# -*- coding: utf-8 -*-

import sys, re
from os.path import abspath, join

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, abspath('.'))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
needs_sphinx = '1.5'

extensions = [
    # Standard Sphinx extensions
    'recommonmark',
    'sphinx.ext.extlinks',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.graphviz',
    'sphinx.ext.mathjax',
    'sphinx.ext.ifconfig',
    'sphinx.ext.viewcode',
    # Other
    'exec',
]

templates_path = ['_templates', '_themes']

# The suffix(es) of source filenames.
source_suffix = {
    '.rst': 'restructuredtext',
    # '.txt': 'markdown',
    '.md': 'markdown',
}

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'GHDL'
copyright = u'2002-2019, Tristan Gingold and contributors'
author = u'Tristan Gingold and contributors'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.

try:
    with open('../configure') as verin:
        for line in verin:
            line = re.findall(r'ghdl_version=\"([0-9].+)\"', line)
            if line:
                version = line[0]
                break
except Exception as e:
    print('cannot extract version: %s' % e)
    version = "latest"
    pass

release = version  # The full version, including alpha/beta/rc tags.

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True
todo_link_only = True

# reST settings
prologPath = "prolog.inc"
try:
    with open(prologPath, "r") as prologFile:
        rst_prolog = prologFile.read()
except Exception as ex:
    print("[ERROR:] While reading '{0!s}'.".format(prologPath))
    print(ex)
    rst_prolog = ""

# -- Options for HTML output ----------------------------------------------

html_theme = "sphinx_rtd_theme"

# Override default css to get a larger width for ReadTheDoc build
html_context = {
    'css_files': [
        'https://media.readthedocs.org/css/sphinx_rtd_theme.css',
        'https://media.readthedocs.org/css/readthedocs-doc-embed.css',
        '_static/theme_overrides.css',
    ],
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Output file base name for HTML help builder.
htmlhelp_basename = 'GHDLdoc'

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    'papersize': 'a4paper',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'GHDL.tex', u'GHDL Documentation', author, 'manual'),
]

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'ghdl', u'GHDL Documentation', [author], 1)
]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author, dir menu entry, description, category)
texinfo_documents = [
  (master_doc, 'GHDL', u'GHDL Documentation', author, 'GHDL', 'VHDL simulator.', 'Miscellaneous'),
]

# -- Sphinx.Ext.InterSphinx -----------------------------------------------

intersphinx_mapping = {
   'python': ('https://docs.python.org/3.6/', None),
   'poc': ('https://poc-library.readthedocs.io/en/release', None)
}

# -- Sphinx.Ext.ExtLinks --------------------------------------------------
extlinks = {
   'wikipedia': ('https://en.wikipedia.org/wiki/%s', None),
   'ghdlsharp': ('https://github.com/ghdl/ghdl/issues/%s', '#'),
   'ghdlissue': ('https://github.com/ghdl/ghdl/issues/%s', 'issue #'),
   'ghdlpull':  ('https://github.com/ghdl/ghdl/pull/%s', 'pull request #'),
   'ghdlsrc':   ('https://github.com/ghdl/ghdl/blob/master/src/%s', None)
}
