.\" @(#)$RCSfile: gfal_opendir.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/11/19 12:56:29 $ CERN Jean-Philippe Baud
.\" Copyright (C) 2003 by CERN
.\" All rights reserved
.\"
.TH GFAL_OPENDIR 3 "$Date: 2003/11/19 12:56:29 $" GFAL "Library Functions"
.SH NAME
gfal_opendir \- open a directory
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "DIR *gfal_opendir (const char *" dirname ");"
.SH DESCRIPTION
.B gfal_opendir
opens a directory to be used in subsequent
.B gfal_readdir
operations.
.SH RETURN VALUE
This routine returns a pointer to a DIR structure to be used in the subsequent
directory function calls if the operation was successful or NULL if the operation
failed. In the latter case,
.B errno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B ENOENT
The named directory does not exist.
.TP
.B EACCES
Search permission is denied on a component of the
.I dirname
prefix or read permission on the directory itself is denied.
.TP
.B EFAULT
.I dirname
is a NULL pointer.
.TP
.B ENOTDIR
A component of
.I dirname
prefix is not a directory.
.TP
.B EINVAL
.I dirname
has an invalid syntax.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.
.SH SEE ALSO
.B gfal(3)
