#!/usr/bin/python

# this distribution file be better than this!

import glob, os
from distutils.core import setup, Extension




#------------------------------------------------------------------------------
def get_cflags():
	import os

	uname = os.uname()[ 0 ]
	if uname == 'Linux':
		return get_cflags_linux()
	else:
		print ("WARNING: Operating System %s not supported by " \
		       " setup.py. No special CFLAGS used.") % uname
		return []
# get_cflags()



def get_cflags_linux():
	import re

	f = open( "/proc/cpuinfo", "r" )
	cpuinfo = f.read()
	f.close()

	cpuinfo = cpuinfo.split( '\n' )

	CFLAGS=[]
	for i in cpuinfo:
		if i.find( ': ' ) == -1:
			continue

		k, v = i.split( ':' )


		if k.startswith( "model name" ):
			if re.match( '^ Intel.+ 4 CPU', v ):
				CFLAGS += [ '-march=pentium4',
					    '-mcpu=pentium4',
					    '-DARCH_X86' ]
			elif re.match( '^ Intel.+ 3 CPU', v ):
				CFLAGS += [ '-march=pentium3',
					    '-mcpu=pentium3',
					    '-DARCH_X86' ]
		if k.startswith( "flags" ):
			if v.find( " mmx " ) > -1:
				CFLAGS += [ '-mmmx', '-DUSE_MMX' ]
			if v.find( " sse " ) > -1:
				CFLAGS += [ '-msse' ]
			if v.find( " sse2 " ) > -1:
				CFLAGS += [ '-msse2' ]
	# for cpuinfo

	return CFLAGS
# get_cflags_linux()

#------------------------------------------------------------------------------











CFLAGS = [ '-O9', '-Wall' ] + get_cflags()

sources   = [ './src/pygoom.c', './goom/goom_core.c', './goom/filters.c', './goom/lines.c', './goom/ifs_display.c', './goom/ifs.c', './goom/graphic.c', './goom/zoom_filter_mmx.c', './goom/surface.c' ]
includes  = [ './include', './goom/' ]
libdir    = [ './goom/' ]
libraries = [ ]

pygoom = Extension(
                    'pygoom', 
                    include_dirs = includes,
                    sources      = sources,
                    library_dirs = libdir,
                    extra_compile_args = CFLAGS,
                    libraries    = libraries )

setup( name             = 'pygoom',
       version          = '0.1',
       author           = 'Gustavo Sverzut Barbieri',
       author_email     = 'gsbarbieri@yahoo.com.br',
       url              = 'http://gsbarbieri.sytes.net/pygoom/',
       maintainer       = 'Gustavo Sverzut Barbieri',
       maintainer_email = 'gsbarbieri@yahoo.com.br',
       download_url     = 'http://gsbarbieri.sytes.net/pygoom/',
       description      = 'GOOM Audio Visualization Module',
       license          = 'GNU GPL',
       long_description = """
GOOM is an audio visualization library, provided with PCM audio data,
it render beautiful graphics, which can be then blitted on some surface.
It's heavily assembly optimized (MMX/SSE/..), so GOOM should benefit from 
your CPU capabilities.

This is a wrapper so you can call GOOM functions from inside Python.

GOOM can be found at: http://www.ios-software.com/

""",
       ext_modules      = [ pygoom ]
      )


