Elvish 0.20.0 has been released on 2024-02-11, 11 months after 0.19.1, bringing
new features and bugfixes.

As usual, [prebuilt binaries](https://elv.sh/get) are offered for most common
platforms.

# Notable new features

-   A new `os:` module providing access to operating system functionality.

-   A new `read-bytes` command for reading a fixed number of bytes.

-   New commands in the `file:` module: `file:open-output`, `file:seek` and
    `file:tell`.

-   Maps now have their keys sorted when printed.

-   The `peach` command now has a `&num-workers` option
    ([#648](https://github.com/elves/elvish/issues/648)).

-   The `from-json` command now supports integers of arbitrary precision, and
    outputs them as exact integers rather than inexact floats.

-   A new `str:fields` command ([#1689](https://b.elv.sh/1689)).

-   The `order` and `compare` commands now support a `&total` option, which
    allows sorting and comparing values of mixed types.

-   The language server now supports showing the documentation of builtin
    functions and variables on hover ([#1684](https://b.elv.sh/1684)).

-   Elvish now respects the [`NO_COLOR`](https://no-color.org) environment
    variable. Builtin UI elements as well as styled texts will not have colors
    if it is set and non-empty.

# Notable bugfixes

-   `has-value $li $v` now works correctly when `$li` is a list and `$v` is a
    composite value, like a map or a list.

-   A bug with how the hash code of a map was computed could lead to unexpected
    results when using maps as map keys; it has now been fixed.

# Breaking changes

-   The `except` keyword in the `try` command was deprecated since 0.18.0 and is
    now removed. Use `catch` instead.

-   The `float64` command was deprecated since 0.16.0 and emitted deprecation
    warnings since 0.19.1, and is now removed. Use `num` or `inexact-num`
    instead.

# Deprecated features

Deprecated features will be removed in 0.21.0.

The following deprecated features trigger a warning whenever the code is parsed
and compiled, even if it is not executed:

-   The `eawk` command is now deprecated. Use `re:awk` instead.
