// This code conforms with the UFC specification version 2.3.0
// and was automatically generated by FFC version 1.3.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   restrict_keyword:               ''
//   split:                          True

#include "Poisson3D_5.h"

/// Constructor
poisson3d_5_finite_element_0::poisson3d_5_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
poisson3d_5_finite_element_0::~poisson3d_5_finite_element_0()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* poisson3d_5_finite_element_0::signature() const
{
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 5, None)";
}

/// Return the cell shape
ufc::shape poisson3d_5_finite_element_0::cell_shape() const
{
    return ufc::tetrahedron;
}

/// Return the topological dimension of the cell shape
std::size_t poisson3d_5_finite_element_0::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the cell shape
std::size_t poisson3d_5_finite_element_0::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the finite element function space
std::size_t poisson3d_5_finite_element_0::space_dimension() const
{
    return 56;
}

/// Return the rank of the value space
std::size_t poisson3d_5_finite_element_0::value_rank() const
{
    return 0;
}

/// Return the dimension of the value space for axis i
std::size_t poisson3d_5_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

/// Evaluate basis function i at given point x in cell
void poisson3d_5_finite_element_0::evaluate_basis(std::size_t i,
                                   double* values,
                                   const double* x,
                                   const double* vertex_coordinates,
                                   int cell_orientation) const
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923496, 0.0060978812067925, 0.00352061335622802, 0.00248944957812477, 0.00705946233325036, 0.00546823600997146, 0.00446479600584758, 0.00315708753234941, 0.00257775117585288, 0.00182274533665716, -0.00298267418725715, -0.00252081977982931, -0.00218309396769448, -0.00195261860521384, -0.00169101731601733, -0.00138070985681771, -0.0011273448773449, -0.00097630930260694, -0.000797153207506486, -0.000563672438672443, 0.00278687112460006, 0.00245778931055955, 0.00219831358911339, 0.00207721109304567, 0.00185791408306669, 0.00160900079398463, 0.00160900079398464, 0.00143913406048031, 0.00124632665582739, 0.00101762145320215, 0.00092895704153337, 0.000830884437218253, 0.000719567030240159, 0.000587524019939406, 0.000415442218609134, -0.00705593524717797, -0.00638233357089079, -0.00582624677716565, -0.00562868913761196, -0.00513826668309062, -0.00459580543596521, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, -0.00368484200521178, -0.00336378514516176, -0.00300866089851429, -0.00260557676948629, -0.00212744452363027, -0.00212744452363026, -0.00194208225905519, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828762};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923489, -0.00609788120679248, 0.00352061335622803, 0.00248944957812477, 0.0070594623332504, -0.00546823600997143, -0.00446479600584756, 0.00315708753234942, 0.00257775117585286, 0.00182274533665715, 0.00298267418725715, -0.0025208197798293, -0.00218309396769447, 0.00195261860521383, 0.00169101731601732, 0.00138070985681771, -0.00112734487734489, -0.000976309302606922, -0.000797153207506473, -0.000563672438672435, 0.00278687112460003, -0.00245778931055953, -0.0021983135891134, 0.00207721109304565, 0.00185791408306669, 0.00160900079398462, -0.00160900079398462, -0.0014391340604803, -0.00124632665582741, -0.00101762145320216, 0.000928957041533351, 0.000830884437218258, 0.000719567030240153, 0.000587524019939406, 0.000415442218609128, 0.00705593524717798, -0.00638233357089081, -0.00582624677716566, 0.00562868913761197, 0.00513826668309062, 0.0045958054359652, -0.00475711057319694, -0.00434262794914383, -0.00388416451811044, -0.00336378514516178, 0.00368484200521179, 0.00336378514516178, 0.0030086608985143, 0.00260557676948629, 0.00212744452363027, -0.00212744452363027, -0.00194208225905521, -0.00173705117965753, -0.00150433044925715, -0.00122828066840393, -0.000868525589828762};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923493, 0.0, -0.00704122671245613, 0.00248944957812475, 0.0, 0.0, 0.0, 0.0094712625970483, -0.00515550235170573, 0.00182274533665714, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00450937950937951, -0.00292892790782074, 0.00159430641501297, -0.000563672438672429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00464478520766671, -0.00332353774887303, 0.00215870109072045, -0.00117504803987881, 0.000415442218609134, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, -0.0097104112952761, 0.00694820471863011, -0.00451299134777143, 0.00245656133680785, -0.000868525589828767};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923494, 0.0, 0.0, -0.00746834873437434, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0109364720199429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00563672438672437, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00623163327913695, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734309, 0.0, 0.03747187483114, -0.0289614183593723, 0.0, 0.0, 0.0, 0.0284137877911448, 0.0051555023517057, -0.00619733414463431, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0315656565656566, -0.0113902751970807, 0.00265717735835489, -0.0001878908128908, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0232239260383337, -0.00166176887443655, -0.00647610327216137, 0.00646276421933345, -0.00290809553026392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0213629048496074, -0.0277928188745204, 0.0243701532779658, -0.0157219925555703, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734309, 0.0, -0.028757485335526, 0.05360943398437, 0.0, 0.0, 0.0, -0.0189425251940965, 0.0154665070551171, 0.0153110608279201, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00450937950937952, 0.0370997534990628, -0.0281660799985623, 0.0108976671476671, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0299118397398575, -0.00431740218144093, -0.0123380044187275, 0.00872428659079177, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0312669212338356, -0.0487403065559316, 0.041270230458372, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734308, 0.0, 0.0409576306293854, -0.0449826285156208, 0.0, 0.0, 0.0, 0.0189425251940965, -0.00515550235170572, -0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00455611007883225, 0.0356061766019561, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0302218152700864, 0.00411266813957585, -0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0379091273212801, -0.0550269739444961, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734311, 0.0, -0.0148144621425437, 0.0449826285156208, 0.0, 0.0, 0.0, 0.0, 0.0206220094068229, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0106287094334197, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.020563340697879, 0.0145404776513197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0343918587153101, -0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734311, 0.0324515955311977, -0.0187359374155699, -0.0289614183593722, 0.0211783869997511, -0.0164047080299144, 0.00446479600584756, 0.00947126259704828, -0.00257775117585288, -0.00619733414463432, 0.0208787193108001, -0.0176457384588052, -0.00848980987436739, 0.0136683302364968, 0.00657617845117846, 0.0023011830946962, -0.00789141414141414, -0.0037967583990269, -0.00132858867917748, -0.000187890812890802, 0.0139343556230002, -0.0122889465527977, -0.00109915679455668, 0.0103860554652283, 0.000928957041533349, -0.00482700238195388, -0.00804500396992314, -0.000719567030240151, 0.00373897996748219, 0.00559691799261186, 0.00464478520766674, 0.000415442218609144, -0.00215870109072048, -0.0032313821096667, -0.00290809553026392, 0.0, 0.0, 0.0128177429097644, 0.0, -0.0113041867027994, -0.0183832217438608, 0.0, 0.0095537814881164, 0.0155366580724417, 0.0181644397838736, 0.0, -0.00740032731935591, -0.0120346435940572, -0.014070114555226, -0.0136156449512337, 0.0, 0.00427258096992147, 0.00694820471863013, 0.00812338442598859, 0.00786099627778514, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734309, -0.024904712849524, 0.014378742667763, 0.0536094339843699, -0.0141189246665007, 0.0109364720199429, 0.0133943880175427, -0.00631417506469883, -0.00773325352755858, 0.01531106082792, -0.00298267418725717, 0.00252081977982932, 0.0276525235907967, -0.00195261860521384, -0.0214195526695527, -0.0243925408037796, 0.00112734487734487, 0.0123665844996876, 0.0140830399992811, 0.0108976671476671, 0.0, 0.0, 0.0197848223020205, 0.0, -0.0167212267476003, -0.00321800158796925, 0.0, 0.0129522065443228, 0.00249265331165478, -0.0106850252586227, 0.0, -0.00747795993496439, -0.0014391340604803, 0.00616900220936372, 0.00872428659079176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0206811244618434, 0.0, 0.0, -0.017478740331497, -0.0363288795677472, 0.0, 0.0, 0.0135389740433143, 0.0281402291104519, 0.0357410679969885, 0.0, 0.0, -0.00781673030845889, -0.0162467688519772, -0.020635115229186, -0.018239037386404};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734309, 0.0354703486038674, -0.0204788153146928, -0.0449826285156207, 0.0141189246665008, -0.0109364720199429, -0.00446479600584758, 0.00631417506469885, 0.00257775117585283, -0.0211438459052229, 0.0, 0.0, 0.00339592394974695, 0.0, -0.00263047138047139, 0.0308358534689291, 0.0, 0.00151870335961075, -0.017803088300978, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0225260111157848, 0.0, 0.0, -0.0174485731815835, 0.00356167508620758, 0.0, 0.0, 0.0100739384233621, -0.0020563340697879, -0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0282557952193589, 0.0, 0.0, 0.0, -0.0218868448636848, -0.047654757329318, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440067};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.010023442173431, -0.0128297005588457, 0.00740723107127188, 0.0449826285156207, 0.0, 0.0, 0.0178591840233903, 0.0, -0.0103110047034114, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00920473237878479, 0.0, 0.0, -0.00531435471670986, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0178083754310377, 0.0, 0.0, 0.0, -0.0102816703489396, 0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0297842233308238, 0.0, 0.0, 0.0, 0.0, -0.017195929357655, -0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734311, 0.0324515955311978, -0.0335503995581136, -0.00801060507812424, 0.0211783869997511, 0.00109364720199428, -0.0169662248222208, -0.00568275755822896, 0.00567105258687628, 0.0083846285486229, 0.0208787193108001, -0.0109235523792603, -0.0162519217595033, 0.00499002532443536, 0.00958243145743147, 0.0108922666482286, -0.00187890812890812, -0.00466458889023306, -0.00558007245254536, -0.00469727032227032, 0.0139343556230002, -0.00245778931055954, -0.0120907247401236, -0.00415442218609132, 0.00464478520766674, 0.00965400476390777, 0.00643600317593851, -0.000719567030240138, -0.00498530662330958, -0.006614539445814, -0.00464478520766673, -0.000415442218609131, 0.00215870109072044, 0.00323138210966672, 0.00290809553026393, 0.0, 0.0127646671417816, -0.00116524935543313, -0.0202632808954031, -0.00719357335632687, 0.00183832217438609, 0.0228341307513453, 0.0112908326677739, 0.00310733161448834, -0.00201827108709707, -0.020635115229186, -0.01143686949355, -0.00481385743762287, -0.000521115353897262, 0.00170195561890421, 0.0127646671417816, 0.00737991258440982, 0.00347410235931507, 0.000902598269554291, -0.000491312267361578, -0.000868525589828769};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734311, -0.0249047128495238, 0.0553363732971483, -0.00431340273437459, -0.0141189246665008, 0.0153110608279201, 0.00803663281052562, 0.00883984509057834, -0.0159820572902877, 0.000729098134662825, -0.00298267418725716, 0.0277290175781224, -0.00145539597846297, -0.0301571095694136, -0.0116492303992304, 0.00352848074520083, 0.0191648629148629, 0.00976309302606915, 0.00132858867917747, -0.00263047138047138, 0.0, 0.0196623144844763, -0.00219831358911338, -0.00727023882565979, -0.0148633126645336, 0.00402250198496157, -0.00724050357293082, 0.0129522065443227, 0.00685479660705068, -0.00457929653940971, 0.00928957041533347, -0.00664707549774609, -0.0057565362419212, -0.000293762009969709, 0.00290809553026394, 0.0, 0.0, 0.0, 0.0202632808954031, -0.00411061334647249, 0.000459580543596518, -0.0399597288148543, -0.00303983956440068, 0.00427258096992149, -0.00100913554354853, 0.0464290092656685, 0.00908221989193679, -0.00270779480866285, -0.00234501909253766, 0.00127646671417817, -0.031911667854454, -0.00776832903622087, 0.000868525589828756, 0.00180519653910858, 0.000245656133680792, -0.000868525589828773};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734312, 0.0354703486038674, -0.0492363006502185, -0.00431340273437457, 0.0141189246665008, -0.00656188321196578, -0.00982255121286467, -0.0164168551682169, 0.0149509568199466, 0.000729098134662869, 0.0, 0.0033610930397724, -0.00048513199282101, 0.0282044909641998, -0.0124007936507936, 0.0029148319199485, -0.0353234728234728, 0.00889526253486301, 0.00239145962251945, -0.00263047138047138, 0.0, 0.0, 0.0, 0.0218107164769794, -0.00557374224920009, 0.000804500396992312, -0.00402250198496154, -0.014391340604803, 0.00934744991870547, -0.00254405363300537, -0.0092895704153335, 0.0141250354327105, -0.00287826812096064, -0.00381890612960613, 0.00290809553026391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0266398192099028, -0.00911951869320202, 0.00233049871086626, -0.000336378514516179, -0.0515877880729651, 0.00840946286290446, 0.00300866089851429, -0.00286613444643492, 0.000850977809452106, 0.0425488904726053, -0.00388416451811045, -0.00347410235931507, 0.00120346435940572, 0.000982624534723146, -0.000868525589828758};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734311, -0.0128297005588457, 0.0448791059024117, -0.00801060507812425, 0.0, 0.0174983552319086, -0.003571836804678, 0.0132597676358676, -0.0175287079957994, 0.00838462854862288, 0.0, 0.0, 0.0, 0.00867830491206146, -0.00300625300625303, 0.000613648825252319, 0.0225468975468975, -0.019200749617936, 0.0122230158484327, -0.00469727032227032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0160900079398463, -0.00719567030240155, 0.00249265331165479, -0.000508810726601085, 0.00464478520766675, -0.0108014976838375, 0.0107935054536023, -0.00734405024924252, 0.00290809553026394, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0257938940364826, -0.0134551405806471, 0.00601732179702858, -0.00208446141558904, 0.000425488904726059, -0.031911667854454, 0.0135945758133865, -0.00347410235931504, -0.000902598269554292, 0.0017195929357655, -0.000868525589828772};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734314, -0.0324515955311979, -0.0187359374155699, -0.0289614183593722, 0.0211783869997512, 0.0164047080299144, -0.00446479600584757, 0.00947126259704827, -0.00257775117585285, -0.0061973341446343, -0.0208787193108001, -0.0176457384588052, -0.0084898098743674, -0.0136683302364968, -0.00657617845117844, -0.00230118309469616, -0.00789141414141415, -0.00379675839902689, -0.00132858867917748, -0.0001878908128908, 0.0139343556230002, 0.0122889465527977, 0.00109915679455668, 0.0103860554652283, 0.000928957041533344, -0.00482700238195391, 0.00804500396992313, 0.000719567030240159, -0.0037389799674822, -0.00559691799261188, 0.00464478520766673, 0.000415442218609133, -0.00215870109072046, -0.00323138210966672, -0.00290809553026394, 0.0, 0.0, 0.0128177429097644, 0.0, 0.0113041867027994, 0.0183832217438608, 0.0, 0.0095537814881164, 0.0155366580724417, 0.0181644397838736, 0.0, 0.00740032731935589, 0.0120346435940572, 0.014070114555226, 0.0136156449512337, 0.0, 0.00427258096992147, 0.00694820471863012, 0.00812338442598859, 0.00786099627778515, 0.00607967912880135};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.010023442173431, 0.024904712849524, 0.014378742667763, 0.05360943398437, -0.0141189246665007, -0.0109364720199429, -0.0133943880175426, -0.00631417506469886, -0.0077332535275586, 0.01531106082792, 0.00298267418725715, 0.00252081977982932, 0.0276525235907967, 0.00195261860521382, 0.0214195526695527, 0.0243925408037797, 0.00112734487734487, 0.0123665844996876, 0.0140830399992811, 0.0108976671476671, 0.0, 0.0, -0.0197848223020205, 0.0, -0.0167212267476003, -0.00321800158796924, 0.0, -0.0129522065443228, -0.00249265331165475, 0.0106850252586226, 0.0, -0.00747795993496438, -0.0014391340604803, 0.00616900220936374, 0.00872428659079182, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0206811244618434, 0.0, 0.0, -0.017478740331497, -0.0363288795677472, 0.0, 0.0, -0.0135389740433143, -0.0281402291104519, -0.0357410679969884, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.020635115229186, -0.018239037386404};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.010023442173431, -0.0354703486038674, -0.0204788153146927, -0.0449826285156207, 0.0141189246665007, 0.0109364720199429, 0.00446479600584753, 0.00631417506469884, 0.00257775117585289, -0.0211438459052229, 0.0, 0.0, 0.00339592394974695, 0.0, 0.00263047138047136, -0.030835853468929, 0.0, 0.00151870335961076, -0.0178030883009781, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0225260111157848, 0.0, 0.0, 0.0174485731815835, -0.00356167508620756, 0.0, 0.0, 0.0100739384233621, -0.00205633406978793, -0.0145404776513197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0282557952193589, 0.0, 0.0, 0.0, 0.0218868448636848, 0.047654757329318, 0.0, 0.0, 0.0, 0.01263637577376, 0.0275134869722481, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0128297005588457, 0.00740723107127181, 0.0449826285156208, 0.0, 0.0, -0.0178591840233902, 0.0, -0.0103110047034115, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00920473237878478, 0.0, 0.0, -0.00531435471670986, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0178083754310377, 0.0, 0.0, 0.0, -0.0102816703489395, 0.0145404776513197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0297842233308237, 0.0, 0.0, 0.0, 0.0, -0.017195929357655, -0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734307, -0.0324515955311978, -0.0335503995581135, -0.00801060507812418, 0.0211783869997512, -0.00109364720199431, 0.0169662248222208, -0.00568275755822894, 0.00567105258687628, 0.00838462854862291, -0.0208787193108001, -0.0109235523792603, -0.0162519217595033, -0.00499002532443535, -0.00958243145743145, -0.0108922666482287, -0.00187890812890815, -0.00466458889023305, -0.00558007245254536, -0.00469727032227032, 0.0139343556230002, 0.00245778931055953, 0.0120907247401236, -0.00415442218609133, 0.00464478520766673, 0.00965400476390777, -0.0064360031759385, 0.000719567030240151, 0.00498530662330959, 0.00661453944581401, -0.00464478520766676, -0.000415442218609123, 0.00215870109072045, 0.00323138210966672, 0.00290809553026392, 0.0, 0.0127646671417816, -0.00116524935543312, 0.0202632808954031, 0.00719357335632687, -0.00183832217438608, 0.0228341307513453, 0.0112908326677739, 0.00310733161448834, -0.00201827108709707, 0.020635115229186, 0.0114368694935501, 0.00481385743762287, 0.000521115353897252, -0.00170195561890421, 0.0127646671417816, 0.00737991258440981, 0.00347410235931507, 0.000902598269554277, -0.000491312267361576, -0.000868525589828769};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734307, 0.0249047128495239, 0.0553363732971483, -0.0043134027343746, -0.0141189246665007, -0.0153110608279201, -0.00803663281052558, 0.00883984509057836, -0.0159820572902877, 0.000729098134662811, 0.00298267418725714, 0.0277290175781224, -0.00145539597846299, 0.0301571095694136, 0.0116492303992304, -0.00352848074520083, 0.0191648629148629, 0.00976309302606916, 0.00132858867917747, -0.00263047138047135, 0.0, -0.0196623144844763, 0.00219831358911336, -0.00727023882565976, -0.0148633126645336, 0.00402250198496157, 0.00724050357293085, -0.0129522065443227, -0.00685479660705067, 0.00457929653940969, 0.00928957041533352, -0.00664707549774611, -0.00575653624192119, -0.000293762009969713, 0.00290809553026392, 0.0, 0.0, 0.0, -0.0202632808954031, 0.00411061334647248, -0.00045958054359652, -0.0399597288148542, -0.00303983956440067, 0.00427258096992148, -0.00100913554354853, -0.0464290092656685, -0.00908221989193681, 0.00270779480866286, 0.00234501909253766, -0.00127646671417816, -0.031911667854454, -0.00776832903622085, 0.000868525589828735, 0.00180519653910859, 0.000245656133680784, -0.000868525589828764};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734311, -0.0354703486038674, -0.0492363006502186, -0.0043134027343746, 0.0141189246665008, 0.00656188321196571, 0.00982255121286463, -0.016416855168217, 0.0149509568199466, 0.000729098134662876, 0.0, 0.00336109303977241, -0.000485131992820999, -0.0282044909641998, 0.0124007936507936, -0.00291483191994852, -0.0353234728234728, 0.008895262534863, 0.00239145962251945, -0.0026304713804714, 0.0, 0.0, 0.0, 0.0218107164769794, -0.00557374224920008, 0.000804500396992314, 0.00402250198496156, 0.0143913406048031, -0.00934744991870547, 0.00254405363300538, -0.00928957041533351, 0.0141250354327105, -0.00287826812096063, -0.00381890612960613, 0.00290809553026392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0266398192099028, -0.00911951869320202, 0.00233049871086625, -0.000336378514516176, 0.0515877880729651, -0.00840946286290445, -0.00300866089851428, 0.00286613444643492, -0.000850977809452104, 0.0425488904726053, -0.00388416451811045, -0.00347410235931505, 0.00120346435940571, 0.000982624534723157, -0.000868525589828761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734311, 0.0128297005588456, 0.0448791059024118, -0.00801060507812428, 0.0, -0.0174983552319087, 0.00357183680467806, 0.0132597676358676, -0.0175287079957995, 0.00838462854862291, 0.0, 0.0, 0.0, -0.00867830491206146, 0.00300625300625301, -0.000613648825252321, 0.0225468975468975, -0.019200749617936, 0.0122230158484327, -0.00469727032227032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0160900079398463, 0.00719567030240155, -0.00249265331165478, 0.000508810726601092, 0.00464478520766676, -0.0108014976838374, 0.0107935054536023, -0.00734405024924251, 0.00290809553026393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0257938940364825, 0.0134551405806471, -0.00601732179702859, 0.00208446141558904, -0.000425488904726056, -0.031911667854454, 0.0135945758133865, -0.00347410235931504, -0.000902598269554288, 0.00171959293576549, -0.000868525589828771};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734307, -0.0452812960900434, -0.0113287063442981, -0.00801060507812426, -0.00141189246665007, 0.0164047080299143, 0.0133943880175427, 0.0145226026488074, 0.0118576554089231, 0.00838462854862294, -0.00894802256177149, -0.0142846454190327, -0.0123708658169353, -0.014536160727703, -0.0125886844636845, -0.0102786178229764, -0.00939454064454066, -0.00813591085505764, -0.00664294339588733, -0.00469727032227033, -0.00836061337380014, 0.00245778931055954, 0.00219831358911338, 0.00830884437218263, 0.00743165633226679, 0.0064360031759385, 0.00965400476390779, 0.00863480436288184, 0.00747795993496438, 0.00610572871921294, 0.00650269929073342, 0.00581619106052785, 0.00503696921168106, 0.00411266813957582, 0.00290809553026392, 0.0352796762358899, 0.0191470007126724, 0.0174787403314969, 0.00788016479265676, 0.00719357335632689, 0.00643412761035129, 0.000951422114639382, 0.000868525589828755, 0.000776832903622077, 0.000672757029032345, -0.00221090520312707, -0.00201827108709705, -0.00180519653910857, -0.00156334606169178, -0.00127646671417816, -0.00212744452363026, -0.00194208225905521, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734311, 0.0603750614533913, -0.00610007264692972, -0.00431340273437463, -0.00564756986660036, -0.0218729440398857, -0.0178591840233902, 0.00126283501293975, 0.00103110047034115, 0.000729098134662875, 0.0417574386216003, 0.016805465198862, 0.0145539597846298, -0.000867830491206133, -0.000751563251563239, -0.000613648825252298, -0.00526094276094275, -0.0045561100788323, -0.00372004830169692, -0.00263047138047139, 0.00557374224920013, -0.0196623144844763, -0.0175865087129071, -0.0103860554652283, -0.00928957041533348, -0.00804500396992313, 0.00321800158796925, 0.00287826812096061, 0.00249265331165479, 0.00203524290640429, 0.00650269929073342, 0.00581619106052785, 0.00503696921168108, 0.00411266813957583, 0.00290809553026395, -0.0705593524717798, -0.0127646671417816, -0.0116524935543313, 0.00450295131008955, 0.00411061334647247, 0.00367664434877214, 0.00380568845855755, 0.00347410235931508, 0.00310733161448836, 0.00269102811612943, -0.000736968401042361, -0.000672757029032368, -0.000601732179702867, -0.000521115353897261, -0.000425488904726046, -0.00212744452363026, -0.00194208225905521, -0.00173705117965753, -0.00150433044925714, -0.00122828066840394, -0.000868525589828775};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734311, -0.0603750614533913, -0.00610007264692977, -0.00431340273437462, -0.00564756986660027, 0.0218729440398858, 0.0178591840233902, 0.00126283501293977, 0.00103110047034114, 0.000729098134662858, -0.0417574386216002, 0.016805465198862, 0.0145539597846299, 0.000867830491206133, 0.000751563251563231, 0.000613648825252297, -0.00526094276094275, -0.00455611007883227, -0.0037200483016969, -0.00263047138047138, 0.00557374224920005, 0.0196623144844763, 0.0175865087129071, -0.0103860554652283, -0.00928957041533347, -0.00804500396992315, -0.00321800158796928, -0.00287826812096063, -0.0024926533116548, -0.00203524290640429, 0.00650269929073343, 0.00581619106052785, 0.00503696921168108, 0.00411266813957581, 0.00290809553026392, 0.0705593524717798, -0.0127646671417816, -0.0116524935543313, -0.00450295131008957, -0.00411061334647248, -0.00367664434877215, 0.00380568845855754, 0.00347410235931504, 0.00310733161448834, 0.00269102811612942, 0.000736968401042369, 0.000672757029032361, 0.000601732179702872, 0.000521115353897267, 0.000425488904726048, -0.00212744452363027, -0.00194208225905522, -0.00173705117965754, -0.00150433044925714, -0.00122828066840393, -0.000868525589828761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0452812960900435, -0.0113287063442981, -0.00801060507812427, -0.00141189246665011, -0.0164047080299144, -0.0133943880175427, 0.0145226026488074, 0.0118576554089232, 0.0083846285486229, 0.00894802256177148, -0.0142846454190328, -0.0123708658169354, 0.014536160727703, 0.0125886844636845, 0.0102786178229764, -0.00939454064454066, -0.00813591085505764, -0.00664294339588733, -0.00469727032227032, -0.0083606133738001, -0.00245778931055954, -0.0021983135891134, 0.00830884437218264, 0.00743165633226679, 0.00643600317593852, -0.00965400476390776, -0.00863480436288183, -0.00747795993496437, -0.00610572871921294, 0.00650269929073343, 0.00581619106052784, 0.00503696921168107, 0.00411266813957582, 0.00290809553026394, -0.0352796762358899, 0.0191470007126724, 0.017478740331497, -0.00788016479265674, -0.00719357335632688, -0.00643412761035128, 0.000951422114639399, 0.00086852558982876, 0.00077683290362209, 0.000672757029032358, 0.00221090520312706, 0.00201827108709707, 0.00180519653910857, 0.00156334606169177, 0.00127646671417816, -0.00212744452363025, -0.00194208225905521, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828767};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769578, 0.0679219441350651, -0.00435719474780698, -0.00308100195312476, 0.0705946233325039, -0.0328094160598288, -0.0267887760350854, 0.0126283501293977, 0.0360885164619401, -0.00729098134662863, 0.0298267418725716, 0.0151249186789759, 0.0130985638061668, -0.0325436434202305, -0.0229226791726792, -0.0248527774227189, 0.0248015873015873, 0.0169226945785198, 0.0164744996218006, 0.0142797017797018, 0.0, 0.0245778931055954, 0.0219831358911339, -0.0363511941282991, -0.0074316563322668, -0.0345935170706696, 0.0362025178646541, 0.0, 0.0130864298861876, 0.0335815079556711, -0.0232239260383337, 0.00166176887443654, -0.00359783515120076, -0.0146881004984851, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0226083734055987, -0.00459580543596521, 0.0, -0.0334382352084074, -0.0194208225905522, 0.00908221989193681, 0.0, 0.0333014729371016, 0.0270779480866286, 0.00703505727761298, -0.0102117337134253, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598858, 0.0019652490694463, 0.00607967912880137};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.021478804657352, 0.00377344134083692, 0.00217859737390368, -0.021567013671873, 0.0, 0.0984282481794863, -0.031253572040933, -0.0852413633734345, -0.01804425823097, 0.0309866707231717, 0.0, 0.0453747560369276, -0.0116431678277039, 0.0, 0.0236742424242424, -0.00138070985681773, -0.0202922077922078, -0.0335199527228374, -0.000797153207506548, 0.00394570707070709, 0.0, 0.0, 0.0, 0.036351194128299, 0.024152883079867, -0.00724050357293084, -0.0603375297744236, 0.0, -0.039259289658563, 0.0188259968842399, 0.0464478520766673, -0.0108014976838374, 0.0259044130886455, 0.010869194368879, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0334382352084074, -0.0155366580724417, 0.00302740663064559, 0.0, -0.0555024548951693, 0.0, 0.0164151336477636, -0.00680782247561685, 0.0, 0.0427258096992147, 0.00694820471863017, -0.0108311792346515, -0.00393049813889261, 0.00607967912880133};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 30:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0301875307266958, 0.0610007264692972, -0.00308100195312477, 0.0, 0.0218729440398859, 0.0178591840233903, 0.0757701007763862, -0.0412440188136457, -0.00729098134662863, 0.0, 0.0, 0.0, 0.0520698294723688, -0.0127765752765753, 0.00184094647575699, -0.00901875901875901, 0.0286384062098029, -0.0297603864135752, 0.0142797017797018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0402250198496157, 0.014391340604803, -0.0137095932141014, 0.00407048581280862, -0.0464478520766673, 0.0182794576188018, -0.0345392174515273, 0.0364264892362429, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0370016365967795, -0.030086608985143, 0.014070114555226, -0.00340391123780845, 0.0, -0.0427258096992148, 0.0243187165152054, 0.0, -0.00982624534723142, 0.00607967912880138};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 31:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.021478804657352, 0.00377344134083704, -0.0196073763651314, 0.00924300585937434, 0.0, -0.0109364720199429, 0.102690308134494, 0.00947126259704824, -0.0695992817480272, -0.0601505961096861, 0.0, -0.00504163955965858, 0.0465726713108155, 0.00650872868404611, 0.0214195526695527, -0.00782402252196706, -0.00450937950937954, -0.0289638426440052, -0.0263060558477139, 0.000563672438672419, 0.0, 0.0, 0.0, 0.0, 0.0334424534952005, 0.0289620142917233, 0.0, -0.0431740218144092, -0.00249265331165474, -0.0605484764655283, 0.0, 0.0299118397398575, -0.00431740218144092, 0.0185070066280912, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0349574806629939, -0.0121096265225824, 0.0, 0.0, -0.0451299134777144, -0.0281402291104519, 0.023827378664659, 0.0, 0.0, 0.0312669212338355, 0.0270779480866286, 0.0, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 32:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573519, -0.0150937653633477, 0.0130715842434208, 0.00924300585937425, 0.0, -0.0109364720199429, -0.0089295920116951, 0.00947126259704835, 0.123732056440937, -0.0601505961096861, 0.0, 0.0, 0.0, -0.00650872868404604, 0.0574945887445887, -0.0266937238984759, 0.00676406926406926, 0.0126920209338899, 0.00637722566005186, 0.000563672438672455, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0431740218144092, 0.0199412264932384, -0.0142467003448302, 0.0, -0.0448677596097863, 0.0215870109072046, -0.0616900220936373, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0451299134777144, -0.0375203054806026, 0.0119136893323295, 0.0, 0.0, -0.0469003818507533, 0.0162467688519772, 0.020635115229186, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 33:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0301875307266957, 0.0174287789912278, 0.0585390371093694, 0.0, 0.0218729440398859, 0.0178591840233903, -0.0189425251940966, 0.0103110047034114, 0.0838462854862291, 0.0, 0.0, 0.0, 0.0, 0.00526094276094278, 0.0533874477969518, 0.0, -0.00455611007883231, 0.0308232573569172, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.034897146363167, 0.0284934006896603, 0.0, 0.0, -0.0302218152700864, 0.0164506725583033, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0437736897273697, -0.023827378664659, 0.0, 0.0, 0.0, -0.0379091273212801, -0.013756743486124, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 34:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769576, -0.0679219441350653, -0.00435719474780704, -0.00308100195312475, 0.0705946233325039, 0.0328094160598287, 0.0267887760350853, 0.0126283501293977, 0.03608851646194, -0.00729098134662861, -0.0298267418725716, 0.0151249186789759, 0.0130985638061669, 0.0325436434202305, 0.0229226791726792, 0.0248527774227189, 0.0248015873015873, 0.0169226945785198, 0.0164744996218006, 0.0142797017797018, 0.0, -0.0245778931055953, -0.0219831358911338, -0.036351194128299, -0.00743165633226677, -0.0345935170706695, -0.0362025178646541, 0.0, -0.0130864298861876, -0.0335815079556711, -0.0232239260383336, 0.00166176887443655, -0.00359783515120076, -0.0146881004984851, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, -0.0226083734055987, 0.00459580543596522, 0.0, -0.0334382352084074, -0.0194208225905522, 0.00908221989193681, 0.0, -0.0333014729371016, -0.0270779480866286, -0.00703505727761297, 0.0102117337134253, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598856, 0.0019652490694463, 0.00607967912880137};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 35:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573516, -0.00377344134083683, 0.00217859737390362, -0.0215670136718728, 0.0, -0.0984282481794862, 0.031253572040933, -0.0852413633734344, -0.0180442582309701, 0.0309866707231716, 0.0, 0.0453747560369275, -0.0116431678277039, 0.0, -0.0236742424242424, 0.00138070985681772, -0.0202922077922078, -0.0335199527228374, -0.000797153207506536, 0.0039457070707071, 0.0, 0.0, 0.0, 0.036351194128299, 0.024152883079867, -0.0072405035729308, 0.0603375297744236, 0.0, 0.039259289658563, -0.0188259968842399, 0.0464478520766673, -0.0108014976838374, 0.0259044130886455, 0.010869194368879, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0334382352084074, -0.0155366580724417, 0.00302740663064559, 0.0, 0.0555024548951693, 0.0, -0.0164151336477637, 0.00680782247561685, 0.0, 0.0427258096992147, 0.00694820471863021, -0.0108311792346515, -0.0039304981388926, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 36:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769579, -0.0301875307266958, 0.0610007264692973, -0.00308100195312476, 0.0, -0.0218729440398857, -0.0178591840233903, 0.0757701007763862, -0.0412440188136456, -0.0072909813466286, 0.0, 0.0, 0.0, -0.0520698294723688, 0.0127765752765753, -0.00184094647575695, -0.00901875901875896, 0.0286384062098028, -0.0297603864135752, 0.0142797017797018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0402250198496158, -0.0143913406048031, 0.0137095932141013, -0.00407048581280863, -0.0464478520766673, 0.0182794576188018, -0.0345392174515273, 0.0364264892362429, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0370016365967796, 0.0300866089851429, -0.014070114555226, 0.00340391123780843, 0.0, -0.0427258096992147, 0.0243187165152053, 0.0, -0.00982624534723144, 0.00607967912880138};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 37:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573524, -0.00377344134083718, -0.0196073763651313, 0.00924300585937407, 0.0, 0.0109364720199428, -0.102690308134494, 0.00947126259704835, -0.0695992817480271, -0.060150596109686, 0.0, -0.00504163955965864, 0.0465726713108155, -0.00650872868404611, -0.0214195526695527, 0.00782402252196711, -0.00450937950937954, -0.0289638426440051, -0.0263060558477138, 0.000563672438672435, 0.0, 0.0, 0.0, 0.0, 0.0334424534952005, 0.0289620142917233, 0.0, 0.0431740218144092, 0.00249265331165475, 0.0605484764655282, 0.0, 0.0299118397398574, -0.00431740218144094, 0.0185070066280911, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0349574806629939, -0.0121096265225824, 0.0, 0.0, 0.0451299134777144, 0.0281402291104519, -0.0238273786646589, 0.0, 0.0, 0.0312669212338355, 0.0270779480866286, 0.0, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 38:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573521, 0.0150937653633479, 0.0130715842434209, 0.00924300585937413, 0.0, 0.0109364720199429, 0.00892959201169516, 0.0094712625970483, 0.123732056440937, -0.0601505961096861, 0.0, 0.0, 0.0, 0.00650872868404609, -0.0574945887445887, 0.0266937238984759, 0.00676406926406923, 0.0126920209338899, 0.00637722566005181, 0.000563672438672487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0431740218144092, -0.0199412264932383, 0.0142467003448302, 0.0, -0.0448677596097863, 0.0215870109072046, -0.0616900220936373, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0451299134777144, 0.0375203054806026, -0.0119136893323295, 0.0, 0.0, -0.0469003818507533, 0.0162467688519772, 0.020635115229186, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 39:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769579, -0.0301875307266957, 0.0174287789912278, 0.0585390371093694, 0.0, -0.0218729440398858, -0.0178591840233902, -0.0189425251940966, 0.0103110047034113, 0.083846285486229, 0.0, 0.0, 0.0, 0.0, -0.00526094276094274, -0.0533874477969517, 0.0, -0.00455611007883227, 0.0308232573569172, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0348971463631671, -0.0284934006896603, 0.0, 0.0, -0.0302218152700864, 0.0164506725583033, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0437736897273697, 0.023827378664659, 0.0, 0.0, 0.0, -0.0379091273212801, -0.013756743486124, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 40:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.078755617076958, -0.0377344134083695, -0.0566435317214905, -0.00308100195312478, 0.0423567739995023, 0.0546823600997146, 0.0446479600584757, 0.0378850503881931, 0.00515550235170577, -0.00729098134662859, 0.0417574386216002, -0.00504163955965862, 0.0295930515620807, -0.0247331689993752, 0.0101461038961039, 0.0266937238984759, -0.0202922077922078, 0.0021695762280154, 0.0132858867917747, 0.0142797017797018, -0.0557374224920008, -0.0245778931055954, -0.00219831358911337, -0.00519302773261414, -0.0130053985814668, -0.0168945083368385, 0.00402250198496158, -0.0158304746652834, -0.026796023100289, -0.0295110221428625, 0.00464478520766674, -0.0108014976838375, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, -0.0512709716390577, 0.0, -0.0226083734055987, -0.0367664434877216, 0.0, -0.0047768907440582, -0.00776832903622085, -0.00908221989193678, 0.0, 0.00370016365967796, 0.00601732179702859, 0.00703505727761299, 0.00680782247561684, 0.0, 0.00427258096992148, 0.0069482047186301, 0.00812338442598856, 0.00786099627778516, 0.00607967912880135};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 41:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573513, 0.0, -0.00435719474780703, -0.0215670136718729, -0.127070321998507, 0.0, 0.0, 0.0284137877911448, 0.0360885164619399, 0.0309866707231715, 0.0, 0.0453747560369275, -0.0422064833754265, 0.0, 0.0, 0.0, -0.0202922077922078, -0.00618329224984381, 0.00159430641501296, 0.0039457070707071, 0.0836061337380012, 0.0, 0.0, -0.0103860554652283, 0.024152883079867, 0.0434430214375849, 0.0, 0.0, 0.0, 0.0, 0.00464478520766673, -0.0108014976838374, -0.0194283098164841, -0.0217383887377578, -0.0178640154001927, 0.0, 0.0, 0.0769064574585865, 0.0, 0.0, 0.0, 0.0, -0.00955378148811642, -0.0155366580724417, -0.0181644397838736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00427258096992146, 0.00694820471863015, 0.00812338442598858, 0.00786099627778516, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 42:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0377344134083696, -0.0566435317214904, -0.00308100195312477, 0.0423567739995022, -0.0546823600997145, -0.0446479600584756, 0.037885050388193, 0.00515550235170577, -0.0072909813466285, -0.0417574386216002, -0.00504163955965861, 0.0295930515620806, 0.0247331689993752, -0.0101461038961039, -0.0266937238984759, -0.0202922077922078, 0.00216957622801539, 0.0132858867917747, 0.0142797017797018, -0.0557374224920008, 0.0245778931055953, 0.00219831358911336, -0.00519302773261413, -0.0130053985814669, -0.0168945083368386, -0.00402250198496157, 0.0158304746652834, 0.026796023100289, 0.0295110221428625, 0.00464478520766677, -0.0108014976838375, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, -0.0512709716390577, 0.0, 0.0226083734055987, 0.0367664434877216, 0.0, -0.00477689074405818, -0.00776832903622087, -0.00908221989193679, 0.0, -0.00370016365967795, -0.00601732179702858, -0.00703505727761299, -0.00680782247561685, 0.0, 0.0042725809699215, 0.00694820471863008, 0.00812338442598856, 0.00786099627778518, 0.00607967912880136};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 43:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573518, -0.0188672067041849, 0.00653579212171039, 0.00924300585937419, 0.0141189246665007, 0.0, -0.111619900146189, -0.00315708753234941, -0.0541327746929101, -0.0601505961096861, -0.00894802256177145, -0.0025208197798293, -0.0276525235907968, 0.000650872868404654, 0.0360750360750361, -0.0188697013765088, 0.00112734487734487, 0.0374251899332651, 0.0199288301876619, 0.000563672438672461, 0.0, 0.0, 0.0593544669060614, 0.0, 0.0167212267476002, 0.00321800158796923, 0.0, -0.00431740218144091, 0.0224338798048931, 0.0463017761206981, 0.0, -0.00747795993496437, 0.018708742786244, 0.0431830154655461, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0620433733855302, 0.0, 0.0, 0.017478740331497, 0.0363288795677472, 0.0, 0.0, -0.00451299134777147, -0.00938007637015062, -0.0119136893323295, 0.0, 0.0, -0.00781673030845886, -0.0162467688519772, -0.020635115229186, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 44:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573522, 0.0188672067041846, 0.00653579212171044, 0.00924300585937427, 0.0141189246665008, 0.0, 0.111619900146189, -0.00315708753234941, -0.0541327746929101, -0.0601505961096861, 0.00894802256177155, -0.0025208197798293, -0.0276525235907967, -0.000650872868404607, -0.0360750360750361, 0.0188697013765088, 0.00112734487734491, 0.0374251899332651, 0.019928830187662, 0.000563672438672448, 0.0, 0.0, -0.0593544669060614, 0.0, 0.0167212267476002, 0.00321800158796924, 0.0, 0.00431740218144093, -0.0224338798048931, -0.0463017761206981, 0.0, -0.00747795993496436, 0.018708742786244, 0.0431830154655461, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0620433733855302, 0.0, 0.0, 0.0174787403314969, 0.0363288795677472, 0.0, 0.0, 0.00451299134777145, 0.00938007637015066, 0.0119136893323295, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.0206351152291861, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 45:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.078755617076958, 0.0, -0.0348575579824556, 0.0585390371093695, -0.0282378493330015, 0.0, 0.0, 0.00631417506469882, -0.0206220094068228, 0.0838462854862289, 0.0, 0.0, -0.0067918478994939, 0.0, 0.0, 0.0, 0.0, 0.00151870335961078, -0.0616465147138344, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0450520222315696, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0100739384233622, -0.0329013451166065, -0.0643935438844154, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0565115904387178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 46:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769581, -0.0377344134083695, -0.0217859737390349, -0.0523770332031201, 0.0423567739995024, 0.0546823600997146, 0.0446479600584758, 0.0, 0.0257775117585286, 0.0291639253865144, 0.0417574386216002, 0.0285692908380655, -0.00921750786359888, 0.0273366604729936, -0.00789141414141413, -0.0248527774227189, 0.0187890812890813, -0.00347132196482459, -0.0143487577351166, -0.015031265031265, -0.0557374224920008, -0.00491557862111905, -0.0241814494802473, -0.0197335053839337, -0.00928957041533348, -0.00241350119097693, -0.0394205194526234, -0.0158304746652834, -0.000623163327913709, 0.00712335017241507, -0.0325134964536671, -0.0141250354327105, -0.00215870109072047, 0.00411266813957583, 0.00540074884191869, 0.0, -0.0510586685671264, 0.00466099742173249, -0.0405265617908061, -0.0143871467126537, 0.00367664434877214, -0.0114170653756726, -0.00564541633388696, -0.00155366580724415, 0.00100913554354854, 0.0103175576145931, 0.00571843474677501, 0.00240692871881143, 0.000260557676948618, -0.000850977809452114, 0.0127646671417816, 0.00737991258440983, 0.00347410235931509, 0.000902598269554292, -0.00049131226736157, -0.000868525589828748};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 47:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573518, 0.0, -0.0217859737390347, 0.00308100195312486, -0.127070321998507, 0.0, 0.0, 0.0473563129852414, 0.0257775117585285, 0.0127592173566, 0.0, -0.0352914769176103, 0.0509388592462045, 0.0, 0.0, 0.0, 0.00225468975468972, -0.00943765659186685, -0.0143487577351166, -0.0129644660894661, 0.0836061337380012, 0.0, 0.0, 0.0477758551400501, 0.00928957041533347, -0.0144810071458617, 0.0, 0.0, 0.0, 0.0, -0.0325134964536671, -0.0141250354327105, -0.00215870109072047, 0.00411266813957584, 0.00540074884191877, 0.0, 0.0765880028506896, -0.00699149613259875, 0.0, 0.0, 0.0, -0.0228341307513453, -0.011290832667774, -0.00310733161448838, 0.00201827108709704, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, 0.00737991258440981, 0.00347410235931506, 0.000902598269554269, -0.000491312267361589, -0.000868525589828803};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 48:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769582, 0.0377344134083696, -0.0217859737390348, -0.05237703320312, 0.0423567739995023, -0.0546823600997146, -0.0446479600584757, 0.0, 0.0257775117585286, 0.0291639253865145, -0.0417574386216002, 0.0285692908380655, -0.00921750786359894, -0.0273366604729936, 0.00789141414141414, 0.0248527774227189, 0.0187890812890813, -0.00347132196482458, -0.0143487577351166, -0.015031265031265, -0.0557374224920008, 0.00491557862111906, 0.0241814494802472, -0.0197335053839338, -0.00928957041533349, -0.00241350119097695, 0.0394205194526234, 0.0158304746652834, 0.000623163327913708, -0.00712335017241507, -0.0325134964536671, -0.0141250354327105, -0.00215870109072045, 0.0041126681395758, 0.00540074884191868, 0.0, -0.0510586685671264, 0.0046609974217325, 0.0405265617908061, 0.0143871467126537, -0.00367664434877216, -0.0114170653756727, -0.00564541633388696, -0.00155366580724416, 0.00100913554354855, -0.010317557614593, -0.00571843474677502, -0.00240692871881143, -0.000260557676948628, 0.000850977809452107, 0.0127646671417816, 0.00737991258440984, 0.00347410235931506, 0.000902598269554289, -0.000491312267361559, -0.000868525589828739};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 49:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573521, -0.0188672067041848, 0.0108929868695174, 0.00308100195312464, 0.0141189246665008, -0.109364720199429, 0.0223239800292378, -0.0789271883087356, -0.0128887558792643, 0.0127592173566001, -0.00894802256177147, -0.0277290175781224, 0.00145539597846298, -0.00585785581564146, 0.0383297258297258, -0.0124263887113595, 0.0191648629148629, 0.0348216984596467, 0.00717437886755837, -0.0129644660894661, 0.0, 0.0589869434534289, -0.00659494076734012, 0.00727023882565974, 0.0148633126645335, -0.0040225019849616, 0.0506835250105158, -0.00431740218144091, -0.00810112326287806, 0.00356167508620759, 0.0650269929073342, -0.00166176887443651, -0.0115130724838425, -0.00205633406978793, 0.00540074884191875, 0.0, 0.0, 0.0, 0.0607898426862092, -0.0123318400394175, 0.0013787416307896, 0.0399597288148543, 0.00303983956440067, -0.00427258096992151, 0.00100913554354852, -0.0154763364218896, -0.00302740663064561, 0.000902598269554316, 0.000781673030845898, -0.000425488904726051, -0.031911667854454, -0.00776832903622089, 0.000868525589828735, 0.00180519653910857, 0.000245656133680779, -0.000868525589828785};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 50:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573522, 0.0188672067041847, 0.0108929868695174, 0.00308100195312463, 0.0141189246665007, 0.109364720199429, -0.0223239800292378, -0.0789271883087357, -0.0128887558792643, 0.0127592173566001, 0.00894802256177146, -0.0277290175781224, 0.00145539597846298, 0.00585785581564147, -0.0383297258297259, 0.0124263887113595, 0.0191648629148629, 0.0348216984596467, 0.00717437886755832, -0.0129644660894661, 0.0, -0.0589869434534289, 0.00659494076734014, 0.00727023882565983, 0.0148633126645336, -0.00402250198496153, -0.0506835250105158, 0.00431740218144093, 0.00810112326287806, -0.00356167508620756, 0.0650269929073343, -0.00166176887443652, -0.0115130724838424, -0.00205633406978791, 0.00540074884191871, 0.0, 0.0, 0.0, -0.0607898426862092, 0.0123318400394175, -0.00137874163078959, 0.0399597288148542, 0.00303983956440069, -0.00427258096992146, 0.00100913554354852, 0.0154763364218896, 0.00302740663064561, -0.000902598269554309, -0.000781673030845883, 0.000425488904726061, -0.031911667854454, -0.00776832903622087, 0.000868525589828761, 0.00180519653910858, 0.000245656133680792, -0.000868525589828766};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 51:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0, 0.0435719474780695, -0.0523770332031201, -0.0282378493330016, 0.0, 0.0, 0.0631417506469885, -0.0515550235170571, 0.0291639253865144, 0.0, -0.00672218607954478, 0.00097026398564201, 0.0, 0.0, 0.0, -0.0601250601250601, -0.0125835421224891, 0.0286975154702332, -0.015031265031265, 0.0, 0.0, 0.0, -0.0436214329539588, 0.0111474844984002, -0.00160900079398465, 0.0, 0.0, 0.0, 0.0, -0.0650269929073343, 0.031573608614294, -0.00287826812096059, -0.00822533627915167, 0.00540074884191872, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0532796384198057, 0.018239037386404, -0.00466099742173253, 0.000672757029032364, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0425488904726053, -0.00388416451811041, -0.00347410235931508, 0.00120346435940574, 0.000982624534723167, -0.000868525589828753};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 52:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.107394023286761, -0.188672067041848, -0.108929868695174, -0.0770250488281178, -0.0705946233325038, -0.0546823600997146, -0.0446479600584758, -0.0315708753234942, -0.0257775117585285, -0.0182274533665714, 0.0894802256177148, -0.0151249186789758, -0.0130985638061669, 0.0585785581564149, -0.028183621933622, 0.0690354928408859, 0.0744047619047619, 0.00976309302606915, 0.039857660375324, 0.0597492784992785, 0.0, 0.0737336793167861, 0.0659494076734016, 0.036351194128299, 0.00743165633226676, 0.0345935170706695, -0.0120675059548847, 0.0431740218144092, 0.0155790831978424, -0.0254405363300539, -0.0232239260383337, 0.0465295284842228, 0.0251848460584054, -0.0146881004984851, -0.0328199352701215, 0.0, 0.0, 0.0, 0.0, 0.0678251202167962, -0.0137874163078956, 0.0, 0.0334382352084074, 0.0194208225905522, -0.00908221989193679, 0.0, -0.0111004909790339, -0.00902598269554286, -0.00234501909253765, 0.0034039112378084, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598858, 0.0019652490694463, 0.00607967912880138};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 53:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.107394023286761, 0.188672067041848, -0.108929868695174, -0.0770250488281179, -0.0705946233325039, 0.0546823600997146, 0.0446479600584756, -0.0315708753234942, -0.0257775117585286, -0.0182274533665715, -0.0894802256177148, -0.0151249186789759, -0.0130985638061668, -0.058578558156415, 0.0281836219336219, -0.0690354928408858, 0.0744047619047619, 0.00976309302606914, 0.039857660375324, 0.0597492784992785, 0.0, -0.0737336793167861, -0.0659494076734016, 0.036351194128299, 0.0074316563322668, 0.0345935170706696, 0.0120675059548846, -0.0431740218144092, -0.0155790831978424, 0.0254405363300538, -0.0232239260383337, 0.0465295284842228, 0.0251848460584053, -0.014688100498485, -0.0328199352701215, 0.0, 0.0, 0.0, 0.0, -0.0678251202167962, 0.0137874163078956, 0.0, 0.0334382352084074, 0.0194208225905522, -0.0090822198919368, 0.0, 0.0111004909790338, 0.00902598269554286, 0.00234501909253764, -0.00340391123780842, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598857, 0.00196524906944628, 0.00607967912880138};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 54:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.107394023286761, 0.0, 0.217859737390348, -0.0770250488281177, 0.0, 0.0, 0.0, -0.0947126259704828, 0.0515550235170571, -0.0182274533665715, 0.0, -0.0907495120738552, 0.0232863356554078, 0.0, 0.0, 0.0, -0.0946969696969697, -0.0227805503941613, -0.079715320750648, 0.0597492784992785, 0.0, 0.0, 0.0, -0.0727023882565981, -0.0483057661597341, 0.0144810071458617, 0.0, 0.0, 0.0, 0.0, 0.0464478520766673, -0.0781031370985168, 0.0431740218144092, 0.0293762009969702, -0.0328199352701214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0668764704168149, 0.0310733161448835, -0.00605481326129118, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0427258096992147, 0.00694820471863014, -0.0108311792346515, -0.00393049813889261, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 55:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.107394023286761, 0.0, 0.0, 0.231075146484353, 0.0, 0.0, 0.0, 0.0, 0.0, -0.109364720199429, 0.0, 0.0100832791193172, -0.0931453426216311, 0.0, 0.0, 0.0, -0.00450937950937957, -0.104139658944738, 0.0, -0.0924422799422799, 0.0, 0.0, 0.0, 0.0, -0.066884906990401, -0.0579240285834467, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0299118397398575, -0.0647610327216138, 0.0, 0.0835038859404355, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0699149613259878, 0.0242192530451648, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0312669212338355, 0.0270779480866287, 0.0, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate all basis functions at given point x in cell
void poisson3d_5_finite_element_0::evaluate_basis_all(double* values,
                                       const double* x,
                                       const double* vertex_coordinates,
                                       int cell_orientation) const
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 56; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
}

/// Evaluate order n derivatives of basis function i at given point x in cell
void poisson3d_5_finite_element_0::evaluate_basis_derivatives(std::size_t i,
                                               std::size_t n,
                                               double* values,
                                               const double* x,
                                               const double* vertex_coordinates,
                                               int cell_orientation) const
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 5)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[243][5];
    for (unsigned int row = 0; row < 243; row++)
    {
      for (unsigned int col = 0; col < 5; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[243][243];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923496, 0.0060978812067925, 0.00352061335622802, 0.00248944957812477, 0.00705946233325036, 0.00546823600997146, 0.00446479600584758, 0.00315708753234941, 0.00257775117585288, 0.00182274533665716, -0.00298267418725715, -0.00252081977982931, -0.00218309396769448, -0.00195261860521384, -0.00169101731601733, -0.00138070985681771, -0.0011273448773449, -0.00097630930260694, -0.000797153207506486, -0.000563672438672443, 0.00278687112460006, 0.00245778931055955, 0.00219831358911339, 0.00207721109304567, 0.00185791408306669, 0.00160900079398463, 0.00160900079398464, 0.00143913406048031, 0.00124632665582739, 0.00101762145320215, 0.00092895704153337, 0.000830884437218253, 0.000719567030240159, 0.000587524019939406, 0.000415442218609134, -0.00705593524717797, -0.00638233357089079, -0.00582624677716565, -0.00562868913761196, -0.00513826668309062, -0.00459580543596521, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, -0.00368484200521178, -0.00336378514516176, -0.00300866089851429, -0.00260557676948629, -0.00212744452363027, -0.00212744452363026, -0.00194208225905519, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828762};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033678, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.18637738522054e-14, 1.95399252334028e-14, -1.4210854715202e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-4.67403893367191e-14, 11.2249721603218, 0.0, -1.06581410364015e-14, 1.59872115546023e-14, 1.57651669496772e-14, 3.15303338993544e-14, 0.0, -1.19904086659517e-14, 0.0, 1.4837385466804e-14, 0.0, -1.77635683940025e-14, -1.59872115546023e-14, -4.48530101948563e-14, -1.33226762955019e-14, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, -1.4210854715202e-14, 8.36660026534077, -1.18321595661993, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.37667655053519e-14, 1.80411241501588e-14, 1.24344978758018e-14, 0.0, 1.95399252334028e-14, 0.0, -2.08721928629529e-14, 0.0, -1.02140518265514e-14, 1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677398, 0.0, 0.0, 8.69482604771367, 0.0, -1.73194791841524e-14, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 2.35367281220533e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394702, -1.95399252334028e-14, -3.34664010613628, -2.36643191323985, 15.4919333848297, 0.0, -2.8421709430404e-14, 0.692820323027547, 0.565685424949269, 0.400000000000013, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.26565424807268e-14, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 2.30926389122033e-14, 1.02140518265514e-14, 1.06581410364015e-14, 14.1985914794391, -0.828078671210798, 0.0, -1.22124532708767e-14, 0.0, -1.4210854715202e-14, 0.0, -1.3988810110277e-14, 0.0, -3.19744231092045e-14, 0.0, 1.24344978758018e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-9.18154441365004e-14, 4.24264068711928, -1.77635683940025e-14, -3.19744231092045e-14, 1.4210854715202e-14, 2.22044604925031e-14, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, -3.81916720471054e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {3.6, 0.0, 8.76356092008268, -1.549193338483, 0.0, 0.0, -1.06581410364015e-14, 9.52470471983255, -1.48131215963608, 0.261861468283199, 0.0, -1.4210854715202e-14, 0.0, -2.1316282072803e-14, -1.77635683940025e-14, 0.0, 1.77635683940025e-14, -2.1316282072803e-14, 1.95399252334028e-14, -2.75335310107039e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 1.11022302462516e-14, 0.0, 0.0, -1.29896093881143e-14},
      {3.11769145362399, -2.88657986402541e-14, 3.16227766016839, 4.91934955049953, 0.0, -3.40838468559923e-14, -3.28626015289046e-14, 1.4210854715202e-14, 10.690449676497, -2.41897262725905, 0.0, 0.0, 0.0, 0.0, 0.0, -1.73194791841524e-14, 0.0, 2.22044604925031e-14, -2.8421709430404e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, -2.08721928629529e-14, 7.66811580507231, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.59872115546023e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.68753899743024e-14, 11.6057691494799, 0.0, 0.0, 0.0, -4.20458932936039, -3.43303281162797, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, -1.4210854715202e-14, 0.611677741841188, 0.529728463363964, 0.432521479156756, 1.08801856413265e-14, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18784601823741e-14, 0.0, -1.06581410364015e-14, 1.95399252334028e-14, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, -2.1316282072803e-14, 3.54562104171168, -2.50713268211202, 4.7871355387817, 0.0, 0.0, -5.56626745075489, -1.04880884817014, 0.74161984870957, 0.0, 18.8034951158402, -0.603122387046445, -2.30926389122033e-14, 0.0, 1.11022302462516e-14, 1.68183573174416, 0.701283781217668, 0.132137494528683, -0.0934353184302168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095221, 0.0, -1.58564993434417, 4.4848952846511, 4.28174419288838, 1.06581410364015e-14, -1.77635683940025e-14, 0.191485421551255, -3.75233260785872, -4.31161222746201, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, 0.0, 0.0, 0.84437134186504, 1.18187368057056, 1.04463861754668, 0.0, 0.0, -1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.28626015289046e-14, 2.59512887494072, 0.0, 2.66453525910038e-14, 0.0, 10.0285307284481, -0.767649473578736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061157, 0.0967147429123365, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20459198171829e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.2410519540681e-14, 2.32115382989599, -1.95399252334028e-14, 0.0, 0.0, 3.92428337406972, 5.49285249860478, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 17.3044631365565, -1.73008591662716, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.63757896132211e-14, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278144, 0.0, 1.24344978758018e-14, 0.0, 0.0, 8.91928088068607, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.124038404636, -1.64130361329659, 0.0, 1.33226762955019e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227618, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409788, -0.0611677741841419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 2.62012633811537e-14, 0.0, 0.0, 0.0},
      {2.65329983228429, -1.59872115546023e-14, 4.15220619990516, 2.93605316083769, 0.0, -1.3988810110277e-14, -3.90798504668055e-14, 2.63248931621765, 9.82591326180785, -2.8226127713774, 0.0, 0.0, 1.59872115546023e-14, 0.0, -2.8421709430404e-14, 0.0, 1.59872115546023e-14, 11.6081867662438, -3.09487177319465, 0.683876505540213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.80966353013901e-14, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.24344978758018e-14, 1.26565424807268e-14, -1.28785870856518e-14},
      {2.29782505861522, 0.0, 1.49829835452875, 5.50917601898536, 0.0, -2.22044604925031e-14, 1.06581410364015e-14, 0.0, 6.64803945320939, 4.13676892548485, 0.0, -1.50990331349021e-14, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 12.5636136423841, -3.55352656109505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0},
      {1.87616630392935, 0.0, 0.0, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722505, 1.11022302462516e-14, -4.41087092453693, -3.11895674167862, 16.6749979177077, 1.24344978758018e-14, 3.28626015289046e-14, 2.13065307820926, 1.73967095350095, 1.23013312825379, 0.0, -4.3665394383501, -3.78153408023781, 2.26485497023532e-14, 1.77635683940025e-14, 0.0, -0.557935943461964, -0.483186700722515, -0.394520289089674, -0.278967971730998, 23.6981011897578, 0.0, 0.0, 0.490653381462662, 0.438853725736256, 0.380058475033046, 0.0, 0.0, 0.0, 0.0, 0.0626933893908896, 0.0560746721671598, 0.0485620906056359, 0.0396507809422184, 0.0280373360835746, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139875, 0.0, 0.0, 1.4210854715202e-14, 10.5706241650196, -2.72554057547702, 0.0, 1.59872115546023e-14, 0.0, 4.67332857821918, -3.37507799486048e-14, 0.0, -7.86705867811455, -2.39719223514613, 0.618094504365233, 1.4210854715202e-14, 1.06581410364015e-14, 1.99840144432528e-14, 0.0, 0.0, 23.1055548876599, -0.46968719442418, 0.0, 0.0, 0.0, 1.62065746295904, 0.790669146636833, 0.24092688467677, -0.0621208350290869, 1.06581410364015e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 3.5527136788005e-14, 0.0, 0.0, -2.1316282072803e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {4.30766533554561e-14, 6.30840061880559, 1.19904086659517e-14, 0.0, 0.0, -1.5236235005501, 11.1963004093827, 0.0, 1.08801856413265e-14, 0.0, 4.2661458015403, 0.0, 1.06581410364015e-14, 0.132992762321605, -4.72217953828913, -6.6768459701302, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560573, 1.11125127955291, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {3.85449644663771, 2.66453525910038e-14, 5.98171817966646, -2.48806675764058, 1.90029237516522, 0.0, 2.75335310107039e-14, -0.339934634239505, -2.35922146606164, 0.981306762925306, 0.0, 9.95226703056237, -0.430945803685665, 0.0, 0.0, 2.1316282072803e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879208, -0.222539456105662, 0.0, 1.28785870856518e-14, 0.0, 21.5273297444417, -1.00024047132728, 0.0433116829031295, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442917, -0.00774782937530993, -0.0537716476536598, 0.0223660568773474, 0.0, -1.59872115546023e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02140518265514e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274499, 0.0, 1.92724822331889, 2.72554057547701, 1.73472166622177, 2.35367281220533e-14, 0.0, -2.01705689521108, 3.42052627529743, -4.03112887414927, 0.0, 4.08831086321547, 5.37643791520788, 0.0, 0.0, 0.0, 0.365669640132041, -6.25148194071024, -2.03981013744547, 1.80803322065281, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.26521523890981, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 1.98456380761454, 1.4711357857929, 0.363818136386337, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0},
      {3.14718316987778, 1.77635683940025e-14, -0.861891607371342, 6.09449400220045, 1.55158222708543, 2.66453525910038e-14, 4.44089209850063e-14, 0.0693888666488727, -3.0594117081557, 1.80277563773198, -1.4210854715202e-14, 0.0, 9.0312215653788, 0.0, -4.13002965160558e-14, -1.4210854715202e-14, 0.0, 0.403888506800969, -3.67461994579464, -5.49650682721194, 0.0, 0.0, 1.62092561595273e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.974215733960547, 1.78974858569576, 1.80791908794929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.08721928629529e-14, 0.0, -1.59872115546023e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-1.33226762955019e-14, 1.54523626091313, 0.0, 0.0, -1.06581410364015e-14, 6.71778024562962, -0.609449400220044, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.6593983227032, -1.52344936219872, 0.138210132827965, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864229, -0.0138906409944095, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {5.50670620214078e-14, 1.41060126129513, -1.06581410364015e-14, 2.8421709430404e-14, -1.06581410364015e-14, 3.63405410063597, 2.50356888118886, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 3.5685702847991, 11.263055412878, -1.49298814645065, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124154, 0.266287609379566, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14},
      {-4.35207425653061e-14, 1.26168012376111, -3.28626015289046e-14, -1.4210854715202e-14, 0.0, 1.42204860051343, 4.47852016375309, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 1.24344978758018e-14, 8.27725128825316, 5.37909280973864, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 1.46549439250521e-14, 19.9654813226339, -2.61992366301006, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.30926389122033e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 1.77635683940025e-14, 0.0, -1.4210854715202e-14},
      {6.52811138479592e-14, 1.09264703862704, 1.77635683940025e-14, 2.04281036531029e-14, 0.0, -1.59872115546023e-14, 5.38682254607087, -1.11022302462516e-14, 0.0, 0.0, -1.50990331349021e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 13.4377817958113, 1.19904086659517e-14, 0.0, 1.59872115546023e-14, 2.39808173319034e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.3988810110277e-14, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03111963412061e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752226, 2.1316282072803e-14, 7.37120708415869, -1.62882203585591, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050878, 0.642416074439627, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882094426, -2.72522906732404, 0.659300804656284, -0.145686271816935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790433, -0.0662622240310449, 0.014642021234016, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.7842851423995, 0.0, 1.37667655053519e-14, 0.0, 4.26614580154032, 7.83741028656786, -2.63899331455874, 0.0, 0.0, 1.06581410364015e-14, -1.24344978758018e-14, -2.1316282072803e-14, 0.0, 2.23427840700305, 13.2221027072096, -4.67379217909107, 1.1836355846623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 1.77635683940025e-14, 12.1258851598178, -3.11150358274814, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, -2.66453525910038e-14, 1.84297022087776e-14, -1.56541446472147e-14, 1.64313007644523e-14, 0.0},
      {2.06031501455083, 0.0, 2.25696201807216, 3.98978286964828, 0.0, -1.95399252334028e-14, 0.0, 0.95393920141694, 8.01142041980429, 1.18019368870418, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.48689957516035e-14, 0.0, -1.59872115546023e-14, 5.55254896421455, 9.62241374388481, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239955, 0.0, 0.814411017927952, 5.06770487035907, 0.0, 1.50990331349021e-14, 2.48689957516035e-14, 0.0, 4.0151004652476, 6.58672305740269, 0.0, 1.59872115546023e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.22044604925031e-14, -2.22044604925031e-14, 10.0159311874144, 2.83293314500739, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.59872115546023e-14, 0.0, 14.0929454377398, -4.55552790213388, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0},
      {1.4568627181694, 0.0, 1.50990331349021e-14, 5.07816454066241, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 10.0142755247554, 0.0, 0.0, 1.95399252334028e-14, 0.0, -1.50990331349021e-14, 0.0, 0.0, 3.84137166520304e-14, 0.0, 13.8784813613723, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 12.5535587278944, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.08721928629529e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505168, 0.0, 0.0, 0.0, 1.08801856413265e-14, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.11074344166795e-14, 0.0, -1.24344978758018e-14, 0.0, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154979, 5.61248608016091, -1.08012344973464, -0.763762615825974, 1.4210854715202e-14, 0.0, 1.88737914186277e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747789, 7.24568837309472, 4.18330013267039, -0.591607978309975, 1.59872115546023e-14, 0.0, 1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.59872115546023e-14, -2.39808173319034e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338699, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079296, 0.683130051063951, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26010313294955e-14, 0.0, 0.0, -1.75415237890775e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920396, 0.0, 0.0, 7.52994023880668, 0.0, -1.59872115546023e-14, 0.0, 0.0, 1.93178806284777e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 2.06501482580279e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.19999999999999, -0.979795897113268, 0.346410161513774, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, -2.30926389122033e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474623, -1.0, 9.16515138991168, 7.09929573971953, -0.414039335605426, -2.04939015319192, -0.47809144373374, 0.169030850945719, 0.0, 1.4210854715202e-14, 0.0, -1.55431223447522e-14, 0.0, 0.0, 1.82076576038526e-14, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355963, -0.408248290463876, 3.17542648054293, 1.24344978758018e-14, 0.0, 7.17137165600638, 0.0, -1.3801311186847, -1.56144011671766, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 1.60982338570648e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0547118733939e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000003, -5.69209978830308, 4.38178046004134, -0.77459666924149, 1.06581410364015e-14, 10.998181667894, 0.962140470884719, 4.76235235991628, -0.740656079818033, 0.1309307341416, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.34336985979644e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681193, 2.73861278752581, 1.58113883008417, 2.45967477524974, 1.24344978758018e-14, 0.0, 9.25820099772552, 1.15463194561016e-14, 5.34522483824851, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, -1.7874590696465e-14, -2.04281036531029e-14, 0.0, 1.11022302462516e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, -1.04360964314765e-14, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, -1.4210854715202e-14, -3.16227766016838, -2.23606797749981, 0.0, 0.0, 0.0, 13.7477270848675, 0.534522483824846, 0.377964473009211, -4.2632564145606e-14, -2.44804176929847e-14, 1.06581410364015e-14, 0.0, -1.99840144432528e-14, 0.0, -1.06581410364015e-14, -1.77635683940025e-14, 2.72837308301632e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.85407245112401e-14, 0.0, 0.0, 0.0},
      {-1.80000000000005, -1.4210854715202e-14, 3.65148371670111, -2.84018778721881, 0.0, -1.46549439250521e-14, -4.61852778244065e-14, 1.93178806284777e-14, 12.3442679969674, 1.39659449751036, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -2.53130849614536e-14, -3.37507799486048e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.20454076850486, 0.0, -1.82076576038526e-14, 6.64078308635358, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.37667655053519e-14, -1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473995, -2.01017818278145, -1.42141062443802, 8.14215222512713, -2.1022946646802, -1.716516405814, 0.728256234341412, 0.594618725379086, 0.420458932936051, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920587, 0.264864231681981, 0.216260739578377, -0.105945692672788, -0.0917516612761675, -0.0749149177264213, -0.0529728463363905, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239556, 3.07059789431495, 1.77281052085586, -1.253566341056, 2.39356776939085, 6.30376871403132, -0.908295106229257, -2.78313372537745, -0.524404424085068, 0.370809924354789, 11.1242977306435, 9.40174755792013, -0.301561193523245, -2.42752078113806, -0.794200206656965, 0.114434427054267, 0.840917865872086, 0.350641890608844, 0.0660687472643463, -0.0467176592151064, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047605, 2.74642624930238, -0.792824967172093, 2.24244764232554, 2.1408720964442, -0.331662479035522, 6.49923072370877, 0.0957427107756317, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331467, 0.0, -1.46249406456537, -2.04706526287664, 0.0, 0.422185670932522, 0.590936840285272, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747037, 3.74574588632196, -1.05945692672795, -8.09173593712688, 5.01426536422406, -0.383824736789357, 1.80936716113937, -1.10800657553491, 0.313391585263999, 1.4210854715202e-14, 12.7134831207354, 1.01946290306867, 8.20651806648288, -0.631738055305799, 0.04835737145617, -2.84282124887605, -0.227958835180086, 0.139595707137604, -0.0394836284566157, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715532, 1.16057691494798, 1.34011878852098, 1.89521416591737, 2.53311402559512, 1.96214168703485, 2.74642624930236, -0.566421515598876, 3.17129986868839, -1.82198870938949, 0.0, 0.0, 11.169982923824, 0.0, 8.65223156827827, -0.865042958313584, 0.0, -2.49768411251821, -0.998865569685883, 0.441440386136648, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139072, -0.193429485824675, 3.55615782880926, 0.0, 0.0, 4.45964044034304, 0.0, -0.858258202906989, 2.67027285925186, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 7.03562363973515, 4.062019202318, -0.820651806648287, 0.0, -6.79705818718656, -2.08116553882674, 5.88642506110459, -1.20156148406978, 0.242752078113808, 0.0, -2.48689957516035e-14, 0.0, 14.8323969741913, 0.85634883857767, 0.262202212042543, 5.13809303146607, -0.741619848709579, 0.151382517704907, -0.0305838870920616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, -1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02060590481778e-14, 0.0, 0.0, 0.0},
      {1.3266499161422, -2.69693703815182, 2.07610309995256, 1.46802658041887, -1.4210854715202e-14, 3.03973683071411, -6.38211787508103, 1.31624465810882, 4.91295663090392, -1.41130638568869, 0.0, 0.0, 1.24344978758018e-14, 0.0, 13.4039795085887, 2.01017818278146, 0.0, 5.80409338312192, -1.54743588659734, 0.341938252770117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 1.25784799243078e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747034, 0.749149177264372, 2.75458800949269, 0.0, 0.0, 5.75737105184056, 0.0, 3.3240197266047, 2.06838446274243, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.50990331349021e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119208, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.938083151964674, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431068, 0.0, 9.3808315196469, 1.89521416591739, 1.59872115546023e-14, 1.3988810110277e-14, -1.59872115546023e-14, -3.39852909359328, -2.77488738510232, -0.560611910581392, 0.0, 0.0, 0.0, 3.19744231092045e-14, 2.1316282072803e-14, 0.0, 17.7988763690296, 0.428174419288847, 0.349602949390063, 0.0706304617818837, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102537, 0.0, -1.49829835452877, 4.2378277069118, -1.14352971536391e-14, 1.33226762955019e-14, 1.59872115546023e-14, 3.79967103839266, -3.54562104171171, -4.07409060843206, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.66453525910038e-14, 0.0, 0.0, 16.7549743857359, 1.11676565710086, 0.987090711415302, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, -1.59872115546023e-14, 0.0, 1.54876111935209e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0},
      {-1.32664991614217, -1.06581410364015e-14, 1.73008591662713, -3.18072425757423, 0.0, 0.0, 0.0, 0.0, 7.67649473578737, -2.38836465270396, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, -1.54321000422897e-14, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {1.62480768092717, 0.0, 0.0, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226845, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.2598988599366, 1.06532653910462, 0.869835476750477, 0.615066564126897, 10.333118277332, -2.18326971917504, -1.89076704011891, 0.724780051083758, 0.627677936394714, 0.512496888990047, -0.278967971730972, -0.241593350361249, -0.197260144544823, -0.139483985865491, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.219426862868129, 0.190029237516521, -0.0814411017927963, -0.0728431359084647, -0.0630840061880511, -0.0515078753637643, 0.0313466946954457, 0.0280373360835794, 0.0242810453028186, 0.0198253904711077, 0.0140186680417866, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069939, 0.997445717412049, -1.41060126129509, 3.23209352764251, 5.28531208250979, -1.36277028773849, -2.89087233497828, -0.393397896234728, 0.556348640264166, 2.33666428910959, 9.02784807228865, -0.732969916135152, -3.93352933905727, -1.19859611757306, 0.309047252182626, 1.64018416088946, 0.655588223176213, 0.0892142571199814, -0.126168012376114, 13.0996183150503, 11.55277744383, -0.234843597212093, -2.44096975264613, -0.907332870306512, 0.0736662483163202, 0.810328731479521, 0.395334573318418, 0.120463442338388, -0.0310604175145452, -0.311895674167854, -0.164844710568315, -0.065889095553074, -0.00896637020658053, 0.0126803623514062, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482417, 3.15420030940279, -1.09264703862701, 1.54523626091313, 2.95048422176041, -0.761811750275049, 5.59815020469132, 0.263899331455868, -1.93925611658548, -2.28543525082516, 2.13307290077015, -0.257539376818855, 9.14446135479766, 0.0664963811607955, -2.36108976914457, -3.3384229850651, -0.0230350221379907, 0.817905488277901, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280282, 0.555625639776457, 0.595437196138651, 0.0, -0.125015768949703, -0.192474367616157, -0.206265495285708, -0.166687691932938, 0.0, 0.0, 0.0, 0.0, 1.63202784619898e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331885, 1.82834820066016, 2.99085908983323, -1.24403337882028, 0.950146187582625, 5.74064456311311, -0.721110255092799, -0.169967317119739, -1.17961073303082, 0.490653381462648, -10.3037210107158, 4.97613351528116, -0.215472901842822, 5.78174466995661, -1.30185581821819, 0.163532434528632, -3.22682211353225, 0.0385449644663689, 0.267510569439618, -0.111269728052833, 0.0, 14.5551314611669, 1.03556292536503, 10.7636648722209, -0.500120235663644, 0.0216558414515656, -3.5732138395088, -0.581087203147981, 0.130841432732453, -0.0164356280722686, 1.37533064807501, 0.324307824721444, -0.0038739146876523, -0.0268858238268335, 0.0111830284386731, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637254, 1.66904592079256, 0.963624111659453, 1.36277028773852, 0.867360833110869, 2.28430636201793, 2.96226264871971, -1.00852844760554, 1.71026313764872, -2.01556443707463, 2.41867732448957, 2.04415543160773, 2.68821895760395, -0.527798662911744, 7.0797705325562, -1.76652739792483, 0.182834820066024, -3.12574097035512, -1.01990506872274, 0.904016610326402, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.632607619454904, 0.0, -2.86447112137562, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807272, 0.735567892896454, 0.181909068193169, -0.147004726489971, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493887, 1.49284005458435, -0.430945803685678, 3.04724700110022, 0.775791113542715, -0.120185042515443, 5.29905651979674, 0.0346944333244396, -1.52970585407785, 0.901387818865995, 0.0, 0.0, 4.51561078268941, 0.0, -0.699555414372442, 6.36462844462228, 0.0, 0.201944253400485, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.0999354831996, 0.0, 0.0, 0.48710786698027, 0.894874292847875, 0.903959543974644, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456571, 3.86595114186568, -1.05140010313425, 9.15442906076461, 3.35889012281483, -0.304724700110018, 3.87851223317102, -1.52475169285615, 0.414677792940093, 0.0, -9.46260092820844, -2.07602937339136, 7.32969916135159, -0.761724681099357, 0.0691050664139832, 0.564240504518073, -0.879563899362202, 0.345781182036212, -0.0940400840863393, 1.24344978758018e-14, 0.0, 0.0, 16.3745228938128, 0.951027176355639, 0.208648802584718, 9.05975063854701, -0.736662483163209, 0.0765562109321241, -0.00694532049720387, -3.48709964663733, -0.0567083043941681, 0.0883994979795857, -0.0347523163751426, 0.0094513840656914, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.72639680329212e-14, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647572, 2.03602754481989, 1.15175110689981, -2.93221479395417, 1.81702705031799, 1.25178444059444, 0.655663160391211, 3.61359041872285, -1.70346285967313, 0.0, 2.76420265655949, -9.08783875864327, 1.78428514239955, 5.63152770643901, -0.746494073225317, -0.61809450436524, 2.03210252328835, -2.1549427706255, 0.764033484562609, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462396, 0.0, 9.68367982311022, -1.32524448062076, 0.133143804689784, 0.0, -3.35452509157129, -0.478206411017784, 0.384353057392899, -0.124241670058193, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321606, 0.630840061880555, 0.728431359084658, 2.57539376818857, 0.917928424547676, 0.711024300256717, 2.23926008187655, -0.205255035576783, 2.58567482211399, 0.761811750275047, 0.0, 0.0, 5.34294273196309, 1.64313007644523e-14, 4.13862564412655, 2.68954640486932, 0.0, -1.1947183148558, 3.10562068169859, -2.32269806558126, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150502, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692614, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {1.15175110689981, 0.546323519313515, -0.105140010313423, 3.27118942773251, 0.0, -1.4432899320127e-14, 2.69341127303543, 0.0, -0.518347241175131, 4.25171145123352, 0.0, 0.0, 0.0, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618717, 1.82865048192214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, -6.78263087840207, 3.68560354207936, -0.814411017927963, 0.0, 10.0216907612581, 2.6751056943961, 6.00856531485323, -1.45362164025438, 0.321208037219805, 0.0, 1.06581410364015e-14, 0.0, -7.57008074256671, -2.27270584034423, -0.606656948415845, 6.99294104721298, -1.36261453366202, 0.329650402328139, -0.0728431359084718, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.76082174108452, 0.228415531250655, 0.0609713174047712, 5.40219154319687, -0.702817019232752, 0.136947913395214, -0.033131112015524, 0.00732101061700607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {1.1517511068998, 3.8242646351946, 2.20794021658197, 0.89214257119975, 0.0, -2.46306042692148, 6.78739640804926, 2.13307290077016, 3.91870514328394, -1.31949665727938, 0.0, 0.0, 1.24344978758018e-14, 3.22490309931941, -7.63378455726035, -4.04762275910192, 1.11713920350154, 6.61105135360477, -2.33689608954553, 0.591817792331161, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108412, 0.721929233499941, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297045, -0.0962371838080758, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.29677388219329e-14, -1.11022302462516e-14, 0.0, 0.0},
      {1.03015750727542, -1.46593983227032, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945719, -5.20357020296095, 0.476969600708463, 4.00571020990213, 0.590096844352084, 0.0, 1.4210854715202e-14, 0.0, 1.59872115546023e-14, 6.41153127835566, -6.24994106094659, 0.0, 2.77627448210727, 4.81120687194239, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.0440762145518, 0.0, 0.0, 6.69662601613678, -2.34333096254028, 0.591780433634506, 0.0, 0.0, 0.0, 0.0, -1.36557432028894e-14, -1.24344978758018e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0},
      {0.89214257119982, 0.705300630647558, 0.407205508963991, 2.53385243517955, 0.0, 0.0, 3.4771790016512, -1.11022302462516e-14, 2.0075502326238, 3.29336152870135, -1.04360964314765e-14, 1.4210854715202e-14, 1.04360964314765e-14, -1.68753899743024e-14, 0.0, 8.67405085085771, 1.95399252334028e-14, 0.0, 5.00796559370721, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.7284313590847, 0.0, 0.0, 2.5390822703312, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.92068583260152e-14, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359278, 2.1316282072803e-14, -4.65474668125634, -3.29140294302191, 0.0, -2.1316282072803e-14, 0.0, 13.490737563232, 1.83585684909536, 1.29814682728312, 1.4210854715202e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, -3.53270434653113, -3.0594117081557, -0.416333199893252, -0.294392028877592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 21.8326971917504, 0.355050145839433, 0.307482445914332, 0.0418430609640592, 0.0295875121532911, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.14352971536391e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.89848137210902e-14, 0.0},
      {-2.65985524643215, 0.0, 5.0990195135928, -2.06031501455083, 1.06581410364015e-14, 1.92623694772465e-14, 0.0, -1.23153021346074, 9.04986187739902, 3.04724700110021, 0.0, 0.0, -1.15463194561016e-14, 0.0, 2.8421709430404e-14, 0.0, 3.86988371918332, -3.81689227863017, -5.39683034546924, -1.36674464685442, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 21.00264918355, 0.89821371554206, 0.962572311333261, 0.222250255910583, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {2.9738085706659, 0.0, -0.814411017927952, 5.75875553449897, -1.4210854715202e-14, 1.68753899743024e-14, 1.77635683940025e-14, 1.3768926368215, -2.89087233497831, 1.70346285967312, -1.4210854715202e-14, 2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 8.01441409794462, -3.47218947830364, -5.19371076584692, 0.0, 0.0, 0.0, 0.0, 0.0, -1.40339129206524e-14, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.06581410364015e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.03015750727538, 0.0, 0.940400840863429, -2.92584077107539, -1.58761892521397e-14, 2.1316282072803e-14, 3.90798504668055e-14, 0.0, 4.6362386688682, -3.80284633026898, 0.0, 2.1316282072803e-14, 0.0, -1.06581410364015e-14, -1.33226762955019e-14, -1.4210854715202e-14, 1.59872115546023e-14, 0.0, 11.565401134477, -1.63559471386625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376115, 0.0, 1.06581410364015e-14, 4.39781949681097, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67261700493489, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 3.21964677141295e-14, 0.0, 12.0191174248973, 0.0, 0.0, 1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494324, -1.06581410364015e-14, 0.0, 0.0, 1.12687636999453e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, -1.03823200037212e-14, 1.06581410364015e-14, 0.0, 0.0, 1.83186799063151e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154979, 5.61248608016091, -1.08012344973464, -0.763762615825974, 1.4210854715202e-14, 0.0, 1.88737914186277e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267039, -0.591607978309967, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338696, 7.09929573971953, 0.0, 4.34741302385682, 0.0, 0.0, 2.62012633811537e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -2.38697950294409e-14, -1.24344978758018e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231719, -0.341565025531991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, -1.06581410364015e-14, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912985, 0.0, -1.4210854715202e-14, 8.87411967464942, -1.33226762955019e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.19999999999999, -0.979795897113268, 0.346410161513774, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, -2.30926389122033e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474621, -0.999999999999998, 1.30930734141597, 7.09929573971953, -0.41403933560541, -2.04939015319192, -0.47809144373375, 0.169030850945708, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355963, -0.408248290463859, 3.17542648054292, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868468, -1.56144011671765, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.53210777398272e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033672, 4.38178046004134, -0.774596669241495, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991628, -0.740656079818042, 0.130930734141602, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, -1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.558845726812, 0.547722557505154, 1.5811388300842, 2.45967477524977, 1.06581410364015e-14, 9.07114735222144, 1.85164019954509, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.48689957516035e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613576, -6.26099033699941, -3.19744231092045e-14, 3.83405790253614, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872627, 0.0, 0.0, 0.0, 2.30926389122033e-14, 1.50990331349021e-14, 1.06581410364015e-14, -1.46549439250521e-14, 0.0, -1.33226762955019e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.28785870856518e-14},
      {1.03923048454132, 0.0, 3.16227766016838, -0.44721359549997, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824846, 0.0755928946018467, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.899999999999991, 0.0, 1.46059348668044, 1.42009389360937, -1.04360964314765e-14, 0.0, -1.24344978758018e-14, 9.07114735222146, 4.93770719878696, -0.698297248755177, 0.0, -2.30926389122033e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283493, -1.06581410364015e-14, -6.26099033699942, 2.21359436211786, 0.0, -2.48689957516035e-14, -1.77635683940025e-14, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497725, 0.0, 0.0, -4.69574275274956, 1.55431223447522e-14, 0.0, 0.0, 0.0, -2.04281036531029e-14, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.84297022087776e-14, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473995, -2.01017818278145, -1.42141062443802, 8.14215222512713, -2.1022946646802, -1.716516405814, 0.728256234341412, 0.594618725379086, 0.420458932936051, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920587, 0.264864231681981, 0.216260739578377, -0.105945692672788, -0.0917516612761675, -0.0749149177264213, -0.0529728463363905, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239553, 3.07059789431495, 1.77281052085585, -1.25356634105601, 2.39356776939085, 6.30376871403131, -0.908295106229241, -2.78313372537744, -0.524404424085075, 0.370809924354784, 1.23603308118261, 9.40174755792012, -0.30156119352323, -2.42752078113806, -0.794200206656987, 0.114434427054268, 0.840917865872094, 0.35064189060884, 0.0660687472643411, -0.0467176592151075, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930236, -0.792824967172092, 2.24244764232555, 2.1408720964442, -0.331662479035516, 6.49923072370876, 0.0957427107756361, -1.87616630392935, -2.155806113731, 11.0554159678513, 0.0, 9.44035859331466, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932523, 0.590936840285276, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551269, 1.29756443747036, 3.74574588632198, -1.05945692672795, 0.404586796856334, 5.01426536422407, -0.383824736789376, 1.80936716113937, -1.10800657553489, 0.313391585264009, 0.0, 2.82521847127455, -0.0509731451534301, 8.20651806648287, -0.631738055305791, 0.0483573714561656, -2.84282124887605, -0.227958835180068, 0.139595707137609, -0.0394836284566193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715533, 1.16057691494799, 1.34011878852097, 1.89521416591738, 0.361873432227869, 1.96214168703484, 2.74642624930238, -0.566421515598876, 3.17129986868839, -1.8219887093895, -1.4210854715202e-14, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313571, 0.0, -2.4976841125182, -0.998865569685877, 0.441440386136653, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03667074924374e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741912, 1.00508909139074, -0.193429485824681, 3.55615782880926, -8.46157280212811, 0.0, 4.45964044034304, 0.0, -0.858258202907004, 2.67027285925185, -1.06581410364015e-14, 0.0, 12.4373429638328, 0.0, 0.0, 8.42792824422443, 0.0, -1.4210854715202e-14, -1.62195554683795, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {1.48323969741915, 0.335029697130246, 4.062019202318, -0.820651806648291, 0.0, 1.69926454679665, -0.0991031208965167, 5.88642506110459, -1.20156148406979, 0.242752078113808, 0.0, -1.4210854715202e-14, 0.0, 4.94413232473044, -0.214087209644421, 0.0124858196210749, 5.13809303146607, -0.741619848709576, 0.151382517704897, -0.0305838870920701, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0},
      {1.32664991614215, 0.299659670905749, 2.07610309995255, 1.46802658041886, 0.0, 0.86849623734689, 0.709124208342313, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, 0.0, 1.15463194561016e-14, 11.0554159678513, 3.82970843102535, -0.223353131420168, 0.0, 5.80409338312193, -1.54743588659732, 0.341938252770108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930759, 0.25951288749407, 0.749149177264341, 2.75458800949268, 0.0, -8.46157280212812, 1.15147421036812, 0.0, 3.32401972660469, 2.06838446274242, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552748, -2.30926389122033e-14, -1.46549439250521e-14, 6.28180682119207, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0},
      {0.938083151964733, 7.62808987244124, 2.30926389122033e-14, 3.11415464992887, -1.4210854715202e-14, 0.0, -7.52139804633608, -1.53210777398272e-14, -1.90958360235527e-14, 5.52707620976691, 0.0, 0.0, 3.01980662698043e-14, -1.06581410364015e-14, 0.0, 14.2141062443803, 1.75415237890775e-14, 1.46549439250521e-14, 2.30926389122033e-14, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.85634883857769, 0.0, 2.68023757704198, -0.473803541479342, 0.0, 0.0, 0.0, 5.09779364038994, -0.792824967172092, 0.140152977645352, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 7.91061171956872, -0.642261628933266, 0.0998865569686012, -0.0176576154454726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205073, 1.50990331349021e-14, 1.49829835452881, 0.847565541382361, 0.0, 0.0, -1.24344978758018e-14, 1.62843044502543, 3.54562104171166, -0.814818121686415, 0.0, -2.1316282072803e-14, 0.0, 1.06581410364015e-14, -1.77635683940025e-14, 0.0, 11.0554159678513, 7.18070330817252, -1.11676565710081, 0.197418142283057, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071061, 0.0, 0.692034366650857, 1.5903621287871, 0.0, 0.0, 0.0, -8.46157280212813, 3.07059789431492, 1.19418232635197, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 0.0, 1.06581410364015e-14, 12.4373429638327, 5.80288457473996, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309085, 1.95399252334028e-14, 7.62808987244126, 1.79795802543455, 0.0, 1.77635683940025e-14, 2.66453525910038e-14, 0.0, -7.52139804633613, 3.19105893754049, 0.0, 1.59872115546023e-14, 0.0, -1.06581410364015e-14, -1.4210854715202e-14, 0.0, 1.38222766565832e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343547, -1.06581410364015e-14, 0.0, 8.8994381845148, 0.0, 0.0, -1.99840144432528e-14, 0.0, 0.0, -5.26497863243525, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 3.01703106941886e-14, -1.06581410364015e-14, 16.583123951777, 0.0, 1.06581410364015e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226845, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.2598988599366, 1.06532653910462, 0.869835476750477, 0.615066564126897, 10.333118277332, -2.18326971917504, -1.89076704011891, 0.724780051083758, 0.627677936394714, 0.512496888990047, -0.278967971730972, -0.241593350361249, -0.197260144544823, -0.139483985865491, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.219426862868129, 0.190029237516521, -0.0814411017927963, -0.0728431359084647, -0.0630840061880511, -0.0515078753637643, 0.0313466946954457, 0.0280373360835794, 0.0242810453028186, 0.0198253904711077, 0.0140186680417866, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069937, 0.997445717412068, -1.4106012612951, 3.23209352764251, 5.28531208250978, -1.36277028773851, -2.89087233497829, -0.393397896234702, 0.556348640264184, 2.33666428910959, 9.02784807228867, -0.732969916135151, -3.93352933905729, -1.19859611757307, 0.309047252182623, 1.64018416088946, 0.655588223176228, 0.0892142571199894, -0.126168012376106, 1.1908743922773, 11.55277744383, -0.23484359721209, -2.44096975264614, -0.907332870306508, 0.0736662483163188, 0.810328731479525, 0.395334573318413, 0.120463442338387, -0.0310604175145479, -0.311895674167861, -0.16484471056832, -0.0658890955530715, -0.00896637020658542, 0.0126803623514078, 0.0, -1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.15420030940282, -1.09264703862703, 1.54523626091314, 2.95048422176041, -0.761811750275041, 5.59815020469135, 0.26389933145588, -1.93925611658551, -2.28543525082518, 2.13307290077015, -0.257539376818862, 9.14446135479766, 0.0664963811608148, -2.36108976914457, -3.33842298506509, -0.0230350221379905, 0.817905488277889, 1.15646364545769, 1.02505848514081, 13.0453753561106, -1.06581410364015e-14, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280284, 0.555625639776453, 0.595437196138652, 0.0, -0.125015768949702, -0.192474367616161, -0.206265495285703, -0.166687691932942, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331887, 1.82834820066016, 2.99085908983324, -1.24403337882028, 0.950146187582611, 5.74064456311311, -0.721110255092788, -0.169967317119747, -1.17961073303083, 0.490653381462657, 0.294392028877589, 4.97613351528118, -0.215472901842833, 5.78174466995659, -1.30185581821819, 0.163532434528633, -3.22682211353225, 0.0385449644663698, 0.267510569439609, -0.111269728052829, 0.0, 2.646387538394, -0.0295875121532863, 10.7636648722209, -0.500120235663637, 0.0216558414515671, -3.57321383950878, -0.581087203147985, 0.130841432732454, -0.0164356280722704, 1.375330648075, 0.324307824721454, -0.00387391468765275, -0.0268858238268313, 0.0111830284386747, 0.0, -1.12132525487141e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637247, 1.66904592079256, 0.963624111659419, 1.3627702877385, 0.86736083311089, 2.28430636201794, 2.96226264871971, -1.00852844760553, 1.71026313764872, -2.01556443707464, 0.268741924943306, 2.04415543160771, 2.68821895760394, -0.527798662911731, 7.07977053255619, -1.76652739792483, 0.182834820066017, -3.12574097035512, -1.01990506872274, 0.904016610326408, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.63260761945491, 0.0, -2.86447112137561, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807264, 0.735567892896449, 0.18190906819317, -0.14700472648997, 0.0, -1.46549439250521e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493893, 1.49284005458437, -0.430945803685665, 3.04724700110023, 0.775791113542702, -0.120185042515462, 5.29905651979674, 0.0346944333244372, -1.52970585407785, 0.901387818865993, -10.576283741361, 0.0, 4.51561078268942, 0.0, -0.699555414372433, 6.36462844462228, 1.13242748511766e-14, 0.201944253400482, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.0999354831996, 0.0, 0.0, 0.487107866980275, 0.894874292847873, 0.903959543974647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.6288220358559, 0.772618130456564, 3.86595114186567, -1.05140010313427, 0.160604018609902, 3.35889012281482, -0.304724700110016, 3.87851223317101, -1.52475169285615, 0.414677792940088, 0.0, 1.135512111385, -0.036421567954231, 7.32969916135159, -0.761724681099368, 0.0691050664139842, 0.564240504518043, -0.879563899362195, 0.345781182036201, -0.0940400840863452, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162677, 0.00366050530850393, 9.05975063854701, -0.736662483163211, 0.0765562109321194, -0.00694532049720442, -3.48709964663733, -0.056708304394161, 0.0883994979795864, -0.0347523163751426, 0.00945138406568952, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647578, 2.03602754481989, 1.15175110689981, 0.146610739697699, 1.81702705031798, 1.25178444059442, 0.655663160391217, 3.61359041872285, -1.70346285967312, 0.0, 0.614267257013196, 0.454391937932176, 1.78428514239956, 5.63152770643901, -0.746494073225321, -0.618094504365239, 2.03210252328834, -2.15494277062552, 0.764033484562615, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865873, -0.106930204231203, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689784, 0.0, -3.3545250915713, -0.478206411017786, 0.384353057392905, -0.124241670058189, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880574, 0.728431359084674, 2.57539376818857, 0.131132632078232, 0.71102430025673, 2.23926008187657, -0.205255035576797, 2.58567482211399, 0.761811750275044, 1.24344978758018e-14, -10.576283741361, 0.763277533137597, 1.4210854715202e-14, 4.13862564412657, 2.68954640486933, 1.26565424807268e-14, -1.1947183148558, 3.10562068169861, -2.32269806558127, 0.0, -1.15463194561016e-14, 0.0, 0.0, 14.3499128917217, 1.84109468241848, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692603, 0.0, 0.0, 0.0, 1.59872115546023e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.23234755733392e-14, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -1.4210854715202e-14},
      {1.1517511068998, 0.546323519313524, -0.105140010313422, 3.27118942773251, 9.65295620481433, 0.0, 2.69341127303544, 0.0, -0.518347241175148, 4.25171145123352, 0.0, 0.0, -9.91526600752596, 0.0, -1.95399252334028e-14, 6.71889089790562, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 2.66453525910038e-14, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059453, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, 0.19948914348242, 3.68560354207935, -0.814411017927956, 0.0, 1.0278657191034, -0.078679579246943, 6.00856531485323, -1.45362164025439, 0.32120803721981, 0.0, 0.0, 0.0, 3.0280322970267, -0.233098034907102, 0.0178428514239943, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433803, 0.0234272339744288, -0.00179327404131557, 5.40219154319687, -0.702817019232747, 0.136947913395217, -0.0331311120155244, 0.00732101061700707, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {1.15175110689979, 0.182107839771167, 2.20794021658197, 0.892142571199755, 0.0, 0.615765106730371, 0.323209352764241, 2.13307290077016, 3.91870514328394, -1.31949665727938, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 1.07496769977313, 1.90844613931507, -0.19274394090962, 1.11713920350153, 6.61105135360477, -2.33689608954553, 0.591817792331158, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771021, 0.0343775825476184, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297045, -0.0962371838080769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.84297022087776e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 1.65423230669148e-14, 0.0, 0.0, 0.0},
      {1.03015750727544, 0.162882203585596, 1.12848100903608, 1.99489143482414, -1.06581410364015e-14, 0.31471831698775, 0.578174466995661, 0.476969600708475, 4.00571020990214, 0.590096844352074, 0.0, 0.0, 1.4210854715202e-14, -10.576283741361, 1.8318660795302, 0.694437895660734, 0.0, 2.77627448210727, 4.8112068719424, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.338230690505756, -1.06581410364015e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199785, 0.141060126129506, 0.407205508963998, 2.53385243517953, 0.0, 9.65295620481433, 0.69543580033025, 0.0, 2.0075502326238, 3.29336152870134, 0.0, 1.4210854715202e-14, 0.0, 0.0, -9.91526600752598, 1.73481017017153, 2.74225087082414e-14, 0.0, 5.00796559370722, 1.41646657250368, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.04647271886991, -2.27776395106695, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {0.728431359084701, -7.94708263760857, 0.0, 2.5390822703312, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.0071377623777, -1.95399252334028e-14, 1.15463194561016e-14, -1.0325074129014e-14, 0.0, -1.59872115546023e-14, -8.49879943502225, -1.55431223447522e-14, 1.06581410364015e-14, 0.0, 6.93924068068619, 0.0, 1.09356967925578e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394722, 0.0, 0.0, 0.0, -1.33226762955019e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843135908469, 2.1316282072803e-14, 2.32737334062816, -0.470200420431695, 0.0, 0.0, 0.0, 4.49691252107736, -0.917928424547684, 0.185449546754731, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 7.0654086930623, -1.01980390271856, 0.20816659994661, -0.0420560041253566, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678878, 0.10249414863811, -0.0209215304820308, 0.00422678745047178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608056, 2.8421709430404e-14, 1.45686271816939, 0.515078753637706, 0.0, 0.0, 1.77635683940025e-14, 1.84729532019112, 2.58567482211397, -0.761811750275051, 2.1316282072803e-14, 1.95399252334028e-14, 0.0, 2.1316282072803e-14, 2.1316282072803e-14, 0.0, 1.71994831963706, 5.72533841794522, -1.54195152727694, 0.341686161713621, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.34732057331309, 0.275020660380932, -0.0555625639776363, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {0.59476171413319, 0.0, 0.814411017927931, 1.1517511068998, -1.06581410364015e-14, 1.59872115546023e-14, 2.30926389122033e-14, 0.590096844352057, 2.89087233497827, 0.340692571934625, 0.0, 1.06581410364015e-14, 0.0, -1.77635683940025e-14, -1.06581410364015e-14, 0.0, -10.576283741361, 3.43474889911912, 3.47218947830365, -1.03874215316937, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.86517468137026e-14, 1.06581410364015e-14, 0.0, 14.3499128917217, 8.28492607088318, -1.69115345252878, 0.341664592660038, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.51507875363772, 0.0, 0.376160336345357, 1.46292038553769, 0.0, 1.49324996812084e-14, 1.14352971536391e-14, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, -1.24344978758018e-14, -1.59872115546023e-14, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, -9.91526600752594, 4.62616045379078, 0.817797356933106, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 15.9443476574685, 6.50925267372302, -1.31506763029893, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {0.420560041253732, -1.28785870856518e-14, -7.94708263760857, 1.46593983227029, -1.59872115546023e-14, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497829, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, 1.95399252334028e-14, -1.24344978758018e-14, -1.68753899743024e-14, 2.58681964737661e-14, -8.49879943502226, 4.00637247496574, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.24344978758018e-14, 17.9373911146521, 3.6239002554188, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {6.54237885546504, 0.0, 1.50990331349021e-14, -6.9105066413987, -1.4210854715202e-14, 0.0, 3.90798504668055e-14, 0.0, 0.0, 12.2649325896465, 0.0, 1.02140518265514e-14, 2.48689957516035e-14, 1.06581410364015e-14, -4.2632564145606e-14, 0.0, 1.06581410364015e-14, 3.10862446895044e-14, 1.06581410364015e-14, -5.66586629001479, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 1.24344978758018e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 20.4998755596024, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, -1.7874590696465e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 1.86517468137026e-14}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[243];
      for (unsigned int r = 0; r < 243; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923489, -0.00609788120679248, 0.00352061335622803, 0.00248944957812477, 0.0070594623332504, -0.00546823600997143, -0.00446479600584756, 0.00315708753234942, 0.00257775117585286, 0.00182274533665715, 0.00298267418725715, -0.0025208197798293, -0.00218309396769447, 0.00195261860521383, 0.00169101731601732, 0.00138070985681771, -0.00112734487734489, -0.000976309302606922, -0.000797153207506473, -0.000563672438672435, 0.00278687112460003, -0.00245778931055953, -0.0021983135891134, 0.00207721109304565, 0.00185791408306669, 0.00160900079398462, -0.00160900079398462, -0.0014391340604803, -0.00124632665582741, -0.00101762145320216, 0.000928957041533351, 0.000830884437218258, 0.000719567030240153, 0.000587524019939406, 0.000415442218609128, 0.00705593524717798, -0.00638233357089081, -0.00582624677716566, 0.00562868913761197, 0.00513826668309062, 0.0045958054359652, -0.00475711057319694, -0.00434262794914383, -0.00388416451811044, -0.00336378514516178, 0.00368484200521179, 0.00336378514516178, 0.0030086608985143, 0.00260557676948629, 0.00212744452363027, -0.00212744452363027, -0.00194208225905521, -0.00173705117965753, -0.00150433044925715, -0.00122828066840393, -0.000868525589828762};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033678, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.18637738522054e-14, 1.95399252334028e-14, -1.4210854715202e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-4.67403893367191e-14, 11.2249721603218, 0.0, -1.06581410364015e-14, 1.59872115546023e-14, 1.57651669496772e-14, 3.15303338993544e-14, 0.0, -1.19904086659517e-14, 0.0, 1.4837385466804e-14, 0.0, -1.77635683940025e-14, -1.59872115546023e-14, -4.48530101948563e-14, -1.33226762955019e-14, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, -1.4210854715202e-14, 8.36660026534077, -1.18321595661993, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.37667655053519e-14, 1.80411241501588e-14, 1.24344978758018e-14, 0.0, 1.95399252334028e-14, 0.0, -2.08721928629529e-14, 0.0, -1.02140518265514e-14, 1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677398, 0.0, 0.0, 8.69482604771367, 0.0, -1.73194791841524e-14, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 2.35367281220533e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394702, -1.95399252334028e-14, -3.34664010613628, -2.36643191323985, 15.4919333848297, 0.0, -2.8421709430404e-14, 0.692820323027547, 0.565685424949269, 0.400000000000013, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.26565424807268e-14, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 2.30926389122033e-14, 1.02140518265514e-14, 1.06581410364015e-14, 14.1985914794391, -0.828078671210798, 0.0, -1.22124532708767e-14, 0.0, -1.4210854715202e-14, 0.0, -1.3988810110277e-14, 0.0, -3.19744231092045e-14, 0.0, 1.24344978758018e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-9.18154441365004e-14, 4.24264068711928, -1.77635683940025e-14, -3.19744231092045e-14, 1.4210854715202e-14, 2.22044604925031e-14, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, -3.81916720471054e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {3.6, 0.0, 8.76356092008268, -1.549193338483, 0.0, 0.0, -1.06581410364015e-14, 9.52470471983255, -1.48131215963608, 0.261861468283199, 0.0, -1.4210854715202e-14, 0.0, -2.1316282072803e-14, -1.77635683940025e-14, 0.0, 1.77635683940025e-14, -2.1316282072803e-14, 1.95399252334028e-14, -2.75335310107039e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 1.11022302462516e-14, 0.0, 0.0, -1.29896093881143e-14},
      {3.11769145362399, -2.88657986402541e-14, 3.16227766016839, 4.91934955049953, 0.0, -3.40838468559923e-14, -3.28626015289046e-14, 1.4210854715202e-14, 10.690449676497, -2.41897262725905, 0.0, 0.0, 0.0, 0.0, 0.0, -1.73194791841524e-14, 0.0, 2.22044604925031e-14, -2.8421709430404e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, -2.08721928629529e-14, 7.66811580507231, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.59872115546023e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.68753899743024e-14, 11.6057691494799, 0.0, 0.0, 0.0, -4.20458932936039, -3.43303281162797, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, -1.4210854715202e-14, 0.611677741841188, 0.529728463363964, 0.432521479156756, 1.08801856413265e-14, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18784601823741e-14, 0.0, -1.06581410364015e-14, 1.95399252334028e-14, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, -2.1316282072803e-14, 3.54562104171168, -2.50713268211202, 4.7871355387817, 0.0, 0.0, -5.56626745075489, -1.04880884817014, 0.74161984870957, 0.0, 18.8034951158402, -0.603122387046445, -2.30926389122033e-14, 0.0, 1.11022302462516e-14, 1.68183573174416, 0.701283781217668, 0.132137494528683, -0.0934353184302168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095221, 0.0, -1.58564993434417, 4.4848952846511, 4.28174419288838, 1.06581410364015e-14, -1.77635683940025e-14, 0.191485421551255, -3.75233260785872, -4.31161222746201, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, 0.0, 0.0, 0.84437134186504, 1.18187368057056, 1.04463861754668, 0.0, 0.0, -1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.28626015289046e-14, 2.59512887494072, 0.0, 2.66453525910038e-14, 0.0, 10.0285307284481, -0.767649473578736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061157, 0.0967147429123365, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20459198171829e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.2410519540681e-14, 2.32115382989599, -1.95399252334028e-14, 0.0, 0.0, 3.92428337406972, 5.49285249860478, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 17.3044631365565, -1.73008591662716, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.63757896132211e-14, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278144, 0.0, 1.24344978758018e-14, 0.0, 0.0, 8.91928088068607, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.124038404636, -1.64130361329659, 0.0, 1.33226762955019e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227618, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409788, -0.0611677741841419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 2.62012633811537e-14, 0.0, 0.0, 0.0},
      {2.65329983228429, -1.59872115546023e-14, 4.15220619990516, 2.93605316083769, 0.0, -1.3988810110277e-14, -3.90798504668055e-14, 2.63248931621765, 9.82591326180785, -2.8226127713774, 0.0, 0.0, 1.59872115546023e-14, 0.0, -2.8421709430404e-14, 0.0, 1.59872115546023e-14, 11.6081867662438, -3.09487177319465, 0.683876505540213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.80966353013901e-14, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.24344978758018e-14, 1.26565424807268e-14, -1.28785870856518e-14},
      {2.29782505861522, 0.0, 1.49829835452875, 5.50917601898536, 0.0, -2.22044604925031e-14, 1.06581410364015e-14, 0.0, 6.64803945320939, 4.13676892548485, 0.0, -1.50990331349021e-14, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 12.5636136423841, -3.55352656109505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0},
      {1.87616630392935, 0.0, 0.0, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722505, 1.11022302462516e-14, -4.41087092453693, -3.11895674167862, 16.6749979177077, 1.24344978758018e-14, 3.28626015289046e-14, 2.13065307820926, 1.73967095350095, 1.23013312825379, 0.0, -4.3665394383501, -3.78153408023781, 2.26485497023532e-14, 1.77635683940025e-14, 0.0, -0.557935943461964, -0.483186700722515, -0.394520289089674, -0.278967971730998, 23.6981011897578, 0.0, 0.0, 0.490653381462662, 0.438853725736256, 0.380058475033046, 0.0, 0.0, 0.0, 0.0, 0.0626933893908896, 0.0560746721671598, 0.0485620906056359, 0.0396507809422184, 0.0280373360835746, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139875, 0.0, 0.0, 1.4210854715202e-14, 10.5706241650196, -2.72554057547702, 0.0, 1.59872115546023e-14, 0.0, 4.67332857821918, -3.37507799486048e-14, 0.0, -7.86705867811455, -2.39719223514613, 0.618094504365233, 1.4210854715202e-14, 1.06581410364015e-14, 1.99840144432528e-14, 0.0, 0.0, 23.1055548876599, -0.46968719442418, 0.0, 0.0, 0.0, 1.62065746295904, 0.790669146636833, 0.24092688467677, -0.0621208350290869, 1.06581410364015e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 3.5527136788005e-14, 0.0, 0.0, -2.1316282072803e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {4.30766533554561e-14, 6.30840061880559, 1.19904086659517e-14, 0.0, 0.0, -1.5236235005501, 11.1963004093827, 0.0, 1.08801856413265e-14, 0.0, 4.2661458015403, 0.0, 1.06581410364015e-14, 0.132992762321605, -4.72217953828913, -6.6768459701302, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560573, 1.11125127955291, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {3.85449644663771, 2.66453525910038e-14, 5.98171817966646, -2.48806675764058, 1.90029237516522, 0.0, 2.75335310107039e-14, -0.339934634239505, -2.35922146606164, 0.981306762925306, 0.0, 9.95226703056237, -0.430945803685665, 0.0, 0.0, 2.1316282072803e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879208, -0.222539456105662, 0.0, 1.28785870856518e-14, 0.0, 21.5273297444417, -1.00024047132728, 0.0433116829031295, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442917, -0.00774782937530993, -0.0537716476536598, 0.0223660568773474, 0.0, -1.59872115546023e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02140518265514e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274499, 0.0, 1.92724822331889, 2.72554057547701, 1.73472166622177, 2.35367281220533e-14, 0.0, -2.01705689521108, 3.42052627529743, -4.03112887414927, 0.0, 4.08831086321547, 5.37643791520788, 0.0, 0.0, 0.0, 0.365669640132041, -6.25148194071024, -2.03981013744547, 1.80803322065281, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.26521523890981, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 1.98456380761454, 1.4711357857929, 0.363818136386337, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0},
      {3.14718316987778, 1.77635683940025e-14, -0.861891607371342, 6.09449400220045, 1.55158222708543, 2.66453525910038e-14, 4.44089209850063e-14, 0.0693888666488727, -3.0594117081557, 1.80277563773198, -1.4210854715202e-14, 0.0, 9.0312215653788, 0.0, -4.13002965160558e-14, -1.4210854715202e-14, 0.0, 0.403888506800969, -3.67461994579464, -5.49650682721194, 0.0, 0.0, 1.62092561595273e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.974215733960547, 1.78974858569576, 1.80791908794929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.08721928629529e-14, 0.0, -1.59872115546023e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-1.33226762955019e-14, 1.54523626091313, 0.0, 0.0, -1.06581410364015e-14, 6.71778024562962, -0.609449400220044, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.6593983227032, -1.52344936219872, 0.138210132827965, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864229, -0.0138906409944095, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {5.50670620214078e-14, 1.41060126129513, -1.06581410364015e-14, 2.8421709430404e-14, -1.06581410364015e-14, 3.63405410063597, 2.50356888118886, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 3.5685702847991, 11.263055412878, -1.49298814645065, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124154, 0.266287609379566, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14},
      {-4.35207425653061e-14, 1.26168012376111, -3.28626015289046e-14, -1.4210854715202e-14, 0.0, 1.42204860051343, 4.47852016375309, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 1.24344978758018e-14, 8.27725128825316, 5.37909280973864, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 1.46549439250521e-14, 19.9654813226339, -2.61992366301006, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.30926389122033e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 1.77635683940025e-14, 0.0, -1.4210854715202e-14},
      {6.52811138479592e-14, 1.09264703862704, 1.77635683940025e-14, 2.04281036531029e-14, 0.0, -1.59872115546023e-14, 5.38682254607087, -1.11022302462516e-14, 0.0, 0.0, -1.50990331349021e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 13.4377817958113, 1.19904086659517e-14, 0.0, 1.59872115546023e-14, 2.39808173319034e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.3988810110277e-14, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03111963412061e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752226, 2.1316282072803e-14, 7.37120708415869, -1.62882203585591, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050878, 0.642416074439627, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882094426, -2.72522906732404, 0.659300804656284, -0.145686271816935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790433, -0.0662622240310449, 0.014642021234016, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.7842851423995, 0.0, 1.37667655053519e-14, 0.0, 4.26614580154032, 7.83741028656786, -2.63899331455874, 0.0, 0.0, 1.06581410364015e-14, -1.24344978758018e-14, -2.1316282072803e-14, 0.0, 2.23427840700305, 13.2221027072096, -4.67379217909107, 1.1836355846623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 1.77635683940025e-14, 12.1258851598178, -3.11150358274814, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, -2.66453525910038e-14, 1.84297022087776e-14, -1.56541446472147e-14, 1.64313007644523e-14, 0.0},
      {2.06031501455083, 0.0, 2.25696201807216, 3.98978286964828, 0.0, -1.95399252334028e-14, 0.0, 0.95393920141694, 8.01142041980429, 1.18019368870418, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.48689957516035e-14, 0.0, -1.59872115546023e-14, 5.55254896421455, 9.62241374388481, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239955, 0.0, 0.814411017927952, 5.06770487035907, 0.0, 1.50990331349021e-14, 2.48689957516035e-14, 0.0, 4.0151004652476, 6.58672305740269, 0.0, 1.59872115546023e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.22044604925031e-14, -2.22044604925031e-14, 10.0159311874144, 2.83293314500739, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.59872115546023e-14, 0.0, 14.0929454377398, -4.55552790213388, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0},
      {1.4568627181694, 0.0, 1.50990331349021e-14, 5.07816454066241, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 10.0142755247554, 0.0, 0.0, 1.95399252334028e-14, 0.0, -1.50990331349021e-14, 0.0, 0.0, 3.84137166520304e-14, 0.0, 13.8784813613723, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 12.5535587278944, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.08721928629529e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505168, 0.0, 0.0, 0.0, 1.08801856413265e-14, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.11074344166795e-14, 0.0, -1.24344978758018e-14, 0.0, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154979, 5.61248608016091, -1.08012344973464, -0.763762615825974, 1.4210854715202e-14, 0.0, 1.88737914186277e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747789, 7.24568837309472, 4.18330013267039, -0.591607978309975, 1.59872115546023e-14, 0.0, 1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.59872115546023e-14, -2.39808173319034e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338699, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079296, 0.683130051063951, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26010313294955e-14, 0.0, 0.0, -1.75415237890775e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920396, 0.0, 0.0, 7.52994023880668, 0.0, -1.59872115546023e-14, 0.0, 0.0, 1.93178806284777e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 2.06501482580279e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.19999999999999, -0.979795897113268, 0.346410161513774, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, -2.30926389122033e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474623, -1.0, 9.16515138991168, 7.09929573971953, -0.414039335605426, -2.04939015319192, -0.47809144373374, 0.169030850945719, 0.0, 1.4210854715202e-14, 0.0, -1.55431223447522e-14, 0.0, 0.0, 1.82076576038526e-14, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355963, -0.408248290463876, 3.17542648054293, 1.24344978758018e-14, 0.0, 7.17137165600638, 0.0, -1.3801311186847, -1.56144011671766, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 1.60982338570648e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0547118733939e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000003, -5.69209978830308, 4.38178046004134, -0.77459666924149, 1.06581410364015e-14, 10.998181667894, 0.962140470884719, 4.76235235991628, -0.740656079818033, 0.1309307341416, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.34336985979644e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681193, 2.73861278752581, 1.58113883008417, 2.45967477524974, 1.24344978758018e-14, 0.0, 9.25820099772552, 1.15463194561016e-14, 5.34522483824851, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, -1.7874590696465e-14, -2.04281036531029e-14, 0.0, 1.11022302462516e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, -1.04360964314765e-14, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, -1.4210854715202e-14, -3.16227766016838, -2.23606797749981, 0.0, 0.0, 0.0, 13.7477270848675, 0.534522483824846, 0.377964473009211, -4.2632564145606e-14, -2.44804176929847e-14, 1.06581410364015e-14, 0.0, -1.99840144432528e-14, 0.0, -1.06581410364015e-14, -1.77635683940025e-14, 2.72837308301632e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.85407245112401e-14, 0.0, 0.0, 0.0},
      {-1.80000000000005, -1.4210854715202e-14, 3.65148371670111, -2.84018778721881, 0.0, -1.46549439250521e-14, -4.61852778244065e-14, 1.93178806284777e-14, 12.3442679969674, 1.39659449751036, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -2.53130849614536e-14, -3.37507799486048e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.20454076850486, 0.0, -1.82076576038526e-14, 6.64078308635358, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.37667655053519e-14, -1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473995, -2.01017818278145, -1.42141062443802, 8.14215222512713, -2.1022946646802, -1.716516405814, 0.728256234341412, 0.594618725379086, 0.420458932936051, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920587, 0.264864231681981, 0.216260739578377, -0.105945692672788, -0.0917516612761675, -0.0749149177264213, -0.0529728463363905, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239556, 3.07059789431495, 1.77281052085586, -1.253566341056, 2.39356776939085, 6.30376871403132, -0.908295106229257, -2.78313372537745, -0.524404424085068, 0.370809924354789, 11.1242977306435, 9.40174755792013, -0.301561193523245, -2.42752078113806, -0.794200206656965, 0.114434427054267, 0.840917865872086, 0.350641890608844, 0.0660687472643463, -0.0467176592151064, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047605, 2.74642624930238, -0.792824967172093, 2.24244764232554, 2.1408720964442, -0.331662479035522, 6.49923072370877, 0.0957427107756317, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331467, 0.0, -1.46249406456537, -2.04706526287664, 0.0, 0.422185670932522, 0.590936840285272, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747037, 3.74574588632196, -1.05945692672795, -8.09173593712688, 5.01426536422406, -0.383824736789357, 1.80936716113937, -1.10800657553491, 0.313391585263999, 1.4210854715202e-14, 12.7134831207354, 1.01946290306867, 8.20651806648288, -0.631738055305799, 0.04835737145617, -2.84282124887605, -0.227958835180086, 0.139595707137604, -0.0394836284566157, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715532, 1.16057691494798, 1.34011878852098, 1.89521416591737, 2.53311402559512, 1.96214168703485, 2.74642624930236, -0.566421515598876, 3.17129986868839, -1.82198870938949, 0.0, 0.0, 11.169982923824, 0.0, 8.65223156827827, -0.865042958313584, 0.0, -2.49768411251821, -0.998865569685883, 0.441440386136648, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139072, -0.193429485824675, 3.55615782880926, 0.0, 0.0, 4.45964044034304, 0.0, -0.858258202906989, 2.67027285925186, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 7.03562363973515, 4.062019202318, -0.820651806648287, 0.0, -6.79705818718656, -2.08116553882674, 5.88642506110459, -1.20156148406978, 0.242752078113808, 0.0, -2.48689957516035e-14, 0.0, 14.8323969741913, 0.85634883857767, 0.262202212042543, 5.13809303146607, -0.741619848709579, 0.151382517704907, -0.0305838870920616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, -1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02060590481778e-14, 0.0, 0.0, 0.0},
      {1.3266499161422, -2.69693703815182, 2.07610309995256, 1.46802658041887, -1.4210854715202e-14, 3.03973683071411, -6.38211787508103, 1.31624465810882, 4.91295663090392, -1.41130638568869, 0.0, 0.0, 1.24344978758018e-14, 0.0, 13.4039795085887, 2.01017818278146, 0.0, 5.80409338312192, -1.54743588659734, 0.341938252770117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 1.25784799243078e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747034, 0.749149177264372, 2.75458800949269, 0.0, 0.0, 5.75737105184056, 0.0, 3.3240197266047, 2.06838446274243, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.50990331349021e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119208, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.938083151964674, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431068, 0.0, 9.3808315196469, 1.89521416591739, 1.59872115546023e-14, 1.3988810110277e-14, -1.59872115546023e-14, -3.39852909359328, -2.77488738510232, -0.560611910581392, 0.0, 0.0, 0.0, 3.19744231092045e-14, 2.1316282072803e-14, 0.0, 17.7988763690296, 0.428174419288847, 0.349602949390063, 0.0706304617818837, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102537, 0.0, -1.49829835452877, 4.2378277069118, -1.14352971536391e-14, 1.33226762955019e-14, 1.59872115546023e-14, 3.79967103839266, -3.54562104171171, -4.07409060843206, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.66453525910038e-14, 0.0, 0.0, 16.7549743857359, 1.11676565710086, 0.987090711415302, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, -1.59872115546023e-14, 0.0, 1.54876111935209e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0},
      {-1.32664991614217, -1.06581410364015e-14, 1.73008591662713, -3.18072425757423, 0.0, 0.0, 0.0, 0.0, 7.67649473578737, -2.38836465270396, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, -1.54321000422897e-14, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {1.62480768092717, 0.0, 0.0, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226845, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.2598988599366, 1.06532653910462, 0.869835476750477, 0.615066564126897, 10.333118277332, -2.18326971917504, -1.89076704011891, 0.724780051083758, 0.627677936394714, 0.512496888990047, -0.278967971730972, -0.241593350361249, -0.197260144544823, -0.139483985865491, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.219426862868129, 0.190029237516521, -0.0814411017927963, -0.0728431359084647, -0.0630840061880511, -0.0515078753637643, 0.0313466946954457, 0.0280373360835794, 0.0242810453028186, 0.0198253904711077, 0.0140186680417866, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069939, 0.997445717412049, -1.41060126129509, 3.23209352764251, 5.28531208250979, -1.36277028773849, -2.89087233497828, -0.393397896234728, 0.556348640264166, 2.33666428910959, 9.02784807228865, -0.732969916135152, -3.93352933905727, -1.19859611757306, 0.309047252182626, 1.64018416088946, 0.655588223176213, 0.0892142571199814, -0.126168012376114, 13.0996183150503, 11.55277744383, -0.234843597212093, -2.44096975264613, -0.907332870306512, 0.0736662483163202, 0.810328731479521, 0.395334573318418, 0.120463442338388, -0.0310604175145452, -0.311895674167854, -0.164844710568315, -0.065889095553074, -0.00896637020658053, 0.0126803623514062, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482417, 3.15420030940279, -1.09264703862701, 1.54523626091313, 2.95048422176041, -0.761811750275049, 5.59815020469132, 0.263899331455868, -1.93925611658548, -2.28543525082516, 2.13307290077015, -0.257539376818855, 9.14446135479766, 0.0664963811607955, -2.36108976914457, -3.3384229850651, -0.0230350221379907, 0.817905488277901, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280282, 0.555625639776457, 0.595437196138651, 0.0, -0.125015768949703, -0.192474367616157, -0.206265495285708, -0.166687691932938, 0.0, 0.0, 0.0, 0.0, 1.63202784619898e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331885, 1.82834820066016, 2.99085908983323, -1.24403337882028, 0.950146187582625, 5.74064456311311, -0.721110255092799, -0.169967317119739, -1.17961073303082, 0.490653381462648, -10.3037210107158, 4.97613351528116, -0.215472901842822, 5.78174466995661, -1.30185581821819, 0.163532434528632, -3.22682211353225, 0.0385449644663689, 0.267510569439618, -0.111269728052833, 0.0, 14.5551314611669, 1.03556292536503, 10.7636648722209, -0.500120235663644, 0.0216558414515656, -3.5732138395088, -0.581087203147981, 0.130841432732453, -0.0164356280722686, 1.37533064807501, 0.324307824721444, -0.0038739146876523, -0.0268858238268335, 0.0111830284386731, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637254, 1.66904592079256, 0.963624111659453, 1.36277028773852, 0.867360833110869, 2.28430636201793, 2.96226264871971, -1.00852844760554, 1.71026313764872, -2.01556443707463, 2.41867732448957, 2.04415543160773, 2.68821895760395, -0.527798662911744, 7.0797705325562, -1.76652739792483, 0.182834820066024, -3.12574097035512, -1.01990506872274, 0.904016610326402, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.632607619454904, 0.0, -2.86447112137562, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807272, 0.735567892896454, 0.181909068193169, -0.147004726489971, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493887, 1.49284005458435, -0.430945803685678, 3.04724700110022, 0.775791113542715, -0.120185042515443, 5.29905651979674, 0.0346944333244396, -1.52970585407785, 0.901387818865995, 0.0, 0.0, 4.51561078268941, 0.0, -0.699555414372442, 6.36462844462228, 0.0, 0.201944253400485, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.0999354831996, 0.0, 0.0, 0.48710786698027, 0.894874292847875, 0.903959543974644, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456571, 3.86595114186568, -1.05140010313425, 9.15442906076461, 3.35889012281483, -0.304724700110018, 3.87851223317102, -1.52475169285615, 0.414677792940093, 0.0, -9.46260092820844, -2.07602937339136, 7.32969916135159, -0.761724681099357, 0.0691050664139832, 0.564240504518073, -0.879563899362202, 0.345781182036212, -0.0940400840863393, 1.24344978758018e-14, 0.0, 0.0, 16.3745228938128, 0.951027176355639, 0.208648802584718, 9.05975063854701, -0.736662483163209, 0.0765562109321241, -0.00694532049720387, -3.48709964663733, -0.0567083043941681, 0.0883994979795857, -0.0347523163751426, 0.0094513840656914, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.72639680329212e-14, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647572, 2.03602754481989, 1.15175110689981, -2.93221479395417, 1.81702705031799, 1.25178444059444, 0.655663160391211, 3.61359041872285, -1.70346285967313, 0.0, 2.76420265655949, -9.08783875864327, 1.78428514239955, 5.63152770643901, -0.746494073225317, -0.61809450436524, 2.03210252328835, -2.1549427706255, 0.764033484562609, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462396, 0.0, 9.68367982311022, -1.32524448062076, 0.133143804689784, 0.0, -3.35452509157129, -0.478206411017784, 0.384353057392899, -0.124241670058193, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321606, 0.630840061880555, 0.728431359084658, 2.57539376818857, 0.917928424547676, 0.711024300256717, 2.23926008187655, -0.205255035576783, 2.58567482211399, 0.761811750275047, 0.0, 0.0, 5.34294273196309, 1.64313007644523e-14, 4.13862564412655, 2.68954640486932, 0.0, -1.1947183148558, 3.10562068169859, -2.32269806558126, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150502, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692614, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {1.15175110689981, 0.546323519313515, -0.105140010313423, 3.27118942773251, 0.0, -1.4432899320127e-14, 2.69341127303543, 0.0, -0.518347241175131, 4.25171145123352, 0.0, 0.0, 0.0, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618717, 1.82865048192214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, -6.78263087840207, 3.68560354207936, -0.814411017927963, 0.0, 10.0216907612581, 2.6751056943961, 6.00856531485323, -1.45362164025438, 0.321208037219805, 0.0, 1.06581410364015e-14, 0.0, -7.57008074256671, -2.27270584034423, -0.606656948415845, 6.99294104721298, -1.36261453366202, 0.329650402328139, -0.0728431359084718, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.76082174108452, 0.228415531250655, 0.0609713174047712, 5.40219154319687, -0.702817019232752, 0.136947913395214, -0.033131112015524, 0.00732101061700607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {1.1517511068998, 3.8242646351946, 2.20794021658197, 0.89214257119975, 0.0, -2.46306042692148, 6.78739640804926, 2.13307290077016, 3.91870514328394, -1.31949665727938, 0.0, 0.0, 1.24344978758018e-14, 3.22490309931941, -7.63378455726035, -4.04762275910192, 1.11713920350154, 6.61105135360477, -2.33689608954553, 0.591817792331161, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108412, 0.721929233499941, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297045, -0.0962371838080758, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.29677388219329e-14, -1.11022302462516e-14, 0.0, 0.0},
      {1.03015750727542, -1.46593983227032, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945719, -5.20357020296095, 0.476969600708463, 4.00571020990213, 0.590096844352084, 0.0, 1.4210854715202e-14, 0.0, 1.59872115546023e-14, 6.41153127835566, -6.24994106094659, 0.0, 2.77627448210727, 4.81120687194239, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.0440762145518, 0.0, 0.0, 6.69662601613678, -2.34333096254028, 0.591780433634506, 0.0, 0.0, 0.0, 0.0, -1.36557432028894e-14, -1.24344978758018e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0},
      {0.89214257119982, 0.705300630647558, 0.407205508963991, 2.53385243517955, 0.0, 0.0, 3.4771790016512, -1.11022302462516e-14, 2.0075502326238, 3.29336152870135, -1.04360964314765e-14, 1.4210854715202e-14, 1.04360964314765e-14, -1.68753899743024e-14, 0.0, 8.67405085085771, 1.95399252334028e-14, 0.0, 5.00796559370721, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.7284313590847, 0.0, 0.0, 2.5390822703312, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.92068583260152e-14, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359278, 2.1316282072803e-14, -4.65474668125634, -3.29140294302191, 0.0, -2.1316282072803e-14, 0.0, 13.490737563232, 1.83585684909536, 1.29814682728312, 1.4210854715202e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, -3.53270434653113, -3.0594117081557, -0.416333199893252, -0.294392028877592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 21.8326971917504, 0.355050145839433, 0.307482445914332, 0.0418430609640592, 0.0295875121532911, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.14352971536391e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.89848137210902e-14, 0.0},
      {-2.65985524643215, 0.0, 5.0990195135928, -2.06031501455083, 1.06581410364015e-14, 1.92623694772465e-14, 0.0, -1.23153021346074, 9.04986187739902, 3.04724700110021, 0.0, 0.0, -1.15463194561016e-14, 0.0, 2.8421709430404e-14, 0.0, 3.86988371918332, -3.81689227863017, -5.39683034546924, -1.36674464685442, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 21.00264918355, 0.89821371554206, 0.962572311333261, 0.222250255910583, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {2.9738085706659, 0.0, -0.814411017927952, 5.75875553449897, -1.4210854715202e-14, 1.68753899743024e-14, 1.77635683940025e-14, 1.3768926368215, -2.89087233497831, 1.70346285967312, -1.4210854715202e-14, 2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 8.01441409794462, -3.47218947830364, -5.19371076584692, 0.0, 0.0, 0.0, 0.0, 0.0, -1.40339129206524e-14, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.06581410364015e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.03015750727538, 0.0, 0.940400840863429, -2.92584077107539, -1.58761892521397e-14, 2.1316282072803e-14, 3.90798504668055e-14, 0.0, 4.6362386688682, -3.80284633026898, 0.0, 2.1316282072803e-14, 0.0, -1.06581410364015e-14, -1.33226762955019e-14, -1.4210854715202e-14, 1.59872115546023e-14, 0.0, 11.565401134477, -1.63559471386625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376115, 0.0, 1.06581410364015e-14, 4.39781949681097, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67261700493489, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 3.21964677141295e-14, 0.0, 12.0191174248973, 0.0, 0.0, 1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494324, -1.06581410364015e-14, 0.0, 0.0, 1.12687636999453e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, -1.03823200037212e-14, 1.06581410364015e-14, 0.0, 0.0, 1.83186799063151e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154979, 5.61248608016091, -1.08012344973464, -0.763762615825974, 1.4210854715202e-14, 0.0, 1.88737914186277e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267039, -0.591607978309967, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338696, 7.09929573971953, 0.0, 4.34741302385682, 0.0, 0.0, 2.62012633811537e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -2.38697950294409e-14, -1.24344978758018e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231719, -0.341565025531991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, -1.06581410364015e-14, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912985, 0.0, -1.4210854715202e-14, 8.87411967464942, -1.33226762955019e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.19999999999999, -0.979795897113268, 0.346410161513774, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, -2.30926389122033e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474621, -0.999999999999998, 1.30930734141597, 7.09929573971953, -0.41403933560541, -2.04939015319192, -0.47809144373375, 0.169030850945708, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355963, -0.408248290463859, 3.17542648054292, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868468, -1.56144011671765, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.53210777398272e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033672, 4.38178046004134, -0.774596669241495, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991628, -0.740656079818042, 0.130930734141602, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, -1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.558845726812, 0.547722557505154, 1.5811388300842, 2.45967477524977, 1.06581410364015e-14, 9.07114735222144, 1.85164019954509, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.48689957516035e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613576, -6.26099033699941, -3.19744231092045e-14, 3.83405790253614, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872627, 0.0, 0.0, 0.0, 2.30926389122033e-14, 1.50990331349021e-14, 1.06581410364015e-14, -1.46549439250521e-14, 0.0, -1.33226762955019e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.28785870856518e-14},
      {1.03923048454132, 0.0, 3.16227766016838, -0.44721359549997, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824846, 0.0755928946018467, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.899999999999991, 0.0, 1.46059348668044, 1.42009389360937, -1.04360964314765e-14, 0.0, -1.24344978758018e-14, 9.07114735222146, 4.93770719878696, -0.698297248755177, 0.0, -2.30926389122033e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283493, -1.06581410364015e-14, -6.26099033699942, 2.21359436211786, 0.0, -2.48689957516035e-14, -1.77635683940025e-14, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497725, 0.0, 0.0, -4.69574275274956, 1.55431223447522e-14, 0.0, 0.0, 0.0, -2.04281036531029e-14, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.84297022087776e-14, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473995, -2.01017818278145, -1.42141062443802, 8.14215222512713, -2.1022946646802, -1.716516405814, 0.728256234341412, 0.594618725379086, 0.420458932936051, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920587, 0.264864231681981, 0.216260739578377, -0.105945692672788, -0.0917516612761675, -0.0749149177264213, -0.0529728463363905, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239553, 3.07059789431495, 1.77281052085585, -1.25356634105601, 2.39356776939085, 6.30376871403131, -0.908295106229241, -2.78313372537744, -0.524404424085075, 0.370809924354784, 1.23603308118261, 9.40174755792012, -0.30156119352323, -2.42752078113806, -0.794200206656987, 0.114434427054268, 0.840917865872094, 0.35064189060884, 0.0660687472643411, -0.0467176592151075, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930236, -0.792824967172092, 2.24244764232555, 2.1408720964442, -0.331662479035516, 6.49923072370876, 0.0957427107756361, -1.87616630392935, -2.155806113731, 11.0554159678513, 0.0, 9.44035859331466, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932523, 0.590936840285276, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551269, 1.29756443747036, 3.74574588632198, -1.05945692672795, 0.404586796856334, 5.01426536422407, -0.383824736789376, 1.80936716113937, -1.10800657553489, 0.313391585264009, 0.0, 2.82521847127455, -0.0509731451534301, 8.20651806648287, -0.631738055305791, 0.0483573714561656, -2.84282124887605, -0.227958835180068, 0.139595707137609, -0.0394836284566193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715533, 1.16057691494799, 1.34011878852097, 1.89521416591738, 0.361873432227869, 1.96214168703484, 2.74642624930238, -0.566421515598876, 3.17129986868839, -1.8219887093895, -1.4210854715202e-14, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313571, 0.0, -2.4976841125182, -0.998865569685877, 0.441440386136653, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03667074924374e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741912, 1.00508909139074, -0.193429485824681, 3.55615782880926, -8.46157280212811, 0.0, 4.45964044034304, 0.0, -0.858258202907004, 2.67027285925185, -1.06581410364015e-14, 0.0, 12.4373429638328, 0.0, 0.0, 8.42792824422443, 0.0, -1.4210854715202e-14, -1.62195554683795, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {1.48323969741915, 0.335029697130246, 4.062019202318, -0.820651806648291, 0.0, 1.69926454679665, -0.0991031208965167, 5.88642506110459, -1.20156148406979, 0.242752078113808, 0.0, -1.4210854715202e-14, 0.0, 4.94413232473044, -0.214087209644421, 0.0124858196210749, 5.13809303146607, -0.741619848709576, 0.151382517704897, -0.0305838870920701, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0},
      {1.32664991614215, 0.299659670905749, 2.07610309995255, 1.46802658041886, 0.0, 0.86849623734689, 0.709124208342313, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, 0.0, 1.15463194561016e-14, 11.0554159678513, 3.82970843102535, -0.223353131420168, 0.0, 5.80409338312193, -1.54743588659732, 0.341938252770108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930759, 0.25951288749407, 0.749149177264341, 2.75458800949268, 0.0, -8.46157280212812, 1.15147421036812, 0.0, 3.32401972660469, 2.06838446274242, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552748, -2.30926389122033e-14, -1.46549439250521e-14, 6.28180682119207, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0},
      {0.938083151964733, 7.62808987244124, 2.30926389122033e-14, 3.11415464992887, -1.4210854715202e-14, 0.0, -7.52139804633608, -1.53210777398272e-14, -1.90958360235527e-14, 5.52707620976691, 0.0, 0.0, 3.01980662698043e-14, -1.06581410364015e-14, 0.0, 14.2141062443803, 1.75415237890775e-14, 1.46549439250521e-14, 2.30926389122033e-14, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.85634883857769, 0.0, 2.68023757704198, -0.473803541479342, 0.0, 0.0, 0.0, 5.09779364038994, -0.792824967172092, 0.140152977645352, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 7.91061171956872, -0.642261628933266, 0.0998865569686012, -0.0176576154454726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205073, 1.50990331349021e-14, 1.49829835452881, 0.847565541382361, 0.0, 0.0, -1.24344978758018e-14, 1.62843044502543, 3.54562104171166, -0.814818121686415, 0.0, -2.1316282072803e-14, 0.0, 1.06581410364015e-14, -1.77635683940025e-14, 0.0, 11.0554159678513, 7.18070330817252, -1.11676565710081, 0.197418142283057, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071061, 0.0, 0.692034366650857, 1.5903621287871, 0.0, 0.0, 0.0, -8.46157280212813, 3.07059789431492, 1.19418232635197, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 0.0, 1.06581410364015e-14, 12.4373429638327, 5.80288457473996, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309085, 1.95399252334028e-14, 7.62808987244126, 1.79795802543455, 0.0, 1.77635683940025e-14, 2.66453525910038e-14, 0.0, -7.52139804633613, 3.19105893754049, 0.0, 1.59872115546023e-14, 0.0, -1.06581410364015e-14, -1.4210854715202e-14, 0.0, 1.38222766565832e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343547, -1.06581410364015e-14, 0.0, 8.8994381845148, 0.0, 0.0, -1.99840144432528e-14, 0.0, 0.0, -5.26497863243525, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 3.01703106941886e-14, -1.06581410364015e-14, 16.583123951777, 0.0, 1.06581410364015e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226845, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.2598988599366, 1.06532653910462, 0.869835476750477, 0.615066564126897, 10.333118277332, -2.18326971917504, -1.89076704011891, 0.724780051083758, 0.627677936394714, 0.512496888990047, -0.278967971730972, -0.241593350361249, -0.197260144544823, -0.139483985865491, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.219426862868129, 0.190029237516521, -0.0814411017927963, -0.0728431359084647, -0.0630840061880511, -0.0515078753637643, 0.0313466946954457, 0.0280373360835794, 0.0242810453028186, 0.0198253904711077, 0.0140186680417866, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069937, 0.997445717412068, -1.4106012612951, 3.23209352764251, 5.28531208250978, -1.36277028773851, -2.89087233497829, -0.393397896234702, 0.556348640264184, 2.33666428910959, 9.02784807228867, -0.732969916135151, -3.93352933905729, -1.19859611757307, 0.309047252182623, 1.64018416088946, 0.655588223176228, 0.0892142571199894, -0.126168012376106, 1.1908743922773, 11.55277744383, -0.23484359721209, -2.44096975264614, -0.907332870306508, 0.0736662483163188, 0.810328731479525, 0.395334573318413, 0.120463442338387, -0.0310604175145479, -0.311895674167861, -0.16484471056832, -0.0658890955530715, -0.00896637020658542, 0.0126803623514078, 0.0, -1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.15420030940282, -1.09264703862703, 1.54523626091314, 2.95048422176041, -0.761811750275041, 5.59815020469135, 0.26389933145588, -1.93925611658551, -2.28543525082518, 2.13307290077015, -0.257539376818862, 9.14446135479766, 0.0664963811608148, -2.36108976914457, -3.33842298506509, -0.0230350221379905, 0.817905488277889, 1.15646364545769, 1.02505848514081, 13.0453753561106, -1.06581410364015e-14, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280284, 0.555625639776453, 0.595437196138652, 0.0, -0.125015768949702, -0.192474367616161, -0.206265495285703, -0.166687691932942, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331887, 1.82834820066016, 2.99085908983324, -1.24403337882028, 0.950146187582611, 5.74064456311311, -0.721110255092788, -0.169967317119747, -1.17961073303083, 0.490653381462657, 0.294392028877589, 4.97613351528118, -0.215472901842833, 5.78174466995659, -1.30185581821819, 0.163532434528633, -3.22682211353225, 0.0385449644663698, 0.267510569439609, -0.111269728052829, 0.0, 2.646387538394, -0.0295875121532863, 10.7636648722209, -0.500120235663637, 0.0216558414515671, -3.57321383950878, -0.581087203147985, 0.130841432732454, -0.0164356280722704, 1.375330648075, 0.324307824721454, -0.00387391468765275, -0.0268858238268313, 0.0111830284386747, 0.0, -1.12132525487141e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637247, 1.66904592079256, 0.963624111659419, 1.3627702877385, 0.86736083311089, 2.28430636201794, 2.96226264871971, -1.00852844760553, 1.71026313764872, -2.01556443707464, 0.268741924943306, 2.04415543160771, 2.68821895760394, -0.527798662911731, 7.07977053255619, -1.76652739792483, 0.182834820066017, -3.12574097035512, -1.01990506872274, 0.904016610326408, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.63260761945491, 0.0, -2.86447112137561, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807264, 0.735567892896449, 0.18190906819317, -0.14700472648997, 0.0, -1.46549439250521e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493893, 1.49284005458437, -0.430945803685665, 3.04724700110023, 0.775791113542702, -0.120185042515462, 5.29905651979674, 0.0346944333244372, -1.52970585407785, 0.901387818865993, -10.576283741361, 0.0, 4.51561078268942, 0.0, -0.699555414372433, 6.36462844462228, 1.13242748511766e-14, 0.201944253400482, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.0999354831996, 0.0, 0.0, 0.487107866980275, 0.894874292847873, 0.903959543974647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.6288220358559, 0.772618130456564, 3.86595114186567, -1.05140010313427, 0.160604018609902, 3.35889012281482, -0.304724700110016, 3.87851223317101, -1.52475169285615, 0.414677792940088, 0.0, 1.135512111385, -0.036421567954231, 7.32969916135159, -0.761724681099368, 0.0691050664139842, 0.564240504518043, -0.879563899362195, 0.345781182036201, -0.0940400840863452, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162677, 0.00366050530850393, 9.05975063854701, -0.736662483163211, 0.0765562109321194, -0.00694532049720442, -3.48709964663733, -0.056708304394161, 0.0883994979795864, -0.0347523163751426, 0.00945138406568952, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647578, 2.03602754481989, 1.15175110689981, 0.146610739697699, 1.81702705031798, 1.25178444059442, 0.655663160391217, 3.61359041872285, -1.70346285967312, 0.0, 0.614267257013196, 0.454391937932176, 1.78428514239956, 5.63152770643901, -0.746494073225321, -0.618094504365239, 2.03210252328834, -2.15494277062552, 0.764033484562615, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865873, -0.106930204231203, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689784, 0.0, -3.3545250915713, -0.478206411017786, 0.384353057392905, -0.124241670058189, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880574, 0.728431359084674, 2.57539376818857, 0.131132632078232, 0.71102430025673, 2.23926008187657, -0.205255035576797, 2.58567482211399, 0.761811750275044, 1.24344978758018e-14, -10.576283741361, 0.763277533137597, 1.4210854715202e-14, 4.13862564412657, 2.68954640486933, 1.26565424807268e-14, -1.1947183148558, 3.10562068169861, -2.32269806558127, 0.0, -1.15463194561016e-14, 0.0, 0.0, 14.3499128917217, 1.84109468241848, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692603, 0.0, 0.0, 0.0, 1.59872115546023e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.23234755733392e-14, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -1.4210854715202e-14},
      {1.1517511068998, 0.546323519313524, -0.105140010313422, 3.27118942773251, 9.65295620481433, 0.0, 2.69341127303544, 0.0, -0.518347241175148, 4.25171145123352, 0.0, 0.0, -9.91526600752596, 0.0, -1.95399252334028e-14, 6.71889089790562, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 2.66453525910038e-14, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059453, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, 0.19948914348242, 3.68560354207935, -0.814411017927956, 0.0, 1.0278657191034, -0.078679579246943, 6.00856531485323, -1.45362164025439, 0.32120803721981, 0.0, 0.0, 0.0, 3.0280322970267, -0.233098034907102, 0.0178428514239943, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433803, 0.0234272339744288, -0.00179327404131557, 5.40219154319687, -0.702817019232747, 0.136947913395217, -0.0331311120155244, 0.00732101061700707, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {1.15175110689979, 0.182107839771167, 2.20794021658197, 0.892142571199755, 0.0, 0.615765106730371, 0.323209352764241, 2.13307290077016, 3.91870514328394, -1.31949665727938, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 1.07496769977313, 1.90844613931507, -0.19274394090962, 1.11713920350153, 6.61105135360477, -2.33689608954553, 0.591817792331158, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771021, 0.0343775825476184, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297045, -0.0962371838080769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.84297022087776e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 1.65423230669148e-14, 0.0, 0.0, 0.0},
      {1.03015750727544, 0.162882203585596, 1.12848100903608, 1.99489143482414, -1.06581410364015e-14, 0.31471831698775, 0.578174466995661, 0.476969600708475, 4.00571020990214, 0.590096844352074, 0.0, 0.0, 1.4210854715202e-14, -10.576283741361, 1.8318660795302, 0.694437895660734, 0.0, 2.77627448210727, 4.8112068719424, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.338230690505756, -1.06581410364015e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199785, 0.141060126129506, 0.407205508963998, 2.53385243517953, 0.0, 9.65295620481433, 0.69543580033025, 0.0, 2.0075502326238, 3.29336152870134, 0.0, 1.4210854715202e-14, 0.0, 0.0, -9.91526600752598, 1.73481017017153, 2.74225087082414e-14, 0.0, 5.00796559370722, 1.41646657250368, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.04647271886991, -2.27776395106695, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {0.728431359084701, -7.94708263760857, 0.0, 2.5390822703312, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.0071377623777, -1.95399252334028e-14, 1.15463194561016e-14, -1.0325074129014e-14, 0.0, -1.59872115546023e-14, -8.49879943502225, -1.55431223447522e-14, 1.06581410364015e-14, 0.0, 6.93924068068619, 0.0, 1.09356967925578e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394722, 0.0, 0.0, 0.0, -1.33226762955019e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843135908469, 2.1316282072803e-14, 2.32737334062816, -0.470200420431695, 0.0, 0.0, 0.0, 4.49691252107736, -0.917928424547684, 0.185449546754731, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 7.0654086930623, -1.01980390271856, 0.20816659994661, -0.0420560041253566, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678878, 0.10249414863811, -0.0209215304820308, 0.00422678745047178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608056, 2.8421709430404e-14, 1.45686271816939, 0.515078753637706, 0.0, 0.0, 1.77635683940025e-14, 1.84729532019112, 2.58567482211397, -0.761811750275051, 2.1316282072803e-14, 1.95399252334028e-14, 0.0, 2.1316282072803e-14, 2.1316282072803e-14, 0.0, 1.71994831963706, 5.72533841794522, -1.54195152727694, 0.341686161713621, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.34732057331309, 0.275020660380932, -0.0555625639776363, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {0.59476171413319, 0.0, 0.814411017927931, 1.1517511068998, -1.06581410364015e-14, 1.59872115546023e-14, 2.30926389122033e-14, 0.590096844352057, 2.89087233497827, 0.340692571934625, 0.0, 1.06581410364015e-14, 0.0, -1.77635683940025e-14, -1.06581410364015e-14, 0.0, -10.576283741361, 3.43474889911912, 3.47218947830365, -1.03874215316937, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.86517468137026e-14, 1.06581410364015e-14, 0.0, 14.3499128917217, 8.28492607088318, -1.69115345252878, 0.341664592660038, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.51507875363772, 0.0, 0.376160336345357, 1.46292038553769, 0.0, 1.49324996812084e-14, 1.14352971536391e-14, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, -1.24344978758018e-14, -1.59872115546023e-14, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, -9.91526600752594, 4.62616045379078, 0.817797356933106, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 15.9443476574685, 6.50925267372302, -1.31506763029893, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {0.420560041253732, -1.28785870856518e-14, -7.94708263760857, 1.46593983227029, -1.59872115546023e-14, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497829, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, 1.95399252334028e-14, -1.24344978758018e-14, -1.68753899743024e-14, 2.58681964737661e-14, -8.49879943502226, 4.00637247496574, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.24344978758018e-14, 17.9373911146521, 3.6239002554188, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {6.54237885546504, 0.0, 1.50990331349021e-14, -6.9105066413987, -1.4210854715202e-14, 0.0, 3.90798504668055e-14, 0.0, 0.0, 12.2649325896465, 0.0, 1.02140518265514e-14, 2.48689957516035e-14, 1.06581410364015e-14, -4.2632564145606e-14, 0.0, 1.06581410364015e-14, 3.10862446895044e-14, 1.06581410364015e-14, -5.66586629001479, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 1.24344978758018e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 20.4998755596024, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, -1.7874590696465e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 1.86517468137026e-14}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[243];
      for (unsigned int r = 0; r < 243; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923493, 0.0, -0.00704122671245613, 0.00248944957812475, 0.0, 0.0, 0.0, 0.0094712625970483, -0.00515550235170573, 0.00182274533665714, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00450937950937951, -0.00292892790782074, 0.00159430641501297, -0.000563672438672429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00464478520766671, -0.00332353774887303, 0.00215870109072045, -0.00117504803987881, 0.000415442218609134, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, -0.0097104112952761, 0.00694820471863011, -0.00451299134777143, 0.00245656133680785, -0.000868525589828767};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033678, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.18637738522054e-14, 1.95399252334028e-14, -1.4210854715202e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-4.67403893367191e-14, 11.2249721603218, 0.0, -1.06581410364015e-14, 1.59872115546023e-14, 1.57651669496772e-14, 3.15303338993544e-14, 0.0, -1.19904086659517e-14, 0.0, 1.4837385466804e-14, 0.0, -1.77635683940025e-14, -1.59872115546023e-14, -4.48530101948563e-14, -1.33226762955019e-14, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, -1.4210854715202e-14, 8.36660026534077, -1.18321595661993, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.37667655053519e-14, 1.80411241501588e-14, 1.24344978758018e-14, 0.0, 1.95399252334028e-14, 0.0, -2.08721928629529e-14, 0.0, -1.02140518265514e-14, 1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677398, 0.0, 0.0, 8.69482604771367, 0.0, -1.73194791841524e-14, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 2.35367281220533e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394702, -1.95399252334028e-14, -3.34664010613628, -2.36643191323985, 15.4919333848297, 0.0, -2.8421709430404e-14, 0.692820323027547, 0.565685424949269, 0.400000000000013, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.26565424807268e-14, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 2.30926389122033e-14, 1.02140518265514e-14, 1.06581410364015e-14, 14.1985914794391, -0.828078671210798, 0.0, -1.22124532708767e-14, 0.0, -1.4210854715202e-14, 0.0, -1.3988810110277e-14, 0.0, -3.19744231092045e-14, 0.0, 1.24344978758018e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-9.18154441365004e-14, 4.24264068711928, -1.77635683940025e-14, -3.19744231092045e-14, 1.4210854715202e-14, 2.22044604925031e-14, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, -3.81916720471054e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {3.6, 0.0, 8.76356092008268, -1.549193338483, 0.0, 0.0, -1.06581410364015e-14, 9.52470471983255, -1.48131215963608, 0.261861468283199, 0.0, -1.4210854715202e-14, 0.0, -2.1316282072803e-14, -1.77635683940025e-14, 0.0, 1.77635683940025e-14, -2.1316282072803e-14, 1.95399252334028e-14, -2.75335310107039e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 1.11022302462516e-14, 0.0, 0.0, -1.29896093881143e-14},
      {3.11769145362399, -2.88657986402541e-14, 3.16227766016839, 4.91934955049953, 0.0, -3.40838468559923e-14, -3.28626015289046e-14, 1.4210854715202e-14, 10.690449676497, -2.41897262725905, 0.0, 0.0, 0.0, 0.0, 0.0, -1.73194791841524e-14, 0.0, 2.22044604925031e-14, -2.8421709430404e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, -2.08721928629529e-14, 7.66811580507231, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.59872115546023e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.68753899743024e-14, 11.6057691494799, 0.0, 0.0, 0.0, -4.20458932936039, -3.43303281162797, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, -1.4210854715202e-14, 0.611677741841188, 0.529728463363964, 0.432521479156756, 1.08801856413265e-14, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18784601823741e-14, 0.0, -1.06581410364015e-14, 1.95399252334028e-14, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, -2.1316282072803e-14, 3.54562104171168, -2.50713268211202, 4.7871355387817, 0.0, 0.0, -5.56626745075489, -1.04880884817014, 0.74161984870957, 0.0, 18.8034951158402, -0.603122387046445, -2.30926389122033e-14, 0.0, 1.11022302462516e-14, 1.68183573174416, 0.701283781217668, 0.132137494528683, -0.0934353184302168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095221, 0.0, -1.58564993434417, 4.4848952846511, 4.28174419288838, 1.06581410364015e-14, -1.77635683940025e-14, 0.191485421551255, -3.75233260785872, -4.31161222746201, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, 0.0, 0.0, 0.84437134186504, 1.18187368057056, 1.04463861754668, 0.0, 0.0, -1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.28626015289046e-14, 2.59512887494072, 0.0, 2.66453525910038e-14, 0.0, 10.0285307284481, -0.767649473578736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061157, 0.0967147429123365, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20459198171829e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.2410519540681e-14, 2.32115382989599, -1.95399252334028e-14, 0.0, 0.0, 3.92428337406972, 5.49285249860478, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 17.3044631365565, -1.73008591662716, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.63757896132211e-14, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278144, 0.0, 1.24344978758018e-14, 0.0, 0.0, 8.91928088068607, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.124038404636, -1.64130361329659, 0.0, 1.33226762955019e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227618, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409788, -0.0611677741841419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 2.62012633811537e-14, 0.0, 0.0, 0.0},
      {2.65329983228429, -1.59872115546023e-14, 4.15220619990516, 2.93605316083769, 0.0, -1.3988810110277e-14, -3.90798504668055e-14, 2.63248931621765, 9.82591326180785, -2.8226127713774, 0.0, 0.0, 1.59872115546023e-14, 0.0, -2.8421709430404e-14, 0.0, 1.59872115546023e-14, 11.6081867662438, -3.09487177319465, 0.683876505540213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.80966353013901e-14, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.24344978758018e-14, 1.26565424807268e-14, -1.28785870856518e-14},
      {2.29782505861522, 0.0, 1.49829835452875, 5.50917601898536, 0.0, -2.22044604925031e-14, 1.06581410364015e-14, 0.0, 6.64803945320939, 4.13676892548485, 0.0, -1.50990331349021e-14, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 12.5636136423841, -3.55352656109505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0},
      {1.87616630392935, 0.0, 0.0, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722505, 1.11022302462516e-14, -4.41087092453693, -3.11895674167862, 16.6749979177077, 1.24344978758018e-14, 3.28626015289046e-14, 2.13065307820926, 1.73967095350095, 1.23013312825379, 0.0, -4.3665394383501, -3.78153408023781, 2.26485497023532e-14, 1.77635683940025e-14, 0.0, -0.557935943461964, -0.483186700722515, -0.394520289089674, -0.278967971730998, 23.6981011897578, 0.0, 0.0, 0.490653381462662, 0.438853725736256, 0.380058475033046, 0.0, 0.0, 0.0, 0.0, 0.0626933893908896, 0.0560746721671598, 0.0485620906056359, 0.0396507809422184, 0.0280373360835746, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139875, 0.0, 0.0, 1.4210854715202e-14, 10.5706241650196, -2.72554057547702, 0.0, 1.59872115546023e-14, 0.0, 4.67332857821918, -3.37507799486048e-14, 0.0, -7.86705867811455, -2.39719223514613, 0.618094504365233, 1.4210854715202e-14, 1.06581410364015e-14, 1.99840144432528e-14, 0.0, 0.0, 23.1055548876599, -0.46968719442418, 0.0, 0.0, 0.0, 1.62065746295904, 0.790669146636833, 0.24092688467677, -0.0621208350290869, 1.06581410364015e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 3.5527136788005e-14, 0.0, 0.0, -2.1316282072803e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {4.30766533554561e-14, 6.30840061880559, 1.19904086659517e-14, 0.0, 0.0, -1.5236235005501, 11.1963004093827, 0.0, 1.08801856413265e-14, 0.0, 4.2661458015403, 0.0, 1.06581410364015e-14, 0.132992762321605, -4.72217953828913, -6.6768459701302, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560573, 1.11125127955291, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {3.85449644663771, 2.66453525910038e-14, 5.98171817966646, -2.48806675764058, 1.90029237516522, 0.0, 2.75335310107039e-14, -0.339934634239505, -2.35922146606164, 0.981306762925306, 0.0, 9.95226703056237, -0.430945803685665, 0.0, 0.0, 2.1316282072803e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879208, -0.222539456105662, 0.0, 1.28785870856518e-14, 0.0, 21.5273297444417, -1.00024047132728, 0.0433116829031295, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442917, -0.00774782937530993, -0.0537716476536598, 0.0223660568773474, 0.0, -1.59872115546023e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02140518265514e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274499, 0.0, 1.92724822331889, 2.72554057547701, 1.73472166622177, 2.35367281220533e-14, 0.0, -2.01705689521108, 3.42052627529743, -4.03112887414927, 0.0, 4.08831086321547, 5.37643791520788, 0.0, 0.0, 0.0, 0.365669640132041, -6.25148194071024, -2.03981013744547, 1.80803322065281, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.26521523890981, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 1.98456380761454, 1.4711357857929, 0.363818136386337, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0},
      {3.14718316987778, 1.77635683940025e-14, -0.861891607371342, 6.09449400220045, 1.55158222708543, 2.66453525910038e-14, 4.44089209850063e-14, 0.0693888666488727, -3.0594117081557, 1.80277563773198, -1.4210854715202e-14, 0.0, 9.0312215653788, 0.0, -4.13002965160558e-14, -1.4210854715202e-14, 0.0, 0.403888506800969, -3.67461994579464, -5.49650682721194, 0.0, 0.0, 1.62092561595273e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.974215733960547, 1.78974858569576, 1.80791908794929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.08721928629529e-14, 0.0, -1.59872115546023e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-1.33226762955019e-14, 1.54523626091313, 0.0, 0.0, -1.06581410364015e-14, 6.71778024562962, -0.609449400220044, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.6593983227032, -1.52344936219872, 0.138210132827965, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864229, -0.0138906409944095, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {5.50670620214078e-14, 1.41060126129513, -1.06581410364015e-14, 2.8421709430404e-14, -1.06581410364015e-14, 3.63405410063597, 2.50356888118886, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 3.5685702847991, 11.263055412878, -1.49298814645065, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124154, 0.266287609379566, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14},
      {-4.35207425653061e-14, 1.26168012376111, -3.28626015289046e-14, -1.4210854715202e-14, 0.0, 1.42204860051343, 4.47852016375309, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 1.24344978758018e-14, 8.27725128825316, 5.37909280973864, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 1.46549439250521e-14, 19.9654813226339, -2.61992366301006, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.30926389122033e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 1.77635683940025e-14, 0.0, -1.4210854715202e-14},
      {6.52811138479592e-14, 1.09264703862704, 1.77635683940025e-14, 2.04281036531029e-14, 0.0, -1.59872115546023e-14, 5.38682254607087, -1.11022302462516e-14, 0.0, 0.0, -1.50990331349021e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 13.4377817958113, 1.19904086659517e-14, 0.0, 1.59872115546023e-14, 2.39808173319034e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.3988810110277e-14, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03111963412061e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752226, 2.1316282072803e-14, 7.37120708415869, -1.62882203585591, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050878, 0.642416074439627, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882094426, -2.72522906732404, 0.659300804656284, -0.145686271816935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790433, -0.0662622240310449, 0.014642021234016, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.7842851423995, 0.0, 1.37667655053519e-14, 0.0, 4.26614580154032, 7.83741028656786, -2.63899331455874, 0.0, 0.0, 1.06581410364015e-14, -1.24344978758018e-14, -2.1316282072803e-14, 0.0, 2.23427840700305, 13.2221027072096, -4.67379217909107, 1.1836355846623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 1.77635683940025e-14, 12.1258851598178, -3.11150358274814, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, -2.66453525910038e-14, 1.84297022087776e-14, -1.56541446472147e-14, 1.64313007644523e-14, 0.0},
      {2.06031501455083, 0.0, 2.25696201807216, 3.98978286964828, 0.0, -1.95399252334028e-14, 0.0, 0.95393920141694, 8.01142041980429, 1.18019368870418, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.48689957516035e-14, 0.0, -1.59872115546023e-14, 5.55254896421455, 9.62241374388481, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239955, 0.0, 0.814411017927952, 5.06770487035907, 0.0, 1.50990331349021e-14, 2.48689957516035e-14, 0.0, 4.0151004652476, 6.58672305740269, 0.0, 1.59872115546023e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.22044604925031e-14, -2.22044604925031e-14, 10.0159311874144, 2.83293314500739, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.59872115546023e-14, 0.0, 14.0929454377398, -4.55552790213388, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0},
      {1.4568627181694, 0.0, 1.50990331349021e-14, 5.07816454066241, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 10.0142755247554, 0.0, 0.0, 1.95399252334028e-14, 0.0, -1.50990331349021e-14, 0.0, 0.0, 3.84137166520304e-14, 0.0, 13.8784813613723, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 12.5535587278944, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.08721928629529e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505168, 0.0, 0.0, 0.0, 1.08801856413265e-14, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.11074344166795e-14, 0.0, -1.24344978758018e-14, 0.0, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154979, 5.61248608016091, -1.08012344973464, -0.763762615825974, 1.4210854715202e-14, 0.0, 1.88737914186277e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747789, 7.24568837309472, 4.18330013267039, -0.591607978309975, 1.59872115546023e-14, 0.0, 1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.59872115546023e-14, -2.39808173319034e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338699, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079296, 0.683130051063951, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26010313294955e-14, 0.0, 0.0, -1.75415237890775e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920396, 0.0, 0.0, 7.52994023880668, 0.0, -1.59872115546023e-14, 0.0, 0.0, 1.93178806284777e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 2.06501482580279e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.19999999999999, -0.979795897113268, 0.346410161513774, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, -2.30926389122033e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474623, -1.0, 9.16515138991168, 7.09929573971953, -0.414039335605426, -2.04939015319192, -0.47809144373374, 0.169030850945719, 0.0, 1.4210854715202e-14, 0.0, -1.55431223447522e-14, 0.0, 0.0, 1.82076576038526e-14, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355963, -0.408248290463876, 3.17542648054293, 1.24344978758018e-14, 0.0, 7.17137165600638, 0.0, -1.3801311186847, -1.56144011671766, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 1.60982338570648e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0547118733939e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000003, -5.69209978830308, 4.38178046004134, -0.77459666924149, 1.06581410364015e-14, 10.998181667894, 0.962140470884719, 4.76235235991628, -0.740656079818033, 0.1309307341416, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.34336985979644e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681193, 2.73861278752581, 1.58113883008417, 2.45967477524974, 1.24344978758018e-14, 0.0, 9.25820099772552, 1.15463194561016e-14, 5.34522483824851, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, -1.7874590696465e-14, -2.04281036531029e-14, 0.0, 1.11022302462516e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, -1.04360964314765e-14, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, -1.4210854715202e-14, -3.16227766016838, -2.23606797749981, 0.0, 0.0, 0.0, 13.7477270848675, 0.534522483824846, 0.377964473009211, -4.2632564145606e-14, -2.44804176929847e-14, 1.06581410364015e-14, 0.0, -1.99840144432528e-14, 0.0, -1.06581410364015e-14, -1.77635683940025e-14, 2.72837308301632e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.85407245112401e-14, 0.0, 0.0, 0.0},
      {-1.80000000000005, -1.4210854715202e-14, 3.65148371670111, -2.84018778721881, 0.0, -1.46549439250521e-14, -4.61852778244065e-14, 1.93178806284777e-14, 12.3442679969674, 1.39659449751036, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -2.53130849614536e-14, -3.37507799486048e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.20454076850486, 0.0, -1.82076576038526e-14, 6.64078308635358, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.37667655053519e-14, -1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473995, -2.01017818278145, -1.42141062443802, 8.14215222512713, -2.1022946646802, -1.716516405814, 0.728256234341412, 0.594618725379086, 0.420458932936051, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920587, 0.264864231681981, 0.216260739578377, -0.105945692672788, -0.0917516612761675, -0.0749149177264213, -0.0529728463363905, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239556, 3.07059789431495, 1.77281052085586, -1.253566341056, 2.39356776939085, 6.30376871403132, -0.908295106229257, -2.78313372537745, -0.524404424085068, 0.370809924354789, 11.1242977306435, 9.40174755792013, -0.301561193523245, -2.42752078113806, -0.794200206656965, 0.114434427054267, 0.840917865872086, 0.350641890608844, 0.0660687472643463, -0.0467176592151064, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047605, 2.74642624930238, -0.792824967172093, 2.24244764232554, 2.1408720964442, -0.331662479035522, 6.49923072370877, 0.0957427107756317, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331467, 0.0, -1.46249406456537, -2.04706526287664, 0.0, 0.422185670932522, 0.590936840285272, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747037, 3.74574588632196, -1.05945692672795, -8.09173593712688, 5.01426536422406, -0.383824736789357, 1.80936716113937, -1.10800657553491, 0.313391585263999, 1.4210854715202e-14, 12.7134831207354, 1.01946290306867, 8.20651806648288, -0.631738055305799, 0.04835737145617, -2.84282124887605, -0.227958835180086, 0.139595707137604, -0.0394836284566157, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715532, 1.16057691494798, 1.34011878852098, 1.89521416591737, 2.53311402559512, 1.96214168703485, 2.74642624930236, -0.566421515598876, 3.17129986868839, -1.82198870938949, 0.0, 0.0, 11.169982923824, 0.0, 8.65223156827827, -0.865042958313584, 0.0, -2.49768411251821, -0.998865569685883, 0.441440386136648, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139072, -0.193429485824675, 3.55615782880926, 0.0, 0.0, 4.45964044034304, 0.0, -0.858258202906989, 2.67027285925186, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 7.03562363973515, 4.062019202318, -0.820651806648287, 0.0, -6.79705818718656, -2.08116553882674, 5.88642506110459, -1.20156148406978, 0.242752078113808, 0.0, -2.48689957516035e-14, 0.0, 14.8323969741913, 0.85634883857767, 0.262202212042543, 5.13809303146607, -0.741619848709579, 0.151382517704907, -0.0305838870920616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, -1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02060590481778e-14, 0.0, 0.0, 0.0},
      {1.3266499161422, -2.69693703815182, 2.07610309995256, 1.46802658041887, -1.4210854715202e-14, 3.03973683071411, -6.38211787508103, 1.31624465810882, 4.91295663090392, -1.41130638568869, 0.0, 0.0, 1.24344978758018e-14, 0.0, 13.4039795085887, 2.01017818278146, 0.0, 5.80409338312192, -1.54743588659734, 0.341938252770117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 1.25784799243078e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747034, 0.749149177264372, 2.75458800949269, 0.0, 0.0, 5.75737105184056, 0.0, 3.3240197266047, 2.06838446274243, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.50990331349021e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119208, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.938083151964674, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431068, 0.0, 9.3808315196469, 1.89521416591739, 1.59872115546023e-14, 1.3988810110277e-14, -1.59872115546023e-14, -3.39852909359328, -2.77488738510232, -0.560611910581392, 0.0, 0.0, 0.0, 3.19744231092045e-14, 2.1316282072803e-14, 0.0, 17.7988763690296, 0.428174419288847, 0.349602949390063, 0.0706304617818837, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102537, 0.0, -1.49829835452877, 4.2378277069118, -1.14352971536391e-14, 1.33226762955019e-14, 1.59872115546023e-14, 3.79967103839266, -3.54562104171171, -4.07409060843206, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.66453525910038e-14, 0.0, 0.0, 16.7549743857359, 1.11676565710086, 0.987090711415302, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, -1.59872115546023e-14, 0.0, 1.54876111935209e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0},
      {-1.32664991614217, -1.06581410364015e-14, 1.73008591662713, -3.18072425757423, 0.0, 0.0, 0.0, 0.0, 7.67649473578737, -2.38836465270396, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, -1.54321000422897e-14, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {1.62480768092717, 0.0, 0.0, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226845, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.2598988599366, 1.06532653910462, 0.869835476750477, 0.615066564126897, 10.333118277332, -2.18326971917504, -1.89076704011891, 0.724780051083758, 0.627677936394714, 0.512496888990047, -0.278967971730972, -0.241593350361249, -0.197260144544823, -0.139483985865491, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.219426862868129, 0.190029237516521, -0.0814411017927963, -0.0728431359084647, -0.0630840061880511, -0.0515078753637643, 0.0313466946954457, 0.0280373360835794, 0.0242810453028186, 0.0198253904711077, 0.0140186680417866, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069939, 0.997445717412049, -1.41060126129509, 3.23209352764251, 5.28531208250979, -1.36277028773849, -2.89087233497828, -0.393397896234728, 0.556348640264166, 2.33666428910959, 9.02784807228865, -0.732969916135152, -3.93352933905727, -1.19859611757306, 0.309047252182626, 1.64018416088946, 0.655588223176213, 0.0892142571199814, -0.126168012376114, 13.0996183150503, 11.55277744383, -0.234843597212093, -2.44096975264613, -0.907332870306512, 0.0736662483163202, 0.810328731479521, 0.395334573318418, 0.120463442338388, -0.0310604175145452, -0.311895674167854, -0.164844710568315, -0.065889095553074, -0.00896637020658053, 0.0126803623514062, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482417, 3.15420030940279, -1.09264703862701, 1.54523626091313, 2.95048422176041, -0.761811750275049, 5.59815020469132, 0.263899331455868, -1.93925611658548, -2.28543525082516, 2.13307290077015, -0.257539376818855, 9.14446135479766, 0.0664963811607955, -2.36108976914457, -3.3384229850651, -0.0230350221379907, 0.817905488277901, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280282, 0.555625639776457, 0.595437196138651, 0.0, -0.125015768949703, -0.192474367616157, -0.206265495285708, -0.166687691932938, 0.0, 0.0, 0.0, 0.0, 1.63202784619898e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331885, 1.82834820066016, 2.99085908983323, -1.24403337882028, 0.950146187582625, 5.74064456311311, -0.721110255092799, -0.169967317119739, -1.17961073303082, 0.490653381462648, -10.3037210107158, 4.97613351528116, -0.215472901842822, 5.78174466995661, -1.30185581821819, 0.163532434528632, -3.22682211353225, 0.0385449644663689, 0.267510569439618, -0.111269728052833, 0.0, 14.5551314611669, 1.03556292536503, 10.7636648722209, -0.500120235663644, 0.0216558414515656, -3.5732138395088, -0.581087203147981, 0.130841432732453, -0.0164356280722686, 1.37533064807501, 0.324307824721444, -0.0038739146876523, -0.0268858238268335, 0.0111830284386731, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637254, 1.66904592079256, 0.963624111659453, 1.36277028773852, 0.867360833110869, 2.28430636201793, 2.96226264871971, -1.00852844760554, 1.71026313764872, -2.01556443707463, 2.41867732448957, 2.04415543160773, 2.68821895760395, -0.527798662911744, 7.0797705325562, -1.76652739792483, 0.182834820066024, -3.12574097035512, -1.01990506872274, 0.904016610326402, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.632607619454904, 0.0, -2.86447112137562, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807272, 0.735567892896454, 0.181909068193169, -0.147004726489971, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493887, 1.49284005458435, -0.430945803685678, 3.04724700110022, 0.775791113542715, -0.120185042515443, 5.29905651979674, 0.0346944333244396, -1.52970585407785, 0.901387818865995, 0.0, 0.0, 4.51561078268941, 0.0, -0.699555414372442, 6.36462844462228, 0.0, 0.201944253400485, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.0999354831996, 0.0, 0.0, 0.48710786698027, 0.894874292847875, 0.903959543974644, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456571, 3.86595114186568, -1.05140010313425, 9.15442906076461, 3.35889012281483, -0.304724700110018, 3.87851223317102, -1.52475169285615, 0.414677792940093, 0.0, -9.46260092820844, -2.07602937339136, 7.32969916135159, -0.761724681099357, 0.0691050664139832, 0.564240504518073, -0.879563899362202, 0.345781182036212, -0.0940400840863393, 1.24344978758018e-14, 0.0, 0.0, 16.3745228938128, 0.951027176355639, 0.208648802584718, 9.05975063854701, -0.736662483163209, 0.0765562109321241, -0.00694532049720387, -3.48709964663733, -0.0567083043941681, 0.0883994979795857, -0.0347523163751426, 0.0094513840656914, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.72639680329212e-14, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647572, 2.03602754481989, 1.15175110689981, -2.93221479395417, 1.81702705031799, 1.25178444059444, 0.655663160391211, 3.61359041872285, -1.70346285967313, 0.0, 2.76420265655949, -9.08783875864327, 1.78428514239955, 5.63152770643901, -0.746494073225317, -0.61809450436524, 2.03210252328835, -2.1549427706255, 0.764033484562609, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462396, 0.0, 9.68367982311022, -1.32524448062076, 0.133143804689784, 0.0, -3.35452509157129, -0.478206411017784, 0.384353057392899, -0.124241670058193, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321606, 0.630840061880555, 0.728431359084658, 2.57539376818857, 0.917928424547676, 0.711024300256717, 2.23926008187655, -0.205255035576783, 2.58567482211399, 0.761811750275047, 0.0, 0.0, 5.34294273196309, 1.64313007644523e-14, 4.13862564412655, 2.68954640486932, 0.0, -1.1947183148558, 3.10562068169859, -2.32269806558126, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150502, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692614, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {1.15175110689981, 0.546323519313515, -0.105140010313423, 3.27118942773251, 0.0, -1.4432899320127e-14, 2.69341127303543, 0.0, -0.518347241175131, 4.25171145123352, 0.0, 0.0, 0.0, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618717, 1.82865048192214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, -6.78263087840207, 3.68560354207936, -0.814411017927963, 0.0, 10.0216907612581, 2.6751056943961, 6.00856531485323, -1.45362164025438, 0.321208037219805, 0.0, 1.06581410364015e-14, 0.0, -7.57008074256671, -2.27270584034423, -0.606656948415845, 6.99294104721298, -1.36261453366202, 0.329650402328139, -0.0728431359084718, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.76082174108452, 0.228415531250655, 0.0609713174047712, 5.40219154319687, -0.702817019232752, 0.136947913395214, -0.033131112015524, 0.00732101061700607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {1.1517511068998, 3.8242646351946, 2.20794021658197, 0.89214257119975, 0.0, -2.46306042692148, 6.78739640804926, 2.13307290077016, 3.91870514328394, -1.31949665727938, 0.0, 0.0, 1.24344978758018e-14, 3.22490309931941, -7.63378455726035, -4.04762275910192, 1.11713920350154, 6.61105135360477, -2.33689608954553, 0.591817792331161, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108412, 0.721929233499941, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297045, -0.0962371838080758, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.29677388219329e-14, -1.11022302462516e-14, 0.0, 0.0},
      {1.03015750727542, -1.46593983227032, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945719, -5.20357020296095, 0.476969600708463, 4.00571020990213, 0.590096844352084, 0.0, 1.4210854715202e-14, 0.0, 1.59872115546023e-14, 6.41153127835566, -6.24994106094659, 0.0, 2.77627448210727, 4.81120687194239, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.0440762145518, 0.0, 0.0, 6.69662601613678, -2.34333096254028, 0.591780433634506, 0.0, 0.0, 0.0, 0.0, -1.36557432028894e-14, -1.24344978758018e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0},
      {0.89214257119982, 0.705300630647558, 0.407205508963991, 2.53385243517955, 0.0, 0.0, 3.4771790016512, -1.11022302462516e-14, 2.0075502326238, 3.29336152870135, -1.04360964314765e-14, 1.4210854715202e-14, 1.04360964314765e-14, -1.68753899743024e-14, 0.0, 8.67405085085771, 1.95399252334028e-14, 0.0, 5.00796559370721, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.7284313590847, 0.0, 0.0, 2.5390822703312, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.92068583260152e-14, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359278, 2.1316282072803e-14, -4.65474668125634, -3.29140294302191, 0.0, -2.1316282072803e-14, 0.0, 13.490737563232, 1.83585684909536, 1.29814682728312, 1.4210854715202e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, -3.53270434653113, -3.0594117081557, -0.416333199893252, -0.294392028877592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 21.8326971917504, 0.355050145839433, 0.307482445914332, 0.0418430609640592, 0.0295875121532911, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.14352971536391e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.89848137210902e-14, 0.0},
      {-2.65985524643215, 0.0, 5.0990195135928, -2.06031501455083, 1.06581410364015e-14, 1.92623694772465e-14, 0.0, -1.23153021346074, 9.04986187739902, 3.04724700110021, 0.0, 0.0, -1.15463194561016e-14, 0.0, 2.8421709430404e-14, 0.0, 3.86988371918332, -3.81689227863017, -5.39683034546924, -1.36674464685442, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 21.00264918355, 0.89821371554206, 0.962572311333261, 0.222250255910583, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {2.9738085706659, 0.0, -0.814411017927952, 5.75875553449897, -1.4210854715202e-14, 1.68753899743024e-14, 1.77635683940025e-14, 1.3768926368215, -2.89087233497831, 1.70346285967312, -1.4210854715202e-14, 2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 8.01441409794462, -3.47218947830364, -5.19371076584692, 0.0, 0.0, 0.0, 0.0, 0.0, -1.40339129206524e-14, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.06581410364015e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.03015750727538, 0.0, 0.940400840863429, -2.92584077107539, -1.58761892521397e-14, 2.1316282072803e-14, 3.90798504668055e-14, 0.0, 4.6362386688682, -3.80284633026898, 0.0, 2.1316282072803e-14, 0.0, -1.06581410364015e-14, -1.33226762955019e-14, -1.4210854715202e-14, 1.59872115546023e-14, 0.0, 11.565401134477, -1.63559471386625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376115, 0.0, 1.06581410364015e-14, 4.39781949681097, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67261700493489, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 3.21964677141295e-14, 0.0, 12.0191174248973, 0.0, 0.0, 1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494324, -1.06581410364015e-14, 0.0, 0.0, 1.12687636999453e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, -1.03823200037212e-14, 1.06581410364015e-14, 0.0, 0.0, 1.83186799063151e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154979, 5.61248608016091, -1.08012344973464, -0.763762615825974, 1.4210854715202e-14, 0.0, 1.88737914186277e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267039, -0.591607978309967, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338696, 7.09929573971953, 0.0, 4.34741302385682, 0.0, 0.0, 2.62012633811537e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -2.38697950294409e-14, -1.24344978758018e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231719, -0.341565025531991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, -1.06581410364015e-14, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912985, 0.0, -1.4210854715202e-14, 8.87411967464942, -1.33226762955019e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.19999999999999, -0.979795897113268, 0.346410161513774, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, -2.30926389122033e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474621, -0.999999999999998, 1.30930734141597, 7.09929573971953, -0.41403933560541, -2.04939015319192, -0.47809144373375, 0.169030850945708, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355963, -0.408248290463859, 3.17542648054292, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868468, -1.56144011671765, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.53210777398272e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033672, 4.38178046004134, -0.774596669241495, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991628, -0.740656079818042, 0.130930734141602, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, -1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.558845726812, 0.547722557505154, 1.5811388300842, 2.45967477524977, 1.06581410364015e-14, 9.07114735222144, 1.85164019954509, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.48689957516035e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613576, -6.26099033699941, -3.19744231092045e-14, 3.83405790253614, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872627, 0.0, 0.0, 0.0, 2.30926389122033e-14, 1.50990331349021e-14, 1.06581410364015e-14, -1.46549439250521e-14, 0.0, -1.33226762955019e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.28785870856518e-14},
      {1.03923048454132, 0.0, 3.16227766016838, -0.44721359549997, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824846, 0.0755928946018467, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.899999999999991, 0.0, 1.46059348668044, 1.42009389360937, -1.04360964314765e-14, 0.0, -1.24344978758018e-14, 9.07114735222146, 4.93770719878696, -0.698297248755177, 0.0, -2.30926389122033e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283493, -1.06581410364015e-14, -6.26099033699942, 2.21359436211786, 0.0, -2.48689957516035e-14, -1.77635683940025e-14, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497725, 0.0, 0.0, -4.69574275274956, 1.55431223447522e-14, 0.0, 0.0, 0.0, -2.04281036531029e-14, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.84297022087776e-14, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473995, -2.01017818278145, -1.42141062443802, 8.14215222512713, -2.1022946646802, -1.716516405814, 0.728256234341412, 0.594618725379086, 0.420458932936051, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920587, 0.264864231681981, 0.216260739578377, -0.105945692672788, -0.0917516612761675, -0.0749149177264213, -0.0529728463363905, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239553, 3.07059789431495, 1.77281052085585, -1.25356634105601, 2.39356776939085, 6.30376871403131, -0.908295106229241, -2.78313372537744, -0.524404424085075, 0.370809924354784, 1.23603308118261, 9.40174755792012, -0.30156119352323, -2.42752078113806, -0.794200206656987, 0.114434427054268, 0.840917865872094, 0.35064189060884, 0.0660687472643411, -0.0467176592151075, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930236, -0.792824967172092, 2.24244764232555, 2.1408720964442, -0.331662479035516, 6.49923072370876, 0.0957427107756361, -1.87616630392935, -2.155806113731, 11.0554159678513, 0.0, 9.44035859331466, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932523, 0.590936840285276, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551269, 1.29756443747036, 3.74574588632198, -1.05945692672795, 0.404586796856334, 5.01426536422407, -0.383824736789376, 1.80936716113937, -1.10800657553489, 0.313391585264009, 0.0, 2.82521847127455, -0.0509731451534301, 8.20651806648287, -0.631738055305791, 0.0483573714561656, -2.84282124887605, -0.227958835180068, 0.139595707137609, -0.0394836284566193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715533, 1.16057691494799, 1.34011878852097, 1.89521416591738, 0.361873432227869, 1.96214168703484, 2.74642624930238, -0.566421515598876, 3.17129986868839, -1.8219887093895, -1.4210854715202e-14, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313571, 0.0, -2.4976841125182, -0.998865569685877, 0.441440386136653, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03667074924374e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741912, 1.00508909139074, -0.193429485824681, 3.55615782880926, -8.46157280212811, 0.0, 4.45964044034304, 0.0, -0.858258202907004, 2.67027285925185, -1.06581410364015e-14, 0.0, 12.4373429638328, 0.0, 0.0, 8.42792824422443, 0.0, -1.4210854715202e-14, -1.62195554683795, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {1.48323969741915, 0.335029697130246, 4.062019202318, -0.820651806648291, 0.0, 1.69926454679665, -0.0991031208965167, 5.88642506110459, -1.20156148406979, 0.242752078113808, 0.0, -1.4210854715202e-14, 0.0, 4.94413232473044, -0.214087209644421, 0.0124858196210749, 5.13809303146607, -0.741619848709576, 0.151382517704897, -0.0305838870920701, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0},
      {1.32664991614215, 0.299659670905749, 2.07610309995255, 1.46802658041886, 0.0, 0.86849623734689, 0.709124208342313, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, 0.0, 1.15463194561016e-14, 11.0554159678513, 3.82970843102535, -0.223353131420168, 0.0, 5.80409338312193, -1.54743588659732, 0.341938252770108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930759, 0.25951288749407, 0.749149177264341, 2.75458800949268, 0.0, -8.46157280212812, 1.15147421036812, 0.0, 3.32401972660469, 2.06838446274242, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552748, -2.30926389122033e-14, -1.46549439250521e-14, 6.28180682119207, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0},
      {0.938083151964733, 7.62808987244124, 2.30926389122033e-14, 3.11415464992887, -1.4210854715202e-14, 0.0, -7.52139804633608, -1.53210777398272e-14, -1.90958360235527e-14, 5.52707620976691, 0.0, 0.0, 3.01980662698043e-14, -1.06581410364015e-14, 0.0, 14.2141062443803, 1.75415237890775e-14, 1.46549439250521e-14, 2.30926389122033e-14, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.85634883857769, 0.0, 2.68023757704198, -0.473803541479342, 0.0, 0.0, 0.0, 5.09779364038994, -0.792824967172092, 0.140152977645352, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 7.91061171956872, -0.642261628933266, 0.0998865569686012, -0.0176576154454726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205073, 1.50990331349021e-14, 1.49829835452881, 0.847565541382361, 0.0, 0.0, -1.24344978758018e-14, 1.62843044502543, 3.54562104171166, -0.814818121686415, 0.0, -2.1316282072803e-14, 0.0, 1.06581410364015e-14, -1.77635683940025e-14, 0.0, 11.0554159678513, 7.18070330817252, -1.11676565710081, 0.197418142283057, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071061, 0.0, 0.692034366650857, 1.5903621287871, 0.0, 0.0, 0.0, -8.46157280212813, 3.07059789431492, 1.19418232635197, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 0.0, 1.06581410364015e-14, 12.4373429638327, 5.80288457473996, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309085, 1.95399252334028e-14, 7.62808987244126, 1.79795802543455, 0.0, 1.77635683940025e-14, 2.66453525910038e-14, 0.0, -7.52139804633613, 3.19105893754049, 0.0, 1.59872115546023e-14, 0.0, -1.06581410364015e-14, -1.4210854715202e-14, 0.0, 1.38222766565832e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343547, -1.06581410364015e-14, 0.0, 8.8994381845148, 0.0, 0.0, -1.99840144432528e-14, 0.0, 0.0, -5.26497863243525, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 3.01703106941886e-14, -1.06581410364015e-14, 16.583123951777, 0.0, 1.06581410364015e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226845, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.2598988599366, 1.06532653910462, 0.869835476750477, 0.615066564126897, 10.333118277332, -2.18326971917504, -1.89076704011891, 0.724780051083758, 0.627677936394714, 0.512496888990047, -0.278967971730972, -0.241593350361249, -0.197260144544823, -0.139483985865491, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.219426862868129, 0.190029237516521, -0.0814411017927963, -0.0728431359084647, -0.0630840061880511, -0.0515078753637643, 0.0313466946954457, 0.0280373360835794, 0.0242810453028186, 0.0198253904711077, 0.0140186680417866, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069937, 0.997445717412068, -1.4106012612951, 3.23209352764251, 5.28531208250978, -1.36277028773851, -2.89087233497829, -0.393397896234702, 0.556348640264184, 2.33666428910959, 9.02784807228867, -0.732969916135151, -3.93352933905729, -1.19859611757307, 0.309047252182623, 1.64018416088946, 0.655588223176228, 0.0892142571199894, -0.126168012376106, 1.1908743922773, 11.55277744383, -0.23484359721209, -2.44096975264614, -0.907332870306508, 0.0736662483163188, 0.810328731479525, 0.395334573318413, 0.120463442338387, -0.0310604175145479, -0.311895674167861, -0.16484471056832, -0.0658890955530715, -0.00896637020658542, 0.0126803623514078, 0.0, -1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.15420030940282, -1.09264703862703, 1.54523626091314, 2.95048422176041, -0.761811750275041, 5.59815020469135, 0.26389933145588, -1.93925611658551, -2.28543525082518, 2.13307290077015, -0.257539376818862, 9.14446135479766, 0.0664963811608148, -2.36108976914457, -3.33842298506509, -0.0230350221379905, 0.817905488277889, 1.15646364545769, 1.02505848514081, 13.0453753561106, -1.06581410364015e-14, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280284, 0.555625639776453, 0.595437196138652, 0.0, -0.125015768949702, -0.192474367616161, -0.206265495285703, -0.166687691932942, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331887, 1.82834820066016, 2.99085908983324, -1.24403337882028, 0.950146187582611, 5.74064456311311, -0.721110255092788, -0.169967317119747, -1.17961073303083, 0.490653381462657, 0.294392028877589, 4.97613351528118, -0.215472901842833, 5.78174466995659, -1.30185581821819, 0.163532434528633, -3.22682211353225, 0.0385449644663698, 0.267510569439609, -0.111269728052829, 0.0, 2.646387538394, -0.0295875121532863, 10.7636648722209, -0.500120235663637, 0.0216558414515671, -3.57321383950878, -0.581087203147985, 0.130841432732454, -0.0164356280722704, 1.375330648075, 0.324307824721454, -0.00387391468765275, -0.0268858238268313, 0.0111830284386747, 0.0, -1.12132525487141e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637247, 1.66904592079256, 0.963624111659419, 1.3627702877385, 0.86736083311089, 2.28430636201794, 2.96226264871971, -1.00852844760553, 1.71026313764872, -2.01556443707464, 0.268741924943306, 2.04415543160771, 2.68821895760394, -0.527798662911731, 7.07977053255619, -1.76652739792483, 0.182834820066017, -3.12574097035512, -1.01990506872274, 0.904016610326408, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.63260761945491, 0.0, -2.86447112137561, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807264, 0.735567892896449, 0.18190906819317, -0.14700472648997, 0.0, -1.46549439250521e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493893, 1.49284005458437, -0.430945803685665, 3.04724700110023, 0.775791113542702, -0.120185042515462, 5.29905651979674, 0.0346944333244372, -1.52970585407785, 0.901387818865993, -10.576283741361, 0.0, 4.51561078268942, 0.0, -0.699555414372433, 6.36462844462228, 1.13242748511766e-14, 0.201944253400482, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.0999354831996, 0.0, 0.0, 0.487107866980275, 0.894874292847873, 0.903959543974647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.6288220358559, 0.772618130456564, 3.86595114186567, -1.05140010313427, 0.160604018609902, 3.35889012281482, -0.304724700110016, 3.87851223317101, -1.52475169285615, 0.414677792940088, 0.0, 1.135512111385, -0.036421567954231, 7.32969916135159, -0.761724681099368, 0.0691050664139842, 0.564240504518043, -0.879563899362195, 0.345781182036201, -0.0940400840863452, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162677, 0.00366050530850393, 9.05975063854701, -0.736662483163211, 0.0765562109321194, -0.00694532049720442, -3.48709964663733, -0.056708304394161, 0.0883994979795864, -0.0347523163751426, 0.00945138406568952, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647578, 2.03602754481989, 1.15175110689981, 0.146610739697699, 1.81702705031798, 1.25178444059442, 0.655663160391217, 3.61359041872285, -1.70346285967312, 0.0, 0.614267257013196, 0.454391937932176, 1.78428514239956, 5.63152770643901, -0.746494073225321, -0.618094504365239, 2.03210252328834, -2.15494277062552, 0.764033484562615, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865873, -0.106930204231203, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689784, 0.0, -3.3545250915713, -0.478206411017786, 0.384353057392905, -0.124241670058189, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880574, 0.728431359084674, 2.57539376818857, 0.131132632078232, 0.71102430025673, 2.23926008187657, -0.205255035576797, 2.58567482211399, 0.761811750275044, 1.24344978758018e-14, -10.576283741361, 0.763277533137597, 1.4210854715202e-14, 4.13862564412657, 2.68954640486933, 1.26565424807268e-14, -1.1947183148558, 3.10562068169861, -2.32269806558127, 0.0, -1.15463194561016e-14, 0.0, 0.0, 14.3499128917217, 1.84109468241848, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692603, 0.0, 0.0, 0.0, 1.59872115546023e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.23234755733392e-14, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -1.4210854715202e-14},
      {1.1517511068998, 0.546323519313524, -0.105140010313422, 3.27118942773251, 9.65295620481433, 0.0, 2.69341127303544, 0.0, -0.518347241175148, 4.25171145123352, 0.0, 0.0, -9.91526600752596, 0.0, -1.95399252334028e-14, 6.71889089790562, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 2.66453525910038e-14, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059453, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, 0.19948914348242, 3.68560354207935, -0.814411017927956, 0.0, 1.0278657191034, -0.078679579246943, 6.00856531485323, -1.45362164025439, 0.32120803721981, 0.0, 0.0, 0.0, 3.0280322970267, -0.233098034907102, 0.0178428514239943, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433803, 0.0234272339744288, -0.00179327404131557, 5.40219154319687, -0.702817019232747, 0.136947913395217, -0.0331311120155244, 0.00732101061700707, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {1.15175110689979, 0.182107839771167, 2.20794021658197, 0.892142571199755, 0.0, 0.615765106730371, 0.323209352764241, 2.13307290077016, 3.91870514328394, -1.31949665727938, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 1.07496769977313, 1.90844613931507, -0.19274394090962, 1.11713920350153, 6.61105135360477, -2.33689608954553, 0.591817792331158, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771021, 0.0343775825476184, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297045, -0.0962371838080769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.84297022087776e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 1.65423230669148e-14, 0.0, 0.0, 0.0},
      {1.03015750727544, 0.162882203585596, 1.12848100903608, 1.99489143482414, -1.06581410364015e-14, 0.31471831698775, 0.578174466995661, 0.476969600708475, 4.00571020990214, 0.590096844352074, 0.0, 0.0, 1.4210854715202e-14, -10.576283741361, 1.8318660795302, 0.694437895660734, 0.0, 2.77627448210727, 4.8112068719424, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.338230690505756, -1.06581410364015e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199785, 0.141060126129506, 0.407205508963998, 2.53385243517953, 0.0, 9.65295620481433, 0.69543580033025, 0.0, 2.0075502326238, 3.29336152870134, 0.0, 1.4210854715202e-14, 0.0, 0.0, -9.91526600752598, 1.73481017017153, 2.74225087082414e-14, 0.0, 5.00796559370722, 1.41646657250368, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.04647271886991, -2.27776395106695, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {0.728431359084701, -7.94708263760857, 0.0, 2.5390822703312, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.0071377623777, -1.95399252334028e-14, 1.15463194561016e-14, -1.0325074129014e-14, 0.0, -1.59872115546023e-14, -8.49879943502225, -1.55431223447522e-14, 1.06581410364015e-14, 0.0, 6.93924068068619, 0.0, 1.09356967925578e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394722, 0.0, 0.0, 0.0, -1.33226762955019e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843135908469, 2.1316282072803e-14, 2.32737334062816, -0.470200420431695, 0.0, 0.0, 0.0, 4.49691252107736, -0.917928424547684, 0.185449546754731, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 7.0654086930623, -1.01980390271856, 0.20816659994661, -0.0420560041253566, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678878, 0.10249414863811, -0.0209215304820308, 0.00422678745047178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608056, 2.8421709430404e-14, 1.45686271816939, 0.515078753637706, 0.0, 0.0, 1.77635683940025e-14, 1.84729532019112, 2.58567482211397, -0.761811750275051, 2.1316282072803e-14, 1.95399252334028e-14, 0.0, 2.1316282072803e-14, 2.1316282072803e-14, 0.0, 1.71994831963706, 5.72533841794522, -1.54195152727694, 0.341686161713621, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.34732057331309, 0.275020660380932, -0.0555625639776363, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {0.59476171413319, 0.0, 0.814411017927931, 1.1517511068998, -1.06581410364015e-14, 1.59872115546023e-14, 2.30926389122033e-14, 0.590096844352057, 2.89087233497827, 0.340692571934625, 0.0, 1.06581410364015e-14, 0.0, -1.77635683940025e-14, -1.06581410364015e-14, 0.0, -10.576283741361, 3.43474889911912, 3.47218947830365, -1.03874215316937, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.86517468137026e-14, 1.06581410364015e-14, 0.0, 14.3499128917217, 8.28492607088318, -1.69115345252878, 0.341664592660038, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.51507875363772, 0.0, 0.376160336345357, 1.46292038553769, 0.0, 1.49324996812084e-14, 1.14352971536391e-14, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, -1.24344978758018e-14, -1.59872115546023e-14, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, -9.91526600752594, 4.62616045379078, 0.817797356933106, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 15.9443476574685, 6.50925267372302, -1.31506763029893, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {0.420560041253732, -1.28785870856518e-14, -7.94708263760857, 1.46593983227029, -1.59872115546023e-14, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497829, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, 1.95399252334028e-14, -1.24344978758018e-14, -1.68753899743024e-14, 2.58681964737661e-14, -8.49879943502226, 4.00637247496574, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.24344978758018e-14, 17.9373911146521, 3.6239002554188, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {6.54237885546504, 0.0, 1.50990331349021e-14, -6.9105066413987, -1.4210854715202e-14, 0.0, 3.90798504668055e-14, 0.0, 0.0, 12.2649325896465, 0.0, 1.02140518265514e-14, 2.48689957516035e-14, 1.06581410364015e-14, -4.2632564145606e-14, 0.0, 1.06581410364015e-14, 3.10862446895044e-14, 1.06581410364015e-14, -5.66586629001479, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 1.24344978758018e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 20.4998755596024, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, -1.7874590696465e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 1.86517468137026e-14}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[243];
      for (unsigned int r = 0; r < 243; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923494, 0.0, 0.0, -0.00746834873437434, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0109364720199429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00563672438672437, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00623163327913695, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0182390373864041};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033678, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.18637738522054e-14, 1.95399252334028e-14, -1.4210854715202e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-4.67403893367191e-14, 11.2249721603218, 0.0, -1.06581410364015e-14, 1.59872115546023e-14, 1.57651669496772e-14, 3.15303338993544e-14, 0.0, -1.19904086659517e-14, 0.0, 1.4837385466804e-14, 0.0, -1.77635683940025e-14, -1.59872115546023e-14, -4.48530101948563e-14, -1.33226762955019e-14, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, -1.4210854715202e-14, 8.36660026534077, -1.18321595661993, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.37667655053519e-14, 1.80411241501588e-14, 1.24344978758018e-14, 0.0, 1.95399252334028e-14, 0.0, -2.08721928629529e-14, 0.0, -1.02140518265514e-14, 1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677398, 0.0, 0.0, 8.69482604771367, 0.0, -1.73194791841524e-14, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 2.35367281220533e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394702, -1.95399252334028e-14, -3.34664010613628, -2.36643191323985, 15.4919333848297, 0.0, -2.8421709430404e-14, 0.692820323027547, 0.565685424949269, 0.400000000000013, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.26565424807268e-14, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 2.30926389122033e-14, 1.02140518265514e-14, 1.06581410364015e-14, 14.1985914794391, -0.828078671210798, 0.0, -1.22124532708767e-14, 0.0, -1.4210854715202e-14, 0.0, -1.3988810110277e-14, 0.0, -3.19744231092045e-14, 0.0, 1.24344978758018e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-9.18154441365004e-14, 4.24264068711928, -1.77635683940025e-14, -3.19744231092045e-14, 1.4210854715202e-14, 2.22044604925031e-14, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, -3.81916720471054e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {3.6, 0.0, 8.76356092008268, -1.549193338483, 0.0, 0.0, -1.06581410364015e-14, 9.52470471983255, -1.48131215963608, 0.261861468283199, 0.0, -1.4210854715202e-14, 0.0, -2.1316282072803e-14, -1.77635683940025e-14, 0.0, 1.77635683940025e-14, -2.1316282072803e-14, 1.95399252334028e-14, -2.75335310107039e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 1.11022302462516e-14, 0.0, 0.0, -1.29896093881143e-14},
      {3.11769145362399, -2.88657986402541e-14, 3.16227766016839, 4.91934955049953, 0.0, -3.40838468559923e-14, -3.28626015289046e-14, 1.4210854715202e-14, 10.690449676497, -2.41897262725905, 0.0, 0.0, 0.0, 0.0, 0.0, -1.73194791841524e-14, 0.0, 2.22044604925031e-14, -2.8421709430404e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, -2.08721928629529e-14, 7.66811580507231, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.59872115546023e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.68753899743024e-14, 11.6057691494799, 0.0, 0.0, 0.0, -4.20458932936039, -3.43303281162797, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, -1.4210854715202e-14, 0.611677741841188, 0.529728463363964, 0.432521479156756, 1.08801856413265e-14, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18784601823741e-14, 0.0, -1.06581410364015e-14, 1.95399252334028e-14, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, -2.1316282072803e-14, 3.54562104171168, -2.50713268211202, 4.7871355387817, 0.0, 0.0, -5.56626745075489, -1.04880884817014, 0.74161984870957, 0.0, 18.8034951158402, -0.603122387046445, -2.30926389122033e-14, 0.0, 1.11022302462516e-14, 1.68183573174416, 0.701283781217668, 0.132137494528683, -0.0934353184302168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095221, 0.0, -1.58564993434417, 4.4848952846511, 4.28174419288838, 1.06581410364015e-14, -1.77635683940025e-14, 0.191485421551255, -3.75233260785872, -4.31161222746201, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, 0.0, 0.0, 0.84437134186504, 1.18187368057056, 1.04463861754668, 0.0, 0.0, -1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.28626015289046e-14, 2.59512887494072, 0.0, 2.66453525910038e-14, 0.0, 10.0285307284481, -0.767649473578736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061157, 0.0967147429123365, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20459198171829e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.2410519540681e-14, 2.32115382989599, -1.95399252334028e-14, 0.0, 0.0, 3.92428337406972, 5.49285249860478, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 17.3044631365565, -1.73008591662716, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.63757896132211e-14, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278144, 0.0, 1.24344978758018e-14, 0.0, 0.0, 8.91928088068607, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.124038404636, -1.64130361329659, 0.0, 1.33226762955019e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227618, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409788, -0.0611677741841419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 2.62012633811537e-14, 0.0, 0.0, 0.0},
      {2.65329983228429, -1.59872115546023e-14, 4.15220619990516, 2.93605316083769, 0.0, -1.3988810110277e-14, -3.90798504668055e-14, 2.63248931621765, 9.82591326180785, -2.8226127713774, 0.0, 0.0, 1.59872115546023e-14, 0.0, -2.8421709430404e-14, 0.0, 1.59872115546023e-14, 11.6081867662438, -3.09487177319465, 0.683876505540213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.80966353013901e-14, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.24344978758018e-14, 1.26565424807268e-14, -1.28785870856518e-14},
      {2.29782505861522, 0.0, 1.49829835452875, 5.50917601898536, 0.0, -2.22044604925031e-14, 1.06581410364015e-14, 0.0, 6.64803945320939, 4.13676892548485, 0.0, -1.50990331349021e-14, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 12.5636136423841, -3.55352656109505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0},
      {1.87616630392935, 0.0, 0.0, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722505, 1.11022302462516e-14, -4.41087092453693, -3.11895674167862, 16.6749979177077, 1.24344978758018e-14, 3.28626015289046e-14, 2.13065307820926, 1.73967095350095, 1.23013312825379, 0.0, -4.3665394383501, -3.78153408023781, 2.26485497023532e-14, 1.77635683940025e-14, 0.0, -0.557935943461964, -0.483186700722515, -0.394520289089674, -0.278967971730998, 23.6981011897578, 0.0, 0.0, 0.490653381462662, 0.438853725736256, 0.380058475033046, 0.0, 0.0, 0.0, 0.0, 0.0626933893908896, 0.0560746721671598, 0.0485620906056359, 0.0396507809422184, 0.0280373360835746, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139875, 0.0, 0.0, 1.4210854715202e-14, 10.5706241650196, -2.72554057547702, 0.0, 1.59872115546023e-14, 0.0, 4.67332857821918, -3.37507799486048e-14, 0.0, -7.86705867811455, -2.39719223514613, 0.618094504365233, 1.4210854715202e-14, 1.06581410364015e-14, 1.99840144432528e-14, 0.0, 0.0, 23.1055548876599, -0.46968719442418, 0.0, 0.0, 0.0, 1.62065746295904, 0.790669146636833, 0.24092688467677, -0.0621208350290869, 1.06581410364015e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 3.5527136788005e-14, 0.0, 0.0, -2.1316282072803e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {4.30766533554561e-14, 6.30840061880559, 1.19904086659517e-14, 0.0, 0.0, -1.5236235005501, 11.1963004093827, 0.0, 1.08801856413265e-14, 0.0, 4.2661458015403, 0.0, 1.06581410364015e-14, 0.132992762321605, -4.72217953828913, -6.6768459701302, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560573, 1.11125127955291, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {3.85449644663771, 2.66453525910038e-14, 5.98171817966646, -2.48806675764058, 1.90029237516522, 0.0, 2.75335310107039e-14, -0.339934634239505, -2.35922146606164, 0.981306762925306, 0.0, 9.95226703056237, -0.430945803685665, 0.0, 0.0, 2.1316282072803e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879208, -0.222539456105662, 0.0, 1.28785870856518e-14, 0.0, 21.5273297444417, -1.00024047132728, 0.0433116829031295, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442917, -0.00774782937530993, -0.0537716476536598, 0.0223660568773474, 0.0, -1.59872115546023e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02140518265514e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274499, 0.0, 1.92724822331889, 2.72554057547701, 1.73472166622177, 2.35367281220533e-14, 0.0, -2.01705689521108, 3.42052627529743, -4.03112887414927, 0.0, 4.08831086321547, 5.37643791520788, 0.0, 0.0, 0.0, 0.365669640132041, -6.25148194071024, -2.03981013744547, 1.80803322065281, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.26521523890981, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 1.98456380761454, 1.4711357857929, 0.363818136386337, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0},
      {3.14718316987778, 1.77635683940025e-14, -0.861891607371342, 6.09449400220045, 1.55158222708543, 2.66453525910038e-14, 4.44089209850063e-14, 0.0693888666488727, -3.0594117081557, 1.80277563773198, -1.4210854715202e-14, 0.0, 9.0312215653788, 0.0, -4.13002965160558e-14, -1.4210854715202e-14, 0.0, 0.403888506800969, -3.67461994579464, -5.49650682721194, 0.0, 0.0, 1.62092561595273e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.974215733960547, 1.78974858569576, 1.80791908794929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.08721928629529e-14, 0.0, -1.59872115546023e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-1.33226762955019e-14, 1.54523626091313, 0.0, 0.0, -1.06581410364015e-14, 6.71778024562962, -0.609449400220044, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.6593983227032, -1.52344936219872, 0.138210132827965, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864229, -0.0138906409944095, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {5.50670620214078e-14, 1.41060126129513, -1.06581410364015e-14, 2.8421709430404e-14, -1.06581410364015e-14, 3.63405410063597, 2.50356888118886, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 3.5685702847991, 11.263055412878, -1.49298814645065, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124154, 0.266287609379566, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14},
      {-4.35207425653061e-14, 1.26168012376111, -3.28626015289046e-14, -1.4210854715202e-14, 0.0, 1.42204860051343, 4.47852016375309, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 1.24344978758018e-14, 8.27725128825316, 5.37909280973864, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 1.46549439250521e-14, 19.9654813226339, -2.61992366301006, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.30926389122033e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 1.77635683940025e-14, 0.0, -1.4210854715202e-14},
      {6.52811138479592e-14, 1.09264703862704, 1.77635683940025e-14, 2.04281036531029e-14, 0.0, -1.59872115546023e-14, 5.38682254607087, -1.11022302462516e-14, 0.0, 0.0, -1.50990331349021e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 13.4377817958113, 1.19904086659517e-14, 0.0, 1.59872115546023e-14, 2.39808173319034e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.3988810110277e-14, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03111963412061e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752226, 2.1316282072803e-14, 7.37120708415869, -1.62882203585591, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050878, 0.642416074439627, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882094426, -2.72522906732404, 0.659300804656284, -0.145686271816935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790433, -0.0662622240310449, 0.014642021234016, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.7842851423995, 0.0, 1.37667655053519e-14, 0.0, 4.26614580154032, 7.83741028656786, -2.63899331455874, 0.0, 0.0, 1.06581410364015e-14, -1.24344978758018e-14, -2.1316282072803e-14, 0.0, 2.23427840700305, 13.2221027072096, -4.67379217909107, 1.1836355846623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 1.77635683940025e-14, 12.1258851598178, -3.11150358274814, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, -2.66453525910038e-14, 1.84297022087776e-14, -1.56541446472147e-14, 1.64313007644523e-14, 0.0},
      {2.06031501455083, 0.0, 2.25696201807216, 3.98978286964828, 0.0, -1.95399252334028e-14, 0.0, 0.95393920141694, 8.01142041980429, 1.18019368870418, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.48689957516035e-14, 0.0, -1.59872115546023e-14, 5.55254896421455, 9.62241374388481, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239955, 0.0, 0.814411017927952, 5.06770487035907, 0.0, 1.50990331349021e-14, 2.48689957516035e-14, 0.0, 4.0151004652476, 6.58672305740269, 0.0, 1.59872115546023e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.22044604925031e-14, -2.22044604925031e-14, 10.0159311874144, 2.83293314500739, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.59872115546023e-14, 0.0, 14.0929454377398, -4.55552790213388, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0},
      {1.4568627181694, 0.0, 1.50990331349021e-14, 5.07816454066241, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 10.0142755247554, 0.0, 0.0, 1.95399252334028e-14, 0.0, -1.50990331349021e-14, 0.0, 0.0, 3.84137166520304e-14, 0.0, 13.8784813613723, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 12.5535587278944, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.08721928629529e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505168, 0.0, 0.0, 0.0, 1.08801856413265e-14, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.11074344166795e-14, 0.0, -1.24344978758018e-14, 0.0, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154979, 5.61248608016091, -1.08012344973464, -0.763762615825974, 1.4210854715202e-14, 0.0, 1.88737914186277e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747789, 7.24568837309472, 4.18330013267039, -0.591607978309975, 1.59872115546023e-14, 0.0, 1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.59872115546023e-14, -2.39808173319034e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338699, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079296, 0.683130051063951, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26010313294955e-14, 0.0, 0.0, -1.75415237890775e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920396, 0.0, 0.0, 7.52994023880668, 0.0, -1.59872115546023e-14, 0.0, 0.0, 1.93178806284777e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 2.06501482580279e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.19999999999999, -0.979795897113268, 0.346410161513774, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, -2.30926389122033e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474623, -1.0, 9.16515138991168, 7.09929573971953, -0.414039335605426, -2.04939015319192, -0.47809144373374, 0.169030850945719, 0.0, 1.4210854715202e-14, 0.0, -1.55431223447522e-14, 0.0, 0.0, 1.82076576038526e-14, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355963, -0.408248290463876, 3.17542648054293, 1.24344978758018e-14, 0.0, 7.17137165600638, 0.0, -1.3801311186847, -1.56144011671766, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 1.60982338570648e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0547118733939e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000003, -5.69209978830308, 4.38178046004134, -0.77459666924149, 1.06581410364015e-14, 10.998181667894, 0.962140470884719, 4.76235235991628, -0.740656079818033, 0.1309307341416, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.34336985979644e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681193, 2.73861278752581, 1.58113883008417, 2.45967477524974, 1.24344978758018e-14, 0.0, 9.25820099772552, 1.15463194561016e-14, 5.34522483824851, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, -1.7874590696465e-14, -2.04281036531029e-14, 0.0, 1.11022302462516e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, -1.04360964314765e-14, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, -1.4210854715202e-14, -3.16227766016838, -2.23606797749981, 0.0, 0.0, 0.0, 13.7477270848675, 0.534522483824846, 0.377964473009211, -4.2632564145606e-14, -2.44804176929847e-14, 1.06581410364015e-14, 0.0, -1.99840144432528e-14, 0.0, -1.06581410364015e-14, -1.77635683940025e-14, 2.72837308301632e-14, -2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.85407245112401e-14, 0.0, 0.0, 0.0},
      {-1.80000000000005, -1.4210854715202e-14, 3.65148371670111, -2.84018778721881, 0.0, -1.46549439250521e-14, -4.61852778244065e-14, 1.93178806284777e-14, 12.3442679969674, 1.39659449751036, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -2.53130849614536e-14, -3.37507799486048e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.20454076850486, 0.0, -1.82076576038526e-14, 6.64078308635358, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.37667655053519e-14, -1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473995, -2.01017818278145, -1.42141062443802, 8.14215222512713, -2.1022946646802, -1.716516405814, 0.728256234341412, 0.594618725379086, 0.420458932936051, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920587, 0.264864231681981, 0.216260739578377, -0.105945692672788, -0.0917516612761675, -0.0749149177264213, -0.0529728463363905, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239556, 3.07059789431495, 1.77281052085586, -1.253566341056, 2.39356776939085, 6.30376871403132, -0.908295106229257, -2.78313372537745, -0.524404424085068, 0.370809924354789, 11.1242977306435, 9.40174755792013, -0.301561193523245, -2.42752078113806, -0.794200206656965, 0.114434427054267, 0.840917865872086, 0.350641890608844, 0.0660687472643463, -0.0467176592151064, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047605, 2.74642624930238, -0.792824967172093, 2.24244764232554, 2.1408720964442, -0.331662479035522, 6.49923072370877, 0.0957427107756317, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331467, 0.0, -1.46249406456537, -2.04706526287664, 0.0, 0.422185670932522, 0.590936840285272, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747037, 3.74574588632196, -1.05945692672795, -8.09173593712688, 5.01426536422406, -0.383824736789357, 1.80936716113937, -1.10800657553491, 0.313391585263999, 1.4210854715202e-14, 12.7134831207354, 1.01946290306867, 8.20651806648288, -0.631738055305799, 0.04835737145617, -2.84282124887605, -0.227958835180086, 0.139595707137604, -0.0394836284566157, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715532, 1.16057691494798, 1.34011878852098, 1.89521416591737, 2.53311402559512, 1.96214168703485, 2.74642624930236, -0.566421515598876, 3.17129986868839, -1.82198870938949, 0.0, 0.0, 11.169982923824, 0.0, 8.65223156827827, -0.865042958313584, 0.0, -2.49768411251821, -0.998865569685883, 0.441440386136648, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139072, -0.193429485824675, 3.55615782880926, 0.0, 0.0, 4.45964044034304, 0.0, -0.858258202906989, 2.67027285925186, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 7.03562363973515, 4.062019202318, -0.820651806648287, 0.0, -6.79705818718656, -2.08116553882674, 5.88642506110459, -1.20156148406978, 0.242752078113808, 0.0, -2.48689957516035e-14, 0.0, 14.8323969741913, 0.85634883857767, 0.262202212042543, 5.13809303146607, -0.741619848709579, 0.151382517704907, -0.0305838870920616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, -1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02060590481778e-14, 0.0, 0.0, 0.0},
      {1.3266499161422, -2.69693703815182, 2.07610309995256, 1.46802658041887, -1.4210854715202e-14, 3.03973683071411, -6.38211787508103, 1.31624465810882, 4.91295663090392, -1.41130638568869, 0.0, 0.0, 1.24344978758018e-14, 0.0, 13.4039795085887, 2.01017818278146, 0.0, 5.80409338312192, -1.54743588659734, 0.341938252770117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 1.25784799243078e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747034, 0.749149177264372, 2.75458800949269, 0.0, 0.0, 5.75737105184056, 0.0, 3.3240197266047, 2.06838446274243, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.50990331349021e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119208, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.938083151964674, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431068, 0.0, 9.3808315196469, 1.89521416591739, 1.59872115546023e-14, 1.3988810110277e-14, -1.59872115546023e-14, -3.39852909359328, -2.77488738510232, -0.560611910581392, 0.0, 0.0, 0.0, 3.19744231092045e-14, 2.1316282072803e-14, 0.0, 17.7988763690296, 0.428174419288847, 0.349602949390063, 0.0706304617818837, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102537, 0.0, -1.49829835452877, 4.2378277069118, -1.14352971536391e-14, 1.33226762955019e-14, 1.59872115546023e-14, 3.79967103839266, -3.54562104171171, -4.07409060843206, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.66453525910038e-14, 0.0, 0.0, 16.7549743857359, 1.11676565710086, 0.987090711415302, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.82076576038526e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, -1.59872115546023e-14, 0.0, 1.54876111935209e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0},
      {-1.32664991614217, -1.06581410364015e-14, 1.73008591662713, -3.18072425757423, 0.0, 0.0, 0.0, 0.0, 7.67649473578737, -2.38836465270396, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, -1.54321000422897e-14, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {1.62480768092717, 0.0, 0.0, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226845, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.2598988599366, 1.06532653910462, 0.869835476750477, 0.615066564126897, 10.333118277332, -2.18326971917504, -1.89076704011891, 0.724780051083758, 0.627677936394714, 0.512496888990047, -0.278967971730972, -0.241593350361249, -0.197260144544823, -0.139483985865491, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.219426862868129, 0.190029237516521, -0.0814411017927963, -0.0728431359084647, -0.0630840061880511, -0.0515078753637643, 0.0313466946954457, 0.0280373360835794, 0.0242810453028186, 0.0198253904711077, 0.0140186680417866, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069939, 0.997445717412049, -1.41060126129509, 3.23209352764251, 5.28531208250979, -1.36277028773849, -2.89087233497828, -0.393397896234728, 0.556348640264166, 2.33666428910959, 9.02784807228865, -0.732969916135152, -3.93352933905727, -1.19859611757306, 0.309047252182626, 1.64018416088946, 0.655588223176213, 0.0892142571199814, -0.126168012376114, 13.0996183150503, 11.55277744383, -0.234843597212093, -2.44096975264613, -0.907332870306512, 0.0736662483163202, 0.810328731479521, 0.395334573318418, 0.120463442338388, -0.0310604175145452, -0.311895674167854, -0.164844710568315, -0.065889095553074, -0.00896637020658053, 0.0126803623514062, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482417, 3.15420030940279, -1.09264703862701, 1.54523626091313, 2.95048422176041, -0.761811750275049, 5.59815020469132, 0.263899331455868, -1.93925611658548, -2.28543525082516, 2.13307290077015, -0.257539376818855, 9.14446135479766, 0.0664963811607955, -2.36108976914457, -3.3384229850651, -0.0230350221379907, 0.817905488277901, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280282, 0.555625639776457, 0.595437196138651, 0.0, -0.125015768949703, -0.192474367616157, -0.206265495285708, -0.166687691932938, 0.0, 0.0, 0.0, 0.0, 1.63202784619898e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331885, 1.82834820066016, 2.99085908983323, -1.24403337882028, 0.950146187582625, 5.74064456311311, -0.721110255092799, -0.169967317119739, -1.17961073303082, 0.490653381462648, -10.3037210107158, 4.97613351528116, -0.215472901842822, 5.78174466995661, -1.30185581821819, 0.163532434528632, -3.22682211353225, 0.0385449644663689, 0.267510569439618, -0.111269728052833, 0.0, 14.5551314611669, 1.03556292536503, 10.7636648722209, -0.500120235663644, 0.0216558414515656, -3.5732138395088, -0.581087203147981, 0.130841432732453, -0.0164356280722686, 1.37533064807501, 0.324307824721444, -0.0038739146876523, -0.0268858238268335, 0.0111830284386731, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637254, 1.66904592079256, 0.963624111659453, 1.36277028773852, 0.867360833110869, 2.28430636201793, 2.96226264871971, -1.00852844760554, 1.71026313764872, -2.01556443707463, 2.41867732448957, 2.04415543160773, 2.68821895760395, -0.527798662911744, 7.0797705325562, -1.76652739792483, 0.182834820066024, -3.12574097035512, -1.01990506872274, 0.904016610326402, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.632607619454904, 0.0, -2.86447112137562, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807272, 0.735567892896454, 0.181909068193169, -0.147004726489971, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493887, 1.49284005458435, -0.430945803685678, 3.04724700110022, 0.775791113542715, -0.120185042515443, 5.29905651979674, 0.0346944333244396, -1.52970585407785, 0.901387818865995, 0.0, 0.0, 4.51561078268941, 0.0, -0.699555414372442, 6.36462844462228, 0.0, 0.201944253400485, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.0999354831996, 0.0, 0.0, 0.48710786698027, 0.894874292847875, 0.903959543974644, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456571, 3.86595114186568, -1.05140010313425, 9.15442906076461, 3.35889012281483, -0.304724700110018, 3.87851223317102, -1.52475169285615, 0.414677792940093, 0.0, -9.46260092820844, -2.07602937339136, 7.32969916135159, -0.761724681099357, 0.0691050664139832, 0.564240504518073, -0.879563899362202, 0.345781182036212, -0.0940400840863393, 1.24344978758018e-14, 0.0, 0.0, 16.3745228938128, 0.951027176355639, 0.208648802584718, 9.05975063854701, -0.736662483163209, 0.0765562109321241, -0.00694532049720387, -3.48709964663733, -0.0567083043941681, 0.0883994979795857, -0.0347523163751426, 0.0094513840656914, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.72639680329212e-14, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647572, 2.03602754481989, 1.15175110689981, -2.93221479395417, 1.81702705031799, 1.25178444059444, 0.655663160391211, 3.61359041872285, -1.70346285967313, 0.0, 2.76420265655949, -9.08783875864327, 1.78428514239955, 5.63152770643901, -0.746494073225317, -0.61809450436524, 2.03210252328835, -2.1549427706255, 0.764033484562609, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462396, 0.0, 9.68367982311022, -1.32524448062076, 0.133143804689784, 0.0, -3.35452509157129, -0.478206411017784, 0.384353057392899, -0.124241670058193, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321606, 0.630840061880555, 0.728431359084658, 2.57539376818857, 0.917928424547676, 0.711024300256717, 2.23926008187655, -0.205255035576783, 2.58567482211399, 0.761811750275047, 0.0, 0.0, 5.34294273196309, 1.64313007644523e-14, 4.13862564412655, 2.68954640486932, 0.0, -1.1947183148558, 3.10562068169859, -2.32269806558126, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150502, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692614, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {1.15175110689981, 0.546323519313515, -0.105140010313423, 3.27118942773251, 0.0, -1.4432899320127e-14, 2.69341127303543, 0.0, -0.518347241175131, 4.25171145123352, 0.0, 0.0, 0.0, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618717, 1.82865048192214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, -6.78263087840207, 3.68560354207936, -0.814411017927963, 0.0, 10.0216907612581, 2.6751056943961, 6.00856531485323, -1.45362164025438, 0.321208037219805, 0.0, 1.06581410364015e-14, 0.0, -7.57008074256671, -2.27270584034423, -0.606656948415845, 6.99294104721298, -1.36261453366202, 0.329650402328139, -0.0728431359084718, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.76082174108452, 0.228415531250655, 0.0609713174047712, 5.40219154319687, -0.702817019232752, 0.136947913395214, -0.033131112015524, 0.00732101061700607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {1.1517511068998, 3.8242646351946, 2.20794021658197, 0.89214257119975, 0.0, -2.46306042692148, 6.78739640804926, 2.13307290077016, 3.91870514328394, -1.31949665727938, 0.0, 0.0, 1.24344978758018e-14, 3.22490309931941, -7.63378455726035, -4.04762275910192, 1.11713920350154, 6.61105135360477, -2.33689608954553, 0.591817792331161, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108412, 0.721929233499941, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297045, -0.0962371838080758, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.29677388219329e-14, -1.11022302462516e-14, 0.0, 0.0},
      {1.03015750727542, -1.46593983227032, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945719, -5.20357020296095, 0.476969600708463, 4.00571020990213, 0.590096844352084, 0.0, 1.4210854715202e-14, 0.0, 1.59872115546023e-14, 6.41153127835566, -6.24994106094659, 0.0, 2.77627448210727, 4.81120687194239, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.0440762145518, 0.0, 0.0, 6.69662601613678, -2.34333096254028, 0.591780433634506, 0.0, 0.0, 0.0, 0.0, -1.36557432028894e-14, -1.24344978758018e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0},
      {0.89214257119982, 0.705300630647558, 0.407205508963991, 2.53385243517955, 0.0, 0.0, 3.4771790016512, -1.11022302462516e-14, 2.0075502326238, 3.29336152870135, -1.04360964314765e-14, 1.4210854715202e-14, 1.04360964314765e-14, -1.68753899743024e-14, 0.0, 8.67405085085771, 1.95399252334028e-14, 0.0, 5.00796559370721, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.7284313590847, 0.0, 0.0, 2.5390822703312, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.92068583260152e-14, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359278, 2.1316282072803e-14, -4.65474668125634, -3.29140294302191, 0.0, -2.1316282072803e-14, 0.0, 13.490737563232, 1.83585684909536, 1.29814682728312, 1.4210854715202e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, -3.53270434653113, -3.0594117081557, -0.416333199893252, -0.294392028877592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 21.8326971917504, 0.355050145839433, 0.307482445914332, 0.0418430609640592, 0.0295875121532911, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.14352971536391e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.89848137210902e-14, 0.0},
      {-2.65985524643215, 0.0, 5.0990195135928, -2.06031501455083, 1.06581410364015e-14, 1.92623694772465e-14, 0.0, -1.23153021346074, 9.04986187739902, 3.04724700110021, 0.0, 0.0, -1.15463194561016e-14, 0.0, 2.8421709430404e-14, 0.0, 3.86988371918332, -3.81689227863017, -5.39683034546924, -1.36674464685442, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 21.00264918355, 0.89821371554206, 0.962572311333261, 0.222250255910583, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {2.9738085706659, 0.0, -0.814411017927952, 5.75875553449897, -1.4210854715202e-14, 1.68753899743024e-14, 1.77635683940025e-14, 1.3768926368215, -2.89087233497831, 1.70346285967312, -1.4210854715202e-14, 2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 8.01441409794462, -3.47218947830364, -5.19371076584692, 0.0, 0.0, 0.0, 0.0, 0.0, -1.40339129206524e-14, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.06581410364015e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.03015750727538, 0.0, 0.940400840863429, -2.92584077107539, -1.58761892521397e-14, 2.1316282072803e-14, 3.90798504668055e-14, 0.0, 4.6362386688682, -3.80284633026898, 0.0, 2.1316282072803e-14, 0.0, -1.06581410364015e-14, -1.33226762955019e-14, -1.4210854715202e-14, 1.59872115546023e-14, 0.0, 11.565401134477, -1.63559471386625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376115, 0.0, 1.06581410364015e-14, 4.39781949681097, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67261700493489, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 3.21964677141295e-14, 0.0, 12.0191174248973, 0.0, 0.0, 1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494324, -1.06581410364015e-14, 0.0, 0.0, 1.12687636999453e-14, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, -1.03823200037212e-14, 1.06581410364015e-14, 0.0, 0.0, 1.83186799063151e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154979, 5.61248608016091, -1.08012344973464, -0.763762615825974, 1.4210854715202e-14, 0.0, 1.88737914186277e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267039, -0.591607978309967, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338696, 7.09929573971953, 0.0, 4.34741302385682, 0.0, 0.0, 2.62012633811537e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -2.38697950294409e-14, -1.24344978758018e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231719, -0.341565025531991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, -1.06581410364015e-14, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912985, 0.0, -1.4210854715202e-14, 8.87411967464942, -1.33226762955019e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.19999999999999, -0.979795897113268, 0.346410161513774, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, -2.30926389122033e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474621, -0.999999999999998, 1.30930734141597, 7.09929573971953, -0.41403933560541, -2.04939015319192, -0.47809144373375, 0.169030850945708, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355963, -0.408248290463859, 3.17542648054292, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868468, -1.56144011671765, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.53210777398272e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033672, 4.38178046004134, -0.774596669241495, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991628, -0.740656079818042, 0.130930734141602, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, -1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.558845726812, 0.547722557505154, 1.5811388300842, 2.45967477524977, 1.06581410364015e-14, 9.07114735222144, 1.85164019954509, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.48689957516035e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613576, -6.26099033699941, -3.19744231092045e-14, 3.83405790253614, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872627, 0.0, 0.0, 0.0, 2.30926389122033e-14, 1.50990331349021e-14, 1.06581410364015e-14, -1.46549439250521e-14, 0.0, -1.33226762955019e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.28785870856518e-14},
      {1.03923048454132, 0.0, 3.16227766016838, -0.44721359549997, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824846, 0.0755928946018467, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.899999999999991, 0.0, 1.46059348668044, 1.42009389360937, -1.04360964314765e-14, 0.0, -1.24344978758018e-14, 9.07114735222146, 4.93770719878696, -0.698297248755177, 0.0, -2.30926389122033e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283493, -1.06581410364015e-14, -6.26099033699942, 2.21359436211786, 0.0, -2.48689957516035e-14, -1.77635683940025e-14, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497725, 0.0, 0.0, -4.69574275274956, 1.55431223447522e-14, 0.0, 0.0, 0.0, -2.04281036531029e-14, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.84297022087776e-14, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473995, -2.01017818278145, -1.42141062443802, 8.14215222512713, -2.1022946646802, -1.716516405814, 0.728256234341412, 0.594618725379086, 0.420458932936051, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920587, 0.264864231681981, 0.216260739578377, -0.105945692672788, -0.0917516612761675, -0.0749149177264213, -0.0529728463363905, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239553, 3.07059789431495, 1.77281052085585, -1.25356634105601, 2.39356776939085, 6.30376871403131, -0.908295106229241, -2.78313372537744, -0.524404424085075, 0.370809924354784, 1.23603308118261, 9.40174755792012, -0.30156119352323, -2.42752078113806, -0.794200206656987, 0.114434427054268, 0.840917865872094, 0.35064189060884, 0.0660687472643411, -0.0467176592151075, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930236, -0.792824967172092, 2.24244764232555, 2.1408720964442, -0.331662479035516, 6.49923072370876, 0.0957427107756361, -1.87616630392935, -2.155806113731, 11.0554159678513, 0.0, 9.44035859331466, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932523, 0.590936840285276, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551269, 1.29756443747036, 3.74574588632198, -1.05945692672795, 0.404586796856334, 5.01426536422407, -0.383824736789376, 1.80936716113937, -1.10800657553489, 0.313391585264009, 0.0, 2.82521847127455, -0.0509731451534301, 8.20651806648287, -0.631738055305791, 0.0483573714561656, -2.84282124887605, -0.227958835180068, 0.139595707137609, -0.0394836284566193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715533, 1.16057691494799, 1.34011878852097, 1.89521416591738, 0.361873432227869, 1.96214168703484, 2.74642624930238, -0.566421515598876, 3.17129986868839, -1.8219887093895, -1.4210854715202e-14, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313571, 0.0, -2.4976841125182, -0.998865569685877, 0.441440386136653, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03667074924374e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741912, 1.00508909139074, -0.193429485824681, 3.55615782880926, -8.46157280212811, 0.0, 4.45964044034304, 0.0, -0.858258202907004, 2.67027285925185, -1.06581410364015e-14, 0.0, 12.4373429638328, 0.0, 0.0, 8.42792824422443, 0.0, -1.4210854715202e-14, -1.62195554683795, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {1.48323969741915, 0.335029697130246, 4.062019202318, -0.820651806648291, 0.0, 1.69926454679665, -0.0991031208965167, 5.88642506110459, -1.20156148406979, 0.242752078113808, 0.0, -1.4210854715202e-14, 0.0, 4.94413232473044, -0.214087209644421, 0.0124858196210749, 5.13809303146607, -0.741619848709576, 0.151382517704897, -0.0305838870920701, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0},
      {1.32664991614215, 0.299659670905749, 2.07610309995255, 1.46802658041886, 0.0, 0.86849623734689, 0.709124208342313, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, 0.0, 1.15463194561016e-14, 11.0554159678513, 3.82970843102535, -0.223353131420168, 0.0, 5.80409338312193, -1.54743588659732, 0.341938252770108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930759, 0.25951288749407, 0.749149177264341, 2.75458800949268, 0.0, -8.46157280212812, 1.15147421036812, 0.0, 3.32401972660469, 2.06838446274242, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552748, -2.30926389122033e-14, -1.46549439250521e-14, 6.28180682119207, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0},
      {0.938083151964733, 7.62808987244124, 2.30926389122033e-14, 3.11415464992887, -1.4210854715202e-14, 0.0, -7.52139804633608, -1.53210777398272e-14, -1.90958360235527e-14, 5.52707620976691, 0.0, 0.0, 3.01980662698043e-14, -1.06581410364015e-14, 0.0, 14.2141062443803, 1.75415237890775e-14, 1.46549439250521e-14, 2.30926389122033e-14, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.08801856413265e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.85634883857769, 0.0, 2.68023757704198, -0.473803541479342, 0.0, 0.0, 0.0, 5.09779364038994, -0.792824967172092, 0.140152977645352, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 7.91061171956872, -0.642261628933266, 0.0998865569686012, -0.0176576154454726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205073, 1.50990331349021e-14, 1.49829835452881, 0.847565541382361, 0.0, 0.0, -1.24344978758018e-14, 1.62843044502543, 3.54562104171166, -0.814818121686415, 0.0, -2.1316282072803e-14, 0.0, 1.06581410364015e-14, -1.77635683940025e-14, 0.0, 11.0554159678513, 7.18070330817252, -1.11676565710081, 0.197418142283057, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071061, 0.0, 0.692034366650857, 1.5903621287871, 0.0, 0.0, 0.0, -8.46157280212813, 3.07059789431492, 1.19418232635197, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 0.0, 1.06581410364015e-14, 12.4373429638327, 5.80288457473996, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309085, 1.95399252334028e-14, 7.62808987244126, 1.79795802543455, 0.0, 1.77635683940025e-14, 2.66453525910038e-14, 0.0, -7.52139804633613, 3.19105893754049, 0.0, 1.59872115546023e-14, 0.0, -1.06581410364015e-14, -1.4210854715202e-14, 0.0, 1.38222766565832e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343547, -1.06581410364015e-14, 0.0, 8.8994381845148, 0.0, 0.0, -1.99840144432528e-14, 0.0, 0.0, -5.26497863243525, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 3.01703106941886e-14, -1.06581410364015e-14, 16.583123951777, 0.0, 1.06581410364015e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226845, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.2598988599366, 1.06532653910462, 0.869835476750477, 0.615066564126897, 10.333118277332, -2.18326971917504, -1.89076704011891, 0.724780051083758, 0.627677936394714, 0.512496888990047, -0.278967971730972, -0.241593350361249, -0.197260144544823, -0.139483985865491, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.219426862868129, 0.190029237516521, -0.0814411017927963, -0.0728431359084647, -0.0630840061880511, -0.0515078753637643, 0.0313466946954457, 0.0280373360835794, 0.0242810453028186, 0.0198253904711077, 0.0140186680417866, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069937, 0.997445717412068, -1.4106012612951, 3.23209352764251, 5.28531208250978, -1.36277028773851, -2.89087233497829, -0.393397896234702, 0.556348640264184, 2.33666428910959, 9.02784807228867, -0.732969916135151, -3.93352933905729, -1.19859611757307, 0.309047252182623, 1.64018416088946, 0.655588223176228, 0.0892142571199894, -0.126168012376106, 1.1908743922773, 11.55277744383, -0.23484359721209, -2.44096975264614, -0.907332870306508, 0.0736662483163188, 0.810328731479525, 0.395334573318413, 0.120463442338387, -0.0310604175145479, -0.311895674167861, -0.16484471056832, -0.0658890955530715, -0.00896637020658542, 0.0126803623514078, 0.0, -1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.15420030940282, -1.09264703862703, 1.54523626091314, 2.95048422176041, -0.761811750275041, 5.59815020469135, 0.26389933145588, -1.93925611658551, -2.28543525082518, 2.13307290077015, -0.257539376818862, 9.14446135479766, 0.0664963811608148, -2.36108976914457, -3.33842298506509, -0.0230350221379905, 0.817905488277889, 1.15646364545769, 1.02505848514081, 13.0453753561106, -1.06581410364015e-14, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280284, 0.555625639776453, 0.595437196138652, 0.0, -0.125015768949702, -0.192474367616161, -0.206265495285703, -0.166687691932942, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331887, 1.82834820066016, 2.99085908983324, -1.24403337882028, 0.950146187582611, 5.74064456311311, -0.721110255092788, -0.169967317119747, -1.17961073303083, 0.490653381462657, 0.294392028877589, 4.97613351528118, -0.215472901842833, 5.78174466995659, -1.30185581821819, 0.163532434528633, -3.22682211353225, 0.0385449644663698, 0.267510569439609, -0.111269728052829, 0.0, 2.646387538394, -0.0295875121532863, 10.7636648722209, -0.500120235663637, 0.0216558414515671, -3.57321383950878, -0.581087203147985, 0.130841432732454, -0.0164356280722704, 1.375330648075, 0.324307824721454, -0.00387391468765275, -0.0268858238268313, 0.0111830284386747, 0.0, -1.12132525487141e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637247, 1.66904592079256, 0.963624111659419, 1.3627702877385, 0.86736083311089, 2.28430636201794, 2.96226264871971, -1.00852844760553, 1.71026313764872, -2.01556443707464, 0.268741924943306, 2.04415543160771, 2.68821895760394, -0.527798662911731, 7.07977053255619, -1.76652739792483, 0.182834820066017, -3.12574097035512, -1.01990506872274, 0.904016610326408, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.63260761945491, 0.0, -2.86447112137561, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807264, 0.735567892896449, 0.18190906819317, -0.14700472648997, 0.0, -1.46549439250521e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493893, 1.49284005458437, -0.430945803685665, 3.04724700110023, 0.775791113542702, -0.120185042515462, 5.29905651979674, 0.0346944333244372, -1.52970585407785, 0.901387818865993, -10.576283741361, 0.0, 4.51561078268942, 0.0, -0.699555414372433, 6.36462844462228, 1.13242748511766e-14, 0.201944253400482, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.0999354831996, 0.0, 0.0, 0.487107866980275, 0.894874292847873, 0.903959543974647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.6288220358559, 0.772618130456564, 3.86595114186567, -1.05140010313427, 0.160604018609902, 3.35889012281482, -0.304724700110016, 3.87851223317101, -1.52475169285615, 0.414677792940088, 0.0, 1.135512111385, -0.036421567954231, 7.32969916135159, -0.761724681099368, 0.0691050664139842, 0.564240504518043, -0.879563899362195, 0.345781182036201, -0.0940400840863452, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162677, 0.00366050530850393, 9.05975063854701, -0.736662483163211, 0.0765562109321194, -0.00694532049720442, -3.48709964663733, -0.056708304394161, 0.0883994979795864, -0.0347523163751426, 0.00945138406568952, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647578, 2.03602754481989, 1.15175110689981, 0.146610739697699, 1.81702705031798, 1.25178444059442, 0.655663160391217, 3.61359041872285, -1.70346285967312, 0.0, 0.614267257013196, 0.454391937932176, 1.78428514239956, 5.63152770643901, -0.746494073225321, -0.618094504365239, 2.03210252328834, -2.15494277062552, 0.764033484562615, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865873, -0.106930204231203, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689784, 0.0, -3.3545250915713, -0.478206411017786, 0.384353057392905, -0.124241670058189, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880574, 0.728431359084674, 2.57539376818857, 0.131132632078232, 0.71102430025673, 2.23926008187657, -0.205255035576797, 2.58567482211399, 0.761811750275044, 1.24344978758018e-14, -10.576283741361, 0.763277533137597, 1.4210854715202e-14, 4.13862564412657, 2.68954640486933, 1.26565424807268e-14, -1.1947183148558, 3.10562068169861, -2.32269806558127, 0.0, -1.15463194561016e-14, 0.0, 0.0, 14.3499128917217, 1.84109468241848, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692603, 0.0, 0.0, 0.0, 1.59872115546023e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.23234755733392e-14, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -1.4210854715202e-14},
      {1.1517511068998, 0.546323519313524, -0.105140010313422, 3.27118942773251, 9.65295620481433, 0.0, 2.69341127303544, 0.0, -0.518347241175148, 4.25171145123352, 0.0, 0.0, -9.91526600752596, 0.0, -1.95399252334028e-14, 6.71889089790562, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 2.66453525910038e-14, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059453, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, 0.19948914348242, 3.68560354207935, -0.814411017927956, 0.0, 1.0278657191034, -0.078679579246943, 6.00856531485323, -1.45362164025439, 0.32120803721981, 0.0, 0.0, 0.0, 3.0280322970267, -0.233098034907102, 0.0178428514239943, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433803, 0.0234272339744288, -0.00179327404131557, 5.40219154319687, -0.702817019232747, 0.136947913395217, -0.0331311120155244, 0.00732101061700707, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {1.15175110689979, 0.182107839771167, 2.20794021658197, 0.892142571199755, 0.0, 0.615765106730371, 0.323209352764241, 2.13307290077016, 3.91870514328394, -1.31949665727938, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 1.07496769977313, 1.90844613931507, -0.19274394090962, 1.11713920350153, 6.61105135360477, -2.33689608954553, 0.591817792331158, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771021, 0.0343775825476184, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297045, -0.0962371838080769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.84297022087776e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 1.65423230669148e-14, 0.0, 0.0, 0.0},
      {1.03015750727544, 0.162882203585596, 1.12848100903608, 1.99489143482414, -1.06581410364015e-14, 0.31471831698775, 0.578174466995661, 0.476969600708475, 4.00571020990214, 0.590096844352074, 0.0, 0.0, 1.4210854715202e-14, -10.576283741361, 1.8318660795302, 0.694437895660734, 0.0, 2.77627448210727, 4.8112068719424, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.338230690505756, -1.06581410364015e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199785, 0.141060126129506, 0.407205508963998, 2.53385243517953, 0.0, 9.65295620481433, 0.69543580033025, 0.0, 2.0075502326238, 3.29336152870134, 0.0, 1.4210854715202e-14, 0.0, 0.0, -9.91526600752598, 1.73481017017153, 2.74225087082414e-14, 0.0, 5.00796559370722, 1.41646657250368, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.04647271886991, -2.27776395106695, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {0.728431359084701, -7.94708263760857, 0.0, 2.5390822703312, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.0071377623777, -1.95399252334028e-14, 1.15463194561016e-14, -1.0325074129014e-14, 0.0, -1.59872115546023e-14, -8.49879943502225, -1.55431223447522e-14, 1.06581410364015e-14, 0.0, 6.93924068068619, 0.0, 1.09356967925578e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394722, 0.0, 0.0, 0.0, -1.33226762955019e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843135908469, 2.1316282072803e-14, 2.32737334062816, -0.470200420431695, 0.0, 0.0, 0.0, 4.49691252107736, -0.917928424547684, 0.185449546754731, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 7.0654086930623, -1.01980390271856, 0.20816659994661, -0.0420560041253566, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678878, 0.10249414863811, -0.0209215304820308, 0.00422678745047178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608056, 2.8421709430404e-14, 1.45686271816939, 0.515078753637706, 0.0, 0.0, 1.77635683940025e-14, 1.84729532019112, 2.58567482211397, -0.761811750275051, 2.1316282072803e-14, 1.95399252334028e-14, 0.0, 2.1316282072803e-14, 2.1316282072803e-14, 0.0, 1.71994831963706, 5.72533841794522, -1.54195152727694, 0.341686161713621, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.34732057331309, 0.275020660380932, -0.0555625639776363, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {0.59476171413319, 0.0, 0.814411017927931, 1.1517511068998, -1.06581410364015e-14, 1.59872115546023e-14, 2.30926389122033e-14, 0.590096844352057, 2.89087233497827, 0.340692571934625, 0.0, 1.06581410364015e-14, 0.0, -1.77635683940025e-14, -1.06581410364015e-14, 0.0, -10.576283741361, 3.43474889911912, 3.47218947830365, -1.03874215316937, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.86517468137026e-14, 1.06581410364015e-14, 0.0, 14.3499128917217, 8.28492607088318, -1.69115345252878, 0.341664592660038, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.51507875363772, 0.0, 0.376160336345357, 1.46292038553769, 0.0, 1.49324996812084e-14, 1.14352971536391e-14, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, -1.24344978758018e-14, -1.59872115546023e-14, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, -9.91526600752594, 4.62616045379078, 0.817797356933106, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 15.9443476574685, 6.50925267372302, -1.31506763029893, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {0.420560041253732, -1.28785870856518e-14, -7.94708263760857, 1.46593983227029, -1.59872115546023e-14, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497829, 0.0, 1.06581410364015e-14, 0.0, -1.15463194561016e-14, 1.95399252334028e-14, -1.24344978758018e-14, -1.68753899743024e-14, 2.58681964737661e-14, -8.49879943502226, 4.00637247496574, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.24344978758018e-14, 17.9373911146521, 3.6239002554188, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {6.54237885546504, 0.0, 1.50990331349021e-14, -6.9105066413987, -1.4210854715202e-14, 0.0, 3.90798504668055e-14, 0.0, 0.0, 12.2649325896465, 0.0, 1.02140518265514e-14, 2.48689957516035e-14, 1.06581410364015e-14, -4.2632564145606e-14, 0.0, 1.06581410364015e-14, 3.10862446895044e-14, 1.06581410364015e-14, -5.66586629001479, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 1.24344978758018e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 20.4998755596024, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, -1.7874590696465e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 1.86517468137026e-14}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[243];
      for (unsigned int r = 0; r < 243; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0