// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2008 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

// $Id: 9eaf5b28b689dde4ec24c4d8eb3e5c9163929dfc $

#ifndef SERVER_IDLE_CONNECTOR_H
#define SERVER_IDLE_CONNECTOR_H

#include "Idle.h"

#include <sigc++/signal.h>

/// \brief Generic class for polling an existing object regularly.
///
/// Emits a sigc signal every time it is called, so can be connected to
/// anything that needs calling.
class IdleConnector : public Idle {
  public:
    explicit IdleConnector(CommServer & svr);
    virtual ~IdleConnector();

    /// \brief Perform idle tasks.
    ///
    /// Called from the server's core idle function whenever it is called.
    virtual void idle(time_t t);

    sigc::signal<void> idling;
};

#endif // SERVER_IDLE_CONNECTOR_H
