/*
 * Colorblind filters
 * This is in Public Domain
 * Original Author: Daniel Ruoso <daniel@ruoso.com>
 * Here you'll find the filters used by libcolorblind.
 */
#ifndef COLORBLIND_UTILS
#define COLORBLIND_UTILS

/*
 * Utility methods
 */

/*
 * get_num_equalized:
 * return the number of equalized colors.
 * num_equalized:
 *   this is the number of colors in the same relative level.
 *   possible values are:
 *   1 - all colors in different values (994422 etc)
 *   2 - two colors equalized (882222 or 882288 etc)
 *   3 - all colors equalized (555555 etc)
 *
 */
extern int colorblind_get_num_equalized(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);

/*
 * get_num_main:
 * return the number of colors that are dominant colors.
 * num_main:
 *   this is the number of colors as a "dominant" level.
 *   possible values are:
 *   1 - the dominant color is not equalized with anyone (994422 or 882222 etc)
 *   2 - the dominant color is equalized with one color (999944 or 994499 etc)
 *   3 - all colors equalized (555555 etc)
 */
extern int colorblind_get_num_main(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);

/*
 * red_is_main:
 *   possible values are:
 *   1 - red is one of the main colors
 *   0 - red is not one of the main colors
 *
 */
extern int colorblind_red_is_main(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);

/*
 * green_is_main:
 * returns true if green is one of the main colors.
 */
extern int colorblind_green_is_main(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);

/*
 * blue_is_main:
 * returns true if blue is one of the main colors.
 */
extern int colorblind_blue_is_main(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);


#endif
