/*
 * libcolorblind - Pixel Filter for colorblind accessibility
 *
 * This is in Public Domain
 * Original Author: Daniel Ruoso <daniel@ruoso.com>
 *
 * This library provides an unified way to recalculate colors
 * in order to present alternative views on images for colorblind
 * people.
 *
 */

#ifndef COLORBLIND_FILTERS
#define COLORBLIND_FILTERS

/*
 * saturation_filters.c
 */
extern int colorblind_filter_selective_saturate_red(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);
extern int colorblind_filter_selective_saturate_green(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);
extern int colorblind_filter_selective_saturate_blue(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);
extern int colorblind_filter_selective_dessaturate_red(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);
extern int colorblind_filter_selective_dessaturate_green(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);
extern int colorblind_filter_selective_dessaturate_blue(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);
/*
 * hue_filters.c
 */
extern int colorblind_filter_hue_shift_positive(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);
extern int colorblind_filter_hue_shift_negative(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color);

#endif
