//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Plot2D/ColorMapCanvas.cpp
//! @brief     Declares class ColorMapCanvas
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Plot2D/ColorMapCanvas.h"
#include "GUI/Model/Data/IntensityDataItem.h"
#include "GUI/View/PlotUtil/ColorMap.h"
#include "GUI/View/PlotUtil/FontScalingEvent.h"
#include "GUI/View/PlotUtil/PlotStatusLabel.h"
#include <QVBoxLayout>

ColorMapCanvas::ColorMapCanvas(QWidget* parent)
    : QWidget(parent)
    , m_colorMap(new ColorMap(this))
    , m_canvasEvent(new FontScalingEvent(m_colorMap, this))
    , m_statusLabel(new PlotStatusLabel(m_colorMap, this))
{
    this->installEventFilter(m_canvasEvent);
    auto* layout = new QVBoxLayout;
    layout->setContentsMargins(0, 0, 0, 0);
    layout->setSpacing(0);

    layout->addWidget(m_colorMap);
    layout->addWidget(m_statusLabel);

    setLayout(layout);

    setStatusLabelEnabled(false);
}

void ColorMapCanvas::setIntensityItem(IntensityDataItem* intensityDataItem)
{
    m_colorMap->setIntensityItem(intensityDataItem);
}

ColorMap* ColorMapCanvas::colorMap()
{
    return m_colorMap;
}

QCustomPlot* ColorMapCanvas::customPlot()
{
    return m_colorMap->customPlot();
}

void ColorMapCanvas::setStatusLabelEnabled(bool flag)
{
    m_statusLabel->setLabelEnabled(flag);
    m_statusLabel->setHidden(!flag);
}
