//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _sphusp_7.cc
// Copyright (C) 2014 Toru Shiozaki
//
// Author: Hai-Anh Le <anh@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/ecp/sphusplist.h>

using namespace std;
using namespace bagel;

vector<double> SphUSPList::sphusp_7(const int m) {

  vector<double> c;
  constexpr double coeff[540] = {   0.000000000000000e+00,   4.950139127672173e+00,   0.000000000000000e+00,  -2.475069563836087e+01,   0.000000000000000e+00,
   1.485041738301652e+01,   0.000000000000000e+00,  -7.071627325245962e-01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   1.587576397081140e+01,
   0.000000000000000e+00,  -5.291921323603801e+01,   0.000000000000000e+00,   1.587576397081140e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -2.594577893601302e+00,   0.000000000000000e+00,   2.594577893601302e+00,   0.000000000000000e+00,
   4.670240208482342e+00,   0.000000000000000e+00,  -5.189155787202603e-01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   3.113493472321562e+01,   0.000000000000000e+00,  -6.226986944643124e+01,   0.000000000000000e+00,
   6.226986944643124e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -1.245397388928625e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   1.245397388928625e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   4.151324629762082e+01,   0.000000000000000e+00,  -4.151324629762082e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   1.408130404760646e+00,   0.000000000000000e+00,   2.346884007934411e+00,   0.000000000000000e+00,
   4.693768015868822e-01,   0.000000000000000e+00,  -4.693768015868822e-01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -2.816260809521293e+01,   0.000000000000000e+00,  -1.877507206347529e+01,   0.000000000000000e+00,
   9.387536031737644e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   3.755014412695057e+01,   0.000000000000000e+00,  -1.251671470898352e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   6.637990386674740e+00,
   0.000000000000000e+00,   1.327598077334948e+01,   0.000000000000000e+00,   6.637990386674740e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -3.540261539559861e+01,   0.000000000000000e+00,  -3.540261539559861e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   2.124156923735917e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -4.516580379125866e-01,   0.000000000000000e+00,  -1.354974113737760e+00,   0.000000000000000e+00,
  -1.354974113737760e+00,   0.000000000000000e+00,  -4.516580379125866e-01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.083979290990208e+01,   0.000000000000000e+00,   2.167958581980416e+01,   0.000000000000000e+00,
   1.083979290990208e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -2.167958581980416e+01,   0.000000000000000e+00,  -2.167958581980416e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   5.781222885281108e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -2.389949691920173e+00,   0.000000000000000e+00,
  -7.169849075760519e+00,   0.000000000000000e+00,  -7.169849075760519e+00,   0.000000000000000e+00,  -2.389949691920173e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.433969815152104e+01,   0.000000000000000e+00,   2.867939630304208e+01,   0.000000000000000e+00,
   1.433969815152104e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -1.147175852121683e+01,   0.000000000000000e+00,  -1.147175852121683e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   1.092548430592079e+00,  -4.516580379125866e-01,   0.000000000000000e+00,  -1.354974113737760e+00,   0.000000000000000e+00,  -1.354974113737760e+00,
   0.000000000000000e+00,  -4.516580379125866e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   1.083979290990208e+01,   0.000000000000000e+00,   2.167958581980416e+01,   0.000000000000000e+00,   1.083979290990208e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -2.167958581980416e+01,   0.000000000000000e+00,  -2.167958581980416e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   5.781222885281108e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   3.318995193337370e+00,   0.000000000000000e+00,
   3.318995193337370e+00,   0.000000000000000e+00,  -3.318995193337370e+00,   0.000000000000000e+00,  -3.318995193337370e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -1.770130769779930e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   1.770130769779930e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   1.062078461867958e+01,   0.000000000000000e+00,  -1.062078461867958e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   4.693768015868822e-01,   0.000000000000000e+00,  -4.693768015868822e-01,   0.000000000000000e+00,  -2.346884007934411e+00,
   0.000000000000000e+00,  -1.408130404760646e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -9.387536031737644e+00,   0.000000000000000e+00,   1.877507206347529e+01,   0.000000000000000e+00,   2.816260809521293e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.251671470898352e+01,   0.000000000000000e+00,  -3.755014412695057e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -3.113493472321562e+00,   0.000000000000000e+00,
   1.556746736160781e+01,   0.000000000000000e+00,   1.556746736160781e+01,   0.000000000000000e+00,  -3.113493472321562e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.037831157440521e+01,   0.000000000000000e+00,  -6.226986944643124e+01,   0.000000000000000e+00,
   1.037831157440521e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -5.189155787202603e-01,   0.000000000000000e+00,   4.670240208482342e+00,   0.000000000000000e+00,   2.594577893601302e+00,
   0.000000000000000e+00,  -2.594577893601302e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   6.226986944643124e+00,   0.000000000000000e+00,  -6.226986944643124e+01,   0.000000000000000e+00,   3.113493472321562e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   2.645960661801900e+00,   0.000000000000000e+00,
  -3.968940992702851e+01,   0.000000000000000e+00,   3.968940992702851e+01,   0.000000000000000e+00,  -2.645960661801900e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   7.071627325245962e-01,   0.000000000000000e+00,  -1.485041738301652e+01,   0.000000000000000e+00,   2.475069563836087e+01,
   0.000000000000000e+00,  -4.950139127672173e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00};

  assert(abs(m) <= 7);
  const int size_c = (7 + 1) * (7 + 2) / 2;
  const int mu = m + 7;
  const int i0 = mu * size_c;
  for (int i = i0; i != i0 + size_c; ++i) c.push_back(coeff[i]);
  return c;

}
