//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _breitroot_10.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot10(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[10] = {9.244815469866574e-01,2.298729805186562e-01,2.099410462708798e+00,3.782880873707290e+00,6.019918027701461e+00,
    8.880347597996709e+00,1.247483240483620e+01,1.699084729354255e+01,2.279100289494895e+01,3.080640591705273e+01};
  constexpr double aw[10] = {1.776116944010360e-01,8.773540752333013e-02,1.263417798378390e-01,4.317805134766631e-02,7.554889017430406e-03,
    6.641078141817820e-04,2.709390010585172e-05,4.368737934593573e-07,2.009849943469898e-09,1.146110765102355e-12};
  constexpr double x[3840] = {  4.053948391343153e-02, -9.035021462501904e-04,  1.479715756639795e-05, -2.094216742045265e-07,  2.673169487355093e-09,
 -3.105452753755934e-11,  3.241923081903109e-13, -2.909066723307717e-15,  1.931323595594027e-17, -1.780335343128166e-20, -2.380958351785062e-21,  5.591177027748569e-23,
  1.591335736557223e-01, -3.340780642341213e-03,  4.817254951501345e-05, -5.347233996382659e-07,  4.181211531778449e-09, -8.693044177703693e-12, -4.229250857685557e-13,
  9.471972479857691e-15, -1.189902107993423e-16,  8.016581966366944e-19,  4.289057476132382e-21, -2.310557014952281e-22,  3.468498630702582e-01, -6.566732118290088e-03,
  7.415287262420615e-05, -4.214642518452896e-07, -2.905491823363550e-09,  1.015927876598147e-10, -1.067300382769073e-12, -9.093111797067393e-16,  2.081841286568415e-16,
 -3.181501393978355e-18,  1.106757852913488e-20,  4.599337280155642e-22,  5.892833541584676e-01, -9.572990972043716e-03,  6.893658195201013e-05,  2.534653016525910e-07,
 -1.099914262481884e-08,  6.450052527408897e-11,  1.262088344742233e-12, -2.474184649001887e-14,  5.720270443178474e-18,  5.045699445737134e-18, -5.499149720152177e-20,
 -5.169837107532981e-22,  8.673243352846970e-01, -1.138523873171890e-02,  2.772103618924687e-05,  9.368623979965675e-07, -6.611993535923860e-09, -1.284696754285592e-10,
  1.638092676747828e-12,  1.921109112577909e-14, -4.098318715556969e-16, -2.625429621788367e-18,  1.018409346241541e-19,  2.129347842343011e-22,  1.158310915213062e+00,
 -1.137550026731293e-02, -3.004765882503279e-05,  9.397871162721771e-07,  6.909759166983804e-09, -1.305550244604117e-10, -1.695986277007785e-12,  2.001787996299787e-14,
  4.248813490584779e-16, -2.886033696969776e-18, -1.068098190178886e-19,  2.863876795195530e-22,  1.437611311719363e+00, -9.495773824169723e-03, -7.218245495456764e-05,
  2.266582680531309e-07,  1.151797971431855e-08,  7.436336312913527e-11, -1.312922331300673e-12, -2.778130544056640e-14, -2.216780940333468e-17,  5.698594613251664e-18,
  6.633725406959072e-20, -5.743594921868543e-22,  1.680635407917564e+00, -6.340613234035376e-03, -7.602240742039012e-05, -4.876800901067832e-07,  2.344995569877859e-09,
  1.077676091100991e-10,  1.297453872470853e-12,  1.465375232872279e-15, -2.239791632092175e-16, -4.050862325387789e-18, -2.260172490410987e-20,  4.725202696349928e-22,
  1.865178339027411e+00, -2.983895921291094e-03, -4.585762425996266e-05, -5.544394795316736e-07, -5.030175723503890e-09, -2.264363585662970e-11,  2.967290901521680e-13,
  9.645186535512125e-15,  1.498423923142833e-16,  1.455978361003551e-18,  3.707625115104047e-21, -1.943694699045588e-22,  1.973880997457899e+00, -6.133775473798292e-04,
 -1.065908183417434e-05, -1.616321317829231e-07, -2.242477163555528e-09, -2.893002703905250e-11, -3.477137989953623e-13, -3.855985201465139e-15, -3.838436775773562e-17,
 -3.186527682558873e-19, -1.636389218206576e-21,  1.057008583549898e-23,  3.714728136422082e-02, -7.944946127397592e-04,  1.252152247288731e-05, -1.712233910948159e-07,
  2.123643692685170e-09, -2.418266500391504e-11,  2.511878457717789e-13, -2.315548110594614e-15,  1.744936841686235e-17, -7.464786676719724e-20, -6.867467435027852e-22,
  2.472616386868194e-23,  1.465021570609958e-01, -2.979946058859544e-03,  4.214996969388845e-05, -4.696836147414764e-07,  3.925223426783303e-09, -1.606351603539121e-11,
 -2.065426214766261e-13,  6.142359892772256e-15, -8.903001555814961e-17,  8.193380278122462e-19, -2.349347489567801e-21, -8.562511357589217e-23,  3.217364257764750e-01,
 -5.994384328862513e-03,  6.887892341597182e-05, -4.530854662559291e-07, -1.128395171025678e-09,  7.632290184756771e-11, -1.015913412814776e-12,  4.037212356602623e-15,
  1.053186735843188e-16, -2.460453635555235e-18,  2.222839912376478e-20,  8.187218638743660e-23,  5.521095565858896e-01, -9.012216176424798e-03,  7.096951097560309e-05,
  8.921169018679110e-08, -9.461584330345694e-09,  8.664990010177747e-11,  5.959737408847551e-13, -2.210706130445810e-14,  1.444607276944596e-16,  2.625015587521292e-18,
 -6.086083691221894e-20,  1.907794179333304e-22,  8.222953404767737e-01, -1.112048010865955e-02,  3.825119655774152e-05,  8.128068123712913e-07, -8.752600855508225e-09,
 -8.424162539079500e-11,  1.983800648849809e-12,  5.368422516167375e-15, -4.318299036630146e-16,  1.304047426764270e-18,  8.715965996951197e-20, -8.036853621377655e-22,
  1.112401950320306e+00, -1.156910406062362e-02, -1.819962272017571e-05,  1.027459592925087e-06,  3.944451130596357e-09, -1.631207743977401e-10, -9.663842740416359e-13,
  3.117407660121025e-14,  2.504890905327208e-16, -6.539650249073692e-18, -6.734425167330706e-20,  1.442616644086757e-21,  1.398495079491162e+00, -1.005912037718005e-02,
 -6.831401613033494e-05,  4.208687060359717e-07,  1.262758945908497e-08,  3.364484446883856e-11, -2.066617405676617e-12, -2.476455564169807e-14,  2.217639682837077e-16,
  7.528860013714141e-18,  1.735387093148863e-20, -1.635069789308964e-21,  1.654020663073710e+00, -6.971388496214664e-03, -8.157284269138795e-05, -4.312278619928843e-07,
  4.810283784218851e-09,  1.384491985597518e-10,  1.215268448427609e-12, -8.157078288425125e-15, -3.792266519870999e-16, -4.332877753257016e-18,  1.401236662999966e-20,
  1.224040940900526e-21,  1.852464922760490e+00, -3.378769624984668e-03, -5.300721057600320e-05, -6.380561413421657e-07, -5.386950257871526e-09, -1.169057033992221e-11,
  6.418874317411977e-13,  1.528588415113903e-14,  2.021193594655718e-16,  1.348328065743905e-18, -1.156869909729381e-20, -5.356987920013009e-22,  1.971243734884365e+00,
 -7.070656105158143e-04, -1.283461440214564e-05, -2.026333355746595e-07, -2.914038243268122e-09, -3.872058673756399e-11, -4.746844437294556e-13, -5.279034409860212e-15,
 -5.084040696546993e-17, -3.653514263113973e-19, -3.977646259971800e-22,  5.241994507584501e-23,  3.415740386480952e-02, -7.019982591788881e-04,  1.065575446103711e-05,
 -1.408077115791233e-07,  1.695338830284265e-09, -1.887171017869993e-11,  1.937386934438677e-13, -1.803670945254577e-15,  1.448037944943976e-17, -8.560811831460325e-20,
  3.033189502171811e-23,  9.718835137627095e-24,  1.352225496035998e-01, -2.664249352438680e-03,  3.687925998811824e-05, -4.096665092980220e-07,  3.566762750173864e-09,
 -1.925218472495200e-11, -7.017174817305897e-14,  3.741430347940521e-15, -6.189552290906487e-17,  6.752473523886296e-19, -4.339590861778629e-21, -1.432333243914382e-23,
  2.988262258074949e-01, -5.465300348222296e-03,  6.337977312688889e-05, -4.602085769871202e-07,  1.650436038787980e-10,  5.360270102472299e-11, -8.677613922536802e-13,
  6.164641189515720e-15,  3.299223782873548e-17, -1.565035735444860e-18,  2.124057433566808e-20, -9.805322145715576e-23,  5.171995296778990e-01, -8.442615724797362e-03,
  7.119089517963941e-05, -4.773262895979771e-08, -7.632680661611480e-09,  9.411874131615572e-11,  5.268492025322654e-14, -1.641804417463400e-14,  1.982991799752015e-16,
  4.771350166642998e-19, -4.434191364357326e-20,  4.933514920105737e-22,  7.784837040336324e-01, -1.077794761490032e-02,  4.711748240142978e-05,  6.618972056495586e-07,
 -9.956950106775968e-09, -3.632260290744171e-11,  1.952056416743437e-12, -7.106092763903169e-15, -3.322313959049172e-16,  3.920240938916544e-18,  4.095973334024494e-20,
 -1.173671996354041e-21,  1.065913606368680e+00, -1.166456469257581e-02, -5.602338285179495e-06,  1.063521452709971e-06,  5.245071933299935e-10, -1.751665390574671e-10,
 -1.960638913817226e-14,  3.503995439894390e-14, -1.626300288924650e-17, -7.773258687851525e-18,  8.529589545349779e-21,  1.831074914438850e-21,  1.357202452765364e+00,
 -1.058196357288548e-02, -6.203846927113990e-05,  6.253803367636196e-07,  1.275354463990703e-08, -2.322149414773639e-11, -2.619860351694639e-12, -1.335256858907371e-14,
  4.858490994017708e-16,  6.564888351677473e-18, -6.928593025103343e-20, -2.133767536397211e-21,  1.624799307262213e+00, -7.643141531369960e-03, -8.618955550826870e-05,
 -3.306308513948399e-07,  7.844756582375971e-09,  1.633661880515289e-10,  7.949779412242704e-13, -2.256051134959493e-14, -5.100257223033084e-16, -2.466645828678223e-18,
  8.437509880547597e-20,  1.906806528559528e-21,  1.838051152404637e+00, -3.834930808694626e-03, -6.118560549957160e-05, -7.251216118679262e-07, -5.428088530458167e-09,
  9.622006393277635e-12,  1.166792550244219e-12,  2.238619312227198e-14,  2.353013806120443e-16,  2.629185050578869e-19, -4.684388336701904e-20, -1.102626454393966e-21,
  1.968193516504956e+00, -8.203246845441147e-04, -1.557366837487379e-05, -2.561259494147665e-07, -3.815348741640271e-09, -5.208273472380532e-11, -6.472403974938143e-13,
 -7.113566354937604e-15, -6.350973512501780e-17, -3.104938412519983e-19,  3.904845348438683e-21,  1.585323061091488e-22,  3.150981667263653e-02, -6.230769866785478e-04,
  9.117132744823898e-06, -1.164653938212280e-07,  1.360569801268692e-09, -1.477847543992582e-11,  1.492655477641151e-13, -1.388693161339036e-15,  1.150037937523817e-17,
 -7.828227887394033e-20,  2.860942501652549e-22,  2.807495875452865e-24,  1.251258162028715e-01, -2.387938801883902e-03,  3.229275648567262e-05, -3.557382913277432e-07,
  3.172297589347063e-09, -1.988175422881340e-11,  1.027094809692623e-14,  2.115658721739009e-15, -4.076293355232888e-17,  4.995699172362412e-19, -4.242642087242136e-21,
  1.370385701218358e-23,  2.779442868317122e-01, -4.980232860673949e-03,  5.790499092674969e-05, -4.500627852744678e-07,  1.043232540208667e-09,  3.492061458771705e-11,
 -6.877276333416114e-13,  6.473099510663559e-15, -9.294922118078604e-18, -8.220710013210396e-19,  1.558799355262563e-20, -1.431348332188267e-22,  4.845617507652471e-01,
 -7.877313035082661e-03,  6.994731140521036e-05, -1.548711274365814e-07, -5.771165531088002e-09,  9.058847255591740e-11, -3.177891657604308e-13, -1.009648315341316e-14,
  1.889131741988516e-16, -8.516827724335199e-19, -2.228982357595097e-20,  4.703041203243981e-22,  7.361722215462443e-01, -1.037198407033670e-02,  5.408842118496453e-05,
  4.992323667411519e-07, -1.023664743256370e-08,  7.076988498177377e-12,  1.627139636443440e-12, -1.526244470682074e-14, -1.737371380038678e-16,  4.568688537240735e-18,
 -6.541806320986030e-21, -9.064028133970458e-22,  1.019246389984912e+00, -1.165845648193801e-02,  7.095480894387233e-06,  1.044190619177225e-06, -2.905438809562809e-09,
 -1.641748896466873e-10,  9.135114592528690e-13,  3.025941218862191e-14, -2.715660876132585e-16, -5.947382628722101e-18,  7.788467282431151e-20,  1.170288081193419e-21,
  1.313934334131021e+00, -1.104484209255341e-02, -5.333622300275476e-05,  8.222123783979477e-07,  1.163998682631677e-08, -8.863297921671266e-11, -2.745393361057516e-12,
  5.263393959365086e-15,  6.507011738826925e-16,  2.049791746203144e-18, -1.504720888109645e-19, -1.312196031884541e-21,  1.592825927096462e+00, -8.346140634774362e-03,
 -8.929351791003917e-05, -1.781882504060380e-07,  1.124192642679758e-08,  1.729664584118996e-10, -7.294218833958133e-14, -3.948287817105869e-14, -5.173859012614877e-16,
  2.619725875871979e-18,  1.683372241535004e-19,  1.669194685431564e-21,  1.821675298951866e+00, -4.360672299447223e-03, -7.039626317481948e-05, -8.086816205236054e-07,
 -4.900467172417018e-09,  4.599088686887440e-11,  1.897257874757906e-12,  2.959892296131869e-14,  1.975485285267948e-16, -2.778156349382759e-18, -1.099572988568204e-19,
 -1.744146268076948e-21,  1.964641996695163e+00, -9.583308545654210e-04, -1.905075704118455e-05, -3.264207397852863e-07, -5.029700215434020e-09, -7.024516783278968e-11,
 -8.762432503449364e-13, -9.277652834515011e-15, -6.968162413220823e-17,  4.409947804342155e-20,  1.561763836658660e-20,  4.070038038014010e-22,  2.915502583906524e-02,
 -5.553814500523131e-04,  7.841005030998660e-06, -9.687869552166277e-08,  1.097878639924662e-09, -1.162363817022228e-11,  1.151274464553522e-13, -1.063390436726070e-15,
  8.907711252509319e-18, -6.545471347543432e-20,  3.333152051481858e-22, -2.379133616819157e-25,  1.160648875277464e-01, -2.145839366359864e-03,  2.831540807545767e-05,
 -3.081315264830270e-07,  2.781230426690275e-09, -1.905630915565626e-11,  5.372559235473979e-14,  1.067621679889056e-15, -2.565899688433705e-17,  3.448637071406680e-19,
 -3.446822528386325e-21,  2.020144377523646e-23,  2.589160940837718e-01, -4.538264632402108e-03,  5.262469671042936e-05, -4.286198542863050e-07,  1.590996135597806e-09,
  2.053315571784518e-11, -5.143069955818142e-13,  5.810270510489784e-15, -2.916488400043027e-17, -3.218214200202580e-19,  9.561600856356673e-21, -1.250102833018712e-22,
  4.541578468978910e-01, -7.326603541523819e-03,  6.759303809182582e-05, -2.332142615560308e-07, -4.055173423019250e-09,  8.021869833513604e-11, -5.214715659067659e-13,
 -4.675963841135750e-15,  1.467984684116493e-16, -1.373682727991684e-18, -5.036459235083395e-21,  3.042015926115254e-22,  6.955837414118612e-01, -9.918074133804928e-03,
  5.910761525190387e-05,  3.385454292485798e-07, -9.741823603607678e-09,  4.052032295892117e-11,  1.145914236199511e-12, -1.831008924275288e-14, -2.222245219394452e-17,
  3.660745635404327e-18, -3.494868167833460e-20, -3.759591476057481e-22,  9.728040169414784e-01, -1.155260222066462e-02,  1.924308895216790e-05,  9.728949322306505e-07,
 -5.906894782619135e-09, -1.332396452645488e-10,  1.611698109762212e-12,  1.882549374307774e-14, -4.202679969697029e-16, -2.144394519231621e-18,  1.034317956832778e-19,
 -2.819802779643606e-23,  1.268968337679058e+00, -1.142905716466528e-02, -4.242209017074168e-05,  9.907837844634525e-07,  9.232661194534826e-09, -1.503765742736758e-10,
 -2.304198184843753e-12,  2.602254934097201e-14,  6.069761458959532e-16, -4.590928498324143e-18, -1.669269141531698e-19,  6.744304777912507e-22,  1.558003786278113e+00,
 -9.065723716510201e-03, -9.023980687403059e-05,  2.885415065865024e-08,  1.458508261830827e-08,  1.562154611387449e-10, -1.386094127100148e-12, -5.311177675228864e-14,
 -2.881073745278021e-16,  1.036075907832364e-17,  2.035873380777120e-19, -4.050195023308933e-22,  1.803043042135881e+00, -4.963904623936356e-03, -8.053172184384325e-05,
 -8.769634074998299e-07, -3.455000463672559e-09,  1.020580344732458e-10,  2.792537364995616e-12,  3.331443478387737e-14, -1.094007060657062e-18, -8.803352798305616e-18,
 -1.916404635865473e-19, -1.765255241889816e-21,  1.960476971104243e+00, -1.127887837745250e-03, -2.350097230359463e-05, -4.193705789062923e-07, -6.667220781377917e-09,
 -9.463748963925424e-11, -1.165898327368437e-12, -1.131913204073931e-14, -5.138895182980348e-17,  1.157673595398014e-18,  4.395766004460567e-20,  9.457039345832753e-22,
  2.705199280016854e-02, -4.970217047702124e-04,  6.776645406375177e-06, -8.103186416496601e-08,  8.907822539732195e-10, -9.187754690564841e-12,  8.900701420028731e-14,
 -8.135208823209974e-16,  6.784688401583929e-18, -5.275933745875487e-20,  2.939616752882759e-22, -1.263620968332504e-24,  1.079121890265240e-01, -1.933378386614789e-03,
  2.487250170646908e-05, -2.666021585492430e-07,  2.414985589706997e-09, -1.749039382966102e-11,  7.381049780443570e-14,  4.202963766437381e-16, -1.551301854581515e-17,
  2.245297850659236e-19, -2.582254161890075e-21,  1.866912398628904e-23,  2.415731025200748e-01, -4.137380941079787e-03,  4.764551985656576e-05, -4.004959643231397e-07,
  1.890821589501825e-09,  1.002825722970257e-11, -3.659600551185046e-13,  4.755291481734156e-15, -3.509805577652376e-17, -3.893579376942868e-20,  4.857902791706884e-21,
 -8.736703602581240e-23,  4.259137948381942e-01, -6.798039198280211e-03,  6.445581201255432e-05, -2.859776026613481e-07, -2.584011398963960e-09,  6.661658486902648e-11,
 -5.942085219085791e-13, -7.855469749038238e-16,  9.646239593705241e-17, -1.359994504978855e-18,  4.492286436058941e-21,  1.367067528007148e-22,  6.568792476887710e-01,
 -9.431542374294690e-03,  6.226605253180878e-05,  1.904794772059809e-07, -8.697860794487344e-09,  6.190120769337913e-11,  6.410209520866212e-13, -1.720590673941152e-14,
  8.175046986980312e-17,  2.076228317178543e-18, -4.102984879591605e-20,  6.827833339949884e-23,  9.269729203871316e-01, -1.135375332123469e-02,  3.027005832484581e-05,
  8.593191683839553e-07, -8.150237881494077e-09, -8.979642388024612e-11,  1.944508208219225e-12,  4.918255504397148e-15, -4.262268281758160e-16,  1.653599618833163e-18,
  7.971412961043012e-20, -9.475142626223382e-22,  1.222651876223085e+00, -1.171861169192665e-02, -2.975456394993437e-05,  1.111726267338003e-06,  5.741675292753812e-09,
 -1.949355792384259e-10, -1.337154043314688e-12,  4.160820440783514e-14,  3.343066071728468e-16, -1.006525136758440e-17, -9.318044320731256e-20,  2.518610709187038e-21,
  1.520305143221165e+00, -9.782066894690552e-03, -8.839755773521798e-05,  2.848830638676919e-07,  1.725254884991033e-08,  1.044607527255145e-10, -2.935505155256978e-12,
 -5.488505373492592e-14,  2.181783001268538e-16,  1.714616696078605e-17,  1.093823357526518e-19, -3.969922788777148e-21,  1.781831176380111e+00, -5.651012056205059e-03,
 -9.130695167908787e-05, -9.119598755804496e-07, -6.695405338485981e-10,  1.799194806685670e-10,  3.665875395857515e-12,  2.659775137285037e-14, -4.713755552489835e-16,
 -1.761555164795898e-17, -2.335629046154025e-19,  3.829711783305600e-22,  1.955554769057654e+00, -1.337993160926203e-03, -2.924115907427816e-05, -5.428189124418258e-07,
 -8.866203449650883e-09, -1.265551738069831e-10, -1.496627571425368e-12, -1.186103925483601e-14,  3.429184710097452e-17,  4.012138418424006e-18,  1.063877491420826e-19,
  1.995337111323673e-21,  2.516649843908400e-02, -4.464690262790572e-04,  5.884070034057851e-06, -6.814064873942858e-08,  7.266634101268529e-10, -7.302072419415075e-12,
  6.899800436480370e-14, -6.246350075600537e-16,  5.084503473957796e-18, -4.197949598420992e-20,  2.528955578349159e-22, -1.625068607311571e-25,  1.005572668544499e-01,
 -1.746564344491276e-03,  2.189389123460628e-05, -2.306615222665996e-07,  2.083584782328717e-09, -1.562702200588149e-11,  7.971118498193627e-14,  3.485976618021886e-17,
 -9.093888206454218e-18,  1.374638015411085e-19, -1.763463891282423e-21,  1.986635805230343e-23,  2.257562119097433e-01, -3.774913927045783e-03,  4.302627817752416e-05,
 -3.690725274168680e-07,  2.013684237079850e-09,  2.715952611596357e-12, -2.485190137528320e-13,  3.640467129602994e-15, -3.381256799824803e-17,  9.137694262469363e-20,
  1.996622738944758e-21, -4.064012750645461e-23,  3.997303316200916e-01, -6.296726268744616e-03,  6.081746613272346e-05, -3.174397474798418e-07, -1.394455315776609e-09,
  5.239669591474139e-11, -5.800443798545422e-13,  1.562174788556397e-15,  5.186529181873057e-17, -1.093946203991891e-18,  8.146157260415250e-21,  4.609467907923809e-23,
  6.201606014221790e-01, -8.926538025586949e-03,  6.375994104362747e-05,  6.189608230446625e-08, -7.343234257914063e-09,  7.185812256403004e-11,  2.049190736848060e-13,
 -1.369943793142723e-14,  1.284857592330259e-16,  5.812585936744141e-19, -3.191283790852454e-20,  3.180154179243342e-22,  8.821042475536031e-01, -1.107268229304669e-02,
  3.974847659601998e-05,  7.171035697628195e-07, -9.475988515772969e-09, -4.294209022879968e-11,  1.904095630091172e-12, -7.242211990778813e-15, -3.204258698484488e-16,
  3.902106525024268e-18,  3.158470984882081e-20, -1.103247137671060e-21,  1.175387649995548e+00, -1.190202919811566e-02, -1.599582864970534e-05,  1.171073093710435e-06,
  1.621165496286269e-09, -2.121929007065821e-10, -8.061623547947055e-14,  4.602248244414273e-14, -6.604105229149509e-17, -1.133945141218335e-17,  3.211829091780024e-20,
  2.882971366085899e-21,  1.479790965758008e+00, -1.047074887582243e-02, -8.326754885887201e-05,  5.733088815819096e-07,  1.851934046339146e-08,  1.694717360807981e-11,
 -4.277993727386480e-12, -3.758203351615085e-14,  8.635312563812527e-16,  1.712390942062279e-17, -1.276854767159106e-19, -6.262560230135312e-21,  1.757697051907138e+00,
 -6.425118219198559e-03, -1.021799141480931e-04, -8.888906820566479e-07,  3.857459327353130e-09,  2.744846875435714e-10,  4.091830656413728e-12, -3.211220065605272e-16,
 -1.256825511918206e-15, -2.515214665932248e-17, -9.912310017037909e-20,  6.434180943908399e-21,  1.949690008756031e+00, -1.600594936561789e-03, -3.669628850195783e-05,
 -7.069872496931979e-07, -1.178206916912325e-08, -1.661679909779688e-10, -1.784681722387004e-12, -7.433314848542216e-15,  2.805500191890606e-16,  1.047883766186728e-17,
  2.293138305843539e-19,  3.685473080236048e-21,  2.346985387248338e-02, -4.024801075368618e-04,  5.131598526959434e-06, -5.759802530900010e-08,  5.958541600314701e-10,
 -5.838938089571466e-12,  5.357299058940997e-14, -4.841178803380591e-16,  3.762212772847140e-18, -3.101648051252688e-20,  3.252681896903209e-22,  3.928982447983653e-24,
  9.390455109060018e-02, -1.581941310948095e-03,  1.931599957344866e-05, -1.997207514995158e-07,  1.790101916739270e-09, -1.373099347825378e-11,  7.727067601703943e-14,
 -1.887257932275904e-16, -5.181274762127319e-18,  8.710613126103991e-20, -6.654514232849072e-22,  3.198921288616950e-23,  2.113177033849765e-01, -3.447869274754978e-03,
  3.879155381499404e-05, -3.367105946907596e-07,  2.015998096029681e-09, -2.144050552157031e-12, -1.611448695762612e-13,  2.624024032614168e-15, -2.936119754428091e-17,
  1.527850674850562e-19,  1.534408208966079e-21,  2.238171837628262e-23,  3.754919440288513e-01, -5.825728124577202e-03,  5.690650095119132e-05, -3.321061362245132e-07,
 -4.813657115229218e-10,  3.915401694240694e-11, -5.185186711490500e-13,  2.658294079238160e-15,  1.879892126877173e-17, -7.302043248228391e-19,  1.016650078345234e-20,
  6.259980261756538e-23,  5.854766381190414e-01, -8.415374497514977e-03,  6.384569963037360e-05, -4.395304475691230e-08, -5.885508105223096e-09,  7.264903091260757e-11,
 -1.195418165863431e-13, -9.469277579411341e-15,  1.302273941969661e-16, -3.700746621722580e-19, -1.464309928650139e-20,  4.578750058826931e-22,  8.385002888521278e-01,
 -1.072290053925496e-02,  4.742349085691139e-05,  5.610118982714441e-07, -9.899685521536335e-09, -6.995589112636620e-13,  1.580100553912377e-12, -1.509279606959658e-14,
 -1.678587040642809e-16,  4.318628723867307e-18, -6.629915235690886e-21, -5.441772761428383e-22,  1.127612800544733e+00, -1.197366443662397e-02, -1.926530957808902e-06,
  1.163384895274018e-06, -2.540444807999895e-09, -1.992653572243339e-10,  1.120199853831150e-12,  3.786046316054998e-14, -4.226840716686969e-16, -7.767003111683009e-18,
  1.383807346187722e-19,  1.789154751398764e-21,  1.436626358815835e+00, -1.110434518734144e-02, -7.461769803140155e-05,  8.664566136892839e-07,  1.776471324186618e-08,
 -9.470853652975934e-11, -4.860855683739607e-12, -1.598428556787689e-15,  1.323958346840165e-15,  6.842808421324646e-18, -3.672863570581235e-19, -3.639065119951915e-21,
  1.730296219254214e+00, -7.283723558448884e-03, -1.122780713205099e-04, -7.780137133115594e-07,  1.030137873729002e-08,  3.671884915970841e-10,  3.382145492248475e-12,
 -5.508821958550772e-14, -2.142425136898262e-15, -2.090930770560035e-17,  3.755415475928689e-19,  1.511392452070533e-20,  1.942641880681777e+00, -1.931573310141558e-03,
 -4.642856180564830e-05, -9.244618218602178e-07, -1.554363166762313e-08, -2.100631410137363e-10, -1.795792936984492e-12,  9.701058414873142e-15,  8.670302185968973e-16,
  2.344186780816773e-17,  4.310314557024203e-19,  5.307718675830619e-21,  2.193787922057400e-02, -3.640383954502949e-04,  4.493984785195231e-06, -4.893310596442016e-08,
  4.909012257388858e-10, -4.703177592945923e-12,  4.155562700996584e-14, -3.786488632273979e-16,  2.935766365255321e-18, -1.299873529638534e-20,  6.102829027646976e-22,
  8.520021396413209e-24,  8.787132375736804e-02, -1.436533229347972e-03,  1.708245863297137e-05, -1.731774166869570e-07,  1.533514014631510e-09, -1.195585687658647e-11,
  7.011740572820114e-14, -3.064280555944914e-16, -2.138542855245118e-18,  9.371114668937194e-20,  1.107735262919162e-21,  4.668644345838143e-23,  1.981220694109209e-01,
 -3.153155108969894e-03,  3.494253055596483e-05, -3.049846657939613e-07,  1.939868228822221e-09, -5.230449540702991e-12, -9.989757077117061e-14,  1.787448649834030e-15,
 -2.233671095819113e-17,  2.535524584050556e-19,  3.941851500605298e-21,  8.092806322075479e-23,  3.530741837239348e-01, -5.386492892148967e-03,  5.289873910710756e-05,
 -3.341932456154741e-07,  1.835581131546913e-10,  2.764940498242128e-11, -4.390195859119236e-13,  2.924371159105943e-15,  6.848582169187364e-19, -2.474942832677727e-19,
  1.448222539881488e-20,  1.296623868094916e-22,  5.528312146639504e-01, -7.908210504850627e-03,  6.280047140168713e-05, -1.267350768358621e-07, -4.480323865891772e-09,
  6.705391139048241e-11, -3.289110244675134e-13, -5.586949530327469e-15,  1.114916348362534e-16, -5.240528388065391e-19,  7.459796561159724e-21,  5.246421925467212e-22,
  7.964063125196035e-01, -1.031926518384233e-02,  5.321106154463866e-05,  4.044126623158715e-07, -9.571220005050628e-09,  3.168562670336849e-11,  1.105108077064705e-12,
 -1.806044234498502e-14, -2.075094656735786e-17,  3.814053875799076e-18, -1.277596084691887e-20,  2.413368846619620e-22,  1.079774374688074e+00, -1.193421693583068e-02,
  1.166433389025269e-05,  1.092646088536206e-06, -6.179881953031233e-09, -1.614047063792495e-10,  1.957275595481154e-12,  2.105699926195689e-14, -5.876529435780311e-16,
 -1.091881894285064e-18,  1.847794528838422e-19,  3.422263851208100e-22,  1.391087525911788e+00, -1.165504970906475e-02, -6.259767605966320e-05,  1.129272889925168e-06,
  1.472563164053135e-08, -2.069981903413170e-10, -4.296928449098947e-12,  4.167366571402342e-14,  1.284714095805648e-15, -9.084808474329213e-18, -3.749127577319171e-19,
  3.681738983988746e-21,  1.699310470626673e+00, -8.215907229051097e-03, -1.203704582858093e-04, -5.507026142912210e-07,  1.828942197396408e-08,  4.215458389122434e-10,
  7.954774760621904e-13, -1.313782312057019e-13, -2.448435227713576e-15,  9.017026415008816e-18,  1.138149577404767e-18,  1.722253572794387e-20,  1.934096063344600e+00,
 -2.351937623637627e-03, -5.916010696061527e-05, -1.208951740972917e-06, -2.013390080728063e-08, -2.458573160845904e-10, -9.824847223581020e-13,  5.473336740954015e-14,
  2.077172366124225e-15,  4.522684511025300e-17,  6.432203268644318e-19,  3.075947278181963e-21,  2.055008998275305e-02, -3.303085950268205e-04,  3.950976066928848e-06,
 -4.178042371592863e-08,  4.060059501080495e-10, -3.822698438188492e-12,  3.223620215437382e-14, -2.867454226532633e-16,  2.996642595317471e-18,  1.860382716104040e-20,
  9.343777855086659e-22,  3.404879536826927e-24,  8.238591433441679e-02, -1.307786554238908e-03,  1.514394407747004e-05, -1.504657090656642e-07,  1.310504771850716e-09,
 -1.038020988504751e-11,  6.117058802163597e-14, -3.083691333215386e-16,  2.514660718493972e-18,  1.768438186355803e-19,  2.880152435309390e-21,  2.250443675241662e-23,
  1.860460840872740e-01, -2.887735201945405e-03,  3.146511110931833e-05, -2.748982290177218e-07,  1.814960650361783e-09, -7.098478436159704e-12, -5.822517020483815e-14,
  1.256301479509173e-15, -9.495962855007711e-18,  4.821972466219406e-19,  7.204715220105886e-21,  3.934448645944162e-23,  3.323493146733506e-01, -4.979255881394642e-03,
  4.892251195644956e-05, -3.273770719480781e-07,  6.378073092009811e-10,  1.809404437939568e-11, -3.573074551113970e-13,  2.926733644490814e-15,  3.563702766502340e-18,
  4.408548706861212e-19,  1.932288629308908e-20,  4.074296991247160e-23,  5.221919584549486e-01, -7.413009765298142e-03,  6.089227735274259e-05, -1.881666617175594e-07,
 -3.228834867618465e-09,  5.767170666741887e-11, -4.375682702543992e-13, -2.219878808884886e-15,  1.032883014701748e-16,  1.997596400144453e-19,  2.696366841512357e-20,
  2.744452960092738e-22,  7.560077630336871e-01, -9.876711584443620e-03,  5.717028731002419e-05,  2.576122134897890e-07, -8.713102701275211e-09,  5.218890979617320e-11,
  6.102233944490742e-13, -1.659654035141598e-14,  1.111926427643354e-16,  3.642095677648101e-18,  5.476699018175030e-21,  4.042890331404316e-22,  1.032304502776690e+00,
 -1.179036409357033e-02,  2.408501441575951e-05,  9.706577823860658e-07, -8.901422026349953e-09, -1.094649194187072e-10,  2.287918693710687e-12,  3.055530214398263e-15,
 -4.938858078506475e-16,  6.204065070335663e-18,  1.698776550781116e-19, -1.070127148563730e-21,  1.343556785745964e+00, -1.209796939508539e-02, -4.778623491227193e-05,
  1.326635594928250e-06,  9.671302707566117e-09, -2.918720190642441e-10, -2.621845867261175e-12,  7.510169014042817e-14,  7.457529024849549e-16, -1.883084661204666e-17,
 -7.322510297372967e-20,  8.913285143401564e-21,  1.664486929070994e+00, -9.199689241910411e-03, -1.249453105298286e-04, -1.909900358361973e-07,  2.657005729221209e-08,
  3.882882797745277e-10, -3.860861222178302e-12, -1.944540004944785e-13, -1.152569897679320e-15,  6.593691553366902e-17,  1.566523185914072e-18, -2.236297879332059e-21,
  1.923641640096912e+00, -2.889103402475506e-03, -7.576500351884960e-05, -1.571035248204162e-06, -2.511684691414760e-08, -2.418500019153158e-10,  1.761494472696768e-12,
  1.523073628528020e-13,  4.172543766114085e-15,  7.023197852361687e-17,  4.817978952315276e-19, -1.449351620928929e-20,  1.928904448159478e-02, -3.006013633334195e-04,
  3.486193771218931e-06, -3.585644864748167e-08,  3.366979040190484e-10, -3.133662172940550e-12,  2.570201133811822e-14, -1.729709608457729e-16,  4.321260612589637e-18,
  5.267156812180046e-20,  5.651028968173803e-22, -2.458882988890421e-23,  7.738611889686972e-02, -1.193516171662057e-03,  1.345756402592651e-05, -1.310813885755642e-07,
  1.116957067375972e-09, -8.999934744866030e-12,  5.478274216295274e-14, -1.033102518990750e-16,  1.096473702431888e-17,  2.852085891823793e-19,  1.683009492557476e-21,
 -9.489118176188561e-23,  1.749783749603123e-01, -2.648726984094117e-03,  2.833566932473367e-05, -2.470589733229146e-07,  1.661764287949092e-09, -8.090046710349962e-12,
 -2.429243097208271e-14,  1.285967937045516e-15,  1.295696004581277e-17,  7.452103724515240e-19,  3.994084387543132e-21, -2.286004175286027e-22,  3.131904482176227e-01,
 -4.603391785685403e-03,  4.506572660126475e-05, -3.147147023137258e-07,  9.207204642811232e-10,  1.053491225597501e-11, -2.703216707275050e-13,  3.441292042856322e-15,
  3.281161881893928e-17,  1.136438922673239e-18,  1.176858524325046e-20, -4.656787743044165e-22,  4.934987661020488e-01, -6.935697912506675e-03,  5.836048307460509e-05,
 -2.311853878819840e-07, -2.183464987331975e-09,  4.681213548277678e-11, -4.508082345467693e-13,  1.419975742370738e-15,  1.308769752569579e-16,  1.296450471908870e-18,
  2.084242939385303e-20, -6.904932894748163e-22,  7.174319841734346e-01, -9.409270116280892e-03,  5.946178740750073e-05,  1.271993335930276e-07, -7.557912132943461e-09,
  6.178320419651590e-11,  2.154862515826315e-13, -1.087675642982998e-14,  2.483752483961296e-16,  3.955623124716921e-18,  7.097680192600316e-22, -8.977581497327288e-22,
  9.855985635605348e-01, -1.155366057045265e-02,  3.481579740130542e-05,  8.137041285176175e-07, -1.054288229875646e-08, -5.506372306384887e-11,  2.194444681210321e-12,
 -7.989192639451217e-15, -1.647520229085300e-16,  1.146884233597652e-17,  7.615432733292344e-20, -3.442828828523603e-21,  1.294504258130244e+00, -1.241441231065915e-02,
 -3.113982020986504e-05,  1.432013441649034e-06,  3.386215787695660e-09, -3.274932568534115e-10, -2.864539096409933e-13,  8.830588381302911e-14,  1.063541399632866e-16,
 -1.444315319754667e-17,  2.584061286265334e-19,  4.230219751950318e-21,  1.625685460281022e+00, -1.020064408817380e-02, -1.244516724535079e-04,  2.893284778666794e-07,
  3.295748792760064e-08,  2.287325389998996e-10, -9.383125014761121e-12, -1.821049842877530e-13,  2.225071114434409e-15,  1.153912389355560e-16,  6.036534519013426e-19,
 -4.312666553426745e-20,  1.910743487227770e+00, -3.577809185267505e-03, -9.717614165259070e-05, -2.007551495116570e-06, -2.909741540154208e-08, -1.308848808380718e-10,
  8.291476924996009e-12,  3.280639554083429e-13,  6.785308173037638e-15,  6.415327942713193e-17, -1.181985949490635e-18, -6.916173523633797e-20,  1.813981631641676e-02,
 -2.743458932401401e-04,  3.086275963024490e-06, -3.093849480765145e-08,  2.798893935740985e-10, -2.557465107608208e-12,  2.309482907006366e-14, -2.889964540943478e-18,
  6.242915081177576e-18,  4.018669153796891e-20, -1.543257114022118e-21, -7.252891860395679e-23,  7.281782450738690e-02, -1.091856971120232e-03,  1.198610598734627e-05,
 -1.145787744867527e-07,  9.501179590362730e-10, -7.670522542174497e-12,  5.837524825091956e-14,  4.134088798418797e-16,  2.093672678676506e-17,  2.131820445900523e-19,
 -6.751848229134035e-21, -2.937038040819813e-22,  1.648186829764356e-01, -2.433460897678803e-03,  2.552508515993198e-05, -2.217834206644213e-07,  1.497399121076094e-09,
 -8.168861646284939e-12,  2.162136009458172e-14,  2.133403537952504e-15,  3.906892458991691e-17,  5.736366428998898e-19, -1.600250235025104e-20, -6.931581941227661e-22,
  2.954743863775517e-01, -4.257707946645456e-03,  4.138344629781048e-05, -2.986146862609515e-07,  1.075127833095004e-09,  5.361910377172740e-12, -1.527697946100342e-13,
  5.182282161231369e-15,  7.505187147441710e-17,  9.512620829912577e-19, -2.751479720682304e-20, -1.344336141862278e-21,  4.666714227670438e-01, -6.480437410059008e-03,
  5.540569630105958e-05, -2.591961134694759e-07, -1.349552088197870e-09,  3.699003145321554e-11, -3.447240122756595e-13,  6.430167009236241e-15,  1.812225677295228e-16,
  1.075895172504750e-18, -4.355702647773536e-20, -2.274194932765289e-21,  6.807531827891926e-01, -8.929430707682880e-03,  6.030406658981854e-05,  1.635332472260530e-08,
 -6.290007453706286e-09,  6.432752332298944e-11,  4.300793495563907e-14, -7.633186395419279e-16,  3.754138358859338e-16,  2.483076638405239e-18, -9.332939864345153e-20,
 -3.468398548043256e-21,  9.399986796636743e-01, -1.123900956628030e-02,  4.354083485963832e-05,  6.389876234248664e-07, -1.113701977520010e-08, -5.283074430315289e-12,
  1.961190433704054e-12, -6.423570929912745e-15,  2.572390314085566e-16,  1.046065085908708e-17, -1.532582223619078e-19, -7.057534464624121e-21,  1.244457850839144e+00,
 -1.259436921034211e-02, -1.384563598022084e-05,  1.434262622476834e-06, -3.031893810565345e-09, -3.047166550493473e-10,  2.170912526887602e-12,  8.554074557575916e-14,
 -2.149224018235176e-16, -4.011895684724174e-18,  1.637757118447835e-19, -9.194029446917368e-21,  1.582926650459860e+00, -1.117314492998429e-02, -1.177087621250668e-04,
  8.394709896791837e-07,  3.492531843386579e-08, -4.570345695188276e-11, -1.285234041614571e-11, -4.415537639409765e-14,  6.257781370032553e-15,  9.124372802231502e-17,
 -1.997362461171912e-18, -6.783857306545607e-20,  1.894713532226582e+00, -4.459606606964281e-03, -1.241018254255512e-04, -2.479652269365007e-06, -2.884699448319026e-08,
  2.045079834726913e-10,  2.075721317040991e-11,  5.655203806828597e-13,  7.271795971489071e-15, -7.065685958370433e-17, -6.265941882539845e-18, -1.644532127062354e-19,
  1.708956443394088e-02, -2.510682935032711e-04,  2.740293961647814e-06, -2.683895302803544e-08,  2.343965446735213e-10, -1.980843978377835e-12,  2.590335197762825e-14,
  2.011205041202278e-16,  5.698177908389856e-18, -9.692511633947922e-20, -5.503226885717224e-21, -9.706876472851114e-23,  6.863381645908515e-02, -1.001220611635075e-03,
  1.069757023335151e-05, -1.005226845548667e-07,  8.120675581423664e-10, -6.050361752807213e-12,  7.995040090196749e-14,  1.125648819378506e-15,  2.017438956441529e-17,
 -3.632883942731570e-19, -2.286727960126383e-20, -3.961023060991269e-22,  1.554769442059404e-01, -2.239510649686324e-03,  2.300219634205711e-05, -1.990808183089711e-07,
  1.344839410867820e-09, -6.778804476587155e-12,  1.007010102035499e-13,  3.523493399661509e-15,  3.976586749598511e-17, -7.889328376833675e-19, -5.399507566307666e-20,
 -9.337328989897098e-22,  2.790834173031189e-01, -3.940674324716800e-03,  3.790632313886589e-05, -2.806994229874047e-07,  1.158953887608609e-09,  3.728989006313125e-12,
  2.885155231753744e-14,  7.789886418387638e-15,  7.318580004766012e-17, -1.544984870544285e-18, -1.008256281174152e-19, -1.798399103789752e-21,  4.416160180129688e-01,
 -6.049946674004172e-03,  5.218893957151314e-05, -2.752467584397249e-07, -6.744238309791406e-10,  3.155094000460998e-11, -8.132404422526810e-14,  1.229223038267299e-14,
  1.608202152187986e-16, -3.048404710291817e-18, -1.690558903204152e-19, -3.101003833671151e-21,  6.459992819622814e-01, -8.447825889366269e-03,  5.993914421680307e-05,
 -7.392041136159059e-08, -4.987620014697790e-09,  6.650938662349883e-11,  1.961839662990739e-13,  1.161937654508758e-14,  3.546506687902782e-16, -4.947173193196504e-18,
 -2.892828465904151e-19, -4.906821723129117e-21,  8.957835912695459e-01, -1.086303238769520e-02,  5.014421152614650e-05,  4.624669047034748e-07, -1.078048592635788e-08,
  4.084693341353282e-11,  1.940959980328400e-12,  5.988515966889248e-15,  4.406699611023735e-16, -2.700011491338560e-18, -5.171033194029351e-19, -8.617428051455373e-21,
  1.193966100906015e+00, -1.263755516363922e-02,  2.884698872449553e-06,  1.340627442804517e-06, -8.415695517944255e-09, -2.247624165134483e-10,  4.451338985263008e-12,
  7.659508026232171e-14, -3.732062976000146e-16, -9.175113754509137e-18, -4.914738991965674e-19, -1.843889136933331e-20,  1.536427712471224e+00, -1.206519940529136e-02,
 -1.043668290237795e-04,  1.374223159674303e-06,  3.095390455100718e-08, -3.440247995586780e-10, -1.093408977400290e-11,  1.876330109529743e-13,  7.427646931290902e-15,
 -4.268191093466052e-17, -4.433564599452150e-18, -3.164590580681251e-20,  1.874690611813119e+00, -5.578775709274499e-03, -1.563885667747934e-04, -2.875608695668721e-06,
 -1.837408263563763e-08,  9.145358717804405e-10,  3.903393645663698e-11,  6.937595893575932e-13, -1.700023170749471e-15, -4.822090283654199e-16, -1.430523251067101e-17,
 -1.557229029108595e-19,  1.612718253114283e-02, -2.303732363072194e-04,  2.439536653074901e-06, -2.336953778118132e-08,  2.015392511892928e-10, -1.275920596274343e-12,
  3.321500316189101e-14,  2.775354161810143e-16, -2.655725787197985e-18, -3.859895764042950e-19, -8.200390363752277e-21,  8.628096120766741e-24,  6.479275604484469e-02,
 -9.202527176738121e-04,  9.565632940898848e-06, -8.838160066547625e-08,  7.131015559086621e-10, -3.699576008864570e-12,  1.170980510954704e-13,  1.354359235314782e-15,
 -1.305226257648044e-17, -1.559449994765459e-18, -3.387993292204325e-20,  3.554004834108224e-23,  1.468723107283928e-01, -2.064692437170477e-03,  2.073837927924790e-05,
 -1.784810491583418e-07,  1.241994251213021e-09, -3.077317657588917e-12,  2.094985632349489e-13,  3.851414884950651e-15, -3.620486909753135e-17, -3.613349317220816e-18,
 -8.005556946341513e-20,  7.749939306695044e-23,  2.639063413056139e-01, -3.650575779646590e-03,  3.465198468693068e-05, -2.614439396878846e-07,  1.259162004027725e-09,
  7.220625643105114e-12,  2.650082916880732e-13,  8.322117934693655e-15, -7.180796754474228e-17, -6.863045713854299e-18, -1.515053523724371e-19,  1.158054980235015e-22,
  4.182301397297871e-01, -5.645782559254507e-03,  4.884205496728157e-05, -2.809697585016534e-07, -3.265917173077596e-11,  3.415655679578164e-11,  3.076569445751867e-13,
  1.413281632159419e-14, -9.970126087150555e-17, -1.204074167732496e-17, -2.575927526020636e-19,  1.391944702131085e-22,  6.131596076629467e-01, -7.973114158749853e-03,
  5.861836408704404e-05, -1.426942882308902e-07, -3.578388987370830e-09,  7.615000275723192e-11,  6.354215478533413e-13,  1.749749252586399e-14, -7.780113513615924e-17,
 -2.005341561362127e-17, -4.293423998277956e-19,  2.721060136325913e-22,  8.531648799261142e-01, -1.044253365428824e-02,  5.469426450874969e-05,  2.991286397886159e-07,
 -9.476856662512868e-09,  9.078577843411269e-11,  2.258999816662472e-12,  1.386928619192152e-14, -1.086942867359626e-16, -2.949733248926787e-17, -7.588656213248294e-19,
  3.833153175972853e-22,  1.143560292847970e+00, -1.255271694866128e-02,  1.803670282083262e-05,  1.176518232032846e-06, -1.167779310681885e-08, -9.402322281759055e-11,
  6.343148230355714e-12,  5.404620839370198e-14, -1.241398757163310e-15, -4.337376660542006e-17, -1.120378723837715e-18, -4.620229061384608e-21,  1.486612579761408e+00,
 -1.282635668537529e-02, -8.517183894782594e-05,  1.802422519824694e-06,  2.200295835798181e-08, -5.192264509415939e-10, -2.837037544036210e-12,  3.651267759164690e-13,
  2.571082787438204e-15, -2.245477122972991e-16, -4.022525866509784e-18,  5.520359684674871e-20,  1.849649977767795e+00, -6.971158919427145e-03, -1.918740607002309e-04,
 -2.966120272209562e-06,  1.074319731478623e-08,  2.058076365371053e-09,  5.424790717182973e-11,  2.431285552929867e-13, -3.013337485919440e-14, -1.084322015719811e-15,
 -1.172555300276328e-17,  4.099188499751304e-19,  1.524302129050537e-02, -2.119255084437401e-04,  2.177754561315203e-06, -2.030346127290108e-08,  1.845098401091827e-10,
 -4.101098735639139e-13,  3.728360866454555e-14, -8.746368380217299e-17, -2.159609443245810e-17, -6.176937332501661e-19, -6.430478518451224e-22,  3.830562874634560e-22,
  6.125834603720592e-02, -8.477805806757101e-04,  8.571595939921400e-06, -7.739992093633242e-08,  6.697884135915966e-10, -5.421502928358461e-13,  1.389817363493533e-13,
 -2.000749608362709e-16, -9.006396117931532e-17, -2.520000741861467e-18, -2.909248592152199e-21,  1.570462641981567e-21,  1.389322636866362e-01, -1.907017407042179e-03,
  1.871478275773388e-05, -1.587957652327679e-07,  1.238198366140032e-09,  2.972510846557146e-12,  2.774200952433513e-13,  4.707353980106738e-17, -2.157240957132471e-16,
 -5.894604961633819e-18, -7.605404171367803e-21,  3.684125652025359e-21,  2.498391014628521e-01, -3.385553135716900e-03,  3.164162001303527e-05, -2.397252437263026e-07,
  1.483593383369504e-09,  1.584910749450522e-11,  4.208593570446135e-13,  1.000251230255578e-15, -4.127543690499196e-16, -1.120550002728348e-17, -1.552262178126461e-20,
  6.961014438241966e-21,  3.964071886224194e-01, -5.268486405072512e-03,  4.549146489649666e-05, -2.755038208894866e-07,  7.525497435632774e-10,  4.545978401623687e-11,
  5.801623815173089e-13,  2.181638471115051e-15, -6.933106522659011e-16, -1.946384963711051e-17, -2.784363857149134e-20,  1.185699897847438e-20,  5.821929863171065e-01,
 -7.511867989130981e-03,  5.661587233574046e-05, -1.867840806079741e-07, -1.867905289520614e-09,  9.621730768810121e-11,  9.596478348648227e-13,  4.113220580551527e-16,
 -1.067288857594218e-15, -3.251050062411541e-17, -5.379980394079318e-20,  1.938162454054792e-20,  8.122891549545196e-01, -9.993041358942009e-03,  5.744380284271499e-05,
  1.650807887104422e-07, -7.094460162139689e-09,  1.480861497293034e-10,  2.399370929458341e-12, -1.201972674053923e-14, -1.649090016449276e-15, -5.213148680819898e-17,
 -1.429189593838384e-19,  3.185949072576507e-20,  1.093722825321711e+00, -1.235521383394258e-02,  3.099975658193493e-05,  9.833135422080277e-07, -1.194376852209199e-08,
  7.013373299169980e-11,  7.005013555527648e-12, -1.899373178788317e-14, -3.545720676918428e-15, -7.918405951101841e-17, -2.603715437683854e-19,  5.148616160524952e-20,
  1.434088787464395e+00, -1.341602599700742e-02, -6.177548608647183e-05,  2.071231988344316e-06,  1.177843128626972e-08, -4.637647516702420e-10,  7.138014876796119e-12,
  2.935553809096730e-13, -7.548527103368435e-15, -3.063770919242861e-16,  7.249124085164958e-19,  1.643671944466410e-19,  1.818478763265096e+00, -8.642013312603091e-03,
 -2.248481332159351e-04, -2.394327809130261e-06,  6.475151526961208e-08,  3.294682766059418e-09,  4.134280020506114e-11, -1.381125943272196e-12, -7.020881128775246e-14,
 -8.515870259097443e-16,  3.221789741825884e-17,  1.582856207096970e-18,  1.442869068158411e-02, -1.954281696573561e-04,  1.951706563340821e-06, -1.737079850965228e-08,
  1.845690261663685e-10,  3.574740478848672e-13,  2.201590132878960e-14, -1.097474288363205e-15, -3.890081421647432e-17, -1.629961452046233e-19,  2.637028613696349e-20,
  7.699767507351556e-22,  5.799874440691549e-02, -7.827405104516892e-04,  7.707304206512276e-06, -6.659763247344404e-08,  6.898182582217912e-10,  2.319910245836125e-12,
  8.019517551250659e-14, -4.384554562233464e-15, -1.607441640489380e-16, -6.649152801395269e-19,  1.079996191591504e-19,  3.166002531020387e-21,  1.315920464150070e-01,
 -1.764577746602261e-03,  1.693119635315123e-05, -1.381632787124989e-07,  1.359494963260591e-09,  8.677621763996616e-12,  1.520339700137986e-13, -9.907176162958048e-15,
 -3.814008582410754e-16, -1.564528120245554e-18,  2.533698905920882e-19,  7.470593884694958e-21,  2.367855415833505e-01, -3.143495871873603e-03,  2.891953130820232e-05,
 -2.129250993327518e-07,  1.894596143912676e-09,  2.443415329924739e-11,  2.067330295764804e-13, -1.801906192307685e-14, -7.287951704282386e-16, -3.038264975305735e-18,
  4.801916090207595e-19,  1.425303632235566e-20,  3.760405542966809e-01, -4.917500270247667e-03,  4.229004824940636e-05, -2.554653944721637e-07,  1.790297070252685e-09,
  5.698509591819625e-11,  2.310818806690293e-13, -3.012676687993590e-14, -1.245588178283009e-15, -5.534137188023884e-18,  8.226605238676627e-19,  2.460419677889964e-20,
  5.530366581457187e-01, -7.068260646199902e-03,  5.426251519352420e-05, -2.001035432531780e-07,  2.632589624642607e-10,  1.144814485178094e-10,  3.260804392405183e-13,
 -5.074716407395687e-14, -2.000167753968134e-15, -9.966428392939193e-18,  1.345868705439778e-18,  4.077933738894582e-20,  7.732462333016135e-01, -9.527252413557501e-03,
  5.885095695756622e-05,  7.814831716067386e-08, -3.622208717253275e-09,  1.939780630443022e-10,  1.053736824790627e-12, -9.240196744201649e-14, -3.173242209768392e-15,
 -1.707350450378757e-17,  2.174484579565168e-18,  6.808706888495585e-20,  1.044868324473510e+00, -1.206310143768957e-02,  4.172767231343177e-05,  8.121242946032986e-07,
 -8.980240448510932e-09,  2.164807874520256e-10,  4.474436425233227e-12, -1.742352115958273e-13, -5.824111503795493e-15, -2.107741607333054e-17,  3.683544175996107e-18,
  1.190115373501532e-19,  1.379597373070939e+00, -1.380824002524694e-02, -3.605972793262010e-05,  2.196970554228550e-06,  4.699700844427606e-09, -2.307151401702979e-10,
  1.044991742447285e-11, -1.026303849110941e-13, -1.599765515410026e-14, -9.888710038540834e-17,  1.034421274087886e-17,  2.533304856892299e-19,  1.780162976567518e+00,
 -1.053284027078753e-02, -2.450622824783768e-04, -7.952065718360120e-07,  1.360465835276663e-07,  3.553093419927276e-09, -3.078533231887440e-11, -3.725758612616498e-12,
 -6.001210241000600e-14,  1.874145063335802e-15,  9.802890845571628e-17,  6.810658883604446e-19,  1.367695687765512e-02, -1.805974449610773e-04,  1.761269912785999e-06,
 -1.434475352485427e-08,  1.937948909832275e-10,  3.798723997422147e-13, -2.520720815228672e-14, -2.170973097169215e-15, -1.848000041081889e-17,  1.446953431495849e-18,
  4.743754732031997e-20, -1.638460885882908e-22,  5.498630790434109e-02, -7.240871765604776e-04,  6.976085901206455e-06, -5.513691708212490e-08,  7.425509127768572e-10,
  2.204313436285575e-12, -1.107400153777708e-13, -8.823886057258060e-15, -7.685253300803306e-17,  5.942586119564853e-18,  1.949887622736703e-19, -6.583288295776098e-22,
  1.247946745288687e-01, -1.635376321403546e-03,  1.540980067550970e-05, -1.149436732242269e-07,  1.540022056660190e-09,  7.651703483425601e-12, -2.872112462894875e-13,
 -2.045730464838861e-14, -1.841658201556073e-16,  1.398785950379029e-17,  4.601006311929398e-19, -1.492909063142325e-21,  2.246588657190254e-01, -2.921806848738833e-03,
  2.656272852791630e-05, -1.786512287294525e-07,  2.378557103469877e-09,  2.076680514453235e-11, -6.075344486613514e-13, -3.823568740707816e-14, -3.562142039301016e-16,
  2.656141547038651e-17,  8.786886319734568e-19, -2.685010445161886e-21,  3.570285806278805e-01, -4.590868440559435e-03,  3.943393968660212e-05, -2.177692567986755e-07,
  2.894063934912637e-09,  4.799814419121915e-11, -1.143420240863460e-12, -6.483304692101377e-14, -6.161441231759089e-16,  4.544350584782814e-17,  1.520144873244438e-18,
 -4.258508227799695e-21,  5.256169383714538e-01, -6.643520042624709e-03,  5.196184675421328e-05, -1.777623179322672e-07,  2.478893282786498e-09,  9.814809878852823e-11,
 -1.951231478694795e-12, -1.067889320774760e-13, -9.955713014895939e-16,  7.410772180570096e-17,  2.522926727909489e-18, -6.219478507295484e-21,  7.360837809525307e-01,
 -9.053380315308668e-03,  5.957057888533297e-05,  5.151718733751284e-08,  2.416148556222118e-10,  1.769201156118526e-10, -2.895035039144343e-12, -1.814226161661665e-13,
 -1.558133384168620e-15,  1.210232984373488e-16,  4.186200615926298e-18, -8.481183866719331e-21,  9.973423042258426e-01, -1.169238352917975e-02,  5.076739812384030e-05,
  7.068774210061454e-07, -4.079231373307536e-09,  2.448292070165288e-10, -2.866841668072318e-12, -3.344775490551834e-13, -2.755772693237452e-15,  2.170637427565605e-16,
  7.292111175587900e-18, -1.255828960174180e-20,  1.323955869936181e+00, -1.399025622534927e-02, -9.358244039285054e-06,  2.246850291049966e-06,  2.059759608995562e-09,
 -7.216802288852085e-11,  5.623229675814614e-13, -5.715922261227995e-13, -9.739385279785343e-15,  4.939437567843266e-16,  1.697540737405126e-17, -7.403397432233557e-20,
  1.734108987624996e+00, -1.248955223786780e-02, -2.394333132087746e-04,  1.871582961690752e-06,  1.905122968149522e-07,  1.434877074712603e-09, -1.464822024616798e-10,
 -3.827854939722093e-12,  7.324618402661061e-14,  5.020474700921193e-15,  1.958093888959400e-17, -4.572115481109095e-18,  1.298173199665198e-02, -1.671428627418917e-04,
  1.607823645822212e-06, -1.123725845678580e-08,  1.903221543569724e-10, -9.612345325292366e-13, -8.411149037144121e-14, -1.617498600984157e-15,  5.975767910846190e-17,
  2.502539485167287e-18, -1.238249500924817e-20, -2.492836441790999e-21,  5.219767402137737e-02, -6.707211021751258e-04,  6.386479836644963e-06, -4.313379158051579e-08,
  7.396323028954793e-10, -3.449119750547274e-12, -3.504886247661021e-13, -6.579110694880341e-15,  2.446947744914982e-16,  1.029144995003174e-17, -5.058404372321846e-20,
 -1.025595484616684e-20,  1.184915927638136e-01, -1.517188120186783e-03,  1.418161006964260e-05, -8.965317258860401e-08,  1.576692517147601e-09, -6.199035616717305e-12,
 -8.441650442317386e-13, -1.526582274330172e-14,  5.738863322834696e-16,  2.429049704890872e-17, -1.180259813402333e-19, -2.423447971509733e-20,  2.133840107246097e-01,
 -2.717208748461721e-03,  2.465737401085009e-05, -1.384374679300021e-07,  2.559283919943200e-09, -6.842648701849023e-12, -1.650622089086889e-12, -2.853935868510769e-14,
  1.087587481852035e-15,  4.635332824795337e-17, -2.214870617888169e-19, -4.636726269116970e-20,  3.392806909058708e-01, -4.285002539617187e-03,  3.712365492781306e-05,
 -1.659095947275995e-07,  3.428894880215519e-09, -1.557421513919893e-12, -2.913663197780779e-12, -4.831588610320676e-14,  1.867055186476909e-15,  7.995720440900288e-17,
 -3.738899710463675e-19, -8.040826200300526e-20,  4.998618592572515e-01, -6.235556127169128e-03,  5.012035676268729e-05, -1.259840914388004e-07,  3.725597106390015e-09,
  1.494622738281388e-11, -4.861105192999175e-12, -7.920140188494551e-14,  3.086116090628407e-15,  1.319426497551443e-16, -6.035461200436877e-19, -1.340073411593645e-19,
  7.008277099945522e-01, -8.574041522102241e-03,  6.031168998899618e-05,  7.814893163512389e-08,  2.665665645511418e-09,  4.594404084511517e-11, -7.809516828271275e-12,
 -1.336450780314460e-13,  5.157522089401314e-15,  2.177752969758565e-16, -9.950418764942500e-19, -2.248123252026019e-19,  9.514376450814407e-01, -1.125309208381432e-02,
  5.899890658904532e-05,  6.737917658020237e-07, -6.432429408944515e-10,  6.276354105403416e-11, -1.192881040008458e-11, -2.489872622092115e-13,  9.159797397652198e-15,
  3.838838333118874e-16, -1.934652546422478e-18, -4.041942177680424e-19,  1.268016491081921e+00, -1.395684676499910e-02,  1.774059375280358e-05,  2.263171078462630e-06,
 -6.415207648627060e-10, -2.652547433964366e-10, -1.630685704208238e-11, -4.888847292621661e-13,  1.719223544403732e-14,  8.524311795604410e-16, -5.615618918506973e-18,
 -9.324016645244296e-19,  1.680536365955273e+00, -1.426257760731819e-02, -1.984403456084696e-04,  4.928777114933727e-06,  1.774346111323208e-07, -2.940571120192429e-09,
 -1.951931487024515e-10,  1.105754202585742e-12,  2.115119485679142e-13,  1.070894505165952e-15, -2.104233846281868e-16, -3.498969076079549e-18,  1.233810188177113e-02,
 -1.547701252041443e-04,  1.490227229024373e-06, -8.466105489292814e-09,  1.486818065013469e-10, -3.233063708124865e-12, -9.107525373416107e-14,  1.415122614443765e-15,
  1.133433708404163e-16, -2.246563609739225e-19, -1.133170965737675e-19, -1.005028619926763e-21,  4.961396820277261e-02, -6.215069494796237e-04,  5.935998288927456e-06,
 -3.235121988299875e-08,  5.775119757004130e-10, -1.288122526853608e-11, -3.775493688393404e-13,  5.860172470512517e-15,  4.651689039401924e-16, -9.229797318465064e-19,
 -4.663732314489930e-19, -4.145435755875498e-21,  1.126435157613704e-01, -1.407626841944197e-03,  1.324919126935476e-05, -6.661712669926356e-08,  1.229349334419765e-09,
 -2.879207999232496e-11, -9.022726335043881e-13,  1.398275952994058e-14,  1.094595298993535e-15, -2.183061298005348e-18, -1.102587961345223e-18, -9.834316282685707e-21,
  2.029001226769401e-01, -2.525924011510053e-03,  2.322979556311434e-05, -1.009187770954068e-07,  1.987864680858287e-09, -5.073745787627879e-11, -1.748199264664127e-12,
  2.704520332304082e-14,  2.081678075333051e-15, -4.216745349444615e-18, -2.110649131057144e-18, -1.890349075616360e-20,  3.227233305097197e-01, -3.995073032126673e-03,
  3.544768368141673e-05, -1.154027648482200e-07,  2.634107307037336e-09, -7.859257364633351e-11, -3.060283426894870e-12,  4.728731818701467e-14,  3.580893040233706e-15,
 -7.531712548581844e-18, -3.661311689936370e-18, -3.290156528564582e-20,  4.757133909903798e-01, -5.839648356270308e-03,  4.895407417090885e-05, -7.082306191150597e-08,
  2.752947701161554e-09, -1.132522084563836e-10, -5.086060333215282e-12,  7.868068509701650e-14,  5.905275271379949e-15, -1.345070812171389e-17, -6.100858189372768e-18,
 -5.473677489840792e-20,  6.675034968830240e-01, -8.087072770478071e-03,  6.150023752063777e-05,  1.171163143538288e-07,  1.531647364034748e-09, -1.612776193188471e-10,
 -8.236100362975166e-12,  1.286200472211150e-13,  9.765246669989164e-15, -2.589312300393617e-17, -1.022792644368180e-17, -8.998207568804980e-20,  9.074202080476533e-01,
 -1.074894826425257e-02,  6.700898363533336e-05,  6.563635057761814e-07, -2.595102397361268e-09, -2.627426124695709e-10, -1.303949086752377e-11,  2.134241510312077e-13,
  1.707137291853476e-14, -5.865868115309285e-17, -1.836411007695844e-17, -1.479204188631748e-19,  1.212643981181993e+00, -1.370702302975004e-02,  4.458381878376934e-05,
  2.185997663021275e-06, -1.053974342970572e-08, -7.339797446511474e-10, -1.847225885902830e-11,  4.259029468367286e-13,  3.374368570437440e-14, -1.779170632206255e-16,
 -4.067611049746812e-17, -2.099354237672035e-19,  1.620745885872687e+00, -1.557127232436369e-02, -1.249649106146490e-04,  7.066843519705594e-06,  7.816278484730805e-08,
 -6.515383481053702e-09, -7.609566642698300e-11,  6.753149804921970e-12,  9.055032404640615e-14, -7.162656951420473e-15, -1.161986910265781e-16,  7.578232798071585e-18,
  1.174227135108991e-02, -1.432198292915911e-04,  1.400442612727688e-06, -6.702811779980183e-09,  6.734255907694635e-11, -4.572724124994319e-12, -8.171089960440250e-15,
  4.044933596101812e-15,  2.733158643478768e-17, -4.062960562484938e-18, -4.060277014999218e-20,  3.957523123236264e-21,  4.722065008398444e-02, -5.754371219633936e-04,
  5.593350248622460e-06, -2.557997845207431e-08,  2.506524244524641e-10, -1.845256519643297e-11, -3.591628907914254e-14,  1.664247821207840e-14,  1.112575422909099e-16,
 -1.671455070496153e-17, -1.664946038886411e-19,  1.631965886819513e-20,  1.072203384294177e-01, -1.304547021350858e-03,  1.254551627763220e-05, -5.253048170596965e-08,
  4.876954012912299e-10, -4.217156602507044e-11, -9.331152233426466e-14,  3.930920420553720e-14,  2.580070714692160e-16, -3.948951353995408e-17, -3.908589963307266e-19,
  3.871761221302477e-20,  1.931610787233464e-01, -2.344479176642829e-03,  2.216974795029626e-05, -7.912531467923984e-08,  6.510351544736162e-10, -7.681067850586059e-11,
 -1.981534335317121e-13,  7.507089540034200e-14,  4.795843030426093e-16, -7.552858798224402e-17, -7.391046076318726e-19,  7.452039646348639e-20,  3.073022558504096e-01,
 -3.716456666688627e-03,  3.425269048904276e-05, -8.915265074305398e-08,  4.971487835090692e-10, -1.244773111199059e-10, -3.756280106483263e-13,  1.295235433283288e-13,
  7.968356757559742e-16, -1.308890568337608e-16, -1.255193044463755e-18,  1.303198074501705e-19,  4.531334624033241e-01, -5.450876493108620e-03,  4.827517538598258e-05,
 -5.041782240626209e-08, -4.520772507758837e-10, -1.896805261374974e-10, -6.479018973257416e-13,  2.132961041643526e-13,  1.244793425743182e-15, -2.178387346802035e-16,
 -2.012295530670620e-18,  2.197522563483560e-19,  6.361482978356399e-01, -7.589339062948679e-03,  6.291623293430362e-05,  1.068989325931109e-07, -3.210449119633830e-09,
 -2.841303053395203e-10, -9.643963435069280e-13,  3.483846768784882e-13,  1.876066000691421e-15, -3.643180492830197e-16, -3.121099231954554e-18,  3.749062551894299e-19,
  8.655447975290337e-01, -1.018257229760002e-02,  7.441579590064794e-05,  5.588666792853443e-07, -1.020323961723256e-08, -4.492842534010549e-10, -7.371921110896829e-13,
  5.878616149169538e-13,  2.680650264289577e-15, -6.476853090743442e-16, -4.632756822365631e-18,  6.899991106698392e-19,  1.158689685150788e+00, -1.324953510193425e-02,
  6.925749884321049e-05,  1.881902118544805e-06, -2.812152146370572e-08, -9.290803260756124e-10,  5.451933899673689e-12,  1.109411929712992e-12,  1.631252258062887e-15,
 -1.359686435557281e-15, -4.616267961132612e-18,  1.572315527088808e-18,  1.557014988280368e+00, -1.622073899170157e-02, -3.709793208805657e-05,  7.242710722169511e-06,
 -5.447105069841864e-08, -5.997985914870252e-09,  1.125156420822219e-10,  5.340469084619590e-12, -1.633769373791751e-13, -4.672481143047604e-15,  2.120180465114599e-16,
  3.861440265257246e-18,  1.119130654513653e-02, -1.323265337038207e-04,  1.323526874337447e-06, -6.329106950699653e-09, -1.697421193046190e-11, -3.448433490388986e-12,
  9.517153917381959e-14,  2.621001549301048e-15, -1.048429933046048e-16, -2.198153224189889e-18,  1.164114202371306e-19,  1.679699667320144e-21,  4.500651097451231e-02,
 -5.318775430106208e-04,  5.298557159170047e-06, -2.441039420501808e-08, -8.960403856410221e-11, -1.388594190440550e-11,  3.887994708797654e-13,  1.075378204831918e-14,
 -4.317853237152724e-16, -8.999727459048725e-18,  4.799427313226092e-19,  6.874354751769254e-21,  1.021989903318219e-01, -1.206634726164574e-03,  1.193476723209109e-05,
 -5.122267444704754e-08, -2.898450625906573e-10, -3.160539468173451e-11,  9.078692998422151e-13,  2.527228732792603e-14, -1.021894991315696e-15, -2.107730011182113e-17,
  1.138180807070770e-18,  1.608259509712037e-20,  1.841319627577478e-01, -2.170856997040414e-03,  2.123316757538190e-05, -8.054384302619948e-08, -7.643820693793388e-10,
 -5.715888727259974e-11,  1.708011636158035e-12,  4.787662496781236e-14, -1.958750189717120e-15, -3.974607656092414e-17,  2.189168082884311e-18,  3.024976253791180e-20,
  2.929776415575992e-01, -3.446765498915709e-03,  3.315021302935703e-05, -1.003764229493187e-07, -1.792702321646375e-09, -9.150191712598189e-11,  2.898211640113962e-12,
  8.157404883662952e-14, -3.402047823561709e-15, -6.735276102360903e-17,  3.823823740285324e-18,  5.095910866620778e-20,  4.320979791502660e-01, -5.067501832386972e-03,
  4.750437318783927e-05, -8.682764228023147e-08, -3.925369704579875e-09, -1.363764275528142e-10,  4.706020566680771e-12,  1.316498815194120e-13, -5.670716612931371e-15,
 -1.080750779771618e-16,  6.433556120662350e-18,  8.066289805065298e-20,  6.068039331556346e-01, -7.082174926771887e-03,  6.370823000364617e-05,  1.209488515426962e-08,
 -8.351216245294060e-09, -1.955896621782916e-10,  7.679915635911225e-12,  2.075123749893651e-13, -9.477668715738402e-15, -1.694605172614406e-16,  1.092312029192857e-17,
  1.222638779731172e-19,  8.260428422575317e-01, -9.563857239992221e-03,  7.985814988182895e-05,  3.282623438517647e-07, -1.807372938996318e-08, -2.810874665642972e-10,
  1.351241363421147e-11,  3.244775345340273e-13, -1.676628123492621e-14, -2.634825450554392e-16,  1.984813953551533e-17,  1.712859097132723e-19,  1.106930149062288e+00,
 -1.261410798887599e-02,  8.857836814228200e-05,  1.300516498884383e-06, -4.303396291821013e-08, -4.627938344378498e-10,  3.039345331862377e-11,  4.716851141821232e-13,
 -3.528554847405780e-14, -3.601731048556335e-16,  4.326016201877593e-17,  1.073135743366795e-19,  1.492057425812382e+00, -1.619264796635989e-02,  4.121219053917824e-05,
  5.597050809363690e-06, -1.388000425373585e-07, -2.186810285993964e-09,  1.760621036694824e-10, -8.324038567766162e-13, -1.714459179366784e-13,  3.620254828944046e-15,
  1.286659031194450e-16, -5.863210449113363e-18,  1.068268353054418e-02, -1.220510742184538e-04,  1.244124486379441e-06, -7.010814496675925e-09, -5.930408483430275e-11,
 -7.021567876567473e-13,  1.164141314085972e-13, -1.062806433545645e-15, -9.828108028990958e-17,  2.227178193519645e-18,  6.923438046334283e-20, -3.022357477554958e-21,
  4.296186491416987e-02, -4.907025846518715e-04,  4.989714494549460e-06, -2.748700079185727e-08, -2.584551544645683e-10, -2.663220908034818e-12,  4.754394230112258e-13,
 -4.387601024456987e-15, -4.030495957675577e-16,  9.198249994150214e-18,  2.833549855925411e-19, -1.247731041746259e-20,  9.755935094076384e-02, -1.113733560127381e-03,
  1.127572954921578e-05, -5.956483740838681e-08, -6.676211594718981e-10, -5.392278779495425e-12,  1.109139800015517e-12, -1.043626606017252e-14, -9.466818016475156e-16,
  2.187863229719107e-17,  6.631064369202281e-19, -2.965706242833353e-20,  1.757817563738935e-01, -2.005136378629114e-03,  2.016366470682906e-05, -9.937451164626691e-08,
 -1.428969170238891e-09, -7.853673040451461e-12,  2.081599710736067e-12, -2.019410048720434e-14, -1.793135593475958e-15,  4.226396337316255e-17,  1.248640608492410e-18,
 -5.722739021690310e-20,  2.797125170775052e-01, -3.186981117316892e-03,  3.172699556677560e-05, -1.393833439495950e-07, -2.811242224950074e-09, -7.979631225690684e-12,
  3.512174905154204e-12, -3.568332978745298e-14, -3.058739067642769e-15,  7.425778364546523e-17,  2.110266829865355e-18, -1.003825438045084e-19,  4.125797181541533e-01,
 -4.692865077696715e-03,  4.601794813411509e-05, -1.644607242752271e-07, -5.339403324364567e-09, -1.460803169298492e-12,  5.631877613960226e-12, -6.135893485612906e-14,
 -4.958437500052316e-15,  1.259050367724950e-16,  3.368914091799951e-18, -1.697491269035232e-19,  5.794919762646991e-01, -6.574425149032126e-03,  6.295882002155899e-05,
 -1.414871562084934e-07, -1.013896179106645e-08,  2.163150538742245e-11,  8.939520966354508e-12, -1.085574245038316e-13, -7.915124172231639e-15,  2.159196026383159e-16,
  5.227780960993550e-18, -2.896782863316494e-19,  7.890827453920257e-01, -8.914453595439758e-03,  8.193945821406237e-05,  1.366929037078236e-08, -2.004697750092131e-08,
  8.834545196897663e-11,  1.474826331816492e-11, -2.139202805254661e-13, -1.283333926566407e-14,  3.977619698867750e-16,  7.936192902120439e-18, -5.272839307521673e-19,
  1.057972698001654e+00, -1.185519465355735e-02,  9.988288354454383e-05,  5.797147747986591e-07, -4.459378929558634e-08,  2.970082584542593e-10,  2.808844132488759e-11,
 -5.594332096238634e-13, -2.150734463835661e-14,  8.920820677286134e-16,  1.010209548774741e-17, -1.127611977500962e-18,  1.428315707511738e+00, -1.563395645924085e-02,
  9.430776482388810e-05,  3.238658023040148e-06, -1.447735540728113e-07,  1.282387479940921e-09,  9.969156690384012e-11, -3.740914849134080e-12, -8.946890594232772e-15,
  3.972415927221650e-15, -8.184637969930291e-17, -2.201721747432415e-18,  1.021382937823440e-02, -1.124508816242858e-04,  1.154289143116346e-06, -7.935648429824781e-09,
 -4.929219071017088e-11,  1.465914285153742e-12,  5.695672120737607e-14, -2.653364953300468e-15, -1.715610662290847e-19,  2.440503094339730e-18, -4.566622873630074e-20,
 -1.396634814100853e-21,  4.107670112380413e-02, -4.521748632011702e-04,  4.635141762902905e-06, -3.149194539340806e-08, -2.136016392459454e-10,  6.172734784134114e-12,
  2.310774483509846e-13, -1.088301556426851e-14,  6.107397915824402e-19,  1.000896929978516e-17, -1.890469857431232e-19, -5.698877434711901e-21,  9.328004525300261e-02,
 -1.026567935420359e-03,  1.049758924491584e-05, -6.981355646831337e-08, -5.470868486237907e-10,  1.514379986176920e-11,  5.327335433858832e-13, -2.557633839323131e-14,
  7.009495087895425e-18,  2.351176552068380e-17, -4.514976552379902e-19, -1.326357393496937e-20,  1.680757331381474e-01, -1.848981377427445e-03,  1.883683693132095e-05,
 -1.210686967240286e-07, -1.158947133103792e-09,  3.046243366238412e-11,  9.815067279656035e-13, -4.852159302266062e-14,  3.005138398616875e-17,  4.454507106509786e-17,
 -8.774529169507598e-19, -2.475455276125823e-20,  2.674605705020796e-01, -2.940604957065903e-03,  2.979275516551717e-05, -1.815631425458669e-07, -2.254097681401388e-09,
  5.609951987462893e-11,  1.610568451952999e-12, -8.308577022349860e-14,  9.536547539360930e-17,  7.602149290722717e-17, -1.554574855642856e-18, -4.124930106087083e-20,
  3.945300479894966e-01, -4.334026436020905e-03,  4.355241906262482e-05, -2.436277668615629e-07, -4.228804243095572e-09,  9.991434089653807e-11,  2.475196876525170e-12,
 -1.358600914646433e-13,  2.670477038398687e-16,  1.233492412663951e-16, -2.665133841047495e-18, -6.433310299502286e-20,  5.541871008194204e-01, -6.080202027020764e-03,
  6.033582788987978e-05, -2.900394742607414e-07, -7.921209852481633e-09,  1.791001021789348e-10,  3.668917671803920e-12, -2.211894314113384e-13,  7.283400575945070e-16,
  1.972521915591774e-16, -4.635688181459970e-18, -9.567576982924539e-20,  7.547296219798652e-01, -8.263488220110349e-03,  8.029240696244735e-05, -2.764044679792449e-07,
 -1.540487192130210e-08,  3.383607335921949e-10,  5.348257643464320e-12, -3.766768165741845e-13,  2.131700671639903e-15,  3.210295270131020e-16, -8.679651385370029e-18,
 -1.319303039739832e-19,  1.012177837378144e+00, -1.103977613739434e-02,  1.028560587646674e-04, -5.597252735689856e-08, -3.345420036574347e-08,  7.356579145022046e-10,
  7.668524303515397e-12, -7.405252920132979e-13,  7.934541123931760e-15,  5.440129051823502e-16, -1.959634906013341e-17, -1.070662197630512e-19,  1.367482772299127e+00,
 -1.476079738986338e-02,  1.204453614916547e-04,  1.222711634459931e-06, -1.033824294208841e-07,  2.492466415267441e-09,  7.340379276408686e-12, -2.459242771190151e-12,
  6.676034657049113e-14,  3.311062877510510e-16, -7.139771120454821e-17,  1.707518493987642e-18,  9.781875836844322e-03, -1.036082986209805e-04,  1.055470340947485e-06,
 -8.439877649562180e-09, -1.203333427460918e-11,  2.007348262101438e-12, -7.145733160365215e-15, -1.671526969684321e-15,  4.810623184427929e-17,  2.460655296991689e-19,
 -4.689309240275842e-20,  9.136174367098926e-22,  3.933970275284052e-02, -4.166526030385611e-04,  4.241507883648387e-06, -3.372049209526337e-08, -5.816360785752559e-11,
  8.336939397361912e-12, -3.133752770746843e-14, -6.824447491955512e-15,  1.977711296558379e-16,  9.757514690875714e-19, -1.922009458238558e-19,  3.781801000744168e-21,
  8.933625362520213e-02, -9.460607242809298e-04,  9.618906296280001e-06, -7.568364882030022e-08, -1.714277945366177e-10,  2.000029420096765e-11, -8.184528781518419e-14,
 -1.590692723707909e-14,  4.666417514091302e-16,  2.151946729738697e-18, -4.509972802332268e-19,  9.029645835087367e-21,  1.609716195649418e-01, -1.704360822374043e-03,
  1.729578335348259e-05, -1.339016385016709e-07, -4.183303273066559e-10,  3.902994893809346e-11, -1.781422700476945e-13, -2.979244134330111e-14,  8.904590713013655e-16,
  3.662423972799271e-18, -8.529517265571044e-19,  1.753722014455929e-20,  2.561602953524328e-01, -2.711495948646109e-03,  2.743934776776134e-05, -2.073096745290884e-07,
 -9.232447850707664e-10,  6.922620632837930e-11, -3.590451806356530e-13, -5.003923563082547e-14,  1.536964819921741e-15,  5.185708145734271e-18, -1.451678962774514e-18,
  3.102552162282341e-20,  3.778708604629040e-01, -3.998284803741740e-03,  4.029592589302478e-05, -2.933060888542327e-07, -1.925157381937428e-09,  1.179213727113937e-10,
 -7.058801104989231e-13, -7.945977375478286e-14,  2.539702378650718e-15,  5.784400699866683e-18, -2.345139321791265e-18,  5.302093355238426e-20,  5.308069670597881e-01,
 -5.613298563769796e-03,  5.622313819914764e-05, -3.853264185726895e-07, -3.923918195512991e-09,  2.006378254127657e-10, -1.409290075478362e-12, -1.234662268917830e-13,
  4.190791808287283e-15,  2.483812780369829e-18, -3.722183799100857e-18,  9.157497616941367e-20,  7.229341399828771e-01, -7.638063725595754e-03,  7.573337918762125e-05,
 -4.651057808617314e-07, -8.132392387317327e-09,  3.560234289068306e-10, -3.008375027214641e-12, -1.936648868126279e-13,  7.254408213824966e-15, -1.598837945481822e-17,
 -5.969917841638806e-18,  1.685849061773198e-19,  9.696488461130554e-01, -1.022756298439624e-02,  9.947309011740230e-05, -4.698894906912044e-07, -1.837460407411054e-08,
  7.123293638330804e-10, -7.622861344905807e-12, -3.186769028955164e-13,  1.446829102799806e-14, -1.103184830081246e-16, -9.748248611182352e-18,  3.623892870580463e-19,
  1.310424888242969e+00, -1.376291223908587e-02,  1.268156802537877e-04, -4.213241685491656e-08, -5.611436060842814e-08,  2.078772218114118e-09, -3.287722876674122e-11,
 -5.338901496781684e-13,  4.548020559244832e-14, -1.055920537429776e-15, -3.776642669940095e-18,  1.000140226837676e-18,  9.383687981605762e-03, -9.556999872884707e-05,
  9.542953330528492e-07, -8.333342311285092e-09,  2.350100013612378e-11,  1.445518637300732e-12, -3.315136288699725e-14, -2.666327998042376e-16,  3.379057916220680e-17,
 -7.564665899209942e-19, -4.965250354150411e-21,  7.223247824349707e-22,  3.773838741634987e-02, -3.843428076941154e-04,  3.836501722938016e-06, -3.341020284453225e-08,
  8.924473420050132e-11,  5.995071758525160e-12, -1.370759401694463e-13, -1.063583619062683e-15,  1.381840062120710e-16, -3.114240203959852e-18, -1.970895896045461e-20,
  2.956317034561750e-21,  8.570013388030373e-02, -8.727598390013099e-04,  8.706759072884087e-06, -7.545439124285725e-08,  1.814957448903375e-10,  1.434643909701507e-11,
 -3.265066594283707e-13, -2.376093133474982e-15,  3.229923198794323e-16, -7.365361674576455e-18, -4.356575907950521e-20,  6.918958207608786e-21,  1.544206465228290e-01,
 -1.572478977372024e-03,  1.567317510062839e-05, -1.348085601952185e-07,  2.683739517399876e-10,  2.789047983110933e-11, -6.311721841846409e-13, -4.154128906159212e-15,
  6.074285216101216e-16, -1.410245981516358e-17, -7.452171564090494e-20,  1.303202809184946e-20,  2.457373635547881e-01, -2.502082933278123e-03,  2.490610987024693e-05,
 -2.118511501304486e-07,  2.898399532608179e-10,  4.919535342781915e-11, -1.107035336310270e-12, -6.246373643565198e-15,  1.026007442449278e-15, -2.445110053399185e-17,
 -1.068338272612748e-19,  2.204171385072769e-20,  3.624996505301193e-01, -3.690349564291624e-03,  3.666460933430390e-05, -3.067558469100872e-07,  1.299448165042710e-10,
  8.312838079674774e-11, -1.863152957468555e-12, -8.207106354974329e-15,  1.641609956893347e-15, -4.063235140204476e-17, -1.239331398956760e-19,  3.526488226814719e-20,
  5.092229326377898e-01, -5.182788153112087e-03,  5.134642281465331e-05, -4.187549778038780e-07, -4.538420527031815e-10,  1.397391306087930e-10, -3.133670175926759e-12,
 -8.653606389498370e-15,  2.576713517432071e-15, -6.749320571791667e-17, -7.420474172077441e-20,  5.509042230327161e-20,  6.935558206793422e-01, -7.056225413658022e-03,
  6.958972459947428e-05, -5.435751233052600e-07, -2.044699556648959e-09,  2.431602853721236e-10, -5.513108166870036e-12, -2.624801294634195e-15,  4.098210658369281e-15,
 -1.175776797357415e-16,  2.319061693214301e-19,  8.580104067766874e-20,  9.302887282432490e-01, -9.458324158771953e-03,  9.250222430013881e-05, -6.620107936486746e-07,
 -6.432887697580591e-09,  4.689900236169118e-10, -1.102940232845777e-11,  3.401287081974638e-14,  6.881188126688886e-15, -2.343066016763899e-16,  1.755918182928007e-18,
  1.305407862577339e-19,  1.257381336900680e+00, -1.276280583336963e-02,  1.221484883943953e-04, -6.528004320457714e-07, -2.293760637418810e-08,  1.240327020943295e-09,
 -3.298744445441471e-11,  3.475730265045302e-13,  1.197619514580077e-14, -6.864451738757156e-16,  1.488656221563208e-17, -1.382174276084174e-21,  9.016054939351469e-03,
 -8.832733269901047e-05,  8.573629781162132e-07, -7.769937969254187e-09,  4.437424894271327e-11,  6.572360082020513e-13, -2.955351082590382e-14,  3.891228225757083e-16,
  8.581545223687255e-18, -5.423489865129897e-19,  1.069819247450078e-20,  5.239045280317866e-23,  3.625990583566640e-02, -3.552222762896535e-04,  3.447515575575978e-06,
 -3.120429537299673e-08,  1.759759584017695e-10,  2.743780442198850e-12, -1.216929699154964e-13,  1.610527050266076e-15,  3.474127643727126e-17, -2.218782045610261e-18,
  4.406155909558955e-20,  2.046415921783598e-22,  8.234276304766447e-02, -8.066592078793327e-04,  7.826801337119291e-06, -7.068555694001586e-08,  3.896668396748910e-10,
  6.635091407766497e-12, -2.878050165175163e-13,  3.843126293291304e-15,  7.974887618112358e-17, -5.189650059857631e-18,  1.042802291128747e-19,  4.382139535683573e-22,
  1.483714081037036e-01, -1.453454400317242e-03,  1.409695183504948e-05, -1.268812003994419e-07,  6.746423011107002e-10,  1.307635918554052e-11, -5.505509125838502e-13,
  7.451287240188670e-15,  1.457720389531865e-16, -9.768831358665552e-18,  1.998436823224532e-19,  7.062786502185440e-22,  2.361116268842497e-01, -2.312858735254150e-03,
  2.241948900947475e-05, -2.007891346399713e-07,  1.009634117194711e-09,  2.343362558406157e-11, -9.517008315606406e-13,  1.313033451667121e-14,  2.357804423145462e-16,
 -1.651968376513650e-17,  3.468253522969263e-19,  8.937110178357779e-22,  3.483017691557634e-01, -3.411611068695602e-03,  3.304301476097326e-05, -2.937942173909856e-07,
  1.351762069926648e-09,  4.026671793196687e-11, -1.570314343338124e-12,  2.225984112635902e-14,  3.526368896687974e-16, -2.646643963575006e-17,  5.767576532814775e-19,
  7.036758223458681e-22,  4.892815699278794e-01, -4.792054426079409e-03,  4.635690221418156e-05, -4.076874239476976e-07,  1.608096271608956e-09,  6.876966812857898e-11,
 -2.569578809006910e-12,  3.786880250771320e-14,  4.942826136311004e-16, -4.159506253181557e-17,  9.577115829041864e-19, -7.090257736519368e-22,  6.664026871415077e-01,
 -6.525831694515640e-03,  6.300819813722243e-05, -5.443804160919042e-07,  1.550103318661107e-09,  1.210788553811597e-10, -4.341897203633313e-12,  6.785969242700088e-14,
  6.278744102548294e-16, -6.618961987428672e-17,  1.662212468192068e-18, -6.200761505577930e-21,  8.938835100386193e-01, -8.751210105930765e-03,  8.420524019173969e-05,
 -7.036028304760947e-07,  4.749582447379708e-10,  2.334882924187063e-10, -8.120495827108911e-12,  1.400714974634751e-13,  5.076087493996243e-16, -1.107994565779051e-16,
  3.260607606639758e-18, -2.889425906721150e-20,  1.208228224829263e+00, -1.182156685132579e-02,  1.128025080353056e-04, -8.605304387538835e-07, -5.118280799520416e-09,
  5.898582897720808e-10, -2.082073329600822e-11,  4.435192601531157e-13, -2.993426400791809e-15, -1.882736652465532e-16,  8.767043524248349e-18, -1.851723388182562e-19,
  8.675890966624687e-03, -8.182854753416227e-05,  7.687036124592414e-07, -6.989269224549391e-09,  5.140324573363342e-11,  9.463639505891507e-14, -1.716378520645460e-14,
  4.325266917724031e-16, -3.542331740918063e-18, -1.556440980613781e-19,  7.304684724191011e-21, -1.366742459735479e-22,  3.489187732818642e-02, -3.290888704568029e-04,
  3.091300099793737e-06, -2.809159600717423e-08,  2.056782855446916e-10,  4.282327149972329e-13, -7.063731483751077e-14,  1.777899924828715e-15, -1.473501055695314e-17,
 -6.318914741483401e-19,  2.987943261988570e-20, -5.626525815708091e-22,  7.923614303111964e-02, -7.473238715824965e-04,  7.019254345098209e-06, -6.372472418369066e-08,
  4.628740683702226e-10,  1.163428383372860e-12, -1.668826365059969e-13,  4.192619563756994e-15, -3.546457580634021e-17, -1.457900847386820e-18,  6.986676209445108e-20,
 -1.330513711274521e-21,  1.427737786130064e-01, -1.346569990862021e-03,  1.264565662137204e-05, -1.146358268667630e-07,  8.224817451912549e-10,  2.623557865227831e-12,
 -3.186562227136294e-13,  7.988453535885767e-15, -6.962664457410084e-17, -2.686341060249197e-18,  1.314493366015810e-19, -2.546302285792961e-21,  2.272040691026293e-01,
 -2.142837863561592e-03,  2.011875547399348e-05, -1.819923924822163e-07,  1.282097157177455e-09,  5.401908513447026e-12, -5.491732466570780e-13,  1.374101876278635e-14,
 -1.248019918083099e-16, -4.399026546909559e-18,  2.221004177702029e-19, -4.409307866742000e-21,  3.351622691227299e-01, -3.160952381237737e-03,  2.966780909099215e-05,
 -2.675459206534485e-07,  1.834129365367111e-09,  1.060862561922200e-11, -9.015743167103567e-13,  2.254252949255563e-14, -2.163992691925781e-16, -6.709980934117716e-18,
  3.553088739300582e-19, -7.306065212029602e-21,  4.708248085903678e-01, -4.440246175468898e-03,  4.165459334592040e-05, -3.739279912856408e-07,  2.456977110398695e-09,
  2.048226328205759e-11, -1.462631437100402e-12,  3.665534493207093e-14, -3.792019297709382e-16, -9.737620038142264e-18,  5.569213836687888e-19, -1.205653876578718e-20,
  6.412669141759283e-01, -6.047324197433871e-03,  5.668782564149860e-05, -5.052049854909338e-07,  3.087515484624773e-09,  4.017687186520786e-11, -2.433339801863554e-12,
  6.154424441261644e-14, -7.067520558425519e-16, -1.336332453275281e-17,  8.815269306721386e-19, -2.068032345782652e-20,  8.601730513448824e-01, -8.110919210342134e-03,
  7.593104026496777e-05, -6.679069488272567e-07,  3.510369098913057e-09,  8.463415467066831e-11, -4.409382110680765e-12,  1.144677858702161e-13, -1.538999151214084e-15,
 -1.520908196397883e-17,  1.457269320819285e-18, -3.949984878668901e-20,  1.162680416063522e+00, -1.096110427177914e-02,  1.022970827457455e-04, -8.712277273291444e-07,
  2.612891059743133e-09,  2.241411088069161e-10, -1.036652991558888e-11,  2.921772893810825e-13, -5.238702647383496e-15,  2.101289613621426e-17,  2.371001714893634e-18,
 -9.678414163408116e-20,  8.360364618757795e-03, -7.600040410775876e-05,  6.897676405955813e-07, -6.170218632342138e-09,  5.007588388906624e-11, -1.882220065644419e-13,
 -7.146908458607893e-15,  2.745116739784043e-16, -5.269646181170852e-18,  2.517105978754283e-20,  2.140493426934143e-21, -8.483777421442301e-23,  3.362292686844652e-02,
 -3.056507898745687e-04,  2.773973821961298e-06, -2.480856785317564e-08,  2.009839285439363e-10, -7.369193687269391e-13, -2.950642802161756e-14,  1.126224844162800e-15,
 -2.165349756005630e-17,  1.059949567665578e-19,  8.696333981679353e-21, -3.468660445640091e-22,  7.635449105799627e-02, -6.941021801041498e-04,  6.299159005032990e-06,
 -5.631305282397803e-08,  4.547923646110173e-10, -1.593262603458184e-12, -7.006781360838495e-14,  2.646917686847961e-15, -5.103583458980366e-17,  2.603518896535102e-19,
  2.009009499285905e-20, -8.104075801719294e-22,  1.375814349575101e-01, -1.250681898225880e-03,  1.134956552369277e-05, -1.014011873552995e-07,  8.150278570458833e-10,
 -2.650212022416209e-12, -1.347064839856363e-13,  5.017451792353078e-15, -9.717719597180343e-17,  5.258235260049822e-19,  3.709360013538572e-20, -1.522753710572073e-21,
  2.189412843510187e-01, -1.990270554265561e-03,  1.805950851630319e-05, -1.612093040647227e-07,  1.286738878042147e-09, -3.706697936155846e-12, -2.340379756187952e-13,
  8.566199330659468e-15, -1.670393907018267e-16,  9.773051063615818e-19,  6.093335976265311e-20, -2.567840434191067e-21,  3.229735282194994e-01, -2.935943741581575e-03,
  2.663707586910463e-05, -2.374796122936991e-07,  1.876367866695015e-09, -4.377500041048360e-12, -3.875707626207193e-13,  1.390169385028091e-14, -2.738788924785878e-16,
  1.771283787290549e-18,  9.340975204303952e-20, -4.095620875272940e-21,  4.537028497521931e-01, -4.124269310930172e-03,  3.741155510506937e-05, -3.329250123426947e-07,
  2.590744550448594e-09, -3.870579568346341e-12, -6.338903321245624e-13,  2.224424026808036e-14, -4.452709012637047e-16,  3.271461825631269e-18,  1.367624293354406e-19,
 -6.388845714146703e-21,  6.179474704781283e-01, -5.617188465095585e-03,  5.093948758329401e-05, -4.520132262349393e-07,  3.432291562027364e-09, -3.425886132247533e-13,
 -1.060097898641070e-12,  3.641094137543345e-14, -7.481273828013924e-16,  6.484316430434712e-18,  1.913732115329143e-19, -1.002845510108830e-20,  8.288949868497176e-01,
 -7.534479322303229e-03,  6.829311479396393e-05, -6.029629496652972e-07,  4.374720599942078e-09,  1.152457591503000e-11, -1.913591110257115e-12,  6.471146040971601e-14,
 -1.394507428544775e-15,  1.515974831089059e-17,  2.343472118319424e-19, -1.629714215278522e-20,  1.120407896135522e+00, -1.018357049303185e-02,  9.220414192566607e-05,
 -8.046221894747160e-07,  5.177274611171152e-09,  5.574943386829227e-11, -4.328744364235595e-12,  1.481813787645882e-13, -3.567673625282111e-15,  5.561662429316991e-17,
 -1.189281769645899e-19, -2.521919959434121e-20,  8.066949137853796e-03, -7.076514784933480e-05,  6.203842348021278e-07, -5.406153802884148e-09,  4.512549012853475e-11,
 -2.852960849364962e-13, -1.603399375161753e-15,  1.308629953012523e-16, -3.532925424115783e-18,  5.646168382733548e-20, -1.317432647908730e-22, -2.427572550960463e-23,
  3.244289728343700e-02, -2.845964652999776e-04,  2.494980503352577e-06, -2.173983199891841e-08,  1.813352206644862e-10, -1.139677505728063e-12, -6.767904437880614e-15,
  5.368167114286848e-16, -1.447835849515339e-17,  2.320465167195039e-19, -5.732590617400624e-22, -9.862467607041687e-23,  7.367475992634751e-02, -6.462911343124065e-04,
  5.665776106135239e-06, -4.936063377869186e-08,  4.112123362788317e-10, -2.557365102659877e-12, -1.664704449959366e-14,  1.261250197000243e-15, -3.396502807591897e-17,
  5.470937128561233e-19, -1.482053917553601e-21, -2.278338293160047e-22,  1.327529004046184e-01, -1.164535900516450e-03,  1.020879175305748e-05, -8.891868693852719e-08,
  7.393599170227805e-10, -4.523778899732806e-12, -3.351016587541788e-14,  2.389099357614143e-15, -6.421591079108714e-17,  1.042270315955630e-18, -3.195601551697406e-21,
 -4.206521689583927e-22,  2.112573869882522e-01, -1.853189794122722e-03,  1.624528663573756e-05, -1.414485128370019e-07,  1.172926064339783e-09, -7.004781343908974e-12,
 -6.145821317439814e-14,  4.072957563298129e-15, -1.092636136604801e-16,  1.793060938220552e-18, -6.403086301789986e-21, -6.910103807212177e-22,  3.116386063519281e-01,
 -2.733745133345867e-03,  2.396324634842297e-05, -2.085480453654972e-07,  1.722531046151801e-09, -9.921382990811279e-12, -1.080131389966931e-13,  6.591327047115650e-15,
 -1.765731939541959e-16,  2.943665965316283e-18, -1.258297406837497e-20, -1.059486075491918e-21,  4.377800365621759e-01, -3.840262902347832e-03,  3.366044679166368e-05,
 -2.927345180558718e-07,  2.403889171926424e-09, -1.308505391055789e-11, -1.879637715460162e-13,  1.049076788087893e-14, -2.810934009135367e-16,  4.795092593248043e-18,
 -2.526020628454910e-20, -1.552343378851044e-21,  5.962607032896015e-01, -5.230443583834980e-03,  4.584096164925018e-05, -3.982326474767928e-07,  3.240663760154423e-09,
 -1.600565881717025e-11, -3.342579638408158e-13,  1.699432364616328e-14, -4.572609985595411e-16,  8.080009060288677e-18, -5.440792555873400e-20, -2.178851048487741e-21,
  7.998056200976433e-01, -7.015882682326458e-03,  6.147853559703558e-05, -5.330866207821125e-07,  4.268936325681326e-09, -1.716092244712026e-11, -6.380238163602293e-13,
  2.953948332688330e-14, -8.062384829196353e-16,  1.512240027780468e-17, -1.377552741423818e-19, -2.717247766812248e-21,  1.081089790258488e+00, -9.483096796633403e-03,
  8.306755019723981e-05, -7.173089506069005e-07,  5.530362520953246e-09, -9.476083550545640e-12, -1.492790204378439e-12,  6.362129312719964e-14, -1.821603273687571e-15,
  3.876856723423793e-17, -5.391219763959416e-19,  5.520022276402332e-22,  7.793420572393645e-03, -6.604973712099474e-05,  5.596502699083278e-07, -4.730844824027785e-09,
  3.927323206894982e-11, -2.907809220726620e-13,  7.673253443154760e-16,  4.784111013195175e-17, -1.761726681743593e-18,  3.933245982870288e-20, -5.475035231507918e-22,
  3.944142210646022e-25,  3.134284618641815e-02, -2.656325777949829e-04,  2.250741832049536e-06, -1.902537766709727e-08,  1.578959453951775e-10, -1.166691986120980e-12,
  2.964409258951419e-15,  1.967700179609606e-16, -7.212347205063072e-18,  1.611147077515725e-19, -2.250881498833241e-21,  1.965086392493433e-24,  7.117664906447632e-02,
 -6.032263629316081e-04,  5.111194690048279e-06, -4.320209913017259e-08,  3.583700226631823e-10, -2.638515435698605e-12,  6.246795494834310e-15,  4.643084420840754e-16,
 -1.688844153699909e-17,  3.776686172794349e-19, -5.309970180389510e-21,  6.042847847223941e-24,  1.282516142605730e-01, -1.086939620158079e-03,  9.209671849981008e-06,
 -7.783743388488130e-08,  6.452019511261796e-10, -4.724388351739497e-12,  9.926201760318543e-15,  8.846396423349008e-16, -3.183838570391733e-17,  7.132541894544858e-19,
 -1.012490822110902e-20,  1.552605900027816e-23,  2.040942382244776e-01, -1.729708995495575e-03,  1.465571307711178e-05, -1.238501988200672e-07,  1.025518975257190e-09,
 -7.449604681014567e-12,  1.273412762431295e-14,  1.518825965851184e-15, -5.394051229021820e-17,  1.211859096751315e-18, -1.743987619562834e-20,  3.645107707037070e-23,
  3.010718288546835e-01, -2.551596666789446e-03,  2.161917486587936e-05, -1.826633509583561e-07,  1.510226801814017e-09, -1.084475530681754e-11,  1.229598684079027e-14,
  2.477324858534132e-15, -8.661107742350690e-17,  1.954851057340216e-18, -2.867965007476874e-20,  8.202385001599571e-23,  4.229361996672990e-01, -3.584397780341528e-03,
  3.036920898607907e-05, -2.565274655119142e-07,  2.116260122003919e-09, -1.493763488449672e-11,  3.860381082508375e-15,  3.973986449496652e-15, -1.365259666553566e-16,
  3.104969212112025e-18, -4.682435486011455e-20,  1.842717330507017e-22,  5.760433282807393e-01, -4.881976063779608e-03,  4.136167556668375e-05, -3.492434998676425e-07,
  2.871401310133527e-09, -1.972077273021551e-11, -2.327433988388706e-14,  6.477437673912210e-15, -2.185444162522796e-16,  5.036275729844519e-18, -7.913490652154522e-20,
  4.349365196021449e-22,  7.726868309003422e-01, -6.548511690326555e-03,  5.547794817572995e-05, -4.681265678953314e-07,  3.826504352702747e-09, -2.500228784775239e-11,
 -9.866436996527798e-14,  1.126052003524912e-14, -3.741167751559210e-16,  8.842454868660668e-18, -1.485926112434005e-19,  1.182578365895809e-21,  1.044434060288593e+00,
 -8.851507437965013e-03,  7.497960061833483e-05, -6.317836701750950e-07,  5.097764929447831e-09, -2.936838346603857e-11, -3.463145777943888e-13,  2.369120550383905e-14,
 -7.873824335866443e-16,  1.978873808197836e-17, -3.805095782626986e-19,  4.826866017921145e-21,  7.537830992672596e-03, -6.178936683095529e-05,  5.064626902367789e-07,
 -4.147641331067766e-09,  3.372236523107978e-11, -2.614999042596165e-13,  1.501309903828118e-15,  1.007724276647061e-17, -7.143423142137446e-19,  1.994317227682802e-20,
 -3.908784164986373e-22,  4.891469889278220e-24,  3.031494015080619e-02, -2.484986542122102e-04,  2.036841942315037e-06, -1.668038097502858e-08,  1.356055822982302e-10,
 -1.050757195319494e-12,  5.994955012433326e-15,  4.217209644113437e-17, -2.925128757135288e-18,  8.157451513290775e-20, -1.600766516586220e-21,  2.011577970210799e-23,
  6.884237178347714e-02, -5.643169691453881e-04,  4.625467744275608e-06, -3.787872710718771e-08,  3.078844802559947e-10, -2.382515979142339e-12,  1.344318025153697e-14,
  1.023300866677526e-16, -6.851588536556364e-18,  1.907345357820956e-19, -3.750924860186672e-21,  4.747910917703552e-23,  1.240455333224814e-01, -1.016830009856906e-03,
  8.334504496595189e-06, -6.825053352896761e-08,  5.545985974125683e-10, -4.283033837387238e-12,  2.375611038125415e-14,  2.023651295420541e-16, -1.291988795702945e-17,
  3.588212178942629e-19, -7.080019678539503e-21,  9.060083798022413e-23,  1.974008601152971e-01, -1.618140315590538e-03,  1.326312965641842e-05, -1.086058064231993e-07,
  8.821737529793963e-10, -6.793051783832001e-12,  3.673395812084660e-14,  3.634108994585349e-16, -2.188743409600793e-17,  6.062204905628385e-19, -1.202054951929465e-20,
  1.562186346192231e-22,  2.911980250147787e-01, -2.387016610009324e-03,  1.956514336803388e-05, -1.602001421614132e-07,  1.300530759421817e-09, -9.973046912243213e-12,
  5.193344790517544e-14,  6.236955051694353e-16, -3.511564287655732e-17,  9.699230111839592e-19, -1.937179366375118e-20,  2.572425347652007e-22,  4.090658027434212e-01,
 -3.353204320571452e-03,  2.748428246788830e-05, -2.250221405131930e-07,  1.825288533471257e-09, -1.391247307248329e-11,  6.833326348310744e-14,  1.056994540419481e-15,
 -5.522064641717603e-17,  1.521990690524902e-18, -3.072982060293436e-20,  4.206805692531053e-22,  5.571517314905426e-01, -4.567095243609899e-03,  3.743343260493684e-05,
 -3.064373646652667e-07,  2.482641748169162e-09, -1.874634017393581e-11,  8.336603201491536e-14,  1.823542574557455e-15, -8.788565921602020e-17,  2.422134053303918e-18,
 -4.975286067399319e-20,  7.122454808594008e-22,  7.473462724560692e-01, -6.126155765074353e-03,  5.021109727907572e-05, -4.109452749003703e-07,  3.322434262297005e-09,
 -2.468358497654000e-11,  8.936260259068725e-14,  3.350113653695288e-15, -1.483809315209933e-16,  4.112891391475762e-18, -8.707607207749196e-20,  1.338847277264795e-21,
  1.010181584727882e+00, -8.280656292992293e-03,  6.786724545758979e-05, -5.551881714147306e-07,  4.468742177195872e-09, -3.200355992588822e-11,  5.279100438460406e-14,
  7.357804344320650e-15, -3.000298950111679e-16,  8.532869289387391e-18, -1.931507749474189e-19,  3.409396957994543e-21,  7.298474149402975e-03, -5.792796405631802e-05,
  4.597622597380802e-07, -3.647908782647989e-09,  2.886464238652128e-11, -2.240998177258266e-13,  1.552254409855885e-15, -3.902333682013006e-18, -2.279133653645155e-19,
  8.359055674219156e-21, -1.988217749337862e-22,  3.527954802415013e-24,  2.935231732852209e-02, -2.329692372750527e-04,  1.849028036059472e-06, -1.467075345869487e-08,
  1.160802508240414e-10, -9.009719217314732e-13,  6.228503428693098e-15, -1.512025062100195e-17, -9.360550175543176e-19,  3.417342702440934e-20, -8.128769764560101e-22,
  1.444595186073707e-23,  6.665634620812731e-02, -5.290511657677844e-04,  4.198965999648534e-06, -3.331564774827215e-08,  2.635880396746962e-10, -2.044863519452379e-12,
  1.408783252730214e-14, -3.205136599931409e-17, -2.203297067068666e-18,  7.982585895946749e-20, -1.899156295537107e-21,  3.384136300976699e-23,  1.201065829587954e-01,
 -9.532854509972892e-04,  7.566016641370244e-06, -6.003004223934832e-08,  4.749010479092309e-10, -3.681440189625132e-12,  2.523047153794757e-14, -5.150873576900664e-17,
 -4.182629444476150e-18,  1.499390828440104e-19, -3.568777585130966e-21,  6.385329856400089e-23,  1.911325804346226e-01, -1.517018407817448e-03,  1.204022693775479e-05,
 -9.552774955304311e-08,  7.556185888359489e-10, -5.851303482727982e-12,  3.979870569430963e-14, -6.766055181861944e-17, -7.144916280093738e-18,  2.527051792327026e-19,
 -6.020200967294279e-21,  1.083548763987176e-22,  2.819513056562927e-01, -2.237846023086660e-03,  1.776124129894195e-05, -1.409155982665951e-07,  1.114411307371750e-09,
 -8.616611838681528e-12,  5.797187221683528e-14, -6.969816114892121e-17, -1.157399472163358e-17,  4.027938664863946e-19, -9.612817984041232e-21,  1.744941913234076e-22,
  3.960763061033074e-01, -3.143655175747272e-03,  2.495037099499136e-05, -1.979473709452238e-07,  1.564991100435457e-09, -1.207399230231284e-11,  7.993679652133089e-14,
 -3.628814943403089e-17, -1.839045605814561e-17,  6.282627905660103e-19, -1.504481219188636e-20,  2.765143834124393e-22,  5.394599129357212e-01, -4.281689219707761e-03,
  3.398253306252422e-05, -2.695932505879044e-07,  2.130512760250818e-09, -1.638235254524348e-11,  1.057591511462078e-13,  7.969977588847412e-17, -2.956297629139591e-17,
  9.897026889870892e-19, -2.385726521387519e-20,  4.469426726418637e-22,  7.236150225666327e-01, -5.743325295327549e-03,  4.558286126488758e-05, -3.615953938215256e-07,
  2.855536435700434e-09, -2.183432790635792e-11,  1.347795622335084e-13,  4.046551735251470e-16, -5.024506757835347e-17,  1.648588145438778e-18, -4.029195100541210e-20,
  7.797034718236190e-22,  9.781042939502198e-01, -7.763199782192137e-03,  6.161323867172760e-05, -4.886863340760369e-07,  3.853453279636794e-09, -2.911208636998036e-11,
  1.614809520488494e-13,  1.440964513285398e-15, -1.007618681111275e-16,  3.265017515856196e-18, -8.267181805668256e-20,  1.713295532402658e-21  };
  constexpr double w[3840] = {  5.629250115892034e-03, -2.401330843367014e-04,  7.267677378819661e-06, -1.892747373514604e-07,  4.495819264454951e-09,
 -9.993879637808899e-11,  2.109168192887102e-12, -4.265344293651548e-14,  8.318767682228398e-16, -1.572098595204205e-17,  2.889196049301503e-19, -5.176545511865152e-21,
  2.031968579266112e-02, -1.377345316337403e-03,  6.475608245116094e-05, -2.505714673191730e-06,  8.503821906579541e-08, -2.616884771471862e-09,  7.450500223352682e-11,
 -1.988834702964491e-12,  5.024537180908511e-14, -1.209707454493543e-15,  2.790261709128665e-17, -6.188673645194597e-19,  3.870575658677620e-02, -4.163488029676414e-03,
  2.848702539998959e-04, -1.521704479919723e-05,  6.877190086067680e-07, -2.742070084315500e-08,  9.893232255017529e-10, -3.284715756628277e-11,  1.015610131611247e-12,
 -2.950223774832158e-14,  8.106215913230068e-16, -2.116765300313381e-17,  5.495080779524396e-02, -8.719085665255316e-03,  8.161986112604271e-04, -5.713092438577566e-05,
  3.281316701168677e-06, -1.623667770989068e-07,  7.130433010537038e-09, -2.834762696289914e-10,  1.034716726235113e-11, -3.504162911239277e-13,  1.109972315718414e-14,
 -3.307142396912030e-16,  6.498764464664189e-02, -1.406070972937489e-02,  1.707258111349402e-03, -1.498910445825364e-04,  1.052948222247824e-05, -6.245696892240950e-07,
  3.233564245210556e-08, -1.494115288506338e-09,  6.260481097043605e-11, -2.407278348124543e-12,  8.573202910481078e-14, -2.846054661879785e-15,  6.720887409611230e-02,
 -1.848355887459773e-02,  2.771588882679183e-03, -2.932282757486418e-04,  2.433443665500055e-05, -1.677436019935044e-06,  9.952866500772913e-08, -5.207409816014906e-09,
  2.444687271149907e-10, -1.043367423780967e-11,  4.089636524055080e-13, -1.482630018982156e-14,  6.190887337025761e-02, -2.037199869867985e-02,  3.604059752486274e-03,
 -4.423622340472849e-04,  4.196138611864328e-05, -3.264039760403841e-06,  2.161184795654642e-07, -1.249522830325856e-08,  6.426168184261194e-10, -2.981263886825010e-11,
  1.261382428624929e-12, -4.904382838953090e-14,  5.037659619712333e-02, -1.883623146478259e-02,  3.767877206716181e-03, -5.173081877489239e-04,  5.431748724509569e-05,
 -4.632972876151760e-06,  3.335442594804510e-07, -2.081144711507101e-08,  1.147329798752928e-09, -5.671407981620168e-11,  2.542858443724540e-12, -1.042427361528044e-13,
  3.424616825017583e-02, -1.391887169561747e-02,  3.025361292978633e-03, -4.485036823870933e-04,  5.050900039861657e-05, -4.591538024425732e-06,  3.502863284742738e-07,
 -2.304019428884819e-08,  1.332751034130710e-09, -6.883154425878819e-11,  3.212088128323977e-12, -1.365616408876743e-13,  1.523170162493522e-02, -6.472547900580908e-03,
  1.472229937032352e-03, -2.276987249735463e-04,  2.665762010160907e-05, -2.510634254823113e-06,  1.978095197432955e-07, -1.339847979317504e-08,  7.960232152229178e-10,
 -4.212493657330468e-11,  2.009913952873770e-12, -8.719348826852155e-14,  4.772162141684004e-03, -1.899898452216419e-04,  5.369936292068304e-06, -1.309394165731648e-07,
  2.920091279427651e-09, -6.109522077501089e-11,  1.216123553180430e-12, -2.323748905219578e-14,  4.288798340330530e-16, -7.680666106167739e-18,  1.339317627689497e-19,
 -2.279560794891427e-21,  1.568407241740276e-02, -9.598693330887473e-04,  4.139388617841841e-05, -1.482764112021923e-06,  4.686360346167763e-08, -1.349003201065791e-09,
  3.605508652005788e-11, -9.062192754170810e-13,  2.161291750321225e-14, -4.923609926968365e-16,  1.076815705582561e-17, -2.269013658354204e-19,  2.567130633259545e-02,
 -2.462504444689875e-03,  1.536490264491321e-04, -7.568089912843055e-06,  3.177507328671178e-07, -1.183685033070601e-08,  4.008344449616025e-10, -1.253903058508565e-11,
  3.665028844069633e-13, -1.009407980443151e-14,  2.636569635452257e-16, -6.561008781252767e-18,  2.978883319146892e-02, -4.236755603699077e-03,  3.625633038140249e-04,
 -2.345996232697674e-05,  1.255511950462463e-06, -5.824459339762201e-08,  2.410100416751371e-09, -9.066343612449280e-11,  3.142834515388412e-12, -1.014074080124936e-13,
  3.069280189619151e-15, -8.761453682738318e-17,  2.773609402114327e-02, -5.465834882048551e-03,  6.128589511458890e-04, -5.016944662570048e-05,  3.310154125498169e-06,
 -1.854954595126228e-07,  9.116816083448714e-09, -4.015504038359868e-10,  1.609560724119403e-11, -5.939306962854669e-13,  2.035549822198074e-14, -6.519812784976953e-16,
  2.214169890105843e-02, -5.667492378078940e-03,  7.972280447733575e-04, -7.969566286373325e-05,  6.286139381920498e-06, -4.138681180370826e-07,  2.355095207115499e-08,
 -1.185950868600129e-09,  5.375229377866341e-11, -2.220886557038014e-12,  8.447865427551866e-14, -2.978797775921734e-15,  1.578506681657820e-02, -4.946132427846935e-03,
  8.361241713052258e-04, -9.851552985921750e-05,  9.007642424007700e-06, -6.777859627760132e-07,  4.354480161306687e-08, -2.449375452360055e-09,  1.228424102387284e-10,
 -5.569075001083835e-12,  2.306848497338354e-13, -8.795978985770774e-15,  1.021838882697084e-02, -3.713303904245672e-03,  7.225720975185946e-04, -9.674197407381500e-05,
  9.929507764177824e-06, -8.296696738292161e-07,  5.862488503014321e-08, -3.596185754894546e-09,  1.952017080837245e-10, -9.512922248462242e-12,  4.210012782134075e-13,
 -1.705353562297647e-14,  5.819462524997251e-03, -2.334479904782944e-03,  5.007962728434284e-04, -7.334530186720286e-05,  8.168752070785897e-06, -7.351116839510888e-07,
  5.556639653724078e-08, -3.624213960760891e-09,  2.080285634251141e-10, -1.066798703083618e-11,  4.945946855637695e-13, -2.090186598638218e-14,  2.329065362434154e-03,
 -9.856176584220053e-04,  2.232170829510147e-04, -3.438125282317232e-05,  4.009656778340906e-06, -3.762773575073949e-07,  2.954725533917716e-08, -1.995117266485461e-09,
  1.181872148441503e-10, -6.237301671125740e-12,  2.968392040364697e-13, -1.284647508874833e-14,  4.089180988101571e-03, -1.526047391215890e-04,  4.043262353926755e-06,
 -9.260362996155562e-08,  1.944405161179144e-09, -3.838807329919814e-11,  7.224190733953237e-13, -1.307170842571714e-14,  2.287821374525824e-16, -3.890243454591384e-18,
  6.448294946365596e-20, -1.044397338593764e-21,  1.240983800456402e-02, -6.889268169368048e-04,  2.734098417509006e-05, -9.091762649017259e-07,  2.682530955988436e-08,
 -7.238446603396094e-10,  1.819503153497764e-11, -4.312953388518542e-13,  9.724144532031918e-15, -2.098661943720566e-16,  4.356685103678807e-18, -8.729500798098053e-20,
  1.780644846701946e-02, -1.525257322039864e-03,  8.693992657786520e-05, -3.954496730039861e-06,  1.544259874132613e-07, -5.379550139757348e-09,  1.710952723237929e-10,
 -5.045248200431431e-12,  1.394468511188695e-13, -3.641819677099768e-15,  9.042666849361540e-17, -2.144086728136423e-18,  1.724659480698313e-02, -2.192524407120198e-03,
  1.713656792902487e-04, -1.024294109205171e-05,  5.104142891483978e-07, -2.218218990119378e-08,  8.641155391698914e-10, -3.072965036212792e-11,  1.010628261325914e-12,
 -3.103523668728657e-14,  8.965290045931546e-16, -2.448959469755311e-17,  1.284333857321844e-02, -2.290912428434067e-03,  2.362998066131240e-04, -1.798070776643713e-05,
  1.111257887260586e-06, -5.868462778152852e-08,  2.731594982577942e-09, -1.144254483961563e-10,  4.378060070661077e-12, -1.547018007161405e-13,  5.091784499809971e-15,
 -1.570355952188464e-16,  7.951718956862485e-03, -1.879339180779237e-03,  2.465622116798051e-04, -2.317820095767621e-05,  1.730462655115850e-06, -1.084132527291050e-07,
  5.896637371355330e-09, -2.848995369543184e-10,  1.243051350970315e-11, -4.958524444884217e-13,  1.825724967833232e-14, -6.246378840998727e-16,  4.346360769084539e-03,
 -1.287108361720391e-03,  2.066420272764918e-04, -2.325214791694637e-05,  2.040144782592410e-06, -1.479105243864343e-07,  9.187753659247720e-09, -5.011886528584357e-10,
  2.444045783594637e-11, -1.079859548117515e-12,  4.368406367981259e-14, -1.629782790149491e-15,  2.190813339374113e-03, -7.695790678853798e-04,  1.449879534005173e-04,
 -1.885221783739114e-05,  1.884686122495896e-06, -1.537800136305717e-07,  1.063503471914461e-08, -6.397621888962770e-10,  3.411411010206303e-11, -1.635708005490875e-12,
  7.131979842522427e-14, -2.849833695996247e-15,  1.018602533342379e-03, -4.022069991067950e-04,  8.494024868652393e-05, -1.226220562639324e-05,  1.347940222249025e-06,
 -1.198713271019118e-07,  8.963826460786485e-09, -5.789394711341030e-10,  3.293456777117844e-11, -1.675140876996668e-12,  7.708190800545164e-14, -3.235137031466007e-15,
  3.597490504991480e-04, -1.514980511302644e-04,  3.413727329831467e-05, -5.232934118414151e-06,  6.075721929389256e-07, -5.678149952977763e-08,  4.441751317373137e-09,
 -2.988561898799551e-10,  1.764526449880571e-11, -9.283571474649090e-13,  4.405425526982233e-14, -1.901434482881811e-15,  3.537093097407674e-03, -1.242275285015629e-04,
  3.096089572798027e-06, -6.680426223166696e-08,  1.324162318277436e-09, -2.472843367912873e-11,  4.409413896324889e-13, -7.571275338957743e-15,  1.259094698604682e-16,
 -2.036665669134546e-18,  3.214644567284987e-20, -4.962953769624942e-22,  1.003151147605978e-02, -5.075071092002366e-04,  1.859534728146744e-05, -5.756123684605690e-07,
  1.589299550913029e-08, -4.028578874606709e-10,  9.541775356148239e-12, -2.136638888683979e-13,  4.560875875945162e-15, -9.337526005582654e-17,  1.842072343399847e-18,
 -3.513339079741017e-20,  1.284600870136277e-02, -9.844836234114271e-04,  5.137071364153468e-05, -2.161597765830390e-06,  7.862525707850862e-08, -2.564322095555603e-09,
  7.667158197372911e-11, -2.132760326046238e-12,  5.577244711554484e-14, -1.381713587419864e-15,  3.262167119971943e-17, -7.370741831534731e-19,  1.059915296087558e-02,
 -1.202048469411594e-03,  8.579423898883537e-05, -4.736603119369813e-06,  2.197270587570152e-07, -8.942826240769802e-09,  3.278240039498065e-10, -1.101480408590039e-11,
  3.434562856589049e-13, -1.003058378473680e-14,  2.763230029666182e-16, -7.216341398758719e-18,  6.426778933425665e-03, -1.031828801898566e-03,  9.760740610217217e-05,
 -6.886986869912300e-06,  3.978268233491410e-07, -1.975810146719811e-08,  8.693002383287916e-10, -3.456660584152285e-11,  1.260065017171123e-12, -4.255868047882984e-14,
  1.342756746014506e-15, -3.980289530278362e-17,  3.114759742056473e-03, -6.743292608129482e-04,  8.206080708763461e-05, -7.221832680117625e-06,  5.083679085613011e-07,
 -3.020138346733392e-08,  1.565078034827604e-09, -7.233719986610963e-11,  3.029810836680897e-12, -1.163779683204909e-13,  4.137460542718090e-15, -1.370244807745644e-16,
  1.299370725096897e-03, -3.606709574793187e-04,  5.464057573324707e-05, -5.840303402332897e-06,  4.894471862442400e-07, -3.404986473273193e-08,  2.037463973253995e-09,
 -1.074240328556231e-10,  5.078045036031278e-12, -2.180504130253308e-13,  8.592222425217597e-15, -3.129041654129490e-16,  5.001627484560757e-04, -1.687558514919466e-04,
  3.061426199079892e-05, -3.847870464004069e-06,  3.731626102240113e-07, -2.962742289805695e-08,  1.999042226254848e-09, -1.175965018205822e-10,  6.144426586732960e-12,
 -2.892004054415065e-13,  1.239753895577778e-14, -4.877572526349068e-16,  1.846307107440037e-04, -7.151829806579996e-05,  1.482247287655854e-05, -2.103453829966916e-06,
  2.276753124292125e-07, -1.996625402847359e-08,  1.474314036590990e-09, -9.413584839750885e-11,  5.299668823410846e-12, -2.670056300308258e-13,  1.217997723495979e-14,
 -5.071471062243047e-16,  5.622886543707366e-05, -2.354207982487014e-05,  5.273225109326774e-06, -8.038233865955696e-07,  9.284639140660703e-08, -8.635780593471267e-09,
  6.725696551813311e-10, -4.506905016680843e-11,  2.650986387236832e-12, -1.389870611603721e-13,  6.574037367166686e-15, -2.828843057353327e-16,  3.085106520939717e-03,
 -1.023394232694957e-04,  2.406920820921158e-06, -4.906390250821828e-08,  9.203426515017931e-10, -1.629432687185448e-11,  2.758805297861606e-13, -4.504243923072347e-15,
  7.130424852741453e-17, -1.099193013756255e-18,  1.654774766268944e-20, -2.439323732283344e-22,  8.260648443963792e-03, -3.825913538639245e-04,  1.298322337565204e-05,
 -3.751119140696633e-07,  9.714964159004186e-09, -2.318177152041946e-10,  5.183346830068815e-12, -1.098312213875074e-13,  2.223016045533742e-15, -4.323272581531907e-17,
  8.114858957130312e-19, -1.474860016284158e-20,  9.591488147422547e-03, -6.592246166485217e-04,  3.156310326360360e-05, -1.231092182784759e-06,  4.177850247267558e-08,
 -1.277449611018159e-09,  3.594752575445544e-11, -9.441586677369533e-13,  2.337768820144530e-14, -5.497259342091757e-16,  1.234636824917507e-17, -2.659125348496888e-19,
  6.873095554233296e-03, -6.945442220843461e-04,  4.529051763632715e-05, -2.310486831578114e-06,  9.980461681394915e-08, -3.804463419477972e-09,  1.312301416564011e-10,
 -4.165192271473264e-12,  1.230981041750646e-13, -3.417503423532050e-15,  8.973234966955971e-17, -2.239022741961603e-18,  3.458560232265290e-03, -4.973579007605818e-04,
  4.305138849977615e-05, -2.811650200527889e-06,  1.515600046438899e-07, -7.068169337741145e-09,  2.934957035648226e-10, -1.106130887312916e-11,  3.835777132695256e-13,
 -1.236400006111287e-14,  3.733596068719408e-16, -1.062073127092629e-17,  1.329564589024779e-03, -2.616232176592350e-04,  2.938369099912502e-05, -2.411155119147828e-06,
  1.594719343926577e-07, -8.955460058741451e-09,  4.408729476676158e-10, -1.943950362152171e-11,  7.795904787690822e-13, -2.876328118772208e-14,  9.850397131933647e-16,
 -3.150680405435704e-17,  4.236257117304680e-04, -1.092449069395140e-04,  1.551407184720924e-05, -1.566566723381067e-06,  1.248094626238063e-07, -8.296975789953564e-09,
  4.764648306153334e-10, -2.419802306513929e-11,  1.105354055352834e-12, -4.599469776190542e-14,  1.760693750656495e-15, -6.243174221886317e-17,  1.225361798575009e-04,
 -3.941569630817503e-05,  6.842708231755994e-06, -8.270164970107866e-07,  7.745131519060331e-08, -5.959902195009992e-09,  3.909602467161203e-10, -2.242005987487709e-11,
  1.144646658591573e-12, -5.275076349238094e-14,  2.218164639370005e-15, -8.574488977442499e-17,  3.487740863879066e-05, -1.319740229312304e-05,  2.674080967816607e-06,
 -3.717984995578602e-07,  3.951162271004402e-08, -3.408420523257089e-09,  2.479738324680542e-10, -1.562254158371832e-11,  8.689014229489956e-13, -4.329582287356587e-14,
  1.955233477595697e-15, -8.066721420308333e-17,  8.912626960948434e-06, -3.705576727745509e-06,  8.241424203369152e-07, -1.247995886987933e-07,  1.432781130495862e-08,
 -1.325257473804163e-09,  1.026880406818809e-10, -6.848944415304710e-12,  4.011202417172067e-13, -2.094620110910858e-14,  9.870832636518804e-16, -4.232907867181025e-17,
  2.710854167441666e-03, -8.521141648701918e-05,  1.896811012794597e-06, -3.662443300442518e-08,  6.516442977475582e-10, -1.096125007386852e-11,  1.765595243480100e-13,
 -2.746249094840518e-15,  4.145416511205570e-17, -6.101373362092007e-19,  8.773258912465648e-21, -1.236751533720625e-22,  6.912821699079359e-03, -2.944015796744128e-04,
  9.280866760211797e-06, -2.509216532524550e-07,  6.109682124731336e-09, -1.375241857077218e-10,  2.908271576743989e-12, -5.841123603260192e-14,  1.122728866798835e-15,
 -2.077004287689786e-17,  3.714034905696988e-19, -6.439738481108697e-21,  7.379854989578235e-03, -4.561248087787617e-04,  2.008810944509467e-05, -7.278247485910342e-07,
  2.308565591566270e-08, -6.627824346000447e-10,  1.757590200960788e-11, -4.363489633555969e-13,  1.023920493599228e-14, -2.287105320655180e-16,  4.889360578434082e-18,
 -1.004283830457030e-19,  4.675864777900260e-03, -4.208163400865331e-04,  2.509747292275363e-05, -1.184093036873345e-06,  4.765891520054015e-08, -1.702291546272751e-09,
  5.526721025674567e-11, -1.657238904790840e-12,  4.642082044939339e-14, -1.224921255016157e-15,  3.064666493349166e-17, -7.303680874860490e-19,  1.990896900203670e-03,
 -2.553758869634580e-04,  2.019867881838499e-05, -1.219637577738681e-06,  6.128508401249711e-08, -2.680946395713367e-09,  1.049488775708232e-10, -3.744602118204689e-12,
  1.233811062440395e-13, -3.790806062366537e-15,  1.094231209513967e-16, -2.983186449624093e-18,  6.170415532963479e-04, -1.095384509336219e-04,  1.130499773542751e-05,
 -8.619591038155856e-07,  5.340238093351773e-08, -2.826968831762182e-09,  1.318687284656207e-10, -5.533434587297836e-12,  2.119743749426474e-13, -7.495297828394205e-15,
  2.467210685555111e-16, -7.605414695335997e-18,  1.510842347684335e-04, -3.586170757576727e-05,  4.742426788478363e-06, -4.499743173266642e-07,  3.392381099287008e-08,
 -2.146138390884485e-09,  1.178404925681868e-10, -5.745219735923322e-12,  2.528092926715070e-13, -1.016436787795230e-14,  3.769670685150226e-16, -1.298185407622978e-17,
  3.246752133640488e-05, -9.871111734489446e-06,  1.628610181556223e-06, -1.881864043212065e-07,  1.693524394367706e-08, -1.257589155361470e-09,  7.989782919485022e-11,
 -4.451274728272594e-12,  2.213748186069365e-13, -9.961235570132968e-15,  4.098305901734770e-16, -1.552961278179771e-17,  6.917965001490059e-06, -2.543634773740938e-06,
  5.015343097843094e-07, -6.804912439963510e-08,  7.075920897473879e-09, -5.986383737410873e-10,  4.280005230457827e-11, -2.654447070401093e-12,  1.455577815704056e-13,
 -7.160272785203859e-15,  3.196004703084766e-16, -1.304635833858564e-17,  1.436582466910792e-06, -5.922175184153328e-07,  1.305909759064009e-07, -1.961983761638100e-08,
  2.236346517635194e-09, -2.055031623208852e-10,  1.582882584312217e-11, -1.049990889891257e-12,  6.118797210148315e-14, -3.180535902756399e-15,  1.492474193509836e-16,
 -6.375170677025383e-18,  2.397804023892693e-03, -7.163293888902602e-05,  1.513321565405006e-06, -2.774537615133594e-08,  4.692617012893389e-10, -7.514776242177252e-12,
  1.153616031321357e-13, -1.712781077735026e-15,  2.468659153983162e-17, -3.475877731231490e-19,  4.782428639972394e-21, -6.440627495193032e-23,  5.866737713608339e-03,
 -2.307239413320601e-04,  6.776493950715203e-06, -1.718691977002335e-07,  3.943090221552168e-09, -8.389264749044374e-11,  1.680962766879493e-12, -3.205465066526640e-14,
  5.859823206836048e-16, -1.032641539908202e-17,  1.761401546666312e-19, -2.916851834004935e-21,  5.829152790208837e-03, -3.249529693524442e-04,  1.319730409338654e-05,
 -4.451540809344398e-07,  1.322195619577338e-08, -3.569941286216157e-10,  8.933727833286115e-12, -2.098986885750894e-13,  4.672691845563883e-15, -9.923065586370558e-17,
  2.020740512292733e-18, -3.960877049893100e-20,  3.319564587749302e-03, -2.660967081859168e-04,  1.453671856889668e-05, -6.350551457816323e-07,  2.383965691743768e-08,
 -7.984721037722254e-10,  2.441334188973614e-11, -6.918745777686472e-13,  1.837250518282772e-14, -4.608342079626322e-16,  1.098615165550231e-17, -2.500318760078749e-19,
  1.218977976748738e-03, -1.389946380990730e-04,  1.003918450858160e-05, -5.601580640069736e-07,  2.622430673972746e-08, -1.075443808398565e-09,  3.966215947044773e-11,
 -1.338738119789571e-12,  4.187642882990524e-14, -1.225276278832734e-15,  3.377516526701383e-17, -8.815850986409057e-19,  3.102442073564585e-04, -4.934173432138059e-05,
  4.662765338454963e-06, -3.294006272444484e-07,  1.906931618709548e-08, -9.494131723343171e-10,  4.187198407105542e-11, -1.668564928428493e-12,  6.093249755851477e-14,
 -2.060716747120699e-15,  6.507070857200878e-17, -1.929444640734789e-18,  5.903550276626544e-05, -1.277474188405308e-05,  1.563137549996960e-06, -1.386505433548835e-07,
  9.847949990747074e-09, -5.905799186169938e-10,  3.089542343423078e-11, -1.441261163256755e-12,  6.090689904100657e-14, -2.359348027610108e-15,  8.454609120857567e-17,
 -2.820573233235308e-18,  9.373353093571149e-06, -2.667271478896820e-06,  4.150875286990245e-07, -4.557262301250410e-08,  3.920114412106523e-09, -2.796260037709945e-10,
  1.713557450063420e-11, -9.240604880581860e-13,  4.461849272464038e-14, -1.954433968877920e-15,  7.845962426135110e-17, -2.907062726258645e-18,  1.453382187693810e-06,
 -5.158428278359276e-07,  9.841667272635710e-08, -1.296899602968530e-08,  1.314134357372386e-09, -1.086541173268408e-10,  7.610637977811719e-12, -4.634098783641437e-13,
  2.499401055076085e-14, -1.211242596309019e-15,  5.333541710101674e-17, -2.150550280784913e-18,  2.362933214474099e-07, -9.639006123569352e-08,  2.103485256136449e-08,
 -3.130312344482748e-09,  3.537514060564822e-10, -3.225575720878225e-11,  2.467098592702993e-12, -1.626117354818257e-13,  9.421187458801149e-15, -4.871110508102153e-16,
  2.274636595231570e-17, -9.672685988629892e-19,  2.133543041314630e-03, -6.074102526245393e-05,  1.220912724352247e-06, -2.130395738194096e-08,  3.431850538156227e-10,
 -5.242692617929659e-12,  7.681654405724843e-14, -1.090992146175092e-15,  1.503101377579267e-17, -2.026025328953951e-19,  2.685690915110584e-21, -3.414003986142375e-23,
  5.040566078143777e-03, -1.838038405334546e-04,  5.043580720463583e-06, -1.202816074796298e-07,  2.605620557502458e-09, -5.250142970606450e-11,  9.984804465225495e-13,
 -1.810769934779808e-14,  3.152900667321369e-16, -5.299821837741289e-18,  8.635816201694249e-20, -1.366965003876304e-21,  4.711112442649153e-03, -2.376213227446935e-04,
  8.922072410383259e-06, -2.808039057445191e-07,  7.825224053601328e-09, -1.990313018316172e-10,  4.707088460437129e-12, -1.047954314690991e-13,  2.215711511734396e-15,
 -4.477914659190113e-17,  8.693697815784586e-19, -1.627384828983502e-20,  2.447281091480032e-03, -1.748365153924771e-04,  8.765299042582519e-06, -3.551028456356358e-07,
  1.244808559601938e-08, -3.913425705984610e-10,  1.127714276003981e-11, -3.022343478656159e-13,  7.611936715303793e-15, -1.815469870772577e-16,  4.124737894452372e-18,
 -8.965444378003127e-20,  7.893267625110524e-04, -7.978817326900649e-05,  5.263317115822393e-06, -2.713845382451833e-07,  1.183648051920690e-08, -4.549651298080213e-10,
  1.580286813561350e-11, -5.043907349485143e-13,  1.497092116322382e-14, -4.168986259153744e-16,  1.096678757002950e-17, -2.738471670505696e-19,  1.682338901212400e-04,
 -2.381770746422020e-05,  2.055393534116832e-06, -1.342466399287123e-07,  7.248097224242400e-09, -3.387835353512399e-10,  1.410191384840557e-11, -5.327387503785560e-13,
  1.851368142963245e-14, -5.978393283204079e-16,  1.807852361147965e-17, -5.147589451433456e-19,  2.526979457467556e-05, -4.937089668617495e-06,  5.556948187159726e-07,
 -4.586284079778902e-08,  3.056636499880036e-09, -1.731368564811046e-10,  8.600944610942936e-12, -3.827303724782033e-13,  1.548805517112628e-14, -5.764641007081571e-16,
  1.990786587134168e-17, -6.418105772915432e-19,  2.967990200468521e-06, -7.818856019691590e-07,  1.138602035586143e-07, -1.180095623300077e-08,  9.649687362923441e-10,
 -6.580149558028089e-11,  3.872809098427363e-12, -2.013775625278536e-13,  9.407679418713769e-15, -3.998789312589714e-16,  1.561787207245057e-17, -5.643118581507720e-19,
  3.266133296066584e-07, -1.109851617000082e-07,  2.035044222732931e-08, -2.589847196650825e-09,  2.545086774565013e-10, -2.048086472785862e-11,  1.400447775319076e-12,
 -8.345762496247296e-14,  4.415158570432399e-15, -2.102703470938403e-16,  9.114238174251706e-18, -3.622919040679904e-19,  3.984002938691994e-08, -1.603882753055655e-08,
  3.455418555838402e-09, -5.082881204762282e-10,  5.684778227019924e-11, -5.135556275495705e-12,  3.895302116760505e-13, -2.548209697011380e-14,  1.466306447023649e-15,
 -7.534429737620146e-17,  3.498418571447718e-18, -1.479978825251138e-19,  1.908616481111643e-03, -5.191033306257566e-05,  9.950490972927889e-07, -1.656114651836565e-08,
  2.545475869389677e-10, -3.717381213483585e-12,  5.203866742953367e-14, -7.085636530898410e-16,  9.359727604986394e-18, -1.198064554580996e-19,  1.568446768155494e-21,
 -1.834981085149357e-23,  4.377811653786868e-03, -1.485921059066918e-04,  3.819481506431136e-06, -8.584380739202012e-08,  1.759381342613233e-09, -3.363707054703866e-11,
  6.081822167771667e-13, -1.050638940041072e-14,  1.745129528123972e-16, -2.800703205596204e-18,  4.368719338572801e-20, -6.613056414328330e-22,  3.884690062287601e-03,
 -1.778619464890058e-04,  6.189752844993896e-06, -1.821777603946875e-07,  4.772483743468342e-09, -1.145406081102024e-10,  2.563921802689746e-12, -5.415991110548444e-14,
  1.088862983102961e-15, -2.096476520097915e-17,  3.883734867319997e-19, -6.949164177463640e-21,  1.865292859535458e-03, -1.188849929143798e-04,  5.481611254582225e-06,
 -2.062924655118050e-07,  6.762512112488244e-09, -1.997831812799921e-10,  5.431227706678338e-12, -1.377608356319836e-13,  3.292762419736993e-15, -7.471248668960987e-17,
  1.618284216394216e-18, -3.360272934423671e-20,  5.375390358144215e-04, -4.806665778387226e-05,  2.898368167362430e-06, -1.381680960253449e-07,  5.616238127105764e-09,
 -2.023736983690981e-10,  6.620650414978646e-12, -1.998029026943868e-13,  5.625952516190966e-15, -1.490580326544527e-16,  3.740275037343256e-18, -8.930412129566039e-20,
  9.787569018697613e-05, -1.226343835996124e-05,  9.647911668278311e-07, -5.817394487103653e-08,  2.925406788460747e-09, -1.282033288420186e-10,  5.030082489433889e-12,
 -1.799073331778754e-13,  5.941664035917009e-15, -1.829440039375314e-16,  5.290448223067893e-18, -1.444449463259969e-19,  1.182752635620014e-05, -2.066553829077409e-06,
  2.128633698330810e-07, -1.627968147145038e-08,  1.014510196911935e-09, -5.410399290857254e-11,  2.544724297213883e-12, -1.077142845639151e-13,  4.162979640195179e-15,
 -1.485001218981457e-16,  4.930285511349741e-18, -1.532411823967314e-19,  1.036136251260039e-06, -2.497027517215140e-07,  3.374914420949038e-08, -3.280554119619092e-09,
  2.535922492913433e-10, -1.645103152069442e-11,  9.259110822692489e-13, -4.624170963691285e-14,  2.082608471588059e-15, -8.561821926884807e-17,  3.243480979930297e-18,
 -1.139675910591383e-19,  7.937088173814657e-08, -2.556176458262359e-08,  4.468606199240448e-09, -5.456065392179840e-10,  5.171336597480696e-11, -4.031188445117569e-12,
  2.679868524132010e-13, -1.557423960115102e-14,  8.056005460472613e-16, -3.759809318484598e-17,  1.600206229990754e-18, -6.256685601100126e-20,  6.925730521575691e-09,
 -2.741745936204766e-09,  5.812845674890503e-10, -8.429235299280514e-11,  9.308850374860776e-12, -8.315612004575406e-13,  6.244561237524947e-14, -4.048581395352027e-15,
  2.310937068717091e-16, -1.178813080377671e-17,  5.437368517909568e-19, -2.286417500900521e-20,  1.715728101197035e-03, -4.468087910295510e-05,  8.185011784456269e-07,
 -1.302149139403666e-08,  1.912416838640596e-10, -2.676273990797866e-12,  3.582168902370827e-14, -4.673598084059993e-16,  6.006964923032595e-18, -7.050588985092225e-20,
  9.515361862396288e-22, -1.076578041898325e-23,  3.838644934111841e-03, -1.217246349878455e-04,  2.938376575299478e-06, -6.237232025283572e-08,  1.211680914639805e-09,
 -2.202218086143937e-11,  3.791390427993741e-13, -6.247524976142243e-15,  9.921750547882695e-17, -1.519599522986500e-18,  2.275742412408520e-20, -3.302548212166922e-22,
  3.260060456932991e-03, -1.359450210460585e-04,  4.395755512202171e-06, -1.212539136788398e-07,  2.991915114277170e-09, -6.787019628366304e-11,  1.440146677213442e-12,
 -2.890360688081303e-14,  5.531665912114778e-16, -1.016013098039840e-17,  1.797231846087588e-19, -3.076519875934190e-21,  1.464027822787259e-03, -8.335813467901472e-05,
  3.543258103074653e-06, -1.241004766209382e-07,  3.810313651752339e-09, -1.059157124036033e-10,  2.719474117290772e-12, -6.534340621924257e-14,  1.483305897286245e-15,
 -3.204233915720994e-17,  6.619512505542313e-19, -1.313589175380567e-20,  3.829572824988900e-04, -3.024383242264869e-05,  1.669472013451892e-06, -7.364555684135939e-08,
  2.791892140443468e-09, -9.435717987269658e-11,  2.908443784332902e-12, -8.300670985008225e-14,  2.217351380517453e-15, -5.589197411324933e-17,  1.337554373770894e-18,
 -3.052775693706083e-20,  6.074872124244626e-05, -6.701167913866761e-06,  4.802813520045739e-07, -2.671261952768118e-08,  1.250216772347103e-09, -5.132864794430078e-11,
  1.896605228770214e-12, -6.416214713035697e-14,  2.011773658517033e-15, -5.899898232239899e-17,  1.629769438337982e-18, -4.261827447150670e-20,  6.033058810192269e-06,
 -9.339800450018858e-07,  8.767526173960115e-08, -6.192542462668527e-09,  3.597802466316645e-10, -1.801643807225905e-11,  8.002635301927464e-13, -3.214366951186876e-14,
  1.183676959543046e-15, -4.037505389700949e-17,  1.285844301063692e-18, -3.844816172895553e-20,  4.001501251004524e-07, -8.709993855053978e-08,  1.083911429612922e-08,
 -9.818739567735383e-10,  7.136724977922455e-11, -4.383618312533993e-12,  2.349328931977238e-13, -1.122536260735951e-14,  4.856503230025040e-16, -1.924675369461466e-17,
  7.050477121990643e-19, -2.402243245328906e-20,  2.109810905264293e-08, -6.361047111392363e-09,  1.050395603115897e-09, -1.221290098513142e-10,  1.109491870796954e-11,
 -8.333397787981559e-13,  5.361114766420173e-14, -3.026087298866916e-15,  1.525002434058017e-16, -6.952596994271688e-18,  2.897267196041218e-19, -1.111424170060663e-20,
  1.250814032083310e-09, -4.845297197672825e-10,  1.006637599192302e-10, -1.433957120062049e-11,  1.559110827712295e-12, -1.373821013338137e-13,  1.019258157713258e-14,
 -6.537547762138117e-16,  3.695943637004217e-17, -1.869093977547277e-18,  8.554384992567133e-20, -3.571846980248175e-21,  1.549179400979070e-03, -3.870966857847986e-05,
  6.789761764495173e-07, -1.034720291494081e-08,  1.453566294286898e-10, -1.953969544649054e-12,  2.509248613855971e-14, -3.092650517581321e-16,  4.049030297598465e-18,
 -4.095955043917452e-20,  5.413798293506824e-22, -8.585065901018077e-24,  3.394444990952089e-03, -1.009124493401172e-04,  2.293148673578922e-06, -4.606818980318915e-08,
  8.497217591697818e-10, -1.470814625999730e-11,  2.415390403027626e-13, -3.797103714056157e-15,  5.791456640967502e-17, -8.447022905009230e-19,  1.213416563396021e-20,
 -1.714578785245470e-22,  2.778423908529936e-03, -1.058775592900761e-04,  3.188547486044096e-06, -8.260761586331783e-08,  1.923658059410697e-09, -4.131224057113013e-11,
  8.322241324879950e-13, -1.589418070650891e-14,  2.897722367531555e-16, -5.086155696453026e-18,  8.599573591950335e-20, -1.407582975311015e-21,  1.179132356092681e-03,
 -6.007317887507685e-05,  2.359931220014404e-06, -7.707340396286715e-08,  2.220256784616037e-09, -5.814776809703633e-11,  1.411761874998460e-12, -3.217262211713561e-14,
  6.939969206681267e-16, -1.428802962400029e-17,  2.817036956172997e-19, -5.342679626242963e-21,  2.840063047062644e-04, -1.978584121344232e-05,  1.001899075445317e-06,
 -4.094643239890191e-08,  1.449225755708966e-09, -4.597286603402876e-11,  1.335916169372319e-12, -3.607381018096614e-14,  9.143686178411223e-16, -2.193255853396911e-17,
  5.005881716671121e-19, -1.091977493528994e-20,  3.999269986177032e-05, -3.865591929453391e-06,  2.524840264116581e-07, -1.294984855566653e-08,  5.639645571135545e-10,
 -2.168344084331055e-11,  7.541935911332875e-13, -2.411963569771795e-14,  7.174858249241611e-16, -2.002678662620221e-17,  5.280061837612415e-19, -1.321212539582342e-20,
  3.338361159044937e-06, -4.538220363537077e-07,  3.871081217721610e-08, -2.518415724839326e-09,  1.361047081015896e-10, -6.386086397918093e-12,  2.673345631205561e-13,
 -1.016882146800621e-14,  3.560806776056211e-16, -1.159125665185430e-17,  3.534185855056165e-19, -1.014665468035838e-20,  1.711594064564411e-07, -3.320365167086058e-08,
  3.776428678557692e-09, -3.169227906629990e-10,  2.155150362775008e-11, -1.247836765471593e-12,  6.342350540346532e-14, -2.888568711347905e-15,  1.196334311387976e-16,
 -4.555708995821994e-18,  1.608841660369152e-19, -5.300287749488318e-21,  6.204834716505808e-09, -1.725787998770434e-09,  2.664037175376183e-10, -2.925351185098727e-11,
  2.529796122061203e-12, -1.820146224019230e-13,  1.127405944873349e-14, -6.153112736396497e-16,  3.009091771363815e-17, -1.335375184913465e-18,  5.431204393491022e-20,
 -2.038310186477275e-21,  2.370435982975235e-10, -8.923688597177641e-11,  1.806445396380419e-11, -2.516244242027870e-12,  2.683403427337653e-13, -2.325036632859583e-14,
  1.699740027493586e-15, -1.076138092679303e-16,  6.014070864796249e-18, -3.010250452785861e-19,  1.365048842653487e-20, -5.652543190539844e-22,  1.404470110429041e-03,
 -3.373775895755889e-05,  5.675729027713420e-07, -8.304108285704935e-09,  1.116683938541857e-10, -1.442253018543307e-12,  1.805086486463597e-14, -1.998510364836701e-16,
  2.872662173504026e-18, -2.694585536520894e-20,  1.547683488793410e-22, -9.135995860812924e-24,  3.024283583713507e-03, -8.456788412824032e-05,  1.813126144763681e-06,
 -3.454368852908122e-08,  6.058905590961159e-10, -1.000269947890338e-11,  1.571851688089648e-13, -2.349773629381515e-15,  3.467609985115571e-17, -4.833580740774938e-19,
  6.494094265961981e-21, -9.376231744604746e-23,  2.400316195909723e-03, -8.386753550749166e-05,  2.357804147089840e-06, -5.748824162892364e-08,  1.265874066378540e-09,
 -2.577962389307673e-11,  4.935934446577564e-13, -8.991698933602843e-15,  1.561376730587216e-16, -2.622384687307544e-18,  4.256393880602973e-20, -6.625270915495886e-22,
  9.714904200803667e-04, -4.436712309576729e-05,  1.615040692892177e-06, -4.927853993786068e-08,  1.334359812907536e-09, -3.297354520978490e-11,  7.577104552995621e-13,
 -1.640844017485847e-14,  3.363633185764833e-16, -6.606356959596451e-18,  1.245753954459000e-19, -2.254078744038054e-21,  2.182582011082038e-04, -1.340194099619134e-05,
  6.241552587792473e-07, -2.366453182554684e-08,  7.830021127347236e-10, -2.333687395719570e-11,  6.397144888233280e-13, -1.635932661779634e-14,  3.935308694373283e-16,
 -8.986022439281905e-18,  1.957118387683797e-19, -4.078983595118822e-21,  2.776585100906819e-05, -2.341459610636570e-06,  1.395699459077658e-07, -6.602535048310543e-09,
  2.676328298185103e-10, -9.636932224318330e-12,  3.154746233119334e-13, -9.536204196530394e-15,  2.690158991948373e-16, -7.143543001587029e-18,  1.796662359595729e-19,
 -4.298925499688280e-21,  1.992874707650721e-06, -2.358421748939858e-07,  1.825240974331755e-08, -1.091678868747586e-09,  5.479494025107864e-11, -2.405214967326719e-12,
  9.474241936375069e-14, -3.407469489214213e-15,  1.132783571297626e-16, -3.513372850589986e-18,  1.023889745367553e-19, -2.817794947351391e-21,  8.099806554727222e-08,
 -1.381242887370671e-08,  1.426727161571833e-09, -1.103445778667061e-10,  6.989349102432261e-12, -3.799566371954685e-13,  1.824792378505333e-14, -7.894650424416330e-16,
  3.119927779025361e-17, -1.138117235606651e-18,  3.863458901341871e-20, -1.227289843879490e-21,  2.039997645393234e-09, -5.145071630681130e-10,  7.342239824866862e-11,
 -7.547907983867524e-12,  6.168490795399310e-13, -4.224910530207894e-14,  2.505936953907861e-15, -1.316083007526595e-16,  6.218861710251526e-18, -2.676063745604272e-19,
  1.058599050701399e-20, -3.874583076748289e-22,  4.775590356634869e-11, -1.730388933579999e-11,  3.387281067668461e-12, -4.585928503191104e-13,  4.773498536896792e-14,
 -4.050706601653770e-15,  2.908243572108371e-16, -1.812371522064015e-17,  9.988404971969816e-19, -4.938156134919236e-20,  2.214757792618254e-21, -9.081213598268628e-23,
  1.278009301180933e-03, -2.956744715340657e-05,  4.777633558719780e-07, -6.726363051705063e-09,  8.675225220521744e-11, -1.066667829925007e-12,  1.360010268515262e-14,
 -1.230407804196763e-16,  1.917061454508866e-18, -2.875117324584089e-20, -2.360914969624258e-22, -7.785182013273619e-24,  2.712610913943943e-03, -7.157014478112263e-05,
  1.450773436162520e-06, -2.626520578431542e-08,  4.388174530511724e-10, -6.908860224782950e-12,  1.046254313535117e-13, -1.475629729486962e-15,  2.108499019806463e-17,
 -2.923817231482389e-19,  3.350670269699551e-21, -5.274066652875524e-23,  2.098641041527152e-03, -6.745561077318510e-05,  1.774327880498306e-06, -4.079180583469910e-08,
  8.509372369918552e-10, -1.646674909709419e-11,  2.996335948983501e-13, -5.226613411120445e-15,  8.648320927504478e-17, -1.382819737969732e-18,  2.188024516875702e-20,
 -3.207859226947939e-22,  8.165709610382574e-04, -3.349361756095234e-05,  1.132855119626958e-06, -3.235333270963114e-08,  8.249898755466443e-10, -1.927506217977596e-11,
  4.190894219599545e-13, -8.653325899123226e-15,  1.686330991887260e-16, -3.151680021247964e-18,  5.729050295886894e-20, -9.846871932049030e-22,  1.730983166979002e-04,
 -9.362353341831151e-06,  4.022775874039350e-07, -1.416970842658518e-08,  4.389510544626944e-10, -1.230991683093530e-11,  3.183558591219685e-13, -7.723697458203927e-15,
  1.763844416875208e-16, -3.832469712437071e-18,  7.982272835676337e-20, -1.587978785653288e-21,  2.021768856353970e-05, -1.481389931533762e-06,  8.079276076581787e-08,
 -3.526843507754652e-09,  1.331539865319322e-10, -4.492814211057599e-12,  1.384123808904491e-13, -3.956177354089332e-15,  1.058197915125630e-16, -2.672270163052713e-18,
  6.411594054757148e-20, -1.466071710188176e-21,  1.275643288779641e-06, -1.303081130347283e-07,  9.151648275734265e-09, -5.025800039552199e-10,  2.340813958415347e-11,
 -9.603320294417842e-13,  3.555323061858246e-14, -1.207734428058155e-15,  3.807042165108896e-17, -1.123562038908948e-18,  3.125616745469090e-20, -8.233939262114583e-22,
  4.226967475583260e-08, -6.247468670987578e-09,  5.833478595244706e-10, -4.139640868553778e-11,  2.433424632043312e-12, -1.237850619776125e-13,  5.599485470367963e-15,
 -2.294265330495516e-16,  8.626496962259573e-18, -3.006081705228053e-19,  9.782535336238433e-21, -2.988655877513567e-22,  7.560246594959714e-10, -1.695334997911343e-10,
  2.211498459199471e-11, -2.109491301444817e-12,  1.617239909503108e-13, -1.047777632894813e-14,  5.917886158438645e-16, -2.975817855590152e-17,  1.352587247204265e-18,
 -5.620794472380430e-20,  2.154592747391686e-21, -7.665003888134880e-23,  1.040149937392515e-11, -3.578269319734587e-12,  6.705195144281802e-13, -8.754545590292978e-14,
  8.839108530482571e-15, -7.308774254174272e-16,  5.131735080172485e-17, -3.136750079794059e-18,  1.699731906237952e-19, -8.278973787951574e-21,  3.664389543109899e-22,
 -1.484973831014350e-23,  1.166903836531883e-03, -2.604612058907549e-05,  4.047257329720264e-07, -5.492318973793244e-09,  6.843534625663161e-11, -7.757111360533724e-13,
  1.084186762882319e-14, -8.063376213745692e-17,  6.479156304023993e-19, -4.283866126858538e-20, -3.893149343414811e-22,  3.218495776255357e-24,  2.447702252382087e-03,
 -6.111500848346602e-05,  1.173564195245939e-06, -2.022590519752924e-08,  3.227594240472746e-10, -4.826321454566479e-12,  7.133230269592112e-14, -9.474530958557475e-16,
  1.249434055664480e-17, -1.958285287196908e-19,  1.693515099396846e-21, -2.272126287388136e-23,  1.854404349294258e-03, -5.501025650265959e-05,  1.356790197026438e-06,
 -2.946543356028827e-08,  5.831013495777017e-10, -1.075953803181330e-11,  1.856108873339509e-13, -3.110857617141977e-15,  4.957261358148814e-17, -7.349331121310350e-19,
  1.162971544806010e-20, -1.662853477249642e-22,  6.985455102242782e-04, -2.578545556273126e-05,  8.126615213416866e-07, -2.176362355185951e-08,  5.232023941411203e-10,
 -1.160554831683595e-11,  2.380102658399993e-13, -4.702732812347763e-15,  8.778584606473435e-17, -1.535632058578558e-18,  2.734805855076404e-20, -4.519552514676357e-22,
  1.411553369255768e-04, -6.721221448475082e-06,  2.674241197767896e-07, -8.764437252831940e-09,  2.544666448173207e-10, -6.735148083143201e-12,  1.640834188221145e-13,
 -3.785302342851741e-15,  8.231140320391923e-17, -1.693207033847194e-18,  3.390699685422319e-20, -6.452112354930400e-22,  1.536017877597975e-05, -9.739374064529014e-07,
  4.878430670151042e-08, -1.966505309497487e-09,  6.920008196961033e-11, -2.191431192497963e-12,  6.349664932377737e-14, -1.717622701348755e-15,  4.359355788698090e-17,
 -1.045579110961767e-18,  2.395672978106745e-20, -5.234394660865330e-22,  8.700254604293775e-07, -7.605871139456885e-08,  4.857877271925691e-09, -2.447683883631365e-10,
  1.057457037257060e-11, -4.054178676631107e-13,  1.409330076526407e-14, -4.519256083041319e-16,  1.349774315684151e-17, -3.786247683265111e-19,  1.004611154440234e-20,
 -2.530489301634702e-22,  2.420241707612384e-08, -3.055476411446881e-09,  2.573027871936212e-10, -1.669426523732264e-11,  9.081528576633661e-13, -4.311529040682665e-14,
  1.832112640853910e-15, -7.091426059049801e-17,  2.530595584330977e-18, -8.403114049473148e-20,  2.615253034958658e-21, -7.665892621382566e-23,  3.174595179106961e-10,
 -6.191029492255516e-11,  7.306206142545123e-12, -6.411429275484185e-13,  4.578463158403052e-14, -2.788591828737285e-15,  1.491503279441781e-16, -7.145299061434765e-18,
  3.109789532997900e-19, -1.242786016271258e-20,  4.598642525097431e-22, -1.584517563957777e-23,  2.501689802256761e-12, -8.013589037395979e-13,  1.418575985542499e-13,
 -1.768375628548583e-14,  1.718285757068779e-15, -1.375652669757752e-16,  9.396610992520977e-18, -5.608999432822898e-19,  2.977376272707313e-20, -1.424269802355098e-21,
  6.204558760184888e-23, -2.479247153287827e-24,  1.068802385492846e-03, -2.305442255676052e-05,  3.449194874787911e-07, -4.508074106397340e-09,  5.534600685127122e-11,
 -5.417749094832589e-13,  8.624627526530737e-15, -8.690930117366835e-17, -1.078859435362749e-18, -4.855878623387730e-20,  3.079936920171651e-22,  3.104737132913054e-23,
  2.220597054710844e-03, -5.261632124484943e-05,  9.589313112318459e-07, -1.574923459277434e-08,  2.414113526064474e-10, -3.393595451566828e-12,  4.942594295461771e-14,
 -6.487395622888581e-16,  6.510900868414720e-18, -1.382907292446948e-19,  1.441429469552726e-21,  1.257818295535018e-23,  1.654036758273115e-03, -4.542658910466602e-05,
  1.052791668342625e-06, -2.164197601234569e-08,  4.062350794787345e-10, -7.192433967816411e-12,  1.173024097364149e-13, -1.870938886061269e-15,  2.993877598377425e-17,
 -3.936600012480469e-19,  5.861531404622254e-21, -1.067077605350247e-22,  6.069321833442040e-04, -2.020233142232466e-05,  5.949612911093740e-07, -1.497855366780906e-08,
  3.389965407101290e-10, -7.200386875218219e-12,  1.386560831741290e-13, -2.600850522957187e-15,  4.814631886438958e-17, -7.608609299197570e-19,  1.293967987434998e-20,
 -2.365303535172881e-22,  1.179689139733157e-04, -4.942313273646842e-06,  1.828405812118783e-07, -5.587950305061204e-09,  1.518879976624525e-10, -3.819546561935238e-12,
  8.739406822502319e-14, -1.911876525317098e-15,  4.018865423178062e-17, -7.717088257213493e-19,  1.479393817340496e-20, -2.795900561670138e-22,  1.211829561179222e-05,
 -6.620968512334148e-07,  3.061260843950501e-08, -1.141037432599037e-09,  3.740309949840988e-11, -1.116132515276375e-12,  3.037130844231973e-14, -7.771683927532810e-16,
  1.880612172442150e-17, -4.266102584012296e-19,  9.334043663410125e-21, -1.962081360718202e-22,  6.282904645081360e-07, -4.658341029844882e-08,  2.717823879579631e-09,
 -1.256264731233458e-10,  5.031039394037879e-12, -1.804974585090785e-13,  5.885372859745786e-15, -1.780668535018992e-16,  5.041656857409795e-18, -1.342096962283097e-19,
  3.394739023616971e-21, -8.176230393754142e-23,  1.510705696496877e-08, -1.604163668882257e-09,  1.219227900261248e-10, -7.213480184231480e-12,  3.623356248922881e-13,
 -1.603000885505405e-14,  6.384630111202589e-16, -2.329910513735476e-17,  7.875890109124161e-19, -2.486691455448385e-20,  7.386642876075478e-22, -2.073202625496986e-23,
  1.512436635711562e-10, -2.502789540584591e-11,  2.650728917034546e-12, -2.123348656005996e-13,  1.403344599991516e-14, -7.990047069578146e-16,  4.025919881929128e-17,
 -1.828720329695878e-18,  7.587332994115155e-20, -2.903991949184481e-21,  1.033306410939585e-22, -3.436071743951917e-24,  6.814907148721498e-13, -1.977679809388365e-13,
  3.252887184758049e-14, -3.823920928410880e-15,  3.541456507413693e-16, -2.723900854622728e-17,  1.798514694866026e-18, -1.042809493611923e-19,  5.398124279157816e-21,
 -2.526377474491233e-22,  1.079651796996424e-23, -4.241867609818287e-25,  9.817810471984211e-04, -2.049715499063495e-05,  2.958122018622099e-07, -3.698892287425335e-09,
  4.635684645833010e-11, -3.693400961668898e-13,  5.480242619563368e-15, -1.437959146927417e-16, -2.193284113415511e-18, -2.396340432966783e-22,  2.258970468230785e-21,
  4.999581230554206e-23,  2.024364121986811e-03, -4.563993878970101e-05,  7.910690126593999e-07, -1.237098393468239e-08,  1.840340539415945e-10, -2.405969405862394e-12,
  3.351845138535409e-14, -5.072011434332672e-16,  2.798326072417950e-18, -5.953681714869772e-20,  2.686909889631478e-21,  3.721163254859637e-23,  1.487673011818669e-03,
 -3.794259443497721e-05,  8.277906873419926e-07, -1.615605903103413e-08,  2.868048034615185e-10, -4.909248185794148e-12,  7.647002559495533e-14, -1.103097279439478e-15,
  1.892809369500956e-17, -2.452659742157570e-19,  1.749550274659257e-21, -7.887501998555723e-23,  5.346209571186597e-04, -1.607928573869851e-05,  4.435349860115731e-07,
 -1.054778408419508e-08,  2.231713832838576e-10, -4.594634774312008e-12,  8.388798132439827e-14, -1.416955315300442e-15,  2.785097844363870e-17, -4.208846315345987e-19,
  4.704632004684153e-21, -1.453080510041185e-22,  1.007519304946933e-04, -3.711642787146085e-06,  1.281705945511346e-07, -3.670787432540624e-09,  9.279075860189485e-11,
 -2.241276607440907e-12,  4.838109527579500e-14, -9.768683977929223e-16,  2.058769692937125e-17, -3.738263473260830e-19,  6.147596640347424e-21, -1.333752495689858e-22,
  9.885401748182786e-06, -4.632636784562336e-07,  1.988487603373580e-08, -6.878994452917820e-10,  2.090636767116947e-11, -5.923261222929972e-13,  1.515684284005621e-14,
 -3.631375774047315e-16,  8.500749192809104e-18, -1.824991639046338e-19,  3.718051695871315e-21, -7.802270816394960e-23,  4.775185242979243e-07, -2.973420040841888e-08,
  1.595066650192970e-09, -6.775130026679465e-11,  2.507923601725307e-12, -8.452466472550736e-14,  2.584539313968669e-15, -7.354813559748644e-17,  1.981889718243277e-18,
 -5.000571944613021e-20,  1.200335084086743e-21, -2.781684579058398e-23,  1.020563689267123e-08, -8.963542901642340e-10,  6.175994335529515e-11, -3.327818297867328e-12,
  1.539542015395510e-13, -6.347666645561202e-15,  2.365751731868227e-16, -8.123111356189341e-18,  2.599145425971906e-19, -7.787582684692862e-21,  2.203457029666317e-22,
 -5.916007333728956e-24,  8.153785897276151e-11, -1.114041364208779e-11,  1.054719165731292e-12, -7.662161681989371e-14,  4.660383608363975e-15, -2.468960772212279e-16,
  1.166464718702602e-17, -5.002048857917657e-19,  1.970474066769031e-20, -7.194608515815536e-22,  2.452666807773648e-23, -7.843913135426533e-25,  2.161968151741711e-13,
 -5.472702048170333e-14,  8.204807531934280e-15, -8.963546558803045e-16,  7.823102100878965e-17, -5.727983361831770e-18,  3.628149585883312e-19, -2.030433445851714e-20,
  1.019471685080819e-21, -4.646532541934861e-23,  1.940288316928923e-24, -7.470098419067363e-26,  9.042614170559668e-04, -1.829611746689775e-05,  2.556510654692769e-07,
 -3.010635745380076e-09,  3.992073732873295e-11, -2.933487534198779e-13,  6.164302174818809e-16, -1.930179652503540e-16, -1.546033930566929e-19,  1.200702802717131e-19,
  3.144166748494103e-21, -3.447164984630036e-23,  1.853587453049838e-03, -3.985853305692269e-05,  6.588253221416340e-07, -9.772350115043455e-09,  1.428555915738449e-10,
 -1.762993500902091e-12,  2.041278399557033e-14, -4.284379837076779e-16,  2.907205971649258e-18,  7.037537765730941e-20,  3.311074027081666e-21, -3.168226552968767e-23,
  1.348020477559187e-03, -3.202461055392942e-05,  6.585081954213535e-07, -1.226231604133266e-08,  2.047911924821352e-10, -3.383991704756256e-12,  5.279712632760876e-14,
 -6.310191450485225e-16,  1.067086551173028e-17, -2.271141180994493e-19, -2.494935981893566e-22,  2.718438801781022e-24,  4.766760541748245e-04, -1.298293021871012e-05,
  3.356750476520663e-07, -7.614639939752907e-09,  1.486630333660837e-10, -2.969693251005393e-12,  5.460703777803015e-14, -7.427071188227456e-16,  1.480052450073321e-17,
 -3.314007585751077e-19,  6.501381560728419e-22, -2.342187992972891e-23,  8.770871505340252e-05, -2.840274836005419e-06,  9.173167343891549e-08, -2.489755681051399e-09,
  5.769847838494708e-11, -1.344905394988787e-12,  2.850874759396616e-14, -4.957978691284089e-16,  1.038454037246481e-17, -2.189206040263548e-19,  2.223750076010372e-21,
 -4.638317606018255e-23,  8.305208932369665e-06, -3.323043983120177e-07,  1.330191501605097e-08, -4.313781146339676e-10,  1.201025385831850e-11, -3.250278623301153e-13,
  7.980718955395388e-15, -1.731781402025792e-16,  3.938878132995226e-18, -8.564675598076473e-20,  1.467877025154206e-21, -3.016435398070597e-23,  3.797712360298337e-07,
 -1.965317340515986e-08,  9.762990591982734e-10, -3.836793786760881e-11,  1.301931421124955e-12, -4.142449199981867e-14,  1.196813263069821e-15, -3.162673421164493e-17,
  8.146924287311824e-19, -1.978341585965381e-20,  4.392313178081476e-22, -9.839655162945298e-24,  7.403989017028851e-09, -5.281038622802767e-10,  3.323876728133308e-11,
 -1.634913472916669e-12,  6.930049410287002e-14, -2.668209616257608e-15,  9.312660771313878e-17, -2.995375786262323e-18,  9.079536662294266e-20, -2.583446060186093e-21,
  6.924124496915371e-23, -1.780140859670391e-24,  4.942408496241361e-11, -5.408660586041599e-12,  4.584951679968175e-13, -3.007938478076482e-14,  1.674371061822847e-15,
 -8.228931266723853e-17,  3.631720987291732e-18, -1.464110147147177e-19,  5.458550167687219e-21, -1.894653086717626e-22,  6.165129720316133e-24, -1.890640265198859e-25,
  8.196182256882762e-14, -1.721337603017048e-14,  2.307729861648709e-15, -2.305685954832819e-16,  1.872649810565462e-17, -1.292016720763927e-18,  7.783320363123746e-20,
 -4.173549943704073e-21,  2.019915888258940e-22, -8.917591062801419e-24,  3.621740845129569e-25, -1.360877416119790e-26,  8.349532932528741e-04, -1.638501064834127e-05,
  2.231599030067543e-07, -2.419824788535232e-09,  3.378076408465861e-11, -3.392342074588954e-13, -4.066353283462916e-15, -1.105024595829717e-16,  5.607997723119292e-18,
  1.652590411022985e-19, -2.062928339149921e-21, -1.881580602025074e-22,  1.704003345095679e-03, -3.502067272952568e-05,  5.541832981493135e-07, -7.745972843197646e-09,
  1.115903250973719e-10, -1.403390941990069e-12,  1.025318985731014e-14, -2.747132760874420e-16,  7.079055576663534e-18,  1.297818960589141e-19, -1.429681268164922e-21,
 -1.739212309565971e-22,  1.229598618796789e-03, -2.729415666881430e-05,  5.289949830915423e-07, -9.463658379888559e-09,  1.485187671360020e-10, -2.297872650150570e-12,
  3.867891706353123e-14, -4.197619739402399e-16,  2.693052462339272e-18, -1.966756677230116e-19,  2.634379378856315e-21,  1.156691196081131e-22,  4.295881008182411e-04,
 -1.062667919048258e-05,  2.568243761382279e-07, -5.646221882388576e-09,  1.009208728234915e-10, -1.865991149825362e-12,  3.868798411937097e-14, -4.538054651766916e-16,
  3.572161655082112e-18, -2.732151066147273e-19,  3.496410177016956e-21,  1.396258119980602e-22,  7.764584065698893e-05, -2.212059462033602e-06,  6.661497967479880e-08,
 -1.748721731206614e-09,  3.668316425516806e-11, -7.964719045235587e-13,  1.820070419821290e-14, -2.748829149062530e-16,  3.844835766821361e-18, -1.455163269469515e-19,
  2.029340712602213e-21,  3.158915635676872e-23,  7.160074117493120e-06, -2.437621285233409e-07,  9.093593887482942e-09, -2.822370113237415e-10,  7.095119264712789e-12,
 -1.799334926453527e-13,  4.501245417162118e-15, -8.719496879177978e-17,  1.672788583237954e-18, -4.489088604295736e-20,  7.540203818277550e-22, -4.968801717450061e-24,
  3.142914665230998e-07, -1.338444802156399e-08,  6.178730391766410e-10, -2.285977900454211e-11,  7.017623884153933e-13, -2.093649169892976e-14,  5.892245341504695e-16,
 -1.425296446102854e-17,  3.373342578394444e-19, -8.454213216852382e-21,  1.750489289327691e-22, -3.184756241569828e-24,  5.721250604730131e-09, -3.252074518952342e-10,
  1.883923209943729e-11, -8.551302348673026e-13,  3.288438797675664e-14, -1.181336317481169e-15,  3.902721711464954e-17, -1.166268340294695e-18,  3.324207267043293e-20,
 -9.129536443149275e-22,  2.301772550818654e-23, -5.536000446195838e-25,  3.334914195632529e-11, -2.829107144964345e-12,  2.162104261332415e-13, -1.282540894544957e-14,
  6.485127256113601e-16, -2.951628008291309e-17,  1.215984829530769e-18, -4.585145392524213e-20,  1.612922745750818e-21, -5.317541711631821e-23,  1.643890242614483e-24,
 -4.814970305479401e-26,  3.775162465628793e-14, -6.184295533447316e-15,  7.310869751732737e-16, -6.577058812539770e-17,  4.904953554855621e-18, -3.156014930372932e-19,
  1.791761809456277e-20, -9.131345860991900e-22,  4.230809561438859e-23, -1.798398732186731e-24,  7.065632478859588e-26, -2.579233341163898e-27,  7.728121466663275e-04,
 -1.470724825485990e-05,  1.971220281798378e-07, -1.939538114583561e-09,  2.589428675670392e-11, -4.491530280601418e-13, -3.961158387322457e-15,  1.321634649441846e-16,
  8.137230537796081e-18, -6.948469530687194e-20, -8.484663017105452e-21, -2.562793035412017e-23,  1.572239027318763e-03, -3.093071770322242e-05,  4.710554366513183e-07,
 -6.173806352135985e-09,  8.550818043774780e-11, -1.220474956407685e-12,  6.268408432594944e-15,  4.743911068312334e-19,  8.899291518837307e-18, -7.193249900265019e-20,
 -7.653427259287807e-21, -3.611914347352163e-23,  1.128219489213375e-03, -2.347923977217269e-05,  4.283250061764534e-07, -7.408476028943414e-09,  1.109182484285918e-10,
 -1.506448131768720e-12,  2.727018394348379e-14, -4.167249134176708e-16, -1.313576741037625e-18,  4.078811889469334e-22,  6.382415615342169e-21,  1.905636217176579e-24,
  3.907968627985240e-04, -8.818181769749733e-06,  1.976785060112593e-07, -4.283789676298234e-09,  7.188963485681417e-11, -1.084855986137648e-12,  2.636752628172313e-14,
 -4.575342544742581e-16, -2.251362325043022e-18, -1.499143003023688e-20,  8.523502641779083e-21,  1.740084799903485e-23,  6.974320921290443e-05, -1.754169061066764e-06,
  4.869643981328459e-08, -1.267915533044217e-09,  2.455205879434506e-11, -4.423161356544390e-13,  1.156874591089408e-14, -2.168544733111889e-16,  4.544014191982319e-19,
 -3.303020955834196e-20,  3.396543957446823e-21,  4.071115585187576e-24,  6.311480499551777e-06, -1.828699854299150e-07,  6.286094495079393e-09, -1.923732443534312e-10,
  4.404650889635678e-12, -9.644383809875904e-14,  2.606352300734371e-15, -5.391948666570263e-17,  5.765910403406761e-19, -1.623652268497598e-20,  6.989613633182679e-22,
 -2.237470099261468e-24,  2.691353796832004e-07, -9.375280999553551e-09,  3.992707706333739e-10, -1.432998668157943e-11,  3.973888243269299e-13, -1.060288162340249e-14,
  3.038505319752765e-16, -7.192989019764610e-18,  1.336942555136976e-19, -3.380344186842620e-21,  9.364541762728950e-23, -1.105864317290243e-24,  4.667477175198591e-09,
 -2.081078076960574e-10,  1.109387013994164e-11, -4.763772952055140e-13,  1.649132526518835e-14, -5.413603353870729e-16,  1.736154242663335e-17, -4.889092389377976e-19,
  1.246552130720111e-20, -3.345171321176176e-22,  8.595575118663383e-24, -1.768511595115655e-25,  2.471799068961322e-11, -1.575018784148474e-12,  1.092364534469802e-13,
 -5.936633189043184e-15,  2.700424692646051e-16, -1.130650848640771e-17,  4.380283891496003e-19, -1.540723561405987e-20,  5.054774270148147e-22, -1.589701249758818e-23,
  4.694254274086955e-25, -1.290214768899202e-26,  2.111365346141664e-14, -2.520512697019835e-15,  2.616215232486767e-16, -2.097425820281961e-17,  1.415572557839121e-18,
 -8.410851798017248e-20,  4.464419295733681e-21, -2.143583950939974e-22,  9.435593748148662e-24, -3.839144133899884e-25,  1.450668312916348e-26, -5.114891724868953e-28,
  7.169987122053383e-04, -1.321703466026453e-05,  1.760248513311572e-07, -1.600523946064333e-09,  1.639423195874781e-11, -4.749663867978972e-13,  2.563998214317695e-15,
  2.919280162098343e-16,  3.321092240134826e-19, -3.144851852640904e-19, -1.177333946945087e-21,  3.114738693345168e-22,  1.455614293043328e-03, -2.743715850179506e-05,
  4.044008076216190e-07, -4.992245178034215e-09,  6.275274160561415e-11, -1.042155194859605e-12,  9.472274591109268e-15,  1.881989460095331e-16,  1.415910139663335e-18,
 -3.008099679189023e-19, -1.313265282678020e-21,  2.866485701385835e-22,  1.040632526390241e-03, -2.038015556761487e-05,  3.491813679033840e-07, -5.843291193365591e-09,
  8.637068066770288e-11, -9.950416183670625e-13,  1.534452607888399e-14, -4.138232092289277e-16,  2.600798463462237e-18,  1.800131878227542e-19,  9.314336132091041e-22,
 -2.149130533737267e-22,  3.583871097427483e-04, -7.424269413030728e-06,  1.525575842431776e-07, -3.277235160600278e-09,  5.544720090312409e-11, -6.121305543283096e-13,
  1.291428925349014e-14, -4.770978089826674e-16,  2.590178856422904e-18,  2.387575097301227e-19,  1.845166053789072e-21, -2.843140259499897e-22,  6.341796709668705e-05,
 -1.419363788711840e-06,  3.558980668909342e-08, -9.328074698506866e-10,  1.799757105773679e-11, -2.360766086708729e-13,  5.700488831340104e-15, -1.968379723533743e-16,
  1.437409453703433e-18,  7.161354673989149e-20,  1.014491909998030e-21, -1.025819873981200e-22,  5.667480683073216e-06, -1.407440082803383e-07,  4.346494696211337e-09,
 -1.344120531988057e-10,  2.988167119516310e-12, -5.027977373172003e-14,  1.303201510774524e-15, -3.986575933182393e-17,  4.331011994794882e-19,  5.439083002476326e-21,
  2.740023954637450e-22, -1.649785277191572e-23,  2.370677233607024e-07, -6.774715514759137e-09,  2.595769884959426e-10, -9.332989782057710e-12,  2.440495826198827e-13,
 -5.332800767343153e-15,  1.486553139871011e-16, -4.233757730251058e-18,  6.761294266108940e-20, -6.376874860964902e-22,  4.066023210626216e-23, -1.421365788742997e-24,
  3.981751496886341e-09, -1.384333423387343e-10,  6.665512806087792e-12, -2.804596170491072e-13,  8.915350144828260e-15, -2.529642886847119e-16,  7.843953212554398e-18,
 -2.290321815840368e-19,  5.104479850654797e-21, -1.084570724395012e-22,  3.347577236512871e-24, -8.507973079898986e-26,  1.979947482392226e-11, -9.267237211124325e-13,
  5.797468806544037e-14, -2.973285799846129e-15,  1.216945470381831e-16, -4.565053970172865e-18,  1.676339869758647e-19, -5.640378896416079e-21,  1.687712603812743e-22,
 -4.901547311444054e-24,  1.444224747609241e-25, -3.846132640419854e-27,  1.403623953851982e-14, -1.147397830514470e-15,  1.047819847118993e-16, -7.519114029524698e-18,
  4.525462963795476e-19, -2.450881059320179e-20,  1.211450695683911e-21, -5.448274765424991e-23,  2.254133671516911e-24, -8.717050152136169e-26,  3.160832693013117e-27,
 -1.070035249073876e-28,  6.668307186706363e-04, -1.188188856994000e-05,  1.580971196144649e-07, -1.408198513257984e-09,  8.135134279010430e-12, -3.242639587478759e-13,
  9.274231339819851e-15,  1.386400490319062e-16, -8.670919713897126e-18, -1.127390400341351e-19,  9.410481211187309e-21,  6.906433974839227e-23,  1.351978781760138e-03,
 -2.442600606394311e-05,  3.498751567828620e-07, -4.140837316936030e-09,  4.459449428678391e-11, -7.562164571338344e-13,  1.381974717336931e-14,  7.469641135023309e-17,
 -7.390124687272984e-18, -1.186734594488850e-19,  8.800966234147307e-21,  7.487533287538822e-23,  9.642860291887230e-04, -1.784509084846969e-05,  2.867513552783639e-07,
 -4.604252499946046e-09,  6.928746985077029e-11, -7.506201930369498e-13,  5.843218443915842e-15, -2.375774011819843e-16,  7.610802055159307e-18,  4.994966466576165e-20,
 -6.101275654994367e-21, -4.058567439702105e-23,  3.309020601381804e-04, -6.346876926520618e-06,  1.181924556335237e-07, -2.475452210060355e-09,  4.530395309103472e-11,
 -4.452848589589097e-13,  1.967804889439130e-15, -2.666816609104110e-16,  9.590682826522024e-18,  8.175147896632445e-20, -8.089969056869117e-21, -7.415506524321735e-23,
  5.824554352293005e-05, -1.174844110318028e-06,  2.598732591272057e-08, -6.769340508809044e-10,  1.423499982944305e-11, -1.577652591526272e-13,  1.224505154114187e-15,
 -1.106490346135822e-16,  3.669314434389622e-18,  2.653974765835379e-20, -2.740231983243209e-21, -3.330940243703451e-23,  5.164891702211272e-06, -1.116781925808009e-07,
  2.991771026664408e-09, -9.329534089775848e-11,  2.213945227888346e-12, -3.061123001160236e-14,  4.170947987799816e-16, -2.220278410307619e-17,  6.505439038238280e-19,
  2.313714331744996e-21, -3.565820715583276e-22, -6.760052705571108e-24,  2.134971769335209e-07, -5.086730991622955e-09,  1.680181865421366e-10, -6.123690434454151e-12,
  1.646732758341413e-13, -2.956157494813959e-15,  5.847857327045710e-17, -2.245168778141588e-18,  5.914565192244182e-20, -2.003266931435017e-22, -1.343055997326313e-23,
 -6.973368571676155e-25,  3.516339912518855e-09, -9.647399077825046e-11,  4.016804166632633e-12, -1.699465790240559e-13,  5.302069238730600e-15, -1.260587525569831e-16,
  3.276127988268107e-18, -1.089446214973511e-19,  2.814662234528356e-21, -3.751583554654386e-23,  5.273358814052095e-25, -3.938833223498512e-26,  1.683329729615007e-11,
 -5.782899142682397e-13,  3.154892303209867e-14, -1.582457445043374e-15,  6.041760647506245e-17, -1.956927548200528e-18,  6.512683441889961e-20, -2.217516255826581e-21,
  6.458412493344849e-23, -1.559890359678770e-24,  4.077350179439072e-26, -1.291228717521973e-27,  1.068674165881336e-14, -5.760433162036310e-16,  4.580758255897206e-17,
 -3.022161757716002e-18,  1.619434646260311e-19, -7.800910716832714e-21,  3.560221492886822e-22, -1.511995327137025e-23,  5.853146998206766e-25, -2.105874528483924e-26,
  7.270344744656830e-28, -2.396369985540954e-29,  6.217282734185135e-04, -1.068290252141474e-05,  1.418070659286510e-07, -1.317091595458868e-09,  4.021649871295083e-12,
 -8.760723947981232e-14,  9.174666640680684e-15, -1.330413159969730e-16, -6.393789045952396e-18,  2.004861144836066e-19,  3.885514139033301e-21, -2.442036030638666e-22,
  1.259573814550880e-03, -2.181466619017057e-05,  3.040261763383360e-07, -3.530095133231640e-09,  3.281040817568915e-11, -4.276663594415846e-13,  1.244285088466798e-14,
 -1.632196649976016e-16, -5.646121803776083e-18,  1.810078695428049e-19,  3.881096562754259e-21, -2.295324488073305e-22,  8.971689175229005e-04, -1.575433856829058e-05,
  2.376762198191217e-07, -3.609894547026104e-09,  5.528177004038774e-11, -6.626991631160642e-13,  2.540852142776500e-15, -1.066327994848162e-17,  5.357591972258890e-18,
 -1.484602797836006e-19, -2.300240789157762e-21,  1.609853972100080e-22,  3.072340104310914e-04, -5.508506491787890e-06,  9.254522868243467e-08, -1.821170842341837e-09,
  3.644821984907336e-11, -4.525190434162837e-13, -1.206725818222101e-15,  2.565990902750650e-17,  6.995310107664032e-18, -1.933608666437342e-19, -3.459787824133236e-21,
  2.177202252823168e-22,  5.391567525054489e-05, -9.958000911004368e-07,  1.912943017963280e-08, -4.736307617794547e-10,  1.119210287324547e-11, -1.521822764302395e-13,
 -2.405891457394283e-16,  6.590016283159764e-19,  2.691387800609837e-18, -7.054141409314225e-20, -1.279679813163481e-21,  7.687464459100770e-23,  4.759749009088953e-06,
 -9.166388030081878e-08,  2.065848492043084e-09, -6.239521515445091e-11,  1.663568822087908e-12, -2.573696588115010e-14,  7.840675666184813e-17, -2.978998180425861e-18,
  4.667483763200066e-19, -1.132920464328282e-20, -1.901118653307128e-22,  1.110770988255768e-23,  1.954309666678356e-07, -3.995820357778140e-09,  1.085890711699276e-10,
 -3.903303305123072e-12,  1.155532643386813e-13, -2.104494271110646e-15,  2.008359390122722e-17, -6.025234385843013e-19,  3.925369846989088e-20, -8.786464679576747e-22,
 -1.035574642774992e-23,  6.398685850847205e-25,  3.183609756802319e-09, -7.122314249286090e-11,  2.414657357412601e-12, -1.018799344116221e-13,  3.367698361168284e-15,
 -7.502658816181373e-17,  1.298041452518748e-18, -3.878286145472074e-20,  1.580008734125134e-21, -3.447333368304649e-23, -1.253014075570582e-26,  8.961577972021563e-27,
  1.492451749971219e-11, -3.879354407875379e-13,  1.729421687946092e-14, -8.614406643295961e-16,  3.290039941217683e-17, -9.483589338033760e-19,  2.524958509818472e-20,
 -8.214059939978328e-22,  2.770299989832960e-23, -6.826008217189953e-25,  1.080764146363356e-26, -2.310211730677822e-28,  8.935440294445108e-15, -3.200250271780882e-16,
  2.112556330934249e-17, -1.328163997527065e-18,  6.563860321452240e-20, -2.761599898870508e-21,  1.114616905171552e-22, -4.478909162950835e-24,  1.683242201796061e-25,
 -5.638693561809452e-27,  1.745974771065624e-28, -5.433166359161032e-30,  5.811669347810501e-04, -9.610635596631046e-06,  1.263647161296511e-07, -1.256389224410930e-09,
  4.080759869333383e-12,  7.199620861409581e-14,  3.766155058528115e-15, -2.122118039619019e-16,  1.217162785172894e-18,  1.672944131934261e-19, -4.227283200145010e-21,
 -7.537721088813111e-23,  1.176923145481771e-03, -1.954353046852676e-05,  2.645801850521513e-07, -3.059167123650208e-09,  2.679556241905215e-11, -1.976849973416194e-13,
  6.424801827865433e-15, -2.286944520481095e-16,  1.378875647716478e-18,  1.563645394488243e-19, -3.907495831510210e-21, -7.542274076073675e-23,  8.376999588474045e-04,
 -1.401215220309411e-05,  1.992383024059990e-07, -2.827924608389503e-09,  4.269133908881176e-11, -5.911692981670436e-13,  3.789435507162543e-15,  7.059499407870471e-17,
 -7.693160150153539e-20, -1.180289588181189e-19,  2.925659793240944e-21,  4.594645725177030e-23,  2.865553788509899e-04, -4.846342243110167e-06,  7.388801910745481e-08,
 -1.311364678137953e-09,  2.726785411027776e-11, -4.544946259523622e-13,  1.514558572678529e-15,  1.294426762447956e-16, -2.925330379570567e-19, -1.615661872386993e-19,
  3.893191292471316e-21,  6.992821893309110e-23,  5.020654081178629e-05, -8.626873987804989e-07,  1.441921487970143e-08, -3.190708631185680e-10,  8.131790354031652e-12,
 -1.505397446421573e-13,  5.692478627860539e-16,  4.272990565611305e-17,  8.300654747191225e-21, -6.029349979631808e-20,  1.398121462146105e-21,  2.674090321796981e-23,
  4.421993051971560e-06, -7.771806319777324e-08,  1.460137705299088e-09, -3.979693219484485e-11,  1.167900460179144e-12, -2.357374919139569e-14,  1.378996833826104e-16,
  4.918181326932695e-18,  3.744094858532860e-20, -9.759924627703834e-21,  2.144012596780835e-22,  4.268238471274709e-24,  1.809288047393477e-07, -3.286084003776036e-09,
  7.152803432949686e-11, -2.368554504551444e-12,  7.752067218157147e-14, -1.713646693872891e-15,  1.580837276146742e-17,  1.251610753599594e-19,  7.183992794511741e-21,
 -7.290728328968411e-22,  1.496493534362035e-23,  2.853321621985679e-25,  2.930763727726595e-09, -5.598461612868518e-11,  1.470569420796176e-12, -5.858932552931261e-14,
  2.115462037680881e-15, -5.231746596370146e-17,  7.384096114158703e-19, -7.175220963148981e-21,  4.551035898217603e-22, -2.455459760576349e-23,  4.797602985744079e-25,
  6.087091921028063e-27,  1.359497670899173e-11, -2.832419722155989e-13,  9.578495638987577e-15, -4.601281734802829e-16,  1.856124851921977e-17, -5.382551837861580e-19,
  1.148478501420654e-20, -2.570752481180203e-22,  9.530062916156793e-24, -3.469431577962159e-25,  7.334782530426635e-27, -3.179590193195625e-29,  7.913055715069067e-15,
 -2.003463493117717e-16,  1.004248091306166e-17, -6.081507456816161e-19,  2.949365494938313e-20, -1.131526608918286e-21,  3.842021862139952e-23, -1.346628500945389e-24,
  5.000050570200438e-26, -1.727179391830170e-27,  5.024233770522027e-29, -1.271059973886121e-30,  5.446524821556406e-04, -8.658782740617076e-06,  1.117380256206642e-07,
 -1.176548623711351e-09,  5.985084372640294e-12,  9.979625188399579e-14, -9.751392885018161e-16, -1.119844267655858e-16,  3.994857530479424e-18, -5.360323106560135e-21,
 -3.243504320010119e-21,  8.209509057466959e-23,  1.102759759252393e-03, -1.756669691527048e-05,  2.303336094498093e-07, -2.655722006626384e-09,  2.390874618327355e-11,
 -1.113094984573545e-13,  1.252022049486268e-15, -1.272892522266792e-16,  3.968810981319899e-18, -5.973112622155579e-21, -3.082170220046119e-21,  7.714960794687164e-23,
  7.846394936845981e-04, -1.254323742691098e-05,  1.690291418979128e-07, -2.233883699497814e-09,  3.192253878899447e-11, -4.798516641557208e-13,  5.263677423882784e-15,
  2.406879798510917e-17, -2.119857895510034e-18, -1.180222693628235e-21,  2.172946534596349e-21, -5.499805789358951e-23,  2.682621378087533e-04, -4.311438903061420e-06,
  6.047898172725885e-08, -9.446674722257942e-10,  1.881094683465446e-11, -3.799310397221837e-13,  4.364216764907895e-15,  5.940656007290793e-17, -3.110646015304108e-18,
 -1.707698793164259e-21,  3.029955871305625e-21, -7.489784040198910e-23,  4.696507864513932e-05, -7.606592869932218e-07,  1.127512959434420e-08, -2.119205655390020e-10,
  5.347684589168331e-12, -1.240788563786444e-13,  1.526634546032786e-15,  2.001082111758891e-17, -1.072474359086933e-18, -1.937006147790525e-21,  1.121714825174568e-21,
 -2.704162652913575e-23,  4.131861419795212e-06, -6.766397937764201e-08,  1.079842760010854e-09, -2.465677765782960e-11,  7.402311843960623e-13, -1.873656432579446e-14,
  2.524560840395606e-16,  2.309793001778589e-18, -1.451018819756334e-19, -6.802513299143229e-22,  1.773220775556320e-22, -4.125384252003183e-24,  1.687754179926998e-07,
 -2.808928669231748e-09,  4.948692336001918e-11, -1.380401143155337e-12,  4.737320401339197e-14, -1.285984515719407e-15,  1.948367218461895e-17,  6.156945398125313e-20,
 -7.291654742434904e-21, -9.433544893980989e-23,  1.257585292633157e-23, -2.782777565434356e-25,  2.726616650663294e-09, -4.653046052185887e-11,  9.390359317059660e-13,
 -3.219764077608355e-14,  1.235602617025739e-15, -3.603840627520020e-17,  6.363113806260280e-19, -2.856068274693114e-21, -6.802412696698871e-23, -5.242691873508988e-24,
  3.805736890944644e-25, -7.939166502520523e-27,  1.258645408045682e-11, -2.243824354876593e-13,  5.526622454899931e-15, -2.362488380455446e-16,  1.010566243928753e-17,
 -3.241429480227382e-19,  7.060417211419727e-21, -9.928653381763606e-23,  1.795923033046440e-24, -1.022672965461302e-25,  4.422551004472029e-27, -9.168227164567541e-29,
  7.235534111803243e-15, -1.426225150792735e-16,  4.962977961472029e-18, -2.773817763936424e-19,  1.376348656528377e-20, -5.269681748461042e-22,  1.601190591511322e-23,
 -4.407010231201326e-25,  1.376885727737308e-26, -5.010239470852739e-28,  1.685192154218788e-29, -4.400103026332322e-31,  5.117182245317093e-04, -7.819585765991790e-06,
  9.825344942455791e-08, -1.066907312259589e-09,  7.564210405562077e-12,  5.231669190795701e-14, -2.486835647737198e-15, -5.111461422221870e-18,  2.339653221561744e-18,
 -6.455909928509108e-20,  1.691156659607546e-23,  4.920079322180292e-23,  1.035985439602547e-03, -1.584516309864644e-05,  2.006892998996160e-07, -2.290322107977201e-09,
  2.176512120801134e-11, -1.105595990078871e-13, -6.966179870910757e-16, -2.074824876344032e-17,  2.360868585017567e-18, -6.240454853119173e-20,  1.571596068171634e-23,
  4.709839413902790e-23,  7.370125886286636e-04, -1.129023196823487e-05,  1.449929359899366e-07, -1.792939843934875e-09,  2.360539388939787e-11, -3.526602243395029e-13,
  5.073356574804836e-15, -3.243724519106886e-17, -1.177939525177131e-18,  3.894330954932541e-20,  1.586292394372237e-23, -3.233390563846643e-23,  2.519187622404858e-04,
 -3.868373026947291e-06,  5.071757358147701e-08, -6.984209797039187e-10,  1.233861806953248e-11, -2.658612928747780e-13,  4.753397613396221e-15, -2.428538041179682e-17,
 -1.790301891014436e-18,  5.480963937521710e-20,  3.460013374636754e-23, -4.553417039661194e-23,  4.408855957872115e-05, -6.793508658149184e-07,  9.170372994196215e-09,
 -1.440970214913194e-10,  3.258504765521974e-12, -8.440823618451051e-14,  1.643861197433855e-15, -9.149353590963134e-18, -6.257247660875842e-19,  1.934025593595517e-20,
  2.554792435893578e-23, -1.684662097496489e-23,  3.876858554040095e-06, -6.003368941453402e-08,  8.437614228633781e-10, -1.546905821083341e-11,  4.286691828700071e-13,
 -1.240901191613463e-14,  2.560733026614581e-16, -1.723059709058008e-18, -8.674700182851274e-20,  2.772551555066088e-21,  7.518668805797993e-24, -2.645139509249590e-24,
  1.582424069274575e-07, -2.468195721762933e-09,  3.670391791390485e-11, -8.026799148576939e-13,  2.633030444850818e-14, -8.243403402793441e-16,  1.797809263028429e-17,
 -1.539171756376751e-19, -4.681365281746136e-21,  1.606505359297888e-22,  9.565499822692357e-25, -1.839107497197456e-25,  2.553481212104694e-09, -4.027712140602503e-11,
  6.500965239718057e-13, -1.739734998835285e-14,  6.593864520643444e-16, -2.205943953052601e-17,  5.143381923882687e-19, -5.821275856402411e-21, -6.922579527856867e-23,
  2.943771527817209e-24,  5.062139557152830e-26, -5.282860781152316e-27,  1.176269643034961e-11, -1.891978783834236e-13,  3.475293654494546e-15, -1.180758197919923e-16,
  5.115069211097796e-18, -1.839336399670350e-19,  4.729906615887539e-21, -7.428876928900003e-23,  3.629432640648287e-25, -6.259208440924727e-28,  9.533492787718524e-28,
 -5.389141168023114e-29,  6.727748903399891e-15, -1.131724985416772e-16,  2.665833166783492e-18, -1.240755096354703e-19,  6.268324924695768e-21, -2.538044523197551e-22,
  7.868399301943780e-24, -1.902425058443417e-25,  4.124988402129199e-27, -1.158020548065578e-28,  4.449979176930881e-30, -1.570002888879901e-31,  4.819338349944899e-04,
 -7.082653520345902e-06,  8.620092534391233e-08, -9.406753255153332e-10,  8.037015568638226e-12, -2.683341580322778e-15, -1.911215038830127e-15,  3.583067477276281e-17,
  3.837249575679987e-19, -3.832094136052692e-20,  9.211021559627220e-22, -1.467908375664197e-24,  9.756498797778708e-04, -1.434383844724770e-05,  1.752187477541564e-07,
 -1.960747907573275e-09,  1.937527634696237e-11, -1.277038328194642e-13, -5.385225892916245e-16,  2.197449679938594e-17,  4.669163322732608e-19, -3.726291436584290e-20,
  8.834672560383708e-22, -1.378879612872296e-24,  6.940436940128493e-04, -1.021042377559376e-05,  1.255314569760987e-07, -1.465432777417004e-09,  1.767954481922646e-11,
 -2.448135189479115e-13,  3.836512473905489e-15, -4.963503415900233e-17,  1.219045432633830e-21,  2.274633736260552e-20, -5.813115163453127e-22,  8.053702915306090e-25,
  2.372079254177807e-04, -3.493165920819914e-06,  4.336477688927492e-08, -5.376673329810978e-10,  8.081185650496532e-12, -1.646586753052251e-13,  3.552213050559683e-15,
 -5.264337486929702e-17, -1.232271237859612e-19,  3.238354681869229e-20, -8.123835635945858e-22,  1.004222343166935e-24,  4.150802967368770e-05, -6.121331689123917e-07,
  7.704941106408376e-09, -1.034424068754915e-10,  1.935082793880481e-12, -4.967093334979030e-14,  1.206872633103440e-15, -1.891412207506571e-17, -3.406838106564743e-20,
  1.150012511383607e-20, -2.911460541630587e-22,  2.684584217571594e-25,  3.649190683021084e-06, -5.392630735034908e-08,  6.921208132444049e-10, -1.028275655751005e-11,
  2.368014100526477e-13, -7.066139140811854e-15,  1.833496978367139e-16, -3.014204342269886e-18, -9.610338781815183e-22,  1.668774588751372e-21, -4.305735237366873e-23,
  1.367617910227440e-26,  1.489045237113757e-07, -2.207040131695039e-09,  2.912675575052195e-11, -4.915474981793457e-13,  1.374425879235627e-14, -4.562213357080324e-16,
  1.242085115771143e-17, -2.157387432838473e-19,  4.247869791615991e-22,  9.976815696893083e-23, -2.660104205615991e-24, -2.633447266464243e-27,  2.401666206661420e-09,
 -3.576153063512986e-11,  4.920833624360288e-13, -9.764586778860700e-15,  3.275784891786240e-16, -1.181895108798722e-17,  3.369449505278011e-19, -6.297532825504037e-21,
  3.328120192031202e-23,  2.048650522240201e-24, -5.831314789423590e-26, -2.706419496563301e-28,  1.105417775263229e-11, -1.659147875142164e-13,  2.446140965301064e-15,
 -6.017837849543732e-17,  2.410426083400927e-18, -9.391776750621920e-20,  2.839738547004801e-21, -5.928587020368462e-23,  6.093548337063815e-25,  6.572324777690178e-27,
 -2.443563811443553e-28, -6.511400904520699e-30,  6.310255053991257e-15, -9.642363751221484e-17,  1.640021178106039e-18, -5.571293079273287e-20,  2.713483148866451e-21,
 -1.168707769021240e-22,  3.944267518773528e-24, -1.011619728723516e-25,  1.930910450545482e-27, -3.008164367112358e-29,  7.286610322457765e-31, -3.344365515539801e-32,
  4.549140069617784e-04, -6.436030989863248e-06,  7.567549234941171e-08, -8.146524673066635e-10,  7.608577110515830e-12, -3.615673429356798e-14, -8.953619393116588e-16,
  3.265212110471273e-17, -4.012593413317209e-19, -8.083313746178420e-21,  5.204340212657646e-22, -1.167727951739516e-23,  9.209361889094560e-04, -1.303113184784088e-05,
  1.534638549241277e-07, -1.671652311072136e-09,  1.674611609626240e-11, -1.325621805548713e-13,  1.304002299135359e-16,  2.179908400674893e-17, -3.040550414313961e-19,
 -8.244454671218718e-21,  4.998503722092239e-22, -1.118941475387950e-23,  6.551054657870958e-04, -9.272045987187489e-06,  1.094968555932828e-07, -1.217191696404308e-09,
  1.359413404129947e-11, -1.688075272310124e-13,  2.540018372400716e-15, -4.067144820532839e-17,  4.447139074844659e-19,  3.672758413327871e-21, -3.262641992794179e-22,
  7.493929431458276e-24,  2.238910435318632e-04, -3.170080321367855e-06,  3.759352966024488e-08, -4.305791892970504e-10,  5.522626628886866e-12, -9.667747359084618e-14,
  2.155783689994071e-15, -4.377739429413180e-17,  5.173719314300966e-19,  5.688788145566846e-21, -4.569211934374414e-22,  1.049344467337368e-23,  3.917556976026840e-05,
 -5.549986965610560e-07,  6.621226995567215e-09, -7.903281665612016e-11,  1.189119555604509e-12, -2.687907940074692e-14,  7.090086952723501e-16, -1.547821469079726e-17,
  1.913448474524154e-19,  1.914143967412638e-21, -1.637813747305305e-22,  3.800599669605761e-24,  3.443856453516155e-06, -4.882783096546630e-08,  5.874942525014181e-10,
 -7.413588865896018e-12,  1.328219106763981e-13, -3.637947839338795e-15,  1.052912088425812e-16, -2.395099828004015e-18,  3.111510708187379e-20,  2.451734308151671e-22,
 -2.426183971523417e-23,  5.726307395580221e-25,  1.405095175982283e-07, -1.994480112677863e-09,  2.429352739706816e-11, -3.304287455376978e-13,  7.130950384083969e-15,
 -2.264671906795164e-16,  6.969704233577547e-18, -1.640671464328813e-19,  2.271041915970986e-21,  1.092673810999866e-23, -1.510292600052818e-24,  3.662667836332211e-26,
  2.265856660695302e-09, -3.221985906383795e-11,  3.998215909786037e-13, -6.032058938115328e-15,  1.586363700333480e-16, -5.675663338212686e-18,  1.834642294852492e-19,
 -4.487247318583524e-21,  6.776097324430152e-23,  4.086695432564064e-26, -3.416037228556722e-26,  8.695953692699636e-28,  1.042584778321033e-11, -1.486999163659137e-13,
  1.903968597623234e-15, -3.345806695415993e-17,  1.091194125475318e-18, -4.333611453641513e-20,  1.473484628592796e-21, -3.807685938241946e-23,  6.546305176292657e-25,
 -3.488020672449902e-27, -1.775093563762547e-28,  5.112868368159562e-30,  5.947411252561913e-15, -8.538815996321133e-17,  1.169132396971831e-18, -2.670193156319625e-20,
  1.125649178163567e-21, -5.007006938152503e-23,  1.841929857063025e-24, -5.306065198040343e-26,  1.147943422014252e-27, -1.702258550146531e-29,  1.443077548677002e-31,
 -2.144074058344414e-33,  4.303216187185529e-04, -5.867721951186696e-06,  6.660322216918331e-08, -6.995853416480106e-10,  6.736417323958419e-12, -4.827414531419055e-14,
 -1.814489370444458e-16,  1.824083729639292e-17, -4.297904021638380e-19,  3.818557472541450e-21,  1.175685422815300e-22, -6.040644323855839e-24,  8.711462050174483e-04,
 -1.187930482414637e-05,  1.349252282526621e-07, -1.424568952854913e-09,  1.416919194732340e-11, -1.233664790168070e-13,  5.822006879683000e-16,  1.028579949738727e-17,
 -3.484844666139170e-19,  3.210300329195601e-21,  1.140975031796410e-22, -5.776375624724020e-24,  6.196816317227772e-04, -8.451035609543476e-06,  9.609392173504761e-08,
 -1.023740031010937e-09,  1.074389555049404e-11, -1.198573087465471e-13,  1.605887313021453e-15, -2.624499412265240e-17,  4.140899350274866e-19, -3.653609450155077e-21,
 -6.764618770432722e-23,  3.870864414366590e-24,  2.117814423019042e-04, -2.888628343985597e-06,  3.290099584282283e-08, -3.552561643209047e-10,  4.017259355684203e-12,
 -5.769268360374493e-14,  1.172363331663371e-15, -2.663389379357129e-17,  4.940517507953268e-19, -4.578346871738427e-21, -9.526855374066050e-23,  5.396001662845926e-24,
  3.705591760477385e-05, -5.055345441167331e-07,  5.771871681055185e-09, -6.351748036251345e-11,  7.903018293216932e-13, -1.434548295954319e-14,  3.644700478827441e-16,
 -9.213390536068856e-18,  1.788626869269293e-19, -1.736841122213686e-21, -3.291298615421870e-23,  1.945032983653705e-24,  3.257426313752456e-06, -4.445234409844890e-08,
  5.092684784559169e-10, -5.753939349341313e-12,  8.049621795293408e-14, -1.800580762346374e-15,  5.242842236479346e-17, -1.399728064917814e-18,  2.797912539785583e-20,
 -2.882483287939989e-22, -4.556546317038478e-24,  2.912864993088179e-25,  1.328975310919987e-07, -1.814345186709488e-09,  2.088901634965007e-11, -2.448928126594648e-13,
  3.944937695079435e-15, -1.060878173115516e-16,  3.386488214704527e-18, -9.382719109429391e-20,  1.929763889035536e-21, -2.148908155901481e-23, -2.492055045866808e-25,
  1.849799815643227e-26,  2.142967196183023e-09, -2.927494313698716e-11,  3.395887580858607e-13, -4.201117102987274e-15,  8.022093520687464e-17, -2.541509182959129e-18,
  8.693033434932015e-20, -2.489072021719477e-21,  5.306217910894334e-23, -6.566904790682879e-25, -4.050276597291195e-27,  4.367168016399294e-28,  9.859314704263750e-12,
 -1.348323706284998e-13,  1.583956606669112e-15, -2.133310116184723e-17,  5.033472872931933e-19, -1.855351837458995e-20,  6.744373238065443e-22, -2.008526075419558e-23,
  4.523127834208534e-25, -6.519869759026832e-27,  6.271277345303246e-30,  2.626357426895688e-30,  5.622884225188336e-15, -7.707334721235618e-17,  9.302900899280861e-19,
 -1.473821828987533e-20,  4.651559321386604e-22, -2.007005279804222e-23,  7.857941039747393e-25, -2.509871957588281e-26,  6.307707041174987e-28, -1.173888063240470e-29,
  1.330286218546345e-31,  2.532069357323635e-35,  4.078657030125001e-04, -5.366718123700808e-06,  5.882267795147301e-08, -5.996155886309185e-10,  5.761346320317785e-12,
 -4.790560049436797e-14,  1.613819294595131e-16,  7.176866379729039e-18, -2.564704460883623e-19,  4.834025882687099e-21, -3.262737201777125e-23, -1.360650499006139e-24,
  8.256847225785833e-04, -1.086461047276300e-05,  1.191118970098119e-07, -1.216764487260037e-09,  1.185893983223141e-11, -1.070699412183567e-13,  7.353432962365572e-16,
  1.464967982252072e-18, -1.973942415260589e-19,  4.251370692946559e-21, -2.933841349694254e-23, -1.296347994363372e-24,  5.873410890008321e-04, -7.728671132436974e-06,
  8.476751128707786e-08, -8.691453905595353e-10,  8.679816406842448e-12, -8.877017985492916e-14,  1.034644712897949e-15, -1.535364890196814e-17,  2.650411783475649e-19,
 -4.005649508678719e-21,  2.794552159308377e-23,  8.443651307677893e-25,  2.007277835257604e-04, -2.641458874834930e-06,  2.898983360624764e-08, -2.989056249617943e-10,
  3.092889964430629e-12, -3.688729453299426e-14,  6.201572699051227e-16, -1.382501756295485e-17,  3.040219512292412e-19, -5.116983647413254e-21,  3.740101686881478e-23,
  1.158756464041321e-24,  3.512158018592935e-05, -4.622125559389795e-07,  5.077389007443576e-09, -5.276953530768179e-11,  5.730448402238764e-13, -8.110482600651717e-15,
  1.762160700380309e-16, -4.610627074748810e-18,  1.082242707167981e-19, -1.879405451051286e-21,  1.453710266592058e-23,  4.043759033678827e-25,  3.087355722927465e-06,
 -4.063484231414089e-08,  4.469496048106937e-10, -4.697362193273830e-12,  5.437216292162290e-14, -9.217566686585545e-16,  2.407955484574717e-17, -6.856681646397850e-19,
  1.664336938085655e-20, -2.959656240922720e-22,  2.463452821199727e-24,  5.743146875710299e-26,  1.259570963106067e-07, -1.658051408910983e-09,  1.827114394088878e-11,
 -1.951091313563383e-13,  2.456026593872610e-15, -5.011048932105739e-17,  1.501402876854623e-18, -4.511874261259059e-20,  1.122937358045317e-21, -2.050299393652617e-23,
  1.877087562210997e-25,  3.320981153286766e-27,  2.031008070327207e-09, -2.674129783044318e-11,  2.955093039288425e-13, -3.231394800624689e-15,  4.550621730804512e-17,
 -1.121823641549613e-18,  3.740783282764468e-20, -1.171277515221826e-21,  2.990307254530493e-23, -5.657459231585660e-25,  5.875041705831870e-27,  6.389924447818071e-29,
  9.343869487101249e-12, -1.230711229776941e-13,  1.366426655606631e-15, -1.553315035839140e-17,  2.561422932513402e-19, -7.690697523036402e-21,  2.807801643889485e-22,
 -9.147469947012197e-24,  2.417195870508438e-25, -4.835576806927462e-27,  5.983829889112898e-29,  1.505867930116991e-31,  5.328500891557374e-15, -7.023682367061618e-17,
  7.875951254066830e-19, -9.684803066742184e-21,  2.056851873730400e-22, -7.717386840602643e-24,  3.093181763567809e-25, -1.066696114318935e-26,  3.011227542489507e-28,
 -6.730771771085139e-30,  1.100191177940793e-31, -9.488305328409028e-34,  3.872965409975648e-04, -4.923422333150956e-06,  5.214959491718528e-08, -5.148349092760721e-10,
  4.854092810748406e-12, -4.239869238360071e-14,  2.713371600465346e-16,  1.427742928195918e-18, -1.141219504715802e-19,  2.980421939728188e-21, -4.845205216975673e-23,
  2.633270089984938e-25,  7.840439440803558e-04, -9.967050853833393e-06,  1.055816322688455e-07, -1.043190933087909e-09,  9.894221057645325e-12, -8.951191306817004e-14,
  7.088813413803227e-16, -2.700376421450890e-18, -7.326250367419089e-20,  2.555487984810879e-21, -4.441939291300758e-23,  2.490153811409431e-25,  5.577197949896822e-04,
 -7.090015937300627e-06,  7.511644957373307e-08, -7.432529243480489e-10,  7.122325460712900e-12, -6.826340452921230e-14,  7.036229058784589e-16, -8.918692502056204e-18,
  1.458719053659066e-19, -2.564619812459071e-21,  3.660779935514324e-23, -2.052594302803988e-25,  1.906041881929778e-04, -2.423097804947600e-06,  2.567784094444717e-08,
 -2.546265671940690e-10,  2.477629330796307e-12, -2.570753696483328e-14,  3.440092330160965e-16, -6.693446602318124e-18,  1.534181273527197e-19, -3.183665221123089e-21,
  4.890682268530270e-23, -2.920112317884112e-25,  3.335016314322670e-05, -4.239815403773584e-07,  4.494453665628204e-09, -4.470631806132934e-11,  4.444439549792439e-13,
 -5.097036491910621e-15,  8.636390526952246e-17, -2.096742674972902e-18,  5.329823683254091e-20, -1.151911608529453e-21,  1.812412280203267e-23, -1.160315770560919e-25,
  2.931629801741155e-06, -3.727115512633698e-08,  3.952788493155371e-10, -3.949052430326341e-12,  4.043303425917574e-14, -5.231319750606820e-16,  1.088910051476987e-17,
 -3.016647052436519e-19,  8.067984844960254e-21, -1.783294394590871e-22,  2.866037744708111e-24, -2.003487226431814e-26,  1.196032571191953e-07, -1.520644768984131e-09,
  1.613786619253774e-11, -1.622372182349745e-13,  1.730119494164719e-15, -2.580184808475407e-17,  6.415130731058285e-19, -1.939153607071639e-20,  5.358642687765416e-22,
 -1.207269017968763e-23,  1.990824285374984e-25, -1.555782243854495e-27,  1.928541008315487e-09, -2.452138915612433e-11,  2.604924935056949e-13, -2.643436902412680e-15,
  2.987630157683713e-17, -5.265775495746623e-19,  1.528612583818407e-20, -4.925449354673558e-22,  1.398326198132273e-23, -3.220283067561055e-25,  5.504317747879737e-27,
 -4.965212163720786e-29,  8.872352786275344e-12, -1.128253164765015e-13,  1.200524409445155e-15, -1.237250441263913e-17,  1.528638559817224e-19, -3.295862396571137e-21,
  1.100399678448369e-22, -3.742532377383869e-24,  1.094518924717636e-25, -2.603062862439978e-27,  4.708846165443595e-29, -5.152697323977374e-31,  5.059485361674826e-15,
 -6.435453042443058e-17,  6.871003528929853e-19, -7.309816626801229e-21,  1.061622002411695e-22, -2.984642419476955e-24,  1.146753063170772e-25, -4.145285356163391e-27,
  1.272856272556831e-28, -3.226637010160039e-30,  6.523459302770863e-32, -9.571680919857887e-34,  3.683998996820075e-04, -4.529679442106136e-06,  4.641075368920897e-08,
 -4.435920797573862e-10,  4.072719559414718e-12, -3.573306094118542e-14,  2.738215568146101e-16, -8.511113216443792e-19, -3.782582370192347e-20,  1.381555411394269e-21,
 -3.031089501831030e-23,  4.424845465615310e-25,  7.457893916599626e-04, -9.169909928368080e-06,  9.395702317249862e-08, -8.983104212574984e-10,  8.266938949505034e-12,
 -7.359758305824785e-14,  6.119961811381185e-16, -3.887045648762570e-18, -9.577704831019112e-21,  1.098769085063768e-21, -2.732482404081240e-23,  4.152635757498350e-25,
  5.305077124213826e-04, -6.522921394330134e-06,  6.683886464170526e-08, -6.393767510164463e-10,  5.908098411228812e-12, -5.392140389805416e-14,  5.072576616032553e-16,
 -5.467976567821594e-18,  7.703111228740911e-20, -1.349065646883730e-21,  2.344818311177987e-23, -3.154716792933239e-25,  1.813041940296642e-04, -2.229259678594722e-06,
  2.284450788765934e-08, -2.187040861793505e-10,  2.033324516106986e-12, -1.923871097001760e-14,  2.106062610842791e-16, -3.272025294403167e-18,  6.999037239752480e-20,
 -1.575333378295985e-21,  3.058953061643604e-23, -4.339346923851209e-25,  3.172291182798733e-05, -3.900580279628194e-07,  3.997598055978923e-09, -3.831505958714689e-11,
  3.593258729348335e-13, -3.569689805232468e-15,  4.622650589694203e-17, -9.270448388995077e-19,  2.332772425092371e-20, -5.601627241542615e-22,  1.117212994646278e-23,
 -1.616940331821993e-25,  2.788584093847290e-06, -3.428819633867374e-08,  3.514657856649408e-10, -3.374041173478098e-12,  3.202792962423007e-14, -3.391691249989199e-16,
  5.237932173163431e-18, -1.261240108777894e-19,  3.454609052917885e-21, -8.560270904895395e-23,  1.735860481010355e-24, -2.563060003772629e-26,  1.137671724108743e-07,
 -1.398893208559231e-09,  1.434236089497429e-11, -1.380014475511215e-13,  1.332564096066499e-15, -1.533372646027535e-17,  2.833679525186539e-19, -7.812676327600943e-21,
  2.256048172813378e-22, -5.712147608911750e-24,  1.177057086227692e-25, -1.782743347517247e-27,  1.834432986259219e-09, -2.255689873758775e-11,  2.313455098887408e-13,
 -2.233637865304308e-15,  2.211736312862116e-17, -2.839475350972960e-19,  6.293032176296593e-21, -1.926724961686936e-22,  5.783466406816795e-24, -1.493799759047005e-25,
  3.140914101351266e-27, -4.931697379084914e-29,  8.439372684401217e-12, -1.037776513503118e-13,  1.064936437381833e-15, -1.034002709669909e-17,  1.065898903211373e-19,
 -1.591318005529546e-21,  4.252794514956813e-23, -1.420630535692800e-24,  4.416195932955295e-26, -1.169258867123133e-27,  2.535785187524067e-29, -4.214602689721222e-31,
  4.812541104564426e-15, -5.918345437686694e-17,  6.079980835389155e-19, -5.971623237800208e-21,  6.657249867098608e-23, -1.256239732839556e-24,  4.131207549172122e-26,
 -1.503293580995023e-27,  4.889567508589627e-29, -1.353421117413324e-30,  3.122888899142185e-32, -5.793450268344267e-34,  3.509915361532108e-04, -4.178630095544981e-06,
  4.145617568125159e-08, -3.837988430189774e-10,  3.421305767694492e-12, -2.954560441768031e-14,  2.390622614122562e-16, -1.464064903820457e-18, -5.595941117066329e-21,
  5.156595710538166e-22, -1.422494663618681e-23,  2.770130055902558e-25,  7.105478260461035e-04, -8.459230904138395e-06,  8.392483319872914e-08, -7.770541953187651e-10,
  6.933001928247960e-12, -6.022050349656774e-14,  5.035065667179123e-16, -3.738161431551351e-18,  1.434515912905271e-20,  3.298058538648193e-22, -1.231420386211018e-23,
  2.564217138920977e-25,  5.054390218169863e-04, -6.017371461426139e-06,  5.969994430172250e-08, -5.528606971673994e-10,  4.940281419509676e-12, -4.334496167365160e-14,
  3.825044815076326e-16, -3.624501642029930e-18,  4.226404273674144e-20, -6.588681878170922e-22,  1.191865253981406e-23, -2.010389878327548e-25,  1.727367902517556e-04,
 -2.056475944199635e-06,  2.040337459712229e-08, -1.890016487450603e-10,  1.692788352908567e-12, -1.507531620229920e-14,  1.432986272972193e-16, -1.738481051399553e-18,
  3.108233083500837e-20, -6.903119323541537e-22,  1.488407680636487e-23, -2.705129743178091e-25,  3.022386061434936e-05, -3.598237024311410e-07,  3.570130964586576e-09,
 -3.308423545796543e-11,  2.972909481029487e-13, -2.703264826116091e-15,  2.822739156546881e-17, -4.299244575696441e-19,  9.639687669980345e-21, -2.387670077888377e-22,
  5.363409977981185e-24, -9.933531246399816e-26,  2.656810002548395e-06, -3.163018875592690e-08,  3.138474356343790e-10, -2.910039230304681e-12,  2.626965525653336e-14,
 -2.457646604274430e-16,  2.874386165068430e-18, -5.352817783389036e-20,  1.375821466862739e-21, -3.592478448490512e-23,  8.238143644645358e-25, -1.546303587005961e-26,
  1.083910728527273e-07, -1.290437157225217e-09,  1.280517375123116e-11, -1.188261492551237e-13,  1.079695235446347e-15, -1.050326954227663e-17,  1.404183281190629e-19,
 -3.116207311096972e-21,  8.766955091440774e-23, -2.365219115585532e-24,  5.509326740834161e-26, -1.049064616476696e-27,  1.747745144669313e-09, -2.080771941451681e-11,
  2.065000695017923e-13, -1.918499452825025e-15,  1.760159269995060e-17, -1.809401186758193e-19,  2.830845981295168e-21, -7.327216340449039e-23,  2.200778695489266e-24,
 -6.089029330614731e-26,  1.441538553456984e-27, -2.797921005973877e-29,  8.040553345529044e-12, -9.572760422331232e-14,  9.501871114633114e-16, -8.844830756811117e-18,
  8.243128890479458e-20, -9.210159942872772e-22,  1.741024687118912e-23, -5.178263515181010e-25,  1.640776018877657e-26, -4.655889089676279e-28,  1.126925099174483e-29,
 -2.253888758673018e-31,  4.585104826915357e-15, -5.458961929439783e-17,  5.420423977043757e-19, -5.065222008516059e-21,  4.870360442321074e-23, -6.305691023733065e-25,
  1.526117007628878e-26, -5.207778201850839e-28,  1.744514941799589e-29, -5.138454584684381e-31,  1.296745438773946e-32, -2.754074636620748e-34  };
  int offset = -10;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 10;
    if (std::isnan(t)) {
      fill_n(rr+offset, 10, 0.5);
      fill_n(ww+offset, 10, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 10; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=10; ++j) {
        const int boxof = it*120+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
