//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _hrr_c0_66.cc
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <src/integral/hrrlist.h>
#include <array>
#include <algorithm>

using namespace std;
using namespace bagel;

void HRRList::perform_HRR_c0_66(const int nloop, const double* data_start, const array<double,3>& AB, double* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 399];
    auto current_out = &data_out[c * 784];
   {
     //current index a: xxxxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[28];
      const auto ay_0 = current_data[29];
      const auto az_0 = current_data[36];
      const auto axx_0 = current_data[64];
      const auto axy_0 = current_data[65];
      const auto ayy_0 = current_data[66];
      const auto axz_0 = current_data[73];
      const auto ayz_0 = current_data[74];
      const auto azz_0 = current_data[81];
      const auto axxx_0 = current_data[109];
      const auto axxy_0 = current_data[110];
      const auto axyy_0 = current_data[111];
      const auto ayyy_0 = current_data[112];
      const auto axxz_0 = current_data[119];
      const auto axyz_0 = current_data[120];
      const auto ayyz_0 = current_data[121];
      const auto axzz_0 = current_data[128];
      const auto ayzz_0 = current_data[129];
      const auto azzz_0 = current_data[136];
      const auto axxxx_0 = current_data[164];
      const auto axxxy_0 = current_data[165];
      const auto axxyy_0 = current_data[166];
      const auto axyyy_0 = current_data[167];
      const auto ayyyy_0 = current_data[168];
      const auto axxxz_0 = current_data[175];
      const auto axxyz_0 = current_data[176];
      const auto axyyz_0 = current_data[177];
      const auto ayyyz_0 = current_data[178];
      const auto axxzz_0 = current_data[185];
      const auto axyzz_0 = current_data[186];
      const auto ayyzz_0 = current_data[187];
      const auto axzzz_0 = current_data[194];
      const auto ayzzz_0 = current_data[195];
      const auto azzzz_0 = current_data[202];
      const auto axxxxx_0 = current_data[230];
      const auto axxxxy_0 = current_data[231];
      const auto axxxyy_0 = current_data[232];
      const auto axxyyy_0 = current_data[233];
      const auto axyyyy_0 = current_data[234];
      const auto ayyyyy_0 = current_data[235];
      const auto axxxxz_0 = current_data[242];
      const auto axxxyz_0 = current_data[243];
      const auto axxyyz_0 = current_data[244];
      const auto axyyyz_0 = current_data[245];
      const auto ayyyyz_0 = current_data[246];
      const auto axxxzz_0 = current_data[253];
      const auto axxyzz_0 = current_data[254];
      const auto axyyzz_0 = current_data[255];
      const auto ayyyzz_0 = current_data[256];
      const auto axxzzz_0 = current_data[263];
      const auto axyzzz_0 = current_data[264];
      const auto ayyzzz_0 = current_data[265];
      const auto axzzzz_0 = current_data[272];
      const auto ayzzzz_0 = current_data[273];
      const auto azzzzz_0 = current_data[280];
      const auto axxxxxx_0 = current_data[308];
      const auto axxxxxy_0 = current_data[309];
      const auto axxxxyy_0 = current_data[310];
      const auto axxxyyy_0 = current_data[311];
      const auto axxyyyy_0 = current_data[312];
      const auto axyyyyy_0 = current_data[313];
      const auto ayyyyyy_0 = current_data[314];
      const auto axxxxxz_0 = current_data[321];
      const auto axxxxyz_0 = current_data[322];
      const auto axxxyyz_0 = current_data[323];
      const auto axxyyyz_0 = current_data[324];
      const auto axyyyyz_0 = current_data[325];
      const auto ayyyyyz_0 = current_data[326];
      const auto axxxxzz_0 = current_data[333];
      const auto axxxyzz_0 = current_data[334];
      const auto axxyyzz_0 = current_data[335];
      const auto axyyyzz_0 = current_data[336];
      const auto ayyyyzz_0 = current_data[337];
      const auto axxxzzz_0 = current_data[344];
      const auto axxyzzz_0 = current_data[345];
      const auto axyyzzz_0 = current_data[346];
      const auto ayyyzzz_0 = current_data[347];
      const auto axxzzzz_0 = current_data[354];
      const auto axyzzzz_0 = current_data[355];
      const auto ayyzzzz_0 = current_data[356];
      const auto axzzzzz_0 = current_data[363];
      const auto ayzzzzz_0 = current_data[364];
      const auto azzzzzz_0 = current_data[371];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[0] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[1] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[2] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[3] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[4] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[5] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[6] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[7] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[8] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[9] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[10] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[11] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[12] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[13] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[14] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[15] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[16] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[17] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[18] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[19] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[20] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[21] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[22] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[23] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[24] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[25] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[26] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[27] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[29];
      const auto ay_0 = current_data[30];
      const auto az_0 = current_data[37];
      const auto axx_0 = current_data[65];
      const auto axy_0 = current_data[66];
      const auto ayy_0 = current_data[67];
      const auto axz_0 = current_data[74];
      const auto ayz_0 = current_data[75];
      const auto azz_0 = current_data[82];
      const auto axxx_0 = current_data[110];
      const auto axxy_0 = current_data[111];
      const auto axyy_0 = current_data[112];
      const auto ayyy_0 = current_data[113];
      const auto axxz_0 = current_data[120];
      const auto axyz_0 = current_data[121];
      const auto ayyz_0 = current_data[122];
      const auto axzz_0 = current_data[129];
      const auto ayzz_0 = current_data[130];
      const auto azzz_0 = current_data[137];
      const auto axxxx_0 = current_data[165];
      const auto axxxy_0 = current_data[166];
      const auto axxyy_0 = current_data[167];
      const auto axyyy_0 = current_data[168];
      const auto ayyyy_0 = current_data[169];
      const auto axxxz_0 = current_data[176];
      const auto axxyz_0 = current_data[177];
      const auto axyyz_0 = current_data[178];
      const auto ayyyz_0 = current_data[179];
      const auto axxzz_0 = current_data[186];
      const auto axyzz_0 = current_data[187];
      const auto ayyzz_0 = current_data[188];
      const auto axzzz_0 = current_data[195];
      const auto ayzzz_0 = current_data[196];
      const auto azzzz_0 = current_data[203];
      const auto axxxxx_0 = current_data[231];
      const auto axxxxy_0 = current_data[232];
      const auto axxxyy_0 = current_data[233];
      const auto axxyyy_0 = current_data[234];
      const auto axyyyy_0 = current_data[235];
      const auto ayyyyy_0 = current_data[236];
      const auto axxxxz_0 = current_data[243];
      const auto axxxyz_0 = current_data[244];
      const auto axxyyz_0 = current_data[245];
      const auto axyyyz_0 = current_data[246];
      const auto ayyyyz_0 = current_data[247];
      const auto axxxzz_0 = current_data[254];
      const auto axxyzz_0 = current_data[255];
      const auto axyyzz_0 = current_data[256];
      const auto ayyyzz_0 = current_data[257];
      const auto axxzzz_0 = current_data[264];
      const auto axyzzz_0 = current_data[265];
      const auto ayyzzz_0 = current_data[266];
      const auto axzzzz_0 = current_data[273];
      const auto ayzzzz_0 = current_data[274];
      const auto azzzzz_0 = current_data[281];
      const auto axxxxxx_0 = current_data[309];
      const auto axxxxxy_0 = current_data[310];
      const auto axxxxyy_0 = current_data[311];
      const auto axxxyyy_0 = current_data[312];
      const auto axxyyyy_0 = current_data[313];
      const auto axyyyyy_0 = current_data[314];
      const auto ayyyyyy_0 = current_data[315];
      const auto axxxxxz_0 = current_data[322];
      const auto axxxxyz_0 = current_data[323];
      const auto axxxyyz_0 = current_data[324];
      const auto axxyyyz_0 = current_data[325];
      const auto axyyyyz_0 = current_data[326];
      const auto ayyyyyz_0 = current_data[327];
      const auto axxxxzz_0 = current_data[334];
      const auto axxxyzz_0 = current_data[335];
      const auto axxyyzz_0 = current_data[336];
      const auto axyyyzz_0 = current_data[337];
      const auto ayyyyzz_0 = current_data[338];
      const auto axxxzzz_0 = current_data[345];
      const auto axxyzzz_0 = current_data[346];
      const auto axyyzzz_0 = current_data[347];
      const auto ayyyzzz_0 = current_data[348];
      const auto axxzzzz_0 = current_data[355];
      const auto axyzzzz_0 = current_data[356];
      const auto ayyzzzz_0 = current_data[357];
      const auto axzzzzz_0 = current_data[364];
      const auto ayzzzzz_0 = current_data[365];
      const auto azzzzzz_0 = current_data[372];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[28] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[29] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[30] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[31] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[32] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[33] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[34] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[35] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[36] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[37] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[38] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[39] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[40] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[41] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[42] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[43] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[44] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[45] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[46] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[47] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[48] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[49] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[50] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[51] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[52] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[53] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[54] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[55] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[30];
      const auto ay_0 = current_data[31];
      const auto az_0 = current_data[38];
      const auto axx_0 = current_data[66];
      const auto axy_0 = current_data[67];
      const auto ayy_0 = current_data[68];
      const auto axz_0 = current_data[75];
      const auto ayz_0 = current_data[76];
      const auto azz_0 = current_data[83];
      const auto axxx_0 = current_data[111];
      const auto axxy_0 = current_data[112];
      const auto axyy_0 = current_data[113];
      const auto ayyy_0 = current_data[114];
      const auto axxz_0 = current_data[121];
      const auto axyz_0 = current_data[122];
      const auto ayyz_0 = current_data[123];
      const auto axzz_0 = current_data[130];
      const auto ayzz_0 = current_data[131];
      const auto azzz_0 = current_data[138];
      const auto axxxx_0 = current_data[166];
      const auto axxxy_0 = current_data[167];
      const auto axxyy_0 = current_data[168];
      const auto axyyy_0 = current_data[169];
      const auto ayyyy_0 = current_data[170];
      const auto axxxz_0 = current_data[177];
      const auto axxyz_0 = current_data[178];
      const auto axyyz_0 = current_data[179];
      const auto ayyyz_0 = current_data[180];
      const auto axxzz_0 = current_data[187];
      const auto axyzz_0 = current_data[188];
      const auto ayyzz_0 = current_data[189];
      const auto axzzz_0 = current_data[196];
      const auto ayzzz_0 = current_data[197];
      const auto azzzz_0 = current_data[204];
      const auto axxxxx_0 = current_data[232];
      const auto axxxxy_0 = current_data[233];
      const auto axxxyy_0 = current_data[234];
      const auto axxyyy_0 = current_data[235];
      const auto axyyyy_0 = current_data[236];
      const auto ayyyyy_0 = current_data[237];
      const auto axxxxz_0 = current_data[244];
      const auto axxxyz_0 = current_data[245];
      const auto axxyyz_0 = current_data[246];
      const auto axyyyz_0 = current_data[247];
      const auto ayyyyz_0 = current_data[248];
      const auto axxxzz_0 = current_data[255];
      const auto axxyzz_0 = current_data[256];
      const auto axyyzz_0 = current_data[257];
      const auto ayyyzz_0 = current_data[258];
      const auto axxzzz_0 = current_data[265];
      const auto axyzzz_0 = current_data[266];
      const auto ayyzzz_0 = current_data[267];
      const auto axzzzz_0 = current_data[274];
      const auto ayzzzz_0 = current_data[275];
      const auto azzzzz_0 = current_data[282];
      const auto axxxxxx_0 = current_data[310];
      const auto axxxxxy_0 = current_data[311];
      const auto axxxxyy_0 = current_data[312];
      const auto axxxyyy_0 = current_data[313];
      const auto axxyyyy_0 = current_data[314];
      const auto axyyyyy_0 = current_data[315];
      const auto ayyyyyy_0 = current_data[316];
      const auto axxxxxz_0 = current_data[323];
      const auto axxxxyz_0 = current_data[324];
      const auto axxxyyz_0 = current_data[325];
      const auto axxyyyz_0 = current_data[326];
      const auto axyyyyz_0 = current_data[327];
      const auto ayyyyyz_0 = current_data[328];
      const auto axxxxzz_0 = current_data[335];
      const auto axxxyzz_0 = current_data[336];
      const auto axxyyzz_0 = current_data[337];
      const auto axyyyzz_0 = current_data[338];
      const auto ayyyyzz_0 = current_data[339];
      const auto axxxzzz_0 = current_data[346];
      const auto axxyzzz_0 = current_data[347];
      const auto axyyzzz_0 = current_data[348];
      const auto ayyyzzz_0 = current_data[349];
      const auto axxzzzz_0 = current_data[356];
      const auto axyzzzz_0 = current_data[357];
      const auto ayyzzzz_0 = current_data[358];
      const auto axzzzzz_0 = current_data[365];
      const auto ayzzzzz_0 = current_data[366];
      const auto azzzzzz_0 = current_data[373];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[56] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[57] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[58] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[59] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[60] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[61] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[62] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[63] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[64] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[65] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[66] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[67] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[68] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[69] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[70] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[71] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[72] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[73] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[74] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[75] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[76] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[77] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[78] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[79] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[80] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[81] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[82] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[83] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[31];
      const auto ay_0 = current_data[32];
      const auto az_0 = current_data[39];
      const auto axx_0 = current_data[67];
      const auto axy_0 = current_data[68];
      const auto ayy_0 = current_data[69];
      const auto axz_0 = current_data[76];
      const auto ayz_0 = current_data[77];
      const auto azz_0 = current_data[84];
      const auto axxx_0 = current_data[112];
      const auto axxy_0 = current_data[113];
      const auto axyy_0 = current_data[114];
      const auto ayyy_0 = current_data[115];
      const auto axxz_0 = current_data[122];
      const auto axyz_0 = current_data[123];
      const auto ayyz_0 = current_data[124];
      const auto axzz_0 = current_data[131];
      const auto ayzz_0 = current_data[132];
      const auto azzz_0 = current_data[139];
      const auto axxxx_0 = current_data[167];
      const auto axxxy_0 = current_data[168];
      const auto axxyy_0 = current_data[169];
      const auto axyyy_0 = current_data[170];
      const auto ayyyy_0 = current_data[171];
      const auto axxxz_0 = current_data[178];
      const auto axxyz_0 = current_data[179];
      const auto axyyz_0 = current_data[180];
      const auto ayyyz_0 = current_data[181];
      const auto axxzz_0 = current_data[188];
      const auto axyzz_0 = current_data[189];
      const auto ayyzz_0 = current_data[190];
      const auto axzzz_0 = current_data[197];
      const auto ayzzz_0 = current_data[198];
      const auto azzzz_0 = current_data[205];
      const auto axxxxx_0 = current_data[233];
      const auto axxxxy_0 = current_data[234];
      const auto axxxyy_0 = current_data[235];
      const auto axxyyy_0 = current_data[236];
      const auto axyyyy_0 = current_data[237];
      const auto ayyyyy_0 = current_data[238];
      const auto axxxxz_0 = current_data[245];
      const auto axxxyz_0 = current_data[246];
      const auto axxyyz_0 = current_data[247];
      const auto axyyyz_0 = current_data[248];
      const auto ayyyyz_0 = current_data[249];
      const auto axxxzz_0 = current_data[256];
      const auto axxyzz_0 = current_data[257];
      const auto axyyzz_0 = current_data[258];
      const auto ayyyzz_0 = current_data[259];
      const auto axxzzz_0 = current_data[266];
      const auto axyzzz_0 = current_data[267];
      const auto ayyzzz_0 = current_data[268];
      const auto axzzzz_0 = current_data[275];
      const auto ayzzzz_0 = current_data[276];
      const auto azzzzz_0 = current_data[283];
      const auto axxxxxx_0 = current_data[311];
      const auto axxxxxy_0 = current_data[312];
      const auto axxxxyy_0 = current_data[313];
      const auto axxxyyy_0 = current_data[314];
      const auto axxyyyy_0 = current_data[315];
      const auto axyyyyy_0 = current_data[316];
      const auto ayyyyyy_0 = current_data[317];
      const auto axxxxxz_0 = current_data[324];
      const auto axxxxyz_0 = current_data[325];
      const auto axxxyyz_0 = current_data[326];
      const auto axxyyyz_0 = current_data[327];
      const auto axyyyyz_0 = current_data[328];
      const auto ayyyyyz_0 = current_data[329];
      const auto axxxxzz_0 = current_data[336];
      const auto axxxyzz_0 = current_data[337];
      const auto axxyyzz_0 = current_data[338];
      const auto axyyyzz_0 = current_data[339];
      const auto ayyyyzz_0 = current_data[340];
      const auto axxxzzz_0 = current_data[347];
      const auto axxyzzz_0 = current_data[348];
      const auto axyyzzz_0 = current_data[349];
      const auto ayyyzzz_0 = current_data[350];
      const auto axxzzzz_0 = current_data[357];
      const auto axyzzzz_0 = current_data[358];
      const auto ayyzzzz_0 = current_data[359];
      const auto axzzzzz_0 = current_data[366];
      const auto ayzzzzz_0 = current_data[367];
      const auto azzzzzz_0 = current_data[374];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[84] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[85] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[86] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[87] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[88] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[89] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[90] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[91] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[92] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[93] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[94] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[95] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[96] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[97] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[98] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[99] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[100] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[101] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[102] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[103] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[104] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[105] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[106] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[107] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[108] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[109] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[110] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[111] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[32];
      const auto ay_0 = current_data[33];
      const auto az_0 = current_data[40];
      const auto axx_0 = current_data[68];
      const auto axy_0 = current_data[69];
      const auto ayy_0 = current_data[70];
      const auto axz_0 = current_data[77];
      const auto ayz_0 = current_data[78];
      const auto azz_0 = current_data[85];
      const auto axxx_0 = current_data[113];
      const auto axxy_0 = current_data[114];
      const auto axyy_0 = current_data[115];
      const auto ayyy_0 = current_data[116];
      const auto axxz_0 = current_data[123];
      const auto axyz_0 = current_data[124];
      const auto ayyz_0 = current_data[125];
      const auto axzz_0 = current_data[132];
      const auto ayzz_0 = current_data[133];
      const auto azzz_0 = current_data[140];
      const auto axxxx_0 = current_data[168];
      const auto axxxy_0 = current_data[169];
      const auto axxyy_0 = current_data[170];
      const auto axyyy_0 = current_data[171];
      const auto ayyyy_0 = current_data[172];
      const auto axxxz_0 = current_data[179];
      const auto axxyz_0 = current_data[180];
      const auto axyyz_0 = current_data[181];
      const auto ayyyz_0 = current_data[182];
      const auto axxzz_0 = current_data[189];
      const auto axyzz_0 = current_data[190];
      const auto ayyzz_0 = current_data[191];
      const auto axzzz_0 = current_data[198];
      const auto ayzzz_0 = current_data[199];
      const auto azzzz_0 = current_data[206];
      const auto axxxxx_0 = current_data[234];
      const auto axxxxy_0 = current_data[235];
      const auto axxxyy_0 = current_data[236];
      const auto axxyyy_0 = current_data[237];
      const auto axyyyy_0 = current_data[238];
      const auto ayyyyy_0 = current_data[239];
      const auto axxxxz_0 = current_data[246];
      const auto axxxyz_0 = current_data[247];
      const auto axxyyz_0 = current_data[248];
      const auto axyyyz_0 = current_data[249];
      const auto ayyyyz_0 = current_data[250];
      const auto axxxzz_0 = current_data[257];
      const auto axxyzz_0 = current_data[258];
      const auto axyyzz_0 = current_data[259];
      const auto ayyyzz_0 = current_data[260];
      const auto axxzzz_0 = current_data[267];
      const auto axyzzz_0 = current_data[268];
      const auto ayyzzz_0 = current_data[269];
      const auto axzzzz_0 = current_data[276];
      const auto ayzzzz_0 = current_data[277];
      const auto azzzzz_0 = current_data[284];
      const auto axxxxxx_0 = current_data[312];
      const auto axxxxxy_0 = current_data[313];
      const auto axxxxyy_0 = current_data[314];
      const auto axxxyyy_0 = current_data[315];
      const auto axxyyyy_0 = current_data[316];
      const auto axyyyyy_0 = current_data[317];
      const auto ayyyyyy_0 = current_data[318];
      const auto axxxxxz_0 = current_data[325];
      const auto axxxxyz_0 = current_data[326];
      const auto axxxyyz_0 = current_data[327];
      const auto axxyyyz_0 = current_data[328];
      const auto axyyyyz_0 = current_data[329];
      const auto ayyyyyz_0 = current_data[330];
      const auto axxxxzz_0 = current_data[337];
      const auto axxxyzz_0 = current_data[338];
      const auto axxyyzz_0 = current_data[339];
      const auto axyyyzz_0 = current_data[340];
      const auto ayyyyzz_0 = current_data[341];
      const auto axxxzzz_0 = current_data[348];
      const auto axxyzzz_0 = current_data[349];
      const auto axyyzzz_0 = current_data[350];
      const auto ayyyzzz_0 = current_data[351];
      const auto axxzzzz_0 = current_data[358];
      const auto axyzzzz_0 = current_data[359];
      const auto ayyzzzz_0 = current_data[360];
      const auto axzzzzz_0 = current_data[367];
      const auto ayzzzzz_0 = current_data[368];
      const auto azzzzzz_0 = current_data[375];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[112] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[113] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[114] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[115] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[116] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[117] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[118] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[119] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[120] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[121] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[122] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[123] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[124] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[125] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[126] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[127] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[128] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[129] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[130] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[131] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[132] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[133] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[134] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[135] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[136] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[137] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[138] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[139] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyyyy
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[33];
      const auto ay_0 = current_data[34];
      const auto az_0 = current_data[41];
      const auto axx_0 = current_data[69];
      const auto axy_0 = current_data[70];
      const auto ayy_0 = current_data[71];
      const auto axz_0 = current_data[78];
      const auto ayz_0 = current_data[79];
      const auto azz_0 = current_data[86];
      const auto axxx_0 = current_data[114];
      const auto axxy_0 = current_data[115];
      const auto axyy_0 = current_data[116];
      const auto ayyy_0 = current_data[117];
      const auto axxz_0 = current_data[124];
      const auto axyz_0 = current_data[125];
      const auto ayyz_0 = current_data[126];
      const auto axzz_0 = current_data[133];
      const auto ayzz_0 = current_data[134];
      const auto azzz_0 = current_data[141];
      const auto axxxx_0 = current_data[169];
      const auto axxxy_0 = current_data[170];
      const auto axxyy_0 = current_data[171];
      const auto axyyy_0 = current_data[172];
      const auto ayyyy_0 = current_data[173];
      const auto axxxz_0 = current_data[180];
      const auto axxyz_0 = current_data[181];
      const auto axyyz_0 = current_data[182];
      const auto ayyyz_0 = current_data[183];
      const auto axxzz_0 = current_data[190];
      const auto axyzz_0 = current_data[191];
      const auto ayyzz_0 = current_data[192];
      const auto axzzz_0 = current_data[199];
      const auto ayzzz_0 = current_data[200];
      const auto azzzz_0 = current_data[207];
      const auto axxxxx_0 = current_data[235];
      const auto axxxxy_0 = current_data[236];
      const auto axxxyy_0 = current_data[237];
      const auto axxyyy_0 = current_data[238];
      const auto axyyyy_0 = current_data[239];
      const auto ayyyyy_0 = current_data[240];
      const auto axxxxz_0 = current_data[247];
      const auto axxxyz_0 = current_data[248];
      const auto axxyyz_0 = current_data[249];
      const auto axyyyz_0 = current_data[250];
      const auto ayyyyz_0 = current_data[251];
      const auto axxxzz_0 = current_data[258];
      const auto axxyzz_0 = current_data[259];
      const auto axyyzz_0 = current_data[260];
      const auto ayyyzz_0 = current_data[261];
      const auto axxzzz_0 = current_data[268];
      const auto axyzzz_0 = current_data[269];
      const auto ayyzzz_0 = current_data[270];
      const auto axzzzz_0 = current_data[277];
      const auto ayzzzz_0 = current_data[278];
      const auto azzzzz_0 = current_data[285];
      const auto axxxxxx_0 = current_data[313];
      const auto axxxxxy_0 = current_data[314];
      const auto axxxxyy_0 = current_data[315];
      const auto axxxyyy_0 = current_data[316];
      const auto axxyyyy_0 = current_data[317];
      const auto axyyyyy_0 = current_data[318];
      const auto ayyyyyy_0 = current_data[319];
      const auto axxxxxz_0 = current_data[326];
      const auto axxxxyz_0 = current_data[327];
      const auto axxxyyz_0 = current_data[328];
      const auto axxyyyz_0 = current_data[329];
      const auto axyyyyz_0 = current_data[330];
      const auto ayyyyyz_0 = current_data[331];
      const auto axxxxzz_0 = current_data[338];
      const auto axxxyzz_0 = current_data[339];
      const auto axxyyzz_0 = current_data[340];
      const auto axyyyzz_0 = current_data[341];
      const auto ayyyyzz_0 = current_data[342];
      const auto axxxzzz_0 = current_data[349];
      const auto axxyzzz_0 = current_data[350];
      const auto axyyzzz_0 = current_data[351];
      const auto ayyyzzz_0 = current_data[352];
      const auto axxzzzz_0 = current_data[359];
      const auto axyzzzz_0 = current_data[360];
      const auto ayyzzzz_0 = current_data[361];
      const auto axzzzzz_0 = current_data[368];
      const auto ayzzzzz_0 = current_data[369];
      const auto azzzzzz_0 = current_data[376];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[140] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[141] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[142] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[143] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[144] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[145] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[146] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[147] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[148] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[149] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[150] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[151] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[152] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[153] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[154] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[155] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[156] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[157] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[158] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[159] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[160] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[161] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[162] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[163] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[164] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[165] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[166] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[167] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyyyy
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[34];
      const auto ay_0 = current_data[35];
      const auto az_0 = current_data[42];
      const auto axx_0 = current_data[70];
      const auto axy_0 = current_data[71];
      const auto ayy_0 = current_data[72];
      const auto axz_0 = current_data[79];
      const auto ayz_0 = current_data[80];
      const auto azz_0 = current_data[87];
      const auto axxx_0 = current_data[115];
      const auto axxy_0 = current_data[116];
      const auto axyy_0 = current_data[117];
      const auto ayyy_0 = current_data[118];
      const auto axxz_0 = current_data[125];
      const auto axyz_0 = current_data[126];
      const auto ayyz_0 = current_data[127];
      const auto axzz_0 = current_data[134];
      const auto ayzz_0 = current_data[135];
      const auto azzz_0 = current_data[142];
      const auto axxxx_0 = current_data[170];
      const auto axxxy_0 = current_data[171];
      const auto axxyy_0 = current_data[172];
      const auto axyyy_0 = current_data[173];
      const auto ayyyy_0 = current_data[174];
      const auto axxxz_0 = current_data[181];
      const auto axxyz_0 = current_data[182];
      const auto axyyz_0 = current_data[183];
      const auto ayyyz_0 = current_data[184];
      const auto axxzz_0 = current_data[191];
      const auto axyzz_0 = current_data[192];
      const auto ayyzz_0 = current_data[193];
      const auto axzzz_0 = current_data[200];
      const auto ayzzz_0 = current_data[201];
      const auto azzzz_0 = current_data[208];
      const auto axxxxx_0 = current_data[236];
      const auto axxxxy_0 = current_data[237];
      const auto axxxyy_0 = current_data[238];
      const auto axxyyy_0 = current_data[239];
      const auto axyyyy_0 = current_data[240];
      const auto ayyyyy_0 = current_data[241];
      const auto axxxxz_0 = current_data[248];
      const auto axxxyz_0 = current_data[249];
      const auto axxyyz_0 = current_data[250];
      const auto axyyyz_0 = current_data[251];
      const auto ayyyyz_0 = current_data[252];
      const auto axxxzz_0 = current_data[259];
      const auto axxyzz_0 = current_data[260];
      const auto axyyzz_0 = current_data[261];
      const auto ayyyzz_0 = current_data[262];
      const auto axxzzz_0 = current_data[269];
      const auto axyzzz_0 = current_data[270];
      const auto ayyzzz_0 = current_data[271];
      const auto axzzzz_0 = current_data[278];
      const auto ayzzzz_0 = current_data[279];
      const auto azzzzz_0 = current_data[286];
      const auto axxxxxx_0 = current_data[314];
      const auto axxxxxy_0 = current_data[315];
      const auto axxxxyy_0 = current_data[316];
      const auto axxxyyy_0 = current_data[317];
      const auto axxyyyy_0 = current_data[318];
      const auto axyyyyy_0 = current_data[319];
      const auto ayyyyyy_0 = current_data[320];
      const auto axxxxxz_0 = current_data[327];
      const auto axxxxyz_0 = current_data[328];
      const auto axxxyyz_0 = current_data[329];
      const auto axxyyyz_0 = current_data[330];
      const auto axyyyyz_0 = current_data[331];
      const auto ayyyyyz_0 = current_data[332];
      const auto axxxxzz_0 = current_data[339];
      const auto axxxyzz_0 = current_data[340];
      const auto axxyyzz_0 = current_data[341];
      const auto axyyyzz_0 = current_data[342];
      const auto ayyyyzz_0 = current_data[343];
      const auto axxxzzz_0 = current_data[350];
      const auto axxyzzz_0 = current_data[351];
      const auto axyyzzz_0 = current_data[352];
      const auto ayyyzzz_0 = current_data[353];
      const auto axxzzzz_0 = current_data[360];
      const auto axyzzzz_0 = current_data[361];
      const auto ayyzzzz_0 = current_data[362];
      const auto axzzzzz_0 = current_data[369];
      const auto ayzzzzz_0 = current_data[370];
      const auto azzzzzz_0 = current_data[377];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[168] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[169] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[170] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[171] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[172] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[173] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[174] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[175] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[176] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[177] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[178] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[179] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[180] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[181] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[182] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[183] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[184] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[185] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[186] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[187] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[188] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[189] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[190] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[191] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[192] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[193] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[194] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[195] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxz
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[36];
      const auto ay_0 = current_data[37];
      const auto az_0 = current_data[43];
      const auto axx_0 = current_data[73];
      const auto axy_0 = current_data[74];
      const auto ayy_0 = current_data[75];
      const auto axz_0 = current_data[81];
      const auto ayz_0 = current_data[82];
      const auto azz_0 = current_data[88];
      const auto axxx_0 = current_data[119];
      const auto axxy_0 = current_data[120];
      const auto axyy_0 = current_data[121];
      const auto ayyy_0 = current_data[122];
      const auto axxz_0 = current_data[128];
      const auto axyz_0 = current_data[129];
      const auto ayyz_0 = current_data[130];
      const auto axzz_0 = current_data[136];
      const auto ayzz_0 = current_data[137];
      const auto azzz_0 = current_data[143];
      const auto axxxx_0 = current_data[175];
      const auto axxxy_0 = current_data[176];
      const auto axxyy_0 = current_data[177];
      const auto axyyy_0 = current_data[178];
      const auto ayyyy_0 = current_data[179];
      const auto axxxz_0 = current_data[185];
      const auto axxyz_0 = current_data[186];
      const auto axyyz_0 = current_data[187];
      const auto ayyyz_0 = current_data[188];
      const auto axxzz_0 = current_data[194];
      const auto axyzz_0 = current_data[195];
      const auto ayyzz_0 = current_data[196];
      const auto axzzz_0 = current_data[202];
      const auto ayzzz_0 = current_data[203];
      const auto azzzz_0 = current_data[209];
      const auto axxxxx_0 = current_data[242];
      const auto axxxxy_0 = current_data[243];
      const auto axxxyy_0 = current_data[244];
      const auto axxyyy_0 = current_data[245];
      const auto axyyyy_0 = current_data[246];
      const auto ayyyyy_0 = current_data[247];
      const auto axxxxz_0 = current_data[253];
      const auto axxxyz_0 = current_data[254];
      const auto axxyyz_0 = current_data[255];
      const auto axyyyz_0 = current_data[256];
      const auto ayyyyz_0 = current_data[257];
      const auto axxxzz_0 = current_data[263];
      const auto axxyzz_0 = current_data[264];
      const auto axyyzz_0 = current_data[265];
      const auto ayyyzz_0 = current_data[266];
      const auto axxzzz_0 = current_data[272];
      const auto axyzzz_0 = current_data[273];
      const auto ayyzzz_0 = current_data[274];
      const auto axzzzz_0 = current_data[280];
      const auto ayzzzz_0 = current_data[281];
      const auto azzzzz_0 = current_data[287];
      const auto axxxxxx_0 = current_data[321];
      const auto axxxxxy_0 = current_data[322];
      const auto axxxxyy_0 = current_data[323];
      const auto axxxyyy_0 = current_data[324];
      const auto axxyyyy_0 = current_data[325];
      const auto axyyyyy_0 = current_data[326];
      const auto ayyyyyy_0 = current_data[327];
      const auto axxxxxz_0 = current_data[333];
      const auto axxxxyz_0 = current_data[334];
      const auto axxxyyz_0 = current_data[335];
      const auto axxyyyz_0 = current_data[336];
      const auto axyyyyz_0 = current_data[337];
      const auto ayyyyyz_0 = current_data[338];
      const auto axxxxzz_0 = current_data[344];
      const auto axxxyzz_0 = current_data[345];
      const auto axxyyzz_0 = current_data[346];
      const auto axyyyzz_0 = current_data[347];
      const auto ayyyyzz_0 = current_data[348];
      const auto axxxzzz_0 = current_data[354];
      const auto axxyzzz_0 = current_data[355];
      const auto axyyzzz_0 = current_data[356];
      const auto ayyyzzz_0 = current_data[357];
      const auto axxzzzz_0 = current_data[363];
      const auto axyzzzz_0 = current_data[364];
      const auto ayyzzzz_0 = current_data[365];
      const auto axzzzzz_0 = current_data[371];
      const auto ayzzzzz_0 = current_data[372];
      const auto azzzzzz_0 = current_data[378];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[196] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[197] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[198] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[199] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[200] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[201] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[202] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[203] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[204] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[205] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[206] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[207] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[208] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[209] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[210] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[211] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[212] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[213] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[214] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[215] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[216] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[217] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[218] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[219] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[220] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[221] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[222] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[223] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxyz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[37];
      const auto ay_0 = current_data[38];
      const auto az_0 = current_data[44];
      const auto axx_0 = current_data[74];
      const auto axy_0 = current_data[75];
      const auto ayy_0 = current_data[76];
      const auto axz_0 = current_data[82];
      const auto ayz_0 = current_data[83];
      const auto azz_0 = current_data[89];
      const auto axxx_0 = current_data[120];
      const auto axxy_0 = current_data[121];
      const auto axyy_0 = current_data[122];
      const auto ayyy_0 = current_data[123];
      const auto axxz_0 = current_data[129];
      const auto axyz_0 = current_data[130];
      const auto ayyz_0 = current_data[131];
      const auto axzz_0 = current_data[137];
      const auto ayzz_0 = current_data[138];
      const auto azzz_0 = current_data[144];
      const auto axxxx_0 = current_data[176];
      const auto axxxy_0 = current_data[177];
      const auto axxyy_0 = current_data[178];
      const auto axyyy_0 = current_data[179];
      const auto ayyyy_0 = current_data[180];
      const auto axxxz_0 = current_data[186];
      const auto axxyz_0 = current_data[187];
      const auto axyyz_0 = current_data[188];
      const auto ayyyz_0 = current_data[189];
      const auto axxzz_0 = current_data[195];
      const auto axyzz_0 = current_data[196];
      const auto ayyzz_0 = current_data[197];
      const auto axzzz_0 = current_data[203];
      const auto ayzzz_0 = current_data[204];
      const auto azzzz_0 = current_data[210];
      const auto axxxxx_0 = current_data[243];
      const auto axxxxy_0 = current_data[244];
      const auto axxxyy_0 = current_data[245];
      const auto axxyyy_0 = current_data[246];
      const auto axyyyy_0 = current_data[247];
      const auto ayyyyy_0 = current_data[248];
      const auto axxxxz_0 = current_data[254];
      const auto axxxyz_0 = current_data[255];
      const auto axxyyz_0 = current_data[256];
      const auto axyyyz_0 = current_data[257];
      const auto ayyyyz_0 = current_data[258];
      const auto axxxzz_0 = current_data[264];
      const auto axxyzz_0 = current_data[265];
      const auto axyyzz_0 = current_data[266];
      const auto ayyyzz_0 = current_data[267];
      const auto axxzzz_0 = current_data[273];
      const auto axyzzz_0 = current_data[274];
      const auto ayyzzz_0 = current_data[275];
      const auto axzzzz_0 = current_data[281];
      const auto ayzzzz_0 = current_data[282];
      const auto azzzzz_0 = current_data[288];
      const auto axxxxxx_0 = current_data[322];
      const auto axxxxxy_0 = current_data[323];
      const auto axxxxyy_0 = current_data[324];
      const auto axxxyyy_0 = current_data[325];
      const auto axxyyyy_0 = current_data[326];
      const auto axyyyyy_0 = current_data[327];
      const auto ayyyyyy_0 = current_data[328];
      const auto axxxxxz_0 = current_data[334];
      const auto axxxxyz_0 = current_data[335];
      const auto axxxyyz_0 = current_data[336];
      const auto axxyyyz_0 = current_data[337];
      const auto axyyyyz_0 = current_data[338];
      const auto ayyyyyz_0 = current_data[339];
      const auto axxxxzz_0 = current_data[345];
      const auto axxxyzz_0 = current_data[346];
      const auto axxyyzz_0 = current_data[347];
      const auto axyyyzz_0 = current_data[348];
      const auto ayyyyzz_0 = current_data[349];
      const auto axxxzzz_0 = current_data[355];
      const auto axxyzzz_0 = current_data[356];
      const auto axyyzzz_0 = current_data[357];
      const auto ayyyzzz_0 = current_data[358];
      const auto axxzzzz_0 = current_data[364];
      const auto axyzzzz_0 = current_data[365];
      const auto ayyzzzz_0 = current_data[366];
      const auto axzzzzz_0 = current_data[372];
      const auto ayzzzzz_0 = current_data[373];
      const auto azzzzzz_0 = current_data[379];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[224] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[225] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[226] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[227] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[228] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[229] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[230] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[231] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[232] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[233] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[234] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[235] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[236] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[237] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[238] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[239] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[240] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[241] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[242] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[243] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[244] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[245] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[246] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[247] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[248] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[249] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[250] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[251] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyyz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[38];
      const auto ay_0 = current_data[39];
      const auto az_0 = current_data[45];
      const auto axx_0 = current_data[75];
      const auto axy_0 = current_data[76];
      const auto ayy_0 = current_data[77];
      const auto axz_0 = current_data[83];
      const auto ayz_0 = current_data[84];
      const auto azz_0 = current_data[90];
      const auto axxx_0 = current_data[121];
      const auto axxy_0 = current_data[122];
      const auto axyy_0 = current_data[123];
      const auto ayyy_0 = current_data[124];
      const auto axxz_0 = current_data[130];
      const auto axyz_0 = current_data[131];
      const auto ayyz_0 = current_data[132];
      const auto axzz_0 = current_data[138];
      const auto ayzz_0 = current_data[139];
      const auto azzz_0 = current_data[145];
      const auto axxxx_0 = current_data[177];
      const auto axxxy_0 = current_data[178];
      const auto axxyy_0 = current_data[179];
      const auto axyyy_0 = current_data[180];
      const auto ayyyy_0 = current_data[181];
      const auto axxxz_0 = current_data[187];
      const auto axxyz_0 = current_data[188];
      const auto axyyz_0 = current_data[189];
      const auto ayyyz_0 = current_data[190];
      const auto axxzz_0 = current_data[196];
      const auto axyzz_0 = current_data[197];
      const auto ayyzz_0 = current_data[198];
      const auto axzzz_0 = current_data[204];
      const auto ayzzz_0 = current_data[205];
      const auto azzzz_0 = current_data[211];
      const auto axxxxx_0 = current_data[244];
      const auto axxxxy_0 = current_data[245];
      const auto axxxyy_0 = current_data[246];
      const auto axxyyy_0 = current_data[247];
      const auto axyyyy_0 = current_data[248];
      const auto ayyyyy_0 = current_data[249];
      const auto axxxxz_0 = current_data[255];
      const auto axxxyz_0 = current_data[256];
      const auto axxyyz_0 = current_data[257];
      const auto axyyyz_0 = current_data[258];
      const auto ayyyyz_0 = current_data[259];
      const auto axxxzz_0 = current_data[265];
      const auto axxyzz_0 = current_data[266];
      const auto axyyzz_0 = current_data[267];
      const auto ayyyzz_0 = current_data[268];
      const auto axxzzz_0 = current_data[274];
      const auto axyzzz_0 = current_data[275];
      const auto ayyzzz_0 = current_data[276];
      const auto axzzzz_0 = current_data[282];
      const auto ayzzzz_0 = current_data[283];
      const auto azzzzz_0 = current_data[289];
      const auto axxxxxx_0 = current_data[323];
      const auto axxxxxy_0 = current_data[324];
      const auto axxxxyy_0 = current_data[325];
      const auto axxxyyy_0 = current_data[326];
      const auto axxyyyy_0 = current_data[327];
      const auto axyyyyy_0 = current_data[328];
      const auto ayyyyyy_0 = current_data[329];
      const auto axxxxxz_0 = current_data[335];
      const auto axxxxyz_0 = current_data[336];
      const auto axxxyyz_0 = current_data[337];
      const auto axxyyyz_0 = current_data[338];
      const auto axyyyyz_0 = current_data[339];
      const auto ayyyyyz_0 = current_data[340];
      const auto axxxxzz_0 = current_data[346];
      const auto axxxyzz_0 = current_data[347];
      const auto axxyyzz_0 = current_data[348];
      const auto axyyyzz_0 = current_data[349];
      const auto ayyyyzz_0 = current_data[350];
      const auto axxxzzz_0 = current_data[356];
      const auto axxyzzz_0 = current_data[357];
      const auto axyyzzz_0 = current_data[358];
      const auto ayyyzzz_0 = current_data[359];
      const auto axxzzzz_0 = current_data[365];
      const auto axyzzzz_0 = current_data[366];
      const auto ayyzzzz_0 = current_data[367];
      const auto axzzzzz_0 = current_data[373];
      const auto ayzzzzz_0 = current_data[374];
      const auto azzzzzz_0 = current_data[380];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[252] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[253] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[254] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[255] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[256] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[257] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[258] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[259] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[260] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[261] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[262] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[263] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[264] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[265] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[266] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[267] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[268] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[269] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[270] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[271] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[272] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[273] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[274] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[275] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[276] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[277] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[278] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[279] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyyyz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[39];
      const auto ay_0 = current_data[40];
      const auto az_0 = current_data[46];
      const auto axx_0 = current_data[76];
      const auto axy_0 = current_data[77];
      const auto ayy_0 = current_data[78];
      const auto axz_0 = current_data[84];
      const auto ayz_0 = current_data[85];
      const auto azz_0 = current_data[91];
      const auto axxx_0 = current_data[122];
      const auto axxy_0 = current_data[123];
      const auto axyy_0 = current_data[124];
      const auto ayyy_0 = current_data[125];
      const auto axxz_0 = current_data[131];
      const auto axyz_0 = current_data[132];
      const auto ayyz_0 = current_data[133];
      const auto axzz_0 = current_data[139];
      const auto ayzz_0 = current_data[140];
      const auto azzz_0 = current_data[146];
      const auto axxxx_0 = current_data[178];
      const auto axxxy_0 = current_data[179];
      const auto axxyy_0 = current_data[180];
      const auto axyyy_0 = current_data[181];
      const auto ayyyy_0 = current_data[182];
      const auto axxxz_0 = current_data[188];
      const auto axxyz_0 = current_data[189];
      const auto axyyz_0 = current_data[190];
      const auto ayyyz_0 = current_data[191];
      const auto axxzz_0 = current_data[197];
      const auto axyzz_0 = current_data[198];
      const auto ayyzz_0 = current_data[199];
      const auto axzzz_0 = current_data[205];
      const auto ayzzz_0 = current_data[206];
      const auto azzzz_0 = current_data[212];
      const auto axxxxx_0 = current_data[245];
      const auto axxxxy_0 = current_data[246];
      const auto axxxyy_0 = current_data[247];
      const auto axxyyy_0 = current_data[248];
      const auto axyyyy_0 = current_data[249];
      const auto ayyyyy_0 = current_data[250];
      const auto axxxxz_0 = current_data[256];
      const auto axxxyz_0 = current_data[257];
      const auto axxyyz_0 = current_data[258];
      const auto axyyyz_0 = current_data[259];
      const auto ayyyyz_0 = current_data[260];
      const auto axxxzz_0 = current_data[266];
      const auto axxyzz_0 = current_data[267];
      const auto axyyzz_0 = current_data[268];
      const auto ayyyzz_0 = current_data[269];
      const auto axxzzz_0 = current_data[275];
      const auto axyzzz_0 = current_data[276];
      const auto ayyzzz_0 = current_data[277];
      const auto axzzzz_0 = current_data[283];
      const auto ayzzzz_0 = current_data[284];
      const auto azzzzz_0 = current_data[290];
      const auto axxxxxx_0 = current_data[324];
      const auto axxxxxy_0 = current_data[325];
      const auto axxxxyy_0 = current_data[326];
      const auto axxxyyy_0 = current_data[327];
      const auto axxyyyy_0 = current_data[328];
      const auto axyyyyy_0 = current_data[329];
      const auto ayyyyyy_0 = current_data[330];
      const auto axxxxxz_0 = current_data[336];
      const auto axxxxyz_0 = current_data[337];
      const auto axxxyyz_0 = current_data[338];
      const auto axxyyyz_0 = current_data[339];
      const auto axyyyyz_0 = current_data[340];
      const auto ayyyyyz_0 = current_data[341];
      const auto axxxxzz_0 = current_data[347];
      const auto axxxyzz_0 = current_data[348];
      const auto axxyyzz_0 = current_data[349];
      const auto axyyyzz_0 = current_data[350];
      const auto ayyyyzz_0 = current_data[351];
      const auto axxxzzz_0 = current_data[357];
      const auto axxyzzz_0 = current_data[358];
      const auto axyyzzz_0 = current_data[359];
      const auto ayyyzzz_0 = current_data[360];
      const auto axxzzzz_0 = current_data[366];
      const auto axyzzzz_0 = current_data[367];
      const auto ayyzzzz_0 = current_data[368];
      const auto axzzzzz_0 = current_data[374];
      const auto ayzzzzz_0 = current_data[375];
      const auto azzzzzz_0 = current_data[381];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[280] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[281] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[282] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[283] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[284] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[285] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[286] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[287] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[288] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[289] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[290] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[291] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[292] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[293] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[294] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[295] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[296] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[297] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[298] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[299] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[300] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[301] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[302] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[303] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[304] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[305] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[306] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[307] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyyyz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[40];
      const auto ay_0 = current_data[41];
      const auto az_0 = current_data[47];
      const auto axx_0 = current_data[77];
      const auto axy_0 = current_data[78];
      const auto ayy_0 = current_data[79];
      const auto axz_0 = current_data[85];
      const auto ayz_0 = current_data[86];
      const auto azz_0 = current_data[92];
      const auto axxx_0 = current_data[123];
      const auto axxy_0 = current_data[124];
      const auto axyy_0 = current_data[125];
      const auto ayyy_0 = current_data[126];
      const auto axxz_0 = current_data[132];
      const auto axyz_0 = current_data[133];
      const auto ayyz_0 = current_data[134];
      const auto axzz_0 = current_data[140];
      const auto ayzz_0 = current_data[141];
      const auto azzz_0 = current_data[147];
      const auto axxxx_0 = current_data[179];
      const auto axxxy_0 = current_data[180];
      const auto axxyy_0 = current_data[181];
      const auto axyyy_0 = current_data[182];
      const auto ayyyy_0 = current_data[183];
      const auto axxxz_0 = current_data[189];
      const auto axxyz_0 = current_data[190];
      const auto axyyz_0 = current_data[191];
      const auto ayyyz_0 = current_data[192];
      const auto axxzz_0 = current_data[198];
      const auto axyzz_0 = current_data[199];
      const auto ayyzz_0 = current_data[200];
      const auto axzzz_0 = current_data[206];
      const auto ayzzz_0 = current_data[207];
      const auto azzzz_0 = current_data[213];
      const auto axxxxx_0 = current_data[246];
      const auto axxxxy_0 = current_data[247];
      const auto axxxyy_0 = current_data[248];
      const auto axxyyy_0 = current_data[249];
      const auto axyyyy_0 = current_data[250];
      const auto ayyyyy_0 = current_data[251];
      const auto axxxxz_0 = current_data[257];
      const auto axxxyz_0 = current_data[258];
      const auto axxyyz_0 = current_data[259];
      const auto axyyyz_0 = current_data[260];
      const auto ayyyyz_0 = current_data[261];
      const auto axxxzz_0 = current_data[267];
      const auto axxyzz_0 = current_data[268];
      const auto axyyzz_0 = current_data[269];
      const auto ayyyzz_0 = current_data[270];
      const auto axxzzz_0 = current_data[276];
      const auto axyzzz_0 = current_data[277];
      const auto ayyzzz_0 = current_data[278];
      const auto axzzzz_0 = current_data[284];
      const auto ayzzzz_0 = current_data[285];
      const auto azzzzz_0 = current_data[291];
      const auto axxxxxx_0 = current_data[325];
      const auto axxxxxy_0 = current_data[326];
      const auto axxxxyy_0 = current_data[327];
      const auto axxxyyy_0 = current_data[328];
      const auto axxyyyy_0 = current_data[329];
      const auto axyyyyy_0 = current_data[330];
      const auto ayyyyyy_0 = current_data[331];
      const auto axxxxxz_0 = current_data[337];
      const auto axxxxyz_0 = current_data[338];
      const auto axxxyyz_0 = current_data[339];
      const auto axxyyyz_0 = current_data[340];
      const auto axyyyyz_0 = current_data[341];
      const auto ayyyyyz_0 = current_data[342];
      const auto axxxxzz_0 = current_data[348];
      const auto axxxyzz_0 = current_data[349];
      const auto axxyyzz_0 = current_data[350];
      const auto axyyyzz_0 = current_data[351];
      const auto ayyyyzz_0 = current_data[352];
      const auto axxxzzz_0 = current_data[358];
      const auto axxyzzz_0 = current_data[359];
      const auto axyyzzz_0 = current_data[360];
      const auto ayyyzzz_0 = current_data[361];
      const auto axxzzzz_0 = current_data[367];
      const auto axyzzzz_0 = current_data[368];
      const auto ayyzzzz_0 = current_data[369];
      const auto axzzzzz_0 = current_data[375];
      const auto ayzzzzz_0 = current_data[376];
      const auto azzzzzz_0 = current_data[382];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[308] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[309] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[310] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[311] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[312] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[313] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[314] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[315] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[316] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[317] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[318] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[319] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[320] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[321] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[322] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[323] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[324] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[325] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[326] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[327] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[328] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[329] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[330] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[331] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[332] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[333] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[334] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[335] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyyyz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[41];
      const auto ay_0 = current_data[42];
      const auto az_0 = current_data[48];
      const auto axx_0 = current_data[78];
      const auto axy_0 = current_data[79];
      const auto ayy_0 = current_data[80];
      const auto axz_0 = current_data[86];
      const auto ayz_0 = current_data[87];
      const auto azz_0 = current_data[93];
      const auto axxx_0 = current_data[124];
      const auto axxy_0 = current_data[125];
      const auto axyy_0 = current_data[126];
      const auto ayyy_0 = current_data[127];
      const auto axxz_0 = current_data[133];
      const auto axyz_0 = current_data[134];
      const auto ayyz_0 = current_data[135];
      const auto axzz_0 = current_data[141];
      const auto ayzz_0 = current_data[142];
      const auto azzz_0 = current_data[148];
      const auto axxxx_0 = current_data[180];
      const auto axxxy_0 = current_data[181];
      const auto axxyy_0 = current_data[182];
      const auto axyyy_0 = current_data[183];
      const auto ayyyy_0 = current_data[184];
      const auto axxxz_0 = current_data[190];
      const auto axxyz_0 = current_data[191];
      const auto axyyz_0 = current_data[192];
      const auto ayyyz_0 = current_data[193];
      const auto axxzz_0 = current_data[199];
      const auto axyzz_0 = current_data[200];
      const auto ayyzz_0 = current_data[201];
      const auto axzzz_0 = current_data[207];
      const auto ayzzz_0 = current_data[208];
      const auto azzzz_0 = current_data[214];
      const auto axxxxx_0 = current_data[247];
      const auto axxxxy_0 = current_data[248];
      const auto axxxyy_0 = current_data[249];
      const auto axxyyy_0 = current_data[250];
      const auto axyyyy_0 = current_data[251];
      const auto ayyyyy_0 = current_data[252];
      const auto axxxxz_0 = current_data[258];
      const auto axxxyz_0 = current_data[259];
      const auto axxyyz_0 = current_data[260];
      const auto axyyyz_0 = current_data[261];
      const auto ayyyyz_0 = current_data[262];
      const auto axxxzz_0 = current_data[268];
      const auto axxyzz_0 = current_data[269];
      const auto axyyzz_0 = current_data[270];
      const auto ayyyzz_0 = current_data[271];
      const auto axxzzz_0 = current_data[277];
      const auto axyzzz_0 = current_data[278];
      const auto ayyzzz_0 = current_data[279];
      const auto axzzzz_0 = current_data[285];
      const auto ayzzzz_0 = current_data[286];
      const auto azzzzz_0 = current_data[292];
      const auto axxxxxx_0 = current_data[326];
      const auto axxxxxy_0 = current_data[327];
      const auto axxxxyy_0 = current_data[328];
      const auto axxxyyy_0 = current_data[329];
      const auto axxyyyy_0 = current_data[330];
      const auto axyyyyy_0 = current_data[331];
      const auto ayyyyyy_0 = current_data[332];
      const auto axxxxxz_0 = current_data[338];
      const auto axxxxyz_0 = current_data[339];
      const auto axxxyyz_0 = current_data[340];
      const auto axxyyyz_0 = current_data[341];
      const auto axyyyyz_0 = current_data[342];
      const auto ayyyyyz_0 = current_data[343];
      const auto axxxxzz_0 = current_data[349];
      const auto axxxyzz_0 = current_data[350];
      const auto axxyyzz_0 = current_data[351];
      const auto axyyyzz_0 = current_data[352];
      const auto ayyyyzz_0 = current_data[353];
      const auto axxxzzz_0 = current_data[359];
      const auto axxyzzz_0 = current_data[360];
      const auto axyyzzz_0 = current_data[361];
      const auto ayyyzzz_0 = current_data[362];
      const auto axxzzzz_0 = current_data[368];
      const auto axyzzzz_0 = current_data[369];
      const auto ayyzzzz_0 = current_data[370];
      const auto axzzzzz_0 = current_data[376];
      const auto ayzzzzz_0 = current_data[377];
      const auto azzzzzz_0 = current_data[383];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[336] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[337] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[338] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[339] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[340] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[341] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[342] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[343] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[344] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[345] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[346] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[347] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[348] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[349] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[350] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[351] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[352] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[353] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[354] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[355] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[356] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[357] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[358] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[359] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[360] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[361] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[362] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[363] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxzz
      const auto a0_0 = current_data[13];
      const auto ax_0 = current_data[43];
      const auto ay_0 = current_data[44];
      const auto az_0 = current_data[49];
      const auto axx_0 = current_data[81];
      const auto axy_0 = current_data[82];
      const auto ayy_0 = current_data[83];
      const auto axz_0 = current_data[88];
      const auto ayz_0 = current_data[89];
      const auto azz_0 = current_data[94];
      const auto axxx_0 = current_data[128];
      const auto axxy_0 = current_data[129];
      const auto axyy_0 = current_data[130];
      const auto ayyy_0 = current_data[131];
      const auto axxz_0 = current_data[136];
      const auto axyz_0 = current_data[137];
      const auto ayyz_0 = current_data[138];
      const auto axzz_0 = current_data[143];
      const auto ayzz_0 = current_data[144];
      const auto azzz_0 = current_data[149];
      const auto axxxx_0 = current_data[185];
      const auto axxxy_0 = current_data[186];
      const auto axxyy_0 = current_data[187];
      const auto axyyy_0 = current_data[188];
      const auto ayyyy_0 = current_data[189];
      const auto axxxz_0 = current_data[194];
      const auto axxyz_0 = current_data[195];
      const auto axyyz_0 = current_data[196];
      const auto ayyyz_0 = current_data[197];
      const auto axxzz_0 = current_data[202];
      const auto axyzz_0 = current_data[203];
      const auto ayyzz_0 = current_data[204];
      const auto axzzz_0 = current_data[209];
      const auto ayzzz_0 = current_data[210];
      const auto azzzz_0 = current_data[215];
      const auto axxxxx_0 = current_data[253];
      const auto axxxxy_0 = current_data[254];
      const auto axxxyy_0 = current_data[255];
      const auto axxyyy_0 = current_data[256];
      const auto axyyyy_0 = current_data[257];
      const auto ayyyyy_0 = current_data[258];
      const auto axxxxz_0 = current_data[263];
      const auto axxxyz_0 = current_data[264];
      const auto axxyyz_0 = current_data[265];
      const auto axyyyz_0 = current_data[266];
      const auto ayyyyz_0 = current_data[267];
      const auto axxxzz_0 = current_data[272];
      const auto axxyzz_0 = current_data[273];
      const auto axyyzz_0 = current_data[274];
      const auto ayyyzz_0 = current_data[275];
      const auto axxzzz_0 = current_data[280];
      const auto axyzzz_0 = current_data[281];
      const auto ayyzzz_0 = current_data[282];
      const auto axzzzz_0 = current_data[287];
      const auto ayzzzz_0 = current_data[288];
      const auto azzzzz_0 = current_data[293];
      const auto axxxxxx_0 = current_data[333];
      const auto axxxxxy_0 = current_data[334];
      const auto axxxxyy_0 = current_data[335];
      const auto axxxyyy_0 = current_data[336];
      const auto axxyyyy_0 = current_data[337];
      const auto axyyyyy_0 = current_data[338];
      const auto ayyyyyy_0 = current_data[339];
      const auto axxxxxz_0 = current_data[344];
      const auto axxxxyz_0 = current_data[345];
      const auto axxxyyz_0 = current_data[346];
      const auto axxyyyz_0 = current_data[347];
      const auto axyyyyz_0 = current_data[348];
      const auto ayyyyyz_0 = current_data[349];
      const auto axxxxzz_0 = current_data[354];
      const auto axxxyzz_0 = current_data[355];
      const auto axxyyzz_0 = current_data[356];
      const auto axyyyzz_0 = current_data[357];
      const auto ayyyyzz_0 = current_data[358];
      const auto axxxzzz_0 = current_data[363];
      const auto axxyzzz_0 = current_data[364];
      const auto axyyzzz_0 = current_data[365];
      const auto ayyyzzz_0 = current_data[366];
      const auto axxzzzz_0 = current_data[371];
      const auto axyzzzz_0 = current_data[372];
      const auto ayyzzzz_0 = current_data[373];
      const auto axzzzzz_0 = current_data[378];
      const auto ayzzzzz_0 = current_data[379];
      const auto azzzzzz_0 = current_data[384];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[364] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[365] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[366] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[367] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[368] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[369] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[370] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[371] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[372] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[373] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[374] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[375] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[376] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[377] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[378] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[379] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[380] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[381] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[382] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[383] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[384] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[385] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[386] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[387] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[388] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[389] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[390] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[391] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyzz
      const auto a0_0 = current_data[14];
      const auto ax_0 = current_data[44];
      const auto ay_0 = current_data[45];
      const auto az_0 = current_data[50];
      const auto axx_0 = current_data[82];
      const auto axy_0 = current_data[83];
      const auto ayy_0 = current_data[84];
      const auto axz_0 = current_data[89];
      const auto ayz_0 = current_data[90];
      const auto azz_0 = current_data[95];
      const auto axxx_0 = current_data[129];
      const auto axxy_0 = current_data[130];
      const auto axyy_0 = current_data[131];
      const auto ayyy_0 = current_data[132];
      const auto axxz_0 = current_data[137];
      const auto axyz_0 = current_data[138];
      const auto ayyz_0 = current_data[139];
      const auto axzz_0 = current_data[144];
      const auto ayzz_0 = current_data[145];
      const auto azzz_0 = current_data[150];
      const auto axxxx_0 = current_data[186];
      const auto axxxy_0 = current_data[187];
      const auto axxyy_0 = current_data[188];
      const auto axyyy_0 = current_data[189];
      const auto ayyyy_0 = current_data[190];
      const auto axxxz_0 = current_data[195];
      const auto axxyz_0 = current_data[196];
      const auto axyyz_0 = current_data[197];
      const auto ayyyz_0 = current_data[198];
      const auto axxzz_0 = current_data[203];
      const auto axyzz_0 = current_data[204];
      const auto ayyzz_0 = current_data[205];
      const auto axzzz_0 = current_data[210];
      const auto ayzzz_0 = current_data[211];
      const auto azzzz_0 = current_data[216];
      const auto axxxxx_0 = current_data[254];
      const auto axxxxy_0 = current_data[255];
      const auto axxxyy_0 = current_data[256];
      const auto axxyyy_0 = current_data[257];
      const auto axyyyy_0 = current_data[258];
      const auto ayyyyy_0 = current_data[259];
      const auto axxxxz_0 = current_data[264];
      const auto axxxyz_0 = current_data[265];
      const auto axxyyz_0 = current_data[266];
      const auto axyyyz_0 = current_data[267];
      const auto ayyyyz_0 = current_data[268];
      const auto axxxzz_0 = current_data[273];
      const auto axxyzz_0 = current_data[274];
      const auto axyyzz_0 = current_data[275];
      const auto ayyyzz_0 = current_data[276];
      const auto axxzzz_0 = current_data[281];
      const auto axyzzz_0 = current_data[282];
      const auto ayyzzz_0 = current_data[283];
      const auto axzzzz_0 = current_data[288];
      const auto ayzzzz_0 = current_data[289];
      const auto azzzzz_0 = current_data[294];
      const auto axxxxxx_0 = current_data[334];
      const auto axxxxxy_0 = current_data[335];
      const auto axxxxyy_0 = current_data[336];
      const auto axxxyyy_0 = current_data[337];
      const auto axxyyyy_0 = current_data[338];
      const auto axyyyyy_0 = current_data[339];
      const auto ayyyyyy_0 = current_data[340];
      const auto axxxxxz_0 = current_data[345];
      const auto axxxxyz_0 = current_data[346];
      const auto axxxyyz_0 = current_data[347];
      const auto axxyyyz_0 = current_data[348];
      const auto axyyyyz_0 = current_data[349];
      const auto ayyyyyz_0 = current_data[350];
      const auto axxxxzz_0 = current_data[355];
      const auto axxxyzz_0 = current_data[356];
      const auto axxyyzz_0 = current_data[357];
      const auto axyyyzz_0 = current_data[358];
      const auto ayyyyzz_0 = current_data[359];
      const auto axxxzzz_0 = current_data[364];
      const auto axxyzzz_0 = current_data[365];
      const auto axyyzzz_0 = current_data[366];
      const auto ayyyzzz_0 = current_data[367];
      const auto axxzzzz_0 = current_data[372];
      const auto axyzzzz_0 = current_data[373];
      const auto ayyzzzz_0 = current_data[374];
      const auto axzzzzz_0 = current_data[379];
      const auto ayzzzzz_0 = current_data[380];
      const auto azzzzzz_0 = current_data[385];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[392] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[393] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[394] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[395] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[396] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[397] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[398] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[399] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[400] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[401] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[402] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[403] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[404] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[405] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[406] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[407] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[408] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[409] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[410] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[411] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[412] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[413] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[414] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[415] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[416] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[417] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[418] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[419] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyyzz
      const auto a0_0 = current_data[15];
      const auto ax_0 = current_data[45];
      const auto ay_0 = current_data[46];
      const auto az_0 = current_data[51];
      const auto axx_0 = current_data[83];
      const auto axy_0 = current_data[84];
      const auto ayy_0 = current_data[85];
      const auto axz_0 = current_data[90];
      const auto ayz_0 = current_data[91];
      const auto azz_0 = current_data[96];
      const auto axxx_0 = current_data[130];
      const auto axxy_0 = current_data[131];
      const auto axyy_0 = current_data[132];
      const auto ayyy_0 = current_data[133];
      const auto axxz_0 = current_data[138];
      const auto axyz_0 = current_data[139];
      const auto ayyz_0 = current_data[140];
      const auto axzz_0 = current_data[145];
      const auto ayzz_0 = current_data[146];
      const auto azzz_0 = current_data[151];
      const auto axxxx_0 = current_data[187];
      const auto axxxy_0 = current_data[188];
      const auto axxyy_0 = current_data[189];
      const auto axyyy_0 = current_data[190];
      const auto ayyyy_0 = current_data[191];
      const auto axxxz_0 = current_data[196];
      const auto axxyz_0 = current_data[197];
      const auto axyyz_0 = current_data[198];
      const auto ayyyz_0 = current_data[199];
      const auto axxzz_0 = current_data[204];
      const auto axyzz_0 = current_data[205];
      const auto ayyzz_0 = current_data[206];
      const auto axzzz_0 = current_data[211];
      const auto ayzzz_0 = current_data[212];
      const auto azzzz_0 = current_data[217];
      const auto axxxxx_0 = current_data[255];
      const auto axxxxy_0 = current_data[256];
      const auto axxxyy_0 = current_data[257];
      const auto axxyyy_0 = current_data[258];
      const auto axyyyy_0 = current_data[259];
      const auto ayyyyy_0 = current_data[260];
      const auto axxxxz_0 = current_data[265];
      const auto axxxyz_0 = current_data[266];
      const auto axxyyz_0 = current_data[267];
      const auto axyyyz_0 = current_data[268];
      const auto ayyyyz_0 = current_data[269];
      const auto axxxzz_0 = current_data[274];
      const auto axxyzz_0 = current_data[275];
      const auto axyyzz_0 = current_data[276];
      const auto ayyyzz_0 = current_data[277];
      const auto axxzzz_0 = current_data[282];
      const auto axyzzz_0 = current_data[283];
      const auto ayyzzz_0 = current_data[284];
      const auto axzzzz_0 = current_data[289];
      const auto ayzzzz_0 = current_data[290];
      const auto azzzzz_0 = current_data[295];
      const auto axxxxxx_0 = current_data[335];
      const auto axxxxxy_0 = current_data[336];
      const auto axxxxyy_0 = current_data[337];
      const auto axxxyyy_0 = current_data[338];
      const auto axxyyyy_0 = current_data[339];
      const auto axyyyyy_0 = current_data[340];
      const auto ayyyyyy_0 = current_data[341];
      const auto axxxxxz_0 = current_data[346];
      const auto axxxxyz_0 = current_data[347];
      const auto axxxyyz_0 = current_data[348];
      const auto axxyyyz_0 = current_data[349];
      const auto axyyyyz_0 = current_data[350];
      const auto ayyyyyz_0 = current_data[351];
      const auto axxxxzz_0 = current_data[356];
      const auto axxxyzz_0 = current_data[357];
      const auto axxyyzz_0 = current_data[358];
      const auto axyyyzz_0 = current_data[359];
      const auto ayyyyzz_0 = current_data[360];
      const auto axxxzzz_0 = current_data[365];
      const auto axxyzzz_0 = current_data[366];
      const auto axyyzzz_0 = current_data[367];
      const auto ayyyzzz_0 = current_data[368];
      const auto axxzzzz_0 = current_data[373];
      const auto axyzzzz_0 = current_data[374];
      const auto ayyzzzz_0 = current_data[375];
      const auto axzzzzz_0 = current_data[380];
      const auto ayzzzzz_0 = current_data[381];
      const auto azzzzzz_0 = current_data[386];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[420] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[421] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[422] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[423] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[424] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[425] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[426] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[427] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[428] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[429] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[430] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[431] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[432] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[433] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[434] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[435] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[436] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[437] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[438] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[439] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[440] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[441] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[442] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[443] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[444] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[445] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[446] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[447] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyyzz
      const auto a0_0 = current_data[16];
      const auto ax_0 = current_data[46];
      const auto ay_0 = current_data[47];
      const auto az_0 = current_data[52];
      const auto axx_0 = current_data[84];
      const auto axy_0 = current_data[85];
      const auto ayy_0 = current_data[86];
      const auto axz_0 = current_data[91];
      const auto ayz_0 = current_data[92];
      const auto azz_0 = current_data[97];
      const auto axxx_0 = current_data[131];
      const auto axxy_0 = current_data[132];
      const auto axyy_0 = current_data[133];
      const auto ayyy_0 = current_data[134];
      const auto axxz_0 = current_data[139];
      const auto axyz_0 = current_data[140];
      const auto ayyz_0 = current_data[141];
      const auto axzz_0 = current_data[146];
      const auto ayzz_0 = current_data[147];
      const auto azzz_0 = current_data[152];
      const auto axxxx_0 = current_data[188];
      const auto axxxy_0 = current_data[189];
      const auto axxyy_0 = current_data[190];
      const auto axyyy_0 = current_data[191];
      const auto ayyyy_0 = current_data[192];
      const auto axxxz_0 = current_data[197];
      const auto axxyz_0 = current_data[198];
      const auto axyyz_0 = current_data[199];
      const auto ayyyz_0 = current_data[200];
      const auto axxzz_0 = current_data[205];
      const auto axyzz_0 = current_data[206];
      const auto ayyzz_0 = current_data[207];
      const auto axzzz_0 = current_data[212];
      const auto ayzzz_0 = current_data[213];
      const auto azzzz_0 = current_data[218];
      const auto axxxxx_0 = current_data[256];
      const auto axxxxy_0 = current_data[257];
      const auto axxxyy_0 = current_data[258];
      const auto axxyyy_0 = current_data[259];
      const auto axyyyy_0 = current_data[260];
      const auto ayyyyy_0 = current_data[261];
      const auto axxxxz_0 = current_data[266];
      const auto axxxyz_0 = current_data[267];
      const auto axxyyz_0 = current_data[268];
      const auto axyyyz_0 = current_data[269];
      const auto ayyyyz_0 = current_data[270];
      const auto axxxzz_0 = current_data[275];
      const auto axxyzz_0 = current_data[276];
      const auto axyyzz_0 = current_data[277];
      const auto ayyyzz_0 = current_data[278];
      const auto axxzzz_0 = current_data[283];
      const auto axyzzz_0 = current_data[284];
      const auto ayyzzz_0 = current_data[285];
      const auto axzzzz_0 = current_data[290];
      const auto ayzzzz_0 = current_data[291];
      const auto azzzzz_0 = current_data[296];
      const auto axxxxxx_0 = current_data[336];
      const auto axxxxxy_0 = current_data[337];
      const auto axxxxyy_0 = current_data[338];
      const auto axxxyyy_0 = current_data[339];
      const auto axxyyyy_0 = current_data[340];
      const auto axyyyyy_0 = current_data[341];
      const auto ayyyyyy_0 = current_data[342];
      const auto axxxxxz_0 = current_data[347];
      const auto axxxxyz_0 = current_data[348];
      const auto axxxyyz_0 = current_data[349];
      const auto axxyyyz_0 = current_data[350];
      const auto axyyyyz_0 = current_data[351];
      const auto ayyyyyz_0 = current_data[352];
      const auto axxxxzz_0 = current_data[357];
      const auto axxxyzz_0 = current_data[358];
      const auto axxyyzz_0 = current_data[359];
      const auto axyyyzz_0 = current_data[360];
      const auto ayyyyzz_0 = current_data[361];
      const auto axxxzzz_0 = current_data[366];
      const auto axxyzzz_0 = current_data[367];
      const auto axyyzzz_0 = current_data[368];
      const auto ayyyzzz_0 = current_data[369];
      const auto axxzzzz_0 = current_data[374];
      const auto axyzzzz_0 = current_data[375];
      const auto ayyzzzz_0 = current_data[376];
      const auto axzzzzz_0 = current_data[381];
      const auto ayzzzzz_0 = current_data[382];
      const auto azzzzzz_0 = current_data[387];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[448] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[449] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[450] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[451] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[452] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[453] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[454] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[455] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[456] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[457] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[458] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[459] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[460] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[461] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[462] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[463] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[464] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[465] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[466] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[467] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[468] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[469] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[470] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[471] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[472] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[473] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[474] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[475] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyyzz
      const auto a0_0 = current_data[17];
      const auto ax_0 = current_data[47];
      const auto ay_0 = current_data[48];
      const auto az_0 = current_data[53];
      const auto axx_0 = current_data[85];
      const auto axy_0 = current_data[86];
      const auto ayy_0 = current_data[87];
      const auto axz_0 = current_data[92];
      const auto ayz_0 = current_data[93];
      const auto azz_0 = current_data[98];
      const auto axxx_0 = current_data[132];
      const auto axxy_0 = current_data[133];
      const auto axyy_0 = current_data[134];
      const auto ayyy_0 = current_data[135];
      const auto axxz_0 = current_data[140];
      const auto axyz_0 = current_data[141];
      const auto ayyz_0 = current_data[142];
      const auto axzz_0 = current_data[147];
      const auto ayzz_0 = current_data[148];
      const auto azzz_0 = current_data[153];
      const auto axxxx_0 = current_data[189];
      const auto axxxy_0 = current_data[190];
      const auto axxyy_0 = current_data[191];
      const auto axyyy_0 = current_data[192];
      const auto ayyyy_0 = current_data[193];
      const auto axxxz_0 = current_data[198];
      const auto axxyz_0 = current_data[199];
      const auto axyyz_0 = current_data[200];
      const auto ayyyz_0 = current_data[201];
      const auto axxzz_0 = current_data[206];
      const auto axyzz_0 = current_data[207];
      const auto ayyzz_0 = current_data[208];
      const auto axzzz_0 = current_data[213];
      const auto ayzzz_0 = current_data[214];
      const auto azzzz_0 = current_data[219];
      const auto axxxxx_0 = current_data[257];
      const auto axxxxy_0 = current_data[258];
      const auto axxxyy_0 = current_data[259];
      const auto axxyyy_0 = current_data[260];
      const auto axyyyy_0 = current_data[261];
      const auto ayyyyy_0 = current_data[262];
      const auto axxxxz_0 = current_data[267];
      const auto axxxyz_0 = current_data[268];
      const auto axxyyz_0 = current_data[269];
      const auto axyyyz_0 = current_data[270];
      const auto ayyyyz_0 = current_data[271];
      const auto axxxzz_0 = current_data[276];
      const auto axxyzz_0 = current_data[277];
      const auto axyyzz_0 = current_data[278];
      const auto ayyyzz_0 = current_data[279];
      const auto axxzzz_0 = current_data[284];
      const auto axyzzz_0 = current_data[285];
      const auto ayyzzz_0 = current_data[286];
      const auto axzzzz_0 = current_data[291];
      const auto ayzzzz_0 = current_data[292];
      const auto azzzzz_0 = current_data[297];
      const auto axxxxxx_0 = current_data[337];
      const auto axxxxxy_0 = current_data[338];
      const auto axxxxyy_0 = current_data[339];
      const auto axxxyyy_0 = current_data[340];
      const auto axxyyyy_0 = current_data[341];
      const auto axyyyyy_0 = current_data[342];
      const auto ayyyyyy_0 = current_data[343];
      const auto axxxxxz_0 = current_data[348];
      const auto axxxxyz_0 = current_data[349];
      const auto axxxyyz_0 = current_data[350];
      const auto axxyyyz_0 = current_data[351];
      const auto axyyyyz_0 = current_data[352];
      const auto ayyyyyz_0 = current_data[353];
      const auto axxxxzz_0 = current_data[358];
      const auto axxxyzz_0 = current_data[359];
      const auto axxyyzz_0 = current_data[360];
      const auto axyyyzz_0 = current_data[361];
      const auto ayyyyzz_0 = current_data[362];
      const auto axxxzzz_0 = current_data[367];
      const auto axxyzzz_0 = current_data[368];
      const auto axyyzzz_0 = current_data[369];
      const auto ayyyzzz_0 = current_data[370];
      const auto axxzzzz_0 = current_data[375];
      const auto axyzzzz_0 = current_data[376];
      const auto ayyzzzz_0 = current_data[377];
      const auto axzzzzz_0 = current_data[382];
      const auto ayzzzzz_0 = current_data[383];
      const auto azzzzzz_0 = current_data[388];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[476] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[477] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[478] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[479] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[480] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[481] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[482] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[483] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[484] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[485] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[486] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[487] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[488] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[489] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[490] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[491] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[492] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[493] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[494] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[495] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[496] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[497] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[498] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[499] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[500] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[501] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[502] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[503] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxzzz
      const auto a0_0 = current_data[18];
      const auto ax_0 = current_data[49];
      const auto ay_0 = current_data[50];
      const auto az_0 = current_data[54];
      const auto axx_0 = current_data[88];
      const auto axy_0 = current_data[89];
      const auto ayy_0 = current_data[90];
      const auto axz_0 = current_data[94];
      const auto ayz_0 = current_data[95];
      const auto azz_0 = current_data[99];
      const auto axxx_0 = current_data[136];
      const auto axxy_0 = current_data[137];
      const auto axyy_0 = current_data[138];
      const auto ayyy_0 = current_data[139];
      const auto axxz_0 = current_data[143];
      const auto axyz_0 = current_data[144];
      const auto ayyz_0 = current_data[145];
      const auto axzz_0 = current_data[149];
      const auto ayzz_0 = current_data[150];
      const auto azzz_0 = current_data[154];
      const auto axxxx_0 = current_data[194];
      const auto axxxy_0 = current_data[195];
      const auto axxyy_0 = current_data[196];
      const auto axyyy_0 = current_data[197];
      const auto ayyyy_0 = current_data[198];
      const auto axxxz_0 = current_data[202];
      const auto axxyz_0 = current_data[203];
      const auto axyyz_0 = current_data[204];
      const auto ayyyz_0 = current_data[205];
      const auto axxzz_0 = current_data[209];
      const auto axyzz_0 = current_data[210];
      const auto ayyzz_0 = current_data[211];
      const auto axzzz_0 = current_data[215];
      const auto ayzzz_0 = current_data[216];
      const auto azzzz_0 = current_data[220];
      const auto axxxxx_0 = current_data[263];
      const auto axxxxy_0 = current_data[264];
      const auto axxxyy_0 = current_data[265];
      const auto axxyyy_0 = current_data[266];
      const auto axyyyy_0 = current_data[267];
      const auto ayyyyy_0 = current_data[268];
      const auto axxxxz_0 = current_data[272];
      const auto axxxyz_0 = current_data[273];
      const auto axxyyz_0 = current_data[274];
      const auto axyyyz_0 = current_data[275];
      const auto ayyyyz_0 = current_data[276];
      const auto axxxzz_0 = current_data[280];
      const auto axxyzz_0 = current_data[281];
      const auto axyyzz_0 = current_data[282];
      const auto ayyyzz_0 = current_data[283];
      const auto axxzzz_0 = current_data[287];
      const auto axyzzz_0 = current_data[288];
      const auto ayyzzz_0 = current_data[289];
      const auto axzzzz_0 = current_data[293];
      const auto ayzzzz_0 = current_data[294];
      const auto azzzzz_0 = current_data[298];
      const auto axxxxxx_0 = current_data[344];
      const auto axxxxxy_0 = current_data[345];
      const auto axxxxyy_0 = current_data[346];
      const auto axxxyyy_0 = current_data[347];
      const auto axxyyyy_0 = current_data[348];
      const auto axyyyyy_0 = current_data[349];
      const auto ayyyyyy_0 = current_data[350];
      const auto axxxxxz_0 = current_data[354];
      const auto axxxxyz_0 = current_data[355];
      const auto axxxyyz_0 = current_data[356];
      const auto axxyyyz_0 = current_data[357];
      const auto axyyyyz_0 = current_data[358];
      const auto ayyyyyz_0 = current_data[359];
      const auto axxxxzz_0 = current_data[363];
      const auto axxxyzz_0 = current_data[364];
      const auto axxyyzz_0 = current_data[365];
      const auto axyyyzz_0 = current_data[366];
      const auto ayyyyzz_0 = current_data[367];
      const auto axxxzzz_0 = current_data[371];
      const auto axxyzzz_0 = current_data[372];
      const auto axyyzzz_0 = current_data[373];
      const auto ayyyzzz_0 = current_data[374];
      const auto axxzzzz_0 = current_data[378];
      const auto axyzzzz_0 = current_data[379];
      const auto ayyzzzz_0 = current_data[380];
      const auto axzzzzz_0 = current_data[384];
      const auto ayzzzzz_0 = current_data[385];
      const auto azzzzzz_0 = current_data[389];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[504] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[505] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[506] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[507] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[508] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[509] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[510] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[511] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[512] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[513] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[514] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[515] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[516] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[517] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[518] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[519] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[520] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[521] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[522] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[523] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[524] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[525] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[526] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[527] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[528] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[529] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[530] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[531] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyzzz
      const auto a0_0 = current_data[19];
      const auto ax_0 = current_data[50];
      const auto ay_0 = current_data[51];
      const auto az_0 = current_data[55];
      const auto axx_0 = current_data[89];
      const auto axy_0 = current_data[90];
      const auto ayy_0 = current_data[91];
      const auto axz_0 = current_data[95];
      const auto ayz_0 = current_data[96];
      const auto azz_0 = current_data[100];
      const auto axxx_0 = current_data[137];
      const auto axxy_0 = current_data[138];
      const auto axyy_0 = current_data[139];
      const auto ayyy_0 = current_data[140];
      const auto axxz_0 = current_data[144];
      const auto axyz_0 = current_data[145];
      const auto ayyz_0 = current_data[146];
      const auto axzz_0 = current_data[150];
      const auto ayzz_0 = current_data[151];
      const auto azzz_0 = current_data[155];
      const auto axxxx_0 = current_data[195];
      const auto axxxy_0 = current_data[196];
      const auto axxyy_0 = current_data[197];
      const auto axyyy_0 = current_data[198];
      const auto ayyyy_0 = current_data[199];
      const auto axxxz_0 = current_data[203];
      const auto axxyz_0 = current_data[204];
      const auto axyyz_0 = current_data[205];
      const auto ayyyz_0 = current_data[206];
      const auto axxzz_0 = current_data[210];
      const auto axyzz_0 = current_data[211];
      const auto ayyzz_0 = current_data[212];
      const auto axzzz_0 = current_data[216];
      const auto ayzzz_0 = current_data[217];
      const auto azzzz_0 = current_data[221];
      const auto axxxxx_0 = current_data[264];
      const auto axxxxy_0 = current_data[265];
      const auto axxxyy_0 = current_data[266];
      const auto axxyyy_0 = current_data[267];
      const auto axyyyy_0 = current_data[268];
      const auto ayyyyy_0 = current_data[269];
      const auto axxxxz_0 = current_data[273];
      const auto axxxyz_0 = current_data[274];
      const auto axxyyz_0 = current_data[275];
      const auto axyyyz_0 = current_data[276];
      const auto ayyyyz_0 = current_data[277];
      const auto axxxzz_0 = current_data[281];
      const auto axxyzz_0 = current_data[282];
      const auto axyyzz_0 = current_data[283];
      const auto ayyyzz_0 = current_data[284];
      const auto axxzzz_0 = current_data[288];
      const auto axyzzz_0 = current_data[289];
      const auto ayyzzz_0 = current_data[290];
      const auto axzzzz_0 = current_data[294];
      const auto ayzzzz_0 = current_data[295];
      const auto azzzzz_0 = current_data[299];
      const auto axxxxxx_0 = current_data[345];
      const auto axxxxxy_0 = current_data[346];
      const auto axxxxyy_0 = current_data[347];
      const auto axxxyyy_0 = current_data[348];
      const auto axxyyyy_0 = current_data[349];
      const auto axyyyyy_0 = current_data[350];
      const auto ayyyyyy_0 = current_data[351];
      const auto axxxxxz_0 = current_data[355];
      const auto axxxxyz_0 = current_data[356];
      const auto axxxyyz_0 = current_data[357];
      const auto axxyyyz_0 = current_data[358];
      const auto axyyyyz_0 = current_data[359];
      const auto ayyyyyz_0 = current_data[360];
      const auto axxxxzz_0 = current_data[364];
      const auto axxxyzz_0 = current_data[365];
      const auto axxyyzz_0 = current_data[366];
      const auto axyyyzz_0 = current_data[367];
      const auto ayyyyzz_0 = current_data[368];
      const auto axxxzzz_0 = current_data[372];
      const auto axxyzzz_0 = current_data[373];
      const auto axyyzzz_0 = current_data[374];
      const auto ayyyzzz_0 = current_data[375];
      const auto axxzzzz_0 = current_data[379];
      const auto axyzzzz_0 = current_data[380];
      const auto ayyzzzz_0 = current_data[381];
      const auto axzzzzz_0 = current_data[385];
      const auto ayzzzzz_0 = current_data[386];
      const auto azzzzzz_0 = current_data[390];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[532] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[533] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[534] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[535] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[536] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[537] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[538] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[539] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[540] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[541] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[542] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[543] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[544] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[545] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[546] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[547] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[548] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[549] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[550] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[551] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[552] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[553] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[554] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[555] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[556] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[557] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[558] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[559] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyzzz
      const auto a0_0 = current_data[20];
      const auto ax_0 = current_data[51];
      const auto ay_0 = current_data[52];
      const auto az_0 = current_data[56];
      const auto axx_0 = current_data[90];
      const auto axy_0 = current_data[91];
      const auto ayy_0 = current_data[92];
      const auto axz_0 = current_data[96];
      const auto ayz_0 = current_data[97];
      const auto azz_0 = current_data[101];
      const auto axxx_0 = current_data[138];
      const auto axxy_0 = current_data[139];
      const auto axyy_0 = current_data[140];
      const auto ayyy_0 = current_data[141];
      const auto axxz_0 = current_data[145];
      const auto axyz_0 = current_data[146];
      const auto ayyz_0 = current_data[147];
      const auto axzz_0 = current_data[151];
      const auto ayzz_0 = current_data[152];
      const auto azzz_0 = current_data[156];
      const auto axxxx_0 = current_data[196];
      const auto axxxy_0 = current_data[197];
      const auto axxyy_0 = current_data[198];
      const auto axyyy_0 = current_data[199];
      const auto ayyyy_0 = current_data[200];
      const auto axxxz_0 = current_data[204];
      const auto axxyz_0 = current_data[205];
      const auto axyyz_0 = current_data[206];
      const auto ayyyz_0 = current_data[207];
      const auto axxzz_0 = current_data[211];
      const auto axyzz_0 = current_data[212];
      const auto ayyzz_0 = current_data[213];
      const auto axzzz_0 = current_data[217];
      const auto ayzzz_0 = current_data[218];
      const auto azzzz_0 = current_data[222];
      const auto axxxxx_0 = current_data[265];
      const auto axxxxy_0 = current_data[266];
      const auto axxxyy_0 = current_data[267];
      const auto axxyyy_0 = current_data[268];
      const auto axyyyy_0 = current_data[269];
      const auto ayyyyy_0 = current_data[270];
      const auto axxxxz_0 = current_data[274];
      const auto axxxyz_0 = current_data[275];
      const auto axxyyz_0 = current_data[276];
      const auto axyyyz_0 = current_data[277];
      const auto ayyyyz_0 = current_data[278];
      const auto axxxzz_0 = current_data[282];
      const auto axxyzz_0 = current_data[283];
      const auto axyyzz_0 = current_data[284];
      const auto ayyyzz_0 = current_data[285];
      const auto axxzzz_0 = current_data[289];
      const auto axyzzz_0 = current_data[290];
      const auto ayyzzz_0 = current_data[291];
      const auto axzzzz_0 = current_data[295];
      const auto ayzzzz_0 = current_data[296];
      const auto azzzzz_0 = current_data[300];
      const auto axxxxxx_0 = current_data[346];
      const auto axxxxxy_0 = current_data[347];
      const auto axxxxyy_0 = current_data[348];
      const auto axxxyyy_0 = current_data[349];
      const auto axxyyyy_0 = current_data[350];
      const auto axyyyyy_0 = current_data[351];
      const auto ayyyyyy_0 = current_data[352];
      const auto axxxxxz_0 = current_data[356];
      const auto axxxxyz_0 = current_data[357];
      const auto axxxyyz_0 = current_data[358];
      const auto axxyyyz_0 = current_data[359];
      const auto axyyyyz_0 = current_data[360];
      const auto ayyyyyz_0 = current_data[361];
      const auto axxxxzz_0 = current_data[365];
      const auto axxxyzz_0 = current_data[366];
      const auto axxyyzz_0 = current_data[367];
      const auto axyyyzz_0 = current_data[368];
      const auto ayyyyzz_0 = current_data[369];
      const auto axxxzzz_0 = current_data[373];
      const auto axxyzzz_0 = current_data[374];
      const auto axyyzzz_0 = current_data[375];
      const auto ayyyzzz_0 = current_data[376];
      const auto axxzzzz_0 = current_data[380];
      const auto axyzzzz_0 = current_data[381];
      const auto ayyzzzz_0 = current_data[382];
      const auto axzzzzz_0 = current_data[386];
      const auto ayzzzzz_0 = current_data[387];
      const auto azzzzzz_0 = current_data[391];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[560] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[561] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[562] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[563] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[564] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[565] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[566] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[567] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[568] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[569] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[570] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[571] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[572] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[573] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[574] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[575] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[576] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[577] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[578] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[579] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[580] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[581] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[582] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[583] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[584] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[585] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[586] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[587] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyzzz
      const auto a0_0 = current_data[21];
      const auto ax_0 = current_data[52];
      const auto ay_0 = current_data[53];
      const auto az_0 = current_data[57];
      const auto axx_0 = current_data[91];
      const auto axy_0 = current_data[92];
      const auto ayy_0 = current_data[93];
      const auto axz_0 = current_data[97];
      const auto ayz_0 = current_data[98];
      const auto azz_0 = current_data[102];
      const auto axxx_0 = current_data[139];
      const auto axxy_0 = current_data[140];
      const auto axyy_0 = current_data[141];
      const auto ayyy_0 = current_data[142];
      const auto axxz_0 = current_data[146];
      const auto axyz_0 = current_data[147];
      const auto ayyz_0 = current_data[148];
      const auto axzz_0 = current_data[152];
      const auto ayzz_0 = current_data[153];
      const auto azzz_0 = current_data[157];
      const auto axxxx_0 = current_data[197];
      const auto axxxy_0 = current_data[198];
      const auto axxyy_0 = current_data[199];
      const auto axyyy_0 = current_data[200];
      const auto ayyyy_0 = current_data[201];
      const auto axxxz_0 = current_data[205];
      const auto axxyz_0 = current_data[206];
      const auto axyyz_0 = current_data[207];
      const auto ayyyz_0 = current_data[208];
      const auto axxzz_0 = current_data[212];
      const auto axyzz_0 = current_data[213];
      const auto ayyzz_0 = current_data[214];
      const auto axzzz_0 = current_data[218];
      const auto ayzzz_0 = current_data[219];
      const auto azzzz_0 = current_data[223];
      const auto axxxxx_0 = current_data[266];
      const auto axxxxy_0 = current_data[267];
      const auto axxxyy_0 = current_data[268];
      const auto axxyyy_0 = current_data[269];
      const auto axyyyy_0 = current_data[270];
      const auto ayyyyy_0 = current_data[271];
      const auto axxxxz_0 = current_data[275];
      const auto axxxyz_0 = current_data[276];
      const auto axxyyz_0 = current_data[277];
      const auto axyyyz_0 = current_data[278];
      const auto ayyyyz_0 = current_data[279];
      const auto axxxzz_0 = current_data[283];
      const auto axxyzz_0 = current_data[284];
      const auto axyyzz_0 = current_data[285];
      const auto ayyyzz_0 = current_data[286];
      const auto axxzzz_0 = current_data[290];
      const auto axyzzz_0 = current_data[291];
      const auto ayyzzz_0 = current_data[292];
      const auto axzzzz_0 = current_data[296];
      const auto ayzzzz_0 = current_data[297];
      const auto azzzzz_0 = current_data[301];
      const auto axxxxxx_0 = current_data[347];
      const auto axxxxxy_0 = current_data[348];
      const auto axxxxyy_0 = current_data[349];
      const auto axxxyyy_0 = current_data[350];
      const auto axxyyyy_0 = current_data[351];
      const auto axyyyyy_0 = current_data[352];
      const auto ayyyyyy_0 = current_data[353];
      const auto axxxxxz_0 = current_data[357];
      const auto axxxxyz_0 = current_data[358];
      const auto axxxyyz_0 = current_data[359];
      const auto axxyyyz_0 = current_data[360];
      const auto axyyyyz_0 = current_data[361];
      const auto ayyyyyz_0 = current_data[362];
      const auto axxxxzz_0 = current_data[366];
      const auto axxxyzz_0 = current_data[367];
      const auto axxyyzz_0 = current_data[368];
      const auto axyyyzz_0 = current_data[369];
      const auto ayyyyzz_0 = current_data[370];
      const auto axxxzzz_0 = current_data[374];
      const auto axxyzzz_0 = current_data[375];
      const auto axyyzzz_0 = current_data[376];
      const auto ayyyzzz_0 = current_data[377];
      const auto axxzzzz_0 = current_data[381];
      const auto axyzzzz_0 = current_data[382];
      const auto ayyzzzz_0 = current_data[383];
      const auto axzzzzz_0 = current_data[387];
      const auto ayzzzzz_0 = current_data[388];
      const auto azzzzzz_0 = current_data[392];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[588] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[589] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[590] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[591] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[592] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[593] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[594] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[595] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[596] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[597] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[598] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[599] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[600] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[601] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[602] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[603] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[604] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[605] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[606] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[607] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[608] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[609] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[610] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[611] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[612] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[613] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[614] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[615] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxzzzz
      const auto a0_0 = current_data[22];
      const auto ax_0 = current_data[54];
      const auto ay_0 = current_data[55];
      const auto az_0 = current_data[58];
      const auto axx_0 = current_data[94];
      const auto axy_0 = current_data[95];
      const auto ayy_0 = current_data[96];
      const auto axz_0 = current_data[99];
      const auto ayz_0 = current_data[100];
      const auto azz_0 = current_data[103];
      const auto axxx_0 = current_data[143];
      const auto axxy_0 = current_data[144];
      const auto axyy_0 = current_data[145];
      const auto ayyy_0 = current_data[146];
      const auto axxz_0 = current_data[149];
      const auto axyz_0 = current_data[150];
      const auto ayyz_0 = current_data[151];
      const auto axzz_0 = current_data[154];
      const auto ayzz_0 = current_data[155];
      const auto azzz_0 = current_data[158];
      const auto axxxx_0 = current_data[202];
      const auto axxxy_0 = current_data[203];
      const auto axxyy_0 = current_data[204];
      const auto axyyy_0 = current_data[205];
      const auto ayyyy_0 = current_data[206];
      const auto axxxz_0 = current_data[209];
      const auto axxyz_0 = current_data[210];
      const auto axyyz_0 = current_data[211];
      const auto ayyyz_0 = current_data[212];
      const auto axxzz_0 = current_data[215];
      const auto axyzz_0 = current_data[216];
      const auto ayyzz_0 = current_data[217];
      const auto axzzz_0 = current_data[220];
      const auto ayzzz_0 = current_data[221];
      const auto azzzz_0 = current_data[224];
      const auto axxxxx_0 = current_data[272];
      const auto axxxxy_0 = current_data[273];
      const auto axxxyy_0 = current_data[274];
      const auto axxyyy_0 = current_data[275];
      const auto axyyyy_0 = current_data[276];
      const auto ayyyyy_0 = current_data[277];
      const auto axxxxz_0 = current_data[280];
      const auto axxxyz_0 = current_data[281];
      const auto axxyyz_0 = current_data[282];
      const auto axyyyz_0 = current_data[283];
      const auto ayyyyz_0 = current_data[284];
      const auto axxxzz_0 = current_data[287];
      const auto axxyzz_0 = current_data[288];
      const auto axyyzz_0 = current_data[289];
      const auto ayyyzz_0 = current_data[290];
      const auto axxzzz_0 = current_data[293];
      const auto axyzzz_0 = current_data[294];
      const auto ayyzzz_0 = current_data[295];
      const auto axzzzz_0 = current_data[298];
      const auto ayzzzz_0 = current_data[299];
      const auto azzzzz_0 = current_data[302];
      const auto axxxxxx_0 = current_data[354];
      const auto axxxxxy_0 = current_data[355];
      const auto axxxxyy_0 = current_data[356];
      const auto axxxyyy_0 = current_data[357];
      const auto axxyyyy_0 = current_data[358];
      const auto axyyyyy_0 = current_data[359];
      const auto ayyyyyy_0 = current_data[360];
      const auto axxxxxz_0 = current_data[363];
      const auto axxxxyz_0 = current_data[364];
      const auto axxxyyz_0 = current_data[365];
      const auto axxyyyz_0 = current_data[366];
      const auto axyyyyz_0 = current_data[367];
      const auto ayyyyyz_0 = current_data[368];
      const auto axxxxzz_0 = current_data[371];
      const auto axxxyzz_0 = current_data[372];
      const auto axxyyzz_0 = current_data[373];
      const auto axyyyzz_0 = current_data[374];
      const auto ayyyyzz_0 = current_data[375];
      const auto axxxzzz_0 = current_data[378];
      const auto axxyzzz_0 = current_data[379];
      const auto axyyzzz_0 = current_data[380];
      const auto ayyyzzz_0 = current_data[381];
      const auto axxzzzz_0 = current_data[384];
      const auto axyzzzz_0 = current_data[385];
      const auto ayyzzzz_0 = current_data[386];
      const auto axzzzzz_0 = current_data[389];
      const auto ayzzzzz_0 = current_data[390];
      const auto azzzzzz_0 = current_data[393];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[616] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[617] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[618] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[619] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[620] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[621] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[622] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[623] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[624] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[625] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[626] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[627] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[628] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[629] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[630] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[631] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[632] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[633] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[634] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[635] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[636] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[637] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[638] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[639] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[640] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[641] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[642] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[643] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyzzzz
      const auto a0_0 = current_data[23];
      const auto ax_0 = current_data[55];
      const auto ay_0 = current_data[56];
      const auto az_0 = current_data[59];
      const auto axx_0 = current_data[95];
      const auto axy_0 = current_data[96];
      const auto ayy_0 = current_data[97];
      const auto axz_0 = current_data[100];
      const auto ayz_0 = current_data[101];
      const auto azz_0 = current_data[104];
      const auto axxx_0 = current_data[144];
      const auto axxy_0 = current_data[145];
      const auto axyy_0 = current_data[146];
      const auto ayyy_0 = current_data[147];
      const auto axxz_0 = current_data[150];
      const auto axyz_0 = current_data[151];
      const auto ayyz_0 = current_data[152];
      const auto axzz_0 = current_data[155];
      const auto ayzz_0 = current_data[156];
      const auto azzz_0 = current_data[159];
      const auto axxxx_0 = current_data[203];
      const auto axxxy_0 = current_data[204];
      const auto axxyy_0 = current_data[205];
      const auto axyyy_0 = current_data[206];
      const auto ayyyy_0 = current_data[207];
      const auto axxxz_0 = current_data[210];
      const auto axxyz_0 = current_data[211];
      const auto axyyz_0 = current_data[212];
      const auto ayyyz_0 = current_data[213];
      const auto axxzz_0 = current_data[216];
      const auto axyzz_0 = current_data[217];
      const auto ayyzz_0 = current_data[218];
      const auto axzzz_0 = current_data[221];
      const auto ayzzz_0 = current_data[222];
      const auto azzzz_0 = current_data[225];
      const auto axxxxx_0 = current_data[273];
      const auto axxxxy_0 = current_data[274];
      const auto axxxyy_0 = current_data[275];
      const auto axxyyy_0 = current_data[276];
      const auto axyyyy_0 = current_data[277];
      const auto ayyyyy_0 = current_data[278];
      const auto axxxxz_0 = current_data[281];
      const auto axxxyz_0 = current_data[282];
      const auto axxyyz_0 = current_data[283];
      const auto axyyyz_0 = current_data[284];
      const auto ayyyyz_0 = current_data[285];
      const auto axxxzz_0 = current_data[288];
      const auto axxyzz_0 = current_data[289];
      const auto axyyzz_0 = current_data[290];
      const auto ayyyzz_0 = current_data[291];
      const auto axxzzz_0 = current_data[294];
      const auto axyzzz_0 = current_data[295];
      const auto ayyzzz_0 = current_data[296];
      const auto axzzzz_0 = current_data[299];
      const auto ayzzzz_0 = current_data[300];
      const auto azzzzz_0 = current_data[303];
      const auto axxxxxx_0 = current_data[355];
      const auto axxxxxy_0 = current_data[356];
      const auto axxxxyy_0 = current_data[357];
      const auto axxxyyy_0 = current_data[358];
      const auto axxyyyy_0 = current_data[359];
      const auto axyyyyy_0 = current_data[360];
      const auto ayyyyyy_0 = current_data[361];
      const auto axxxxxz_0 = current_data[364];
      const auto axxxxyz_0 = current_data[365];
      const auto axxxyyz_0 = current_data[366];
      const auto axxyyyz_0 = current_data[367];
      const auto axyyyyz_0 = current_data[368];
      const auto ayyyyyz_0 = current_data[369];
      const auto axxxxzz_0 = current_data[372];
      const auto axxxyzz_0 = current_data[373];
      const auto axxyyzz_0 = current_data[374];
      const auto axyyyzz_0 = current_data[375];
      const auto ayyyyzz_0 = current_data[376];
      const auto axxxzzz_0 = current_data[379];
      const auto axxyzzz_0 = current_data[380];
      const auto axyyzzz_0 = current_data[381];
      const auto ayyyzzz_0 = current_data[382];
      const auto axxzzzz_0 = current_data[385];
      const auto axyzzzz_0 = current_data[386];
      const auto ayyzzzz_0 = current_data[387];
      const auto axzzzzz_0 = current_data[390];
      const auto ayzzzzz_0 = current_data[391];
      const auto azzzzzz_0 = current_data[394];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[644] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[645] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[646] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[647] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[648] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[649] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[650] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[651] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[652] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[653] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[654] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[655] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[656] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[657] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[658] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[659] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[660] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[661] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[662] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[663] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[664] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[665] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[666] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[667] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[668] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[669] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[670] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[671] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyzzzz
      const auto a0_0 = current_data[24];
      const auto ax_0 = current_data[56];
      const auto ay_0 = current_data[57];
      const auto az_0 = current_data[60];
      const auto axx_0 = current_data[96];
      const auto axy_0 = current_data[97];
      const auto ayy_0 = current_data[98];
      const auto axz_0 = current_data[101];
      const auto ayz_0 = current_data[102];
      const auto azz_0 = current_data[105];
      const auto axxx_0 = current_data[145];
      const auto axxy_0 = current_data[146];
      const auto axyy_0 = current_data[147];
      const auto ayyy_0 = current_data[148];
      const auto axxz_0 = current_data[151];
      const auto axyz_0 = current_data[152];
      const auto ayyz_0 = current_data[153];
      const auto axzz_0 = current_data[156];
      const auto ayzz_0 = current_data[157];
      const auto azzz_0 = current_data[160];
      const auto axxxx_0 = current_data[204];
      const auto axxxy_0 = current_data[205];
      const auto axxyy_0 = current_data[206];
      const auto axyyy_0 = current_data[207];
      const auto ayyyy_0 = current_data[208];
      const auto axxxz_0 = current_data[211];
      const auto axxyz_0 = current_data[212];
      const auto axyyz_0 = current_data[213];
      const auto ayyyz_0 = current_data[214];
      const auto axxzz_0 = current_data[217];
      const auto axyzz_0 = current_data[218];
      const auto ayyzz_0 = current_data[219];
      const auto axzzz_0 = current_data[222];
      const auto ayzzz_0 = current_data[223];
      const auto azzzz_0 = current_data[226];
      const auto axxxxx_0 = current_data[274];
      const auto axxxxy_0 = current_data[275];
      const auto axxxyy_0 = current_data[276];
      const auto axxyyy_0 = current_data[277];
      const auto axyyyy_0 = current_data[278];
      const auto ayyyyy_0 = current_data[279];
      const auto axxxxz_0 = current_data[282];
      const auto axxxyz_0 = current_data[283];
      const auto axxyyz_0 = current_data[284];
      const auto axyyyz_0 = current_data[285];
      const auto ayyyyz_0 = current_data[286];
      const auto axxxzz_0 = current_data[289];
      const auto axxyzz_0 = current_data[290];
      const auto axyyzz_0 = current_data[291];
      const auto ayyyzz_0 = current_data[292];
      const auto axxzzz_0 = current_data[295];
      const auto axyzzz_0 = current_data[296];
      const auto ayyzzz_0 = current_data[297];
      const auto axzzzz_0 = current_data[300];
      const auto ayzzzz_0 = current_data[301];
      const auto azzzzz_0 = current_data[304];
      const auto axxxxxx_0 = current_data[356];
      const auto axxxxxy_0 = current_data[357];
      const auto axxxxyy_0 = current_data[358];
      const auto axxxyyy_0 = current_data[359];
      const auto axxyyyy_0 = current_data[360];
      const auto axyyyyy_0 = current_data[361];
      const auto ayyyyyy_0 = current_data[362];
      const auto axxxxxz_0 = current_data[365];
      const auto axxxxyz_0 = current_data[366];
      const auto axxxyyz_0 = current_data[367];
      const auto axxyyyz_0 = current_data[368];
      const auto axyyyyz_0 = current_data[369];
      const auto ayyyyyz_0 = current_data[370];
      const auto axxxxzz_0 = current_data[373];
      const auto axxxyzz_0 = current_data[374];
      const auto axxyyzz_0 = current_data[375];
      const auto axyyyzz_0 = current_data[376];
      const auto ayyyyzz_0 = current_data[377];
      const auto axxxzzz_0 = current_data[380];
      const auto axxyzzz_0 = current_data[381];
      const auto axyyzzz_0 = current_data[382];
      const auto ayyyzzz_0 = current_data[383];
      const auto axxzzzz_0 = current_data[386];
      const auto axyzzzz_0 = current_data[387];
      const auto ayyzzzz_0 = current_data[388];
      const auto axzzzzz_0 = current_data[391];
      const auto ayzzzzz_0 = current_data[392];
      const auto azzzzzz_0 = current_data[395];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[672] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[673] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[674] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[675] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[676] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[677] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[678] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[679] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[680] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[681] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[682] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[683] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[684] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[685] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[686] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[687] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[688] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[689] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[690] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[691] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[692] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[693] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[694] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[695] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[696] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[697] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[698] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[699] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xzzzzz
      const auto a0_0 = current_data[25];
      const auto ax_0 = current_data[58];
      const auto ay_0 = current_data[59];
      const auto az_0 = current_data[61];
      const auto axx_0 = current_data[99];
      const auto axy_0 = current_data[100];
      const auto ayy_0 = current_data[101];
      const auto axz_0 = current_data[103];
      const auto ayz_0 = current_data[104];
      const auto azz_0 = current_data[106];
      const auto axxx_0 = current_data[149];
      const auto axxy_0 = current_data[150];
      const auto axyy_0 = current_data[151];
      const auto ayyy_0 = current_data[152];
      const auto axxz_0 = current_data[154];
      const auto axyz_0 = current_data[155];
      const auto ayyz_0 = current_data[156];
      const auto axzz_0 = current_data[158];
      const auto ayzz_0 = current_data[159];
      const auto azzz_0 = current_data[161];
      const auto axxxx_0 = current_data[209];
      const auto axxxy_0 = current_data[210];
      const auto axxyy_0 = current_data[211];
      const auto axyyy_0 = current_data[212];
      const auto ayyyy_0 = current_data[213];
      const auto axxxz_0 = current_data[215];
      const auto axxyz_0 = current_data[216];
      const auto axyyz_0 = current_data[217];
      const auto ayyyz_0 = current_data[218];
      const auto axxzz_0 = current_data[220];
      const auto axyzz_0 = current_data[221];
      const auto ayyzz_0 = current_data[222];
      const auto axzzz_0 = current_data[224];
      const auto ayzzz_0 = current_data[225];
      const auto azzzz_0 = current_data[227];
      const auto axxxxx_0 = current_data[280];
      const auto axxxxy_0 = current_data[281];
      const auto axxxyy_0 = current_data[282];
      const auto axxyyy_0 = current_data[283];
      const auto axyyyy_0 = current_data[284];
      const auto ayyyyy_0 = current_data[285];
      const auto axxxxz_0 = current_data[287];
      const auto axxxyz_0 = current_data[288];
      const auto axxyyz_0 = current_data[289];
      const auto axyyyz_0 = current_data[290];
      const auto ayyyyz_0 = current_data[291];
      const auto axxxzz_0 = current_data[293];
      const auto axxyzz_0 = current_data[294];
      const auto axyyzz_0 = current_data[295];
      const auto ayyyzz_0 = current_data[296];
      const auto axxzzz_0 = current_data[298];
      const auto axyzzz_0 = current_data[299];
      const auto ayyzzz_0 = current_data[300];
      const auto axzzzz_0 = current_data[302];
      const auto ayzzzz_0 = current_data[303];
      const auto azzzzz_0 = current_data[305];
      const auto axxxxxx_0 = current_data[363];
      const auto axxxxxy_0 = current_data[364];
      const auto axxxxyy_0 = current_data[365];
      const auto axxxyyy_0 = current_data[366];
      const auto axxyyyy_0 = current_data[367];
      const auto axyyyyy_0 = current_data[368];
      const auto ayyyyyy_0 = current_data[369];
      const auto axxxxxz_0 = current_data[371];
      const auto axxxxyz_0 = current_data[372];
      const auto axxxyyz_0 = current_data[373];
      const auto axxyyyz_0 = current_data[374];
      const auto axyyyyz_0 = current_data[375];
      const auto ayyyyyz_0 = current_data[376];
      const auto axxxxzz_0 = current_data[378];
      const auto axxxyzz_0 = current_data[379];
      const auto axxyyzz_0 = current_data[380];
      const auto axyyyzz_0 = current_data[381];
      const auto ayyyyzz_0 = current_data[382];
      const auto axxxzzz_0 = current_data[384];
      const auto axxyzzz_0 = current_data[385];
      const auto axyyzzz_0 = current_data[386];
      const auto ayyyzzz_0 = current_data[387];
      const auto axxzzzz_0 = current_data[389];
      const auto axyzzzz_0 = current_data[390];
      const auto ayyzzzz_0 = current_data[391];
      const auto axzzzzz_0 = current_data[393];
      const auto ayzzzzz_0 = current_data[394];
      const auto azzzzzz_0 = current_data[396];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[700] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[701] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[702] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[703] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[704] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[705] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[706] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[707] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[708] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[709] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[710] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[711] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[712] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[713] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[714] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[715] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[716] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[717] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[718] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[719] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[720] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[721] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[722] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[723] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[724] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[725] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[726] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[727] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yzzzzz
      const auto a0_0 = current_data[26];
      const auto ax_0 = current_data[59];
      const auto ay_0 = current_data[60];
      const auto az_0 = current_data[62];
      const auto axx_0 = current_data[100];
      const auto axy_0 = current_data[101];
      const auto ayy_0 = current_data[102];
      const auto axz_0 = current_data[104];
      const auto ayz_0 = current_data[105];
      const auto azz_0 = current_data[107];
      const auto axxx_0 = current_data[150];
      const auto axxy_0 = current_data[151];
      const auto axyy_0 = current_data[152];
      const auto ayyy_0 = current_data[153];
      const auto axxz_0 = current_data[155];
      const auto axyz_0 = current_data[156];
      const auto ayyz_0 = current_data[157];
      const auto axzz_0 = current_data[159];
      const auto ayzz_0 = current_data[160];
      const auto azzz_0 = current_data[162];
      const auto axxxx_0 = current_data[210];
      const auto axxxy_0 = current_data[211];
      const auto axxyy_0 = current_data[212];
      const auto axyyy_0 = current_data[213];
      const auto ayyyy_0 = current_data[214];
      const auto axxxz_0 = current_data[216];
      const auto axxyz_0 = current_data[217];
      const auto axyyz_0 = current_data[218];
      const auto ayyyz_0 = current_data[219];
      const auto axxzz_0 = current_data[221];
      const auto axyzz_0 = current_data[222];
      const auto ayyzz_0 = current_data[223];
      const auto axzzz_0 = current_data[225];
      const auto ayzzz_0 = current_data[226];
      const auto azzzz_0 = current_data[228];
      const auto axxxxx_0 = current_data[281];
      const auto axxxxy_0 = current_data[282];
      const auto axxxyy_0 = current_data[283];
      const auto axxyyy_0 = current_data[284];
      const auto axyyyy_0 = current_data[285];
      const auto ayyyyy_0 = current_data[286];
      const auto axxxxz_0 = current_data[288];
      const auto axxxyz_0 = current_data[289];
      const auto axxyyz_0 = current_data[290];
      const auto axyyyz_0 = current_data[291];
      const auto ayyyyz_0 = current_data[292];
      const auto axxxzz_0 = current_data[294];
      const auto axxyzz_0 = current_data[295];
      const auto axyyzz_0 = current_data[296];
      const auto ayyyzz_0 = current_data[297];
      const auto axxzzz_0 = current_data[299];
      const auto axyzzz_0 = current_data[300];
      const auto ayyzzz_0 = current_data[301];
      const auto axzzzz_0 = current_data[303];
      const auto ayzzzz_0 = current_data[304];
      const auto azzzzz_0 = current_data[306];
      const auto axxxxxx_0 = current_data[364];
      const auto axxxxxy_0 = current_data[365];
      const auto axxxxyy_0 = current_data[366];
      const auto axxxyyy_0 = current_data[367];
      const auto axxyyyy_0 = current_data[368];
      const auto axyyyyy_0 = current_data[369];
      const auto ayyyyyy_0 = current_data[370];
      const auto axxxxxz_0 = current_data[372];
      const auto axxxxyz_0 = current_data[373];
      const auto axxxyyz_0 = current_data[374];
      const auto axxyyyz_0 = current_data[375];
      const auto axyyyyz_0 = current_data[376];
      const auto ayyyyyz_0 = current_data[377];
      const auto axxxxzz_0 = current_data[379];
      const auto axxxyzz_0 = current_data[380];
      const auto axxyyzz_0 = current_data[381];
      const auto axyyyzz_0 = current_data[382];
      const auto ayyyyzz_0 = current_data[383];
      const auto axxxzzz_0 = current_data[385];
      const auto axxyzzz_0 = current_data[386];
      const auto axyyzzz_0 = current_data[387];
      const auto ayyyzzz_0 = current_data[388];
      const auto axxzzzz_0 = current_data[390];
      const auto axyzzzz_0 = current_data[391];
      const auto ayyzzzz_0 = current_data[392];
      const auto axzzzzz_0 = current_data[394];
      const auto ayzzzzz_0 = current_data[395];
      const auto azzzzzz_0 = current_data[397];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[728] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[729] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[730] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[731] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[732] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[733] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[734] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[735] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[736] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[737] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[738] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[739] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[740] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[741] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[742] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[743] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[744] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[745] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[746] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[747] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[748] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[749] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[750] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[751] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[752] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[753] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[754] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[755] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: zzzzzz
      const auto a0_0 = current_data[27];
      const auto ax_0 = current_data[61];
      const auto ay_0 = current_data[62];
      const auto az_0 = current_data[63];
      const auto axx_0 = current_data[103];
      const auto axy_0 = current_data[104];
      const auto ayy_0 = current_data[105];
      const auto axz_0 = current_data[106];
      const auto ayz_0 = current_data[107];
      const auto azz_0 = current_data[108];
      const auto axxx_0 = current_data[154];
      const auto axxy_0 = current_data[155];
      const auto axyy_0 = current_data[156];
      const auto ayyy_0 = current_data[157];
      const auto axxz_0 = current_data[158];
      const auto axyz_0 = current_data[159];
      const auto ayyz_0 = current_data[160];
      const auto axzz_0 = current_data[161];
      const auto ayzz_0 = current_data[162];
      const auto azzz_0 = current_data[163];
      const auto axxxx_0 = current_data[215];
      const auto axxxy_0 = current_data[216];
      const auto axxyy_0 = current_data[217];
      const auto axyyy_0 = current_data[218];
      const auto ayyyy_0 = current_data[219];
      const auto axxxz_0 = current_data[220];
      const auto axxyz_0 = current_data[221];
      const auto axyyz_0 = current_data[222];
      const auto ayyyz_0 = current_data[223];
      const auto axxzz_0 = current_data[224];
      const auto axyzz_0 = current_data[225];
      const auto ayyzz_0 = current_data[226];
      const auto axzzz_0 = current_data[227];
      const auto ayzzz_0 = current_data[228];
      const auto azzzz_0 = current_data[229];
      const auto axxxxx_0 = current_data[287];
      const auto axxxxy_0 = current_data[288];
      const auto axxxyy_0 = current_data[289];
      const auto axxyyy_0 = current_data[290];
      const auto axyyyy_0 = current_data[291];
      const auto ayyyyy_0 = current_data[292];
      const auto axxxxz_0 = current_data[293];
      const auto axxxyz_0 = current_data[294];
      const auto axxyyz_0 = current_data[295];
      const auto axyyyz_0 = current_data[296];
      const auto ayyyyz_0 = current_data[297];
      const auto axxxzz_0 = current_data[298];
      const auto axxyzz_0 = current_data[299];
      const auto axyyzz_0 = current_data[300];
      const auto ayyyzz_0 = current_data[301];
      const auto axxzzz_0 = current_data[302];
      const auto axyzzz_0 = current_data[303];
      const auto ayyzzz_0 = current_data[304];
      const auto axzzzz_0 = current_data[305];
      const auto ayzzzz_0 = current_data[306];
      const auto azzzzz_0 = current_data[307];
      const auto axxxxxx_0 = current_data[371];
      const auto axxxxxy_0 = current_data[372];
      const auto axxxxyy_0 = current_data[373];
      const auto axxxyyy_0 = current_data[374];
      const auto axxyyyy_0 = current_data[375];
      const auto axyyyyy_0 = current_data[376];
      const auto ayyyyyy_0 = current_data[377];
      const auto axxxxxz_0 = current_data[378];
      const auto axxxxyz_0 = current_data[379];
      const auto axxxyyz_0 = current_data[380];
      const auto axxyyyz_0 = current_data[381];
      const auto axyyyyz_0 = current_data[382];
      const auto ayyyyyz_0 = current_data[383];
      const auto axxxxzz_0 = current_data[384];
      const auto axxxyzz_0 = current_data[385];
      const auto axxyyzz_0 = current_data[386];
      const auto axyyyzz_0 = current_data[387];
      const auto ayyyyzz_0 = current_data[388];
      const auto axxxzzz_0 = current_data[389];
      const auto axxyzzz_0 = current_data[390];
      const auto axyyzzz_0 = current_data[391];
      const auto ayyyzzz_0 = current_data[392];
      const auto axxzzzz_0 = current_data[393];
      const auto axyzzzz_0 = current_data[394];
      const auto ayyzzzz_0 = current_data[395];
      const auto axzzzzz_0 = current_data[396];
      const auto ayzzzzz_0 = current_data[397];
      const auto azzzzzz_0 = current_data[398];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[756] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[757] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[758] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[759] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[760] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[761] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[762] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[763] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[764] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[765] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[766] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[767] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[768] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[769] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[770] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[771] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[772] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[773] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[774] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[775] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[776] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[777] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[778] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[779] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[780] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[781] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[782] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[783] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
  }
}


void CHRRList::perform_HRR_c0_66(const int nloop, const complex<double>* data_start, const array<double,3>& AB, complex<double>* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 399];
    auto current_out = &data_out[c * 784];
   {
     //current index a: xxxxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[28];
      const auto ay_0 = current_data[29];
      const auto az_0 = current_data[36];
      const auto axx_0 = current_data[64];
      const auto axy_0 = current_data[65];
      const auto ayy_0 = current_data[66];
      const auto axz_0 = current_data[73];
      const auto ayz_0 = current_data[74];
      const auto azz_0 = current_data[81];
      const auto axxx_0 = current_data[109];
      const auto axxy_0 = current_data[110];
      const auto axyy_0 = current_data[111];
      const auto ayyy_0 = current_data[112];
      const auto axxz_0 = current_data[119];
      const auto axyz_0 = current_data[120];
      const auto ayyz_0 = current_data[121];
      const auto axzz_0 = current_data[128];
      const auto ayzz_0 = current_data[129];
      const auto azzz_0 = current_data[136];
      const auto axxxx_0 = current_data[164];
      const auto axxxy_0 = current_data[165];
      const auto axxyy_0 = current_data[166];
      const auto axyyy_0 = current_data[167];
      const auto ayyyy_0 = current_data[168];
      const auto axxxz_0 = current_data[175];
      const auto axxyz_0 = current_data[176];
      const auto axyyz_0 = current_data[177];
      const auto ayyyz_0 = current_data[178];
      const auto axxzz_0 = current_data[185];
      const auto axyzz_0 = current_data[186];
      const auto ayyzz_0 = current_data[187];
      const auto axzzz_0 = current_data[194];
      const auto ayzzz_0 = current_data[195];
      const auto azzzz_0 = current_data[202];
      const auto axxxxx_0 = current_data[230];
      const auto axxxxy_0 = current_data[231];
      const auto axxxyy_0 = current_data[232];
      const auto axxyyy_0 = current_data[233];
      const auto axyyyy_0 = current_data[234];
      const auto ayyyyy_0 = current_data[235];
      const auto axxxxz_0 = current_data[242];
      const auto axxxyz_0 = current_data[243];
      const auto axxyyz_0 = current_data[244];
      const auto axyyyz_0 = current_data[245];
      const auto ayyyyz_0 = current_data[246];
      const auto axxxzz_0 = current_data[253];
      const auto axxyzz_0 = current_data[254];
      const auto axyyzz_0 = current_data[255];
      const auto ayyyzz_0 = current_data[256];
      const auto axxzzz_0 = current_data[263];
      const auto axyzzz_0 = current_data[264];
      const auto ayyzzz_0 = current_data[265];
      const auto axzzzz_0 = current_data[272];
      const auto ayzzzz_0 = current_data[273];
      const auto azzzzz_0 = current_data[280];
      const auto axxxxxx_0 = current_data[308];
      const auto axxxxxy_0 = current_data[309];
      const auto axxxxyy_0 = current_data[310];
      const auto axxxyyy_0 = current_data[311];
      const auto axxyyyy_0 = current_data[312];
      const auto axyyyyy_0 = current_data[313];
      const auto ayyyyyy_0 = current_data[314];
      const auto axxxxxz_0 = current_data[321];
      const auto axxxxyz_0 = current_data[322];
      const auto axxxyyz_0 = current_data[323];
      const auto axxyyyz_0 = current_data[324];
      const auto axyyyyz_0 = current_data[325];
      const auto ayyyyyz_0 = current_data[326];
      const auto axxxxzz_0 = current_data[333];
      const auto axxxyzz_0 = current_data[334];
      const auto axxyyzz_0 = current_data[335];
      const auto axyyyzz_0 = current_data[336];
      const auto ayyyyzz_0 = current_data[337];
      const auto axxxzzz_0 = current_data[344];
      const auto axxyzzz_0 = current_data[345];
      const auto axyyzzz_0 = current_data[346];
      const auto ayyyzzz_0 = current_data[347];
      const auto axxzzzz_0 = current_data[354];
      const auto axyzzzz_0 = current_data[355];
      const auto ayyzzzz_0 = current_data[356];
      const auto axzzzzz_0 = current_data[363];
      const auto ayzzzzz_0 = current_data[364];
      const auto azzzzzz_0 = current_data[371];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[0] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[1] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[2] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[3] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[4] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[5] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[6] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[7] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[8] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[9] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[10] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[11] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[12] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[13] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[14] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[15] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[16] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[17] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[18] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[19] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[20] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[21] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[22] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[23] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[24] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[25] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[26] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[27] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[29];
      const auto ay_0 = current_data[30];
      const auto az_0 = current_data[37];
      const auto axx_0 = current_data[65];
      const auto axy_0 = current_data[66];
      const auto ayy_0 = current_data[67];
      const auto axz_0 = current_data[74];
      const auto ayz_0 = current_data[75];
      const auto azz_0 = current_data[82];
      const auto axxx_0 = current_data[110];
      const auto axxy_0 = current_data[111];
      const auto axyy_0 = current_data[112];
      const auto ayyy_0 = current_data[113];
      const auto axxz_0 = current_data[120];
      const auto axyz_0 = current_data[121];
      const auto ayyz_0 = current_data[122];
      const auto axzz_0 = current_data[129];
      const auto ayzz_0 = current_data[130];
      const auto azzz_0 = current_data[137];
      const auto axxxx_0 = current_data[165];
      const auto axxxy_0 = current_data[166];
      const auto axxyy_0 = current_data[167];
      const auto axyyy_0 = current_data[168];
      const auto ayyyy_0 = current_data[169];
      const auto axxxz_0 = current_data[176];
      const auto axxyz_0 = current_data[177];
      const auto axyyz_0 = current_data[178];
      const auto ayyyz_0 = current_data[179];
      const auto axxzz_0 = current_data[186];
      const auto axyzz_0 = current_data[187];
      const auto ayyzz_0 = current_data[188];
      const auto axzzz_0 = current_data[195];
      const auto ayzzz_0 = current_data[196];
      const auto azzzz_0 = current_data[203];
      const auto axxxxx_0 = current_data[231];
      const auto axxxxy_0 = current_data[232];
      const auto axxxyy_0 = current_data[233];
      const auto axxyyy_0 = current_data[234];
      const auto axyyyy_0 = current_data[235];
      const auto ayyyyy_0 = current_data[236];
      const auto axxxxz_0 = current_data[243];
      const auto axxxyz_0 = current_data[244];
      const auto axxyyz_0 = current_data[245];
      const auto axyyyz_0 = current_data[246];
      const auto ayyyyz_0 = current_data[247];
      const auto axxxzz_0 = current_data[254];
      const auto axxyzz_0 = current_data[255];
      const auto axyyzz_0 = current_data[256];
      const auto ayyyzz_0 = current_data[257];
      const auto axxzzz_0 = current_data[264];
      const auto axyzzz_0 = current_data[265];
      const auto ayyzzz_0 = current_data[266];
      const auto axzzzz_0 = current_data[273];
      const auto ayzzzz_0 = current_data[274];
      const auto azzzzz_0 = current_data[281];
      const auto axxxxxx_0 = current_data[309];
      const auto axxxxxy_0 = current_data[310];
      const auto axxxxyy_0 = current_data[311];
      const auto axxxyyy_0 = current_data[312];
      const auto axxyyyy_0 = current_data[313];
      const auto axyyyyy_0 = current_data[314];
      const auto ayyyyyy_0 = current_data[315];
      const auto axxxxxz_0 = current_data[322];
      const auto axxxxyz_0 = current_data[323];
      const auto axxxyyz_0 = current_data[324];
      const auto axxyyyz_0 = current_data[325];
      const auto axyyyyz_0 = current_data[326];
      const auto ayyyyyz_0 = current_data[327];
      const auto axxxxzz_0 = current_data[334];
      const auto axxxyzz_0 = current_data[335];
      const auto axxyyzz_0 = current_data[336];
      const auto axyyyzz_0 = current_data[337];
      const auto ayyyyzz_0 = current_data[338];
      const auto axxxzzz_0 = current_data[345];
      const auto axxyzzz_0 = current_data[346];
      const auto axyyzzz_0 = current_data[347];
      const auto ayyyzzz_0 = current_data[348];
      const auto axxzzzz_0 = current_data[355];
      const auto axyzzzz_0 = current_data[356];
      const auto ayyzzzz_0 = current_data[357];
      const auto axzzzzz_0 = current_data[364];
      const auto ayzzzzz_0 = current_data[365];
      const auto azzzzzz_0 = current_data[372];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[28] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[29] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[30] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[31] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[32] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[33] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[34] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[35] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[36] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[37] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[38] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[39] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[40] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[41] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[42] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[43] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[44] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[45] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[46] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[47] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[48] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[49] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[50] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[51] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[52] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[53] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[54] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[55] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[30];
      const auto ay_0 = current_data[31];
      const auto az_0 = current_data[38];
      const auto axx_0 = current_data[66];
      const auto axy_0 = current_data[67];
      const auto ayy_0 = current_data[68];
      const auto axz_0 = current_data[75];
      const auto ayz_0 = current_data[76];
      const auto azz_0 = current_data[83];
      const auto axxx_0 = current_data[111];
      const auto axxy_0 = current_data[112];
      const auto axyy_0 = current_data[113];
      const auto ayyy_0 = current_data[114];
      const auto axxz_0 = current_data[121];
      const auto axyz_0 = current_data[122];
      const auto ayyz_0 = current_data[123];
      const auto axzz_0 = current_data[130];
      const auto ayzz_0 = current_data[131];
      const auto azzz_0 = current_data[138];
      const auto axxxx_0 = current_data[166];
      const auto axxxy_0 = current_data[167];
      const auto axxyy_0 = current_data[168];
      const auto axyyy_0 = current_data[169];
      const auto ayyyy_0 = current_data[170];
      const auto axxxz_0 = current_data[177];
      const auto axxyz_0 = current_data[178];
      const auto axyyz_0 = current_data[179];
      const auto ayyyz_0 = current_data[180];
      const auto axxzz_0 = current_data[187];
      const auto axyzz_0 = current_data[188];
      const auto ayyzz_0 = current_data[189];
      const auto axzzz_0 = current_data[196];
      const auto ayzzz_0 = current_data[197];
      const auto azzzz_0 = current_data[204];
      const auto axxxxx_0 = current_data[232];
      const auto axxxxy_0 = current_data[233];
      const auto axxxyy_0 = current_data[234];
      const auto axxyyy_0 = current_data[235];
      const auto axyyyy_0 = current_data[236];
      const auto ayyyyy_0 = current_data[237];
      const auto axxxxz_0 = current_data[244];
      const auto axxxyz_0 = current_data[245];
      const auto axxyyz_0 = current_data[246];
      const auto axyyyz_0 = current_data[247];
      const auto ayyyyz_0 = current_data[248];
      const auto axxxzz_0 = current_data[255];
      const auto axxyzz_0 = current_data[256];
      const auto axyyzz_0 = current_data[257];
      const auto ayyyzz_0 = current_data[258];
      const auto axxzzz_0 = current_data[265];
      const auto axyzzz_0 = current_data[266];
      const auto ayyzzz_0 = current_data[267];
      const auto axzzzz_0 = current_data[274];
      const auto ayzzzz_0 = current_data[275];
      const auto azzzzz_0 = current_data[282];
      const auto axxxxxx_0 = current_data[310];
      const auto axxxxxy_0 = current_data[311];
      const auto axxxxyy_0 = current_data[312];
      const auto axxxyyy_0 = current_data[313];
      const auto axxyyyy_0 = current_data[314];
      const auto axyyyyy_0 = current_data[315];
      const auto ayyyyyy_0 = current_data[316];
      const auto axxxxxz_0 = current_data[323];
      const auto axxxxyz_0 = current_data[324];
      const auto axxxyyz_0 = current_data[325];
      const auto axxyyyz_0 = current_data[326];
      const auto axyyyyz_0 = current_data[327];
      const auto ayyyyyz_0 = current_data[328];
      const auto axxxxzz_0 = current_data[335];
      const auto axxxyzz_0 = current_data[336];
      const auto axxyyzz_0 = current_data[337];
      const auto axyyyzz_0 = current_data[338];
      const auto ayyyyzz_0 = current_data[339];
      const auto axxxzzz_0 = current_data[346];
      const auto axxyzzz_0 = current_data[347];
      const auto axyyzzz_0 = current_data[348];
      const auto ayyyzzz_0 = current_data[349];
      const auto axxzzzz_0 = current_data[356];
      const auto axyzzzz_0 = current_data[357];
      const auto ayyzzzz_0 = current_data[358];
      const auto axzzzzz_0 = current_data[365];
      const auto ayzzzzz_0 = current_data[366];
      const auto azzzzzz_0 = current_data[373];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[56] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[57] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[58] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[59] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[60] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[61] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[62] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[63] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[64] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[65] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[66] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[67] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[68] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[69] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[70] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[71] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[72] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[73] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[74] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[75] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[76] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[77] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[78] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[79] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[80] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[81] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[82] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[83] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[31];
      const auto ay_0 = current_data[32];
      const auto az_0 = current_data[39];
      const auto axx_0 = current_data[67];
      const auto axy_0 = current_data[68];
      const auto ayy_0 = current_data[69];
      const auto axz_0 = current_data[76];
      const auto ayz_0 = current_data[77];
      const auto azz_0 = current_data[84];
      const auto axxx_0 = current_data[112];
      const auto axxy_0 = current_data[113];
      const auto axyy_0 = current_data[114];
      const auto ayyy_0 = current_data[115];
      const auto axxz_0 = current_data[122];
      const auto axyz_0 = current_data[123];
      const auto ayyz_0 = current_data[124];
      const auto axzz_0 = current_data[131];
      const auto ayzz_0 = current_data[132];
      const auto azzz_0 = current_data[139];
      const auto axxxx_0 = current_data[167];
      const auto axxxy_0 = current_data[168];
      const auto axxyy_0 = current_data[169];
      const auto axyyy_0 = current_data[170];
      const auto ayyyy_0 = current_data[171];
      const auto axxxz_0 = current_data[178];
      const auto axxyz_0 = current_data[179];
      const auto axyyz_0 = current_data[180];
      const auto ayyyz_0 = current_data[181];
      const auto axxzz_0 = current_data[188];
      const auto axyzz_0 = current_data[189];
      const auto ayyzz_0 = current_data[190];
      const auto axzzz_0 = current_data[197];
      const auto ayzzz_0 = current_data[198];
      const auto azzzz_0 = current_data[205];
      const auto axxxxx_0 = current_data[233];
      const auto axxxxy_0 = current_data[234];
      const auto axxxyy_0 = current_data[235];
      const auto axxyyy_0 = current_data[236];
      const auto axyyyy_0 = current_data[237];
      const auto ayyyyy_0 = current_data[238];
      const auto axxxxz_0 = current_data[245];
      const auto axxxyz_0 = current_data[246];
      const auto axxyyz_0 = current_data[247];
      const auto axyyyz_0 = current_data[248];
      const auto ayyyyz_0 = current_data[249];
      const auto axxxzz_0 = current_data[256];
      const auto axxyzz_0 = current_data[257];
      const auto axyyzz_0 = current_data[258];
      const auto ayyyzz_0 = current_data[259];
      const auto axxzzz_0 = current_data[266];
      const auto axyzzz_0 = current_data[267];
      const auto ayyzzz_0 = current_data[268];
      const auto axzzzz_0 = current_data[275];
      const auto ayzzzz_0 = current_data[276];
      const auto azzzzz_0 = current_data[283];
      const auto axxxxxx_0 = current_data[311];
      const auto axxxxxy_0 = current_data[312];
      const auto axxxxyy_0 = current_data[313];
      const auto axxxyyy_0 = current_data[314];
      const auto axxyyyy_0 = current_data[315];
      const auto axyyyyy_0 = current_data[316];
      const auto ayyyyyy_0 = current_data[317];
      const auto axxxxxz_0 = current_data[324];
      const auto axxxxyz_0 = current_data[325];
      const auto axxxyyz_0 = current_data[326];
      const auto axxyyyz_0 = current_data[327];
      const auto axyyyyz_0 = current_data[328];
      const auto ayyyyyz_0 = current_data[329];
      const auto axxxxzz_0 = current_data[336];
      const auto axxxyzz_0 = current_data[337];
      const auto axxyyzz_0 = current_data[338];
      const auto axyyyzz_0 = current_data[339];
      const auto ayyyyzz_0 = current_data[340];
      const auto axxxzzz_0 = current_data[347];
      const auto axxyzzz_0 = current_data[348];
      const auto axyyzzz_0 = current_data[349];
      const auto ayyyzzz_0 = current_data[350];
      const auto axxzzzz_0 = current_data[357];
      const auto axyzzzz_0 = current_data[358];
      const auto ayyzzzz_0 = current_data[359];
      const auto axzzzzz_0 = current_data[366];
      const auto ayzzzzz_0 = current_data[367];
      const auto azzzzzz_0 = current_data[374];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[84] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[85] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[86] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[87] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[88] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[89] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[90] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[91] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[92] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[93] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[94] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[95] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[96] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[97] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[98] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[99] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[100] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[101] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[102] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[103] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[104] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[105] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[106] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[107] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[108] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[109] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[110] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[111] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[32];
      const auto ay_0 = current_data[33];
      const auto az_0 = current_data[40];
      const auto axx_0 = current_data[68];
      const auto axy_0 = current_data[69];
      const auto ayy_0 = current_data[70];
      const auto axz_0 = current_data[77];
      const auto ayz_0 = current_data[78];
      const auto azz_0 = current_data[85];
      const auto axxx_0 = current_data[113];
      const auto axxy_0 = current_data[114];
      const auto axyy_0 = current_data[115];
      const auto ayyy_0 = current_data[116];
      const auto axxz_0 = current_data[123];
      const auto axyz_0 = current_data[124];
      const auto ayyz_0 = current_data[125];
      const auto axzz_0 = current_data[132];
      const auto ayzz_0 = current_data[133];
      const auto azzz_0 = current_data[140];
      const auto axxxx_0 = current_data[168];
      const auto axxxy_0 = current_data[169];
      const auto axxyy_0 = current_data[170];
      const auto axyyy_0 = current_data[171];
      const auto ayyyy_0 = current_data[172];
      const auto axxxz_0 = current_data[179];
      const auto axxyz_0 = current_data[180];
      const auto axyyz_0 = current_data[181];
      const auto ayyyz_0 = current_data[182];
      const auto axxzz_0 = current_data[189];
      const auto axyzz_0 = current_data[190];
      const auto ayyzz_0 = current_data[191];
      const auto axzzz_0 = current_data[198];
      const auto ayzzz_0 = current_data[199];
      const auto azzzz_0 = current_data[206];
      const auto axxxxx_0 = current_data[234];
      const auto axxxxy_0 = current_data[235];
      const auto axxxyy_0 = current_data[236];
      const auto axxyyy_0 = current_data[237];
      const auto axyyyy_0 = current_data[238];
      const auto ayyyyy_0 = current_data[239];
      const auto axxxxz_0 = current_data[246];
      const auto axxxyz_0 = current_data[247];
      const auto axxyyz_0 = current_data[248];
      const auto axyyyz_0 = current_data[249];
      const auto ayyyyz_0 = current_data[250];
      const auto axxxzz_0 = current_data[257];
      const auto axxyzz_0 = current_data[258];
      const auto axyyzz_0 = current_data[259];
      const auto ayyyzz_0 = current_data[260];
      const auto axxzzz_0 = current_data[267];
      const auto axyzzz_0 = current_data[268];
      const auto ayyzzz_0 = current_data[269];
      const auto axzzzz_0 = current_data[276];
      const auto ayzzzz_0 = current_data[277];
      const auto azzzzz_0 = current_data[284];
      const auto axxxxxx_0 = current_data[312];
      const auto axxxxxy_0 = current_data[313];
      const auto axxxxyy_0 = current_data[314];
      const auto axxxyyy_0 = current_data[315];
      const auto axxyyyy_0 = current_data[316];
      const auto axyyyyy_0 = current_data[317];
      const auto ayyyyyy_0 = current_data[318];
      const auto axxxxxz_0 = current_data[325];
      const auto axxxxyz_0 = current_data[326];
      const auto axxxyyz_0 = current_data[327];
      const auto axxyyyz_0 = current_data[328];
      const auto axyyyyz_0 = current_data[329];
      const auto ayyyyyz_0 = current_data[330];
      const auto axxxxzz_0 = current_data[337];
      const auto axxxyzz_0 = current_data[338];
      const auto axxyyzz_0 = current_data[339];
      const auto axyyyzz_0 = current_data[340];
      const auto ayyyyzz_0 = current_data[341];
      const auto axxxzzz_0 = current_data[348];
      const auto axxyzzz_0 = current_data[349];
      const auto axyyzzz_0 = current_data[350];
      const auto ayyyzzz_0 = current_data[351];
      const auto axxzzzz_0 = current_data[358];
      const auto axyzzzz_0 = current_data[359];
      const auto ayyzzzz_0 = current_data[360];
      const auto axzzzzz_0 = current_data[367];
      const auto ayzzzzz_0 = current_data[368];
      const auto azzzzzz_0 = current_data[375];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[112] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[113] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[114] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[115] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[116] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[117] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[118] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[119] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[120] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[121] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[122] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[123] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[124] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[125] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[126] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[127] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[128] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[129] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[130] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[131] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[132] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[133] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[134] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[135] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[136] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[137] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[138] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[139] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyyyy
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[33];
      const auto ay_0 = current_data[34];
      const auto az_0 = current_data[41];
      const auto axx_0 = current_data[69];
      const auto axy_0 = current_data[70];
      const auto ayy_0 = current_data[71];
      const auto axz_0 = current_data[78];
      const auto ayz_0 = current_data[79];
      const auto azz_0 = current_data[86];
      const auto axxx_0 = current_data[114];
      const auto axxy_0 = current_data[115];
      const auto axyy_0 = current_data[116];
      const auto ayyy_0 = current_data[117];
      const auto axxz_0 = current_data[124];
      const auto axyz_0 = current_data[125];
      const auto ayyz_0 = current_data[126];
      const auto axzz_0 = current_data[133];
      const auto ayzz_0 = current_data[134];
      const auto azzz_0 = current_data[141];
      const auto axxxx_0 = current_data[169];
      const auto axxxy_0 = current_data[170];
      const auto axxyy_0 = current_data[171];
      const auto axyyy_0 = current_data[172];
      const auto ayyyy_0 = current_data[173];
      const auto axxxz_0 = current_data[180];
      const auto axxyz_0 = current_data[181];
      const auto axyyz_0 = current_data[182];
      const auto ayyyz_0 = current_data[183];
      const auto axxzz_0 = current_data[190];
      const auto axyzz_0 = current_data[191];
      const auto ayyzz_0 = current_data[192];
      const auto axzzz_0 = current_data[199];
      const auto ayzzz_0 = current_data[200];
      const auto azzzz_0 = current_data[207];
      const auto axxxxx_0 = current_data[235];
      const auto axxxxy_0 = current_data[236];
      const auto axxxyy_0 = current_data[237];
      const auto axxyyy_0 = current_data[238];
      const auto axyyyy_0 = current_data[239];
      const auto ayyyyy_0 = current_data[240];
      const auto axxxxz_0 = current_data[247];
      const auto axxxyz_0 = current_data[248];
      const auto axxyyz_0 = current_data[249];
      const auto axyyyz_0 = current_data[250];
      const auto ayyyyz_0 = current_data[251];
      const auto axxxzz_0 = current_data[258];
      const auto axxyzz_0 = current_data[259];
      const auto axyyzz_0 = current_data[260];
      const auto ayyyzz_0 = current_data[261];
      const auto axxzzz_0 = current_data[268];
      const auto axyzzz_0 = current_data[269];
      const auto ayyzzz_0 = current_data[270];
      const auto axzzzz_0 = current_data[277];
      const auto ayzzzz_0 = current_data[278];
      const auto azzzzz_0 = current_data[285];
      const auto axxxxxx_0 = current_data[313];
      const auto axxxxxy_0 = current_data[314];
      const auto axxxxyy_0 = current_data[315];
      const auto axxxyyy_0 = current_data[316];
      const auto axxyyyy_0 = current_data[317];
      const auto axyyyyy_0 = current_data[318];
      const auto ayyyyyy_0 = current_data[319];
      const auto axxxxxz_0 = current_data[326];
      const auto axxxxyz_0 = current_data[327];
      const auto axxxyyz_0 = current_data[328];
      const auto axxyyyz_0 = current_data[329];
      const auto axyyyyz_0 = current_data[330];
      const auto ayyyyyz_0 = current_data[331];
      const auto axxxxzz_0 = current_data[338];
      const auto axxxyzz_0 = current_data[339];
      const auto axxyyzz_0 = current_data[340];
      const auto axyyyzz_0 = current_data[341];
      const auto ayyyyzz_0 = current_data[342];
      const auto axxxzzz_0 = current_data[349];
      const auto axxyzzz_0 = current_data[350];
      const auto axyyzzz_0 = current_data[351];
      const auto ayyyzzz_0 = current_data[352];
      const auto axxzzzz_0 = current_data[359];
      const auto axyzzzz_0 = current_data[360];
      const auto ayyzzzz_0 = current_data[361];
      const auto axzzzzz_0 = current_data[368];
      const auto ayzzzzz_0 = current_data[369];
      const auto azzzzzz_0 = current_data[376];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[140] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[141] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[142] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[143] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[144] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[145] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[146] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[147] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[148] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[149] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[150] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[151] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[152] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[153] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[154] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[155] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[156] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[157] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[158] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[159] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[160] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[161] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[162] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[163] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[164] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[165] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[166] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[167] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyyyy
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[34];
      const auto ay_0 = current_data[35];
      const auto az_0 = current_data[42];
      const auto axx_0 = current_data[70];
      const auto axy_0 = current_data[71];
      const auto ayy_0 = current_data[72];
      const auto axz_0 = current_data[79];
      const auto ayz_0 = current_data[80];
      const auto azz_0 = current_data[87];
      const auto axxx_0 = current_data[115];
      const auto axxy_0 = current_data[116];
      const auto axyy_0 = current_data[117];
      const auto ayyy_0 = current_data[118];
      const auto axxz_0 = current_data[125];
      const auto axyz_0 = current_data[126];
      const auto ayyz_0 = current_data[127];
      const auto axzz_0 = current_data[134];
      const auto ayzz_0 = current_data[135];
      const auto azzz_0 = current_data[142];
      const auto axxxx_0 = current_data[170];
      const auto axxxy_0 = current_data[171];
      const auto axxyy_0 = current_data[172];
      const auto axyyy_0 = current_data[173];
      const auto ayyyy_0 = current_data[174];
      const auto axxxz_0 = current_data[181];
      const auto axxyz_0 = current_data[182];
      const auto axyyz_0 = current_data[183];
      const auto ayyyz_0 = current_data[184];
      const auto axxzz_0 = current_data[191];
      const auto axyzz_0 = current_data[192];
      const auto ayyzz_0 = current_data[193];
      const auto axzzz_0 = current_data[200];
      const auto ayzzz_0 = current_data[201];
      const auto azzzz_0 = current_data[208];
      const auto axxxxx_0 = current_data[236];
      const auto axxxxy_0 = current_data[237];
      const auto axxxyy_0 = current_data[238];
      const auto axxyyy_0 = current_data[239];
      const auto axyyyy_0 = current_data[240];
      const auto ayyyyy_0 = current_data[241];
      const auto axxxxz_0 = current_data[248];
      const auto axxxyz_0 = current_data[249];
      const auto axxyyz_0 = current_data[250];
      const auto axyyyz_0 = current_data[251];
      const auto ayyyyz_0 = current_data[252];
      const auto axxxzz_0 = current_data[259];
      const auto axxyzz_0 = current_data[260];
      const auto axyyzz_0 = current_data[261];
      const auto ayyyzz_0 = current_data[262];
      const auto axxzzz_0 = current_data[269];
      const auto axyzzz_0 = current_data[270];
      const auto ayyzzz_0 = current_data[271];
      const auto axzzzz_0 = current_data[278];
      const auto ayzzzz_0 = current_data[279];
      const auto azzzzz_0 = current_data[286];
      const auto axxxxxx_0 = current_data[314];
      const auto axxxxxy_0 = current_data[315];
      const auto axxxxyy_0 = current_data[316];
      const auto axxxyyy_0 = current_data[317];
      const auto axxyyyy_0 = current_data[318];
      const auto axyyyyy_0 = current_data[319];
      const auto ayyyyyy_0 = current_data[320];
      const auto axxxxxz_0 = current_data[327];
      const auto axxxxyz_0 = current_data[328];
      const auto axxxyyz_0 = current_data[329];
      const auto axxyyyz_0 = current_data[330];
      const auto axyyyyz_0 = current_data[331];
      const auto ayyyyyz_0 = current_data[332];
      const auto axxxxzz_0 = current_data[339];
      const auto axxxyzz_0 = current_data[340];
      const auto axxyyzz_0 = current_data[341];
      const auto axyyyzz_0 = current_data[342];
      const auto ayyyyzz_0 = current_data[343];
      const auto axxxzzz_0 = current_data[350];
      const auto axxyzzz_0 = current_data[351];
      const auto axyyzzz_0 = current_data[352];
      const auto ayyyzzz_0 = current_data[353];
      const auto axxzzzz_0 = current_data[360];
      const auto axyzzzz_0 = current_data[361];
      const auto ayyzzzz_0 = current_data[362];
      const auto axzzzzz_0 = current_data[369];
      const auto ayzzzzz_0 = current_data[370];
      const auto azzzzzz_0 = current_data[377];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[168] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[169] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[170] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[171] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[172] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[173] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[174] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[175] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[176] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[177] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[178] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[179] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[180] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[181] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[182] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[183] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[184] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[185] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[186] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[187] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[188] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[189] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[190] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[191] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[192] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[193] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[194] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[195] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxz
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[36];
      const auto ay_0 = current_data[37];
      const auto az_0 = current_data[43];
      const auto axx_0 = current_data[73];
      const auto axy_0 = current_data[74];
      const auto ayy_0 = current_data[75];
      const auto axz_0 = current_data[81];
      const auto ayz_0 = current_data[82];
      const auto azz_0 = current_data[88];
      const auto axxx_0 = current_data[119];
      const auto axxy_0 = current_data[120];
      const auto axyy_0 = current_data[121];
      const auto ayyy_0 = current_data[122];
      const auto axxz_0 = current_data[128];
      const auto axyz_0 = current_data[129];
      const auto ayyz_0 = current_data[130];
      const auto axzz_0 = current_data[136];
      const auto ayzz_0 = current_data[137];
      const auto azzz_0 = current_data[143];
      const auto axxxx_0 = current_data[175];
      const auto axxxy_0 = current_data[176];
      const auto axxyy_0 = current_data[177];
      const auto axyyy_0 = current_data[178];
      const auto ayyyy_0 = current_data[179];
      const auto axxxz_0 = current_data[185];
      const auto axxyz_0 = current_data[186];
      const auto axyyz_0 = current_data[187];
      const auto ayyyz_0 = current_data[188];
      const auto axxzz_0 = current_data[194];
      const auto axyzz_0 = current_data[195];
      const auto ayyzz_0 = current_data[196];
      const auto axzzz_0 = current_data[202];
      const auto ayzzz_0 = current_data[203];
      const auto azzzz_0 = current_data[209];
      const auto axxxxx_0 = current_data[242];
      const auto axxxxy_0 = current_data[243];
      const auto axxxyy_0 = current_data[244];
      const auto axxyyy_0 = current_data[245];
      const auto axyyyy_0 = current_data[246];
      const auto ayyyyy_0 = current_data[247];
      const auto axxxxz_0 = current_data[253];
      const auto axxxyz_0 = current_data[254];
      const auto axxyyz_0 = current_data[255];
      const auto axyyyz_0 = current_data[256];
      const auto ayyyyz_0 = current_data[257];
      const auto axxxzz_0 = current_data[263];
      const auto axxyzz_0 = current_data[264];
      const auto axyyzz_0 = current_data[265];
      const auto ayyyzz_0 = current_data[266];
      const auto axxzzz_0 = current_data[272];
      const auto axyzzz_0 = current_data[273];
      const auto ayyzzz_0 = current_data[274];
      const auto axzzzz_0 = current_data[280];
      const auto ayzzzz_0 = current_data[281];
      const auto azzzzz_0 = current_data[287];
      const auto axxxxxx_0 = current_data[321];
      const auto axxxxxy_0 = current_data[322];
      const auto axxxxyy_0 = current_data[323];
      const auto axxxyyy_0 = current_data[324];
      const auto axxyyyy_0 = current_data[325];
      const auto axyyyyy_0 = current_data[326];
      const auto ayyyyyy_0 = current_data[327];
      const auto axxxxxz_0 = current_data[333];
      const auto axxxxyz_0 = current_data[334];
      const auto axxxyyz_0 = current_data[335];
      const auto axxyyyz_0 = current_data[336];
      const auto axyyyyz_0 = current_data[337];
      const auto ayyyyyz_0 = current_data[338];
      const auto axxxxzz_0 = current_data[344];
      const auto axxxyzz_0 = current_data[345];
      const auto axxyyzz_0 = current_data[346];
      const auto axyyyzz_0 = current_data[347];
      const auto ayyyyzz_0 = current_data[348];
      const auto axxxzzz_0 = current_data[354];
      const auto axxyzzz_0 = current_data[355];
      const auto axyyzzz_0 = current_data[356];
      const auto ayyyzzz_0 = current_data[357];
      const auto axxzzzz_0 = current_data[363];
      const auto axyzzzz_0 = current_data[364];
      const auto ayyzzzz_0 = current_data[365];
      const auto axzzzzz_0 = current_data[371];
      const auto ayzzzzz_0 = current_data[372];
      const auto azzzzzz_0 = current_data[378];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[196] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[197] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[198] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[199] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[200] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[201] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[202] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[203] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[204] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[205] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[206] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[207] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[208] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[209] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[210] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[211] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[212] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[213] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[214] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[215] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[216] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[217] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[218] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[219] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[220] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[221] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[222] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[223] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxyz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[37];
      const auto ay_0 = current_data[38];
      const auto az_0 = current_data[44];
      const auto axx_0 = current_data[74];
      const auto axy_0 = current_data[75];
      const auto ayy_0 = current_data[76];
      const auto axz_0 = current_data[82];
      const auto ayz_0 = current_data[83];
      const auto azz_0 = current_data[89];
      const auto axxx_0 = current_data[120];
      const auto axxy_0 = current_data[121];
      const auto axyy_0 = current_data[122];
      const auto ayyy_0 = current_data[123];
      const auto axxz_0 = current_data[129];
      const auto axyz_0 = current_data[130];
      const auto ayyz_0 = current_data[131];
      const auto axzz_0 = current_data[137];
      const auto ayzz_0 = current_data[138];
      const auto azzz_0 = current_data[144];
      const auto axxxx_0 = current_data[176];
      const auto axxxy_0 = current_data[177];
      const auto axxyy_0 = current_data[178];
      const auto axyyy_0 = current_data[179];
      const auto ayyyy_0 = current_data[180];
      const auto axxxz_0 = current_data[186];
      const auto axxyz_0 = current_data[187];
      const auto axyyz_0 = current_data[188];
      const auto ayyyz_0 = current_data[189];
      const auto axxzz_0 = current_data[195];
      const auto axyzz_0 = current_data[196];
      const auto ayyzz_0 = current_data[197];
      const auto axzzz_0 = current_data[203];
      const auto ayzzz_0 = current_data[204];
      const auto azzzz_0 = current_data[210];
      const auto axxxxx_0 = current_data[243];
      const auto axxxxy_0 = current_data[244];
      const auto axxxyy_0 = current_data[245];
      const auto axxyyy_0 = current_data[246];
      const auto axyyyy_0 = current_data[247];
      const auto ayyyyy_0 = current_data[248];
      const auto axxxxz_0 = current_data[254];
      const auto axxxyz_0 = current_data[255];
      const auto axxyyz_0 = current_data[256];
      const auto axyyyz_0 = current_data[257];
      const auto ayyyyz_0 = current_data[258];
      const auto axxxzz_0 = current_data[264];
      const auto axxyzz_0 = current_data[265];
      const auto axyyzz_0 = current_data[266];
      const auto ayyyzz_0 = current_data[267];
      const auto axxzzz_0 = current_data[273];
      const auto axyzzz_0 = current_data[274];
      const auto ayyzzz_0 = current_data[275];
      const auto axzzzz_0 = current_data[281];
      const auto ayzzzz_0 = current_data[282];
      const auto azzzzz_0 = current_data[288];
      const auto axxxxxx_0 = current_data[322];
      const auto axxxxxy_0 = current_data[323];
      const auto axxxxyy_0 = current_data[324];
      const auto axxxyyy_0 = current_data[325];
      const auto axxyyyy_0 = current_data[326];
      const auto axyyyyy_0 = current_data[327];
      const auto ayyyyyy_0 = current_data[328];
      const auto axxxxxz_0 = current_data[334];
      const auto axxxxyz_0 = current_data[335];
      const auto axxxyyz_0 = current_data[336];
      const auto axxyyyz_0 = current_data[337];
      const auto axyyyyz_0 = current_data[338];
      const auto ayyyyyz_0 = current_data[339];
      const auto axxxxzz_0 = current_data[345];
      const auto axxxyzz_0 = current_data[346];
      const auto axxyyzz_0 = current_data[347];
      const auto axyyyzz_0 = current_data[348];
      const auto ayyyyzz_0 = current_data[349];
      const auto axxxzzz_0 = current_data[355];
      const auto axxyzzz_0 = current_data[356];
      const auto axyyzzz_0 = current_data[357];
      const auto ayyyzzz_0 = current_data[358];
      const auto axxzzzz_0 = current_data[364];
      const auto axyzzzz_0 = current_data[365];
      const auto ayyzzzz_0 = current_data[366];
      const auto axzzzzz_0 = current_data[372];
      const auto ayzzzzz_0 = current_data[373];
      const auto azzzzzz_0 = current_data[379];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[224] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[225] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[226] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[227] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[228] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[229] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[230] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[231] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[232] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[233] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[234] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[235] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[236] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[237] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[238] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[239] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[240] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[241] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[242] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[243] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[244] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[245] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[246] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[247] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[248] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[249] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[250] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[251] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyyz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[38];
      const auto ay_0 = current_data[39];
      const auto az_0 = current_data[45];
      const auto axx_0 = current_data[75];
      const auto axy_0 = current_data[76];
      const auto ayy_0 = current_data[77];
      const auto axz_0 = current_data[83];
      const auto ayz_0 = current_data[84];
      const auto azz_0 = current_data[90];
      const auto axxx_0 = current_data[121];
      const auto axxy_0 = current_data[122];
      const auto axyy_0 = current_data[123];
      const auto ayyy_0 = current_data[124];
      const auto axxz_0 = current_data[130];
      const auto axyz_0 = current_data[131];
      const auto ayyz_0 = current_data[132];
      const auto axzz_0 = current_data[138];
      const auto ayzz_0 = current_data[139];
      const auto azzz_0 = current_data[145];
      const auto axxxx_0 = current_data[177];
      const auto axxxy_0 = current_data[178];
      const auto axxyy_0 = current_data[179];
      const auto axyyy_0 = current_data[180];
      const auto ayyyy_0 = current_data[181];
      const auto axxxz_0 = current_data[187];
      const auto axxyz_0 = current_data[188];
      const auto axyyz_0 = current_data[189];
      const auto ayyyz_0 = current_data[190];
      const auto axxzz_0 = current_data[196];
      const auto axyzz_0 = current_data[197];
      const auto ayyzz_0 = current_data[198];
      const auto axzzz_0 = current_data[204];
      const auto ayzzz_0 = current_data[205];
      const auto azzzz_0 = current_data[211];
      const auto axxxxx_0 = current_data[244];
      const auto axxxxy_0 = current_data[245];
      const auto axxxyy_0 = current_data[246];
      const auto axxyyy_0 = current_data[247];
      const auto axyyyy_0 = current_data[248];
      const auto ayyyyy_0 = current_data[249];
      const auto axxxxz_0 = current_data[255];
      const auto axxxyz_0 = current_data[256];
      const auto axxyyz_0 = current_data[257];
      const auto axyyyz_0 = current_data[258];
      const auto ayyyyz_0 = current_data[259];
      const auto axxxzz_0 = current_data[265];
      const auto axxyzz_0 = current_data[266];
      const auto axyyzz_0 = current_data[267];
      const auto ayyyzz_0 = current_data[268];
      const auto axxzzz_0 = current_data[274];
      const auto axyzzz_0 = current_data[275];
      const auto ayyzzz_0 = current_data[276];
      const auto axzzzz_0 = current_data[282];
      const auto ayzzzz_0 = current_data[283];
      const auto azzzzz_0 = current_data[289];
      const auto axxxxxx_0 = current_data[323];
      const auto axxxxxy_0 = current_data[324];
      const auto axxxxyy_0 = current_data[325];
      const auto axxxyyy_0 = current_data[326];
      const auto axxyyyy_0 = current_data[327];
      const auto axyyyyy_0 = current_data[328];
      const auto ayyyyyy_0 = current_data[329];
      const auto axxxxxz_0 = current_data[335];
      const auto axxxxyz_0 = current_data[336];
      const auto axxxyyz_0 = current_data[337];
      const auto axxyyyz_0 = current_data[338];
      const auto axyyyyz_0 = current_data[339];
      const auto ayyyyyz_0 = current_data[340];
      const auto axxxxzz_0 = current_data[346];
      const auto axxxyzz_0 = current_data[347];
      const auto axxyyzz_0 = current_data[348];
      const auto axyyyzz_0 = current_data[349];
      const auto ayyyyzz_0 = current_data[350];
      const auto axxxzzz_0 = current_data[356];
      const auto axxyzzz_0 = current_data[357];
      const auto axyyzzz_0 = current_data[358];
      const auto ayyyzzz_0 = current_data[359];
      const auto axxzzzz_0 = current_data[365];
      const auto axyzzzz_0 = current_data[366];
      const auto ayyzzzz_0 = current_data[367];
      const auto axzzzzz_0 = current_data[373];
      const auto ayzzzzz_0 = current_data[374];
      const auto azzzzzz_0 = current_data[380];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[252] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[253] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[254] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[255] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[256] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[257] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[258] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[259] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[260] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[261] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[262] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[263] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[264] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[265] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[266] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[267] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[268] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[269] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[270] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[271] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[272] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[273] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[274] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[275] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[276] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[277] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[278] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[279] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyyyz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[39];
      const auto ay_0 = current_data[40];
      const auto az_0 = current_data[46];
      const auto axx_0 = current_data[76];
      const auto axy_0 = current_data[77];
      const auto ayy_0 = current_data[78];
      const auto axz_0 = current_data[84];
      const auto ayz_0 = current_data[85];
      const auto azz_0 = current_data[91];
      const auto axxx_0 = current_data[122];
      const auto axxy_0 = current_data[123];
      const auto axyy_0 = current_data[124];
      const auto ayyy_0 = current_data[125];
      const auto axxz_0 = current_data[131];
      const auto axyz_0 = current_data[132];
      const auto ayyz_0 = current_data[133];
      const auto axzz_0 = current_data[139];
      const auto ayzz_0 = current_data[140];
      const auto azzz_0 = current_data[146];
      const auto axxxx_0 = current_data[178];
      const auto axxxy_0 = current_data[179];
      const auto axxyy_0 = current_data[180];
      const auto axyyy_0 = current_data[181];
      const auto ayyyy_0 = current_data[182];
      const auto axxxz_0 = current_data[188];
      const auto axxyz_0 = current_data[189];
      const auto axyyz_0 = current_data[190];
      const auto ayyyz_0 = current_data[191];
      const auto axxzz_0 = current_data[197];
      const auto axyzz_0 = current_data[198];
      const auto ayyzz_0 = current_data[199];
      const auto axzzz_0 = current_data[205];
      const auto ayzzz_0 = current_data[206];
      const auto azzzz_0 = current_data[212];
      const auto axxxxx_0 = current_data[245];
      const auto axxxxy_0 = current_data[246];
      const auto axxxyy_0 = current_data[247];
      const auto axxyyy_0 = current_data[248];
      const auto axyyyy_0 = current_data[249];
      const auto ayyyyy_0 = current_data[250];
      const auto axxxxz_0 = current_data[256];
      const auto axxxyz_0 = current_data[257];
      const auto axxyyz_0 = current_data[258];
      const auto axyyyz_0 = current_data[259];
      const auto ayyyyz_0 = current_data[260];
      const auto axxxzz_0 = current_data[266];
      const auto axxyzz_0 = current_data[267];
      const auto axyyzz_0 = current_data[268];
      const auto ayyyzz_0 = current_data[269];
      const auto axxzzz_0 = current_data[275];
      const auto axyzzz_0 = current_data[276];
      const auto ayyzzz_0 = current_data[277];
      const auto axzzzz_0 = current_data[283];
      const auto ayzzzz_0 = current_data[284];
      const auto azzzzz_0 = current_data[290];
      const auto axxxxxx_0 = current_data[324];
      const auto axxxxxy_0 = current_data[325];
      const auto axxxxyy_0 = current_data[326];
      const auto axxxyyy_0 = current_data[327];
      const auto axxyyyy_0 = current_data[328];
      const auto axyyyyy_0 = current_data[329];
      const auto ayyyyyy_0 = current_data[330];
      const auto axxxxxz_0 = current_data[336];
      const auto axxxxyz_0 = current_data[337];
      const auto axxxyyz_0 = current_data[338];
      const auto axxyyyz_0 = current_data[339];
      const auto axyyyyz_0 = current_data[340];
      const auto ayyyyyz_0 = current_data[341];
      const auto axxxxzz_0 = current_data[347];
      const auto axxxyzz_0 = current_data[348];
      const auto axxyyzz_0 = current_data[349];
      const auto axyyyzz_0 = current_data[350];
      const auto ayyyyzz_0 = current_data[351];
      const auto axxxzzz_0 = current_data[357];
      const auto axxyzzz_0 = current_data[358];
      const auto axyyzzz_0 = current_data[359];
      const auto ayyyzzz_0 = current_data[360];
      const auto axxzzzz_0 = current_data[366];
      const auto axyzzzz_0 = current_data[367];
      const auto ayyzzzz_0 = current_data[368];
      const auto axzzzzz_0 = current_data[374];
      const auto ayzzzzz_0 = current_data[375];
      const auto azzzzzz_0 = current_data[381];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[280] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[281] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[282] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[283] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[284] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[285] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[286] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[287] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[288] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[289] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[290] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[291] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[292] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[293] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[294] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[295] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[296] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[297] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[298] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[299] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[300] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[301] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[302] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[303] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[304] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[305] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[306] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[307] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyyyz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[40];
      const auto ay_0 = current_data[41];
      const auto az_0 = current_data[47];
      const auto axx_0 = current_data[77];
      const auto axy_0 = current_data[78];
      const auto ayy_0 = current_data[79];
      const auto axz_0 = current_data[85];
      const auto ayz_0 = current_data[86];
      const auto azz_0 = current_data[92];
      const auto axxx_0 = current_data[123];
      const auto axxy_0 = current_data[124];
      const auto axyy_0 = current_data[125];
      const auto ayyy_0 = current_data[126];
      const auto axxz_0 = current_data[132];
      const auto axyz_0 = current_data[133];
      const auto ayyz_0 = current_data[134];
      const auto axzz_0 = current_data[140];
      const auto ayzz_0 = current_data[141];
      const auto azzz_0 = current_data[147];
      const auto axxxx_0 = current_data[179];
      const auto axxxy_0 = current_data[180];
      const auto axxyy_0 = current_data[181];
      const auto axyyy_0 = current_data[182];
      const auto ayyyy_0 = current_data[183];
      const auto axxxz_0 = current_data[189];
      const auto axxyz_0 = current_data[190];
      const auto axyyz_0 = current_data[191];
      const auto ayyyz_0 = current_data[192];
      const auto axxzz_0 = current_data[198];
      const auto axyzz_0 = current_data[199];
      const auto ayyzz_0 = current_data[200];
      const auto axzzz_0 = current_data[206];
      const auto ayzzz_0 = current_data[207];
      const auto azzzz_0 = current_data[213];
      const auto axxxxx_0 = current_data[246];
      const auto axxxxy_0 = current_data[247];
      const auto axxxyy_0 = current_data[248];
      const auto axxyyy_0 = current_data[249];
      const auto axyyyy_0 = current_data[250];
      const auto ayyyyy_0 = current_data[251];
      const auto axxxxz_0 = current_data[257];
      const auto axxxyz_0 = current_data[258];
      const auto axxyyz_0 = current_data[259];
      const auto axyyyz_0 = current_data[260];
      const auto ayyyyz_0 = current_data[261];
      const auto axxxzz_0 = current_data[267];
      const auto axxyzz_0 = current_data[268];
      const auto axyyzz_0 = current_data[269];
      const auto ayyyzz_0 = current_data[270];
      const auto axxzzz_0 = current_data[276];
      const auto axyzzz_0 = current_data[277];
      const auto ayyzzz_0 = current_data[278];
      const auto axzzzz_0 = current_data[284];
      const auto ayzzzz_0 = current_data[285];
      const auto azzzzz_0 = current_data[291];
      const auto axxxxxx_0 = current_data[325];
      const auto axxxxxy_0 = current_data[326];
      const auto axxxxyy_0 = current_data[327];
      const auto axxxyyy_0 = current_data[328];
      const auto axxyyyy_0 = current_data[329];
      const auto axyyyyy_0 = current_data[330];
      const auto ayyyyyy_0 = current_data[331];
      const auto axxxxxz_0 = current_data[337];
      const auto axxxxyz_0 = current_data[338];
      const auto axxxyyz_0 = current_data[339];
      const auto axxyyyz_0 = current_data[340];
      const auto axyyyyz_0 = current_data[341];
      const auto ayyyyyz_0 = current_data[342];
      const auto axxxxzz_0 = current_data[348];
      const auto axxxyzz_0 = current_data[349];
      const auto axxyyzz_0 = current_data[350];
      const auto axyyyzz_0 = current_data[351];
      const auto ayyyyzz_0 = current_data[352];
      const auto axxxzzz_0 = current_data[358];
      const auto axxyzzz_0 = current_data[359];
      const auto axyyzzz_0 = current_data[360];
      const auto ayyyzzz_0 = current_data[361];
      const auto axxzzzz_0 = current_data[367];
      const auto axyzzzz_0 = current_data[368];
      const auto ayyzzzz_0 = current_data[369];
      const auto axzzzzz_0 = current_data[375];
      const auto ayzzzzz_0 = current_data[376];
      const auto azzzzzz_0 = current_data[382];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[308] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[309] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[310] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[311] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[312] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[313] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[314] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[315] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[316] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[317] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[318] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[319] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[320] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[321] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[322] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[323] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[324] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[325] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[326] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[327] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[328] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[329] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[330] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[331] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[332] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[333] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[334] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[335] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyyyz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[41];
      const auto ay_0 = current_data[42];
      const auto az_0 = current_data[48];
      const auto axx_0 = current_data[78];
      const auto axy_0 = current_data[79];
      const auto ayy_0 = current_data[80];
      const auto axz_0 = current_data[86];
      const auto ayz_0 = current_data[87];
      const auto azz_0 = current_data[93];
      const auto axxx_0 = current_data[124];
      const auto axxy_0 = current_data[125];
      const auto axyy_0 = current_data[126];
      const auto ayyy_0 = current_data[127];
      const auto axxz_0 = current_data[133];
      const auto axyz_0 = current_data[134];
      const auto ayyz_0 = current_data[135];
      const auto axzz_0 = current_data[141];
      const auto ayzz_0 = current_data[142];
      const auto azzz_0 = current_data[148];
      const auto axxxx_0 = current_data[180];
      const auto axxxy_0 = current_data[181];
      const auto axxyy_0 = current_data[182];
      const auto axyyy_0 = current_data[183];
      const auto ayyyy_0 = current_data[184];
      const auto axxxz_0 = current_data[190];
      const auto axxyz_0 = current_data[191];
      const auto axyyz_0 = current_data[192];
      const auto ayyyz_0 = current_data[193];
      const auto axxzz_0 = current_data[199];
      const auto axyzz_0 = current_data[200];
      const auto ayyzz_0 = current_data[201];
      const auto axzzz_0 = current_data[207];
      const auto ayzzz_0 = current_data[208];
      const auto azzzz_0 = current_data[214];
      const auto axxxxx_0 = current_data[247];
      const auto axxxxy_0 = current_data[248];
      const auto axxxyy_0 = current_data[249];
      const auto axxyyy_0 = current_data[250];
      const auto axyyyy_0 = current_data[251];
      const auto ayyyyy_0 = current_data[252];
      const auto axxxxz_0 = current_data[258];
      const auto axxxyz_0 = current_data[259];
      const auto axxyyz_0 = current_data[260];
      const auto axyyyz_0 = current_data[261];
      const auto ayyyyz_0 = current_data[262];
      const auto axxxzz_0 = current_data[268];
      const auto axxyzz_0 = current_data[269];
      const auto axyyzz_0 = current_data[270];
      const auto ayyyzz_0 = current_data[271];
      const auto axxzzz_0 = current_data[277];
      const auto axyzzz_0 = current_data[278];
      const auto ayyzzz_0 = current_data[279];
      const auto axzzzz_0 = current_data[285];
      const auto ayzzzz_0 = current_data[286];
      const auto azzzzz_0 = current_data[292];
      const auto axxxxxx_0 = current_data[326];
      const auto axxxxxy_0 = current_data[327];
      const auto axxxxyy_0 = current_data[328];
      const auto axxxyyy_0 = current_data[329];
      const auto axxyyyy_0 = current_data[330];
      const auto axyyyyy_0 = current_data[331];
      const auto ayyyyyy_0 = current_data[332];
      const auto axxxxxz_0 = current_data[338];
      const auto axxxxyz_0 = current_data[339];
      const auto axxxyyz_0 = current_data[340];
      const auto axxyyyz_0 = current_data[341];
      const auto axyyyyz_0 = current_data[342];
      const auto ayyyyyz_0 = current_data[343];
      const auto axxxxzz_0 = current_data[349];
      const auto axxxyzz_0 = current_data[350];
      const auto axxyyzz_0 = current_data[351];
      const auto axyyyzz_0 = current_data[352];
      const auto ayyyyzz_0 = current_data[353];
      const auto axxxzzz_0 = current_data[359];
      const auto axxyzzz_0 = current_data[360];
      const auto axyyzzz_0 = current_data[361];
      const auto ayyyzzz_0 = current_data[362];
      const auto axxzzzz_0 = current_data[368];
      const auto axyzzzz_0 = current_data[369];
      const auto ayyzzzz_0 = current_data[370];
      const auto axzzzzz_0 = current_data[376];
      const auto ayzzzzz_0 = current_data[377];
      const auto azzzzzz_0 = current_data[383];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * ax