//
// anyRemote
// a wi-fi or bluetooth remote for your PC.
//
// Copyright (C) 2012-2014 Mikhail Fedotov <anyremote@mail.ru>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

//
// Message queue related wrappers
//

#ifndef _PEER_H_
#define _PEER_H_ 1

#include "list.h"
#include "dispatcher.h"

enum PeerState {
    PEER_DISCONNECTED = 0,
    PEER_WAIT_ACCEPT,
    PEER_CONNECTED 
};

typedef struct {
    int       mode;
    int       state;
    int       port;
    void*     connectionData;  // specific to connection
    string_t  *portStr;
} ConnectInfo;

int  definePeers    (void);
int  openPeers      (void);         // EXIT_OK/EXIT_NOK
int  setupPeers     (void);         // -1/1
int  disconnectPeers(void);         // -1/1
void closePeers     (int final);
void freePeers      (void);

int  readPeers (string_t* buffer);

int  readPeer  (int fd, char* buffer, int max);

int  writePeers     (dMessage* dm);
int  writeFilePeers (dMessage* dm);
int  writeBytesPeers(char* command);

int writeCKPD(dMessage* dm);
int writeCMER(dMessage* dm);

int  isAtMode      (void);          // EXIT_OK/EXIT_NOK
int  isAtModeDuplex(void);          // EXIT_OK/EXIT_NOK
int  isServerMode  (void);          // EXIT_OK/EXIT_NOK
int  isServerModeNoWeb(void);       // EXIT_OK/EXIT_NOK
int  isWebServer   (void);          // EXIT_OK/EXIT_NOK
int  connected     (void);          // EXIT_OK/EXIT_NOK
int  needExit      (void);          // EXIT_OK/EXIT_NOK
int  needFinalizer (void);          // EXIT_OK/EXIT_NOK
int  needAtMainMenuReturn(void);    // EXIT_OK/EXIT_NOK
void sendIViewerHeartbeat(void);

int  getIViewerTcpPort(void);	    // <port>/-1	

void      connectNotify();
boolean_t checkActiveCall();
boolean_t hasActiveCall  ();

#endif
