### Core APIs ###

| API                                                       | Brief              |
|-----------------------------------------------------------|--------------------|
| [_ACTION](globals/premake_ACTION.md)                      | The action that will be run |
| [_ARGS](globals/premake_ARGS.md)                          | Array of action args |
| [_MAIN_SCRIPT](globals/premake_MAIN_SCRIPT.md)            |  |
| [_MAIN_SCRIPT_DIR](globals/premake_MAIN_SCRIPT_DIR.md)    |  |
| [_OPTIONS](globals/premake_OPTIONS.md)                    |  |
| [_OS](globals/premake_OS.md)                              | The currently targeted operating system |
| [_PREMAKE_COMMAND](globals/premake_PREMAKE_COMMAND.md)    |  |
| [_PREMAKE_DIR](globals/premake_PREMAKE_DIR.md)            |  |
| [_PREMAKE_VERSION](globals/premake_PREMAKE_VERSION.md)    | The version of the currently executing instance of Premake |
| [_WORKING_DIR](globals/premake_WORKING_DIR.md)            |  |
| [architecture](architecture.md)                           |  |
| [atl](atl.md)                                             | Use Microsoft's Active Template Library |
| [basedir](basedir.md)                                     |  |
| [bindirs](bindirs.md)                                     |  |
| [buildaction](buildaction.md)                             |  |
| [buildcommands](buildcommands.md)                         |  |
| [buildcustomizations](buildcustomizations.md)             |  |
| [builddependencies](builddependencies.md)                 |  |
| [buildinputs](buildinputs.md)                             |  |
| [buildlog](buildlog.md)                                   |  |
| [buildmessage](buildmessage.md)                           |  |
| [buildoptions](buildoptions.md)                           | Additional build options (passed directly to compiler) |
| [buildoutputs](buildoutputs.md)                           |  |
| [buildrule](buildrule.md)                                 |  |
| [callingconvention](callingconvention.md)                 | Sets the function calling convention |
| [cdialect](cdialect.md)                                   |  |
| [characterset](characterset.md)                           | Set the character encoding |
| [cleancommands](cleancommands.md)                         |  |
| [cleanextensions](cleanextensions.md)                     |  |
| [clr](clr.md)                                             | Use Microsoft's Common Language Runtime |
| [compileas](compileas.md)                                 |  |
| [compilebuildoutputs](compilebuildoutputs.md)             |  |
| [configfile](configfile.md)                               |  |
| [configmap](configmap.md)                                 |  |
| [configuration](configuration.md)                         |  |
| [configurations](configurations.md)                       |  |
| [copylocal](copylocal.md)                                 |  |
| [cppdialect](cppdialect.md)                               |  |
| [customtoolnamespace](customtoolnamespace.md)             |  |
| [debugargs](debugargs.md)                                 |  |
| [debugcommand](debugcommand.md)                           |  |
| [debugconnectcommands](debugconnectcommands.md)           | Debugger commands to execute on remote target connection |
| [debugdir](debugdir.md)                                   | Working directory for debug session |
| [debugenvs](debugenvs.md)                                 | Env vars for debug session |
| [debugextendedprotocol](debugextendedprotocol.md)         | Use gdb 'extended' protocol; maintain a persistent connection |
| [debugformat](debugformat.md)                             | Format for embedded debug information |
| [debugger](debugger.md)                                   |  |
| [debuggertype](debuggertype.md)                           |  |
| [debugport](debugport.md)                                 | Port to use for remote debugging |
| [debugremotehost](debugremotehost.md)                     | Target for remote debugging |
| [debugsearchpaths](debugsearchpaths.md)                   | Search paths for source code while debugging |
| [debugstartupcommands](debugstartupcommands.md)           | Debugger commands to execute on debugger startup |
| [defaultplatform](defaultplatform.md)                     |  |
| [defines](defines.md)                                     |  |
| [dependson](dependson.md)                                 |  |
| [deploymentoptions](deploymentoptions.md)                 |  |
| [disablewarnings](disablewarnings.md)                     |  |
| [display](display.md)                                     |  |
| [display](display.md)                                     |  |
| [editandcontinue](editandcontinue.md)                     |  |
| [editorintegration](editorintegration.md)                 | Enable or disable IDE integration |
| [enableunitybuild](enableunitybuild.md)                   |  |
| [enablewarnings](enablewarnings.md)                       |  |
| [endian](endian.md)                                       |  |
| [entrypoint](entrypoint.md)                               | Specify the program entry point function |
| [exceptionhandling](exceptionhandling.md)                 | Enable or disable exception handling |
| [external](external.md)                                   |  |
| [externalanglebrackets](externalanglebrackets.md)         |  |
| [externalincludedirs](externalincludedirs.md)             |  |
| [externalrule](externalrule.md)                           |  |
| [externalwarnings](externalwarnings.md)                   |  |
| [fatalwarnings](fatalwarnings.md)                         |  |
| [fileextension](fileextension.md)                         |  |
| [filename](filename.md)                                   |  |
| [files](files.md)                                         |  |
| [filter](filter.md)                                       |  |
| [flags](flags.md)                                         |  |
| [floatingpoint](floatingpoint.md)                         |  |
| [floatingpointexceptions](floatingpointexceptions.md)     |  |
| [forceincludes](forceincludes.md)                         |  |
| [forceusings](forceusings.md)                             |  |
| [fpu](fpu.md)                                             |  |
| [framework](framework.md)                                 |  |
| [functionlevellinking](functionlevellinking.md)           |  |
| [gccprefix](gccprefix.md)                                 |  |
| [group](group.md)                                         |  |
| [icon](icon.md)                                           |  |
| [ignoredefaultlibraries](ignoredefaultlibraries.md)       | Specify a list of default libraries to ignore |
| [imageoptions](imageoptions.md)                           |  |
| [imagepath](imagepath.md)                                 |  |
| [implibdir](implibdir.md)                                 |  |
| [implibextension](implibextension.md)                     |  |
| [implibname](implibname.md)                               |  |
| [implibprefix](implibprefix.md)                           |  |
| [implibsuffix](implibsuffix.md)                           |  |
| [include](globals/include.md)                             |  |
| [includedirs](includedirs.md)                             |  |
| [includedirsafter](includedirsafter.md)                   |  |
| [includeexternal](globals/includeexternal.md)             |  |
| [inlining](inlining.md)                                   | Tells the compiler when it should inline functions |
| [intrinsics](intrinsics.md)                               |  |
| [kind](kind.md)                                           |  |
| [language](language.md)                                   |  |
| [largeaddressaware](largeaddressaware.md)                 |  |
| [libdirs](libdirs.md)                                     |  |
| [linkbuildoutputs](linkbuildoutputs.md)                   |  |
| [linkgroups](linkgroups.md)                               | Turn on/off linkgroups for gcc/clang |
| [linkoptions](linkoptions.md)                             | Additional linker options (passed directly to linker) |
| [links](links.md)                                         |  |
| [locale](locale.md)                                       |  |
| [location](location.md)                                   | Specifies the directory for the generated workspace/project file |
| [makesettings](makesettings.md)                           |  |
| [namespace](namespace.md)                                 |  |
| [nativewchar](nativewchar.md)                             |  |
| [nuget](nuget.md)                                         |  |
| [nugetsource](nugetsource.md)                             |  |
| [objdir](objdir.md)                                       | Output dir for object/intermediate files |
| [optimize](optimize.md)                                   | Optimization level |
| [pchheader](pchheader.md)                                 | Precompiled header file |
| [pchsource](pchsource.md)                                 | Precompiled header source file (which should build the PCH) |
| [pic](pic.md)                                             | Position independent code |
| [platforms](platforms.md)                                 |  |
| [postbuildcommands](postbuildcommands.md)                 |  |
| [postbuildmessage](postbuildmessage.md)                   |  |
| [prebuildcommands](prebuildcommands.md)                   |  |
| [prebuildmessage](prebuildmessage.md)                     |  |
| [preferredtoolarchitecture](preferredtoolarchitecture.md) |  |
| [prelinkcommands](prelinkcommands.md)                     |  |
| [prelinkmessage](prelinkmessage.md)                       |  |
| [project](project.md)                                     |  |
| [propertydefinition](propertydefinition.md)               |  |
| [rebuildcommands](rebuildcommands.md)                     |  |
| [resdefines](resdefines.md)                               |  |
| [resincludedirs](resincludedirs.md)                       |  |
| [resoptions](resoptions.md)                               |  |
| [resourcegenerator](resourcegenerator.md)                 |  |
| [rtti](rtti.md)                                           | Enable or disable runtime type information |
| [rule](rule.md)                                           |  |
| [rules](rules.md)                                         |  |
| [runtime](runtime.md)                                     |  |
| [sanitize](sanitize.md)                                   | Enable `fsanitize` compiler options |
| [sharedlibtype](sharedlibtype.md)                         |  |
| [startproject](startproject.md)                           |  |
| [strictaliasing](strictaliasing.md)                       |  |
| [stringpooling](stringpooling.md)                         |  |
| [symbols](symbols.md)                                     | Turn symbol generation on/off |
| [symbolspath](symbolspath.md)                             | Allows you to specify the target location of the symbols |
| [sysincludedirs](sysincludedirs.md)                       |  |
| [syslibdirs](syslibdirs.md)                               |  |
| [system](system.md)                                       |  |
| [tags](tags.md)                                           |  |
| [targetdir](targetdir.md)                                 |  |
| [targetextension](targetextension.md)                     |  |
| [targetname](targetname.md)                               |  |
| [targetprefix](targetprefix.md)                           |  |
| [targetsuffix](targetsuffix.md)                           |  |
| [toolset](toolset.md)                                     |  |
| [toolsversion](toolsversion.md)                           |  |
| [undefines](undefines.md)                                 |  |
| [usingdirs](usingdirs.md)                                 |  |
| [uuid](uuid.md)                                           | Set project GUID (for VS projects/workspaces) |
| [vectorextensions](vectorextensions.md)                   | Enable hardware vector extensions |
| [vpaths](vpaths.md)                                       |  |
| [warnings](warnings.md)                                   |  |
| [workspace](workspace.md)                                 |  |

### Builtin Extension APIs ###

The following API reference is for use with various built-in extensions.

| Xcode APIs                                     | Brief              |
|------------------------------------------------|--------------------|
| [xcodebuildsettings](xcodebuildsettings.md)    |  |
| [xcodebuildresources](xcodebuildresources.md)  |  |
