#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sudocats
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241002.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='sudocats'
GAME_NAME='Sudocats'

ARCHIVE_BASE_2_NAME='setup_sudocats_1.11_(json_achievements_fix)_(64bit)_(69928).exe'
ARCHIVE_BASE_2_MD5='ad7da533bc7b59c7b0f62c468e2bae85'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_SIZE='250280'
ARCHIVE_BASE_2_VERSION='1.11-gog69928'
ARCHIVE_BASE_2_URL='https://www.gog.com/en/game/sudocats'

ARCHIVE_BASE_1_NAME='setup_sudocats_1.1_(random_puzzles_with_gog_wrapper)_(64bit)_(68010).exe'
ARCHIVE_BASE_1_MD5='c4a1e2a5cabddeedf73832c5841d576c'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='250591'
ARCHIVE_BASE_1_VERSION='1.1-gog68010'

ARCHIVE_BASE_0_NAME='setup_sudocats_1.0_gog_(64bit)_(62585).exe'
ARCHIVE_BASE_0_MD5='c75b4230f05cc5b4d875abd855767dcf'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='230000'
ARCHIVE_BASE_0_VERSION='1.0-gog62585'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
sudocats.exe'
## The game fails to start if steam_api64.dll is missing.
CONTENT_GAME0_BIN_FILES='
steam_api64.dll'
## Starting with game build 1.1, galaxy64.dll is required.
CONTENT_GAME1_BIN_FILES='
galaxyconfig.json
galaxy64.dll'
CONTENT_GAME_DATA_FILES='
sudocats.pck'

USER_PERSISTENT_FILES='
*.cfg'

APP_MAIN_EXE='sudocats.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
