/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_PCIPort.h"
#include "OpenDRIM_PCIPortAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define PCI_OpenDRIM_PCIPortProviderSetInstance PCI_OpenDRIM_PCIPortProviderModifyInstance
#endif

int PCI_OpenDRIM_PCIPort_init(const CMPIBroker* broker);

int PCI_OpenDRIM_PCIPort_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus PCI_OpenDRIM_PCIPortProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = PCI_OpenDRIM_PCIPort_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_PCIPortProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_PCIPort> instances;
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_PCIPort_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = PCI_OpenDRIM_PCIPort_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_PCIPortProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_PCIPort> instances;
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_PCIPort_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = PCI_OpenDRIM_PCIPort_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_PCIPortProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PCIPort instance;
	PCI_OpenDRIM_PCIPort_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_PCIPort_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = PCI_OpenDRIM_PCIPort_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_PCIPortProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PCIPort newInstance, oldInstance;
	PCI_OpenDRIM_PCIPort_toCPP(_broker, ci, newInstance);
	PCI_OpenDRIM_PCIPort_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_PCIPort_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PCI_OpenDRIM_PCIPort_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_PCIPortProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PCIPort instance;
	PCI_OpenDRIM_PCIPort_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_PCIPort_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PCI_OpenDRIM_PCIPort_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PCI_OpenDRIM_PCIPort_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = PCI_OpenDRIM_PCIPort_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_PCIPortProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PCIPort instance;
	PCI_OpenDRIM_PCIPort_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_PCIPort_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PCI_OpenDRIM_PCIPort_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_PCIPortProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                        Method Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus PCI_OpenDRIM_PCIPortProviderMethodCleanup(CMPIMethodMI * mi, const CMPIContext * ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = PCI_OpenDRIM_PCIPort_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_PCIPortProviderInvokeMethod(CMPIMethodMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* methodName, const CMPIArgs* in, CMPIArgs* out) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PCIPort instance;
	PCI_OpenDRIM_PCIPort_toCPP(_broker, ref, instance);
	string errorMessage;

	const char* properties[] = {"DeviceID", "SystemCreationClassName", "SystemName", "CreationClassName"};
	int errorCode = PCI_OpenDRIM_PCIPort_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}

	if ((string) methodName =="RequestStateChange") {
		unsigned int returnValue;
		OpenDRIM_PCIPort_RequestStateChange_In inArgs;
		PCI_OpenDRIM_PCIPort_toCPP(_broker, in, inArgs);
		OpenDRIM_PCIPort_RequestStateChange_Out outArgs;
		
		errorCode = PCI_OpenDRIM_PCIPort_RequestStateChange(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		PCI_OpenDRIM_PCIPort_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="SetPowerState") {
		unsigned int returnValue;
		OpenDRIM_PCIPort_SetPowerState_In inArgs;
		PCI_OpenDRIM_PCIPort_toCPP(_broker, in, inArgs);
		
		errorCode = PCI_OpenDRIM_PCIPort_SetPowerState(_broker, ctx, instance, returnValue, inArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="Reset") {
		unsigned int returnValue;
		
		errorCode = PCI_OpenDRIM_PCIPort_Reset(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="EnableDevice") {
		unsigned int returnValue;
		OpenDRIM_PCIPort_EnableDevice_In inArgs;
		PCI_OpenDRIM_PCIPort_toCPP(_broker, in, inArgs);
		
		errorCode = PCI_OpenDRIM_PCIPort_EnableDevice(_broker, ctx, instance, returnValue, inArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="OnlineDevice") {
		unsigned int returnValue;
		OpenDRIM_PCIPort_OnlineDevice_In inArgs;
		PCI_OpenDRIM_PCIPort_toCPP(_broker, in, inArgs);
		
		errorCode = PCI_OpenDRIM_PCIPort_OnlineDevice(_broker, ctx, instance, returnValue, inArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="QuiesceDevice") {
		unsigned int returnValue;
		OpenDRIM_PCIPort_QuiesceDevice_In inArgs;
		PCI_OpenDRIM_PCIPort_toCPP(_broker, in, inArgs);
		
		errorCode = PCI_OpenDRIM_PCIPort_QuiesceDevice(_broker, ctx, instance, returnValue, inArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="SaveProperties") {
		unsigned int returnValue;
		
		errorCode = PCI_OpenDRIM_PCIPort_SaveProperties(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="RestoreProperties") {
		unsigned int returnValue;
		
		errorCode = PCI_OpenDRIM_PCIPort_RestoreProperties(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else {
		errorMessage = (string) OpenDRIM_PCIPort_classnames[0] + ": " + "The requested method (" + (string) methodName +") was not found.";
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) NOT_SUPPORTED, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	CMReturn(CMPI_RC_OK);
}

/* ---------------------------------------------------------------------------*/
/*                    End of Method Provider Interface                        */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int PCI_OpenDRIM_PCIPort_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = PCI_OpenDRIM_PCIPort_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "PCI_OpenDRIM_PCIPort_init FAILED: " + (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int PCI_OpenDRIM_PCIPort_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = PCI_OpenDRIM_PCIPort_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "PCI_OpenDRIM_PCIPort_unload FAILED: " + (string) OpenDRIM_PCIPort_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define PCI_OpenDRIM_PCIPort_INIT if (PCI_OpenDRIM_PCIPort_init(_broker) < 0) return NULL

CMInstanceMIStub(PCI_OpenDRIM_PCIPortProvider, PCI_OpenDRIM_PCIPortProvider, _broker, PCI_OpenDRIM_PCIPort_INIT);
CMMethodMIStub(PCI_OpenDRIM_PCIPortProvider, PCI_OpenDRIM_PCIPortProvider, _broker, PCI_OpenDRIM_PCIPort_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
