#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 31 July 2009 15:28:06 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/NBCR/ScreeningADT_pmvnet.py,v 1.1 2009/07/31 22:29:48 vareille Exp $
#
# $Id: ScreeningADT_pmvnet.py,v 1.1 2009/07/31 22:29:48 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
from WebServices.VisionInterface.WSNodes import wslib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://ws.nbcr.net/opal", replace=False)
except:
    pass
try:
    addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
except:
    pass
try:
    ## saving node Receptor File ##
    from Vision.StandardNodes import FileBrowserNE
    Receptor_File_0 = FileBrowserNE(constrkw={}, name='Receptor File', library=stdlib)
    masterNet.addNode(Receptor_File_0,17,9)
    apply(Receptor_File_0.configure, (), {'specialPortsVisible': True})
    Receptor_File_0.inputPortByName['filename'].widget.set(r"2HU4-chain_B.pdb", run=False)
    apply(Receptor_File_0.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named Receptor File in network masterNet"
    print_exc()
    Receptor_File_0=None

try:
    ## saving node ReceptorPDBQT ##
    from Vision.StandardNodes import FileBrowserNE
    ReceptorPDBQT_1 = FileBrowserNE(constrkw={}, name='ReceptorPDBQT', library=stdlib)
    masterNet.addNode(ReceptorPDBQT_1,254,195)
    apply(ReceptorPDBQT_1.configure, (), {'specialPortsVisible': True})
    ReceptorPDBQT_1.inputPortByName['filename'].rebindWidget()
    ReceptorPDBQT_1.inputPortByName['filename'].widget.set(r"3ptb_rec.pdbqt", run=False)
    ReceptorPDBQT_1.inputPortByName['filename'].unbindWidget()
    apply(ReceptorPDBQT_1.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named ReceptorPDBQT in network masterNet"
    print_exc()
    ReceptorPDBQT_1=None

try:
    ## saving node GPFFile ##
    from Vision.StandardNodes import FileBrowserNE
    GPFFile_2 = FileBrowserNE(constrkw={}, name='GPFFile', library=stdlib)
    masterNet.addNode(GPFFile_2,176,269)
    apply(GPFFile_2.configure, (), {'specialPortsVisible': True})
    GPFFile_2.inputPortByName['filename'].rebindWidget()
    GPFFile_2.inputPortByName['filename'].widget.set(r"3ptb_test.gpf", run=False)
    GPFFile_2.inputPortByName['filename'].unbindWidget()
    apply(GPFFile_2.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named GPFFile in network masterNet"
    print_exc()
    GPFFile_2=None

try:
    ## saving node autodock-screening ##
    from NetworkEditor.macros import MacroNode
    autodock_screening_3 = MacroNode(name='autodock-screening')
    masterNet.addNode(autodock_screening_3, 298, 458)
    input_Ports_4 = autodock_screening_3.macroNetwork.ipNode
    apply(input_Ports_4.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    input_Ports_4.move(340, 4)
    output_Ports_5 = autodock_screening_3.macroNetwork.opNode
    apply(output_Ports_5.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_5.move(308, 455)
    from Vision.StandardNodes import Generic
    Download4Summarize_6 = Generic(constrkw={}, name='Download4Summarize', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(Download4Summarize_6,334,202)
    apply(Download4Summarize_6.addInputPort, (), {'singleConnection': True, 'name': 'in1', 'cast': 1, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(Download4Summarize_6.addOutputPort, (), {'name': 'out1', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Download4Summarize_6.addOutputPort, (), {'name': 'out11', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Download4Summarize_6.configure, (), {'specialPortsVisible': True})
    code = """def doit(self, in1):
        maindir = '''vision_work'''
        if os.name == '''dos''' or os.name == '''nt''':
            downloadcmd1 = '''md ''' + maindir
            downloadcmd2 = '''cd vision_work && wget -r ''' + in1 + '''/..'''
            os.system(downloadcmd1)
            os.system(downloadcmd2)
        else:
            downloadcmd = '''mkdir -p ''' + maindir + '''; cd vision_work; wget -r ''' + in1 + '''/..'''
            os.system(downloadcmd)

        d1, d2, d3, d4, d5 = in1.split('''/''')
        dir = os.getcwd() + '''/''' + maindir + '''/''' + d3 + '''/''' + d4
        sum = dir + '''/''' + '''summarize_results.txt'''
        dir = os.path.normpath(dir)
        sum = os.path.normpath(sum)
    
	pass

        self.outputData(out1=sum, out11=dir)

## to ouput data on port out1 use
## self.outputData(out1=data)





















## to ouput data on port out11 use
## self.outputData(out11=data)



"""
    Download4Summarize_6.configure(function=code)
    apply(Download4Summarize_6.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Index
    Index_7 = Index(constrkw={}, name='Index', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(Index_7,334,135)
    apply(Index_7.outputPortByName['data'].configure, (), {'datatype': 'string'})
    apply(Index_7.inputPortByName['index'].widget.configure, (), {'max': 25, 'min': -26})
    Index_7.inputPortByName['index'].widget.set(0, run=False)
    apply(Index_7.configure, (), {'paramPanelImmediate': 1})
    from NetworkEditor.items import FunctionNode
    autodock_kryptonite_nbcr_net_8 = FunctionNode(functionOrString='autodock_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", namedArgs={'ga_run': '', 'lib': '', 'ga_num_evals': '', 'sched': '', 'urllib': '', 'ga_num_generations': '', 'dpf': '', 'u': '', 'utar': '', 'userlib': '', 'ga_pop_size': '', 'localRun': False, 'email': '', 'execPath': ''}, constrkw={'functionOrString': "'autodock_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'namedArgs': {'ga_run': '', 'lib': '', 'ga_num_evals': '', 'sched': '', 'urllib': '', 'ga_num_generations': '', 'dpf': '', 'u': '', 'utar': '', 'userlib': '', 'ga_pop_size': '', 'localRun': False, 'email': '', 'execPath': ''}}, name='autodock_kryptonite_nbcr_net', library=wslib)
    autodock_screening_3.macroNetwork.addNode(autodock_kryptonite_nbcr_net_8,334,78)
    autodock_kryptonite_nbcr_net_8.inputPortByName['ga_run'].widget.set(r"7", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['lib'].rebindWidget()
    autodock_kryptonite_nbcr_net_8.inputPortByName['lib'].widget.set(r"sample", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['lib'].unbindWidget()
    autodock_kryptonite_nbcr_net_8.inputPortByName['ga_num_evals'].widget.set(r"250000", run=False)
    apply(autodock_kryptonite_nbcr_net_8.inputPortByName['sched'].widget.configure, (), {'choices': ('SGE', 'CSF')})
    autodock_kryptonite_nbcr_net_8.inputPortByName['sched'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['urllib'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['ga_num_generations'].widget.set(r"2700", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['dpf'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['u'].rebindWidget()
    autodock_kryptonite_nbcr_net_8.inputPortByName['u'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['u'].unbindWidget()
    autodock_kryptonite_nbcr_net_8.inputPortByName['utar'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['userlib'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['ga_pop_size'].widget.set(r"100", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['localRun'].widget.set(0, run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['email'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_8.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(autodock_kryptonite_nbcr_net_8.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    OpenFile_9 = Generic(constrkw={}, name='OpenFile', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(OpenFile_9,483,297)
    apply(OpenFile_9.addInputPort, (), {'singleConnection': True, 'name': 'in0', 'cast': 1, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    code = """def doit(self, in0):
        if os.name == '''nt''' or os.name == '''dos''':
            open_prog = '''explorer'''
        elif os.name == '''posix''':
            if os.uname()[0] == '''Darwin''':
                open_prog = '''open'''
            else:
                open_prog = '''gnome-open'''
        else:
            open_prog = ''''''

        cmd = open_prog + ''' ''' + in0
        os.system(cmd)
            
	pass











"""
    OpenFile_9.configure(function=code)
    apply(OpenFile_9.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Eval
    eval__in1_______10 = Eval(constrkw={}, name='eval: in1 + /..', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(eval__in1_______10,483,189)
    eval__in1_______10.inputPortByName['command'].widget.set(r"in1 + '/..'", run=False)
    eval__in1_______10.inputPortByName['importString'].widget.set(r"", run=False)
    apply(eval__in1_______10.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    OpenFile_11 = Generic(constrkw={}, name='OpenFile', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(OpenFile_11,267,305)
    apply(OpenFile_11.addInputPort, (), {'singleConnection': True, 'name': 'in0', 'cast': 1, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    code = """def doit(self, in0):
        if os.name == '''nt''' or os.name == '''dos''':
            open_prog = '''explorer'''
        elif os.name == '''posix''':
            if os.uname()[0] == '''Darwin''':
                open_prog = '''open'''
            else:
                open_prog = '''gnome-open'''
        else:
            open_prog = ''''''

        cmd = open_prog + ''' ''' + in0
        os.system(cmd)
            
	pass











"""
    OpenFile_11.configure(function=code)
    apply(OpenFile_11.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    OpenFile_12 = Generic(constrkw={}, name='OpenFile', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(OpenFile_12,379,304)
    apply(OpenFile_12.addInputPort, (), {'singleConnection': True, 'name': 'in0', 'cast': 1, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    code = """def doit(self, in0):
        if os.name == '''nt''' or os.name == '''dos''':
            open_prog = '''explorer'''
        elif os.name == '''posix''':
            if os.uname()[0] == '''Darwin''':
                open_prog = '''open'''
            else:
                open_prog = '''gnome-open'''
        else:
            open_prog = ''''''

        cmd = open_prog + ''' ''' + in0
        os.system(cmd)
            
	pass











"""
    OpenFile_12.configure(function=code)
    apply(OpenFile_12.configure, (), {'paramPanelImmediate': 1, 'expanded': False})

    ## saving connections for network autodock-screening ##
    autodock_screening_3.macroNetwork.freeze()
    if Index_7 is not None and Download4Summarize_6 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                Index_7, Download4Summarize_6, "data", "in1", blocking=True
                , splitratio=[0.38945329520468319, 0.53456030070003691])
        except:
            print "WARNING: failed to restore connection between Index_7 and Download4Summarize_6 in network autodock_screening_3.macroNetwork"
    if autodock_kryptonite_nbcr_net_8 is not None and Index_7 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                autodock_kryptonite_nbcr_net_8, Index_7, "result", "data", blocking=True
                , splitratio=[0.50587416942142949, 0.36441111756526601])
        except:
            print "WARNING: failed to restore connection between autodock_kryptonite_nbcr_net_8 and Index_7 in network autodock_screening_3.macroNetwork"
    input_Ports_4 = autodock_screening_3.macroNetwork.ipNode
    if input_Ports_4 is not None and autodock_kryptonite_nbcr_net_8 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                input_Ports_4, autodock_kryptonite_nbcr_net_8, "new", "u", blocking=True
                , splitratio=[0.54348304338128905, 0.42840635355979384])
        except:
            print "WARNING: failed to restore connection between input_Ports_4 and autodock_kryptonite_nbcr_net_8 in network autodock_screening_3.macroNetwork"
    if input_Ports_4 is not None and autodock_kryptonite_nbcr_net_8 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                input_Ports_4, autodock_kryptonite_nbcr_net_8, "new", "lib", blocking=True
                , splitratio=[0.55472227088750392, 0.47275636642626773])
        except:
            print "WARNING: failed to restore connection between input_Ports_4 and autodock_kryptonite_nbcr_net_8 in network autodock_screening_3.macroNetwork"
    if Index_7 is not None and eval__in1_______10 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                Index_7, eval__in1_______10, "data", "in1", blocking=True
                , splitratio=[0.72178158061042219, 0.71815791330956191])
        except:
            print "WARNING: failed to restore connection between Index_7 and eval__in1_______10 in network autodock_screening_3.macroNetwork"
    if Download4Summarize_6 is not None and OpenFile_12 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                Download4Summarize_6, OpenFile_12, "out11", "in0", blocking=True
                , splitratio=[0.54065518212283603, 0.61832038225221009])
        except:
            print "WARNING: failed to restore connection between Download4Summarize_6 and OpenFile_12 in network autodock_screening_3.macroNetwork"
    if Download4Summarize_6 is not None and OpenFile_11 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                Download4Summarize_6, OpenFile_11, "out1", "in0", blocking=True
                , splitratio=[0.27007888253183021, 0.22163693524145145])
        except:
            print "WARNING: failed to restore connection between Download4Summarize_6 and OpenFile_11 in network autodock_screening_3.macroNetwork"
    if eval__in1_______10 is not None and OpenFile_9 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                eval__in1_______10, OpenFile_9, "result", "in0", blocking=True
                , splitratio=[0.61629307900113961, 0.56340105583718414])
        except:
            print "WARNING: failed to restore connection between eval__in1_______10 and OpenFile_9 in network autodock_screening_3.macroNetwork"
    autodock_screening_3.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_4.outputPorts[1].configure(name='autodock_kryptonite_nbcr_net_u')
    input_Ports_4.outputPorts[2].configure(name='autodock_kryptonite_nbcr_net_lib')
    autodock_screening_3.inputPorts[0].configure(name='autodock_kryptonite_nbcr_net_u')
    autodock_screening_3.inputPorts[0].configure(datatype='string')
    autodock_screening_3.inputPorts[1].configure(name='autodock_kryptonite_nbcr_net_lib')
    autodock_screening_3.inputPorts[1].configure(datatype='string')
    ## configure MacroNode input ports
    ## configure MacroNode output ports
    autodock_screening_3.shrink()
    apply(autodock_screening_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named autodock-screening in network masterNet"
    print_exc()
    autodock_screening_3=None

try:
    ## saving node autogrid6 ##
    from NetworkEditor.macros import MacroNode
    autogrid6_13 = MacroNode(name='autogrid6')
    masterNet.addNode(autogrid6_13, 237, 377)
    output_Ports_15 = autogrid6_13.macroNetwork.opNode
    apply(output_Ports_15.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_15.move(198, 350)
    from Vision.StandardNodes import Eval
    eval__in1_____16 = Eval(constrkw={}, name='eval: in1+/..', library=stdlib)
    autogrid6_13.macroNetwork.addNode(eval__in1_____16,216,218)
    apply(eval__in1_____16.inputPortByName['in1'].configure, (), {'datatype': 'string', 'originalDatatype': 'None'})
    eval__in1_____16.inputPortByName['command'].widget.set(r"in1+'/..'", run=False)
    eval__in1_____16.inputPortByName['importString'].widget.set(r"", run=False)
    apply(eval__in1_____16.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Index
    Index_17 = Index(constrkw={}, name='Index', library=stdlib)
    autogrid6_13.macroNetwork.addNode(Index_17,216,145)
    apply(Index_17.outputPortByName['data'].configure, (), {'datatype': 'string'})
    apply(Index_17.inputPortByName['index'].widget.configure, (), {'max': 14, 'min': -15})
    Index_17.inputPortByName['index'].widget.set(0, run=False)
    apply(Index_17.configure, (), {'paramPanelImmediate': 1})
    from NetworkEditor.items import FunctionNode
    autogrid_kryptonite_nbcr_net_18 = FunctionNode(functionOrString='autogrid_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", namedArgs={'p_url': '', 'infile_url': '', 'l': 'output.glg', 'o': False, 'p': '', 'localRun': False, 'inFile': '', 'execPath': ''}, constrkw={'functionOrString': "'autogrid_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'namedArgs': {'p_url': '', 'infile_url': '', 'l': 'output.glg', 'o': False, 'p': '', 'localRun': False, 'inFile': '', 'execPath': ''}}, name='autogrid_kryptonite_nbcr_net', library=wslib)
    autogrid6_13.macroNetwork.addNode(autogrid_kryptonite_nbcr_net_18,217,86)
    autogrid_kryptonite_nbcr_net_18.inputPortByName['p_url'].widget.set(r"", run=False)
    autogrid_kryptonite_nbcr_net_18.inputPortByName['infile_url'].widget.set(r"", run=False)
    autogrid_kryptonite_nbcr_net_18.inputPortByName['l'].widget.set(r"otuput.glg", run=False)
    autogrid_kryptonite_nbcr_net_18.inputPortByName['o'].widget.set(0, run=False)
    autogrid_kryptonite_nbcr_net_18.inputPortByName['p'].rebindWidget()
    autogrid_kryptonite_nbcr_net_18.inputPortByName['p'].widget.set(r"", run=False)
    autogrid_kryptonite_nbcr_net_18.inputPortByName['p'].unbindWidget()
    autogrid_kryptonite_nbcr_net_18.inputPortByName['localRun'].widget.set(0, run=False)
    autogrid_kryptonite_nbcr_net_18.inputPortByName['inFile'].rebindWidget()
    autogrid_kryptonite_nbcr_net_18.inputPortByName['inFile'].widget.set(r"", run=False)
    autogrid_kryptonite_nbcr_net_18.inputPortByName['inFile'].unbindWidget()
    autogrid_kryptonite_nbcr_net_18.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(autogrid_kryptonite_nbcr_net_18.configure, (), {'paramPanelImmediate': 1, 'expanded': False})

    ## saving connections for network autogrid6 ##
    autogrid6_13.macroNetwork.freeze()
    if Index_17 is not None and eval__in1_____16 is not None:
        try:
            autogrid6_13.macroNetwork.connectNodes(
                Index_17, eval__in1_____16, "data", "in1", blocking=True
                , splitratio=[0.40926850005719312, 0.33127801648645372])
        except:
            print "WARNING: failed to restore connection between Index_17 and eval__in1_____16 in network autogrid6_13.macroNetwork"
    if autogrid_kryptonite_nbcr_net_18 is not None and Index_17 is not None:
        try:
            autogrid6_13.macroNetwork.connectNodes(
                autogrid_kryptonite_nbcr_net_18, Index_17, "result", "data", blocking=True
                , splitratio=[0.35117645750830362, 0.22661316217482019])
        except:
            print "WARNING: failed to restore connection between autogrid_kryptonite_nbcr_net_18 and Index_17 in network autogrid6_13.macroNetwork"
    input_Ports_14 = autogrid6_13.macroNetwork.ipNode
    if input_Ports_14 is not None and autogrid_kryptonite_nbcr_net_18 is not None:
        try:
            autogrid6_13.macroNetwork.connectNodes(
                input_Ports_14, autogrid_kryptonite_nbcr_net_18, "new", "p", blocking=True
                , splitratio=[0.49813486888665642, 0.22310664610504843])
        except:
            print "WARNING: failed to restore connection between input_Ports_14 and autogrid_kryptonite_nbcr_net_18 in network autogrid6_13.macroNetwork"
    if input_Ports_14 is not None and autogrid_kryptonite_nbcr_net_18 is not None:
        try:
            autogrid6_13.macroNetwork.connectNodes(
                input_Ports_14, autogrid_kryptonite_nbcr_net_18, "new", "inFile", blocking=True
                , splitratio=[0.73255961904978295, 0.66093923654161224])
        except:
            print "WARNING: failed to restore connection between input_Ports_14 and autogrid_kryptonite_nbcr_net_18 in network autogrid6_13.macroNetwork"
    output_Ports_15 = autogrid6_13.macroNetwork.opNode
    if eval__in1_____16 is not None and output_Ports_15 is not None:
        try:
            autogrid6_13.macroNetwork.connectNodes(
                eval__in1_____16, output_Ports_15, "result", "new", blocking=True
                , splitratio=[0.20435912775867832, 0.39954387166046734])
        except:
            print "WARNING: failed to restore connection between eval__in1_____16 and output_Ports_15 in network autogrid6_13.macroNetwork"
    autogrid6_13.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_14.outputPorts[1].configure(name='autogrid_kryptonite_nbcr_net_p')
    input_Ports_14.outputPorts[2].configure(name='autogrid_kryptonite_nbcr_net_inFile')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_15.inputPorts[1].configure(singleConnection='auto')
    output_Ports_15.inputPorts[1].configure(name='eval:_in1+/.._result')
    autogrid6_13.inputPorts[0].configure(name='autogrid_kryptonite_nbcr_net_p')
    autogrid6_13.inputPorts[0].configure(datatype='string')
    autogrid6_13.inputPorts[1].configure(name='autogrid_kryptonite_nbcr_net_inFile')
    autogrid6_13.inputPorts[1].configure(datatype='string')
    ## configure MacroNode input ports
    autogrid6_13.outputPorts[0].configure(name='eval:_in1+/.._result')
    autogrid6_13.outputPorts[0].configure(datatype='None')
    ## configure MacroNode output ports
    autogrid6_13.shrink()
    apply(autogrid6_13.configure, (), {'frozen': True, 'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named autogrid6 in network masterNet"
    print_exc()
    autogrid6_13=None

try:
    ## saving node ADTloadmolecule ##
    from NetworkEditor.macros import MacroNode
    ADTloadmolecule_19 = MacroNode(name='ADTloadmolecule')
    masterNet.addNode(ADTloadmolecule_19, 18, 268)
    input_Ports_20 = ADTloadmolecule_19.macroNetwork.ipNode
    apply(input_Ports_20.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
    input_Ports_20.move(229, 11)
    output_Ports_21 = ADTloadmolecule_19.macroNetwork.opNode
    apply(output_Ports_21.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_21.move(272, 411)
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    readPDBQT_22 = PmvRunCommand(command=masterNet.editor.vf.readPDBQT, posArgsNames=['filename'], constrkw={'command': 'masterNet.editor.vf.readPDBQT', 'posArgsNames': ['filename']}, name='readPDBQT', library=pmvlib)
    ADTloadmolecule_19.macroNetwork.addNode(readPDBQT_22,108,272)
    apply(readPDBQT_22.inputPortByName['command'].configure, (), {'datatype': 'PmvCmd', 'originalDatatype': 'None'})
    apply(readPDBQT_22.addInputPort, (), {'singleConnection': True, 'name': 'filename3', 'cast': 1, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(readPDBQT_22.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(readPDBQT_22.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(readPDBQT_22.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(readPDBQT_22.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(readPDBQT_22.configure, (), {'specialPortsVisible': True})
    readPDBQT_22.inputPortByName['command'].rebindWidget()
    readPDBQT_22.inputPortByName['command'].widget.set(r"", run=False)
    readPDBQT_22.inputPortByName['command'].unbindWidget()
    readPDBQT_22.inputPortByName['importString'].widget.set(r"", run=False)
    apply(readPDBQT_22.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 1, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 1}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    readPDBQT_22.inputPortByName['topCommand'].widget.set(1, run=False)
    apply(readPDBQT_22.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    readPDBQT_22.inputPortByName['redraw'].widget.set(1, run=False)
    apply(readPDBQT_22.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    readPDBQT_22.inputPortByName['setupUndo'].widget.set(1, run=False)
    apply(readPDBQT_22.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    readPDBQT_22.inputPortByName['log'].widget.set(1, run=False)
    apply(readPDBQT_22.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_23 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    ADTloadmolecule_19.macroNetwork.addNode(Pmv_23,28,105)
    apply(Pmv_23.configure, (), {'specialPortsVisible': True})
    Pmv_23.inputPortByName['cmdName'].widget.set(r"readPDBQT", run=False)
    Pmv_23.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_23.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_24 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    ADTloadmolecule_19.macroNetwork.addNode(Pmv_24,247,194)
    apply(Pmv_24.configure, (), {'specialPortsVisible': True})
    Pmv_24.inputPortByName['cmdName'].widget.set(r"computeMSMS", run=False)
    Pmv_24.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_24.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    computeMSMS_25 = PmvRunCommand(command=masterNet.editor.vf.computeMSMS, namedArgs={'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'display': True, 'pRadius': 1.5}, posArgsNames=['nodes'], constrkw={'command': 'masterNet.editor.vf.computeMSMS', 'namedArgs': {'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'display': True, 'pRadius': 1.5}, 'posArgsNames': ['nodes']}, name='computeMSMS', library=pmvlib)
    ADTloadmolecule_19.macroNetwork.addNode(computeMSMS_25,338,282)
    apply(computeMSMS_25.inputPortByName['command'].configure, (), {'datatype': 'PmvCmd', 'originalDatatype': 'None'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'nodes10', 'cast': 1, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'hdensity11', 'cast': 1, 'datatype': 'float', 'balloon': 'Defaults to6.0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'hdset12', 'cast': 1, 'datatype': 'string', 'balloon': 'Defaults toNone', 'required': False, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'surfName15', 'cast': 1, 'datatype': 'string', 'balloon': 'Defaults toMSMS-MOL', 'required': False, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'density16', 'cast': 1, 'datatype': 'float', 'balloon': 'Defaults to3.0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'perMol18', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'display20', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(computeMSMS_25.addInputPort, (), {'singleConnection': True, 'name': 'pRadius21', 'cast': 1, 'datatype': 'float', 'balloon': 'Defaults to1.5', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(computeMSMS_25.configure, (), {'specialPortsVisible': True})
    computeMSMS_25.inputPortByName['command'].rebindWidget()
    computeMSMS_25.inputPortByName['command'].widget.set(r"", run=False)
    computeMSMS_25.inputPortByName['command'].unbindWidget()
    computeMSMS_25.inputPortByName['importString'].widget.set(r"", run=False)
    computeMSMS_25.inputPortByName['hdensity'].widget.set(6.0, run=False)
    computeMSMS_25.inputPortByName['hdset'].widget.set(r"None", run=False)
    computeMSMS_25.inputPortByName['surfName'].widget.set(r"MSMS-MOL", run=False)
    computeMSMS_25.inputPortByName['density'].widget.set(3.0, run=False)
    computeMSMS_25.inputPortByName['perMol'].widget.set(1, run=False)
    computeMSMS_25.inputPortByName['display'].widget.set(1, run=False)
    computeMSMS_25.inputPortByName['pRadius'].widget.set(1.5, run=False)
    apply(computeMSMS_25.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    computeMSMS_25.inputPortByName['topCommand'].widget.set(1, run=False)
    apply(computeMSMS_25.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    computeMSMS_25.inputPortByName['setupUndo'].widget.set(1, run=False)
    apply(computeMSMS_25.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 13, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 13}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    computeMSMS_25.inputPortByName['log'].widget.set(1, run=False)
    apply(computeMSMS_25.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 17, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 17}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    computeMSMS_25.inputPortByName['redraw'].widget.set(1, run=False)
    apply(computeMSMS_25.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_26 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    ADTloadmolecule_19.macroNetwork.addNode(Pmv_26,586,162)
    apply(Pmv_26.configure, (), {'specialPortsVisible': True})
    Pmv_26.inputPortByName['cmdName'].widget.set(r"AD4gpf_readGPF", run=False)
    Pmv_26.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_26.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    AD4gpf_readGPF_27 = PmvRunCommand(command=masterNet.editor.vf.AD4gpf_readGPF, posArgsNames=['gpffile'], constrkw={'command': 'masterNet.editor.vf.AD4gpf_readGPF', 'posArgsNames': ['gpffile']}, name='AD4gpf_readGPF', library=pmvlib)
    ADTloadmolecule_19.macroNetwork.addNode(AD4gpf_readGPF_27,686,221)
    apply(AD4gpf_readGPF_27.inputPortByName['command'].configure, (), {'datatype': 'PmvCmd', 'originalDatatype': 'None'})
    apply(AD4gpf_readGPF_27.addInputPort, (), {'singleConnection': True, 'name': 'gpffile3', 'cast': 1, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(AD4gpf_readGPF_27.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(AD4gpf_readGPF_27.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(AD4gpf_readGPF_27.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(AD4gpf_readGPF_27.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': 1, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(AD4gpf_readGPF_27.configure, (), {'specialPortsVisible': True})
    AD4gpf_readGPF_27.inputPortByName['command'].rebindWidget()
    AD4gpf_readGPF_27.inputPortByName['command'].widget.set(r"", run=False)
    AD4gpf_readGPF_27.inputPortByName['command'].unbindWidget()
    AD4gpf_readGPF_27.inputPortByName['importString'].widget.set(r"", run=False)
    apply(AD4gpf_readGPF_27.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    AD4gpf_readGPF_27.inputPortByName['topCommand'].widget.set(1, run=False)
    apply(AD4gpf_readGPF_27.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    AD4gpf_readGPF_27.inputPortByName['redraw'].widget.set(1, run=False)
    apply(AD4gpf_readGPF_27.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    AD4gpf_readGPF_27.inputPortByName['setupUndo'].widget.set(1, run=False)
    apply(AD4gpf_readGPF_27.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 9, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 9}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    AD4gpf_readGPF_27.inputPortByName['log'].widget.set(1, run=False)
    apply(AD4gpf_readGPF_27.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    eval__in1_replace______28 = Eval(constrkw={}, name='eval: in1.replace(-...', library=stdlib)
    ADTloadmolecule_19.macroNetwork.addNode(eval__in1_replace______28,348,192)
    eval__in1_replace______28.inputPortByName['command'].widget.set(r"in1.replace('-','_')", run=False)
    eval__in1_replace______28.inputPortByName['importString'].widget.set(r"", run=False)
    apply(eval__in1_replace______28.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network ADTloadmolecule ##
    ADTloadmolecule_19.macroNetwork.freeze()
    if Pmv_23 is not None and readPDBQT_22 is not None:
        try:
            ADTloadmolecule_19.macroNetwork.connectNodes(
                Pmv_23, readPDBQT_22, "cmd", "command", blocking=True
                , splitratio=[0.50301160844931836, 0.67711137108946029])
        except:
            print "WARNING: failed to restore connection between Pmv_23 and readPDBQT_22 in network ADTloadmolecule_19.macroNetwork"
    if Pmv_24 is not None and computeMSMS_25 is not None:
        try:
            ADTloadmolecule_19.macroNetwork.connectNodes(
                Pmv_24, computeMSMS_25, "cmd", "command", blocking=True
                , splitratio=[0.67993193530016383, 0.30659379444384177])
        except:
            print "WARNING: failed to restore connection between Pmv_24 and computeMSMS_25 in network ADTloadmolecule_19.macroNetwork"
    if Pmv_26 is not None and AD4gpf_readGPF_27 is not None:
        try:
            ADTloadmolecule_19.macroNetwork.connectNodes(
                Pmv_26, AD4gpf_readGPF_27, "cmd", "command", blocking=True
                , splitratio=[0.25904796822744641, 0.7041853945274601])
        except:
            print "WARNING: failed to restore connection between Pmv_26 and AD4gpf_readGPF_27 in network ADTloadmolecule_19.macroNetwork"
    input_Ports_20 = ADTloadmolecule_19.macroNetwork.ipNode
    if input_Ports_20 is not None and readPDBQT_22 is not None:
        try:
            ADTloadmolecule_19.macroNetwork.connectNodes(
                input_Ports_20, readPDBQT_22, "new", "filename", blocking=True
                , splitratio=[0.33660634917382459, 0.25585969406254844])
        except:
            print "WARNING: failed to restore connection between input_Ports_20 and readPDBQT_22 in network ADTloadmolecule_19.macroNetwork"
    if input_Ports_20 is not None and AD4gpf_readGPF_27 is not None:
        try:
            ADTloadmolecule_19.macroNetwork.connectNodes(
                input_Ports_20, AD4gpf_readGPF_27, "new", "gpffile", blocking=True
                , splitratio=[1.0, 0.47837837837837838])
        except:
            print "WARNING: failed to restore connection between input_Ports_20 and AD4gpf_readGPF_27 in network ADTloadmolecule_19.macroNetwork"
    if readPDBQT_22 is not None and computeMSMS_25 is not None:
        try:
            ADTloadmolecule_19.macroNetwork.specialConnectNodes(
                readPDBQT_22, computeMSMS_25, "trigger", "runNode", blocking=True
                , splitratio=[0.424003001233481, 0.60806784046166307])
        except:
            print "WARNING: failed to restore connection between readPDBQT_22 and computeMSMS_25 in network ADTloadmolecule_19.macroNetwork"
    if computeMSMS_25 is not None and AD4gpf_readGPF_27 is not None:
        try:
            ADTloadmolecule_19.macroNetwork.specialConnectNodes(
                computeMSMS_25, AD4gpf_readGPF_27, "trigger", "runNode", blocking=True
                , splitratio=[0.3536715988664445, 0.61638488986784223])
        except:
            print "WARNING: failed to restore connection between computeMSMS_25 and AD4gpf_readGPF_27 in network ADTloadmolecule_19.macroNetwork"
    if input_Ports_20 is not None and eval__in1_replace______28 is not None:
        try:
            ADTloadmolecule_19.macroNetwork.connectNodes(
                input_Ports_20, eval__in1_replace______28, "new", "in1", blocking=True
                , splitratio=[0.73721307871736474, 0.39051113795567749])
        except:
            print "WARNING: failed to restore connection between input_Ports_20 and eval__in1_replace______28 in network ADTloadmolecule_19.macroNetwork"
    if eval__in1_replace______28 is not None and computeMSMS_25 is not None:
        try:
            ADTloadmolecule_19.macroNetwork.connectNodes(
                eval__in1_replace______28, computeMSMS_25, "result", "nodes", blocking=True
                , splitratio=[0.55902791513238481, 0.34592554764257855])
        except:
            print "WARNING: failed to restore connection between eval__in1_replace______28 and computeMSMS_25 in network ADTloadmolecule_19.macroNetwork"
    ADTloadmolecule_19.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_20.outputPorts[1].configure(name='readPDBQT_filename')
    input_Ports_20.outputPorts[2].configure(name='AD4gpf_readGPF_gpffile')
    input_Ports_20.outputPorts[3].configure(name='eval:_in1.replace(-..._in1')
    ADTloadmolecule_19.inputPorts[0].configure(name='readPDBQT_filename')
    ADTloadmolecule_19.inputPorts[0].configure(datatype='string')
    ADTloadmolecule_19.inputPorts[1].configure(name='AD4gpf_readGPF_gpffile')
    ADTloadmolecule_19.inputPorts[1].configure(datatype='string')
    ADTloadmolecule_19.inputPorts[2].configure(name='eval:_in1.replace(-..._in1')
    ADTloadmolecule_19.inputPorts[2].configure(datatype='None')
    ## configure MacroNode input ports
    ## configure MacroNode output ports
    ADTloadmolecule_19.shrink()
    apply(ADTloadmolecule_19.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named ADTloadmolecule in network masterNet"
    print_exc()
    ADTloadmolecule_19=None

try:
    ## saving node prepareGPF ##
    from NetworkEditor.macros import MacroNode
    prepareGPF_29 = MacroNode(name='prepareGPF')
    masterNet.addNode(prepareGPF_29, 82, 194)
    output_Ports_31 = prepareGPF_29.macroNetwork.opNode
    apply(output_Ports_31.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_31.move(78, 383)
    from WebServices.VisionInterface.WSNodes import DownloadNode
    Download_32 = DownloadNode(constrkw={}, name='Download', library=wslib)
    prepareGPF_29.macroNetwork.addNode(Download_32,95,247)
    Download_32.inputPortByName['url'].rebindWidget()
    Download_32.inputPortByName['url'].widget.set(r"", run=False)
    Download_32.inputPortByName['url'].unbindWidget()
    apply(Download_32.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Split
    Split_33 = Split(constrkw={}, name='Split', library=stdlib)
    prepareGPF_29.macroNetwork.addNode(Split_33,95,184)
    apply(Split_33.addOutputPort, (), {'name': '3', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Split_33.addOutputPort, (), {'name': '0', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Split_33.addOutputPort, (), {'name': '1', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Split_33.addOutputPort, (), {'name': '2', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    code = """def doit(self, data):
    # we remove all the not connected output ports
    lOutputPorts = self.outputPorts[:]
    for port in lOutputPorts:
        if len(port.connections) == 0:
            self.deletePort(port)

    # we add all the missing output ports
    if data is not None and len(data) > 0:
        for lValueIndex in range(len(data)):
            lPortName = str(lValueIndex)
            for p in self.outputPorts:
                if p.name == lPortName:
                    break
            else: # we didn'''t break
                self.addOutputPort(name=lPortName)
            lPort = self.getOutputPortByName(lPortName)
            lPort.outputData(data[lValueIndex])
## to ouput data on port 3 use
## self.outputData(3=data)
## to ouput data on port 0 use
## self.outputData(0=data)
## to ouput data on port 1 use
## self.outputData(1=data)
## to ouput data on port 2 use
## self.outputData(2=data)
"""
    Split_33.configure(function=code)
    apply(Split_33.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import SaveLines
    Save_Lines_34 = SaveLines(constrkw={}, name='Save Lines', library=stdlib)
    prepareGPF_29.macroNetwork.addNode(Save_Lines_34,95,312)
    apply(Save_Lines_34.configure, (), {'specialPortsVisible': True})
    Save_Lines_34.inputPortByName['filename'].rebindWidget()
    Save_Lines_34.inputPortByName['filename'].widget.set(r"3ptb_rec.gpf", run=False)
    Save_Lines_34.inputPortByName['filename'].unbindWidget()
    apply(Save_Lines_34.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from NetworkEditor.items import FunctionNode
    prepareGPF_kryptonite_nbcr_net_35 = FunctionNode(functionOrString='prepareGPF_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", namedArgs={'singlelib': '', 'r_url': '', 'zpoints': '', 'lib': '', 'ypoints': '', 'gpf': '', 'xcenter': 'auto', 'urllib': '', 'p': '', 'r': '', 'o': '', 'zcenter': 'auto', 'v': False, 'userlib': '', 'xpoints': '', 'localRun': False, 'ycenter': 'auto', 'execPath': ''}, constrkw={'functionOrString': "'prepareGPF_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'namedArgs': {'singlelib': '', 'r_url': '', 'zpoints': '', 'lib': '', 'ypoints': '', 'gpf': '', 'xcenter': 'auto', 'urllib': '', 'p': '', 'r': '', 'o': '', 'zcenter': 'auto', 'v': False, 'userlib': '', 'xpoints': '', 'localRun': False, 'ycenter': 'auto', 'execPath': ''}}, name='prepareGPF_kryptonite_nbcr_net', library=wslib)
    prepareGPF_29.macroNetwork.addNode(prepareGPF_kryptonite_nbcr_net_35,101,124)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['singlelib'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['r_url'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['zpoints'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['lib'].rebindWidget()
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['lib'].widget.set(r"sample", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['lib'].unbindWidget()
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['ypoints'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['gpf'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['xcenter'].widget.set(r"auto", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['urllib'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['p'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['r'].rebindWidget()
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['r'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['r'].unbindWidget()
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['o'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['zcenter'].widget.set(r"auto", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['v'].widget.set(0, run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['userlib'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['xpoints'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['localRun'].widget.set(0, run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['ycenter'].widget.set(r"auto", run=False)
    prepareGPF_kryptonite_nbcr_net_35.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(prepareGPF_kryptonite_nbcr_net_35.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Eval
    GPFFileName_36 = Eval(constrkw={}, name='GPFFileName', library=stdlib)
    prepareGPF_29.macroNetwork.addNode(GPFFileName_36,338,125)
    GPFFileName_36.inputPortByName['command'].widget.set(r"in1 + '.gpf'", run=False)
    GPFFileName_36.inputPortByName['importString'].widget.set(r"", run=False)
    apply(GPFFileName_36.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network prepareGPF ##
    prepareGPF_29.macroNetwork.freeze()
    if Download_32 is not None and Save_Lines_34 is not None:
        try:
            prepareGPF_29.macroNetwork.connectNodes(
                Download_32, Save_Lines_34, "output", "data", blocking=True
                , splitratio=[0.5471461973279752, 0.2207226287877346])
        except:
            print "WARNING: failed to restore connection between Download_32 and Save_Lines_34 in network prepareGPF_29.macroNetwork"
    if prepareGPF_kryptonite_nbcr_net_35 is not None and Split_33 is not None:
        try:
            prepareGPF_29.macroNetwork.connectNodes(
                prepareGPF_kryptonite_nbcr_net_35, Split_33, "result", "data", blocking=True
                , splitratio=[0.60963152091497053, 0.36782664765213124])
        except:
            print "WARNING: failed to restore connection between prepareGPF_kryptonite_nbcr_net_35 and Split_33 in network prepareGPF_29.macroNetwork"
    if Split_33 is not None and Download_32 is not None:
        try:
            prepareGPF_29.macroNetwork.connectNodes(
                Split_33, Download_32, "3", "url", blocking=True
                , splitratio=[0.51906847179717841, 0.4256731668171384])
        except:
            print "WARNING: failed to restore connection between Split_33 and Download_32 in network prepareGPF_29.macroNetwork"
    input_Ports_30 = prepareGPF_29.macroNetwork.ipNode
    if input_Ports_30 is not None and prepareGPF_kryptonite_nbcr_net_35 is not None:
        try:
            prepareGPF_29.macroNetwork.connectNodes(
                input_Ports_30, prepareGPF_kryptonite_nbcr_net_35, "new", "r", blocking=True
                , splitratio=[0.56051955600231751, 0.49705672982643151])
        except:
            print "WARNING: failed to restore connection between input_Ports_30 and prepareGPF_kryptonite_nbcr_net_35 in network prepareGPF_29.macroNetwork"
    output_Ports_31 = prepareGPF_29.macroNetwork.opNode
    if Save_Lines_34 is not None and output_Ports_31 is not None:
        try:
            prepareGPF_29.macroNetwork.connectNodes(
                Save_Lines_34, output_Ports_31, "filename", "new", blocking=True
                , splitratio=[0.69952830894874551, 0.6430271640248364])
        except:
            print "WARNING: failed to restore connection between Save_Lines_34 and output_Ports_31 in network prepareGPF_29.macroNetwork"
    if input_Ports_30 is not None and prepareGPF_kryptonite_nbcr_net_35 is not None:
        try:
            prepareGPF_29.macroNetwork.connectNodes(
                input_Ports_30, prepareGPF_kryptonite_nbcr_net_35, "new", "lib", blocking=True
                , splitratio=[0.50188105519963, 0.59956474883215771])
        except:
            print "WARNING: failed to restore connection between input_Ports_30 and prepareGPF_kryptonite_nbcr_net_35 in network prepareGPF_29.macroNetwork"
    if input_Ports_30 is not None and GPFFileName_36 is not None:
        try:
            prepareGPF_29.macroNetwork.connectNodes(
                input_Ports_30, GPFFileName_36, "new", "in1", blocking=True
                , splitratio=[0.64965761626138674, 0.71035424489116306])
        except:
            print "WARNING: failed to restore connection between input_Ports_30 and GPFFileName_36 in network prepareGPF_29.macroNetwork"
    if GPFFileName_36 is not None and Save_Lines_34 is not None:
        try:
            prepareGPF_29.macroNetwork.connectNodes(
                GPFFileName_36, Save_Lines_34, "result", "filename", blocking=True
                , splitratio=[0.24475621308815357, 0.35477484048751212])
        except:
            print "WARNING: failed to restore connection between GPFFileName_36 and Save_Lines_34 in network prepareGPF_29.macroNetwork"
    prepareGPF_29.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_30.outputPorts[1].configure(name='prepareGPF_kryptonite_nbcr_net_r')
    input_Ports_30.outputPorts[2].configure(name='prepareGPF_kryptonite_nbcr_net_lib')
    input_Ports_30.outputPorts[3].configure(name='GPFFileName_in1')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_31.inputPorts[1].configure(singleConnection='auto')
    output_Ports_31.inputPorts[1].configure(name='Save_Lines_filename')
    prepareGPF_29.inputPorts[0].configure(name='prepareGPF_kryptonite_nbcr_net_r')
    prepareGPF_29.inputPorts[0].configure(datatype='string')
    prepareGPF_29.inputPorts[1].configure(name='prepareGPF_kryptonite_nbcr_net_lib')
    prepareGPF_29.inputPorts[1].configure(datatype='string')
    prepareGPF_29.inputPorts[2].configure(name='GPFFileName_in1')
    prepareGPF_29.inputPorts[2].configure(datatype='None')
    ## configure MacroNode input ports
    prepareGPF_29.outputPorts[0].configure(name='Save_Lines_filename')
    prepareGPF_29.outputPorts[0].configure(datatype='string')
    ## configure MacroNode output ports
    prepareGPF_29.shrink()
    apply(prepareGPF_29.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named prepareGPF in network masterNet"
    print_exc()
    prepareGPF_29=None

try:
    ## saving node prepareReceptor ##
    from NetworkEditor.macros import MacroNode
    prepareReceptor_37 = MacroNode(name='prepareReceptor')
    masterNet.addNode(prepareReceptor_37, 21, 106)
    input_Ports_38 = prepareReceptor_37.macroNetwork.ipNode
    apply(input_Ports_38.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    input_Ports_38.move(94, 13)
    output_Ports_39 = prepareReceptor_37.macroNetwork.opNode
    apply(output_Ports_39.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_39.move(288, 652)
    from NetworkEditor.items import FunctionNode
    Pdb2pqrOpalService_ws_nbcr_net_40 = FunctionNode(functionOrString='Pdb2pqrOpalService_ws_nbcr_net', host="http://ws.nbcr.net/opal", namedArgs={'noopt': False, 'phi': False, 'psi': False, 'verbose': True, 'chain': False, 'nodebump': False, 'chi': False, 'output_file': '', 'ligand': '', 'hbond': False, 'inFile': '', 'with_ph': '', 'forcefield': 'AMBER', 'clean': False, 'inId': '', 'apbs_input': False, 'ffout': '', 'localRun': False, 'rama': False, 'execPath': '', 'assign_only': False}, constrkw={'functionOrString': "'Pdb2pqrOpalService_ws_nbcr_net'", 'host': '"http://ws.nbcr.net/opal"', 'namedArgs': {'noopt': False, 'phi': False, 'psi': False, 'verbose': True, 'chain': False, 'nodebump': False, 'chi': False, 'output_file': '', 'ligand': '', 'hbond': False, 'inFile': '', 'with_ph': '', 'forcefield': 'AMBER', 'clean': False, 'inId': '', 'apbs_input': False, 'ffout': '', 'localRun': False, 'rama': False, 'execPath': '', 'assign_only': False}}, name='Pdb2pqrOpalService_ws_nbcr_net', library=wslib)
    prepareReceptor_37.macroNetwork.addNode(Pdb2pqrOpalService_ws_nbcr_net_40,70,169)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['noopt'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['phi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['psi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['verbose'].widget.set(1, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['chain'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['nodebump'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['chi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['output_file'].rebindWidget()
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['output_file'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['output_file'].unbindWidget()
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['ligand'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['hbond'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['inFile'].rebindWidget()
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['inFile'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['inFile'].unbindWidget()
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['with_ph'].widget.set(r"6.5", run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['forcefield'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['forcefield'].widget.set(r"AMBER", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['clean'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['inId'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['apbs_input'].widget.set(0, run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['ffout'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['ffout'].widget.set(r"AMBER", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['localRun'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['rama'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['execPath'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_40.inputPortByName['assign_only'].widget.set(0, run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_40.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from NetworkEditor.items import FunctionNode
    PrepareReceptorOpalService_ws_nbcr_net_41 = FunctionNode(functionOrString='PrepareReceptorOpalService_ws_nbcr_net', host="http://ws.nbcr.net/opal", namedArgs={'C': False, 'url': '', 'o': '', 'r': '', 'v': False, 'localRun': False, 'execPath': ''}, constrkw={'functionOrString': "'PrepareReceptorOpalService_ws_nbcr_net'", 'host': '"http://ws.nbcr.net/opal"', 'namedArgs': {'C': False, 'url': '', 'o': '', 'r': '', 'v': False, 'localRun': False, 'execPath': ''}}, name='PrepareReceptorOpalService_ws_nbcr_net', library=wslib)
    prepareReceptor_37.macroNetwork.addNode(PrepareReceptorOpalService_ws_nbcr_net_41,128,414)
    PrepareReceptorOpalService_ws_nbcr_net_41.inputPortByName['C'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_41.inputPortByName['url'].widget.set(r"", run=False)
    PrepareReceptorOpalService_ws_nbcr_net_41.inputPortByName['o'].widget.set(r"", run=False)
    PrepareReceptorOpalService_ws_nbcr_net_41.inputPortByName['r'].rebindWidget()
    PrepareReceptorOpalService_ws_nbcr_net_41.inputPortByName['r'].widget.set(r"", run=False)
    PrepareReceptorOpalService_ws_nbcr_net_41.inputPortByName['r'].unbindWidget()
    PrepareReceptorOpalService_ws_nbcr_net_41.inputPortByName['v'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_41.inputPortByName['localRun'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_41.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(PrepareReceptorOpalService_ws_nbcr_net_41.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from WebServices.VisionInterface.WSNodes import DownloadNode
    Download_42 = DownloadNode(constrkw={}, name='Download', library=wslib)
    prepareReceptor_37.macroNetwork.addNode(Download_42,70,293)
    Download_42.inputPortByName['url'].rebindWidget()
    Download_42.inputPortByName['url'].widget.set(r"", run=False)
    Download_42.inputPortByName['url'].unbindWidget()
    apply(Download_42.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import SaveLines
    Save_Lines_43 = SaveLines(constrkw={}, name='Save Lines', library=stdlib)
    prepareReceptor_37.macroNetwork.addNode(Save_Lines_43,128,352)
    Save_Lines_43.inputPortByName['filename'].rebindWidget()
    Save_Lines_43.inputPortByName['filename'].widget.set(r"", run=False)
    Save_Lines_43.inputPortByName['filename'].unbindWidget()
    apply(Save_Lines_43.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    output_file_name_44 = Eval(constrkw={}, name='output_file_name', library=stdlib)
    prepareReceptor_37.macroNetwork.addNode(output_file_name_44,143,105)
    apply(output_file_name_44.inputPortByName['in1'].configure, (), {'datatype': 'string', 'originalDatatype': 'None'})
    output_file_name_44.inputPortByName['command'].widget.set(r"(os.path.basename(in1)).replace('.pdb','.pqr')", run=False)
    output_file_name_44.inputPortByName['importString'].widget.set(r"os", run=False)
    apply(output_file_name_44.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    get_PQR_file_45 = Generic(constrkw={}, name='get_PQR_file', library=stdlib)
    prepareReceptor_37.macroNetwork.addNode(get_PQR_file_45,70,228)
    apply(get_PQR_file_45.addInputPort, (), {'singleConnection': True, 'name': 'in1', 'cast': 1, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(get_PQR_file_45.addOutputPort, (), {'name': 'out1', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(get_PQR_file_45.configure, (), {'specialPortsVisible': True})
    code = """def doit(self, in1):
    for i in in1:
        if i.endswith('''.pqr'''):
            self.outputData(out1=i)
            return

## to ouput data on port out1 use
## self.outputData(out1=data)

"""
    get_PQR_file_45.configure(function=code)
    apply(get_PQR_file_45.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    get_PQR_file_46 = Generic(constrkw={}, name='get_PQR_file', library=stdlib)
    prepareReceptor_37.macroNetwork.addNode(get_PQR_file_46,128,470)
    apply(get_PQR_file_46.addInputPort, (), {'singleConnection': True, 'name': 'in1', 'cast': 1, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(get_PQR_file_46.addOutputPort, (), {'name': 'out1', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(get_PQR_file_46.configure, (), {'specialPortsVisible': True})
    code = """def doit(self, in1):
    for i in in1:
        if i.endswith('''.pdbqt'''):
            self.outputData(out1=i)
            return

## to ouput data on port out1 use
## self.outputData(out1=data)


"""
    get_PQR_file_46.configure(function=code)
    apply(get_PQR_file_46.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
    from WebServices.VisionInterface.WSNodes import DownloadNode
    Download_47 = DownloadNode(constrkw={}, name='Download', library=wslib)
    prepareReceptor_37.macroNetwork.addNode(Download_47,129,530)
    Download_47.inputPortByName['url'].rebindWidget()
    Download_47.inputPortByName['url'].widget.set(r"", run=False)
    Download_47.inputPortByName['url'].unbindWidget()
    apply(Download_47.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import SaveLines
    Save_Lines_48 = SaveLines(constrkw={}, name='Save Lines', library=stdlib)
    prepareReceptor_37.macroNetwork.addNode(Save_Lines_48,195,593)
    Save_Lines_48.inputPortByName['filename'].rebindWidget()
    Save_Lines_48.inputPortByName['filename'].widget.set(r"", run=False)
    Save_Lines_48.inputPortByName['filename'].unbindWidget()
    apply(Save_Lines_48.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    Molecule_basename_49 = Eval(constrkw={}, name='Molecule_basename', library=stdlib)
    prepareReceptor_37.macroNetwork.addNode(Molecule_basename_49,222,529)
    apply(Molecule_basename_49.inputPortByName['in1'].configure, (), {'datatype': 'string', 'originalDatatype': 'None'})
    Molecule_basename_49.inputPortByName['command'].widget.set(r"os.path.basename(in1)", run=False)
    Molecule_basename_49.inputPortByName['importString'].widget.set(r"os", run=False)
    apply(Molecule_basename_49.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    moleculeName_50 = Eval(constrkw={}, name='moleculeName', library=stdlib)
    prepareReceptor_37.macroNetwork.addNode(moleculeName_50,322,91)
    moleculeName_50.inputPortByName['command'].widget.set(r"in1.rstrip('.pdb')", run=False)
    moleculeName_50.inputPortByName['importString'].widget.set(r"", run=False)
    apply(moleculeName_50.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network prepareReceptor ##
    prepareReceptor_37.macroNetwork.freeze()
    if Download_42 is not None and Save_Lines_43 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                Download_42, Save_Lines_43, "output", "data", blocking=True
                , splitratio=[0.36827280113261895, 0.64697287632017964])
        except:
            print "WARNING: failed to restore connection between Download_42 and Save_Lines_43 in network prepareReceptor_37.macroNetwork"
    if Save_Lines_43 is not None and PrepareReceptorOpalService_ws_nbcr_net_41 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                Save_Lines_43, PrepareReceptorOpalService_ws_nbcr_net_41, "filename", "r", blocking=True
                , splitratio=[0.26127683776860539, 0.60475029192198448])
        except:
            print "WARNING: failed to restore connection between Save_Lines_43 and PrepareReceptorOpalService_ws_nbcr_net_41 in network prepareReceptor_37.macroNetwork"
    if output_file_name_44 is not None and Pdb2pqrOpalService_ws_nbcr_net_40 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                output_file_name_44, Pdb2pqrOpalService_ws_nbcr_net_40, "result", "output_file", blocking=True
                , splitratio=[0.60421348235588523, 0.592140438680123])
        except:
            print "WARNING: failed to restore connection between output_file_name_44 and Pdb2pqrOpalService_ws_nbcr_net_40 in network prepareReceptor_37.macroNetwork"
    if output_file_name_44 is not None and Save_Lines_43 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                output_file_name_44, Save_Lines_43, "result", "filename", blocking=True
                , splitratio=[0.42349139321771523, 0.21214185214925788])
        except:
            print "WARNING: failed to restore connection between output_file_name_44 and Save_Lines_43 in network prepareReceptor_37.macroNetwork"
    if Pdb2pqrOpalService_ws_nbcr_net_40 is not None and get_PQR_file_45 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                Pdb2pqrOpalService_ws_nbcr_net_40, get_PQR_file_45, "result", "in1", blocking=True
                , splitratio=[0.44150506985278171, 0.74431459196773875])
        except:
            print "WARNING: failed to restore connection between Pdb2pqrOpalService_ws_nbcr_net_40 and get_PQR_file_45 in network prepareReceptor_37.macroNetwork"
    if get_PQR_file_45 is not None and Download_42 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                get_PQR_file_45, Download_42, "out1", "url", blocking=True
                , splitratio=[0.5853067652571553, 0.32803418578915733])
        except:
            print "WARNING: failed to restore connection between get_PQR_file_45 and Download_42 in network prepareReceptor_37.macroNetwork"
    if PrepareReceptorOpalService_ws_nbcr_net_41 is not None and get_PQR_file_46 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                PrepareReceptorOpalService_ws_nbcr_net_41, get_PQR_file_46, "result", "in1", blocking=True
                , splitratio=[0.25718005340471095, 0.72103023725687843])
        except:
            print "WARNING: failed to restore connection between PrepareReceptorOpalService_ws_nbcr_net_41 and get_PQR_file_46 in network prepareReceptor_37.macroNetwork"
    if Download_47 is not None and Save_Lines_48 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                Download_47, Save_Lines_48, "output", "data", blocking=True
                , splitratio=[0.49489433472114652, 0.57257925412591537])
        except:
            print "WARNING: failed to restore connection between Download_47 and Save_Lines_48 in network prepareReceptor_37.macroNetwork"
    if get_PQR_file_46 is not None and Download_47 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                get_PQR_file_46, Download_47, "out1", "url", blocking=True
                , splitratio=[0.29461646845140871, 0.32194350721134524])
        except:
            print "WARNING: failed to restore connection between get_PQR_file_46 and Download_47 in network prepareReceptor_37.macroNetwork"
    if get_PQR_file_46 is not None and Molecule_basename_49 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                get_PQR_file_46, Molecule_basename_49, "out1", "in1", blocking=True
                , splitratio=[0.65208646788684343, 0.22421009353093341])
        except:
            print "WARNING: failed to restore connection between get_PQR_file_46 and Molecule_basename_49 in network prepareReceptor_37.macroNetwork"
    if Molecule_basename_49 is not None and Save_Lines_48 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                Molecule_basename_49, Save_Lines_48, "result", "filename", blocking=True
                , splitratio=[0.47964835294965058, 0.2330604290732039])
        except:
            print "WARNING: failed to restore connection between Molecule_basename_49 and Save_Lines_48 in network prepareReceptor_37.macroNetwork"
    input_Ports_38 = prepareReceptor_37.macroNetwork.ipNode
    if input_Ports_38 is not None and output_file_name_44 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                input_Ports_38, output_file_name_44, "new", "in1", blocking=True
                , splitratio=[0.31114392362602006, 0.56977692284428305])
        except:
            print "WARNING: failed to restore connection between input_Ports_38 and output_file_name_44 in network prepareReceptor_37.macroNetwork"
    output_Ports_39 = prepareReceptor_37.macroNetwork.opNode
    if Save_Lines_48 is not None and output_Ports_39 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                Save_Lines_48, output_Ports_39, "filename", "new", blocking=True
                , splitratio=[0.50555167702997239, 0.21304301197103559])
        except:
            print "WARNING: failed to restore connection between Save_Lines_48 and output_Ports_39 in network prepareReceptor_37.macroNetwork"
    if input_Ports_38 is not None and Pdb2pqrOpalService_ws_nbcr_net_40 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                input_Ports_38, Pdb2pqrOpalService_ws_nbcr_net_40, "output_file_name_in1", "inFile", blocking=True
                , splitratio=[0.40102655123873254, 0.30725056190426414])
        except:
            print "WARNING: failed to restore connection between input_Ports_38 and Pdb2pqrOpalService_ws_nbcr_net_40 in network prepareReceptor_37.macroNetwork"
    if input_Ports_38 is not None and moleculeName_50 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                input_Ports_38, moleculeName_50, "output_file_name_in1", "in1", blocking=True
                , splitratio=[0.28411077626396108, 0.33430813527118652])
        except:
            print "WARNING: failed to restore connection between input_Ports_38 and moleculeName_50 in network prepareReceptor_37.macroNetwork"
    if moleculeName_50 is not None and output_Ports_39 is not None:
        try:
            prepareReceptor_37.macroNetwork.connectNodes(
                moleculeName_50, output_Ports_39, "result", "new", blocking=True
                , splitratio=[0.28495356719896592, 0.59090971100919876])
        except:
            print "WARNING: failed to restore connection between moleculeName_50 and output_Ports_39 in network prepareReceptor_37.macroNetwork"
    prepareReceptor_37.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_38.outputPorts[1].configure(name='output_file_name_in1')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_39.inputPorts[1].configure(singleConnection='auto')
    output_Ports_39.inputPorts[2].configure(singleConnection='auto')
    output_Ports_39.inputPorts[1].configure(name='Save_Lines_filename')
    output_Ports_39.inputPorts[2].configure(name='moleculeName_result')
    prepareReceptor_37.inputPorts[0].configure(name='output_file_name_in1')
    prepareReceptor_37.inputPorts[0].configure(datatype='string')
    ## configure MacroNode input ports
    prepareReceptor_37.outputPorts[0].configure(name='Save_Lines_filename')
    prepareReceptor_37.outputPorts[0].configure(datatype='string')
    prepareReceptor_37.outputPorts[1].configure(name='moleculeName_result')
    prepareReceptor_37.outputPorts[1].configure(datatype='None')
    ## configure MacroNode output ports
    prepareReceptor_37.shrink()
    apply(prepareReceptor_37.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named prepareReceptor in network masterNet"
    print_exc()
    prepareReceptor_37=None

try:
    ## saving node LibraryName ##
    from Vision.StandardNodes import ComboBoxNE
    LibraryName_51 = ComboBoxNE(constrkw={}, name='LibraryName', library=stdlib)
    masterNet.addNode(LibraryName_51,306,62)
    apply(LibraryName_51.inputPortByName['selection'].widget.configure, (), {'choices': ['sample', 'NCIDiversity']})
    LibraryName_51.inputPortByName['selection'].widget.set(r"sample", run=False)
    apply(LibraryName_51.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ComboBoxNE named LibraryName in network masterNet"
    print_exc()
    LibraryName_51=None

try:
    ## saving node eval: [sample, NCI... ##
    from Vision.StandardNodes import Eval
    eval___sample__NCI____52 = Eval(constrkw={}, name='eval: [sample, NCI...', library=stdlib)
    masterNet.addNode(eval___sample__NCI____52,504,7)
    eval___sample__NCI____52.inputPortByName['command'].widget.set(r"['sample', 'NCIDiversity']", run=False)
    eval___sample__NCI____52.inputPortByName['importString'].widget.set(r"", run=False)
    apply(eval___sample__NCI____52.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Eval named eval: [sample, NCI... in network masterNet"
    print_exc()
    eval___sample__NCI____52=None

#masterNet.run()
masterNet.freeze()

## saving connections for network ScreeningADT ##
prepareReceptor_37 = masterNet.nodes[7]
if Receptor_File_0 is not None and prepareReceptor_37 is not None:
    try:
        masterNet.connectNodes(
            Receptor_File_0, prepareReceptor_37, "filename", "output_file_name_in1", blocking=True
            , splitratio=[0.39216074492000064, 0.44507995139058715])
    except:
        print "WARNING: failed to restore connection between Receptor_File_0 and prepareReceptor_37 in network masterNet"
if eval___sample__NCI____52 is not None and LibraryName_51 is not None:
    try:
        masterNet.connectNodes(
            eval___sample__NCI____52, LibraryName_51, "result", "valueList", blocking=True
            , splitratio=[0.47729994318698177, 0.58017916248968082])
    except:
        print "WARNING: failed to restore connection between eval___sample__NCI____52 and LibraryName_51 in network masterNet"
prepareGPF_29 = masterNet.nodes[6]
if LibraryName_51 is not None and prepareGPF_29 is not None:
    try:
        masterNet.connectNodes(
            LibraryName_51, prepareGPF_29, "selection", "prepareGPF_kryptonite_nbcr_net_lib", blocking=True
            , splitratio=[0.46706920792491124, 0.23912463516851185])
    except:
        print "WARNING: failed to restore connection between LibraryName_51 and prepareGPF_29 in network masterNet"
autodock_screening_3 = masterNet.nodes[3]
if LibraryName_51 is not None and autodock_screening_3 is not None:
    try:
        masterNet.connectNodes(
            LibraryName_51, autodock_screening_3, "selection", "autodock_kryptonite_nbcr_net_lib", blocking=True
            , splitratio=[0.66013456195905329, 0.73867479494317512])
    except:
        print "WARNING: failed to restore connection between LibraryName_51 and autodock_screening_3 in network masterNet"
autogrid6_13 = masterNet.nodes[4]
if ReceptorPDBQT_1 is not None and autogrid6_13 is not None:
    try:
        masterNet.connectNodes(
            ReceptorPDBQT_1, autogrid6_13, "filename", "autogrid_kryptonite_nbcr_net_inFile", blocking=True
            , splitratio=[0.22628348581607899, 0.70500553094995833])
    except:
        print "WARNING: failed to restore connection between ReceptorPDBQT_1 and autogrid6_13 in network masterNet"
if GPFFile_2 is not None and autogrid6_13 is not None:
    try:
        masterNet.connectNodes(
            GPFFile_2, autogrid6_13, "filename", "autogrid_kryptonite_nbcr_net_p", blocking=True
            , splitratio=[0.45071556062233353, 0.26349352233293599])
    except:
        print "WARNING: failed to restore connection between GPFFile_2 and autogrid6_13 in network masterNet"
if prepareReceptor_37 is not None and prepareGPF_29 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_37, prepareGPF_29, "moleculeName_result", "GPFFileName_in1", blocking=True
            , splitratio=[0.65254165222357141, 0.5134920338843294])
    except:
        print "WARNING: failed to restore connection between prepareReceptor_37 and prepareGPF_29 in network masterNet"
ADTloadmolecule_19 = masterNet.nodes[5]
if prepareGPF_29 is not None and ADTloadmolecule_19 is not None:
    try:
        masterNet.connectNodes(
            prepareGPF_29, ADTloadmolecule_19, "Save_Lines_filename", "AD4gpf_readGPF_gpffile", blocking=True
            , splitratio=[0.25956542897007479, 0.46743137569401533])
    except:
        print "WARNING: failed to restore connection between prepareGPF_29 and ADTloadmolecule_19 in network masterNet"
if prepareReceptor_37 is not None and ADTloadmolecule_19 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_37, ADTloadmolecule_19, "Save_Lines_filename", "readPDBQT_filename", blocking=True
            , splitratio=[0.38252212921998086, 0.64101837959357943])
    except:
        print "WARNING: failed to restore connection between prepareReceptor_37 and ADTloadmolecule_19 in network masterNet"
if prepareReceptor_37 is not None and prepareGPF_29 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_37, prepareGPF_29, "Save_Lines_filename", "prepareGPF_kryptonite_nbcr_net_r", blocking=True
            , splitratio=[0.48375814502252534, 0.42416956778745468])
    except:
        print "WARNING: failed to restore connection between prepareReceptor_37 and prepareGPF_29 in network masterNet"
if prepareReceptor_37 is not None and ReceptorPDBQT_1 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_37, ReceptorPDBQT_1, "Save_Lines_filename", "filename", blocking=True
            , splitratio=[0.23053278095705415, 0.44557924978782842])
    except:
        print "WARNING: failed to restore connection between prepareReceptor_37 and ReceptorPDBQT_1 in network masterNet"
if prepareGPF_29 is not None and GPFFile_2 is not None:
    try:
        masterNet.connectNodes(
            prepareGPF_29, GPFFile_2, "Save_Lines_filename", "filename", blocking=True
            , splitratio=[0.46689623206843001, 0.20549487490599236])
    except:
        print "WARNING: failed to restore connection between prepareGPF_29 and GPFFile_2 in network masterNet"
if prepareReceptor_37 is not None and ADTloadmolecule_19 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_37, ADTloadmolecule_19, "moleculeName_result", "eval:_in1.replace(-..._in1", blocking=True
            , splitratio=[0.7061822277931129, 0.67266719597177405])
    except:
        print "WARNING: failed to restore connection between prepareReceptor_37 and ADTloadmolecule_19 in network masterNet"
if autogrid6_13 is not None and autodock_screening_3 is not None:
    try:
        masterNet.connectNodes(
            autogrid6_13, autodock_screening_3, "eval:_in1+/.._result", "autodock_kryptonite_nbcr_net_u", blocking=True
            , splitratio=[0.52869951980473184, 0.63841449365863878])
    except:
        print "WARNING: failed to restore connection between autogrid6_13 and autodock_screening_3 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

