/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safehtml.shared;

import com.google.gwt.core.client.GWT;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.streamhtmlparser.HtmlParser;
import com.google.gwt.thirdparty.streamhtmlparser.HtmlParserFactory;
import com.google.gwt.thirdparty.streamhtmlparser.ParseException;

public class SafeHtmlHostedModeUtils {
    public static final String FORCE_CHECK_COMPLETE_HTML = "com.google.gwt.safehtml.ForceCheckCompleteHtml";
    private static boolean forceCheckCompleteHtml;

    public static void maybeCheckCompleteHtml(String html) {
        if (GWT.isClient() || forceCheckCompleteHtml) {
            Preconditions.checkArgument((boolean)SafeHtmlHostedModeUtils.isCompleteHtml(html), (String)"String is not complete HTML (ends in non-inner-HTML context): %s", (Object[])new Object[]{html});
        } else assert (SafeHtmlHostedModeUtils.isCompleteHtml(html)) : "String is not complete HTML (ends in non-inner-HTML context): " + html;
    }

    public static void setForceCheckCompleteHtml(boolean check) {
        forceCheckCompleteHtml = check;
    }

    public static void setForceCheckCompleteHtmlFromProperty() {
        forceCheckCompleteHtml = System.getProperty(FORCE_CHECK_COMPLETE_HTML) != null;
    }

    private static boolean isCompleteHtml(String html) {
        HtmlParser htmlParser = HtmlParserFactory.createParser();
        try {
            htmlParser.parse(html);
        }
        catch (ParseException e) {
            return false;
        }
        return htmlParser.getState() == HtmlParser.STATE_TEXT;
    }

    static {
        SafeHtmlHostedModeUtils.setForceCheckCompleteHtmlFromProperty();
    }
}

