/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "lg" locale.
 */
public class LocalizedNamesImpl_lg extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AL",
        "DZ",
        "US",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AM",
        "AR",
        "AW",
        "AU",
        "AT",
        "AX",
        "IE",
        "IS",
        "AZ",
        "BH",
        "BS",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BJ",
        "BM",
        "SB",
        "IO",
        "FK",
        "CV",
        "KM",
        "MV",
        "TC",
        "AN",
        "PH",
        "CK",
        "MH",
        "MP",
        "VI",
        "KY",
        "VG",
        "BL",
        "BO",
        "BW",
        "BA",
        "BE",
        "DE",
        "FR",
        "GR",
        "BG",
        "GB",
        "BR",
        "BF",
        "BN",
        "BI",
        "BT",
        "IN",
        "BV",
        "TD",
        "CN",
        "CC",
        "CL",
        "CP",
        "CU",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EH",
        "EC",
        "SV",
        "AE",
        "ER",
        "EE",
        "ET",
        "EU",
        "FJ",
        "FI",
        "FO",
        "GA",
        "GM",
        "GH",
        "GY",
        "GQ",
        "GG",
        "GI",
        "GN",
        "GW",
        "GS",
        "GD",
        "GL",
        "GF",
        "GP",
        "GU",
        "GT",
        "GE",
        "HU",
        "HT",
        "HK",
        "HM",
        "NL",
        "HN",
        "IC",
        "IM",
        "JM",
        "JP",
        "JE",
        "DJ",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "KI",
        "KG",
        "NF",
        "CO",
        "CG",
        "CD",
        "KP",
        "KR",
        "CR",
        "CI",
        "HR",
        "KW",
        "RU",
        "LV",
        "LA",
        "LB",
        "LS",
        "RE",
        "LR",
        "LY",
        "LI",
        "CF",
        "CZ",
        "DO",
        "LT",
        "RO",
        "LU",
        "MG",
        "MW",
        "MY",
        "ML",
        "MT",
        "MQ",
        "MK",
        "MU",
        "MR",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "EG",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NG",
        "NP",
        "NE",
        "NI",
        "NU",
        "NZ",
        "NO",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PF",
        "PR",
        "PT",
        "QO",
        "RS",
        "RW",
        "WS",
        "AS",
        "SM",
        "ST",
        "SA",
        "ZA",
        "SN",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "CS",
        "SC",
        "SG",
        "ES",
        "CY",
        "LK",
        "SY",
        "SK",
        "SI",
        "SL",
        "SJ",
        "SO",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "TA",
        "TJ",
        "TM",
        "TZ",
        "TH",
        "TW",
        "TF",
        "TL",
        "TG",
        "TK",
        "TO",
        "TR",
        "TN",
        "TT",
        "TV",
        "UM",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "UY",
        "UZ",
        "YE",
        "ID",
        "IQ",
        "IR",
        "IL",
        "IT",
        "JO",
        "UG",
        "UA",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Emireeti");
    namesMap.put("AF", "Afaganisitani");
    namesMap.put("AG", "Antigwa ne Barabuda");
    namesMap.put("AI", "Angwila");
    namesMap.put("AL", "Alibaniya");
    namesMap.put("AM", "Arameniya");
    namesMap.put("AN", "Bizinga bya Antile eby'abaHolandi");
    namesMap.put("AR", "Arigentina");
    namesMap.put("AS", "Samowa omumerika");
    namesMap.put("AT", "Awusituriya");
    namesMap.put("AU", "Awusitureliya");
    namesMap.put("AZ", "Azerebayijaani");
    namesMap.put("BA", "Boziniya Hezegovina");
    namesMap.put("BB", "Barabadosi");
    namesMap.put("BD", "Bangaladesi");
    namesMap.put("BE", "Bubirigi");
    namesMap.put("BF", "Burukina Faso");
    namesMap.put("BG", "Bulugariya");
    namesMap.put("BH", "Baareeni");
    namesMap.put("BJ", "Benini");
    namesMap.put("BM", "Beremuda");
    namesMap.put("BN", "Burunayi");
    namesMap.put("BO", "Boliviya");
    namesMap.put("BR", "Buraziiri");
    namesMap.put("BS", "Bahamasi");
    namesMap.put("BT", "Butaani");
    namesMap.put("BW", "Botiswana");
    namesMap.put("BY", "Belarusi");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Kongo - Zayire");
    namesMap.put("CF", "Lipubulika eya Senturafiriki");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Switizirandi");
    namesMap.put("CI", "Kote Divwa");
    namesMap.put("CK", "Bizinga bya Kkuki");
    namesMap.put("CL", "Cile");
    namesMap.put("CM", "Kameruuni");
    namesMap.put("CN", "Cayina");
    namesMap.put("CO", "Kolombya");
    namesMap.put("CR", "Kosita Rika");
    namesMap.put("CS", "Seribya ne Monteneguro");
    namesMap.put("CV", "Bizinga by'e Kepu Veredi");
    namesMap.put("CY", "Sipuriya");
    namesMap.put("CZ", "Lipubulika ya Ceeka");
    namesMap.put("DE", "Budaaki");
    namesMap.put("DJ", "Jjibuti");
    namesMap.put("DK", "Denimaaka");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Lipubulika ya Dominika");
    namesMap.put("DZ", "Aligerya");
    namesMap.put("EC", "Ekwado");
    namesMap.put("EE", "Esitoniya");
    namesMap.put("EG", "Misiri");
    namesMap.put("ER", "Eritureya");
    namesMap.put("ES", "Sipeyini");
    namesMap.put("ET", "Esyopya");
    namesMap.put("FI", "Finilandi");
    namesMap.put("FK", "Bizinga by'eFalikalandi");
    namesMap.put("FM", "Mikuronezya");
    namesMap.put("FR", "Bufalansa");
    namesMap.put("GA", "Gaboni");
    namesMap.put("GB", "Bungereza");
    namesMap.put("GD", "Gurenada");
    namesMap.put("GE", "Gyogya");
    namesMap.put("GF", "Guyana enfalansa");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Giburalita");
    namesMap.put("GL", "Gurenelandi");
    namesMap.put("GM", "Gambya");
    namesMap.put("GN", "Gini");
    namesMap.put("GP", "Gwadalupe");
    namesMap.put("GQ", "Gayana ey'oku ekweta");
    namesMap.put("GR", "Bugereeki/Buyonaani");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwamu");
    namesMap.put("GW", "Gini-Bisawu");
    namesMap.put("GY", "Gayana");
    namesMap.put("HN", "Hundurasi");
    namesMap.put("HR", "Kurowesya");
    namesMap.put("HT", "Hayiti");
    namesMap.put("HU", "Hangare");
    namesMap.put("ID", "Yindonezya");
    namesMap.put("IE", "Ayalandi");
    namesMap.put("IL", "Yisirayeri");
    namesMap.put("IN", "Buyindi");
    namesMap.put("IO", "Bizinga by'eCago");
    namesMap.put("IQ", "Yiraaka");
    namesMap.put("IR", "Yiraani");
    namesMap.put("IS", "Ayisirandi");
    namesMap.put("IT", "Yitale");
    namesMap.put("JM", "Jamayika");
    namesMap.put("JO", "Yorodani");
    namesMap.put("JP", "Japani");
    namesMap.put("KG", "Kirigizisitaani");
    namesMap.put("KH", "Kambodya");
    namesMap.put("KM", "Bizinga by'eKomoro");
    namesMap.put("KN", "Senti Kitisi ne Nevisi");
    namesMap.put("KP", "Koreya ey'omumambuka");
    namesMap.put("KR", "Koreya ey'omumaserengeta");
    namesMap.put("KW", "Kuweti");
    namesMap.put("KY", "Bizinga ebya Kayimaani");
    namesMap.put("KZ", "Kazakisitaani");
    namesMap.put("LA", "Lawosi");
    namesMap.put("LB", "Lebanoni");
    namesMap.put("LC", "Senti Luciya");
    namesMap.put("LI", "Licitensitayini");
    namesMap.put("LK", "Sirilanka");
    namesMap.put("LR", "Liberya");
    namesMap.put("LS", "Lesoso");
    namesMap.put("LT", "Lisuwenya");
    namesMap.put("LU", "Lukisembaaga");
    namesMap.put("LV", "Lativya");
    namesMap.put("MA", "Moroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Molodova");
    namesMap.put("MG", "Madagasika");
    namesMap.put("MH", "Bizinga bya Mariso");
    namesMap.put("MK", "Masedoniya");
    namesMap.put("MM", "Myanima");
    namesMap.put("MN", "Mongoliya");
    namesMap.put("MP", "Bizinga bya Mariyana eby'omumambuka");
    namesMap.put("MQ", "Maritiniiki");
    namesMap.put("MR", "Mawulitenya");
    namesMap.put("MS", "Monteseraati");
    namesMap.put("MT", "Malita");
    namesMap.put("MU", "Mawulisyasi");
    namesMap.put("MV", "Bizinga by'eMalidive");
    namesMap.put("MX", "Mekisiko");
    namesMap.put("MY", "Malezya");
    namesMap.put("MZ", "Mozambiiki");
    namesMap.put("NA", "Namibiya");
    namesMap.put("NC", "Kaledonya mupya");
    namesMap.put("NE", "Nije");
    namesMap.put("NF", "Kizinga ky'eNorofoko");
    namesMap.put("NG", "Nayijerya");
    namesMap.put("NI", "Nikaraguwa");
    namesMap.put("NL", "Holandi");
    namesMap.put("NO", "Nowe");
    namesMap.put("NP", "Nepalo");
    namesMap.put("NR", "Nawuru");
    namesMap.put("NU", "Niyuwe");
    namesMap.put("NZ", "Niyuziirandi");
    namesMap.put("OM", "Omaani");
    namesMap.put("PF", "Polinesiya enfalansa");
    namesMap.put("PG", "Papwa Nyugini");
    namesMap.put("PH", "Bizinga bya Firipino");
    namesMap.put("PK", "Pakisitaani");
    namesMap.put("PL", "Polandi");
    namesMap.put("PM", "Senti Piyere ne Mikeloni");
    namesMap.put("PN", "Pitikeeni");
    namesMap.put("PR", "Potoriko");
    namesMap.put("PS", "Palesitayini");
    namesMap.put("PT", "Potugaali");
    namesMap.put("PW", "Palawu");
    namesMap.put("PY", "Paragwayi");
    namesMap.put("QA", "Kataa");
    namesMap.put("RE", "Leyunyoni");
    namesMap.put("RO", "Lomaniya");
    namesMap.put("RU", "Lasa");
    namesMap.put("SA", "Sawudarebya - Buwarabu");
    namesMap.put("SB", "Bizanga by'eSolomooni");
    namesMap.put("SC", "Sesere");
    namesMap.put("SD", "Sudaani");
    namesMap.put("SE", "Swideni");
    namesMap.put("SG", "Singapowa");
    namesMap.put("SH", "Senti Herena");
    namesMap.put("SI", "Sirovenya");
    namesMap.put("SK", "Sirovakya");
    namesMap.put("SL", "Siyeralewone");
    namesMap.put("SM", "Sanimarino");
    namesMap.put("SN", "Senegaalo");
    namesMap.put("SO", "Somaliya");
    namesMap.put("SR", "Surinaamu");
    namesMap.put("ST", "Sanitome ne Purincipe");
    namesMap.put("SV", "El salivado");
    namesMap.put("SY", "Siriya");
    namesMap.put("SZ", "Swazirandi");
    namesMap.put("TC", "Bizinga by'eTaaka ne Kayikosi");
    namesMap.put("TD", "Caadi");
    namesMap.put("TH", "Tayirandi");
    namesMap.put("TJ", "Tajikisitaani");
    namesMap.put("TK", "Tokelawu");
    namesMap.put("TL", "Timowa");
    namesMap.put("TM", "Takimenesitaani");
    namesMap.put("TN", "Tunisya");
    namesMap.put("TR", "Ttake");
    namesMap.put("TT", "Turindaadi ne Tobago");
    namesMap.put("TW", "Tayiwani");
    namesMap.put("TZ", "Tanzaniya");
    namesMap.put("UA", "Yukurayine");
    namesMap.put("UG", "Yuganda");
    namesMap.put("US", "Amerika");
    namesMap.put("UY", "Wurugwayi");
    namesMap.put("UZ", "Wuzibekisitaani");
    namesMap.put("VA", "Vatikaani");
    namesMap.put("VC", "Senti Vinsenti ne Gurendadiini");
    namesMap.put("VE", "Venzwera");
    namesMap.put("VG", "Bizinga ebya Virigini ebitwalibwa Bungereza");
    namesMap.put("VI", "Bizinga bya Virigini eby'Amerika");
    namesMap.put("VN", "Vyetinaamu");
    namesMap.put("VU", "Vanawuwatu");
    namesMap.put("WF", "Walisi ne Futuna");
    namesMap.put("WS", "Samowa");
    namesMap.put("YE", "Yemeni");
    namesMap.put("ZA", "Sawusafirika");
    namesMap.put("ZM", "Zambya");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andora",
        "AE": "Emireeti",
        "AF": "Afaganisitani",
        "AG": "Antigwa ne Barabuda",
        "AI": "Angwila",
        "AL": "Alibaniya",
        "AM": "Arameniya",
        "AN": "Bizinga bya Antile eby'abaHolandi",
        "AR": "Arigentina",
        "AS": "Samowa omumerika",
        "AT": "Awusituriya",
        "AU": "Awusitureliya",
        "AZ": "Azerebayijaani",
        "BA": "Boziniya Hezegovina",
        "BB": "Barabadosi",
        "BD": "Bangaladesi",
        "BE": "Bubirigi",
        "BF": "Burukina Faso",
        "BG": "Bulugariya",
        "BH": "Baareeni",
        "BJ": "Benini",
        "BM": "Beremuda",
        "BN": "Burunayi",
        "BO": "Boliviya",
        "BR": "Buraziiri",
        "BS": "Bahamasi",
        "BT": "Butaani",
        "BW": "Botiswana",
        "BY": "Belarusi",
        "CA": "Kanada",
        "CD": "Kongo - Zayire",
        "CF": "Lipubulika eya Senturafiriki",
        "CG": "Kongo",
        "CH": "Switizirandi",
        "CI": "Kote Divwa",
        "CK": "Bizinga bya Kkuki",
        "CL": "Cile",
        "CM": "Kameruuni",
        "CN": "Cayina",
        "CO": "Kolombya",
        "CR": "Kosita Rika",
        "CS": "Seribya ne Monteneguro",
        "CV": "Bizinga by'e Kepu Veredi",
        "CY": "Sipuriya",
        "CZ": "Lipubulika ya Ceeka",
        "DE": "Budaaki",
        "DJ": "Jjibuti",
        "DK": "Denimaaka",
        "DM": "Dominika",
        "DO": "Lipubulika ya Dominika",
        "DZ": "Aligerya",
        "EC": "Ekwado",
        "EE": "Esitoniya",
        "EG": "Misiri",
        "ER": "Eritureya",
        "ES": "Sipeyini",
        "ET": "Esyopya",
        "FI": "Finilandi",
        "FK": "Bizinga by'eFalikalandi",
        "FM": "Mikuronezya",
        "FR": "Bufalansa",
        "GA": "Gaboni",
        "GB": "Bungereza",
        "GD": "Gurenada",
        "GE": "Gyogya",
        "GF": "Guyana enfalansa",
        "GH": "Gana",
        "GI": "Giburalita",
        "GL": "Gurenelandi",
        "GM": "Gambya",
        "GN": "Gini",
        "GP": "Gwadalupe",
        "GQ": "Gayana ey'oku ekweta",
        "GR": "Bugereeki/Buyonaani",
        "GT": "Gwatemala",
        "GU": "Gwamu",
        "GW": "Gini-Bisawu",
        "GY": "Gayana",
        "HN": "Hundurasi",
        "HR": "Kurowesya",
        "HT": "Hayiti",
        "HU": "Hangare",
        "ID": "Yindonezya",
        "IE": "Ayalandi",
        "IL": "Yisirayeri",
        "IN": "Buyindi",
        "IO": "Bizinga by'eCago",
        "IQ": "Yiraaka",
        "IR": "Yiraani",
        "IS": "Ayisirandi",
        "IT": "Yitale",
        "JM": "Jamayika",
        "JO": "Yorodani",
        "JP": "Japani",
        "KG": "Kirigizisitaani",
        "KH": "Kambodya",
        "KM": "Bizinga by'eKomoro",
        "KN": "Senti Kitisi ne Nevisi",
        "KP": "Koreya ey'omumambuka",
        "KR": "Koreya ey'omumaserengeta",
        "KW": "Kuweti",
        "KY": "Bizinga ebya Kayimaani",
        "KZ": "Kazakisitaani",
        "LA": "Lawosi",
        "LB": "Lebanoni",
        "LC": "Senti Luciya",
        "LI": "Licitensitayini",
        "LK": "Sirilanka",
        "LR": "Liberya",
        "LS": "Lesoso",
        "LT": "Lisuwenya",
        "LU": "Lukisembaaga",
        "LV": "Lativya",
        "MA": "Moroko",
        "MC": "Monako",
        "MD": "Molodova",
        "MG": "Madagasika",
        "MH": "Bizinga bya Mariso",
        "MK": "Masedoniya",
        "MM": "Myanima",
        "MN": "Mongoliya",
        "MP": "Bizinga bya Mariyana eby'omumambuka",
        "MQ": "Maritiniiki",
        "MR": "Mawulitenya",
        "MS": "Monteseraati",
        "MT": "Malita",
        "MU": "Mawulisyasi",
        "MV": "Bizinga by'eMalidive",
        "MX": "Mekisiko",
        "MY": "Malezya",
        "MZ": "Mozambiiki",
        "NA": "Namibiya",
        "NC": "Kaledonya mupya",
        "NE": "Nije",
        "NF": "Kizinga ky'eNorofoko",
        "NG": "Nayijerya",
        "NI": "Nikaraguwa",
        "NL": "Holandi",
        "NO": "Nowe",
        "NP": "Nepalo",
        "NR": "Nawuru",
        "NU": "Niyuwe",
        "NZ": "Niyuziirandi",
        "OM": "Omaani",
        "PF": "Polinesiya enfalansa",
        "PG": "Papwa Nyugini",
        "PH": "Bizinga bya Firipino",
        "PK": "Pakisitaani",
        "PL": "Polandi",
        "PM": "Senti Piyere ne Mikeloni",
        "PN": "Pitikeeni",
        "PR": "Potoriko",
        "PS": "Palesitayini",
        "PT": "Potugaali",
        "PW": "Palawu",
        "PY": "Paragwayi",
        "QA": "Kataa",
        "RE": "Leyunyoni",
        "RO": "Lomaniya",
        "RU": "Lasa",
        "SA": "Sawudarebya - Buwarabu",
        "SB": "Bizanga by'eSolomooni",
        "SC": "Sesere",
        "SD": "Sudaani",
        "SE": "Swideni",
        "SG": "Singapowa",
        "SH": "Senti Herena",
        "SI": "Sirovenya",
        "SK": "Sirovakya",
        "SL": "Siyeralewone",
        "SM": "Sanimarino",
        "SN": "Senegaalo",
        "SO": "Somaliya",
        "SR": "Surinaamu",
        "ST": "Sanitome ne Purincipe",
        "SV": "El salivado",
        "SY": "Siriya",
        "SZ": "Swazirandi",
        "TC": "Bizinga by'eTaaka ne Kayikosi",
        "TD": "Caadi",
        "TH": "Tayirandi",
        "TJ": "Tajikisitaani",
        "TK": "Tokelawu",
        "TL": "Timowa",
        "TM": "Takimenesitaani",
        "TN": "Tunisya",
        "TR": "Ttake",
        "TT": "Turindaadi ne Tobago",
        "TW": "Tayiwani",
        "TZ": "Tanzaniya",
        "UA": "Yukurayine",
        "UG": "Yuganda",
        "US": "Amerika",
        "UY": "Wurugwayi",
        "UZ": "Wuzibekisitaani",
        "VA": "Vatikaani",
        "VC": "Senti Vinsenti ne Gurendadiini",
        "VE": "Venzwera",
        "VG": "Bizinga ebya Virigini ebitwalibwa Bungereza",
        "VI": "Bizinga bya Virigini eby'Amerika",
        "VN": "Vyetinaamu",
        "VU": "Vanawuwatu",
        "WF": "Walisi ne Futuna",
        "WS": "Samowa",
        "YE": "Yemeni",
        "ZA": "Sawusafirika",
        "ZM": "Zambya"
    };
  }-*/;
}
