#ifndef WIBBLE_BENCHMARK_H
#define WIBBLE_BENCHMARK_H

#include <time.h>

#include <vector>
#include <string>

class Timer
{
protected:
	clock_t start;
	std::string desc;

public:
	Timer(const Timer& t) : start(t.start), desc(t.desc)
	{
		const_cast<Timer*>(&t)->start = -1;
	}
	Timer(const std::string& desc) : start(clock()), desc(desc) {}
	~Timer();
	const Timer& operator=(const Timer& t)
	{
		start = t.start;
		desc = t.desc;
		const_cast<Timer*>(&t)->start = -1;
		return *this;
	}
	
	void done();
};

class Benchmark
{
private:
	std::string tag;
	Benchmark* parent;
	std::vector<Benchmark*> children;
	
protected:
	// Main function with the benchmarks
	virtual void main() {}

	void setParent(Benchmark* parent) { this->parent = parent; }

	Timer mktimer(const std::string& desc)
	{
		return Timer(fullName() + "/" + desc);
	}

	std::string name() const { return tag; }

	std::string fullName() const
	{
		if (parent)
			return parent->fullName() + "/" + tag;
		else
			return tag;
	}
	
public:
	Benchmark(const std::string& tag) : tag(tag), parent(0) {}

	void addChild(Benchmark* child)
	{
		children.push_back(child);
		child->setParent(this);
	}

	virtual ~Benchmark()
	{
		for (std::vector<Benchmark*>::iterator i = children.begin();
				i != children.end(); i++)
			delete *i;
	}

	// Run only the subtest at the given path
	void run(const std::string& path);
	
	// Run all subtests and this test
	void run();

	// Return the singleton instance of the toplevel benchmark class
	static Benchmark* root();
};

struct RegisterRoot
{
	RegisterRoot(Benchmark* b)
	{
		Benchmark::root()->addChild(b);
	}
};

// vim:set ts=4 sw=4:
#endif
