function test154(tasks)
%TEST154 test GrB_apply with scalar binding

% SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2025, All Rights Reserved.
% SPDX-License-Identifier: Apache-2.0

if (nargin < 1)
    tasks = [ ] ;
end

if (isempty (tasks))
    tasks = { ...
     {    'first',        'logical',  1, 1,-1, 1}, ... % (  7,    7)
     {    'first',        'logical',  1, 4,-1, 1}, ... % (  1,    8)
     {    'first',           'int8',  1, 1,-1, 1}, ... % (  1,    9)
     {    'first',          'int16',  1, 1,-1, 1}, ... % (  1,   10)
     {    'first',          'int32',  1, 1,-1, 1}, ... % (  1,   11)
     {    'first',          'int64',  1, 1,-1, 1}, ... % (  1,   12)
     {    'first',          'uint8',  1, 1,-1, 1}, ... % (  1,   13)
     {    'first',         'uint16',  1, 1,-1, 1}, ... % (  1,   14)
     {    'first',         'uint32',  1, 1,-1, 1}, ... % (  1,   15)
     {    'first',         'uint64',  1, 1,-1, 1}, ... % (  1,   16)
     {    'first',         'single',  1, 1,-1, 1}, ... % (  1,   17)
     {    'first',         'double',  1, 1,-1, 1}, ... % (  1,   18)
     {    'first', 'single complex',  1, 1,-1, 1}, ... % (  1,   19)
     {    'first', 'double complex',  1, 1,-1, 1}, ... % (  1,   20)
     {     'pair',        'logical',  1, 1,-1, 1}, ... % (  1,   21)
     {     'plus',        'logical',  1, 1,-1, 1}, ... % (  6,   27)
     {     'plus',        'logical',  4, 4,-1, 1}, ... % (  5,   32)
     {     'plus',           'int8',  1, 1,-1, 1}, ... % (  3,   35)
     {     'plus',           'int8',  4, 4,-1, 1}, ... % (  1,   36)
     {     'plus',          'int16',  1, 1,-1, 1}, ... % (  3,   39)
     {     'plus',          'int16',  4, 4,-1, 1}, ... % (  3,   42)
     {     'plus',          'int32',  1, 1,-1, 1}, ... % (  3,   45)
     {     'plus',          'int32',  4, 4,-1, 1}, ... % (  1,   46)
     {     'plus',          'int64',  1, 1,-1, 1}, ... % (  3,   49)
     {     'plus',          'int64',  4, 4,-1, 1}, ... % (  1,   50)
     {     'plus',          'uint8',  1, 1,-1, 1}, ... % (  3,   53)
     {     'plus',          'uint8',  4, 4,-1, 1}, ... % (  1,   54)
     {     'plus',         'uint16',  1, 1,-1, 1}, ... % (  3,   57)
     {     'plus',         'uint16',  4, 4,-1, 1}, ... % (  1,   58)
     {     'plus',         'uint32',  1, 1,-1, 1}, ... % (  3,   61)
     {     'plus',         'uint32',  4, 4,-1, 1}, ... % (  1,   62)
     {     'plus',         'uint64',  1, 1,-1, 1}, ... % (  3,   65)
     {     'plus',         'uint64',  4, 4,-1, 1}, ... % (  1,   66)
     {     'plus',         'single',  1, 1,-1, 1}, ... % (  3,   69)
     {     'plus',         'single',  4, 4,-1, 1}, ... % (  1,   70)
     {     'plus',         'double',  1, 1,-1, 1}, ... % (  2,   72)
     {     'plus',         'double',  4, 4,-1, 1}, ... % (  1,   73)
     {     'plus', 'single complex',  1, 1,-1, 1}, ... % (  3,   76)
     {     'plus', 'single complex',  4, 4,-1, 1}, ... % (  1,   77)
     {     'plus', 'double complex',  1, 1,-1, 1}, ... % (  3,   80)
     {     'plus', 'double complex',  4, 4,-1, 1}, ... % (  1,   81)
     {    'minus',        'logical',  1, 1,-1, 1}, ... % (  1,   82)
     {    'minus',        'logical',  4, 4,-1, 1}, ... % (  1,   83)
     {    'minus',           'int8',  1, 1,-1, 1}, ... % (  3,   86)
     {    'minus',           'int8',  4, 4,-1, 1}, ... % (  1,   87)
     {    'minus',          'int16',  1, 1,-1, 1}, ... % (  3,   90)
     {    'minus',          'int16',  4, 4,-1, 1}, ... % (  1,   91)
     {    'minus',          'int32',  1, 1,-1, 1}, ... % (  3,   94)
     {    'minus',          'int32',  4, 4,-1, 1}, ... % (  1,   95)
     {    'minus',          'int64',  1, 1,-1, 1}, ... % (  3,   98)
     {    'minus',          'int64',  4, 4,-1, 1}, ... % (  1,   99)
     {    'minus',          'uint8',  1, 1,-1, 1}, ... % (  3,  102)
     {    'minus',          'uint8',  4, 4,-1, 1}, ... % (  1,  103)
     {    'minus',         'uint16',  1, 1,-1, 1}, ... % (  3,  106)
     {    'minus',         'uint16',  4, 4,-1, 1}, ... % (  1,  107)
     {    'minus',         'uint32',  1, 1,-1, 1}, ... % (  3,  110)
     {    'minus',         'uint32',  4, 4,-1, 1}, ... % (  1,  111)
     {    'minus',         'uint64',  1, 1,-1, 1}, ... % (  3,  114)
     {    'minus',         'uint64',  4, 4,-1, 1}, ... % (  1,  115)
     {    'minus',         'single',  1, 1,-1, 1}, ... % (  3,  118)
     {    'minus',         'single',  4, 4,-1, 1}, ... % (  1,  119)
     {    'minus',         'double',  1, 1,-1, 1}, ... % (  3,  122)
     {    'minus',         'double',  4, 4,-1, 1}, ... % (  1,  123)
     {    'minus', 'single complex',  1, 1,-1, 1}, ... % (  3,  126)
     {    'minus', 'single complex',  4, 4,-1, 1}, ... % (  1,  127)
     {    'minus', 'double complex',  1, 1,-1, 1}, ... % (  3,  130)
     {    'minus', 'double complex',  4, 4,-1, 1}, ... % (  1,  131)
     {   'rminus',           'int8',  1, 1,-1, 1}, ... % (  3,  134)
     {   'rminus',           'int8',  4, 4,-1, 1}, ... % (  1,  135)
     {   'rminus',          'int16',  1, 1,-1, 1}, ... % (  3,  138)
     {   'rminus',          'int16',  4, 4,-1, 1}, ... % (  1,  139)
     {   'rminus',          'int32',  1, 1,-1, 1}, ... % (  3,  142)
     {   'rminus',          'int32',  4, 4,-1, 1}, ... % (  1,  143)
     {   'rminus',          'int64',  1, 1,-1, 1}, ... % (  3,  146)
     {   'rminus',          'int64',  4, 4,-1, 1}, ... % (  1,  147)
     {   'rminus',          'uint8',  1, 1,-1, 1}, ... % (  3,  150)
     {   'rminus',          'uint8',  4, 4,-1, 1}, ... % (  1,  151)
     {   'rminus',         'uint16',  1, 1,-1, 1}, ... % (  3,  154)
     {   'rminus',         'uint16',  4, 4,-1, 1}, ... % (  1,  155)
     {   'rminus',         'uint32',  1, 1,-1, 1}, ... % (  3,  158)
     {   'rminus',         'uint32',  4, 4,-1, 1}, ... % (  1,  159)
     {   'rminus',         'uint64',  1, 1,-1, 1}, ... % (  3,  162)
     {   'rminus',         'uint64',  4, 4,-1, 1}, ... % (  1,  163)
     {   'rminus',         'single',  1, 1,-1, 1}, ... % (  3,  166)
     {   'rminus',         'single',  4, 4,-1, 1}, ... % (  1,  167)
     {   'rminus',         'double',  1, 1,-1, 1}, ... % (  3,  170)
     {   'rminus',         'double',  4, 4,-1, 1}, ... % (  1,  171)
     {   'rminus', 'single complex',  1, 1,-1, 1}, ... % (  3,  174)
     {   'rminus', 'single complex',  4, 4,-1, 1}, ... % (  1,  175)
     {   'rminus', 'double complex',  1, 1,-1, 1}, ... % (  3,  178)
     {   'rminus', 'double complex',  4, 4,-1, 1}, ... % (  1,  179)
     {    'times',        'logical',  1, 1,-1, 1}, ... % (  3,  182)
     {    'times',        'logical',  4, 4,-1, 1}, ... % (  1,  183)
     {    'times',           'int8',  1, 1,-1, 1}, ... % (  3,  186)
     {    'times',           'int8',  4, 4,-1, 1}, ... % (  1,  187)
     {    'times',          'int16',  1, 1,-1, 1}, ... % (  3,  190)
     {    'times',          'int16',  4, 4,-1, 1}, ... % (  1,  191)
     {    'times',          'int32',  1, 1,-1, 1}, ... % (  3,  194)
     {    'times',          'int32',  4, 4,-1, 1}, ... % (  1,  195)
     {    'times',          'int64',  1, 1,-1, 1}, ... % (  3,  198)
     {    'times',          'int64',  4, 4,-1, 1}, ... % (  1,  199)
     {    'times',          'uint8',  1, 1,-1, 1}, ... % (  3,  202)
     {    'times',          'uint8',  4, 4,-1, 1}, ... % (  1,  203)
     {    'times',         'uint16',  1, 1,-1, 1}, ... % (  3,  206)
     {    'times',         'uint16',  4, 4,-1, 1}, ... % (  1,  207)
     {    'times',         'uint32',  1, 1,-1, 1}, ... % (  3,  210)
     {    'times',         'uint32',  4, 4,-1, 1}, ... % (  1,  211)
     {    'times',         'uint64',  1, 1,-1, 1}, ... % (  3,  214)
     {    'times',         'uint64',  4, 4,-1, 1}, ... % (  1,  215)
     {    'times',         'single',  1, 1,-1, 1}, ... % (  3,  218)
     {    'times',         'single',  4, 4,-1, 1}, ... % (  1,  219)
     {    'times',         'double',  1, 1,-1, 1}, ... % (  3,  222)
     {    'times',         'double',  4, 4,-1, 1}, ... % (  1,  223)
     {    'times', 'single complex',  1, 1,-1, 1}, ... % (  3,  226)
     {    'times', 'single complex',  4, 4,-1, 1}, ... % (  1,  227)
     {    'times', 'double complex',  1, 1,-1, 1}, ... % (  3,  230)
     {    'times', 'double complex',  4, 4,-1, 1}, ... % (  1,  231)
     {      'div',           'int8',  1, 1,-1, 1}, ... % (  3,  234)
     {      'div',           'int8',  4, 4,-1, 1}, ... % (  1,  235)
     {      'div',          'int16',  1, 1,-1, 1}, ... % (  3,  238)
     {      'div',          'int16',  4, 4,-1, 1}, ... % (  1,  239)
     {      'div',          'int32',  1, 1,-1, 1}, ... % (  3,  242)
     {      'div',          'int32',  4, 4,-1, 1}, ... % (  1,  243)
     {      'div',          'int64',  1, 1,-1, 1}, ... % (  3,  246)
     {      'div',          'int64',  4, 4,-1, 1}, ... % (  1,  247)
     {      'div',          'uint8',  1, 1,-1, 1}, ... % (  3,  250)
     {      'div',          'uint8',  4, 4,-1, 1}, ... % (  1,  251)
     {      'div',         'uint16',  1, 1,-1, 1}, ... % (  3,  254)
     {      'div',         'uint16',  4, 4,-1, 1}, ... % (  1,  255)
     {      'div',         'uint32',  1, 1,-1, 1}, ... % (  3,  258)
     {      'div',         'uint32',  4, 4,-1, 1}, ... % (  1,  259)
     {      'div',         'uint64',  1, 1,-1, 1}, ... % (  3,  262)
     {      'div',         'uint64',  4, 4,-1, 1}, ... % (  1,  263)
     {      'div',         'single',  1, 1,-1, 1}, ... % (  3,  266)
     {      'div',         'single',  4, 4,-1, 1}, ... % (  1,  267)
     {      'div',         'double',  1, 1,-1, 1}, ... % (  3,  270)
     {      'div',         'double',  4, 4,-1, 1}, ... % (  1,  271)
     {      'div', 'single complex',  1, 1,-1, 1}, ... % (  3,  274)
     {      'div', 'single complex',  4, 4,-1, 1}, ... % (  1,  275)
     {      'div', 'double complex',  1, 1,-1, 1}, ... % (  3,  278)
     {      'div', 'double complex',  4, 4,-1, 1}, ... % (  1,  279)
     {     'rdiv',           'int8',  1, 1,-1, 1}, ... % (  3,  282)
     {     'rdiv',           'int8',  4, 4,-1, 1}, ... % (  1,  283)
     {     'rdiv',          'int16',  1, 1,-1, 1}, ... % (  3,  286)
     {     'rdiv',          'int16',  4, 4,-1, 1}, ... % (  1,  287)
     {     'rdiv',          'int32',  1, 1,-1, 1}, ... % (  3,  290)
     {     'rdiv',          'int32',  4, 4,-1, 1}, ... % (  1,  291)
     {     'rdiv',          'int64',  1, 1,-1, 1}, ... % (  3,  294)
     {     'rdiv',          'int64',  4, 4,-1, 1}, ... % (  1,  295)
     {     'rdiv',          'uint8',  1, 1,-1, 1}, ... % (  3,  298)
     {     'rdiv',          'uint8',  4, 4,-1, 1}, ... % (  1,  299)
     {     'rdiv',         'uint16',  1, 1,-1, 1}, ... % (  3,  302)
     {     'rdiv',         'uint16',  4, 4,-1, 1}, ... % (  1,  303)
     {     'rdiv',         'uint32',  1, 1,-1, 1}, ... % (  3,  306)
     {     'rdiv',         'uint32',  4, 4,-1, 1}, ... % (  1,  307)
     {     'rdiv',         'uint64',  1, 1,-1, 1}, ... % (  3,  310)
     {     'rdiv',         'uint64',  4, 4,-1, 1}, ... % (  1,  311)
     {     'rdiv',         'single',  1, 1,-1, 1}, ... % (  3,  314)
     {     'rdiv',         'single',  4, 4,-1, 1}, ... % (  1,  315)
     {     'rdiv',         'double',  1, 1,-1, 1}, ... % (  3,  318)
     {     'rdiv',         'double',  4, 4,-1, 1}, ... % (  1,  319)
     {     'rdiv', 'single complex',  1, 1,-1, 1}, ... % (  3,  322)
     {     'rdiv', 'single complex',  4, 4,-1, 1}, ... % (  1,  323)
     {     'rdiv', 'double complex',  1, 1,-1, 1}, ... % (  3,  326)
     {     'rdiv', 'double complex',  4, 4,-1, 1}, ... % (  1,  327)
     {     'iseq',        'logical',  1, 1,-1, 1}, ... % (  1,  328)
     {     'iseq',        'logical',  4, 4,-1, 1}, ... % (  1,  329)
     {     'iseq',           'int8',  1, 1,-1, 1}, ... % (  3,  332)
     {     'iseq',           'int8',  4, 4,-1, 1}, ... % (  1,  333)
     {     'iseq',          'int16',  1, 1,-1, 1}, ... % (  3,  336)
     {     'iseq',          'int16',  4, 4,-1, 1}, ... % (  1,  337)
     {     'iseq',          'int32',  1, 1,-1, 1}, ... % (  3,  340)
     {     'iseq',          'int32',  4, 4,-1, 1}, ... % (  1,  341)
     {     'iseq',          'int64',  1, 1,-1, 1}, ... % (  3,  344)
     {     'iseq',          'int64',  4, 4,-1, 1}, ... % (  1,  345)
     {     'iseq',          'uint8',  1, 1,-1, 1}, ... % (  3,  348)
     {     'iseq',          'uint8',  4, 4,-1, 1}, ... % (  1,  349)
     {     'iseq',         'uint16',  1, 1,-1, 1}, ... % (  3,  352)
     {     'iseq',         'uint16',  4, 4,-1, 1}, ... % (  1,  353)
     {     'iseq',         'uint32',  1, 1,-1, 1}, ... % (  3,  356)
     {     'iseq',         'uint32',  4, 4,-1, 1}, ... % (  1,  357)
     {     'iseq',         'uint64',  1, 1,-1, 1}, ... % (  3,  360)
     {     'iseq',         'uint64',  4, 4,-1, 1}, ... % (  1,  361)
     {     'iseq',         'single',  1, 1,-1, 1}, ... % (  3,  364)
     {     'iseq',         'single',  4, 4,-1, 1}, ... % (  1,  365)
     {     'iseq',         'double',  1, 1,-1, 1}, ... % (  3,  368)
     {     'iseq',         'double',  4, 4,-1, 1}, ... % (  1,  369)
     {     'iseq', 'single complex',  1, 1,-1, 1}, ... % (  3,  372)
     {     'iseq', 'single complex',  4, 4,-1, 1}, ... % (  1,  373)
     {     'iseq', 'double complex',  1, 1,-1, 1}, ... % (  3,  376)
     {     'iseq', 'double complex',  4, 4,-1, 1}, ... % (  1,  377)
     {     'isne',           'int8',  1, 1,-1, 1}, ... % (  3,  380)
     {     'isne',           'int8',  4, 4,-1, 1}, ... % (  1,  381)
     {     'isne',          'int16',  1, 1,-1, 1}, ... % (  3,  384)
     {     'isne',          'int16',  4, 4,-1, 1}, ... % (  1,  385)
     {     'isne',          'int32',  1, 1,-1, 1}, ... % (  3,  388)
     {     'isne',          'int32',  4, 4,-1, 1}, ... % (  1,  389)
     {     'isne',          'int64',  1, 1,-1, 1}, ... % (  3,  392)
     {     'isne',          'int64',  4, 4,-1, 1}, ... % (  1,  393)
     {     'isne',          'uint8',  1, 1,-1, 1}, ... % (  3,  396)
     {     'isne',          'uint8',  4, 4,-1, 1}, ... % (  1,  397)
     {     'isne',         'uint16',  1, 1,-1, 1}, ... % (  3,  400)
     {     'isne',         'uint16',  4, 4,-1, 1}, ... % (  1,  401)
     {     'isne',         'uint32',  1, 1,-1, 1}, ... % (  3,  404)
     {     'isne',         'uint32',  4, 4,-1, 1}, ... % (  1,  405)
     {     'isne',         'uint64',  1, 1,-1, 1}, ... % (  3,  408)
     {     'isne',         'uint64',  4, 4,-1, 1}, ... % (  1,  409)
     {     'isne',         'single',  1, 1,-1, 1}, ... % (  3,  412)
     {     'isne',         'single',  4, 4,-1, 1}, ... % (  1,  413)
     {     'isne',         'double',  1, 1,-1, 1}, ... % (  3,  416)
     {     'isne',         'double',  4, 4,-1, 1}, ... % (  1,  417)
     {     'isne', 'single complex',  1, 1,-1, 1}, ... % (  3,  420)
     {     'isne', 'single complex',  4, 4,-1, 1}, ... % (  1,  421)
     {     'isne', 'double complex',  1, 1,-1, 1}, ... % (  3,  424)
     {     'isne', 'double complex',  4, 4,-1, 1}, ... % (  1,  425)
     {       'eq',           'int8',  1, 1,-1, 1}, ... % (  1,  426)
     {       'eq',           'int8',  4, 4,-1, 1}, ... % (  1,  427)
     {       'eq',          'int16',  1, 1,-1, 1}, ... % (  1,  428)
     {       'eq',          'int16',  4, 4,-1, 1}, ... % (  1,  429)
     {       'eq',          'int32',  1, 1,-1, 1}, ... % (  1,  430)
     {       'eq',          'int32',  4, 4,-1, 1}, ... % (  1,  431)
     {       'eq',          'int64',  1, 1,-1, 1}, ... % (  1,  432)
     {       'eq',          'int64',  4, 4,-1, 1}, ... % (  1,  433)
     {       'eq',          'uint8',  1, 1,-1, 1}, ... % (  1,  434)
     {       'eq',          'uint8',  4, 4,-1, 1}, ... % (  1,  435)
     {       'eq',         'uint16',  1, 1,-1, 1}, ... % (  1,  436)
     {       'eq',         'uint16',  4, 4,-1, 1}, ... % (  1,  437)
     {       'eq',         'uint32',  1, 1,-1, 1}, ... % (  1,  438)
     {       'eq',         'uint32',  4, 4,-1, 1}, ... % (  1,  439)
     {       'eq',         'uint64',  1, 1,-1, 1}, ... % (  1,  440)
     {       'eq',         'uint64',  4, 4,-1, 1}, ... % (  1,  441)
     {       'eq',         'single',  1, 1,-1, 1}, ... % (  1,  442)
     {       'eq',         'single',  4, 4,-1, 1}, ... % (  1,  443)
     {       'eq',         'double',  1, 1,-1, 1}, ... % (  1,  444)
     {       'eq',         'double',  4, 4,-1, 1}, ... % (  1,  445)
     {       'eq', 'single complex',  1, 1,-1, 1}, ... % (  1,  446)
     {       'eq', 'single complex',  4, 4,-1, 1}, ... % (  1,  447)
     {       'eq', 'double complex',  1, 1,-1, 1}, ... % (  1,  448)
     {       'eq', 'double complex',  4, 4,-1, 1}, ... % (  1,  449)
     {       'ne',           'int8',  1, 1,-1, 1}, ... % (  1,  450)
     {       'ne',           'int8',  4, 4,-1, 1}, ... % (  1,  451)
     {       'ne',          'int16',  1, 1,-1, 1}, ... % (  1,  452)
     {       'ne',          'int16',  4, 4,-1, 1}, ... % (  1,  453)
     {       'ne',          'int32',  1, 1,-1, 1}, ... % (  1,  454)
     {       'ne',          'int32',  4, 4,-1, 1}, ... % (  1,  455)
     {       'ne',          'int64',  1, 1,-1, 1}, ... % (  1,  456)
     {       'ne',          'int64',  4, 4,-1, 1}, ... % (  1,  457)
     {       'ne',          'uint8',  1, 1,-1, 1}, ... % (  1,  458)
     {       'ne',          'uint8',  4, 4,-1, 1}, ... % (  1,  459)
     {       'ne',         'uint16',  1, 1,-1, 1}, ... % (  1,  460)
     {       'ne',         'uint16',  4, 4,-1, 1}, ... % (  1,  461)
     {       'ne',         'uint32',  1, 1,-1, 1}, ... % (  1,  462)
     {       'ne',         'uint32',  4, 4,-1, 1}, ... % (  1,  463)
     {       'ne',         'uint64',  1, 1,-1, 1}, ... % (  1,  464)
     {       'ne',         'uint64',  4, 4,-1, 1}, ... % (  1,  465)
     {       'ne',         'single',  1, 1,-1, 1}, ... % (  1,  466)
     {       'ne',         'single',  4, 4,-1, 1}, ... % (  1,  467)
     {       'ne',         'double',  1, 1,-1, 1}, ... % (  1,  468)
     {       'ne',         'double',  4, 4,-1, 1}, ... % (  1,  469)
     {       'ne', 'single complex',  1, 1,-1, 1}, ... % (  1,  470)
     {       'ne', 'single complex',  4, 4,-1, 1}, ... % (  1,  471)
     {       'ne', 'double complex',  1, 1,-1, 1}, ... % (  1,  472)
     {       'ne', 'double complex',  4, 4,-1, 1}, ... % (  1,  473)
     {      'pow',        'logical',  1, 1,-1, 1}, ... % (  1,  474)
     {      'pow',        'logical',  4, 4,-1, 1}, ... % (  1,  475)
     {      'pow',           'int8',  1, 1,-1, 1}, ... % (  3,  478)
     {      'pow',           'int8',  4, 4,-1, 1}, ... % (  1,  479)
     {      'pow',          'int16',  1, 1,-1, 1}, ... % (  3,  482)
     {      'pow',          'int16',  4, 4,-1, 1}, ... % (  1,  483)
     {      'pow',          'int32',  1, 1,-1, 1}, ... % (  3,  486)
     {      'pow',          'int32',  4, 4,-1, 1}, ... % (  1,  487)
     {      'pow',          'int64',  1, 1,-1, 1}, ... % (  3,  490)
     {      'pow',          'int64',  4, 4,-1, 1}, ... % (  1,  491)
     {      'pow',          'uint8',  1, 1,-1, 1}, ... % (  3,  494)
     {      'pow',          'uint8',  4, 4,-1, 1}, ... % (  1,  495)
     {      'pow',         'uint16',  1, 1,-1, 1}, ... % (  3,  498)
     {      'pow',         'uint16',  4, 4,-1, 1}, ... % (  1,  499)
     {      'pow',         'uint32',  1, 1,-1, 1}, ... % (  3,  502)
     {      'pow',         'uint32',  4, 4,-1, 1}, ... % (  1,  503)
     {      'pow',         'uint64',  1, 1,-1, 1}, ... % (  3,  506)
     {      'pow',         'uint64',  4, 4,-1, 1}, ... % (  1,  507)
     {      'pow',         'single',  1, 1,-1, 1}, ... % (  3,  510)
     {      'pow',         'single',  4, 4,-1, 1}, ... % (  1,  511)
     {      'pow',         'double',  1, 1,-1, 1}, ... % (  3,  514)
     {      'pow',         'double',  4, 4,-1, 1}, ... % (  1,  515)
     {      'pow', 'single complex',  1, 1,-1, 1}, ... % (  3,  518)
     {      'pow', 'single complex',  4, 4,-1, 1}, ... % (  1,  519)
     {      'pow', 'double complex',  1, 1,-1, 1}, ... % (  3,  522)
     {      'pow', 'double complex',  4, 4,-1, 1}, ... % (  1,  523)
     {      'min',           'int8',  1, 1,-1, 1}, ... % (  3,  526)
     {      'min',           'int8',  4, 4,-1, 1}, ... % (  1,  527)
     {      'min',          'int16',  1, 1,-1, 1}, ... % (  3,  530)
     {      'min',          'int16',  4, 4,-1, 1}, ... % (  1,  531)
     {      'min',          'int32',  1, 1,-1, 1}, ... % (  3,  534)
     {      'min',          'int32',  4, 4,-1, 1}, ... % (  1,  535)
     {      'min',          'int64',  1, 1,-1, 1}, ... % (  3,  538)
     {      'min',          'int64',  4, 4,-1, 1}, ... % (  1,  539)
     {      'min',          'uint8',  1, 1,-1, 1}, ... % (  3,  542)
     {      'min',          'uint8',  4, 4,-1, 1}, ... % (  1,  543)
     {      'min',         'uint16',  1, 1,-1, 1}, ... % (  3,  546)
     {      'min',         'uint16',  4, 4,-1, 1}, ... % (  1,  547)
     {      'min',         'uint32',  1, 1,-1, 1}, ... % (  3,  550)
     {      'min',         'uint32',  4, 4,-1, 1}, ... % (  1,  551)
     {      'min',         'uint64',  1, 1,-1, 1}, ... % (  3,  554)
     {      'min',         'uint64',  4, 4,-1, 1}, ... % (  1,  555)
     {      'min',         'single',  1, 1,-1, 1}, ... % (  3,  558)
     {      'min',         'single',  4, 4,-1, 1}, ... % (  1,  559)
     {      'min',         'double',  1, 1,-1, 1}, ... % (  3,  562)
     {      'min',         'double',  4, 4,-1, 1}, ... % (  1,  563)
     {      'max',           'int8',  1, 1,-1, 1}, ... % (  3,  566)
     {      'max',           'int8',  4, 4,-1, 1}, ... % (  1,  567)
     {      'max',          'int16',  1, 1,-1, 1}, ... % (  3,  570)
     {      'max',          'int16',  4, 4,-1, 1}, ... % (  1,  571)
     {      'max',          'int32',  1, 1,-1, 1}, ... % (  3,  574)
     {      'max',          'int32',  4, 4,-1, 1}, ... % (  1,  575)
     {      'max',          'int64',  1, 1,-1, 1}, ... % (  3,  578)
     {      'max',          'int64',  4, 4,-1, 1}, ... % (  1,  579)
     {      'max',          'uint8',  1, 1,-1, 1}, ... % (  3,  582)
     {      'max',          'uint8',  4, 4,-1, 1}, ... % (  1,  583)
     {      'max',         'uint16',  1, 1,-1, 1}, ... % (  3,  586)
     {      'max',         'uint16',  4, 4,-1, 1}, ... % (  1,  587)
     {      'max',         'uint32',  1, 1,-1, 1}, ... % (  3,  590)
     {      'max',         'uint32',  4, 4,-1, 1}, ... % (  1,  591)
     {      'max',         'uint64',  1, 1,-1, 1}, ... % (  3,  594)
     {      'max',         'uint64',  4, 4,-1, 1}, ... % (  1,  595)
     {      'max',         'single',  1, 1,-1, 1}, ... % (  3,  598)
     {      'max',         'single',  4, 4,-1, 1}, ... % (  1,  599)
     {      'max',         'double',  1, 1,-1, 1}, ... % (  3,  602)
     {      'max',         'double',  4, 4,-1, 1}, ... % (  1,  603)
     {     'isgt',        'logical',  1, 1,-1, 1}, ... % (  1,  604)
     {     'isgt',        'logical',  4, 4,-1, 1}, ... % (  1,  605)
     {     'isgt',           'int8',  1, 1,-1, 1}, ... % (  3,  608)
     {     'isgt',           'int8',  4, 4,-1, 1}, ... % (  1,  609)
     {     'isgt',          'int16',  1, 1,-1, 1}, ... % (  3,  612)
     {     'isgt',          'int16',  4, 4,-1, 1}, ... % (  1,  613)
     {     'isgt',          'int32',  1, 1,-1, 1}, ... % (  3,  616)
     {     'isgt',          'int32',  4, 4,-1, 1}, ... % (  1,  617)
     {     'isgt',          'int64',  1, 1,-1, 1}, ... % (  3,  620)
     {     'isgt',          'int64',  4, 4,-1, 1}, ... % (  1,  621)
     {     'isgt',          'uint8',  1, 1,-1, 1}, ... % (  3,  624)
     {     'isgt',          'uint8',  4, 4,-1, 1}, ... % (  1,  625)
     {     'isgt',         'uint16',  1, 1,-1, 1}, ... % (  3,  628)
     {     'isgt',         'uint16',  4, 4,-1, 1}, ... % (  1,  629)
     {     'isgt',         'uint32',  1, 1,-1, 1}, ... % (  3,  632)
     {     'isgt',         'uint32',  4, 4,-1, 1}, ... % (  1,  633)
     {     'isgt',         'uint64',  1, 1,-1, 1}, ... % (  3,  636)
     {     'isgt',         'uint64',  4, 4,-1, 1}, ... % (  1,  637)
     {     'isgt',         'single',  1, 1,-1, 1}, ... % (  3,  640)
     {     'isgt',         'single',  4, 4,-1, 1}, ... % (  1,  641)
     {     'isgt',         'double',  1, 1,-1, 1}, ... % (  3,  644)
     {     'isgt',         'double',  4, 4,-1, 1}, ... % (  1,  645)
     {     'islt',        'logical',  1, 1,-1, 1}, ... % (  1,  646)
     {     'islt',        'logical',  4, 4,-1, 1}, ... % (  1,  647)
     {     'islt',           'int8',  1, 1,-1, 1}, ... % (  3,  650)
     {     'islt',           'int8',  4, 4,-1, 1}, ... % (  1,  651)
     {     'islt',          'int16',  1, 1,-1, 1}, ... % (  3,  654)
     {     'islt',          'int16',  4, 4,-1, 1}, ... % (  1,  655)
     {     'islt',          'int32',  1, 1,-1, 1}, ... % (  3,  658)
     {     'islt',          'int32',  4, 4,-1, 1}, ... % (  1,  659)
     {     'islt',          'int64',  1, 1,-1, 1}, ... % (  3,  662)
     {     'islt',          'int64',  4, 4,-1, 1}, ... % (  1,  663)
     {     'islt',          'uint8',  1, 1,-1, 1}, ... % (  3,  666)
     {     'islt',          'uint8',  4, 4,-1, 1}, ... % (  1,  667)
     {     'islt',         'uint16',  1, 1,-1, 1}, ... % (  3,  670)
     {     'islt',         'uint16',  4, 4,-1, 1}, ... % (  1,  671)
     {     'islt',         'uint32',  1, 1,-1, 1}, ... % (  3,  674)
     {     'islt',         'uint32',  4, 4,-1, 1}, ... % (  1,  675)
     {     'islt',         'uint64',  1, 1,-1, 1}, ... % (  3,  678)
     {     'islt',         'uint64',  4, 4,-1, 1}, ... % (  1,  679)
     {     'islt',         'single',  1, 1,-1, 1}, ... % (  3,  682)
     {     'islt',         'single',  4, 4,-1, 1}, ... % (  1,  683)
     {     'islt',         'double',  1, 1,-1, 1}, ... % (  3,  686)
     {     'islt',         'double',  4, 4,-1, 1}, ... % (  1,  687)
     {     'isge',           'int8',  1, 1,-1, 1}, ... % (  3,  690)
     {     'isge',           'int8',  4, 4,-1, 1}, ... % (  1,  691)
     {     'isge',          'int16',  1, 1,-1, 1}, ... % (  3,  694)
     {     'isge',          'int16',  4, 4,-1, 1}, ... % (  1,  695)
     {     'isge',          'int32',  1, 1,-1, 1}, ... % (  3,  698)
     {     'isge',          'int32',  4, 4,-1, 1}, ... % (  1,  699)
     {     'isge',          'int64',  1, 1,-1, 1}, ... % (  3,  702)
     {     'isge',          'int64',  4, 4,-1, 1}, ... % (  1,  703)
     {     'isge',          'uint8',  1, 1,-1, 1}, ... % (  3,  706)
     {     'isge',          'uint8',  4, 4,-1, 1}, ... % (  1,  707)
     {     'isge',         'uint16',  1, 1,-1, 1}, ... % (  3,  710)
     {     'isge',         'uint16',  4, 4,-1, 1}, ... % (  1,  711)
     {     'isge',         'uint32',  1, 1,-1, 1}, ... % (  3,  714)
     {     'isge',         'uint32',  4, 4,-1, 1}, ... % (  1,  715)
     {     'isge',         'uint64',  1, 1,-1, 1}, ... % (  3,  718)
     {     'isge',         'uint64',  4, 4,-1, 1}, ... % (  1,  719)
     {     'isge',         'single',  1, 1,-1, 1}, ... % (  3,  722)
     {     'isge',         'single',  4, 4,-1, 1}, ... % (  1,  723)
     {     'isge',         'double',  1, 1,-1, 1}, ... % (  3,  726)
     {     'isge',         'double',  4, 4,-1, 1}, ... % (  1,  727)
     {     'isle',        'logical',  1, 1,-1, 1}, ... % (  1,  728)
     {     'isle',        'logical',  4, 4,-1, 1}, ... % (  1,  729)
     {     'isle',           'int8',  1, 1,-1, 1}, ... % (  3,  732)
     {     'isle',           'int8',  4, 4,-1, 1}, ... % (  1,  733)
     {     'isle',          'int16',  1, 1,-1, 1}, ... % (  3,  736)
     {     'isle',          'int16',  4, 4,-1, 1}, ... % (  1,  737)
     {     'isle',          'int32',  1, 1,-1, 1}, ... % (  3,  740)
     {     'isle',          'int32',  4, 4,-1, 1}, ... % (  1,  741)
     {     'isle',          'int64',  1, 1,-1, 1}, ... % (  3,  744)
     {     'isle',          'int64',  4, 4,-1, 1}, ... % (  1,  745)
     {     'isle',          'uint8',  1, 1,-1, 1}, ... % (  3,  748)
     {     'isle',          'uint8',  4, 4,-1, 1}, ... % (  1,  749)
     {     'isle',         'uint16',  1, 1,-1, 1}, ... % (  3,  752)
     {     'isle',         'uint16',  4, 4,-1, 1}, ... % (  1,  753)
     {     'isle',         'uint32',  1, 1,-1, 1}, ... % (  3,  756)
     {     'isle',         'uint32',  4, 4,-1, 1}, ... % (  1,  757)
     {     'isle',         'uint64',  1, 1,-1, 1}, ... % (  3,  760)
     {     'isle',         'uint64',  4, 4,-1, 1}, ... % (  1,  761)
     {     'isle',         'single',  1, 1,-1, 1}, ... % (  3,  764)
     {     'isle',         'single',  4, 4,-1, 1}, ... % (  1,  765)
     {     'isle',         'double',  1, 1,-1, 1}, ... % (  3,  768)
     {     'isle',         'double',  4, 4,-1, 1}, ... % (  1,  769)
     {       'gt',           'int8',  1, 1,-1, 1}, ... % (  1,  770)
     {       'gt',           'int8',  4, 4,-1, 1}, ... % (  1,  771)
     {       'gt',          'int16',  1, 1,-1, 1}, ... % (  1,  772)
     {       'gt',          'int16',  4, 4,-1, 1}, ... % (  1,  773)
     {       'gt',          'int32',  1, 1,-1, 1}, ... % (  1,  774)
     {       'gt',          'int32',  4, 4,-1, 1}, ... % (  1,  775)
     {       'gt',          'int64',  1, 1,-1, 1}, ... % (  1,  776)
     {       'gt',          'int64',  4, 4,-1, 1}, ... % (  1,  777)
     {       'gt',          'uint8',  1, 1,-1, 1}, ... % (  1,  778)
     {       'gt',          'uint8',  4, 4,-1, 1}, ... % (  1,  779)
     {       'gt',         'uint16',  1, 1,-1, 1}, ... % (  1,  780)
     {       'gt',         'uint16',  4, 4,-1, 1}, ... % (  1,  781)
     {       'gt',         'uint32',  1, 1,-1, 1}, ... % (  1,  782)
     {       'gt',         'uint32',  4, 4,-1, 1}, ... % (  1,  783)
     {       'gt',         'uint64',  1, 1,-1, 1}, ... % (  1,  784)
     {       'gt',         'uint64',  4, 4,-1, 1}, ... % (  1,  785)
     {       'gt',         'single',  1, 1,-1, 1}, ... % (  1,  786)
     {       'gt',         'single',  4, 4,-1, 1}, ... % (  1,  787)
     {       'gt',         'double',  1, 1,-1, 1}, ... % (  1,  788)
     {       'gt',         'double',  4, 4,-1, 1}, ... % (  1,  789)
     {       'lt',           'int8',  1, 1,-1, 1}, ... % (  1,  790)
     {       'lt',           'int8',  4, 4,-1, 1}, ... % (  1,  791)
     {       'lt',          'int16',  1, 1,-1, 1}, ... % (  1,  792)
     {       'lt',          'int16',  4, 4,-1, 1}, ... % (  1,  793)
     {       'lt',          'int32',  1, 1,-1, 1}, ... % (  1,  794)
     {       'lt',          'int32',  4, 4,-1, 1}, ... % (  1,  795)
     {       'lt',          'int64',  1, 1,-1, 1}, ... % (  1,  796)
     {       'lt',          'int64',  4, 4,-1, 1}, ... % (  1,  797)
     {       'lt',          'uint8',  1, 1,-1, 1}, ... % (  1,  798)
     {       'lt',          'uint8',  4, 4,-1, 1}, ... % (  1,  799)
     {       'lt',         'uint16',  1, 1,-1, 1}, ... % (  1,  800)
     {       'lt',         'uint16',  4, 4,-1, 1}, ... % (  1,  801)
     {       'lt',         'uint32',  1, 1,-1, 1}, ... % (  1,  802)
     {       'lt',         'uint32',  4, 4,-1, 1}, ... % (  1,  803)
     {       'lt',         'uint64',  1, 1,-1, 1}, ... % (  1,  804)
     {       'lt',         'uint64',  4, 4,-1, 1}, ... % (  1,  805)
     {       'lt',         'single',  1, 1,-1, 1}, ... % (  1,  806)
     {       'lt',         'single',  4, 4,-1, 1}, ... % (  1,  807)
     {       'lt',         'double',  1, 1,-1, 1}, ... % (  1,  808)
     {       'lt',         'double',  4, 4,-1, 1}, ... % (  1,  809)
     {       'ge',           'int8',  1, 1,-1, 1}, ... % (  1,  810)
     {       'ge',           'int8',  4, 4,-1, 1}, ... % (  1,  811)
     {       'ge',          'int16',  1, 1,-1, 1}, ... % (  1,  812)
     {       'ge',          'int16',  4, 4,-1, 1}, ... % (  1,  813)
     {       'ge',          'int32',  1, 1,-1, 1}, ... % (  1,  814)
     {       'ge',          'int32',  4, 4,-1, 1}, ... % (  1,  815)
     {       'ge',          'int64',  1, 1,-1, 1}, ... % (  1,  816)
     {       'ge',          'int64',  4, 4,-1, 1}, ... % (  1,  817)
     {       'ge',          'uint8',  1, 1,-1, 1}, ... % (  1,  818)
     {       'ge',          'uint8',  4, 4,-1, 1}, ... % (  1,  819)
     {       'ge',         'uint16',  1, 1,-1, 1}, ... % (  1,  820)
     {       'ge',         'uint16',  4, 4,-1, 1}, ... % (  1,  821)
     {       'ge',         'uint32',  1, 1,-1, 1}, ... % (  1,  822)
     {       'ge',         'uint32',  4, 4,-1, 1}, ... % (  1,  823)
     {       'ge',         'uint64',  1, 1,-1, 1}, ... % (  1,  824)
     {       'ge',         'uint64',  4, 4,-1, 1}, ... % (  1,  825)
     {       'ge',         'single',  1, 1,-1, 1}, ... % (  1,  826)
     {       'ge',         'single',  4, 4,-1, 1}, ... % (  1,  827)
     {       'ge',         'double',  1, 1,-1, 1}, ... % (  1,  828)
     {       'ge',         'double',  4, 4,-1, 1}, ... % (  1,  829)
     {       'le',           'int8',  1, 1,-1, 1}, ... % (  1,  830)
     {       'le',           'int8',  4, 4,-1, 1}, ... % (  1,  831)
     {       'le',          'int16',  1, 1,-1, 1}, ... % (  1,  832)
     {       'le',          'int16',  4, 4,-1, 1}, ... % (  1,  833)
     {       'le',          'int32',  1, 1,-1, 1}, ... % (  1,  834)
     {       'le',          'int32',  4, 4,-1, 1}, ... % (  1,  835)
     {       'le',          'int64',  1, 1,-1, 1}, ... % (  1,  836)
     {       'le',          'int64',  4, 4,-1, 1}, ... % (  1,  837)
     {       'le',          'uint8',  1, 1,-1, 1}, ... % (  1,  838)
     {       'le',          'uint8',  4, 4,-1, 1}, ... % (  1,  839)
     {       'le',         'uint16',  1, 1,-1, 1}, ... % (  1,  840)
     {       'le',         'uint16',  4, 4,-1, 1}, ... % (  1,  841)
     {       'le',         'uint32',  1, 1,-1, 1}, ... % (  1,  842)
     {       'le',         'uint32',  4, 4,-1, 1}, ... % (  1,  843)
     {       'le',         'uint64',  1, 1,-1, 1}, ... % (  1,  844)
     {       'le',         'uint64',  4, 4,-1, 1}, ... % (  1,  845)
     {       'le',         'single',  1, 1,-1, 1}, ... % (  1,  846)
     {       'le',         'single',  4, 4,-1, 1}, ... % (  1,  847)
     {       'le',         'double',  1, 1,-1, 1}, ... % (  1,  848)
     {       'le',         'double',  4, 4,-1, 1}, ... % (  1,  849)
     {       'or',           'int8',  1, 1,-1, 1}, ... % (  3,  852)
     {       'or',           'int8',  4, 4,-1, 1}, ... % (  1,  853)
     {       'or',          'int16',  1, 1,-1, 1}, ... % (  3,  856)
     {       'or',          'int16',  4, 4,-1, 1}, ... % (  1,  857)
     {       'or',          'int32',  1, 1,-1, 1}, ... % (  3,  860)
     {       'or',          'int32',  4, 4,-1, 1}, ... % (  1,  861)
     {       'or',          'int64',  1, 1,-1, 1}, ... % (  3,  864)
     {       'or',          'int64',  4, 4,-1, 1}, ... % (  1,  865)
     {       'or',          'uint8',  1, 1,-1, 1}, ... % (  3,  868)
     {       'or',          'uint8',  4, 4,-1, 1}, ... % (  1,  869)
     {       'or',         'uint16',  1, 1,-1, 1}, ... % (  3,  872)
     {       'or',         'uint16',  4, 4,-1, 1}, ... % (  1,  873)
     {       'or',         'uint32',  1, 1,-1, 1}, ... % (  3,  876)
     {       'or',         'uint32',  4, 4,-1, 1}, ... % (  1,  877)
     {       'or',         'uint64',  1, 1,-1, 1}, ... % (  3,  880)
     {       'or',         'uint64',  4, 4,-1, 1}, ... % (  1,  881)
     {       'or',         'single',  1, 1,-1, 1}, ... % (  3,  884)
     {       'or',         'single',  4, 4,-1, 1}, ... % (  1,  885)
     {       'or',         'double',  1, 1,-1, 1}, ... % (  3,  888)
     {       'or',         'double',  4, 4,-1, 1}, ... % (  1,  889)
     {      'and',           'int8',  1, 1,-1, 1}, ... % (  3,  892)
     {      'and',           'int8',  4, 4,-1, 1}, ... % (  1,  893)
     {      'and',          'int16',  1, 1,-1, 1}, ... % (  3,  896)
     {      'and',          'int16',  4, 4,-1, 1}, ... % (  1,  897)
     {      'and',          'int32',  1, 1,-1, 1}, ... % (  3,  900)
     {      'and',          'int32',  4, 4,-1, 1}, ... % (  1,  901)
     {      'and',          'int64',  1, 1,-1, 1}, ... % (  3,  904)
     {      'and',          'int64',  4, 4,-1, 1}, ... % (  1,  905)
     {      'and',          'uint8',  1, 1,-1, 1}, ... % (  3,  908)
     {      'and',          'uint8',  4, 4,-1, 1}, ... % (  1,  909)
     {      'and',         'uint16',  1, 1,-1, 1}, ... % (  3,  912)
     {      'and',         'uint16',  4, 4,-1, 1}, ... % (  1,  913)
     {      'and',         'uint32',  1, 1,-1, 1}, ... % (  3,  916)
     {      'and',         'uint32',  4, 4,-1, 1}, ... % (  1,  917)
     {      'and',         'uint64',  1, 1,-1, 1}, ... % (  3,  920)
     {      'and',         'uint64',  4, 4,-1, 1}, ... % (  1,  921)
     {      'and',         'single',  1, 1,-1, 1}, ... % (  3,  924)
     {      'and',         'single',  4, 4,-1, 1}, ... % (  1,  925)
     {      'and',         'double',  1, 1,-1, 1}, ... % (  3,  928)
     {      'and',         'double',  4, 4,-1, 1}, ... % (  1,  929)
     {      'xor',           'int8',  1, 1,-1, 1}, ... % (  3,  932)
     {      'xor',           'int8',  4, 4,-1, 1}, ... % (  1,  933)
     {      'xor',          'int16',  1, 1,-1, 1}, ... % (  3,  936)
     {      'xor',          'int16',  4, 4,-1, 1}, ... % (  1,  937)
     {      'xor',          'int32',  1, 1,-1, 1}, ... % (  3,  940)
     {      'xor',          'int32',  4, 4,-1, 1}, ... % (  1,  941)
     {      'xor',          'int64',  1, 1,-1, 1}, ... % (  3,  944)
     {      'xor',          'int64',  4, 4,-1, 1}, ... % (  1,  945)
     {      'xor',          'uint8',  1, 1,-1, 1}, ... % (  3,  948)
     {      'xor',          'uint8',  4, 4,-1, 1}, ... % (  1,  949)
     {      'xor',         'uint16',  1, 1,-1, 1}, ... % (  3,  952)
     {      'xor',         'uint16',  4, 4,-1, 1}, ... % (  1,  953)
     {      'xor',         'uint32',  1, 1,-1, 1}, ... % (  3,  956)
     {      'xor',         'uint32',  4, 4,-1, 1}, ... % (  1,  957)
     {      'xor',         'uint64',  1, 1,-1, 1}, ... % (  3,  960)
     {      'xor',         'uint64',  4, 4,-1, 1}, ... % (  1,  961)
     {      'xor',         'single',  1, 1,-1, 1}, ... % (  3,  964)
     {      'xor',         'single',  4, 4,-1, 1}, ... % (  1,  965)
     {      'xor',         'double',  1, 1,-1, 1}, ... % (  3,  968)
     {      'xor',         'double',  4, 4,-1, 1}, ... % (  1,  969)
     {      'bor',           'int8',  1, 1,-1, 1}, ... % (  3,  972)
     {      'bor',           'int8',  4, 4,-1, 1}, ... % (  1,  973)
     {      'bor',          'int16',  1, 1,-1, 1}, ... % (  3,  976)
     {      'bor',          'int16',  4, 4,-1, 1}, ... % (  1,  977)
     {      'bor',          'int32',  1, 1,-1, 1}, ... % (  3,  980)
     {      'bor',          'int32',  4, 4,-1, 1}, ... % (  1,  981)
     {      'bor',          'int64',  1, 1,-1, 1}, ... % (  3,  984)
     {      'bor',          'int64',  4, 4,-1, 1}, ... % (  1,  985)
     {      'bor',          'uint8',  1, 1,-1, 1}, ... % (  3,  988)
     {      'bor',          'uint8',  4, 4,-1, 1}, ... % (  1,  989)
     {      'bor',         'uint16',  1, 1,-1, 1}, ... % (  3,  992)
     {      'bor',         'uint16',  4, 4,-1, 1}, ... % (  1,  993)
     {      'bor',         'uint32',  1, 1,-1, 1}, ... % (  3,  996)
     {      'bor',         'uint32',  4, 4,-1, 1}, ... % (  1,  997)
     {      'bor',         'uint64',  1, 1,-1, 1}, ... % (  3, 1000)
     {      'bor',         'uint64',  4, 4,-1, 1}, ... % (  1, 1001)
     {     'band',           'int8',  1, 1,-1, 1}, ... % (  3, 1004)
     {     'band',           'int8',  4, 4,-1, 1}, ... % (  1, 1005)
     {     'band',          'int16',  1, 1,-1, 1}, ... % (  3, 1008)
     {     'band',          'int16',  4, 4,-1, 1}, ... % (  1, 1009)
     {     'band',          'int32',  1, 1,-1, 1}, ... % (  3, 1012)
     {     'band',          'int32',  4, 4,-1, 1}, ... % (  1, 1013)
     {     'band',          'int64',  1, 1,-1, 1}, ... % (  3, 1016)
     {     'band',          'int64',  4, 4,-1, 1}, ... % (  1, 1017)
     {     'band',          'uint8',  1, 1,-1, 1}, ... % (  3, 1020)
     {     'band',          'uint8',  4, 4,-1, 1}, ... % (  1, 1021)
     {     'band',         'uint16',  1, 1,-1, 1}, ... % (  3, 1024)
     {     'band',         'uint16',  4, 4,-1, 1}, ... % (  1, 1025)
     {     'band',         'uint32',  1, 1,-1, 1}, ... % (  3, 1028)
     {     'band',         'uint32',  4, 4,-1, 1}, ... % (  1, 1029)
     {     'band',         'uint64',  1, 1,-1, 1}, ... % (  3, 1032)
     {     'band',         'uint64',  4, 4,-1, 1}, ... % (  1, 1033)
     {     'bxor',           'int8',  1, 1,-1, 1}, ... % (  3, 1036)
     {     'bxor',           'int8',  4, 4,-1, 1}, ... % (  1, 1037)
     {     'bxor',          'int16',  1, 1,-1, 1}, ... % (  3, 1040)
     {     'bxor',          'int16',  4, 4,-1, 1}, ... % (  1, 1041)
     {     'bxor',          'int32',  1, 1,-1, 1}, ... % (  3, 1044)
     {     'bxor',          'int32',  4, 4,-1, 1}, ... % (  1, 1045)
     {     'bxor',          'int64',  1, 1,-1, 1}, ... % (  3, 1048)
     {     'bxor',          'int64',  4, 4,-1, 1}, ... % (  1, 1049)
     {     'bxor',          'uint8',  1, 1,-1, 1}, ... % (  3, 1052)
     {     'bxor',          'uint8',  4, 4,-1, 1}, ... % (  1, 1053)
     {     'bxor',         'uint16',  1, 1,-1, 1}, ... % (  3, 1056)
     {     'bxor',         'uint16',  4, 4,-1, 1}, ... % (  1, 1057)
     {     'bxor',         'uint32',  1, 1,-1, 1}, ... % (  3, 1060)
     {     'bxor',         'uint32',  4, 4,-1, 1}, ... % (  1, 1061)
     {     'bxor',         'uint64',  1, 1,-1, 1}, ... % (  3, 1064)
     {     'bxor',         'uint64',  4, 4,-1, 1}, ... % (  1, 1065)
     {    'bxnor',           'int8',  1, 1,-1, 1}, ... % (  3, 1068)
     {    'bxnor',           'int8',  4, 4,-1, 1}, ... % (  1, 1069)
     {    'bxnor',          'int16',  1, 1,-1, 1}, ... % (  3, 1072)
     {    'bxnor',          'int16',  4, 4,-1, 1}, ... % (  1, 1073)
     {    'bxnor',          'int32',  1, 1,-1, 1}, ... % (  3, 1076)
     {    'bxnor',          'int32',  4, 4,-1, 1}, ... % (  1, 1077)
     {    'bxnor',          'int64',  1, 1,-1, 1}, ... % (  3, 1080)
     {    'bxnor',          'int64',  4, 4,-1, 1}, ... % (  1, 1081)
     {    'bxnor',          'uint8',  1, 1,-1, 1}, ... % (  3, 1084)
     {    'bxnor',          'uint8',  4, 4,-1, 1}, ... % (  1, 1085)
     {    'bxnor',         'uint16',  1, 1,-1, 1}, ... % (  3, 1088)
     {    'bxnor',         'uint16',  4, 4,-1, 1}, ... % (  1, 1089)
     {    'bxnor',         'uint32',  1, 1,-1, 1}, ... % (  3, 1092)
     {    'bxnor',         'uint32',  4, 4,-1, 1}, ... % (  1, 1093)
     {    'bxnor',         'uint64',  1, 1,-1, 1}, ... % (  3, 1096)
     {    'bxnor',         'uint64',  4, 4,-1, 1}, ... % (  1, 1097)
     {     'bget',           'int8',  1, 1,-1, 1}, ... % (  3, 1100)
     {     'bget',           'int8',  4, 4,-1, 1}, ... % (  1, 1101)
     {     'bget',          'int16',  1, 1,-1, 1}, ... % (  3, 1104)
     {     'bget',          'int16',  4, 4,-1, 1}, ... % (  1, 1105)
     {     'bget',          'int32',  1, 1,-1, 1}, ... % (  3, 1108)
     {     'bget',          'int32',  4, 4,-1, 1}, ... % (  1, 1109)
     {     'bget',          'int64',  1, 1,-1, 1}, ... % (  3, 1112)
     {     'bget',          'int64',  4, 4,-1, 1}, ... % (  1, 1113)
     {     'bget',          'uint8',  1, 1,-1, 1}, ... % (  3, 1116)
     {     'bget',          'uint8',  4, 4,-1, 1}, ... % (  1, 1117)
     {     'bget',         'uint16',  1, 1,-1, 1}, ... % (  3, 1120)
     {     'bget',         'uint16',  4, 4,-1, 1}, ... % (  1, 1121)
     {     'bget',         'uint32',  1, 1,-1, 1}, ... % (  3, 1124)
     {     'bget',         'uint32',  4, 4,-1, 1}, ... % (  1, 1125)
     {     'bget',         'uint64',  1, 1,-1, 1}, ... % (  3, 1128)
     {     'bget',         'uint64',  4, 4,-1, 1}, ... % (  1, 1129)
     {     'bset',           'int8',  1, 1,-1, 1}, ... % (  3, 1132)
     {     'bset',           'int8',  4, 4,-1, 1}, ... % (  1, 1133)
     {     'bset',          'int16',  1, 1,-1, 1}, ... % (  3, 1136)
     {     'bset',          'int16',  4, 4,-1, 1}, ... % (  1, 1137)
     {     'bset',          'int32',  1, 1,-1, 1}, ... % (  3, 1140)
     {     'bset',          'int32',  4, 4,-1, 1}, ... % (  1, 1141)
     {     'bset',          'int64',  1, 1,-1, 1}, ... % (  3, 1144)
     {     'bset',          'int64',  4, 4,-1, 1}, ... % (  1, 1145)
     {     'bset',          'uint8',  1, 1,-1, 1}, ... % (  3, 1148)
     {     'bset',          'uint8',  4, 4,-1, 1}, ... % (  1, 1149)
     {     'bset',         'uint16',  1, 1,-1, 1}, ... % (  3, 1152)
     {     'bset',         'uint16',  4, 4,-1, 1}, ... % (  1, 1153)
     {     'bset',         'uint32',  1, 1,-1, 1}, ... % (  3, 1156)
     {     'bset',         'uint32',  4, 4,-1, 1}, ... % (  1, 1157)
     {     'bset',         'uint64',  1, 1,-1, 1}, ... % (  3, 1160)
     {     'bset',         'uint64',  4, 4,-1, 1}, ... % (  1, 1161)
     {     'bclr',           'int8',  1, 1,-1, 1}, ... % (  3, 1164)
     {     'bclr',           'int8',  4, 4,-1, 1}, ... % (  1, 1165)
     {     'bclr',          'int16',  1, 1,-1, 1}, ... % (  3, 1168)
     {     'bclr',          'int16',  4, 4,-1, 1}, ... % (  1, 1169)
     {     'bclr',          'int32',  1, 1,-1, 1}, ... % (  3, 1172)
     {     'bclr',          'int32',  4, 4,-1, 1}, ... % (  1, 1173)
     {     'bclr',          'int64',  1, 1,-1, 1}, ... % (  3, 1176)
     {     'bclr',          'int64',  4, 4,-1, 1}, ... % (  1, 1177)
     {     'bclr',          'uint8',  1, 1,-1, 1}, ... % (  3, 1180)
     {     'bclr',          'uint8',  4, 4,-1, 1}, ... % (  1, 1181)
     {     'bclr',         'uint16',  1, 1,-1, 1}, ... % (  3, 1184)
     {     'bclr',         'uint16',  4, 4,-1, 1}, ... % (  1, 1185)
     {     'bclr',         'uint32',  1, 1,-1, 1}, ... % (  3, 1188)
     {     'bclr',         'uint32',  4, 4,-1, 1}, ... % (  1, 1189)
     {     'bclr',         'uint64',  1, 1,-1, 1}, ... % (  3, 1192)
     {     'bclr',         'uint64',  4, 4,-1, 1}, ... % (  1, 1193)
     {   'bshift',           'int8',  1, 1,-1, 1}, ... % (  3, 1196)
     {   'bshift',           'int8',  4, 4,-1, 1}, ... % (  1, 1197)
     {   'bshift',          'int16',  1, 1,-1, 1}, ... % (  3, 1200)
     {   'bshift',          'int16',  4, 4,-1, 1}, ... % (  1, 1201)
     {   'bshift',          'int32',  1, 1,-1, 1}, ... % (  3, 1204)
     {   'bshift',          'int32',  4, 4,-1, 1}, ... % (  1, 1205)
     {   'bshift',          'int64',  1, 1,-1, 1}, ... % (  3, 1208)
     {   'bshift',          'int64',  4, 4,-1, 1}, ... % (  1, 1209)
     {   'bshift',          'uint8',  1, 1,-1, 1}, ... % (  3, 1212)
     {   'bshift',          'uint8',  4, 4,-1, 1}, ... % (  1, 1213)
     {   'bshift',         'uint16',  1, 1,-1, 1}, ... % (  3, 1216)
     {   'bshift',         'uint16',  4, 4,-1, 1}, ... % (  1, 1217)
     {   'bshift',         'uint32',  1, 1,-1, 1}, ... % (  3, 1220)
     {   'bshift',         'uint32',  4, 4,-1, 1}, ... % (  1, 1221)
     {   'bshift',         'uint64',  1, 1,-1, 1}, ... % (  3, 1224)
     {   'bshift',         'uint64',  4, 4,-1, 1}, ... % (  1, 1225)
     {    'atan2',         'single',  1, 1,-1, 1}, ... % (  3, 1228)
     {    'atan2',         'single',  4, 4,-1, 1}, ... % (  1, 1229)
     {    'atan2',         'double',  1, 1,-1, 1}, ... % (  3, 1232)
     {    'atan2',         'double',  4, 4,-1, 1}, ... % (  1, 1233)
     {    'hypot',         'single',  1, 1,-1, 1}, ... % (  3, 1236)
     {    'hypot',         'single',  4, 4,-1, 1}, ... % (  1, 1237)
     {    'hypot',         'double',  1, 1,-1, 1}, ... % (  3, 1240)
     {    'hypot',         'double',  4, 4,-1, 1}, ... % (  1, 1241)
     {     'fmod',         'single',  1, 1,-1, 1}, ... % (  3, 1244)
     {     'fmod',         'single',  4, 4,-1, 1}, ... % (  1, 1245)
     {     'fmod',         'double',  1, 1,-1, 1}, ... % (  3, 1248)
     {     'fmod',         'double',  4, 4,-1, 1}, ... % (  1, 1249)
     {'remainder',         'single',  1, 1,-1, 1}, ... % (  3, 1252)
     {'remainder',         'single',  4, 4,-1, 1}, ... % (  1, 1253)
     {'remainder',         'double',  1, 1,-1, 1}, ... % (  3, 1256)
     {'remainder',         'double',  4, 4,-1, 1}, ... % (  1, 1257)
     {    'ldexp',         'single',  1, 1,-1, 1}, ... % (  3, 1260)
     {    'ldexp',         'single',  4, 4,-1, 1}, ... % (  1, 1261)
     {    'ldexp',         'double',  1, 1,-1, 1}, ... % (  3, 1264)
     {    'ldexp',         'double',  4, 4,-1, 1}, ... % (  1, 1265)
     { 'copysign',         'single',  1, 1,-1, 1}, ... % (  3, 1268)
     { 'copysign',         'single',  4, 4,-1, 1}, ... % (  1, 1269)
     { 'copysign',         'double',  1, 1,-1, 1}, ... % (  3, 1272)
     { 'copysign',         'double',  4, 4,-1, 1}, ... % (  1, 1273)
     {    'cmplx',         'single',  1, 1,-1, 1}, ... % (  3, 1276)
     {    'cmplx',         'single',  4, 4,-1, 1}, ... % (  1, 1277)
     {    'cmplx',         'double',  1, 1,-1, 1}, ... % (  3, 1280)
     {    'cmplx',         'double',  4, 4,-1, 1}, ... % (  1, 1281)
     {   'firsti',          'int32',  1, 1,-1, 1}, ... % (  5, 1286)
     {  'firsti1',          'int32',  1, 1,-1, 1}, ... % (  4, 1290)
    } ;
end

track_coverage = false ;
if (track_coverage)
    global GraphBLAS_grbcov
    track_coverage = ~isempty (GraphBLAS_grbcov) ;
    clast = sum (GraphBLAS_grbcov > 0) ;
    cfirst = clast ;
end

fprintf ('\n--- testing apply with binaryop and scalar binding\n') ;
% the right approach for apply_bind1st and apply_bind2nd
desc0.inp0 = 'tran' ;
desc1.inp1 = 'tran' ;
% shotgun approach for eWiseMult
desc.inp0 = 'tran' ;
desc.inp1 = 'tran' ;

% create test matrices
rng ('default') ;
for m = [1 4]
    for n = [1 4]
        AA_matrices {m,n} = sprand (m, n, 0.8) ;
        AS_matrices {m,n} = sprand (m, n, 0.5) ;
        BB_matrices {m,n} = sprand (m, n, 0.8) ;
        BS_matrices {m,n} = sprand (m, n, 0.5) ;
        xx_matrix = sparse (rand (1)) ;
        xs_matrix = sparse (rand (1)) ;
        yy_matrix = sparse (rand (1)) ;
        ys_matrix = sparse (rand (1)) ;
    end
end

for kk = 1:length(tasks)
    task = tasks {kk} ;
    mulop = task {1} ;
    type = task {2} ;
    m = task {3} ;
    n = task {4} ;
    lo = task {5} ;
    hi = task {6} ;

    % create the op
    clear op
    op.opname = mulop ;
    op.optype = type ;

    try
        [oname ot ztype xtype ytype] = GB_spec_operator (op) ;
    catch
        continue ;
    end

    switch (mulop)
        case { 'pow' }
            xlimits = [0, 5] ;
            ylimits = [0, 5] ;
        case { 'ldexp' }
            xlimits = [-5, 5] ;
            ylimits = [-5, 5] ;
        otherwise
            xlimits = [ ] ;
            ylimits = [ ] ;
    end

    if (test_contains (type, 'single'))
        tol = 1e-5 ;
    elseif (test_contains (type, 'double'))
        tol = 1e-12 ;
    else
        tol = 0 ;
    end

    Amat = (hi*AA_matrices{m,n}-lo) .* AS_matrices{m,n} ;
    Bmat = (hi*BB_matrices{m,n}-lo) .* BS_matrices{m,n} ;
    xmat = (hi*xx_matrix-lo) .* xs_matrix ;
    ymat = (hi*yy_matrix-lo) .* ys_matrix ;

    Cmat = sparse (m, n) ;
    if (~isempty (xlimits))
        Amat = max (Amat, xlimits (1)) ;
        Amat = min (Amat, xlimits (2)) ;
        xmat = max (xmat, xlimits (1)) ;
        xmat = min (xmat, xlimits (2)) ;
    end
    if (xmat == 0)
        xmat = sparse (0.5) ;
    end

    if (~isempty (ylimits))
        Bmat = max (Bmat, ylimits (1)) ;
        Bmat = min (Bmat, ylimits (2)) ;
        ymat = max (ymat, ylimits (1)) ;
        ymat = min (ymat, ylimits (2)) ;
    end
    if (ymat == 0)
        ymat = sparse (0.5) ;
    end

    C.matrix = Cmat ;
    C.class = ztype ;

    CT.matrix = Cmat' ;
    CT.class = ztype ;

    A.matrix = Amat ;
    A.class = xtype ;

    B.matrix = Bmat ;
    B.class = ytype ;

    x.matrix = xmat ;
    x.class = xtype ;

    y.matrix = ymat ;
    y.class = ytype ;

    X.matrix = xmat .* spones (Bmat) ;
    X.class = xtype ;

    Y.matrix = ymat .* spones (Amat) ; 
    Y.class = ytype ;

    op_bind1 = op ;
    op_bind2 = op ;
    if (isequal (op.opname, 'any'))
        op_bind1.opname = 'first' ;
        op_bind2.opname = 'second' ;
    end

    C1 = GB_mex_apply1 (C, [ ], [ ], op, 0, x, B) ;
    C2 = GB_spec_Matrix_eWiseMult (C, [ ], [ ], op_bind1, X, B, [ ]) ;
    GB_spec_compare (C1, C2, 0, tol) ;
    C1 = GB_mex_apply1 (C, [ ], [ ], op, 1, x, B) ;
    GB_spec_compare (C1, C2, 0, tol) ;

    C1 = GB_mex_apply1 (CT, [ ], [ ], op, 0, x, B, desc1) ;
    C2 = GB_spec_Matrix_eWiseMult (CT, [ ], [ ], op_bind1, X, B, desc) ;
    GB_spec_compare (C1, C2, 0, tol) ;
    C1 = GB_mex_apply1 (CT, [ ], [ ], op, 1, x, B, desc1) ;
    GB_spec_compare (C1, C2, 0, tol) ;

    for csc = 0:1
        A.is_csc = csc ;
        C.is_csc = csc ;
        CT.is_csc = csc ;

        C1 = GB_mex_apply2 (C, [ ], [ ], op, 0, A, y) ;
        C2 = GB_spec_Matrix_eWiseMult (C, [ ], [ ], op_bind2, A, Y, [ ]) ;
        GB_spec_compare (C1, C2, 0, tol) ;
        C1 = GB_mex_apply2 (C, [ ], [ ], op, 1, A, y) ;
        GB_spec_compare (C1, C2, 0, tol) ;

        C1 = GB_mex_apply2 (CT, [ ], [ ], op, 0, A, y, desc0) ;
        C2 = GB_spec_Matrix_eWiseMult (CT, [ ], [ ], op_bind2, A, Y, desc) ;
        GB_spec_compare (C1, C2, 0, tol) ;
        C1 = GB_mex_apply2 (CT, [ ], [ ], op, 1, A, y, desc0) ;
        GB_spec_compare (C1, C2, 0, tol) ;
    end

    A.is_csc = 1 ;
    C.is_csc = 1 ;
    CT.is_csc = 1 ;

    y.class = 'double' ;
    Y.class = 'double' ;

    C1 = GB_mex_apply2 (C, [ ], [ ], op, 0, A, y) ;
    C2 = GB_spec_Matrix_eWiseMult (C, [ ], [ ], op_bind2, A, Y, [ ]) ;
    GB_spec_compare (C1, C2, 0, tol) ;

    C1 = GB_mex_apply2 (C, [ ], [ ], op, 1, A, y) ;
    GB_spec_compare (C1, C2, 0, tol) ;

    C1 = GB_mex_apply2 (CT, [ ], [ ], op, 0, A, y, desc0) ;
    C2 = GB_spec_Matrix_eWiseMult (CT, [ ], [ ], op_bind2, A, Y, desc) ;
    GB_spec_compare (C1, C2, 0, tol) ;
    C1 = GB_mex_apply2 (CT, [ ], [ ], op, 1, A, y, desc0) ;
    GB_spec_compare (C1, C2, 0, tol) ;

    if (track_coverage)
        c = sum (GraphBLAS_grbcov > 0) ;
        d = c - clast ;
        if (d > 0)
            mm = sprintf ('''%s''', mulop) ;
            tt = sprintf ('''%s''', type) ;
            fprintf (...
            '{%11s, %16s, %2d,%2d,%2d,%2d}, ... ', ...
            mm, tt, m, n, lo, hi) ;
            fprintf ('%% (%3d, %4d)\n', d, c - cfirst) ;
        end
        clast = c ;
    else
        fprintf ('.') ;
    end

end

fprintf ('\ntest154: all tests passed\n') ;

