//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kcallinterfaceopenwithgate?language=objc)
pub const kCallInterfaceOpenWithGate: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"kCallInterfaceOpenWithGate\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbunknownpipeerr?language=objc)
pub const kIOUSBUnknownPipeErr: c_uint = iokit_usb_err!(0x61);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbtoomanypipeserr?language=objc)
pub const kIOUSBTooManyPipesErr: c_uint = iokit_usb_err!(0x60);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbnoasyncporterr?language=objc)
pub const kIOUSBNoAsyncPortErr: c_uint = iokit_usb_err!(0x5f);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbnotenoughpipeserr?language=objc)
pub const kIOUSBNotEnoughPipesErr: c_uint = iokit_usb_err!(0x5e);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbnotenoughpowererr?language=objc)
pub const kIOUSBNotEnoughPowerErr: c_uint = iokit_usb_err!(0x5d);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointnotfound?language=objc)
pub const kIOUSBEndpointNotFound: c_uint = iokit_usb_err!(0x57);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbconfignotfound?language=objc)
pub const kIOUSBConfigNotFound: c_uint = iokit_usb_err!(0x56);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbportwassuspended?language=objc)
pub const kIOUSBPortWasSuspended: c_uint = iokit_usb_err!(0x52);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbpipestalled?language=objc)
pub const kIOUSBPipeStalled: c_uint = iokit_usb_err!(0x4f);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbinterfacenotfound?language=objc)
pub const kIOUSBInterfaceNotFound: c_uint = iokit_usb_err!(0x4e);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousblowlatencybuffernotpreviouslyallocated?language=objc)
pub const kIOUSBLowLatencyBufferNotPreviouslyAllocated: c_uint = iokit_usb_err!(0x4d);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousblowlatencyframelistnotpreviouslyallocated?language=objc)
pub const kIOUSBLowLatencyFrameListNotPreviouslyAllocated: c_uint = iokit_usb_err!(0x4c);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbhighspeedspliterror?language=objc)
pub const kIOUSBHighSpeedSplitError: c_uint = iokit_usb_err!(0x4b);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsyncrequestonwlthread?language=objc)
pub const kIOUSBSyncRequestOnWLThread: c_uint = iokit_usb_err!(0x4a);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicenothighspeed?language=objc)
pub const kIOUSBDeviceNotHighSpeed: c_uint = iokit_usb_err!(0x49);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicetransferredtocompanion?language=objc)
pub const kIOUSBDeviceTransferredToCompanion: c_uint = iokit_usb_err!(0x49);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbclearpipestallnotrecursive?language=objc)
pub const kIOUSBClearPipeStallNotRecursive: c_uint = iokit_usb_err!(0x48);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdeviceportwasnotsuspended?language=objc)
pub const kIOUSBDevicePortWasNotSuspended: c_uint = iokit_usb_err!(0x47);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointcountexceeded?language=objc)
pub const kIOUSBEndpointCountExceeded: c_uint = iokit_usb_err!(0x46);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicecountexceeded?language=objc)
pub const kIOUSBDeviceCountExceeded: c_uint = iokit_usb_err!(0x45);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbstreamsnotsupported?language=objc)
pub const kIOUSBStreamsNotSupported: c_uint = iokit_usb_err!(0x44);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbinvalidssendpoint?language=objc)
pub const kIOUSBInvalidSSEndpoint: c_uint = iokit_usb_err!(0x43);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbtoomanytransactionspending?language=objc)
pub const kIOUSBTooManyTransactionsPending: c_uint = iokit_usb_err!(0x42);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbtransactionreturned?language=objc)
pub const kIOUSBTransactionReturned: c_uint = iokit_usb_err!(0x50);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbtransactiontimeout?language=objc)
pub const kIOUSBTransactionTimeout: c_uint = iokit_usb_err!(0x51);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousblinkerr?language=objc)
pub const kIOUSBLinkErr: c_uint = iokit_usb_err!(0x10);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbnotsent2err?language=objc)
pub const kIOUSBNotSent2Err: c_uint = iokit_usb_err!(0x0f);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbnotsent1err?language=objc)
pub const kIOUSBNotSent1Err: c_uint = iokit_usb_err!(0x0e);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbbufferunderrunerr?language=objc)
pub const kIOUSBBufferUnderrunErr: c_uint = iokit_usb_err!(0x0d);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbbufferoverrunerr?language=objc)
pub const kIOUSBBufferOverrunErr: c_uint = iokit_usb_err!(0x0c);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbreserved2err?language=objc)
pub const kIOUSBReserved2Err: c_uint = iokit_usb_err!(0x0b);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbreserved1err?language=objc)
pub const kIOUSBReserved1Err: c_uint = iokit_usb_err!(0x0a);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbwrongpiderr?language=objc)
pub const kIOUSBWrongPIDErr: c_uint = iokit_usb_err!(0x07);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbpidcheckerr?language=objc)
pub const kIOUSBPIDCheckErr: c_uint = iokit_usb_err!(0x06);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdatatoggleerr?language=objc)
pub const kIOUSBDataToggleErr: c_uint = iokit_usb_err!(0x03);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbbitstuferr?language=objc)
pub const kIOUSBBitstufErr: c_uint = iokit_usb_err!(0x02);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbcrcerr?language=objc)
pub const kIOUSBCRCErr: c_uint = iokit_usb_err!(0x01);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubresetport?language=objc)
pub const kIOUSBMessageHubResetPort: c_uint = iokit_usb_msg!(0x01);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubsuspendport?language=objc)
pub const kIOUSBMessageHubSuspendPort: c_uint = iokit_usb_msg!(0x02);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubresumeport?language=objc)
pub const kIOUSBMessageHubResumePort: c_uint = iokit_usb_msg!(0x03);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubisdeviceconnected?language=objc)
pub const kIOUSBMessageHubIsDeviceConnected: c_uint = iokit_usb_msg!(0x04);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubisportenabled?language=objc)
pub const kIOUSBMessageHubIsPortEnabled: c_uint = iokit_usb_msg!(0x05);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubreenumerateport?language=objc)
pub const kIOUSBMessageHubReEnumeratePort: c_uint = iokit_usb_msg!(0x06);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageporthasbeenreset?language=objc)
pub const kIOUSBMessagePortHasBeenReset: c_uint = iokit_usb_msg!(0x0a);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageporthasbeenresumed?language=objc)
pub const kIOUSBMessagePortHasBeenResumed: c_uint = iokit_usb_msg!(0x0b);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubportcleartt?language=objc)
pub const kIOUSBMessageHubPortClearTT: c_uint = iokit_usb_msg!(0x0c);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageporthasbeensuspended?language=objc)
pub const kIOUSBMessagePortHasBeenSuspended: c_uint = iokit_usb_msg!(0x0d);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagefromthirdparty?language=objc)
pub const kIOUSBMessageFromThirdParty: c_uint = iokit_usb_msg!(0x0e);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageportwasnotsuspended?language=objc)
pub const kIOUSBMessagePortWasNotSuspended: c_uint = iokit_usb_msg!(0x0f);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageexpresscardcantwake?language=objc)
pub const kIOUSBMessageExpressCardCantWake: c_uint = iokit_usb_msg!(0x10);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagecompositedriverreconfigured?language=objc)
pub const kIOUSBMessageCompositeDriverReconfigured: c_uint = iokit_usb_msg!(0x11);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubsetportrecoverytime?language=objc)
pub const kIOUSBMessageHubSetPortRecoveryTime: c_uint = iokit_usb_msg!(0x12);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageovercurrentcondition?language=objc)
pub const kIOUSBMessageOvercurrentCondition: c_uint = iokit_usb_msg!(0x13);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagenotenoughpower?language=objc)
pub const kIOUSBMessageNotEnoughPower: c_uint = iokit_usb_msg!(0x14);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagecontroller?language=objc)
pub const kIOUSBMessageController: c_uint = iokit_usb_msg!(0x15);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageroothubwakeevent?language=objc)
pub const kIOUSBMessageRootHubWakeEvent: c_uint = iokit_usb_msg!(0x16);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagereleaseextracurrent?language=objc)
pub const kIOUSBMessageReleaseExtraCurrent: c_uint = iokit_usb_msg!(0x17);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagereallocateextracurrent?language=objc)
pub const kIOUSBMessageReallocateExtraCurrent: c_uint = iokit_usb_msg!(0x18);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageendpointcountexceeded?language=objc)
pub const kIOUSBMessageEndpointCountExceeded: c_uint = iokit_usb_msg!(0x19);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagedevicecountexceeded?language=objc)
pub const kIOUSBMessageDeviceCountExceeded: c_uint = iokit_usb_msg!(0x1a);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubportdevicedisconnected?language=objc)
pub const kIOUSBMessageHubPortDeviceDisconnected: c_uint = iokit_usb_msg!(0x1b);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageunsupportedconfiguration?language=objc)
pub const kIOUSBMessageUnsupportedConfiguration: c_uint = iokit_usb_msg!(0x1c);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagehubcountexceeded?language=objc)
pub const kIOUSBMessageHubCountExceeded: c_uint = iokit_usb_msg!(0x1d);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagetdmlowbattery?language=objc)
pub const kIOUSBMessageTDMLowBattery: c_uint = iokit_usb_msg!(0x1e);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagelegacysuspenddevice?language=objc)
pub const kIOUSBMessageLegacySuspendDevice: c_uint = iokit_usb_msg!(0x1f);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagelegacyresetdevice?language=objc)
pub const kIOUSBMessageLegacyResetDevice: c_uint = iokit_usb_msg!(0x20);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessagelegacyreenumeratedevice?language=objc)
pub const kIOUSBMessageLegacyReEnumerateDevice: c_uint = iokit_usb_msg!(0x21);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbmessageconfigurationset?language=objc)
pub const kIOUSBMessageConfigurationSet: c_uint = iokit_usb_msg!(0x22);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicepropertybuspoweravailable?language=objc)
pub const kUSBDevicePropertyBusPowerAvailable: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Bus Power Available\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicepropertylocationid?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBDevicePropertyLocationID: &CStr = kUSBHostPropertyLocationID;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbproductidmask?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBProductIDMask: &CStr = kUSBHostMatchingPropertyProductIDMask;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbproductidsarrayname?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBProductIdsArrayName: &CStr = kUSBHostMatchingPropertyProductIDArray;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbsuspendport?language=objc)
pub const kUSBSuspendPort: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"kSuspendPort\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbexpresscardcantwake?language=objc)
pub const kUSBExpressCardCantWake: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"ExpressCardCantWake\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdeviceresumerecoverytime?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBDeviceResumeRecoveryTime: &CStr = kUSBHostDevicePropertyResumeRecoveryTime;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusboutofspecmpsok?language=objc)
pub const kUSBOutOfSpecMPSOK: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Out of spec MPS OK\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/koverrideifatlocationid?language=objc)
pub const kOverrideIfAtLocationID: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"OverrideIfAtLocationID\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicecurrentconfiguration?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBDeviceCurrentConfiguration: &CStr = kUSBHostDevicePropertyCurrentConfiguration;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdeviceremotewakeoverride?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBDeviceRemoteWakeOverride: &CStr = kUSBHostDevicePropertyRemoteWakeOverride;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdeviceconfigurationcurrentoverride?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBDeviceConfigurationCurrentOverride: &CStr =
    kUSBHostDevicePropertyConfigurationCurrentOverride;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdeviceresetdurationoverride?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBDeviceResetDurationOverride: &CStr = kUSBHostDevicePropertyResetDurationOverride;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicefailedrequestedpower?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBDeviceFailedRequestedPower: &CStr = kUSBHostDevicePropertyFailedRequestedPower;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbpropertyremovable?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBPropertyRemovable: &CStr = kUSBHostPortPropertyRemovable;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbpropertytestmode?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBPropertyTestMode: &CStr = kUSBHostPortPropertyTestMode;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbpropertydebuglevel?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBPropertyDebugLevel: &CStr = kUSBHostPropertyDebugOptions;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbhubpropertypowersupply?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBHubPropertyPowerSupply: &CStr = kUSBHostHubPropertyPowerSupply;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbcontrollersleepsupported?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBControllerSleepSupported: &CStr = kUSBHostControllerPropertySleepSupported;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbportpropertybuscurrentallocation?language=objc)
#[cfg(feature = "IOUSBHostFamilyDefinitions")]
pub const kUSBPortPropertyBusCurrentAllocation: &CStr = kUSBHostPortPropertyBusCurrentAllocation;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbpreferredinterface?language=objc)
pub const kUSBPreferredInterface: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Preferred Interface\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbpreferredinterfacepriority?language=objc)
pub const kUSBPreferredInterfacePriority: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"priority\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/koverrideallowlowpower?language=objc)
pub const kOverrideAllowLowPower: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"kOverrideAllowLowPower\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbusercliententitlementrequired?language=objc)
pub const kUSBUserClientEntitlementRequired: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"UsbUserClientEntitlementRequired\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicepropertyspeed?language=objc)
pub const kUSBDevicePropertySpeed: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Device Speed\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicepropertyaddress?language=objc)
pub const kUSBDevicePropertyAddress: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"USB Address\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbpreferredconfiguration?language=objc)
pub const kUSBPreferredConfiguration: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Preferred Configuration\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbcontrollerneedscontiguousmemoryforisoch?language=objc)
pub const kUSBControllerNeedsContiguousMemoryForIsoch: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Need contiguous memory for isoch\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbhubdontallowlowpower?language=objc)
pub const kUSBHubDontAllowLowPower: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"kUSBHubDontAllowLowPower\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kconfigurationdescriptoroverride?language=objc)
pub const kConfigurationDescriptorOverride: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"ConfigurationDescriptorOverride\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kapplerevocableextracurrent?language=objc)
pub const kAppleRevocableExtraCurrent: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,revocable-extra-current\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kappleexternalsuperspeedports?language=objc)
pub const kAppleExternalSuperSpeedPorts: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,ExternalSSPorts\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kappleunconnectedsuperspeedports?language=objc)
pub const kAppleUnconnectedSuperSpeedPorts: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,UnconnectedSSPorts\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kappleacpiroothubdepth?language=objc)
pub const kAppleAcpiRootHubDepth: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,root-hub-depth\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kapplestandardportcurrentinsleep?language=objc)
pub const kAppleStandardPortCurrentInSleep: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,standard-port-current-in-sleep\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kappleinternalusbdevice?language=objc)
pub const kAppleInternalUSBDevice: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,device-internal\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbbusid?language=objc)
pub const kUSBBusID: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,bus-id\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kapplepowersupply?language=objc)
pub const kApplePowerSupply: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,power-supply\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kapplecurrentavailable?language=objc)
pub const kAppleCurrentAvailable: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,current-available\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kapplecurrentinsleep?language=objc)
pub const kAppleCurrentInSleep: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,current-in-sleep\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kappleportcurrentinsleep?language=objc)
pub const kApplePortCurrentInSleep: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AAPL,port-current-in-sleep\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/koverrideattachedtocpu?language=objc)
pub const kOverrideAttachedToCPU: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"kOverrideAttachedToCPU\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kehciisochmaxbusstall?language=objc)
pub const kEHCIIsochMaxBusStall: c_uint = 25000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kxhciisochmaxbusstall?language=objc)
pub const kXHCIIsochMaxBusStall: c_uint = 25000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kohciisochmaxbusstall?language=objc)
pub const kOHCIIsochMaxBusStall: c_uint = 25000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kuhciisochmaxbusstall?language=objc)
pub const kUHCIIsochMaxBusStall: c_uint = 10000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kmaxbusstall10us?language=objc)
pub const kMaxBusStall10uS: c_uint = 10000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kmaxbusstall25us?language=objc)
pub const kMaxBusStall25uS: c_uint = 25000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdeviceidshift?language=objc)
pub const kUSBDeviceIDShift: c_long = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbmaxdevices?language=objc)
pub const kUSBMaxDevices: c_long = 128;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbmaxdevice?language=objc)
pub const kUSBMaxDevice: c_long = kUSBMaxDevices - 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdeviceidmask?language=objc)
pub const kUSBDeviceIDMask: c_long = 0x7f;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbtoomanydevicesaddress?language=objc)
pub const kUSBTooManyDevicesAddress: c_long = 0xfffe;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbpipeidmask?language=objc)
pub const kUSBPipeIDMask: c_long = 0xf;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbmaxpipes?language=objc)
pub const kUSBMaxPipes: c_long = 32;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbinterfaceidshift?language=objc)
pub const kUSBInterfaceIDShift: c_long = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbmaxinterfaces?language=objc)
pub const kUSBMaxInterfaces: c_long = 1 << kUSBInterfaceIDShift;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbinterfaceidmask?language=objc)
pub const kUSBInterfaceIDMask: c_long = kUSBMaxInterfaces - 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbendptshift?language=objc)
pub const kUSBEndPtShift: c_long = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicemask?language=objc)
pub const kUSBDeviceMask: c_long = (1 << kUSBEndPtShift) - 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbnopipeidx?language=objc)
pub const kUSBNoPipeIdx: c_long = -1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbucrequestwithoutusbnotificationmask?language=objc)
pub const kUSBUCRequestWithoutUSBNotificationMask: c_long = 1 << 30;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbendpointtransfertypeucmask?language=objc)
pub const kUSBEndpointTransferTypeUCMask: c_long = 1 << 7;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbstream0?language=objc)
pub const kUSBStream0: c_long = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbmaxstream?language=objc)
pub const kUSBMaxStream: c_long = 65533;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbprimestream?language=objc)
pub const kUSBPRimeStream: c_long = 0xfffe;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbnostream?language=objc)
pub const kUSBNoStream: c_long = 0xffff;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbstreamidmask?language=objc)
pub const kUSBStreamIDMask: c_long = 0xffff;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbstreamidallstreamsmask?language=objc)
pub const kUSBStreamIDAllStreamsMask: c_long = 1 << 31;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbrqdirnshift?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub const kUSBRqDirnShift: c_uint = tIOUSBDeviceRequest::IOUSBDeviceRequestDirectionPhase.0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbrqdirnmask?language=objc)
pub const kUSBRqDirnMask: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbrqtypeshift?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub const kUSBRqTypeShift: c_uint = tIOUSBDeviceRequest::IOUSBDeviceRequestTypePhase.0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbrqtypemask?language=objc)
pub const kUSBRqTypeMask: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbrqrecipientmask?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub const kUSBRqRecipientMask: c_uint = tIOUSBDeviceRequest::IOUSBDeviceRequestRecipientMask.0;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbmaxfsisocendpointreqcount?language=objc)
pub const kUSBMaxFSIsocEndpointReqCount: c_uint = 1023;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbmaxhsisocendpointreqcount?language=objc)
pub const kUSBMaxHSIsocEndpointReqCount: c_uint = 3072;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbmaxhsisocframecount?language=objc)
pub const kUSBMaxHSIsocFrameCount: c_uint = 7168;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kcleardevicefeature?language=objc)
#[cfg(feature = "USBSpec")]
pub const kClearDeviceFeature: c_uint =
    EncodeRequest!(kUSBRqClearFeature, kUSBOut, kUSBStandard, kUSBDevice);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kclearinterfacefeature?language=objc)
#[cfg(feature = "USBSpec")]
pub const kClearInterfaceFeature: c_uint =
    EncodeRequest!(kUSBRqClearFeature, kUSBOut, kUSBStandard, kUSBInterface);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kclearendpointfeature?language=objc)
#[cfg(feature = "USBSpec")]
pub const kClearEndpointFeature: c_uint =
    EncodeRequest!(kUSBRqClearFeature, kUSBOut, kUSBStandard, kUSBEndpoint);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kgetconfiguration?language=objc)
#[cfg(feature = "USBSpec")]
pub const kGetConfiguration: c_uint =
    EncodeRequest!(kUSBRqGetConfig, kUSBIn, kUSBStandard, kUSBDevice);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kgetdescriptor?language=objc)
#[cfg(feature = "USBSpec")]
pub const kGetDescriptor: c_uint =
    EncodeRequest!(kUSBRqGetDescriptor, kUSBIn, kUSBStandard, kUSBDevice);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kgetinterface?language=objc)
#[cfg(feature = "USBSpec")]
pub const kGetInterface: c_uint =
    EncodeRequest!(kUSBRqGetInterface, kUSBIn, kUSBStandard, kUSBInterface);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kgetdevicestatus?language=objc)
#[cfg(feature = "USBSpec")]
pub const kGetDeviceStatus: c_uint =
    EncodeRequest!(kUSBRqGetStatus, kUSBIn, kUSBStandard, kUSBDevice);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kgetinterfacestatus?language=objc)
#[cfg(feature = "USBSpec")]
pub const kGetInterfaceStatus: c_uint =
    EncodeRequest!(kUSBRqGetStatus, kUSBIn, kUSBStandard, kUSBInterface);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kgetendpointstatus?language=objc)
#[cfg(feature = "USBSpec")]
pub const kGetEndpointStatus: c_uint =
    EncodeRequest!(kUSBRqGetStatus, kUSBIn, kUSBStandard, kUSBEndpoint);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ksetaddress?language=objc)
#[cfg(feature = "USBSpec")]
pub const kSetAddress: c_uint = EncodeRequest!(kUSBRqSetAddress, kUSBOut, kUSBStandard, kUSBDevice);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ksetconfiguration?language=objc)
#[cfg(feature = "USBSpec")]
pub const kSetConfiguration: c_uint =
    EncodeRequest!(kUSBRqSetConfig, kUSBOut, kUSBStandard, kUSBDevice);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ksetdescriptor?language=objc)
#[cfg(feature = "USBSpec")]
pub const kSetDescriptor: c_uint =
    EncodeRequest!(kUSBRqSetDescriptor, kUSBOut, kUSBStandard, kUSBDevice);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ksetdevicefeature?language=objc)
#[cfg(feature = "USBSpec")]
pub const kSetDeviceFeature: c_uint =
    EncodeRequest!(kUSBRqSetFeature, kUSBOut, kUSBStandard, kUSBDevice);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ksetinterfacefeature?language=objc)
#[cfg(feature = "USBSpec")]
pub const kSetInterfaceFeature: c_uint =
    EncodeRequest!(kUSBRqSetFeature, kUSBOut, kUSBStandard, kUSBInterface);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ksetendpointfeature?language=objc)
#[cfg(feature = "USBSpec")]
pub const kSetEndpointFeature: c_uint =
    EncodeRequest!(kUSBRqSetFeature, kUSBOut, kUSBStandard, kUSBEndpoint);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ksetinterface?language=objc)
#[cfg(feature = "USBSpec")]
pub const kSetInterface: c_uint =
    EncodeRequest!(kUSBRqSetInterface, kUSBOut, kUSBStandard, kUSBInterface);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ksyncframe?language=objc)
#[cfg(feature = "USBSpec")]
pub const kSyncFrame: c_uint = EncodeRequest!(kUSBRqSyncFrame, kUSBIn, kUSBStandard, kUSBEndpoint);

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/usbdeviceaddress?language=objc)
pub type USBDeviceAddress = u16;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/usbphysicaladdress32?language=objc)
pub type USBPhysicalAddress32 = u32;

/// Structure used to encode information about each isoc frame.
///
/// Parameter `frStatus`: Returns status associated with the frame.
///
/// Parameter `frReqCount`: Input specifiying how many bytes to read or write.
///
/// Parameter `frActCount`: Actual # of bytes transferred.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbisocframe?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBIsocFrame {
    pub frStatus: IOReturn,
    pub frReqCount: u16,
    pub frActCount: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBIsocFrame {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBIsocFrame",
        &[<IOReturn>::ENCODING, <u16>::ENCODING, <u16>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBIsocFrame {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Structure used to encode information about each isoc frame that is processed
/// at hardware interrupt time (low latency).
///
/// Parameter `frStatus`: Returns status associated with the frame.
///
/// Parameter `frReqCount`: Input specifiying how many bytes to read or write.
///
/// Parameter `frActCount`: Actual # of bytes transferred.
///
/// Parameter `frTimeStamp`: Time stamp that indicates time when frame was procesed.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousblowlatencyisocframe?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBLowLatencyIsocFrame {
    pub frStatus: IOReturn,
    pub frReqCount: u16,
    pub frActCount: u16,
    pub frTimeStamp: AbsoluteTime,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBLowLatencyIsocFrame {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBLowLatencyIsocFrame",
        &[
            <IOReturn>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <AbsoluteTime>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBLowLatencyIsocFrame {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Function called when USB I/O completes.
///
/// Parameter `target`: The target specified in the IOUSBCompletion struct.
///
/// Parameter `parameter`: The parameter specified in the IOUSBCompletion struct.
///
/// Parameter `status`: Completion status.
///
/// Parameter `bufferSizeRemaining`: Bytes left to be transferred.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbcompletionaction?language=objc)
pub type IOUSBCompletionAction =
    Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void, IOReturn, u32)>;

/// Function called when USB I/O completes.
///
/// Parameter `target`: The target specified in the IOUSBCompletion struct.
///
/// Parameter `parameter`: The parameter specified in the IOUSBCompletion struct.
///
/// Parameter `status`: Completion status.
///
/// Parameter `bufferSizeRemaining`: Bytes left to be transferred.
///
/// Parameter `timeStamp`: Time at which the transaction was processed.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbcompletionactionwithtimestamp?language=objc)
pub type IOUSBCompletionActionWithTimeStamp =
    Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void, IOReturn, u32, AbsoluteTime)>;

/// Function called when Isochronous USB I/O completes.
///
/// Parameter `target`: The target specified in the IOUSBIsocCompletionn struct.
///
/// Parameter `parameter`: The parameter specified in the IOUSBIsocCompletion struct.
///
/// Parameter `status`: Completion status.
///
/// Parameter `pFrames`: Pointer to the frame list containing the status for each frame transferred.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbisoccompletionaction?language=objc)
pub type IOUSBIsocCompletionAction =
    Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void, IOReturn, *mut IOUSBIsocFrame)>;

/// Function called when Low Latency Isochronous USB I/O completes.
///
/// Parameter `target`: The target specified in the IOUSBLowLatencyIsocCompletion struct.
///
/// Parameter `parameter`: The parameter specified in the IOUSBLowLatencyIsocCompletion struct.
///
/// Parameter `status`: Completion status.
///
/// Parameter `pFrames`: Pointer to the low latency frame list containing the status for each frame transferred.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousblowlatencyisoccompletionaction?language=objc)
pub type IOUSBLowLatencyIsocCompletionAction = Option<
    unsafe extern "C-unwind" fn(*mut c_void, *mut c_void, IOReturn, *mut IOUSBLowLatencyIsocFrame),
>;

/// Struct specifying action to perform when a USB I/O completes.
///
/// Parameter `target`: The target to pass to the action function.
///
/// Parameter `action`: The function to call.
///
/// Parameter `parameter`: The parameter to pass to the action function.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbcompletion?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBCompletion {
    pub target: *mut c_void,
    pub action: IOUSBCompletionAction,
    pub parameter: *mut c_void,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBCompletion {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBCompletion",
        &[
            <*mut c_void>::ENCODING,
            <IOUSBCompletionAction>::ENCODING,
            <*mut c_void>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBCompletion {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Struct specifying action to perform when a USB I/O completes.
///
/// Parameter `target`: The target to pass to the action function.
///
/// Parameter `action`: The function to call.
///
/// Parameter `parameter`: The parameter to pass to the action function.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbcompletionwithtimestamp?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBCompletionWithTimeStamp {
    pub target: *mut c_void,
    pub action: IOUSBCompletionActionWithTimeStamp,
    pub parameter: *mut c_void,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBCompletionWithTimeStamp {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBCompletionWithTimeStamp",
        &[
            <*mut c_void>::ENCODING,
            <IOUSBCompletionActionWithTimeStamp>::ENCODING,
            <*mut c_void>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBCompletionWithTimeStamp {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Struct specifying action to perform when an Isochronous USB I/O completes.
///
/// Parameter `target`: The target to pass to the action function.
///
/// Parameter `action`: The function to call.
///
/// Parameter `parameter`: The parameter to pass to the action function.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbisoccompletion?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBIsocCompletion {
    pub target: *mut c_void,
    pub action: IOUSBIsocCompletionAction,
    pub parameter: *mut c_void,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBIsocCompletion {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBIsocCompletion",
        &[
            <*mut c_void>::ENCODING,
            <IOUSBIsocCompletionAction>::ENCODING,
            <*mut c_void>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBIsocCompletion {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Struct specifying action to perform when an Low Latency Isochronous USB I/O completes.
///
/// Parameter `target`: The target to pass to the action function.
///
/// Parameter `action`: The function to call.
///
/// Parameter `parameter`: The parameter to pass to the action function.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousblowlatencyisoccompletion?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBLowLatencyIsocCompletion {
    pub target: *mut c_void,
    pub action: IOUSBLowLatencyIsocCompletionAction,
    pub parameter: *mut c_void,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBLowLatencyIsocCompletion {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBLowLatencyIsocCompletion",
        &[
            <*mut c_void>::ENCODING,
            <IOUSBLowLatencyIsocCompletionAction>::ENCODING,
            <*mut c_void>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBLowLatencyIsocCompletion {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbmousedata?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBMouseData {
    pub buttons: u16,
    pub XDelta: i16,
    pub YDelta: i16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBMouseData {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBMouseData",
        &[<u16>::ENCODING, <i16>::ENCODING, <i16>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBMouseData {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbmousedataptr?language=objc)
pub type IOUSBMouseDataPtr = *mut IOUSBMouseData;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbkeyboarddata?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBKeyboardData {
    pub keycount: u16,
    pub usbkeycode: [u16; 32],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBKeyboardData {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBKeyboardData",
        &[<u16>::ENCODING, <[u16; 32]>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBKeyboardData {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbkeyboarddataptr?language=objc)
pub type IOUSBKeyboardDataPtr = *mut IOUSBKeyboardData;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbhiddata?language=objc)
#[repr(C)]
#[derive(Clone, Copy)]
pub union IOUSBHIDData {
    pub kbd: IOUSBKeyboardData,
    pub mouse: IOUSBMouseData,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBHIDData {
    const ENCODING: Encoding = Encoding::Union(
        "IOUSBHIDData",
        &[<IOUSBKeyboardData>::ENCODING, <IOUSBMouseData>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBHIDData {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbhiddataptr?language=objc)
pub type IOUSBHIDDataPtr = *mut IOUSBHIDData;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicedescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceDescriptorPtr = *mut IOUSBDeviceDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdescriptorheaderptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDescriptorHeaderPtr = *mut IOUSBDescriptorHeader;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbbosdescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBBOSDescriptorPtr = *mut IOUSBBOSDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitydescriptorheaderptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceCapabilityDescriptorHeaderPtr = *mut IOUSBDeviceCapabilityDescriptorHeader;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilityusb2extensionptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceCapabilityUSB2ExtensionPtr = *mut IOUSBDeviceCapabilityUSB2Extension;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitysuperspeedusbptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceCapabilitySuperSpeedUSBPtr = *mut IOUSBDeviceCapabilitySuperSpeedUSB;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitysuperspeedplususbptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceCapabilitySuperSpeedPlusUSBPtr = *mut IOUSBDeviceCapabilitySuperSpeedPlusUSB;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitycontaineridptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceCapabilityContainerIDPtr = *mut IOUSBDeviceCapabilityContainerID;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbplatformcapabilitydescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBPlatformCapabilityDescriptorPtr = *mut IOUSBPlatformCapabilityDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitybillboardaltconfigptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceCapabilityBillboardAltConfigPtr = *mut IOUSBDeviceCapabilityBillboardAltConfig;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitybillboardptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceCapabilityBillboardPtr = *mut IOUSBDeviceCapabilityBillboard;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitybillboardaltmodeptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceCapabilityBillboardAltModePtr = *mut IOUSBDeviceCapabilityBillboardAltMode;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbconfigurationdescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBConfigurationDescriptorPtr = *mut IOUSBConfigurationDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbconfigurationdescheaderptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBConfigurationDescHeaderPtr = *mut IOUSBConfigurationDescHeader;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacedescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBInterfaceDescriptorPtr = *mut IOUSBInterfaceDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbendpointdescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBEndpointDescriptorPtr = *mut IOUSBEndpointDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbstringdescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBStringDescriptorPtr = *mut IOUSBStringDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbsuperspeedendpointcompaniondescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBSuperSpeedEndpointCompanionDescriptorPtr =
    *mut IOUSBSuperSpeedEndpointCompanionDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbsuperspeedplusisochronousendpointcompaniondescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBSuperSpeedPlusIsochronousEndpointCompanionDescriptorPtr =
    *mut IOUSBSuperSpeedPlusIsochronousEndpointCompanionDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/uaspipedescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type UASPipeDescriptorPtr = *mut UASPipeDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbhiddescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBHIDDescriptorPtr = *mut IOUSBHIDDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbhidreportdescptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBHIDReportDescPtr = *mut IOUSBHIDReportDesc;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicequalifierdescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDeviceQualifierDescriptorPtr = *mut IOUSBDeviceQualifierDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdfudescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBDFUDescriptorPtr = *mut IOUSBDFUDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceassociationdescriptorptr?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub type IOUSBInterfaceAssociationDescriptorPtr = *mut IOUSBInterfaceAssociationDescriptor;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicecapabilitydescriptortype?language=objc)
pub const kIOUSBDeviceCapabilityDescriptorType: c_uint = 16;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicecapabilitydescriptorlengthmin?language=objc)
pub const kIOUSBDeviceCapabilityDescriptorLengthMin: c_uint = 3;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_epdesc_bmattributes_trantype_mask?language=objc)
pub const kUSB_EPDesc_bmAttributes_TranType_Mask: c_uint = USBBitRange!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_epdesc_bmattributes_trantype_shift?language=objc)
pub const kUSB_EPDesc_bmAttributes_TranType_Shift: c_uint = USBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_epdesc_bmattributes_synctype_mask?language=objc)
pub const kUSB_EPDesc_bmAttributes_SyncType_Mask: c_uint = USBBitRange!(2, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_epdesc_bmattributes_synctype_shift?language=objc)
pub const kUSB_EPDesc_bmAttributes_SyncType_Shift: c_uint = USBBitRangePhase!(2, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_epdesc_bmattributes_usagetype_mask?language=objc)
pub const kUSB_EPDesc_bmAttributes_UsageType_Mask: c_uint = USBBitRange!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_epdesc_bmattributes_usagetype_shift?language=objc)
pub const kUSB_EPDesc_bmAttributes_UsageType_Shift: c_uint = USBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_epdesc_wmaxpacketsize_mps_mask?language=objc)
pub const kUSB_EPDesc_wMaxPacketSize_MPS_Mask: c_uint = USBBitRange!(0, 10);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_epdesc_wmaxpacketsize_mps_shift?language=objc)
pub const kUSB_EPDesc_wMaxPacketSize_MPS_Shift: c_uint = USBBitRangePhase!(0, 10);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_epdesc_maxmps?language=objc)
pub const kUSB_EPDesc_MaxMPS: c_uint = 1024;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_hsfsepdesc_wmaxpacketsize_mult_mask?language=objc)
pub const kUSB_HSFSEPDesc_wMaxPacketSize_Mult_Mask: c_uint = USBBitRange!(11, 12);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_hsfsepdesc_wmaxpacketsize_mult_shift?language=objc)
pub const kUSB_HSFSEPDesc_wMaxPacketSize_Mult_Shift: c_uint = USBBitRangePhase!(11, 12);

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_sscompdesc_bulk_maxstreams_mask?language=objc)
pub const kUSB_SSCompDesc_Bulk_MaxStreams_Mask: c_uint = USBBitRange!(0, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_sscompdesc_bulk_maxstreams_shift?language=objc)
pub const kUSB_SSCompDesc_Bulk_MaxStreams_Shift: c_uint = USBBitRangePhase!(0, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_sscompdesc_isoc_mult_mask?language=objc)
pub const kUSB_SSCompDesc_Isoc_Mult_Mask: c_uint = USBBitRange!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusb_sscompdesc_isoc_mult_shift?language=objc)
pub const kUSB_SSCompDesc_Isoc_Mult_Shift: c_uint = USBBitRangePhase!(0, 1);

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/addpacketshift?language=objc)
pub const addPacketShift: c_uint = 11;

/// Structure used with the IOUSBLib GetEndpointPropertiesV3 and GetPipePropertiesV3 API. Most of the fields are taken directly from corresponding Standard Endpoint Descriptor and SuperSpeed Endpoint Companion Descriptor. wBytesPerInterval will be synthesized for  High Speed High Bandwidth Isochronous endpoints.
/// Field: bVersion  Version of the structure.  Currently kUSBEndpointPropertiesVersion3.  Need to set this when using this structure
/// Field: bAlternateSetting Used as an input for GetEndpointPropertiesV3.  Used as an output for GetPipePropertiesV3
/// Field: bDirection Used as an input for GetEndpointPropertiesV3.  Used as an output for GetPipePropertiesV3. One of kUSBIn or kUSBOut.
/// Field: bEndpointNumber Used as an input for GetEndpointPropertiesV3.  Used as an output for GetPipePropertiesV3
/// Field: bTransferType  One of kUSBControl, kUSBBulk, kUSBIsoc, or kUSBInterrupt
/// Field: bUsageType  For interrupt and isoc endpoints, the usage type.  For Bulk endpoints of the UAS Mass Storage Protocol, the pipe ID.
/// Field: bSyncType    For isoc endpoints only
/// Field: bInterval    The bInterval field from the Standard Endpoint descriptor.
/// Field: wMaxPacketSize  The meaning of this value depends on whether this is called with GetPipePropertiesV3 or GetEndpointPropertiesV3. See the documentation of those calls for more info.
/// Field: bMaxBurst  For SuperSpeed endpoints, maximum number of packets the endpoint can send or receive as part of a burst
/// Field: bMaxStreams  For SuperSpeed bulk endpoints, maximum number of streams this endpoint supports.
/// Field: bMult  For SuperSpeed isoc endpoints, this is the mult value from the SuperSpeed Endpoint Companion Descriptor. For High Speed isoc and interrupt endpoints, this is bits 11 and 12 of the Standard Endpoint Descriptor, which represents a similar value.
/// Field: wBytesPerInterval  For SuperSpeed interrupt and isoc endpoints, this is the wBytesPerInterval from the SuperSpeed Endpoint Companion Descriptor. For High Speed High Bandwidth isoc endpoints, this will be equal to wMaxPacketSize * (bMult+1).
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbendpointproperties?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBEndpointProperties {
    pub bVersion: u8,
    pub bAlternateSetting: u8,
    pub bDirection: u8,
    pub bEndpointNumber: u8,
    pub bTransferType: u8,
    pub bUsageType: u8,
    pub bSyncType: u8,
    pub bInterval: u8,
    pub wMaxPacketSize: u16,
    pub bMaxBurst: u8,
    pub bMaxStreams: u8,
    pub bMult: u8,
    pub wBytesPerInterval: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBEndpointProperties {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBEndpointProperties",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBEndpointProperties {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbendpointpropertiesptr?language=objc)
pub type IOUSBEndpointPropertiesPtr = *mut IOUSBEndpointProperties;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbendpointpropertiesversion3?language=objc)
pub const kUSBEndpointPropertiesVersion3: c_uint = 0x03;

/// Type used to get a DeviceStatus as a single quantity.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/usbstatus?language=objc)
pub type USBStatus = u16;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/usbstatusptr?language=objc)
pub type USBStatusPtr = *mut USBStatus;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbanyclass?language=objc)
pub const kIOUSBAnyClass: c_uint = 0xFFFF;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbanysubclass?language=objc)
pub const kIOUSBAnySubClass: c_uint = 0xFFFF;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbanyprotocol?language=objc)
pub const kIOUSBAnyProtocol: c_uint = 0xFFFF;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbanyvendor?language=objc)
pub const kIOUSBAnyVendor: c_uint = 0xFFFF;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbanyproduct?language=objc)
pub const kIOUSBAnyProduct: c_uint = 0xFFFF;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbmatch?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBMatch {
    pub usbClass: u16,
    pub usbSubClass: u16,
    pub usbProtocol: u16,
    pub usbVendor: u16,
    pub usbProduct: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBMatch {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBMatch",
        &[
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBMatch {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Struct used to find endpoints of an interface
/// type and direction are used to match endpoints,
/// type, direction, maxPacketSize and interval are updated
/// with the properties of the found endpoint.
/// Field: type Type of endpoint: kUSBControl, kUSBIsoc, kUSBBulk, kUSBInterrupt, kUSBAnyType.  If kUSBAnyType is specified, this field is treated as a don't care.
/// Field: direction Direction of endpoint: kUSBOut, kUSBIn, kUSBAnyDirn.   If kUSBAnyDirn is specified, this field is treated as a don't care.
/// Field: maxPacketSize maximum packet size of endpoint.
/// Field: interval Polling interval in mSec for endpoint.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbfindendpointrequest?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBFindEndpointRequest {
    pub r#type: u8,
    pub direction: u8,
    pub maxPacketSize: u16,
    pub interval: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBFindEndpointRequest {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBFindEndpointRequest {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Parameter block for control requests, using a simple pointer
/// for the data to be transferred.
/// Field: bmRequestType Request type: kUSBStandard, kUSBClass or kUSBVendor
/// Field: bRequest Request code
/// Field: wValue 16 bit parameter for request, host endianess
/// Field: wIndex 16 bit parameter for request, host endianess
/// Field: wLength Length of data part of request, 16 bits, host endianess
/// Field: pData Pointer to data for request - data returned in bus endianess
/// Field: wLenDone Set by standard completion routine to number of data bytes
/// actually transferred
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevrequest?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDevRequest {
    pub bmRequestType: u8,
    pub bRequest: u8,
    pub wValue: u16,
    pub wIndex: u16,
    pub wLength: u16,
    pub pData: *mut c_void,
    pub wLenDone: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDevRequest {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <*mut c_void>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDevRequest {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicerequestptr?language=objc)
pub type IOUSBDeviceRequestPtr = *mut IOUSBDevRequest;

/// Parameter block for control requests with timeouts, using a simple pointer
/// for the data to be transferred.  Same as a IOUSBDevRequest except for the two extra timeout fields.
/// Field: bmRequestType Request type: kUSBStandard, kUSBClass or kUSBVendor
/// Field: bRequest Request code
/// Field: wValue 16 bit parameter for request, host endianess
/// Field: wIndex 16 bit parameter for request, host endianess
/// Field: wLength Length of data part of request, 16 bits, host endianess
/// Field: pData Pointer to data for request - data returned in bus endianess
/// Field: wLenDone Set by standard completion routine to number of data bytes
/// actually transferred
/// Field: noDataTimeout Specifies a time value in milliseconds. Once the request is queued on the bus, if no data is transferred in this amount of time, the request will be aborted and returned.
/// Field: completionTimeout Specifies a time value in milliseconds. Once the request is queued on the bus, if the entire request is not completed in this amount of time, the request will be aborted and returned
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevrequestto?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDevRequestTO {
    pub bmRequestType: u8,
    pub bRequest: u8,
    pub wValue: u16,
    pub wIndex: u16,
    pub wLength: u16,
    pub pData: *mut c_void,
    pub wLenDone: u32,
    pub noDataTimeout: u32,
    pub completionTimeout: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDevRequestTO {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <*mut c_void>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDevRequestTO {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdefaultcontrolnodatatimeoutms?language=objc)
pub const kUSBDefaultControlNoDataTimeoutMS: c_uint = 5000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdefaultcontrolcompletiontimeoutms?language=objc)
pub const kUSBDefaultControlCompletionTimeoutMS: c_uint = 0;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbbulkpipereq?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBBulkPipeReq {
    pub pipeRef: u32,
    pub buf: *mut c_void,
    pub size: u32,
    pub noDataTimeout: u32,
    pub completionTimeout: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBBulkPipeReq {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <*mut c_void>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBBulkPipeReq {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevreqool?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDevReqOOL {
    pub bmRequestType: u8,
    pub bRequest: u8,
    pub wValue: u16,
    pub wIndex: u16,
    pub wLength: u16,
    pub pData: *mut c_void,
    pub wLenDone: u32,
    pub pipeRef: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDevReqOOL {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <*mut c_void>::ENCODING,
            <u32>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDevReqOOL {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevreqoolto?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDevReqOOLTO {
    pub bmRequestType: u8,
    pub bRequest: u8,
    pub wValue: u16,
    pub wIndex: u16,
    pub wLength: u16,
    pub pData: *mut c_void,
    pub wLenDone: u32,
    pub pipeRef: u8,
    pub noDataTimeout: u32,
    pub completionTimeout: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDevReqOOLTO {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <*mut c_void>::ENCODING,
            <u32>::ENCODING,
            <u8>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDevReqOOLTO {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbisocstruct?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBIsocStruct {
    pub fPipe: u32,
    pub fBuffer: *mut c_void,
    pub fBufSize: u32,
    pub fStartFrame: u64,
    pub fNumFrames: u32,
    pub fFrameCounts: *mut IOUSBIsocFrame,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBIsocStruct {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <*mut c_void>::ENCODING,
            <u32>::ENCODING,
            <u64>::ENCODING,
            <u32>::ENCODING,
            <*mut IOUSBIsocFrame>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBIsocStruct {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousblowlatencyisocstruct?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBLowLatencyIsocStruct {
    pub fPipe: u32,
    pub fBufSize: u32,
    pub fStartFrame: u64,
    pub fNumFrames: u32,
    pub fUpdateFrequency: u32,
    pub fDataBufferCookie: u32,
    pub fDataBufferOffset: u32,
    pub fFrameListBufferCookie: u32,
    pub fFrameListBufferOffset: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBLowLatencyIsocStruct {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBLowLatencyIsocStruct",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u64>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBLowLatencyIsocStruct {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Structure used from user space to return the frame number and a timestamp on when the frame register was read.
/// Field: frame frame number
/// Field: timeStamp  AbsoluteTime when the frame was updated
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbgetframestruct?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBGetFrameStruct {
    pub frame: u64,
    pub timeStamp: AbsoluteTime,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBGetFrameStruct {
    const ENCODING: Encoding = Encoding::Struct("?", &[<u64>::ENCODING, <AbsoluteTime>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBGetFrameStruct {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Structure used with FindNextInterface.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbfindinterfacerequest?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBFindInterfaceRequest {
    pub bInterfaceClass: u16,
    pub bInterfaceSubClass: u16,
    pub bInterfaceProtocol: u16,
    pub bAlternateSetting: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBFindInterfaceRequest {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBFindInterfaceRequest {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbfindinterfacedontcare?language=objc)
pub const kIOUSBFindInterfaceDontCare: c_uint = 0xFFFF;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbvendoridapplecomputer?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub const kIOUSBVendorIDAppleComputer: c_uint = kIOUSBAppleVendorID;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbvendoridapple?language=objc)
#[cfg(feature = "AppleUSBDefinitions")]
pub const kIOUSBVendorIDApple: c_uint = kIOUSBAppleVendorID;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicespeedlow?language=objc)
pub const kUSBDeviceSpeedLow: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicespeedfull?language=objc)
pub const kUSBDeviceSpeedFull: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicespeedhigh?language=objc)
pub const kUSBDeviceSpeedHigh: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicespeedsuper?language=objc)
pub const kUSBDeviceSpeedSuper: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicespeedsuperplus?language=objc)
pub const kUSBDeviceSpeedSuperPlus: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicespeedsuperplusby2?language=objc)
pub const kUSBDeviceSpeedSuperPlusBy2: c_uint = 5;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbfullspeedmicrosecondsinframe?language=objc)
pub const kUSBFullSpeedMicrosecondsInFrame: c_uint = 1000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbhighspeedmicrosecondsinframe?language=objc)
pub const kUSBHighSpeedMicrosecondsInFrame: c_uint = 125;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusblowlatencyisochtransferkey?language=objc)
pub const kUSBLowLatencyIsochTransferKey: c_uint = 0x6c6c6974;

/// Used to specify what kind of buffer to create when calling LowLatencyCreateBuffer().
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/usblowlatencybuffertype?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct USBLowLatencyBufferType(pub c_uint);
impl USBLowLatencyBufferType {
    #[doc(alias = "kUSBLowLatencyWriteBuffer")]
    pub const WriteBuffer: Self = Self(0);
    #[doc(alias = "kUSBLowLatencyReadBuffer")]
    pub const ReadBuffer: Self = Self(1);
    #[doc(alias = "kUSBLowLatencyFrameListBuffer")]
    pub const FrameListBuffer: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for USBLowLatencyBufferType {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for USBLowLatencyBufferType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbnousernotificationtype?language=objc)
pub const kUSBNoUserNotificationType: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbnotenoughpowernotificationtype?language=objc)
pub const kUSBNotEnoughPowerNotificationType: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbindividualovercurrentnotificationtype?language=objc)
pub const kUSBIndividualOverCurrentNotificationType: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbgangovercurrentnotificationtype?language=objc)
pub const kUSBGangOverCurrentNotificationType: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbiosdevicenotenoughpowernotificationtype?language=objc)
pub const kUSBiOSDeviceNotEnoughPowerNotificationType: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbnotenoughpowernoacnotificationtype?language=objc)
pub const kUSBNotEnoughPowerNoACNotificationType: c_uint = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbdevicecountexceedednotificationtype?language=objc)
pub const kUSBDeviceCountExceededNotificationType: c_uint = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbendpointcountexceedednotificationtype?language=objc)
pub const kUSBEndpointCountExceededNotificationType: c_uint = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbunsupportednotificationtype?language=objc)
pub const kUSBUnsupportedNotificationType: c_uint = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbhubcountexceedednotificationtype?language=objc)
pub const kUSBHubCountExceededNotificationType: c_uint = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbtdmlowbatterytype?language=objc)
pub const kUSBTDMLowBatteryType: c_uint = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbctbnotenoughpowernotificationtype?language=objc)
pub const kUSBCTBNotEnoughPowerNotificationType: c_uint = 11;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbctbunsupportednotificationtype?language=objc)
pub const kUSBCTBUnsupportedNotificationType: c_uint = 12;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbcunsupportedtbportnotificationtype?language=objc)
pub const kUSBCUnsupportedTBPortNotificationType: c_uint = 13;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbcunsupportedtbcablenotificationtype?language=objc)
pub const kUSBCUnsupportedTBCableNotificationType: c_uint = 14;

/// Options used when calling ReEnumerateDevice.
///
///
/// any drivers attached to a Mass Storage Class IOUSBInterface.  A client needs to have the appropriate permissions in order to specify this bit.  See IOUSBLib.h
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/usbreenumerateoptions?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct USBReEnumerateOptions(pub c_int);
impl USBReEnumerateOptions {
    #[doc(alias = "kUSBAddExtraResetTimeBit")]
    pub const AddExtraResetTimeBit: Self = Self(31);
    #[doc(alias = "kUSBReEnumerateCaptureDeviceBit")]
    pub const ReEnumerateCaptureDeviceBit: Self = Self(30);
    #[doc(alias = "kUSBReEnumerateReleaseDeviceBit")]
    pub const ReEnumerateReleaseDeviceBit: Self = Self(29);
    #[doc(alias = "kUSBAddExtraResetTimeMask")]
    pub const AddExtraResetTimeMask: Self =
        Self(1 << USBReEnumerateOptions::AddExtraResetTimeBit.0);
    #[doc(alias = "kUSBReEnumerateCaptureDeviceMask")]
    pub const ReEnumerateCaptureDeviceMask: Self =
        Self(1 << USBReEnumerateOptions::ReEnumerateCaptureDeviceBit.0);
    #[doc(alias = "kUSBReEnumerateReleaseDeviceMask")]
    pub const ReEnumerateReleaseDeviceMask: Self =
        Self(1 << USBReEnumerateOptions::ReEnumerateReleaseDeviceBit.0);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for USBReEnumerateOptions {
    const ENCODING: Encoding = c_int::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for USBReEnumerateOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// GetUSBDeviceInformation will return a unit32_t value with bits set indicating that a particular state is present in the USB device.  These bits are described here
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/usbdeviceinformationbits?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct USBDeviceInformationBits(pub c_uint);
impl USBDeviceInformationBits {
    #[doc(alias = "kUSBInformationDeviceIsCaptiveBit")]
    pub const InformationDeviceIsCaptiveBit: Self = Self(0);
    #[doc(alias = "kUSBInformationDeviceIsAttachedToRootHubBit")]
    pub const InformationDeviceIsAttachedToRootHubBit: Self = Self(1);
    #[doc(alias = "kUSBInformationDeviceIsInternalBit")]
    pub const InformationDeviceIsInternalBit: Self = Self(2);
    #[doc(alias = "kUSBInformationDeviceIsConnectedBit")]
    pub const InformationDeviceIsConnectedBit: Self = Self(3);
    #[doc(alias = "kUSBInformationDeviceIsEnabledBit")]
    pub const InformationDeviceIsEnabledBit: Self = Self(4);
    #[doc(alias = "kUSBInformationDeviceIsSuspendedBit")]
    pub const InformationDeviceIsSuspendedBit: Self = Self(5);
    #[doc(alias = "kUSBInformationDeviceIsInResetBit")]
    pub const InformationDeviceIsInResetBit: Self = Self(6);
    #[doc(alias = "kUSBInformationDeviceOvercurrentBit")]
    pub const InformationDeviceOvercurrentBit: Self = Self(7);
    #[doc(alias = "kUSBInformationDevicePortIsInTestModeBit")]
    pub const InformationDevicePortIsInTestModeBit: Self = Self(8);
    #[doc(alias = "kUSBInformationDeviceIsRootHub")]
    pub const InformationDeviceIsRootHub: Self = Self(9);
    #[doc(alias = "kUSBInformationRootHubisBuiltIn")]
    pub const InformationRootHubisBuiltIn: Self = Self(10);
    #[doc(alias = "kUSBInformationRootHubIsBuiltInBit")]
    pub const InformationRootHubIsBuiltInBit: Self = Self(10);
    #[doc(alias = "kUSBInformationDeviceIsRemote")]
    pub const InformationDeviceIsRemote: Self = Self(11);
    #[doc(alias = "kUSBInformationDeviceIsAttachedToEnclosure")]
    pub const InformationDeviceIsAttachedToEnclosure: Self = Self(12);
    #[doc(alias = "kUSBInformationDeviceIsOnThunderboltBit")]
    pub const InformationDeviceIsOnThunderboltBit: Self = Self(13);
    #[doc(alias = "kUSBInformationDeviceIsCaptiveMask")]
    pub const InformationDeviceIsCaptiveMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsCaptiveBit.0);
    #[doc(alias = "kUSBInformationDeviceIsAttachedToRootHubMask")]
    pub const InformationDeviceIsAttachedToRootHubMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsAttachedToRootHubBit.0);
    #[doc(alias = "kUSBInformationDeviceIsInternalMask")]
    pub const InformationDeviceIsInternalMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsInternalBit.0);
    #[doc(alias = "kUSBInformationDeviceIsConnectedMask")]
    pub const InformationDeviceIsConnectedMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsConnectedBit.0);
    #[doc(alias = "kUSBInformationDeviceIsEnabledMask")]
    pub const InformationDeviceIsEnabledMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsEnabledBit.0);
    #[doc(alias = "kUSBInformationDeviceIsSuspendedMask")]
    pub const InformationDeviceIsSuspendedMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsSuspendedBit.0);
    #[doc(alias = "kUSBInformationDeviceIsInResetMask")]
    pub const InformationDeviceIsInResetMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsInResetBit.0);
    #[doc(alias = "kUSBInformationDeviceOvercurrentMask")]
    pub const InformationDeviceOvercurrentMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceOvercurrentBit.0);
    #[doc(alias = "kUSBInformationDevicePortIsInTestModeMask")]
    pub const InformationDevicePortIsInTestModeMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDevicePortIsInTestModeBit.0);
    #[doc(alias = "kUSBInformationDeviceIsRootHubMask")]
    pub const InformationDeviceIsRootHubMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsRootHub.0);
    #[doc(alias = "kUSBInformationRootHubisBuiltInMask")]
    pub const InformationRootHubisBuiltInMask: Self =
        Self(1 << USBDeviceInformationBits::InformationRootHubisBuiltIn.0);
    #[doc(alias = "kUSBInformationRootHubIsBuiltInMask")]
    pub const InformationRootHubIsBuiltInMask: Self =
        Self(1 << USBDeviceInformationBits::InformationRootHubIsBuiltInBit.0);
    #[doc(alias = "kUSBInformationDeviceIsRemoteMask")]
    pub const InformationDeviceIsRemoteMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsRemote.0);
    #[doc(alias = "kUSBInformationDeviceIsAttachedToEnclosureMask")]
    pub const InformationDeviceIsAttachedToEnclosureMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsAttachedToEnclosure.0);
    #[doc(alias = "kUSBInformationDeviceIsOnThunderboltMask")]
    pub const InformationDeviceIsOnThunderboltMask: Self =
        Self(1 << USBDeviceInformationBits::InformationDeviceIsOnThunderboltBit.0);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for USBDeviceInformationBits {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for USBDeviceInformationBits {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Used to specify what kind of power will be reserved using the IOUSBDevice RequestExtraPower and ReturnExtraPower APIs.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/usbpowerrequesttypes?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct USBPowerRequestTypes(pub c_uint);
impl USBPowerRequestTypes {
    #[doc(alias = "kUSBPowerDuringSleep")]
    pub const DuringSleep: Self = Self(0);
    #[doc(alias = "kUSBPowerDuringWake")]
    pub const DuringWake: Self = Self(1);
    #[doc(alias = "kUSBPowerRequestWakeRelease")]
    pub const RequestWakeRelease: Self = Self(2);
    #[doc(alias = "kUSBPowerRequestSleepRelease")]
    pub const RequestSleepRelease: Self = Self(3);
    #[doc(alias = "kUSBPowerRequestWakeReallocate")]
    pub const RequestWakeReallocate: Self = Self(4);
    #[doc(alias = "kUSBPowerRequestSleepReallocate")]
    pub const RequestSleepReallocate: Self = Self(5);
    #[doc(alias = "kUSBPowerDuringWakeRevocable")]
    pub const DuringWakeRevocable: Self = Self(6);
    #[doc(alias = "kUSBPowerDuringWakeUSB3")]
    pub const DuringWakeUSB3: Self = Self(7);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for USBPowerRequestTypes {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for USBPowerRequestTypes {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbnotificationpreforcedsuspendbit?language=objc)
pub const kUSBNotificationPreForcedSuspendBit: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbnotificationpostforcedsuspendbit?language=objc)
pub const kUSBNotificationPostForcedSuspendBit: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbnotificationpreforcedresumebit?language=objc)
pub const kUSBNotificationPreForcedResumeBit: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbnotificationpostforcedresumebit?language=objc)
pub const kUSBNotificationPostForcedResumeBit: c_uint = 3;

/// Used to register for USB notifications. These types may be OR'd together if more than one notification is desired. These notification are expected to be acknowledged before the process (e.g. system sleep or system wake) can be continued. See RegisterForNotification and AcknowledgeNotification in IOUSBDeviceInterface and IOUSBInterfaceInterface.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/usbnotificationtypes?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct USBNotificationTypes(pub c_uint);
impl USBNotificationTypes {
    #[doc(alias = "kUSBNotificationPreForcedSuspend")]
    pub const PreForcedSuspend: Self = Self(1 << kUSBNotificationPreForcedSuspendBit);
    #[doc(alias = "kUSBNotificationPostForcedSuspend")]
    pub const PostForcedSuspend: Self = Self(1 << kUSBNotificationPostForcedSuspendBit);
    #[doc(alias = "kUSBNotificationPreForcedResume")]
    pub const PreForcedResume: Self = Self(1 << kUSBNotificationPreForcedResumeBit);
    #[doc(alias = "kUSBNotificationPostForcedResume")]
    pub const PostForcedResume: Self = Self(1 << kUSBNotificationPostForcedResumeBit);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for USBNotificationTypes {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for USBNotificationTypes {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbconnectable?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct kUSBConnectable(pub c_uint);
impl kUSBConnectable {
    #[doc(alias = "kUSBPortNotConnectable")]
    pub const USBPortNotConnectable: Self = Self(0);
    #[doc(alias = "kUSBPortConnectable")]
    pub const USBPortConnectable: Self = Self(1);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for kUSBConnectable {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for kUSBConnectable {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbhostconnectortype?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct kUSBHostConnectorType(pub c_uint);
impl kUSBHostConnectorType {
    #[doc(alias = "kUSBTypeAConnector")]
    pub const USBTypeAConnector: Self = Self(0x00);
    #[doc(alias = "kUSBTypeMiniABConnector")]
    pub const USBTypeMiniABConnector: Self = Self(0x01);
    #[doc(alias = "kUSBTypeExpressCard")]
    pub const USBTypeExpressCard: Self = Self(0x02);
    #[doc(alias = "kUSB3TypeStdAConnector")]
    pub const USB3TypeStdAConnector: Self = Self(0x03);
    #[doc(alias = "kUSB3TypeStdBConnector")]
    pub const USB3TypeStdBConnector: Self = Self(0x04);
    #[doc(alias = "kUSB3TypeMicroBConnector")]
    pub const USB3TypeMicroBConnector: Self = Self(0x05);
    #[doc(alias = "kUSB3TypeMicroABConnector")]
    pub const USB3TypeMicroABConnector: Self = Self(0x06);
    #[doc(alias = "kUSB3TypePowerBConnector")]
    pub const USB3TypePowerBConnector: Self = Self(0x07);
    #[doc(alias = "kUSBProprietaryConnector")]
    pub const USBProprietaryConnector: Self = Self(0xFF);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for kUSBHostConnectorType {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for kUSBHostConnectorType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbspeed_mask?language=objc)
pub const kUSBSpeed_Mask: c_uint = USBBitRange!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbspeed_shift?language=objc)
pub const kUSBSpeed_Shift: c_uint = USBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbaddress_mask?language=objc)
pub const kUSBAddress_Mask: c_uint = USBBitRange!(8, 15);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kusbaddress_shift?language=objc)
pub const kUSBAddress_Shift: c_uint = USBBitRangePhase!(8, 15);

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kxhcissroothubaddress?language=objc)
pub const kXHCISSRootHubAddress: c_long = kUSBMaxDevices;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kxhciusb2roothubaddress?language=objc)
pub const kXHCIUSB2RootHubAddress: c_long = kUSBMaxDevices + 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ksuperspeedbusbitmask?language=objc)
pub const kSuperSpeedBusBitMask: c_long = 0x01000000;
