# PySNMP SMI module. Autogenerated from smidump -f python SMON-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:38 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( OwnerString, rmon, ) = mibBuilder.importSymbols("RMON-MIB", "OwnerString", "rmon")
( DataSource, LastCreateTime, probeConfig, rmonConformance, ) = mibBuilder.importSymbols("RMON2-MIB", "DataSource", "LastCreateTime", "probeConfig", "rmonConformance")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks")
( RowStatus, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention")

# Types

class SmonDataSource(ObjectIdentifier):
    pass


# Objects

smonCapabilities = MibScalar((1, 3, 6, 1, 2, 1, 16, 19, 15), Bits().subtype(namedValues=NamedValues(("smonVlanStats", 0), ("smonPrioStats", 1), ("dataSource", 2), ("smonUnusedBit", 3), ("portCopy", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonCapabilities.setDescription("An indication of the SMON MIB groups supported\nby this agent.")
smonMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20, 3))
smonMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20, 4))
switchRMON = ModuleIdentity((1, 3, 6, 1, 2, 1, 16, 22)).setRevisions(("1998-12-16 00:00",))
if mibBuilder.loadTexts: switchRMON.setOrganization("IETF RMON MIB Working Group")
if mibBuilder.loadTexts: switchRMON.setContactInfo("IETF RMONMIB WG Mailing list: rmonmib@cisco.com\n\nRich Waterman\nAllot Networks Inc.\nTel:  +1-408-559-0253\nEmail: rich@allot.com\n\nBill Lahaye\nXylan Corp.\nTel: +1-800-995-2612\nEmail:  lahaye@ctron.com\n\nDan Romascanu\nLucent Technologies\nTel:  +972-3-645-8414\nEmail: dromasca@lucent.com\n\nSteven Waldbusser\nInternational Network Services (INS)\nTel: +1-650-318-1251\nEmail: waldbusser@ins.com")
if mibBuilder.loadTexts: switchRMON.setDescription("The MIB module for managing remote monitoring device\nimplementations for Switched Networks")
smonMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1))
dataSourceCaps = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 1))
dataSourceCapsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1))
if mibBuilder.loadTexts: dataSourceCapsTable.setDescription("This table describes RMON data sources and port copy\ncapabilities. An NMS MAY use this table to discover the\nidentity and attributes of the data sources on a given agent\nimplementation. Similar to the probeCapabilities object,\nactual row-creation operations will succeed or fail based on\nthe resources available and parameter values used in each\nrow-creation operation.\n\nUpon restart of the RMON agent, the dataSourceTable, ifTable,\nand perhaps entPhysicalTable are initialized for the available\ndataSources.\n\nFor each dataSourceCapsEntry representing a VLAN or\nentPhysicalEntry the agent MUST create an associated ifEntry\nwith a ifType value of 'propVirtual(53)'. This ifEntry will be\nused as the actual value in RMON control table dataSource\nobjects. The assigned ifIndex value is copied into the\nassociated dataSourceCapsIfIndex object.\n\nIt is understood that dataSources representing VLANs may not\nalways be instantiated immediately upon restart, but rather as\nVLAN usage is detected by the agent. The agent SHOULD attempt\nto create dataSource and interface entries for all dataSources\nas soon as possible.")
dataSourceCapsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1)).setIndexNames((1, "SMON-MIB", "dataSourceCapsObject"))
if mibBuilder.loadTexts: dataSourceCapsEntry.setDescription("Entries per data source containing descriptions of data\nsource and port copy capabilities. This table is populated by\nthe SMON agent with one entry for each supported data\nsource.")
dataSourceCapsObject = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1, 1), SmonDataSource()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dataSourceCapsObject.setDescription("Defines an object that can be a SMON data source or a\nsource or a destination for a port copy operation.")
dataSourceRmonCaps = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1, 2), Bits().subtype(namedValues=NamedValues(("countErrFrames", 0), ("countAllGoodFrames", 1), ("countAnyRmonTables", 2), ("babyGiantsCountAsGood", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dataSourceRmonCaps.setDescription(" General attributes of the specified dataSource. Note that\nthese are static attributes, which SHOULD NOT be adjusted\nbecause of current resources or configuration.\n\n- countErrFrames(0)\n  The agent sets this bit for the dataSource if errored frames\n  received on this dataSource can actually be monitored by the\n  agent The agent clears this bit if any errored frames are\n  not visible to the RMON data collector.\n\n- countAllGoodFrames(1)\n  The agent sets this bit for the dataSource if all good\n  frames received on this dataSource can actually be monitored\n  by the agent. The agent clears this bit if any good frames\n  are not visible for RMON collection, e.g., the dataSource is\n  a non-promiscuous interface or an internal switch interface\n  which may not receive frames which were switched in hardware\n  or dropped by the bridge forwarding function.\n\n- countAnyRmonTables(2)\n  The agent sets this bit if this dataSource can actually be\n  used in any of the implemented RMON tables, resources\n  notwithstanding. The agent clears this bit if this\n  dataSourceCapsEntry is present simply to identify a\n  dataSource that may only be used as portCopySource and/or a\n  portCopyDest, but not the source of an actual RMON data\n  collection.\n\n- babyGiantsCountAsGood(3)\n  The agent sets this bit if it can distinguish, for counting\n  purposes, between true giant frames and frames that exceed\n  Ethernet maximum frame size 1518 due to VLAN tagging ('baby\n  giants'). Specifically, this BIT means that frames up to\n  1522 octets are counted as good.\n\n  Agents not capable of detecting 'baby giants' will clear\n  this bit and will view all frames less than or equal to 1518\n  octets as 'good frames' and all frames larger than 1518\n  octets as 'bad frames' for the purpose of counting in the\n  smonVlanIdStats and smonPrioStats tables.\n\n  Agents capable of detecting 'baby giants' SHALL consider\n  them as 'good frames' for the purpose of counting in the\n  smonVlanIdStats and smonPrioStats tables.")
dataSourceCopyCaps = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1, 3), Bits().subtype(namedValues=NamedValues(("copySourcePort", 0), ("copyDestPort", 1), ("copySrcTxTraffic", 2), ("copySrcRxTraffic", 3), ("countDestDropEvents", 4), ("copyErrFrames", 5), ("copyUnalteredFrames", 6), ("copyAllGoodFrames", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dataSourceCopyCaps.setDescription("PortCopy function capabilities of the specified dataSource.\nNote that these are static capabilities, which SHOULD NOT be\nadjusted because of current resources or configuration.\n\n  - copySourcePort(0)\n      The agent sets this bit if this dataSource is capable of\n      acting as a source of a portCopy operation. The agent clears\n      this bit otherwise.\n\n  - copyDestPort(1)\n      The agent sets this bit if this dataSource is capable of\n      acting as a destination of a portCopy operation. The agent\n      clears this bit otherwise.\n\n - copySrcTxTraffic(2)\n      If the copySourcePort bit is set:\n            The agent sets this bit if this dataSource is capable of\n          copying frames transmitted out this portCopy source. The\n          agent clears this bit otherwise. This function is needed\n          to support full-duplex ports.\n       Else:\n           this bit SHOULD be cleared.\n\n  - copySrcRxTraffic(3)\n      If the copySourcePort bit is set:\n        The agent sets this bit if this dataSource is capable of\n        copying frames received on this portCopy source. The agent\n        clears this bit otherwise. This function is needed to\n        support full-duplex ports.\n      Else:\n        this bit SHOULD be cleared.\n\n  - countDestDropEvents(4)\n      If the copyDestPort bit is set:\n          The agent sets this bit if it is capable of incrementing\n          portCopyDestDropEvents, when this dataSource is the\n          target of a portCopy operation and a frame destined to\n          this dataSource is dropped (for RMON counting purposes).\n      Else:\n          this BIT SHOULD be cleared.\n\n  - copyErrFrames(5)\n      If the copySourcePort bit is set:\n          The agent sets this bit if it is capable of copying all\n          errored frames from this portCopy source-port, for\n          errored frames received on this dataSource.\n      Else:\n          this BIT SHOULD be cleared.\n\n  - copyUnalteredFrames(6)\n      If the copySourcePort bit is set:\n          The agent sets the copyUnalteredFrames bit If it is\n          capable of copying all frames from this portCopy\n          source-port without alteration in any way;\n      Else:\n          this bit SHOULD be cleared.\n\n  - copyAllGoodFrames(7)\n      If the copySourcePort bit is set:\n          The agent sets this bit for the dataSource if all good\n          frames received on this dataSource are normally capable\n          of being copied by the agent. The agent clears this bit\n          if any good frames are not visible for the RMON portCopy\n          operation, e.g., the dataSource is a non-promiscuous\n          interface or an internal switch interface which may not\n          receive frames which were switched in hardware or\n          dropped by the bridge forwarding function.\n       Else:\n          this bit SHOULD be cleared.")
dataSourceCapsIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 1, 1, 1, 4), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dataSourceCapsIfIndex.setDescription("This object contains the ifIndex value of the ifEntry\nassociated with this smonDataSource. The agent MUST create\n'propVirtual' ifEntries for each dataSourceCapsEntry of type\nVLAN or entPhysicalEntry.")
smonStats = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 2))
smonVlanStatsControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1))
if mibBuilder.loadTexts: smonVlanStatsControlTable.setDescription("Controls the setup of VLAN statistics tables.\n\nThe statistics collected represent a distribution based on\nthe IEEE 802.1Q VLAN-ID (VID), for each good frame attributed\nto the data source for the collection.")
smonVlanStatsControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1)).setIndexNames((0, "SMON-MIB", "smonVlanStatsControlIndex"))
if mibBuilder.loadTexts: smonVlanStatsControlEntry.setDescription("A conceptual row in the smonVlanStatsControlTable.")
smonVlanStatsControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smonVlanStatsControlIndex.setDescription("A unique arbitrary index for this smonVlanStatsControlEntry.")
smonVlanStatsControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 2), DataSource()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonVlanStatsControlDataSource.setDescription("The source of data for this set of VLAN statistics.\n\nThis object MAY NOT be modified if the associated\nsmonVlanStatsControlStatus object is equal to active(1).")
smonVlanStatsControlCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 3), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanStatsControlCreateTime.setDescription("The value of sysUpTime when this control entry was last\nactivated. This object allows to a management station to\ndetect deletion and recreation cycles between polls.")
smonVlanStatsControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 4), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonVlanStatsControlOwner.setDescription("Administratively assigned named of the owner of this entry.\nIt usually defines the entity that created this entry and is\ntherefore using the resources assigned to it, though there is\nno enforcement mechanism, nor assurance that rows created are\never used.")
smonVlanStatsControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 1, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonVlanStatsControlStatus.setDescription("The status of this row.\nAn entry MAY NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nIf this object is not equal to active(1), all associated\nentries in the smonVlanIdStatsTable SHALL be deleted.")
smonVlanIdStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2))
if mibBuilder.loadTexts: smonVlanIdStatsTable.setDescription("Contains the VLAN statistics data.\nThe statistics collected represent a distribution based\non the IEEE 802.1Q VLAN-ID (VID), for each good frame\nattributed to the data source for the collection.\n\nThis function applies the same rules for attributing frames\nto VLAN-based collections. RMON VLAN statistics are collected\nafter the Ingress Rules defined in section 3.13 of the VLAN\nSpecification [20] are applied.\n\nIt is possible that entries in this table will be\ngarbage-collected, based on agent resources, and VLAN\nconfiguration. Agents are encouraged to support all 4094\nindex values and not garbage collect this table.")
smonVlanIdStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1)).setIndexNames((0, "SMON-MIB", "smonVlanStatsControlIndex"), (0, "SMON-MIB", "smonVlanIdStatsId"))
if mibBuilder.loadTexts: smonVlanIdStatsEntry.setDescription("A conceptual row in smonVlanIdStatsTable.")
smonVlanIdStatsId = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 4094))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smonVlanIdStatsId.setDescription("The unique identifier of the VLAN monitored for\nthis specific statistics collection.\n\nTagged packets match the VID for the range between 1 and 4094.\nAn external RMON probe MAY detect VID=0 on an Inter Switch\nLink, in which case the packet belongs to a VLAN determined by\nthe PVID of the ingress port. The VLAN to which such a packet\nbelongs can be determined only by a RMON probe internal to the\nswitch.")
smonVlanIdStatsTotalPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalPkts.setDescription("The total number of packets counted on this VLAN.")
smonVlanIdStatsTotalOverflowPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalOverflowPkts.setDescription("The number of times the associated smonVlanIdStatsTotalPkts\ncounter has overflowed.")
smonVlanIdStatsTotalHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalHCPkts.setDescription("The total number of packets counted on this VLAN.")
smonVlanIdStatsTotalOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalOctets.setDescription("The total number of octets counted on this VLAN.")
smonVlanIdStatsTotalOverflowOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalOverflowOctets.setDescription("The number of times the associated smonVlanIdStatsTotalOctets\ncounter has overflowed.")
smonVlanIdStatsTotalHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsTotalHCOctets.setDescription("The total number of octets counted on this VLAN.")
smonVlanIdStatsNUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastPkts.setDescription("The total number of non-unicast packets counted on this\nVLAN.")
smonVlanIdStatsNUcastOverflowPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastOverflowPkts.setDescription("The number of times the associated smonVlanIdStatsNUcastPkts\ncounter has overflowed.")
smonVlanIdStatsNUcastHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 10), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastHCPkts.setDescription("The total number of non-unicast packets counted on\nthis VLAN.")
smonVlanIdStatsNUcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastOctets.setDescription("The total number of non-unicast octets counted on\nthis VLAN.")
smonVlanIdStatsNUcastOverflowOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastOverflowOctets.setDescription("The number of times the associated\nsmonVlanIdStatsNUcastOctets counter has overflowed.")
smonVlanIdStatsNUcastHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsNUcastHCOctets.setDescription("The total number of Non-unicast octets counted on\nthis VLAN.")
smonVlanIdStatsCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 2, 1, 14), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonVlanIdStatsCreateTime.setDescription("The value of sysUpTime when this entry was last\nactivated. This object allows to a management station to\ndetect deletion and recreation cycles between polls.")
smonPrioStatsControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3))
if mibBuilder.loadTexts: smonPrioStatsControlTable.setDescription("Controls the setup of priority statistics tables.\n\nThe smonPrioStatsControlTable allows configuration of\ncollections based on the value of the 3-bit user priority\nfield encoded in the Tag Control Information (TCI) field\naccording to [19],[20].\n\nNote that this table merely reports priority as encoded in\nthe VLAN headers, not the priority (if any) given to the\nframe for the actual switching purposes.")
smonPrioStatsControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1)).setIndexNames((0, "SMON-MIB", "smonPrioStatsControlIndex"))
if mibBuilder.loadTexts: smonPrioStatsControlEntry.setDescription("A conceptual row in the smonPrioStatsControlTable.")
smonPrioStatsControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smonPrioStatsControlIndex.setDescription("A unique arbitrary index for this smonPrioStatsControlEntry.")
smonPrioStatsControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 2), DataSource()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonPrioStatsControlDataSource.setDescription("The source of data for this set of VLAN statistics.\n\nThis object MAY NOT be modified if the associated\nsmonPrioStatsControlStatus object is equal to active(1).")
smonPrioStatsControlCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 3), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsControlCreateTime.setDescription("The value of sysUpTime when this entry was created.\nThis object allows to a management station to\ndetect deletion and recreation cycles between polls.")
smonPrioStatsControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 4), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonPrioStatsControlOwner.setDescription("Administratively assigned named of the owner of this entry.\nIt usually defines the entity that created this entry and is\ntherefore using the resources assigned to it, though there is\nno enforcement mechanism, nor assurance that rows created are\never used.")
smonPrioStatsControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 3, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: smonPrioStatsControlStatus.setDescription("The status of this row.\nAn entry MAY NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nIf this object is not equal to active(1), all associated\nentries in the smonPrioStatsTable SHALL be deleted.")
smonPrioStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4))
if mibBuilder.loadTexts: smonPrioStatsTable.setDescription("Contains the priority statistics. The collections are based\non the value of the 3-bit user priority field encoded in the\nTag Control Information (TCI) field according to [19], [20].\nNote that this table merely reports priority as encoded in\nthe VLAN headers, not the priority (if any) given to the\nframe for the actual switching purposes.\n\nNo garbage collection is designed for this table, as there\nalways are at most eight rows per statistical set, and the\nlow memory requirements do not justify the implementation of\nsuch a mechanism.")
smonPrioStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1)).setIndexNames((0, "SMON-MIB", "smonPrioStatsControlIndex"), (0, "SMON-MIB", "smonPrioStatsId"))
if mibBuilder.loadTexts: smonPrioStatsEntry.setDescription("A conceptual row in smonPrioStatsTable.")
smonPrioStatsId = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 7))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: smonPrioStatsId.setDescription("The unique identifier of the priority level monitored for\nthis specific statistics collection.")
smonPrioStatsPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsPkts.setDescription("The total number of packets counted on\nthis priority level.")
smonPrioStatsOverflowPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsOverflowPkts.setDescription("The number of times the associated smonPrioStatsPkts\ncounter has overflowed.")
smonPrioStatsHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsHCPkts.setDescription("The total number of packets counted on\nthis priority level.")
smonPrioStatsOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsOctets.setDescription("The total number of octets counted on\nthis priority level.")
smonPrioStatsOverflowOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsOverflowOctets.setDescription("The number of times the associated smonPrioStatsOctets\ncounter has overflowed.")
smonPrioStatsHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 2, 4, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: smonPrioStatsHCOctets.setDescription("The total number of octets counted on\nthis priority level.")
portCopyConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 3))
portCopyTable = MibTable((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1))
if mibBuilder.loadTexts: portCopyTable.setDescription(" Port Copy provides the ability to copy all frames from a\nspecified source to specified destination within a switch.\nSource and destinations MUST be ifEntries, as defined by [22].\nOne to one, one to many, many to one and many to many source to\ndestination relationships may be configured.\n\nApplicable counters on the destination will increment for all\npackets transiting the port, be it by normal bridging/switching\nor due to packet copy.\nNote that this table manages no RMON data collection by itself,\nand an agent may possibly implement no RMON objects except\nobjects related to the port copy operation defined by the\nportCopyCompliance conformance macro. That allows for a switch\nwith no other embedded RMON capability to perform port copy\noperations to a destination port at which a different external\nRMON probe is connected.\n\nOne to one, many to one and one to many source to destination\nrelationships may be configured.\nEach row that exists in this table defines such a\nrelationship. By disabling a row in this table the port copy\nrelationship no longer exists.\n\nThe number of entries and the types of port copies (1-1,\nmany-1, 1-many) are implementation specific and could\npossibly be dynamic due to changing resource availability.\n\nIn order to configure a source to destination portCopy\nrelationship, both source and destination interfaces MUST be\npresent as an ifEntry in the ifTable and their respective\nifAdminStatus and ifOperStatus values MUST be equal to\n'up(1)'. If the value of any of those two objects changes\nafter the portCopyEntry is activated, portCopyStatus will\ntransition to 'notReady(3)'.\n\nThe capability of an interface to be source or destination of\na port copy operation is described by the 'copySourcePort(0)'\nand 'copyDestPort(1)' bits in dataSourceCopyCaps. Those bits\nSHOULD be appropriately set by the agent, in order to allow\nfor a portCopyEntry to be created.\n\nApplicable counters on the destination will increment for all\npackets transmitted, be it by normal bridging/switching or\ndue to packet copy.")
portCopyEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1)).setIndexNames((0, "SMON-MIB", "portCopySource"), (0, "SMON-MIB", "portCopyDest"))
if mibBuilder.loadTexts: portCopyEntry.setDescription("Describes a particular port copy entry.")
portCopySource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: portCopySource.setDescription("The ifIndex of the source which will have all packets\nredirected to the destination as defined by portCopyDest.")
portCopyDest = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 2), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: portCopyDest.setDescription("Defines the ifIndex destination for the copy operation.")
portCopyDestDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: portCopyDestDropEvents.setDescription("The total number of events in which port copy packets were\ndropped by the switch at the destination port due to lack of\nresources.\n\nNote that this number is not necessarily the number of\npackets dropped; it is just the number of times this\ncondition has been detected.\n\nA single dropped event counter is maintained for each\nportCopyDest. Thus all instances associated with a given\nportCopyDest will have the same portCopyDestDropEvents\nvalue.")
portCopyDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("copyRxOnly", 1), ("copyTxOnly", 2), ("copyBoth", 3), )).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: portCopyDirection.setDescription("This object affects the way traffic is copied from a switch\nsource port, for the indicated port copy operation.\nIf this object has the value 'copyRxOnly(1)', then only\ntraffic received on the indicated source port will be copied\nto the indicated destination port.\n\nIf this object has the value 'copyTxOnly(2)', then only\ntraffic transmitted out the indicated source port will be\ncopied to the indicated destination port.\n\nIf this object has the value 'copyBoth(3)', then all traffic\nreceived or transmitted on the indicated source port will be\ncopied to the indicated destination port.\n\nThe creation and deletion of instances of this object is\ncontrolled by the portCopyRowStatus object. Note that there\nis no guarantee that changes in the value of this object\nperformed while the associated portCopyRowStatus object is\nequal to active will not cause traffic discontinuities in the\npacket stream.")
portCopyStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 22, 1, 3, 1, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: portCopyStatus.setDescription("Defines the status of the port copy entry.\n\nIn order to configure a source to destination portCopy\nrelationship, both source and destination interfaces MUST be\npresent as an ifEntry in the ifTable and their respective\nifAdminStatus and ifOperStatus values MUST be equal to\n'up(1)'. If the value of any of those two objects changes\nafter the portCopyEntry is activated, portCopyStatus will\ntransition to 'notReady(3)'.\n\nThe capability of an interface to be source or destination of\na port copy operation is described by the 'copySourcePort(0)'\nand 'copyDestPort(1)' bits in dataSourceCopyCaps. Those bits\nSHOULD be appropriately set by the agent, in order to allow\nfor a portCopyEntry to be created.")
smonRegistrationPoints = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 4))
smonVlanDataSource = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 22, 1, 4, 1))

# Augmentions

# Groups

dataSourceCapsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 1)).setObjects(*(("SMON-MIB", "dataSourceCapsIfIndex"), ("SMON-MIB", "dataSourceCopyCaps"), ("SMON-MIB", "dataSourceRmonCaps"), ) )
if mibBuilder.loadTexts: dataSourceCapsGroup.setDescription("Defines the objects that describe the capabilities of RMON\ndata sources.")
smonVlanStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 2)).setObjects(*(("SMON-MIB", "smonVlanStatsControlCreateTime"), ("SMON-MIB", "smonVlanStatsControlStatus"), ("SMON-MIB", "smonVlanIdStatsNUcastPkts"), ("SMON-MIB", "smonVlanIdStatsTotalOctets"), ("SMON-MIB", "smonVlanStatsControlDataSource"), ("SMON-MIB", "smonVlanIdStatsTotalPkts"), ("SMON-MIB", "smonVlanStatsControlOwner"), ("SMON-MIB", "smonVlanIdStatsCreateTime"), ) )
if mibBuilder.loadTexts: smonVlanStatsGroup.setDescription("Defines the switch monitoring specific statistics - per VLAN\nId on interfaces of 10MB or less.")
smonPrioStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 3)).setObjects(*(("SMON-MIB", "smonPrioStatsPkts"), ("SMON-MIB", "smonPrioStatsControlOwner"), ("SMON-MIB", "smonPrioStatsControlDataSource"), ("SMON-MIB", "smonPrioStatsControlStatus"), ("SMON-MIB", "smonPrioStatsControlCreateTime"), ("SMON-MIB", "smonPrioStatsOctets"), ) )
if mibBuilder.loadTexts: smonPrioStatsGroup.setDescription("Defines the switch monitoring specific statistics - per VLAN\nId on interface.")
smonHcTo100mbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 4)).setObjects(*(("SMON-MIB", "smonPrioStatsHCOctets"), ("SMON-MIB", "smonVlanIdStatsTotalHCOctets"), ("SMON-MIB", "smonVlanIdStatsTotalOverflowOctets"), ("SMON-MIB", "smonPrioStatsOverflowOctets"), ) )
if mibBuilder.loadTexts: smonHcTo100mbGroup.setDescription("Defines the additional high capacity statistics needed to be\nkept on interfaces with ifSpeed greater than 10MB/sec and\nless than or equal to 100MB/sec.")
smonHc100mbPlusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 5)).setObjects(*(("SMON-MIB", "smonVlanIdStatsNUcastOverflowPkts"), ("SMON-MIB", "smonPrioStatsOverflowOctets"), ("SMON-MIB", "smonVlanIdStatsNUcastHCPkts"), ("SMON-MIB", "smonPrioStatsHCOctets"), ("SMON-MIB", "smonVlanIdStatsTotalHCOctets"), ("SMON-MIB", "smonVlanIdStatsTotalOverflowOctets"), ("SMON-MIB", "smonVlanIdStatsTotalHCPkts"), ("SMON-MIB", "smonVlanIdStatsTotalOverflowPkts"), ("SMON-MIB", "smonPrioStatsOverflowPkts"), ("SMON-MIB", "smonPrioStatsHCPkts"), ) )
if mibBuilder.loadTexts: smonHc100mbPlusGroup.setDescription("Defines the additional high capacity statistics needed to be\nkept on interfaces with ifSpeed of more than 100MB/sec. These\nstatistics MUST also be kept on smonDataSources of type VLAN\nor entPhysicalEntry.")
hcVlanTo100mbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 6)).setObjects(*(("SMON-MIB", "smonVlanIdStatsTotalHCOctets"), ("SMON-MIB", "smonVlanIdStatsTotalOverflowOctets"), ) )
if mibBuilder.loadTexts: hcVlanTo100mbGroup.setDescription("Defines the additional high capacity VLAN statistics\nneeded to be kept on interfaces with ifSpeed greater than\n10MB/sec and less than or equal to 100MB/sec.")
hcVlan100mbPlusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 7)).setObjects(*(("SMON-MIB", "smonVlanIdStatsNUcastHCPkts"), ("SMON-MIB", "smonVlanIdStatsTotalOverflowPkts"), ("SMON-MIB", "smonVlanIdStatsNUcastOverflowPkts"), ("SMON-MIB", "smonVlanIdStatsTotalHCOctets"), ("SMON-MIB", "smonVlanIdStatsTotalOverflowOctets"), ("SMON-MIB", "smonVlanIdStatsTotalHCPkts"), ) )
if mibBuilder.loadTexts: hcVlan100mbPlusGroup.setDescription("Defines the additional high capacity VLAN statistics\nneeded to be kept on interfaces with ifSpeed of more than\n100MB/sec.  These statistics MUST also be kept on\nsmonDataSources of type VLAN or entPhysicalEntry.")
hcPrioTo100mbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 8)).setObjects(*(("SMON-MIB", "smonPrioStatsHCOctets"), ("SMON-MIB", "smonPrioStatsOverflowOctets"), ) )
if mibBuilder.loadTexts: hcPrioTo100mbGroup.setDescription("Defines the additional high capacity VLAN priority\nstatistics needed to be kept on interfaces with\nifSpeed of greater than 10MB/sec and less than or equal\nto 100MB/sec.")
hcPrio100mbPlusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 9)).setObjects(*(("SMON-MIB", "smonPrioStatsHCOctets"), ("SMON-MIB", "smonPrioStatsHCPkts"), ("SMON-MIB", "smonPrioStatsOverflowOctets"), ("SMON-MIB", "smonPrioStatsOverflowPkts"), ) )
if mibBuilder.loadTexts: hcPrio100mbPlusGroup.setDescription("Defines the additional high capacity VLAN priority\nstatistics needed to be kept on interfaces with\nifSpeed of greater than 100MB/sec. These statistics MUST\nalso be kept on smonDataSources of type VLAN or\nentPhysicalEntry.")
smonVlanStatsExtGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 10)).setObjects(*(("SMON-MIB", "smonVlanIdStatsNUcastHCOctets"), ("SMON-MIB", "smonVlanIdStatsNUcastOctets"), ("SMON-MIB", "smonVlanIdStatsNUcastOverflowOctets"), ) )
if mibBuilder.loadTexts: smonVlanStatsExtGroup.setDescription("Defines the switch monitoring specific statistics for systems\ncapable of counting non-unicast octets for a given dataSource\n(as described in the dataSourceRmonCaps object).")
smonInformationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 11)).setObjects(*(("SMON-MIB", "smonCapabilities"), ) )
if mibBuilder.loadTexts: smonInformationGroup.setDescription("An indication of the SMON capabilities supported by this\nagent.")
portCopyConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 4, 12)).setObjects(*(("SMON-MIB", "portCopyDestDropEvents"), ("SMON-MIB", "portCopyStatus"), ("SMON-MIB", "portCopyDirection"), ) )
if mibBuilder.loadTexts: portCopyConfigGroup.setDescription("Defines the control objects for copy port operations.")

# Compliances

smonMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 20, 3, 1)).setObjects(*(("SMON-MIB", "smonHc100mbPlusGroup"), ("SMON-MIB", "dataSourceCapsGroup"), ("SMON-MIB", "smonInformationGroup"), ("SMON-MIB", "smonPrioStatsGroup"), ("SMON-MIB", "portCopyConfigGroup"), ("SMON-MIB", "smonVlanStatsGroup"), ("SMON-MIB", "smonHcTo100mbGroup"), ) )
if mibBuilder.loadTexts: smonMIBCompliance.setDescription("Describes the requirements for full conformance with the SMON\nMIB")
smonMIBVlanStatsCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 20, 3, 2)).setObjects(*(("SMON-MIB", "smonVlanStatsGroup"), ("SMON-MIB", "smonInformationGroup"), ("SMON-MIB", "dataSourceCapsGroup"), ("SMON-MIB", "hcVlanTo100mbGroup"), ("SMON-MIB", "hcVlan100mbPlusGroup"), ) )
if mibBuilder.loadTexts: smonMIBVlanStatsCompliance.setDescription("Describes the requirements for conformance with the SMON MIB\nwith support for VLAN Statistics. Mandatory for a SMON probe\nin environment where IEEE 802.1Q bridging is implemented.")
smonMIBPrioStatsCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 20, 3, 3)).setObjects(*(("SMON-MIB", "smonInformationGroup"), ("SMON-MIB", "hcPrioTo100mbGroup"), ("SMON-MIB", "dataSourceCapsGroup"), ("SMON-MIB", "hcPrio100mbPlusGroup"), ("SMON-MIB", "smonPrioStatsGroup"), ) )
if mibBuilder.loadTexts: smonMIBPrioStatsCompliance.setDescription("Describes the requirements for conformance with the SMON MIB\nwith support for priority level Statistics. Mandatory for a\nSMON probe in a environment where IEEE 802.1p\npriority-switching is implemented.")
portCopyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 20, 3, 4)).setObjects(*(("SMON-MIB", "smonInformationGroup"), ("SMON-MIB", "dataSourceCapsGroup"), ("SMON-MIB", "portCopyConfigGroup"), ) )
if mibBuilder.loadTexts: portCopyCompliance.setDescription("Describes the requirements for conformance with the port copy\nfunctionality defined by the SMON MIB")

# Exports

# Module identity
mibBuilder.exportSymbols("SMON-MIB", PYSNMP_MODULE_ID=switchRMON)

# Types
mibBuilder.exportSymbols("SMON-MIB", SmonDataSource=SmonDataSource)

# Objects
mibBuilder.exportSymbols("SMON-MIB", smonCapabilities=smonCapabilities, smonMIBCompliances=smonMIBCompliances, smonMIBGroups=smonMIBGroups, switchRMON=switchRMON, smonMIBObjects=smonMIBObjects, dataSourceCaps=dataSourceCaps, dataSourceCapsTable=dataSourceCapsTable, dataSourceCapsEntry=dataSourceCapsEntry, dataSourceCapsObject=dataSourceCapsObject, dataSourceRmonCaps=dataSourceRmonCaps, dataSourceCopyCaps=dataSourceCopyCaps, dataSourceCapsIfIndex=dataSourceCapsIfIndex, smonStats=smonStats, smonVlanStatsControlTable=smonVlanStatsControlTable, smonVlanStatsControlEntry=smonVlanStatsControlEntry, smonVlanStatsControlIndex=smonVlanStatsControlIndex, smonVlanStatsControlDataSource=smonVlanStatsControlDataSource, smonVlanStatsControlCreateTime=smonVlanStatsControlCreateTime, smonVlanStatsControlOwner=smonVlanStatsControlOwner, smonVlanStatsControlStatus=smonVlanStatsControlStatus, smonVlanIdStatsTable=smonVlanIdStatsTable, smonVlanIdStatsEntry=smonVlanIdStatsEntry, smonVlanIdStatsId=smonVlanIdStatsId, smonVlanIdStatsTotalPkts=smonVlanIdStatsTotalPkts, smonVlanIdStatsTotalOverflowPkts=smonVlanIdStatsTotalOverflowPkts, smonVlanIdStatsTotalHCPkts=smonVlanIdStatsTotalHCPkts, smonVlanIdStatsTotalOctets=smonVlanIdStatsTotalOctets, smonVlanIdStatsTotalOverflowOctets=smonVlanIdStatsTotalOverflowOctets, smonVlanIdStatsTotalHCOctets=smonVlanIdStatsTotalHCOctets, smonVlanIdStatsNUcastPkts=smonVlanIdStatsNUcastPkts, smonVlanIdStatsNUcastOverflowPkts=smonVlanIdStatsNUcastOverflowPkts, smonVlanIdStatsNUcastHCPkts=smonVlanIdStatsNUcastHCPkts, smonVlanIdStatsNUcastOctets=smonVlanIdStatsNUcastOctets, smonVlanIdStatsNUcastOverflowOctets=smonVlanIdStatsNUcastOverflowOctets, smonVlanIdStatsNUcastHCOctets=smonVlanIdStatsNUcastHCOctets, smonVlanIdStatsCreateTime=smonVlanIdStatsCreateTime, smonPrioStatsControlTable=smonPrioStatsControlTable, smonPrioStatsControlEntry=smonPrioStatsControlEntry, smonPrioStatsControlIndex=smonPrioStatsControlIndex, smonPrioStatsControlDataSource=smonPrioStatsControlDataSource, smonPrioStatsControlCreateTime=smonPrioStatsControlCreateTime, smonPrioStatsControlOwner=smonPrioStatsControlOwner, smonPrioStatsControlStatus=smonPrioStatsControlStatus, smonPrioStatsTable=smonPrioStatsTable, smonPrioStatsEntry=smonPrioStatsEntry, smonPrioStatsId=smonPrioStatsId, smonPrioStatsPkts=smonPrioStatsPkts, smonPrioStatsOverflowPkts=smonPrioStatsOverflowPkts, smonPrioStatsHCPkts=smonPrioStatsHCPkts, smonPrioStatsOctets=smonPrioStatsOctets, smonPrioStatsOverflowOctets=smonPrioStatsOverflowOctets, smonPrioStatsHCOctets=smonPrioStatsHCOctets, portCopyConfig=portCopyConfig, portCopyTable=portCopyTable, portCopyEntry=portCopyEntry, portCopySource=portCopySource, portCopyDest=portCopyDest, portCopyDestDropEvents=portCopyDestDropEvents, portCopyDirection=portCopyDirection, portCopyStatus=portCopyStatus, smonRegistrationPoints=smonRegistrationPoints, smonVlanDataSource=smonVlanDataSource)

# Groups
mibBuilder.exportSymbols("SMON-MIB", dataSourceCapsGroup=dataSourceCapsGroup, smonVlanStatsGroup=smonVlanStatsGroup, smonPrioStatsGroup=smonPrioStatsGroup, smonHcTo100mbGroup=smonHcTo100mbGroup, smonHc100mbPlusGroup=smonHc100mbPlusGroup, hcVlanTo100mbGroup=hcVlanTo100mbGroup, hcVlan100mbPlusGroup=hcVlan100mbPlusGroup, hcPrioTo100mbGroup=hcPrioTo100mbGroup, hcPrio100mbPlusGroup=hcPrio100mbPlusGroup, smonVlanStatsExtGroup=smonVlanStatsExtGroup, smonInformationGroup=smonInformationGroup, portCopyConfigGroup=portCopyConfigGroup)

# Compliances
mibBuilder.exportSymbols("SMON-MIB", smonMIBCompliance=smonMIBCompliance, smonMIBVlanStatsCompliance=smonMIBVlanStatsCompliance, smonMIBPrioStatsCompliance=smonMIBPrioStatsCompliance, portCopyCompliance=portCopyCompliance)
