/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import org.jhotdraw.figures.FigureAttributes;
import org.jhotdraw.figures.LineDecoration;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class AbstractLineDecoration
implements LineDecoration {
    static final long serialVersionUID = 1577970039258356627L;
    private Color fFillColor;
    private Color fBorderColor;
    private transient Rectangle myBounds;

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color;
        Polygon polygon = this.outline(n, n2, n3, n4);
        this.myBounds = polygon.getBounds();
        if (this.getFillColor() == null) {
            graphics.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        } else {
            color = graphics.getColor();
            graphics.setColor(this.getFillColor());
            graphics.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            graphics.setColor(color);
        }
        if (this.getBorderColor() != this.getFillColor()) {
            color = graphics.getColor();
            graphics.setColor(this.getBorderColor());
            graphics.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            graphics.setColor(color);
        }
    }

    public Rectangle displayBox() {
        if (this.myBounds != null) {
            return this.myBounds;
        }
        return new Rectangle(0, 0);
    }

    public abstract Polygon outline(int var1, int var2, int var3, int var4);

    public void write(StorableOutput storableOutput) {
        if (this.getFillColor() != null) {
            FigureAttributes.writeColor(storableOutput, FigureAttributeConstant.FILL_COLOR.getName(), this.getFillColor());
        } else {
            storableOutput.writeString("no" + FigureAttributeConstant.FILL_COLOR.getName());
        }
        if (this.getBorderColor() != null) {
            FigureAttributes.writeColor(storableOutput, FigureAttributeConstant.FRAME_COLOR.getName(), this.getBorderColor());
        } else {
            storableOutput.writeString("no" + FigureAttributeConstant.FRAME_COLOR.getName());
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        String string;
        String string2 = storableInput.readString();
        if (string2.equals(FigureAttributeConstant.FRAME_COLOR.getName())) {
            this.setFillColor(FigureAttributes.readColor(storableInput));
        }
        if ((string = storableInput.readString()).equals("BorderColor") || string.equals(FigureAttributeConstant.FRAME_COLOR.getName())) {
            this.setBorderColor(FigureAttributes.readColor(storableInput));
        }
    }

    public void setFillColor(Color color) {
        this.fFillColor = color;
    }

    public Color getFillColor() {
        return this.fFillColor;
    }

    public void setBorderColor(Color color) {
        this.fBorderColor = color;
    }

    public Color getBorderColor() {
        return this.fBorderColor;
    }

    public abstract /* synthetic */ String getMap();
}

