/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ToolListener;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.standard.AWTCursor;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;

public abstract class AbstractTool
implements Tool {
    private DrawingEditor myDrawingEditor;
    private int myAnchorX;
    private int myAnchorY;
    private DrawingView myDrawingView;
    private Undoable myUndoActivity;
    private EventDispatcher myEventDispatcher;
    private boolean myIsUsable;
    private boolean myIsEnabled;

    public AbstractTool(DrawingEditor drawingEditor) {
        this.setEditor(drawingEditor);
        this.setEventDispatcher(this.createEventDispatcher());
        this.setEnabled(true);
        this.checkUsable();
        this.editor().addViewChangeListener(this.createViewChangeListener());
    }

    public void activate() {
        if (this.getActiveView() != null) {
            this.getActiveView().clearSelection();
            this.getActiveView().checkDamage();
            this.getEventDispatcher().fireToolActivatedEvent();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            if (this.getActiveView() != null) {
                this.getActiveView().setCursor(new AWTCursor(0));
            }
            this.getEventDispatcher().fireToolDeactivatedEvent();
        }
    }

    protected void viewSelectionChanged(DrawingView drawingView, DrawingView drawingView2) {
        if (this.isActive()) {
            this.deactivate();
            this.activate();
        }
        this.checkUsable();
    }

    protected void viewCreated(DrawingView drawingView) {
    }

    protected void viewDestroying(DrawingView drawingView) {
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.setAnchorX(n);
        this.setAnchorY(n2);
        this.setView((DrawingView)mouseEvent.getSource());
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
    }

    public void keyDown(KeyEvent keyEvent, int n) {
    }

    public Drawing drawing() {
        return this.view().drawing();
    }

    public Drawing getActiveDrawing() {
        return this.getActiveView().drawing();
    }

    public DrawingEditor editor() {
        return this.myDrawingEditor;
    }

    protected void setEditor(DrawingEditor drawingEditor) {
        this.myDrawingEditor = drawingEditor;
    }

    public DrawingView view() {
        return this.myDrawingView;
    }

    protected void setView(DrawingView drawingView) {
        this.myDrawingView = drawingView;
    }

    public DrawingView getActiveView() {
        return this.editor().view();
    }

    public boolean isUsable() {
        return this.isEnabled() && this.myIsUsable;
    }

    public void setUsable(boolean bl) {
        if (this.isUsable() != bl) {
            this.myIsUsable = bl;
            if (this.isUsable()) {
                this.getEventDispatcher().fireToolUsableEvent();
            } else {
                this.getEventDispatcher().fireToolUnusableEvent();
            }
        }
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            this.myIsEnabled = bl;
            if (this.isEnabled()) {
                this.getEventDispatcher().fireToolEnabledEvent();
            } else {
                this.getEventDispatcher().fireToolDisabledEvent();
                this.setUsable(false);
                this.deactivate();
            }
        }
    }

    public boolean isEnabled() {
        return this.myIsEnabled;
    }

    protected void setAnchorX(int n) {
        this.myAnchorX = n;
    }

    protected int getAnchorX() {
        return this.myAnchorX;
    }

    protected void setAnchorY(int n) {
        this.myAnchorY = n;
    }

    protected int getAnchorY() {
        return this.myAnchorY;
    }

    public Undoable getUndoActivity() {
        return this.myUndoActivity;
    }

    public void setUndoActivity(Undoable undoable) {
        this.myUndoActivity = undoable;
    }

    public boolean isActive() {
        return this.editor().tool() == this && this.isUsable();
    }

    public void addToolListener(ToolListener toolListener) {
        this.getEventDispatcher().addToolListener(toolListener);
    }

    public void removeToolListener(ToolListener toolListener) {
        this.getEventDispatcher().removeToolListener(toolListener);
    }

    private void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.myEventDispatcher = eventDispatcher;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    protected EventDispatcher createEventDispatcher() {
        return new EventDispatcher(this);
    }

    protected ViewChangeListener createViewChangeListener() {
        return new ViewChangeListener(){

            public void viewSelectionChanged(DrawingView drawingView, DrawingView drawingView2) {
                AbstractTool.this.viewSelectionChanged(drawingView, drawingView2);
            }

            public void viewCreated(DrawingView drawingView) {
                AbstractTool.this.viewCreated(drawingView);
            }

            public void viewDestroying(DrawingView drawingView) {
                AbstractTool.this.viewDestroying(drawingView);
            }
        };
    }

    protected void checkUsable() {
        if (this.isEnabled()) {
            this.setUsable(this.getActiveView() != null && this.getActiveView().isInteractive());
        }
    }

    public static class EventDispatcher {
        private List myRegisteredListeners = CollectionsFactory.current().createList();
        private Tool myObservedTool;

        public EventDispatcher(Tool tool) {
            this.myObservedTool = tool;
        }

        public void fireToolUsableEvent() {
            Iterator iterator = this.myRegisteredListeners.iterator();
            while (iterator.hasNext()) {
                ((ToolListener)iterator.next()).toolUsable(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolUnusableEvent() {
            Iterator iterator = this.myRegisteredListeners.iterator();
            while (iterator.hasNext()) {
                ((ToolListener)iterator.next()).toolUnusable(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolActivatedEvent() {
            Iterator iterator = this.myRegisteredListeners.iterator();
            while (iterator.hasNext()) {
                ((ToolListener)iterator.next()).toolActivated(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolDeactivatedEvent() {
            Iterator iterator = this.myRegisteredListeners.iterator();
            while (iterator.hasNext()) {
                ((ToolListener)iterator.next()).toolDeactivated(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolEnabledEvent() {
            Iterator iterator = this.myRegisteredListeners.iterator();
            while (iterator.hasNext()) {
                ((ToolListener)iterator.next()).toolEnabled(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolDisabledEvent() {
            Iterator iterator = this.myRegisteredListeners.iterator();
            while (iterator.hasNext()) {
                ((ToolListener)iterator.next()).toolDisabled(new EventObject(this.myObservedTool));
            }
        }

        public void addToolListener(ToolListener toolListener) {
            if (!this.myRegisteredListeners.contains(toolListener)) {
                this.myRegisteredListeners.add(toolListener);
            }
        }

        public void removeToolListener(ToolListener toolListener) {
            if (this.myRegisteredListeners.contains(toolListener)) {
                this.myRegisteredListeners.remove(toolListener);
            }
        }
    }
}

