/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.util.EventObject;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureSelectionListener;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.CommandListener;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class UndoableCommand
implements Command,
FigureSelectionListener,
CommandListener {
    private Command myWrappedCommand;
    private boolean hasSelectionChanged;
    private AbstractCommand.EventDispatcher myEventDispatcher;

    public UndoableCommand(Command command) {
        this.setWrappedCommand(command);
        this.getWrappedCommand().addCommandListener(this);
        this.setEventDispatcher(this.createEventDispatcher());
    }

    public void execute() {
        this.hasSelectionChanged = false;
        this.view().addFigureSelectionListener(this);
        this.getWrappedCommand().execute();
        Undoable undoable = this.getWrappedCommand().getUndoActivity();
        if (undoable != null && undoable.isUndoable()) {
            this.getDrawingEditor().getUndoManager().pushUndo(undoable);
            this.getDrawingEditor().getUndoManager().clearRedos();
        }
        if (!this.hasSelectionChanged || this.getDrawingEditor().getUndoManager().getUndoSize() == 1) {
            this.getDrawingEditor().figureSelectionChanged(this.view());
        }
        this.view().removeFigureSelectionListener(this);
    }

    public boolean isExecutable() {
        return this.getWrappedCommand().isExecutable();
    }

    protected void setWrappedCommand(Command command) {
        this.myWrappedCommand = command;
    }

    protected Command getWrappedCommand() {
        return this.myWrappedCommand;
    }

    public String name() {
        return this.getWrappedCommand().name();
    }

    public DrawingEditor getDrawingEditor() {
        return this.getWrappedCommand().getDrawingEditor();
    }

    public DrawingView view() {
        return this.getDrawingEditor().view();
    }

    public void figureSelectionChanged(DrawingView drawingView) {
        this.hasSelectionChanged = true;
    }

    public Undoable getUndoActivity() {
        return new UndoableAdapter(this.view());
    }

    public void setUndoActivity(Undoable undoable) {
    }

    public void addCommandListener(CommandListener commandListener) {
        this.getEventDispatcher().addCommandListener(commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        this.getEventDispatcher().removeCommandListener(commandListener);
    }

    private void setEventDispatcher(AbstractCommand.EventDispatcher eventDispatcher) {
        this.myEventDispatcher = eventDispatcher;
    }

    protected AbstractCommand.EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    public AbstractCommand.EventDispatcher createEventDispatcher() {
        return new AbstractCommand.EventDispatcher(this);
    }

    public void commandExecuted(EventObject eventObject) {
        this.getEventDispatcher().fireCommandExecutedEvent();
    }

    public void commandExecutable(EventObject eventObject) {
        this.getEventDispatcher().fireCommandExecutableEvent();
    }

    public void commandNotExecutable(EventObject eventObject) {
        this.getEventDispatcher().fireCommandNotExecutableEvent();
    }
}

