/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.util.Iterator;
import java.util.List;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;

public class UndoManager {
    public static final int DEFAULT_BUFFER_SIZE = 20;
    private List redoStack;
    private List undoStack;
    private int maxStackCapacity;

    public UndoManager() {
        this(20);
    }

    public UndoManager(int n) {
        this.maxStackCapacity = n;
        this.undoStack = CollectionsFactory.current().createList(this.maxStackCapacity);
        this.redoStack = CollectionsFactory.current().createList(this.maxStackCapacity);
    }

    public void pushUndo(Undoable undoable) {
        if (undoable.isUndoable()) {
            this.removeFirstElementInFullList(this.undoStack);
            this.undoStack.add(undoable);
        } else {
            this.undoStack = CollectionsFactory.current().createList(this.maxStackCapacity);
        }
    }

    public void pushRedo(Undoable undoable) {
        if (undoable.isRedoable()) {
            this.removeFirstElementInFullList(this.redoStack);
            if (this.getRedoSize() == 0 || this.peekRedo() != undoable) {
                this.redoStack.add(undoable);
            }
        } else {
            this.redoStack = CollectionsFactory.current().createList(this.maxStackCapacity);
        }
    }

    private void removeFirstElementInFullList(List list) {
        if (list.size() >= this.maxStackCapacity) {
            Undoable undoable = (Undoable)list.remove(0);
            undoable.release();
        }
    }

    private Undoable getLastElement(List list) {
        if (list.size() > 0) {
            return (Undoable)list.get(list.size() - 1);
        }
        return null;
    }

    public boolean isUndoable() {
        if (this.getUndoSize() > 0) {
            return this.getLastElement(this.undoStack).isUndoable();
        }
        return false;
    }

    public boolean isRedoable() {
        if (this.getRedoSize() > 0) {
            return this.getLastElement(this.redoStack).isRedoable();
        }
        return false;
    }

    protected Undoable peekUndo() {
        if (this.getUndoSize() > 0) {
            return this.getLastElement(this.undoStack);
        }
        return null;
    }

    protected Undoable peekRedo() {
        if (this.getRedoSize() > 0) {
            return this.getLastElement(this.redoStack);
        }
        return null;
    }

    public int getUndoSize() {
        return this.undoStack.size();
    }

    public int getRedoSize() {
        return this.redoStack.size();
    }

    public Undoable popUndo() {
        Undoable undoable = this.peekUndo();
        this.undoStack.remove(this.getUndoSize() - 1);
        return undoable;
    }

    public Undoable popRedo() {
        Undoable undoable = this.peekRedo();
        this.redoStack.remove(this.getRedoSize() - 1);
        return undoable;
    }

    public void clearUndos() {
        this.clearStack(this.undoStack);
    }

    public void clearRedos() {
        this.clearStack(this.redoStack);
    }

    protected void clearStack(List list) {
        list.clear();
    }

    public void clearUndos(DrawingView drawingView) {
        Iterator iterator = this.undoStack.iterator();
        while (iterator.hasNext()) {
            Undoable undoable = (Undoable)iterator.next();
            if (undoable.getDrawingView() != drawingView) continue;
            iterator.remove();
        }
    }

    public void clearRedos(DrawingView drawingView) {
        Iterator iterator = this.redoStack.iterator();
        while (iterator.hasNext()) {
            Undoable undoable = (Undoable)iterator.next();
            if (undoable.getDrawingView() != drawingView) continue;
            iterator.remove();
        }
    }
}

