/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.DatatypeLibraryImpl;
import com.thaiopensource.datatype.xsd.DecimalDatatype;
import com.thaiopensource.datatype.xsd.LengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.MaxExclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MaxInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MaxLengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinExclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinLengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.PatternRestrictDatatype;
import com.thaiopensource.datatype.xsd.PrecisionRestrictDatatype;
import com.thaiopensource.datatype.xsd.ScaleRestrictDatatype;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Localizer;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

class DatatypeBuilderImpl
implements DatatypeBuilder {
    static final Localizer localizer = new Localizer(class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl == null ? (class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl = DatatypeBuilderImpl.class$("com.thaiopensource.datatype.xsd.DatatypeBuilderImpl")) : class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl);
    private DatatypeBase base;
    private final DatatypeLibraryImpl library;
    static /* synthetic */ Class class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl;

    DatatypeBuilderImpl(DatatypeLibraryImpl datatypeLibraryImpl, DatatypeBase datatypeBase) throws DatatypeException {
        this.library = datatypeLibraryImpl;
        this.base = datatypeBase;
    }

    public void addParameter(String string, String string2, ValidationContext validationContext) throws DatatypeException {
        if (string.equals("pattern")) {
            this.addPatternParam(string2);
        } else if (string.equals("minInclusive")) {
            this.addMinInclusiveParam(string2, validationContext);
        } else if (string.equals("maxInclusive")) {
            this.addMaxInclusiveParam(string2, validationContext);
        } else if (string.equals("minExclusive")) {
            this.addMinExclusiveParam(string2, validationContext);
        } else if (string.equals("maxExclusive")) {
            this.addMaxExclusiveParam(string2, validationContext);
        } else if (string.equals("length")) {
            this.addLengthParam(string2);
        } else if (string.equals("minLength")) {
            this.addMinLengthParam(string2);
        } else if (string.equals("maxLength")) {
            this.addMaxLengthParam(string2);
        } else if (string.equals("fractionDigits")) {
            this.addScaleParam(string2);
        } else if (string.equals("totalDigits")) {
            this.addPrecisionParam(string2);
        } else if (string.equals("enumeration")) {
            DatatypeBuilderImpl.error("enumeration_param");
        } else if (string.equals("whiteSpace")) {
            DatatypeBuilderImpl.error("whiteSpace_param");
        } else {
            DatatypeBuilderImpl.error("unrecognized_param", string);
        }
    }

    private void addPatternParam(String string) throws DatatypeException {
        try {
            this.base = new PatternRestrictDatatype(this.base, this.library.getRegexEngine().compile(string));
        }
        catch (RegexSyntaxException regexSyntaxException) {
            int n = regexSyntaxException.getPosition();
            if (n == -1) {
                n = -1;
            }
            DatatypeBuilderImpl.error("invalid_regex", regexSyntaxException.getMessage(), n);
        }
    }

    private void addMinInclusiveParam(String string, ValidationContext validationContext) throws DatatypeException {
        this.base = new MinInclusiveRestrictDatatype(this.base, this.getLimit(string, validationContext));
    }

    private void addMaxInclusiveParam(String string, ValidationContext validationContext) throws DatatypeException {
        this.base = new MaxInclusiveRestrictDatatype(this.base, this.getLimit(string, validationContext));
    }

    private void addMinExclusiveParam(String string, ValidationContext validationContext) throws DatatypeException {
        this.base = new MinExclusiveRestrictDatatype(this.base, this.getLimit(string, validationContext));
    }

    private void addMaxExclusiveParam(String string, ValidationContext validationContext) throws DatatypeException {
        this.base = new MaxExclusiveRestrictDatatype(this.base, this.getLimit(string, validationContext));
    }

    private Object getLimit(String string, ValidationContext validationContext) throws DatatypeException {
        Object object;
        if (this.base.getOrderRelation() == null) {
            DatatypeBuilderImpl.error("not_ordered");
        }
        if ((object = this.base.createValue(string, validationContext)) == null) {
            DatatypeBuilderImpl.error("invalid_limit", string);
        }
        return object;
    }

    private void addLengthParam(String string) throws DatatypeException {
        this.base = new LengthRestrictDatatype(this.base, this.getLength(string));
    }

    private void addMinLengthParam(String string) throws DatatypeException {
        this.base = new MinLengthRestrictDatatype(this.base, this.getLength(string));
    }

    private void addMaxLengthParam(String string) throws DatatypeException {
        this.base = new MaxLengthRestrictDatatype(this.base, this.getLength(string));
    }

    private int getLength(String string) throws DatatypeException {
        int n;
        if (this.base.getMeasure() == null) {
            DatatypeBuilderImpl.error("no_length");
        }
        if ((n = this.convertNonNegativeInteger(string)) < 0) {
            DatatypeBuilderImpl.error("value_not_non_negative_integer");
        }
        return n;
    }

    private void addScaleParam(String string) throws DatatypeException {
        int n;
        if (!(this.base.getPrimitive() instanceof DecimalDatatype)) {
            DatatypeBuilderImpl.error("scale_not_derived_from_decimal");
        }
        if ((n = this.convertNonNegativeInteger(string)) < 0) {
            DatatypeBuilderImpl.error("value_not_non_negative_integer");
        }
        this.base = new ScaleRestrictDatatype(this.base, n);
    }

    private void addPrecisionParam(String string) throws DatatypeException {
        int n;
        if (!(this.base.getPrimitive() instanceof DecimalDatatype)) {
            DatatypeBuilderImpl.error("precision_not_derived_from_decimal");
        }
        if ((n = this.convertNonNegativeInteger(string)) <= 0) {
            DatatypeBuilderImpl.error("value_not_positive_integer");
        }
        this.base = new PrecisionRestrictDatatype(this.base, n);
    }

    public Datatype createDatatype() {
        return this.base;
    }

    private static void error(String string) throws DatatypeException {
        throw new DatatypeException(localizer.message(string));
    }

    private static void error(String string, String string2) throws DatatypeException {
        throw new DatatypeException(localizer.message(string, string2));
    }

    private static void error(String string, String string2, int n) throws DatatypeException {
        throw new DatatypeException(n, localizer.message(string, string2));
    }

    private int convertNonNegativeInteger(String string) {
        DecimalDatatype decimalDatatype = new DecimalDatatype();
        if (!decimalDatatype.lexicallyAllows(string = string.trim())) {
            return -1;
        }
        if ((string = decimalDatatype.getValue(string, null).toString()).charAt(0) == '-' || string.indexOf(46) >= 0) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

