/*
 * Qt wrapper for libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#ifndef COMMUNICATIONTEST_H
#define COMMUNICATIONTEST_H

// Qt
#include <QObject>
#include <QVariant>

// Local
#include <qindicateindicator.h>
#include <qindicatelistener.h>
#include <qindicateserver.h>

struct PropertyReceiver : public QObject
{
Q_OBJECT
public:
    PropertyReceiver()
    : server(0)
    , indicator(0)
    {}

    QIndicate::Listener::Server* server;
    QIndicate::Listener::Indicator* indicator;
    QString key;
    QVariant value;

public Q_SLOTS:
    void slotIndicatorPropertyReceived(
        QIndicate::Listener::Server* _server,
        QIndicate::Listener::Indicator* _indicator,
        const QString& _key,
        const QByteArray& _value)
    {
        server = _server;
        indicator = _indicator;
        key = _key;
        value = _value;
    }

    void slotServerQByteArrayPropertyReceived(
        QIndicate::Listener::Server* _server,
        const QByteArray& _value)
    {
        server = _server;
        value = _value;
    }

    void slotServerIntPropertyReceived(
        QIndicate::Listener::Server* _server,
        int _value)
    {
        server = _server;
        value = _value;
    }
};

/**
 * Test communication between listener, servers and indicators
 */
class CommunicationTest : public QObject
{
Q_OBJECT
private Q_SLOTS:
    void initTestCase();
    void init();
    void cleanup();
    void testIndicatorModified();
    void testGetServerDesktop();
    void testGetServerType();
    void testGetServerCount();
    void testGetIndicatorProperty();
    void testDisplay();
    void testInterest();

private:
    void showIndicatorAndGetProxies();

    QIndicate::Listener* mListener;
    QIndicate::Server* mServer;
    QIndicate::Indicator* mIndicator;

    QIndicate::Listener::Server* mListenerServer;
    QIndicate::Listener::Indicator* mListenerIndicator;
};

#endif /* COMMUNICATIONTEST_H */
