/*
 * Qt wrapper for libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#ifndef QINDICATESERVER_H
#define QINDICATESERVER_H

// Qt
#include <QObject>

// Local
#include <qindicateinterest.h>

namespace QIndicate
{

struct ServerPrivate;
class Server : public QObject
{
Q_OBJECT
public:
    Server(QObject* parent=0);
    ~Server();

    void setType(const QString&);
    void setDesktopFile(const QString&);
    void setCount(int);

    /**
     * Show server on DBus
     */
    void show();

    /**
     * Hide server from DBus
     */
    void hide();

    static void setDefaultInstance(Server*);
    static Server* defaultInstance();

Q_SIGNALS:
    void indicatorAdded(uint id);
    void indicatorRemoved(uint id);
    void indicatorModified(uint id, const QString& property);

    /**
     * Emitted when show() is called
     */
    void serverShow(const QString& type);

    /**
     * Emitted when hide() is called
     */
    void serverHide(const QString& type);

    /**
     * Emitted when a listener wants the server app to display itself, for
     * example because the user clicked on the application item.
     */
    void serverDisplay();

    /**
     * Emitted when a listener is interested in interest
     */
    void interestAdded(QIndicate::Interest interest);

    /**
     * Emitted when a listener is no longer interested in interest
     */
    void interestRemoved(QIndicate::Interest interest);

private:
    ServerPrivate* const d;
};

} // namespace

#endif /* QINDICATESERVER_H */
