#! /usr/bin/env python

# Genetic
# Copyright (C) 2001 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

from __future__ import nested_scopes

import random, string, math, Tkinter
from genetic import organism, lifecycle

SIZE = 250


class Point:
  def __init__(self, x, y):
    self.x = x
    self.y = y
    
  def __repr__(self): return "<Point %s, %s>" % (self.x, self.y)
  
points = []

def radius_func(x, y):
  # return the largest distance from the center (x, y) to one of the points.
  if len(points) == 0: return 0.0
  return max(map(lambda point: math.sqrt((point.x - x) ** 2 + (point.y - y) ** 2), points))

class CircleMinimizer(organism.Organism):
  characteristics = [
    organism.Characteristic("radius", radius_func, organism.PERCHROMOSOM_DOMINANCY_PHENOTYPE)
    ]
  
  def __cmp__(self, other):
    # Say how we compare 2 organisms. Here, the lower the circle radius is the better the organism is.
    return cmp(self.radius, other.radius)


class Graph(Tkinter.Canvas):
  def __init__(self, master):
    Tkinter.Canvas.__init__(self, master, bg = "white", width = SIZE, height = SIZE)
    self.bind("<Button-1>", self.leftClick )
    self.circle = None
    
    organismA = CircleMinimizer([
      organism.Chromosom(x = 50.0, y = 120.0, __mutampl__ = 50.0, __mutation__ = 0.8, __break__ = 0.0),
      ])
    organismB = CircleMinimizer([
      organism.Chromosom(x = 100.0, y = 100.0, __mutampl__ = 20.0, __mutation__ = 0.8, __break__ = 0.0),
      ])
    self.organisms = [organismA, organismB]
    
  def recomputephenotypes(self):
    for organism in self.organisms: organism._compute_phenotypes()
    
  def leftClick (self, event): self.addPoint(Point(event.x, event.y))
  
  def addPoint(self, point):
    points.append(point)
    self.create_text(point.x - 0, point.y - 0, text = "+")
    # Phenotypes have changed, because there is one point more !
    self.recomputephenotypes()
    
  def generation(self, nb = 1):
    self.organisms = lifecycle.run(self.organisms, 1, nb, 20, 8)
    
  def update(self):
    if self.circle: self.delete(self.circle)
    best   = self.organisms[0]
    radius = best.radius
    x, y   = best.radius_args
    self.circle = self.create_oval(x - radius, y - radius, x + radius, y + radius)
    

class GraphFrame(Tkinter.Tk):
  def __init__(self):
    Tkinter.Tk.__init__(self, className = "genetic circle")
    Tkinter.Label(self, text = "Click some points below, then run 1 or 10 generations !\nI will genetically compute the smallest circle around your points !", wraplength = SIZE + 30).pack()
    self.graph = Graph(self)
    self.graph.pack()
    Tkinter.Button(self, text = "1   generation" , command = self.generation1  ).pack()
    Tkinter.Button(self, text = "10  generations", command = self.generation10 ).pack()
        
  def generation1(self, event = None):
    self.graph.generation(1)
    self.graph.update()
        
  def generation10(self, event = None):
    self.graph.generation(10)
    self.graph.update()
    

graphframe = GraphFrame()
Tkinter.mainloop()
