NetBSD Prerequisites 
===================

These instructions will lead you through preparing to build the diagnostics repo on NetBSD. We'll start by showing how to set up your environment from scratch.

Environment
===========

These instructions are written on NetBSD 7.x on the amd64 platform, since that's the release the team uses.

Older releases aren't supported because building requires the modern LLVM stack (Clang and LLDB) that is developed against the NetBSD-7.x branch.

Pull Requests are welcome to address other ports (like i386 or evbarm) as long as they don't break the ability to use NetBSD/amd64.

Minimum RAM required to build is 1GB.

The pkgsrc framework is required to build .NET projects on NetBSD. Minimal pkgsrc version required is 2016Q1.

pkgsrc setup
------------

Fetch pkgsrc and install to the system. By default it's done in the /usr directory as root:

```
ftp -o- ftp://ftp.netbsd.org/pub/pkgsrc/stable/pkgsrc.tar.gz | tar -zxpf- -C /usr
```

The .NET projects are tracked in pkgsrc-wip.

In order to use pkgsrc-wip, git must be installed:


```
cd /usr/pkgsrc/devel/git-base && make install
```

To access resources over SSL link, mozilla-rootcerts must be installed:

```
cd /usr/pkgsrc/security/mozilla-rootcerts && make install
```

And follow the MESSAGE commands to finish the installation.


Installing pkgsrc-wip
---------------------

Type the following command to fetch the pkgsrc-wip sources:


```sh
cd /usr/pkgsrc
git clone --depth 1 git://wip.pkgsrc.org/pkgsrc-wip.git wip
```
