
//  (C) Copyright Edward Diener 2011-2015
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#include <boost/vmd/elem.hpp>
#include <boost/vmd/equal.hpp>
#include <boost/vmd/is_empty.hpp>
#include <boost/detail/lightweight_test.hpp>
#include <boost/preprocessor/tuple/elem.hpp>

int main()
  {
  
#if BOOST_PP_VARIADICS

  #define BOOST_VMD_REGISTER_ggh (ggh)
  
  #define ANIDENTIFIER ggh
  #define ANUMBER 249
  #define ASEQ (25)(26)(27)
  #define ATYPE BOOST_VMD_TYPE_SEQ
  #define ATYPE2 BOOST_VMD_TYPE_ARRAY
  #define ATYPE3 BOOST_VMD_TYPE_TYPE
  #define ATYPE5 BOOST_VMD_TYPE_EMPTY
  #define ALIST (0,(1,(2,(3,BOOST_PP_NIL))))
  #define ANARRAY (3,(a,b,38))
  #define ANARRAY2 (5,(c,d,133,22,15))
  #define ASEQUENCE ANUMBER ALIST ATYPE ANIDENTIFIER ANARRAY ASEQ
  #define ASEQUENCE2 ANIDENTIFIER ANARRAY2 ALIST ASEQ ATYPE2
  #define ASEQUENCE3 ASEQ ANIDENTIFIER ATYPE3 ALIST
  #define ASEQUENCE4
  #define ASEQUENCE5 ALIST ASEQ ATYPE5 ANIDENTIFIER

  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(0,ASEQUENCE,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE))));
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_PP_TUPLE_ELEM(1,BOOST_VMD_ELEM(0,ASEQUENCE2,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE))));
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(0,ASEQUENCE3,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE))));
  
  BOOST_TEST(!BOOST_VMD_IS_EMPTY(BOOST_PP_TUPLE_ELEM(1,BOOST_VMD_ELEM(2,ASEQUENCE,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE))));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(2,ASEQUENCE,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE)),BOOST_VMD_TYPE_SEQ,BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(2,ASEQUENCE,BOOST_VMD_TYPE_TYPE),BOOST_VMD_TYPE_SEQ,BOOST_VMD_TYPE_TYPE));
  
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_PP_TUPLE_ELEM(1,BOOST_VMD_ELEM(4,ASEQUENCE2,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE))));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TYPE_ARRAY,BOOST_VMD_ELEM(4,ASEQUENCE2,BOOST_VMD_TYPE_TYPE),BOOST_VMD_TYPE_TYPE));
  
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TYPE_TYPE,BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(2,ASEQUENCE3,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE)),BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(!BOOST_VMD_IS_EMPTY(BOOST_PP_TUPLE_ELEM(1,BOOST_VMD_ELEM(2,ASEQUENCE3,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE))));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TYPE_TYPE,BOOST_VMD_ELEM(2,ASEQUENCE3,BOOST_VMD_TYPE_TYPE),BOOST_VMD_TYPE_TYPE));
 
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(0,ASEQUENCE4,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE))));
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_PP_TUPLE_ELEM(1,BOOST_VMD_ELEM(0,ASEQUENCE4,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE))));
  BOOST_TEST(BOOST_VMD_IS_EMPTY(BOOST_VMD_ELEM(0,ASEQUENCE4,BOOST_VMD_TYPE_TYPE)));
  
  BOOST_TEST(!BOOST_VMD_IS_EMPTY(BOOST_PP_TUPLE_ELEM(1,BOOST_VMD_ELEM(2,ASEQUENCE5,BOOST_VMD_RETURN_AFTER,BOOST_VMD_TYPE_TYPE))));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TYPE_EMPTY,BOOST_VMD_ELEM(2,ASEQUENCE5,BOOST_VMD_TYPE_TYPE),BOOST_VMD_TYPE_TYPE));
  
#else

BOOST_ERROR("No variadic macro support");
  
#endif

  return boost::report_errors();
  
  }
