target=solumodel3  solumodelb solflim3  solferm solferm4  solcirc solcircosc solcascade

\language{fr}
\range{-5..5}
\author{Bernadette Perrin-Riou}
\email{bpr@math.u-psud.fr}
\computeanswer{yes}
\format{html}
\precision{10000}

\integer{n=\confparm1= ? 3:1+\confparm1}
\text{N=item(\n, Un, Deux,Trois,Quatre,Cinq,Six)}
\integer{tborne=200}
\text{E= wims(values 0 for x=1 to \n)}
\matrix{M=pari(matrix(\n+1,\n+1))}
\text{A =pari(A=vector(\n,i, 10*random\(10)+1) ; A)}
\text{V = pari(A=vector(\n,i, (random\(40)+10)*10) ; A)}

#if #TARGET (solumodel3)
	\title{Mlange de solutions (modlisation)}
	\integer{k=randint(\n)}
	\integer{s=randint(2)}
	\text{E=wims(replace internal item number  1 by  \s in \E)}
	\text{alph=randint(4..10)}
	\matrix{M=pari(M=Mat([\M]);
	for(i=1,\n, M[i+1,i]=random\(5)+1;
		M[i,i+1]=\alph+M[i+1,i]);
		M[\n+1,1]=\alph;
	M)}
#endif
#if #TARGET(solumodelb)
	\title{Mlange de solutions (modlisation) II}
	\integer{k=randint(1..\n)}
	\matrix{M=pari(M=Mat([\M]); 
	for(i=2,\n, M[i,i+1]=random\(3)+1;M[i+1,i]=random\(3)+1 ); 	
	M[\n+1,1]=random\(4); 
	M[1,\k+1]=random\(6);
	M)}
	\integer{s = randint(1..12)}
	\text{E=wims(replace internal item number \k by \s in \E)}
#endif
#if #TARGET(solflim3)
	\title{Solutions salines}
	\text{alph=randint(4..10)}
	\matrix{M=pari(M=Mat([\M]);
	for(i=1,\n, M[i+1,i]=random\(5)+1;
		M[i,i+1]=\alph+M[i+1,i]);
		M[\n+1,1]=\alph;
	M)}
#endif
#if #TARGET(solferm4)
	\title{Solutions salines en circuit ferm}
#endif
#if	#TARGET(solferm)
	\title{Solutions salines et vecteurs propres}
#endif
#if #TARGET(solferm4) || #TARGET(solferm)
	\integer{s=randint(1..5)}
	\matrix{M=pari(M=Mat([\M]);
for(i=2,\n, M[i,i+1] =\s; M[i+1,i] =\s);
M)}
#endif
#if #TARGET(solcircosc)
	\title{Solutions salines et oscillations}
	\integer{tborne=20}
	\integer{r=randint(1..20)*10}
#endif
#if #TARGET(solcirc)
	\title{Solutions salines en circuit circulaire }
	\integer{r=randint(1..5)}
#endif	
#if #TARGET(solcircosc) || #TARGET(solcirc)
	\matrix{M=pari(M=Mat([\M]);M[2,3] =\r;
	for(i=3,\n, M[i,i+1] =\r);
	M[\n+1,2] =\r;M)}
	\text{choix=randint(1,2)}
	\text{A =\choix=1? pari(A=vector(\n,i, 5*(random\(6))) ; if(A==0, A[\n]=random\(6)); A):
pari(A=vector(\n,i,5*(random\(6)+3)) ; A[1]=1; A)}
	\text{A=shuffle(\A)}
#endif
#if #TARGET(solcascade)
	\title{Solutions salines en cascade}
	\integer{r=randint(2..5)}
	\matrix{M=pari(M=Mat([\M]);for(i=1, \n , M[i,i+1] =\r);
M[\n+1,1]=\r;
M)}
	\text{A =pari(A=vector(\n) ; A[1]=random\(6)+8;
for(i=2, \n, A[i]=random\(2)*(random\(3)+1));A)}
	\text{test=1}
	\for{i =1 to \10}{
		\if{\test=1}{
			\text{V = pari(A=vector(\n,i, (random\(40)+10)*10) ; A)}
			\text{test0=items(wims(listuniq \V))}
			\text{test=\test0=\n ? 0}
		}
	}
	\if{\test=1}{\text{V = shuffle(200,300,350,100,120,150,250)}}
#endif
dessin des bidons
\integer{size=200*\n}
\text{dessin=xrange -2.5,4*\n+0.5
yrange -2,4}
\for{i=1 to \n}{
	\text{dessin = \dessin
text black,4*(\i-1)+0.5,1.6,medium,\A[\i] g
text black,4*(\i-1)+0.5,0.8,medium,\V[\i] m^3}
	}
\for{i = 1 to \n}{
	\text{dessin = \dessin
lines black, 4*(\i-1),0,4*(\i-1),2,4*\i-2,2,4*\i-2,0,4*(\i-1),0
line 4*(\i-1),1,4*\i-2,1, blue 
fill  4*\i-3,0.5,skyblue}}
\for{j=0 to \n}{
	\for{i=0 to \n}{
	\text{dessin = \j<>0 and \M[\i+1;\j+1]<>0 and \i>\j  ?\dessin
text red,4*\i-6,-0.8,medium,\M[\i+1;\j+1] m^3/s
arrow 4*\i-4,-0.5,4*\j-1,-0.5,20,black
lines black, 4*\i-3.5,0,4*\i-3.5,-0.5, 4*\j-2.5,-0.5,4*\j-2.5,0}
	\text{dessin = \i<>0 and \M[\i+1;\j+1]<>0 and \i<\j  ?\dessin
text red,4*\i-2,3,medium,\M[\i+1;\j+1] m^3/s
arrow 4*\i -1,2.5,4*\j-4,2.5,20,black
lines black, 4*\i-2.5,2,4*\i-2.5,2.5, 4*\j-3.5,2.5,4*\j-3.5,2}
	\text{dessin = \j=0 and \M[\i+1;\j+1]<>0  ?\dessin
text red,4*\i-4,-1.2,medium,\M[\i+1;\j+1] m^3/s
arrow 4*\i-3,-1,4*\i-4,-1,20,black
lines black, 4*\i-4,-1,4*\i-3,-1, 4*\i-3,0}
	\text{dessin = \i=0 and \M[\i+1;\j+1]<>0 and \i<\j  ?\dessin
text blue,4*\j-4,3.8,medium,\M[\i+1;\j+1] m^3/s
arrow 4*\j-4,3.2,4*\j-3,3.2,20,black
lines black, 4*\j-4,3.2,4*\j-3,3.2, 4*\j-3,2}
	}
}
\for{i=1 to \n}{
	\text{dessin=\E[\i]<>0? \dessin
text blue,4*\i-4,3,medium,\E[\i] g/m^3}
}
\matrix{U = pari(R=matrix(\n,\n); M=Mat([\M]);V=[\V];
for(j=1, \n, S=  sum(k=1, \n+1, M[j+1,k]) - sum(k=1, \n+1, M[k,j+1]) ; 
for(i=1, \n,  R[i,j] = if(j<>i, M[j+1,i+1]/(V[j]-t*S),  -sum(k=1, \n+1, M[j+1,k])/(V[j]-t*S))));R)}

\text{B = pari(M=Mat([\M]); E=Vec([\E]); vector(\n,i,M[1,i+1]*E[i]))}
\text{dA = wims(makelist dA x/dt for x=1 to \n)}
\text{dA = wims(nospace \dA)}
\text{dA = wims(replace internal , by ; in \dA)}
\text{Ap = wims(makelist A x for x=1 to \n)}
\text{Ap = wims(nospace \Ap)}
\text{Ap = wims(replace internal , by ; in \Ap)}

\text{color=blue,red,gold,black,brown,skyblue,magenta}
\text{couleur=bleu,rouge,jaune,noir,marron,bleu ciel,magenta}
\text{coul=shuffle(items(\couleur))}
\text{coul=item(1..\n,\coul)}
\text{couleur=item([\coul], \couleur)}
\text{color=item([\coul], \color)}

#if #TARGET (solcirc)  || #TARGET(solcircosc) || #TARGET (solferm4) || #TARGET (solflim3) || #TARGET (solferm) 
Rsolution gnrale
	\text{Cgen = wims(makelist C x for x=1 to \n)}
	\text{Cgen = wims(nospace \Cgen)}
	\text{s = pari({U= Mat([\U]); A=Mat([\A]) ;n=\n;
P = mateigen(U); 
Q= P^(-1);D = Q*U*P; 
C = (Q*A~); 
S=matrix(n,n,a,b,C[b,1]*P[a,b]);
print(vector(n,a,D[a,a])","S)})}
#endif
#if #TARGET (solcascade)
matrice triangulaire a priori
	\text{s = pari({U= Mat([\U]); A=Mat([\A]) ;n=\n;
vp=vector(n,i,U[i,i]); P=Mat([]);
for(i=1,n, P1 = matker(U-vp[i]*matid(n)); P=concat(P,P1));
Q= P^(-1);D = Q*U*P; 
C = Q*A~; 
S=matrix(n,n,a,b,C[b,1]*P[a,b]);
[vp,S]})}
#endif
#if #TARGET (solferm) ||#TARGET (solcirc)  || #TARGET(solcircosc)
	\text{noyau = pari(U= Mat([\U]); A=Mat([\A]) ;n=\n;
 print(matker(U)~))}
#endif
#if #TARGET (solcirc)  || #TARGET(solcircosc) || #TARGET (solferm4) || #TARGET (solflim3) || #TARGET (solferm) || #TARGET (solcascade)

valeurs propres
	\text{vp=item(1,\s)}
	\text{vp=wims(declosing \vp)}
	\text{vp1=pari(round(10000*[\vp])/10000)}
	\text{W=item(2,\s)}
	\matrix{W=wims(declosing \W)}

	\text{solution =}
	\text{borne=0}
	\text{plotdata=}
	\text{Wapp=pari(round(10000*[\W])/10000)}
	\text{vpim=}
	\for{i=1 to \n}{
		\text{ligne=}
		\for{j=1 to \n}{
			\text{c=\Wapp[\i;\j]}
			\text{c1=pari(real(\c))}
			\text{c2=pari(imag(\c))}
			\text{d=\vp1[\j]}
			\text{d1=pari(real(\d))}
			\text{d2=pari(imag(\d))}
			\text{vpim=\vpim,pari(imag(\vp[\j]))}
			\text{ligne =  \c1<>0 or \c2<>0 ?\ligne+(cos(\d2*t)*(\c1) - sin(\d2*t)*(\c2))*exp((\d1)*t)}
		}
		\text{solution=\solution,\ligne}
		\text{borne1=item(2,slib(function/bounds \ligne,t,0,\tborne))}
		\real{borne=max(\borne,\borne1)}
		\text{plotdata=\plotdata
		plot \color[\i], t,\ligne}
	}
	\text{solution=wims(nonempty items \solution)}
#endif
#if #TARGET(solcircosc) 
	\text{vpim=wims(nonempty items \vpim)}
	\text{vpim=wims(values abs(x) for x  in \vpim)}
	\text{vpim=pari(round(10^10*[\vpim])/10^10)}
	\text{vpim=wims(listuniq \vpim )}
	\text{vpim=wims(sort  numeric item \vpim )}
	\text{vpim=item([2..-1],\vpim)}
	\text{vpim=\vpim= ? 0:pari(vp=Vec([\vpim]);V=vector(matsize(vp)[2],i,2*pi/vp[i]))}
#endif
#if #TARGET (solferm4) || #TARGET (solferm) || #TARGET (solcirc)
	\for{i=1 to \n}{
		\complex{absol=abs(\vp[\i])}
		\text{limite=\absol<10^-5? \W[;\i]}
	}
	\text{limite=pari(real([\limite]))}
#endif
#if #TARGET (solcascade)
	\integer{k=randint(2..\n)}
	\integer{k1=2}
	\integer{choix=randint(1,2)}
	\if{\choix=1}{
		\text{t0=solve(\solution[1]=\solution[\k1],t=0..\tborne)}
		}
		{\function{maxi=diff(\solution[\k1],t)}
		\text{t0=solve(\maxi, t=0..\tborne)}
		}	
	\text{t0=items(\t0)>0  ? item(1,\t0):\tborne}
#endif
#if #TARGET (solflim3)
	\text{deriv=}
	\for{i=1 to \n}{
		\function{h=diff(\solution[\i],t)}
		\real{h=evalue(\h,t=0)}
		\text{deriv=\deriv, \h}
	}
	\text{deriv=wims(nonempty items \deriv)}
#endif
#if #TARGET (solumodel3) || #TARGET(solumodelb)
	\text{STEPS=reply1, reply2}
#endif 
#if #TARGET (solferm4)
	\text{STEPS=reply1
	item(1..\n,reply2,reply3,reply4,reply5,reply6) }
#endif
#if #TARGET (solferm ) || #TARGET (solcirc)
\text{STEPS=reply1
reply2 , item(1..\n-1,reply3,reply4,reply5,reply6) }
#endif
#if #TARGET (solcircosc)
	\text{STEPS=reply1
reply2}
#endif
#if #TARGET (solflim3)
	\text{STEPS=reply1
	item(1..\n,reply2,reply3,reply4,reply5)}
#endif
#if #TARGET (solcascade)
	\text{STEPS=reply1
	reply2,reply3}
#endif
\steps{\STEPS}

\statement{
\N bidons sont remplis initialement (pour \(t = 0)) de 
\for{u=1 to \n-1}{ \V[\u]  \(m^3),}  \V[\n] \(m^3) d' une solution saline et  contiennent alors
  \for{u=1 to \n-1}{\A[\u] \(g),} \A[\n] 
 \(g) de sel.
 Il y a des flux de mlange entre les bidons comme indiqu sur le dessin ci-dessous :
<p align="center">\draw{\size,200}{\dessin} </p>
On note \for{m=1 to \n-1}{<i>A</i><sub>\m</sub> , } \(A_\n)  les quantits de sels respectivement dans chaque bidon  l' instant \(t).
<p>
\if{\step = 1}{On cherche  modliser la situation par un systme diffrentiel vrifi par les fonctions \(A_i) : 
#if #TARGET (solumodel3) || #TARGET(solumodelb)
	<p align="center">\([\dA]  =  U* [\Ap] + B )</p>
	Ecrire les matrices  \(U) et \(B). 
#else
	<p align="center">\([\dA]  =  U* [\Ap]  )</p>
	Ecrire la matrice  \(U).  
#endif
<p><b>Consigne : sparer les lments d' une mme ligne d' une matrice par des virgules ou laisser un blanc.</b>}
#if #TARGET (solflim3) || #TARGET (solferm) || #TARGET (solferm4) || #TARGET (solcirc)  || #TARGET(solcircosc) || #TARGET ( solcascade) 
\if{\step = 2}{On modlise le systme par le systme diffrentiel : 
<p align="center">\([\dA]  =  [\U]* [\Ap])</p>

Voici les courbes solutions du systme diffrentiel (avec conditions initiales donnes) reprsentant \for{m=1 to \n-1}{<i> A<sub>\m</sub> </i>, } \(A_\n): 
<p align="center">  
\draw{300,150}{xrange 0, \tborne
yrange -2,\borne+1
hline 0,0,black
vline 0,0, black
trange 0,\tborne
\plotdata
}
</p>
#if #TARGET (solferm4)
	 Calculer les valeurs limites des quantits de sels dans chaque bidon. 
#endif
#if #TARGET (solcascade)  
Quelle est la couleur de la courbe reprsentant \( A_\k) ? 
<p align="center">\embed{reply2, radio}</p>

Calculer l' instant \(t_0) 
 \if{\choix=1}{o le premier rcipient contient la mme quantit de sels que le rcipient numro \k1 }
{o  la quantit de sels est maximale dans le rcipient numro \k1 }
(si \(t_0) dpasse \tborne, rentrer \tborne).
#endif
#if #TARGET (solflim3) 
 Calculer les drives des fonctions  \(A_i) en \(t = 0). 
#endif
#if #TARGET (solferm)  || #TARGET(solcirc)
 Calculer un vecteur propre non nul de la matrice A  coefficients entiers pour la valeur propre 0. Sachant que la limite de  \(A_1) est \limite[1]..., calculer les limites des autres concentrations.  
#endif
#if #TARGET (solcircosc)
Les concentrations tendent vers une limite. Le font-elles en oscillant ? 
Si oui, donner les valeurs des pseudo-priodes qui peuvent intervenir. Sinon, rentrer 0. 
#endif
 }
#endif
}

#if #TARGET (solumodelb)
\answer{\(U)}{\UU}{type = matrix}
\matrix{UU = \UU}

\text{test = pari(a=if(Mat([\UU])-Mat([\U])==0,1,0) ; a)}
 \condition{}{\test = 1}
\feedback{1=1}{\test}
#else
\answer{\(U)}{\U}{type = matrix}
#endif
#if #TARGET (solumodel3 ) || #TARGET (solumodelb)
	\answer{\(B)}{\B}{type = matrix}
#endif

#if #TARGET (solferm) || #TARGET (solcirc)
	\answer{Vecteur du noyau}{\noyau1}{type =vector}
	\answer{\(A_2(\infty))}{\limite[2]}{type = numeric}
	\answer{\(A_3(\infty))}{\limite[3]}{type = numeric}
	\answer{\(A_4(\infty))}{\limite[4]}{type = numeric}
	\answer{\(A_5(\infty))}{\limite[5]}{type = numeric}

\text{testnoyau=pari( U=Mat([\U]); B=Vec([\reply2]) ; print(if( B<>0 && U*B~==0,1,0)))}
\condition{Vecteur du noyau}{\testnoyau=1}
#endif
#if #TARGET (solferm4)
	\answer{\(A_1(\infty))}{\limite[1]}{type = numeric}
	\answer{\(A_2(\infty))}{\limite[2]}{type = numeric}
	\answer{\(A_3(\infty))}{\limite[3]}{type = numeric}
	\answer{\(A_4(\infty))}{\limite[4]}{type = numeric}
	\answer{\(A_5(\infty))}{\limite[5]}{type = numeric}
#endif
#if #TARGET (solflim3)
	\answer{Pente 1}{\deriv[1]}{type = numeric}
	\answer{Pente 2}{\deriv[2]}{type = numeric}
	\answer{Pente 3}{\deriv[3]}{type = numeric}
	\answer{Pente 4}{\deriv[4]}{type = numeric}
	\answer{Pente 5}{\deriv[5]}{type = numeric}
#endif
#if #TARGET (solcascade)
	\answer{couleur}{\k ; \couleur}{type=radio}
	\answer{\(t_0)}{\t0}{type = numeric}
#endif
#if #TARGET (solcircosc)
\answer{Priodes}{\vpim}{type=aset}
#endif
#if #TARGET (solferm4) ||  #TARGET (solferm) ||#TARGET (solcirc)
	\hint{\if{\step = 1}{L&#39;indication est pour la question 2}
	\if{\step = 2}{Remarquer  que dans le cas d&#39;un  systme ferm, 0 est toujours valeur propre de la matrice associe au systme diffrentiel, la somme totale des sels est constante. Quel est le signe des autres valeurs propres  (ou de leur partie relle) ? Physiquement, ces signes sont imposs ! }}
#endif