target=dist2l3d1 dist2l3d2 dist2l3d3

#include "header.inc"
\integer{dim=3}

#if #TARGET (dist2l3d1)
 \title{Distance between two lines I*}
 \integer{style=1}
#endif
#if #TARGET (dist2l3d2)
 \title{Distance between two lines II*}
 \integer{style=2}
#endif
#if #TARGET (dist2l3d3)
 \title{Distance between two lines III*}
 \integer{style=3}
#endif

\integer{range=30}
\integer{rank=0}
\while{\rank<2}{
    \text{sh=shuffle(\range)}
    \text{mat=random(-,)\sh[1],random(-,)\sh[2],random(-,)\sh[3];
	      random(-,)\sh[4],random(-,)\sh[5],random(-,)\sh[6]}
    \integer{rank=pari(matrank([\mat]))}
}

\integer{x11=random(-\range..\range)*random(-1,1)}
\integer{y11=random(-\range..\range)*random(-1,1)}
\integer{z11=random(-\range..\range)*random(-1,1)}
\integer{x21=random(-\range..\range)*random(-1,1)}
\integer{y21=random(-\range..\range)*random(-1,1)}
\integer{z21=random(-\range..\range)*random(-1,1)}

\integer{x12=\x11+\mat[1;1]}
\integer{y12=\y11+\mat[1;2]}
\integer{z12=\z11+\mat[1;3]}
\integer{x22=\x21+\mat[2;1]}
\integer{y22=\y21+\mat[2;2]}
\integer{z22=\z21+\mat[2;3]}

\text{vec=pari(M=matker([\mat])~;de=denominator(M);print(de*M))}
\integer{d1=\vec[1]*(\x11)+\vec[2]*(\y11)+\vec[3]*(\z11)}
\integer{d2=\vec[1]*(\x21)+\vec[2]*(\y21)+\vec[3]*(\z21)}
\real{dist=abs(\d1-(\d2))/sqrt((\vec[1])^2+(\vec[2])^2+(\vec[3])^2)}

\function{fx1=\mat[1;1]*t + \x11}
\function{fy1=\mat[1;2]*t + \y11}
\function{fz1=\mat[1;3]*t + \z11}
\function{fx2=\mat[2;1]*t + \x21}
\function{fy2=\mat[2;2]*t + \y21}
\function{fz2=\mat[2;3]*t + \z21}

\statement{Compute the distance in \(RR^\dim) between the line
\if{\style < 3}{
    defined by the parametric system <p><center>
      \(x = \fx1), \(y = \fy1) , \(z = \fz1)
}{
    passing through the points <p><center>
      \((\x11 , \y11 , \z11)) and \((\x12 , \y12 , \z12))
}
</center><p>
and the line
\if{\style < 2}{
    defined by the parametric system <p><center>
      \(x = \fx2), \(y = \fy2) , \(z = \fz2)
}{
    passing through the points <p><center>
      \((\x21 , \y21 , \z21)) and \((\x22 , \y22 , \z22))
}
.</center>  
}

\answer{The distance}{\dist}

