/* valagidlparser.c generated by valac, the Vala compiler
 * generated from valagidlparser.vala, do not modify */

/* valagidlparser.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gidlmodule.h>
#include <gidlparser.h>
#include <gidlnode.h>
#include <float.h>
#include <math.h>
#include <gmetadata.h>
#include <stdio.h>


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIdlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaSourceReference* current_source_reference;
	ValaNamespace* current_namespace;
	ValaTypeSymbol* current_data_type;
	ValaMap* codenode_attributes_map;
	ValaMap* codenode_attributes_patterns;
	ValaSet* current_type_symbol_set;
	ValaMap* cname_type_map;
};


static gpointer vala_gidl_parser_parent_class = NULL;
static GRegex* vala_gidl_parser_type_from_string_regex;
static GRegex* vala_gidl_parser_type_from_string_regex = NULL;

GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
#define VALA_GIDL_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIDL_PARSER, ValaGIdlParserPrivate))
void vala_gidl_parser_parse (ValaGIdlParser* self,
                             ValaCodeContext* context);
static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base,
                                            ValaNamespace* ns);
static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base,
                                        ValaClass* cl);
static void vala_gidl_parser_visit_type (ValaGIdlParser* self,
                                  ValaTypeSymbol* t);
static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base,
                                         ValaStruct* st);
static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base,
                                            ValaInterface* iface);
static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base,
                                       ValaEnum* en);
static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base,
                                               ValaErrorDomain* ed);
static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base,
                                           ValaDelegate* d);
static gchar* vala_gidl_parser_get_cname (ValaGIdlParser* self,
                                   ValaSymbol* sym,
                                   ValaSymbol* container);
static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base,
                                              ValaSourceFile* source_file);
static void vala_gidl_parser_parse_file (ValaGIdlParser* self,
                                  ValaSourceFile* source_file);
static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self,
                                              GIdlModule* module);
static void _g_idl_module_free0_ (gpointer var);
static inline void _g_list_free__g_idl_module_free0_ (GList* self);
static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self,
                                       const gchar* type_name,
                                       ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self,
                                         const gchar* codenode,
                                         int* result_length1);
static gchar* vala_gidl_parser_eval (ValaGIdlParser* self,
                              const gchar* s);
gchar* vala_gidl_parser_get_cprefix (ValaGIdlParser* self,
                                     ValaSymbol* sym);
static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self,
                                        const gchar* const_name,
                                        ValaSymbol* container);
static gchar* vala_gidl_parser_get_lower_case_cprefix (ValaGIdlParser* self,
                                                ValaSymbol* sym);
static gchar* vala_gidl_parser_get_cheader_filename (ValaGIdlParser* self,
                                              ValaSymbol* sym);
static gchar* vala_gidl_parser_get_finish_cname (ValaGIdlParser* self,
                                          ValaMethod* m);
static gchar* vala_gidl_parser_get_lower_case_cname (ValaGIdlParser* self,
                                              ValaSymbol* sym);
static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self,
                                                  GIdlNode* node,
                                                  int* result_length1);
static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self,
                                               ValaSymbol* container,
                                               ValaSymbol* sym);
static void vala_gidl_parser_parse_node (ValaGIdlParser* self,
                                  GIdlNode* node,
                                  GIdlModule* module,
                                  ValaSymbol* container);
static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self,
                                               GIdlNodeFunction* f_node);
static void vala_gidl_parser_parse_struct (ValaGIdlParser* self,
                                    GIdlNodeStruct* st_node,
                                    ValaSymbol* container,
                                    GIdlModule* module);
static void vala_gidl_parser_parse_union (ValaGIdlParser* self,
                                   GIdlNodeUnion* un_node,
                                   ValaSymbol* container,
                                   GIdlModule* module);
static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self,
                                   GIdlNodeBoxed* boxed_node,
                                   ValaSymbol* container,
                                   GIdlModule* module);
static void vala_gidl_parser_parse_enum (ValaGIdlParser* self,
                                  GIdlNodeEnum* en_node,
                                  ValaSymbol* container,
                                  GIdlModule* module,
                                  gboolean is_flags);
static void vala_gidl_parser_parse_object (ValaGIdlParser* self,
                                    GIdlNodeInterface* node,
                                    ValaSymbol* container,
                                    GIdlModule* module);
static void vala_gidl_parser_parse_interface (ValaGIdlParser* self,
                                       GIdlNodeInterface* node,
                                       ValaSymbol* container,
                                       GIdlModule* module);
static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self,
                                               GIdlNodeConstant* const_node);
static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self,
                                             GIdlNodeFunction* f,
                                             gboolean is_interface);
static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self,
                                                      const gchar* name);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self,
                                            GIdlNodeParam* param,
                                            ValaParameterDirection* direction);
static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self,
                                                       const gchar* type_string,
                                                       gboolean owned_by_default,
                                                       ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self,
                                                            ValaDataType* parent_type,
                                                            const gchar* type_arguments,
                                                            ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self,
                                              GIdlNodeParam* param);
static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self,
                                           GIdlNodeType* type_node,
                                           ValaParameterDirection* direction);
static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self,
                                             const gchar* cname);
static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self,
                                                  const gchar* n);
static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self,
                                         GIdlNodeField* field_node);
static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self,
                                            GIdlNodeVFunc* v,
                                            GIdlNodeFunction* func,
                                            gboolean is_interface);
static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self,
                                               GIdlNodeProperty* prop_node);
static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self,
                                           GIdlNodeSignal* sig_node);
static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self,
                                            ValaObjectTypeSymbol* type_symbol);
static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self,
                                          const gchar* type_name);
static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self,
                                                                 const gchar* symbol_string,
                                                                 ValaSourceReference* source_reference);
static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self,
                                            const gchar* name,
                                            const gchar* symbol,
                                            GIdlNodeParam* res,
                                            GList* parameters,
                                            gboolean is_constructor,
                                            gboolean is_interface);
static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self,
                                       const gchar* name);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
static void vala_gidl_parser_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Parse all source files in the specified code context and build a
 * code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}


void
vala_gidl_parser_parse (ValaGIdlParser* self,
                        ValaCodeContext* context)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	ValaCodeContext* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = (ValaMap*) _tmp3_;
	_tmp4_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp4_;
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = NULL;
}


static void
vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base,
                                       ValaNamespace* ns)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ns != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
}


static void
vala_gidl_parser_real_visit_class (ValaCodeVisitor* base,
                                   ValaClass* cl)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (cl != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) cl);
}


static void
vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base,
                                    ValaStruct* st)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (st != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) st);
}


static void
vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base,
                                       ValaInterface* iface)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (iface != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) iface);
}


static void
vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base,
                                  ValaEnum* en)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (en != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) en);
}


static void
vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base,
                                          ValaErrorDomain* ed)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ed != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) ed);
}


static void
vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base,
                                      ValaDelegate* d)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (d != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) d);
}


static void
vala_gidl_parser_visit_type (ValaGIdlParser* self,
                             ValaTypeSymbol* t)
{
	ValaMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->cname_type_map;
	_tmp1_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) t, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = !vala_map_contains (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaMap* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->cname_type_map;
		_tmp5_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) t, NULL);
		_tmp6_ = _tmp5_;
		vala_map_set (_tmp4_, _tmp6_, t);
		_g_free0 (_tmp6_);
	}
}


static void
vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base,
                                         ValaSourceFile* source_file)
{
	ValaGIdlParser * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	if (g_str_has_suffix (_tmp1_, ".gi")) {
		vala_gidl_parser_parse_file (self, source_file);
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void
_g_idl_module_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_idl_module_free (var), NULL));
}


static inline void
_g_list_free__g_idl_module_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_idl_module_free0_);
}


static void
vala_gidl_parser_parse_file (ValaGIdlParser* self,
                             ValaSourceFile* source_file)
{
	gchar* metadata_filename = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValaSourceFile* _tmp12_;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GEqualFunc _tmp15_;
	ValaHashMap* _tmp16_;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	ValaHashMap* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_source_file_get_filename (source_file);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (".gi");
	_tmp7_ = _tmp6_;
	_tmp8_ = string_substring (_tmp1_, (glong) 0, (glong) (_tmp5_ - _tmp7_));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%s.metadata", _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	metadata_filename = _tmp11_;
	_tmp12_ = _vala_source_file_ref0 (source_file);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp12_;
	_tmp13_ = g_str_hash;
	_tmp14_ = g_str_equal;
	_tmp15_ = g_direct_equal;
	_tmp16_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp13_, _tmp14_, _tmp15_);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	self->priv->codenode_attributes_map = (ValaMap*) _tmp16_;
	_tmp17_ = g_direct_hash;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_hash_map_new (G_TYPE_POINTER, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp17_, (GEqualFunc) g_pattern_spec_equal, _tmp18_);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	self->priv->codenode_attributes_patterns = (ValaMap*) _tmp19_;
	_tmp20_ = metadata_filename;
	if (g_file_test (_tmp20_, G_FILE_TEST_EXISTS)) {
		{
			gchar* metadata = NULL;
			const gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gchar** _tmp25_;
			_tmp21_ = metadata_filename;
			g_file_get_contents (_tmp21_, &_tmp22_, NULL, &_inner_error0_);
			_g_free0 (metadata);
			metadata = _tmp22_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (metadata);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (metadata_filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp23_ = metadata;
			_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "\n", 0);
			{
				gchar** line_collection = NULL;
				gint line_collection_length1 = 0;
				gint _line_collection_size_ = 0;
				gint line_it = 0;
				line_collection = _tmp25_;
				line_collection_length1 = _vala_array_length (_tmp24_);
				for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
					const gchar* line = NULL;
					line = line_collection[line_it];
					{
						const gchar* _tmp26_;
						gchar** tokens = NULL;
						const gchar* _tmp27_;
						gchar** _tmp28_;
						gchar** _tmp29_;
						gint tokens_length1;
						gint _tokens_size_;
						gchar** _tmp30_;
						gint _tmp30__length1;
						const gchar* _tmp31_;
						gchar** _tmp32_;
						gint _tmp32__length1;
						const gchar* _tmp33_;
						ValaMap* _tmp41_;
						gchar** _tmp42_;
						gint _tmp42__length1;
						const gchar* _tmp43_;
						gchar** _tmp44_;
						gint _tmp44__length1;
						const gchar* _tmp45_;
						_tmp26_ = line;
						if (g_str_has_prefix (_tmp26_, "#")) {
							continue;
						}
						_tmp27_ = line;
						_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, " ", 2);
						tokens = _tmp29_;
						tokens_length1 = _vala_array_length (_tmp28_);
						_tokens_size_ = tokens_length1;
						_tmp30_ = tokens;
						_tmp30__length1 = tokens_length1;
						_tmp31_ = _tmp30_[0];
						if (NULL == _tmp31_) {
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							continue;
						}
						_tmp32_ = tokens;
						_tmp32__length1 = tokens_length1;
						_tmp33_ = _tmp32_[0];
						if (-1 != string_index_of_char (_tmp33_, (gunichar) '*', 0)) {
							GPatternSpec* pattern = NULL;
							gchar** _tmp34_;
							gint _tmp34__length1;
							const gchar* _tmp35_;
							GPatternSpec* _tmp36_;
							ValaMap* _tmp37_;
							GPatternSpec* _tmp38_;
							gchar** _tmp39_;
							gint _tmp39__length1;
							const gchar* _tmp40_;
							_tmp34_ = tokens;
							_tmp34__length1 = tokens_length1;
							_tmp35_ = _tmp34_[0];
							_tmp36_ = g_pattern_spec_new (_tmp35_);
							pattern = _tmp36_;
							_tmp37_ = self->priv->codenode_attributes_patterns;
							_tmp38_ = pattern;
							_tmp39_ = tokens;
							_tmp39__length1 = tokens_length1;
							_tmp40_ = _tmp39_[0];
							vala_map_set (_tmp37_, _tmp38_, _tmp40_);
						}
						_tmp41_ = self->priv->codenode_attributes_map;
						_tmp42_ = tokens;
						_tmp42__length1 = tokens_length1;
						_tmp43_ = _tmp42_[0];
						_tmp44_ = tokens;
						_tmp44__length1 = tokens_length1;
						_tmp45_ = _tmp44_[1];
						vala_map_set (_tmp41_, _tmp43_, _tmp45_);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (metadata);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp46_ = e;
			_tmp47_ = _tmp46_->message;
			_tmp48_ = g_strdup_printf ("Unable to read metadata file: %s", _tmp47_);
			_tmp49_ = _tmp48_;
			vala_report_error (NULL, _tmp49_);
			_g_free0 (_tmp49_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GList* modules = NULL;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		GList* _tmp52_;
		ValaSourceLocation _tmp53_ = {0};
		ValaSourceLocation _tmp54_ = {0};
		ValaSourceReference* _tmp55_;
		_tmp50_ = vala_source_file_get_filename (source_file);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_idl_parse_file (_tmp51_, &_inner_error0_);
		modules = _tmp52_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch1_g_markup_error;
			}
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		vala_source_location_init (&_tmp53_, NULL, 0, 0);
		vala_source_location_init (&_tmp54_, NULL, 0, 0);
		_tmp55_ = vala_source_reference_new (source_file, &_tmp53_, &_tmp54_);
		_vala_source_reference_unref0 (self->priv->current_source_reference);
		self->priv->current_source_reference = _tmp55_;
		{
			GList* module_collection = NULL;
			GList* module_it = NULL;
			module_collection = modules;
			for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
				GIdlModule* module = NULL;
				module = (GIdlModule*) module_it->data;
				{
					ValaNamespace* ns = NULL;
					GIdlModule* _tmp56_;
					ValaNamespace* _tmp57_;
					ValaNamespace* _tmp58_;
					_tmp56_ = module;
					_tmp57_ = vala_gidl_parser_parse_module (self, _tmp56_);
					ns = _tmp57_;
					_tmp58_ = ns;
					if (_tmp58_ != NULL) {
						ValaCodeContext* _tmp59_;
						ValaNamespace* _tmp60_;
						ValaNamespace* _tmp61_;
						ValaNamespace* _tmp62_;
						_tmp59_ = self->priv->context;
						_tmp60_ = vala_code_context_get_root (_tmp59_);
						_tmp61_ = _tmp60_;
						_tmp62_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp61_, _tmp62_);
					}
					_vala_code_node_unref0 (ns);
				}
			}
		}
		(modules == NULL) ? NULL : (modules = (_g_list_free__g_idl_module_free0_ (modules), NULL));
	}
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp63_ = e;
		_tmp64_ = _tmp63_->message;
		_tmp65_ = g_strdup_printf ("Unable to parse GIDL file: %s", _tmp64_);
		_tmp66_ = _tmp65_;
		vala_report_error (NULL, _tmp66_);
		_g_free0 (_tmp66_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (metadata_filename);
}


static gchar*
vala_gidl_parser_fix_type_name (ValaGIdlParser* self,
                                const gchar* type_name,
                                ValaSymbol* container)
{
	gchar* result = NULL;
	gchar** attributes = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp1_ = vala_gidl_parser_get_attributes (self, type_name, &_tmp0_);
	attributes = _tmp1_;
	attributes_length1 = _tmp0_;
	_attributes_size_ = attributes_length1;
	_tmp2_ = attributes;
	_tmp2__length1 = attributes_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp3_;
			attr_collection_length1 = _tmp3__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp4_;
				gchar* attr = NULL;
				_tmp4_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp4_;
				{
					gchar** nv = NULL;
					const gchar* _tmp5_;
					gchar** _tmp6_;
					gchar** _tmp7_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					_tmp5_ = attr;
					_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "=", 2);
					nv = _tmp7_;
					nv_length1 = _vala_array_length (_tmp6_);
					_nv_size_ = nv_length1;
					_tmp8_ = nv;
					_tmp8__length1 = nv_length1;
					_tmp9_ = _tmp8_[0];
					if (g_strcmp0 (_tmp9_, "name") == 0) {
						gchar** _tmp10_;
						gint _tmp10__length1;
						const gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp10_ = nv;
						_tmp10__length1 = nv_length1;
						_tmp11_ = _tmp10_[1];
						_tmp12_ = vala_gidl_parser_eval (self, _tmp11_);
						result = _tmp12_;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp13_ = vala_symbol_get_name (container);
	_tmp14_ = _tmp13_;
	if (g_str_has_prefix (type_name, _tmp14_)) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
		_tmp15_ = vala_symbol_get_name (container);
		_tmp16_ = _tmp15_;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_substring (type_name, (glong) _tmp18_, (glong) -1);
		result = _tmp19_;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gchar* cprefix = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = vala_gidl_parser_get_cprefix (self, container);
		cprefix = _tmp20_;
		_tmp21_ = cprefix;
		if (g_str_has_prefix (type_name, _tmp21_)) {
			const gchar* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gchar* _tmp25_;
			_tmp22_ = cprefix;
			_tmp23_ = strlen (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = string_substring (type_name, (glong) _tmp24_, (glong) -1);
			result = _tmp25_;
			_g_free0 (cprefix);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_free0 (cprefix);
	}
	_tmp26_ = g_strdup (type_name);
	result = _tmp26_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar*
vala_gidl_parser_fix_const_name (ValaGIdlParser* self,
                                 const gchar* const_name,
                                 ValaSymbol* container)
{
	gchar* result = NULL;
	gchar* pref = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = vala_gidl_parser_get_lower_case_cprefix (self, container);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	pref = _tmp3_;
	_tmp4_ = pref;
	if (g_str_has_prefix (const_name, _tmp4_)) {
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = pref;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_substring (const_name, (glong) _tmp7_, (glong) -1);
		result = _tmp8_;
		_g_free0 (pref);
		return result;
	}
	_tmp9_ = g_strdup (const_name);
	result = _tmp9_;
	_g_free0 (pref);
	return result;
}


static gchar*
vala_gidl_parser_get_cheader_filename (ValaGIdlParser* self,
                                       ValaSymbol* sym)
{
	gchar* result = NULL;
	gchar* cheader_filename = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "cheader_filename", NULL);
	cheader_filename = _tmp0_;
	_tmp1_ = cheader_filename;
	if (_tmp1_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp2_ = vala_symbol_get_parent_symbol (sym);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = vala_symbol_get_parent_symbol (sym);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_gidl_parser_get_cheader_filename (self, _tmp5_);
		result = _tmp6_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != NULL) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaSourceFile* _tmp11_;
			ValaSourceFile* _tmp12_;
			gchar* _tmp13_;
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_source_reference_get_file (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_source_file_get_cinclude_filename (_tmp12_);
			result = _tmp13_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp14_ = g_strdup ("");
	result = _tmp14_;
	_g_free0 (cheader_filename);
	return result;
}


static gchar*
vala_gidl_parser_get_cname (ValaGIdlParser* self,
                            ValaSymbol* sym,
                            ValaSymbol* container)
{
	gchar* result = NULL;
	gchar* cname = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	if (container == NULL) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		_tmp0_ = vala_symbol_get_parent_symbol (sym);
		_tmp1_ = _tmp0_;
		container = _tmp1_;
	}
	_tmp2_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "cname", NULL);
	cname = _tmp2_;
	_tmp3_ = cname;
	if (_tmp3_ != NULL) {
		result = cname;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
		gchar* name = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = vala_symbol_get_name (sym);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		name = _tmp6_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CREATION_METHOD)) {
			gboolean _tmp7_ = FALSE;
			const gchar* _tmp8_;
			_tmp8_ = name;
			if (_tmp8_ == NULL) {
				_tmp7_ = TRUE;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = name;
				_tmp7_ = g_strcmp0 (_tmp9_, ".new") == 0;
			}
			if (_tmp7_) {
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("new");
				_g_free0 (name);
				name = _tmp10_;
			} else {
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = name;
				_tmp12_ = g_strdup_printf ("new_%s", _tmp11_);
				_g_free0 (name);
				name = _tmp12_;
			}
		}
		if (container != NULL) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp13_ = vala_gidl_parser_get_lower_case_cprefix (self, container);
			_tmp14_ = _tmp13_;
			_tmp15_ = name;
			_tmp16_ = g_strdup_printf ("%s%s", _tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			_g_free0 (name);
			_g_free0 (cname);
			return result;
		} else {
			result = name;
			_g_free0 (cname);
			return result;
		}
		_g_free0 (name);
	} else {
		if (container != NULL) {
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp18_ = vala_gidl_parser_get_cprefix (self, container);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_symbol_get_name (sym);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup_printf ("%s%s", _tmp19_, _tmp21_);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp19_);
			result = _tmp23_;
			_g_free0 (cname);
			return result;
		} else {
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp24_ = vala_symbol_get_name (sym);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup (_tmp25_);
			result = _tmp26_;
			_g_free0 (cname);
			return result;
		}
	}
	_g_free0 (cname);
}


static gchar*
vala_gidl_parser_get_finish_cname (ValaGIdlParser* self,
                                   ValaMethod* m)
{
	gchar* result = NULL;
	gchar* finish_cname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) m, "CCode", "finish_name", NULL);
	finish_cname = _tmp0_;
	_tmp1_ = finish_cname;
	if (_tmp1_ != NULL) {
		result = finish_cname;
		return result;
	}
	_tmp2_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) m, NULL);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (g_str_has_suffix (_tmp3_, "_async")) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = _result_;
		_tmp5_ = _result_;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = strlen ("_async");
		_tmp9_ = _tmp8_;
		_tmp10_ = string_substring (_tmp4_, (glong) 0, (glong) (_tmp7_ - _tmp9_));
		_g_free0 (_result_);
		_result_ = _tmp10_;
	}
	_tmp11_ = _result_;
	_tmp12_ = g_strconcat (_tmp11_, "_finish", NULL);
	result = _tmp12_;
	_g_free0 (_result_);
	_g_free0 (finish_cname);
	return result;
}


static gchar*
vala_gidl_parser_get_lower_case_cname (ValaGIdlParser* self,
                                       ValaSymbol* sym)
{
	gchar* result = NULL;
	gchar* lower_case_csuffix = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	ValaSymbol* _tmp27_;
	ValaSymbol* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_symbol_get_name (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_camel_case_to_lower_case (_tmp1_);
	lower_case_csuffix = _tmp2_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		const gchar* _tmp3_;
		const gchar* _tmp17_;
		_tmp3_ = lower_case_csuffix;
		if (g_str_has_prefix (_tmp3_, "type_")) {
			const gchar* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp4_ = lower_case_csuffix;
			_tmp5_ = strlen ("type_");
			_tmp6_ = _tmp5_;
			_tmp7_ = string_substring (_tmp4_, (glong) _tmp6_, (glong) -1);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat ("type", _tmp8_, NULL);
			_g_free0 (lower_case_csuffix);
			lower_case_csuffix = _tmp9_;
			_g_free0 (_tmp8_);
		} else {
			const gchar* _tmp10_;
			_tmp10_ = lower_case_csuffix;
			if (g_str_has_prefix (_tmp10_, "is_")) {
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp11_ = lower_case_csuffix;
				_tmp12_ = strlen ("is_");
				_tmp13_ = _tmp12_;
				_tmp14_ = string_substring (_tmp11_, (glong) _tmp13_, (glong) -1);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat ("is", _tmp15_, NULL);
				_g_free0 (lower_case_csuffix);
				lower_case_csuffix = _tmp16_;
				_g_free0 (_tmp15_);
			}
		}
		_tmp17_ = lower_case_csuffix;
		if (g_str_has_suffix (_tmp17_, "_class")) {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp18_ = lower_case_csuffix;
			_tmp19_ = lower_case_csuffix;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = strlen ("_class");
			_tmp23_ = _tmp22_;
			_tmp24_ = string_substring (_tmp18_, (glong) 0, (glong) (_tmp21_ - _tmp23_));
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp25_, "class", NULL);
			_g_free0 (lower_case_csuffix);
			lower_case_csuffix = _tmp26_;
			_g_free0 (_tmp25_);
		}
	}
	_tmp27_ = vala_symbol_get_parent_symbol (sym);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp29_ = vala_symbol_get_parent_symbol (sym);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = lower_case_csuffix;
		_tmp34_ = g_strdup_printf ("%s%s", _tmp32_, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp32_);
		result = _tmp35_;
		_g_free0 (lower_case_csuffix);
		return result;
	} else {
		result = lower_case_csuffix;
		return result;
	}
	_g_free0 (lower_case_csuffix);
}


static gchar*
vala_gidl_parser_get_lower_case_cprefix (ValaGIdlParser* self,
                                         ValaSymbol* sym)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* cprefix = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_symbol_get_name (sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "lower_case_cprefix", NULL);
	_g_free0 (cprefix);
	cprefix = _tmp3_;
	_tmp5_ = cprefix;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT);
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp7_;
		_tmp7_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "cprefix", NULL);
		_g_free0 (cprefix);
		cprefix = _tmp7_;
	}
	_tmp8_ = cprefix;
	if (_tmp8_ != NULL) {
		result = cprefix;
		return result;
	}
	_tmp9_ = vala_gidl_parser_get_lower_case_cname (self, sym);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, "_", NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	result = _tmp12_;
	_g_free0 (cprefix);
	return result;
}


gchar*
vala_gidl_parser_get_cprefix (ValaGIdlParser* self,
                              ValaSymbol* sym)
{
	gchar* result = NULL;
	gchar* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		gchar* _tmp0_;
		_tmp0_ = vala_gidl_parser_get_cname (self, sym, NULL);
		result = _tmp0_;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN);
		}
		if (_tmp1_) {
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp2_ = vala_gidl_parser_get_lower_case_cname (self, sym);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_ascii_strup (_tmp3_, (gssize) -1);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("%s_", _tmp5_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			_g_free0 (_tmp3_);
			result = _tmp7_;
			return result;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = vala_symbol_get_name (sym);
				_tmp9_ = _tmp8_;
				if (_tmp9_ != NULL) {
					gchar* cprefix = NULL;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					ValaSymbol* _tmp12_;
					ValaSymbol* _tmp13_;
					_tmp10_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "cprefix", NULL);
					cprefix = _tmp10_;
					_tmp11_ = cprefix;
					if (_tmp11_ != NULL) {
						result = cprefix;
						return result;
					}
					_tmp12_ = vala_symbol_get_parent_symbol (sym);
					_tmp13_ = _tmp12_;
					if (_tmp13_ != NULL) {
						ValaSymbol* _tmp14_;
						ValaSymbol* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp14_ = vala_symbol_get_parent_symbol (sym);
						_tmp15_ = _tmp14_;
						_tmp16_ = vala_gidl_parser_get_cprefix (self, _tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = vala_symbol_get_name (sym);
						_tmp19_ = _tmp18_;
						_tmp20_ = g_strdup_printf ("%s%s", _tmp17_, _tmp19_);
						_tmp21_ = _tmp20_;
						_g_free0 (_tmp17_);
						result = _tmp21_;
						_g_free0 (cprefix);
						return result;
					} else {
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp22_ = vala_symbol_get_name (sym);
						_tmp23_ = _tmp22_;
						_tmp24_ = g_strdup (_tmp23_);
						result = _tmp24_;
						_g_free0 (cprefix);
						return result;
					}
					_g_free0 (cprefix);
				} else {
					gchar* _tmp25_;
					_tmp25_ = g_strdup ("");
					result = _tmp25_;
					return result;
				}
			} else {
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp26_ = vala_symbol_get_name (sym);
				_tmp27_ = _tmp26_;
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp28_ = vala_symbol_get_name (sym);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strdup (_tmp29_);
					result = _tmp30_;
					return result;
				}
			}
		}
	}
	_tmp31_ = g_strdup ("");
	result = _tmp31_;
	return result;
}


static gchar**
vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self,
                                          GIdlNode* node,
                                          int* result_length1)
{
	gchar** result = NULL;
	gchar* name = NULL;
	GIdlNodeTypeId _tmp0_;
	const gchar* _tmp23_;
	gint _tmp24_ = 0;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node->type;
	if (_tmp0_ == G_IDL_NODE_FUNCTION) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = ((GIdlNodeFunction*) node)->symbol;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (name);
		name = _tmp2_;
	} else {
		GIdlNodeTypeId _tmp3_;
		_tmp3_ = node->type;
		if (_tmp3_ == G_IDL_NODE_SIGNAL) {
			ValaTypeSymbol* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp4_ = self->priv->current_data_type;
			_tmp5_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp4_, NULL);
			_tmp6_ = _tmp5_;
			_tmp7_ = node->name;
			_tmp8_ = g_strdup_printf ("%s::%s", _tmp6_, _tmp7_);
			_g_free0 (name);
			name = _tmp8_;
			_g_free0 (_tmp6_);
		} else {
			GIdlNodeTypeId _tmp9_;
			_tmp9_ = node->type;
			if (_tmp9_ == G_IDL_NODE_PROPERTY) {
				ValaTypeSymbol* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp10_ = self->priv->current_data_type;
				_tmp11_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = node->name;
				_tmp14_ = g_strdup_printf ("%s:%s", _tmp12_, _tmp13_);
				_g_free0 (name);
				name = _tmp14_;
				_g_free0 (_tmp12_);
			} else {
				GIdlNodeTypeId _tmp15_;
				_tmp15_ = node->type;
				if (_tmp15_ == G_IDL_NODE_FIELD) {
					ValaTypeSymbol* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp16_ = self->priv->current_data_type;
					_tmp17_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp16_, NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = node->name;
					_tmp20_ = g_strdup_printf ("%s.%s", _tmp18_, _tmp19_);
					_g_free0 (name);
					name = _tmp20_;
					_g_free0 (_tmp18_);
				} else {
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp21_ = node->name;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (name);
					name = _tmp22_;
				}
			}
		}
	}
	_tmp23_ = name;
	_tmp25_ = vala_gidl_parser_get_attributes (self, _tmp23_, &_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp26__length1 = _tmp24_;
	if (result_length1) {
		*result_length1 = _tmp26__length1;
	}
	result = _tmp26_;
	_g_free0 (name);
	return result;
}


static void
vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self,
                                          ValaSymbol* container,
                                          ValaSymbol* sym)
{
	gboolean _tmp34_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		cl = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_CLASS, ValaClass);
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
			ValaClass* _tmp0_;
			_tmp0_ = cl;
			vala_symbol_add_class ((ValaSymbol*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
				ValaClass* _tmp1_;
				_tmp1_ = cl;
				vala_symbol_add_constant ((ValaSymbol*) _tmp1_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
					ValaClass* _tmp2_;
					_tmp2_ = cl;
					vala_symbol_add_enum ((ValaSymbol*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
						ValaClass* _tmp3_;
						_tmp3_ = cl;
						vala_symbol_add_field ((ValaSymbol*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
							ValaClass* _tmp4_;
							_tmp4_ = cl;
							vala_symbol_add_method ((ValaSymbol*) _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
								ValaClass* _tmp5_;
								_tmp5_ = cl;
								vala_symbol_add_property ((ValaSymbol*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
									ValaClass* _tmp6_;
									_tmp6_ = cl;
									vala_symbol_add_signal ((ValaSymbol*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
										ValaClass* _tmp7_;
										_tmp7_ = cl;
										vala_symbol_add_struct ((ValaSymbol*) _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			en = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ENUM, ValaEnum);
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM_VALUE)) {
				ValaEnum* _tmp8_;
				_tmp8_ = en;
				vala_enum_add_value (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
					ValaEnum* _tmp9_;
					_tmp9_ = en;
					vala_symbol_add_constant ((ValaSymbol*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
						ValaEnum* _tmp10_;
						_tmp10_ = en;
						vala_symbol_add_method ((ValaSymbol*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_INTERFACE)) {
				ValaInterface* iface = NULL;
				iface = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_INTERFACE, ValaInterface);
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
					ValaInterface* _tmp11_;
					_tmp11_ = iface;
					vala_symbol_add_class ((ValaSymbol*) _tmp11_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
						ValaInterface* _tmp12_;
						_tmp12_ = iface;
						vala_symbol_add_constant ((ValaSymbol*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
							ValaInterface* _tmp13_;
							_tmp13_ = iface;
							vala_symbol_add_enum ((ValaSymbol*) _tmp13_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								ValaInterface* _tmp14_;
								_tmp14_ = iface;
								vala_symbol_add_field ((ValaSymbol*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaInterface* _tmp15_;
									_tmp15_ = iface;
									vala_symbol_add_method ((ValaSymbol*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										ValaInterface* _tmp16_;
										_tmp16_ = iface;
										vala_symbol_add_property ((ValaSymbol*) _tmp16_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
											ValaInterface* _tmp17_;
											_tmp17_ = iface;
											vala_symbol_add_signal ((ValaSymbol*) _tmp17_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
												ValaInterface* _tmp18_;
												_tmp18_ = iface;
												vala_symbol_add_struct ((ValaSymbol*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_NAMESPACE)) {
					ValaNamespace* ns = NULL;
					ns = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_NAMESPACE, ValaNamespace);
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
						ValaNamespace* _tmp19_;
						_tmp19_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp19_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
							ValaNamespace* _tmp20_;
							_tmp20_ = ns;
							vala_symbol_add_class ((ValaSymbol*) _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
								ValaNamespace* _tmp21_;
								_tmp21_ = ns;
								vala_symbol_add_constant ((ValaSymbol*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE)) {
									ValaNamespace* _tmp22_;
									_tmp22_ = ns;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp22_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
										ValaNamespace* _tmp23_;
										_tmp23_ = ns;
										vala_symbol_add_enum ((ValaSymbol*) _tmp23_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN)) {
											ValaNamespace* _tmp24_;
											_tmp24_ = ns;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
												ValaNamespace* _tmp25_;
												_tmp25_ = ns;
												vala_symbol_add_field ((ValaSymbol*) _tmp25_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
											} else {
												if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_INTERFACE)) {
													ValaNamespace* _tmp26_;
													_tmp26_ = ns;
													vala_symbol_add_interface ((ValaSymbol*) _tmp26_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
														ValaNamespace* _tmp27_;
														_tmp27_ = ns;
														vala_symbol_add_method ((ValaSymbol*) _tmp27_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
													} else {
														if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
															ValaNamespace* _tmp28_;
															_tmp28_ = ns;
															vala_symbol_add_namespace ((ValaSymbol*) _tmp28_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
														} else {
															if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
																ValaNamespace* _tmp29_;
																_tmp29_ = ns;
																vala_symbol_add_struct ((ValaSymbol*) _tmp29_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_STRUCT)) {
						ValaStruct* st = NULL;
						st = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_STRUCT, ValaStruct);
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
							ValaStruct* _tmp30_;
							_tmp30_ = st;
							vala_symbol_add_constant ((ValaSymbol*) _tmp30_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								ValaStruct* _tmp31_;
								_tmp31_ = st;
								vala_symbol_add_field ((ValaSymbol*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaStruct* _tmp32_;
									_tmp32_ = st;
									vala_symbol_add_method ((ValaSymbol*) _tmp32_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										ValaStruct* _tmp33_;
										_tmp33_ = st;
										vala_symbol_add_property ((ValaSymbol*) _tmp33_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (!G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
		_tmp34_ = G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_NAMESPACE);
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp35_ = vala_gidl_parser_get_cheader_filename (self, sym);
		_tmp36_ = _tmp35_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "cheader_filename", _tmp36_, NULL);
		_g_free0 (_tmp36_);
	}
}


static void
vala_gidl_parser_parse_node (ValaGIdlParser* self,
                             GIdlNode* node,
                             GIdlModule* module,
                             ValaSymbol* container)
{
	GIdlNodeTypeId _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (module != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = node->type;
	if (_tmp0_ == G_IDL_NODE_CALLBACK) {
		ValaDelegate* cb = NULL;
		ValaDelegate* _tmp1_;
		ValaDelegate* _tmp2_;
		ValaDelegate* _tmp3_;
		ValaDelegate* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		ValaDelegate* _tmp9_;
		ValaSourceFile* _tmp10_;
		ValaDelegate* _tmp11_;
		_tmp1_ = vala_gidl_parser_parse_delegate (self, (GIdlNodeFunction*) node);
		cb = _tmp1_;
		_tmp2_ = cb;
		if (_tmp2_ == NULL) {
			_vala_code_node_unref0 (cb);
			return;
		}
		_tmp3_ = cb;
		_tmp4_ = cb;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_gidl_parser_fix_type_name (self, _tmp6_, container);
		_tmp8_ = _tmp7_;
		vala_symbol_set_name ((ValaSymbol*) _tmp3_, _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = cb;
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp9_);
		_tmp10_ = self->priv->current_source_file;
		_tmp11_ = cb;
		vala_source_file_add_node (_tmp10_, (ValaCodeNode*) _tmp11_);
		_vala_code_node_unref0 (cb);
	} else {
		GIdlNodeTypeId _tmp12_;
		_tmp12_ = node->type;
		if (_tmp12_ == G_IDL_NODE_STRUCT) {
			vala_gidl_parser_parse_struct (self, (GIdlNodeStruct*) node, container, module);
		} else {
			GIdlNodeTypeId _tmp13_;
			_tmp13_ = node->type;
			if (_tmp13_ == G_IDL_NODE_UNION) {
				vala_gidl_parser_parse_union (self, (GIdlNodeUnion*) node, container, module);
			} else {
				GIdlNodeTypeId _tmp14_;
				_tmp14_ = node->type;
				if (_tmp14_ == G_IDL_NODE_BOXED) {
					vala_gidl_parser_parse_boxed (self, (GIdlNodeBoxed*) node, container, module);
				} else {
					GIdlNodeTypeId _tmp15_;
					_tmp15_ = node->type;
					if (_tmp15_ == G_IDL_NODE_ENUM) {
						vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, FALSE);
					} else {
						GIdlNodeTypeId _tmp16_;
						_tmp16_ = node->type;
						if (_tmp16_ == G_IDL_NODE_FLAGS) {
							vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, TRUE);
						} else {
							GIdlNodeTypeId _tmp17_;
							_tmp17_ = node->type;
							if (_tmp17_ == G_IDL_NODE_OBJECT) {
								vala_gidl_parser_parse_object (self, (GIdlNodeInterface*) node, container, module);
							} else {
								GIdlNodeTypeId _tmp18_;
								_tmp18_ = node->type;
								if (_tmp18_ == G_IDL_NODE_INTERFACE) {
									vala_gidl_parser_parse_interface (self, (GIdlNodeInterface*) node, container, module);
								} else {
									GIdlNodeTypeId _tmp19_;
									_tmp19_ = node->type;
									if (_tmp19_ == G_IDL_NODE_CONSTANT) {
										ValaConstant* c = NULL;
										ValaConstant* _tmp20_;
										ValaConstant* _tmp21_;
										_tmp20_ = vala_gidl_parser_parse_constant (self, (GIdlNodeConstant*) node);
										c = _tmp20_;
										_tmp21_ = c;
										if (_tmp21_ != NULL) {
											ValaConstant* _tmp22_;
											ValaConstant* _tmp23_;
											const gchar* _tmp24_;
											const gchar* _tmp25_;
											gchar* _tmp26_;
											gchar* _tmp27_;
											ValaConstant* _tmp28_;
											ValaSourceFile* _tmp29_;
											ValaConstant* _tmp30_;
											_tmp22_ = c;
											_tmp23_ = c;
											_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
											_tmp25_ = _tmp24_;
											_tmp26_ = vala_gidl_parser_fix_const_name (self, _tmp25_, container);
											_tmp27_ = _tmp26_;
											vala_symbol_set_name ((ValaSymbol*) _tmp22_, _tmp27_);
											_g_free0 (_tmp27_);
											_tmp28_ = c;
											vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp28_);
											_tmp29_ = self->priv->current_source_file;
											_tmp30_ = c;
											vala_source_file_add_node (_tmp29_, (ValaCodeNode*) _tmp30_);
										}
										_vala_code_node_unref0 (c);
									} else {
										GIdlNodeTypeId _tmp31_;
										_tmp31_ = node->type;
										if (_tmp31_ == G_IDL_NODE_FUNCTION) {
											ValaMethod* m = NULL;
											ValaMethod* _tmp32_;
											ValaMethod* _tmp33_;
											_tmp32_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) node, FALSE);
											m = _tmp32_;
											_tmp33_ = m;
											if (_tmp33_ != NULL) {
												ValaMethod* _tmp34_;
												ValaMethod* _tmp35_;
												ValaSourceFile* _tmp36_;
												ValaMethod* _tmp37_;
												_tmp34_ = m;
												vala_method_set_binding (_tmp34_, VALA_MEMBER_BINDING_STATIC);
												_tmp35_ = m;
												vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp35_);
												_tmp36_ = self->priv->current_source_file;
												_tmp37_ = m;
												vala_source_file_add_node (_tmp36_, (ValaCodeNode*) _tmp37_);
											}
											_vala_code_node_unref0 (m);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaSymbol*
vala_gidl_parser_get_container_from_name (ValaGIdlParser* self,
                                          const gchar* name)
{
	ValaSymbol* result = NULL;
	gchar** path = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint path_length1;
	gint _path_size_;
	ValaSymbol* cp = NULL;
	ValaNamespace* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaCodeContext* _tmp7_;
	ValaNamespace* _tmp8_;
	ValaNamespace* _tmp9_;
	ValaSymbol* cc = NULL;
	gchar** _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (name, ".", 0);
	path = _tmp1_;
	path_length1 = _vala_array_length (_tmp0_);
	_path_size_ = path_length1;
	_tmp2_ = self->priv->current_namespace;
	_tmp3_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp2_);
	cp = _tmp3_;
	_tmp4_ = cp;
	_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->context;
	_tmp8_ = vala_code_context_get_root (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp6_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_SYMBOL, ValaSymbol)) {
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		_tmp10_ = cp;
		_tmp11_ = vala_symbol_get_parent_symbol (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (_tmp12_);
		_vala_code_node_unref0 (cp);
		cp = _tmp13_;
	}
	cc = NULL;
	_tmp14_ = path;
	_tmp14__length1 = path_length1;
	{
		gchar** tok_collection = NULL;
		gint tok_collection_length1 = 0;
		gint _tok_collection_size_ = 0;
		gint tok_it = 0;
		tok_collection = _tmp14_;
		tok_collection_length1 = _tmp14__length1;
		for (tok_it = 0; tok_it < tok_collection_length1; tok_it = tok_it + 1) {
			const gchar* tok = NULL;
			tok = tok_collection[tok_it];
			{
				ValaSymbol* _tmp15_;
				ValaScope* _tmp16_;
				ValaScope* _tmp17_;
				const gchar* _tmp18_;
				ValaSymbol* _tmp19_;
				ValaSymbol* _tmp20_;
				ValaSymbol* _tmp21_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				_tmp15_ = cp;
				_tmp16_ = vala_symbol_get_scope (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = tok;
				_tmp19_ = vala_scope_lookup (_tmp17_, _tmp18_);
				_tmp20_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_SYMBOL) ? ((ValaSymbol*) _tmp19_) : NULL;
				if (_tmp20_ == NULL) {
					_vala_code_node_unref0 (_tmp19_);
				}
				_vala_code_node_unref0 (cc);
				cc = _tmp20_;
				_tmp21_ = cc;
				if (_tmp21_ == NULL) {
					const gchar* _tmp22_;
					ValaSourceReference* _tmp23_;
					ValaNamespace* _tmp24_;
					ValaSymbol* _tmp25_;
					ValaSymbol* _tmp26_;
					_tmp22_ = tok;
					_tmp23_ = self->priv->current_source_reference;
					_tmp24_ = vala_namespace_new (_tmp22_, _tmp23_);
					_vala_code_node_unref0 (cc);
					cc = (ValaSymbol*) _tmp24_;
					_tmp25_ = cp;
					_tmp26_ = cc;
					vala_gidl_parser_add_symbol_to_container (self, _tmp25_, _tmp26_);
				}
				_tmp27_ = cc;
				_tmp28_ = _vala_code_node_ref0 (_tmp27_);
				_vala_code_node_unref0 (cp);
				cp = _tmp28_;
			}
		}
	}
	result = cc;
	_vala_code_node_unref0 (cp);
	path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaNamespace*
vala_gidl_parser_parse_module (ValaGIdlParser* self,
                               GIdlModule* module)
{
	ValaNamespace* result = NULL;
	ValaSymbol* sym = NULL;
	ValaCodeContext* _tmp0_;
	ValaNamespace* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	const gchar* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaNamespace* ns = NULL;
	ValaSymbol* _tmp7_;
	ValaNamespace* _tmp19_;
	ValaNamespace* _tmp20_;
	gchar** attributes = NULL;
	ValaNamespace* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_ = 0;
	gchar** _tmp25_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	ValaArrayList* deferred = NULL;
	GEqualFunc _tmp107_;
	ValaArrayList* _tmp108_;
	GList* _tmp109_;
	ValaSymbol* _tmp162_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_root (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = module->name;
	_tmp6_ = vala_scope_lookup (_tmp4_, _tmp5_);
	sym = _tmp6_;
	_tmp7_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE)) {
		ValaSymbol* _tmp8_;
		ValaNamespace* _tmp9_;
		ValaNamespace* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp8_ = sym;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp9_;
		_tmp10_ = ns;
		_tmp11_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_) {
			ValaNamespace* _tmp13_;
			ValaNamespace* _tmp14_;
			ValaSourceReference* _tmp15_;
			_tmp13_ = ns;
			(((ValaCodeNode*) _tmp13_)->attributes == NULL) ? NULL : (((ValaCodeNode*) _tmp13_)->attributes = (_g_list_free__vala_code_node_unref0_ (((ValaCodeNode*) _tmp13_)->attributes), NULL));
			((ValaCodeNode*) _tmp13_)->attributes = NULL;
			_tmp14_ = ns;
			_tmp15_ = self->priv->current_source_reference;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp14_, _tmp15_);
		}
	} else {
		const gchar* _tmp16_;
		ValaSourceReference* _tmp17_;
		ValaNamespace* _tmp18_;
		_tmp16_ = module->name;
		_tmp17_ = self->priv->current_source_reference;
		_tmp18_ = vala_namespace_new (_tmp16_, _tmp17_);
		_vala_code_node_unref0 (ns);
		ns = _tmp18_;
	}
	_tmp19_ = ns;
	_tmp20_ = _vala_code_node_ref0 (_tmp19_);
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp20_;
	_tmp21_ = ns;
	_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp25_ = vala_gidl_parser_get_attributes (self, _tmp23_, &_tmp24_);
	attributes = _tmp25_;
	attributes_length1 = _tmp24_;
	_attributes_size_ = attributes_length1;
	_tmp26_ = attributes;
	_tmp26__length1 = attributes_length1;
	if (_tmp26_ != NULL) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp27_ = attributes;
		_tmp27__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp27_;
			attr_collection_length1 = _tmp27__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp28_;
				gchar* attr = NULL;
				_tmp28_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp28_;
				{
					gchar** nv = NULL;
					const gchar* _tmp29_;
					gchar** _tmp30_;
					gchar** _tmp31_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp32_;
					gint _tmp32__length1;
					const gchar* _tmp33_;
					_tmp29_ = attr;
					_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, "=", 2);
					nv = _tmp31_;
					nv_length1 = _vala_array_length (_tmp30_);
					_nv_size_ = nv_length1;
					_tmp32_ = nv;
					_tmp32__length1 = nv_length1;
					_tmp33_ = _tmp32_[0];
					if (g_strcmp0 (_tmp33_, "cheader_filename") == 0) {
						ValaNamespace* _tmp34_;
						gchar** _tmp35_;
						gint _tmp35__length1;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						_tmp34_ = ns;
						_tmp35_ = nv;
						_tmp35__length1 = nv_length1;
						_tmp36_ = _tmp35_[1];
						_tmp37_ = vala_gidl_parser_eval (self, _tmp36_);
						_tmp38_ = _tmp37_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp34_, "CCode", "cheader_filename", _tmp38_, NULL);
						_g_free0 (_tmp38_);
					} else {
						gchar** _tmp39_;
						gint _tmp39__length1;
						const gchar* _tmp40_;
						_tmp39_ = nv;
						_tmp39__length1 = nv_length1;
						_tmp40_ = _tmp39_[0];
						if (g_strcmp0 (_tmp40_, "cprefix") == 0) {
							ValaNamespace* _tmp41_;
							gchar** _tmp42_;
							gint _tmp42__length1;
							const gchar* _tmp43_;
							gchar* _tmp44_;
							gchar* _tmp45_;
							_tmp41_ = ns;
							_tmp42_ = nv;
							_tmp42__length1 = nv_length1;
							_tmp43_ = _tmp42_[1];
							_tmp44_ = vala_gidl_parser_eval (self, _tmp43_);
							_tmp45_ = _tmp44_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp41_, "CCode", "cprefix", _tmp45_, NULL);
							_g_free0 (_tmp45_);
						} else {
							gchar** _tmp46_;
							gint _tmp46__length1;
							const gchar* _tmp47_;
							_tmp46_ = nv;
							_tmp46__length1 = nv_length1;
							_tmp47_ = _tmp46_[0];
							if (g_strcmp0 (_tmp47_, "lower_case_cprefix") == 0) {
								ValaNamespace* _tmp48_;
								gchar** _tmp49_;
								gint _tmp49__length1;
								const gchar* _tmp50_;
								gchar* _tmp51_;
								gchar* _tmp52_;
								_tmp48_ = ns;
								_tmp49_ = nv;
								_tmp49__length1 = nv_length1;
								_tmp50_ = _tmp49_[1];
								_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
								_tmp52_ = _tmp51_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp48_, "CCode", "lower_case_cprefix", _tmp52_, NULL);
								_g_free0 (_tmp52_);
							} else {
								gchar** _tmp53_;
								gint _tmp53__length1;
								const gchar* _tmp54_;
								_tmp53_ = nv;
								_tmp53__length1 = nv_length1;
								_tmp54_ = _tmp53_[0];
								if (g_strcmp0 (_tmp54_, "gir_namespace") == 0) {
									ValaNamespace* _tmp55_;
									ValaSourceReference* _tmp56_;
									ValaSourceReference* _tmp57_;
									ValaSourceFile* _tmp58_;
									ValaSourceFile* _tmp59_;
									gchar** _tmp60_;
									gint _tmp60__length1;
									const gchar* _tmp61_;
									gchar* _tmp62_;
									gchar* _tmp63_;
									ValaNamespace* _tmp64_;
									gchar** _tmp65_;
									gint _tmp65__length1;
									const gchar* _tmp66_;
									gchar* _tmp67_;
									gchar* _tmp68_;
									_tmp55_ = ns;
									_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
									_tmp57_ = _tmp56_;
									_tmp58_ = vala_source_reference_get_file (_tmp57_);
									_tmp59_ = _tmp58_;
									_tmp60_ = nv;
									_tmp60__length1 = nv_length1;
									_tmp61_ = _tmp60_[1];
									_tmp62_ = vala_gidl_parser_eval (self, _tmp61_);
									_tmp63_ = _tmp62_;
									vala_source_file_set_gir_namespace (_tmp59_, _tmp63_);
									_g_free0 (_tmp63_);
									_tmp64_ = ns;
									_tmp65_ = nv;
									_tmp65__length1 = nv_length1;
									_tmp66_ = _tmp65_[1];
									_tmp67_ = vala_gidl_parser_eval (self, _tmp66_);
									_tmp68_ = _tmp67_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp64_, "CCode", "gir_namespace", _tmp68_, NULL);
									_g_free0 (_tmp68_);
								} else {
									gchar** _tmp69_;
									gint _tmp69__length1;
									const gchar* _tmp70_;
									_tmp69_ = nv;
									_tmp69__length1 = nv_length1;
									_tmp70_ = _tmp69_[0];
									if (g_strcmp0 (_tmp70_, "gir_version") == 0) {
										ValaNamespace* _tmp71_;
										ValaSourceReference* _tmp72_;
										ValaSourceReference* _tmp73_;
										ValaSourceFile* _tmp74_;
										ValaSourceFile* _tmp75_;
										gchar** _tmp76_;
										gint _tmp76__length1;
										const gchar* _tmp77_;
										gchar* _tmp78_;
										gchar* _tmp79_;
										ValaNamespace* _tmp80_;
										gchar** _tmp81_;
										gint _tmp81__length1;
										const gchar* _tmp82_;
										gchar* _tmp83_;
										gchar* _tmp84_;
										_tmp71_ = ns;
										_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
										_tmp73_ = _tmp72_;
										_tmp74_ = vala_source_reference_get_file (_tmp73_);
										_tmp75_ = _tmp74_;
										_tmp76_ = nv;
										_tmp76__length1 = nv_length1;
										_tmp77_ = _tmp76_[1];
										_tmp78_ = vala_gidl_parser_eval (self, _tmp77_);
										_tmp79_ = _tmp78_;
										vala_source_file_set_gir_version (_tmp75_, _tmp79_);
										_g_free0 (_tmp79_);
										_tmp80_ = ns;
										_tmp81_ = nv;
										_tmp81__length1 = nv_length1;
										_tmp82_ = _tmp81_[1];
										_tmp83_ = vala_gidl_parser_eval (self, _tmp82_);
										_tmp84_ = _tmp83_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp80_, "CCode", "gir_version", _tmp84_, NULL);
										_g_free0 (_tmp84_);
									} else {
										gchar** _tmp85_;
										gint _tmp85__length1;
										const gchar* _tmp86_;
										_tmp85_ = nv;
										_tmp85__length1 = nv_length1;
										_tmp86_ = _tmp85_[0];
										if (g_strcmp0 (_tmp86_, "deprecated") == 0) {
											gchar** _tmp87_;
											gint _tmp87__length1;
											const gchar* _tmp88_;
											gchar* _tmp89_;
											gchar* _tmp90_;
											gboolean _tmp91_;
											_tmp87_ = nv;
											_tmp87__length1 = nv_length1;
											_tmp88_ = _tmp87_[1];
											_tmp89_ = vala_gidl_parser_eval (self, _tmp88_);
											_tmp90_ = _tmp89_;
											_tmp91_ = g_strcmp0 (_tmp90_, "1") == 0;
											_g_free0 (_tmp90_);
											if (_tmp91_) {
												ValaNamespace* _tmp92_;
												_tmp92_ = ns;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp92_, "Version", "deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp93_;
											gint _tmp93__length1;
											const gchar* _tmp94_;
											_tmp93_ = nv;
											_tmp93__length1 = nv_length1;
											_tmp94_ = _tmp93_[0];
											if (g_strcmp0 (_tmp94_, "replacement") == 0) {
												ValaNamespace* _tmp95_;
												gchar** _tmp96_;
												gint _tmp96__length1;
												const gchar* _tmp97_;
												gchar* _tmp98_;
												gchar* _tmp99_;
												_tmp95_ = ns;
												_tmp96_ = nv;
												_tmp96__length1 = nv_length1;
												_tmp97_ = _tmp96_[1];
												_tmp98_ = vala_gidl_parser_eval (self, _tmp97_);
												_tmp99_ = _tmp98_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp95_, "Version", "replacement", _tmp99_, NULL);
												_g_free0 (_tmp99_);
											} else {
												gchar** _tmp100_;
												gint _tmp100__length1;
												const gchar* _tmp101_;
												_tmp100_ = nv;
												_tmp100__length1 = nv_length1;
												_tmp101_ = _tmp100_[0];
												if (g_strcmp0 (_tmp101_, "deprecated_since") == 0) {
													ValaNamespace* _tmp102_;
													gchar** _tmp103_;
													gint _tmp103__length1;
													const gchar* _tmp104_;
													gchar* _tmp105_;
													gchar* _tmp106_;
													_tmp102_ = ns;
													_tmp103_ = nv;
													_tmp103__length1 = nv_length1;
													_tmp104_ = _tmp103_[1];
													_tmp105_ = vala_gidl_parser_eval (self, _tmp104_);
													_tmp106_ = _tmp105_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp102_, "Version", "deprecated_since", _tmp106_, NULL);
													_g_free0 (_tmp106_);
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp107_ = g_direct_equal;
	_tmp108_ = vala_array_list_new (G_TYPE_POINTER, NULL, NULL, _tmp107_);
	deferred = _tmp108_;
	_tmp109_ = module->entries;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp109_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node = NULL;
			node = (GIdlNode*) node_it->data;
			{
				gboolean is_deferred = FALSE;
				gchar** child_attributes = NULL;
				GIdlNode* _tmp110_;
				gint _tmp111_ = 0;
				gchar** _tmp112_;
				gint child_attributes_length1;
				gint _child_attributes_size_;
				gchar** _tmp113_;
				gint _tmp113__length1;
				gboolean _tmp122_;
				is_deferred = FALSE;
				_tmp110_ = node;
				_tmp112_ = vala_gidl_parser_get_attributes_for_node (self, _tmp110_, &_tmp111_);
				child_attributes = _tmp112_;
				child_attributes_length1 = _tmp111_;
				_child_attributes_size_ = child_attributes_length1;
				_tmp113_ = child_attributes;
				_tmp113__length1 = child_attributes_length1;
				if (_tmp113_ != NULL) {
					gchar** _tmp114_;
					gint _tmp114__length1;
					_tmp114_ = child_attributes;
					_tmp114__length1 = child_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp114_;
						attr_collection_length1 = _tmp114__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							const gchar* attr = NULL;
							attr = attr_collection[attr_it];
							{
								gchar** nv = NULL;
								const gchar* _tmp115_;
								gchar** _tmp116_;
								gchar** _tmp117_;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp118_;
								gint _tmp118__length1;
								const gchar* _tmp119_;
								_tmp115_ = attr;
								_tmp117_ = _tmp116_ = g_strsplit (_tmp115_, "=", 2);
								nv = _tmp117_;
								nv_length1 = _vala_array_length (_tmp116_);
								_nv_size_ = nv_length1;
								_tmp118_ = nv;
								_tmp118__length1 = nv_length1;
								_tmp119_ = _tmp118_[0];
								if (g_strcmp0 (_tmp119_, "parent") == 0) {
									ValaArrayList* _tmp120_;
									GIdlNode* _tmp121_;
									_tmp120_ = deferred;
									_tmp121_ = node;
									vala_collection_add ((ValaCollection*) _tmp120_, _tmp121_);
									is_deferred = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
				}
				_tmp122_ = is_deferred;
				if (!_tmp122_) {
					GIdlNode* _tmp123_;
					ValaNamespace* _tmp124_;
					_tmp123_ = node;
					_tmp124_ = ns;
					vala_gidl_parser_parse_node (self, _tmp123_, module, (ValaSymbol*) _tmp124_);
				}
				child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp125_;
		ValaArrayList* _tmp126_;
		gint _node_size = 0;
		ValaArrayList* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gint _node_index = 0;
		_tmp125_ = deferred;
		_tmp126_ = _vala_iterable_ref0 (_tmp125_);
		_node_list = _tmp126_;
		_tmp127_ = _node_list;
		_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
		_tmp129_ = _tmp128_;
		_node_size = _tmp129_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			GIdlNode* node = NULL;
			ValaArrayList* _tmp133_;
			gint _tmp134_;
			gpointer _tmp135_;
			ValaSymbol* container = NULL;
			ValaNamespace* _tmp136_;
			ValaSymbol* _tmp137_;
			gchar** child_attributes = NULL;
			GIdlNode* _tmp138_;
			gint _tmp139_ = 0;
			gchar** _tmp140_;
			gint child_attributes_length1;
			gint _child_attributes_size_;
			gchar** _tmp141_;
			gint _tmp141__length1;
			ValaSymbol* _tmp153_;
			GIdlNode* _tmp158_;
			ValaSymbol* _tmp159_;
			ValaNamespace* _tmp160_;
			ValaNamespace* _tmp161_;
			_tmp130_ = _node_index;
			_node_index = _tmp130_ + 1;
			_tmp131_ = _node_index;
			_tmp132_ = _node_size;
			if (!(_tmp131_ < _tmp132_)) {
				break;
			}
			_tmp133_ = _node_list;
			_tmp134_ = _node_index;
			_tmp135_ = vala_list_get ((ValaList*) _tmp133_, _tmp134_);
			node = (GIdlNode*) _tmp135_;
			_tmp136_ = ns;
			_tmp137_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp136_);
			container = _tmp137_;
			_tmp138_ = node;
			_tmp140_ = vala_gidl_parser_get_attributes_for_node (self, _tmp138_, &_tmp139_);
			child_attributes = _tmp140_;
			child_attributes_length1 = _tmp139_;
			_child_attributes_size_ = child_attributes_length1;
			_tmp141_ = child_attributes;
			_tmp141__length1 = child_attributes_length1;
			if (_tmp141_ != NULL) {
				gchar** _tmp142_;
				gint _tmp142__length1;
				_tmp142_ = child_attributes;
				_tmp142__length1 = child_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp142_;
					attr_collection_length1 = _tmp142__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						const gchar* attr = NULL;
						attr = attr_collection[attr_it];
						{
							gchar** nv = NULL;
							const gchar* _tmp143_;
							gchar** _tmp144_;
							gchar** _tmp145_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp146_;
							gint _tmp146__length1;
							const gchar* _tmp147_;
							_tmp143_ = attr;
							_tmp145_ = _tmp144_ = g_strsplit (_tmp143_, "=", 2);
							nv = _tmp145_;
							nv_length1 = _vala_array_length (_tmp144_);
							_nv_size_ = nv_length1;
							_tmp146_ = nv;
							_tmp146__length1 = nv_length1;
							_tmp147_ = _tmp146_[0];
							if (g_strcmp0 (_tmp147_, "parent") == 0) {
								gchar** _tmp148_;
								gint _tmp148__length1;
								const gchar* _tmp149_;
								gchar* _tmp150_;
								gchar* _tmp151_;
								ValaSymbol* _tmp152_;
								_tmp148_ = nv;
								_tmp148__length1 = nv_length1;
								_tmp149_ = _tmp148_[1];
								_tmp150_ = vala_gidl_parser_eval (self, _tmp149_);
								_tmp151_ = _tmp150_;
								_tmp152_ = vala_gidl_parser_get_container_from_name (self, _tmp151_);
								_vala_code_node_unref0 (container);
								container = _tmp152_;
								_g_free0 (_tmp151_);
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			_tmp153_ = container;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp153_, VALA_TYPE_NAMESPACE)) {
				ValaSymbol* _tmp154_;
				ValaNamespace* _tmp155_;
				_tmp154_ = container;
				_tmp155_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp154_, VALA_TYPE_NAMESPACE, ValaNamespace));
				_vala_code_node_unref0 (self->priv->current_namespace);
				self->priv->current_namespace = _tmp155_;
			} else {
				ValaSymbol* _tmp156_;
				ValaTypeSymbol* _tmp157_;
				_tmp156_ = container;
				_tmp157_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (self->priv->current_data_type);
				self->priv->current_data_type = _tmp157_;
			}
			_tmp158_ = node;
			_tmp159_ = container;
			vala_gidl_parser_parse_node (self, _tmp158_, module, _tmp159_);
			_tmp160_ = ns;
			_tmp161_ = _vala_code_node_ref0 (_tmp160_);
			_vala_code_node_unref0 (self->priv->current_namespace);
			self->priv->current_namespace = _tmp161_;
			_vala_code_node_unref0 (self->priv->current_data_type);
			self->priv->current_data_type = NULL;
			child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (container);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = NULL;
	_tmp162_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp162_, VALA_TYPE_NAMESPACE)) {
		result = NULL;
		_vala_iterable_unref0 (deferred);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (ns);
		_vala_code_node_unref0 (sym);
		return result;
	}
	result = ns;
	_vala_iterable_unref0 (deferred);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (sym);
	return result;
}


static gdouble
double_parse (const gchar* str)
{
	gdouble result = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}


static ValaDelegate*
vala_gidl_parser_parse_delegate (ValaGIdlParser* self,
                                 GIdlNodeFunction* f_node)
{
	ValaDelegate* result = NULL;
	GIdlNode* node = NULL;
	ValaDataType* return_type = NULL;
	GIdlNodeParam* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDelegate* cb = NULL;
	GIdlNode* _tmp2_;
	const gchar* _tmp3_;
	ValaDataType* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaDelegate* _tmp7_;
	ValaDelegate* _tmp8_;
	gboolean check_has_target = FALSE;
	gboolean suppress_throws = FALSE;
	gchar* error_types = NULL;
	gchar** attributes = NULL;
	GIdlNode* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	guint remaining_params = 0U;
	GList* _tmp159_;
	GList* _tmp160_;
	gboolean _tmp340_ = FALSE;
	gboolean _tmp341_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f_node != NULL, NULL);
	node = (GIdlNode*) f_node;
	_tmp0_ = f_node->result;
	_tmp1_ = vala_gidl_parser_parse_param (self, _tmp0_, NULL);
	return_type = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = return_type;
	_tmp5_ = self->priv->current_source_reference;
	_tmp6_ = vala_delegate_new (_tmp3_, _tmp4_, _tmp5_, NULL);
	cb = _tmp6_;
	_tmp7_ = cb;
	vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp8_ = cb;
	vala_delegate_set_has_target (_tmp8_, FALSE);
	check_has_target = TRUE;
	suppress_throws = FALSE;
	error_types = NULL;
	_tmp9_ = node;
	_tmp10_ = _tmp9_->name;
	_tmp12_ = vala_gidl_parser_get_attributes (self, _tmp10_, &_tmp11_);
	attributes = _tmp12_;
	attributes_length1 = _tmp11_;
	_attributes_size_ = attributes_length1;
	_tmp13_ = attributes;
	_tmp13__length1 = attributes_length1;
	if (_tmp13_ != NULL) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = attributes;
		_tmp14__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp14_;
			attr_collection_length1 = _tmp14__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp15_;
				gchar* attr = NULL;
				_tmp15_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp15_;
				{
					gchar** nv = NULL;
					const gchar* _tmp16_;
					gchar** _tmp17_;
					gchar** _tmp18_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					_tmp16_ = attr;
					_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "=", 2);
					nv = _tmp18_;
					nv_length1 = _vala_array_length (_tmp17_);
					_nv_size_ = nv_length1;
					_tmp19_ = nv;
					_tmp19__length1 = nv_length1;
					_tmp20_ = _tmp19_[0];
					if (g_strcmp0 (_tmp20_, "hidden") == 0) {
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gboolean _tmp25_;
						_tmp21_ = nv;
						_tmp21__length1 = nv_length1;
						_tmp22_ = _tmp21_[1];
						_tmp23_ = vala_gidl_parser_eval (self, _tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0;
						_g_free0 (_tmp24_);
						if (_tmp25_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (error_types);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (return_type);
							return result;
						}
					} else {
						gchar** _tmp26_;
						gint _tmp26__length1;
						const gchar* _tmp27_;
						_tmp26_ = nv;
						_tmp26__length1 = nv_length1;
						_tmp27_ = _tmp26_[0];
						if (g_strcmp0 (_tmp27_, "cheader_filename") == 0) {
							ValaDelegate* _tmp28_;
							gchar** _tmp29_;
							gint _tmp29__length1;
							const gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							_tmp28_ = cb;
							_tmp29_ = nv;
							_tmp29__length1 = nv_length1;
							_tmp30_ = _tmp29_[1];
							_tmp31_ = vala_gidl_parser_eval (self, _tmp30_);
							_tmp32_ = _tmp31_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp28_, "CCode", "cheader_filename", _tmp32_, NULL);
							_g_free0 (_tmp32_);
						} else {
							gchar** _tmp33_;
							gint _tmp33__length1;
							const gchar* _tmp34_;
							_tmp33_ = nv;
							_tmp33__length1 = nv_length1;
							_tmp34_ = _tmp33_[0];
							if (g_strcmp0 (_tmp34_, "has_target") == 0) {
								gchar** _tmp35_;
								gint _tmp35__length1;
								const gchar* _tmp36_;
								gchar* _tmp37_;
								gchar* _tmp38_;
								gboolean _tmp39_;
								_tmp35_ = nv;
								_tmp35__length1 = nv_length1;
								_tmp36_ = _tmp35_[1];
								_tmp37_ = vala_gidl_parser_eval (self, _tmp36_);
								_tmp38_ = _tmp37_;
								_tmp39_ = g_strcmp0 (_tmp38_, "0") == 0;
								_g_free0 (_tmp38_);
								if (_tmp39_) {
									check_has_target = FALSE;
								} else {
									gchar** _tmp40_;
									gint _tmp40__length1;
									const gchar* _tmp41_;
									gchar* _tmp42_;
									gchar* _tmp43_;
									gboolean _tmp44_;
									_tmp40_ = nv;
									_tmp40__length1 = nv_length1;
									_tmp41_ = _tmp40_[1];
									_tmp42_ = vala_gidl_parser_eval (self, _tmp41_);
									_tmp43_ = _tmp42_;
									_tmp44_ = g_strcmp0 (_tmp43_, "1") == 0;
									_g_free0 (_tmp43_);
									if (_tmp44_) {
										ValaDelegate* _tmp45_;
										_tmp45_ = cb;
										vala_delegate_set_has_target (_tmp45_, TRUE);
									}
								}
							} else {
								gchar** _tmp46_;
								gint _tmp46__length1;
								const gchar* _tmp47_;
								_tmp46_ = nv;
								_tmp46__length1 = nv_length1;
								_tmp47_ = _tmp46_[0];
								if (g_strcmp0 (_tmp47_, "transfer_ownership") == 0) {
									gchar** _tmp48_;
									gint _tmp48__length1;
									const gchar* _tmp49_;
									gchar* _tmp50_;
									gchar* _tmp51_;
									gboolean _tmp52_;
									_tmp48_ = nv;
									_tmp48__length1 = nv_length1;
									_tmp49_ = _tmp48_[1];
									_tmp50_ = vala_gidl_parser_eval (self, _tmp49_);
									_tmp51_ = _tmp50_;
									_tmp52_ = g_strcmp0 (_tmp51_, "1") == 0;
									_g_free0 (_tmp51_);
									if (_tmp52_) {
										ValaDataType* _tmp53_;
										_tmp53_ = return_type;
										vala_data_type_set_value_owned (_tmp53_, TRUE);
									}
								} else {
									gchar** _tmp54_;
									gint _tmp54__length1;
									const gchar* _tmp55_;
									_tmp54_ = nv;
									_tmp54__length1 = nv_length1;
									_tmp55_ = _tmp54_[0];
									if (g_strcmp0 (_tmp55_, "is_array") == 0) {
										gchar** _tmp56_;
										gint _tmp56__length1;
										const gchar* _tmp57_;
										gchar* _tmp58_;
										gchar* _tmp59_;
										gboolean _tmp60_;
										_tmp56_ = nv;
										_tmp56__length1 = nv_length1;
										_tmp57_ = _tmp56_[1];
										_tmp58_ = vala_gidl_parser_eval (self, _tmp57_);
										_tmp59_ = _tmp58_;
										_tmp60_ = g_strcmp0 (_tmp59_, "1") == 0;
										_g_free0 (_tmp59_);
										if (_tmp60_) {
											ValaDataType* _tmp61_;
											ValaDataType* _tmp62_;
											ValaDataType* _tmp63_;
											ValaSourceReference* _tmp64_;
											ValaSourceReference* _tmp65_;
											ValaArrayType* _tmp66_;
											ValaDelegate* _tmp67_;
											ValaDataType* _tmp68_;
											_tmp61_ = return_type;
											vala_data_type_set_value_owned (_tmp61_, TRUE);
											_tmp62_ = return_type;
											_tmp63_ = return_type;
											_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
											_tmp65_ = _tmp64_;
											_tmp66_ = vala_array_type_new (_tmp62_, 1, _tmp65_);
											_vala_code_node_unref0 (return_type);
											return_type = (ValaDataType*) _tmp66_;
											_tmp67_ = cb;
											_tmp68_ = return_type;
											vala_callable_set_return_type ((ValaCallable*) _tmp67_, _tmp68_);
										}
									} else {
										gchar** _tmp69_;
										gint _tmp69__length1;
										const gchar* _tmp70_;
										_tmp69_ = nv;
										_tmp69__length1 = nv_length1;
										_tmp70_ = _tmp69_[0];
										if (g_strcmp0 (_tmp70_, "throws") == 0) {
											gchar** _tmp71_;
											gint _tmp71__length1;
											const gchar* _tmp72_;
											gchar* _tmp73_;
											gchar* _tmp74_;
											gboolean _tmp75_;
											_tmp71_ = nv;
											_tmp71__length1 = nv_length1;
											_tmp72_ = _tmp71_[1];
											_tmp73_ = vala_gidl_parser_eval (self, _tmp72_);
											_tmp74_ = _tmp73_;
											_tmp75_ = g_strcmp0 (_tmp74_, "0") == 0;
											_g_free0 (_tmp74_);
											if (_tmp75_) {
												suppress_throws = TRUE;
											}
										} else {
											gchar** _tmp76_;
											gint _tmp76__length1;
											const gchar* _tmp77_;
											_tmp76_ = nv;
											_tmp76__length1 = nv_length1;
											_tmp77_ = _tmp76_[0];
											if (g_strcmp0 (_tmp77_, "error_types") == 0) {
												gchar** _tmp78_;
												gint _tmp78__length1;
												const gchar* _tmp79_;
												gchar* _tmp80_;
												_tmp78_ = nv;
												_tmp78__length1 = nv_length1;
												_tmp79_ = _tmp78_[1];
												_tmp80_ = vala_gidl_parser_eval (self, _tmp79_);
												_g_free0 (error_types);
												error_types = _tmp80_;
											} else {
												gchar** _tmp81_;
												gint _tmp81__length1;
												const gchar* _tmp82_;
												_tmp81_ = nv;
												_tmp81__length1 = nv_length1;
												_tmp82_ = _tmp81_[0];
												if (g_strcmp0 (_tmp82_, "array_length_type") == 0) {
													ValaDelegate* _tmp83_;
													gchar** _tmp84_;
													gint _tmp84__length1;
													const gchar* _tmp85_;
													gchar* _tmp86_;
													gchar* _tmp87_;
													_tmp83_ = cb;
													_tmp84_ = nv;
													_tmp84__length1 = nv_length1;
													_tmp85_ = _tmp84_[1];
													_tmp86_ = vala_gidl_parser_eval (self, _tmp85_);
													_tmp87_ = _tmp86_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp83_, "CCode", "array_length_type", _tmp87_, NULL);
													_g_free0 (_tmp87_);
												} else {
													gchar** _tmp88_;
													gint _tmp88__length1;
													const gchar* _tmp89_;
													_tmp88_ = nv;
													_tmp88__length1 = nv_length1;
													_tmp89_ = _tmp88_[0];
													if (g_strcmp0 (_tmp89_, "type_name") == 0) {
														ValaDelegate* _tmp90_;
														gchar** _tmp91_;
														gint _tmp91__length1;
														const gchar* _tmp92_;
														gchar* _tmp93_;
														gchar* _tmp94_;
														ValaDataType* _tmp95_;
														gboolean _tmp96_;
														gboolean _tmp97_;
														ValaDataType* _tmp98_;
														ValaDataType* _tmp99_;
														_tmp90_ = cb;
														_tmp91_ = nv;
														_tmp91__length1 = nv_length1;
														_tmp92_ = _tmp91_[1];
														_tmp93_ = vala_gidl_parser_eval (self, _tmp92_);
														_tmp94_ = _tmp93_;
														_tmp95_ = return_type;
														_tmp96_ = vala_data_type_get_value_owned (_tmp95_);
														_tmp97_ = _tmp96_;
														_tmp98_ = vala_gidl_parser_parse_type_from_string (self, _tmp94_, _tmp97_, NULL);
														_vala_code_node_unref0 (return_type);
														return_type = _tmp98_;
														_tmp99_ = return_type;
														vala_callable_set_return_type ((ValaCallable*) _tmp90_, _tmp99_);
														_g_free0 (_tmp94_);
													} else {
														gchar** _tmp100_;
														gint _tmp100__length1;
														const gchar* _tmp101_;
														_tmp100_ = nv;
														_tmp100__length1 = nv_length1;
														_tmp101_ = _tmp100_[0];
														if (g_strcmp0 (_tmp101_, "deprecated") == 0) {
															gchar** _tmp102_;
															gint _tmp102__length1;
															const gchar* _tmp103_;
															gchar* _tmp104_;
															gchar* _tmp105_;
															gboolean _tmp106_;
															_tmp102_ = nv;
															_tmp102__length1 = nv_length1;
															_tmp103_ = _tmp102_[1];
															_tmp104_ = vala_gidl_parser_eval (self, _tmp103_);
															_tmp105_ = _tmp104_;
															_tmp106_ = g_strcmp0 (_tmp105_, "1") == 0;
															_g_free0 (_tmp105_);
															if (_tmp106_) {
																ValaDelegate* _tmp107_;
																_tmp107_ = cb;
																vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp107_, "Version", "deprecated", TRUE, NULL);
															}
														} else {
															gchar** _tmp108_;
															gint _tmp108__length1;
															const gchar* _tmp109_;
															_tmp108_ = nv;
															_tmp108__length1 = nv_length1;
															_tmp109_ = _tmp108_[0];
															if (g_strcmp0 (_tmp109_, "replacement") == 0) {
																ValaDelegate* _tmp110_;
																gchar** _tmp111_;
																gint _tmp111__length1;
																const gchar* _tmp112_;
																gchar* _tmp113_;
																gchar* _tmp114_;
																_tmp110_ = cb;
																_tmp111_ = nv;
																_tmp111__length1 = nv_length1;
																_tmp112_ = _tmp111_[1];
																_tmp113_ = vala_gidl_parser_eval (self, _tmp112_);
																_tmp114_ = _tmp113_;
																vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp110_, "Version", "replacement", _tmp114_, NULL);
																_g_free0 (_tmp114_);
															} else {
																gchar** _tmp115_;
																gint _tmp115__length1;
																const gchar* _tmp116_;
																_tmp115_ = nv;
																_tmp115__length1 = nv_length1;
																_tmp116_ = _tmp115_[0];
																if (g_strcmp0 (_tmp116_, "deprecated_since") == 0) {
																	ValaDelegate* _tmp117_;
																	gchar** _tmp118_;
																	gint _tmp118__length1;
																	const gchar* _tmp119_;
																	gchar* _tmp120_;
																	gchar* _tmp121_;
																	_tmp117_ = cb;
																	_tmp118_ = nv;
																	_tmp118__length1 = nv_length1;
																	_tmp119_ = _tmp118_[1];
																	_tmp120_ = vala_gidl_parser_eval (self, _tmp119_);
																	_tmp121_ = _tmp120_;
																	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp117_, "Version", "deprecated_since", _tmp121_, NULL);
																	_g_free0 (_tmp121_);
																} else {
																	gchar** _tmp122_;
																	gint _tmp122__length1;
																	const gchar* _tmp123_;
																	_tmp122_ = nv;
																	_tmp122__length1 = nv_length1;
																	_tmp123_ = _tmp122_[0];
																	if (g_strcmp0 (_tmp123_, "type_arguments") == 0) {
																		ValaDataType* _tmp124_;
																		gchar** _tmp125_;
																		gint _tmp125__length1;
																		const gchar* _tmp126_;
																		gchar* _tmp127_;
																		gchar* _tmp128_;
																		_tmp124_ = return_type;
																		_tmp125_ = nv;
																		_tmp125__length1 = nv_length1;
																		_tmp126_ = _tmp125_[1];
																		_tmp127_ = vala_gidl_parser_eval (self, _tmp126_);
																		_tmp128_ = _tmp127_;
																		vala_gidl_parser_parse_type_arguments_from_string (self, _tmp124_, _tmp128_, NULL);
																		_g_free0 (_tmp128_);
																	} else {
																		gchar** _tmp129_;
																		gint _tmp129__length1;
																		const gchar* _tmp130_;
																		_tmp129_ = nv;
																		_tmp129__length1 = nv_length1;
																		_tmp130_ = _tmp129_[0];
																		if (g_strcmp0 (_tmp130_, "instance_pos") == 0) {
																			ValaDelegate* _tmp131_;
																			gchar** _tmp132_;
																			gint _tmp132__length1;
																			const gchar* _tmp133_;
																			gchar* _tmp134_;
																			gchar* _tmp135_;
																			_tmp131_ = cb;
																			_tmp132_ = nv;
																			_tmp132__length1 = nv_length1;
																			_tmp133_ = _tmp132_[1];
																			_tmp134_ = vala_gidl_parser_eval (self, _tmp133_);
																			_tmp135_ = _tmp134_;
																			vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp131_, "CCode", "instance_pos", double_parse (_tmp135_), NULL);
																			_g_free0 (_tmp135_);
																		} else {
																			gchar** _tmp136_;
																			gint _tmp136__length1;
																			const gchar* _tmp137_;
																			_tmp136_ = nv;
																			_tmp136__length1 = nv_length1;
																			_tmp137_ = _tmp136_[0];
																			if (g_strcmp0 (_tmp137_, "type_parameters") == 0) {
																				gchar** _tmp138_;
																				gint _tmp138__length1;
																				const gchar* _tmp139_;
																				gchar* _tmp140_;
																				gchar* _tmp141_;
																				gchar** _tmp142_;
																				gchar** _tmp143_;
																				gchar** _tmp144_;
																				gint _tmp144__length1;
																				_tmp138_ = nv;
																				_tmp138__length1 = nv_length1;
																				_tmp139_ = _tmp138_[1];
																				_tmp140_ = vala_gidl_parser_eval (self, _tmp139_);
																				_tmp141_ = _tmp140_;
																				_tmp143_ = _tmp142_ = g_strsplit (_tmp141_, ",", 0);
																				_tmp144_ = _tmp143_;
																				_tmp144__length1 = _vala_array_length (_tmp142_);
																				_g_free0 (_tmp141_);
																				{
																					gchar** type_param_name_collection = NULL;
																					gint type_param_name_collection_length1 = 0;
																					gint _type_param_name_collection_size_ = 0;
																					gint type_param_name_it = 0;
																					type_param_name_collection = _tmp144_;
																					type_param_name_collection_length1 = _tmp144__length1;
																					for (type_param_name_it = 0; type_param_name_it < type_param_name_collection_length1; type_param_name_it = type_param_name_it + 1) {
																						gchar* _tmp145_;
																						gchar* type_param_name = NULL;
																						_tmp145_ = g_strdup (type_param_name_collection[type_param_name_it]);
																						type_param_name = _tmp145_;
																						{
																							ValaDelegate* _tmp146_;
																							const gchar* _tmp147_;
																							ValaSourceReference* _tmp148_;
																							ValaTypeParameter* _tmp149_;
																							ValaTypeParameter* _tmp150_;
																							_tmp146_ = cb;
																							_tmp147_ = type_param_name;
																							_tmp148_ = self->priv->current_source_reference;
																							_tmp149_ = vala_typeparameter_new (_tmp147_, _tmp148_);
																							_tmp150_ = _tmp149_;
																							vala_delegate_add_type_parameter (_tmp146_, _tmp150_);
																							_vala_code_node_unref0 (_tmp150_);
																							_g_free0 (type_param_name);
																						}
																					}
																					type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																				}
																			} else {
																				gchar** _tmp151_;
																				gint _tmp151__length1;
																				const gchar* _tmp152_;
																				_tmp151_ = nv;
																				_tmp151__length1 = nv_length1;
																				_tmp152_ = _tmp151_[0];
																				if (g_strcmp0 (_tmp152_, "experimental") == 0) {
																					gchar** _tmp153_;
																					gint _tmp153__length1;
																					const gchar* _tmp154_;
																					gchar* _tmp155_;
																					gchar* _tmp156_;
																					gboolean _tmp157_;
																					_tmp153_ = nv;
																					_tmp153__length1 = nv_length1;
																					_tmp154_ = _tmp153_[1];
																					_tmp155_ = vala_gidl_parser_eval (self, _tmp154_);
																					_tmp156_ = _tmp155_;
																					_tmp157_ = g_strcmp0 (_tmp156_, "1") == 0;
																					_g_free0 (_tmp156_);
																					if (_tmp157_) {
																						ValaDelegate* _tmp158_;
																						_tmp158_ = cb;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp158_, "Version", "experimental", TRUE, NULL);
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp159_ = f_node->parameters;
	remaining_params = g_list_length (_tmp159_);
	_tmp160_ = f_node->parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp160_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node = NULL;
				GIdlNodeParam* _tmp161_;
				gboolean _tmp162_ = FALSE;
				gboolean _tmp163_ = FALSE;
				gboolean _tmp164_;
				guint _tmp339_;
				_tmp161_ = param;
				param_node = (GIdlNode*) _tmp161_;
				_tmp164_ = check_has_target;
				if (_tmp164_) {
					guint _tmp165_;
					_tmp165_ = remaining_params;
					_tmp163_ = _tmp165_ == ((guint) 1);
				} else {
					_tmp163_ = FALSE;
				}
				if (_tmp163_) {
					gboolean _tmp166_ = FALSE;
					GIdlNode* _tmp167_;
					const gchar* _tmp168_;
					_tmp167_ = param_node;
					_tmp168_ = _tmp167_->name;
					if (g_strcmp0 (_tmp168_, "user_data") == 0) {
						_tmp166_ = TRUE;
					} else {
						GIdlNode* _tmp169_;
						const gchar* _tmp170_;
						_tmp169_ = param_node;
						_tmp170_ = _tmp169_->name;
						_tmp166_ = g_strcmp0 (_tmp170_, "data") == 0;
					}
					_tmp162_ = _tmp166_;
				} else {
					_tmp162_ = FALSE;
				}
				if (_tmp162_) {
					ValaDelegate* _tmp171_;
					_tmp171_ = cb;
					vala_delegate_set_has_target (_tmp171_, TRUE);
				} else {
					gboolean _tmp172_ = FALSE;
					gboolean _tmp173_;
					gchar* param_name = NULL;
					GIdlNode* _tmp182_;
					const gchar* _tmp183_;
					gchar* _tmp184_;
					const gchar* _tmp185_;
					ValaParameterDirection direction = 0;
					ValaDataType* param_type = NULL;
					GIdlNodeParam* _tmp189_;
					ValaParameterDirection _tmp190_ = 0;
					ValaDataType* _tmp191_;
					ValaParameter* p = NULL;
					const gchar* _tmp192_;
					ValaDataType* _tmp193_;
					ValaParameter* _tmp194_;
					ValaParameter* _tmp195_;
					ValaParameterDirection _tmp196_;
					gboolean hide_param = FALSE;
					gboolean show_param = FALSE;
					gboolean array_requested = FALSE;
					gboolean out_requested = FALSE;
					GIdlNode* _tmp197_;
					const gchar* _tmp198_;
					GIdlNode* _tmp199_;
					const gchar* _tmp200_;
					gchar* _tmp201_;
					gchar* _tmp202_;
					gint _tmp203_ = 0;
					gchar** _tmp204_;
					gchar** _tmp205_;
					gint _tmp205__length1;
					gboolean _tmp334_ = FALSE;
					gboolean _tmp335_;
					_tmp173_ = suppress_throws;
					if (_tmp173_ == FALSE) {
						GIdlNodeParam* _tmp174_;
						_tmp174_ = param;
						_tmp172_ = vala_gidl_parser_param_is_exception (self, _tmp174_);
					} else {
						_tmp172_ = FALSE;
					}
					if (_tmp172_) {
						const gchar* _tmp175_;
						guint _tmp181_;
						_tmp175_ = error_types;
						if (_tmp175_ == NULL) {
							ValaDelegate* _tmp176_;
							GIdlNodeParam* _tmp177_;
							GIdlNodeType* _tmp178_;
							ValaDataType* _tmp179_;
							ValaDataType* _tmp180_;
							_tmp176_ = cb;
							_tmp177_ = param;
							_tmp178_ = _tmp177_->type;
							_tmp179_ = vala_gidl_parser_parse_type (self, _tmp178_, NULL);
							_tmp180_ = _tmp179_;
							vala_code_node_add_error_type ((ValaCodeNode*) _tmp176_, _tmp180_);
							_vala_code_node_unref0 (_tmp180_);
						}
						_tmp181_ = remaining_params;
						remaining_params = _tmp181_ - 1;
						continue;
					}
					_tmp182_ = param_node;
					_tmp183_ = _tmp182_->name;
					_tmp184_ = g_strdup (_tmp183_);
					param_name = _tmp184_;
					_tmp185_ = param_name;
					if (g_strcmp0 (_tmp185_, "string") == 0) {
						gchar* _tmp186_;
						_tmp186_ = g_strdup ("str");
						_g_free0 (param_name);
						param_name = _tmp186_;
					} else {
						const gchar* _tmp187_;
						_tmp187_ = param_name;
						if (g_strcmp0 (_tmp187_, "self") == 0) {
							gchar* _tmp188_;
							_tmp188_ = g_strdup ("_self");
							_g_free0 (param_name);
							param_name = _tmp188_;
						}
					}
					_tmp189_ = param;
					_tmp191_ = vala_gidl_parser_parse_param (self, _tmp189_, &_tmp190_);
					direction = _tmp190_;
					param_type = _tmp191_;
					_tmp192_ = param_name;
					_tmp193_ = param_type;
					_tmp194_ = vala_parameter_new (_tmp192_, _tmp193_, NULL);
					p = _tmp194_;
					_tmp195_ = p;
					_tmp196_ = direction;
					vala_parameter_set_direction (_tmp195_, _tmp196_);
					hide_param = FALSE;
					show_param = FALSE;
					array_requested = FALSE;
					out_requested = FALSE;
					_tmp197_ = node;
					_tmp198_ = _tmp197_->name;
					_tmp199_ = param_node;
					_tmp200_ = _tmp199_->name;
					_tmp201_ = g_strdup_printf ("%s.%s", _tmp198_, _tmp200_);
					_tmp202_ = _tmp201_;
					_tmp204_ = vala_gidl_parser_get_attributes (self, _tmp202_, &_tmp203_);
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					attributes = _tmp204_;
					attributes_length1 = _tmp203_;
					_attributes_size_ = attributes_length1;
					_g_free0 (_tmp202_);
					_tmp205_ = attributes;
					_tmp205__length1 = attributes_length1;
					if (_tmp205_ != NULL) {
						gchar** _tmp206_;
						gint _tmp206__length1;
						_tmp206_ = attributes;
						_tmp206__length1 = attributes_length1;
						{
							gchar** attr_collection = NULL;
							gint attr_collection_length1 = 0;
							gint _attr_collection_size_ = 0;
							gint attr_it = 0;
							attr_collection = _tmp206_;
							attr_collection_length1 = _tmp206__length1;
							for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
								gchar* _tmp207_;
								gchar* attr = NULL;
								_tmp207_ = g_strdup (attr_collection[attr_it]);
								attr = _tmp207_;
								{
									gchar** nv = NULL;
									const gchar* _tmp208_;
									gchar** _tmp209_;
									gchar** _tmp210_;
									gint nv_length1;
									gint _nv_size_;
									gchar** _tmp211_;
									gint _tmp211__length1;
									const gchar* _tmp212_;
									_tmp208_ = attr;
									_tmp210_ = _tmp209_ = g_strsplit (_tmp208_, "=", 2);
									nv = _tmp210_;
									nv_length1 = _vala_array_length (_tmp209_);
									_nv_size_ = nv_length1;
									_tmp211_ = nv;
									_tmp211__length1 = nv_length1;
									_tmp212_ = _tmp211_[0];
									if (g_strcmp0 (_tmp212_, "hidden") == 0) {
										gchar** _tmp213_;
										gint _tmp213__length1;
										const gchar* _tmp214_;
										gchar* _tmp215_;
										gchar* _tmp216_;
										gboolean _tmp217_;
										_tmp213_ = nv;
										_tmp213__length1 = nv_length1;
										_tmp214_ = _tmp213_[1];
										_tmp215_ = vala_gidl_parser_eval (self, _tmp214_);
										_tmp216_ = _tmp215_;
										_tmp217_ = g_strcmp0 (_tmp216_, "1") == 0;
										_g_free0 (_tmp216_);
										if (_tmp217_) {
											hide_param = TRUE;
										} else {
											gchar** _tmp218_;
											gint _tmp218__length1;
											const gchar* _tmp219_;
											gchar* _tmp220_;
											gchar* _tmp221_;
											gboolean _tmp222_;
											_tmp218_ = nv;
											_tmp218__length1 = nv_length1;
											_tmp219_ = _tmp218_[1];
											_tmp220_ = vala_gidl_parser_eval (self, _tmp219_);
											_tmp221_ = _tmp220_;
											_tmp222_ = g_strcmp0 (_tmp221_, "0") == 0;
											_g_free0 (_tmp221_);
											if (_tmp222_) {
												show_param = TRUE;
											}
										}
									} else {
										gchar** _tmp223_;
										gint _tmp223__length1;
										const gchar* _tmp224_;
										_tmp223_ = nv;
										_tmp223__length1 = nv_length1;
										_tmp224_ = _tmp223_[0];
										if (g_strcmp0 (_tmp224_, "is_array") == 0) {
											gchar** _tmp225_;
											gint _tmp225__length1;
											const gchar* _tmp226_;
											gchar* _tmp227_;
											gchar* _tmp228_;
											gboolean _tmp229_;
											_tmp225_ = nv;
											_tmp225__length1 = nv_length1;
											_tmp226_ = _tmp225_[1];
											_tmp227_ = vala_gidl_parser_eval (self, _tmp226_);
											_tmp228_ = _tmp227_;
											_tmp229_ = g_strcmp0 (_tmp228_, "1") == 0;
											_g_free0 (_tmp228_);
											if (_tmp229_) {
												ValaDataType* _tmp230_;
												ValaDataType* _tmp231_;
												ValaDataType* _tmp232_;
												ValaSourceReference* _tmp233_;
												ValaSourceReference* _tmp234_;
												ValaArrayType* _tmp235_;
												ValaParameter* _tmp236_;
												ValaDataType* _tmp237_;
												gboolean _tmp238_;
												_tmp230_ = param_type;
												vala_data_type_set_value_owned (_tmp230_, TRUE);
												_tmp231_ = param_type;
												_tmp232_ = param_type;
												_tmp233_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp232_);
												_tmp234_ = _tmp233_;
												_tmp235_ = vala_array_type_new (_tmp231_, 1, _tmp234_);
												_vala_code_node_unref0 (param_type);
												param_type = (ValaDataType*) _tmp235_;
												_tmp236_ = p;
												_tmp237_ = param_type;
												vala_variable_set_variable_type ((ValaVariable*) _tmp236_, _tmp237_);
												_tmp238_ = out_requested;
												if (!_tmp238_) {
													ValaParameter* _tmp239_;
													_tmp239_ = p;
													vala_parameter_set_direction (_tmp239_, VALA_PARAMETER_DIRECTION_IN);
												}
												array_requested = TRUE;
											}
										} else {
											gchar** _tmp240_;
											gint _tmp240__length1;
											const gchar* _tmp241_;
											_tmp240_ = nv;
											_tmp240__length1 = nv_length1;
											_tmp241_ = _tmp240_[0];
											if (g_strcmp0 (_tmp241_, "is_out") == 0) {
												gchar** _tmp242_;
												gint _tmp242__length1;
												const gchar* _tmp243_;
												gchar* _tmp244_;
												gchar* _tmp245_;
												gboolean _tmp246_;
												_tmp242_ = nv;
												_tmp242__length1 = nv_length1;
												_tmp243_ = _tmp242_[1];
												_tmp244_ = vala_gidl_parser_eval (self, _tmp243_);
												_tmp245_ = _tmp244_;
												_tmp246_ = g_strcmp0 (_tmp245_, "1") == 0;
												_g_free0 (_tmp245_);
												if (_tmp246_) {
													ValaParameter* _tmp247_;
													gboolean _tmp248_ = FALSE;
													gboolean _tmp249_;
													_tmp247_ = p;
													vala_parameter_set_direction (_tmp247_, VALA_PARAMETER_DIRECTION_OUT);
													out_requested = TRUE;
													_tmp249_ = array_requested;
													if (!_tmp249_) {
														ValaDataType* _tmp250_;
														_tmp250_ = param_type;
														_tmp248_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp250_, VALA_TYPE_ARRAY_TYPE);
													} else {
														_tmp248_ = FALSE;
													}
													if (_tmp248_) {
														ValaArrayType* array_type = NULL;
														ValaDataType* _tmp251_;
														ValaArrayType* _tmp252_;
														ValaArrayType* _tmp253_;
														ValaDataType* _tmp254_;
														ValaDataType* _tmp255_;
														ValaDataType* _tmp256_;
														ValaParameter* _tmp257_;
														ValaDataType* _tmp258_;
														_tmp251_ = param_type;
														_tmp252_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp251_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
														array_type = _tmp252_;
														_tmp253_ = array_type;
														_tmp254_ = vala_array_type_get_element_type (_tmp253_);
														_tmp255_ = _tmp254_;
														_tmp256_ = _vala_code_node_ref0 (_tmp255_);
														_vala_code_node_unref0 (param_type);
														param_type = _tmp256_;
														_tmp257_ = p;
														_tmp258_ = param_type;
														vala_variable_set_variable_type ((ValaVariable*) _tmp257_, _tmp258_);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												gchar** _tmp259_;
												gint _tmp259__length1;
												const gchar* _tmp260_;
												_tmp259_ = nv;
												_tmp259__length1 = nv_length1;
												_tmp260_ = _tmp259_[0];
												if (g_strcmp0 (_tmp260_, "is_ref") == 0) {
													gchar** _tmp261_;
													gint _tmp261__length1;
													const gchar* _tmp262_;
													gchar* _tmp263_;
													gchar* _tmp264_;
													gboolean _tmp265_;
													_tmp261_ = nv;
													_tmp261__length1 = nv_length1;
													_tmp262_ = _tmp261_[1];
													_tmp263_ = vala_gidl_parser_eval (self, _tmp262_);
													_tmp264_ = _tmp263_;
													_tmp265_ = g_strcmp0 (_tmp264_, "1") == 0;
													_g_free0 (_tmp264_);
													if (_tmp265_) {
														ValaParameter* _tmp266_;
														gboolean _tmp267_ = FALSE;
														gboolean _tmp268_;
														_tmp266_ = p;
														vala_parameter_set_direction (_tmp266_, VALA_PARAMETER_DIRECTION_REF);
														_tmp268_ = array_requested;
														if (!_tmp268_) {
															ValaDataType* _tmp269_;
															_tmp269_ = param_type;
															_tmp267_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp269_, VALA_TYPE_ARRAY_TYPE);
														} else {
															_tmp267_ = FALSE;
														}
														if (_tmp267_) {
															ValaArrayType* array_type = NULL;
															ValaDataType* _tmp270_;
															ValaArrayType* _tmp271_;
															ValaArrayType* _tmp272_;
															ValaDataType* _tmp273_;
															ValaDataType* _tmp274_;
															ValaDataType* _tmp275_;
															ValaParameter* _tmp276_;
															ValaDataType* _tmp277_;
															_tmp270_ = param_type;
															_tmp271_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp270_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
															array_type = _tmp271_;
															_tmp272_ = array_type;
															_tmp273_ = vala_array_type_get_element_type (_tmp272_);
															_tmp274_ = _tmp273_;
															_tmp275_ = _vala_code_node_ref0 (_tmp274_);
															_vala_code_node_unref0 (param_type);
															param_type = _tmp275_;
															_tmp276_ = p;
															_tmp277_ = param_type;
															vala_variable_set_variable_type ((ValaVariable*) _tmp276_, _tmp277_);
															_vala_code_node_unref0 (array_type);
														}
													}
												} else {
													gchar** _tmp278_;
													gint _tmp278__length1;
													const gchar* _tmp279_;
													_tmp278_ = nv;
													_tmp278__length1 = nv_length1;
													_tmp279_ = _tmp278_[0];
													if (g_strcmp0 (_tmp279_, "takes_ownership") == 0) {
														gchar** _tmp280_;
														gint _tmp280__length1;
														const gchar* _tmp281_;
														gchar* _tmp282_;
														gchar* _tmp283_;
														gboolean _tmp284_;
														_tmp280_ = nv;
														_tmp280__length1 = nv_length1;
														_tmp281_ = _tmp280_[1];
														_tmp282_ = vala_gidl_parser_eval (self, _tmp281_);
														_tmp283_ = _tmp282_;
														_tmp284_ = g_strcmp0 (_tmp283_, "1") == 0;
														_g_free0 (_tmp283_);
														if (_tmp284_) {
															ValaDataType* _tmp285_;
															_tmp285_ = param_type;
															vala_data_type_set_value_owned (_tmp285_, TRUE);
														}
													} else {
														gchar** _tmp286_;
														gint _tmp286__length1;
														const gchar* _tmp287_;
														_tmp286_ = nv;
														_tmp286__length1 = nv_length1;
														_tmp287_ = _tmp286_[0];
														if (g_strcmp0 (_tmp287_, "nullable") == 0) {
															gchar** _tmp288_;
															gint _tmp288__length1;
															const gchar* _tmp289_;
															gchar* _tmp290_;
															gchar* _tmp291_;
															gboolean _tmp292_;
															_tmp288_ = nv;
															_tmp288__length1 = nv_length1;
															_tmp289_ = _tmp288_[1];
															_tmp290_ = vala_gidl_parser_eval (self, _tmp289_);
															_tmp291_ = _tmp290_;
															_tmp292_ = g_strcmp0 (_tmp291_, "1") == 0;
															_g_free0 (_tmp291_);
															if (_tmp292_) {
																ValaDataType* _tmp293_;
																_tmp293_ = param_type;
																vala_data_type_set_nullable (_tmp293_, TRUE);
															}
														} else {
															gchar** _tmp294_;
															gint _tmp294__length1;
															const gchar* _tmp295_;
															_tmp294_ = nv;
															_tmp294__length1 = nv_length1;
															_tmp295_ = _tmp294_[0];
															if (g_strcmp0 (_tmp295_, "type_arguments") == 0) {
																ValaDataType* _tmp296_;
																gchar** _tmp297_;
																gint _tmp297__length1;
																const gchar* _tmp298_;
																gchar* _tmp299_;
																gchar* _tmp300_;
																_tmp296_ = param_type;
																_tmp297_ = nv;
																_tmp297__length1 = nv_length1;
																_tmp298_ = _tmp297_[1];
																_tmp299_ = vala_gidl_parser_eval (self, _tmp298_);
																_tmp300_ = _tmp299_;
																vala_gidl_parser_parse_type_arguments_from_string (self, _tmp296_, _tmp300_, NULL);
																_g_free0 (_tmp300_);
															} else {
																gchar** _tmp301_;
																gint _tmp301__length1;
																const gchar* _tmp302_;
																_tmp301_ = nv;
																_tmp301__length1 = nv_length1;
																_tmp302_ = _tmp301_[0];
																if (g_strcmp0 (_tmp302_, "no_array_length") == 0) {
																	gchar** _tmp303_;
																	gint _tmp303__length1;
																	const gchar* _tmp304_;
																	gchar* _tmp305_;
																	gchar* _tmp306_;
																	gboolean _tmp307_;
																	_tmp303_ = nv;
																	_tmp303__length1 = nv_length1;
																	_tmp304_ = _tmp303_[1];
																	_tmp305_ = vala_gidl_parser_eval (self, _tmp304_);
																	_tmp306_ = _tmp305_;
																	_tmp307_ = g_strcmp0 (_tmp306_, "1") == 0;
																	_g_free0 (_tmp306_);
																	if (_tmp307_) {
																		ValaParameter* _tmp308_;
																		_tmp308_ = p;
																		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp308_, "CCode", "array_length", FALSE, NULL);
																	}
																} else {
																	gchar** _tmp309_;
																	gint _tmp309__length1;
																	const gchar* _tmp310_;
																	_tmp309_ = nv;
																	_tmp309__length1 = nv_length1;
																	_tmp310_ = _tmp309_[0];
																	if (g_strcmp0 (_tmp310_, "array_length_type") == 0) {
																		ValaParameter* _tmp311_;
																		gchar** _tmp312_;
																		gint _tmp312__length1;
																		const gchar* _tmp313_;
																		gchar* _tmp314_;
																		gchar* _tmp315_;
																		_tmp311_ = p;
																		_tmp312_ = nv;
																		_tmp312__length1 = nv_length1;
																		_tmp313_ = _tmp312_[1];
																		_tmp314_ = vala_gidl_parser_eval (self, _tmp313_);
																		_tmp315_ = _tmp314_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp311_, "CCode", "array_length_type", _tmp315_, NULL);
																		_g_free0 (_tmp315_);
																	} else {
																		gchar** _tmp316_;
																		gint _tmp316__length1;
																		const gchar* _tmp317_;
																		_tmp316_ = nv;
																		_tmp316__length1 = nv_length1;
																		_tmp317_ = _tmp316_[0];
																		if (g_strcmp0 (_tmp317_, "array_null_terminated") == 0) {
																			gchar** _tmp318_;
																			gint _tmp318__length1;
																			const gchar* _tmp319_;
																			gchar* _tmp320_;
																			gchar* _tmp321_;
																			gboolean _tmp322_;
																			_tmp318_ = nv;
																			_tmp318__length1 = nv_length1;
																			_tmp319_ = _tmp318_[1];
																			_tmp320_ = vala_gidl_parser_eval (self, _tmp319_);
																			_tmp321_ = _tmp320_;
																			_tmp322_ = g_strcmp0 (_tmp321_, "1") == 0;
																			_g_free0 (_tmp321_);
																			if (_tmp322_) {
																				ValaParameter* _tmp323_;
																				ValaParameter* _tmp324_;
																				_tmp323_ = p;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp323_, "CCode", "array_length", FALSE, NULL);
																				_tmp324_ = p;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp324_, "CCode", "array_null_terminated", TRUE, NULL);
																			}
																		} else {
																			gchar** _tmp325_;
																			gint _tmp325__length1;
																			const gchar* _tmp326_;
																			_tmp325_ = nv;
																			_tmp325__length1 = nv_length1;
																			_tmp326_ = _tmp325_[0];
																			if (g_strcmp0 (_tmp326_, "type_name") == 0) {
																				ValaParameter* _tmp327_;
																				gchar** _tmp328_;
																				gint _tmp328__length1;
																				const gchar* _tmp329_;
																				gchar* _tmp330_;
																				gchar* _tmp331_;
																				ValaDataType* _tmp332_;
																				ValaDataType* _tmp333_;
																				_tmp327_ = p;
																				_tmp328_ = nv;
																				_tmp328__length1 = nv_length1;
																				_tmp329_ = _tmp328_[1];
																				_tmp330_ = vala_gidl_parser_eval (self, _tmp329_);
																				_tmp331_ = _tmp330_;
																				_tmp332_ = vala_gidl_parser_parse_type_from_string (self, _tmp331_, FALSE, NULL);
																				_vala_code_node_unref0 (param_type);
																				param_type = _tmp332_;
																				_tmp333_ = param_type;
																				vala_variable_set_variable_type ((ValaVariable*) _tmp327_, _tmp333_);
																				_g_free0 (_tmp331_);
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
								}
							}
						}
					}
					_tmp335_ = show_param;
					if (_tmp335_) {
						_tmp334_ = TRUE;
					} else {
						gboolean _tmp336_;
						_tmp336_ = hide_param;
						_tmp334_ = !_tmp336_;
					}
					if (_tmp334_) {
						ValaDelegate* _tmp337_;
						ValaParameter* _tmp338_;
						_tmp337_ = cb;
						_tmp338_ = p;
						vala_callable_add_parameter ((ValaCallable*) _tmp337_, _tmp338_);
					}
					_vala_code_node_unref0 (p);
					_vala_code_node_unref0 (param_type);
					_g_free0 (param_name);
				}
				_tmp339_ = remaining_params;
				remaining_params = _tmp339_ - 1;
			}
		}
	}
	_tmp341_ = suppress_throws;
	if (_tmp341_ == FALSE) {
		const gchar* _tmp342_;
		_tmp342_ = error_types;
		_tmp340_ = _tmp342_ != NULL;
	} else {
		_tmp340_ = FALSE;
	}
	if (_tmp340_) {
		gchar** type_args = NULL;
		const gchar* _tmp343_;
		gchar* _tmp344_;
		gchar* _tmp345_;
		gchar** _tmp346_;
		gchar** _tmp347_;
		gchar** _tmp348_;
		gint _tmp348__length1;
		gint type_args_length1;
		gint _type_args_size_;
		gchar** _tmp349_;
		gint _tmp349__length1;
		_tmp343_ = error_types;
		_tmp344_ = vala_gidl_parser_eval (self, _tmp343_);
		_tmp345_ = _tmp344_;
		_tmp347_ = _tmp346_ = g_strsplit (_tmp345_, ",", 0);
		_tmp348_ = _tmp347_;
		_tmp348__length1 = _vala_array_length (_tmp346_);
		_g_free0 (_tmp345_);
		type_args = _tmp348_;
		type_args_length1 = _tmp348__length1;
		_type_args_size_ = type_args_length1;
		_tmp349_ = type_args;
		_tmp349__length1 = type_args_length1;
		{
			gchar** type_arg_collection = NULL;
			gint type_arg_collection_length1 = 0;
			gint _type_arg_collection_size_ = 0;
			gint type_arg_it = 0;
			type_arg_collection = _tmp349_;
			type_arg_collection_length1 = _tmp349__length1;
			for (type_arg_it = 0; type_arg_it < type_arg_collection_length1; type_arg_it = type_arg_it + 1) {
				const gchar* type_arg = NULL;
				type_arg = type_arg_collection[type_arg_it];
				{
					ValaDelegate* _tmp350_;
					const gchar* _tmp351_;
					ValaDataType* _tmp352_;
					ValaDataType* _tmp353_;
					_tmp350_ = cb;
					_tmp351_ = type_arg;
					_tmp352_ = vala_gidl_parser_parse_type_from_string (self, _tmp351_, TRUE, NULL);
					_tmp353_ = _tmp352_;
					vala_code_node_add_error_type ((ValaCodeNode*) _tmp350_, _tmp353_);
					_vala_code_node_unref0 (_tmp353_);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	result = cb;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gboolean
vala_gidl_parser_is_reference_type (ValaGIdlParser* self,
                                    const gchar* cname)
{
	gboolean result = FALSE;
	gchar** st_attributes = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint st_attributes_length1;
	gint _st_attributes_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cname != NULL, FALSE);
	_tmp1_ = vala_gidl_parser_get_attributes (self, cname, &_tmp0_);
	st_attributes = _tmp1_;
	st_attributes_length1 = _tmp0_;
	_st_attributes_size_ = st_attributes_length1;
	_tmp2_ = st_attributes;
	_tmp2__length1 = st_attributes_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = st_attributes;
		_tmp3__length1 = st_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp3_;
			attr_collection_length1 = _tmp3__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp4_;
				gchar* attr = NULL;
				_tmp4_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp4_;
				{
					gchar** nv = NULL;
					const gchar* _tmp5_;
					gchar** _tmp6_;
					gchar** _tmp7_;
					gint nv_length1;
					gint _nv_size_;
					gboolean _tmp8_ = FALSE;
					gchar** _tmp9_;
					gint _tmp9__length1;
					const gchar* _tmp10_;
					_tmp5_ = attr;
					_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "=", 2);
					nv = _tmp7_;
					nv_length1 = _vala_array_length (_tmp6_);
					_nv_size_ = nv_length1;
					_tmp9_ = nv;
					_tmp9__length1 = nv_length1;
					_tmp10_ = _tmp9_[0];
					if (g_strcmp0 (_tmp10_, "is_value_type") == 0) {
						gchar** _tmp11_;
						gint _tmp11__length1;
						const gchar* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp11_ = nv;
						_tmp11__length1 = nv_length1;
						_tmp12_ = _tmp11_[1];
						_tmp13_ = vala_gidl_parser_eval (self, _tmp12_);
						_tmp14_ = _tmp13_;
						_tmp8_ = g_strcmp0 (_tmp14_, "1") == 0;
						_g_free0 (_tmp14_);
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						result = FALSE;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	result = TRUE;
	st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void
vala_gidl_parser_parse_struct (ValaGIdlParser* self,
                               GIdlNodeStruct* st_node,
                               ValaSymbol* container,
                               GIdlModule* module)
{
	GIdlNode* node = NULL;
	gboolean _tmp0_;
	gchar* name = NULL;
	GIdlNode* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GIdlNode* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) st_node;
	_tmp0_ = st_node->deprecated;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = node;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = vala_gidl_parser_fix_type_name (self, _tmp2_, container);
	name = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->name;
	if (!vala_gidl_parser_is_reference_type (self, _tmp5_)) {
		ValaStruct* st = NULL;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		const gchar* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaStruct* _tmp10_;
		ValaStruct* _tmp11_;
		ValaStruct* _tmp136_;
		ValaTypeSymbol* _tmp137_;
		GList* _tmp138_;
		_tmp6_ = vala_symbol_get_scope (container);
		_tmp7_ = _tmp6_;
		_tmp8_ = name;
		_tmp9_ = vala_scope_lookup (_tmp7_, _tmp8_);
		_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp9_) : NULL;
		if (_tmp10_ == NULL) {
			_vala_code_node_unref0 (_tmp9_);
		}
		st = _tmp10_;
		_tmp11_ = st;
		if (_tmp11_ == NULL) {
			const gchar* _tmp12_;
			ValaSourceReference* _tmp13_;
			ValaStruct* _tmp14_;
			ValaStruct* _tmp15_;
			gchar** st_attributes = NULL;
			GIdlNode* _tmp16_;
			const gchar* _tmp17_;
			gint _tmp18_ = 0;
			gchar** _tmp19_;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			ValaStruct* _tmp133_;
			ValaSourceFile* _tmp134_;
			ValaStruct* _tmp135_;
			_tmp12_ = name;
			_tmp13_ = self->priv->current_source_reference;
			_tmp14_ = vala_struct_new (_tmp12_, _tmp13_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp14_;
			_tmp15_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp15_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp16_ = node;
			_tmp17_ = _tmp16_->name;
			_tmp19_ = vala_gidl_parser_get_attributes (self, _tmp17_, &_tmp18_);
			st_attributes = _tmp19_;
			st_attributes_length1 = _tmp18_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp20_ = st_attributes;
			_tmp20__length1 = st_attributes_length1;
			if (_tmp20_ != NULL) {
				gchar** _tmp21_;
				gint _tmp21__length1;
				_tmp21_ = st_attributes;
				_tmp21__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp21_;
					attr_collection_length1 = _tmp21__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp22_;
						gchar* attr = NULL;
						_tmp22_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp22_;
						{
							gchar** nv = NULL;
							const gchar* _tmp23_;
							gchar** _tmp24_;
							gchar** _tmp25_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp26_;
							gint _tmp26__length1;
							const gchar* _tmp27_;
							_tmp23_ = attr;
							_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "=", 2);
							nv = _tmp25_;
							nv_length1 = _vala_array_length (_tmp24_);
							_nv_size_ = nv_length1;
							_tmp26_ = nv;
							_tmp26__length1 = nv_length1;
							_tmp27_ = _tmp26_[0];
							if (g_strcmp0 (_tmp27_, "cheader_filename") == 0) {
								ValaStruct* _tmp28_;
								gchar** _tmp29_;
								gint _tmp29__length1;
								const gchar* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_;
								_tmp28_ = st;
								_tmp29_ = nv;
								_tmp29__length1 = nv_length1;
								_tmp30_ = _tmp29_[1];
								_tmp31_ = vala_gidl_parser_eval (self, _tmp30_);
								_tmp32_ = _tmp31_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp28_, "CCode", "cheader_filename", _tmp32_, NULL);
								_g_free0 (_tmp32_);
							} else {
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								_tmp33_ = nv;
								_tmp33__length1 = nv_length1;
								_tmp34_ = _tmp33_[0];
								if (g_strcmp0 (_tmp34_, "hidden") == 0) {
									gchar** _tmp35_;
									gint _tmp35__length1;
									const gchar* _tmp36_;
									gchar* _tmp37_;
									gchar* _tmp38_;
									gboolean _tmp39_;
									_tmp35_ = nv;
									_tmp35__length1 = nv_length1;
									_tmp36_ = _tmp35_[1];
									_tmp37_ = vala_gidl_parser_eval (self, _tmp36_);
									_tmp38_ = _tmp37_;
									_tmp39_ = g_strcmp0 (_tmp38_, "1") == 0;
									_g_free0 (_tmp38_);
									if (_tmp39_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								} else {
									gchar** _tmp40_;
									gint _tmp40__length1;
									const gchar* _tmp41_;
									_tmp40_ = nv;
									_tmp40__length1 = nv_length1;
									_tmp41_ = _tmp40_[0];
									if (g_strcmp0 (_tmp41_, "base_type") == 0) {
										ValaStruct* _tmp42_;
										gchar** _tmp43_;
										gint _tmp43__length1;
										const gchar* _tmp44_;
										gchar* _tmp45_;
										gchar* _tmp46_;
										ValaDataType* _tmp47_;
										ValaDataType* _tmp48_;
										_tmp42_ = st;
										_tmp43_ = nv;
										_tmp43__length1 = nv_length1;
										_tmp44_ = _tmp43_[1];
										_tmp45_ = vala_gidl_parser_eval (self, _tmp44_);
										_tmp46_ = _tmp45_;
										_tmp47_ = vala_gidl_parser_parse_type_string (self, _tmp46_);
										_tmp48_ = _tmp47_;
										vala_struct_set_base_type (_tmp42_, _tmp48_);
										_vala_code_node_unref0 (_tmp48_);
										_g_free0 (_tmp46_);
									} else {
										gchar** _tmp49_;
										gint _tmp49__length1;
										const gchar* _tmp50_;
										_tmp49_ = nv;
										_tmp49__length1 = nv_length1;
										_tmp50_ = _tmp49_[0];
										if (g_strcmp0 (_tmp50_, "rank") == 0) {
											ValaStruct* _tmp51_;
											gchar** _tmp52_;
											gint _tmp52__length1;
											const gchar* _tmp53_;
											gchar* _tmp54_;
											gchar* _tmp55_;
											_tmp51_ = st;
											_tmp52_ = nv;
											_tmp52__length1 = nv_length1;
											_tmp53_ = _tmp52_[1];
											_tmp54_ = vala_gidl_parser_eval (self, _tmp53_);
											_tmp55_ = _tmp54_;
											vala_struct_set_rank (_tmp51_, atoi (_tmp55_));
											_g_free0 (_tmp55_);
										} else {
											gchar** _tmp56_;
											gint _tmp56__length1;
											const gchar* _tmp57_;
											_tmp56_ = nv;
											_tmp56__length1 = nv_length1;
											_tmp57_ = _tmp56_[0];
											if (g_strcmp0 (_tmp57_, "simple_type") == 0) {
												gchar** _tmp58_;
												gint _tmp58__length1;
												const gchar* _tmp59_;
												gchar* _tmp60_;
												gchar* _tmp61_;
												gboolean _tmp62_;
												_tmp58_ = nv;
												_tmp58__length1 = nv_length1;
												_tmp59_ = _tmp58_[1];
												_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
												_tmp61_ = _tmp60_;
												_tmp62_ = g_strcmp0 (_tmp61_, "1") == 0;
												_g_free0 (_tmp61_);
												if (_tmp62_) {
													ValaStruct* _tmp63_;
													_tmp63_ = st;
													vala_struct_set_simple_type (_tmp63_, TRUE);
												}
											} else {
												gchar** _tmp64_;
												gint _tmp64__length1;
												const gchar* _tmp65_;
												_tmp64_ = nv;
												_tmp64__length1 = nv_length1;
												_tmp65_ = _tmp64_[0];
												if (g_strcmp0 (_tmp65_, "immutable") == 0) {
													gchar** _tmp66_;
													gint _tmp66__length1;
													const gchar* _tmp67_;
													gchar* _tmp68_;
													gchar* _tmp69_;
													gboolean _tmp70_;
													_tmp66_ = nv;
													_tmp66__length1 = nv_length1;
													_tmp67_ = _tmp66_[1];
													_tmp68_ = vala_gidl_parser_eval (self, _tmp67_);
													_tmp69_ = _tmp68_;
													_tmp70_ = g_strcmp0 (_tmp69_, "1") == 0;
													_g_free0 (_tmp69_);
													if (_tmp70_) {
														ValaStruct* _tmp71_;
														_tmp71_ = st;
														vala_code_node_set_attribute ((ValaCodeNode*) _tmp71_, "Immutable", TRUE, NULL);
													}
												} else {
													gchar** _tmp72_;
													gint _tmp72__length1;
													const gchar* _tmp73_;
													_tmp72_ = nv;
													_tmp72__length1 = nv_length1;
													_tmp73_ = _tmp72_[0];
													if (g_strcmp0 (_tmp73_, "has_type_id") == 0) {
														gchar** _tmp74_;
														gint _tmp74__length1;
														const gchar* _tmp75_;
														gchar* _tmp76_;
														gchar* _tmp77_;
														gboolean _tmp78_;
														_tmp74_ = nv;
														_tmp74__length1 = nv_length1;
														_tmp75_ = _tmp74_[1];
														_tmp76_ = vala_gidl_parser_eval (self, _tmp75_);
														_tmp77_ = _tmp76_;
														_tmp78_ = g_strcmp0 (_tmp77_, "0") == 0;
														_g_free0 (_tmp77_);
														if (_tmp78_) {
															ValaStruct* _tmp79_;
															_tmp79_ = st;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp79_, "CCode", "has_type_id", FALSE, NULL);
														}
													} else {
														gchar** _tmp80_;
														gint _tmp80__length1;
														const gchar* _tmp81_;
														_tmp80_ = nv;
														_tmp80__length1 = nv_length1;
														_tmp81_ = _tmp80_[0];
														if (g_strcmp0 (_tmp81_, "type_id") == 0) {
															ValaStruct* _tmp82_;
															gchar** _tmp83_;
															gint _tmp83__length1;
															const gchar* _tmp84_;
															gchar* _tmp85_;
															gchar* _tmp86_;
															_tmp82_ = st;
															_tmp83_ = nv;
															_tmp83__length1 = nv_length1;
															_tmp84_ = _tmp83_[1];
															_tmp85_ = vala_gidl_parser_eval (self, _tmp84_);
															_tmp86_ = _tmp85_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp82_, "CCode", "type_id", _tmp86_, NULL);
															_g_free0 (_tmp86_);
														} else {
															gchar** _tmp87_;
															gint _tmp87__length1;
															const gchar* _tmp88_;
															_tmp87_ = nv;
															_tmp87__length1 = nv_length1;
															_tmp88_ = _tmp87_[0];
															if (g_strcmp0 (_tmp88_, "has_copy_function") == 0) {
																gchar** _tmp89_;
																gint _tmp89__length1;
																const gchar* _tmp90_;
																gchar* _tmp91_;
																gchar* _tmp92_;
																gboolean _tmp93_;
																_tmp89_ = nv;
																_tmp89__length1 = nv_length1;
																_tmp90_ = _tmp89_[1];
																_tmp91_ = vala_gidl_parser_eval (self, _tmp90_);
																_tmp92_ = _tmp91_;
																_tmp93_ = g_strcmp0 (_tmp92_, "0") == 0;
																_g_free0 (_tmp92_);
																if (_tmp93_) {
																	ValaStruct* _tmp94_;
																	_tmp94_ = st;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp94_, "CCode", "has_copy_function", FALSE, NULL);
																}
															} else {
																gchar** _tmp95_;
																gint _tmp95__length1;
																const gchar* _tmp96_;
																_tmp95_ = nv;
																_tmp95__length1 = nv_length1;
																_tmp96_ = _tmp95_[0];
																if (g_strcmp0 (_tmp96_, "deprecated") == 0) {
																	gchar** _tmp97_;
																	gint _tmp97__length1;
																	const gchar* _tmp98_;
																	gchar* _tmp99_;
																	gchar* _tmp100_;
																	gboolean _tmp101_;
																	_tmp97_ = nv;
																	_tmp97__length1 = nv_length1;
																	_tmp98_ = _tmp97_[1];
																	_tmp99_ = vala_gidl_parser_eval (self, _tmp98_);
																	_tmp100_ = _tmp99_;
																	_tmp101_ = g_strcmp0 (_tmp100_, "1") == 0;
																	_g_free0 (_tmp100_);
																	if (_tmp101_) {
																		ValaStruct* _tmp102_;
																		_tmp102_ = st;
																		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp102_, "Version", "deprecated", TRUE, NULL);
																	}
																} else {
																	gchar** _tmp103_;
																	gint _tmp103__length1;
																	const gchar* _tmp104_;
																	_tmp103_ = nv;
																	_tmp103__length1 = nv_length1;
																	_tmp104_ = _tmp103_[0];
																	if (g_strcmp0 (_tmp104_, "replacement") == 0) {
																		ValaStruct* _tmp105_;
																		gchar** _tmp106_;
																		gint _tmp106__length1;
																		const gchar* _tmp107_;
																		gchar* _tmp108_;
																		gchar* _tmp109_;
																		_tmp105_ = st;
																		_tmp106_ = nv;
																		_tmp106__length1 = nv_length1;
																		_tmp107_ = _tmp106_[1];
																		_tmp108_ = vala_gidl_parser_eval (self, _tmp107_);
																		_tmp109_ = _tmp108_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp105_, "Version", "replacement", _tmp109_, NULL);
																		_g_free0 (_tmp109_);
																	} else {
																		gchar** _tmp110_;
																		gint _tmp110__length1;
																		const gchar* _tmp111_;
																		_tmp110_ = nv;
																		_tmp110__length1 = nv_length1;
																		_tmp111_ = _tmp110_[0];
																		if (g_strcmp0 (_tmp111_, "deprecated_since") == 0) {
																			ValaStruct* _tmp112_;
																			gchar** _tmp113_;
																			gint _tmp113__length1;
																			const gchar* _tmp114_;
																			gchar* _tmp115_;
																			gchar* _tmp116_;
																			_tmp112_ = st;
																			_tmp113_ = nv;
																			_tmp113__length1 = nv_length1;
																			_tmp114_ = _tmp113_[1];
																			_tmp115_ = vala_gidl_parser_eval (self, _tmp114_);
																			_tmp116_ = _tmp115_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp112_, "Version", "deprecated_since", _tmp116_, NULL);
																			_g_free0 (_tmp116_);
																		} else {
																			gchar** _tmp117_;
																			gint _tmp117__length1;
																			const gchar* _tmp118_;
																			_tmp117_ = nv;
																			_tmp117__length1 = nv_length1;
																			_tmp118_ = _tmp117_[0];
																			if (g_strcmp0 (_tmp118_, "has_destroy_function") == 0) {
																				gchar** _tmp119_;
																				gint _tmp119__length1;
																				const gchar* _tmp120_;
																				gchar* _tmp121_;
																				gchar* _tmp122_;
																				gboolean _tmp123_;
																				_tmp119_ = nv;
																				_tmp119__length1 = nv_length1;
																				_tmp120_ = _tmp119_[1];
																				_tmp121_ = vala_gidl_parser_eval (self, _tmp120_);
																				_tmp122_ = _tmp121_;
																				_tmp123_ = g_strcmp0 (_tmp122_, "0") == 0;
																				_g_free0 (_tmp122_);
																				if (_tmp123_) {
																					ValaStruct* _tmp124_;
																					_tmp124_ = st;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp124_, "CCode", "has_destroy_function", FALSE, NULL);
																				}
																			} else {
																				gchar** _tmp125_;
																				gint _tmp125__length1;
																				const gchar* _tmp126_;
																				_tmp125_ = nv;
																				_tmp125__length1 = nv_length1;
																				_tmp126_ = _tmp125_[0];
																				if (g_strcmp0 (_tmp126_, "experimental") == 0) {
																					gchar** _tmp127_;
																					gint _tmp127__length1;
																					const gchar* _tmp128_;
																					gchar* _tmp129_;
																					gchar* _tmp130_;
																					gboolean _tmp131_;
																					_tmp127_ = nv;
																					_tmp127__length1 = nv_length1;
																					_tmp128_ = _tmp127_[1];
																					_tmp129_ = vala_gidl_parser_eval (self, _tmp128_);
																					_tmp130_ = _tmp129_;
																					_tmp131_ = g_strcmp0 (_tmp130_, "1") == 0;
																					_g_free0 (_tmp130_);
																					if (_tmp131_) {
																						ValaStruct* _tmp132_;
																						_tmp132_ = st;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp132_, "Version", "experimental", TRUE, NULL);
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp133_ = st;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp133_);
			_tmp134_ = self->priv->current_source_file;
			_tmp135_ = st;
			vala_source_file_add_node (_tmp134_, (ValaCodeNode*) _tmp135_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp136_ = st;
		_tmp137_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp136_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp137_;
		_tmp138_ = st_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp138_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp139_;
					GIdlNodeTypeId _tmp140_;
					_tmp139_ = member;
					_tmp140_ = _tmp139_->type;
					if (_tmp140_ == G_IDL_NODE_FUNCTION) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp141_;
						ValaMethod* _tmp142_;
						ValaMethod* _tmp143_;
						_tmp141_ = member;
						_tmp142_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp141_, FALSE);
						m = _tmp142_;
						_tmp143_ = m;
						if (_tmp143_ != NULL) {
							ValaStruct* _tmp144_;
							ValaMethod* _tmp145_;
							_tmp144_ = st;
							_tmp145_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp144_, _tmp145_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp146_;
						GIdlNodeTypeId _tmp147_;
						_tmp146_ = member;
						_tmp147_ = _tmp146_->type;
						if (_tmp147_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp148_;
							ValaField* _tmp149_;
							ValaField* _tmp150_;
							_tmp148_ = member;
							_tmp149_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp148_);
							f = _tmp149_;
							_tmp150_ = f;
							if (_tmp150_ != NULL) {
								ValaStruct* _tmp151_;
								ValaField* _tmp152_;
								_tmp151_ = st;
								_tmp152_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp151_, _tmp152_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void = FALSE;
		gchar* ref_function = NULL;
		gchar* unref_function = NULL;
		gchar* copy_function = NULL;
		gchar* free_function = NULL;
		ValaClass* cl = NULL;
		ValaScope* _tmp153_;
		ValaScope* _tmp154_;
		const gchar* _tmp155_;
		ValaSymbol* _tmp156_;
		ValaClass* _tmp157_;
		ValaClass* _tmp158_;
		ValaClass* _tmp314_;
		ValaTypeSymbol* _tmp315_;
		GList* _tmp316_;
		const gchar* _tmp367_;
		const gchar* _tmp376_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp153_ = vala_symbol_get_scope (container);
		_tmp154_ = _tmp153_;
		_tmp155_ = name;
		_tmp156_ = vala_scope_lookup (_tmp154_, _tmp155_);
		_tmp157_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp156_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp156_) : NULL;
		if (_tmp157_ == NULL) {
			_vala_code_node_unref0 (_tmp156_);
		}
		cl = _tmp157_;
		_tmp158_ = cl;
		if (_tmp158_ == NULL) {
			gchar* base_class = NULL;
			gboolean is_fundamental = FALSE;
			const gchar* _tmp159_;
			ValaSourceReference* _tmp160_;
			ValaClass* _tmp161_;
			ValaClass* _tmp162_;
			gchar** cl_attributes = NULL;
			GIdlNode* _tmp163_;
			const gchar* _tmp164_;
			gint _tmp165_ = 0;
			gchar** _tmp166_;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp167_;
			gint _tmp167__length1;
			ValaClass* _tmp302_;
			ValaSourceFile* _tmp303_;
			ValaClass* _tmp304_;
			const gchar* _tmp305_;
			gboolean _tmp310_ = FALSE;
			const gchar* _tmp311_;
			base_class = NULL;
			is_fundamental = FALSE;
			_tmp159_ = name;
			_tmp160_ = self->priv->current_source_reference;
			_tmp161_ = vala_class_new (_tmp159_, _tmp160_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp161_;
			_tmp162_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp162_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp163_ = node;
			_tmp164_ = _tmp163_->name;
			_tmp166_ = vala_gidl_parser_get_attributes (self, _tmp164_, &_tmp165_);
			cl_attributes = _tmp166_;
			cl_attributes_length1 = _tmp165_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp167_ = cl_attributes;
			_tmp167__length1 = cl_attributes_length1;
			if (_tmp167_ != NULL) {
				gchar** _tmp168_;
				gint _tmp168__length1;
				_tmp168_ = cl_attributes;
				_tmp168__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp168_;
					attr_collection_length1 = _tmp168__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp169_;
						gchar* attr = NULL;
						_tmp169_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp169_;
						{
							gchar** nv = NULL;
							const gchar* _tmp170_;
							gchar** _tmp171_;
							gchar** _tmp172_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp173_;
							gint _tmp173__length1;
							const gchar* _tmp174_;
							_tmp170_ = attr;
							_tmp172_ = _tmp171_ = g_strsplit (_tmp170_, "=", 2);
							nv = _tmp172_;
							nv_length1 = _vala_array_length (_tmp171_);
							_nv_size_ = nv_length1;
							_tmp173_ = nv;
							_tmp173__length1 = nv_length1;
							_tmp174_ = _tmp173_[0];
							if (g_strcmp0 (_tmp174_, "cheader_filename") == 0) {
								ValaClass* _tmp175_;
								gchar** _tmp176_;
								gint _tmp176__length1;
								const gchar* _tmp177_;
								gchar* _tmp178_;
								gchar* _tmp179_;
								_tmp175_ = cl;
								_tmp176_ = nv;
								_tmp176__length1 = nv_length1;
								_tmp177_ = _tmp176_[1];
								_tmp178_ = vala_gidl_parser_eval (self, _tmp177_);
								_tmp179_ = _tmp178_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp175_, "CCode", "cheader_filename", _tmp179_, NULL);
								_g_free0 (_tmp179_);
							} else {
								gchar** _tmp180_;
								gint _tmp180__length1;
								const gchar* _tmp181_;
								_tmp180_ = nv;
								_tmp180__length1 = nv_length1;
								_tmp181_ = _tmp180_[0];
								if (g_strcmp0 (_tmp181_, "base_class") == 0) {
									gchar** _tmp182_;
									gint _tmp182__length1;
									const gchar* _tmp183_;
									gchar* _tmp184_;
									_tmp182_ = nv;
									_tmp182__length1 = nv_length1;
									_tmp183_ = _tmp182_[1];
									_tmp184_ = vala_gidl_parser_eval (self, _tmp183_);
									_g_free0 (base_class);
									base_class = _tmp184_;
								} else {
									gchar** _tmp185_;
									gint _tmp185__length1;
									const gchar* _tmp186_;
									_tmp185_ = nv;
									_tmp185__length1 = nv_length1;
									_tmp186_ = _tmp185_[0];
									if (g_strcmp0 (_tmp186_, "hidden") == 0) {
										gchar** _tmp187_;
										gint _tmp187__length1;
										const gchar* _tmp188_;
										gchar* _tmp189_;
										gchar* _tmp190_;
										gboolean _tmp191_;
										_tmp187_ = nv;
										_tmp187__length1 = nv_length1;
										_tmp188_ = _tmp187_[1];
										_tmp189_ = vala_gidl_parser_eval (self, _tmp188_);
										_tmp190_ = _tmp189_;
										_tmp191_ = g_strcmp0 (_tmp190_, "1") == 0;
										_g_free0 (_tmp190_);
										if (_tmp191_) {
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (base_class);
											_vala_code_node_unref0 (cl);
											_g_free0 (free_function);
											_g_free0 (copy_function);
											_g_free0 (unref_function);
											_g_free0 (ref_function);
											_g_free0 (name);
											return;
										}
									} else {
										gchar** _tmp192_;
										gint _tmp192__length1;
										const gchar* _tmp193_;
										_tmp192_ = nv;
										_tmp192__length1 = nv_length1;
										_tmp193_ = _tmp192_[0];
										if (g_strcmp0 (_tmp193_, "is_immutable") == 0) {
											gchar** _tmp194_;
											gint _tmp194__length1;
											const gchar* _tmp195_;
											gchar* _tmp196_;
											gchar* _tmp197_;
											gboolean _tmp198_;
											_tmp194_ = nv;
											_tmp194__length1 = nv_length1;
											_tmp195_ = _tmp194_[1];
											_tmp196_ = vala_gidl_parser_eval (self, _tmp195_);
											_tmp197_ = _tmp196_;
											_tmp198_ = g_strcmp0 (_tmp197_, "1") == 0;
											_g_free0 (_tmp197_);
											if (_tmp198_) {
												ValaClass* _tmp199_;
												_tmp199_ = cl;
												vala_class_set_is_immutable (_tmp199_, TRUE);
											}
										} else {
											gchar** _tmp200_;
											gint _tmp200__length1;
											const gchar* _tmp201_;
											_tmp200_ = nv;
											_tmp200__length1 = nv_length1;
											_tmp201_ = _tmp200_[0];
											if (g_strcmp0 (_tmp201_, "const_cname") == 0) {
												ValaClass* _tmp202_;
												gchar** _tmp203_;
												gint _tmp203__length1;
												const gchar* _tmp204_;
												gchar* _tmp205_;
												gchar* _tmp206_;
												_tmp202_ = cl;
												_tmp203_ = nv;
												_tmp203__length1 = nv_length1;
												_tmp204_ = _tmp203_[1];
												_tmp205_ = vala_gidl_parser_eval (self, _tmp204_);
												_tmp206_ = _tmp205_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp202_, "CCode", "const_cname", _tmp206_, NULL);
												_g_free0 (_tmp206_);
											} else {
												gchar** _tmp207_;
												gint _tmp207__length1;
												const gchar* _tmp208_;
												_tmp207_ = nv;
												_tmp207__length1 = nv_length1;
												_tmp208_ = _tmp207_[0];
												if (g_strcmp0 (_tmp208_, "is_fundamental") == 0) {
													gchar** _tmp209_;
													gint _tmp209__length1;
													const gchar* _tmp210_;
													gchar* _tmp211_;
													gchar* _tmp212_;
													gboolean _tmp213_;
													_tmp209_ = nv;
													_tmp209__length1 = nv_length1;
													_tmp210_ = _tmp209_[1];
													_tmp211_ = vala_gidl_parser_eval (self, _tmp210_);
													_tmp212_ = _tmp211_;
													_tmp213_ = g_strcmp0 (_tmp212_, "1") == 0;
													_g_free0 (_tmp212_);
													if (_tmp213_) {
														is_fundamental = TRUE;
													}
												} else {
													gboolean _tmp214_ = FALSE;
													gchar** _tmp215_;
													gint _tmp215__length1;
													const gchar* _tmp216_;
													_tmp215_ = nv;
													_tmp215__length1 = nv_length1;
													_tmp216_ = _tmp215_[0];
													if (g_strcmp0 (_tmp216_, "abstract") == 0) {
														const gchar* _tmp217_;
														_tmp217_ = base_class;
														_tmp214_ = _tmp217_ != NULL;
													} else {
														_tmp214_ = FALSE;
													}
													if (_tmp214_) {
														gchar** _tmp218_;
														gint _tmp218__length1;
														const gchar* _tmp219_;
														gchar* _tmp220_;
														gchar* _tmp221_;
														gboolean _tmp222_;
														_tmp218_ = nv;
														_tmp218__length1 = nv_length1;
														_tmp219_ = _tmp218_[1];
														_tmp220_ = vala_gidl_parser_eval (self, _tmp219_);
														_tmp221_ = _tmp220_;
														_tmp222_ = g_strcmp0 (_tmp221_, "1") == 0;
														_g_free0 (_tmp221_);
														if (_tmp222_) {
															ValaClass* _tmp223_;
															_tmp223_ = cl;
															vala_class_set_is_abstract (_tmp223_, TRUE);
														}
													} else {
														gchar** _tmp224_;
														gint _tmp224__length1;
														const gchar* _tmp225_;
														_tmp224_ = nv;
														_tmp224__length1 = nv_length1;
														_tmp225_ = _tmp224_[0];
														if (g_strcmp0 (_tmp225_, "free_function") == 0) {
															gchar** _tmp226_;
															gint _tmp226__length1;
															const gchar* _tmp227_;
															gchar* _tmp228_;
															_tmp226_ = nv;
															_tmp226__length1 = nv_length1;
															_tmp227_ = _tmp226_[1];
															_tmp228_ = vala_gidl_parser_eval (self, _tmp227_);
															_g_free0 (free_function);
															free_function = _tmp228_;
														} else {
															gchar** _tmp229_;
															gint _tmp229__length1;
															const gchar* _tmp230_;
															_tmp229_ = nv;
															_tmp229__length1 = nv_length1;
															_tmp230_ = _tmp229_[0];
															if (g_strcmp0 (_tmp230_, "ref_function") == 0) {
																gchar** _tmp231_;
																gint _tmp231__length1;
																const gchar* _tmp232_;
																gchar* _tmp233_;
																_tmp231_ = nv;
																_tmp231__length1 = nv_length1;
																_tmp232_ = _tmp231_[1];
																_tmp233_ = vala_gidl_parser_eval (self, _tmp232_);
																_g_free0 (ref_function);
																ref_function = _tmp233_;
															} else {
																gchar** _tmp234_;
																gint _tmp234__length1;
																const gchar* _tmp235_;
																_tmp234_ = nv;
																_tmp234__length1 = nv_length1;
																_tmp235_ = _tmp234_[0];
																if (g_strcmp0 (_tmp235_, "unref_function") == 0) {
																	gchar** _tmp236_;
																	gint _tmp236__length1;
																	const gchar* _tmp237_;
																	gchar* _tmp238_;
																	_tmp236_ = nv;
																	_tmp236__length1 = nv_length1;
																	_tmp237_ = _tmp236_[1];
																	_tmp238_ = vala_gidl_parser_eval (self, _tmp237_);
																	_g_free0 (unref_function);
																	unref_function = _tmp238_;
																} else {
																	gchar** _tmp239_;
																	gint _tmp239__length1;
																	const gchar* _tmp240_;
																	_tmp239_ = nv;
																	_tmp239__length1 = nv_length1;
																	_tmp240_ = _tmp239_[0];
																	if (g_strcmp0 (_tmp240_, "copy_function") == 0) {
																		gchar** _tmp241_;
																		gint _tmp241__length1;
																		const gchar* _tmp242_;
																		gchar* _tmp243_;
																		_tmp241_ = nv;
																		_tmp241__length1 = nv_length1;
																		_tmp242_ = _tmp241_[1];
																		_tmp243_ = vala_gidl_parser_eval (self, _tmp242_);
																		_g_free0 (copy_function);
																		copy_function = _tmp243_;
																	} else {
																		gchar** _tmp244_;
																		gint _tmp244__length1;
																		const gchar* _tmp245_;
																		_tmp244_ = nv;
																		_tmp244__length1 = nv_length1;
																		_tmp245_ = _tmp244_[0];
																		if (g_strcmp0 (_tmp245_, "ref_function_void") == 0) {
																			gchar** _tmp246_;
																			gint _tmp246__length1;
																			const gchar* _tmp247_;
																			gchar* _tmp248_;
																			gchar* _tmp249_;
																			gboolean _tmp250_;
																			_tmp246_ = nv;
																			_tmp246__length1 = nv_length1;
																			_tmp247_ = _tmp246_[1];
																			_tmp248_ = vala_gidl_parser_eval (self, _tmp247_);
																			_tmp249_ = _tmp248_;
																			_tmp250_ = g_strcmp0 (_tmp249_, "1") == 0;
																			_g_free0 (_tmp249_);
																			if (_tmp250_) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			gchar** _tmp251_;
																			gint _tmp251__length1;
																			const gchar* _tmp252_;
																			_tmp251_ = nv;
																			_tmp251__length1 = nv_length1;
																			_tmp252_ = _tmp251_[0];
																			if (g_strcmp0 (_tmp252_, "deprecated") == 0) {
																				gchar** _tmp253_;
																				gint _tmp253__length1;
																				const gchar* _tmp254_;
																				gchar* _tmp255_;
																				gchar* _tmp256_;
																				gboolean _tmp257_;
																				_tmp253_ = nv;
																				_tmp253__length1 = nv_length1;
																				_tmp254_ = _tmp253_[1];
																				_tmp255_ = vala_gidl_parser_eval (self, _tmp254_);
																				_tmp256_ = _tmp255_;
																				_tmp257_ = g_strcmp0 (_tmp256_, "1") == 0;
																				_g_free0 (_tmp256_);
																				if (_tmp257_) {
																					ValaClass* _tmp258_;
																					_tmp258_ = cl;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp258_, "Version", "deprecated", TRUE, NULL);
																				}
																			} else {
																				gchar** _tmp259_;
																				gint _tmp259__length1;
																				const gchar* _tmp260_;
																				_tmp259_ = nv;
																				_tmp259__length1 = nv_length1;
																				_tmp260_ = _tmp259_[0];
																				if (g_strcmp0 (_tmp260_, "replacement") == 0) {
																					ValaClass* _tmp261_;
																					gchar** _tmp262_;
																					gint _tmp262__length1;
																					const gchar* _tmp263_;
																					gchar* _tmp264_;
																					gchar* _tmp265_;
																					_tmp261_ = cl;
																					_tmp262_ = nv;
																					_tmp262__length1 = nv_length1;
																					_tmp263_ = _tmp262_[1];
																					_tmp264_ = vala_gidl_parser_eval (self, _tmp263_);
																					_tmp265_ = _tmp264_;
																					vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp261_, "Version", "replacement", _tmp265_, NULL);
																					_g_free0 (_tmp265_);
																				} else {
																					gchar** _tmp266_;
																					gint _tmp266__length1;
																					const gchar* _tmp267_;
																					_tmp266_ = nv;
																					_tmp266__length1 = nv_length1;
																					_tmp267_ = _tmp266_[0];
																					if (g_strcmp0 (_tmp267_, "deprecated_since") == 0) {
																						ValaClass* _tmp268_;
																						gchar** _tmp269_;
																						gint _tmp269__length1;
																						const gchar* _tmp270_;
																						gchar* _tmp271_;
																						gchar* _tmp272_;
																						_tmp268_ = cl;
																						_tmp269_ = nv;
																						_tmp269__length1 = nv_length1;
																						_tmp270_ = _tmp269_[1];
																						_tmp271_ = vala_gidl_parser_eval (self, _tmp270_);
																						_tmp272_ = _tmp271_;
																						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp268_, "Version", "deprecated_since", _tmp272_, NULL);
																						_g_free0 (_tmp272_);
																					} else {
																						gchar** _tmp273_;
																						gint _tmp273__length1;
																						const gchar* _tmp274_;
																						_tmp273_ = nv;
																						_tmp273__length1 = nv_length1;
																						_tmp274_ = _tmp273_[0];
																						if (g_strcmp0 (_tmp274_, "type_parameters") == 0) {
																							gchar** _tmp275_;
																							gint _tmp275__length1;
																							const gchar* _tmp276_;
																							gchar* _tmp277_;
																							gchar* _tmp278_;
																							gchar** _tmp279_;
																							gchar** _tmp280_;
																							gchar** _tmp281_;
																							gint _tmp281__length1;
																							_tmp275_ = nv;
																							_tmp275__length1 = nv_length1;
																							_tmp276_ = _tmp275_[1];
																							_tmp277_ = vala_gidl_parser_eval (self, _tmp276_);
																							_tmp278_ = _tmp277_;
																							_tmp280_ = _tmp279_ = g_strsplit (_tmp278_, ",", 0);
																							_tmp281_ = _tmp280_;
																							_tmp281__length1 = _vala_array_length (_tmp279_);
																							_g_free0 (_tmp278_);
																							{
																								gchar** type_param_name_collection = NULL;
																								gint type_param_name_collection_length1 = 0;
																								gint _type_param_name_collection_size_ = 0;
																								gint type_param_name_it = 0;
																								type_param_name_collection = _tmp281_;
																								type_param_name_collection_length1 = _tmp281__length1;
																								for (type_param_name_it = 0; type_param_name_it < type_param_name_collection_length1; type_param_name_it = type_param_name_it + 1) {
																									const gchar* type_param_name = NULL;
																									type_param_name = type_param_name_collection[type_param_name_it];
																									{
																										ValaClass* _tmp282_;
																										const gchar* _tmp283_;
																										ValaSourceReference* _tmp284_;
																										ValaTypeParameter* _tmp285_;
																										ValaTypeParameter* _tmp286_;
																										_tmp282_ = cl;
																										_tmp283_ = type_param_name;
																										_tmp284_ = self->priv->current_source_reference;
																										_tmp285_ = vala_typeparameter_new (_tmp283_, _tmp284_);
																										_tmp286_ = _tmp285_;
																										vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) _tmp282_, _tmp286_);
																										_vala_code_node_unref0 (_tmp286_);
																									}
																								}
																								type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																							}
																						} else {
																							gchar** _tmp287_;
																							gint _tmp287__length1;
																							const gchar* _tmp288_;
																							_tmp287_ = nv;
																							_tmp287__length1 = nv_length1;
																							_tmp288_ = _tmp287_[0];
																							if (g_strcmp0 (_tmp288_, "experimental") == 0) {
																								gchar** _tmp289_;
																								gint _tmp289__length1;
																								const gchar* _tmp290_;
																								gchar* _tmp291_;
																								gchar* _tmp292_;
																								gboolean _tmp293_;
																								_tmp289_ = nv;
																								_tmp289__length1 = nv_length1;
																								_tmp290_ = _tmp289_[1];
																								_tmp291_ = vala_gidl_parser_eval (self, _tmp290_);
																								_tmp292_ = _tmp291_;
																								_tmp293_ = g_strcmp0 (_tmp292_, "1") == 0;
																								_g_free0 (_tmp292_);
																								if (_tmp293_) {
																									ValaClass* _tmp294_;
																									_tmp294_ = cl;
																									vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp294_, "Version", "experimental", TRUE, NULL);
																								}
																							} else {
																								gchar** _tmp295_;
																								gint _tmp295__length1;
																								const gchar* _tmp296_;
																								_tmp295_ = nv;
																								_tmp295__length1 = nv_length1;
																								_tmp296_ = _tmp295_[0];
																								if (g_strcmp0 (_tmp296_, "delegate_target_cname") == 0) {
																									ValaClass* _tmp297_;
																									gchar** _tmp298_;
																									gint _tmp298__length1;
																									const gchar* _tmp299_;
																									gchar* _tmp300_;
																									gchar* _tmp301_;
																									_tmp297_ = cl;
																									_tmp298_ = nv;
																									_tmp298__length1 = nv_length1;
																									_tmp299_ = _tmp298_[1];
																									_tmp300_ = vala_gidl_parser_eval (self, _tmp299_);
																									_tmp301_ = _tmp300_;
																									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp297_, "CCode", "delegate_target_cname", _tmp301_, NULL);
																									_g_free0 (_tmp301_);
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp302_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp302_);
			_tmp303_ = self->priv->current_source_file;
			_tmp304_ = cl;
			vala_source_file_add_node (_tmp303_, (ValaCodeNode*) _tmp304_);
			_tmp305_ = base_class;
			if (_tmp305_ != NULL) {
				ValaDataType* parent = NULL;
				const gchar* _tmp306_;
				ValaDataType* _tmp307_;
				ValaClass* _tmp308_;
				ValaDataType* _tmp309_;
				_tmp306_ = base_class;
				_tmp307_ = vala_gidl_parser_parse_type_string (self, _tmp306_);
				parent = _tmp307_;
				_tmp308_ = cl;
				_tmp309_ = parent;
				vala_class_add_base_type (_tmp308_, _tmp309_);
				_vala_code_node_unref0 (parent);
			}
			_tmp311_ = base_class;
			if (_tmp311_ == NULL) {
				gboolean _tmp312_;
				_tmp312_ = is_fundamental;
				_tmp310_ = !_tmp312_;
			} else {
				_tmp310_ = FALSE;
			}
			if (_tmp310_) {
				ValaClass* _tmp313_;
				_tmp313_ = cl;
				vala_class_set_is_compact (_tmp313_, TRUE);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp314_ = cl;
		_tmp315_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp314_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp315_;
		_tmp316_ = st_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp316_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp317_;
					GIdlNodeTypeId _tmp318_;
					_tmp317_ = member;
					_tmp318_ = _tmp317_->type;
					if (_tmp318_ == G_IDL_NODE_FUNCTION) {
						gboolean _tmp319_ = FALSE;
						const gchar* _tmp320_;
						_tmp320_ = ref_function;
						if (_tmp320_ == NULL) {
							GIdlNode* _tmp321_;
							const gchar* _tmp322_;
							_tmp321_ = member;
							_tmp322_ = _tmp321_->name;
							_tmp319_ = g_strcmp0 (_tmp322_, "ref") == 0;
						} else {
							_tmp319_ = FALSE;
						}
						if (_tmp319_) {
							GIdlNode* _tmp323_;
							const gchar* _tmp324_;
							gchar* _tmp325_;
							GIdlNode* _tmp326_;
							GIdlNodeParam* _tmp327_;
							GIdlNodeType* _tmp328_;
							ValaDataType* _tmp329_;
							ValaDataType* _tmp330_;
							_tmp323_ = member;
							_tmp324_ = ((GIdlNodeFunction*) _tmp323_)->symbol;
							_tmp325_ = g_strdup (_tmp324_);
							_g_free0 (ref_function);
							ref_function = _tmp325_;
							_tmp326_ = member;
							_tmp327_ = ((GIdlNodeFunction*) _tmp326_)->result;
							_tmp328_ = _tmp327_->type;
							_tmp329_ = vala_gidl_parser_parse_type (self, _tmp328_, NULL);
							_tmp330_ = _tmp329_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp330_);
						} else {
							gboolean _tmp331_ = FALSE;
							const gchar* _tmp332_;
							_tmp332_ = unref_function;
							if (_tmp332_ == NULL) {
								GIdlNode* _tmp333_;
								const gchar* _tmp334_;
								_tmp333_ = member;
								_tmp334_ = _tmp333_->name;
								_tmp331_ = g_strcmp0 (_tmp334_, "unref") == 0;
							} else {
								_tmp331_ = FALSE;
							}
							if (_tmp331_) {
								GIdlNode* _tmp335_;
								const gchar* _tmp336_;
								gchar* _tmp337_;
								_tmp335_ = member;
								_tmp336_ = ((GIdlNodeFunction*) _tmp335_)->symbol;
								_tmp337_ = g_strdup (_tmp336_);
								_g_free0 (unref_function);
								unref_function = _tmp337_;
							} else {
								gboolean _tmp338_ = FALSE;
								const gchar* _tmp339_;
								_tmp339_ = free_function;
								if (_tmp339_ == NULL) {
									gboolean _tmp340_ = FALSE;
									GIdlNode* _tmp341_;
									const gchar* _tmp342_;
									_tmp341_ = member;
									_tmp342_ = _tmp341_->name;
									if (g_strcmp0 (_tmp342_, "free") == 0) {
										_tmp340_ = TRUE;
									} else {
										GIdlNode* _tmp343_;
										const gchar* _tmp344_;
										_tmp343_ = member;
										_tmp344_ = _tmp343_->name;
										_tmp340_ = g_strcmp0 (_tmp344_, "destroy") == 0;
									}
									_tmp338_ = _tmp340_;
								} else {
									_tmp338_ = FALSE;
								}
								if (_tmp338_) {
									GIdlNode* _tmp345_;
									const gchar* _tmp346_;
									gchar* _tmp347_;
									_tmp345_ = member;
									_tmp346_ = ((GIdlNodeFunction*) _tmp345_)->symbol;
									_tmp347_ = g_strdup (_tmp346_);
									_g_free0 (free_function);
									free_function = _tmp347_;
								} else {
									gboolean _tmp348_ = FALSE;
									const gchar* _tmp349_;
									ValaMethod* m = NULL;
									GIdlNode* _tmp355_;
									ValaMethod* _tmp356_;
									ValaMethod* _tmp357_;
									_tmp349_ = copy_function;
									if (_tmp349_ == NULL) {
										GIdlNode* _tmp350_;
										const gchar* _tmp351_;
										_tmp350_ = member;
										_tmp351_ = _tmp350_->name;
										_tmp348_ = g_strcmp0 (_tmp351_, "copy") == 0;
									} else {
										_tmp348_ = FALSE;
									}
									if (_tmp348_) {
										GIdlNode* _tmp352_;
										const gchar* _tmp353_;
										gchar* _tmp354_;
										_tmp352_ = member;
										_tmp353_ = ((GIdlNodeFunction*) _tmp352_)->symbol;
										_tmp354_ = g_strdup (_tmp353_);
										_g_free0 (copy_function);
										copy_function = _tmp354_;
									}
									_tmp355_ = member;
									_tmp356_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp355_, FALSE);
									m = _tmp356_;
									_tmp357_ = m;
									if (_tmp357_ != NULL) {
										ValaClass* _tmp358_;
										ValaMethod* _tmp359_;
										_tmp358_ = cl;
										_tmp359_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp358_, _tmp359_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp360_;
						GIdlNodeTypeId _tmp361_;
						_tmp360_ = member;
						_tmp361_ = _tmp360_->type;
						if (_tmp361_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp362_;
							ValaField* _tmp363_;
							ValaField* _tmp364_;
							_tmp362_ = member;
							_tmp363_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp362_);
							f = _tmp363_;
							_tmp364_ = f;
							if (_tmp364_ != NULL) {
								ValaClass* _tmp365_;
								ValaField* _tmp366_;
								_tmp365_ = cl;
								_tmp366_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp365_, _tmp366_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp367_ = ref_function;
		if (_tmp367_ != NULL) {
			ValaClass* _tmp368_;
			const gchar* _tmp369_;
			gboolean _tmp370_;
			_tmp368_ = cl;
			_tmp369_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp368_, "CCode", "ref_function", _tmp369_, NULL);
			_tmp370_ = ref_function_void;
			if (_tmp370_) {
				ValaClass* _tmp371_;
				gboolean _tmp372_;
				_tmp371_ = cl;
				_tmp372_ = ref_function_void;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp371_, "CCode", "ref_function_void", _tmp372_, NULL);
			}
		} else {
			const gchar* _tmp373_;
			_tmp373_ = copy_function;
			if (_tmp373_ != NULL) {
				ValaClass* _tmp374_;
				const gchar* _tmp375_;
				_tmp374_ = cl;
				_tmp375_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp374_, "CCode", "copy_function", _tmp375_, NULL);
			}
		}
		_tmp376_ = unref_function;
		if (_tmp376_ != NULL) {
			ValaClass* _tmp377_;
			const gchar* _tmp378_;
			_tmp377_ = cl;
			_tmp378_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp377_, "CCode", "unref_function", _tmp378_, NULL);
		} else {
			gboolean _tmp379_ = FALSE;
			const gchar* _tmp380_;
			_tmp380_ = free_function;
			if (_tmp380_ != NULL) {
				const gchar* _tmp381_;
				ValaClass* _tmp382_;
				gchar* _tmp383_;
				gchar* _tmp384_;
				gchar* _tmp385_;
				gchar* _tmp386_;
				_tmp381_ = free_function;
				_tmp382_ = cl;
				_tmp383_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp382_);
				_tmp384_ = _tmp383_;
				_tmp385_ = g_strdup_printf ("%sfree", _tmp384_);
				_tmp386_ = _tmp385_;
				_tmp379_ = g_strcmp0 (_tmp381_, _tmp386_) != 0;
				_g_free0 (_tmp386_);
				_g_free0 (_tmp384_);
			} else {
				_tmp379_ = FALSE;
			}
			if (_tmp379_) {
				ValaClass* _tmp387_;
				const gchar* _tmp388_;
				_tmp387_ = cl;
				_tmp388_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp387_, "CCode", "free_function", _tmp388_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	_g_free0 (name);
}


static void
vala_gidl_parser_parse_union (ValaGIdlParser* self,
                              GIdlNodeUnion* un_node,
                              ValaSymbol* container,
                              GIdlModule* module)
{
	GIdlNode* node = NULL;
	gboolean _tmp0_;
	gchar* name = NULL;
	GIdlNode* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GIdlNode* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (un_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) un_node;
	_tmp0_ = un_node->deprecated;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = node;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = vala_gidl_parser_fix_type_name (self, _tmp2_, container);
	name = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->name;
	if (!vala_gidl_parser_is_reference_type (self, _tmp5_)) {
		ValaStruct* st = NULL;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		const gchar* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaStruct* _tmp10_;
		ValaStruct* _tmp11_;
		ValaStruct* _tmp73_;
		ValaTypeSymbol* _tmp74_;
		GList* _tmp75_;
		_tmp6_ = vala_symbol_get_scope (container);
		_tmp7_ = _tmp6_;
		_tmp8_ = name;
		_tmp9_ = vala_scope_lookup (_tmp7_, _tmp8_);
		_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp9_) : NULL;
		if (_tmp10_ == NULL) {
			_vala_code_node_unref0 (_tmp9_);
		}
		st = _tmp10_;
		_tmp11_ = st;
		if (_tmp11_ == NULL) {
			const gchar* _tmp12_;
			ValaSourceReference* _tmp13_;
			ValaStruct* _tmp14_;
			ValaStruct* _tmp15_;
			gchar** st_attributes = NULL;
			GIdlNode* _tmp16_;
			const gchar* _tmp17_;
			gint _tmp18_ = 0;
			gchar** _tmp19_;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			ValaStruct* _tmp70_;
			ValaSourceFile* _tmp71_;
			ValaStruct* _tmp72_;
			_tmp12_ = name;
			_tmp13_ = self->priv->current_source_reference;
			_tmp14_ = vala_struct_new (_tmp12_, _tmp13_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp14_;
			_tmp15_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp15_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp16_ = node;
			_tmp17_ = _tmp16_->name;
			_tmp19_ = vala_gidl_parser_get_attributes (self, _tmp17_, &_tmp18_);
			st_attributes = _tmp19_;
			st_attributes_length1 = _tmp18_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp20_ = st_attributes;
			_tmp20__length1 = st_attributes_length1;
			if (_tmp20_ != NULL) {
				gchar** _tmp21_;
				gint _tmp21__length1;
				_tmp21_ = st_attributes;
				_tmp21__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp21_;
					attr_collection_length1 = _tmp21__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp22_;
						gchar* attr = NULL;
						_tmp22_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp22_;
						{
							gchar** nv = NULL;
							const gchar* _tmp23_;
							gchar** _tmp24_;
							gchar** _tmp25_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp26_;
							gint _tmp26__length1;
							const gchar* _tmp27_;
							_tmp23_ = attr;
							_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "=", 2);
							nv = _tmp25_;
							nv_length1 = _vala_array_length (_tmp24_);
							_nv_size_ = nv_length1;
							_tmp26_ = nv;
							_tmp26__length1 = nv_length1;
							_tmp27_ = _tmp26_[0];
							if (g_strcmp0 (_tmp27_, "cheader_filename") == 0) {
								ValaStruct* _tmp28_;
								gchar** _tmp29_;
								gint _tmp29__length1;
								const gchar* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_;
								_tmp28_ = st;
								_tmp29_ = nv;
								_tmp29__length1 = nv_length1;
								_tmp30_ = _tmp29_[1];
								_tmp31_ = vala_gidl_parser_eval (self, _tmp30_);
								_tmp32_ = _tmp31_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp28_, "CCode", "cheader_filename", _tmp32_, NULL);
								_g_free0 (_tmp32_);
							} else {
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								_tmp33_ = nv;
								_tmp33__length1 = nv_length1;
								_tmp34_ = _tmp33_[0];
								if (g_strcmp0 (_tmp34_, "deprecated") == 0) {
									gchar** _tmp35_;
									gint _tmp35__length1;
									const gchar* _tmp36_;
									gchar* _tmp37_;
									gchar* _tmp38_;
									gboolean _tmp39_;
									_tmp35_ = nv;
									_tmp35__length1 = nv_length1;
									_tmp36_ = _tmp35_[1];
									_tmp37_ = vala_gidl_parser_eval (self, _tmp36_);
									_tmp38_ = _tmp37_;
									_tmp39_ = g_strcmp0 (_tmp38_, "1") == 0;
									_g_free0 (_tmp38_);
									if (_tmp39_) {
										ValaStruct* _tmp40_;
										_tmp40_ = st;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp40_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp41_;
									gint _tmp41__length1;
									const gchar* _tmp42_;
									_tmp41_ = nv;
									_tmp41__length1 = nv_length1;
									_tmp42_ = _tmp41_[0];
									if (g_strcmp0 (_tmp42_, "replacement") == 0) {
										ValaStruct* _tmp43_;
										gchar** _tmp44_;
										gint _tmp44__length1;
										const gchar* _tmp45_;
										gchar* _tmp46_;
										gchar* _tmp47_;
										_tmp43_ = st;
										_tmp44_ = nv;
										_tmp44__length1 = nv_length1;
										_tmp45_ = _tmp44_[1];
										_tmp46_ = vala_gidl_parser_eval (self, _tmp45_);
										_tmp47_ = _tmp46_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp43_, "Version", "replacement", _tmp47_, NULL);
										_g_free0 (_tmp47_);
									} else {
										gchar** _tmp48_;
										gint _tmp48__length1;
										const gchar* _tmp49_;
										_tmp48_ = nv;
										_tmp48__length1 = nv_length1;
										_tmp49_ = _tmp48_[0];
										if (g_strcmp0 (_tmp49_, "deprecated_since") == 0) {
											ValaStruct* _tmp50_;
											gchar** _tmp51_;
											gint _tmp51__length1;
											const gchar* _tmp52_;
											gchar* _tmp53_;
											gchar* _tmp54_;
											_tmp50_ = st;
											_tmp51_ = nv;
											_tmp51__length1 = nv_length1;
											_tmp52_ = _tmp51_[1];
											_tmp53_ = vala_gidl_parser_eval (self, _tmp52_);
											_tmp54_ = _tmp53_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp50_, "Version", "deprecated_since", _tmp54_, NULL);
											_g_free0 (_tmp54_);
										} else {
											gchar** _tmp55_;
											gint _tmp55__length1;
											const gchar* _tmp56_;
											_tmp55_ = nv;
											_tmp55__length1 = nv_length1;
											_tmp56_ = _tmp55_[0];
											if (g_strcmp0 (_tmp56_, "hidden") == 0) {
												gchar** _tmp57_;
												gint _tmp57__length1;
												const gchar* _tmp58_;
												gchar* _tmp59_;
												gchar* _tmp60_;
												gboolean _tmp61_;
												_tmp57_ = nv;
												_tmp57__length1 = nv_length1;
												_tmp58_ = _tmp57_[1];
												_tmp59_ = vala_gidl_parser_eval (self, _tmp58_);
												_tmp60_ = _tmp59_;
												_tmp61_ = g_strcmp0 (_tmp60_, "1") == 0;
												_g_free0 (_tmp60_);
												if (_tmp61_) {
													nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (attr);
													st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
													_vala_code_node_unref0 (st);
													_g_free0 (name);
													return;
												}
											} else {
												gchar** _tmp62_;
												gint _tmp62__length1;
												const gchar* _tmp63_;
												_tmp62_ = nv;
												_tmp62__length1 = nv_length1;
												_tmp63_ = _tmp62_[0];
												if (g_strcmp0 (_tmp63_, "experimental") == 0) {
													gchar** _tmp64_;
													gint _tmp64__length1;
													const gchar* _tmp65_;
													gchar* _tmp66_;
													gchar* _tmp67_;
													gboolean _tmp68_;
													_tmp64_ = nv;
													_tmp64__length1 = nv_length1;
													_tmp65_ = _tmp64_[1];
													_tmp66_ = vala_gidl_parser_eval (self, _tmp65_);
													_tmp67_ = _tmp66_;
													_tmp68_ = g_strcmp0 (_tmp67_, "1") == 0;
													_g_free0 (_tmp67_);
													if (_tmp68_) {
														ValaStruct* _tmp69_;
														_tmp69_ = st;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp69_, "Version", "experimental", TRUE, NULL);
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp70_ = st;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp70_);
			_tmp71_ = self->priv->current_source_file;
			_tmp72_ = st;
			vala_source_file_add_node (_tmp71_, (ValaCodeNode*) _tmp72_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp73_ = st;
		_tmp74_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp73_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp74_;
		_tmp75_ = un_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp75_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp76_;
					GIdlNodeTypeId _tmp77_;
					_tmp76_ = member;
					_tmp77_ = _tmp76_->type;
					if (_tmp77_ == G_IDL_NODE_FUNCTION) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp78_;
						ValaMethod* _tmp79_;
						ValaMethod* _tmp80_;
						_tmp78_ = member;
						_tmp79_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp78_, FALSE);
						m = _tmp79_;
						_tmp80_ = m;
						if (_tmp80_ != NULL) {
							ValaStruct* _tmp81_;
							ValaMethod* _tmp82_;
							_tmp81_ = st;
							_tmp82_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp81_, _tmp82_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp83_;
						GIdlNodeTypeId _tmp84_;
						_tmp83_ = member;
						_tmp84_ = _tmp83_->type;
						if (_tmp84_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp85_;
							ValaField* _tmp86_;
							ValaField* _tmp87_;
							_tmp85_ = member;
							_tmp86_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp85_);
							f = _tmp86_;
							_tmp87_ = f;
							if (_tmp87_ != NULL) {
								ValaStruct* _tmp88_;
								ValaField* _tmp89_;
								_tmp88_ = st;
								_tmp89_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp88_, _tmp89_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		ValaClass* cl = NULL;
		ValaScope* _tmp90_;
		ValaScope* _tmp91_;
		const gchar* _tmp92_;
		ValaSymbol* _tmp93_;
		ValaClass* _tmp94_;
		ValaClass* _tmp95_;
		ValaClass* _tmp128_;
		ValaTypeSymbol* _tmp129_;
		gboolean ref_function_void = FALSE;
		gchar* ref_function = NULL;
		gchar* unref_function = NULL;
		gchar* copy_function = NULL;
		gchar* free_function = NULL;
		GList* _tmp130_;
		const gchar* _tmp173_;
		const gchar* _tmp182_;
		_tmp90_ = vala_symbol_get_scope (container);
		_tmp91_ = _tmp90_;
		_tmp92_ = name;
		_tmp93_ = vala_scope_lookup (_tmp91_, _tmp92_);
		_tmp94_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp93_) : NULL;
		if (_tmp94_ == NULL) {
			_vala_code_node_unref0 (_tmp93_);
		}
		cl = _tmp94_;
		_tmp95_ = cl;
		if (_tmp95_ == NULL) {
			const gchar* _tmp96_;
			ValaSourceReference* _tmp97_;
			ValaClass* _tmp98_;
			ValaClass* _tmp99_;
			ValaClass* _tmp100_;
			gchar** cl_attributes = NULL;
			GIdlNode* _tmp101_;
			const gchar* _tmp102_;
			gint _tmp103_ = 0;
			gchar** _tmp104_;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp105_;
			gint _tmp105__length1;
			ValaClass* _tmp125_;
			ValaSourceFile* _tmp126_;
			ValaClass* _tmp127_;
			_tmp96_ = name;
			_tmp97_ = self->priv->current_source_reference;
			_tmp98_ = vala_class_new (_tmp96_, _tmp97_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp98_;
			_tmp99_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp99_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp100_ = cl;
			vala_class_set_is_compact (_tmp100_, TRUE);
			_tmp101_ = node;
			_tmp102_ = _tmp101_->name;
			_tmp104_ = vala_gidl_parser_get_attributes (self, _tmp102_, &_tmp103_);
			cl_attributes = _tmp104_;
			cl_attributes_length1 = _tmp103_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp105_ = cl_attributes;
			_tmp105__length1 = cl_attributes_length1;
			if (_tmp105_ != NULL) {
				gchar** _tmp106_;
				gint _tmp106__length1;
				_tmp106_ = cl_attributes;
				_tmp106__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp106_;
					attr_collection_length1 = _tmp106__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp107_;
						gchar* attr = NULL;
						_tmp107_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp107_;
						{
							gchar** nv = NULL;
							const gchar* _tmp108_;
							gchar** _tmp109_;
							gchar** _tmp110_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp111_;
							gint _tmp111__length1;
							const gchar* _tmp112_;
							_tmp108_ = attr;
							_tmp110_ = _tmp109_ = g_strsplit (_tmp108_, "=", 2);
							nv = _tmp110_;
							nv_length1 = _vala_array_length (_tmp109_);
							_nv_size_ = nv_length1;
							_tmp111_ = nv;
							_tmp111__length1 = nv_length1;
							_tmp112_ = _tmp111_[0];
							if (g_strcmp0 (_tmp112_, "cheader_filename") == 0) {
								ValaClass* _tmp113_;
								gchar** _tmp114_;
								gint _tmp114__length1;
								const gchar* _tmp115_;
								gchar* _tmp116_;
								gchar* _tmp117_;
								_tmp113_ = cl;
								_tmp114_ = nv;
								_tmp114__length1 = nv_length1;
								_tmp115_ = _tmp114_[1];
								_tmp116_ = vala_gidl_parser_eval (self, _tmp115_);
								_tmp117_ = _tmp116_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp113_, "CCode", "cheader_filename", _tmp117_, NULL);
								_g_free0 (_tmp117_);
							} else {
								gchar** _tmp118_;
								gint _tmp118__length1;
								const gchar* _tmp119_;
								_tmp118_ = nv;
								_tmp118__length1 = nv_length1;
								_tmp119_ = _tmp118_[0];
								if (g_strcmp0 (_tmp119_, "hidden") == 0) {
									gchar** _tmp120_;
									gint _tmp120__length1;
									const gchar* _tmp121_;
									gchar* _tmp122_;
									gchar* _tmp123_;
									gboolean _tmp124_;
									_tmp120_ = nv;
									_tmp120__length1 = nv_length1;
									_tmp121_ = _tmp120_[1];
									_tmp122_ = vala_gidl_parser_eval (self, _tmp121_);
									_tmp123_ = _tmp122_;
									_tmp124_ = g_strcmp0 (_tmp123_, "1") == 0;
									_g_free0 (_tmp123_);
									if (_tmp124_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (name);
										return;
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp125_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp125_);
			_tmp126_ = self->priv->current_source_file;
			_tmp127_ = cl;
			vala_source_file_add_node (_tmp126_, (ValaCodeNode*) _tmp127_);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp128_ = cl;
		_tmp129_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp128_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp129_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp130_ = un_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp130_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp131_;
					GIdlNodeTypeId _tmp132_;
					_tmp131_ = member;
					_tmp132_ = _tmp131_->type;
					if (_tmp132_ == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp133_;
						const gchar* _tmp134_;
						_tmp133_ = member;
						_tmp134_ = _tmp133_->name;
						if (g_strcmp0 (_tmp134_, "ref") == 0) {
							GIdlNode* _tmp135_;
							const gchar* _tmp136_;
							gchar* _tmp137_;
							GIdlNode* _tmp138_;
							GIdlNodeParam* _tmp139_;
							GIdlNodeType* _tmp140_;
							ValaDataType* _tmp141_;
							ValaDataType* _tmp142_;
							_tmp135_ = member;
							_tmp136_ = ((GIdlNodeFunction*) _tmp135_)->symbol;
							_tmp137_ = g_strdup (_tmp136_);
							_g_free0 (ref_function);
							ref_function = _tmp137_;
							_tmp138_ = member;
							_tmp139_ = ((GIdlNodeFunction*) _tmp138_)->result;
							_tmp140_ = _tmp139_->type;
							_tmp141_ = vala_gidl_parser_parse_type (self, _tmp140_, NULL);
							_tmp142_ = _tmp141_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp142_);
						} else {
							GIdlNode* _tmp143_;
							const gchar* _tmp144_;
							_tmp143_ = member;
							_tmp144_ = _tmp143_->name;
							if (g_strcmp0 (_tmp144_, "unref") == 0) {
								GIdlNode* _tmp145_;
								const gchar* _tmp146_;
								gchar* _tmp147_;
								_tmp145_ = member;
								_tmp146_ = ((GIdlNodeFunction*) _tmp145_)->symbol;
								_tmp147_ = g_strdup (_tmp146_);
								_g_free0 (unref_function);
								unref_function = _tmp147_;
							} else {
								gboolean _tmp148_ = FALSE;
								GIdlNode* _tmp149_;
								const gchar* _tmp150_;
								_tmp149_ = member;
								_tmp150_ = _tmp149_->name;
								if (g_strcmp0 (_tmp150_, "free") == 0) {
									_tmp148_ = TRUE;
								} else {
									GIdlNode* _tmp151_;
									const gchar* _tmp152_;
									_tmp151_ = member;
									_tmp152_ = _tmp151_->name;
									_tmp148_ = g_strcmp0 (_tmp152_, "destroy") == 0;
								}
								if (_tmp148_) {
									GIdlNode* _tmp153_;
									const gchar* _tmp154_;
									gchar* _tmp155_;
									_tmp153_ = member;
									_tmp154_ = ((GIdlNodeFunction*) _tmp153_)->symbol;
									_tmp155_ = g_strdup (_tmp154_);
									_g_free0 (free_function);
									free_function = _tmp155_;
								} else {
									GIdlNode* _tmp156_;
									const gchar* _tmp157_;
									ValaMethod* m = NULL;
									GIdlNode* _tmp161_;
									ValaMethod* _tmp162_;
									ValaMethod* _tmp163_;
									_tmp156_ = member;
									_tmp157_ = _tmp156_->name;
									if (g_strcmp0 (_tmp157_, "copy") == 0) {
										GIdlNode* _tmp158_;
										const gchar* _tmp159_;
										gchar* _tmp160_;
										_tmp158_ = member;
										_tmp159_ = ((GIdlNodeFunction*) _tmp158_)->symbol;
										_tmp160_ = g_strdup (_tmp159_);
										_g_free0 (copy_function);
										copy_function = _tmp160_;
									}
									_tmp161_ = member;
									_tmp162_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp161_, FALSE);
									m = _tmp162_;
									_tmp163_ = m;
									if (_tmp163_ != NULL) {
										ValaClass* _tmp164_;
										ValaMethod* _tmp165_;
										_tmp164_ = cl;
										_tmp165_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp164_, _tmp165_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp166_;
						GIdlNodeTypeId _tmp167_;
						_tmp166_ = member;
						_tmp167_ = _tmp166_->type;
						if (_tmp167_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp168_;
							ValaField* _tmp169_;
							ValaField* _tmp170_;
							_tmp168_ = member;
							_tmp169_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp168_);
							f = _tmp169_;
							_tmp170_ = f;
							if (_tmp170_ != NULL) {
								ValaClass* _tmp171_;
								ValaField* _tmp172_;
								_tmp171_ = cl;
								_tmp172_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp171_, _tmp172_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp173_ = ref_function;
		if (_tmp173_ != NULL) {
			ValaClass* _tmp174_;
			const gchar* _tmp175_;
			gboolean _tmp176_;
			_tmp174_ = cl;
			_tmp175_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp174_, "CCode", "ref_function", _tmp175_, NULL);
			_tmp176_ = ref_function_void;
			if (_tmp176_) {
				ValaClass* _tmp177_;
				gboolean _tmp178_;
				_tmp177_ = cl;
				_tmp178_ = ref_function_void;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp177_, "CCode", "ref_function_void", _tmp178_, NULL);
			}
		} else {
			const gchar* _tmp179_;
			_tmp179_ = copy_function;
			if (_tmp179_ != NULL) {
				ValaClass* _tmp180_;
				const gchar* _tmp181_;
				_tmp180_ = cl;
				_tmp181_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp180_, "CCode", "copy_function", _tmp181_, NULL);
			}
		}
		_tmp182_ = unref_function;
		if (_tmp182_ != NULL) {
			ValaClass* _tmp183_;
			const gchar* _tmp184_;
			_tmp183_ = cl;
			_tmp184_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp183_, "CCode", "unref_function", _tmp184_, NULL);
		} else {
			gboolean _tmp185_ = FALSE;
			const gchar* _tmp186_;
			_tmp186_ = free_function;
			if (_tmp186_ != NULL) {
				const gchar* _tmp187_;
				ValaClass* _tmp188_;
				gchar* _tmp189_;
				gchar* _tmp190_;
				gchar* _tmp191_;
				gchar* _tmp192_;
				_tmp187_ = free_function;
				_tmp188_ = cl;
				_tmp189_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp188_);
				_tmp190_ = _tmp189_;
				_tmp191_ = g_strdup_printf ("%sfree", _tmp190_);
				_tmp192_ = _tmp191_;
				_tmp185_ = g_strcmp0 (_tmp187_, _tmp192_) != 0;
				_g_free0 (_tmp192_);
				_g_free0 (_tmp190_);
			} else {
				_tmp185_ = FALSE;
			}
			if (_tmp185_) {
				ValaClass* _tmp193_;
				const gchar* _tmp194_;
				_tmp193_ = cl;
				_tmp194_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp193_, "CCode", "free_function", _tmp194_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
		_vala_code_node_unref0 (cl);
	}
	_g_free0 (name);
}


static void
vala_gidl_parser_parse_boxed (ValaGIdlParser* self,
                              GIdlNodeBoxed* boxed_node,
                              ValaSymbol* container,
                              GIdlModule* module)
{
	GIdlNode* node = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** node_attributes = NULL;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint node_attributes_length1;
	gint _node_attributes_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GIdlNode* _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (boxed_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) boxed_node;
	_tmp0_ = node;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = vala_gidl_parser_fix_type_name (self, _tmp1_, container);
	name = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp6_ = vala_gidl_parser_get_attributes (self, _tmp4_, &_tmp5_);
	node_attributes = _tmp6_;
	node_attributes_length1 = _tmp5_;
	_node_attributes_size_ = node_attributes_length1;
	_tmp7_ = node_attributes;
	_tmp7__length1 = node_attributes_length1;
	if (_tmp7_ != NULL) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp8_ = node_attributes;
		_tmp8__length1 = node_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp8_;
			attr_collection_length1 = _tmp8__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp9_;
				gchar* attr = NULL;
				_tmp9_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp9_;
				{
					gchar** nv = NULL;
					const gchar* _tmp10_;
					gchar** _tmp11_;
					gchar** _tmp12_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					_tmp10_ = attr;
					_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "=", 2);
					nv = _tmp12_;
					nv_length1 = _vala_array_length (_tmp11_);
					_nv_size_ = nv_length1;
					_tmp13_ = nv;
					_tmp13__length1 = nv_length1;
					_tmp14_ = _tmp13_[0];
					if (g_strcmp0 (_tmp14_, "hidden") == 0) {
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (name);
						return;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp15_ = node;
	_tmp16_ = _tmp15_->name;
	if (!vala_gidl_parser_is_reference_type (self, _tmp16_)) {
		ValaStruct* st = NULL;
		ValaScope* _tmp17_;
		ValaScope* _tmp18_;
		const gchar* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaStruct* _tmp21_;
		ValaStruct* _tmp22_;
		ValaStruct* _tmp101_;
		ValaTypeSymbol* _tmp102_;
		GList* _tmp103_;
		_tmp17_ = vala_symbol_get_scope (container);
		_tmp18_ = _tmp17_;
		_tmp19_ = name;
		_tmp20_ = vala_scope_lookup (_tmp18_, _tmp19_);
		_tmp21_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp20_) : NULL;
		if (_tmp21_ == NULL) {
			_vala_code_node_unref0 (_tmp20_);
		}
		st = _tmp21_;
		_tmp22_ = st;
		if (_tmp22_ == NULL) {
			const gchar* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaStruct* _tmp25_;
			ValaStruct* _tmp26_;
			gchar** st_attributes = NULL;
			GIdlNode* _tmp27_;
			const gchar* _tmp28_;
			gint _tmp29_ = 0;
			gchar** _tmp30_;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			ValaStruct* _tmp98_;
			ValaSourceFile* _tmp99_;
			ValaStruct* _tmp100_;
			_tmp23_ = name;
			_tmp24_ = self->priv->current_source_reference;
			_tmp25_ = vala_struct_new (_tmp23_, _tmp24_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp25_;
			_tmp26_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp26_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp27_ = node;
			_tmp28_ = _tmp27_->name;
			_tmp30_ = vala_gidl_parser_get_attributes (self, _tmp28_, &_tmp29_);
			st_attributes = _tmp30_;
			st_attributes_length1 = _tmp29_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp31_ = st_attributes;
			_tmp31__length1 = st_attributes_length1;
			if (_tmp31_ != NULL) {
				gchar** _tmp32_;
				gint _tmp32__length1;
				_tmp32_ = st_attributes;
				_tmp32__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp32_;
					attr_collection_length1 = _tmp32__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp33_;
						gchar* attr = NULL;
						_tmp33_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp33_;
						{
							gchar** nv = NULL;
							const gchar* _tmp34_;
							gchar** _tmp35_;
							gchar** _tmp36_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp37_;
							gint _tmp37__length1;
							const gchar* _tmp38_;
							_tmp34_ = attr;
							_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, "=", 2);
							nv = _tmp36_;
							nv_length1 = _vala_array_length (_tmp35_);
							_nv_size_ = nv_length1;
							_tmp37_ = nv;
							_tmp37__length1 = nv_length1;
							_tmp38_ = _tmp37_[0];
							if (g_strcmp0 (_tmp38_, "cheader_filename") == 0) {
								ValaStruct* _tmp39_;
								gchar** _tmp40_;
								gint _tmp40__length1;
								const gchar* _tmp41_;
								gchar* _tmp42_;
								gchar* _tmp43_;
								_tmp39_ = st;
								_tmp40_ = nv;
								_tmp40__length1 = nv_length1;
								_tmp41_ = _tmp40_[1];
								_tmp42_ = vala_gidl_parser_eval (self, _tmp41_);
								_tmp43_ = _tmp42_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp39_, "CCode", "cheader_filename", _tmp43_, NULL);
								_g_free0 (_tmp43_);
							} else {
								gchar** _tmp44_;
								gint _tmp44__length1;
								const gchar* _tmp45_;
								_tmp44_ = nv;
								_tmp44__length1 = nv_length1;
								_tmp45_ = _tmp44_[0];
								if (g_strcmp0 (_tmp45_, "deprecated") == 0) {
									gchar** _tmp46_;
									gint _tmp46__length1;
									const gchar* _tmp47_;
									gchar* _tmp48_;
									gchar* _tmp49_;
									gboolean _tmp50_;
									_tmp46_ = nv;
									_tmp46__length1 = nv_length1;
									_tmp47_ = _tmp46_[1];
									_tmp48_ = vala_gidl_parser_eval (self, _tmp47_);
									_tmp49_ = _tmp48_;
									_tmp50_ = g_strcmp0 (_tmp49_, "1") == 0;
									_g_free0 (_tmp49_);
									if (_tmp50_) {
										ValaStruct* _tmp51_;
										_tmp51_ = st;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp51_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp52_;
									gint _tmp52__length1;
									const gchar* _tmp53_;
									_tmp52_ = nv;
									_tmp52__length1 = nv_length1;
									_tmp53_ = _tmp52_[0];
									if (g_strcmp0 (_tmp53_, "replacement") == 0) {
										ValaStruct* _tmp54_;
										gchar** _tmp55_;
										gint _tmp55__length1;
										const gchar* _tmp56_;
										gchar* _tmp57_;
										gchar* _tmp58_;
										_tmp54_ = st;
										_tmp55_ = nv;
										_tmp55__length1 = nv_length1;
										_tmp56_ = _tmp55_[1];
										_tmp57_ = vala_gidl_parser_eval (self, _tmp56_);
										_tmp58_ = _tmp57_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp54_, "Version", "replacement", _tmp58_, NULL);
										_g_free0 (_tmp58_);
									} else {
										gchar** _tmp59_;
										gint _tmp59__length1;
										const gchar* _tmp60_;
										_tmp59_ = nv;
										_tmp59__length1 = nv_length1;
										_tmp60_ = _tmp59_[0];
										if (g_strcmp0 (_tmp60_, "deprecated_since") == 0) {
											ValaStruct* _tmp61_;
											gchar** _tmp62_;
											gint _tmp62__length1;
											const gchar* _tmp63_;
											gchar* _tmp64_;
											gchar* _tmp65_;
											_tmp61_ = st;
											_tmp62_ = nv;
											_tmp62__length1 = nv_length1;
											_tmp63_ = _tmp62_[1];
											_tmp64_ = vala_gidl_parser_eval (self, _tmp63_);
											_tmp65_ = _tmp64_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp61_, "Version", "deprecated_since", _tmp65_, NULL);
											_g_free0 (_tmp65_);
										} else {
											gchar** _tmp66_;
											gint _tmp66__length1;
											const gchar* _tmp67_;
											_tmp66_ = nv;
											_tmp66__length1 = nv_length1;
											_tmp67_ = _tmp66_[0];
											if (g_strcmp0 (_tmp67_, "immutable") == 0) {
												gchar** _tmp68_;
												gint _tmp68__length1;
												const gchar* _tmp69_;
												gchar* _tmp70_;
												gchar* _tmp71_;
												gboolean _tmp72_;
												_tmp68_ = nv;
												_tmp68__length1 = nv_length1;
												_tmp69_ = _tmp68_[1];
												_tmp70_ = vala_gidl_parser_eval (self, _tmp69_);
												_tmp71_ = _tmp70_;
												_tmp72_ = g_strcmp0 (_tmp71_, "1") == 0;
												_g_free0 (_tmp71_);
												if (_tmp72_) {
													ValaStruct* _tmp73_;
													_tmp73_ = st;
													vala_code_node_set_attribute ((ValaCodeNode*) _tmp73_, "Immutable", TRUE, NULL);
												}
											} else {
												gchar** _tmp74_;
												gint _tmp74__length1;
												const gchar* _tmp75_;
												_tmp74_ = nv;
												_tmp74__length1 = nv_length1;
												_tmp75_ = _tmp74_[0];
												if (g_strcmp0 (_tmp75_, "has_copy_function") == 0) {
													gchar** _tmp76_;
													gint _tmp76__length1;
													const gchar* _tmp77_;
													gchar* _tmp78_;
													gchar* _tmp79_;
													gboolean _tmp80_;
													_tmp76_ = nv;
													_tmp76__length1 = nv_length1;
													_tmp77_ = _tmp76_[1];
													_tmp78_ = vala_gidl_parser_eval (self, _tmp77_);
													_tmp79_ = _tmp78_;
													_tmp80_ = g_strcmp0 (_tmp79_, "0") == 0;
													_g_free0 (_tmp79_);
													if (_tmp80_) {
														ValaStruct* _tmp81_;
														_tmp81_ = st;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp81_, "CCode", "has_copy_function", FALSE, NULL);
													}
												} else {
													gchar** _tmp82_;
													gint _tmp82__length1;
													const gchar* _tmp83_;
													_tmp82_ = nv;
													_tmp82__length1 = nv_length1;
													_tmp83_ = _tmp82_[0];
													if (g_strcmp0 (_tmp83_, "has_destroy_function") == 0) {
														gchar** _tmp84_;
														gint _tmp84__length1;
														const gchar* _tmp85_;
														gchar* _tmp86_;
														gchar* _tmp87_;
														gboolean _tmp88_;
														_tmp84_ = nv;
														_tmp84__length1 = nv_length1;
														_tmp85_ = _tmp84_[1];
														_tmp86_ = vala_gidl_parser_eval (self, _tmp85_);
														_tmp87_ = _tmp86_;
														_tmp88_ = g_strcmp0 (_tmp87_, "0") == 0;
														_g_free0 (_tmp87_);
														if (_tmp88_) {
															ValaStruct* _tmp89_;
															_tmp89_ = st;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp89_, "CCode", "has_destroy_function", FALSE, NULL);
														}
													} else {
														gchar** _tmp90_;
														gint _tmp90__length1;
														const gchar* _tmp91_;
														_tmp90_ = nv;
														_tmp90__length1 = nv_length1;
														_tmp91_ = _tmp90_[0];
														if (g_strcmp0 (_tmp91_, "experimental") == 0) {
															gchar** _tmp92_;
															gint _tmp92__length1;
															const gchar* _tmp93_;
															gchar* _tmp94_;
															gchar* _tmp95_;
															gboolean _tmp96_;
															_tmp92_ = nv;
															_tmp92__length1 = nv_length1;
															_tmp93_ = _tmp92_[1];
															_tmp94_ = vala_gidl_parser_eval (self, _tmp93_);
															_tmp95_ = _tmp94_;
															_tmp96_ = g_strcmp0 (_tmp95_, "1") == 0;
															_g_free0 (_tmp95_);
															if (_tmp96_) {
																ValaStruct* _tmp97_;
																_tmp97_ = st;
																vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp97_, "Version", "experimental", TRUE, NULL);
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp98_ = st;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp98_);
			_tmp99_ = self->priv->current_source_file;
			_tmp100_ = st;
			vala_source_file_add_node (_tmp99_, (ValaCodeNode*) _tmp100_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp101_ = st;
		_tmp102_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp101_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp102_;
		_tmp103_ = boxed_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp103_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp104_;
					GIdlNodeTypeId _tmp105_;
					_tmp104_ = member;
					_tmp105_ = _tmp104_->type;
					if (_tmp105_ == G_IDL_NODE_FUNCTION) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp106_;
						ValaMethod* _tmp107_;
						ValaMethod* _tmp108_;
						_tmp106_ = member;
						_tmp107_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp106_, FALSE);
						m = _tmp107_;
						_tmp108_ = m;
						if (_tmp108_ != NULL) {
							ValaStruct* _tmp109_;
							ValaMethod* _tmp110_;
							_tmp109_ = st;
							_tmp110_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp109_, _tmp110_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp111_;
						GIdlNodeTypeId _tmp112_;
						_tmp111_ = member;
						_tmp112_ = _tmp111_->type;
						if (_tmp112_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp113_;
							ValaField* _tmp114_;
							ValaField* _tmp115_;
							_tmp113_ = member;
							_tmp114_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp113_);
							f = _tmp114_;
							_tmp115_ = f;
							if (_tmp115_ != NULL) {
								ValaStruct* _tmp116_;
								ValaField* _tmp117_;
								_tmp116_ = st;
								_tmp117_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp116_, _tmp117_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void = FALSE;
		gchar* ref_function = NULL;
		gchar* unref_function = NULL;
		gchar* copy_function = NULL;
		gchar* free_function = NULL;
		ValaClass* cl = NULL;
		ValaScope* _tmp118_;
		ValaScope* _tmp119_;
		const gchar* _tmp120_;
		ValaSymbol* _tmp121_;
		ValaClass* _tmp122_;
		ValaClass* _tmp123_;
		ValaClass* _tmp236_;
		ValaTypeSymbol* _tmp237_;
		GList* _tmp238_;
		const gchar* _tmp281_;
		const gchar* _tmp290_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp118_ = vala_symbol_get_scope (container);
		_tmp119_ = _tmp118_;
		_tmp120_ = name;
		_tmp121_ = vala_scope_lookup (_tmp119_, _tmp120_);
		_tmp122_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp121_) : NULL;
		if (_tmp122_ == NULL) {
			_vala_code_node_unref0 (_tmp121_);
		}
		cl = _tmp122_;
		_tmp123_ = cl;
		if (_tmp123_ == NULL) {
			gchar* base_class = NULL;
			const gchar* _tmp124_;
			ValaSourceReference* _tmp125_;
			ValaClass* _tmp126_;
			ValaClass* _tmp127_;
			ValaClass* _tmp128_;
			const gchar* _tmp129_;
			gchar** cl_attributes = NULL;
			GIdlNode* _tmp134_;
			const gchar* _tmp135_;
			gint _tmp136_ = 0;
			gchar** _tmp137_;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp138_;
			gint _tmp138__length1;
			ValaClass* _tmp228_;
			ValaSourceFile* _tmp229_;
			ValaClass* _tmp230_;
			const gchar* _tmp231_;
			base_class = NULL;
			_tmp124_ = name;
			_tmp125_ = self->priv->current_source_reference;
			_tmp126_ = vala_class_new (_tmp124_, _tmp125_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp126_;
			_tmp127_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp127_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp128_ = cl;
			vala_class_set_is_compact (_tmp128_, TRUE);
			_tmp129_ = boxed_node->gtype_init;
			if (_tmp129_ != NULL) {
				ValaClass* _tmp130_;
				const gchar* _tmp131_;
				gchar* _tmp132_;
				gchar* _tmp133_;
				_tmp130_ = cl;
				_tmp131_ = boxed_node->gtype_init;
				_tmp132_ = g_strdup_printf ("%s ()", _tmp131_);
				_tmp133_ = _tmp132_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp130_, "CCode", "type_id", _tmp133_, NULL);
				_g_free0 (_tmp133_);
			}
			_tmp134_ = node;
			_tmp135_ = _tmp134_->name;
			_tmp137_ = vala_gidl_parser_get_attributes (self, _tmp135_, &_tmp136_);
			cl_attributes = _tmp137_;
			cl_attributes_length1 = _tmp136_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp138_ = cl_attributes;
			_tmp138__length1 = cl_attributes_length1;
			if (_tmp138_ != NULL) {
				gchar** _tmp139_;
				gint _tmp139__length1;
				_tmp139_ = cl_attributes;
				_tmp139__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp139_;
					attr_collection_length1 = _tmp139__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp140_;
						gchar* attr = NULL;
						_tmp140_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp140_;
						{
							gchar** nv = NULL;
							const gchar* _tmp141_;
							gchar** _tmp142_;
							gchar** _tmp143_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp144_;
							gint _tmp144__length1;
							const gchar* _tmp145_;
							_tmp141_ = attr;
							_tmp143_ = _tmp142_ = g_strsplit (_tmp141_, "=", 2);
							nv = _tmp143_;
							nv_length1 = _vala_array_length (_tmp142_);
							_nv_size_ = nv_length1;
							_tmp144_ = nv;
							_tmp144__length1 = nv_length1;
							_tmp145_ = _tmp144_[0];
							if (g_strcmp0 (_tmp145_, "cheader_filename") == 0) {
								ValaClass* _tmp146_;
								gchar** _tmp147_;
								gint _tmp147__length1;
								const gchar* _tmp148_;
								gchar* _tmp149_;
								gchar* _tmp150_;
								_tmp146_ = cl;
								_tmp147_ = nv;
								_tmp147__length1 = nv_length1;
								_tmp148_ = _tmp147_[1];
								_tmp149_ = vala_gidl_parser_eval (self, _tmp148_);
								_tmp150_ = _tmp149_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp146_, "CCode", "cheader_filename", _tmp150_, NULL);
								_g_free0 (_tmp150_);
							} else {
								gchar** _tmp151_;
								gint _tmp151__length1;
								const gchar* _tmp152_;
								_tmp151_ = nv;
								_tmp151__length1 = nv_length1;
								_tmp152_ = _tmp151_[0];
								if (g_strcmp0 (_tmp152_, "base_class") == 0) {
									gchar** _tmp153_;
									gint _tmp153__length1;
									const gchar* _tmp154_;
									gchar* _tmp155_;
									_tmp153_ = nv;
									_tmp153__length1 = nv_length1;
									_tmp154_ = _tmp153_[1];
									_tmp155_ = vala_gidl_parser_eval (self, _tmp154_);
									_g_free0 (base_class);
									base_class = _tmp155_;
								} else {
									gchar** _tmp156_;
									gint _tmp156__length1;
									const gchar* _tmp157_;
									_tmp156_ = nv;
									_tmp156__length1 = nv_length1;
									_tmp157_ = _tmp156_[0];
									if (g_strcmp0 (_tmp157_, "is_immutable") == 0) {
										gchar** _tmp158_;
										gint _tmp158__length1;
										const gchar* _tmp159_;
										gchar* _tmp160_;
										gchar* _tmp161_;
										gboolean _tmp162_;
										_tmp158_ = nv;
										_tmp158__length1 = nv_length1;
										_tmp159_ = _tmp158_[1];
										_tmp160_ = vala_gidl_parser_eval (self, _tmp159_);
										_tmp161_ = _tmp160_;
										_tmp162_ = g_strcmp0 (_tmp161_, "1") == 0;
										_g_free0 (_tmp161_);
										if (_tmp162_) {
											ValaClass* _tmp163_;
											_tmp163_ = cl;
											vala_class_set_is_immutable (_tmp163_, TRUE);
										}
									} else {
										gchar** _tmp164_;
										gint _tmp164__length1;
										const gchar* _tmp165_;
										_tmp164_ = nv;
										_tmp164__length1 = nv_length1;
										_tmp165_ = _tmp164_[0];
										if (g_strcmp0 (_tmp165_, "deprecated") == 0) {
											gchar** _tmp166_;
											gint _tmp166__length1;
											const gchar* _tmp167_;
											gchar* _tmp168_;
											gchar* _tmp169_;
											gboolean _tmp170_;
											_tmp166_ = nv;
											_tmp166__length1 = nv_length1;
											_tmp167_ = _tmp166_[1];
											_tmp168_ = vala_gidl_parser_eval (self, _tmp167_);
											_tmp169_ = _tmp168_;
											_tmp170_ = g_strcmp0 (_tmp169_, "1") == 0;
											_g_free0 (_tmp169_);
											if (_tmp170_) {
												ValaClass* _tmp171_;
												_tmp171_ = cl;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp171_, "Version", "deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp172_;
											gint _tmp172__length1;
											const gchar* _tmp173_;
											_tmp172_ = nv;
											_tmp172__length1 = nv_length1;
											_tmp173_ = _tmp172_[0];
											if (g_strcmp0 (_tmp173_, "replacement") == 0) {
												ValaClass* _tmp174_;
												gchar** _tmp175_;
												gint _tmp175__length1;
												const gchar* _tmp176_;
												gchar* _tmp177_;
												gchar* _tmp178_;
												_tmp174_ = cl;
												_tmp175_ = nv;
												_tmp175__length1 = nv_length1;
												_tmp176_ = _tmp175_[1];
												_tmp177_ = vala_gidl_parser_eval (self, _tmp176_);
												_tmp178_ = _tmp177_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp174_, "Version", "replacement", _tmp178_, NULL);
												_g_free0 (_tmp178_);
											} else {
												gchar** _tmp179_;
												gint _tmp179__length1;
												const gchar* _tmp180_;
												_tmp179_ = nv;
												_tmp179__length1 = nv_length1;
												_tmp180_ = _tmp179_[0];
												if (g_strcmp0 (_tmp180_, "deprecated_since") == 0) {
													ValaClass* _tmp181_;
													gchar** _tmp182_;
													gint _tmp182__length1;
													const gchar* _tmp183_;
													gchar* _tmp184_;
													gchar* _tmp185_;
													_tmp181_ = cl;
													_tmp182_ = nv;
													_tmp182__length1 = nv_length1;
													_tmp183_ = _tmp182_[1];
													_tmp184_ = vala_gidl_parser_eval (self, _tmp183_);
													_tmp185_ = _tmp184_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp181_, "Version", "deprecated_since", _tmp185_, NULL);
													_g_free0 (_tmp185_);
												} else {
													gchar** _tmp186_;
													gint _tmp186__length1;
													const gchar* _tmp187_;
													_tmp186_ = nv;
													_tmp186__length1 = nv_length1;
													_tmp187_ = _tmp186_[0];
													if (g_strcmp0 (_tmp187_, "const_cname") == 0) {
														ValaClass* _tmp188_;
														gchar** _tmp189_;
														gint _tmp189__length1;
														const gchar* _tmp190_;
														gchar* _tmp191_;
														gchar* _tmp192_;
														_tmp188_ = cl;
														_tmp189_ = nv;
														_tmp189__length1 = nv_length1;
														_tmp190_ = _tmp189_[1];
														_tmp191_ = vala_gidl_parser_eval (self, _tmp190_);
														_tmp192_ = _tmp191_;
														vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp188_, "CCode", "const_cname", _tmp192_, NULL);
														_g_free0 (_tmp192_);
													} else {
														gchar** _tmp193_;
														gint _tmp193__length1;
														const gchar* _tmp194_;
														_tmp193_ = nv;
														_tmp193__length1 = nv_length1;
														_tmp194_ = _tmp193_[0];
														if (g_strcmp0 (_tmp194_, "free_function") == 0) {
															gchar** _tmp195_;
															gint _tmp195__length1;
															const gchar* _tmp196_;
															gchar* _tmp197_;
															_tmp195_ = nv;
															_tmp195__length1 = nv_length1;
															_tmp196_ = _tmp195_[1];
															_tmp197_ = vala_gidl_parser_eval (self, _tmp196_);
															_g_free0 (free_function);
															free_function = _tmp197_;
														} else {
															gchar** _tmp198_;
															gint _tmp198__length1;
															const gchar* _tmp199_;
															_tmp198_ = nv;
															_tmp198__length1 = nv_length1;
															_tmp199_ = _tmp198_[0];
															if (g_strcmp0 (_tmp199_, "ref_function") == 0) {
																gchar** _tmp200_;
																gint _tmp200__length1;
																const gchar* _tmp201_;
																gchar* _tmp202_;
																_tmp200_ = nv;
																_tmp200__length1 = nv_length1;
																_tmp201_ = _tmp200_[1];
																_tmp202_ = vala_gidl_parser_eval (self, _tmp201_);
																_g_free0 (ref_function);
																ref_function = _tmp202_;
															} else {
																gchar** _tmp203_;
																gint _tmp203__length1;
																const gchar* _tmp204_;
																_tmp203_ = nv;
																_tmp203__length1 = nv_length1;
																_tmp204_ = _tmp203_[0];
																if (g_strcmp0 (_tmp204_, "unref_function") == 0) {
																	gchar** _tmp205_;
																	gint _tmp205__length1;
																	const gchar* _tmp206_;
																	gchar* _tmp207_;
																	_tmp205_ = nv;
																	_tmp205__length1 = nv_length1;
																	_tmp206_ = _tmp205_[1];
																	_tmp207_ = vala_gidl_parser_eval (self, _tmp206_);
																	_g_free0 (unref_function);
																	unref_function = _tmp207_;
																} else {
																	gchar** _tmp208_;
																	gint _tmp208__length1;
																	const gchar* _tmp209_;
																	_tmp208_ = nv;
																	_tmp208__length1 = nv_length1;
																	_tmp209_ = _tmp208_[0];
																	if (g_strcmp0 (_tmp209_, "copy_function") == 0) {
																		gchar** _tmp210_;
																		gint _tmp210__length1;
																		const gchar* _tmp211_;
																		gchar* _tmp212_;
																		_tmp210_ = nv;
																		_tmp210__length1 = nv_length1;
																		_tmp211_ = _tmp210_[1];
																		_tmp212_ = vala_gidl_parser_eval (self, _tmp211_);
																		_g_free0 (copy_function);
																		copy_function = _tmp212_;
																	} else {
																		gchar** _tmp213_;
																		gint _tmp213__length1;
																		const gchar* _tmp214_;
																		_tmp213_ = nv;
																		_tmp213__length1 = nv_length1;
																		_tmp214_ = _tmp213_[0];
																		if (g_strcmp0 (_tmp214_, "ref_function_void") == 0) {
																			gchar** _tmp215_;
																			gint _tmp215__length1;
																			const gchar* _tmp216_;
																			gchar* _tmp217_;
																			gchar* _tmp218_;
																			gboolean _tmp219_;
																			_tmp215_ = nv;
																			_tmp215__length1 = nv_length1;
																			_tmp216_ = _tmp215_[1];
																			_tmp217_ = vala_gidl_parser_eval (self, _tmp216_);
																			_tmp218_ = _tmp217_;
																			_tmp219_ = g_strcmp0 (_tmp218_, "1") == 0;
																			_g_free0 (_tmp218_);
																			if (_tmp219_) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			gchar** _tmp220_;
																			gint _tmp220__length1;
																			const gchar* _tmp221_;
																			_tmp220_ = nv;
																			_tmp220__length1 = nv_length1;
																			_tmp221_ = _tmp220_[0];
																			if (g_strcmp0 (_tmp221_, "experimental") == 0) {
																				gchar** _tmp222_;
																				gint _tmp222__length1;
																				const gchar* _tmp223_;
																				gchar* _tmp224_;
																				gchar* _tmp225_;
																				gboolean _tmp226_;
																				_tmp222_ = nv;
																				_tmp222__length1 = nv_length1;
																				_tmp223_ = _tmp222_[1];
																				_tmp224_ = vala_gidl_parser_eval (self, _tmp223_);
																				_tmp225_ = _tmp224_;
																				_tmp226_ = g_strcmp0 (_tmp225_, "1") == 0;
																				_g_free0 (_tmp225_);
																				if (_tmp226_) {
																					ValaClass* _tmp227_;
																					_tmp227_ = cl;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp227_, "Version", "experimental", TRUE, NULL);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp228_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp228_);
			_tmp229_ = self->priv->current_source_file;
			_tmp230_ = cl;
			vala_source_file_add_node (_tmp229_, (ValaCodeNode*) _tmp230_);
			_tmp231_ = base_class;
			if (_tmp231_ != NULL) {
				ValaDataType* parent = NULL;
				const gchar* _tmp232_;
				ValaDataType* _tmp233_;
				ValaClass* _tmp234_;
				ValaDataType* _tmp235_;
				_tmp232_ = base_class;
				_tmp233_ = vala_gidl_parser_parse_type_string (self, _tmp232_);
				parent = _tmp233_;
				_tmp234_ = cl;
				_tmp235_ = parent;
				vala_class_add_base_type (_tmp234_, _tmp235_);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp236_ = cl;
		_tmp237_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp236_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp237_;
		_tmp238_ = boxed_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp238_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp239_;
					GIdlNodeTypeId _tmp240_;
					_tmp239_ = member;
					_tmp240_ = _tmp239_->type;
					if (_tmp240_ == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp241_;
						const gchar* _tmp242_;
						_tmp241_ = member;
						_tmp242_ = _tmp241_->name;
						if (g_strcmp0 (_tmp242_, "ref") == 0) {
							GIdlNode* _tmp243_;
							const gchar* _tmp244_;
							gchar* _tmp245_;
							GIdlNode* _tmp246_;
							GIdlNodeParam* _tmp247_;
							GIdlNodeType* _tmp248_;
							ValaDataType* _tmp249_;
							ValaDataType* _tmp250_;
							_tmp243_ = member;
							_tmp244_ = ((GIdlNodeFunction*) _tmp243_)->symbol;
							_tmp245_ = g_strdup (_tmp244_);
							_g_free0 (ref_function);
							ref_function = _tmp245_;
							_tmp246_ = member;
							_tmp247_ = ((GIdlNodeFunction*) _tmp246_)->result;
							_tmp248_ = _tmp247_->type;
							_tmp249_ = vala_gidl_parser_parse_type (self, _tmp248_, NULL);
							_tmp250_ = _tmp249_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp250_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp250_);
						} else {
							GIdlNode* _tmp251_;
							const gchar* _tmp252_;
							_tmp251_ = member;
							_tmp252_ = _tmp251_->name;
							if (g_strcmp0 (_tmp252_, "unref") == 0) {
								GIdlNode* _tmp253_;
								const gchar* _tmp254_;
								gchar* _tmp255_;
								_tmp253_ = member;
								_tmp254_ = ((GIdlNodeFunction*) _tmp253_)->symbol;
								_tmp255_ = g_strdup (_tmp254_);
								_g_free0 (unref_function);
								unref_function = _tmp255_;
							} else {
								gboolean _tmp256_ = FALSE;
								GIdlNode* _tmp257_;
								const gchar* _tmp258_;
								_tmp257_ = member;
								_tmp258_ = _tmp257_->name;
								if (g_strcmp0 (_tmp258_, "free") == 0) {
									_tmp256_ = TRUE;
								} else {
									GIdlNode* _tmp259_;
									const gchar* _tmp260_;
									_tmp259_ = member;
									_tmp260_ = _tmp259_->name;
									_tmp256_ = g_strcmp0 (_tmp260_, "destroy") == 0;
								}
								if (_tmp256_) {
									GIdlNode* _tmp261_;
									const gchar* _tmp262_;
									gchar* _tmp263_;
									_tmp261_ = member;
									_tmp262_ = ((GIdlNodeFunction*) _tmp261_)->symbol;
									_tmp263_ = g_strdup (_tmp262_);
									_g_free0 (free_function);
									free_function = _tmp263_;
								} else {
									GIdlNode* _tmp264_;
									const gchar* _tmp265_;
									ValaMethod* m = NULL;
									GIdlNode* _tmp269_;
									ValaMethod* _tmp270_;
									ValaMethod* _tmp271_;
									_tmp264_ = member;
									_tmp265_ = _tmp264_->name;
									if (g_strcmp0 (_tmp265_, "copy") == 0) {
										GIdlNode* _tmp266_;
										const gchar* _tmp267_;
										gchar* _tmp268_;
										_tmp266_ = member;
										_tmp267_ = ((GIdlNodeFunction*) _tmp266_)->symbol;
										_tmp268_ = g_strdup (_tmp267_);
										_g_free0 (copy_function);
										copy_function = _tmp268_;
									}
									_tmp269_ = member;
									_tmp270_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp269_, FALSE);
									m = _tmp270_;
									_tmp271_ = m;
									if (_tmp271_ != NULL) {
										ValaClass* _tmp272_;
										ValaMethod* _tmp273_;
										_tmp272_ = cl;
										_tmp273_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp272_, _tmp273_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp274_;
						GIdlNodeTypeId _tmp275_;
						_tmp274_ = member;
						_tmp275_ = _tmp274_->type;
						if (_tmp275_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp276_;
							ValaField* _tmp277_;
							ValaField* _tmp278_;
							_tmp276_ = member;
							_tmp277_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp276_);
							f = _tmp277_;
							_tmp278_ = f;
							if (_tmp278_ != NULL) {
								ValaClass* _tmp279_;
								ValaField* _tmp280_;
								_tmp279_ = cl;
								_tmp280_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp279_, _tmp280_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp281_ = ref_function;
		if (_tmp281_ != NULL) {
			ValaClass* _tmp282_;
			const gchar* _tmp283_;
			gboolean _tmp284_;
			_tmp282_ = cl;
			_tmp283_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp282_, "CCode", "ref_function", _tmp283_, NULL);
			_tmp284_ = ref_function_void;
			if (_tmp284_) {
				ValaClass* _tmp285_;
				gboolean _tmp286_;
				_tmp285_ = cl;
				_tmp286_ = ref_function_void;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp285_, "CCode", "ref_function_void", _tmp286_, NULL);
			}
		} else {
			const gchar* _tmp287_;
			_tmp287_ = copy_function;
			if (_tmp287_ != NULL) {
				ValaClass* _tmp288_;
				const gchar* _tmp289_;
				_tmp288_ = cl;
				_tmp289_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp288_, "CCode", "copy_function", _tmp289_, NULL);
			}
		}
		_tmp290_ = unref_function;
		if (_tmp290_ != NULL) {
			ValaClass* _tmp291_;
			const gchar* _tmp292_;
			_tmp291_ = cl;
			_tmp292_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp291_, "CCode", "unref_function", _tmp292_, NULL);
		} else {
			gboolean _tmp293_ = FALSE;
			const gchar* _tmp294_;
			_tmp294_ = free_function;
			if (_tmp294_ != NULL) {
				const gchar* _tmp295_;
				ValaClass* _tmp296_;
				gchar* _tmp297_;
				gchar* _tmp298_;
				gchar* _tmp299_;
				gchar* _tmp300_;
				_tmp295_ = free_function;
				_tmp296_ = cl;
				_tmp297_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp296_);
				_tmp298_ = _tmp297_;
				_tmp299_ = g_strdup_printf ("%sfree", _tmp298_);
				_tmp300_ = _tmp299_;
				_tmp293_ = g_strcmp0 (_tmp295_, _tmp300_) != 0;
				_g_free0 (_tmp300_);
				_g_free0 (_tmp298_);
			} else {
				_tmp293_ = FALSE;
			}
			if (_tmp293_) {
				ValaClass* _tmp301_;
				const gchar* _tmp302_;
				_tmp301_ = cl;
				_tmp302_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp301_, "CCode", "free_function", _tmp302_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


static void
vala_gidl_parser_parse_enum (ValaGIdlParser* self,
                             GIdlNodeEnum* en_node,
                             ValaSymbol* container,
                             GIdlModule* module,
                             gboolean is_flags)
{
	GIdlNode* node = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean existing = FALSE;
	ValaEnum* en = NULL;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	const gchar* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaEnum* _tmp7_;
	ValaEnum* _tmp8_;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gchar* common_prefix = NULL;
	GList* _tmp29_;
	gboolean is_errordomain = FALSE;
	gchar* cheader_filename = NULL;
	gchar** en_attributes = NULL;
	GIdlNode* _tmp94_;
	const gchar* _tmp95_;
	gint _tmp96_ = 0;
	gchar** _tmp97_;
	gint en_attributes_length1;
	gint _en_attributes_size_;
	gchar** _tmp98_;
	gint _tmp98__length1;
	ValaEnum* _tmp192_;
	const gchar* _tmp193_;
	GList* _tmp194_;
	gboolean _tmp246_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) en_node;
	_tmp0_ = node;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = vala_gidl_parser_fix_type_name (self, _tmp1_, container);
	name = _tmp2_;
	existing = TRUE;
	_tmp3_ = vala_symbol_get_scope (container);
	_tmp4_ = _tmp3_;
	_tmp5_ = name;
	_tmp6_ = vala_scope_lookup (_tmp4_, _tmp5_);
	_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_ENUM) ? ((ValaEnum*) _tmp6_) : NULL;
	if (_tmp7_ == NULL) {
		_vala_code_node_unref0 (_tmp6_);
	}
	en = _tmp7_;
	_tmp8_ = en;
	if (_tmp8_ == NULL) {
		const gchar* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaEnum* _tmp11_;
		ValaEnum* _tmp12_;
		_tmp9_ = name;
		_tmp10_ = self->priv->current_source_reference;
		_tmp11_ = vala_enum_new (_tmp9_, _tmp10_, NULL);
		_vala_code_node_unref0 (en);
		en = _tmp11_;
		_tmp12_ = en;
		vala_symbol_set_access ((ValaSymbol*) _tmp12_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		existing = FALSE;
	} else {
		ValaEnumValue* dummy = NULL;
		ValaEnum* _tmp13_;
		ValaScope* _tmp14_;
		ValaScope* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaEnumValue* _tmp17_;
		_tmp13_ = en;
		_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_scope_lookup (_tmp15_, "__DUMMY__");
		dummy = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_ENUM_VALUE, ValaEnumValue);
		_tmp17_ = dummy;
		if (_tmp17_ != NULL) {
			ValaEnum* _tmp18_;
			ValaList* _tmp19_;
			ValaList* _tmp20_;
			ValaEnumValue* _tmp21_;
			ValaEnum* _tmp22_;
			ValaScope* _tmp23_;
			ValaScope* _tmp24_;
			_tmp18_ = en;
			_tmp19_ = vala_enum_get_values (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = dummy;
			vala_collection_remove ((ValaCollection*) _tmp20_, _tmp21_);
			_vala_iterable_unref0 (_tmp20_);
			_tmp22_ = en;
			_tmp23_ = vala_symbol_get_scope ((ValaSymbol*) _tmp22_);
			_tmp24_ = _tmp23_;
			vala_scope_remove (_tmp24_, "__DUMMY__");
		}
		_vala_code_node_unref0 (dummy);
	}
	_tmp26_ = en_node->gtype_name;
	if (_tmp26_ == NULL) {
		_tmp25_ = TRUE;
	} else {
		const gchar* _tmp27_;
		_tmp27_ = en_node->gtype_name;
		_tmp25_ = g_strcmp0 (_tmp27_, "") == 0;
	}
	if (_tmp25_) {
		ValaEnum* _tmp28_;
		_tmp28_ = en;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp28_, "CCode", "has_type_id", FALSE, NULL);
	}
	common_prefix = NULL;
	_tmp29_ = en_node->values;
	{
		GList* value_collection = NULL;
		GList* value_it = NULL;
		value_collection = _tmp29_;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GIdlNode* value = NULL;
			value = (GIdlNode*) value_it->data;
			{
				gchar** val_attributes = NULL;
				GIdlNode* _tmp30_;
				const gchar* _tmp31_;
				gint _tmp32_ = 0;
				gchar** _tmp33_;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gboolean is_hidden = FALSE;
				gchar** _tmp34_;
				gint _tmp34__length1;
				gboolean _tmp47_;
				const gchar* _tmp48_;
				_tmp30_ = value;
				_tmp31_ = _tmp30_->name;
				_tmp33_ = vala_gidl_parser_get_attributes (self, _tmp31_, &_tmp32_);
				val_attributes = _tmp33_;
				val_attributes_length1 = _tmp32_;
				_val_attributes_size_ = val_attributes_length1;
				is_hidden = FALSE;
				_tmp34_ = val_attributes;
				_tmp34__length1 = val_attributes_length1;
				if (_tmp34_ != NULL) {
					gchar** _tmp35_;
					gint _tmp35__length1;
					_tmp35_ = val_attributes;
					_tmp35__length1 = val_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp35_;
						attr_collection_length1 = _tmp35__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp36_;
							gchar* attr = NULL;
							_tmp36_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp36_;
							{
								gchar** nv = NULL;
								const gchar* _tmp37_;
								gchar** _tmp38_;
								gchar** _tmp39_;
								gint nv_length1;
								gint _nv_size_;
								gboolean _tmp40_ = FALSE;
								gchar** _tmp41_;
								gint _tmp41__length1;
								const gchar* _tmp42_;
								_tmp37_ = attr;
								_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, "=", 2);
								nv = _tmp39_;
								nv_length1 = _vala_array_length (_tmp38_);
								_nv_size_ = nv_length1;
								_tmp41_ = nv;
								_tmp41__length1 = nv_length1;
								_tmp42_ = _tmp41_[0];
								if (g_strcmp0 (_tmp42_, "hidden") == 0) {
									gchar** _tmp43_;
									gint _tmp43__length1;
									const gchar* _tmp44_;
									gchar* _tmp45_;
									gchar* _tmp46_;
									_tmp43_ = nv;
									_tmp43__length1 = nv_length1;
									_tmp44_ = _tmp43_[1];
									_tmp45_ = vala_gidl_parser_eval (self, _tmp44_);
									_tmp46_ = _tmp45_;
									_tmp40_ = g_strcmp0 (_tmp46_, "1") == 0;
									_g_free0 (_tmp46_);
								} else {
									_tmp40_ = FALSE;
								}
								if (_tmp40_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp47_ = is_hidden;
				if (_tmp47_) {
					val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				_tmp48_ = common_prefix;
				if (_tmp48_ == NULL) {
					GIdlNode* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp49_ = value;
					_tmp50_ = _tmp49_->name;
					_tmp51_ = g_strdup (_tmp50_);
					_g_free0 (common_prefix);
					common_prefix = _tmp51_;
					while (TRUE) {
						gboolean _tmp52_ = FALSE;
						const gchar* _tmp53_;
						gint _tmp54_;
						gint _tmp55_;
						const gchar* _tmp57_;
						const gchar* _tmp58_;
						gint _tmp59_;
						gint _tmp60_;
						gchar* _tmp61_;
						_tmp53_ = common_prefix;
						_tmp54_ = strlen (_tmp53_);
						_tmp55_ = _tmp54_;
						if (_tmp55_ > 0) {
							const gchar* _tmp56_;
							_tmp56_ = common_prefix;
							_tmp52_ = !g_str_has_suffix (_tmp56_, "_");
						} else {
							_tmp52_ = FALSE;
						}
						if (!_tmp52_) {
							break;
						}
						_tmp57_ = common_prefix;
						_tmp58_ = common_prefix;
						_tmp59_ = strlen (_tmp58_);
						_tmp60_ = _tmp59_;
						_tmp61_ = string_substring (_tmp57_, (glong) 0, (glong) (_tmp60_ - 1));
						_g_free0 (common_prefix);
						common_prefix = _tmp61_;
					}
				} else {
					while (TRUE) {
						GIdlNode* _tmp62_;
						const gchar* _tmp63_;
						const gchar* _tmp64_;
						const gchar* _tmp65_;
						const gchar* _tmp66_;
						gint _tmp67_;
						gint _tmp68_;
						gchar* _tmp69_;
						_tmp62_ = value;
						_tmp63_ = _tmp62_->name;
						_tmp64_ = common_prefix;
						if (!(!g_str_has_prefix (_tmp63_, _tmp64_))) {
							break;
						}
						_tmp65_ = common_prefix;
						_tmp66_ = common_prefix;
						_tmp67_ = strlen (_tmp66_);
						_tmp68_ = _tmp67_;
						_tmp69_ = string_substring (_tmp65_, (glong) 0, (glong) (_tmp68_ - 1));
						_g_free0 (common_prefix);
						common_prefix = _tmp69_;
					}
				}
				while (TRUE) {
					gboolean _tmp70_ = FALSE;
					const gchar* _tmp71_;
					gint _tmp72_;
					gint _tmp73_;
					const gchar* _tmp89_;
					const gchar* _tmp90_;
					gint _tmp91_;
					gint _tmp92_;
					gchar* _tmp93_;
					_tmp71_ = common_prefix;
					_tmp72_ = strlen (_tmp71_);
					_tmp73_ = _tmp72_;
					if (_tmp73_ > 0) {
						gboolean _tmp74_ = FALSE;
						const gchar* _tmp75_;
						_tmp75_ = common_prefix;
						if (!g_str_has_suffix (_tmp75_, "_")) {
							_tmp74_ = TRUE;
						} else {
							gboolean _tmp76_ = FALSE;
							GIdlNode* _tmp77_;
							const gchar* _tmp78_;
							const gchar* _tmp79_;
							gint _tmp80_;
							gint _tmp81_;
							_tmp77_ = value;
							_tmp78_ = _tmp77_->name;
							_tmp79_ = common_prefix;
							_tmp80_ = strlen (_tmp79_);
							_tmp81_ = _tmp80_;
							if (g_unichar_isdigit (string_get_char (_tmp78_, (glong) _tmp81_))) {
								GIdlNode* _tmp82_;
								const gchar* _tmp83_;
								gint _tmp84_;
								gint _tmp85_;
								const gchar* _tmp86_;
								gint _tmp87_;
								gint _tmp88_;
								_tmp82_ = value;
								_tmp83_ = _tmp82_->name;
								_tmp84_ = strlen (_tmp83_);
								_tmp85_ = _tmp84_;
								_tmp86_ = common_prefix;
								_tmp87_ = strlen (_tmp86_);
								_tmp88_ = _tmp87_;
								_tmp76_ = (_tmp85_ - _tmp88_) <= 1;
							} else {
								_tmp76_ = FALSE;
							}
							_tmp74_ = _tmp76_;
						}
						_tmp70_ = _tmp74_;
					} else {
						_tmp70_ = FALSE;
					}
					if (!_tmp70_) {
						break;
					}
					_tmp89_ = common_prefix;
					_tmp90_ = common_prefix;
					_tmp91_ = strlen (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = string_substring (_tmp89_, (glong) 0, (glong) (_tmp92_ - 1));
					_g_free0 (common_prefix);
					common_prefix = _tmp93_;
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	is_errordomain = FALSE;
	cheader_filename = NULL;
	_tmp94_ = node;
	_tmp95_ = _tmp94_->name;
	_tmp97_ = vala_gidl_parser_get_attributes (self, _tmp95_, &_tmp96_);
	en_attributes = _tmp97_;
	en_attributes_length1 = _tmp96_;
	_en_attributes_size_ = en_attributes_length1;
	_tmp98_ = en_attributes;
	_tmp98__length1 = en_attributes_length1;
	if (_tmp98_ != NULL) {
		gchar** _tmp99_;
		gint _tmp99__length1;
		_tmp99_ = en_attributes;
		_tmp99__length1 = en_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp99_;
			attr_collection_length1 = _tmp99__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp100_;
				gchar* attr = NULL;
				_tmp100_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp100_;
				{
					gchar** nv = NULL;
					const gchar* _tmp101_;
					gchar** _tmp102_;
					gchar** _tmp103_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp104_;
					gint _tmp104__length1;
					const gchar* _tmp105_;
					_tmp101_ = attr;
					_tmp103_ = _tmp102_ = g_strsplit (_tmp101_, "=", 2);
					nv = _tmp103_;
					nv_length1 = _vala_array_length (_tmp102_);
					_nv_size_ = nv_length1;
					_tmp104_ = nv;
					_tmp104__length1 = nv_length1;
					_tmp105_ = _tmp104_[0];
					if (g_strcmp0 (_tmp105_, "common_prefix") == 0) {
						gchar** _tmp106_;
						gint _tmp106__length1;
						const gchar* _tmp107_;
						gchar* _tmp108_;
						_tmp106_ = nv;
						_tmp106__length1 = nv_length1;
						_tmp107_ = _tmp106_[1];
						_tmp108_ = vala_gidl_parser_eval (self, _tmp107_);
						_g_free0 (common_prefix);
						common_prefix = _tmp108_;
					} else {
						gchar** _tmp109_;
						gint _tmp109__length1;
						const gchar* _tmp110_;
						_tmp109_ = nv;
						_tmp109__length1 = nv_length1;
						_tmp110_ = _tmp109_[0];
						if (g_strcmp0 (_tmp110_, "cheader_filename") == 0) {
							gchar** _tmp111_;
							gint _tmp111__length1;
							const gchar* _tmp112_;
							gchar* _tmp113_;
							ValaEnum* _tmp114_;
							const gchar* _tmp115_;
							_tmp111_ = nv;
							_tmp111__length1 = nv_length1;
							_tmp112_ = _tmp111_[1];
							_tmp113_ = vala_gidl_parser_eval (self, _tmp112_);
							_g_free0 (cheader_filename);
							cheader_filename = _tmp113_;
							_tmp114_ = en;
							_tmp115_ = cheader_filename;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp114_, "CCode", "cheader_filename", _tmp115_, NULL);
						} else {
							gchar** _tmp116_;
							gint _tmp116__length1;
							const gchar* _tmp117_;
							_tmp116_ = nv;
							_tmp116__length1 = nv_length1;
							_tmp117_ = _tmp116_[0];
							if (g_strcmp0 (_tmp117_, "hidden") == 0) {
								gchar** _tmp118_;
								gint _tmp118__length1;
								const gchar* _tmp119_;
								gchar* _tmp120_;
								gchar* _tmp121_;
								gboolean _tmp122_;
								_tmp118_ = nv;
								_tmp118__length1 = nv_length1;
								_tmp119_ = _tmp118_[1];
								_tmp120_ = vala_gidl_parser_eval (self, _tmp119_);
								_tmp121_ = _tmp120_;
								_tmp122_ = g_strcmp0 (_tmp121_, "1") == 0;
								_g_free0 (_tmp121_);
								if (_tmp122_) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (cheader_filename);
									_g_free0 (common_prefix);
									_vala_code_node_unref0 (en);
									_g_free0 (name);
									return;
								}
							} else {
								gchar** _tmp123_;
								gint _tmp123__length1;
								const gchar* _tmp124_;
								_tmp123_ = nv;
								_tmp123__length1 = nv_length1;
								_tmp124_ = _tmp123_[0];
								if (g_strcmp0 (_tmp124_, "deprecated") == 0) {
									gchar** _tmp125_;
									gint _tmp125__length1;
									const gchar* _tmp126_;
									gchar* _tmp127_;
									gchar* _tmp128_;
									gboolean _tmp129_;
									_tmp125_ = nv;
									_tmp125__length1 = nv_length1;
									_tmp126_ = _tmp125_[1];
									_tmp127_ = vala_gidl_parser_eval (self, _tmp126_);
									_tmp128_ = _tmp127_;
									_tmp129_ = g_strcmp0 (_tmp128_, "1") == 0;
									_g_free0 (_tmp128_);
									if (_tmp129_) {
										ValaEnum* _tmp130_;
										_tmp130_ = en;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp130_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp131_;
									gint _tmp131__length1;
									const gchar* _tmp132_;
									_tmp131_ = nv;
									_tmp131__length1 = nv_length1;
									_tmp132_ = _tmp131_[0];
									if (g_strcmp0 (_tmp132_, "default_value") == 0) {
										ValaEnum* _tmp133_;
										gchar** _tmp134_;
										gint _tmp134__length1;
										const gchar* _tmp135_;
										gchar* _tmp136_;
										gchar* _tmp137_;
										_tmp133_ = en;
										_tmp134_ = nv;
										_tmp134__length1 = nv_length1;
										_tmp135_ = _tmp134_[1];
										_tmp136_ = vala_gidl_parser_eval (self, _tmp135_);
										_tmp137_ = _tmp136_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp133_, "CCode", "default_value", _tmp137_, NULL);
										_g_free0 (_tmp137_);
									} else {
										gchar** _tmp138_;
										gint _tmp138__length1;
										const gchar* _tmp139_;
										_tmp138_ = nv;
										_tmp138__length1 = nv_length1;
										_tmp139_ = _tmp138_[0];
										if (g_strcmp0 (_tmp139_, "replacement") == 0) {
											ValaEnum* _tmp140_;
											gchar** _tmp141_;
											gint _tmp141__length1;
											const gchar* _tmp142_;
											gchar* _tmp143_;
											gchar* _tmp144_;
											_tmp140_ = en;
											_tmp141_ = nv;
											_tmp141__length1 = nv_length1;
											_tmp142_ = _tmp141_[1];
											_tmp143_ = vala_gidl_parser_eval (self, _tmp142_);
											_tmp144_ = _tmp143_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp140_, "Version", "replacement", _tmp144_, NULL);
											_g_free0 (_tmp144_);
										} else {
											gchar** _tmp145_;
											gint _tmp145__length1;
											const gchar* _tmp146_;
											_tmp145_ = nv;
											_tmp145__length1 = nv_length1;
											_tmp146_ = _tmp145_[0];
											if (g_strcmp0 (_tmp146_, "deprecated_since") == 0) {
												ValaEnum* _tmp147_;
												gchar** _tmp148_;
												gint _tmp148__length1;
												const gchar* _tmp149_;
												gchar* _tmp150_;
												gchar* _tmp151_;
												_tmp147_ = en;
												_tmp148_ = nv;
												_tmp148__length1 = nv_length1;
												_tmp149_ = _tmp148_[1];
												_tmp150_ = vala_gidl_parser_eval (self, _tmp149_);
												_tmp151_ = _tmp150_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp147_, "Version", "deprecated_since", _tmp151_, NULL);
												_g_free0 (_tmp151_);
											} else {
												gchar** _tmp152_;
												gint _tmp152__length1;
												const gchar* _tmp153_;
												_tmp152_ = nv;
												_tmp152__length1 = nv_length1;
												_tmp153_ = _tmp152_[0];
												if (g_strcmp0 (_tmp153_, "rename_to") == 0) {
													ValaEnum* _tmp154_;
													gchar** _tmp155_;
													gint _tmp155__length1;
													const gchar* _tmp156_;
													gchar* _tmp157_;
													gchar* _tmp158_;
													_tmp154_ = en;
													_tmp155_ = nv;
													_tmp155__length1 = nv_length1;
													_tmp156_ = _tmp155_[1];
													_tmp157_ = vala_gidl_parser_eval (self, _tmp156_);
													_tmp158_ = _tmp157_;
													vala_symbol_set_name ((ValaSymbol*) _tmp154_, _tmp158_);
													_g_free0 (_tmp158_);
												} else {
													gchar** _tmp159_;
													gint _tmp159__length1;
													const gchar* _tmp160_;
													_tmp159_ = nv;
													_tmp159__length1 = nv_length1;
													_tmp160_ = _tmp159_[0];
													if (g_strcmp0 (_tmp160_, "errordomain") == 0) {
														gchar** _tmp161_;
														gint _tmp161__length1;
														const gchar* _tmp162_;
														gchar* _tmp163_;
														gchar* _tmp164_;
														gboolean _tmp165_;
														_tmp161_ = nv;
														_tmp161__length1 = nv_length1;
														_tmp162_ = _tmp161_[1];
														_tmp163_ = vala_gidl_parser_eval (self, _tmp162_);
														_tmp164_ = _tmp163_;
														_tmp165_ = g_strcmp0 (_tmp164_, "1") == 0;
														_g_free0 (_tmp164_);
														if (_tmp165_) {
															is_errordomain = TRUE;
														}
													} else {
														gchar** _tmp166_;
														gint _tmp166__length1;
														const gchar* _tmp167_;
														_tmp166_ = nv;
														_tmp166__length1 = nv_length1;
														_tmp167_ = _tmp166_[0];
														if (g_strcmp0 (_tmp167_, "to_string") == 0) {
															ValaUnresolvedType* return_type = NULL;
															ValaUnresolvedType* _tmp168_;
															ValaUnresolvedType* _tmp169_;
															ValaUnresolvedSymbol* _tmp170_;
															ValaUnresolvedSymbol* _tmp171_;
															ValaUnresolvedType* _tmp172_;
															ValaMethod* m = NULL;
															ValaUnresolvedType* _tmp173_;
															ValaSourceReference* _tmp174_;
															ValaMethod* _tmp175_;
															ValaMethod* _tmp176_;
															ValaMethod* _tmp177_;
															gchar** _tmp178_;
															gint _tmp178__length1;
															const gchar* _tmp179_;
															gchar* _tmp180_;
															gchar* _tmp181_;
															ValaEnum* _tmp182_;
															ValaMethod* _tmp183_;
															_tmp168_ = vala_unresolved_type_new ();
															return_type = _tmp168_;
															_tmp169_ = return_type;
															_tmp170_ = vala_unresolved_symbol_new (NULL, "string", NULL);
															_tmp171_ = _tmp170_;
															vala_unresolved_type_set_unresolved_symbol (_tmp169_, _tmp171_);
															_vala_code_node_unref0 (_tmp171_);
															_tmp172_ = return_type;
															vala_data_type_set_value_owned ((ValaDataType*) _tmp172_, FALSE);
															_tmp173_ = return_type;
															_tmp174_ = self->priv->current_source_reference;
															_tmp175_ = vala_method_new ("to_string", (ValaDataType*) _tmp173_, _tmp174_, NULL);
															m = _tmp175_;
															_tmp176_ = m;
															vala_symbol_set_access ((ValaSymbol*) _tmp176_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
															_tmp177_ = m;
															_tmp178_ = nv;
															_tmp178__length1 = nv_length1;
															_tmp179_ = _tmp178_[1];
															_tmp180_ = vala_gidl_parser_eval (self, _tmp179_);
															_tmp181_ = _tmp180_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp177_, "CCode", "cname", _tmp181_, NULL);
															_g_free0 (_tmp181_);
															_tmp182_ = en;
															_tmp183_ = m;
															vala_symbol_add_method ((ValaSymbol*) _tmp182_, _tmp183_);
															_vala_code_node_unref0 (m);
															_vala_code_node_unref0 (return_type);
														} else {
															gchar** _tmp184_;
															gint _tmp184__length1;
															const gchar* _tmp185_;
															_tmp184_ = nv;
															_tmp184__length1 = nv_length1;
															_tmp185_ = _tmp184_[0];
															if (g_strcmp0 (_tmp185_, "experimental") == 0) {
																gchar** _tmp186_;
																gint _tmp186__length1;
																const gchar* _tmp187_;
																gchar* _tmp188_;
																gchar* _tmp189_;
																gboolean _tmp190_;
																_tmp186_ = nv;
																_tmp186__length1 = nv_length1;
																_tmp187_ = _tmp186_[1];
																_tmp188_ = vala_gidl_parser_eval (self, _tmp187_);
																_tmp189_ = _tmp188_;
																_tmp190_ = g_strcmp0 (_tmp189_, "1") == 0;
																_g_free0 (_tmp189_);
																if (_tmp190_) {
																	ValaEnum* _tmp191_;
																	_tmp191_ = en;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp191_, "Version", "experimental", TRUE, NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp192_ = en;
	_tmp193_ = common_prefix;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp192_, "CCode", "cprefix", _tmp193_, NULL);
	_tmp194_ = en_node->values;
	{
		GList* value2_collection = NULL;
		GList* value2_it = NULL;
		value2_collection = _tmp194_;
		for (value2_it = value2_collection; value2_it != NULL; value2_it = value2_it->next) {
			GIdlNode* value2 = NULL;
			value2 = (GIdlNode*) value2_it->data;
			{
				ValaEnumValue* ev = NULL;
				GIdlNode* _tmp195_;
				const gchar* _tmp196_;
				const gchar* _tmp197_;
				gint _tmp198_;
				gint _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				ValaEnumValue* _tmp202_;
				ValaEnumValue* _tmp203_;
				gchar** val_attributes = NULL;
				GIdlNode* _tmp204_;
				const gchar* _tmp205_;
				gint _tmp206_ = 0;
				gchar** _tmp207_;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gboolean is_hidden = FALSE;
				gchar** _tmp208_;
				gint _tmp208__length1;
				gboolean _tmp243_;
				_tmp195_ = value2;
				_tmp196_ = _tmp195_->name;
				_tmp197_ = common_prefix;
				_tmp198_ = strlen (_tmp197_);
				_tmp199_ = _tmp198_;
				_tmp200_ = string_substring (_tmp196_, (glong) _tmp199_, (glong) -1);
				_tmp201_ = _tmp200_;
				_tmp202_ = vala_enum_value_new (_tmp201_, NULL, NULL, NULL);
				_tmp203_ = _tmp202_;
				_g_free0 (_tmp201_);
				ev = _tmp203_;
				_tmp204_ = value2;
				_tmp205_ = _tmp204_->name;
				_tmp207_ = vala_gidl_parser_get_attributes (self, _tmp205_, &_tmp206_);
				val_attributes = _tmp207_;
				val_attributes_length1 = _tmp206_;
				_val_attributes_size_ = val_attributes_length1;
				is_hidden = FALSE;
				_tmp208_ = val_attributes;
				_tmp208__length1 = val_attributes_length1;
				if (_tmp208_ != NULL) {
					gchar** _tmp209_;
					gint _tmp209__length1;
					_tmp209_ = val_attributes;
					_tmp209__length1 = val_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp209_;
						attr_collection_length1 = _tmp209__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp210_;
							gchar* attr = NULL;
							_tmp210_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp210_;
							{
								gchar** nv = NULL;
								const gchar* _tmp211_;
								gchar** _tmp212_;
								gchar** _tmp213_;
								gint nv_length1;
								gint _nv_size_;
								gboolean _tmp214_ = FALSE;
								gchar** _tmp215_;
								gint _tmp215__length1;
								const gchar* _tmp216_;
								_tmp211_ = attr;
								_tmp213_ = _tmp212_ = g_strsplit (_tmp211_, "=", 2);
								nv = _tmp213_;
								nv_length1 = _vala_array_length (_tmp212_);
								_nv_size_ = nv_length1;
								_tmp215_ = nv;
								_tmp215__length1 = nv_length1;
								_tmp216_ = _tmp215_[0];
								if (g_strcmp0 (_tmp216_, "hidden") == 0) {
									gchar** _tmp217_;
									gint _tmp217__length1;
									const gchar* _tmp218_;
									gchar* _tmp219_;
									gchar* _tmp220_;
									_tmp217_ = nv;
									_tmp217__length1 = nv_length1;
									_tmp218_ = _tmp217_[1];
									_tmp219_ = vala_gidl_parser_eval (self, _tmp218_);
									_tmp220_ = _tmp219_;
									_tmp214_ = g_strcmp0 (_tmp220_, "1") == 0;
									_g_free0 (_tmp220_);
								} else {
									_tmp214_ = FALSE;
								}
								if (_tmp214_) {
									is_hidden = TRUE;
								} else {
									gchar** _tmp221_;
									gint _tmp221__length1;
									const gchar* _tmp222_;
									_tmp221_ = nv;
									_tmp221__length1 = nv_length1;
									_tmp222_ = _tmp221_[0];
									if (g_strcmp0 (_tmp222_, "deprecated") == 0) {
										gchar** _tmp223_;
										gint _tmp223__length1;
										const gchar* _tmp224_;
										gchar* _tmp225_;
										gchar* _tmp226_;
										gboolean _tmp227_;
										_tmp223_ = nv;
										_tmp223__length1 = nv_length1;
										_tmp224_ = _tmp223_[1];
										_tmp225_ = vala_gidl_parser_eval (self, _tmp224_);
										_tmp226_ = _tmp225_;
										_tmp227_ = g_strcmp0 (_tmp226_, "1") == 0;
										_g_free0 (_tmp226_);
										if (_tmp227_) {
											ValaEnumValue* _tmp228_;
											_tmp228_ = ev;
											vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp228_, "Version", "deprecated", TRUE, NULL);
										}
									} else {
										gchar** _tmp229_;
										gint _tmp229__length1;
										const gchar* _tmp230_;
										_tmp229_ = nv;
										_tmp229__length1 = nv_length1;
										_tmp230_ = _tmp229_[0];
										if (g_strcmp0 (_tmp230_, "replacement") == 0) {
											ValaEnumValue* _tmp231_;
											gchar** _tmp232_;
											gint _tmp232__length1;
											const gchar* _tmp233_;
											gchar* _tmp234_;
											gchar* _tmp235_;
											_tmp231_ = ev;
											_tmp232_ = nv;
											_tmp232__length1 = nv_length1;
											_tmp233_ = _tmp232_[1];
											_tmp234_ = vala_gidl_parser_eval (self, _tmp233_);
											_tmp235_ = _tmp234_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp231_, "Version", "replacement", _tmp235_, NULL);
											_g_free0 (_tmp235_);
										} else {
											gchar** _tmp236_;
											gint _tmp236__length1;
											const gchar* _tmp237_;
											_tmp236_ = nv;
											_tmp236__length1 = nv_length1;
											_tmp237_ = _tmp236_[0];
											if (g_strcmp0 (_tmp237_, "deprecated_since") == 0) {
												ValaEnumValue* _tmp238_;
												gchar** _tmp239_;
												gint _tmp239__length1;
												const gchar* _tmp240_;
												gchar* _tmp241_;
												gchar* _tmp242_;
												_tmp238_ = ev;
												_tmp239_ = nv;
												_tmp239__length1 = nv_length1;
												_tmp240_ = _tmp239_[1];
												_tmp241_ = vala_gidl_parser_eval (self, _tmp240_);
												_tmp242_ = _tmp241_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp238_, "Version", "deprecated_since", _tmp242_, NULL);
												_g_free0 (_tmp242_);
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp243_ = is_hidden;
				if (!_tmp243_) {
					ValaEnum* _tmp244_;
					ValaEnumValue* _tmp245_;
					_tmp244_ = en;
					_tmp245_ = ev;
					vala_enum_add_value (_tmp244_, _tmp245_);
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
				_vala_code_node_unref0 (ev);
			}
		}
	}
	_tmp246_ = is_errordomain;
	if (_tmp246_) {
		ValaErrorDomain* ed = NULL;
		ValaEnum* _tmp247_;
		const gchar* _tmp248_;
		const gchar* _tmp249_;
		ValaSourceReference* _tmp250_;
		ValaErrorDomain* _tmp251_;
		ValaErrorDomain* _tmp252_;
		ValaErrorDomain* _tmp253_;
		const gchar* _tmp254_;
		const gchar* _tmp255_;
		ValaSourceFile* _tmp275_;
		ValaErrorDomain* _tmp276_;
		gboolean _tmp277_;
		_tmp247_ = en;
		_tmp248_ = vala_symbol_get_name ((ValaSymbol*) _tmp247_);
		_tmp249_ = _tmp248_;
		_tmp250_ = self->priv->current_source_reference;
		_tmp251_ = vala_error_domain_new (_tmp249_, _tmp250_, NULL);
		ed = _tmp251_;
		_tmp252_ = ed;
		vala_symbol_set_access ((ValaSymbol*) _tmp252_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp253_ = ed;
		_tmp254_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp253_, "CCode", "cprefix", _tmp254_, NULL);
		_tmp255_ = cheader_filename;
		if (_tmp255_ != NULL) {
			ValaErrorDomain* _tmp256_;
			const gchar* _tmp257_;
			_tmp256_ = ed;
			_tmp257_ = cheader_filename;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp256_, "CCode", "cheader_filename", _tmp257_, NULL);
		}
		{
			ValaList* _ev_list = NULL;
			ValaEnum* _tmp258_;
			ValaList* _tmp259_;
			gint _ev_size = 0;
			ValaList* _tmp260_;
			gint _tmp261_;
			gint _tmp262_;
			gint _ev_index = 0;
			_tmp258_ = en;
			_tmp259_ = vala_enum_get_values (_tmp258_);
			_ev_list = _tmp259_;
			_tmp260_ = _ev_list;
			_tmp261_ = vala_collection_get_size ((ValaCollection*) _tmp260_);
			_tmp262_ = _tmp261_;
			_ev_size = _tmp262_;
			_ev_index = -1;
			while (TRUE) {
				gint _tmp263_;
				gint _tmp264_;
				gint _tmp265_;
				ValaEnumValue* ev = NULL;
				ValaList* _tmp266_;
				gint _tmp267_;
				gpointer _tmp268_;
				ValaErrorDomain* _tmp269_;
				ValaEnumValue* _tmp270_;
				const gchar* _tmp271_;
				const gchar* _tmp272_;
				ValaErrorCode* _tmp273_;
				ValaErrorCode* _tmp274_;
				_tmp263_ = _ev_index;
				_ev_index = _tmp263_ + 1;
				_tmp264_ = _ev_index;
				_tmp265_ = _ev_size;
				if (!(_tmp264_ < _tmp265_)) {
					break;
				}
				_tmp266_ = _ev_list;
				_tmp267_ = _ev_index;
				_tmp268_ = vala_list_get (_tmp266_, _tmp267_);
				ev = (ValaEnumValue*) _tmp268_;
				_tmp269_ = ed;
				_tmp270_ = ev;
				_tmp271_ = vala_symbol_get_name ((ValaSymbol*) _tmp270_);
				_tmp272_ = _tmp271_;
				_tmp273_ = vala_error_code_new (_tmp272_, NULL, NULL);
				_tmp274_ = _tmp273_;
				vala_error_domain_add_code (_tmp269_, _tmp274_);
				_vala_code_node_unref0 (_tmp274_);
				_vala_code_node_unref0 (ev);
			}
			_vala_iterable_unref0 (_ev_list);
		}
		_tmp275_ = self->priv->current_source_file;
		_tmp276_ = ed;
		vala_source_file_add_node (_tmp275_, (ValaCodeNode*) _tmp276_);
		_tmp277_ = existing;
		if (!_tmp277_) {
			ValaErrorDomain* _tmp278_;
			_tmp278_ = ed;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp278_);
		}
		_vala_code_node_unref0 (ed);
	} else {
		ValaEnum* _tmp279_;
		ValaSourceFile* _tmp280_;
		ValaEnum* _tmp281_;
		gboolean _tmp282_;
		_tmp279_ = en;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp279_, "Flags", is_flags, NULL);
		_tmp280_ = self->priv->current_source_file;
		_tmp281_ = en;
		vala_source_file_add_node (_tmp280_, (ValaCodeNode*) _tmp281_);
		_tmp282_ = existing;
		if (!_tmp282_) {
			ValaEnum* _tmp283_;
			_tmp283_ = en;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp283_);
		}
	}
	en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cheader_filename);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (en);
	_g_free0 (name);
}


static void
vala_gidl_parser_parse_object (ValaGIdlParser* self,
                               GIdlNodeInterface* node,
                               ValaSymbol* container,
                               GIdlModule* module)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* base_class = NULL;
	ValaClass* cl = NULL;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaClass* _tmp6_;
	ValaClass* _tmp7_;
	const gchar* _tmp131_;
	GList* _tmp152_;
	ValaClass* _tmp175_;
	ValaTypeSymbol* _tmp176_;
	GHashFunc _tmp177_;
	GEqualFunc _tmp178_;
	ValaHashSet* _tmp179_;
	ValaHashMap* current_type_func_map = NULL;
	GHashFunc _tmp180_;
	GEqualFunc _tmp181_;
	GEqualFunc _tmp182_;
	ValaHashMap* _tmp183_;
	ValaHashMap* current_type_vfunc_map = NULL;
	GHashFunc _tmp184_;
	GEqualFunc _tmp185_;
	GEqualFunc _tmp186_;
	ValaHashMap* _tmp187_;
	GList* _tmp188_;
	GList* _tmp200_;
	GList* _tmp236_;
	ValaClass* _tmp299_;
	ValaClass* _tmp300_;
	ValaCreationMethod* _tmp301_;
	ValaCreationMethod* _tmp302_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = ((GIdlNode*) node)->name;
	_tmp1_ = vala_gidl_parser_fix_type_name (self, _tmp0_, container);
	name = _tmp1_;
	base_class = NULL;
	_tmp2_ = vala_symbol_get_scope (container);
	_tmp3_ = _tmp2_;
	_tmp4_ = name;
	_tmp5_ = vala_scope_lookup (_tmp3_, _tmp4_);
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_vala_code_node_unref0 (_tmp5_);
	}
	cl = _tmp6_;
	_tmp7_ = cl;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaClass* _tmp10_;
		ValaClass* _tmp11_;
		gchar** attributes = NULL;
		const gchar* _tmp12_;
		gint _tmp13_ = 0;
		gchar** _tmp14_;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		ValaClass* _tmp128_;
		ValaSourceFile* _tmp129_;
		ValaClass* _tmp130_;
		_tmp8_ = name;
		_tmp9_ = self->priv->current_source_reference;
		_tmp10_ = vala_class_new (_tmp8_, _tmp9_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp10_;
		_tmp11_ = cl;
		vala_symbol_set_access ((ValaSymbol*) _tmp11_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp12_ = node->gtype_name;
		_tmp14_ = vala_gidl_parser_get_attributes (self, _tmp12_, &_tmp13_);
		attributes = _tmp14_;
		attributes_length1 = _tmp13_;
		_attributes_size_ = attributes_length1;
		_tmp15_ = attributes;
		_tmp15__length1 = attributes_length1;
		if (_tmp15_ != NULL) {
			gchar** _tmp16_;
			gint _tmp16__length1;
			_tmp16_ = attributes;
			_tmp16__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp16_;
				attr_collection_length1 = _tmp16__length1;
				for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
					gchar* _tmp17_;
					gchar* attr = NULL;
					_tmp17_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp17_;
					{
						gchar** nv = NULL;
						const gchar* _tmp18_;
						gchar** _tmp19_;
						gchar** _tmp20_;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						_tmp18_ = attr;
						_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
						nv = _tmp20_;
						nv_length1 = _vala_array_length (_tmp19_);
						_nv_size_ = nv_length1;
						_tmp21_ = nv;
						_tmp21__length1 = nv_length1;
						_tmp22_ = _tmp21_[0];
						if (g_strcmp0 (_tmp22_, "cheader_filename") == 0) {
							ValaClass* _tmp23_;
							gchar** _tmp24_;
							gint _tmp24__length1;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							_tmp23_ = cl;
							_tmp24_ = nv;
							_tmp24__length1 = nv_length1;
							_tmp25_ = _tmp24_[1];
							_tmp26_ = vala_gidl_parser_eval (self, _tmp25_);
							_tmp27_ = _tmp26_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp23_, "CCode", "cheader_filename", _tmp27_, NULL);
							_g_free0 (_tmp27_);
						} else {
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[0];
							if (g_strcmp0 (_tmp29_, "base_class") == 0) {
								gchar** _tmp30_;
								gint _tmp30__length1;
								const gchar* _tmp31_;
								gchar* _tmp32_;
								_tmp30_ = nv;
								_tmp30__length1 = nv_length1;
								_tmp31_ = _tmp30_[1];
								_tmp32_ = vala_gidl_parser_eval (self, _tmp31_);
								_g_free0 (base_class);
								base_class = _tmp32_;
							} else {
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								_tmp33_ = nv;
								_tmp33__length1 = nv_length1;
								_tmp34_ = _tmp33_[0];
								if (g_strcmp0 (_tmp34_, "hidden") == 0) {
									gchar** _tmp35_;
									gint _tmp35__length1;
									const gchar* _tmp36_;
									gchar* _tmp37_;
									gchar* _tmp38_;
									gboolean _tmp39_;
									_tmp35_ = nv;
									_tmp35__length1 = nv_length1;
									_tmp36_ = _tmp35_[1];
									_tmp37_ = vala_gidl_parser_eval (self, _tmp36_);
									_tmp38_ = _tmp37_;
									_tmp39_ = g_strcmp0 (_tmp38_, "1") == 0;
									_g_free0 (_tmp38_);
									if (_tmp39_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (base_class);
										_g_free0 (name);
										return;
									}
								} else {
									gchar** _tmp40_;
									gint _tmp40__length1;
									const gchar* _tmp41_;
									_tmp40_ = nv;
									_tmp40__length1 = nv_length1;
									_tmp41_ = _tmp40_[0];
									if (g_strcmp0 (_tmp41_, "type_check_function") == 0) {
										ValaClass* _tmp42_;
										gchar** _tmp43_;
										gint _tmp43__length1;
										const gchar* _tmp44_;
										gchar* _tmp45_;
										gchar* _tmp46_;
										_tmp42_ = cl;
										_tmp43_ = nv;
										_tmp43__length1 = nv_length1;
										_tmp44_ = _tmp43_[1];
										_tmp45_ = vala_gidl_parser_eval (self, _tmp44_);
										_tmp46_ = _tmp45_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp42_, "CCode", "type_check_function", _tmp46_, NULL);
										_g_free0 (_tmp46_);
									} else {
										gchar** _tmp47_;
										gint _tmp47__length1;
										const gchar* _tmp48_;
										_tmp47_ = nv;
										_tmp47__length1 = nv_length1;
										_tmp48_ = _tmp47_[0];
										if (g_strcmp0 (_tmp48_, "deprecated") == 0) {
											gchar** _tmp49_;
											gint _tmp49__length1;
											const gchar* _tmp50_;
											gchar* _tmp51_;
											gchar* _tmp52_;
											gboolean _tmp53_;
											_tmp49_ = nv;
											_tmp49__length1 = nv_length1;
											_tmp50_ = _tmp49_[1];
											_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
											_tmp52_ = _tmp51_;
											_tmp53_ = g_strcmp0 (_tmp52_, "1") == 0;
											_g_free0 (_tmp52_);
											if (_tmp53_) {
												ValaClass* _tmp54_;
												_tmp54_ = cl;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp54_, "Version", "deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp55_;
											gint _tmp55__length1;
											const gchar* _tmp56_;
											_tmp55_ = nv;
											_tmp55__length1 = nv_length1;
											_tmp56_ = _tmp55_[0];
											if (g_strcmp0 (_tmp56_, "replacement") == 0) {
												ValaClass* _tmp57_;
												gchar** _tmp58_;
												gint _tmp58__length1;
												const gchar* _tmp59_;
												gchar* _tmp60_;
												gchar* _tmp61_;
												_tmp57_ = cl;
												_tmp58_ = nv;
												_tmp58__length1 = nv_length1;
												_tmp59_ = _tmp58_[1];
												_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
												_tmp61_ = _tmp60_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp57_, "Version", "replacement", _tmp61_, NULL);
												_g_free0 (_tmp61_);
											} else {
												gchar** _tmp62_;
												gint _tmp62__length1;
												const gchar* _tmp63_;
												_tmp62_ = nv;
												_tmp62__length1 = nv_length1;
												_tmp63_ = _tmp62_[0];
												if (g_strcmp0 (_tmp63_, "deprecated_since") == 0) {
													ValaClass* _tmp64_;
													gchar** _tmp65_;
													gint _tmp65__length1;
													const gchar* _tmp66_;
													gchar* _tmp67_;
													gchar* _tmp68_;
													_tmp64_ = cl;
													_tmp65_ = nv;
													_tmp65__length1 = nv_length1;
													_tmp66_ = _tmp65_[1];
													_tmp67_ = vala_gidl_parser_eval (self, _tmp66_);
													_tmp68_ = _tmp67_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp64_, "Version", "deprecated_since", _tmp68_, NULL);
													_g_free0 (_tmp68_);
												} else {
													gchar** _tmp69_;
													gint _tmp69__length1;
													const gchar* _tmp70_;
													_tmp69_ = nv;
													_tmp69__length1 = nv_length1;
													_tmp70_ = _tmp69_[0];
													if (g_strcmp0 (_tmp70_, "type_id") == 0) {
														ValaClass* _tmp71_;
														gchar** _tmp72_;
														gint _tmp72__length1;
														const gchar* _tmp73_;
														gchar* _tmp74_;
														gchar* _tmp75_;
														_tmp71_ = cl;
														_tmp72_ = nv;
														_tmp72__length1 = nv_length1;
														_tmp73_ = _tmp72_[1];
														_tmp74_ = vala_gidl_parser_eval (self, _tmp73_);
														_tmp75_ = _tmp74_;
														vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp71_, "CCode", "type_id", _tmp75_, NULL);
														_g_free0 (_tmp75_);
													} else {
														gchar** _tmp76_;
														gint _tmp76__length1;
														const gchar* _tmp77_;
														_tmp76_ = nv;
														_tmp76__length1 = nv_length1;
														_tmp77_ = _tmp76_[0];
														if (g_strcmp0 (_tmp77_, "abstract") == 0) {
															gchar** _tmp78_;
															gint _tmp78__length1;
															const gchar* _tmp79_;
															gchar* _tmp80_;
															gchar* _tmp81_;
															gboolean _tmp82_;
															_tmp78_ = nv;
															_tmp78__length1 = nv_length1;
															_tmp79_ = _tmp78_[1];
															_tmp80_ = vala_gidl_parser_eval (self, _tmp79_);
															_tmp81_ = _tmp80_;
															_tmp82_ = g_strcmp0 (_tmp81_, "1") == 0;
															_g_free0 (_tmp81_);
															if (_tmp82_) {
																ValaClass* _tmp83_;
																_tmp83_ = cl;
																vala_class_set_is_abstract (_tmp83_, TRUE);
															}
														} else {
															gchar** _tmp84_;
															gint _tmp84__length1;
															const gchar* _tmp85_;
															_tmp84_ = nv;
															_tmp84__length1 = nv_length1;
															_tmp85_ = _tmp84_[0];
															if (g_strcmp0 (_tmp85_, "experimental") == 0) {
																gchar** _tmp86_;
																gint _tmp86__length1;
																const gchar* _tmp87_;
																gchar* _tmp88_;
																gchar* _tmp89_;
																gboolean _tmp90_;
																_tmp86_ = nv;
																_tmp86__length1 = nv_length1;
																_tmp87_ = _tmp86_[1];
																_tmp88_ = vala_gidl_parser_eval (self, _tmp87_);
																_tmp89_ = _tmp88_;
																_tmp90_ = g_strcmp0 (_tmp89_, "1") == 0;
																_g_free0 (_tmp89_);
																if (_tmp90_) {
																	ValaClass* _tmp91_;
																	_tmp91_ = cl;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp91_, "Version", "experimental", TRUE, NULL);
																}
															} else {
																gchar** _tmp92_;
																gint _tmp92__length1;
																const gchar* _tmp93_;
																_tmp92_ = nv;
																_tmp92__length1 = nv_length1;
																_tmp93_ = _tmp92_[0];
																if (g_strcmp0 (_tmp93_, "compact") == 0) {
																	gchar** _tmp94_;
																	gint _tmp94__length1;
																	const gchar* _tmp95_;
																	gchar* _tmp96_;
																	gchar* _tmp97_;
																	gboolean _tmp98_;
																	_tmp94_ = nv;
																	_tmp94__length1 = nv_length1;
																	_tmp95_ = _tmp94_[1];
																	_tmp96_ = vala_gidl_parser_eval (self, _tmp95_);
																	_tmp97_ = _tmp96_;
																	_tmp98_ = g_strcmp0 (_tmp97_, "1") == 0;
																	_g_free0 (_tmp97_);
																	if (_tmp98_) {
																		ValaClass* _tmp99_;
																		_tmp99_ = cl;
																		vala_class_set_is_compact (_tmp99_, TRUE);
																	}
																} else {
																	gchar** _tmp100_;
																	gint _tmp100__length1;
																	const gchar* _tmp101_;
																	_tmp100_ = nv;
																	_tmp100__length1 = nv_length1;
																	_tmp101_ = _tmp100_[0];
																	if (g_strcmp0 (_tmp101_, "ref_function") == 0) {
																		ValaClass* _tmp102_;
																		gchar** _tmp103_;
																		gint _tmp103__length1;
																		const gchar* _tmp104_;
																		gchar* _tmp105_;
																		gchar* _tmp106_;
																		_tmp102_ = cl;
																		_tmp103_ = nv;
																		_tmp103__length1 = nv_length1;
																		_tmp104_ = _tmp103_[1];
																		_tmp105_ = vala_gidl_parser_eval (self, _tmp104_);
																		_tmp106_ = _tmp105_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp102_, "CCode", "ref_function", _tmp106_, NULL);
																		_g_free0 (_tmp106_);
																	} else {
																		gchar** _tmp107_;
																		gint _tmp107__length1;
																		const gchar* _tmp108_;
																		_tmp107_ = nv;
																		_tmp107__length1 = nv_length1;
																		_tmp108_ = _tmp107_[0];
																		if (g_strcmp0 (_tmp108_, "unref_function") == 0) {
																			ValaClass* _tmp109_;
																			gchar** _tmp110_;
																			gint _tmp110__length1;
																			const gchar* _tmp111_;
																			gchar* _tmp112_;
																			gchar* _tmp113_;
																			_tmp109_ = cl;
																			_tmp110_ = nv;
																			_tmp110__length1 = nv_length1;
																			_tmp111_ = _tmp110_[1];
																			_tmp112_ = vala_gidl_parser_eval (self, _tmp111_);
																			_tmp113_ = _tmp112_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp109_, "CCode", "unref_function", _tmp113_, NULL);
																			_g_free0 (_tmp113_);
																		} else {
																			gchar** _tmp114_;
																			gint _tmp114__length1;
																			const gchar* _tmp115_;
																			_tmp114_ = nv;
																			_tmp114__length1 = nv_length1;
																			_tmp115_ = _tmp114_[0];
																			if (g_strcmp0 (_tmp115_, "copy_function") == 0) {
																				ValaClass* _tmp116_;
																				gchar** _tmp117_;
																				gint _tmp117__length1;
																				const gchar* _tmp118_;
																				gchar* _tmp119_;
																				gchar* _tmp120_;
																				_tmp116_ = cl;
																				_tmp117_ = nv;
																				_tmp117__length1 = nv_length1;
																				_tmp118_ = _tmp117_[1];
																				_tmp119_ = vala_gidl_parser_eval (self, _tmp118_);
																				_tmp120_ = _tmp119_;
																				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp116_, "CCode", "copy_function", _tmp120_, NULL);
																				_g_free0 (_tmp120_);
																			} else {
																				gchar** _tmp121_;
																				gint _tmp121__length1;
																				const gchar* _tmp122_;
																				_tmp121_ = nv;
																				_tmp121__length1 = nv_length1;
																				_tmp122_ = _tmp121_[0];
																				if (g_strcmp0 (_tmp122_, "free_function") == 0) {
																					ValaClass* _tmp123_;
																					gchar** _tmp124_;
																					gint _tmp124__length1;
																					const gchar* _tmp125_;
																					gchar* _tmp126_;
																					gchar* _tmp127_;
																					_tmp123_ = cl;
																					_tmp124_ = nv;
																					_tmp124__length1 = nv_length1;
																					_tmp125_ = _tmp124_[1];
																					_tmp126_ = vala_gidl_parser_eval (self, _tmp125_);
																					_tmp127_ = _tmp126_;
																					vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp123_, "CCode", "free_function", _tmp127_, NULL);
																					_g_free0 (_tmp127_);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp128_ = cl;
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp128_);
		_tmp129_ = self->priv->current_source_file;
		_tmp130_ = cl;
		vala_source_file_add_node (_tmp129_, (ValaCodeNode*) _tmp130_);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp131_ = base_class;
	if (_tmp131_ != NULL) {
		ValaDataType* parent = NULL;
		const gchar* _tmp132_;
		ValaDataType* _tmp133_;
		ValaClass* _tmp134_;
		ValaDataType* _tmp135_;
		_tmp132_ = base_class;
		_tmp133_ = vala_gidl_parser_parse_type_string (self, _tmp132_);
		parent = _tmp133_;
		_tmp134_ = cl;
		_tmp135_ = parent;
		vala_class_add_base_type (_tmp134_, _tmp135_);
		_vala_code_node_unref0 (parent);
	} else {
		const gchar* _tmp136_;
		_tmp136_ = node->parent;
		if (_tmp136_ != NULL) {
			ValaClass* _tmp137_;
			gboolean _tmp138_;
			gboolean _tmp139_;
			_tmp137_ = cl;
			_tmp138_ = vala_class_get_is_compact (_tmp137_);
			_tmp139_ = _tmp138_;
			if (!_tmp139_) {
				ValaDataType* parent = NULL;
				const gchar* _tmp140_;
				ValaDataType* _tmp141_;
				ValaClass* _tmp142_;
				ValaDataType* _tmp143_;
				_tmp140_ = node->parent;
				_tmp141_ = vala_gidl_parser_parse_type_string (self, _tmp140_);
				parent = _tmp141_;
				_tmp142_ = cl;
				_tmp143_ = parent;
				vala_class_add_base_type (_tmp142_, _tmp143_);
				_vala_code_node_unref0 (parent);
			}
		} else {
			ValaUnresolvedSymbol* gobject_symbol = NULL;
			ValaUnresolvedSymbol* _tmp144_;
			ValaUnresolvedSymbol* _tmp145_;
			ValaUnresolvedSymbol* _tmp146_;
			ValaUnresolvedSymbol* _tmp147_;
			ValaClass* _tmp148_;
			ValaUnresolvedSymbol* _tmp149_;
			ValaUnresolvedType* _tmp150_;
			ValaUnresolvedType* _tmp151_;
			_tmp144_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_unresolved_symbol_new (_tmp145_, "Object", NULL);
			_tmp147_ = _tmp146_;
			_vala_code_node_unref0 (_tmp145_);
			gobject_symbol = _tmp147_;
			_tmp148_ = cl;
			_tmp149_ = gobject_symbol;
			_tmp150_ = vala_unresolved_type_new_from_symbol (_tmp149_, NULL);
			_tmp151_ = _tmp150_;
			vala_class_add_base_type (_tmp148_, (ValaDataType*) _tmp151_);
			_vala_code_node_unref0 (_tmp151_);
			_vala_code_node_unref0 (gobject_symbol);
		}
	}
	_tmp152_ = node->interfaces;
	{
		GList* iface_name_collection = NULL;
		GList* iface_name_it = NULL;
		iface_name_collection = _tmp152_;
		for (iface_name_it = iface_name_collection; iface_name_it != NULL; iface_name_it = iface_name_it->next) {
			gchar* _tmp153_;
			gchar* iface_name = NULL;
			_tmp153_ = g_strdup ((const gchar*) iface_name_it->data);
			iface_name = _tmp153_;
			{
				gboolean skip_iface = FALSE;
				gchar** attributes = NULL;
				const gchar* _tmp154_;
				gint _tmp155_ = 0;
				gchar** _tmp156_;
				gint attributes_length1;
				gint _attributes_size_;
				gchar** _tmp157_;
				gint _tmp157__length1;
				gboolean _tmp170_;
				ValaDataType* iface = NULL;
				const gchar* _tmp171_;
				ValaDataType* _tmp172_;
				ValaClass* _tmp173_;
				ValaDataType* _tmp174_;
				skip_iface = FALSE;
				_tmp154_ = iface_name;
				_tmp156_ = vala_gidl_parser_get_attributes (self, _tmp154_, &_tmp155_);
				attributes = _tmp156_;
				attributes_length1 = _tmp155_;
				_attributes_size_ = attributes_length1;
				_tmp157_ = attributes;
				_tmp157__length1 = attributes_length1;
				if (_tmp157_ != NULL) {
					gchar** _tmp158_;
					gint _tmp158__length1;
					_tmp158_ = attributes;
					_tmp158__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp158_;
						attr_collection_length1 = _tmp158__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp159_;
							gchar* attr = NULL;
							_tmp159_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp159_;
							{
								gchar** nv = NULL;
								const gchar* _tmp160_;
								gchar** _tmp161_;
								gchar** _tmp162_;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp163_;
								gint _tmp163__length1;
								const gchar* _tmp164_;
								_tmp160_ = attr;
								_tmp162_ = _tmp161_ = g_strsplit (_tmp160_, "=", 2);
								nv = _tmp162_;
								nv_length1 = _vala_array_length (_tmp161_);
								_nv_size_ = nv_length1;
								_tmp163_ = nv;
								_tmp163__length1 = nv_length1;
								_tmp164_ = _tmp163_[0];
								if (g_strcmp0 (_tmp164_, "hidden") == 0) {
									gchar** _tmp165_;
									gint _tmp165__length1;
									const gchar* _tmp166_;
									gchar* _tmp167_;
									gchar* _tmp168_;
									gboolean _tmp169_;
									_tmp165_ = nv;
									_tmp165__length1 = nv_length1;
									_tmp166_ = _tmp165_[1];
									_tmp167_ = vala_gidl_parser_eval (self, _tmp166_);
									_tmp168_ = _tmp167_;
									_tmp169_ = g_strcmp0 (_tmp168_, "1") == 0;
									_g_free0 (_tmp168_);
									if (_tmp169_) {
										skip_iface = TRUE;
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp170_ = skip_iface;
				if (_tmp170_) {
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (iface_name);
					continue;
				}
				_tmp171_ = iface_name;
				_tmp172_ = vala_gidl_parser_parse_type_string (self, _tmp171_);
				iface = _tmp172_;
				_tmp173_ = cl;
				_tmp174_ = iface;
				vala_class_add_base_type (_tmp173_, _tmp174_);
				_vala_code_node_unref0 (iface);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (iface_name);
			}
		}
	}
	_tmp175_ = cl;
	_tmp176_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp175_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp176_;
	_tmp177_ = g_str_hash;
	_tmp178_ = g_str_equal;
	_tmp179_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp177_, _tmp178_);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = (ValaSet*) _tmp179_;
	_tmp180_ = g_str_hash;
	_tmp181_ = g_str_equal;
	_tmp182_ = g_direct_equal;
	_tmp183_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_POINTER, NULL, NULL, _tmp180_, _tmp181_, _tmp182_);
	current_type_func_map = _tmp183_;
	_tmp184_ = g_str_hash;
	_tmp185_ = g_str_equal;
	_tmp186_ = g_direct_equal;
	_tmp187_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp184_, _tmp185_, _tmp186_);
	current_type_vfunc_map = _tmp187_;
	_tmp188_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp188_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp189_;
				GIdlNodeTypeId _tmp190_;
				GIdlNode* _tmp195_;
				GIdlNodeTypeId _tmp196_;
				_tmp189_ = member;
				_tmp190_ = _tmp189_->type;
				if (_tmp190_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp191_;
					GIdlNode* _tmp192_;
					const gchar* _tmp193_;
					GIdlNode* _tmp194_;
					_tmp191_ = current_type_func_map;
					_tmp192_ = member;
					_tmp193_ = _tmp192_->name;
					_tmp194_ = member;
					vala_map_set ((ValaMap*) _tmp191_, _tmp193_, (GIdlNodeFunction*) _tmp194_);
				}
				_tmp195_ = member;
				_tmp196_ = _tmp195_->type;
				if (_tmp196_ == G_IDL_NODE_VFUNC) {
					ValaHashMap* _tmp197_;
					GIdlNode* _tmp198_;
					const gchar* _tmp199_;
					_tmp197_ = current_type_vfunc_map;
					_tmp198_ = member;
					_tmp199_ = _tmp198_->name;
					vala_map_set ((ValaMap*) _tmp197_, _tmp199_, "1");
				}
			}
		}
	}
	_tmp200_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp200_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp201_;
				GIdlNodeTypeId _tmp202_;
				_tmp201_ = member;
				_tmp202_ = _tmp201_->type;
				if (_tmp202_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp203_;
					GIdlNode* _tmp204_;
					const gchar* _tmp205_;
					_tmp203_ = current_type_vfunc_map;
					_tmp204_ = member;
					_tmp205_ = _tmp204_->name;
					if (!vala_map_contains ((ValaMap*) _tmp203_, _tmp205_)) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp206_;
						ValaMethod* _tmp207_;
						ValaMethod* _tmp208_;
						_tmp206_ = member;
						_tmp207_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp206_, FALSE);
						m = _tmp207_;
						_tmp208_ = m;
						if (_tmp208_ != NULL) {
							ValaClass* _tmp209_;
							ValaMethod* _tmp210_;
							_tmp209_ = cl;
							_tmp210_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp209_, _tmp210_);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					GIdlNode* _tmp211_;
					GIdlNodeTypeId _tmp212_;
					_tmp211_ = member;
					_tmp212_ = _tmp211_->type;
					if (_tmp212_ == G_IDL_NODE_VFUNC) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp213_;
						ValaHashMap* _tmp214_;
						GIdlNode* _tmp215_;
						const gchar* _tmp216_;
						gpointer _tmp217_;
						ValaMethod* _tmp218_;
						ValaMethod* _tmp219_;
						_tmp213_ = member;
						_tmp214_ = current_type_func_map;
						_tmp215_ = member;
						_tmp216_ = _tmp215_->name;
						_tmp217_ = vala_map_get ((ValaMap*) _tmp214_, _tmp216_);
						_tmp218_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) _tmp213_, (GIdlNodeFunction*) _tmp217_, FALSE);
						m = _tmp218_;
						_tmp219_ = m;
						if (_tmp219_ != NULL) {
							ValaClass* _tmp220_;
							ValaMethod* _tmp221_;
							_tmp220_ = cl;
							_tmp221_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp220_, _tmp221_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp222_;
						GIdlNodeTypeId _tmp223_;
						_tmp222_ = member;
						_tmp223_ = _tmp222_->type;
						if (_tmp223_ == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop = NULL;
							GIdlNode* _tmp224_;
							ValaProperty* _tmp225_;
							ValaProperty* _tmp226_;
							_tmp224_ = member;
							_tmp225_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) _tmp224_);
							prop = _tmp225_;
							_tmp226_ = prop;
							if (_tmp226_ != NULL) {
								ValaClass* _tmp227_;
								ValaProperty* _tmp228_;
								_tmp227_ = cl;
								_tmp228_ = prop;
								vala_symbol_add_property ((ValaSymbol*) _tmp227_, _tmp228_);
							}
							_vala_code_node_unref0 (prop);
						} else {
							GIdlNode* _tmp229_;
							GIdlNodeTypeId _tmp230_;
							_tmp229_ = member;
							_tmp230_ = _tmp229_->type;
							if (_tmp230_ == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig = NULL;
								GIdlNode* _tmp231_;
								ValaSignal* _tmp232_;
								ValaSignal* _tmp233_;
								_tmp231_ = member;
								_tmp232_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) _tmp231_);
								sig = _tmp232_;
								_tmp233_ = sig;
								if (_tmp233_ != NULL) {
									ValaClass* _tmp234_;
									ValaSignal* _tmp235_;
									_tmp234_ = cl;
									_tmp235_ = sig;
									vala_symbol_add_signal ((ValaSymbol*) _tmp234_, _tmp235_);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	_tmp236_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp236_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp237_;
				GIdlNodeTypeId _tmp238_;
				_tmp237_ = member;
				_tmp238_ = _tmp237_->type;
				if (_tmp238_ == G_IDL_NODE_FIELD) {
					ValaSet* _tmp239_;
					GIdlNode* _tmp240_;
					const gchar* _tmp241_;
					_tmp239_ = self->priv->current_type_symbol_set;
					_tmp240_ = member;
					_tmp241_ = _tmp240_->name;
					if (!vala_collection_contains ((ValaCollection*) _tmp239_, _tmp241_)) {
						ValaField* f = NULL;
						GIdlNode* _tmp242_;
						ValaField* _tmp243_;
						ValaField* _tmp244_;
						_tmp242_ = member;
						_tmp243_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp242_);
						f = _tmp243_;
						_tmp244_ = f;
						if (_tmp244_ != NULL) {
							ValaClass* _tmp245_;
							ValaField* _tmp246_;
							_tmp245_ = cl;
							_tmp246_ = f;
							vala_symbol_add_field ((ValaSymbol*) _tmp245_, _tmp246_);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaClass* _tmp247_;
		ValaList* _tmp248_;
		gint _prop_size = 0;
		ValaList* _tmp249_;
		gint _tmp250_;
		gint _tmp251_;
		gint _prop_index = 0;
		_tmp247_ = cl;
		_tmp248_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp247_);
		_prop_list = _tmp248_;
		_tmp249_ = _prop_list;
		_tmp250_ = vala_collection_get_size ((ValaCollection*) _tmp249_);
		_tmp251_ = _tmp250_;
		_prop_size = _tmp251_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp252_;
			gint _tmp253_;
			gint _tmp254_;
			ValaProperty* prop = NULL;
			ValaList* _tmp255_;
			gint _tmp256_;
			gpointer _tmp257_;
			gchar* getter = NULL;
			ValaProperty* _tmp258_;
			const gchar* _tmp259_;
			const gchar* _tmp260_;
			gchar* _tmp261_;
			gboolean _tmp262_ = FALSE;
			ValaProperty* _tmp263_;
			ValaPropertyAccessor* _tmp264_;
			ValaPropertyAccessor* _tmp265_;
			gchar* setter = NULL;
			ValaProperty* _tmp269_;
			const gchar* _tmp270_;
			const gchar* _tmp271_;
			gchar* _tmp272_;
			gboolean _tmp273_ = FALSE;
			gboolean _tmp274_ = FALSE;
			ValaProperty* _tmp275_;
			ValaPropertyAccessor* _tmp276_;
			ValaPropertyAccessor* _tmp277_;
			gboolean _tmp286_ = FALSE;
			ValaProperty* _tmp287_;
			ValaAttribute* _tmp288_;
			ValaAttribute* _tmp289_;
			gboolean _tmp290_;
			_tmp252_ = _prop_index;
			_prop_index = _tmp252_ + 1;
			_tmp253_ = _prop_index;
			_tmp254_ = _prop_size;
			if (!(_tmp253_ < _tmp254_)) {
				break;
			}
			_tmp255_ = _prop_list;
			_tmp256_ = _prop_index;
			_tmp257_ = vala_list_get (_tmp255_, _tmp256_);
			prop = (ValaProperty*) _tmp257_;
			_tmp258_ = prop;
			_tmp259_ = vala_symbol_get_name ((ValaSymbol*) _tmp258_);
			_tmp260_ = _tmp259_;
			_tmp261_ = g_strdup_printf ("get_%s", _tmp260_);
			getter = _tmp261_;
			_tmp263_ = prop;
			_tmp264_ = vala_property_get_get_accessor (_tmp263_);
			_tmp265_ = _tmp264_;
			if (_tmp265_ != NULL) {
				ValaSet* _tmp266_;
				const gchar* _tmp267_;
				_tmp266_ = self->priv->current_type_symbol_set;
				_tmp267_ = getter;
				_tmp262_ = !vala_collection_contains ((ValaCollection*) _tmp266_, _tmp267_);
			} else {
				_tmp262_ = FALSE;
			}
			if (_tmp262_) {
				ValaProperty* _tmp268_;
				_tmp268_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp268_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp269_ = prop;
			_tmp270_ = vala_symbol_get_name ((ValaSymbol*) _tmp269_);
			_tmp271_ = _tmp270_;
			_tmp272_ = g_strdup_printf ("set_%s", _tmp271_);
			setter = _tmp272_;
			_tmp275_ = prop;
			_tmp276_ = vala_property_get_set_accessor (_tmp275_);
			_tmp277_ = _tmp276_;
			if (_tmp277_ != NULL) {
				ValaProperty* _tmp278_;
				ValaPropertyAccessor* _tmp279_;
				ValaPropertyAccessor* _tmp280_;
				gboolean _tmp281_;
				gboolean _tmp282_;
				_tmp278_ = prop;
				_tmp279_ = vala_property_get_set_accessor (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp281_ = vala_property_accessor_get_writable (_tmp280_);
				_tmp282_ = _tmp281_;
				_tmp274_ = _tmp282_;
			} else {
				_tmp274_ = FALSE;
			}
			if (_tmp274_) {
				ValaSet* _tmp283_;
				const gchar* _tmp284_;
				_tmp283_ = self->priv->current_type_symbol_set;
				_tmp284_ = setter;
				_tmp273_ = !vala_collection_contains ((ValaCollection*) _tmp283_, _tmp284_);
			} else {
				_tmp273_ = FALSE;
			}
			if (_tmp273_) {
				ValaProperty* _tmp285_;
				_tmp285_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp285_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp287_ = prop;
			_tmp288_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp287_, "NoAccessorMethod");
			_tmp289_ = _tmp288_;
			_tmp290_ = _tmp289_ != NULL;
			_vala_code_node_unref0 (_tmp289_);
			if (_tmp290_) {
				ValaProperty* _tmp291_;
				ValaPropertyAccessor* _tmp292_;
				ValaPropertyAccessor* _tmp293_;
				_tmp291_ = prop;
				_tmp292_ = vala_property_get_get_accessor (_tmp291_);
				_tmp293_ = _tmp292_;
				_tmp286_ = _tmp293_ != NULL;
			} else {
				_tmp286_ = FALSE;
			}
			if (_tmp286_) {
				ValaProperty* _tmp294_;
				ValaPropertyAccessor* _tmp295_;
				ValaPropertyAccessor* _tmp296_;
				ValaDataType* _tmp297_;
				ValaDataType* _tmp298_;
				_tmp294_ = prop;
				_tmp295_ = vala_property_get_get_accessor (_tmp294_);
				_tmp296_ = _tmp295_;
				_tmp297_ = vala_property_accessor_get_value_type (_tmp296_);
				_tmp298_ = _tmp297_;
				vala_data_type_set_value_owned (_tmp298_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp299_ = cl;
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) _tmp299_);
	_tmp300_ = cl;
	_tmp301_ = vala_class_get_default_construction_method (_tmp300_);
	_tmp302_ = _tmp301_;
	if (_tmp302_ == NULL) {
		ValaCreationMethod* cm = NULL;
		ValaClass* _tmp303_;
		ValaSourceReference* _tmp304_;
		ValaSourceReference* _tmp305_;
		ValaCreationMethod* _tmp306_;
		ValaCreationMethod* _tmp307_;
		ValaCreationMethod* _tmp308_;
		ValaClass* _tmp309_;
		ValaCreationMethod* _tmp310_;
		_tmp303_ = cl;
		_tmp304_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp303_);
		_tmp305_ = _tmp304_;
		_tmp306_ = vala_creation_method_new (NULL, NULL, _tmp305_, NULL);
		cm = _tmp306_;
		_tmp307_ = cm;
		vala_method_set_has_construct_function ((ValaMethod*) _tmp307_, FALSE);
		_tmp308_ = cm;
		vala_symbol_set_access ((ValaSymbol*) _tmp308_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		_tmp309_ = cl;
		_tmp310_ = cm;
		vala_symbol_add_method ((ValaSymbol*) _tmp309_, (ValaMethod*) _tmp310_);
		_vala_code_node_unref0 (cm);
	}
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = NULL;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = NULL;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (cl);
	_g_free0 (base_class);
	_g_free0 (name);
}


static void
vala_gidl_parser_parse_interface (ValaGIdlParser* self,
                                  GIdlNodeInterface* node,
                                  ValaSymbol* container,
                                  GIdlModule* module)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ValaInterface* iface = NULL;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaInterface* _tmp6_;
	ValaInterface* _tmp7_;
	ValaInterface* _tmp58_;
	ValaTypeSymbol* _tmp59_;
	GHashFunc _tmp60_;
	GEqualFunc _tmp61_;
	ValaHashSet* _tmp62_;
	ValaHashMap* current_type_func_map = NULL;
	GHashFunc _tmp63_;
	GEqualFunc _tmp64_;
	GEqualFunc _tmp65_;
	ValaHashMap* _tmp66_;
	ValaHashMap* current_type_vfunc_map = NULL;
	GHashFunc _tmp67_;
	GEqualFunc _tmp68_;
	GEqualFunc _tmp69_;
	ValaHashMap* _tmp70_;
	GList* _tmp71_;
	GList* _tmp83_;
	ValaInterface* _tmp172_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = node->gtype_name;
	_tmp1_ = vala_gidl_parser_fix_type_name (self, _tmp0_, container);
	name = _tmp1_;
	_tmp2_ = vala_symbol_get_scope (container);
	_tmp3_ = _tmp2_;
	_tmp4_ = name;
	_tmp5_ = vala_scope_lookup (_tmp3_, _tmp4_);
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_INTERFACE) ? ((ValaInterface*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_vala_code_node_unref0 (_tmp5_);
	}
	iface = _tmp6_;
	_tmp7_ = iface;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaInterface* _tmp10_;
		ValaInterface* _tmp11_;
		gchar** attributes = NULL;
		const gchar* _tmp12_;
		gint _tmp13_ = 0;
		gchar** _tmp14_;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		GList* _tmp49_;
		ValaInterface* _tmp55_;
		ValaSourceFile* _tmp56_;
		ValaInterface* _tmp57_;
		_tmp8_ = name;
		_tmp9_ = self->priv->current_source_reference;
		_tmp10_ = vala_interface_new (_tmp8_, _tmp9_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp10_;
		_tmp11_ = iface;
		vala_symbol_set_access ((ValaSymbol*) _tmp11_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp12_ = node->gtype_name;
		_tmp14_ = vala_gidl_parser_get_attributes (self, _tmp12_, &_tmp13_);
		attributes = _tmp14_;
		attributes_length1 = _tmp13_;
		_attributes_size_ = attributes_length1;
		_tmp15_ = attributes;
		_tmp15__length1 = attributes_length1;
		if (_tmp15_ != NULL) {
			gchar** _tmp16_;
			gint _tmp16__length1;
			_tmp16_ = attributes;
			_tmp16__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp16_;
				attr_collection_length1 = _tmp16__length1;
				for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
					gchar* _tmp17_;
					gchar* attr = NULL;
					_tmp17_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp17_;
					{
						gchar** nv = NULL;
						const gchar* _tmp18_;
						gchar** _tmp19_;
						gchar** _tmp20_;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						_tmp18_ = attr;
						_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
						nv = _tmp20_;
						nv_length1 = _vala_array_length (_tmp19_);
						_nv_size_ = nv_length1;
						_tmp21_ = nv;
						_tmp21__length1 = nv_length1;
						_tmp22_ = _tmp21_[0];
						if (g_strcmp0 (_tmp22_, "cheader_filename") == 0) {
							ValaInterface* _tmp23_;
							gchar** _tmp24_;
							gint _tmp24__length1;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							_tmp23_ = iface;
							_tmp24_ = nv;
							_tmp24__length1 = nv_length1;
							_tmp25_ = _tmp24_[1];
							_tmp26_ = vala_gidl_parser_eval (self, _tmp25_);
							_tmp27_ = _tmp26_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp23_, "CCode", "cheader_filename", _tmp27_, NULL);
							_g_free0 (_tmp27_);
						} else {
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[0];
							if (g_strcmp0 (_tmp29_, "hidden") == 0) {
								gchar** _tmp30_;
								gint _tmp30__length1;
								const gchar* _tmp31_;
								gchar* _tmp32_;
								gchar* _tmp33_;
								gboolean _tmp34_;
								_tmp30_ = nv;
								_tmp30__length1 = nv_length1;
								_tmp31_ = _tmp30_[1];
								_tmp32_ = vala_gidl_parser_eval (self, _tmp31_);
								_tmp33_ = _tmp32_;
								_tmp34_ = g_strcmp0 (_tmp33_, "1") == 0;
								_g_free0 (_tmp33_);
								if (_tmp34_) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (iface);
									_g_free0 (name);
									return;
								}
							} else {
								gchar** _tmp35_;
								gint _tmp35__length1;
								const gchar* _tmp36_;
								_tmp35_ = nv;
								_tmp35__length1 = nv_length1;
								_tmp36_ = _tmp35_[0];
								if (g_strcmp0 (_tmp36_, "type_cname") == 0) {
									ValaInterface* _tmp37_;
									gchar** _tmp38_;
									gint _tmp38__length1;
									const gchar* _tmp39_;
									gchar* _tmp40_;
									gchar* _tmp41_;
									_tmp37_ = iface;
									_tmp38_ = nv;
									_tmp38__length1 = nv_length1;
									_tmp39_ = _tmp38_[1];
									_tmp40_ = vala_gidl_parser_eval (self, _tmp39_);
									_tmp41_ = _tmp40_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp37_, "CCode", "type_cname", _tmp41_, NULL);
									_g_free0 (_tmp41_);
								} else {
									gchar** _tmp42_;
									gint _tmp42__length1;
									const gchar* _tmp43_;
									_tmp42_ = nv;
									_tmp42__length1 = nv_length1;
									_tmp43_ = _tmp42_[0];
									if (g_strcmp0 (_tmp43_, "lower_case_csuffix") == 0) {
										ValaInterface* _tmp44_;
										gchar** _tmp45_;
										gint _tmp45__length1;
										const gchar* _tmp46_;
										gchar* _tmp47_;
										gchar* _tmp48_;
										_tmp44_ = iface;
										_tmp45_ = nv;
										_tmp45__length1 = nv_length1;
										_tmp46_ = _tmp45_[1];
										_tmp47_ = vala_gidl_parser_eval (self, _tmp46_);
										_tmp48_ = _tmp47_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp44_, "CCode", "lower_case_csuffix", _tmp48_, NULL);
										_g_free0 (_tmp48_);
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp49_ = node->prerequisites;
		{
			GList* prereq_name_collection = NULL;
			GList* prereq_name_it = NULL;
			prereq_name_collection = _tmp49_;
			for (prereq_name_it = prereq_name_collection; prereq_name_it != NULL; prereq_name_it = prereq_name_it->next) {
				gchar* _tmp50_;
				gchar* prereq_name = NULL;
				_tmp50_ = g_strdup ((const gchar*) prereq_name_it->data);
				prereq_name = _tmp50_;
				{
					ValaDataType* prereq = NULL;
					const gchar* _tmp51_;
					ValaDataType* _tmp52_;
					ValaInterface* _tmp53_;
					ValaDataType* _tmp54_;
					_tmp51_ = prereq_name;
					_tmp52_ = vala_gidl_parser_parse_type_string (self, _tmp51_);
					prereq = _tmp52_;
					_tmp53_ = iface;
					_tmp54_ = prereq;
					vala_interface_add_prerequisite (_tmp53_, _tmp54_);
					_vala_code_node_unref0 (prereq);
					_g_free0 (prereq_name);
				}
			}
		}
		_tmp55_ = iface;
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp55_);
		_tmp56_ = self->priv->current_source_file;
		_tmp57_ = iface;
		vala_source_file_add_node (_tmp56_, (ValaCodeNode*) _tmp57_);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp58_ = iface;
	_tmp59_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp58_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp59_;
	_tmp60_ = g_str_hash;
	_tmp61_ = g_str_equal;
	_tmp62_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp60_, _tmp61_);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = (ValaSet*) _tmp62_;
	_tmp63_ = g_str_hash;
	_tmp64_ = g_str_equal;
	_tmp65_ = g_direct_equal;
	_tmp66_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_POINTER, NULL, NULL, _tmp63_, _tmp64_, _tmp65_);
	current_type_func_map = _tmp66_;
	_tmp67_ = g_str_hash;
	_tmp68_ = g_str_equal;
	_tmp69_ = g_direct_equal;
	_tmp70_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp67_, _tmp68_, _tmp69_);
	current_type_vfunc_map = _tmp70_;
	_tmp71_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp71_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp72_;
				GIdlNodeTypeId _tmp73_;
				GIdlNode* _tmp78_;
				GIdlNodeTypeId _tmp79_;
				_tmp72_ = member;
				_tmp73_ = _tmp72_->type;
				if (_tmp73_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp74_;
					GIdlNode* _tmp75_;
					const gchar* _tmp76_;
					GIdlNode* _tmp77_;
					_tmp74_ = current_type_func_map;
					_tmp75_ = member;
					_tmp76_ = _tmp75_->name;
					_tmp77_ = member;
					vala_map_set ((ValaMap*) _tmp74_, _tmp76_, (GIdlNodeFunction*) _tmp77_);
				}
				_tmp78_ = member;
				_tmp79_ = _tmp78_->type;
				if (_tmp79_ == G_IDL_NODE_VFUNC) {
					ValaHashMap* _tmp80_;
					GIdlNode* _tmp81_;
					const gchar* _tmp82_;
					_tmp80_ = current_type_vfunc_map;
					_tmp81_ = member;
					_tmp82_ = _tmp81_->name;
					vala_map_set ((ValaMap*) _tmp80_, _tmp82_, "1");
				}
			}
		}
	}
	_tmp83_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp83_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp84_;
				GIdlNodeTypeId _tmp85_;
				_tmp84_ = member;
				_tmp85_ = _tmp84_->type;
				if (_tmp85_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp86_;
					GIdlNode* _tmp87_;
					const gchar* _tmp88_;
					_tmp86_ = current_type_vfunc_map;
					_tmp87_ = member;
					_tmp88_ = _tmp87_->name;
					if (!vala_map_contains ((ValaMap*) _tmp86_, _tmp88_)) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp89_;
						ValaMethod* _tmp90_;
						ValaMethod* _tmp91_;
						_tmp89_ = member;
						_tmp90_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp89_, TRUE);
						m = _tmp90_;
						_tmp91_ = m;
						if (_tmp91_ != NULL) {
							ValaInterface* _tmp92_;
							ValaMethod* _tmp93_;
							_tmp92_ = iface;
							_tmp93_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp92_, _tmp93_);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					GIdlNode* _tmp94_;
					GIdlNodeTypeId _tmp95_;
					_tmp94_ = member;
					_tmp95_ = _tmp94_->type;
					if (_tmp95_ == G_IDL_NODE_VFUNC) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp96_;
						ValaHashMap* _tmp97_;
						GIdlNode* _tmp98_;
						const gchar* _tmp99_;
						gpointer _tmp100_;
						ValaMethod* _tmp101_;
						ValaMethod* _tmp102_;
						_tmp96_ = member;
						_tmp97_ = current_type_func_map;
						_tmp98_ = member;
						_tmp99_ = _tmp98_->name;
						_tmp100_ = vala_map_get ((ValaMap*) _tmp97_, _tmp99_);
						_tmp101_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) _tmp96_, (GIdlNodeFunction*) _tmp100_, TRUE);
						m = _tmp101_;
						_tmp102_ = m;
						if (_tmp102_ != NULL) {
							ValaInterface* _tmp103_;
							ValaMethod* _tmp104_;
							_tmp103_ = iface;
							_tmp104_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp103_, _tmp104_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp105_;
						GIdlNodeTypeId _tmp106_;
						_tmp105_ = member;
						_tmp106_ = _tmp105_->type;
						if (_tmp106_ == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop = NULL;
							GIdlNode* _tmp107_;
							ValaProperty* _tmp108_;
							ValaProperty* _tmp109_;
							_tmp107_ = member;
							_tmp108_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) _tmp107_);
							prop = _tmp108_;
							_tmp109_ = prop;
							if (_tmp109_ != NULL) {
								ValaInterface* _tmp110_;
								ValaProperty* _tmp111_;
								_tmp110_ = iface;
								_tmp111_ = prop;
								vala_symbol_add_property ((ValaSymbol*) _tmp110_, _tmp111_);
							}
							_vala_code_node_unref0 (prop);
						} else {
							GIdlNode* _tmp112_;
							GIdlNodeTypeId _tmp113_;
							_tmp112_ = member;
							_tmp113_ = _tmp112_->type;
							if (_tmp113_ == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig = NULL;
								GIdlNode* _tmp114_;
								ValaSignal* _tmp115_;
								ValaSignal* _tmp116_;
								_tmp114_ = member;
								_tmp115_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) _tmp114_);
								sig = _tmp115_;
								_tmp116_ = sig;
								if (_tmp116_ != NULL) {
									ValaInterface* _tmp117_;
									ValaSignal* _tmp118_;
									ValaSignal* _tmp119_;
									_tmp117_ = iface;
									_tmp118_ = sig;
									vala_symbol_add_signal ((ValaSymbol*) _tmp117_, _tmp118_);
									_tmp119_ = sig;
									vala_signal_set_is_virtual (_tmp119_, FALSE);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaInterface* _tmp120_;
		ValaList* _tmp121_;
		gint _prop_size = 0;
		ValaList* _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
		gint _prop_index = 0;
		_tmp120_ = iface;
		_tmp121_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp120_);
		_prop_list = _tmp121_;
		_tmp122_ = _prop_list;
		_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
		_tmp124_ = _tmp123_;
		_prop_size = _tmp124_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp125_;
			gint _tmp126_;
			gint _tmp127_;
			ValaProperty* prop = NULL;
			ValaList* _tmp128_;
			gint _tmp129_;
			gpointer _tmp130_;
			gchar* getter = NULL;
			ValaProperty* _tmp131_;
			const gchar* _tmp132_;
			const gchar* _tmp133_;
			gchar* _tmp134_;
			gboolean _tmp135_ = FALSE;
			ValaProperty* _tmp136_;
			ValaPropertyAccessor* _tmp137_;
			ValaPropertyAccessor* _tmp138_;
			gchar* setter = NULL;
			ValaProperty* _tmp142_;
			const gchar* _tmp143_;
			const gchar* _tmp144_;
			gchar* _tmp145_;
			gboolean _tmp146_ = FALSE;
			gboolean _tmp147_ = FALSE;
			ValaProperty* _tmp148_;
			ValaPropertyAccessor* _tmp149_;
			ValaPropertyAccessor* _tmp150_;
			gboolean _tmp159_ = FALSE;
			ValaProperty* _tmp160_;
			ValaAttribute* _tmp161_;
			ValaAttribute* _tmp162_;
			gboolean _tmp163_;
			_tmp125_ = _prop_index;
			_prop_index = _tmp125_ + 1;
			_tmp126_ = _prop_index;
			_tmp127_ = _prop_size;
			if (!(_tmp126_ < _tmp127_)) {
				break;
			}
			_tmp128_ = _prop_list;
			_tmp129_ = _prop_index;
			_tmp130_ = vala_list_get (_tmp128_, _tmp129_);
			prop = (ValaProperty*) _tmp130_;
			_tmp131_ = prop;
			_tmp132_ = vala_symbol_get_name ((ValaSymbol*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp134_ = g_strdup_printf ("get_%s", _tmp133_);
			getter = _tmp134_;
			_tmp136_ = prop;
			_tmp137_ = vala_property_get_get_accessor (_tmp136_);
			_tmp138_ = _tmp137_;
			if (_tmp138_ != NULL) {
				ValaSet* _tmp139_;
				const gchar* _tmp140_;
				_tmp139_ = self->priv->current_type_symbol_set;
				_tmp140_ = getter;
				_tmp135_ = !vala_collection_contains ((ValaCollection*) _tmp139_, _tmp140_);
			} else {
				_tmp135_ = FALSE;
			}
			if (_tmp135_) {
				ValaProperty* _tmp141_;
				_tmp141_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp141_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp142_ = prop;
			_tmp143_ = vala_symbol_get_name ((ValaSymbol*) _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = g_strdup_printf ("set_%s", _tmp144_);
			setter = _tmp145_;
			_tmp148_ = prop;
			_tmp149_ = vala_property_get_set_accessor (_tmp148_);
			_tmp150_ = _tmp149_;
			if (_tmp150_ != NULL) {
				ValaProperty* _tmp151_;
				ValaPropertyAccessor* _tmp152_;
				ValaPropertyAccessor* _tmp153_;
				gboolean _tmp154_;
				gboolean _tmp155_;
				_tmp151_ = prop;
				_tmp152_ = vala_property_get_set_accessor (_tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = vala_property_accessor_get_writable (_tmp153_);
				_tmp155_ = _tmp154_;
				_tmp147_ = _tmp155_;
			} else {
				_tmp147_ = FALSE;
			}
			if (_tmp147_) {
				ValaSet* _tmp156_;
				const gchar* _tmp157_;
				_tmp156_ = self->priv->current_type_symbol_set;
				_tmp157_ = setter;
				_tmp146_ = !vala_collection_contains ((ValaCollection*) _tmp156_, _tmp157_);
			} else {
				_tmp146_ = FALSE;
			}
			if (_tmp146_) {
				ValaProperty* _tmp158_;
				_tmp158_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp158_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp160_ = prop;
			_tmp161_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp160_, "NoAccessorMethod");
			_tmp162_ = _tmp161_;
			_tmp163_ = _tmp162_ != NULL;
			_vala_code_node_unref0 (_tmp162_);
			if (_tmp163_) {
				ValaProperty* _tmp164_;
				ValaPropertyAccessor* _tmp165_;
				ValaPropertyAccessor* _tmp166_;
				_tmp164_ = prop;
				_tmp165_ = vala_property_get_get_accessor (_tmp164_);
				_tmp166_ = _tmp165_;
				_tmp159_ = _tmp166_ != NULL;
			} else {
				_tmp159_ = FALSE;
			}
			if (_tmp159_) {
				ValaProperty* _tmp167_;
				ValaPropertyAccessor* _tmp168_;
				ValaPropertyAccessor* _tmp169_;
				ValaDataType* _tmp170_;
				ValaDataType* _tmp171_;
				_tmp167_ = prop;
				_tmp168_ = vala_property_get_get_accessor (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_property_accessor_get_value_type (_tmp169_);
				_tmp171_ = _tmp170_;
				vala_data_type_set_value_owned (_tmp171_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp172_ = iface;
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) _tmp172_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = NULL;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (iface);
	_g_free0 (name);
}


static void
vala_gidl_parser_handle_async_methods (ValaGIdlParser* self,
                                       ValaObjectTypeSymbol* type_symbol)
{
	ValaSet* finish_methods = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaList* methods = NULL;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_symbol != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_hash_set_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_, _tmp1_);
	finish_methods = (ValaSet*) _tmp2_;
	_tmp3_ = vala_object_type_symbol_get_methods (type_symbol);
	methods = _tmp3_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _m_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _m_index = 0;
		_tmp4_ = methods;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_m_list = _tmp5_;
		_tmp6_ = _m_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_m_size = _tmp8_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaMethod* m = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaMethod* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			_tmp9_ = _m_index;
			_m_index = _tmp9_ + 1;
			_tmp10_ = _m_index;
			_tmp11_ = _m_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _m_list;
			_tmp13_ = _m_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			m = (ValaMethod*) _tmp14_;
			_tmp15_ = m;
			_tmp16_ = vala_method_get_coroutine (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_) {
				gchar* finish_method_base = NULL;
				ValaMethod* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				ValaMethod* finish_method = NULL;
				ValaScope* _tmp36_;
				ValaScope* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				ValaSymbol* _tmp41_;
				ValaMethod* _tmp42_;
				ValaMethod* _tmp43_;
				ValaMethod* _tmp44_;
				ValaMethod* _tmp64_;
				_tmp18_ = m;
				_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
				_tmp20_ = _tmp19_;
				if (g_str_has_suffix (_tmp20_, "_async")) {
					ValaMethod* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					ValaMethod* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gchar* _tmp31_;
					_tmp21_ = m;
					_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = m;
					_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = strlen (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = strlen ("_async");
					_tmp30_ = _tmp29_;
					_tmp31_ = string_substring (_tmp23_, (glong) 0, (glong) (_tmp28_ - _tmp30_));
					_g_free0 (finish_method_base);
					finish_method_base = _tmp31_;
				} else {
					ValaMethod* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					_tmp32_ = m;
					_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = g_strdup (_tmp34_);
					_g_free0 (finish_method_base);
					finish_method_base = _tmp35_;
				}
				_tmp36_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
				_tmp37_ = _tmp36_;
				_tmp38_ = finish_method_base;
				_tmp39_ = g_strconcat (_tmp38_, "_finish", NULL);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_scope_lookup (_tmp37_, _tmp40_);
				_tmp42_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp41_) : NULL;
				if (_tmp42_ == NULL) {
					_vala_code_node_unref0 (_tmp41_);
				}
				_tmp43_ = _tmp42_;
				_g_free0 (_tmp40_);
				finish_method = _tmp43_;
				_tmp44_ = finish_method;
				if (_tmp44_ == NULL) {
					gchar* method_cname = NULL;
					ValaMethod* _tmp45_;
					gchar* _tmp46_;
					_tmp45_ = m;
					_tmp46_ = vala_gidl_parser_get_finish_cname (self, _tmp45_);
					method_cname = _tmp46_;
					{
						ValaList* _method_list = NULL;
						ValaList* _tmp47_;
						gint _method_size = 0;
						ValaList* _tmp48_;
						gint _tmp49_;
						gint _tmp50_;
						gint _method_index = 0;
						_tmp47_ = vala_object_type_symbol_get_methods (type_symbol);
						_method_list = _tmp47_;
						_tmp48_ = _method_list;
						_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
						_tmp50_ = _tmp49_;
						_method_size = _tmp50_;
						_method_index = -1;
						while (TRUE) {
							gint _tmp51_;
							gint _tmp52_;
							gint _tmp53_;
							ValaMethod* method = NULL;
							ValaList* _tmp54_;
							gint _tmp55_;
							gpointer _tmp56_;
							ValaMethod* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp59_;
							const gchar* _tmp60_;
							gboolean _tmp61_;
							_tmp51_ = _method_index;
							_method_index = _tmp51_ + 1;
							_tmp52_ = _method_index;
							_tmp53_ = _method_size;
							if (!(_tmp52_ < _tmp53_)) {
								break;
							}
							_tmp54_ = _method_list;
							_tmp55_ = _method_index;
							_tmp56_ = vala_list_get (_tmp54_, _tmp55_);
							method = (ValaMethod*) _tmp56_;
							_tmp57_ = method;
							_tmp58_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp57_, NULL);
							_tmp59_ = _tmp58_;
							_tmp60_ = method_cname;
							_tmp61_ = g_strcmp0 (_tmp59_, _tmp60_) == 0;
							_g_free0 (_tmp59_);
							if (_tmp61_) {
								ValaMethod* _tmp62_;
								ValaMethod* _tmp63_;
								_tmp62_ = method;
								_tmp63_ = _vala_code_node_ref0 (_tmp62_);
								_vala_code_node_unref0 (finish_method);
								finish_method = _tmp63_;
								_vala_code_node_unref0 (method);
								break;
							}
							_vala_code_node_unref0 (method);
						}
						_vala_iterable_unref0 (_method_list);
					}
					_g_free0 (method_cname);
				}
				_tmp64_ = finish_method;
				if (_tmp64_ != NULL) {
					ValaMethod* _tmp65_;
					ValaMethod* _tmp66_;
					ValaDataType* _tmp67_;
					ValaDataType* _tmp68_;
					ValaDataType* _tmp69_;
					ValaDataType* _tmp70_;
					ValaAttribute* a = NULL;
					ValaMethod* _tmp71_;
					ValaAttribute* _tmp72_;
					gboolean _tmp73_ = FALSE;
					ValaAttribute* _tmp74_;
					gboolean _tmp78_ = FALSE;
					ValaAttribute* _tmp79_;
					ValaSet* _tmp131_;
					ValaMethod* _tmp132_;
					_tmp65_ = m;
					_tmp66_ = finish_method;
					_tmp67_ = vala_callable_get_return_type ((ValaCallable*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = vala_data_type_copy (_tmp68_);
					_tmp70_ = _tmp69_;
					vala_callable_set_return_type ((ValaCallable*) _tmp65_, _tmp70_);
					_vala_code_node_unref0 (_tmp70_);
					_tmp71_ = finish_method;
					_tmp72_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp71_, "CCode");
					a = _tmp72_;
					_tmp74_ = a;
					if (_tmp74_ != NULL) {
						ValaAttribute* _tmp75_;
						_tmp75_ = a;
						_tmp73_ = vala_attribute_has_argument (_tmp75_, "array_length");
					} else {
						_tmp73_ = FALSE;
					}
					if (_tmp73_) {
						ValaMethod* _tmp76_;
						ValaAttribute* _tmp77_;
						_tmp76_ = m;
						_tmp77_ = a;
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp76_, "CCode", "array_length", vala_attribute_get_bool (_tmp77_, "array_length", FALSE), NULL);
					}
					_tmp79_ = a;
					if (_tmp79_ != NULL) {
						ValaAttribute* _tmp80_;
						_tmp80_ = a;
						_tmp78_ = vala_attribute_has_argument (_tmp80_, "array_null_terminated");
					} else {
						_tmp78_ = FALSE;
					}
					if (_tmp78_) {
						ValaMethod* _tmp81_;
						ValaAttribute* _tmp82_;
						_tmp81_ = m;
						_tmp82_ = a;
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp81_, "CCode", "array_null_terminated", vala_attribute_get_bool (_tmp82_, "array_null_terminated", FALSE), NULL);
					}
					{
						ValaList* _param_list = NULL;
						ValaMethod* _tmp83_;
						ValaList* _tmp84_;
						gint _param_size = 0;
						ValaList* _tmp85_;
						gint _tmp86_;
						gint _tmp87_;
						gint _param_index = 0;
						_tmp83_ = finish_method;
						_tmp84_ = vala_callable_get_parameters ((ValaCallable*) _tmp83_);
						_param_list = _tmp84_;
						_tmp85_ = _param_list;
						_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
						_tmp87_ = _tmp86_;
						_param_size = _tmp87_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp88_;
							gint _tmp89_;
							gint _tmp90_;
							ValaParameter* param = NULL;
							ValaList* _tmp91_;
							gint _tmp92_;
							gpointer _tmp93_;
							ValaParameter* _tmp94_;
							ValaParameterDirection _tmp95_;
							ValaParameterDirection _tmp96_;
							_tmp88_ = _param_index;
							_param_index = _tmp88_ + 1;
							_tmp89_ = _param_index;
							_tmp90_ = _param_size;
							if (!(_tmp89_ < _tmp90_)) {
								break;
							}
							_tmp91_ = _param_list;
							_tmp92_ = _param_index;
							_tmp93_ = vala_list_get (_tmp91_, _tmp92_);
							param = (ValaParameter*) _tmp93_;
							_tmp94_ = param;
							_tmp95_ = vala_parameter_get_direction (_tmp94_);
							_tmp96_ = _tmp95_;
							if (_tmp96_ == VALA_PARAMETER_DIRECTION_OUT) {
								ValaParameter* async_param = NULL;
								ValaParameter* _tmp97_;
								ValaParameter* _tmp98_;
								ValaMethod* _tmp99_;
								ValaScope* _tmp100_;
								ValaScope* _tmp101_;
								ValaParameter* _tmp102_;
								const gchar* _tmp103_;
								const gchar* _tmp104_;
								ValaSymbol* _tmp105_;
								ValaSymbol* _tmp106_;
								gboolean _tmp107_;
								ValaMethod* _tmp114_;
								ValaParameter* _tmp115_;
								_tmp97_ = param;
								_tmp98_ = vala_parameter_copy (_tmp97_);
								async_param = _tmp98_;
								_tmp99_ = m;
								_tmp100_ = vala_symbol_get_scope ((ValaSymbol*) _tmp99_);
								_tmp101_ = _tmp100_;
								_tmp102_ = param;
								_tmp103_ = vala_symbol_get_name ((ValaSymbol*) _tmp102_);
								_tmp104_ = _tmp103_;
								_tmp105_ = vala_scope_lookup (_tmp101_, _tmp104_);
								_tmp106_ = _tmp105_;
								_tmp107_ = _tmp106_ != NULL;
								_vala_code_node_unref0 (_tmp106_);
								if (_tmp107_) {
									ValaParameter* _tmp108_;
									ValaParameter* _tmp109_;
									const gchar* _tmp110_;
									const gchar* _tmp111_;
									gchar* _tmp112_;
									gchar* _tmp113_;
									_tmp108_ = async_param;
									_tmp109_ = async_param;
									_tmp110_ = vala_symbol_get_name ((ValaSymbol*) _tmp109_);
									_tmp111_ = _tmp110_;
									_tmp112_ = g_strconcat (_tmp111_, "_out", NULL);
									_tmp113_ = _tmp112_;
									vala_symbol_set_name ((ValaSymbol*) _tmp109_, _tmp113_);
									_g_free0 (_tmp113_);
								}
								_tmp114_ = m;
								_tmp115_ = async_param;
								vala_callable_add_parameter ((ValaCallable*) _tmp114_, _tmp115_);
								_vala_code_node_unref0 (async_param);
							}
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					{
						ValaList* _error_type_list = NULL;
						ValaMethod* _tmp116_;
						ValaList* _tmp117_;
						gint _error_type_size = 0;
						ValaList* _tmp118_;
						gint _tmp119_;
						gint _tmp120_;
						gint _error_type_index = 0;
						_tmp116_ = finish_method;
						_tmp117_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp116_);
						_error_type_list = _tmp117_;
						_tmp118_ = _error_type_list;
						_tmp119_ = vala_collection_get_size ((ValaCollection*) _tmp118_);
						_tmp120_ = _tmp119_;
						_error_type_size = _tmp120_;
						_error_type_index = -1;
						while (TRUE) {
							gint _tmp121_;
							gint _tmp122_;
							gint _tmp123_;
							ValaDataType* error_type = NULL;
							ValaList* _tmp124_;
							gint _tmp125_;
							gpointer _tmp126_;
							ValaMethod* _tmp127_;
							ValaDataType* _tmp128_;
							ValaDataType* _tmp129_;
							ValaDataType* _tmp130_;
							_tmp121_ = _error_type_index;
							_error_type_index = _tmp121_ + 1;
							_tmp122_ = _error_type_index;
							_tmp123_ = _error_type_size;
							if (!(_tmp122_ < _tmp123_)) {
								break;
							}
							_tmp124_ = _error_type_list;
							_tmp125_ = _error_type_index;
							_tmp126_ = vala_list_get (_tmp124_, _tmp125_);
							error_type = (ValaDataType*) _tmp126_;
							_tmp127_ = m;
							_tmp128_ = error_type;
							_tmp129_ = vala_data_type_copy (_tmp128_);
							_tmp130_ = _tmp129_;
							vala_code_node_add_error_type ((ValaCodeNode*) _tmp127_, _tmp130_);
							_vala_code_node_unref0 (_tmp130_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					_tmp131_ = finish_methods;
					_tmp132_ = finish_method;
					vala_collection_add ((ValaCollection*) _tmp131_, _tmp132_);
					_vala_code_node_unref0 (a);
				}
				_vala_code_node_unref0 (finish_method);
				_g_free0 (finish_method_base);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaIterator* _m_it = NULL;
		ValaSet* _tmp133_;
		ValaIterator* _tmp134_;
		_tmp133_ = finish_methods;
		_tmp134_ = vala_iterable_iterator ((ValaIterable*) _tmp133_);
		_m_it = _tmp134_;
		while (TRUE) {
			ValaIterator* _tmp135_;
			ValaMethod* m = NULL;
			ValaIterator* _tmp136_;
			gpointer _tmp137_;
			ValaScope* _tmp138_;
			ValaScope* _tmp139_;
			ValaMethod* _tmp140_;
			const gchar* _tmp141_;
			const gchar* _tmp142_;
			ValaList* _tmp143_;
			ValaMethod* _tmp144_;
			_tmp135_ = _m_it;
			if (!vala_iterator_next (_tmp135_)) {
				break;
			}
			_tmp136_ = _m_it;
			_tmp137_ = vala_iterator_get (_tmp136_);
			m = (ValaMethod*) _tmp137_;
			_tmp138_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
			_tmp139_ = _tmp138_;
			_tmp140_ = m;
			_tmp141_ = vala_symbol_get_name ((ValaSymbol*) _tmp140_);
			_tmp142_ = _tmp141_;
			vala_scope_remove (_tmp139_, _tmp142_);
			_tmp143_ = methods;
			_tmp144_ = m;
			vala_collection_remove ((ValaCollection*) _tmp143_, _tmp144_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterator_unref0 (_m_it);
	}
	_vala_iterable_unref0 (methods);
	_vala_iterable_unref0 (finish_methods);
}


static ValaDataType*
vala_gidl_parser_parse_type (ValaGIdlParser* self,
                             GIdlNodeType* type_node,
                             ValaParameterDirection* direction)
{
	ValaParameterDirection _vala_direction = 0;
	ValaDataType* result = NULL;
	ValaUnresolvedType* type = NULL;
	ValaUnresolvedType* _tmp0_;
	TypeTag _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_node != NULL, NULL);
	_vala_direction = VALA_PARAMETER_DIRECTION_IN;
	_tmp0_ = vala_unresolved_type_new ();
	type = _tmp0_;
	_tmp1_ = type_node->tag;
	if (_tmp1_ == TYPE_TAG_VOID) {
		gboolean _tmp2_;
		_tmp2_ = type_node->is_pointer;
		if (_tmp2_) {
			ValaVoidType* _tmp3_;
			ValaVoidType* _tmp4_;
			ValaPointerType* _tmp5_;
			ValaDataType* _tmp6_;
			_tmp3_ = vala_void_type_new (NULL);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_pointer_type_new ((ValaDataType*) _tmp4_, NULL);
			_tmp6_ = (ValaDataType*) _tmp5_;
			_vala_code_node_unref0 (_tmp4_);
			result = _tmp6_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _vala_direction;
			}
			return result;
		} else {
			ValaVoidType* _tmp7_;
			_tmp7_ = vala_void_type_new (NULL);
			result = (ValaDataType*) _tmp7_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _vala_direction;
			}
			return result;
		}
	} else {
		TypeTag _tmp8_;
		_tmp8_ = type_node->tag;
		if (_tmp8_ == TYPE_TAG_BOOLEAN) {
			ValaUnresolvedType* _tmp9_;
			ValaUnresolvedSymbol* _tmp10_;
			ValaUnresolvedSymbol* _tmp11_;
			_tmp9_ = type;
			_tmp10_ = vala_unresolved_symbol_new (NULL, "bool", NULL);
			_tmp11_ = _tmp10_;
			vala_unresolved_type_set_unresolved_symbol (_tmp9_, _tmp11_);
			_vala_code_node_unref0 (_tmp11_);
		} else {
			TypeTag _tmp12_;
			_tmp12_ = type_node->tag;
			if (_tmp12_ == TYPE_TAG_INT8) {
				ValaUnresolvedType* _tmp13_;
				ValaUnresolvedSymbol* _tmp14_;
				ValaUnresolvedSymbol* _tmp15_;
				_tmp13_ = type;
				_tmp14_ = vala_unresolved_symbol_new (NULL, "char", NULL);
				_tmp15_ = _tmp14_;
				vala_unresolved_type_set_unresolved_symbol (_tmp13_, _tmp15_);
				_vala_code_node_unref0 (_tmp15_);
			} else {
				TypeTag _tmp16_;
				_tmp16_ = type_node->tag;
				if (_tmp16_ == TYPE_TAG_UINT8) {
					ValaUnresolvedType* _tmp17_;
					ValaUnresolvedSymbol* _tmp18_;
					ValaUnresolvedSymbol* _tmp19_;
					_tmp17_ = type;
					_tmp18_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
					_tmp19_ = _tmp18_;
					vala_unresolved_type_set_unresolved_symbol (_tmp17_, _tmp19_);
					_vala_code_node_unref0 (_tmp19_);
				} else {
					TypeTag _tmp20_;
					_tmp20_ = type_node->tag;
					if (_tmp20_ == TYPE_TAG_INT16) {
						ValaUnresolvedType* _tmp21_;
						ValaUnresolvedSymbol* _tmp22_;
						ValaUnresolvedSymbol* _tmp23_;
						_tmp21_ = type;
						_tmp22_ = vala_unresolved_symbol_new (NULL, "int16", NULL);
						_tmp23_ = _tmp22_;
						vala_unresolved_type_set_unresolved_symbol (_tmp21_, _tmp23_);
						_vala_code_node_unref0 (_tmp23_);
					} else {
						TypeTag _tmp24_;
						_tmp24_ = type_node->tag;
						if (_tmp24_ == TYPE_TAG_UINT16) {
							ValaUnresolvedType* _tmp25_;
							ValaUnresolvedSymbol* _tmp26_;
							ValaUnresolvedSymbol* _tmp27_;
							_tmp25_ = type;
							_tmp26_ = vala_unresolved_symbol_new (NULL, "uint16", NULL);
							_tmp27_ = _tmp26_;
							vala_unresolved_type_set_unresolved_symbol (_tmp25_, _tmp27_);
							_vala_code_node_unref0 (_tmp27_);
						} else {
							TypeTag _tmp28_;
							_tmp28_ = type_node->tag;
							if (_tmp28_ == TYPE_TAG_INT32) {
								ValaUnresolvedType* _tmp29_;
								ValaUnresolvedSymbol* _tmp30_;
								ValaUnresolvedSymbol* _tmp31_;
								_tmp29_ = type;
								_tmp30_ = vala_unresolved_symbol_new (NULL, "int32", NULL);
								_tmp31_ = _tmp30_;
								vala_unresolved_type_set_unresolved_symbol (_tmp29_, _tmp31_);
								_vala_code_node_unref0 (_tmp31_);
							} else {
								TypeTag _tmp32_;
								_tmp32_ = type_node->tag;
								if (_tmp32_ == TYPE_TAG_UINT32) {
									ValaUnresolvedType* _tmp33_;
									ValaUnresolvedSymbol* _tmp34_;
									ValaUnresolvedSymbol* _tmp35_;
									_tmp33_ = type;
									_tmp34_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
									_tmp35_ = _tmp34_;
									vala_unresolved_type_set_unresolved_symbol (_tmp33_, _tmp35_);
									_vala_code_node_unref0 (_tmp35_);
								} else {
									TypeTag _tmp36_;
									_tmp36_ = type_node->tag;
									if (_tmp36_ == TYPE_TAG_INT64) {
										ValaUnresolvedType* _tmp37_;
										ValaUnresolvedSymbol* _tmp38_;
										ValaUnresolvedSymbol* _tmp39_;
										_tmp37_ = type;
										_tmp38_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
										_tmp39_ = _tmp38_;
										vala_unresolved_type_set_unresolved_symbol (_tmp37_, _tmp39_);
										_vala_code_node_unref0 (_tmp39_);
									} else {
										TypeTag _tmp40_;
										_tmp40_ = type_node->tag;
										if (_tmp40_ == TYPE_TAG_UINT64) {
											ValaUnresolvedType* _tmp41_;
											ValaUnresolvedSymbol* _tmp42_;
											ValaUnresolvedSymbol* _tmp43_;
											_tmp41_ = type;
											_tmp42_ = vala_unresolved_symbol_new (NULL, "uint64", NULL);
											_tmp43_ = _tmp42_;
											vala_unresolved_type_set_unresolved_symbol (_tmp41_, _tmp43_);
											_vala_code_node_unref0 (_tmp43_);
										} else {
											TypeTag _tmp44_;
											_tmp44_ = type_node->tag;
											if (_tmp44_ == TYPE_TAG_INT) {
												ValaUnresolvedType* _tmp45_;
												ValaUnresolvedSymbol* _tmp46_;
												ValaUnresolvedSymbol* _tmp47_;
												_tmp45_ = type;
												_tmp46_ = vala_unresolved_symbol_new (NULL, "int", NULL);
												_tmp47_ = _tmp46_;
												vala_unresolved_type_set_unresolved_symbol (_tmp45_, _tmp47_);
												_vala_code_node_unref0 (_tmp47_);
											} else {
												TypeTag _tmp48_;
												_tmp48_ = type_node->tag;
												if (_tmp48_ == TYPE_TAG_UINT) {
													ValaUnresolvedType* _tmp49_;
													ValaUnresolvedSymbol* _tmp50_;
													ValaUnresolvedSymbol* _tmp51_;
													_tmp49_ = type;
													_tmp50_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
													_tmp51_ = _tmp50_;
													vala_unresolved_type_set_unresolved_symbol (_tmp49_, _tmp51_);
													_vala_code_node_unref0 (_tmp51_);
												} else {
													TypeTag _tmp52_;
													_tmp52_ = type_node->tag;
													if (_tmp52_ == TYPE_TAG_LONG) {
														ValaUnresolvedType* _tmp53_;
														ValaUnresolvedSymbol* _tmp54_;
														ValaUnresolvedSymbol* _tmp55_;
														_tmp53_ = type;
														_tmp54_ = vala_unresolved_symbol_new (NULL, "long", NULL);
														_tmp55_ = _tmp54_;
														vala_unresolved_type_set_unresolved_symbol (_tmp53_, _tmp55_);
														_vala_code_node_unref0 (_tmp55_);
													} else {
														TypeTag _tmp56_;
														_tmp56_ = type_node->tag;
														if (_tmp56_ == TYPE_TAG_ULONG) {
															ValaUnresolvedType* _tmp57_;
															ValaUnresolvedSymbol* _tmp58_;
															ValaUnresolvedSymbol* _tmp59_;
															_tmp57_ = type;
															_tmp58_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
															_tmp59_ = _tmp58_;
															vala_unresolved_type_set_unresolved_symbol (_tmp57_, _tmp59_);
															_vala_code_node_unref0 (_tmp59_);
														} else {
															TypeTag _tmp60_;
															_tmp60_ = type_node->tag;
															if (_tmp60_ == TYPE_TAG_SSIZE) {
																ValaUnresolvedType* _tmp61_;
																ValaUnresolvedSymbol* _tmp62_;
																ValaUnresolvedSymbol* _tmp63_;
																_tmp61_ = type;
																_tmp62_ = vala_unresolved_symbol_new (NULL, "ssize_t", NULL);
																_tmp63_ = _tmp62_;
																vala_unresolved_type_set_unresolved_symbol (_tmp61_, _tmp63_);
																_vala_code_node_unref0 (_tmp63_);
															} else {
																TypeTag _tmp64_;
																_tmp64_ = type_node->tag;
																if (_tmp64_ == TYPE_TAG_SIZE) {
																	ValaUnresolvedType* _tmp65_;
																	ValaUnresolvedSymbol* _tmp66_;
																	ValaUnresolvedSymbol* _tmp67_;
																	_tmp65_ = type;
																	_tmp66_ = vala_unresolved_symbol_new (NULL, "size_t", NULL);
																	_tmp67_ = _tmp66_;
																	vala_unresolved_type_set_unresolved_symbol (_tmp65_, _tmp67_);
																	_vala_code_node_unref0 (_tmp67_);
																} else {
																	TypeTag _tmp68_;
																	_tmp68_ = type_node->tag;
																	if (_tmp68_ == TYPE_TAG_FLOAT) {
																		ValaUnresolvedType* _tmp69_;
																		ValaUnresolvedSymbol* _tmp70_;
																		ValaUnresolvedSymbol* _tmp71_;
																		_tmp69_ = type;
																		_tmp70_ = vala_unresolved_symbol_new (NULL, "float", NULL);
																		_tmp71_ = _tmp70_;
																		vala_unresolved_type_set_unresolved_symbol (_tmp69_, _tmp71_);
																		_vala_code_node_unref0 (_tmp71_);
																	} else {
																		TypeTag _tmp72_;
																		_tmp72_ = type_node->tag;
																		if (_tmp72_ == TYPE_TAG_DOUBLE) {
																			ValaUnresolvedType* _tmp73_;
																			ValaUnresolvedSymbol* _tmp74_;
																			ValaUnresolvedSymbol* _tmp75_;
																			_tmp73_ = type;
																			_tmp74_ = vala_unresolved_symbol_new (NULL, "double", NULL);
																			_tmp75_ = _tmp74_;
																			vala_unresolved_type_set_unresolved_symbol (_tmp73_, _tmp75_);
																			_vala_code_node_unref0 (_tmp75_);
																		} else {
																			TypeTag _tmp76_;
																			_tmp76_ = type_node->tag;
																			if (_tmp76_ == TYPE_TAG_UTF8) {
																				ValaUnresolvedType* _tmp77_;
																				ValaUnresolvedSymbol* _tmp78_;
																				ValaUnresolvedSymbol* _tmp79_;
																				_tmp77_ = type;
																				_tmp78_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																				_tmp79_ = _tmp78_;
																				vala_unresolved_type_set_unresolved_symbol (_tmp77_, _tmp79_);
																				_vala_code_node_unref0 (_tmp79_);
																			} else {
																				TypeTag _tmp80_;
																				_tmp80_ = type_node->tag;
																				if (_tmp80_ == TYPE_TAG_FILENAME) {
																					ValaUnresolvedType* _tmp81_;
																					ValaUnresolvedSymbol* _tmp82_;
																					ValaUnresolvedSymbol* _tmp83_;
																					_tmp81_ = type;
																					_tmp82_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																					_tmp83_ = _tmp82_;
																					vala_unresolved_type_set_unresolved_symbol (_tmp81_, _tmp83_);
																					_vala_code_node_unref0 (_tmp83_);
																				} else {
																					TypeTag _tmp84_;
																					_tmp84_ = type_node->tag;
																					if (_tmp84_ == TYPE_TAG_ARRAY) {
																						ValaDataType* element_type = NULL;
																						GIdlNodeType* _tmp85_;
																						ValaDataType* _tmp86_;
																						ValaDataType* _tmp87_;
																						ValaUnresolvedType* _tmp88_;
																						ValaUnresolvedType* _tmp89_;
																						ValaDataType* _tmp90_;
																						ValaDataType* _tmp91_;
																						ValaDataType* _tmp92_;
																						ValaSourceReference* _tmp93_;
																						ValaSourceReference* _tmp94_;
																						ValaArrayType* _tmp95_;
																						_tmp85_ = type_node->parameter_type1;
																						_tmp86_ = vala_gidl_parser_parse_type (self, _tmp85_, NULL);
																						element_type = _tmp86_;
																						_tmp87_ = element_type;
																						_tmp88_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp87_) : NULL);
																						_vala_code_node_unref0 (type);
																						type = _tmp88_;
																						_tmp89_ = type;
																						if (_tmp89_ == NULL) {
																							result = element_type;
																							_vala_code_node_unref0 (type);
																							if (direction) {
																								*direction = _vala_direction;
																							}
																							return result;
																						}
																						_tmp90_ = element_type;
																						vala_data_type_set_value_owned (_tmp90_, TRUE);
																						_tmp91_ = element_type;
																						_tmp92_ = element_type;
																						_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp92_);
																						_tmp94_ = _tmp93_;
																						_tmp95_ = vala_array_type_new (_tmp91_, 1, _tmp94_);
																						result = (ValaDataType*) _tmp95_;
																						_vala_code_node_unref0 (element_type);
																						_vala_code_node_unref0 (type);
																						if (direction) {
																							*direction = _vala_direction;
																						}
																						return result;
																					} else {
																						TypeTag _tmp96_;
																						_tmp96_ = type_node->tag;
																						if (_tmp96_ == TYPE_TAG_LIST) {
																							ValaUnresolvedType* _tmp97_;
																							ValaUnresolvedSymbol* _tmp98_;
																							ValaUnresolvedSymbol* _tmp99_;
																							ValaUnresolvedSymbol* _tmp100_;
																							ValaUnresolvedSymbol* _tmp101_;
																							_tmp97_ = type;
																							_tmp98_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																							_tmp99_ = _tmp98_;
																							_tmp100_ = vala_unresolved_symbol_new (_tmp99_, "List", NULL);
																							_tmp101_ = _tmp100_;
																							vala_unresolved_type_set_unresolved_symbol (_tmp97_, _tmp101_);
																							_vala_code_node_unref0 (_tmp101_);
																							_vala_code_node_unref0 (_tmp99_);
																						} else {
																							TypeTag _tmp102_;
																							_tmp102_ = type_node->tag;
																							if (_tmp102_ == TYPE_TAG_SLIST) {
																								ValaUnresolvedType* _tmp103_;
																								ValaUnresolvedSymbol* _tmp104_;
																								ValaUnresolvedSymbol* _tmp105_;
																								ValaUnresolvedSymbol* _tmp106_;
																								ValaUnresolvedSymbol* _tmp107_;
																								_tmp103_ = type;
																								_tmp104_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																								_tmp105_ = _tmp104_;
																								_tmp106_ = vala_unresolved_symbol_new (_tmp105_, "SList", NULL);
																								_tmp107_ = _tmp106_;
																								vala_unresolved_type_set_unresolved_symbol (_tmp103_, _tmp107_);
																								_vala_code_node_unref0 (_tmp107_);
																								_vala_code_node_unref0 (_tmp105_);
																							} else {
																								TypeTag _tmp108_;
																								_tmp108_ = type_node->tag;
																								if (_tmp108_ == TYPE_TAG_HASH) {
																									ValaUnresolvedType* _tmp109_;
																									ValaUnresolvedSymbol* _tmp110_;
																									ValaUnresolvedSymbol* _tmp111_;
																									ValaUnresolvedSymbol* _tmp112_;
																									ValaUnresolvedSymbol* _tmp113_;
																									_tmp109_ = type;
																									_tmp110_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																									_tmp111_ = _tmp110_;
																									_tmp112_ = vala_unresolved_symbol_new (_tmp111_, "HashTable", NULL);
																									_tmp113_ = _tmp112_;
																									vala_unresolved_type_set_unresolved_symbol (_tmp109_, _tmp113_);
																									_vala_code_node_unref0 (_tmp113_);
																									_vala_code_node_unref0 (_tmp111_);
																								} else {
																									TypeTag _tmp114_;
																									_tmp114_ = type_node->tag;
																									if (_tmp114_ == TYPE_TAG_ERROR) {
																										ValaUnresolvedType* _tmp115_;
																										ValaUnresolvedSymbol* _tmp116_;
																										ValaUnresolvedSymbol* _tmp117_;
																										ValaUnresolvedSymbol* _tmp118_;
																										ValaUnresolvedSymbol* _tmp119_;
																										_tmp115_ = type;
																										_tmp116_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																										_tmp117_ = _tmp116_;
																										_tmp118_ = vala_unresolved_symbol_new (_tmp117_, "Error", NULL);
																										_tmp119_ = _tmp118_;
																										vala_unresolved_type_set_unresolved_symbol (_tmp115_, _tmp119_);
																										_vala_code_node_unref0 (_tmp119_);
																										_vala_code_node_unref0 (_tmp117_);
																									} else {
																										gboolean _tmp120_ = FALSE;
																										gboolean _tmp121_ = FALSE;
																										const gchar* _tmp122_;
																										_tmp122_ = type_node->unparsed;
																										if (g_str_has_prefix (_tmp122_, "cairo_device_t")) {
																											_tmp121_ = TRUE;
																										} else {
																											const gchar* _tmp123_;
																											_tmp123_ = type_node->unparsed;
																											_tmp121_ = g_str_has_prefix (_tmp123_, "cairo_pattern_t");
																										}
																										if (_tmp121_) {
																											_tmp120_ = TRUE;
																										} else {
																											const gchar* _tmp124_;
																											_tmp124_ = type_node->unparsed;
																											_tmp120_ = g_str_has_prefix (_tmp124_, "cairo_surface_t");
																										}
																										if (_tmp120_) {
																											const gchar* _tmp125_;
																											const gchar* _tmp143_;
																											_tmp125_ = type_node->unparsed;
																											if (g_str_has_prefix (_tmp125_, "cairo_device_t")) {
																												ValaUnresolvedType* _tmp126_;
																												ValaUnresolvedSymbol* _tmp127_;
																												ValaUnresolvedSymbol* _tmp128_;
																												ValaUnresolvedSymbol* _tmp129_;
																												ValaUnresolvedSymbol* _tmp130_;
																												_tmp126_ = type;
																												_tmp127_ = vala_unresolved_symbol_new (NULL, "Cairo", NULL);
																												_tmp128_ = _tmp127_;
																												_tmp129_ = vala_unresolved_symbol_new (_tmp128_, "Device", NULL);
																												_tmp130_ = _tmp129_;
																												vala_unresolved_type_set_unresolved_symbol (_tmp126_, _tmp130_);
																												_vala_code_node_unref0 (_tmp130_);
																												_vala_code_node_unref0 (_tmp128_);
																											} else {
																												const gchar* _tmp131_;
																												_tmp131_ = type_node->unparsed;
																												if (g_str_has_prefix (_tmp131_, "cairo_pattern_t")) {
																													ValaUnresolvedType* _tmp132_;
																													ValaUnresolvedSymbol* _tmp133_;
																													ValaUnresolvedSymbol* _tmp134_;
																													ValaUnresolvedSymbol* _tmp135_;
																													ValaUnresolvedSymbol* _tmp136_;
																													_tmp132_ = type;
																													_tmp133_ = vala_unresolved_symbol_new (NULL, "Cairo", NULL);
																													_tmp134_ = _tmp133_;
																													_tmp135_ = vala_unresolved_symbol_new (_tmp134_, "Pattern", NULL);
																													_tmp136_ = _tmp135_;
																													vala_unresolved_type_set_unresolved_symbol (_tmp132_, _tmp136_);
																													_vala_code_node_unref0 (_tmp136_);
																													_vala_code_node_unref0 (_tmp134_);
																												} else {
																													const gchar* _tmp137_;
																													_tmp137_ = type_node->unparsed;
																													if (g_str_has_prefix (_tmp137_, "cairo_surface_t")) {
																														ValaUnresolvedType* _tmp138_;
																														ValaUnresolvedSymbol* _tmp139_;
																														ValaUnresolvedSymbol* _tmp140_;
																														ValaUnresolvedSymbol* _tmp141_;
																														ValaUnresolvedSymbol* _tmp142_;
																														_tmp138_ = type;
																														_tmp139_ = vala_unresolved_symbol_new (NULL, "Cairo", NULL);
																														_tmp140_ = _tmp139_;
																														_tmp141_ = vala_unresolved_symbol_new (_tmp140_, "Surface", NULL);
																														_tmp142_ = _tmp141_;
																														vala_unresolved_type_set_unresolved_symbol (_tmp138_, _tmp142_);
																														_vala_code_node_unref0 (_tmp142_);
																														_vala_code_node_unref0 (_tmp140_);
																													}
																												}
																											}
																											_tmp143_ = type_node->unparsed;
																											if (g_str_has_suffix (_tmp143_, "**")) {
																												_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																											}
																										} else {
																											gboolean _tmp144_;
																											_tmp144_ = type_node->is_interface;
																											if (_tmp144_) {
																												gchar* n = NULL;
																												const gchar* _tmp145_;
																												gchar* _tmp146_;
																												const gchar* _tmp147_;
																												const gchar* _tmp148_;
																												gboolean _tmp153_ = FALSE;
																												gboolean _tmp154_;
																												_tmp145_ = type_node->interface;
																												_tmp146_ = g_strdup (_tmp145_);
																												n = _tmp146_;
																												_tmp147_ = n;
																												if (g_strcmp0 (_tmp147_, "") == 0) {
																													result = NULL;
																													_g_free0 (n);
																													_vala_code_node_unref0 (type);
																													if (direction) {
																														*direction = _vala_direction;
																													}
																													return result;
																												}
																												_tmp148_ = n;
																												if (g_str_has_prefix (_tmp148_, "const-")) {
																													const gchar* _tmp149_;
																													gint _tmp150_;
																													gint _tmp151_;
																													gchar* _tmp152_;
																													_tmp149_ = n;
																													_tmp150_ = strlen ("const-");
																													_tmp151_ = _tmp150_;
																													_tmp152_ = string_substring (_tmp149_, (glong) _tmp151_, (glong) -1);
																													_g_free0 (n);
																													n = _tmp152_;
																												}
																												_tmp154_ = type_node->is_pointer;
																												if (_tmp154_) {
																													gboolean _tmp155_ = FALSE;
																													const gchar* _tmp156_;
																													_tmp156_ = n;
																													if (g_strcmp0 (_tmp156_, "gchar") == 0) {
																														_tmp155_ = TRUE;
																													} else {
																														const gchar* _tmp157_;
																														_tmp157_ = n;
																														_tmp155_ = g_strcmp0 (_tmp157_, "char") == 0;
																													}
																													_tmp153_ = _tmp155_;
																												} else {
																													_tmp153_ = FALSE;
																												}
																												if (_tmp153_) {
																													ValaUnresolvedType* _tmp158_;
																													ValaUnresolvedSymbol* _tmp159_;
																													ValaUnresolvedSymbol* _tmp160_;
																													const gchar* _tmp161_;
																													_tmp158_ = type;
																													_tmp159_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																													_tmp160_ = _tmp159_;
																													vala_unresolved_type_set_unresolved_symbol (_tmp158_, _tmp160_);
																													_vala_code_node_unref0 (_tmp160_);
																													_tmp161_ = type_node->unparsed;
																													if (g_str_has_suffix (_tmp161_, "**")) {
																														_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																													}
																												} else {
																													const gchar* _tmp162_;
																													_tmp162_ = n;
																													if (g_strcmp0 (_tmp162_, "gunichar") == 0) {
																														ValaUnresolvedType* _tmp163_;
																														ValaUnresolvedSymbol* _tmp164_;
																														ValaUnresolvedSymbol* _tmp165_;
																														_tmp163_ = type;
																														_tmp164_ = vala_unresolved_symbol_new (NULL, "unichar", NULL);
																														_tmp165_ = _tmp164_;
																														vala_unresolved_type_set_unresolved_symbol (_tmp163_, _tmp165_);
																														_vala_code_node_unref0 (_tmp165_);
																													} else {
																														const gchar* _tmp166_;
																														_tmp166_ = n;
																														if (g_strcmp0 (_tmp166_, "gchar") == 0) {
																															ValaUnresolvedType* _tmp167_;
																															ValaUnresolvedSymbol* _tmp168_;
																															ValaUnresolvedSymbol* _tmp169_;
																															_tmp167_ = type;
																															_tmp168_ = vala_unresolved_symbol_new (NULL, "char", NULL);
																															_tmp169_ = _tmp168_;
																															vala_unresolved_type_set_unresolved_symbol (_tmp167_, _tmp169_);
																															_vala_code_node_unref0 (_tmp169_);
																														} else {
																															gboolean _tmp170_ = FALSE;
																															const gchar* _tmp171_;
																															_tmp171_ = n;
																															if (g_strcmp0 (_tmp171_, "guchar") == 0) {
																																_tmp170_ = TRUE;
																															} else {
																																const gchar* _tmp172_;
																																_tmp172_ = n;
																																_tmp170_ = g_strcmp0 (_tmp172_, "guint8") == 0;
																															}
																															if (_tmp170_) {
																																ValaUnresolvedType* _tmp173_;
																																ValaUnresolvedSymbol* _tmp174_;
																																ValaUnresolvedSymbol* _tmp175_;
																																gboolean _tmp176_;
																																_tmp173_ = type;
																																_tmp174_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
																																_tmp175_ = _tmp174_;
																																vala_unresolved_type_set_unresolved_symbol (_tmp173_, _tmp175_);
																																_vala_code_node_unref0 (_tmp175_);
																																_tmp176_ = type_node->is_pointer;
																																if (_tmp176_) {
																																	ValaUnresolvedType* _tmp177_;
																																	ValaUnresolvedType* _tmp178_;
																																	ValaUnresolvedType* _tmp179_;
																																	ValaSourceReference* _tmp180_;
																																	ValaSourceReference* _tmp181_;
																																	ValaArrayType* _tmp182_;
																																	_tmp177_ = type;
																																	vala_data_type_set_value_owned ((ValaDataType*) _tmp177_, TRUE);
																																	_tmp178_ = type;
																																	_tmp179_ = type;
																																	_tmp180_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp179_);
																																	_tmp181_ = _tmp180_;
																																	_tmp182_ = vala_array_type_new ((ValaDataType*) _tmp178_, 1, _tmp181_);
																																	result = (ValaDataType*) _tmp182_;
																																	_g_free0 (n);
																																	_vala_code_node_unref0 (type);
																																	if (direction) {
																																		*direction = _vala_direction;
																																	}
																																	return result;
																																}
																															} else {
																																const gchar* _tmp183_;
																																_tmp183_ = n;
																																if (g_strcmp0 (_tmp183_, "gushort") == 0) {
																																	ValaUnresolvedType* _tmp184_;
																																	ValaUnresolvedSymbol* _tmp185_;
																																	ValaUnresolvedSymbol* _tmp186_;
																																	_tmp184_ = type;
																																	_tmp185_ = vala_unresolved_symbol_new (NULL, "ushort", NULL);
																																	_tmp186_ = _tmp185_;
																																	vala_unresolved_type_set_unresolved_symbol (_tmp184_, _tmp186_);
																																	_vala_code_node_unref0 (_tmp186_);
																																} else {
																																	const gchar* _tmp187_;
																																	_tmp187_ = n;
																																	if (g_strcmp0 (_tmp187_, "gshort") == 0) {
																																		ValaUnresolvedType* _tmp188_;
																																		ValaUnresolvedSymbol* _tmp189_;
																																		ValaUnresolvedSymbol* _tmp190_;
																																		_tmp188_ = type;
																																		_tmp189_ = vala_unresolved_symbol_new (NULL, "short", NULL);
																																		_tmp190_ = _tmp189_;
																																		vala_unresolved_type_set_unresolved_symbol (_tmp188_, _tmp190_);
																																		_vala_code_node_unref0 (_tmp190_);
																																	} else {
																																		gboolean _tmp191_ = FALSE;
																																		const gchar* _tmp192_;
																																		_tmp192_ = n;
																																		if (g_strcmp0 (_tmp192_, "gconstpointer") == 0) {
																																			_tmp191_ = TRUE;
																																		} else {
																																			const gchar* _tmp193_;
																																			_tmp193_ = n;
																																			_tmp191_ = g_strcmp0 (_tmp193_, "void") == 0;
																																		}
																																		if (_tmp191_) {
																																			ValaVoidType* _tmp194_;
																																			ValaVoidType* _tmp195_;
																																			ValaPointerType* _tmp196_;
																																			ValaDataType* _tmp197_;
																																			_tmp194_ = vala_void_type_new (NULL);
																																			_tmp195_ = _tmp194_;
																																			_tmp196_ = vala_pointer_type_new ((ValaDataType*) _tmp195_, NULL);
																																			_tmp197_ = (ValaDataType*) _tmp196_;
																																			_vala_code_node_unref0 (_tmp195_);
																																			result = _tmp197_;
																																			_g_free0 (n);
																																			_vala_code_node_unref0 (type);
																																			if (direction) {
																																				*direction = _vala_direction;
																																			}
																																			return result;
																																		} else {
																																			gboolean _tmp198_ = FALSE;
																																			const gchar* _tmp199_;
																																			_tmp199_ = n;
																																			if (g_strcmp0 (_tmp199_, "goffset") == 0) {
																																				_tmp198_ = TRUE;
																																			} else {
																																				const gchar* _tmp200_;
																																				_tmp200_ = n;
																																				_tmp198_ = g_strcmp0 (_tmp200_, "off_t") == 0;
																																			}
																																			if (_tmp198_) {
																																				ValaUnresolvedType* _tmp201_;
																																				ValaUnresolvedSymbol* _tmp202_;
																																				ValaUnresolvedSymbol* _tmp203_;
																																				_tmp201_ = type;
																																				_tmp202_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
																																				_tmp203_ = _tmp202_;
																																				vala_unresolved_type_set_unresolved_symbol (_tmp201_, _tmp203_);
																																				_vala_code_node_unref0 (_tmp203_);
																																			} else {
																																				const gchar* _tmp204_;
																																				_tmp204_ = n;
																																				if (g_strcmp0 (_tmp204_, "value_array") == 0) {
																																					ValaUnresolvedType* _tmp205_;
																																					ValaUnresolvedSymbol* _tmp206_;
																																					ValaUnresolvedSymbol* _tmp207_;
																																					ValaUnresolvedSymbol* _tmp208_;
																																					ValaUnresolvedSymbol* _tmp209_;
																																					_tmp205_ = type;
																																					_tmp206_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																					_tmp207_ = _tmp206_;
																																					_tmp208_ = vala_unresolved_symbol_new (_tmp207_, "ValueArray", NULL);
																																					_tmp209_ = _tmp208_;
																																					vala_unresolved_type_set_unresolved_symbol (_tmp205_, _tmp209_);
																																					_vala_code_node_unref0 (_tmp209_);
																																					_vala_code_node_unref0 (_tmp207_);
																																				} else {
																																					const gchar* _tmp210_;
																																					_tmp210_ = n;
																																					if (g_strcmp0 (_tmp210_, "time_t") == 0) {
																																						ValaUnresolvedType* _tmp211_;
																																						ValaUnresolvedSymbol* _tmp212_;
																																						ValaUnresolvedSymbol* _tmp213_;
																																						_tmp211_ = type;
																																						_tmp212_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
																																						_tmp213_ = _tmp212_;
																																						vala_unresolved_type_set_unresolved_symbol (_tmp211_, _tmp213_);
																																						_vala_code_node_unref0 (_tmp213_);
																																					} else {
																																						const gchar* _tmp214_;
																																						_tmp214_ = n;
																																						if (g_strcmp0 (_tmp214_, "socklen_t") == 0) {
																																							ValaUnresolvedType* _tmp215_;
																																							ValaUnresolvedSymbol* _tmp216_;
																																							ValaUnresolvedSymbol* _tmp217_;
																																							_tmp215_ = type;
																																							_tmp216_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
																																							_tmp217_ = _tmp216_;
																																							vala_unresolved_type_set_unresolved_symbol (_tmp215_, _tmp217_);
																																							_vala_code_node_unref0 (_tmp217_);
																																						} else {
																																							const gchar* _tmp218_;
																																							_tmp218_ = n;
																																							if (g_strcmp0 (_tmp218_, "mode_t") == 0) {
																																								ValaUnresolvedType* _tmp219_;
																																								ValaUnresolvedSymbol* _tmp220_;
																																								ValaUnresolvedSymbol* _tmp221_;
																																								_tmp219_ = type;
																																								_tmp220_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																								_tmp221_ = _tmp220_;
																																								vala_unresolved_type_set_unresolved_symbol (_tmp219_, _tmp221_);
																																								_vala_code_node_unref0 (_tmp221_);
																																							} else {
																																								gboolean _tmp222_ = FALSE;
																																								const gchar* _tmp223_;
																																								_tmp223_ = n;
																																								if (g_strcmp0 (_tmp223_, "gint") == 0) {
																																									_tmp222_ = TRUE;
																																								} else {
																																									const gchar* _tmp224_;
																																									_tmp224_ = n;
																																									_tmp222_ = g_strcmp0 (_tmp224_, "pid_t") == 0;
																																								}
																																								if (_tmp222_) {
																																									ValaUnresolvedType* _tmp225_;
																																									ValaUnresolvedSymbol* _tmp226_;
																																									ValaUnresolvedSymbol* _tmp227_;
																																									_tmp225_ = type;
																																									_tmp226_ = vala_unresolved_symbol_new (NULL, "int", NULL);
																																									_tmp227_ = _tmp226_;
																																									vala_unresolved_type_set_unresolved_symbol (_tmp225_, _tmp227_);
																																									_vala_code_node_unref0 (_tmp227_);
																																								} else {
																																									gboolean _tmp228_ = FALSE;
																																									const gchar* _tmp229_;
																																									_tmp229_ = n;
																																									if (g_strcmp0 (_tmp229_, "unsigned") == 0) {
																																										_tmp228_ = TRUE;
																																									} else {
																																										const gchar* _tmp230_;
																																										_tmp230_ = n;
																																										_tmp228_ = g_strcmp0 (_tmp230_, "unsigned-int") == 0;
																																									}
																																									if (_tmp228_) {
																																										ValaUnresolvedType* _tmp231_;
																																										ValaUnresolvedSymbol* _tmp232_;
																																										ValaUnresolvedSymbol* _tmp233_;
																																										_tmp231_ = type;
																																										_tmp232_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																										_tmp233_ = _tmp232_;
																																										vala_unresolved_type_set_unresolved_symbol (_tmp231_, _tmp233_);
																																										_vala_code_node_unref0 (_tmp233_);
																																									} else {
																																										const gchar* _tmp234_;
																																										_tmp234_ = n;
																																										if (g_strcmp0 (_tmp234_, "FILE") == 0) {
																																											ValaUnresolvedType* _tmp235_;
																																											ValaUnresolvedSymbol* _tmp236_;
																																											ValaUnresolvedSymbol* _tmp237_;
																																											ValaUnresolvedSymbol* _tmp238_;
																																											ValaUnresolvedSymbol* _tmp239_;
																																											_tmp235_ = type;
																																											_tmp236_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																											_tmp237_ = _tmp236_;
																																											_tmp238_ = vala_unresolved_symbol_new (_tmp237_, "FileStream", NULL);
																																											_tmp239_ = _tmp238_;
																																											vala_unresolved_type_set_unresolved_symbol (_tmp235_, _tmp239_);
																																											_vala_code_node_unref0 (_tmp239_);
																																											_vala_code_node_unref0 (_tmp237_);
																																										} else {
																																											const gchar* _tmp240_;
																																											_tmp240_ = n;
																																											if (g_strcmp0 (_tmp240_, "struct") == 0) {
																																												ValaVoidType* _tmp241_;
																																												ValaVoidType* _tmp242_;
																																												ValaPointerType* _tmp243_;
																																												ValaDataType* _tmp244_;
																																												_tmp241_ = vala_void_type_new (NULL);
																																												_tmp242_ = _tmp241_;
																																												_tmp243_ = vala_pointer_type_new ((ValaDataType*) _tmp242_, NULL);
																																												_tmp244_ = (ValaDataType*) _tmp243_;
																																												_vala_code_node_unref0 (_tmp242_);
																																												result = _tmp244_;
																																												_g_free0 (n);
																																												_vala_code_node_unref0 (type);
																																												if (direction) {
																																													*direction = _vala_direction;
																																												}
																																												return result;
																																											} else {
																																												const gchar* _tmp245_;
																																												_tmp245_ = n;
																																												if (g_strcmp0 (_tmp245_, "iconv_t") == 0) {
																																													ValaVoidType* _tmp246_;
																																													ValaVoidType* _tmp247_;
																																													ValaPointerType* _tmp248_;
																																													ValaDataType* _tmp249_;
																																													_tmp246_ = vala_void_type_new (NULL);
																																													_tmp247_ = _tmp246_;
																																													_tmp248_ = vala_pointer_type_new ((ValaDataType*) _tmp247_, NULL);
																																													_tmp249_ = (ValaDataType*) _tmp248_;
																																													_vala_code_node_unref0 (_tmp247_);
																																													result = _tmp249_;
																																													_g_free0 (n);
																																													_vala_code_node_unref0 (type);
																																													if (direction) {
																																														*direction = _vala_direction;
																																													}
																																													return result;
																																												} else {
																																													const gchar* _tmp250_;
																																													_tmp250_ = n;
																																													if (g_strcmp0 (_tmp250_, "GType") == 0) {
																																														ValaUnresolvedType* _tmp251_;
																																														ValaUnresolvedSymbol* _tmp252_;
																																														ValaUnresolvedSymbol* _tmp253_;
																																														ValaUnresolvedSymbol* _tmp254_;
																																														ValaUnresolvedSymbol* _tmp255_;
																																														gboolean _tmp256_;
																																														_tmp251_ = type;
																																														_tmp252_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																														_tmp253_ = _tmp252_;
																																														_tmp254_ = vala_unresolved_symbol_new (_tmp253_, "Type", NULL);
																																														_tmp255_ = _tmp254_;
																																														vala_unresolved_type_set_unresolved_symbol (_tmp251_, _tmp255_);
																																														_vala_code_node_unref0 (_tmp255_);
																																														_vala_code_node_unref0 (_tmp253_);
																																														_tmp256_ = type_node->is_pointer;
																																														if (_tmp256_) {
																																															ValaUnresolvedType* _tmp257_;
																																															ValaUnresolvedType* _tmp258_;
																																															ValaUnresolvedType* _tmp259_;
																																															ValaSourceReference* _tmp260_;
																																															ValaSourceReference* _tmp261_;
																																															ValaArrayType* _tmp262_;
																																															_tmp257_ = type;
																																															vala_data_type_set_value_owned ((ValaDataType*) _tmp257_, TRUE);
																																															_tmp258_ = type;
																																															_tmp259_ = type;
																																															_tmp260_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp259_);
																																															_tmp261_ = _tmp260_;
																																															_tmp262_ = vala_array_type_new ((ValaDataType*) _tmp258_, 1, _tmp261_);
																																															result = (ValaDataType*) _tmp262_;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _vala_direction;
																																															}
																																															return result;
																																														}
																																													} else {
																																														const gchar* _tmp263_;
																																														_tmp263_ = n;
																																														if (g_strcmp0 (_tmp263_, "GStrv") == 0) {
																																															ValaUnresolvedType* _tmp264_;
																																															ValaUnresolvedSymbol* _tmp265_;
																																															ValaUnresolvedSymbol* _tmp266_;
																																															ValaUnresolvedType* _tmp267_;
																																															ValaUnresolvedType* _tmp268_;
																																															ValaUnresolvedType* _tmp269_;
																																															ValaSourceReference* _tmp270_;
																																															ValaSourceReference* _tmp271_;
																																															ValaArrayType* _tmp272_;
																																															_tmp264_ = type;
																																															_tmp265_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																																															_tmp266_ = _tmp265_;
																																															vala_unresolved_type_set_unresolved_symbol (_tmp264_, _tmp266_);
																																															_vala_code_node_unref0 (_tmp266_);
																																															_tmp267_ = type;
																																															vala_data_type_set_value_owned ((ValaDataType*) _tmp267_, TRUE);
																																															_tmp268_ = type;
																																															_tmp269_ = type;
																																															_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp269_);
																																															_tmp271_ = _tmp270_;
																																															_tmp272_ = vala_array_type_new ((ValaDataType*) _tmp268_, 1, _tmp271_);
																																															result = (ValaDataType*) _tmp272_;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _vala_direction;
																																															}
																																															return result;
																																														} else {
																																															ValaDataType* named_type = NULL;
																																															const gchar* _tmp273_;
																																															ValaDataType* _tmp274_;
																																															ValaDataType* _tmp275_;
																																															ValaUnresolvedType* _tmp276_;
																																															ValaUnresolvedType* _tmp277_;
																																															const gchar* _tmp278_;
																																															_tmp273_ = n;
																																															_tmp274_ = vala_gidl_parser_parse_type_string (self, _tmp273_);
																																															named_type = _tmp274_;
																																															_tmp275_ = named_type;
																																															_tmp276_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp275_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp275_) : NULL);
																																															_vala_code_node_unref0 (type);
																																															type = _tmp276_;
																																															_tmp277_ = type;
																																															if (_tmp277_ == NULL) {
																																																result = named_type;
																																																_g_free0 (n);
																																																_vala_code_node_unref0 (type);
																																																if (direction) {
																																																	*direction = _vala_direction;
																																																}
																																																return result;
																																															}
																																															_tmp278_ = n;
																																															if (vala_gidl_parser_is_simple_type (self, _tmp278_)) {
																																																gboolean _tmp279_;
																																																_tmp279_ = type_node->is_pointer;
																																																if (_tmp279_) {
																																																	_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																																																}
																																															} else {
																																																const gchar* _tmp280_;
																																																_tmp280_ = type_node->unparsed;
																																																if (g_str_has_suffix (_tmp280_, "**")) {
																																																	_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																																																}
																																															}
																																															_vala_code_node_unref0 (named_type);
																																														}
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																												_g_free0 (n);
																											} else {
																												FILE* _tmp281_;
																												TypeTag _tmp282_;
																												_tmp281_ = stdout;
																												_tmp282_ = type_node->tag;
																												fprintf (_tmp281_, "%d\n", (gint) _tmp282_);
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = (ValaDataType*) type;
	if (direction) {
		*direction = _vala_direction;
	}
	return result;
}


static gboolean
vala_gidl_parser_is_simple_type (ValaGIdlParser* self,
                                 const gchar* type_name)
{
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaStruct* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaStruct* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_name != NULL, FALSE);
	_tmp0_ = self->priv->cname_type_map;
	_tmp1_ = vala_map_get (_tmp0_, type_name);
	_tmp2_ = (ValaTypeSymbol*) _tmp1_;
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_vala_code_node_unref0 (_tmp2_);
	}
	st = _tmp3_;
	_tmp5_ = st;
	if (_tmp5_ != NULL) {
		ValaStruct* _tmp6_;
		_tmp6_ = st;
		_tmp4_ = vala_struct_is_simple_type (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (st);
	return result;
}


static ValaDataType*
vala_gidl_parser_parse_type_string (ValaGIdlParser* self,
                                    const gchar* n)
{
	ValaDataType* result = NULL;
	ValaUnresolvedType* type = NULL;
	ValaUnresolvedType* _tmp4_;
	ValaTypeSymbol* dt = NULL;
	ValaMap* _tmp5_;
	gpointer _tmp6_;
	ValaTypeSymbol* _tmp7_;
	gchar** type_attributes = NULL;
	gint _tmp26_ = 0;
	gchar** _tmp27_;
	gint type_attributes_length1;
	gint _type_attributes_size_;
	gchar* ns_name = NULL;
	gchar** _tmp28_;
	gint _tmp28__length1;
	ValaUnresolvedType* _tmp70_;
	ValaUnresolvedSymbol* _tmp71_;
	ValaUnresolvedSymbol* _tmp72_;
	ValaNamespace* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	if (g_strcmp0 (n, "va_list") == 0) {
		ValaVoidType* _tmp0_;
		ValaVoidType* _tmp1_;
		ValaPointerType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp0_ = vala_void_type_new (NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_pointer_type_new ((ValaDataType*) _tmp1_, NULL);
		_tmp3_ = (ValaDataType*) _tmp2_;
		_vala_code_node_unref0 (_tmp1_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = vala_unresolved_type_new ();
	type = _tmp4_;
	_tmp5_ = self->priv->cname_type_map;
	_tmp6_ = vala_map_get (_tmp5_, n);
	dt = (ValaTypeSymbol*) _tmp6_;
	_tmp7_ = dt;
	if (_tmp7_ != NULL) {
		ValaUnresolvedSymbol* parent_symbol = NULL;
		ValaTypeSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		ValaUnresolvedType* _tmp19_;
		ValaUnresolvedSymbol* _tmp20_;
		ValaTypeSymbol* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaUnresolvedSymbol* _tmp25_;
		parent_symbol = NULL;
		_tmp8_ = dt;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaTypeSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			ValaUnresolvedSymbol* _tmp18_;
			_tmp13_ = dt;
			_tmp14_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_symbol_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_unresolved_symbol_new (NULL, _tmp17_, NULL);
			_vala_code_node_unref0 (parent_symbol);
			parent_symbol = _tmp18_;
		}
		_tmp19_ = type;
		_tmp20_ = parent_symbol;
		_tmp21_ = dt;
		_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_unresolved_symbol_new (_tmp20_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		vala_unresolved_type_set_unresolved_symbol (_tmp19_, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (parent_symbol);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp27_ = vala_gidl_parser_get_attributes (self, n, &_tmp26_);
	type_attributes = _tmp27_;
	type_attributes_length1 = _tmp26_;
	_type_attributes_size_ = type_attributes_length1;
	ns_name = NULL;
	_tmp28_ = type_attributes;
	_tmp28__length1 = type_attributes_length1;
	if (NULL != _tmp28_) {
		gchar** _tmp29_;
		gint _tmp29__length1;
		_tmp29_ = type_attributes;
		_tmp29__length1 = type_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp29_;
			attr_collection_length1 = _tmp29__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp30_;
				gchar* attr = NULL;
				_tmp30_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp30_;
				{
					gchar** nv = NULL;
					const gchar* _tmp31_;
					gchar** _tmp32_;
					gchar** _tmp33_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp34_;
					gint _tmp34__length1;
					const gchar* _tmp35_;
					_tmp31_ = attr;
					_tmp33_ = _tmp32_ = g_strsplit (_tmp31_, "=", 2);
					nv = _tmp33_;
					nv_length1 = _vala_array_length (_tmp32_);
					_nv_size_ = nv_length1;
					_tmp34_ = nv;
					_tmp34__length1 = nv_length1;
					_tmp35_ = _tmp34_[0];
					if (g_strcmp0 (_tmp35_, "cprefix") == 0) {
						ValaUnresolvedType* _tmp36_;
						gchar** _tmp37_;
						gint _tmp37__length1;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gint _tmp41_;
						gint _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						ValaUnresolvedSymbol* _tmp45_;
						ValaUnresolvedSymbol* _tmp46_;
						_tmp36_ = type;
						_tmp37_ = nv;
						_tmp37__length1 = nv_length1;
						_tmp38_ = _tmp37_[1];
						_tmp39_ = vala_gidl_parser_eval (self, _tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = strlen (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = string_substring (n, (glong) _tmp42_, (glong) -1);
						_tmp44_ = _tmp43_;
						_tmp45_ = vala_unresolved_symbol_new (NULL, _tmp44_, NULL);
						_tmp46_ = _tmp45_;
						vala_unresolved_type_set_unresolved_symbol (_tmp36_, _tmp46_);
						_vala_code_node_unref0 (_tmp46_);
						_g_free0 (_tmp44_);
						_g_free0 (_tmp40_);
					} else {
						gchar** _tmp47_;
						gint _tmp47__length1;
						const gchar* _tmp48_;
						_tmp47_ = nv;
						_tmp47__length1 = nv_length1;
						_tmp48_ = _tmp47_[0];
						if (g_strcmp0 (_tmp48_, "name") == 0) {
							ValaUnresolvedType* _tmp49_;
							gchar** _tmp50_;
							gint _tmp50__length1;
							const gchar* _tmp51_;
							gchar* _tmp52_;
							gchar* _tmp53_;
							ValaUnresolvedSymbol* _tmp54_;
							ValaUnresolvedSymbol* _tmp55_;
							_tmp49_ = type;
							_tmp50_ = nv;
							_tmp50__length1 = nv_length1;
							_tmp51_ = _tmp50_[1];
							_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = vala_unresolved_symbol_new (NULL, _tmp53_, NULL);
							_tmp55_ = _tmp54_;
							vala_unresolved_type_set_unresolved_symbol (_tmp49_, _tmp55_);
							_vala_code_node_unref0 (_tmp55_);
							_g_free0 (_tmp53_);
						} else {
							gchar** _tmp56_;
							gint _tmp56__length1;
							const gchar* _tmp57_;
							_tmp56_ = nv;
							_tmp56__length1 = nv_length1;
							_tmp57_ = _tmp56_[0];
							if (g_strcmp0 (_tmp57_, "namespace") == 0) {
								gchar** _tmp58_;
								gint _tmp58__length1;
								const gchar* _tmp59_;
								gchar* _tmp60_;
								_tmp58_ = nv;
								_tmp58__length1 = nv_length1;
								_tmp59_ = _tmp58_[1];
								_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
								_g_free0 (ns_name);
								ns_name = _tmp60_;
							} else {
								gchar** _tmp61_;
								gint _tmp61__length1;
								const gchar* _tmp62_;
								_tmp61_ = nv;
								_tmp61__length1 = nv_length1;
								_tmp62_ = _tmp61_[0];
								if (g_strcmp0 (_tmp62_, "rename_to") == 0) {
									ValaUnresolvedType* _tmp63_;
									gchar** _tmp64_;
									gint _tmp64__length1;
									const gchar* _tmp65_;
									gchar* _tmp66_;
									gchar* _tmp67_;
									ValaUnresolvedSymbol* _tmp68_;
									ValaUnresolvedSymbol* _tmp69_;
									_tmp63_ = type;
									_tmp64_ = nv;
									_tmp64__length1 = nv_length1;
									_tmp65_ = _tmp64_[1];
									_tmp66_ = vala_gidl_parser_eval (self, _tmp65_);
									_tmp67_ = _tmp66_;
									_tmp68_ = vala_unresolved_symbol_new (NULL, _tmp67_, NULL);
									_tmp69_ = _tmp68_;
									vala_unresolved_type_set_unresolved_symbol (_tmp63_, _tmp69_);
									_vala_code_node_unref0 (_tmp69_);
									_g_free0 (_tmp67_);
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp70_ = type;
	_tmp71_ = vala_unresolved_type_get_unresolved_symbol (_tmp70_);
	_tmp72_ = _tmp71_;
	if (_tmp72_ != NULL) {
		ValaUnresolvedType* _tmp73_;
		ValaUnresolvedSymbol* _tmp74_;
		ValaUnresolvedSymbol* _tmp75_;
		const gchar* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp82_;
		_tmp73_ = type;
		_tmp74_ = vala_unresolved_type_get_unresolved_symbol (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_symbol_get_name ((ValaSymbol*) _tmp75_);
		_tmp77_ = _tmp76_;
		if (g_strcmp0 (_tmp77_, "pointer") == 0) {
			ValaVoidType* _tmp78_;
			ValaVoidType* _tmp79_;
			ValaPointerType* _tmp80_;
			ValaDataType* _tmp81_;
			_tmp78_ = vala_void_type_new (NULL);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_pointer_type_new ((ValaDataType*) _tmp79_, NULL);
			_tmp81_ = (ValaDataType*) _tmp80_;
			_vala_code_node_unref0 (_tmp79_);
			result = _tmp81_;
			_g_free0 (ns_name);
			type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (dt);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp82_ = ns_name;
		if (_tmp82_ != NULL) {
			ValaUnresolvedType* _tmp83_;
			ValaUnresolvedSymbol* _tmp84_;
			ValaUnresolvedSymbol* _tmp85_;
			const gchar* _tmp86_;
			ValaUnresolvedSymbol* _tmp87_;
			ValaUnresolvedSymbol* _tmp88_;
			_tmp83_ = type;
			_tmp84_ = vala_unresolved_type_get_unresolved_symbol (_tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = ns_name;
			_tmp87_ = vala_unresolved_symbol_new (NULL, _tmp86_, NULL);
			_tmp88_ = _tmp87_;
			vala_unresolved_symbol_set_inner (_tmp85_, _tmp88_);
			_vala_code_node_unref0 (_tmp88_);
		}
		result = (ValaDataType*) type;
		_g_free0 (ns_name);
		type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp89_ = self->priv->current_namespace;
	_tmp90_ = vala_symbol_get_name ((ValaSymbol*) _tmp89_);
	_tmp91_ = _tmp90_;
	if (g_str_has_prefix (n, _tmp91_)) {
		ValaUnresolvedType* _tmp92_;
		ValaNamespace* _tmp93_;
		const gchar* _tmp94_;
		const gchar* _tmp95_;
		ValaUnresolvedSymbol* _tmp96_;
		ValaUnresolvedSymbol* _tmp97_;
		ValaNamespace* _tmp98_;
		const gchar* _tmp99_;
		const gchar* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		ValaUnresolvedSymbol* _tmp105_;
		ValaUnresolvedSymbol* _tmp106_;
		_tmp92_ = type;
		_tmp93_ = self->priv->current_namespace;
		_tmp94_ = vala_symbol_get_name ((ValaSymbol*) _tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_unresolved_symbol_new (NULL, _tmp95_, NULL);
		_tmp97_ = _tmp96_;
		_tmp98_ = self->priv->current_namespace;
		_tmp99_ = vala_symbol_get_name ((ValaSymbol*) _tmp98_);
		_tmp100_ = _tmp99_;
		_tmp101_ = strlen (_tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = string_substring (n, (glong) _tmp102_, (glong) -1);
		_tmp104_ = _tmp103_;
		_tmp105_ = vala_unresolved_symbol_new (_tmp97_, _tmp104_, NULL);
		_tmp106_ = _tmp105_;
		vala_unresolved_type_set_unresolved_symbol (_tmp92_, _tmp106_);
		_vala_code_node_unref0 (_tmp106_);
		_g_free0 (_tmp104_);
		_vala_code_node_unref0 (_tmp97_);
	} else {
		gboolean _tmp107_ = FALSE;
		gboolean _tmp108_ = FALSE;
		ValaNamespace* _tmp109_;
		ValaSymbol* _tmp110_;
		ValaSymbol* _tmp111_;
		_tmp109_ = self->priv->current_namespace;
		_tmp110_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp109_);
		_tmp111_ = _tmp110_;
		if (_tmp111_ != NULL) {
			ValaNamespace* _tmp112_;
			ValaSymbol* _tmp113_;
			ValaSymbol* _tmp114_;
			const gchar* _tmp115_;
			const gchar* _tmp116_;
			_tmp112_ = self->priv->current_namespace;
			_tmp113_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = vala_symbol_get_name (_tmp114_);
			_tmp116_ = _tmp115_;
			_tmp108_ = _tmp116_ != NULL;
		} else {
			_tmp108_ = FALSE;
		}
		if (_tmp108_) {
			ValaNamespace* _tmp117_;
			ValaSymbol* _tmp118_;
			ValaSymbol* _tmp119_;
			const gchar* _tmp120_;
			const gchar* _tmp121_;
			_tmp117_ = self->priv->current_namespace;
			_tmp118_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp117_);
			_tmp119_ = _tmp118_;
			_tmp120_ = vala_symbol_get_name (_tmp119_);
			_tmp121_ = _tmp120_;
			_tmp107_ = g_str_has_prefix (n, _tmp121_);
		} else {
			_tmp107_ = FALSE;
		}
		if (_tmp107_) {
			ValaUnresolvedType* _tmp122_;
			ValaNamespace* _tmp123_;
			ValaSymbol* _tmp124_;
			ValaSymbol* _tmp125_;
			const gchar* _tmp126_;
			const gchar* _tmp127_;
			ValaUnresolvedSymbol* _tmp128_;
			ValaUnresolvedSymbol* _tmp129_;
			ValaNamespace* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			const gchar* _tmp133_;
			const gchar* _tmp134_;
			gint _tmp135_;
			gint _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			ValaUnresolvedSymbol* _tmp139_;
			ValaUnresolvedSymbol* _tmp140_;
			_tmp122_ = type;
			_tmp123_ = self->priv->current_namespace;
			_tmp124_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp123_);
			_tmp125_ = _tmp124_;
			_tmp126_ = vala_symbol_get_name (_tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_unresolved_symbol_new (NULL, _tmp127_, NULL);
			_tmp129_ = _tmp128_;
			_tmp130_ = self->priv->current_namespace;
			_tmp131_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_symbol_get_name (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = strlen (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = string_substring (n, (glong) _tmp136_, (glong) -1);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_unresolved_symbol_new (_tmp129_, _tmp138_, NULL);
			_tmp140_ = _tmp139_;
			vala_unresolved_type_set_unresolved_symbol (_tmp122_, _tmp140_);
			_vala_code_node_unref0 (_tmp140_);
			_g_free0 (_tmp138_);
			_vala_code_node_unref0 (_tmp129_);
		} else {
			if (g_str_has_prefix (n, "G")) {
				ValaUnresolvedType* _tmp141_;
				ValaUnresolvedSymbol* _tmp142_;
				ValaUnresolvedSymbol* _tmp143_;
				gchar* _tmp144_;
				gchar* _tmp145_;
				ValaUnresolvedSymbol* _tmp146_;
				ValaUnresolvedSymbol* _tmp147_;
				_tmp141_ = type;
				_tmp142_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
				_tmp143_ = _tmp142_;
				_tmp144_ = string_substring (n, (glong) 1, (glong) -1);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_unresolved_symbol_new (_tmp143_, _tmp145_, NULL);
				_tmp147_ = _tmp146_;
				vala_unresolved_type_set_unresolved_symbol (_tmp141_, _tmp147_);
				_vala_code_node_unref0 (_tmp147_);
				_g_free0 (_tmp145_);
				_vala_code_node_unref0 (_tmp143_);
			} else {
				gchar** name_parts = NULL;
				gchar** _tmp148_;
				gchar** _tmp149_;
				gint name_parts_length1;
				gint _name_parts_size_;
				gchar** _tmp150_;
				gint _tmp150__length1;
				const gchar* _tmp151_;
				_tmp149_ = _tmp148_ = g_strsplit (n, ".", 2);
				name_parts = _tmp149_;
				name_parts_length1 = _vala_array_length (_tmp148_);
				_name_parts_size_ = name_parts_length1;
				_tmp150_ = name_parts;
				_tmp150__length1 = name_parts_length1;
				_tmp151_ = _tmp150_[1];
				if (_tmp151_ == NULL) {
					ValaUnresolvedType* _tmp152_;
					gchar** _tmp153_;
					gint _tmp153__length1;
					const gchar* _tmp154_;
					ValaUnresolvedSymbol* _tmp155_;
					ValaUnresolvedSymbol* _tmp156_;
					_tmp152_ = type;
					_tmp153_ = name_parts;
					_tmp153__length1 = name_parts_length1;
					_tmp154_ = _tmp153_[0];
					_tmp155_ = vala_unresolved_symbol_new (NULL, _tmp154_, NULL);
					_tmp156_ = _tmp155_;
					vala_unresolved_type_set_unresolved_symbol (_tmp152_, _tmp156_);
					_vala_code_node_unref0 (_tmp156_);
				} else {
					ValaUnresolvedType* _tmp157_;
					gchar** _tmp158_;
					gint _tmp158__length1;
					const gchar* _tmp159_;
					ValaUnresolvedSymbol* _tmp160_;
					ValaUnresolvedSymbol* _tmp161_;
					gchar** _tmp162_;
					gint _tmp162__length1;
					const gchar* _tmp163_;
					ValaUnresolvedSymbol* _tmp164_;
					ValaUnresolvedSymbol* _tmp165_;
					_tmp157_ = type;
					_tmp158_ = name_parts;
					_tmp158__length1 = name_parts_length1;
					_tmp159_ = _tmp158_[0];
					_tmp160_ = vala_unresolved_symbol_new (NULL, _tmp159_, NULL);
					_tmp161_ = _tmp160_;
					_tmp162_ = name_parts;
					_tmp162__length1 = name_parts_length1;
					_tmp163_ = _tmp162_[1];
					_tmp164_ = vala_unresolved_symbol_new (_tmp161_, _tmp163_, NULL);
					_tmp165_ = _tmp164_;
					vala_unresolved_type_set_unresolved_symbol (_tmp157_, _tmp165_);
					_vala_code_node_unref0 (_tmp165_);
					_vala_code_node_unref0 (_tmp161_);
				}
				name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = (ValaDataType*) type;
	_g_free0 (ns_name);
	type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (dt);
	return result;
}


static ValaDataType*
vala_gidl_parser_parse_param (ValaGIdlParser* self,
                              GIdlNodeParam* param,
                              ValaParameterDirection* direction)
{
	ValaParameterDirection _vala_direction = 0;
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	GIdlNodeType* _tmp0_;
	ValaParameterDirection _tmp1_ = 0;
	ValaDataType* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	_tmp0_ = param->type;
	_tmp2_ = vala_gidl_parser_parse_type (self, _tmp0_, &_tmp1_);
	_vala_direction = _tmp1_;
	type = _tmp2_;
	result = type;
	if (direction) {
		*direction = _vala_direction;
	}
	return result;
}


static ValaUnresolvedSymbol*
vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self,
                                           const gchar* symbol_string,
                                           ValaSourceReference* source_reference)
{
	ValaUnresolvedSymbol* result = NULL;
	ValaUnresolvedSymbol* sym = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	ValaUnresolvedSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_;
				const gchar* _tmp3_;
				ValaUnresolvedSymbol* _tmp4_;
				_tmp2_ = sym;
				_tmp3_ = s;
				_tmp4_ = vala_unresolved_symbol_new (_tmp2_, _tmp3_, source_reference);
				_vala_code_node_unref0 (sym);
				sym = _tmp4_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = sym;
	if (_tmp5_ == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gboolean
vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self,
                                                   ValaDataType* parent_type,
                                                   const gchar* type_arguments,
                                                   ValaSourceReference* source_reference)
{
	gboolean result = FALSE;
	gint type_arguments_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	GString* current = NULL;
	gint _tmp2_;
	GString* _tmp3_;
	gint depth = 0;
	ValaDataType* dt = NULL;
	GString* _tmp32_;
	const gchar* _tmp33_;
	ValaDataType* _tmp34_;
	ValaDataType* _tmp35_;
	ValaDataType* _tmp36_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	_tmp1_ = _tmp0_;
	type_arguments_length = (gint) _tmp1_;
	_tmp2_ = type_arguments_length;
	_tmp3_ = g_string_sized_new ((gsize) _tmp2_);
	current = _tmp3_;
	depth = 0;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				gboolean _tmp8_ = FALSE;
				gint _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = c;
					c = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = c;
				_tmp7_ = type_arguments_length;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp9_ = c;
				if (string_get (type_arguments, (glong) _tmp9_) == '<') {
					_tmp8_ = TRUE;
				} else {
					gint _tmp10_;
					_tmp10_ = c;
					_tmp8_ = string_get (type_arguments, (glong) _tmp10_) == '[';
				}
				if (_tmp8_) {
					gint _tmp11_;
					GString* _tmp12_;
					gint _tmp13_;
					_tmp11_ = depth;
					depth = _tmp11_ + 1;
					_tmp12_ = current;
					_tmp13_ = c;
					g_string_append_unichar (_tmp12_, (gunichar) string_get (type_arguments, (glong) _tmp13_));
				} else {
					gboolean _tmp14_ = FALSE;
					gint _tmp15_;
					_tmp15_ = c;
					if (string_get (type_arguments, (glong) _tmp15_) == '>') {
						_tmp14_ = TRUE;
					} else {
						gint _tmp16_;
						_tmp16_ = c;
						_tmp14_ = string_get (type_arguments, (glong) _tmp16_) == ']';
					}
					if (_tmp14_) {
						gint _tmp17_;
						GString* _tmp18_;
						gint _tmp19_;
						_tmp17_ = depth;
						depth = _tmp17_ - 1;
						_tmp18_ = current;
						_tmp19_ = c;
						g_string_append_unichar (_tmp18_, (gunichar) string_get (type_arguments, (glong) _tmp19_));
					} else {
						gint _tmp20_;
						_tmp20_ = c;
						if (string_get (type_arguments, (glong) _tmp20_) == ',') {
							gint _tmp21_;
							_tmp21_ = depth;
							if (_tmp21_ == 0) {
								ValaDataType* dt = NULL;
								GString* _tmp22_;
								const gchar* _tmp23_;
								ValaDataType* _tmp24_;
								ValaDataType* _tmp25_;
								ValaDataType* _tmp26_;
								GString* _tmp27_;
								_tmp22_ = current;
								_tmp23_ = _tmp22_->str;
								_tmp24_ = vala_gidl_parser_parse_type_from_string (self, _tmp23_, TRUE, source_reference);
								dt = _tmp24_;
								_tmp25_ = dt;
								if (_tmp25_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp26_ = dt;
								vala_data_type_add_type_argument (parent_type, _tmp26_);
								_tmp27_ = current;
								g_string_truncate (_tmp27_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp28_;
								gint _tmp29_;
								_tmp28_ = current;
								_tmp29_ = c;
								g_string_append_unichar (_tmp28_, (gunichar) string_get (type_arguments, (glong) _tmp29_));
							}
						} else {
							GString* _tmp30_;
							gint _tmp31_;
							_tmp30_ = current;
							_tmp31_ = c;
							g_string_append_unichar (_tmp30_, (gunichar) string_get (type_arguments, (glong) _tmp31_));
						}
					}
				}
			}
		}
	}
	_tmp32_ = current;
	_tmp33_ = _tmp32_->str;
	_tmp34_ = vala_gidl_parser_parse_type_from_string (self, _tmp33_, TRUE, source_reference);
	dt = _tmp34_;
	_tmp35_ = dt;
	if (_tmp35_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp36_ = dt;
	vala_data_type_add_type_argument (parent_type, _tmp36_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}


static ValaDataType*
vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self,
                                         const gchar* type_string,
                                         gboolean owned_by_default,
                                         ValaSourceReference* source_reference)
{
	ValaDataType* result = NULL;
	GRegex* _tmp0_;
	GMatchInfo* match = NULL;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	ValaDataType* type = NULL;
	gchar* ownership_data = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gchar* type_name = NULL;
	GMatchInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* type_arguments_data = NULL;
	GMatchInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* pointers_data = NULL;
	GMatchInfo* _tmp14_;
	gchar* _tmp15_;
	gchar* array_data = NULL;
	GMatchInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* array_dimension_data = NULL;
	GMatchInfo* _tmp18_;
	gchar* _tmp19_;
	gchar* nullable_data = NULL;
	GMatchInfo* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	gboolean nullable = FALSE;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	gboolean value_owned = FALSE;
	const gchar* _tmp43_;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp45_;
	ValaUnresolvedSymbol* _tmp46_;
	ValaUnresolvedSymbol* _tmp47_;
	ValaUnresolvedSymbol* _tmp48_;
	ValaUnresolvedType* _tmp49_;
	gboolean _tmp50_ = FALSE;
	const gchar* _tmp51_;
	const gchar* _tmp57_;
	gboolean _tmp66_ = FALSE;
	const gchar* _tmp67_;
	ValaDataType* _tmp77_;
	gboolean _tmp78_;
	ValaDataType* _tmp79_;
	gboolean _tmp80_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gidl_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[(," \
"*)?\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch2_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_gidl_parser_type_from_string_regex);
			vala_gidl_parser_type_from_string_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally2;
		__catch2_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e->message;
			g_error ("valagidlparser.vala:2131: Unable to compile regex: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = vala_gidl_parser_type_from_string_regex;
	_tmp7_ = g_regex_match (_tmp5_, type_string, 0, &_tmp6_);
	_g_match_info_unref0 (match);
	match = _tmp6_;
	if (!_tmp7_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_unref0 (match);
		return result;
	}
	type = NULL;
	_tmp8_ = match;
	_tmp9_ = g_match_info_fetch (_tmp8_, 1);
	ownership_data = _tmp9_;
	_tmp10_ = match;
	_tmp11_ = g_match_info_fetch (_tmp10_, 2);
	type_name = _tmp11_;
	_tmp12_ = match;
	_tmp13_ = g_match_info_fetch (_tmp12_, 3);
	type_arguments_data = _tmp13_;
	_tmp14_ = match;
	_tmp15_ = g_match_info_fetch (_tmp14_, 4);
	pointers_data = _tmp15_;
	_tmp16_ = match;
	_tmp17_ = g_match_info_fetch (_tmp16_, 5);
	array_data = _tmp17_;
	_tmp18_ = match;
	_tmp19_ = g_match_info_fetch (_tmp18_, 6);
	array_dimension_data = _tmp19_;
	_tmp20_ = match;
	_tmp21_ = g_match_info_fetch (_tmp20_, 7);
	nullable_data = _tmp21_;
	_tmp23_ = nullable_data;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp24_ = nullable_data;
		_tmp25_ = strlen (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp22_ = _tmp26_ > 0;
	} else {
		_tmp22_ = FALSE;
	}
	nullable = _tmp22_;
	_tmp28_ = ownership_data;
	if (_tmp28_ == NULL) {
		const gchar* _tmp29_;
		_tmp29_ = type_name;
		_tmp27_ = g_strcmp0 (_tmp29_, "void") == 0;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		_tmp31_ = array_data;
		if (_tmp31_ == NULL) {
			gboolean _tmp32_;
			_tmp32_ = nullable;
			_tmp30_ = !_tmp32_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			ValaVoidType* _tmp33_;
			const gchar* _tmp34_;
			_tmp33_ = vala_void_type_new (source_reference);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp33_;
			_tmp34_ = pointers_data;
			if (_tmp34_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp35_ = FALSE;
						_tmp35_ = TRUE;
						while (TRUE) {
							gint _tmp37_;
							const gchar* _tmp38_;
							gint _tmp39_;
							gint _tmp40_;
							ValaDataType* _tmp41_;
							ValaPointerType* _tmp42_;
							if (!_tmp35_) {
								gint _tmp36_;
								_tmp36_ = i;
								i = _tmp36_ + 1;
							}
							_tmp35_ = FALSE;
							_tmp37_ = i;
							_tmp38_ = pointers_data;
							_tmp39_ = strlen (_tmp38_);
							_tmp40_ = _tmp39_;
							if (!(_tmp37_ < _tmp40_)) {
								break;
							}
							_tmp41_ = type;
							_tmp42_ = vala_pointer_type_new (_tmp41_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp42_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_unref0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	_tmp43_ = ownership_data;
	if (g_strcmp0 (_tmp43_, "owned") == 0) {
		value_owned = TRUE;
	} else {
		const gchar* _tmp44_;
		_tmp44_ = ownership_data;
		if (g_strcmp0 (_tmp44_, "unowned") == 0) {
			value_owned = FALSE;
		}
	}
	_tmp45_ = type_name;
	_tmp46_ = vala_gidl_parser_parse_symbol_from_string (self, _tmp45_, source_reference);
	sym = _tmp46_;
	_tmp47_ = sym;
	if (_tmp47_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_dimension_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_unref0 (match);
		return result;
	}
	_tmp48_ = sym;
	_tmp49_ = vala_unresolved_type_new_from_symbol (_tmp48_, source_reference);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp49_;
	_tmp51_ = type_arguments_data;
	if (_tmp51_ != NULL) {
		const gchar* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		_tmp52_ = type_arguments_data;
		_tmp53_ = strlen (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp50_ = _tmp54_ > 0;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		ValaDataType* _tmp55_;
		const gchar* _tmp56_;
		_tmp55_ = type;
		_tmp56_ = type_arguments_data;
		if (!vala_gidl_parser_parse_type_arguments_from_string (self, _tmp55_, _tmp56_, source_reference)) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp57_ = pointers_data;
	if (_tmp57_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp58_ = FALSE;
				_tmp58_ = TRUE;
				while (TRUE) {
					gint _tmp60_;
					const gchar* _tmp61_;
					gint _tmp62_;
					gint _tmp63_;
					ValaDataType* _tmp64_;
					ValaPointerType* _tmp65_;
					if (!_tmp58_) {
						gint _tmp59_;
						_tmp59_ = i;
						i = _tmp59_ + 1;
					}
					_tmp58_ = FALSE;
					_tmp60_ = i;
					_tmp61_ = pointers_data;
					_tmp62_ = strlen (_tmp61_);
					_tmp63_ = _tmp62_;
					if (!(_tmp60_ < _tmp63_)) {
						break;
					}
					_tmp64_ = type;
					_tmp65_ = vala_pointer_type_new (_tmp64_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp65_;
				}
			}
		}
	}
	_tmp67_ = array_data;
	if (_tmp67_ != NULL) {
		const gchar* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		_tmp68_ = array_data;
		_tmp69_ = strlen (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp66_ = _tmp70_ > 0;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		const gchar* _tmp73_;
		gint _tmp74_;
		gint _tmp75_;
		ValaArrayType* _tmp76_;
		_tmp71_ = type;
		vala_data_type_set_value_owned (_tmp71_, TRUE);
		_tmp72_ = type;
		_tmp73_ = array_dimension_data;
		_tmp74_ = strlen (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_array_type_new (_tmp72_, _tmp75_ + 1, source_reference);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp76_;
	}
	_tmp77_ = type;
	_tmp78_ = nullable;
	vala_data_type_set_nullable (_tmp77_, _tmp78_);
	_tmp79_ = type;
	_tmp80_ = value_owned;
	vala_data_type_set_value_owned (_tmp79_, _tmp80_);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_dimension_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_unref0 (match);
	return result;
}


static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar* * unparsed)
{
	gint64 _vala_result = 0LL;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, (guint) 0);
	endptr = _tmp0_;
	_vala_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}


static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar* * unparsed)
{
	gdouble _vala_result = 0.0;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}


static ValaMethod*
vala_gidl_parser_create_method (ValaGIdlParser* self,
                                const gchar* name,
                                const gchar* symbol,
                                GIdlNodeParam* res,
                                GList* parameters,
                                gboolean is_constructor,
                                gboolean is_interface)
{
	ValaMethod* result = NULL;
	ValaDataType* return_type = NULL;
	ValaMethod* m = NULL;
	gboolean _tmp1_ = FALSE;
	ValaMethod* _tmp37_;
	ValaSet* _tmp38_;
	ValaTypeSymbol* _tmp40_;
	gboolean add_ellipsis = FALSE;
	gboolean suppress_throws = FALSE;
	gchar* error_types = NULL;
	ValaSymbol* container = NULL;
	gchar** attributes = NULL;
	gint _tmp62_ = 0;
	gchar** _tmp63_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	gboolean first = FALSE;
	ValaParameter* last_param = NULL;
	ValaDataType* last_param_type = NULL;
	gboolean _tmp759_ = FALSE;
	gboolean _tmp760_;
	gboolean _tmp773_;
	gboolean _tmp775_ = FALSE;
	ValaParameter* _tmp776_;
	ValaSymbol* _tmp785_;
	ValaMethod* _tmp791_;
	ValaSymbol* _tmp792_;
	gchar* _tmp793_;
	gchar* _tmp794_;
	gboolean _tmp795_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	return_type = NULL;
	if (res != NULL) {
		ValaDataType* _tmp0_;
		_tmp0_ = vala_gidl_parser_parse_param (self, res, NULL);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp0_;
	}
	if (!is_interface) {
		gboolean _tmp2_ = FALSE;
		if (is_constructor) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = g_str_has_prefix (name, "new");
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaSourceReference* _tmp3_;
		ValaCreationMethod* _tmp4_;
		ValaMethod* _tmp5_;
		ValaMethod* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp21_ = FALSE;
		ValaTypeSymbol* _tmp22_;
		_tmp3_ = self->priv->current_source_reference;
		_tmp4_ = vala_creation_method_new (NULL, name, _tmp3_, NULL);
		_vala_code_node_unref0 (m);
		m = (ValaMethod*) _tmp4_;
		_tmp5_ = m;
		vala_method_set_has_construct_function (_tmp5_, FALSE);
		_tmp6_ = m;
		_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (g_strcmp0 (_tmp8_, "new") == 0) {
			ValaMethod* _tmp9_;
			_tmp9_ = m;
			vala_symbol_set_name ((ValaSymbol*) _tmp9_, NULL);
		} else {
			ValaMethod* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = m;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (g_str_has_prefix (_tmp12_, "new_")) {
				ValaMethod* _tmp13_;
				ValaMethod* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp13_ = m;
				_tmp14_ = m;
				_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = strlen ("new_");
				_tmp18_ = _tmp17_;
				_tmp19_ = string_substring (_tmp16_, (glong) _tmp18_, (glong) -1);
				_tmp20_ = _tmp19_;
				vala_symbol_set_name ((ValaSymbol*) _tmp13_, _tmp20_);
				_g_free0 (_tmp20_);
			}
		}
		_tmp22_ = self->priv->current_data_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_CLASS)) {
			_tmp21_ = res != NULL;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			ValaTypeSymbol* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			GIdlNodeType* _tmp28_;
			const gchar* _tmp29_;
			gboolean _tmp30_;
			_tmp23_ = self->priv->current_data_type;
			_tmp24_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup_printf ("%s*", _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = res->type;
			_tmp29_ = _tmp28_->unparsed;
			_tmp30_ = g_strcmp0 (_tmp27_, _tmp29_) != 0;
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			if (_tmp30_) {
				ValaMethod* _tmp31_;
				GIdlNodeType* _tmp32_;
				const gchar* _tmp33_;
				_tmp31_ = m;
				_tmp32_ = res->type;
				_tmp33_ = _tmp32_->unparsed;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp31_, "CCode", "type", _tmp33_, NULL);
			}
		}
	} else {
		ValaDataType* _tmp34_;
		ValaSourceReference* _tmp35_;
		ValaMethod* _tmp36_;
		_tmp34_ = return_type;
		_tmp35_ = self->priv->current_source_reference;
		_tmp36_ = vala_method_new (name, _tmp34_, _tmp35_, NULL);
		_vala_code_node_unref0 (m);
		m = _tmp36_;
	}
	_tmp37_ = m;
	vala_symbol_set_access ((ValaSymbol*) _tmp37_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp38_ = self->priv->current_type_symbol_set;
	if (_tmp38_ != NULL) {
		ValaSet* _tmp39_;
		_tmp39_ = self->priv->current_type_symbol_set;
		vala_collection_add ((ValaCollection*) _tmp39_, name);
	}
	_tmp40_ = self->priv->current_data_type;
	if (_tmp40_ != NULL) {
		gchar** sig_attributes = NULL;
		ValaTypeSymbol* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gint _tmp46_ = 0;
		gchar** _tmp47_;
		gchar** _tmp48_;
		gint _tmp48__length1;
		gint sig_attributes_length1;
		gint _sig_attributes_size_;
		gchar** _tmp49_;
		gint _tmp49__length1;
		_tmp41_ = self->priv->current_data_type;
		_tmp42_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp41_, NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf ("%s::%s", _tmp43_, name);
		_tmp45_ = _tmp44_;
		_tmp47_ = vala_gidl_parser_get_attributes (self, _tmp45_, &_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp48__length1 = _tmp46_;
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		sig_attributes = _tmp48_;
		sig_attributes_length1 = _tmp48__length1;
		_sig_attributes_size_ = sig_attributes_length1;
		_tmp49_ = sig_attributes;
		_tmp49__length1 = sig_attributes_length1;
		if (_tmp49_ != NULL) {
			gchar** _tmp50_;
			gint _tmp50__length1;
			_tmp50_ = sig_attributes;
			_tmp50__length1 = sig_attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp50_;
				attr_collection_length1 = _tmp50__length1;
				for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
					gchar* _tmp51_;
					gchar* attr = NULL;
					_tmp51_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp51_;
					{
						gchar** nv = NULL;
						const gchar* _tmp52_;
						gchar** _tmp53_;
						gchar** _tmp54_;
						gint nv_length1;
						gint _nv_size_;
						gboolean _tmp55_ = FALSE;
						gchar** _tmp56_;
						gint _tmp56__length1;
						const gchar* _tmp57_;
						_tmp52_ = attr;
						_tmp54_ = _tmp53_ = g_strsplit (_tmp52_, "=", 2);
						nv = _tmp54_;
						nv_length1 = _vala_array_length (_tmp53_);
						_nv_size_ = nv_length1;
						_tmp56_ = nv;
						_tmp56__length1 = nv_length1;
						_tmp57_ = _tmp56_[0];
						if (g_strcmp0 (_tmp57_, "has_emitter") == 0) {
							gchar** _tmp58_;
							gint _tmp58__length1;
							const gchar* _tmp59_;
							gchar* _tmp60_;
							gchar* _tmp61_;
							_tmp58_ = nv;
							_tmp58__length1 = nv_length1;
							_tmp59_ = _tmp58_[1];
							_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
							_tmp61_ = _tmp60_;
							_tmp55_ = g_strcmp0 (_tmp61_, "1") == 0;
							_g_free0 (_tmp61_);
						} else {
							_tmp55_ = FALSE;
						}
						if (_tmp55_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (return_type);
							return result;
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	add_ellipsis = FALSE;
	suppress_throws = FALSE;
	error_types = NULL;
	container = NULL;
	_tmp63_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp62_);
	attributes = _tmp63_;
	attributes_length1 = _tmp62_;
	_attributes_size_ = attributes_length1;
	_tmp64_ = attributes;
	_tmp64__length1 = attributes_length1;
	if (_tmp64_ != NULL) {
		gchar** _tmp65_;
		gint _tmp65__length1;
		_tmp65_ = attributes;
		_tmp65__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp65_;
			attr_collection_length1 = _tmp65__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp66_;
				gchar* attr = NULL;
				_tmp66_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp66_;
				{
					gchar** nv = NULL;
					const gchar* _tmp67_;
					gchar** _tmp68_;
					gchar** _tmp69_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp70_;
					gint _tmp70__length1;
					const gchar* _tmp71_;
					_tmp67_ = attr;
					_tmp69_ = _tmp68_ = g_strsplit (_tmp67_, "=", 2);
					nv = _tmp69_;
					nv_length1 = _vala_array_length (_tmp68_);
					_nv_size_ = nv_length1;
					_tmp70_ = nv;
					_tmp70__length1 = nv_length1;
					_tmp71_ = _tmp70_[0];
					if (g_strcmp0 (_tmp71_, "name") == 0) {
						ValaMethod* _tmp72_;
						gchar** _tmp73_;
						gint _tmp73__length1;
						const gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						_tmp72_ = m;
						_tmp73_ = nv;
						_tmp73__length1 = nv_length1;
						_tmp74_ = _tmp73_[1];
						_tmp75_ = vala_gidl_parser_eval (self, _tmp74_);
						_tmp76_ = _tmp75_;
						vala_symbol_set_name ((ValaSymbol*) _tmp72_, _tmp76_);
						_g_free0 (_tmp76_);
					} else {
						gchar** _tmp77_;
						gint _tmp77__length1;
						const gchar* _tmp78_;
						_tmp77_ = nv;
						_tmp77__length1 = nv_length1;
						_tmp78_ = _tmp77_[0];
						if (g_strcmp0 (_tmp78_, "hidden") == 0) {
							gchar** _tmp79_;
							gint _tmp79__length1;
							const gchar* _tmp80_;
							gchar* _tmp81_;
							gchar* _tmp82_;
							gboolean _tmp83_;
							_tmp79_ = nv;
							_tmp79__length1 = nv_length1;
							_tmp80_ = _tmp79_[1];
							_tmp81_ = vala_gidl_parser_eval (self, _tmp80_);
							_tmp82_ = _tmp81_;
							_tmp83_ = g_strcmp0 (_tmp82_, "1") == 0;
							_g_free0 (_tmp82_);
							if (_tmp83_) {
								result = NULL;
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								_vala_code_node_unref0 (container);
								_g_free0 (error_types);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (return_type);
								return result;
							}
						} else {
							gchar** _tmp84_;
							gint _tmp84__length1;
							const gchar* _tmp85_;
							_tmp84_ = nv;
							_tmp84__length1 = nv_length1;
							_tmp85_ = _tmp84_[0];
							if (g_strcmp0 (_tmp85_, "ellipsis") == 0) {
								gchar** _tmp86_;
								gint _tmp86__length1;
								const gchar* _tmp87_;
								gchar* _tmp88_;
								gchar* _tmp89_;
								gboolean _tmp90_;
								_tmp86_ = nv;
								_tmp86__length1 = nv_length1;
								_tmp87_ = _tmp86_[1];
								_tmp88_ = vala_gidl_parser_eval (self, _tmp87_);
								_tmp89_ = _tmp88_;
								_tmp90_ = g_strcmp0 (_tmp89_, "1") == 0;
								_g_free0 (_tmp89_);
								if (_tmp90_) {
									add_ellipsis = TRUE;
								}
							} else {
								gchar** _tmp91_;
								gint _tmp91__length1;
								const gchar* _tmp92_;
								_tmp91_ = nv;
								_tmp91__length1 = nv_length1;
								_tmp92_ = _tmp91_[0];
								if (g_strcmp0 (_tmp92_, "printf_format") == 0) {
									gchar** _tmp93_;
									gint _tmp93__length1;
									const gchar* _tmp94_;
									gchar* _tmp95_;
									gchar* _tmp96_;
									gboolean _tmp97_;
									_tmp93_ = nv;
									_tmp93__length1 = nv_length1;
									_tmp94_ = _tmp93_[1];
									_tmp95_ = vala_gidl_parser_eval (self, _tmp94_);
									_tmp96_ = _tmp95_;
									_tmp97_ = g_strcmp0 (_tmp96_, "1") == 0;
									_g_free0 (_tmp96_);
									if (_tmp97_) {
										ValaMethod* _tmp98_;
										_tmp98_ = m;
										vala_code_node_set_attribute ((ValaCodeNode*) _tmp98_, "PrintfFormat", TRUE, NULL);
									}
								} else {
									gchar** _tmp99_;
									gint _tmp99__length1;
									const gchar* _tmp100_;
									_tmp99_ = nv;
									_tmp99__length1 = nv_length1;
									_tmp100_ = _tmp99_[0];
									if (g_strcmp0 (_tmp100_, "transfer_ownership") == 0) {
										gchar** _tmp101_;
										gint _tmp101__length1;
										const gchar* _tmp102_;
										gchar* _tmp103_;
										gchar* _tmp104_;
										gboolean _tmp105_;
										_tmp101_ = nv;
										_tmp101__length1 = nv_length1;
										_tmp102_ = _tmp101_[1];
										_tmp103_ = vala_gidl_parser_eval (self, _tmp102_);
										_tmp104_ = _tmp103_;
										_tmp105_ = g_strcmp0 (_tmp104_, "1") == 0;
										_g_free0 (_tmp104_);
										if (_tmp105_) {
											ValaDataType* _tmp106_;
											_tmp106_ = return_type;
											vala_data_type_set_value_owned (_tmp106_, TRUE);
										}
									} else {
										gchar** _tmp107_;
										gint _tmp107__length1;
										const gchar* _tmp108_;
										_tmp107_ = nv;
										_tmp107__length1 = nv_length1;
										_tmp108_ = _tmp107_[0];
										if (g_strcmp0 (_tmp108_, "transfer_container") == 0) {
											gchar** _tmp109_;
											gint _tmp109__length1;
											const gchar* _tmp110_;
											gchar* _tmp111_;
											gchar* _tmp112_;
											gboolean _tmp113_;
											_tmp109_ = nv;
											_tmp109__length1 = nv_length1;
											_tmp110_ = _tmp109_[1];
											_tmp111_ = vala_gidl_parser_eval (self, _tmp110_);
											_tmp112_ = _tmp111_;
											_tmp113_ = g_strcmp0 (_tmp112_, "1") == 0;
											_g_free0 (_tmp112_);
											if (_tmp113_) {
												ValaDataType* _tmp114_;
												ValaDataType* _tmp115_;
												_tmp114_ = return_type;
												vala_data_type_set_value_owned (_tmp114_, TRUE);
												_tmp115_ = return_type;
												if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, VALA_TYPE_ARRAY_TYPE)) {
													ValaDataType* _tmp116_;
													ValaDataType* _tmp117_;
													ValaDataType* _tmp118_;
													_tmp116_ = return_type;
													_tmp117_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
													_tmp118_ = _tmp117_;
													vala_data_type_set_value_owned (_tmp118_, FALSE);
												}
											}
										} else {
											gchar** _tmp119_;
											gint _tmp119__length1;
											const gchar* _tmp120_;
											_tmp119_ = nv;
											_tmp119__length1 = nv_length1;
											_tmp120_ = _tmp119_[0];
											if (g_strcmp0 (_tmp120_, "destroys_instance") == 0) {
												gchar** _tmp121_;
												gint _tmp121__length1;
												const gchar* _tmp122_;
												gchar* _tmp123_;
												gchar* _tmp124_;
												gboolean _tmp125_;
												_tmp121_ = nv;
												_tmp121__length1 = nv_length1;
												_tmp122_ = _tmp121_[1];
												_tmp123_ = vala_gidl_parser_eval (self, _tmp122_);
												_tmp124_ = _tmp123_;
												_tmp125_ = g_strcmp0 (_tmp124_, "1") == 0;
												_g_free0 (_tmp124_);
												if (_tmp125_) {
													ValaMethod* _tmp126_;
													ValaMethod* _tmp127_;
													ValaSourceReference* _tmp128_;
													ValaSourceReference* _tmp129_;
													_tmp126_ = m;
													_tmp127_ = m;
													_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp127_);
													_tmp129_ = _tmp128_;
													vala_code_node_set_attribute ((ValaCodeNode*) _tmp126_, "DestroysInstance", TRUE, _tmp129_);
												}
											} else {
												gchar** _tmp130_;
												gint _tmp130__length1;
												const gchar* _tmp131_;
												_tmp130_ = nv;
												_tmp130__length1 = nv_length1;
												_tmp131_ = _tmp130_[0];
												if (g_strcmp0 (_tmp131_, "returns_floating_reference") == 0) {
													gchar** _tmp132_;
													gint _tmp132__length1;
													const gchar* _tmp133_;
													gchar* _tmp134_;
													gchar* _tmp135_;
													gboolean _tmp136_;
													_tmp132_ = nv;
													_tmp132__length1 = nv_length1;
													_tmp133_ = _tmp132_[1];
													_tmp134_ = vala_gidl_parser_eval (self, _tmp133_);
													_tmp135_ = _tmp134_;
													_tmp136_ = g_strcmp0 (_tmp135_, "1") == 0;
													_g_free0 (_tmp135_);
													if (_tmp136_) {
														ValaMethod* _tmp137_;
														ValaMethod* _tmp138_;
														ValaDataType* _tmp139_;
														ValaDataType* _tmp140_;
														_tmp137_ = m;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp137_, "CCode", "returns_floating_reference", TRUE, NULL);
														_tmp138_ = m;
														_tmp139_ = vala_callable_get_return_type ((ValaCallable*) _tmp138_);
														_tmp140_ = _tmp139_;
														vala_data_type_set_value_owned (_tmp140_, TRUE);
													}
												} else {
													gchar** _tmp141_;
													gint _tmp141__length1;
													const gchar* _tmp142_;
													_tmp141_ = nv;
													_tmp141__length1 = nv_length1;
													_tmp142_ = _tmp141_[0];
													if (g_strcmp0 (_tmp142_, "nullable") == 0) {
														gboolean _tmp143_ = FALSE;
														gchar** _tmp144_;
														gint _tmp144__length1;
														const gchar* _tmp145_;
														gchar* _tmp146_;
														gchar* _tmp147_;
														gboolean _tmp148_;
														_tmp144_ = nv;
														_tmp144__length1 = nv_length1;
														_tmp145_ = _tmp144_[1];
														_tmp146_ = vala_gidl_parser_eval (self, _tmp145_);
														_tmp147_ = _tmp146_;
														_tmp148_ = g_strcmp0 (_tmp147_, "1") == 0;
														_g_free0 (_tmp147_);
														if (_tmp148_) {
															ValaDataType* _tmp149_;
															_tmp149_ = return_type;
															_tmp143_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp149_, VALA_TYPE_VOID_TYPE);
														} else {
															_tmp143_ = FALSE;
														}
														if (_tmp143_) {
															ValaDataType* _tmp150_;
															_tmp150_ = return_type;
															vala_data_type_set_nullable (_tmp150_, TRUE);
														}
													} else {
														gchar** _tmp151_;
														gint _tmp151__length1;
														const gchar* _tmp152_;
														_tmp151_ = nv;
														_tmp151__length1 = nv_length1;
														_tmp152_ = _tmp151_[0];
														if (g_strcmp0 (_tmp152_, "sentinel") == 0) {
															ValaMethod* _tmp153_;
															gchar** _tmp154_;
															gint _tmp154__length1;
															const gchar* _tmp155_;
															gchar* _tmp156_;
															gchar* _tmp157_;
															_tmp153_ = m;
															_tmp154_ = nv;
															_tmp154__length1 = nv_length1;
															_tmp155_ = _tmp154_[1];
															_tmp156_ = vala_gidl_parser_eval (self, _tmp155_);
															_tmp157_ = _tmp156_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp153_, "CCode", "sentinel", _tmp157_, NULL);
															_g_free0 (_tmp157_);
														} else {
															gchar** _tmp158_;
															gint _tmp158__length1;
															const gchar* _tmp159_;
															_tmp158_ = nv;
															_tmp158__length1 = nv_length1;
															_tmp159_ = _tmp158_[0];
															if (g_strcmp0 (_tmp159_, "is_array") == 0) {
																gchar** _tmp160_;
																gint _tmp160__length1;
																const gchar* _tmp161_;
																gchar* _tmp162_;
																gchar* _tmp163_;
																gboolean _tmp164_;
																_tmp160_ = nv;
																_tmp160__length1 = nv_length1;
																_tmp161_ = _tmp160_[1];
																_tmp162_ = vala_gidl_parser_eval (self, _tmp161_);
																_tmp163_ = _tmp162_;
																_tmp164_ = g_strcmp0 (_tmp163_, "1") == 0;
																_g_free0 (_tmp163_);
																if (_tmp164_) {
																	ValaDataType* _tmp165_;
																	ValaDataType* _tmp166_;
																	ValaDataType* _tmp167_;
																	ValaSourceReference* _tmp168_;
																	ValaSourceReference* _tmp169_;
																	ValaArrayType* _tmp170_;
																	ValaMethod* _tmp171_;
																	ValaDataType* _tmp172_;
																	_tmp165_ = return_type;
																	vala_data_type_set_value_owned (_tmp165_, TRUE);
																	_tmp166_ = return_type;
																	_tmp167_ = return_type;
																	_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp167_);
																	_tmp169_ = _tmp168_;
																	_tmp170_ = vala_array_type_new (_tmp166_, 1, _tmp169_);
																	_vala_code_node_unref0 (return_type);
																	return_type = (ValaDataType*) _tmp170_;
																	_tmp171_ = m;
																	_tmp172_ = return_type;
																	vala_callable_set_return_type ((ValaCallable*) _tmp171_, _tmp172_);
																}
															} else {
																gchar** _tmp173_;
																gint _tmp173__length1;
																const gchar* _tmp174_;
																_tmp173_ = nv;
																_tmp173__length1 = nv_length1;
																_tmp174_ = _tmp173_[0];
																if (g_strcmp0 (_tmp174_, "is_pointer") == 0) {
																	gchar** _tmp175_;
																	gint _tmp175__length1;
																	const gchar* _tmp176_;
																	gchar* _tmp177_;
																	gchar* _tmp178_;
																	gboolean _tmp179_;
																	_tmp175_ = nv;
																	_tmp175__length1 = nv_length1;
																	_tmp176_ = _tmp175_[1];
																	_tmp177_ = vala_gidl_parser_eval (self, _tmp176_);
																	_tmp178_ = _tmp177_;
																	_tmp179_ = g_strcmp0 (_tmp178_, "1") == 0;
																	_g_free0 (_tmp178_);
																	if (_tmp179_) {
																		ValaDataType* _tmp180_;
																		ValaDataType* _tmp181_;
																		ValaSourceReference* _tmp182_;
																		ValaSourceReference* _tmp183_;
																		ValaPointerType* _tmp184_;
																		ValaMethod* _tmp185_;
																		ValaDataType* _tmp186_;
																		_tmp180_ = return_type;
																		_tmp181_ = return_type;
																		_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp181_);
																		_tmp183_ = _tmp182_;
																		_tmp184_ = vala_pointer_type_new (_tmp180_, _tmp183_);
																		_vala_code_node_unref0 (return_type);
																		return_type = (ValaDataType*) _tmp184_;
																		_tmp185_ = m;
																		_tmp186_ = return_type;
																		vala_callable_set_return_type ((ValaCallable*) _tmp185_, _tmp186_);
																	}
																} else {
																	gchar** _tmp187_;
																	gint _tmp187__length1;
																	const gchar* _tmp188_;
																	_tmp187_ = nv;
																	_tmp187__length1 = nv_length1;
																	_tmp188_ = _tmp187_[0];
																	if (g_strcmp0 (_tmp188_, "throws") == 0) {
																		gchar** _tmp189_;
																		gint _tmp189__length1;
																		const gchar* _tmp190_;
																		gchar* _tmp191_;
																		gchar* _tmp192_;
																		gboolean _tmp193_;
																		_tmp189_ = nv;
																		_tmp189__length1 = nv_length1;
																		_tmp190_ = _tmp189_[1];
																		_tmp191_ = vala_gidl_parser_eval (self, _tmp190_);
																		_tmp192_ = _tmp191_;
																		_tmp193_ = g_strcmp0 (_tmp192_, "0") == 0;
																		_g_free0 (_tmp192_);
																		if (_tmp193_) {
																			suppress_throws = TRUE;
																		}
																	} else {
																		gchar** _tmp194_;
																		gint _tmp194__length1;
																		const gchar* _tmp195_;
																		_tmp194_ = nv;
																		_tmp194__length1 = nv_length1;
																		_tmp195_ = _tmp194_[0];
																		if (g_strcmp0 (_tmp195_, "error_types") == 0) {
																			gchar** _tmp196_;
																			gint _tmp196__length1;
																			const gchar* _tmp197_;
																			gchar* _tmp198_;
																			_tmp196_ = nv;
																			_tmp196__length1 = nv_length1;
																			_tmp197_ = _tmp196_[1];
																			_tmp198_ = vala_gidl_parser_eval (self, _tmp197_);
																			_g_free0 (error_types);
																			error_types = _tmp198_;
																		} else {
																			gchar** _tmp199_;
																			gint _tmp199__length1;
																			const gchar* _tmp200_;
																			_tmp199_ = nv;
																			_tmp199__length1 = nv_length1;
																			_tmp200_ = _tmp199_[0];
																			if (g_strcmp0 (_tmp200_, "no_array_length") == 0) {
																				gchar** _tmp201_;
																				gint _tmp201__length1;
																				const gchar* _tmp202_;
																				gchar* _tmp203_;
																				gchar* _tmp204_;
																				gboolean _tmp205_;
																				_tmp201_ = nv;
																				_tmp201__length1 = nv_length1;
																				_tmp202_ = _tmp201_[1];
																				_tmp203_ = vala_gidl_parser_eval (self, _tmp202_);
																				_tmp204_ = _tmp203_;
																				_tmp205_ = g_strcmp0 (_tmp204_, "1") == 0;
																				_g_free0 (_tmp204_);
																				if (_tmp205_) {
																					ValaMethod* _tmp206_;
																					_tmp206_ = m;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp206_, "CCode", "array_length", FALSE, NULL);
																				}
																			} else {
																				gchar** _tmp207_;
																				gint _tmp207__length1;
																				const gchar* _tmp208_;
																				_tmp207_ = nv;
																				_tmp207__length1 = nv_length1;
																				_tmp208_ = _tmp207_[0];
																				if (g_strcmp0 (_tmp208_, "array_null_terminated") == 0) {
																					gchar** _tmp209_;
																					gint _tmp209__length1;
																					const gchar* _tmp210_;
																					gchar* _tmp211_;
																					gchar* _tmp212_;
																					gboolean _tmp213_;
																					_tmp209_ = nv;
																					_tmp209__length1 = nv_length1;
																					_tmp210_ = _tmp209_[1];
																					_tmp211_ = vala_gidl_parser_eval (self, _tmp210_);
																					_tmp212_ = _tmp211_;
																					_tmp213_ = g_strcmp0 (_tmp212_, "1") == 0;
																					_g_free0 (_tmp212_);
																					if (_tmp213_) {
																						ValaMethod* _tmp214_;
																						ValaMethod* _tmp215_;
																						_tmp214_ = m;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp214_, "CCode", "array_length", FALSE, NULL);
																						_tmp215_ = m;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp215_, "CCode", "array_null_terminated", TRUE, NULL);
																					}
																				} else {
																					gchar** _tmp216_;
																					gint _tmp216__length1;
																					const gchar* _tmp217_;
																					_tmp216_ = nv;
																					_tmp216__length1 = nv_length1;
																					_tmp217_ = _tmp216_[0];
																					if (g_strcmp0 (_tmp217_, "array_length_type") == 0) {
																						ValaMethod* _tmp218_;
																						gchar** _tmp219_;
																						gint _tmp219__length1;
																						const gchar* _tmp220_;
																						gchar* _tmp221_;
																						gchar* _tmp222_;
																						_tmp218_ = m;
																						_tmp219_ = nv;
																						_tmp219__length1 = nv_length1;
																						_tmp220_ = _tmp219_[1];
																						_tmp221_ = vala_gidl_parser_eval (self, _tmp220_);
																						_tmp222_ = _tmp221_;
																						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp218_, "CCode", "array_length_type", _tmp222_, NULL);
																						_g_free0 (_tmp222_);
																					} else {
																						gchar** _tmp223_;
																						gint _tmp223__length1;
																						const gchar* _tmp224_;
																						_tmp223_ = nv;
																						_tmp223__length1 = nv_length1;
																						_tmp224_ = _tmp223_[0];
																						if (g_strcmp0 (_tmp224_, "type_name") == 0) {
																							ValaMethod* _tmp225_;
																							gchar** _tmp226_;
																							gint _tmp226__length1;
																							const gchar* _tmp227_;
																							gchar* _tmp228_;
																							gchar* _tmp229_;
																							ValaDataType* _tmp230_;
																							gboolean _tmp231_;
																							gboolean _tmp232_;
																							ValaDataType* _tmp233_;
																							ValaDataType* _tmp234_;
																							_tmp225_ = m;
																							_tmp226_ = nv;
																							_tmp226__length1 = nv_length1;
																							_tmp227_ = _tmp226_[1];
																							_tmp228_ = vala_gidl_parser_eval (self, _tmp227_);
																							_tmp229_ = _tmp228_;
																							_tmp230_ = return_type;
																							_tmp231_ = vala_data_type_get_value_owned (_tmp230_);
																							_tmp232_ = _tmp231_;
																							_tmp233_ = vala_gidl_parser_parse_type_from_string (self, _tmp229_, _tmp232_, NULL);
																							_vala_code_node_unref0 (return_type);
																							return_type = _tmp233_;
																							_tmp234_ = return_type;
																							vala_callable_set_return_type ((ValaCallable*) _tmp225_, _tmp234_);
																							_g_free0 (_tmp229_);
																						} else {
																							gchar** _tmp235_;
																							gint _tmp235__length1;
																							const gchar* _tmp236_;
																							_tmp235_ = nv;
																							_tmp235__length1 = nv_length1;
																							_tmp236_ = _tmp235_[0];
																							if (g_strcmp0 (_tmp236_, "ctype") == 0) {
																								ValaMethod* _tmp237_;
																								gchar** _tmp238_;
																								gint _tmp238__length1;
																								const gchar* _tmp239_;
																								gchar* _tmp240_;
																								gchar* _tmp241_;
																								_tmp237_ = m;
																								_tmp238_ = nv;
																								_tmp238__length1 = nv_length1;
																								_tmp239_ = _tmp238_[1];
																								_tmp240_ = vala_gidl_parser_eval (self, _tmp239_);
																								_tmp241_ = _tmp240_;
																								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp237_, "CCode", "type", _tmp241_, NULL);
																								_g_free0 (_tmp241_);
																							} else {
																								gchar** _tmp242_;
																								gint _tmp242__length1;
																								const gchar* _tmp243_;
																								_tmp242_ = nv;
																								_tmp242__length1 = nv_length1;
																								_tmp243_ = _tmp242_[0];
																								if (g_strcmp0 (_tmp243_, "type_arguments") == 0) {
																									ValaDataType* _tmp244_;
																									gchar** _tmp245_;
																									gint _tmp245__length1;
																									const gchar* _tmp246_;
																									gchar* _tmp247_;
																									gchar* _tmp248_;
																									_tmp244_ = return_type;
																									_tmp245_ = nv;
																									_tmp245__length1 = nv_length1;
																									_tmp246_ = _tmp245_[1];
																									_tmp247_ = vala_gidl_parser_eval (self, _tmp246_);
																									_tmp248_ = _tmp247_;
																									vala_gidl_parser_parse_type_arguments_from_string (self, _tmp244_, _tmp248_, NULL);
																									_g_free0 (_tmp248_);
																								} else {
																									gchar** _tmp249_;
																									gint _tmp249__length1;
																									const gchar* _tmp250_;
																									_tmp249_ = nv;
																									_tmp249__length1 = nv_length1;
																									_tmp250_ = _tmp249_[0];
																									if (g_strcmp0 (_tmp250_, "deprecated") == 0) {
																										gchar** _tmp251_;
																										gint _tmp251__length1;
																										const gchar* _tmp252_;
																										gchar* _tmp253_;
																										gchar* _tmp254_;
																										gboolean _tmp255_;
																										_tmp251_ = nv;
																										_tmp251__length1 = nv_length1;
																										_tmp252_ = _tmp251_[1];
																										_tmp253_ = vala_gidl_parser_eval (self, _tmp252_);
																										_tmp254_ = _tmp253_;
																										_tmp255_ = g_strcmp0 (_tmp254_, "1") == 0;
																										_g_free0 (_tmp254_);
																										if (_tmp255_) {
																											ValaMethod* _tmp256_;
																											_tmp256_ = m;
																											vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp256_, "Version", "deprecated", TRUE, NULL);
																										}
																									} else {
																										gchar** _tmp257_;
																										gint _tmp257__length1;
																										const gchar* _tmp258_;
																										_tmp257_ = nv;
																										_tmp257__length1 = nv_length1;
																										_tmp258_ = _tmp257_[0];
																										if (g_strcmp0 (_tmp258_, "replacement") == 0) {
																											ValaMethod* _tmp259_;
																											gchar** _tmp260_;
																											gint _tmp260__length1;
																											const gchar* _tmp261_;
																											gchar* _tmp262_;
																											gchar* _tmp263_;
																											_tmp259_ = m;
																											_tmp260_ = nv;
																											_tmp260__length1 = nv_length1;
																											_tmp261_ = _tmp260_[1];
																											_tmp262_ = vala_gidl_parser_eval (self, _tmp261_);
																											_tmp263_ = _tmp262_;
																											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp259_, "Version", "replacement", _tmp263_, NULL);
																											_g_free0 (_tmp263_);
																										} else {
																											gchar** _tmp264_;
																											gint _tmp264__length1;
																											const gchar* _tmp265_;
																											_tmp264_ = nv;
																											_tmp264__length1 = nv_length1;
																											_tmp265_ = _tmp264_[0];
																											if (g_strcmp0 (_tmp265_, "deprecated_since") == 0) {
																												ValaMethod* _tmp266_;
																												gchar** _tmp267_;
																												gint _tmp267__length1;
																												const gchar* _tmp268_;
																												gchar* _tmp269_;
																												gchar* _tmp270_;
																												_tmp266_ = m;
																												_tmp267_ = nv;
																												_tmp267__length1 = nv_length1;
																												_tmp268_ = _tmp267_[1];
																												_tmp269_ = vala_gidl_parser_eval (self, _tmp268_);
																												_tmp270_ = _tmp269_;
																												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp266_, "Version", "deprecated_since", _tmp270_, NULL);
																												_g_free0 (_tmp270_);
																											} else {
																												gchar** _tmp271_;
																												gint _tmp271__length1;
																												const gchar* _tmp272_;
																												_tmp271_ = nv;
																												_tmp271__length1 = nv_length1;
																												_tmp272_ = _tmp271_[0];
																												if (g_strcmp0 (_tmp272_, "cheader_filename") == 0) {
																													ValaMethod* _tmp273_;
																													gchar** _tmp274_;
																													gint _tmp274__length1;
																													const gchar* _tmp275_;
																													gchar* _tmp276_;
																													gchar* _tmp277_;
																													_tmp273_ = m;
																													_tmp274_ = nv;
																													_tmp274__length1 = nv_length1;
																													_tmp275_ = _tmp274_[1];
																													_tmp276_ = vala_gidl_parser_eval (self, _tmp275_);
																													_tmp277_ = _tmp276_;
																													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp273_, "CCode", "cheader_filename", _tmp277_, NULL);
																													_g_free0 (_tmp277_);
																												} else {
																													gchar** _tmp278_;
																													gint _tmp278__length1;
																													const gchar* _tmp279_;
																													_tmp278_ = nv;
																													_tmp278__length1 = nv_length1;
																													_tmp279_ = _tmp278_[0];
																													if (g_strcmp0 (_tmp279_, "abstract") == 0) {
																														gchar** _tmp280_;
																														gint _tmp280__length1;
																														const gchar* _tmp281_;
																														gchar* _tmp282_;
																														gchar* _tmp283_;
																														gboolean _tmp284_;
																														_tmp280_ = nv;
																														_tmp280__length1 = nv_length1;
																														_tmp281_ = _tmp280_[1];
																														_tmp282_ = vala_gidl_parser_eval (self, _tmp281_);
																														_tmp283_ = _tmp282_;
																														_tmp284_ = g_strcmp0 (_tmp283_, "1") == 0;
																														_g_free0 (_tmp283_);
																														if (_tmp284_) {
																															ValaMethod* _tmp285_;
																															_tmp285_ = m;
																															vala_method_set_is_abstract (_tmp285_, TRUE);
																														}
																													} else {
																														gchar** _tmp286_;
																														gint _tmp286__length1;
																														const gchar* _tmp287_;
																														_tmp286_ = nv;
																														_tmp286__length1 = nv_length1;
																														_tmp287_ = _tmp286_[0];
																														if (g_strcmp0 (_tmp287_, "virtual") == 0) {
																															gchar** _tmp288_;
																															gint _tmp288__length1;
																															const gchar* _tmp289_;
																															gchar* _tmp290_;
																															gchar* _tmp291_;
																															gboolean _tmp292_;
																															_tmp288_ = nv;
																															_tmp288__length1 = nv_length1;
																															_tmp289_ = _tmp288_[1];
																															_tmp290_ = vala_gidl_parser_eval (self, _tmp289_);
																															_tmp291_ = _tmp290_;
																															_tmp292_ = g_strcmp0 (_tmp291_, "1") == 0;
																															_g_free0 (_tmp291_);
																															if (_tmp292_) {
																																ValaMethod* _tmp293_;
																																_tmp293_ = m;
																																vala_method_set_is_virtual (_tmp293_, TRUE);
																															}
																														} else {
																															gchar** _tmp294_;
																															gint _tmp294__length1;
																															const gchar* _tmp295_;
																															_tmp294_ = nv;
																															_tmp294__length1 = nv_length1;
																															_tmp295_ = _tmp294_[0];
																															if (g_strcmp0 (_tmp295_, "vfunc_name") == 0) {
																																ValaMethod* _tmp296_;
																																gchar** _tmp297_;
																																gint _tmp297__length1;
																																const gchar* _tmp298_;
																																gchar* _tmp299_;
																																gchar* _tmp300_;
																																_tmp296_ = m;
																																_tmp297_ = nv;
																																_tmp297__length1 = nv_length1;
																																_tmp298_ = _tmp297_[1];
																																_tmp299_ = vala_gidl_parser_eval (self, _tmp298_);
																																_tmp300_ = _tmp299_;
																																vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp296_, "CCode", "vfunc_name", _tmp300_, NULL);
																																_g_free0 (_tmp300_);
																															} else {
																																gchar** _tmp301_;
																																gint _tmp301__length1;
																																const gchar* _tmp302_;
																																_tmp301_ = nv;
																																_tmp301__length1 = nv_length1;
																																_tmp302_ = _tmp301_[0];
																																if (g_strcmp0 (_tmp302_, "finish_vfunc_name") == 0) {
																																	ValaMethod* _tmp303_;
																																	gchar** _tmp304_;
																																	gint _tmp304__length1;
																																	const gchar* _tmp305_;
																																	gchar* _tmp306_;
																																	gchar* _tmp307_;
																																	_tmp303_ = m;
																																	_tmp304_ = nv;
																																	_tmp304__length1 = nv_length1;
																																	_tmp305_ = _tmp304_[1];
																																	_tmp306_ = vala_gidl_parser_eval (self, _tmp305_);
																																	_tmp307_ = _tmp306_;
																																	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp303_, "CCode", "finish_vfunc_name", _tmp307_, NULL);
																																	_g_free0 (_tmp307_);
																																} else {
																																	gchar** _tmp308_;
																																	gint _tmp308__length1;
																																	const gchar* _tmp309_;
																																	_tmp308_ = nv;
																																	_tmp308__length1 = nv_length1;
																																	_tmp309_ = _tmp308_[0];
																																	if (g_strcmp0 (_tmp309_, "finish_name") == 0) {
																																		ValaMethod* _tmp310_;
																																		gchar** _tmp311_;
																																		gint _tmp311__length1;
																																		const gchar* _tmp312_;
																																		gchar* _tmp313_;
																																		gchar* _tmp314_;
																																		_tmp310_ = m;
																																		_tmp311_ = nv;
																																		_tmp311__length1 = nv_length1;
																																		_tmp312_ = _tmp311_[1];
																																		_tmp313_ = vala_gidl_parser_eval (self, _tmp312_);
																																		_tmp314_ = _tmp313_;
																																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp310_, "CCode", "finish_name", _tmp314_, NULL);
																																		_g_free0 (_tmp314_);
																																	} else {
																																		gchar** _tmp315_;
																																		gint _tmp315__length1;
																																		const gchar* _tmp316_;
																																		_tmp315_ = nv;
																																		_tmp315__length1 = nv_length1;
																																		_tmp316_ = _tmp315_[0];
																																		if (g_strcmp0 (_tmp316_, "async") == 0) {
																																			gchar** _tmp317_;
																																			gint _tmp317__length1;
																																			const gchar* _tmp318_;
																																			gchar* _tmp319_;
																																			gchar* _tmp320_;
																																			gboolean _tmp321_;
																																			_tmp317_ = nv;
																																			_tmp317__length1 = nv_length1;
																																			_tmp318_ = _tmp317_[1];
																																			_tmp319_ = vala_gidl_parser_eval (self, _tmp318_);
																																			_tmp320_ = _tmp319_;
																																			_tmp321_ = g_strcmp0 (_tmp320_, "1") == 0;
																																			_g_free0 (_tmp320_);
																																			if (_tmp321_) {
																																				ValaMethod* _tmp322_;
																																				_tmp322_ = m;
																																				vala_method_set_coroutine (_tmp322_, TRUE);
																																			}
																																		} else {
																																			gchar** _tmp323_;
																																			gint _tmp323__length1;
																																			const gchar* _tmp324_;
																																			_tmp323_ = nv;
																																			_tmp323__length1 = nv_length1;
																																			_tmp324_ = _tmp323_[0];
																																			if (g_strcmp0 (_tmp324_, "parent") == 0) {
																																				gchar** _tmp325_;
																																				gint _tmp325__length1;
																																				const gchar* _tmp326_;
																																				gchar* _tmp327_;
																																				gchar* _tmp328_;
																																				ValaSymbol* _tmp329_;
																																				gchar* prefix = NULL;
																																				ValaSymbol* _tmp330_;
																																				gchar* _tmp331_;
																																				const gchar* _tmp332_;
																																				_tmp325_ = nv;
																																				_tmp325__length1 = nv_length1;
																																				_tmp326_ = _tmp325_[1];
																																				_tmp327_ = vala_gidl_parser_eval (self, _tmp326_);
																																				_tmp328_ = _tmp327_;
																																				_tmp329_ = vala_gidl_parser_get_container_from_name (self, _tmp328_);
																																				_vala_code_node_unref0 (container);
																																				container = _tmp329_;
																																				_g_free0 (_tmp328_);
																																				_tmp330_ = container;
																																				_tmp331_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp330_);
																																				prefix = _tmp331_;
																																				_tmp332_ = prefix;
																																				if (g_str_has_prefix (symbol, _tmp332_)) {
																																					ValaMethod* _tmp333_;
																																					const gchar* _tmp334_;
																																					gint _tmp335_;
																																					gint _tmp336_;
																																					gchar* _tmp337_;
																																					gchar* _tmp338_;
																																					_tmp333_ = m;
																																					_tmp334_ = prefix;
																																					_tmp335_ = strlen (_tmp334_);
																																					_tmp336_ = _tmp335_;
																																					_tmp337_ = string_substring (symbol, (glong) _tmp336_, (glong) -1);
																																					_tmp338_ = _tmp337_;
																																					vala_symbol_set_name ((ValaSymbol*) _tmp333_, _tmp338_);
																																					_g_free0 (_tmp338_);
																																				}
																																				_g_free0 (prefix);
																																			} else {
																																				gchar** _tmp339_;
																																				gint _tmp339__length1;
																																				const gchar* _tmp340_;
																																				_tmp339_ = nv;
																																				_tmp339__length1 = nv_length1;
																																				_tmp340_ = _tmp339_[0];
																																				if (g_strcmp0 (_tmp340_, "experimental") == 0) {
																																					gchar** _tmp341_;
																																					gint _tmp341__length1;
																																					const gchar* _tmp342_;
																																					gchar* _tmp343_;
																																					gchar* _tmp344_;
																																					gboolean _tmp345_;
																																					_tmp341_ = nv;
																																					_tmp341__length1 = nv_length1;
																																					_tmp342_ = _tmp341_[1];
																																					_tmp343_ = vala_gidl_parser_eval (self, _tmp342_);
																																					_tmp344_ = _tmp343_;
																																					_tmp345_ = g_strcmp0 (_tmp344_, "1") == 0;
																																					_g_free0 (_tmp344_);
																																					if (_tmp345_) {
																																						ValaMethod* _tmp346_;
																																						_tmp346_ = m;
																																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp346_, "Version", "experimental", TRUE, NULL);
																																					}
																																				} else {
																																					gchar** _tmp347_;
																																					gint _tmp347__length1;
																																					const gchar* _tmp348_;
																																					_tmp347_ = nv;
																																					_tmp347__length1 = nv_length1;
																																					_tmp348_ = _tmp347_[0];
																																					if (g_strcmp0 (_tmp348_, "simple_generics") == 0) {
																																						gchar** _tmp349_;
																																						gint _tmp349__length1;
																																						const gchar* _tmp350_;
																																						gchar* _tmp351_;
																																						gchar* _tmp352_;
																																						gboolean _tmp353_;
																																						_tmp349_ = nv;
																																						_tmp349__length1 = nv_length1;
																																						_tmp350_ = _tmp349_[1];
																																						_tmp351_ = vala_gidl_parser_eval (self, _tmp350_);
																																						_tmp352_ = _tmp351_;
																																						_tmp353_ = g_strcmp0 (_tmp352_, "1") == 0;
																																						_g_free0 (_tmp352_);
																																						if (_tmp353_) {
																																							ValaMethod* _tmp354_;
																																							_tmp354_ = m;
																																							vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp354_, "CCode", "simple_generics", TRUE, NULL);
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	first = TRUE;
	last_param = NULL;
	last_param_type = NULL;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node = NULL;
				GIdlNodeParam* _tmp355_;
				gboolean _tmp356_;
				gboolean _tmp413_ = FALSE;
				GIdlNodeParam* _tmp414_;
				GIdlNodeType* _tmp415_;
				const gchar* _tmp416_;
				gboolean _tmp422_ = FALSE;
				gboolean _tmp423_;
				gchar* param_name = NULL;
				GIdlNode* _tmp431_;
				const gchar* _tmp432_;
				gchar* _tmp433_;
				const gchar* _tmp434_;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type = NULL;
				GIdlNodeParam* _tmp438_;
				ValaParameterDirection _tmp439_ = 0;
				ValaDataType* _tmp440_;
				ValaParameter* p = NULL;
				const gchar* _tmp441_;
				ValaDataType* _tmp442_;
				ValaParameter* _tmp443_;
				ValaParameter* _tmp444_;
				ValaParameterDirection _tmp445_;
				gboolean hide_param = FALSE;
				gboolean show_param = FALSE;
				gboolean set_array_length_pos = FALSE;
				gdouble array_length_pos = 0.0;
				gboolean set_delegate_target_pos = FALSE;
				gdouble delegate_target_pos = 0.0;
				gboolean array_requested = FALSE;
				gboolean out_requested = FALSE;
				GIdlNode* _tmp446_;
				const gchar* _tmp447_;
				gchar* _tmp448_;
				gchar* _tmp449_;
				gint _tmp450_ = 0;
				gchar** _tmp451_;
				gchar** _tmp452_;
				gint _tmp452__length1;
				gboolean _tmp719_ = FALSE;
				ValaParameter* _tmp720_;
				gboolean _tmp744_ = FALSE;
				gboolean _tmp745_;
				ValaParameter* _tmp755_;
				ValaParameter* _tmp756_;
				ValaDataType* _tmp757_;
				ValaDataType* _tmp758_;
				_tmp355_ = param;
				param_node = (GIdlNode*) _tmp355_;
				_tmp356_ = first;
				if (_tmp356_) {
					gboolean _tmp357_ = FALSE;
					gboolean _tmp358_ = FALSE;
					gboolean _tmp359_ = FALSE;
					ValaMethod* _tmp360_;
					first = FALSE;
					_tmp360_ = m;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp360_, VALA_TYPE_CREATION_METHOD)) {
						ValaTypeSymbol* _tmp361_;
						_tmp361_ = self->priv->current_data_type;
						_tmp359_ = _tmp361_ != NULL;
					} else {
						_tmp359_ = FALSE;
					}
					if (_tmp359_) {
						GIdlNodeParam* _tmp362_;
						GIdlNodeType* _tmp363_;
						gboolean _tmp364_;
						_tmp362_ = param;
						_tmp363_ = _tmp362_->type;
						_tmp364_ = _tmp363_->is_interface;
						_tmp358_ = _tmp364_;
					} else {
						_tmp358_ = FALSE;
					}
					if (_tmp358_) {
						gboolean _tmp365_ = FALSE;
						GIdlNode* _tmp366_;
						const gchar* _tmp367_;
						_tmp366_ = param_node;
						_tmp367_ = _tmp366_->name;
						if (g_strcmp0 (_tmp367_, "self") == 0) {
							_tmp365_ = TRUE;
						} else {
							GIdlNodeParam* _tmp368_;
							GIdlNodeType* _tmp369_;
							const gchar* _tmp370_;
							ValaTypeSymbol* _tmp371_;
							gchar* _tmp372_;
							gchar* _tmp373_;
							_tmp368_ = param;
							_tmp369_ = _tmp368_->type;
							_tmp370_ = _tmp369_->interface;
							_tmp371_ = self->priv->current_data_type;
							_tmp372_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp371_, NULL);
							_tmp373_ = _tmp372_;
							_tmp365_ = g_str_has_suffix (_tmp370_, _tmp373_);
							_g_free0 (_tmp373_);
						}
						_tmp357_ = _tmp365_;
					} else {
						_tmp357_ = FALSE;
					}
					if (_tmp357_) {
						continue;
					} else {
						gboolean _tmp374_ = FALSE;
						gboolean _tmp375_ = FALSE;
						gboolean _tmp376_ = FALSE;
						ValaMethod* _tmp377_;
						_tmp377_ = m;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp377_, VALA_TYPE_CREATION_METHOD)) {
							ValaTypeSymbol* _tmp378_;
							_tmp378_ = self->priv->current_data_type;
							_tmp376_ = _tmp378_ != NULL;
						} else {
							_tmp376_ = FALSE;
						}
						if (_tmp376_) {
							GIdlNodeParam* _tmp379_;
							GIdlNodeType* _tmp380_;
							gboolean _tmp381_;
							_tmp379_ = param;
							_tmp380_ = _tmp379_->type;
							_tmp381_ = _tmp380_->is_interface;
							_tmp375_ = _tmp381_;
						} else {
							_tmp375_ = FALSE;
						}
						if (_tmp375_) {
							gboolean _tmp382_ = FALSE;
							GIdlNode* _tmp383_;
							const gchar* _tmp384_;
							_tmp383_ = param_node;
							_tmp384_ = _tmp383_->name;
							if (g_strcmp0 (_tmp384_, "klass") == 0) {
								_tmp382_ = TRUE;
							} else {
								GIdlNodeParam* _tmp385_;
								GIdlNodeType* _tmp386_;
								const gchar* _tmp387_;
								ValaTypeSymbol* _tmp388_;
								gchar* _tmp389_;
								gchar* _tmp390_;
								gchar* _tmp391_;
								gchar* _tmp392_;
								_tmp385_ = param;
								_tmp386_ = _tmp385_->type;
								_tmp387_ = _tmp386_->interface;
								_tmp388_ = self->priv->current_data_type;
								_tmp389_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp388_, NULL);
								_tmp390_ = _tmp389_;
								_tmp391_ = g_strdup_printf ("%sClass", _tmp390_);
								_tmp392_ = _tmp391_;
								_tmp382_ = g_str_has_suffix (_tmp387_, _tmp392_);
								_g_free0 (_tmp392_);
								_g_free0 (_tmp390_);
							}
							_tmp374_ = _tmp382_;
						} else {
							_tmp374_ = FALSE;
						}
						if (_tmp374_) {
							ValaMethod* _tmp393_;
							ValaMethod* _tmp394_;
							const gchar* _tmp395_;
							const gchar* _tmp396_;
							_tmp393_ = m;
							vala_method_set_binding (_tmp393_, VALA_MEMBER_BINDING_CLASS);
							_tmp394_ = m;
							_tmp395_ = vala_symbol_get_name ((ValaSymbol*) _tmp394_);
							_tmp396_ = _tmp395_;
							if (g_str_has_prefix (_tmp396_, "class_")) {
								ValaMethod* _tmp397_;
								ValaMethod* _tmp398_;
								const gchar* _tmp399_;
								const gchar* _tmp400_;
								gint _tmp401_;
								gint _tmp402_;
								ValaMethod* _tmp403_;
								const gchar* _tmp404_;
								const gchar* _tmp405_;
								gint _tmp406_;
								gint _tmp407_;
								gint _tmp408_;
								gint _tmp409_;
								gchar* _tmp410_;
								gchar* _tmp411_;
								_tmp397_ = m;
								_tmp398_ = m;
								_tmp399_ = vala_symbol_get_name ((ValaSymbol*) _tmp398_);
								_tmp400_ = _tmp399_;
								_tmp401_ = strlen ("class_");
								_tmp402_ = _tmp401_;
								_tmp403_ = m;
								_tmp404_ = vala_symbol_get_name ((ValaSymbol*) _tmp403_);
								_tmp405_ = _tmp404_;
								_tmp406_ = strlen (_tmp405_);
								_tmp407_ = _tmp406_;
								_tmp408_ = strlen ("class_");
								_tmp409_ = _tmp408_;
								_tmp410_ = string_substring (_tmp400_, (glong) _tmp402_, (glong) (_tmp407_ - _tmp409_));
								_tmp411_ = _tmp410_;
								vala_symbol_set_name ((ValaSymbol*) _tmp397_, _tmp411_);
								_g_free0 (_tmp411_);
							}
							continue;
						} else {
							ValaMethod* _tmp412_;
							_tmp412_ = m;
							vala_method_set_binding (_tmp412_, VALA_MEMBER_BINDING_STATIC);
						}
					}
				}
				_tmp414_ = param;
				_tmp415_ = _tmp414_->type;
				_tmp416_ = _tmp415_->interface;
				if (g_strcmp0 (_tmp416_, "GAsyncReadyCallback") == 0) {
					gboolean _tmp417_ = FALSE;
					if (g_str_has_suffix (symbol, "_async")) {
						_tmp417_ = TRUE;
					} else {
						ValaMethod* _tmp418_;
						gboolean _tmp419_;
						gboolean _tmp420_;
						_tmp418_ = m;
						_tmp419_ = vala_method_get_coroutine (_tmp418_);
						_tmp420_ = _tmp419_;
						_tmp417_ = _tmp420_;
					}
					_tmp413_ = _tmp417_;
				} else {
					_tmp413_ = FALSE;
				}
				if (_tmp413_) {
					ValaMethod* _tmp421_;
					_tmp421_ = m;
					vala_method_set_coroutine (_tmp421_, TRUE);
					continue;
				}
				_tmp423_ = suppress_throws;
				if (_tmp423_ == FALSE) {
					GIdlNodeParam* _tmp424_;
					_tmp424_ = param;
					_tmp422_ = vala_gidl_parser_param_is_exception (self, _tmp424_);
				} else {
					_tmp422_ = FALSE;
				}
				if (_tmp422_) {
					const gchar* _tmp425_;
					_tmp425_ = error_types;
					if (_tmp425_ == NULL) {
						ValaMethod* _tmp426_;
						GIdlNodeParam* _tmp427_;
						GIdlNodeType* _tmp428_;
						ValaDataType* _tmp429_;
						ValaDataType* _tmp430_;
						_tmp426_ = m;
						_tmp427_ = param;
						_tmp428_ = _tmp427_->type;
						_tmp429_ = vala_gidl_parser_parse_type (self, _tmp428_, NULL);
						_tmp430_ = _tmp429_;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp426_, _tmp430_);
						_vala_code_node_unref0 (_tmp430_);
					}
					continue;
				}
				_tmp431_ = param_node;
				_tmp432_ = _tmp431_->name;
				_tmp433_ = g_strdup (_tmp432_);
				param_name = _tmp433_;
				_tmp434_ = param_name;
				if (g_strcmp0 (_tmp434_, "result") == 0) {
					gchar* _tmp435_;
					_tmp435_ = g_strdup ("_result");
					_g_free0 (param_name);
					param_name = _tmp435_;
				} else {
					const gchar* _tmp436_;
					_tmp436_ = param_name;
					if (g_strcmp0 (_tmp436_, "string") == 0) {
						gchar* _tmp437_;
						_tmp437_ = g_strdup ("str");
						_g_free0 (param_name);
						param_name = _tmp437_;
					}
				}
				_tmp438_ = param;
				_tmp440_ = vala_gidl_parser_parse_param (self, _tmp438_, &_tmp439_);
				direction = _tmp439_;
				param_type = _tmp440_;
				_tmp441_ = param_name;
				_tmp442_ = param_type;
				_tmp443_ = vala_parameter_new (_tmp441_, _tmp442_, NULL);
				p = _tmp443_;
				_tmp444_ = p;
				_tmp445_ = direction;
				vala_parameter_set_direction (_tmp444_, _tmp445_);
				hide_param = FALSE;
				show_param = FALSE;
				set_array_length_pos = FALSE;
				array_length_pos = (gdouble) 0;
				set_delegate_target_pos = FALSE;
				delegate_target_pos = (gdouble) 0;
				array_requested = FALSE;
				out_requested = FALSE;
				_tmp446_ = param_node;
				_tmp447_ = _tmp446_->name;
				_tmp448_ = g_strdup_printf ("%s.%s", symbol, _tmp447_);
				_tmp449_ = _tmp448_;
				_tmp451_ = vala_gidl_parser_get_attributes (self, _tmp449_, &_tmp450_);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes = _tmp451_;
				attributes_length1 = _tmp450_;
				_attributes_size_ = attributes_length1;
				_g_free0 (_tmp449_);
				_tmp452_ = attributes;
				_tmp452__length1 = attributes_length1;
				if (_tmp452_ != NULL) {
					gchar** _tmp453_;
					gint _tmp453__length1;
					_tmp453_ = attributes;
					_tmp453__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp453_;
						attr_collection_length1 = _tmp453__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp454_;
							gchar* attr = NULL;
							_tmp454_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp454_;
							{
								gchar** nv = NULL;
								const gchar* _tmp455_;
								gchar** _tmp456_;
								gchar** _tmp457_;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp458_;
								gint _tmp458__length1;
								const gchar* _tmp459_;
								_tmp455_ = attr;
								_tmp457_ = _tmp456_ = g_strsplit (_tmp455_, "=", 2);
								nv = _tmp457_;
								nv_length1 = _vala_array_length (_tmp456_);
								_nv_size_ = nv_length1;
								_tmp458_ = nv;
								_tmp458__length1 = nv_length1;
								_tmp459_ = _tmp458_[0];
								if (g_strcmp0 (_tmp459_, "is_array") == 0) {
									gchar** _tmp460_;
									gint _tmp460__length1;
									const gchar* _tmp461_;
									gchar* _tmp462_;
									gchar* _tmp463_;
									gboolean _tmp464_;
									_tmp460_ = nv;
									_tmp460__length1 = nv_length1;
									_tmp461_ = _tmp460_[1];
									_tmp462_ = vala_gidl_parser_eval (self, _tmp461_);
									_tmp463_ = _tmp462_;
									_tmp464_ = g_strcmp0 (_tmp463_, "1") == 0;
									_g_free0 (_tmp463_);
									if (_tmp464_) {
										ValaDataType* _tmp465_;
										ValaDataType* _tmp466_;
										ValaDataType* _tmp467_;
										ValaSourceReference* _tmp468_;
										ValaSourceReference* _tmp469_;
										ValaArrayType* _tmp470_;
										ValaParameter* _tmp471_;
										ValaDataType* _tmp472_;
										gboolean _tmp473_;
										_tmp465_ = param_type;
										vala_data_type_set_value_owned (_tmp465_, TRUE);
										_tmp466_ = param_type;
										_tmp467_ = param_type;
										_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp467_);
										_tmp469_ = _tmp468_;
										_tmp470_ = vala_array_type_new (_tmp466_, 1, _tmp469_);
										_vala_code_node_unref0 (param_type);
										param_type = (ValaDataType*) _tmp470_;
										_tmp471_ = p;
										_tmp472_ = param_type;
										vala_variable_set_variable_type ((ValaVariable*) _tmp471_, _tmp472_);
										_tmp473_ = out_requested;
										if (!_tmp473_) {
											ValaParameter* _tmp474_;
											_tmp474_ = p;
											vala_parameter_set_direction (_tmp474_, VALA_PARAMETER_DIRECTION_IN);
										}
										array_requested = TRUE;
									}
								} else {
									gchar** _tmp475_;
									gint _tmp475__length1;
									const gchar* _tmp476_;
									_tmp475_ = nv;
									_tmp475__length1 = nv_length1;
									_tmp476_ = _tmp475_[0];
									if (g_strcmp0 (_tmp476_, "is_pointer") == 0) {
										gchar** _tmp477_;
										gint _tmp477__length1;
										const gchar* _tmp478_;
										gchar* _tmp479_;
										gchar* _tmp480_;
										gboolean _tmp481_;
										_tmp477_ = nv;
										_tmp477__length1 = nv_length1;
										_tmp478_ = _tmp477_[1];
										_tmp479_ = vala_gidl_parser_eval (self, _tmp478_);
										_tmp480_ = _tmp479_;
										_tmp481_ = g_strcmp0 (_tmp480_, "1") == 0;
										_g_free0 (_tmp480_);
										if (_tmp481_) {
											ValaDataType* _tmp482_;
											ValaDataType* _tmp483_;
											ValaSourceReference* _tmp484_;
											ValaSourceReference* _tmp485_;
											ValaPointerType* _tmp486_;
											ValaParameter* _tmp487_;
											ValaDataType* _tmp488_;
											gboolean _tmp489_;
											_tmp482_ = param_type;
											_tmp483_ = return_type;
											_tmp484_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp483_);
											_tmp485_ = _tmp484_;
											_tmp486_ = vala_pointer_type_new (_tmp482_, _tmp485_);
											_vala_code_node_unref0 (param_type);
											param_type = (ValaDataType*) _tmp486_;
											_tmp487_ = p;
											_tmp488_ = param_type;
											vala_variable_set_variable_type ((ValaVariable*) _tmp487_, _tmp488_);
											_tmp489_ = out_requested;
											if (!_tmp489_) {
												ValaParameter* _tmp490_;
												_tmp490_ = p;
												vala_parameter_set_direction (_tmp490_, VALA_PARAMETER_DIRECTION_IN);
											}
										}
									} else {
										gchar** _tmp491_;
										gint _tmp491__length1;
										const gchar* _tmp492_;
										_tmp491_ = nv;
										_tmp491__length1 = nv_length1;
										_tmp492_ = _tmp491_[0];
										if (g_strcmp0 (_tmp492_, "is_out") == 0) {
											gchar** _tmp493_;
											gint _tmp493__length1;
											const gchar* _tmp494_;
											gchar* _tmp495_;
											gchar* _tmp496_;
											gboolean _tmp497_;
											_tmp493_ = nv;
											_tmp493__length1 = nv_length1;
											_tmp494_ = _tmp493_[1];
											_tmp495_ = vala_gidl_parser_eval (self, _tmp494_);
											_tmp496_ = _tmp495_;
											_tmp497_ = g_strcmp0 (_tmp496_, "1") == 0;
											_g_free0 (_tmp496_);
											if (_tmp497_) {
												ValaParameter* _tmp498_;
												gboolean _tmp499_ = FALSE;
												gboolean _tmp500_;
												_tmp498_ = p;
												vala_parameter_set_direction (_tmp498_, VALA_PARAMETER_DIRECTION_OUT);
												out_requested = TRUE;
												_tmp500_ = array_requested;
												if (!_tmp500_) {
													ValaDataType* _tmp501_;
													_tmp501_ = param_type;
													_tmp499_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp501_, VALA_TYPE_ARRAY_TYPE);
												} else {
													_tmp499_ = FALSE;
												}
												if (_tmp499_) {
													ValaArrayType* array_type = NULL;
													ValaDataType* _tmp502_;
													ValaArrayType* _tmp503_;
													ValaArrayType* _tmp504_;
													ValaDataType* _tmp505_;
													ValaDataType* _tmp506_;
													ValaDataType* _tmp507_;
													ValaParameter* _tmp508_;
													ValaDataType* _tmp509_;
													_tmp502_ = param_type;
													_tmp503_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp502_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
													array_type = _tmp503_;
													_tmp504_ = array_type;
													_tmp505_ = vala_array_type_get_element_type (_tmp504_);
													_tmp506_ = _tmp505_;
													_tmp507_ = _vala_code_node_ref0 (_tmp506_);
													_vala_code_node_unref0 (param_type);
													param_type = _tmp507_;
													_tmp508_ = p;
													_tmp509_ = param_type;
													vala_variable_set_variable_type ((ValaVariable*) _tmp508_, _tmp509_);
													_vala_code_node_unref0 (array_type);
												}
											}
										} else {
											gchar** _tmp510_;
											gint _tmp510__length1;
											const gchar* _tmp511_;
											_tmp510_ = nv;
											_tmp510__length1 = nv_length1;
											_tmp511_ = _tmp510_[0];
											if (g_strcmp0 (_tmp511_, "is_ref") == 0) {
												gchar** _tmp512_;
												gint _tmp512__length1;
												const gchar* _tmp513_;
												gchar* _tmp514_;
												gchar* _tmp515_;
												gboolean _tmp516_;
												_tmp512_ = nv;
												_tmp512__length1 = nv_length1;
												_tmp513_ = _tmp512_[1];
												_tmp514_ = vala_gidl_parser_eval (self, _tmp513_);
												_tmp515_ = _tmp514_;
												_tmp516_ = g_strcmp0 (_tmp515_, "1") == 0;
												_g_free0 (_tmp515_);
												if (_tmp516_) {
													ValaParameter* _tmp517_;
													gboolean _tmp518_ = FALSE;
													gboolean _tmp519_;
													_tmp517_ = p;
													vala_parameter_set_direction (_tmp517_, VALA_PARAMETER_DIRECTION_REF);
													_tmp519_ = array_requested;
													if (!_tmp519_) {
														ValaDataType* _tmp520_;
														_tmp520_ = param_type;
														_tmp518_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp520_, VALA_TYPE_ARRAY_TYPE);
													} else {
														_tmp518_ = FALSE;
													}
													if (_tmp518_) {
														ValaArrayType* array_type = NULL;
														ValaDataType* _tmp521_;
														ValaArrayType* _tmp522_;
														ValaArrayType* _tmp523_;
														ValaDataType* _tmp524_;
														ValaDataType* _tmp525_;
														ValaDataType* _tmp526_;
														ValaParameter* _tmp527_;
														ValaDataType* _tmp528_;
														_tmp521_ = param_type;
														_tmp522_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp521_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
														array_type = _tmp522_;
														_tmp523_ = array_type;
														_tmp524_ = vala_array_type_get_element_type (_tmp523_);
														_tmp525_ = _tmp524_;
														_tmp526_ = _vala_code_node_ref0 (_tmp525_);
														_vala_code_node_unref0 (param_type);
														param_type = _tmp526_;
														_tmp527_ = p;
														_tmp528_ = param_type;
														vala_variable_set_variable_type ((ValaVariable*) _tmp527_, _tmp528_);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												gchar** _tmp529_;
												gint _tmp529__length1;
												const gchar* _tmp530_;
												_tmp529_ = nv;
												_tmp529__length1 = nv_length1;
												_tmp530_ = _tmp529_[0];
												if (g_strcmp0 (_tmp530_, "nullable") == 0) {
													gboolean _tmp531_ = FALSE;
													gchar** _tmp532_;
													gint _tmp532__length1;
													const gchar* _tmp533_;
													gchar* _tmp534_;
													gchar* _tmp535_;
													gboolean _tmp536_;
													_tmp532_ = nv;
													_tmp532__length1 = nv_length1;
													_tmp533_ = _tmp532_[1];
													_tmp534_ = vala_gidl_parser_eval (self, _tmp533_);
													_tmp535_ = _tmp534_;
													_tmp536_ = g_strcmp0 (_tmp535_, "1") == 0;
													_g_free0 (_tmp535_);
													if (_tmp536_) {
														ValaDataType* _tmp537_;
														_tmp537_ = param_type;
														_tmp531_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp537_, VALA_TYPE_VOID_TYPE);
													} else {
														_tmp531_ = FALSE;
													}
													if (_tmp531_) {
														ValaDataType* _tmp538_;
														_tmp538_ = param_type;
														vala_data_type_set_nullable (_tmp538_, TRUE);
													}
												} else {
													gchar** _tmp539_;
													gint _tmp539__length1;
													const gchar* _tmp540_;
													_tmp539_ = nv;
													_tmp539__length1 = nv_length1;
													_tmp540_ = _tmp539_[0];
													if (g_strcmp0 (_tmp540_, "transfer_ownership") == 0) {
														gchar** _tmp541_;
														gint _tmp541__length1;
														const gchar* _tmp542_;
														gchar* _tmp543_;
														gchar* _tmp544_;
														gboolean _tmp545_;
														_tmp541_ = nv;
														_tmp541__length1 = nv_length1;
														_tmp542_ = _tmp541_[1];
														_tmp543_ = vala_gidl_parser_eval (self, _tmp542_);
														_tmp544_ = _tmp543_;
														_tmp545_ = g_strcmp0 (_tmp544_, "1") == 0;
														_g_free0 (_tmp544_);
														if (_tmp545_) {
															ValaDataType* _tmp546_;
															_tmp546_ = param_type;
															vala_data_type_set_value_owned (_tmp546_, TRUE);
														}
													} else {
														gchar** _tmp547_;
														gint _tmp547__length1;
														const gchar* _tmp548_;
														_tmp547_ = nv;
														_tmp547__length1 = nv_length1;
														_tmp548_ = _tmp547_[0];
														if (g_strcmp0 (_tmp548_, "takes_ownership") == 0) {
															gchar** _tmp549_;
															gint _tmp549__length1;
															const gchar* _tmp550_;
															gchar* _tmp551_;
															gchar* _tmp552_;
															gboolean _tmp553_;
															_tmp549_ = nv;
															_tmp549__length1 = nv_length1;
															_tmp550_ = _tmp549_[1];
															_tmp551_ = vala_gidl_parser_eval (self, _tmp550_);
															_tmp552_ = _tmp551_;
															_tmp553_ = g_strcmp0 (_tmp552_, "1") == 0;
															_g_free0 (_tmp552_);
															if (_tmp553_) {
																ValaDataType* _tmp554_;
																_tmp554_ = param_type;
																vala_data_type_set_value_owned (_tmp554_, TRUE);
															}
														} else {
															gchar** _tmp555_;
															gint _tmp555__length1;
															const gchar* _tmp556_;
															_tmp555_ = nv;
															_tmp555__length1 = nv_length1;
															_tmp556_ = _tmp555_[0];
															if (g_strcmp0 (_tmp556_, "value_owned") == 0) {
																gchar** _tmp557_;
																gint _tmp557__length1;
																const gchar* _tmp558_;
																gchar* _tmp559_;
																gchar* _tmp560_;
																gboolean _tmp561_;
																_tmp557_ = nv;
																_tmp557__length1 = nv_length1;
																_tmp558_ = _tmp557_[1];
																_tmp559_ = vala_gidl_parser_eval (self, _tmp558_);
																_tmp560_ = _tmp559_;
																_tmp561_ = g_strcmp0 (_tmp560_, "0") == 0;
																_g_free0 (_tmp560_);
																if (_tmp561_) {
																	ValaDataType* _tmp562_;
																	_tmp562_ = param_type;
																	vala_data_type_set_value_owned (_tmp562_, FALSE);
																} else {
																	gchar** _tmp563_;
																	gint _tmp563__length1;
																	const gchar* _tmp564_;
																	gchar* _tmp565_;
																	gchar* _tmp566_;
																	gboolean _tmp567_;
																	_tmp563_ = nv;
																	_tmp563__length1 = nv_length1;
																	_tmp564_ = _tmp563_[1];
																	_tmp565_ = vala_gidl_parser_eval (self, _tmp564_);
																	_tmp566_ = _tmp565_;
																	_tmp567_ = g_strcmp0 (_tmp566_, "1") == 0;
																	_g_free0 (_tmp566_);
																	if (_tmp567_) {
																		ValaDataType* _tmp568_;
																		_tmp568_ = param_type;
																		vala_data_type_set_value_owned (_tmp568_, TRUE);
																	}
																}
															} else {
																gchar** _tmp569_;
																gint _tmp569__length1;
																const gchar* _tmp570_;
																_tmp569_ = nv;
																_tmp569__length1 = nv_length1;
																_tmp570_ = _tmp569_[0];
																if (g_strcmp0 (_tmp570_, "hidden") == 0) {
																	gchar** _tmp571_;
																	gint _tmp571__length1;
																	const gchar* _tmp572_;
																	gchar* _tmp573_;
																	gchar* _tmp574_;
																	gboolean _tmp575_;
																	_tmp571_ = nv;
																	_tmp571__length1 = nv_length1;
																	_tmp572_ = _tmp571_[1];
																	_tmp573_ = vala_gidl_parser_eval (self, _tmp572_);
																	_tmp574_ = _tmp573_;
																	_tmp575_ = g_strcmp0 (_tmp574_, "1") == 0;
																	_g_free0 (_tmp574_);
																	if (_tmp575_) {
																		hide_param = TRUE;
																	} else {
																		gchar** _tmp576_;
																		gint _tmp576__length1;
																		const gchar* _tmp577_;
																		gchar* _tmp578_;
																		gchar* _tmp579_;
																		gboolean _tmp580_;
																		_tmp576_ = nv;
																		_tmp576__length1 = nv_length1;
																		_tmp577_ = _tmp576_[1];
																		_tmp578_ = vala_gidl_parser_eval (self, _tmp577_);
																		_tmp579_ = _tmp578_;
																		_tmp580_ = g_strcmp0 (_tmp579_, "0") == 0;
																		_g_free0 (_tmp579_);
																		if (_tmp580_) {
																			show_param = TRUE;
																		}
																	}
																} else {
																	gchar** _tmp581_;
																	gint _tmp581__length1;
																	const gchar* _tmp582_;
																	_tmp581_ = nv;
																	_tmp581__length1 = nv_length1;
																	_tmp582_ = _tmp581_[0];
																	if (g_strcmp0 (_tmp582_, "no_array_length") == 0) {
																		gchar** _tmp583_;
																		gint _tmp583__length1;
																		const gchar* _tmp584_;
																		gchar* _tmp585_;
																		gchar* _tmp586_;
																		gboolean _tmp587_;
																		_tmp583_ = nv;
																		_tmp583__length1 = nv_length1;
																		_tmp584_ = _tmp583_[1];
																		_tmp585_ = vala_gidl_parser_eval (self, _tmp584_);
																		_tmp586_ = _tmp585_;
																		_tmp587_ = g_strcmp0 (_tmp586_, "1") == 0;
																		_g_free0 (_tmp586_);
																		if (_tmp587_) {
																			ValaParameter* _tmp588_;
																			_tmp588_ = p;
																			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp588_, "CCode", "array_length", FALSE, NULL);
																		}
																	} else {
																		gchar** _tmp589_;
																		gint _tmp589__length1;
																		const gchar* _tmp590_;
																		_tmp589_ = nv;
																		_tmp589__length1 = nv_length1;
																		_tmp590_ = _tmp589_[0];
																		if (g_strcmp0 (_tmp590_, "array_length_type") == 0) {
																			ValaParameter* _tmp591_;
																			gchar** _tmp592_;
																			gint _tmp592__length1;
																			const gchar* _tmp593_;
																			gchar* _tmp594_;
																			gchar* _tmp595_;
																			_tmp591_ = p;
																			_tmp592_ = nv;
																			_tmp592__length1 = nv_length1;
																			_tmp593_ = _tmp592_[1];
																			_tmp594_ = vala_gidl_parser_eval (self, _tmp593_);
																			_tmp595_ = _tmp594_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp591_, "CCode", "array_length_type", _tmp595_, NULL);
																			_g_free0 (_tmp595_);
																		} else {
																			gchar** _tmp596_;
																			gint _tmp596__length1;
																			const gchar* _tmp597_;
																			_tmp596_ = nv;
																			_tmp596__length1 = nv_length1;
																			_tmp597_ = _tmp596_[0];
																			if (g_strcmp0 (_tmp597_, "array_null_terminated") == 0) {
																				gchar** _tmp598_;
																				gint _tmp598__length1;
																				const gchar* _tmp599_;
																				gchar* _tmp600_;
																				gchar* _tmp601_;
																				gboolean _tmp602_;
																				_tmp598_ = nv;
																				_tmp598__length1 = nv_length1;
																				_tmp599_ = _tmp598_[1];
																				_tmp600_ = vala_gidl_parser_eval (self, _tmp599_);
																				_tmp601_ = _tmp600_;
																				_tmp602_ = g_strcmp0 (_tmp601_, "1") == 0;
																				_g_free0 (_tmp601_);
																				if (_tmp602_) {
																					ValaParameter* _tmp603_;
																					ValaParameter* _tmp604_;
																					_tmp603_ = p;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp603_, "CCode", "array_length", FALSE, NULL);
																					_tmp604_ = p;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp604_, "CCode", "array_null_terminated", TRUE, NULL);
																				}
																			} else {
																				gchar** _tmp605_;
																				gint _tmp605__length1;
																				const gchar* _tmp606_;
																				_tmp605_ = nv;
																				_tmp605__length1 = nv_length1;
																				_tmp606_ = _tmp605_[0];
																				if (g_strcmp0 (_tmp606_, "array_length_pos") == 0) {
																					gchar** _tmp607_;
																					gint _tmp607__length1;
																					const gchar* _tmp608_;
																					gchar* _tmp609_;
																					gchar* _tmp610_;
																					set_array_length_pos = TRUE;
																					_tmp607_ = nv;
																					_tmp607__length1 = nv_length1;
																					_tmp608_ = _tmp607_[1];
																					_tmp609_ = vala_gidl_parser_eval (self, _tmp608_);
																					_tmp610_ = _tmp609_;
																					array_length_pos = double_parse (_tmp610_);
																					_g_free0 (_tmp610_);
																				} else {
																					gchar** _tmp611_;
																					gint _tmp611__length1;
																					const gchar* _tmp612_;
																					_tmp611_ = nv;
																					_tmp611__length1 = nv_length1;
																					_tmp612_ = _tmp611_[0];
																					if (g_strcmp0 (_tmp612_, "delegate_target_pos") == 0) {
																						gchar** _tmp613_;
																						gint _tmp613__length1;
																						const gchar* _tmp614_;
																						gchar* _tmp615_;
																						gchar* _tmp616_;
																						set_delegate_target_pos = TRUE;
																						_tmp613_ = nv;
																						_tmp613__length1 = nv_length1;
																						_tmp614_ = _tmp613_[1];
																						_tmp615_ = vala_gidl_parser_eval (self, _tmp614_);
																						_tmp616_ = _tmp615_;
																						delegate_target_pos = double_parse (_tmp616_);
																						_g_free0 (_tmp616_);
																					} else {
																						gchar** _tmp617_;
																						gint _tmp617__length1;
																						const gchar* _tmp618_;
																						_tmp617_ = nv;
																						_tmp617__length1 = nv_length1;
																						_tmp618_ = _tmp617_[0];
																						if (g_strcmp0 (_tmp618_, "type_name") == 0) {
																							ValaParameter* _tmp619_;
																							gchar** _tmp620_;
																							gint _tmp620__length1;
																							const gchar* _tmp621_;
																							gchar* _tmp622_;
																							gchar* _tmp623_;
																							ValaDataType* _tmp624_;
																							ValaDataType* _tmp625_;
																							_tmp619_ = p;
																							_tmp620_ = nv;
																							_tmp620__length1 = nv_length1;
																							_tmp621_ = _tmp620_[1];
																							_tmp622_ = vala_gidl_parser_eval (self, _tmp621_);
																							_tmp623_ = _tmp622_;
																							_tmp624_ = vala_gidl_parser_parse_type_from_string (self, _tmp623_, FALSE, NULL);
																							_vala_code_node_unref0 (param_type);
																							param_type = _tmp624_;
																							_tmp625_ = param_type;
																							vala_variable_set_variable_type ((ValaVariable*) _tmp619_, _tmp625_);
																							_g_free0 (_tmp623_);
																						} else {
																							gchar** _tmp626_;
																							gint _tmp626__length1;
																							const gchar* _tmp627_;
																							_tmp626_ = nv;
																							_tmp626__length1 = nv_length1;
																							_tmp627_ = _tmp626_[0];
																							if (g_strcmp0 (_tmp627_, "ctype") == 0) {
																								ValaParameter* _tmp628_;
																								gchar** _tmp629_;
																								gint _tmp629__length1;
																								const gchar* _tmp630_;
																								gchar* _tmp631_;
																								gchar* _tmp632_;
																								_tmp628_ = p;
																								_tmp629_ = nv;
																								_tmp629__length1 = nv_length1;
																								_tmp630_ = _tmp629_[1];
																								_tmp631_ = vala_gidl_parser_eval (self, _tmp630_);
																								_tmp632_ = _tmp631_;
																								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp628_, "CCode", "type", _tmp632_, NULL);
																								_g_free0 (_tmp632_);
																							} else {
																								gchar** _tmp633_;
																								gint _tmp633__length1;
																								const gchar* _tmp634_;
																								_tmp633_ = nv;
																								_tmp633__length1 = nv_length1;
																								_tmp634_ = _tmp633_[0];
																								if (g_strcmp0 (_tmp634_, "scope") == 0) {
																									ValaParameter* _tmp635_;
																									gchar** _tmp636_;
																									gint _tmp636__length1;
																									const gchar* _tmp637_;
																									gchar* _tmp638_;
																									gchar* _tmp639_;
																									_tmp635_ = p;
																									_tmp636_ = nv;
																									_tmp636__length1 = nv_length1;
																									_tmp637_ = _tmp636_[1];
																									_tmp638_ = vala_gidl_parser_eval (self, _tmp637_);
																									_tmp639_ = _tmp638_;
																									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp635_, "CCode", "scope", _tmp639_, NULL);
																									_g_free0 (_tmp639_);
																								} else {
																									gchar** _tmp640_;
																									gint _tmp640__length1;
																									const gchar* _tmp641_;
																									_tmp640_ = nv;
																									_tmp640__length1 = nv_length1;
																									_tmp641_ = _tmp640_[0];
																									if (g_strcmp0 (_tmp641_, "type_arguments") == 0) {
																										ValaDataType* _tmp642_;
																										gchar** _tmp643_;
																										gint _tmp643__length1;
																										const gchar* _tmp644_;
																										gchar* _tmp645_;
																										gchar* _tmp646_;
																										_tmp642_ = param_type;
																										_tmp643_ = nv;
																										_tmp643__length1 = nv_length1;
																										_tmp644_ = _tmp643_[1];
																										_tmp645_ = vala_gidl_parser_eval (self, _tmp644_);
																										_tmp646_ = _tmp645_;
																										vala_gidl_parser_parse_type_arguments_from_string (self, _tmp642_, _tmp646_, NULL);
																										_g_free0 (_tmp646_);
																									} else {
																										gchar** _tmp647_;
																										gint _tmp647__length1;
																										const gchar* _tmp648_;
																										_tmp647_ = nv;
																										_tmp647__length1 = nv_length1;
																										_tmp648_ = _tmp647_[0];
																										if (g_strcmp0 (_tmp648_, "default_value") == 0) {
																											gchar* val = NULL;
																											gchar** _tmp649_;
																											gint _tmp649__length1;
																											const gchar* _tmp650_;
																											gchar* _tmp651_;
																											const gchar* _tmp652_;
																											_tmp649_ = nv;
																											_tmp649__length1 = nv_length1;
																											_tmp650_ = _tmp649_[1];
																											_tmp651_ = vala_gidl_parser_eval (self, _tmp650_);
																											val = _tmp651_;
																											_tmp652_ = val;
																											if (g_strcmp0 (_tmp652_, "null") == 0) {
																												ValaParameter* _tmp653_;
																												ValaDataType* _tmp654_;
																												ValaSourceReference* _tmp655_;
																												ValaSourceReference* _tmp656_;
																												ValaNullLiteral* _tmp657_;
																												ValaNullLiteral* _tmp658_;
																												_tmp653_ = p;
																												_tmp654_ = param_type;
																												_tmp655_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp654_);
																												_tmp656_ = _tmp655_;
																												_tmp657_ = vala_null_literal_new (_tmp656_);
																												_tmp658_ = _tmp657_;
																												vala_variable_set_initializer ((ValaVariable*) _tmp653_, (ValaExpression*) _tmp658_);
																												_vala_code_node_unref0 (_tmp658_);
																											} else {
																												const gchar* _tmp659_;
																												_tmp659_ = val;
																												if (g_strcmp0 (_tmp659_, "true") == 0) {
																													ValaParameter* _tmp660_;
																													ValaDataType* _tmp661_;
																													ValaSourceReference* _tmp662_;
																													ValaSourceReference* _tmp663_;
																													ValaBooleanLiteral* _tmp664_;
																													ValaBooleanLiteral* _tmp665_;
																													_tmp660_ = p;
																													_tmp661_ = param_type;
																													_tmp662_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp661_);
																													_tmp663_ = _tmp662_;
																													_tmp664_ = vala_boolean_literal_new (TRUE, _tmp663_);
																													_tmp665_ = _tmp664_;
																													vala_variable_set_initializer ((ValaVariable*) _tmp660_, (ValaExpression*) _tmp665_);
																													_vala_code_node_unref0 (_tmp665_);
																												} else {
																													const gchar* _tmp666_;
																													_tmp666_ = val;
																													if (g_strcmp0 (_tmp666_, "false") == 0) {
																														ValaParameter* _tmp667_;
																														ValaDataType* _tmp668_;
																														ValaSourceReference* _tmp669_;
																														ValaSourceReference* _tmp670_;
																														ValaBooleanLiteral* _tmp671_;
																														ValaBooleanLiteral* _tmp672_;
																														_tmp667_ = p;
																														_tmp668_ = param_type;
																														_tmp669_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp668_);
																														_tmp670_ = _tmp669_;
																														_tmp671_ = vala_boolean_literal_new (FALSE, _tmp670_);
																														_tmp672_ = _tmp671_;
																														vala_variable_set_initializer ((ValaVariable*) _tmp667_, (ValaExpression*) _tmp672_);
																														_vala_code_node_unref0 (_tmp672_);
																													} else {
																														const gchar* _tmp673_;
																														_tmp673_ = val;
																														if (g_strcmp0 (_tmp673_, "") == 0) {
																															ValaParameter* _tmp674_;
																															ValaDataType* _tmp675_;
																															ValaSourceReference* _tmp676_;
																															ValaSourceReference* _tmp677_;
																															ValaStringLiteral* _tmp678_;
																															ValaStringLiteral* _tmp679_;
																															_tmp674_ = p;
																															_tmp675_ = param_type;
																															_tmp676_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp675_);
																															_tmp677_ = _tmp676_;
																															_tmp678_ = vala_string_literal_new ("\"\"", _tmp677_);
																															_tmp679_ = _tmp678_;
																															vala_variable_set_initializer ((ValaVariable*) _tmp674_, (ValaExpression*) _tmp679_);
																															_vala_code_node_unref0 (_tmp679_);
																														} else {
																															const gchar* _tmp680_;
																															_tmp680_ = val;
																															if (int64_try_parse (_tmp680_, NULL, NULL)) {
																																ValaParameter* _tmp681_;
																																const gchar* _tmp682_;
																																ValaDataType* _tmp683_;
																																ValaSourceReference* _tmp684_;
																																ValaSourceReference* _tmp685_;
																																ValaIntegerLiteral* _tmp686_;
																																ValaIntegerLiteral* _tmp687_;
																																_tmp681_ = p;
																																_tmp682_ = val;
																																_tmp683_ = param_type;
																																_tmp684_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp683_);
																																_tmp685_ = _tmp684_;
																																_tmp686_ = vala_integer_literal_new (_tmp682_, _tmp685_);
																																_tmp687_ = _tmp686_;
																																vala_variable_set_initializer ((ValaVariable*) _tmp681_, (ValaExpression*) _tmp687_);
																																_vala_code_node_unref0 (_tmp687_);
																															} else {
																																const gchar* _tmp688_;
																																_tmp688_ = val;
																																if (double_try_parse (_tmp688_, NULL, NULL)) {
																																	ValaParameter* _tmp689_;
																																	const gchar* _tmp690_;
																																	ValaDataType* _tmp691_;
																																	ValaSourceReference* _tmp692_;
																																	ValaSourceReference* _tmp693_;
																																	ValaRealLiteral* _tmp694_;
																																	ValaRealLiteral* _tmp695_;
																																	_tmp689_ = p;
																																	_tmp690_ = val;
																																	_tmp691_ = param_type;
																																	_tmp692_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp691_);
																																	_tmp693_ = _tmp692_;
																																	_tmp694_ = vala_real_literal_new (_tmp690_, _tmp693_);
																																	_tmp695_ = _tmp694_;
																																	vala_variable_set_initializer ((ValaVariable*) _tmp689_, (ValaExpression*) _tmp695_);
																																	_vala_code_node_unref0 (_tmp695_);
																																} else {
																																	gboolean _tmp696_ = FALSE;
																																	const gchar* _tmp697_;
																																	_tmp697_ = val;
																																	if (g_str_has_prefix (_tmp697_, "\"")) {
																																		const gchar* _tmp698_;
																																		_tmp698_ = val;
																																		_tmp696_ = g_str_has_suffix (_tmp698_, "\"");
																																	} else {
																																		_tmp696_ = FALSE;
																																	}
																																	if (_tmp696_) {
																																		ValaParameter* _tmp699_;
																																		const gchar* _tmp700_;
																																		ValaDataType* _tmp701_;
																																		ValaSourceReference* _tmp702_;
																																		ValaSourceReference* _tmp703_;
																																		ValaStringLiteral* _tmp704_;
																																		ValaStringLiteral* _tmp705_;
																																		_tmp699_ = p;
																																		_tmp700_ = val;
																																		_tmp701_ = param_type;
																																		_tmp702_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp701_);
																																		_tmp703_ = _tmp702_;
																																		_tmp704_ = vala_string_literal_new (_tmp700_, _tmp703_);
																																		_tmp705_ = _tmp704_;
																																		vala_variable_set_initializer ((ValaVariable*) _tmp699_, (ValaExpression*) _tmp705_);
																																		_vala_code_node_unref0 (_tmp705_);
																																	} else {
																																		const gchar* _tmp706_;
																																		gchar** _tmp707_;
																																		gchar** _tmp708_;
																																		_tmp706_ = val;
																																		_tmp708_ = _tmp707_ = g_strsplit (_tmp706_, ".", 0);
																																		{
																																			gchar** member_collection = NULL;
																																			gint member_collection_length1 = 0;
																																			gint _member_collection_size_ = 0;
																																			gint member_it = 0;
																																			member_collection = _tmp708_;
																																			member_collection_length1 = _vala_array_length (_tmp707_);
																																			for (member_it = 0; member_it < member_collection_length1; member_it = member_it + 1) {
																																				const gchar* member = NULL;
																																				member = member_collection[member_it];
																																				{
																																					ValaParameter* _tmp709_;
																																					ValaParameter* _tmp710_;
																																					ValaExpression* _tmp711_;
																																					ValaExpression* _tmp712_;
																																					const gchar* _tmp713_;
																																					ValaDataType* _tmp714_;
																																					ValaSourceReference* _tmp715_;
																																					ValaSourceReference* _tmp716_;
																																					ValaMemberAccess* _tmp717_;
																																					ValaMemberAccess* _tmp718_;
																																					_tmp709_ = p;
																																					_tmp710_ = p;
																																					_tmp711_ = vala_variable_get_initializer ((ValaVariable*) _tmp710_);
																																					_tmp712_ = _tmp711_;
																																					_tmp713_ = member;
																																					_tmp714_ = param_type;
																																					_tmp715_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp714_);
																																					_tmp716_ = _tmp715_;
																																					_tmp717_ = vala_member_access_new (_tmp712_, _tmp713_, _tmp716_);
																																					_tmp718_ = _tmp717_;
																																					vala_variable_set_initializer ((ValaVariable*) _tmp709_, (ValaExpression*) _tmp718_);
																																					_vala_code_node_unref0 (_tmp718_);
																																				}
																																			}
																																			member_collection = (_vala_array_free (member_collection, member_collection_length1, (GDestroyNotify) g_free), NULL);
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																											_g_free0 (val);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp720_ = last_param;
				if (_tmp720_ != NULL) {
					ValaParameter* _tmp721_;
					const gchar* _tmp722_;
					const gchar* _tmp723_;
					ValaParameter* _tmp724_;
					const gchar* _tmp725_;
					const gchar* _tmp726_;
					gchar* _tmp727_;
					gchar* _tmp728_;
					_tmp721_ = p;
					_tmp722_ = vala_symbol_get_name ((ValaSymbol*) _tmp721_);
					_tmp723_ = _tmp722_;
					_tmp724_ = last_param;
					_tmp725_ = vala_symbol_get_name ((ValaSymbol*) _tmp724_);
					_tmp726_ = _tmp725_;
					_tmp727_ = g_strconcat ("n_", _tmp726_, NULL);
					_tmp728_ = _tmp727_;
					_tmp719_ = g_strcmp0 (_tmp723_, _tmp728_) == 0;
					_g_free0 (_tmp728_);
				} else {
					_tmp719_ = FALSE;
				}
				if (_tmp719_) {
					ValaDataType* _tmp729_;
					_tmp729_ = last_param_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp729_, VALA_TYPE_ARRAY_TYPE)) {
						ValaDataType* _tmp730_;
						ValaDataType* _tmp731_;
						ValaDataType* _tmp732_;
						ValaSourceReference* _tmp733_;
						ValaSourceReference* _tmp734_;
						ValaArrayType* _tmp735_;
						ValaParameter* _tmp736_;
						ValaDataType* _tmp737_;
						ValaParameter* _tmp738_;
						_tmp730_ = last_param_type;
						vala_data_type_set_value_owned (_tmp730_, TRUE);
						_tmp731_ = last_param_type;
						_tmp732_ = last_param_type;
						_tmp733_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp732_);
						_tmp734_ = _tmp733_;
						_tmp735_ = vala_array_type_new (_tmp731_, 1, _tmp734_);
						_vala_code_node_unref0 (last_param_type);
						last_param_type = (ValaDataType*) _tmp735_;
						_tmp736_ = last_param;
						_tmp737_ = last_param_type;
						vala_variable_set_variable_type ((ValaVariable*) _tmp736_, _tmp737_);
						_tmp738_ = last_param;
						vala_parameter_set_direction (_tmp738_, VALA_PARAMETER_DIRECTION_IN);
					}
					hide_param = TRUE;
				} else {
					gboolean _tmp739_ = FALSE;
					ValaParameter* _tmp740_;
					_tmp740_ = last_param;
					if (_tmp740_ != NULL) {
						ValaParameter* _tmp741_;
						const gchar* _tmp742_;
						const gchar* _tmp743_;
						_tmp741_ = p;
						_tmp742_ = vala_symbol_get_name ((ValaSymbol*) _tmp741_);
						_tmp743_ = _tmp742_;
						_tmp739_ = g_strcmp0 (_tmp743_, "user_data") == 0;
					} else {
						_tmp739_ = FALSE;
					}
					if (_tmp739_) {
						hide_param = TRUE;
					}
				}
				_tmp745_ = show_param;
				if (_tmp745_) {
					_tmp744_ = TRUE;
				} else {
					gboolean _tmp746_;
					_tmp746_ = hide_param;
					_tmp744_ = !_tmp746_;
				}
				if (_tmp744_) {
					ValaMethod* _tmp747_;
					ValaParameter* _tmp748_;
					gboolean _tmp749_;
					gboolean _tmp752_;
					_tmp747_ = m;
					_tmp748_ = p;
					vala_callable_add_parameter ((ValaCallable*) _tmp747_, _tmp748_);
					_tmp749_ = set_array_length_pos;
					if (_tmp749_) {
						ValaParameter* _tmp750_;
						gdouble _tmp751_;
						_tmp750_ = p;
						_tmp751_ = array_length_pos;
						vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp750_, "CCode", "array_length_pos", _tmp751_, NULL);
					}
					_tmp752_ = set_delegate_target_pos;
					if (_tmp752_) {
						ValaParameter* _tmp753_;
						gdouble _tmp754_;
						_tmp753_ = p;
						_tmp754_ = delegate_target_pos;
						vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp753_, "CCode", "delegate_target_pos", _tmp754_, NULL);
					}
				}
				_tmp755_ = p;
				_tmp756_ = _vala_code_node_ref0 (_tmp755_);
				_vala_code_node_unref0 (last_param);
				last_param = _tmp756_;
				_tmp757_ = param_type;
				_tmp758_ = _vala_code_node_ref0 (_tmp757_);
				_vala_code_node_unref0 (last_param_type);
				last_param_type = _tmp758_;
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
				_g_free0 (param_name);
			}
		}
	}
	_tmp760_ = suppress_throws;
	if (_tmp760_ == FALSE) {
		const gchar* _tmp761_;
		_tmp761_ = error_types;
		_tmp759_ = _tmp761_ != NULL;
	} else {
		_tmp759_ = FALSE;
	}
	if (_tmp759_) {
		gchar** type_args = NULL;
		const gchar* _tmp762_;
		gchar* _tmp763_;
		gchar* _tmp764_;
		gchar** _tmp765_;
		gchar** _tmp766_;
		gchar** _tmp767_;
		gint _tmp767__length1;
		gint type_args_length1;
		gint _type_args_size_;
		gchar** _tmp768_;
		gint _tmp768__length1;
		_tmp762_ = error_types;
		_tmp763_ = vala_gidl_parser_eval (self, _tmp762_);
		_tmp764_ = _tmp763_;
		_tmp766_ = _tmp765_ = g_strsplit (_tmp764_, ",", 0);
		_tmp767_ = _tmp766_;
		_tmp767__length1 = _vala_array_length (_tmp765_);
		_g_free0 (_tmp764_);
		type_args = _tmp767_;
		type_args_length1 = _tmp767__length1;
		_type_args_size_ = type_args_length1;
		_tmp768_ = type_args;
		_tmp768__length1 = type_args_length1;
		{
			gchar** type_arg_collection = NULL;
			gint type_arg_collection_length1 = 0;
			gint _type_arg_collection_size_ = 0;
			gint type_arg_it = 0;
			type_arg_collection = _tmp768_;
			type_arg_collection_length1 = _tmp768__length1;
			for (type_arg_it = 0; type_arg_it < type_arg_collection_length1; type_arg_it = type_arg_it + 1) {
				const gchar* type_arg = NULL;
				type_arg = type_arg_collection[type_arg_it];
				{
					ValaMethod* _tmp769_;
					const gchar* _tmp770_;
					ValaDataType* _tmp771_;
					ValaDataType* _tmp772_;
					_tmp769_ = m;
					_tmp770_ = type_arg;
					_tmp771_ = vala_gidl_parser_parse_type_from_string (self, _tmp770_, TRUE, NULL);
					_tmp772_ = _tmp771_;
					vala_code_node_add_error_type ((ValaCodeNode*) _tmp769_, _tmp772_);
					_vala_code_node_unref0 (_tmp772_);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp773_ = first;
	if (_tmp773_) {
		ValaMethod* _tmp774_;
		_tmp774_ = m;
		vala_method_set_binding (_tmp774_, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp776_ = last_param;
	if (_tmp776_ != NULL) {
		ValaParameter* _tmp777_;
		const gchar* _tmp778_;
		const gchar* _tmp779_;
		_tmp777_ = last_param;
		_tmp778_ = vala_symbol_get_name ((ValaSymbol*) _tmp777_);
		_tmp779_ = _tmp778_;
		_tmp775_ = g_str_has_prefix (_tmp779_, "first_");
	} else {
		_tmp775_ = FALSE;
	}
	if (_tmp775_) {
		ValaParameter* _tmp780_;
		_tmp780_ = last_param;
		vala_parameter_set_ellipsis (_tmp780_, TRUE);
	} else {
		gboolean _tmp781_;
		_tmp781_ = add_ellipsis;
		if (_tmp781_) {
			ValaMethod* _tmp782_;
			ValaParameter* _tmp783_;
			ValaParameter* _tmp784_;
			_tmp782_ = m;
			_tmp783_ = vala_parameter_new_with_ellipsis (NULL);
			_tmp784_ = _tmp783_;
			vala_callable_add_parameter ((ValaCallable*) _tmp782_, _tmp784_);
			_vala_code_node_unref0 (_tmp784_);
		}
	}
	_tmp785_ = container;
	if (_tmp785_ == NULL) {
		ValaTypeSymbol* _tmp786_;
		ValaSymbol* _tmp787_;
		ValaSymbol* _tmp788_;
		_tmp786_ = self->priv->current_data_type;
		_tmp787_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp786_);
		_vala_code_node_unref0 (container);
		container = _tmp787_;
		_tmp788_ = container;
		if (_tmp788_ == NULL) {
			ValaNamespace* _tmp789_;
			ValaSymbol* _tmp790_;
			_tmp789_ = self->priv->current_namespace;
			_tmp790_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp789_);
			_vala_code_node_unref0 (container);
			container = _tmp790_;
		}
	}
	_tmp791_ = m;
	_tmp792_ = container;
	_tmp793_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp791_, _tmp792_);
	_tmp794_ = _tmp793_;
	_tmp795_ = g_strcmp0 (symbol, _tmp794_) != 0;
	_g_free0 (_tmp794_);
	if (_tmp795_) {
		ValaMethod* _tmp796_;
		_tmp796_ = m;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp796_, "CCode", "cname", symbol, NULL);
	}
	result = m;
	_vala_code_node_unref0 (last_param_type);
	_vala_code_node_unref0 (last_param);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (container);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gchar*
string_chomp (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchomp (_tmp1_);
	result = _result_;
	return result;
}


static gboolean
vala_gidl_parser_param_is_exception (ValaGIdlParser* self,
                                     GIdlNodeParam* param)
{
	gboolean result = FALSE;
	GIdlNodeType* _tmp0_;
	gboolean _tmp1_;
	gchar* s = NULL;
	GIdlNodeType* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param != NULL, FALSE);
	_tmp0_ = param->type;
	_tmp1_ = _tmp0_->is_error;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = param->type;
	_tmp3_ = _tmp2_->unparsed;
	_tmp4_ = string_chomp (_tmp3_);
	s = _tmp4_;
	_tmp5_ = s;
	if (g_str_has_suffix (_tmp5_, "**")) {
		result = TRUE;
		_g_free0 (s);
		return result;
	}
	result = FALSE;
	_g_free0 (s);
	return result;
}


static ValaMethod*
vala_gidl_parser_parse_function (ValaGIdlParser* self,
                                 GIdlNodeFunction* f,
                                 gboolean is_interface)
{
	ValaMethod* result = NULL;
	GIdlNode* node = NULL;
	gboolean _tmp0_;
	GIdlNode* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GIdlNodeParam* _tmp4_;
	GList* _tmp5_;
	gboolean _tmp6_;
	ValaMethod* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	node = (GIdlNode*) f;
	_tmp0_ = f->deprecated;
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = node;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = f->symbol;
	_tmp4_ = f->result;
	_tmp5_ = f->parameters;
	_tmp6_ = f->is_constructor;
	_tmp7_ = vala_gidl_parser_create_method (self, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_, is_interface);
	result = _tmp7_;
	return result;
}


static ValaMethod*
vala_gidl_parser_parse_virtual (ValaGIdlParser* self,
                                GIdlNodeVFunc* v,
                                GIdlNodeFunction* func,
                                gboolean is_interface)
{
	ValaMethod* result = NULL;
	GIdlNode* node = NULL;
	gchar* symbol = NULL;
	ValaTypeSymbol* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GList* _tmp9_ = NULL;
	ValaMethod* m = NULL;
	GIdlNode* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GIdlNodeParam* _tmp15_;
	ValaMethod* _tmp16_;
	ValaMethod* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	node = (GIdlNode*) v;
	_tmp0_ = self->priv->current_data_type;
	_tmp1_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = g_strdup_printf ("%s%s", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp2_);
	symbol = _tmp6_;
	if (func != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = func->symbol;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (symbol);
		symbol = _tmp8_;
	}
	if (func != NULL) {
		GList* _tmp10_;
		_tmp10_ = func->parameters;
		_tmp9_ = _tmp10_;
	} else {
		GList* _tmp11_;
		_tmp11_ = v->parameters;
		_tmp9_ = _tmp11_;
	}
	_tmp12_ = node;
	_tmp13_ = _tmp12_->name;
	_tmp14_ = symbol;
	_tmp15_ = v->result;
	_tmp16_ = vala_gidl_parser_create_method (self, _tmp13_, _tmp14_, _tmp15_, _tmp9_, FALSE, is_interface);
	m = _tmp16_;
	_tmp17_ = m;
	if (_tmp17_ != NULL) {
		ValaMethod* _tmp18_;
		gboolean _tmp19_ = FALSE;
		ValaMethod* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		ValaMethod* _tmp23_;
		gboolean _tmp24_ = FALSE;
		ValaMethod* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		ValaMethod* _tmp28_;
		gchar** attributes = NULL;
		const gchar* _tmp29_;
		gint _tmp30_ = 0;
		gchar** _tmp31_;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		_tmp18_ = m;
		vala_method_set_binding (_tmp18_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = m;
		_tmp21_ = vala_method_get_is_abstract (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			_tmp19_ = TRUE;
		} else {
			_tmp19_ = is_interface;
		}
		_tmp23_ = m;
		vala_method_set_is_virtual (_tmp23_, !_tmp19_);
		_tmp25_ = m;
		_tmp26_ = vala_method_get_is_abstract (_tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_) {
			_tmp24_ = TRUE;
		} else {
			_tmp24_ = is_interface;
		}
		_tmp28_ = m;
		vala_method_set_is_abstract (_tmp28_, _tmp24_);
		_tmp29_ = symbol;
		_tmp31_ = vala_gidl_parser_get_attributes (self, _tmp29_, &_tmp30_);
		attributes = _tmp31_;
		attributes_length1 = _tmp30_;
		_attributes_size_ = attributes_length1;
		_tmp32_ = attributes;
		_tmp32__length1 = attributes_length1;
		if (_tmp32_ != NULL) {
			gchar** _tmp33_;
			gint _tmp33__length1;
			_tmp33_ = attributes;
			_tmp33__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp33_;
				attr_collection_length1 = _tmp33__length1;
				for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
					gchar* _tmp34_;
					gchar* attr = NULL;
					_tmp34_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp34_;
					{
						gchar** nv = NULL;
						const gchar* _tmp35_;
						gchar** _tmp36_;
						gchar** _tmp37_;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp38_;
						gint _tmp38__length1;
						const gchar* _tmp39_;
						_tmp35_ = attr;
						_tmp37_ = _tmp36_ = g_strsplit (_tmp35_, "=", 2);
						nv = _tmp37_;
						nv_length1 = _vala_array_length (_tmp36_);
						_nv_size_ = nv_length1;
						_tmp38_ = nv;
						_tmp38__length1 = nv_length1;
						_tmp39_ = _tmp38_[0];
						if (g_strcmp0 (_tmp39_, "virtual") == 0) {
							gchar** _tmp40_;
							gint _tmp40__length1;
							const gchar* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							gboolean _tmp44_;
							_tmp40_ = nv;
							_tmp40__length1 = nv_length1;
							_tmp41_ = _tmp40_[1];
							_tmp42_ = vala_gidl_parser_eval (self, _tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = g_strcmp0 (_tmp43_, "0") == 0;
							_g_free0 (_tmp43_);
							if (_tmp44_) {
								ValaMethod* _tmp45_;
								ValaMethod* _tmp46_;
								_tmp45_ = m;
								vala_method_set_is_virtual (_tmp45_, FALSE);
								_tmp46_ = m;
								vala_method_set_is_abstract (_tmp46_, FALSE);
							} else {
								ValaMethod* _tmp47_;
								ValaMethod* _tmp48_;
								_tmp47_ = m;
								vala_method_set_is_virtual (_tmp47_, TRUE);
								_tmp48_ = m;
								vala_method_set_is_abstract (_tmp48_, FALSE);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		if (func == NULL) {
			ValaMethod* _tmp49_;
			_tmp49_ = m;
			vala_code_node_set_attribute ((ValaCodeNode*) _tmp49_, "NoWrapper", TRUE, NULL);
		}
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	result = m;
	_g_free0 (symbol);
	return result;
}


static gchar*
vala_gidl_parser_fix_prop_name (ValaGIdlParser* self,
                                const gchar* name)
{
	gchar* result = NULL;
	GString* str = NULL;
	GString* _tmp0_;
	gchar* i = NULL;
	gchar* _tmp1_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = g_strdup (name);
	i = _tmp1_;
	while (TRUE) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gunichar c = 0U;
		const gchar* _tmp5_;
		gunichar _tmp6_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp2_ = i;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!(_tmp4_ > 0)) {
			break;
		}
		_tmp5_ = i;
		c = string_get_char (_tmp5_, (glong) 0);
		_tmp6_ = c;
		if (_tmp6_ == ((gunichar) '-')) {
			GString* _tmp7_;
			_tmp7_ = str;
			g_string_append_c (_tmp7_, '_');
		} else {
			GString* _tmp8_;
			gunichar _tmp9_;
			_tmp8_ = str;
			_tmp9_ = c;
			g_string_append_unichar (_tmp8_, _tmp9_);
		}
		_tmp10_ = i;
		_tmp11_ = g_utf8_next_char (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (i);
		i = _tmp12_;
	}
	_tmp13_ = str;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}


static ValaProperty*
vala_gidl_parser_parse_property (ValaGIdlParser* self,
                                 GIdlNodeProperty* prop_node)
{
	ValaProperty* result = NULL;
	GIdlNode* node = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	ValaProperty* prop = NULL;
	GIdlNode* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GIdlNodeType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaProperty* _tmp12_;
	ValaProperty* _tmp13_;
	ValaProperty* _tmp14_;
	ValaProperty* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GIdlNodeType* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp23_;
	gboolean _tmp32_;
	ValaProperty* _tmp51_;
	ValaDataType* _tmp52_;
	ValaDataType* _tmp53_;
	gchar** attributes = NULL;
	ValaTypeSymbol* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	GIdlNode* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gint _tmp61_ = 0;
	gchar** _tmp62_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	ValaSet* _tmp167_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	node = (GIdlNode*) prop_node;
	_tmp0_ = prop_node->deprecated;
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = prop_node->readable;
	if (!_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = prop_node->writable;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		prop_node->readable = TRUE;
		prop_node->writable = TRUE;
	}
	_tmp4_ = node;
	_tmp5_ = _tmp4_->name;
	_tmp6_ = vala_gidl_parser_fix_prop_name (self, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = prop_node->type;
	_tmp9_ = vala_gidl_parser_parse_type (self, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->current_source_reference;
	_tmp12_ = vala_property_new (_tmp7_, _tmp10_, NULL, NULL, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_vala_code_node_unref0 (_tmp10_);
	_g_free0 (_tmp7_);
	prop = _tmp13_;
	_tmp14_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp15_ = prop;
	vala_property_set_interface_only (_tmp15_, TRUE);
	_tmp17_ = prop_node->type;
	_tmp18_ = _tmp17_->is_interface;
	if (_tmp18_) {
		GIdlNodeType* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = prop_node->type;
		_tmp20_ = _tmp19_->interface;
		_tmp16_ = g_strcmp0 (_tmp20_, "GStrv") == 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaProperty* _tmp21_;
		ValaProperty* _tmp22_;
		_tmp21_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp21_, "CCode", "array_length", FALSE, NULL);
		_tmp22_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp22_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp23_ = prop_node->readable;
	if (_tmp23_) {
		ValaProperty* _tmp24_;
		ValaProperty* _tmp25_;
		ValaDataType* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		ValaPropertyAccessor* _tmp30_;
		ValaPropertyAccessor* _tmp31_;
		_tmp24_ = prop;
		_tmp25_ = prop;
		_tmp26_ = vala_property_get_property_type (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_data_type_copy (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp29_, NULL, NULL, NULL);
		_tmp31_ = _tmp30_;
		vala_property_set_get_accessor (_tmp24_, _tmp31_);
		_vala_code_node_unref0 (_tmp31_);
		_vala_code_node_unref0 (_tmp29_);
	}
	_tmp32_ = prop_node->writable;
	if (_tmp32_) {
		gboolean _tmp33_;
		_tmp33_ = prop_node->construct_only;
		if (_tmp33_) {
			ValaProperty* _tmp34_;
			ValaProperty* _tmp35_;
			ValaDataType* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaDataType* _tmp39_;
			ValaPropertyAccessor* _tmp40_;
			ValaPropertyAccessor* _tmp41_;
			_tmp34_ = prop;
			_tmp35_ = prop;
			_tmp36_ = vala_property_get_property_type (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_data_type_copy (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_property_accessor_new (FALSE, FALSE, TRUE, _tmp39_, NULL, NULL, NULL);
			_tmp41_ = _tmp40_;
			vala_property_set_set_accessor (_tmp34_, _tmp41_);
			_vala_code_node_unref0 (_tmp41_);
			_vala_code_node_unref0 (_tmp39_);
		} else {
			ValaProperty* _tmp42_;
			gboolean _tmp43_;
			ValaProperty* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaPropertyAccessor* _tmp49_;
			ValaPropertyAccessor* _tmp50_;
			_tmp42_ = prop;
			_tmp43_ = prop_node->construct;
			_tmp44_ = prop;
			_tmp45_ = vala_property_get_property_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_copy (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_property_accessor_new (FALSE, TRUE, _tmp43_, _tmp48_, NULL, NULL, NULL);
			_tmp50_ = _tmp49_;
			vala_property_set_set_accessor (_tmp42_, _tmp50_);
			_vala_code_node_unref0 (_tmp50_);
			_vala_code_node_unref0 (_tmp48_);
		}
	}
	_tmp51_ = prop;
	_tmp52_ = vala_property_get_property_type (_tmp51_);
	_tmp53_ = _tmp52_;
	vala_data_type_set_value_owned (_tmp53_, TRUE);
	_tmp54_ = self->priv->current_data_type;
	_tmp55_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp54_, NULL);
	_tmp56_ = _tmp55_;
	_tmp57_ = node;
	_tmp58_ = _tmp57_->name;
	_tmp59_ = g_strdup_printf ("%s:%s", _tmp56_, _tmp58_);
	_tmp60_ = _tmp59_;
	_tmp62_ = vala_gidl_parser_get_attributes (self, _tmp60_, &_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp63__length1 = _tmp61_;
	_g_free0 (_tmp60_);
	_g_free0 (_tmp56_);
	attributes = _tmp63_;
	attributes_length1 = _tmp63__length1;
	_attributes_size_ = attributes_length1;
	_tmp64_ = attributes;
	_tmp64__length1 = attributes_length1;
	if (_tmp64_ != NULL) {
		gchar** _tmp65_;
		gint _tmp65__length1;
		_tmp65_ = attributes;
		_tmp65__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp65_;
			attr_collection_length1 = _tmp65__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp66_;
				gchar* attr = NULL;
				_tmp66_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp66_;
				{
					gchar** nv = NULL;
					const gchar* _tmp67_;
					gchar** _tmp68_;
					gchar** _tmp69_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp70_;
					gint _tmp70__length1;
					const gchar* _tmp71_;
					_tmp67_ = attr;
					_tmp69_ = _tmp68_ = g_strsplit (_tmp67_, "=", 2);
					nv = _tmp69_;
					nv_length1 = _vala_array_length (_tmp68_);
					_nv_size_ = nv_length1;
					_tmp70_ = nv;
					_tmp70__length1 = nv_length1;
					_tmp71_ = _tmp70_[0];
					if (g_strcmp0 (_tmp71_, "hidden") == 0) {
						gchar** _tmp72_;
						gint _tmp72__length1;
						const gchar* _tmp73_;
						gchar* _tmp74_;
						gchar* _tmp75_;
						gboolean _tmp76_;
						_tmp72_ = nv;
						_tmp72__length1 = nv_length1;
						_tmp73_ = _tmp72_[1];
						_tmp74_ = vala_gidl_parser_eval (self, _tmp73_);
						_tmp75_ = _tmp74_;
						_tmp76_ = g_strcmp0 (_tmp75_, "1") == 0;
						_g_free0 (_tmp75_);
						if (_tmp76_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (prop);
							return result;
						}
					} else {
						gchar** _tmp77_;
						gint _tmp77__length1;
						const gchar* _tmp78_;
						_tmp77_ = nv;
						_tmp77__length1 = nv_length1;
						_tmp78_ = _tmp77_[0];
						if (g_strcmp0 (_tmp78_, "type_arguments") == 0) {
							ValaProperty* _tmp79_;
							ValaDataType* _tmp80_;
							ValaDataType* _tmp81_;
							gchar** _tmp82_;
							gint _tmp82__length1;
							const gchar* _tmp83_;
							gchar* _tmp84_;
							gchar* _tmp85_;
							_tmp79_ = prop;
							_tmp80_ = vala_property_get_property_type (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp82_ = nv;
							_tmp82__length1 = nv_length1;
							_tmp83_ = _tmp82_[1];
							_tmp84_ = vala_gidl_parser_eval (self, _tmp83_);
							_tmp85_ = _tmp84_;
							vala_gidl_parser_parse_type_arguments_from_string (self, _tmp81_, _tmp85_, NULL);
							_g_free0 (_tmp85_);
						} else {
							gchar** _tmp86_;
							gint _tmp86__length1;
							const gchar* _tmp87_;
							_tmp86_ = nv;
							_tmp86__length1 = nv_length1;
							_tmp87_ = _tmp86_[0];
							if (g_strcmp0 (_tmp87_, "deprecated") == 0) {
								gchar** _tmp88_;
								gint _tmp88__length1;
								const gchar* _tmp89_;
								gchar* _tmp90_;
								gchar* _tmp91_;
								gboolean _tmp92_;
								_tmp88_ = nv;
								_tmp88__length1 = nv_length1;
								_tmp89_ = _tmp88_[1];
								_tmp90_ = vala_gidl_parser_eval (self, _tmp89_);
								_tmp91_ = _tmp90_;
								_tmp92_ = g_strcmp0 (_tmp91_, "1") == 0;
								_g_free0 (_tmp91_);
								if (_tmp92_) {
									ValaProperty* _tmp93_;
									_tmp93_ = prop;
									vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp93_, "Version", "deprecated", TRUE, NULL);
								}
							} else {
								gchar** _tmp94_;
								gint _tmp94__length1;
								const gchar* _tmp95_;
								_tmp94_ = nv;
								_tmp94__length1 = nv_length1;
								_tmp95_ = _tmp94_[0];
								if (g_strcmp0 (_tmp95_, "replacement") == 0) {
									ValaProperty* _tmp96_;
									gchar** _tmp97_;
									gint _tmp97__length1;
									const gchar* _tmp98_;
									gchar* _tmp99_;
									gchar* _tmp100_;
									_tmp96_ = prop;
									_tmp97_ = nv;
									_tmp97__length1 = nv_length1;
									_tmp98_ = _tmp97_[1];
									_tmp99_ = vala_gidl_parser_eval (self, _tmp98_);
									_tmp100_ = _tmp99_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp96_, "Version", "replacement", _tmp100_, NULL);
									_g_free0 (_tmp100_);
								} else {
									gchar** _tmp101_;
									gint _tmp101__length1;
									const gchar* _tmp102_;
									_tmp101_ = nv;
									_tmp101__length1 = nv_length1;
									_tmp102_ = _tmp101_[0];
									if (g_strcmp0 (_tmp102_, "deprecated_since") == 0) {
										ValaProperty* _tmp103_;
										gchar** _tmp104_;
										gint _tmp104__length1;
										const gchar* _tmp105_;
										gchar* _tmp106_;
										gchar* _tmp107_;
										_tmp103_ = prop;
										_tmp104_ = nv;
										_tmp104__length1 = nv_length1;
										_tmp105_ = _tmp104_[1];
										_tmp106_ = vala_gidl_parser_eval (self, _tmp105_);
										_tmp107_ = _tmp106_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp103_, "Version", "deprecated_since", _tmp107_, NULL);
										_g_free0 (_tmp107_);
									} else {
										gchar** _tmp108_;
										gint _tmp108__length1;
										const gchar* _tmp109_;
										_tmp108_ = nv;
										_tmp108__length1 = nv_length1;
										_tmp109_ = _tmp108_[0];
										if (g_strcmp0 (_tmp109_, "accessor_method") == 0) {
											gchar** _tmp110_;
											gint _tmp110__length1;
											const gchar* _tmp111_;
											gchar* _tmp112_;
											gchar* _tmp113_;
											gboolean _tmp114_;
											_tmp110_ = nv;
											_tmp110__length1 = nv_length1;
											_tmp111_ = _tmp110_[1];
											_tmp112_ = vala_gidl_parser_eval (self, _tmp111_);
											_tmp113_ = _tmp112_;
											_tmp114_ = g_strcmp0 (_tmp113_, "0") == 0;
											_g_free0 (_tmp113_);
											if (_tmp114_) {
												ValaProperty* _tmp115_;
												_tmp115_ = prop;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp115_, "NoAccessorMethod", TRUE, NULL);
											}
										} else {
											gchar** _tmp116_;
											gint _tmp116__length1;
											const gchar* _tmp117_;
											_tmp116_ = nv;
											_tmp116__length1 = nv_length1;
											_tmp117_ = _tmp116_[0];
											if (g_strcmp0 (_tmp117_, "owned_get") == 0) {
												gchar** _tmp118_;
												gint _tmp118__length1;
												const gchar* _tmp119_;
												gchar* _tmp120_;
												gchar* _tmp121_;
												gboolean _tmp122_;
												_tmp118_ = nv;
												_tmp118__length1 = nv_length1;
												_tmp119_ = _tmp118_[1];
												_tmp120_ = vala_gidl_parser_eval (self, _tmp119_);
												_tmp121_ = _tmp120_;
												_tmp122_ = g_strcmp0 (_tmp121_, "1") == 0;
												_g_free0 (_tmp121_);
												if (_tmp122_) {
													ValaProperty* _tmp123_;
													ValaPropertyAccessor* _tmp124_;
													ValaPropertyAccessor* _tmp125_;
													ValaDataType* _tmp126_;
													ValaDataType* _tmp127_;
													_tmp123_ = prop;
													_tmp124_ = vala_property_get_get_accessor (_tmp123_);
													_tmp125_ = _tmp124_;
													_tmp126_ = vala_property_accessor_get_value_type (_tmp125_);
													_tmp127_ = _tmp126_;
													vala_data_type_set_value_owned (_tmp127_, TRUE);
												}
											} else {
												gchar** _tmp128_;
												gint _tmp128__length1;
												const gchar* _tmp129_;
												_tmp128_ = nv;
												_tmp128__length1 = nv_length1;
												_tmp129_ = _tmp128_[0];
												if (g_strcmp0 (_tmp129_, "type_name") == 0) {
													ValaProperty* _tmp130_;
													gchar** _tmp131_;
													gint _tmp131__length1;
													const gchar* _tmp132_;
													gchar* _tmp133_;
													gchar* _tmp134_;
													ValaDataType* _tmp135_;
													ValaDataType* _tmp136_;
													_tmp130_ = prop;
													_tmp131_ = nv;
													_tmp131__length1 = nv_length1;
													_tmp132_ = _tmp131_[1];
													_tmp133_ = vala_gidl_parser_eval (self, _tmp132_);
													_tmp134_ = _tmp133_;
													_tmp135_ = vala_gidl_parser_parse_type_from_string (self, _tmp134_, FALSE, NULL);
													_tmp136_ = _tmp135_;
													vala_property_set_property_type (_tmp130_, _tmp136_);
													_vala_code_node_unref0 (_tmp136_);
													_g_free0 (_tmp134_);
												} else {
													gchar** _tmp137_;
													gint _tmp137__length1;
													const gchar* _tmp138_;
													_tmp137_ = nv;
													_tmp137__length1 = nv_length1;
													_tmp138_ = _tmp137_[0];
													if (g_strcmp0 (_tmp138_, "experimental") == 0) {
														gchar** _tmp139_;
														gint _tmp139__length1;
														const gchar* _tmp140_;
														gchar* _tmp141_;
														gchar* _tmp142_;
														gboolean _tmp143_;
														_tmp139_ = nv;
														_tmp139__length1 = nv_length1;
														_tmp140_ = _tmp139_[1];
														_tmp141_ = vala_gidl_parser_eval (self, _tmp140_);
														_tmp142_ = _tmp141_;
														_tmp143_ = g_strcmp0 (_tmp142_, "1") == 0;
														_g_free0 (_tmp142_);
														if (_tmp143_) {
															ValaProperty* _tmp144_;
															_tmp144_ = prop;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp144_, "Version", "experimental", TRUE, NULL);
														}
													} else {
														gchar** _tmp145_;
														gint _tmp145__length1;
														const gchar* _tmp146_;
														_tmp145_ = nv;
														_tmp145__length1 = nv_length1;
														_tmp146_ = _tmp145_[0];
														if (g_strcmp0 (_tmp146_, "nullable") == 0) {
															gboolean _tmp147_ = FALSE;
															gchar** _tmp148_;
															gint _tmp148__length1;
															const gchar* _tmp149_;
															gchar* _tmp150_;
															gchar* _tmp151_;
															gboolean _tmp152_;
															_tmp148_ = nv;
															_tmp148__length1 = nv_length1;
															_tmp149_ = _tmp148_[1];
															_tmp150_ = vala_gidl_parser_eval (self, _tmp149_);
															_tmp151_ = _tmp150_;
															_tmp152_ = g_strcmp0 (_tmp151_, "1") == 0;
															_g_free0 (_tmp151_);
															if (_tmp152_) {
																ValaProperty* _tmp153_;
																ValaDataType* _tmp154_;
																ValaDataType* _tmp155_;
																_tmp153_ = prop;
																_tmp154_ = vala_property_get_property_type (_tmp153_);
																_tmp155_ = _tmp154_;
																_tmp147_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_VOID_TYPE);
															} else {
																_tmp147_ = FALSE;
															}
															if (_tmp147_) {
																ValaProperty* _tmp156_;
																ValaDataType* _tmp157_;
																ValaDataType* _tmp158_;
																_tmp156_ = prop;
																_tmp157_ = vala_property_get_property_type (_tmp156_);
																_tmp158_ = _tmp157_;
																vala_data_type_set_nullable (_tmp158_, TRUE);
															}
														} else {
															gchar** _tmp159_;
															gint _tmp159__length1;
															const gchar* _tmp160_;
															_tmp159_ = nv;
															_tmp159__length1 = nv_length1;
															_tmp160_ = _tmp159_[0];
															if (g_strcmp0 (_tmp160_, "abstract") == 0) {
																gchar** _tmp161_;
																gint _tmp161__length1;
																const gchar* _tmp162_;
																gchar* _tmp163_;
																gchar* _tmp164_;
																gboolean _tmp165_;
																_tmp161_ = nv;
																_tmp161__length1 = nv_length1;
																_tmp162_ = _tmp161_[1];
																_tmp163_ = vala_gidl_parser_eval (self, _tmp162_);
																_tmp164_ = _tmp163_;
																_tmp165_ = g_strcmp0 (_tmp164_, "1") == 0;
																_g_free0 (_tmp164_);
																if (_tmp165_) {
																	ValaProperty* _tmp166_;
																	_tmp166_ = prop;
																	vala_property_set_is_abstract (_tmp166_, TRUE);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp167_ = self->priv->current_type_symbol_set;
	if (_tmp167_ != NULL) {
		ValaSet* _tmp168_;
		ValaProperty* _tmp169_;
		const gchar* _tmp170_;
		const gchar* _tmp171_;
		_tmp168_ = self->priv->current_type_symbol_set;
		_tmp169_ = prop;
		_tmp170_ = vala_symbol_get_name ((ValaSymbol*) _tmp169_);
		_tmp171_ = _tmp170_;
		vala_collection_add ((ValaCollection*) _tmp168_, _tmp171_);
	}
	result = prop;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaConstant*
vala_gidl_parser_parse_constant (ValaGIdlParser* self,
                                 GIdlNodeConstant* const_node)
{
	ValaConstant* result = NULL;
	GIdlNode* node = NULL;
	ValaDataType* type = NULL;
	GIdlNodeType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaConstant* c = NULL;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaConstant* _tmp7_;
	ValaConstant* _tmp8_;
	gchar** attributes = NULL;
	GIdlNode* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	ValaConstant* _tmp63_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_node != NULL, NULL);
	node = (GIdlNode*) const_node;
	_tmp0_ = const_node->type;
	_tmp1_ = vala_gidl_parser_parse_type (self, _tmp0_, NULL);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = type;
	_tmp6_ = self->priv->current_source_reference;
	_tmp7_ = vala_constant_new (_tmp4_, _tmp5_, NULL, _tmp6_, NULL);
	c = _tmp7_;
	_tmp8_ = c;
	vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
	_tmp9_ = node;
	_tmp10_ = _tmp9_->name;
	_tmp12_ = vala_gidl_parser_get_attributes (self, _tmp10_, &_tmp11_);
	attributes = _tmp12_;
	attributes_length1 = _tmp11_;
	_attributes_size_ = attributes_length1;
	_tmp13_ = attributes;
	_tmp13__length1 = attributes_length1;
	if (_tmp13_ != NULL) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = attributes;
		_tmp14__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp14_;
			attr_collection_length1 = _tmp14__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp15_;
				gchar* attr = NULL;
				_tmp15_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp15_;
				{
					gchar** nv = NULL;
					const gchar* _tmp16_;
					gchar** _tmp17_;
					gchar** _tmp18_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					_tmp16_ = attr;
					_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "=", 2);
					nv = _tmp18_;
					nv_length1 = _vala_array_length (_tmp17_);
					_nv_size_ = nv_length1;
					_tmp19_ = nv;
					_tmp19__length1 = nv_length1;
					_tmp20_ = _tmp19_[0];
					if (g_strcmp0 (_tmp20_, "cheader_filename") == 0) {
						ValaConstant* _tmp21_;
						gchar** _tmp22_;
						gint _tmp22__length1;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp21_ = c;
						_tmp22_ = nv;
						_tmp22__length1 = nv_length1;
						_tmp23_ = _tmp22_[1];
						_tmp24_ = vala_gidl_parser_eval (self, _tmp23_);
						_tmp25_ = _tmp24_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp21_, "CCode", "cheader_filename", _tmp25_, NULL);
						_g_free0 (_tmp25_);
					} else {
						gchar** _tmp26_;
						gint _tmp26__length1;
						const gchar* _tmp27_;
						_tmp26_ = nv;
						_tmp26__length1 = nv_length1;
						_tmp27_ = _tmp26_[0];
						if (g_strcmp0 (_tmp27_, "deprecated") == 0) {
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gboolean _tmp32_;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[1];
							_tmp30_ = vala_gidl_parser_eval (self, _tmp29_);
							_tmp31_ = _tmp30_;
							_tmp32_ = g_strcmp0 (_tmp31_, "1") == 0;
							_g_free0 (_tmp31_);
							if (_tmp32_) {
								ValaConstant* _tmp33_;
								_tmp33_ = c;
								vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp33_, "Version", "deprecated", TRUE, NULL);
							}
						} else {
							gchar** _tmp34_;
							gint _tmp34__length1;
							const gchar* _tmp35_;
							_tmp34_ = nv;
							_tmp34__length1 = nv_length1;
							_tmp35_ = _tmp34_[0];
							if (g_strcmp0 (_tmp35_, "replacement") == 0) {
								ValaConstant* _tmp36_;
								gchar** _tmp37_;
								gint _tmp37__length1;
								const gchar* _tmp38_;
								gchar* _tmp39_;
								gchar* _tmp40_;
								_tmp36_ = c;
								_tmp37_ = nv;
								_tmp37__length1 = nv_length1;
								_tmp38_ = _tmp37_[1];
								_tmp39_ = vala_gidl_parser_eval (self, _tmp38_);
								_tmp40_ = _tmp39_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp36_, "Version", "replacement", _tmp40_, NULL);
								_g_free0 (_tmp40_);
							} else {
								gchar** _tmp41_;
								gint _tmp41__length1;
								const gchar* _tmp42_;
								_tmp41_ = nv;
								_tmp41__length1 = nv_length1;
								_tmp42_ = _tmp41_[0];
								if (g_strcmp0 (_tmp42_, "deprecated_since") == 0) {
									ValaConstant* _tmp43_;
									gchar** _tmp44_;
									gint _tmp44__length1;
									const gchar* _tmp45_;
									gchar* _tmp46_;
									gchar* _tmp47_;
									_tmp43_ = c;
									_tmp44_ = nv;
									_tmp44__length1 = nv_length1;
									_tmp45_ = _tmp44_[1];
									_tmp46_ = vala_gidl_parser_eval (self, _tmp45_);
									_tmp47_ = _tmp46_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp43_, "Version", "deprecated_since", _tmp47_, NULL);
									_g_free0 (_tmp47_);
								} else {
									gchar** _tmp48_;
									gint _tmp48__length1;
									const gchar* _tmp49_;
									_tmp48_ = nv;
									_tmp48__length1 = nv_length1;
									_tmp49_ = _tmp48_[0];
									if (g_strcmp0 (_tmp49_, "hidden") == 0) {
										gchar** _tmp50_;
										gint _tmp50__length1;
										const gchar* _tmp51_;
										gchar* _tmp52_;
										gchar* _tmp53_;
										gboolean _tmp54_;
										_tmp50_ = nv;
										_tmp50__length1 = nv_length1;
										_tmp51_ = _tmp50_[1];
										_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
										_tmp53_ = _tmp52_;
										_tmp54_ = g_strcmp0 (_tmp53_, "1") == 0;
										_g_free0 (_tmp53_);
										if (_tmp54_) {
											result = NULL;
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
											_vala_code_node_unref0 (c);
											_vala_code_node_unref0 (type);
											return result;
										}
									} else {
										gchar** _tmp55_;
										gint _tmp55__length1;
										const gchar* _tmp56_;
										_tmp55_ = nv;
										_tmp55__length1 = nv_length1;
										_tmp56_ = _tmp55_[0];
										if (g_strcmp0 (_tmp56_, "experimental") == 0) {
											gchar** _tmp57_;
											gint _tmp57__length1;
											const gchar* _tmp58_;
											gchar* _tmp59_;
											gchar* _tmp60_;
											gboolean _tmp61_;
											_tmp57_ = nv;
											_tmp57__length1 = nv_length1;
											_tmp58_ = _tmp57_[1];
											_tmp59_ = vala_gidl_parser_eval (self, _tmp58_);
											_tmp60_ = _tmp59_;
											_tmp61_ = g_strcmp0 (_tmp60_, "1") == 0;
											_g_free0 (_tmp60_);
											if (_tmp61_) {
												ValaConstant* _tmp62_;
												_tmp62_ = c;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp62_, "Version", "experimental", TRUE, NULL);
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp63_ = c;
	vala_symbol_set_access ((ValaSymbol*) _tmp63_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	result = c;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaField*
vala_gidl_parser_parse_field (ValaGIdlParser* self,
                              GIdlNodeField* field_node)
{
	ValaField* result = NULL;
	GIdlNode* node = NULL;
	gboolean unhidden = FALSE;
	ValaDataType* type = NULL;
	GIdlNodeType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gchar* cheader_filename = NULL;
	gchar* ctype = NULL;
	gchar* array_length_cname = NULL;
	gchar* array_length_type = NULL;
	gboolean array_null_terminated = FALSE;
	gboolean deprecated = FALSE;
	gchar* deprecated_since = NULL;
	gchar* replacement = NULL;
	gboolean experimental = FALSE;
	gboolean no_delegate_target = FALSE;
	gchar** attributes = NULL;
	ValaTypeSymbol* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GIdlNode* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_ = 0;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gboolean _tmp133_ = FALSE;
	GIdlNode* _tmp134_;
	const gchar* _tmp135_;
	ValaSet* _tmp137_;
	gchar* field_name = NULL;
	GIdlNode* _tmp141_;
	const gchar* _tmp142_;
	gchar* _tmp143_;
	const gchar* _tmp144_;
	ValaField* field = NULL;
	const gchar* _tmp146_;
	ValaDataType* _tmp147_;
	ValaSourceReference* _tmp148_;
	ValaField* _tmp149_;
	ValaField* _tmp150_;
	const gchar* _tmp151_;
	GIdlNode* _tmp152_;
	const gchar* _tmp153_;
	gboolean _tmp157_;
	gboolean _tmp165_;
	const gchar* _tmp167_;
	const gchar* _tmp170_;
	gboolean _tmp173_;
	gboolean _tmp175_ = FALSE;
	const gchar* _tmp176_;
	gboolean _tmp188_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_node != NULL, NULL);
	node = (GIdlNode*) field_node;
	unhidden = FALSE;
	_tmp0_ = field_node->type;
	_tmp1_ = vala_gidl_parser_parse_type (self, _tmp0_, NULL);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	cheader_filename = NULL;
	ctype = NULL;
	array_length_cname = NULL;
	array_length_type = NULL;
	array_null_terminated = FALSE;
	deprecated = FALSE;
	deprecated_since = NULL;
	replacement = NULL;
	experimental = FALSE;
	no_delegate_target = FALSE;
	_tmp3_ = self->priv->current_data_type;
	_tmp4_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = node;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = g_strdup_printf ("%s.%s", _tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp11_ = vala_gidl_parser_get_attributes (self, _tmp9_, &_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
	attributes = _tmp12_;
	attributes_length1 = _tmp12__length1;
	_attributes_size_ = attributes_length1;
	_tmp13_ = attributes;
	_tmp13__length1 = attributes_length1;
	if (_tmp13_ != NULL) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = attributes;
		_tmp14__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp14_;
			attr_collection_length1 = _tmp14__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp15_;
				gchar* attr = NULL;
				_tmp15_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp15_;
				{
					gchar** nv = NULL;
					const gchar* _tmp16_;
					gchar** _tmp17_;
					gchar** _tmp18_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					_tmp16_ = attr;
					_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "=", 2);
					nv = _tmp18_;
					nv_length1 = _vala_array_length (_tmp17_);
					_nv_size_ = nv_length1;
					_tmp19_ = nv;
					_tmp19__length1 = nv_length1;
					_tmp20_ = _tmp19_[0];
					if (g_strcmp0 (_tmp20_, "hidden") == 0) {
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gboolean _tmp25_;
						_tmp21_ = nv;
						_tmp21__length1 = nv_length1;
						_tmp22_ = _tmp21_[1];
						_tmp23_ = vala_gidl_parser_eval (self, _tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0;
						_g_free0 (_tmp24_);
						if (_tmp25_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (replacement);
							_g_free0 (deprecated_since);
							_g_free0 (array_length_type);
							_g_free0 (array_length_cname);
							_g_free0 (ctype);
							_g_free0 (cheader_filename);
							_vala_code_node_unref0 (type);
							return result;
						} else {
							unhidden = TRUE;
						}
					} else {
						gchar** _tmp26_;
						gint _tmp26__length1;
						const gchar* _tmp27_;
						_tmp26_ = nv;
						_tmp26__length1 = nv_length1;
						_tmp27_ = _tmp26_[0];
						if (g_strcmp0 (_tmp27_, "is_array") == 0) {
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gboolean _tmp32_;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[1];
							_tmp30_ = vala_gidl_parser_eval (self, _tmp29_);
							_tmp31_ = _tmp30_;
							_tmp32_ = g_strcmp0 (_tmp31_, "1") == 0;
							_g_free0 (_tmp31_);
							if (_tmp32_) {
								ValaDataType* _tmp33_;
								ValaDataType* _tmp34_;
								ValaDataType* _tmp35_;
								ValaSourceReference* _tmp36_;
								ValaSourceReference* _tmp37_;
								ValaArrayType* _tmp38_;
								_tmp33_ = type;
								vala_data_type_set_value_owned (_tmp33_, TRUE);
								_tmp34_ = type;
								_tmp35_ = type;
								_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = vala_array_type_new (_tmp34_, 1, _tmp37_);
								_vala_code_node_unref0 (type);
								type = (ValaDataType*) _tmp38_;
							}
						} else {
							gchar** _tmp39_;
							gint _tmp39__length1;
							const gchar* _tmp40_;
							_tmp39_ = nv;
							_tmp39__length1 = nv_length1;
							_tmp40_ = _tmp39_[0];
							if (g_strcmp0 (_tmp40_, "weak") == 0) {
								gchar** _tmp41_;
								gint _tmp41__length1;
								const gchar* _tmp42_;
								gchar* _tmp43_;
								gchar* _tmp44_;
								gboolean _tmp45_;
								_tmp41_ = nv;
								_tmp41__length1 = nv_length1;
								_tmp42_ = _tmp41_[1];
								_tmp43_ = vala_gidl_parser_eval (self, _tmp42_);
								_tmp44_ = _tmp43_;
								_tmp45_ = g_strcmp0 (_tmp44_, "0") == 0;
								_g_free0 (_tmp44_);
								if (_tmp45_) {
									ValaDataType* _tmp46_;
									_tmp46_ = type;
									vala_data_type_set_value_owned (_tmp46_, TRUE);
								}
							} else {
								gchar** _tmp47_;
								gint _tmp47__length1;
								const gchar* _tmp48_;
								_tmp47_ = nv;
								_tmp47__length1 = nv_length1;
								_tmp48_ = _tmp47_[0];
								if (g_strcmp0 (_tmp48_, "value_owned") == 0) {
									gchar** _tmp49_;
									gint _tmp49__length1;
									const gchar* _tmp50_;
									gchar* _tmp51_;
									gchar* _tmp52_;
									gboolean _tmp53_;
									_tmp49_ = nv;
									_tmp49__length1 = nv_length1;
									_tmp50_ = _tmp49_[1];
									_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
									_tmp52_ = _tmp51_;
									_tmp53_ = g_strcmp0 (_tmp52_, "0") == 0;
									_g_free0 (_tmp52_);
									if (_tmp53_) {
										ValaDataType* _tmp54_;
										_tmp54_ = type;
										vala_data_type_set_value_owned (_tmp54_, FALSE);
									} else {
										gchar** _tmp55_;
										gint _tmp55__length1;
										const gchar* _tmp56_;
										gchar* _tmp57_;
										gchar* _tmp58_;
										gboolean _tmp59_;
										_tmp55_ = nv;
										_tmp55__length1 = nv_length1;
										_tmp56_ = _tmp55_[1];
										_tmp57_ = vala_gidl_parser_eval (self, _tmp56_);
										_tmp58_ = _tmp57_;
										_tmp59_ = g_strcmp0 (_tmp58_, "1") == 0;
										_g_free0 (_tmp58_);
										if (_tmp59_) {
											ValaDataType* _tmp60_;
											_tmp60_ = type;
											vala_data_type_set_value_owned (_tmp60_, TRUE);
										}
									}
								} else {
									gchar** _tmp61_;
									gint _tmp61__length1;
									const gchar* _tmp62_;
									_tmp61_ = nv;
									_tmp61__length1 = nv_length1;
									_tmp62_ = _tmp61_[0];
									if (g_strcmp0 (_tmp62_, "type_name") == 0) {
										gchar** _tmp63_;
										gint _tmp63__length1;
										const gchar* _tmp64_;
										gchar* _tmp65_;
										gchar* _tmp66_;
										ValaDataType* _tmp67_;
										_tmp63_ = nv;
										_tmp63__length1 = nv_length1;
										_tmp64_ = _tmp63_[1];
										_tmp65_ = vala_gidl_parser_eval (self, _tmp64_);
										_tmp66_ = _tmp65_;
										_tmp67_ = vala_gidl_parser_parse_type_from_string (self, _tmp66_, TRUE, NULL);
										_vala_code_node_unref0 (type);
										type = _tmp67_;
										_g_free0 (_tmp66_);
									} else {
										gchar** _tmp68_;
										gint _tmp68__length1;
										const gchar* _tmp69_;
										_tmp68_ = nv;
										_tmp68__length1 = nv_length1;
										_tmp69_ = _tmp68_[0];
										if (g_strcmp0 (_tmp69_, "type_arguments") == 0) {
											ValaDataType* _tmp70_;
											gchar** _tmp71_;
											gint _tmp71__length1;
											const gchar* _tmp72_;
											gchar* _tmp73_;
											gchar* _tmp74_;
											_tmp70_ = type;
											_tmp71_ = nv;
											_tmp71__length1 = nv_length1;
											_tmp72_ = _tmp71_[1];
											_tmp73_ = vala_gidl_parser_eval (self, _tmp72_);
											_tmp74_ = _tmp73_;
											vala_gidl_parser_parse_type_arguments_from_string (self, _tmp70_, _tmp74_, NULL);
											_g_free0 (_tmp74_);
										} else {
											gchar** _tmp75_;
											gint _tmp75__length1;
											const gchar* _tmp76_;
											_tmp75_ = nv;
											_tmp75__length1 = nv_length1;
											_tmp76_ = _tmp75_[0];
											if (g_strcmp0 (_tmp76_, "deprecated") == 0) {
												gchar** _tmp77_;
												gint _tmp77__length1;
												const gchar* _tmp78_;
												gchar* _tmp79_;
												gchar* _tmp80_;
												gboolean _tmp81_;
												_tmp77_ = nv;
												_tmp77__length1 = nv_length1;
												_tmp78_ = _tmp77_[1];
												_tmp79_ = vala_gidl_parser_eval (self, _tmp78_);
												_tmp80_ = _tmp79_;
												_tmp81_ = g_strcmp0 (_tmp80_, "1") == 0;
												_g_free0 (_tmp80_);
												if (_tmp81_) {
													deprecated = TRUE;
												}
											} else {
												gchar** _tmp82_;
												gint _tmp82__length1;
												const gchar* _tmp83_;
												_tmp82_ = nv;
												_tmp82__length1 = nv_length1;
												_tmp83_ = _tmp82_[0];
												if (g_strcmp0 (_tmp83_, "replacement") == 0) {
													gchar** _tmp84_;
													gint _tmp84__length1;
													const gchar* _tmp85_;
													gchar* _tmp86_;
													_tmp84_ = nv;
													_tmp84__length1 = nv_length1;
													_tmp85_ = _tmp84_[1];
													_tmp86_ = vala_gidl_parser_eval (self, _tmp85_);
													_g_free0 (replacement);
													replacement = _tmp86_;
												} else {
													gchar** _tmp87_;
													gint _tmp87__length1;
													const gchar* _tmp88_;
													_tmp87_ = nv;
													_tmp87__length1 = nv_length1;
													_tmp88_ = _tmp87_[0];
													if (g_strcmp0 (_tmp88_, "deprecated_since") == 0) {
														gchar** _tmp89_;
														gint _tmp89__length1;
														const gchar* _tmp90_;
														gchar* _tmp91_;
														_tmp89_ = nv;
														_tmp89__length1 = nv_length1;
														_tmp90_ = _tmp89_[1];
														_tmp91_ = vala_gidl_parser_eval (self, _tmp90_);
														_g_free0 (deprecated_since);
														deprecated_since = _tmp91_;
													} else {
														gchar** _tmp92_;
														gint _tmp92__length1;
														const gchar* _tmp93_;
														_tmp92_ = nv;
														_tmp92__length1 = nv_length1;
														_tmp93_ = _tmp92_[0];
														if (g_strcmp0 (_tmp93_, "cheader_filename") == 0) {
															gchar** _tmp94_;
															gint _tmp94__length1;
															const gchar* _tmp95_;
															gchar* _tmp96_;
															_tmp94_ = nv;
															_tmp94__length1 = nv_length1;
															_tmp95_ = _tmp94_[1];
															_tmp96_ = vala_gidl_parser_eval (self, _tmp95_);
															_g_free0 (cheader_filename);
															cheader_filename = _tmp96_;
														} else {
															gchar** _tmp97_;
															gint _tmp97__length1;
															const gchar* _tmp98_;
															_tmp97_ = nv;
															_tmp97__length1 = nv_length1;
															_tmp98_ = _tmp97_[0];
															if (g_strcmp0 (_tmp98_, "ctype") == 0) {
																gchar** _tmp99_;
																gint _tmp99__length1;
																const gchar* _tmp100_;
																gchar* _tmp101_;
																_tmp99_ = nv;
																_tmp99__length1 = nv_length1;
																_tmp100_ = _tmp99_[1];
																_tmp101_ = vala_gidl_parser_eval (self, _tmp100_);
																_g_free0 (ctype);
																ctype = _tmp101_;
															} else {
																gchar** _tmp102_;
																gint _tmp102__length1;
																const gchar* _tmp103_;
																_tmp102_ = nv;
																_tmp102__length1 = nv_length1;
																_tmp103_ = _tmp102_[0];
																if (g_strcmp0 (_tmp103_, "array_null_terminated") == 0) {
																	gchar** _tmp104_;
																	gint _tmp104__length1;
																	const gchar* _tmp105_;
																	gchar* _tmp106_;
																	gchar* _tmp107_;
																	gboolean _tmp108_;
																	_tmp104_ = nv;
																	_tmp104__length1 = nv_length1;
																	_tmp105_ = _tmp104_[1];
																	_tmp106_ = vala_gidl_parser_eval (self, _tmp105_);
																	_tmp107_ = _tmp106_;
																	_tmp108_ = g_strcmp0 (_tmp107_, "1") == 0;
																	_g_free0 (_tmp107_);
																	if (_tmp108_) {
																		array_null_terminated = TRUE;
																	}
																} else {
																	gchar** _tmp109_;
																	gint _tmp109__length1;
																	const gchar* _tmp110_;
																	_tmp109_ = nv;
																	_tmp109__length1 = nv_length1;
																	_tmp110_ = _tmp109_[0];
																	if (g_strcmp0 (_tmp110_, "array_length_cname") == 0) {
																		gchar** _tmp111_;
																		gint _tmp111__length1;
																		const gchar* _tmp112_;
																		gchar* _tmp113_;
																		_tmp111_ = nv;
																		_tmp111__length1 = nv_length1;
																		_tmp112_ = _tmp111_[1];
																		_tmp113_ = vala_gidl_parser_eval (self, _tmp112_);
																		_g_free0 (array_length_cname);
																		array_length_cname = _tmp113_;
																	} else {
																		gchar** _tmp114_;
																		gint _tmp114__length1;
																		const gchar* _tmp115_;
																		_tmp114_ = nv;
																		_tmp114__length1 = nv_length1;
																		_tmp115_ = _tmp114_[0];
																		if (g_strcmp0 (_tmp115_, "array_length_type") == 0) {
																			gchar** _tmp116_;
																			gint _tmp116__length1;
																			const gchar* _tmp117_;
																			gchar* _tmp118_;
																			_tmp116_ = nv;
																			_tmp116__length1 = nv_length1;
																			_tmp117_ = _tmp116_[1];
																			_tmp118_ = vala_gidl_parser_eval (self, _tmp117_);
																			_g_free0 (array_length_type);
																			array_length_type = _tmp118_;
																		} else {
																			gchar** _tmp119_;
																			gint _tmp119__length1;
																			const gchar* _tmp120_;
																			_tmp119_ = nv;
																			_tmp119__length1 = nv_length1;
																			_tmp120_ = _tmp119_[0];
																			if (g_strcmp0 (_tmp120_, "no_delegate_target") == 0) {
																				gchar** _tmp121_;
																				gint _tmp121__length1;
																				const gchar* _tmp122_;
																				gchar* _tmp123_;
																				gchar* _tmp124_;
																				gboolean _tmp125_;
																				_tmp121_ = nv;
																				_tmp121__length1 = nv_length1;
																				_tmp122_ = _tmp121_[1];
																				_tmp123_ = vala_gidl_parser_eval (self, _tmp122_);
																				_tmp124_ = _tmp123_;
																				_tmp125_ = g_strcmp0 (_tmp124_, "1") == 0;
																				_g_free0 (_tmp124_);
																				if (_tmp125_) {
																					no_delegate_target = TRUE;
																				}
																			} else {
																				gchar** _tmp126_;
																				gint _tmp126__length1;
																				const gchar* _tmp127_;
																				_tmp126_ = nv;
																				_tmp126__length1 = nv_length1;
																				_tmp127_ = _tmp126_[0];
																				if (g_strcmp0 (_tmp127_, "experimental") == 0) {
																					gchar** _tmp128_;
																					gint _tmp128__length1;
																					const gchar* _tmp129_;
																					gchar* _tmp130_;
																					gchar* _tmp131_;
																					gboolean _tmp132_;
																					_tmp128_ = nv;
																					_tmp128__length1 = nv_length1;
																					_tmp129_ = _tmp128_[1];
																					_tmp130_ = vala_gidl_parser_eval (self, _tmp129_);
																					_tmp131_ = _tmp130_;
																					_tmp132_ = g_strcmp0 (_tmp131_, "1") == 0;
																					_g_free0 (_tmp131_);
																					if (_tmp132_) {
																						experimental = TRUE;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp134_ = node;
	_tmp135_ = _tmp134_->name;
	if (g_str_has_prefix (_tmp135_, "_")) {
		gboolean _tmp136_;
		_tmp136_ = unhidden;
		_tmp133_ = !_tmp136_;
	} else {
		_tmp133_ = FALSE;
	}
	if (_tmp133_) {
		result = NULL;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (replacement);
		_g_free0 (deprecated_since);
		_g_free0 (array_length_type);
		_g_free0 (array_length_cname);
		_g_free0 (ctype);
		_g_free0 (cheader_filename);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp137_ = self->priv->current_type_symbol_set;
	if (_tmp137_ != NULL) {
		ValaSet* _tmp138_;
		GIdlNode* _tmp139_;
		const gchar* _tmp140_;
		_tmp138_ = self->priv->current_type_symbol_set;
		_tmp139_ = node;
		_tmp140_ = _tmp139_->name;
		vala_collection_add ((ValaCollection*) _tmp138_, _tmp140_);
	}
	_tmp141_ = node;
	_tmp142_ = _tmp141_->name;
	_tmp143_ = g_strdup (_tmp142_);
	field_name = _tmp143_;
	_tmp144_ = field_name;
	if (g_strcmp0 (_tmp144_, "string") == 0) {
		gchar* _tmp145_;
		_tmp145_ = g_strdup ("str");
		_g_free0 (field_name);
		field_name = _tmp145_;
	}
	_tmp146_ = field_name;
	_tmp147_ = type;
	_tmp148_ = self->priv->current_source_reference;
	_tmp149_ = vala_field_new (_tmp146_, _tmp147_, NULL, _tmp148_, NULL);
	field = _tmp149_;
	_tmp150_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp150_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp151_ = field_name;
	_tmp152_ = node;
	_tmp153_ = _tmp152_->name;
	if (g_strcmp0 (_tmp151_, _tmp153_) != 0) {
		ValaField* _tmp154_;
		GIdlNode* _tmp155_;
		const gchar* _tmp156_;
		_tmp154_ = field;
		_tmp155_ = node;
		_tmp156_ = _tmp155_->name;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp154_, "CCode", "cname", _tmp156_, NULL);
	}
	_tmp157_ = deprecated;
	if (_tmp157_) {
		ValaField* _tmp158_;
		const gchar* _tmp159_;
		const gchar* _tmp162_;
		_tmp158_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp158_, "Version", "deprecated", TRUE, NULL);
		_tmp159_ = deprecated_since;
		if (_tmp159_ != NULL) {
			ValaField* _tmp160_;
			const gchar* _tmp161_;
			_tmp160_ = field;
			_tmp161_ = deprecated_since;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp160_, "Version", "deprecated_since", _tmp161_, NULL);
		}
		_tmp162_ = replacement;
		if (_tmp162_ != NULL) {
			ValaField* _tmp163_;
			const gchar* _tmp164_;
			_tmp163_ = field;
			_tmp164_ = replacement;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp163_, "Version", "replacement", _tmp164_, NULL);
		}
	}
	_tmp165_ = experimental;
	if (_tmp165_) {
		ValaField* _tmp166_;
		_tmp166_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp166_, "Version", "experimental", TRUE, NULL);
	}
	_tmp167_ = ctype;
	if (_tmp167_ != NULL) {
		ValaField* _tmp168_;
		const gchar* _tmp169_;
		_tmp168_ = field;
		_tmp169_ = ctype;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp168_, "CCode", "type", _tmp169_, NULL);
	}
	_tmp170_ = cheader_filename;
	if (_tmp170_ != NULL) {
		ValaField* _tmp171_;
		const gchar* _tmp172_;
		_tmp171_ = field;
		_tmp172_ = cheader_filename;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp171_, "CCode", "cheader_filename", _tmp172_, NULL);
	}
	_tmp173_ = array_null_terminated;
	if (_tmp173_) {
		ValaField* _tmp174_;
		_tmp174_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp174_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp176_ = array_length_cname;
	if (_tmp176_ != NULL) {
		_tmp175_ = TRUE;
	} else {
		const gchar* _tmp177_;
		_tmp177_ = array_length_type;
		_tmp175_ = _tmp177_ != NULL;
	}
	if (_tmp175_) {
		const gchar* _tmp178_;
		const gchar* _tmp181_;
		_tmp178_ = array_length_cname;
		if (_tmp178_ != NULL) {
			ValaField* _tmp179_;
			const gchar* _tmp180_;
			_tmp179_ = field;
			_tmp180_ = array_length_cname;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp179_, "CCode", "array_length_cname", _tmp180_, NULL);
		}
		_tmp181_ = array_length_type;
		if (_tmp181_ != NULL) {
			ValaField* _tmp182_;
			const gchar* _tmp183_;
			_tmp182_ = field;
			_tmp183_ = array_length_type;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp182_, "CCode", "array_length_type", _tmp183_, NULL);
		}
	} else {
		ValaField* _tmp184_;
		ValaDataType* _tmp185_;
		ValaDataType* _tmp186_;
		_tmp184_ = field;
		_tmp185_ = vala_variable_get_variable_type ((ValaVariable*) _tmp184_);
		_tmp186_ = _tmp185_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp186_, VALA_TYPE_ARRAY_TYPE)) {
			ValaField* _tmp187_;
			_tmp187_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp187_, "CCode", "array_length", FALSE, NULL);
		}
	}
	_tmp188_ = no_delegate_target;
	if (_tmp188_) {
		ValaField* _tmp189_;
		_tmp189_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp189_, "CCode", "delegate_target", FALSE, NULL);
	}
	result = field;
	_g_free0 (field_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (replacement);
	_g_free0 (deprecated_since);
	_g_free0 (array_length_type);
	_g_free0 (array_length_cname);
	_g_free0 (ctype);
	_g_free0 (cheader_filename);
	_vala_code_node_unref0 (type);
	return result;
}


static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gint result = 0;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}


static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}


static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}


static gchar**
vala_gidl_parser_get_attributes (ValaGIdlParser* self,
                                 const gchar* codenode,
                                 int* result_length1)
{
	gchar** result = NULL;
	gchar* attributes = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp25_;
	GSList* attr_list = NULL;
	GString* attr = NULL;
	const gchar* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GString* _tmp30_;
	gint attributes_len = 0;
	const gchar* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	const gchar* remaining = NULL;
	const gchar* _tmp34_;
	gboolean quoted = FALSE;
	gboolean escaped = FALSE;
	GString* _tmp59_;
	gssize _tmp60_;
	gchar** attrs = NULL;
	GSList* _tmp64_;
	gchar** _tmp65_;
	gint attrs_length1;
	gint _attrs_size_;
	GSList* attr_i = NULL;
	GSList* _tmp66_;
	gchar** _tmp79_;
	gint _tmp79__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (codenode != NULL, NULL);
	_tmp0_ = self->priv->codenode_attributes_map;
	_tmp1_ = vala_map_get (_tmp0_, codenode);
	attributes = (gchar*) _tmp1_;
	_tmp2_ = attributes;
	if (_tmp2_ == NULL) {
		gboolean dot_required = FALSE;
		gboolean colon_required = FALSE;
		ValaSet* pattern_specs = NULL;
		ValaMap* _tmp3_;
		ValaSet* _tmp4_;
		dot_required = -1 != string_index_of_char (codenode, (gunichar) '.', 0);
		colon_required = -1 != string_index_of_char (codenode, (gunichar) ':', 0);
		_tmp3_ = self->priv->codenode_attributes_patterns;
		_tmp4_ = vala_map_get_keys (_tmp3_);
		pattern_specs = _tmp4_;
		{
			ValaIterator* _pattern_it = NULL;
			ValaSet* _tmp5_;
			ValaIterator* _tmp6_;
			_tmp5_ = pattern_specs;
			_tmp6_ = vala_iterable_iterator ((ValaIterable*) _tmp5_);
			_pattern_it = _tmp6_;
			while (TRUE) {
				ValaIterator* _tmp7_;
				GPatternSpec* pattern = NULL;
				ValaIterator* _tmp8_;
				gpointer _tmp9_;
				gchar* pspec = NULL;
				ValaMap* _tmp10_;
				GPatternSpec* _tmp11_;
				gpointer _tmp12_;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_;
				GPatternSpec* _tmp20_;
				_tmp7_ = _pattern_it;
				if (!vala_iterator_next (_tmp7_)) {
					break;
				}
				_tmp8_ = _pattern_it;
				_tmp9_ = vala_iterator_get (_tmp8_);
				pattern = _tmp9_;
				_tmp10_ = self->priv->codenode_attributes_patterns;
				_tmp11_ = pattern;
				_tmp12_ = vala_map_get (_tmp10_, _tmp11_);
				pspec = (gchar*) _tmp12_;
				_tmp15_ = dot_required;
				if (_tmp15_) {
					const gchar* _tmp16_;
					_tmp16_ = pspec;
					_tmp14_ = -1 == string_index_of_char (_tmp16_, (gunichar) '.', 0);
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					_tmp13_ = TRUE;
				} else {
					gboolean _tmp17_ = FALSE;
					gboolean _tmp18_;
					_tmp18_ = colon_required;
					if (_tmp18_) {
						const gchar* _tmp19_;
						_tmp19_ = pspec;
						_tmp17_ = -1 == string_index_of_char (_tmp19_, (gunichar) ':', 0);
					} else {
						_tmp17_ = FALSE;
					}
					_tmp13_ = _tmp17_;
				}
				if (_tmp13_) {
					_g_free0 (pspec);
					continue;
				}
				_tmp20_ = pattern;
				if (g_pattern_match_string (_tmp20_, codenode)) {
					const gchar* _tmp21_;
					gint _tmp22_ = 0;
					gchar** _tmp23_;
					gchar** _tmp24_;
					gint _tmp24__length1;
					_tmp21_ = pspec;
					_tmp23_ = vala_gidl_parser_get_attributes (self, _tmp21_, &_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp24__length1 = _tmp22_;
					if (result_length1) {
						*result_length1 = _tmp24__length1;
					}
					result = _tmp24_;
					_g_free0 (pspec);
					_vala_iterator_unref0 (_pattern_it);
					_vala_iterable_unref0 (pattern_specs);
					_g_free0 (attributes);
					return result;
				}
				_g_free0 (pspec);
			}
			_vala_iterator_unref0 (_pattern_it);
		}
		_vala_iterable_unref0 (pattern_specs);
	}
	_tmp25_ = attributes;
	if (_tmp25_ == NULL) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		_tmp26_ = NULL;
		_tmp26__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp26__length1;
		}
		result = _tmp26_;
		_g_free0 (attributes);
		return result;
	}
	attr_list = NULL;
	_tmp27_ = attributes;
	_tmp28_ = strlen (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_string_sized_new ((gsize) _tmp29_);
	attr = _tmp30_;
	_tmp31_ = attributes;
	_tmp32_ = strlen (_tmp31_);
	_tmp33_ = _tmp32_;
	attributes_len = _tmp33_;
	_tmp34_ = attributes;
	remaining = _tmp34_;
	quoted = FALSE;
	escaped = FALSE;
	{
		gint b = 0;
		b = 0;
		{
			gboolean _tmp35_ = FALSE;
			_tmp35_ = TRUE;
			while (TRUE) {
				gint _tmp37_;
				gint _tmp38_;
				gunichar c = 0U;
				const gchar* _tmp39_;
				gboolean _tmp40_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				if (!_tmp35_) {
					gint _tmp36_;
					_tmp36_ = b;
					b = _tmp36_ + 1;
				}
				_tmp35_ = FALSE;
				_tmp37_ = b;
				_tmp38_ = attributes_len;
				if (!(_tmp37_ < _tmp38_)) {
					break;
				}
				_tmp39_ = remaining;
				c = string_get_char (_tmp39_, (glong) 0);
				_tmp40_ = escaped;
				if (_tmp40_) {
					GString* _tmp41_;
					gunichar _tmp42_;
					escaped = FALSE;
					_tmp41_ = attr;
					_tmp42_ = c;
					g_string_append_unichar (_tmp41_, _tmp42_);
				} else {
					gunichar _tmp43_;
					_tmp43_ = c;
					if (_tmp43_ == ((gunichar) '"')) {
						GString* _tmp44_;
						gunichar _tmp45_;
						gboolean _tmp46_;
						_tmp44_ = attr;
						_tmp45_ = c;
						g_string_append_unichar (_tmp44_, _tmp45_);
						_tmp46_ = quoted;
						quoted = !_tmp46_;
					} else {
						gunichar _tmp47_;
						_tmp47_ = c;
						if (_tmp47_ == ((gunichar) '\\')) {
							escaped = TRUE;
						} else {
							gboolean _tmp48_ = FALSE;
							gboolean _tmp49_;
							_tmp49_ = quoted;
							if (!_tmp49_) {
								gunichar _tmp50_;
								_tmp50_ = c;
								_tmp48_ = _tmp50_ == ((gunichar) ' ');
							} else {
								_tmp48_ = FALSE;
							}
							if (_tmp48_) {
								GString* _tmp51_;
								const gchar* _tmp52_;
								gchar* _tmp53_;
								GString* _tmp54_;
								_tmp51_ = attr;
								_tmp52_ = _tmp51_->str;
								_tmp53_ = g_strdup (_tmp52_);
								attr_list = g_slist_prepend (attr_list, _tmp53_);
								_tmp54_ = attr;
								g_string_truncate (_tmp54_, (gsize) 0);
							} else {
								GString* _tmp55_;
								gunichar _tmp56_;
								_tmp55_ = attr;
								_tmp56_ = c;
								g_string_append_unichar (_tmp55_, _tmp56_);
							}
						}
					}
				}
				_tmp57_ = remaining;
				_tmp58_ = remaining;
				remaining = (const gchar*) (((gchar*) _tmp57_) + string_index_of_nth_char (_tmp58_, (glong) 1));
			}
		}
	}
	_tmp59_ = attr;
	_tmp60_ = _tmp59_->len;
	if (_tmp60_ > ((gssize) 0)) {
		GString* _tmp61_;
		const gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp61_ = attr;
		_tmp62_ = _tmp61_->str;
		_tmp63_ = g_strdup (_tmp62_);
		attr_list = g_slist_prepend (attr_list, _tmp63_);
	}
	_tmp64_ = attr_list;
	_tmp65_ = g_new0 (gchar*, g_slist_length (_tmp64_) + 1);
	attrs = _tmp65_;
	attrs_length1 = g_slist_length (_tmp64_);
	_attrs_size_ = attrs_length1;
	_tmp66_ = attr_list;
	attr_i = _tmp66_;
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp67_ = FALSE;
			_tmp67_ = TRUE;
			while (TRUE) {
				gint _tmp71_;
				gchar** _tmp72_;
				gint _tmp72__length1;
				gchar** _tmp73_;
				gint _tmp73__length1;
				gchar** _tmp74_;
				gint _tmp74__length1;
				gint _tmp75_;
				GSList* _tmp76_;
				gconstpointer _tmp77_;
				gchar* _tmp78_;
				if (!_tmp67_) {
					gint _tmp68_;
					GSList* _tmp69_;
					GSList* _tmp70_;
					_tmp68_ = a;
					a = _tmp68_ + 1;
					_tmp69_ = attr_i;
					_tmp70_ = _tmp69_->next;
					attr_i = _tmp70_;
				}
				_tmp67_ = FALSE;
				_tmp71_ = a;
				_tmp72_ = attrs;
				_tmp72__length1 = attrs_length1;
				if (!(_tmp71_ < _tmp72__length1)) {
					break;
				}
				_tmp73_ = attrs;
				_tmp73__length1 = attrs_length1;
				_tmp74_ = attrs;
				_tmp74__length1 = attrs_length1;
				_tmp75_ = a;
				_tmp76_ = attr_i;
				_tmp77_ = _tmp76_->data;
				_tmp78_ = g_strdup ((const gchar*) _tmp77_);
				_g_free0 (_tmp73_[(_tmp74__length1 - 1) - _tmp75_]);
				_tmp73_[(_tmp74__length1 - 1) - _tmp75_] = _tmp78_;
			}
		}
	}
	_tmp79_ = attrs;
	_tmp79__length1 = attrs_length1;
	if (result_length1) {
		*result_length1 = _tmp79__length1;
	}
	result = _tmp79_;
	_g_string_free0 (attr);
	(attr_list == NULL) ? NULL : (attr_list = (_g_slist_free__g_free0_ (attr_list), NULL));
	_g_free0 (attributes);
	return result;
}


static gchar*
vala_gidl_parser_eval (ValaGIdlParser* self,
                       const gchar* s)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp3_ = strlen (s);
	_tmp4_ = _tmp3_;
	if (_tmp4_ >= 2) {
		_tmp2_ = g_str_has_prefix (s, "\"");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_str_has_suffix (s, "\"");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = strlen (s);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_substring (s, (glong) 1, (glong) (_tmp6_ - 2));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
	} else {
		gchar* _tmp8_;
		_tmp8_ = g_strdup (s);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	}
	result = _tmp0_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static ValaSignal*
vala_gidl_parser_parse_signal (ValaGIdlParser* self,
                               GIdlNodeSignal* sig_node)
{
	ValaSignal* result = NULL;
	GIdlNode* node = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValaSignal* sig = NULL;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GIdlNodeParam* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaSignal* _tmp11_;
	ValaSignal* _tmp12_;
	ValaSignal* _tmp13_;
	gchar** attributes = NULL;
	ValaTypeSymbol* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	ValaSignal* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gint _tmp22_ = 0;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	ValaSignal* _tmp131_;
	gboolean first = FALSE;
	GList* _tmp132_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig_node != NULL, NULL);
	node = (GIdlNode*) sig_node;
	_tmp1_ = sig_node->deprecated;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GIdlNodeParam* _tmp2_;
		_tmp2_ = sig_node->result;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = vala_gidl_parser_fix_prop_name (self, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sig_node->result;
	_tmp8_ = vala_gidl_parser_parse_param (self, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->current_source_reference;
	_tmp11_ = vala_signal_new (_tmp6_, _tmp9_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_vala_code_node_unref0 (_tmp9_);
	_g_free0 (_tmp6_);
	sig = _tmp12_;
	_tmp13_ = sig;
	vala_symbol_set_access ((ValaSymbol*) _tmp13_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp14_ = self->priv->current_data_type;
	_tmp15_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = sig;
	_tmp18_ = vala_symbol_get_name ((ValaSymbol*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s::%s", _tmp16_, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp23_ = vala_gidl_parser_get_attributes (self, _tmp21_, &_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp24__length1 = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp16_);
	attributes = _tmp24_;
	attributes_length1 = _tmp24__length1;
	_attributes_size_ = attributes_length1;
	_tmp25_ = attributes;
	_tmp25__length1 = attributes_length1;
	if (_tmp25_ != NULL) {
		gchar* ns_name = NULL;
		gchar** _tmp26_;
		gint _tmp26__length1;
		const gchar* _tmp122_;
		ns_name = NULL;
		_tmp26_ = attributes;
		_tmp26__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp26_;
			attr_collection_length1 = _tmp26__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp27_;
				gchar* attr = NULL;
				_tmp27_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp27_;
				{
					gchar** nv = NULL;
					const gchar* _tmp28_;
					gchar** _tmp29_;
					gchar** _tmp30_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp31_;
					gint _tmp31__length1;
					const gchar* _tmp32_;
					_tmp28_ = attr;
					_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, "=", 2);
					nv = _tmp30_;
					nv_length1 = _vala_array_length (_tmp29_);
					_nv_size_ = nv_length1;
					_tmp31_ = nv;
					_tmp31__length1 = nv_length1;
					_tmp32_ = _tmp31_[0];
					if (g_strcmp0 (_tmp32_, "name") == 0) {
						ValaSignal* _tmp33_;
						ValaSignal* _tmp34_;
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						ValaSignal* _tmp39_;
						gchar** _tmp40_;
						gint _tmp40__length1;
						const gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp33_ = sig;
						_tmp34_ = sig;
						_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = string_replace (_tmp36_, "_", "-");
						_tmp38_ = _tmp37_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp33_, "CCode", "cname", _tmp38_, NULL);
						_g_free0 (_tmp38_);
						_tmp39_ = sig;
						_tmp40_ = nv;
						_tmp40__length1 = nv_length1;
						_tmp41_ = _tmp40_[1];
						_tmp42_ = vala_gidl_parser_eval (self, _tmp41_);
						_tmp43_ = _tmp42_;
						vala_symbol_set_name ((ValaSymbol*) _tmp39_, _tmp43_);
						_g_free0 (_tmp43_);
					} else {
						gboolean _tmp44_ = FALSE;
						gchar** _tmp45_;
						gint _tmp45__length1;
						const gchar* _tmp46_;
						_tmp45_ = nv;
						_tmp45__length1 = nv_length1;
						_tmp46_ = _tmp45_[0];
						if (g_strcmp0 (_tmp46_, "has_emitter") == 0) {
							gchar** _tmp47_;
							gint _tmp47__length1;
							const gchar* _tmp48_;
							gchar* _tmp49_;
							gchar* _tmp50_;
							_tmp47_ = nv;
							_tmp47__length1 = nv_length1;
							_tmp48_ = _tmp47_[1];
							_tmp49_ = vala_gidl_parser_eval (self, _tmp48_);
							_tmp50_ = _tmp49_;
							_tmp44_ = g_strcmp0 (_tmp50_, "1") == 0;
							_g_free0 (_tmp50_);
						} else {
							_tmp44_ = FALSE;
						}
						if (_tmp44_) {
							ValaSignal* _tmp51_;
							_tmp51_ = sig;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp51_, "HasEmitter", TRUE, NULL);
						} else {
							gchar** _tmp52_;
							gint _tmp52__length1;
							const gchar* _tmp53_;
							_tmp52_ = nv;
							_tmp52__length1 = nv_length1;
							_tmp53_ = _tmp52_[0];
							if (g_strcmp0 (_tmp53_, "hidden") == 0) {
								gchar** _tmp54_;
								gint _tmp54__length1;
								const gchar* _tmp55_;
								gchar* _tmp56_;
								gchar* _tmp57_;
								gboolean _tmp58_;
								_tmp54_ = nv;
								_tmp54__length1 = nv_length1;
								_tmp55_ = _tmp54_[1];
								_tmp56_ = vala_gidl_parser_eval (self, _tmp55_);
								_tmp57_ = _tmp56_;
								_tmp58_ = g_strcmp0 (_tmp57_, "1") == 0;
								_g_free0 (_tmp57_);
								if (_tmp58_) {
									result = NULL;
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									_g_free0 (ns_name);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (sig);
									return result;
								}
							} else {
								gchar** _tmp59_;
								gint _tmp59__length1;
								const gchar* _tmp60_;
								_tmp59_ = nv;
								_tmp59__length1 = nv_length1;
								_tmp60_ = _tmp59_[0];
								if (g_strcmp0 (_tmp60_, "deprecated") == 0) {
									gchar** _tmp61_;
									gint _tmp61__length1;
									const gchar* _tmp62_;
									gchar* _tmp63_;
									gchar* _tmp64_;
									gboolean _tmp65_;
									_tmp61_ = nv;
									_tmp61__length1 = nv_length1;
									_tmp62_ = _tmp61_[1];
									_tmp63_ = vala_gidl_parser_eval (self, _tmp62_);
									_tmp64_ = _tmp63_;
									_tmp65_ = g_strcmp0 (_tmp64_, "1") == 0;
									_g_free0 (_tmp64_);
									if (_tmp65_) {
										ValaSignal* _tmp66_;
										_tmp66_ = sig;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp66_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp67_;
									gint _tmp67__length1;
									const gchar* _tmp68_;
									_tmp67_ = nv;
									_tmp67__length1 = nv_length1;
									_tmp68_ = _tmp67_[0];
									if (g_strcmp0 (_tmp68_, "replacement") == 0) {
										ValaSignal* _tmp69_;
										gchar** _tmp70_;
										gint _tmp70__length1;
										const gchar* _tmp71_;
										gchar* _tmp72_;
										gchar* _tmp73_;
										_tmp69_ = sig;
										_tmp70_ = nv;
										_tmp70__length1 = nv_length1;
										_tmp71_ = _tmp70_[1];
										_tmp72_ = vala_gidl_parser_eval (self, _tmp71_);
										_tmp73_ = _tmp72_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp69_, "Version", "replacement", _tmp73_, NULL);
										_g_free0 (_tmp73_);
									} else {
										gchar** _tmp74_;
										gint _tmp74__length1;
										const gchar* _tmp75_;
										_tmp74_ = nv;
										_tmp74__length1 = nv_length1;
										_tmp75_ = _tmp74_[0];
										if (g_strcmp0 (_tmp75_, "deprecated_since") == 0) {
											ValaSignal* _tmp76_;
											gchar** _tmp77_;
											gint _tmp77__length1;
											const gchar* _tmp78_;
											gchar* _tmp79_;
											gchar* _tmp80_;
											_tmp76_ = sig;
											_tmp77_ = nv;
											_tmp77__length1 = nv_length1;
											_tmp78_ = _tmp77_[1];
											_tmp79_ = vala_gidl_parser_eval (self, _tmp78_);
											_tmp80_ = _tmp79_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp76_, "Version", "deprecated_since", _tmp80_, NULL);
											_g_free0 (_tmp80_);
										} else {
											gchar** _tmp81_;
											gint _tmp81__length1;
											const gchar* _tmp82_;
											_tmp81_ = nv;
											_tmp81__length1 = nv_length1;
											_tmp82_ = _tmp81_[0];
											if (g_strcmp0 (_tmp82_, "transfer_ownership") == 0) {
												gchar** _tmp83_;
												gint _tmp83__length1;
												const gchar* _tmp84_;
												gchar* _tmp85_;
												gchar* _tmp86_;
												gboolean _tmp87_;
												_tmp83_ = nv;
												_tmp83__length1 = nv_length1;
												_tmp84_ = _tmp83_[1];
												_tmp85_ = vala_gidl_parser_eval (self, _tmp84_);
												_tmp86_ = _tmp85_;
												_tmp87_ = g_strcmp0 (_tmp86_, "1") == 0;
												_g_free0 (_tmp86_);
												if (_tmp87_) {
													ValaSignal* _tmp88_;
													ValaDataType* _tmp89_;
													ValaDataType* _tmp90_;
													_tmp88_ = sig;
													_tmp89_ = vala_callable_get_return_type ((ValaCallable*) _tmp88_);
													_tmp90_ = _tmp89_;
													vala_data_type_set_value_owned (_tmp90_, TRUE);
												}
											} else {
												gchar** _tmp91_;
												gint _tmp91__length1;
												const gchar* _tmp92_;
												_tmp91_ = nv;
												_tmp91__length1 = nv_length1;
												_tmp92_ = _tmp91_[0];
												if (g_strcmp0 (_tmp92_, "namespace_name") == 0) {
													gchar** _tmp93_;
													gint _tmp93__length1;
													const gchar* _tmp94_;
													gchar* _tmp95_;
													_tmp93_ = nv;
													_tmp93__length1 = nv_length1;
													_tmp94_ = _tmp93_[1];
													_tmp95_ = vala_gidl_parser_eval (self, _tmp94_);
													_g_free0 (ns_name);
													ns_name = _tmp95_;
												} else {
													gchar** _tmp96_;
													gint _tmp96__length1;
													const gchar* _tmp97_;
													_tmp96_ = nv;
													_tmp96__length1 = nv_length1;
													_tmp97_ = _tmp96_[0];
													if (g_strcmp0 (_tmp97_, "type_name") == 0) {
														ValaSignal* _tmp98_;
														gchar** _tmp99_;
														gint _tmp99__length1;
														const gchar* _tmp100_;
														gchar* _tmp101_;
														gchar* _tmp102_;
														ValaDataType* _tmp103_;
														ValaDataType* _tmp104_;
														_tmp98_ = sig;
														_tmp99_ = nv;
														_tmp99__length1 = nv_length1;
														_tmp100_ = _tmp99_[1];
														_tmp101_ = vala_gidl_parser_eval (self, _tmp100_);
														_tmp102_ = _tmp101_;
														_tmp103_ = vala_gidl_parser_parse_type_from_string (self, _tmp102_, FALSE, NULL);
														_tmp104_ = _tmp103_;
														vala_callable_set_return_type ((ValaCallable*) _tmp98_, _tmp104_);
														_vala_code_node_unref0 (_tmp104_);
														_g_free0 (_tmp102_);
													} else {
														gchar** _tmp105_;
														gint _tmp105__length1;
														const gchar* _tmp106_;
														_tmp105_ = nv;
														_tmp105__length1 = nv_length1;
														_tmp106_ = _tmp105_[0];
														if (g_strcmp0 (_tmp106_, "type_arguments") == 0) {
															ValaSignal* _tmp107_;
															ValaDataType* _tmp108_;
															ValaDataType* _tmp109_;
															gchar** _tmp110_;
															gint _tmp110__length1;
															const gchar* _tmp111_;
															gchar* _tmp112_;
															gchar* _tmp113_;
															_tmp107_ = sig;
															_tmp108_ = vala_callable_get_return_type ((ValaCallable*) _tmp107_);
															_tmp109_ = _tmp108_;
															_tmp110_ = nv;
															_tmp110__length1 = nv_length1;
															_tmp111_ = _tmp110_[1];
															_tmp112_ = vala_gidl_parser_eval (self, _tmp111_);
															_tmp113_ = _tmp112_;
															vala_gidl_parser_parse_type_arguments_from_string (self, _tmp109_, _tmp113_, NULL);
															_g_free0 (_tmp113_);
														} else {
															gchar** _tmp114_;
															gint _tmp114__length1;
															const gchar* _tmp115_;
															_tmp114_ = nv;
															_tmp114__length1 = nv_length1;
															_tmp115_ = _tmp114_[0];
															if (g_strcmp0 (_tmp115_, "experimental") == 0) {
																gchar** _tmp116_;
																gint _tmp116__length1;
																const gchar* _tmp117_;
																gchar* _tmp118_;
																gchar* _tmp119_;
																gboolean _tmp120_;
																_tmp116_ = nv;
																_tmp116__length1 = nv_length1;
																_tmp117_ = _tmp116_[1];
																_tmp118_ = vala_gidl_parser_eval (self, _tmp117_);
																_tmp119_ = _tmp118_;
																_tmp120_ = g_strcmp0 (_tmp119_, "1") == 0;
																_g_free0 (_tmp119_);
																if (_tmp120_) {
																	ValaSignal* _tmp121_;
																	_tmp121_ = sig;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp121_, "Version", "experimental", TRUE, NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
		_tmp122_ = ns_name;
		if (_tmp122_ != NULL) {
			ValaSignal* _tmp123_;
			ValaDataType* _tmp124_;
			ValaDataType* _tmp125_;
			ValaUnresolvedSymbol* _tmp126_;
			ValaUnresolvedSymbol* _tmp127_;
			const gchar* _tmp128_;
			ValaUnresolvedSymbol* _tmp129_;
			ValaUnresolvedSymbol* _tmp130_;
			_tmp123_ = sig;
			_tmp124_ = vala_callable_get_return_type ((ValaCallable*) _tmp123_);
			_tmp125_ = _tmp124_;
			_tmp126_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp127_ = _tmp126_;
			_tmp128_ = ns_name;
			_tmp129_ = vala_unresolved_symbol_new (NULL, _tmp128_, NULL);
			_tmp130_ = _tmp129_;
			vala_unresolved_symbol_set_inner (_tmp127_, _tmp130_);
			_vala_code_node_unref0 (_tmp130_);
		}
		_g_free0 (ns_name);
	}
	_tmp131_ = sig;
	vala_signal_set_is_virtual (_tmp131_, TRUE);
	first = TRUE;
	_tmp132_ = sig_node->parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp132_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				gboolean _tmp133_;
				GIdlNode* param_node = NULL;
				GIdlNodeParam* _tmp134_;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type = NULL;
				GIdlNodeParam* _tmp135_;
				ValaParameterDirection _tmp136_ = 0;
				ValaDataType* _tmp137_;
				ValaParameter* p = NULL;
				GIdlNode* _tmp138_;
				const gchar* _tmp139_;
				ValaDataType* _tmp140_;
				ValaParameter* _tmp141_;
				ValaParameter* _tmp142_;
				ValaParameterDirection _tmp143_;
				gboolean hide_param = FALSE;
				gboolean show_param = FALSE;
				ValaTypeSymbol* _tmp144_;
				gchar* _tmp145_;
				gchar* _tmp146_;
				ValaSignal* _tmp147_;
				const gchar* _tmp148_;
				const gchar* _tmp149_;
				GIdlNode* _tmp150_;
				const gchar* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				gint _tmp154_ = 0;
				gchar** _tmp155_;
				gchar** _tmp156_;
				gint _tmp156__length1;
				gboolean _tmp276_ = FALSE;
				gboolean _tmp277_;
				_tmp133_ = first;
				if (_tmp133_) {
					first = FALSE;
					continue;
				}
				_tmp134_ = param;
				param_node = (GIdlNode*) _tmp134_;
				_tmp135_ = param;
				_tmp137_ = vala_gidl_parser_parse_param (self, _tmp135_, &_tmp136_);
				direction = _tmp136_;
				param_type = _tmp137_;
				_tmp138_ = param_node;
				_tmp139_ = _tmp138_->name;
				_tmp140_ = param_type;
				_tmp141_ = vala_parameter_new (_tmp139_, _tmp140_, NULL);
				p = _tmp141_;
				_tmp142_ = p;
				_tmp143_ = direction;
				vala_parameter_set_direction (_tmp142_, _tmp143_);
				hide_param = FALSE;
				show_param = FALSE;
				_tmp144_ = self->priv->current_data_type;
				_tmp145_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp144_, NULL);
				_tmp146_ = _tmp145_;
				_tmp147_ = sig;
				_tmp148_ = vala_symbol_get_name ((ValaSymbol*) _tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = param_node;
				_tmp151_ = _tmp150_->name;
				_tmp152_ = g_strdup_printf ("%s::%s.%s", _tmp146_, _tmp149_, _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp155_ = vala_gidl_parser_get_attributes (self, _tmp153_, &_tmp154_);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes = _tmp155_;
				attributes_length1 = _tmp154_;
				_attributes_size_ = attributes_length1;
				_g_free0 (_tmp153_);
				_g_free0 (_tmp146_);
				_tmp156_ = attributes;
				_tmp156__length1 = attributes_length1;
				if (_tmp156_ != NULL) {
					gchar* ns_name = NULL;
					gchar** _tmp157_;
					gint _tmp157__length1;
					const gchar* _tmp269_;
					ns_name = NULL;
					_tmp157_ = attributes;
					_tmp157__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp157_;
						attr_collection_length1 = _tmp157__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp158_;
							gchar* attr = NULL;
							_tmp158_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp158_;
							{
								gchar** nv = NULL;
								const gchar* _tmp159_;
								gchar** _tmp160_;
								gchar** _tmp161_;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp162_;
								gint _tmp162__length1;
								const gchar* _tmp163_;
								_tmp159_ = attr;
								_tmp161_ = _tmp160_ = g_strsplit (_tmp159_, "=", 2);
								nv = _tmp161_;
								nv_length1 = _vala_array_length (_tmp160_);
								_nv_size_ = nv_length1;
								_tmp162_ = nv;
								_tmp162__length1 = nv_length1;
								_tmp163_ = _tmp162_[0];
								if (g_strcmp0 (_tmp163_, "hidden") == 0) {
									gchar** _tmp164_;
									gint _tmp164__length1;
									const gchar* _tmp165_;
									gchar* _tmp166_;
									gchar* _tmp167_;
									gboolean _tmp168_;
									_tmp164_ = nv;
									_tmp164__length1 = nv_length1;
									_tmp165_ = _tmp164_[1];
									_tmp166_ = vala_gidl_parser_eval (self, _tmp165_);
									_tmp167_ = _tmp166_;
									_tmp168_ = g_strcmp0 (_tmp167_, "1") == 0;
									_g_free0 (_tmp167_);
									if (_tmp168_) {
										hide_param = TRUE;
									} else {
										gchar** _tmp169_;
										gint _tmp169__length1;
										const gchar* _tmp170_;
										gchar* _tmp171_;
										gchar* _tmp172_;
										gboolean _tmp173_;
										_tmp169_ = nv;
										_tmp169__length1 = nv_length1;
										_tmp170_ = _tmp169_[1];
										_tmp171_ = vala_gidl_parser_eval (self, _tmp170_);
										_tmp172_ = _tmp171_;
										_tmp173_ = g_strcmp0 (_tmp172_, "0") == 0;
										_g_free0 (_tmp172_);
										if (_tmp173_) {
											show_param = TRUE;
										}
									}
								} else {
									gchar** _tmp174_;
									gint _tmp174__length1;
									const gchar* _tmp175_;
									_tmp174_ = nv;
									_tmp174__length1 = nv_length1;
									_tmp175_ = _tmp174_[0];
									if (g_strcmp0 (_tmp175_, "is_array") == 0) {
										gchar** _tmp176_;
										gint _tmp176__length1;
										const gchar* _tmp177_;
										gchar* _tmp178_;
										gchar* _tmp179_;
										gboolean _tmp180_;
										_tmp176_ = nv;
										_tmp176__length1 = nv_length1;
										_tmp177_ = _tmp176_[1];
										_tmp178_ = vala_gidl_parser_eval (self, _tmp177_);
										_tmp179_ = _tmp178_;
										_tmp180_ = g_strcmp0 (_tmp179_, "1") == 0;
										_g_free0 (_tmp179_);
										if (_tmp180_) {
											ValaDataType* _tmp181_;
											ValaDataType* _tmp182_;
											ValaDataType* _tmp183_;
											ValaSourceReference* _tmp184_;
											ValaSourceReference* _tmp185_;
											ValaArrayType* _tmp186_;
											ValaParameter* _tmp187_;
											ValaDataType* _tmp188_;
											ValaParameter* _tmp189_;
											_tmp181_ = param_type;
											vala_data_type_set_value_owned (_tmp181_, TRUE);
											_tmp182_ = param_type;
											_tmp183_ = param_type;
											_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp183_);
											_tmp185_ = _tmp184_;
											_tmp186_ = vala_array_type_new (_tmp182_, 1, _tmp185_);
											_vala_code_node_unref0 (param_type);
											param_type = (ValaDataType*) _tmp186_;
											_tmp187_ = p;
											_tmp188_ = param_type;
											vala_variable_set_variable_type ((ValaVariable*) _tmp187_, _tmp188_);
											_tmp189_ = p;
											vala_parameter_set_direction (_tmp189_, VALA_PARAMETER_DIRECTION_IN);
										}
									} else {
										gchar** _tmp190_;
										gint _tmp190__length1;
										const gchar* _tmp191_;
										_tmp190_ = nv;
										_tmp190__length1 = nv_length1;
										_tmp191_ = _tmp190_[0];
										if (g_strcmp0 (_tmp191_, "no_array_length") == 0) {
											gchar** _tmp192_;
											gint _tmp192__length1;
											const gchar* _tmp193_;
											gchar* _tmp194_;
											gchar* _tmp195_;
											gboolean _tmp196_;
											_tmp192_ = nv;
											_tmp192__length1 = nv_length1;
											_tmp193_ = _tmp192_[1];
											_tmp194_ = vala_gidl_parser_eval (self, _tmp193_);
											_tmp195_ = _tmp194_;
											_tmp196_ = g_strcmp0 (_tmp195_, "1") == 0;
											_g_free0 (_tmp195_);
											if (_tmp196_) {
												ValaParameter* _tmp197_;
												_tmp197_ = p;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp197_, "CCode", "array_length", FALSE, NULL);
											}
										} else {
											gchar** _tmp198_;
											gint _tmp198__length1;
											const gchar* _tmp199_;
											_tmp198_ = nv;
											_tmp198__length1 = nv_length1;
											_tmp199_ = _tmp198_[0];
											if (g_strcmp0 (_tmp199_, "array_length_type") == 0) {
												ValaParameter* _tmp200_;
												gchar** _tmp201_;
												gint _tmp201__length1;
												const gchar* _tmp202_;
												_tmp200_ = p;
												_tmp201_ = nv;
												_tmp201__length1 = nv_length1;
												_tmp202_ = _tmp201_[1];
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp200_, "CCode", "array_length_type", _tmp202_, NULL);
											} else {
												gchar** _tmp203_;
												gint _tmp203__length1;
												const gchar* _tmp204_;
												_tmp203_ = nv;
												_tmp203__length1 = nv_length1;
												_tmp204_ = _tmp203_[0];
												if (g_strcmp0 (_tmp204_, "array_null_terminated") == 0) {
													gchar** _tmp205_;
													gint _tmp205__length1;
													const gchar* _tmp206_;
													gchar* _tmp207_;
													gchar* _tmp208_;
													gboolean _tmp209_;
													_tmp205_ = nv;
													_tmp205__length1 = nv_length1;
													_tmp206_ = _tmp205_[1];
													_tmp207_ = vala_gidl_parser_eval (self, _tmp206_);
													_tmp208_ = _tmp207_;
													_tmp209_ = g_strcmp0 (_tmp208_, "1") == 0;
													_g_free0 (_tmp208_);
													if (_tmp209_) {
														ValaParameter* _tmp210_;
														ValaParameter* _tmp211_;
														_tmp210_ = p;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp210_, "CCode", "array_length", FALSE, NULL);
														_tmp211_ = p;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp211_, "CCode", "array_null_terminated", TRUE, NULL);
													}
												} else {
													gchar** _tmp212_;
													gint _tmp212__length1;
													const gchar* _tmp213_;
													_tmp212_ = nv;
													_tmp212__length1 = nv_length1;
													_tmp213_ = _tmp212_[0];
													if (g_strcmp0 (_tmp213_, "is_out") == 0) {
														gchar** _tmp214_;
														gint _tmp214__length1;
														const gchar* _tmp215_;
														gchar* _tmp216_;
														gchar* _tmp217_;
														gboolean _tmp218_;
														_tmp214_ = nv;
														_tmp214__length1 = nv_length1;
														_tmp215_ = _tmp214_[1];
														_tmp216_ = vala_gidl_parser_eval (self, _tmp215_);
														_tmp217_ = _tmp216_;
														_tmp218_ = g_strcmp0 (_tmp217_, "1") == 0;
														_g_free0 (_tmp217_);
														if (_tmp218_) {
															ValaParameter* _tmp219_;
															_tmp219_ = p;
															vala_parameter_set_direction (_tmp219_, VALA_PARAMETER_DIRECTION_OUT);
														}
													} else {
														gchar** _tmp220_;
														gint _tmp220__length1;
														const gchar* _tmp221_;
														_tmp220_ = nv;
														_tmp220__length1 = nv_length1;
														_tmp221_ = _tmp220_[0];
														if (g_strcmp0 (_tmp221_, "is_ref") == 0) {
															gchar** _tmp222_;
															gint _tmp222__length1;
															const gchar* _tmp223_;
															gchar* _tmp224_;
															gchar* _tmp225_;
															gboolean _tmp226_;
															_tmp222_ = nv;
															_tmp222__length1 = nv_length1;
															_tmp223_ = _tmp222_[1];
															_tmp224_ = vala_gidl_parser_eval (self, _tmp223_);
															_tmp225_ = _tmp224_;
															_tmp226_ = g_strcmp0 (_tmp225_, "1") == 0;
															_g_free0 (_tmp225_);
															if (_tmp226_) {
																ValaParameter* _tmp227_;
																_tmp227_ = p;
																vala_parameter_set_direction (_tmp227_, VALA_PARAMETER_DIRECTION_REF);
															}
														} else {
															gchar** _tmp228_;
															gint _tmp228__length1;
															const gchar* _tmp229_;
															_tmp228_ = nv;
															_tmp228__length1 = nv_length1;
															_tmp229_ = _tmp228_[0];
															if (g_strcmp0 (_tmp229_, "nullable") == 0) {
																gboolean _tmp230_ = FALSE;
																gchar** _tmp231_;
																gint _tmp231__length1;
																const gchar* _tmp232_;
																gchar* _tmp233_;
																gchar* _tmp234_;
																gboolean _tmp235_;
																_tmp231_ = nv;
																_tmp231__length1 = nv_length1;
																_tmp232_ = _tmp231_[1];
																_tmp233_ = vala_gidl_parser_eval (self, _tmp232_);
																_tmp234_ = _tmp233_;
																_tmp235_ = g_strcmp0 (_tmp234_, "1") == 0;
																_g_free0 (_tmp234_);
																if (_tmp235_) {
																	ValaDataType* _tmp236_;
																	_tmp236_ = param_type;
																	_tmp230_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp236_, VALA_TYPE_VOID_TYPE);
																} else {
																	_tmp230_ = FALSE;
																}
																if (_tmp230_) {
																	ValaDataType* _tmp237_;
																	_tmp237_ = param_type;
																	vala_data_type_set_nullable (_tmp237_, TRUE);
																}
															} else {
																gchar** _tmp238_;
																gint _tmp238__length1;
																const gchar* _tmp239_;
																_tmp238_ = nv;
																_tmp238__length1 = nv_length1;
																_tmp239_ = _tmp238_[0];
																if (g_strcmp0 (_tmp239_, "transfer_ownership") == 0) {
																	gchar** _tmp240_;
																	gint _tmp240__length1;
																	const gchar* _tmp241_;
																	gchar* _tmp242_;
																	gchar* _tmp243_;
																	gboolean _tmp244_;
																	_tmp240_ = nv;
																	_tmp240__length1 = nv_length1;
																	_tmp241_ = _tmp240_[1];
																	_tmp242_ = vala_gidl_parser_eval (self, _tmp241_);
																	_tmp243_ = _tmp242_;
																	_tmp244_ = g_strcmp0 (_tmp243_, "1") == 0;
																	_g_free0 (_tmp243_);
																	if (_tmp244_) {
																		ValaDataType* _tmp245_;
																		_tmp245_ = param_type;
																		vala_data_type_set_value_owned (_tmp245_, TRUE);
																	}
																} else {
																	gchar** _tmp246_;
																	gint _tmp246__length1;
																	const gchar* _tmp247_;
																	_tmp246_ = nv;
																	_tmp246__length1 = nv_length1;
																	_tmp247_ = _tmp246_[0];
																	if (g_strcmp0 (_tmp247_, "type_name") == 0) {
																		ValaParameter* _tmp248_;
																		gchar** _tmp249_;
																		gint _tmp249__length1;
																		const gchar* _tmp250_;
																		gchar* _tmp251_;
																		gchar* _tmp252_;
																		ValaDataType* _tmp253_;
																		ValaDataType* _tmp254_;
																		_tmp248_ = p;
																		_tmp249_ = nv;
																		_tmp249__length1 = nv_length1;
																		_tmp250_ = _tmp249_[1];
																		_tmp251_ = vala_gidl_parser_eval (self, _tmp250_);
																		_tmp252_ = _tmp251_;
																		_tmp253_ = vala_gidl_parser_parse_type_from_string (self, _tmp252_, FALSE, NULL);
																		_vala_code_node_unref0 (param_type);
																		param_type = _tmp253_;
																		_tmp254_ = param_type;
																		vala_variable_set_variable_type ((ValaVariable*) _tmp248_, _tmp254_);
																		_g_free0 (_tmp252_);
																	} else {
																		gchar** _tmp255_;
																		gint _tmp255__length1;
																		const gchar* _tmp256_;
																		_tmp255_ = nv;
																		_tmp255__length1 = nv_length1;
																		_tmp256_ = _tmp255_[0];
																		if (g_strcmp0 (_tmp256_, "type_arguments") == 0) {
																			ValaParameter* _tmp257_;
																			ValaDataType* _tmp258_;
																			ValaDataType* _tmp259_;
																			gchar** _tmp260_;
																			gint _tmp260__length1;
																			const gchar* _tmp261_;
																			gchar* _tmp262_;
																			gchar* _tmp263_;
																			_tmp257_ = p;
																			_tmp258_ = vala_variable_get_variable_type ((ValaVariable*) _tmp257_);
																			_tmp259_ = _tmp258_;
																			_tmp260_ = nv;
																			_tmp260__length1 = nv_length1;
																			_tmp261_ = _tmp260_[1];
																			_tmp262_ = vala_gidl_parser_eval (self, _tmp261_);
																			_tmp263_ = _tmp262_;
																			vala_gidl_parser_parse_type_arguments_from_string (self, _tmp259_, _tmp263_, NULL);
																			_g_free0 (_tmp263_);
																		} else {
																			gchar** _tmp264_;
																			gint _tmp264__length1;
																			const gchar* _tmp265_;
																			_tmp264_ = nv;
																			_tmp264__length1 = nv_length1;
																			_tmp265_ = _tmp264_[0];
																			if (g_strcmp0 (_tmp265_, "namespace_name") == 0) {
																				gchar** _tmp266_;
																				gint _tmp266__length1;
																				const gchar* _tmp267_;
																				gchar* _tmp268_;
																				_tmp266_ = nv;
																				_tmp266__length1 = nv_length1;
																				_tmp267_ = _tmp266_[1];
																				_tmp268_ = vala_gidl_parser_eval (self, _tmp267_);
																				_g_free0 (ns_name);
																				ns_name = _tmp268_;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
					_tmp269_ = ns_name;
					if (_tmp269_ != NULL) {
						ValaDataType* _tmp270_;
						ValaUnresolvedSymbol* _tmp271_;
						ValaUnresolvedSymbol* _tmp272_;
						const gchar* _tmp273_;
						ValaUnresolvedSymbol* _tmp274_;
						ValaUnresolvedSymbol* _tmp275_;
						_tmp270_ = param_type;
						_tmp271_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp270_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp272_ = _tmp271_;
						_tmp273_ = ns_name;
						_tmp274_ = vala_unresolved_symbol_new (NULL, _tmp273_, NULL);
						_tmp275_ = _tmp274_;
						vala_unresolved_symbol_set_inner (_tmp272_, _tmp275_);
						_vala_code_node_unref0 (_tmp275_);
					}
					_g_free0 (ns_name);
				}
				_tmp277_ = show_param;
				if (_tmp277_) {
					_tmp276_ = TRUE;
				} else {
					gboolean _tmp278_;
					_tmp278_ = hide_param;
					_tmp276_ = !_tmp278_;
				}
				if (_tmp276_) {
					ValaSignal* _tmp279_;
					ValaParameter* _tmp280_;
					_tmp279_ = sig;
					_tmp280_ = p;
					vala_callable_add_parameter ((ValaCallable*) _tmp279_, _tmp280_);
				}
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
			}
		}
	}
	result = sig;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ValaGIdlParser*
vala_gidl_parser_construct (GType object_type)
{
	ValaGIdlParser* self = NULL;
	self = (ValaGIdlParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIdlParser*
vala_gidl_parser_new (void)
{
	return vala_gidl_parser_construct (VALA_TYPE_GIDL_PARSER);
}


static void
vala_gidl_parser_class_init (ValaGIdlParserClass * klass)
{
	vala_gidl_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gidl_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIdlParserPrivate));
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor*, ValaNamespace*)) vala_gidl_parser_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gidl_parser_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_gidl_parser_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_gidl_parser_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_gidl_parser_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gidl_parser_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor*, ValaDelegate*)) vala_gidl_parser_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gidl_parser_real_visit_source_file;
}


static void
vala_gidl_parser_instance_init (ValaGIdlParser * self)
{
	self->priv = VALA_GIDL_PARSER_GET_PRIVATE (self);
}


static void
vala_gidl_parser_finalize (ValaCodeVisitor * obj)
{
	ValaGIdlParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIDL_PARSER, ValaGIdlParser);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	_vala_code_node_unref0 (self->priv->current_namespace);
	_vala_code_node_unref0 (self->priv->current_data_type);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	_vala_map_unref0 (self->priv->cname_type_map);
	VALA_CODE_VISITOR_CLASS (vala_gidl_parser_parent_class)->finalize (obj);
}


/**
 * Code visitor parsing all GIDL files.
 */
GType
vala_gidl_parser_get_type (void)
{
	static volatile gsize vala_gidl_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gidl_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIdlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gidl_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIdlParser), 0, (GInstanceInitFunc) vala_gidl_parser_instance_init, NULL };
		GType vala_gidl_parser_type_id;
		vala_gidl_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIdlParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_gidl_parser_type_id__volatile, vala_gidl_parser_type_id);
	}
	return vala_gidl_parser_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



