/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef _UNS_COMMON_DEFS_H
#define _UNS_COMMON_DEFS_H

#include "AMTPPDefs.h"
#include "Credentials.h"

// Registry location for AMT specific information

#ifdef _WIN32
#define AMT_UNS_REG_BASE "SOFTWARE\\Intel"
#else
#define AMT_UNS_REG_BASE "etc/Intel"
#endif
#define AMT_UNS_REG_KEY "IntelAMTUNS"
#define AMT_UNS_REG_USERNAME "Creds1"
#define AMT_UNS_REG_PASSWORD "Creds2"
#define AMT_PP_REG_USERNAME "Creds3"
#define AMT_PP_REG_PASSWORD "Creds4"
#define AMT_PP_REG_CERT "Creds5"
#define AMT_UNS_REG_CERT "Creds5" //Yes, this the same as AMT_PP_REG_CERT
#define AMT_UNS_REG_CAINFO  "Creds6"
#define AMT_UNS_REG_CAPATH  "Creds7"
#define AMT_UNS_REG_SSLKEY  "Creds8"
#define AMT_PP_REG_CAINFO  "Creds6" //Yes, this the same as AMT_UNS_REG_CAINFO
#define AMT_PP_REG_CAPATH  "Creds7" //Yes, this the same as AMT_UNS_REG_CAPATH
#define AMT_PP_REG_SSLKEY  "Creds8" //Yes, this the same as AMT_UNS_REG_SSLKEY
#define AMT_UNS_GET_POSTURE_INTERVAL "GetPostureInterval"

class CRED_REG_INFO
{
public:
	static const CredentialsRegInfo UNS;
	static const CredentialsRegInfo EAC;
};

#endif //_UNS_COMMON_DEFS_H
