# TransDecoder

TransDecoder identifies candidate coding regions within transcript sequences, such as those generated by de novo RNA-Seq transcript assembly using Trinity, or constructed based on RNA-Seq alignments to the genome using Tophat and Cufflinks.

It uses the following criteria:

*    a minimum length open reading frame (ORF) is found in a transcript sequence
*    a log-likelihood score similar to what is computed by the GeneID software is > 0.
*    the above coding score is greatest when the ORF is scored in the 1st reading frame as compared to scores in the other 5 reading frames.
*    if a candidate ORF is found fully encapsulated by the coordinates of another candidate ORF, the longer one is reported. However, a single transcript can report multiple ORFs (allowing for operons, chimeras, etc).
*    optional the putative peptide has a match to a Pfam domain above the noise cutoff score.

The software is primarily maintained by Brian Haas at the Broad Institute and Alexie Papanicolaou at the Commonwealth Scientific and Industrial Research Organisation (CSIRO). It is integrated into other related software such as Trinity, PASA, EVidenceModeler, and Trinotate.

Full documentation is provided at: http://transdecoder.github.io

===========================
To build just TransDecoder:

Please make sure you read http://transdecoder.sf.net before proceeding.

   %  make

See sample_data/ directory for example usage.


