8.1 Listy

# Listy

W tej sekcji przyjrzymy się bardzo przydatnej strukturze 
danych - liście. Spotkaliśmy ją na krótko już wcześniej w sekcji 
poświęconej randomizacji kiedy to wybieraliśmy z listy losowe 
nuty do zagrania:

```
play choose([50, 55, 62])
```

W obecnym rozdziale zobaczymy jak możemy wykorzystać listy również 
do reprezentacji akordów i skal. Na początku jednak spróbujmy sobie 
przypomnieć w jaki sposób możemy zagrać akord. Pamiętasz, że jeśli 
nie użyliśmy polecenia `sleep`, to wszystkie dźwięki zagrają 
jednocześnie: 

```
play 52
play 55
play 59
```

Spróbujmy przyjrzeć się innym sposobom, za pomocą których możemy 
wyrazić powyższy kod.

## Granie Listy

Jedną z opcji jest umieszczenie wszystkich nut w liście `[52, 55 , 59]`. 
Nasza poczciwa funkcja `play` jest wystarczająco bystra by wiedzieć 
w jaki sposób ma zagrać listę nut. Spróbuj tego: 

```
play [52, 55, 59]
```

Ooh, taki kod jest dużo przyjemniejszy do czytania. Zagranie listy nut, 
nie blokuje Ci korzystania z żadnego z parametrów: 

```
play [52, 55, 59], amp: 0.3
```

Oczywiście, możesz również używać tradycyjnych nazw nut zamiast korzystania 
z liczb MIDI: 

```
play [:E3, :G3, :B3]
```

Teraz Ci z Was, który mieli farta i studiowali trochę teorii muzycznej 
mogą zauważyć, że to jest akord *E Minor* zagrany na 3-ciej oktawie. 

## Dostęp do Listy

Innym bardzo przydatną cechą list jest możliwość wyciągnięcia z nich 
informacji. Może to brzmieć odrobinę dziwnie, ale nie jest to nic 
bardziej trudnego niż to gdy ktoś prosi Cię o to abyś przeszedł 
książce na stronę 23. Korzystając z listy, mógłbyś zapytać, jaki element 
znajduje się na 23 pozycji? Jedyną dziwną rzeczą w programowaniu jest to, 
że numery takich pozycji (indeksy) zazwyczaj zaczynają się od 0 
a nie od 1. 

Indeksy w listach nie są odliczane przez 1, 2, 3... Zamiast tego 
odliczamy 0, 1, 2...

Przyjrzyjmy się temu trochę bardziej. Spójrz na taką listę: 

```
[52, 55, 59]
```

Nie ma w niej nic specjalnie strasznego. Teraz pytania, jaki jest 
drugi element w tej liście. Tak, zgadłeś, jest to `55`. To było proste. 
Sprawdźmy, czy możemy poprosić komputer aby odpowiedział nam na 
to pytanie: 

```
puts [52, 55, 59][1]
```

Dobrze, to wygląda trochę dziwnie, jeśli jeszcze nigdy nie widziałeś 
niczego takiego. Zaufaj mi jednak, to nie jest trudne. W powyższej linii 
są 3 części: słowo `puts`, nasza lista `52, 55, 59` oraz nasz indeks 
`[1]`. Najpierw mówimy `puts` ponieważ chcemy aby Sonic Pi wyświetlił 
nam odpowiedź w panelu logowania (po prawej stronie). Następnie, przekazujemy 
do tego polecenia naszą listę i na końcu nasz indeks, który pyta nas 
o drugi element. Musimy otoczyć nasz indeks w nawiasy kwadratowe, 
a ponieważ liczenie zaczynamy od `0`, to indeks dla drugiego elementu 
to `1`. Spójrz: 

```
# indeksy:  0   1   2
           [52, 55, 59]
```

Spróbuj uruchomić kod `puts [52, 55, 59][1]` a zobaczysz, że liczba 
`55` pojawi się w panelu logowania. Zmień indeks `1` na inne wartości, 
spróbuj użyć dłuższych list i pomyśl w jaki sposob mógłbyś użyć listy 
w twojej kolejnej zabawie kodem. Na przykład, jakie muzyczne struktury 
mogą być reprezentowane jako seria liczb...
