#ifndef __ECCRYPT_H
#define __ECCRYPT_H

#include "eclib.h"

typedef ecPoint	PubKey;
typedef vlPoint	PrivKey;
typedef struct {
	vlPoint r, s;
} sgPair;

ERROR eccInit(void);
void eccQuit(void);
ERROR eccCheck(PubKey/*, PubKey*/);
ERROR eccMakePublicKey (PubKey, PrivKey);
ERROR eccEncode (PubKey *, ecPoint *, vlPoint, int);
ERROR eccDecode (PrivKey, ecPoint, vlPoint);
ERROR eccSign(PrivKey, vlPoint, vlPoint, sgPair *);
int eccVerify(PubKey, vlPoint, sgPair *);

#ifdef _ECCRYPT_C

#if (GF_T==9)

static ecPoint curve_point_raw = {
	0xa0, 0xb8, 0x6b, 0xdb, 0xa1, 0x68, 0x1c, 0x86, 0x9f, 0xda, 0x56, 0x88, 
	0xef, 0xe1, 0xc4, 0xea, 0x39, 0xdb, 0xa4, 0x17, 0xa3, 0xb0, 0x20, 0x62
};
/*
static vlPoint point_order_raw ={
	0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x16, 0x4F, 0x53, 0x25, 0x90, 0x16, 0x9C, 0x84, 0xD7, 0xF3, 0xB5, 0x97 
};
*/

static char point_order_raw[] =
	"400000000000000000000000164F532590169C84D7F3B597";
#elif (GF_T==18)

static ecPoint curve_point_raw = {
	0xb8, 0x50, 0xb3, 0xf1, 0xf4, 0x2c, 0x89, 0xaf, 0x55, 0xa3, 0x2b, 0x45, 
	0x7c, 0xbe, 0x8d, 0x7e, 0x2a, 0x6f, 0xc5, 0x5e, 0xf2, 0x32, 0xd0, 0x18
};

/*static vlPoint point_order_raw ={
	0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0x3C, 0x68, 0x52, 0xA8, 0xA6, 0x33, 0x27, 0xB9, 0x8D, 0xCA, 0xB5
};
*/

static car point_order_raw[]=
	"1FFFFFFFFFFFFFFFFFFFFFFFFD3C6852A8A63327B98DCAB5";

#elif (GF_T==71)

static ecPoint curve_point_raw = {
	0x43, 0x9b, 0x99, 0x77, 0xe7, 0x03, 0x29, 0xd3, 0x65, 0x71, 0xb9, 0x66, 
	0x49, 0xad, 0x2c, 0xab, 0xca, 0x2d, 0xd5, 0xf3, 0x2c, 0x1e, 0x7d, 0x68
};

/*static vlPoint point_order_raw ={
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x2C, 0xB4, 0x5E, 0x4B, 0x0E, 0x81, 0x08, 0x56, 0x05, 0x8B, 0x92, 0x15
};
*/
static car point_order_raw[]=
	"2000000000000000000000002CB45E4B0E810856058B9215";

#elif (GF_T==140)

static ecPoint curve_point_raw = {
	0xc9, 0x69, 0x7c, 0xdd, 0xf0, 0x22, 0xf9, 0xa4, 0x69, 0x4c, 0x7b, 0xcf, 
	0x21, 0xb9, 0x39, 0xbc, 0xc1, 0xe5, 0x5c, 0xe4, 0x5e, 0x0f, 0x82, 0xc2
};

/*static vlPoint point_order_raw ={
	0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF0, 0xE1, 0x49, 0xB5, 0x2B, 0x7A, 0x39, 0x39, 0xBC, 0x44, 0xE0, 0x55
};*/

static car point_order_raw[]=
	"1FFFFFFFFFFFFFFFFFFFFFFFF0E149B52B7A3939BC44E055";

#endif /* ? GF_T */

#endif /* ? _ECCRYPT_C */

#endif /* ?__ECCRYPT_H */
