// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_FILE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_FILE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AppendChunkCollectorToString_

template <typename TExpand> struct AppendChunkCollectorToString_;       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(354)

//____________________________________________________________________________
// AssignChunkCollectorToString_

template <typename TExpand> struct AssignChunkCollectorToString_;       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(284)

//____________________________________________________________________________
// AssignStreamToChunkCollector_

struct AssignStreamToChunkCollector_;       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(206)

//____________________________________________________________________________
// Async

template <typename TSpec > struct Async;       	// "seqan-1.3.1/seqan/file/file_base.h"(72)

//____________________________________________________________________________
// AsyncDummyRequest

struct AsyncDummyRequest;       	// "seqan-1.3.1/seqan/file/file_base.h"(160)

//____________________________________________________________________________
// AsyncRequest

template <typename T > struct AsyncRequest;       	// "seqan-1.3.1/seqan/file/file_base.h"(174)

//____________________________________________________________________________
// Chained

template <__int64 FileSize_ , typename TFile > struct Chained;       	// "seqan-1.3.1/seqan/file/file_base.h"(106)

//____________________________________________________________________________
// ChunkCollector_

template <typename THost> class ChunkCollector_;       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(63)

//____________________________________________________________________________
// ChunkLength

template <typename T> struct ChunkLength;       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(53)

//____________________________________________________________________________
// DefaultOpenMode

template <typename T> struct DefaultOpenMode;       	// "seqan-1.3.1/seqan/file/file_base.h"(139)

//____________________________________________________________________________
// DefaultOpenTempMode

template <typename T> struct DefaultOpenTempMode;       	// "seqan-1.3.1/seqan/file/file_base.h"(144)

//____________________________________________________________________________
// Dynamic

template <typename TSpec > struct Dynamic;       	// "seqan-1.3.1/seqan/file/file_page.h"(236)

//____________________________________________________________________________
// ExtStringConstIterator

template <typename TExtString > struct ExtStringConstIterator;       	// "seqan-1.3.1/seqan/file/string_external.h"(285)

//____________________________________________________________________________
// ExtStringFwdConstIterator

template <typename TExtString > struct ExtStringFwdConstIterator;       	// "seqan-1.3.1/seqan/file/string_external.h"(619)

//____________________________________________________________________________
// ExtStringFwdIterator

template <typename TExtString > struct ExtStringFwdIterator;       	// "seqan-1.3.1/seqan/file/string_external.h"(388)

//____________________________________________________________________________
// ExtStringIterator

template <typename TExtString > struct ExtStringIterator;       	// "seqan-1.3.1/seqan/file/string_external.h"(183)

//____________________________________________________________________________
// External

template <typename TConfig > struct External;       	// "seqan-1.3.1/seqan/file/string_external.h"(176)

//____________________________________________________________________________
// ExternalConfig

template <typename TFile_ , unsigned PAGE_SIZE_ , unsigned FRAMES_ > struct ExternalConfig;       	// "seqan-1.3.1/seqan/file/string_external.h"(99)

//____________________________________________________________________________
// ExternalConfigLarge

template <typename TFile_ , unsigned PAGE_SIZE_ , unsigned FRAMES_ > struct ExternalConfigLarge;       	// "seqan-1.3.1/seqan/file/string_external.h"(135)

//____________________________________________________________________________
// ExternalConfigSize

template <typename TSize_, typename TFile_ , unsigned PAGE_SIZE_ , unsigned FRAMES_ > struct ExternalConfigSize;       	// "seqan-1.3.1/seqan/file/string_external.h"(168)

//____________________________________________________________________________
// File

template <typename TSpec > class File;       	// "seqan-1.3.1/seqan/file/file_base.h"(86)

//____________________________________________________________________________
// FileFormat

template <typename TFile, typename TData, typename TMeta, typename TFormat > struct FileFormat;       	// "seqan-1.3.1/seqan/file/file_format.h"(74)

//____________________________________________________________________________
// FileReader

template <typename TFormat, typename TFile, typename TSpec> struct FileReader;       	// "seqan-1.3.1/seqan/file/file_filereader.h"(40)

//____________________________________________________________________________
// FileReaderIterator

struct FileReaderIterator;       	// "seqan-1.3.1/seqan/file/file_filereader.h"(425)

//____________________________________________________________________________
// FileReaderTypes_

template <typename T> struct FileReaderTypes_;       	// "seqan-1.3.1/seqan/file/file_filereader.h"(433)

//____________________________________________________________________________
// Fixed

template <unsigned PageSize_ > struct Fixed;       	// "seqan-1.3.1/seqan/file/file_page.h"(266)

//____________________________________________________________________________
// IsTellAndSeekStream_

template <typename T> struct IsTellAndSeekStream_;       	// "seqan-1.3.1/seqan/file/stream.h"(191)
template <typename T> struct IsTellAndSeekStream_;       	// "seqan-1.3.1/seqan/file/cstream.h"(75)

//____________________________________________________________________________
// MMap

template <typename TConfig > struct MMap;       	// "seqan-1.3.1/seqan/file/string_mmap.h"(50)

//____________________________________________________________________________
// MMapConfig

template <typename TFile_ , typename TSize_ > struct MMapConfig;       	// "seqan-1.3.1/seqan/file/string_mmap.h"(44)

//____________________________________________________________________________
// PageBucket

template <typename TValue > struct PageBucket;       	// "seqan-1.3.1/seqan/file/file_page.h"(168)

//____________________________________________________________________________
// PageBucketExtended

template <typename TValue > struct PageBucketExtended;       	// "seqan-1.3.1/seqan/file/file_page.h"(176)

//____________________________________________________________________________
// PageChain

template <typename TPageFrame > struct PageChain;       	// "seqan-1.3.1/seqan/file/file_page.h"(581)

//____________________________________________________________________________
// PageContainer

template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > struct PageContainer;       	// "seqan-1.3.1/seqan/file/file_page.h"(720)

//____________________________________________________________________________
// PageFrame

template <typename TValue, typename TFile, typename TSpec > struct PageFrame;       	// "seqan-1.3.1/seqan/file/file_page.h"(207)

//____________________________________________________________________________
// ReadRaw_

template <typename TFile, typename TData, typename TTag> struct ReadRaw_;       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(60)

//____________________________________________________________________________
// ReplaceChunkCollectorToString_

template <typename TExpand> struct ReplaceChunkCollectorToString_;       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(427)

//____________________________________________________________________________
// SimpleBuffer

template <typename TValue > struct SimpleBuffer;       	// "seqan-1.3.1/seqan/file/file_page.h"(48)

//____________________________________________________________________________
// Striped

template <unsigned FileCount_ , typename TFile > struct Striped;       	// "seqan-1.3.1/seqan/file/file_base.h"(124)

//____________________________________________________________________________
// Sync

template <typename TSpec > struct Sync;       	// "seqan-1.3.1/seqan/file/file_base.h"(60)

//____________________________________________________________________________
// TagCGViz_

struct TagCGViz_;       	// "seqan-1.3.1/seqan/file/file_format_cgviz.h"(49)

//____________________________________________________________________________
// TagEmbl_

struct TagEmbl_;       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(47)

//____________________________________________________________________________
// TagFasta_

struct TagFasta_;       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(48)

//____________________________________________________________________________
// TagGenbank_

struct TagGenbank_;       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(48)

//____________________________________________________________________________
// TagRaw_

struct TagRaw_;       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(50)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// FastaAlign_

struct FastaAlign_;       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(62)

//____________________________________________________________________________
// Row

template <typename T> struct Row;       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(48)

//____________________________________________________________________________
// Rows

template <typename T> struct Rows;       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(51)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CGViz

typedef Tag<TagCGViz_> const CGViz;       	// "seqan-1.3.1/seqan/file/file_format_cgviz.h"(50)

//____________________________________________________________________________
// Embl

typedef Tag<TagEmbl_> const Embl;       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(48)

//____________________________________________________________________________
// Fasta

typedef Tag<TagFasta_> const Fasta;       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(49)

//____________________________________________________________________________
// Genbank

typedef Tag<TagGenbank_> const Genbank;       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(49)

//____________________________________________________________________________
// Raw

typedef Tag<TagRaw_> const Raw;       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(51)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// FastaAlign

typedef Tag<FastaAlign_> FastaAlign;       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(63)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _allocateStorage

template <typename TValue, typename TConfig, typename TSize > inline typename Value<String<TValue, MMap<TConfig> > >::Type * _allocateStorage(String<TValue, MMap<TConfig> > &me, TSize new_capacity);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(681)

//____________________________________________________________________________
// _cancelFArray

template <typename TFileArray, typename TRequest > inline bool _cancelFArray(TFileArray &me, TRequest &request);       	// "seqan-1.3.1/seqan/file/file_array.h"(284)

//____________________________________________________________________________
// _closeFArray

template <typename TFileArray > inline bool _closeFArray(TFileArray &me);       	// "seqan-1.3.1/seqan/file/file_array.h"(254)

//____________________________________________________________________________
// _constructFileReaderString

template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline void _constructFileReaderString(String<TValue, FileReader<TFormat, TFile, TSpec> > & me);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(277)

//____________________________________________________________________________
// _dataFile

template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline TFile & _dataFile(String<TValue, FileReader<TFormat, TFile, TSpec> > & me);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(178)

//____________________________________________________________________________
// _deallocateStorage

template <typename TValue, typename TConfig, typename TSize > inline void _deallocateStorage(String<TValue, MMap<TConfig> > & , TValue * , TSize );       	// "seqan-1.3.1/seqan/file/string_mmap.h"(701)

//____________________________________________________________________________
// _ensureFileIsOpen

template <typename TValue, typename TConfig > inline void _ensureFileIsOpen(String<TValue, MMap<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(764)

//____________________________________________________________________________
// _fastaScanLine

template <typename TFile, typename TSize> inline typename Value<TFile>::Type _fastaScanLine(TFile & file, TSize & count_valid, TSize & count_all);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(158)

//____________________________________________________________________________
// _findBlockFileReaderString

template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPosition> inline unsigned int _findBlockFileReaderString(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TPosition pos);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(256)

//____________________________________________________________________________
// _flushFArray

template <typename TFileArray > inline bool _flushFArray(TFileArray &me);       	// "seqan-1.3.1/seqan/file/file_array.h"(276)

//____________________________________________________________________________
// _getCStyleOpenMode

inline const char * _getCStyleOpenMode(int openMode);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(80)

//____________________________________________________________________________
// _holderAllocatePointer

template <typename THolder> inline FILE * _holderAllocatePointer(THolder &, FILE * data);       	// "seqan-1.3.1/seqan/file/cstream.h"(250)

//____________________________________________________________________________
// _holderDeallocate

template <typename THolder> inline void _holderDeallocate(THolder &, FILE *);       	// "seqan-1.3.1/seqan/file/cstream.h"(245)

//____________________________________________________________________________
// _isValidBlockFileReaderString

template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TUint> inline bool _isValidBlockFileReaderString(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TUint block_number);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(294)

//____________________________________________________________________________
// _loadBlockFileReaderString

template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPosition> inline void _loadBlockFileReaderString(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TPosition blocknum);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(189)

//____________________________________________________________________________
// _loadCompleteFileReaderString

template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline void _loadCompleteFileReaderString(String<TValue, FileReader<TFormat, TFile, TSpec> > & me);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(311)

//____________________________________________________________________________
// _map

template <typename TValue, typename TConfig > inline bool _map(String<TValue, MMap<TConfig> > &me, size_t new_capacity);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(378)
template <typename TValue, typename TConfig > inline bool _map(String<TValue, MMap<TConfig> > &me, size_t new_capacity);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(557)

//____________________________________________________________________________
// _openTempFArray

template <typename TFileArray > inline bool _openTempFArray(TFileArray &me, int openMode);       	// "seqan-1.3.1/seqan/file/file_array.h"(233)
template <typename TFileArray > inline bool _openTempFArray(TFileArray &me);       	// "seqan-1.3.1/seqan/file/file_array.h"(241)

//____________________________________________________________________________
// _readNCharsFromFile

template <typename TFile, typename TSize> inline void _readNCharsFromFile(TFile & file, TSize count);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(193)

//____________________________________________________________________________
// _reallocateStorage

template <typename TValue, typename TConfig, typename TSize > inline typename Value<String<TValue, MMap<TConfig> > >::Type * _reallocateStorage( String<TValue, MMap<TConfig> > &me, TSize new_capacity);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(692)

//____________________________________________________________________________
// _remap

template <typename TValue, typename TConfig, typename TCapSize > inline bool _remap(String<TValue, MMap<TConfig> > &me, TCapSize new_capacity);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(455)
template <typename TValue, typename TConfig, typename TCapSize > inline bool _remap(String<TValue, MMap<TConfig> > &me, TCapSize new_capacity);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(609)

//____________________________________________________________________________
// _reopenFArray

template <typename TFileArray > inline bool _reopenFArray(TFileArray &me, int openMode);       	// "seqan-1.3.1/seqan/file/file_array.h"(246)

//____________________________________________________________________________
// _sectorSizeFArray

template <typename TFileArray > inline unsigned _sectorSizeFArray(TFileArray &me, int );       	// "seqan-1.3.1/seqan/file/file_array.h"(262)

//____________________________________________________________________________
// _setCapacity

template <typename TValue, typename TConfig > inline void _setCapacity( String<TValue, MMap<TConfig> > & me, size_t new_capacity);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(277)

//____________________________________________________________________________
// _setLength

template <typename TValue, typename TConfig > inline void _setLength( String<TValue, MMap<TConfig> > & me, size_t new_length);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(265)
template <typename THost> inline void _setLength(ChunkCollector_<THost> & me, typename Size<THost>::Type new_length);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(118)

//____________________________________________________________________________
// _sizeFArray

template <typename TFileArray > inline typename Size<TFileArray>::Type _sizeFArray(TFileArray &me);       	// "seqan-1.3.1/seqan/file/file_array.h"(268)

//____________________________________________________________________________
// _streamAppendLine

template <typename TFile, typename TString, typename TChar> inline void _streamAppendLine(TFile & file, TString & str, TChar & c);       	// "seqan-1.3.1/seqan/file/file_format.h"(451)

//____________________________________________________________________________
// _streamClose

inline void _streamClose(::std::FILE * & me);       	// "seqan-1.3.1/seqan/file/cstream.h"(105)

//____________________________________________________________________________
// _streamCountLine

template <typename TFile, typename TChar> inline void _streamCountLine(TFile & file, TChar & c);       	// "seqan-1.3.1/seqan/file/file_format.h"(483)

//____________________________________________________________________________
// _streamEOF

template <typename TValue, typename TTraits> inline bool _streamEOF(::std::basic_istream<TValue, TTraits> const & me);       	// "seqan-1.3.1/seqan/file/stream.h"(221)
inline bool _streamEOF(::std::FILE * me);       	// "seqan-1.3.1/seqan/file/cstream.h"(120)

//____________________________________________________________________________
// _streamGet

template <typename TValue, typename TTraits> inline TValue _streamGet(::std::basic_istream<TValue, TTraits> & source);       	// "seqan-1.3.1/seqan/file/stream.h"(269)
inline char _streamGet(::std::FILE * source);       	// "seqan-1.3.1/seqan/file/cstream.h"(147)

//____________________________________________________________________________
// _streamIsLetter

template <typename TChar> inline bool _streamIsLetter(TChar const c);       	// "seqan-1.3.1/seqan/file/file_format.h"(583)

//____________________________________________________________________________
// _streamOpen

inline bool _streamOpen(::std::FILE * & me, String<char> path, bool for_read );       	// "seqan-1.3.1/seqan/file/cstream.h"(87)

//____________________________________________________________________________
// _streamPeek

template <typename TValue, typename TTraits> inline TValue _streamPeek(::std::basic_istream<TValue, TTraits> & source);       	// "seqan-1.3.1/seqan/file/stream.h"(289)

//____________________________________________________________________________
// _streamPut

template <typename TValue, typename TTraits, typename TChar> inline void _streamPut(::std::basic_ostream<TValue, TTraits> & target, TChar character);       	// "seqan-1.3.1/seqan/file/stream.h"(329)
inline void _streamPut(::std::FILE * target, char character);       	// "seqan-1.3.1/seqan/file/cstream.h"(159)

//____________________________________________________________________________
// _streamPutFloat

template <typename TStream> inline void _streamPutFloat(TStream & target, double number, char const * format_string);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(85)
template <typename TStream> inline void _streamPutFloat(TStream & target, double number);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(95)

//____________________________________________________________________________
// _streamPutInt

template <typename TStream> inline void _streamPutInt(TStream & target, int number, char const * format_string);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(56)
template <typename TStream> inline void _streamPutInt(TStream & target, int number);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(66)

//____________________________________________________________________________
// _streamRead

template <typename TValue, typename TTraits> inline ::std::streamsize _streamRead(TValue * target, ::std::basic_istream<TValue, TTraits> & source, ::std::streamsize limit);       	// "seqan-1.3.1/seqan/file/stream.h"(248)
template <typename TValue> inline size_t _streamRead(TValue * target, ::std::FILE * source, size_t limit);       	// "seqan-1.3.1/seqan/file/cstream.h"(136)

//____________________________________________________________________________
// _streamReadWord

template <typename TFile, typename TChar> inline String<char> _streamReadWord(TFile & file, TChar& c);       	// "seqan-1.3.1/seqan/file/file_format.h"(567)

//____________________________________________________________________________
// _streamSeek2G

template <typename TValue, typename TTraits> inline void _streamSeek2G(::std::basic_istream<TValue, TTraits> & me, int off);       	// "seqan-1.3.1/seqan/file/stream.h"(436)
inline void _streamSeek2G(FILE * me, int off);       	// "seqan-1.3.1/seqan/file/cstream.h"(222)

//____________________________________________________________________________
// _streamSeekG

template <typename TValue, typename TTraits> inline void _streamSeekG(::std::basic_istream<TValue, TTraits> & me, typename Position< ::std::basic_istream<TValue, TTraits> >::Type pos);       	// "seqan-1.3.1/seqan/file/stream.h"(389)
inline void _streamSeekG(FILE * me, Position<FILE *>::Type pos);       	// "seqan-1.3.1/seqan/file/cstream.h"(198)

//____________________________________________________________________________
// _streamSeekP

template <typename TValue, typename TTraits> inline void _streamSeekP(::std::basic_ostream<TValue, TTraits> & me, typename Position< ::std::basic_ostream<TValue, TTraits> >::Type pos);       	// "seqan-1.3.1/seqan/file/stream.h"(413)
inline void _streamSeekP(FILE * me, Position<FILE *>::Type pos);       	// "seqan-1.3.1/seqan/file/cstream.h"(210)

//____________________________________________________________________________
// _streamSkipLine

template <typename TFile, typename TChar> inline typename Size<TFile>::Type _streamSkipLine(TFile & file, TChar & c);       	// "seqan-1.3.1/seqan/file/file_format.h"(514)

//____________________________________________________________________________
// _streamSkipWhitespace

template <typename TFile, typename TChar> inline void _streamSkipWhitespace(TFile& file, TChar& c);       	// "seqan-1.3.1/seqan/file/file_format.h"(553)

//____________________________________________________________________________
// _streamTellG

template <typename TValue, typename TTraits> inline typename Position< ::std::basic_istream<TValue, TTraits> >::Type _streamTellG(::std::basic_istream<TValue, TTraits> & me);       	// "seqan-1.3.1/seqan/file/stream.h"(348)
inline Position<FILE *>::Type _streamTellG(FILE * me);       	// "seqan-1.3.1/seqan/file/cstream.h"(175)

//____________________________________________________________________________
// _streamTellP

template <typename TValue, typename TTraits> inline typename Position< ::std::basic_ostream<TValue, TTraits> >::Type _streamTellP(::std::basic_ostream<TValue, TTraits> & me);       	// "seqan-1.3.1/seqan/file/stream.h"(367)
inline Position<FILE *>::Type _streamTellP(FILE * me);       	// "seqan-1.3.1/seqan/file/cstream.h"(186)

//____________________________________________________________________________
// _streamUnget

template <typename TValue, typename TTraits> inline void _streamUnget(::std::basic_istream<TValue, TTraits> & source);       	// "seqan-1.3.1/seqan/file/stream.h"(308)
inline void _streamUnget(::std::FILE * stream);       	// "seqan-1.3.1/seqan/file/cstream.h"(233)

//____________________________________________________________________________
// _streamWrite

template <typename TTarget, typename T1, typename T2, typename TCompression> inline void _streamWrite(TTarget & target, Pair<T1, T2, TCompression> const & source);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(107)
template <typename TTarget, typename T1, typename T2, typename T3, typename TCompression> inline void _streamWrite(TTarget & target, Triple<T1, T2, T3, TCompression> const & source);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(117)
template <typename TTarget, typename TSource> inline void _streamWrite(TTarget & target, TSource const & source);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(141)

//____________________________________________________________________________
// _streamWriteRange

template <typename TTarget, typename TIterator> inline void _streamWriteRange(TTarget & target, TIterator begin_, TIterator end_);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(206)

//____________________________________________________________________________
// _streamWriteSeq

template <typename TTarget, typename TSource> inline void _streamWriteSeq(TTarget & target, TSource const & source, False const);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(153)
template <typename TTarget, typename TSource> inline void _streamWriteSeq(TTarget & target, TSource const & source, True const);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(164)
template <typename TTarget, typename TSourceValue> inline void _streamWriteSeq(TTarget & target, TSourceValue const * source, True const);       	// "seqan-1.3.1/seqan/file/stream_algorithms.h"(181)

//____________________________________________________________________________
// _stringAppendLine

template <typename TString1, typename TString2, typename TIter> inline void _stringAppendLine(TString1 & str, TString2 & a_str, TIter & it);       	// "seqan-1.3.1/seqan/file/file_format.h"(643)

//____________________________________________________________________________
// _stringReadNumber

template <typename TString, typename TIter> inline int _stringReadNumber(TString & str, TIter& it);       	// "seqan-1.3.1/seqan/file/file_format.h"(687)

//____________________________________________________________________________
// _stringSkipLine

template <typename TString, typename TIter> inline typename Size<TString>::Type _stringSkipLine(TString & str, TIter & it);       	// "seqan-1.3.1/seqan/file/file_format.h"(607)

//____________________________________________________________________________
// _stringSkipWhitespace

template <typename TString, typename TIter> inline void _stringSkipWhitespace(TString& str, TIter& it);       	// "seqan-1.3.1/seqan/file/file_format.h"(674)

//____________________________________________________________________________
// _unmap

template <typename TValue, typename TConfig > inline bool _unmap(String<TValue, MMap<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(424)
template <typename TValue, typename TConfig > inline bool _unmap(String<TValue, MMap<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(586)

//____________________________________________________________________________
// _writeImpl

template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void _writeImpl(TFile& target, Align<TSource, TSpec>& align, TStringContainer& ids, CGViz);       	// "seqan-1.3.1/seqan/file/file_format_cgviz.h"(76)
template <typename TFile, typename TString, typename TData> void _writeImpl(TFile & file, TData & data, TString & id, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(501)

//____________________________________________________________________________
// alignSize

template <typename T1, typename T2> inline T1 alignSize(T1 _size, T2 _aligning);       	// "seqan-1.3.1/seqan/file/file_base.h"(750)

//____________________________________________________________________________
// allocPage

template <typename TValue, typename TSize, typename T > inline void allocPage(SimpleBuffer<TValue> &pf, TSize size, T const & me);       	// "seqan-1.3.1/seqan/file/file_page.h"(126)
template <typename TValue, typename TFile, typename TSpec, typename T > inline void allocPage(PageFrame<TValue, TFile, TSpec> &pf, T const & me);       	// "seqan-1.3.1/seqan/file/file_page.h"(389)

//____________________________________________________________________________
// allocate

template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize > inline void allocate(File< Chained<FILE_SIZE, TFile> > const &me, TValue* &data, TSize count);       	// "seqan-1.3.1/seqan/file/file_array.h"(352)
template <unsigned FileCount_, typename TFile, typename TValue, typename TSize > inline void allocate(File< Striped<FileCount_, TFile> > const &me, TValue* &data, TSize count);       	// "seqan-1.3.1/seqan/file/file_array.h"(362)

//____________________________________________________________________________
// append

template <typename TValue, typename TConfig, typename TSource, typename TExpand > inline void append(String<TValue, External<TConfig> > &target, TSource const &source, Tag<TExpand> const expand);       	// "seqan-1.3.1/seqan/file/string_external.h"(1960)
template <typename TValue, typename TConfig, typename TSourceValue, typename TExpand > inline void append(String<TValue, External<TConfig> > &target, TSourceValue * source, Tag<TExpand> const expand);       	// "seqan-1.3.1/seqan/file/string_external.h"(1981)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, ChunkCollector_<TSourceHost> const & source, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(410)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, ChunkCollector_<TSourceHost> const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(419)

//____________________________________________________________________________
// appendValue

template <typename TValue, typename TConfig, typename TExpand > inline void appendValue(String<TValue, External<TConfig> > &me, TValue const &Val_, Tag<TExpand> const expand);       	// "seqan-1.3.1/seqan/file/string_external.h"(1898)

//____________________________________________________________________________
// assign

template <typename TValue, typename TConfig, typename TSource, typename TExpand > inline void assign( String<TValue, External<TConfig> > &target, TSource const &source, Tag<TExpand> const);       	// "seqan-1.3.1/seqan/file/string_external.h"(2032)
template <typename TValue, typename TConfig, typename TSourceValue, typename TExpand > inline void assign( String<TValue, External<TConfig> > &target, TSourceValue * source, Tag<TExpand> const);       	// "seqan-1.3.1/seqan/file/string_external.h"(2055)
template <typename THost, typename TSource> inline void assign(ChunkCollector_<THost> & target, TSource & source);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(251)
template <typename THost, typename TSource> inline void assign(ChunkCollector_<THost> & target, TSource const & source);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(258)
template <typename THost, typename TSource, typename TSize> inline void assign(ChunkCollector_<THost> & target, TSource & source, TSize limit);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(267)
template <typename THost, typename TSource, typename TSize> inline void assign(ChunkCollector_<THost> & target, TSource const & source, TSize limit);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(275)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, ChunkCollector_<TSourceHost> const & source, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(336)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, ChunkCollector_<TSourceHost> const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(345)

//____________________________________________________________________________
// asyncReadAt

template <typename File, typename TValue, typename TSize, typename TPos, typename AsyncRequest > inline bool asyncReadAt(File & me, TValue *memPtr, TSize const count, TPos const fileOfs, AsyncRequest &);       	// "seqan-1.3.1/seqan/file/file_base.h"(639)
template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize, typename TOffset, typename TRequest > inline bool asyncReadAt(File< Chained<FILE_SIZE, TFile> > &me, TValue *memPtr, TSize count, TOffset offset, TRequest &req);       	// "seqan-1.3.1/seqan/file/file_array.h"(404)

//____________________________________________________________________________
// asyncWriteAt

template <typename File, typename TValue, typename TSize, typename TPos, typename AsyncRequest > inline bool asyncWriteAt(File & me, TValue const *memPtr, TSize const count, TPos const fileOfs, AsyncRequest &);       	// "seqan-1.3.1/seqan/file/file_base.h"(664)
template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize, typename TOffset, typename TRequest > inline bool asyncWriteAt(File< Chained<FILE_SIZE, TFile> > &me, TValue const *memPtr, TSize count, TOffset offset, TRequest &req);       	// "seqan-1.3.1/seqan/file/file_array.h"(421)

//____________________________________________________________________________
// atBegin

template <typename TExtString> inline bool atBegin(ExtStringIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(947)
template <typename TExtString> inline bool atBegin(ExtStringIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(949)
template <typename TExtString> inline bool atBegin(ExtStringConstIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(952)
template <typename TExtString> inline bool atBegin(ExtStringConstIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(954)
template <typename TExtString> inline bool atBegin(ExtStringFwdIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(957)
template <typename TExtString> inline bool atBegin(ExtStringFwdIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(961)
template <typename TExtString> inline bool atBegin(ExtStringFwdConstIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(966)
template <typename TExtString> inline bool atBegin(ExtStringFwdConstIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(970)
template <typename TContainer> inline bool atBegin(Iter<TContainer, FileReaderIterator> & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(784)
template <typename TContainer> inline bool atBegin(Iter<TContainer, FileReaderIterator> const & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(790)

//____________________________________________________________________________
// atEnd

template <typename TExtString> inline bool atEnd(ExtStringIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(976)
template <typename TExtString> inline bool atEnd(ExtStringIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(978)
template <typename TExtString> inline bool atEnd(ExtStringConstIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(981)
template <typename TExtString> inline bool atEnd(ExtStringConstIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(983)
template <typename TExtString> inline bool atEnd(ExtStringFwdIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(986)
template <typename TExtString> inline bool atEnd(ExtStringFwdIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(990)
template <typename TExtString> inline bool atEnd(ExtStringFwdConstIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(995)
template <typename TExtString> inline bool atEnd(ExtStringFwdConstIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(999)
template <typename TContainer> inline bool atEnd(Iter<TContainer, FileReaderIterator> & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(769)
template <typename TContainer> inline bool atEnd(Iter<TContainer, FileReaderIterator> const & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(775)

//____________________________________________________________________________
// back

template <typename TValue, typename TConfig > inline TValue & back(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1943)
template <typename TValue, typename TConfig > inline TValue const & back(String<TValue, External<TConfig> > const &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1950)

//____________________________________________________________________________
// begin

template <typename TValue, typename TConfig > inline typename Iterator<String<TValue, MMap<TConfig> > , Standard>::Type begin(String<TValue, MMap<TConfig> > & me, Standard);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(208)
template <typename TValue, typename TConfig > inline typename Iterator<String<TValue, MMap<TConfig> > const, Standard>::Type begin(String<TValue, MMap<TConfig> > const & me, Standard);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(216)
template <typename TValue, typename TConfig, typename TSpec > inline typename Iterator<String<TValue, External<TConfig> >, Tag<TSpec> const>::Type begin(String<TValue, External<TConfig> > &me, Tag<TSpec> const);       	// "seqan-1.3.1/seqan/file/string_external.h"(1848)
template <typename TValue, typename TConfig, typename TSpec > inline typename Iterator<String<TValue, External<TConfig> > const, Tag<TSpec> const>::Type begin(String<TValue, External<TConfig> > const &me, Tag<TSpec> const);       	// "seqan-1.3.1/seqan/file/string_external.h"(1856)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> >, TIteratorSpec >::Type begin(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, Tag<TIteratorSpec> const);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(363)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> > const, TIteratorSpec >::Type begin(String<TValue, FileReader<TFormat, TFile, TSpec> > const & me, Tag<TIteratorSpec> const);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(371)
template <typename TValue > inline TValue* begin(SimpleBuffer<TValue> &pf, Standard);       	// "seqan-1.3.1/seqan/file/file_page.h"(141)
template <typename TValue > inline TValue const * begin(SimpleBuffer<TValue> const &pf, Standard);       	// "seqan-1.3.1/seqan/file/file_page.h"(146)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Iterator< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS>, Standard >::Type begin( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> &pageCont, Standard const);       	// "seqan-1.3.1/seqan/file/file_page.h"(931)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Iterator< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const, Standard >::Type begin( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const &pageCont, Standard const);       	// "seqan-1.3.1/seqan/file/file_page.h"(940)

//____________________________________________________________________________
// cancel

template <typename TValue, typename TConfig > inline void cancel(String<TValue, MMap<TConfig> > &);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(363)
template <typename TValue, typename TConfig > inline void cancel(String<TValue, MMap<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(540)
template <typename TValue, typename TConfig > inline void cancel(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1579)
template <typename AsyncRequest > inline bool cancel(FILE*, AsyncRequest &);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(239)
template <typename TSpec, typename AsyncRequest > inline bool cancel(File<TSpec> &, AsyncRequest &);       	// "seqan-1.3.1/seqan/file/file_base.h"(735)
template <typename TValue, typename TFile, typename TSpec > inline bool cancel(PageFrame<TValue, TFile, TSpec> &pf, TFile &file);       	// "seqan-1.3.1/seqan/file/file_page.h"(491)

//____________________________________________________________________________
// cancelAndFree

template <typename TValue, typename TConfig > inline void cancelAndFree(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1597)

//____________________________________________________________________________
// capacity

template <typename TValue, typename TConfig > inline typename Size<String<TValue, MMap<TConfig> > >::Type capacity(String<TValue, MMap<TConfig> > & me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(245)
template <typename TValue, typename TConfig > inline typename Size<String<TValue, MMap<TConfig> > >::Type capacity(String<TValue, MMap<TConfig> > const & me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(253)
template <typename TValue, typename TConfig > inline typename Size< String<TValue, External<TConfig> > >::Type capacity(String<TValue, External<TConfig> > const &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1800)

//____________________________________________________________________________
// chunkCount

template <typename THost> inline int chunkCount(ChunkCollector_<THost> const & me);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(125)

//____________________________________________________________________________
// clear

template <typename TValue, typename TConfig > inline void clear(String<TValue, MMap<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(662)
template <typename TValue, typename TConfig > inline void clear(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1528)
template <typename THost> inline void clear(ChunkCollector_<THost> & me);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(92)

//____________________________________________________________________________
// close

template <typename TValue, typename TConfig > inline bool close(String<TValue, MMap<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(805)
template <typename TValue, typename TConfig > inline bool close(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1771)
inline bool close(FILE* me);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(125)
template <typename TSpec > inline bool close(File<TSpec> & me);       	// "seqan-1.3.1/seqan/file/file_base.h"(289)
template <__int64 FILE_SIZE, typename TFile > inline bool close(File< Chained<FILE_SIZE, TFile> > &me);       	// "seqan-1.3.1/seqan/file/file_array.h"(327)
template <unsigned FileCount_, typename TFile > inline bool close(File< Striped<FileCount_, TFile> > &me);       	// "seqan-1.3.1/seqan/file/file_array.h"(334)

//____________________________________________________________________________
// container

template <typename TExtString> inline TExtString & container(ExtStringIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(926)
template <typename TExtString> inline TExtString & container(ExtStringIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(928)
template <typename TExtString> inline TExtString & container(ExtStringConstIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(931)
template <typename TExtString> inline TExtString & container(ExtStringConstIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(933)
template <typename TExtString> inline TExtString & container(ExtStringFwdIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(936)
template <typename TExtString> inline TExtString & container(ExtStringFwdIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(938)
template <typename TExtString> inline TExtString & container(ExtStringFwdConstIterator<TExtString> &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(941)
template <typename TExtString> inline TExtString & container(ExtStringFwdConstIterator<TExtString> const &it);       	// "seqan-1.3.1/seqan/file/string_external.h"(943)
template <typename TContainer> inline TContainer & container(Iter<TContainer, FileReaderIterator> & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(596)
template <typename TContainer> inline TContainer & container(Iter<TContainer, FileReaderIterator> const & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(602)

//____________________________________________________________________________
// createChunk

template <typename THost> inline typename Value<THost>::Type * createChunk(ChunkCollector_<THost> & me);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(139)

//____________________________________________________________________________
// deallocate

template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize > inline void deallocate(File< Chained<FILE_SIZE, TFile> > const &me, TValue* &data, TSize count);       	// "seqan-1.3.1/seqan/file/file_array.h"(357)
template <unsigned FileCount_, typename TFile, typename TValue, typename TSize > inline void deallocate(File< Striped<FileCount_, TFile> > const &me, TValue* &data, TSize count);       	// "seqan-1.3.1/seqan/file/file_array.h"(367)

//____________________________________________________________________________
// enclosingBlocks

template <typename T1, typename T2> inline T1 enclosingBlocks(T1 _size, T2 _blockSize);       	// "seqan-1.3.1/seqan/file/file_base.h"(744)

//____________________________________________________________________________
// end

template <typename TValue, typename TConfig > inline typename Iterator<String<TValue, MMap<TConfig> > , Standard>::Type end(String<TValue, MMap<TConfig> > & me, Standard);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(227)
template <typename TValue, typename TConfig > inline typename Iterator<String<TValue, MMap<TConfig> > const, Standard>::Type end(String<TValue, MMap<TConfig> > const & me, Standard);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(235)
template <typename TValue, typename TConfig, typename TSpec > inline typename Iterator<String<TValue, External<TConfig> >, Tag<TSpec> const>::Type end(String<TValue, External<TConfig> > &me, Tag<TSpec> const);       	// "seqan-1.3.1/seqan/file/string_external.h"(1864)
template <typename TValue, typename TConfig, typename TSpec > inline typename Iterator<String<TValue, External<TConfig> > const, Tag<TSpec> const>::Type end(String<TValue, External<TConfig> > const &me, Tag<TSpec> const);       	// "seqan-1.3.1/seqan/file/string_external.h"(1872)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> >, TIteratorSpec >::Type end(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, Tag<TIteratorSpec> const);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(383)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> > const, TIteratorSpec >::Type end(String<TValue, FileReader<TFormat, TFile, TSpec> > const & me, Tag<TIteratorSpec> const);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(391)
template <typename TValue > inline TValue * end(SimpleBuffer<TValue> &pf, Standard);       	// "seqan-1.3.1/seqan/file/file_page.h"(151)
template <typename TValue > inline TValue const * end(SimpleBuffer<TValue> const &pf, Standard);       	// "seqan-1.3.1/seqan/file/file_page.h"(156)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Iterator< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS>, Standard >::Type end( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> &pageCont, Standard const);       	// "seqan-1.3.1/seqan/file/file_page.h"(949)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Iterator< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const, Standard >::Type end( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const &pageCont, Standard const);       	// "seqan-1.3.1/seqan/file/file_page.h"(958)

//____________________________________________________________________________
// equiDistantAlignedDistribution

template <typename TValue, typename TSize, typename T, class Function > inline unsigned equiDistantAlignedDistribution( SimpleBuffer<TValue> &_clusterBuffer, unsigned aligning, unsigned _bufferSize, T const &me, TSize _size, unsigned _pageSize, Function const &Func_);       	// "seqan-1.3.1/seqan/file/file_page.h"(1034)

//____________________________________________________________________________
// equiDistantDistribution

template <typename TValue, typename TSize, typename T, class Function > inline bool equiDistantDistribution( SimpleBuffer<TValue> &_clusterBuffer, unsigned _bufferSize, T const &me, TSize _size, unsigned _pageSize, Function const &Func_);       	// "seqan-1.3.1/seqan/file/file_page.h"(972)

//____________________________________________________________________________
// flush

template <typename TValue, typename TConfig > inline void flush(String<TValue, MMap<TConfig> > &);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(356)
template <typename TValue, typename TConfig > inline void flush(String<TValue, MMap<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(532)
template <typename TValue, typename TConfig > inline void flush(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1559)
inline bool flush(FILE*);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(226)
template <typename TSpec > inline void flush(File<TSpec> &);       	// "seqan-1.3.1/seqan/file/file_base.h"(685)

//____________________________________________________________________________
// flushAndFree

template <typename TValue, typename TConfig > inline int flushAndFree(String<TValue, MMap<TConfig> > &);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(370)
template <typename TValue, typename TConfig > inline int flushAndFree(String<TValue, MMap<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(548)
template <typename TValue, typename TConfig > inline void flushAndFree(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1626)

//____________________________________________________________________________
// formatID

template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void * formatID(FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "seqan-1.3.1/seqan/file/file_format.h"(185)

//____________________________________________________________________________
// freePage

template <typename TValue, typename T > inline void freePage(SimpleBuffer<TValue> &pf, T const & me);       	// "seqan-1.3.1/seqan/file/file_page.h"(133)
template <typename TValue, typename TFile, typename TSpec, typename T > inline void freePage(PageFrame<TValue, TFile, TSpec> &pf, T const & me);       	// "seqan-1.3.1/seqan/file/file_page.h"(400)

//____________________________________________________________________________
// front

template <typename TValue, typename TConfig > inline TValue & front(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1929)
template <typename TValue, typename TConfig > inline TValue const & front(String<TValue, External<TConfig> > const &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1936)

//____________________________________________________________________________
// getChunk

template <typename THost> inline typename Value<THost>::Type * getChunk(ChunkCollector_<THost> const & me, int chunk_number);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(132)

//____________________________________________________________________________
// getValue

template <typename TContainer> inline typename GetValue<Iter<TContainer, FileReaderIterator> >::Type getValue(Iter<TContainer, FileReaderIterator> & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(556)
template <typename TContainer> inline typename GetValue<Iter<TContainer, FileReaderIterator> >::Type getValue(Iter<TContainer, FileReaderIterator> const & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(567)

//____________________________________________________________________________
// goBegin

template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Embl, TFile2, TSpec> > & it, bool skip_meta);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(59)
template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Embl, TFile2, TSpec> > & it);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(120)
template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Fasta, TFile2, TSpec> > & it, bool skip_meta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(58)
template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Fasta, TFile2, TSpec> > & it);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(95)
template <typename TContainer> inline void goBegin(Iter<TContainer, FileReaderIterator> & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(735)
template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Genbank, TFile2, TSpec> > & it, bool skip_meta);       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(59)
template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Genbank, TFile2, TSpec> > & it);       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(137)

//____________________________________________________________________________
// goEnd

template <typename TContainer> inline void goEnd(Iter<TContainer, FileReaderIterator> & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(757)

//____________________________________________________________________________
// goNext

template <typename TFile> void goNext(TFile & file, CGViz);       	// "seqan-1.3.1/seqan/file/file_format_cgviz.h"(61)
template <typename TFile, typename TFile2, typename TSpec> inline void goNext(Iter<TFile, FileReader<Embl, TFile2, TSpec> > & it);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(129)
template <typename TFile> inline void goNext(TFile & file, Embl);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(450)
template <typename TFile, typename TFile2, typename TSpec> inline void goNext(Iter<TFile, FileReader<Fasta, TFile2, TSpec> > & it);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(103)
template <typename TFile> void goNext(TFile & file, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(447)
template <typename TFile> void goNext(TFile & file, Raw);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(220)
template <typename TContainer> inline void goNext(Iter<TContainer, FileReaderIterator> & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(669)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void goNext(TFile & file, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "seqan-1.3.1/seqan/file/file_format.h"(268)
template <typename TFile, typename TFile2, typename TSpec> inline void goNext(Iter<TFile, FileReader<Genbank, TFile2, TSpec> > & it);       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(146)
template <typename TFile> inline void goNext(TFile & file, Genbank);       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(276)

//____________________________________________________________________________
// goPrevious

template <typename TContainer> inline void goPrevious(Iter<TContainer, FileReaderIterator> & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(701)

//____________________________________________________________________________
// guessFileFormat

template <typename TFile, typename TData, typename TMeta> inline FileFormat<TFile, TData, TMeta, void> guessFileFormat(TFile & file, TData & data);       	// "seqan-1.3.1/seqan/file/file_format_guess.h"(65)

//____________________________________________________________________________
// id

template <typename TValue, typename TConfig > inline void const * id(String<TValue, External<TConfig> > const &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(2075)
template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline void const * id(String<TValue, FileReader<TFormat, TFile, TSpec> > const & me);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(324)

//____________________________________________________________________________
// iter

template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPosition, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> >, TIteratorSpec >::Type iter(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TPosition pos, Tag<TIteratorSpec> const);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(404)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPosition, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> > const, TIteratorSpec >::Type iter(String<TValue, FileReader<TFormat, TFile, TSpec> > const & me, TPosition pos, Tag<TIteratorSpec> const);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(413)

//____________________________________________________________________________
// length

template <typename TValue, typename TConfig > inline typename Size< String<TValue, External<TConfig> > >::Type length(String<TValue, External<TConfig> > const &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1793)
template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline typename Size< String<TValue, FileReader<TFormat, TFile, TSpec> > >::Type length(String<TValue, FileReader<TFormat, TFile, TSpec> > & me);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(351)
template <__int64 FILE_SIZE, typename TFile > inline unsigned length(File< Chained<FILE_SIZE, TFile> > const &me);       	// "seqan-1.3.1/seqan/file/file_array.h"(296)
template <unsigned FileCount_, typename TFile > inline unsigned length(File< Striped<FileCount_, TFile> > const & );       	// "seqan-1.3.1/seqan/file/file_array.h"(301)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void length(TFile & file, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "seqan-1.3.1/seqan/file/file_format.h"(285)
template <typename THost> inline typename Size<THost>::Type length(ChunkCollector_<THost> const & me);       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(111)
template <typename TValue > inline typename Size<SimpleBuffer<TValue> >::Type length(SimpleBuffer<TValue> const &me);       	// "seqan-1.3.1/seqan/file/file_page.h"(116)
template <typename TValue, typename TFile, unsigned PageSize_ > inline typename Size<PageFrame<TValue, TFile, Fixed<PageSize_> > >::Type length(PageFrame<TValue, TFile, Fixed<PageSize_> > const & );       	// "seqan-1.3.1/seqan/file/file_page.h"(339)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Size< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> >::Type length(PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const &pageCont);       	// "seqan-1.3.1/seqan/file/file_page.h"(922)

//____________________________________________________________________________
// mmapAdvise

template <typename TValue, typename TConfig, typename TScheme, typename TBeginPos, typename TEndPos > inline int mmapAdvise(String<TValue, MMap<TConfig> > & , TScheme const & , TBeginPos const &, TEndPos const &);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(349)
template <typename TValue, typename TConfig, typename TScheme, typename TBeginPos, typename TEndPos > inline int mmapAdvise(String<TValue, MMap<TConfig> > &me, TScheme const & scheme, TBeginPos const & beginPos, TEndPos const & endPos);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(521)
template <typename TValue, typename TConfig, typename TScheme > inline int mmapAdvise(String<TValue, MMap<TConfig> > &me, TScheme scheme);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(672)

//____________________________________________________________________________
// open

template <typename TValue, typename TConfig > inline bool open(String<TValue, MMap<TConfig> > &me, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(709)
template <typename TValue, typename TConfig > inline bool open(String<TValue, MMap<TConfig> > &me, const char *fileName);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(725)
template <typename TValue, typename TConfig > inline bool open(String<TValue, MMap<TConfig> > &me, typename TConfig::TFile file);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(733)
template <typename TValue, typename TConfig > inline bool open(String<TValue, External<TConfig> > &me, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/file/string_external.h"(1663)
template <typename TValue, typename TConfig > inline bool open(String<TValue, External<TConfig> > &me, const char *fileName);       	// "seqan-1.3.1/seqan/file/string_external.h"(1686)
template <typename TValue, typename TConfig > inline bool open(String<TValue, External<TConfig> > &me, typename TConfig::TFile file);       	// "seqan-1.3.1/seqan/file/string_external.h"(1696)
inline bool open(FILE* &me, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(105)
inline bool open(FILE* &me, const char *fileName);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(112)
template <typename TSpec > inline bool open(File<TSpec> &me, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/file/file_base.h"(236)
template <typename TSpec > inline bool open(File<TSpec> &me, const char *fileName);       	// "seqan-1.3.1/seqan/file/file_base.h"(242)
template <__int64 FILE_SIZE, typename TFile > inline bool open(File< Chained<FILE_SIZE, TFile> > &me, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/file/file_array.h"(306)

//____________________________________________________________________________
// openTemp

template <typename TValue, typename TConfig > inline bool openTemp(String<TValue, MMap<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(753)
template <typename TValue, typename TConfig > inline bool openTemp(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1728)
inline bool openTemp(FILE* &me);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(118)
template <typename TSpec > inline bool openTemp(File<TSpec> &me);       	// "seqan-1.3.1/seqan/file/file_base.h"(261)
template <typename TSpec > inline bool openTemp(File<TSpec> &me, int openMode);       	// "seqan-1.3.1/seqan/file/file_base.h"(267)
template <__int64 FILE_SIZE, typename TFile > inline bool openTemp(File< Chained<FILE_SIZE, TFile> > &me, int openMode);       	// "seqan-1.3.1/seqan/file/file_array.h"(315)
template <unsigned FileCount_, typename TFile > inline bool openTemp(File< Striped<FileCount_, TFile> > &me, int openMode);       	// "seqan-1.3.1/seqan/file/file_array.h"(322)

//____________________________________________________________________________
// operator!=

template <typename TContainer> inline bool operator!= (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(815)
template <typename TFileLeft, typename TDataLeft, typename TMetaLeft, typename TFormatLeft, typename TFileRight, typename TDataRight, typename TMetaRight, typename TFormatRight> inline bool operator!= (FileFormat<TFileLeft, TDataLeft, TMetaLeft, TFormatLeft> const & left, FileFormat<TFileRight, TDataRight, TMetaRight, TFormatRight> const & right);       	// "seqan-1.3.1/seqan/file/file_format.h"(367)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TFormat2> inline bool operator!= (FileFormat<TFile, TData, TMeta, TFormat> const & left, Tag<TFormat2> const);       	// "seqan-1.3.1/seqan/file/file_format.h"(376)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TFormat2> inline bool operator!= (Tag<TFormat2> const, FileFormat<TFile, TData, TMeta, TFormat> const & right);       	// "seqan-1.3.1/seqan/file/file_format.h"(385)

//____________________________________________________________________________
// operator+

template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> operator+ (Iter<TContainer, FileReaderIterator> const & left, TIntegral right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(872)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> operator+ (TIntegral left, Iter<TContainer, FileReaderIterator> const & right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(880)

//____________________________________________________________________________
// operator+=

template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> & operator+= (Iter<TContainer, FileReaderIterator> & left, TIntegral right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(893)

//____________________________________________________________________________
// operator-

template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> operator- (Iter<TContainer, FileReaderIterator> const & left, TIntegral right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(911)
template <typename TContainer> inline typename Difference<Iter<TContainer, FileReaderIterator> >::Type operator- (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(922)

//____________________________________________________________________________
// operator-=

template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> & operator-= (Iter<TContainer, FileReaderIterator> & left, TIntegral right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(935)

//____________________________________________________________________________
// operator<

template <typename TContainer> inline bool operator< (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(828)

//____________________________________________________________________________
// operator<<

template <typename TValue > ::std::ostream& operator<<(::std::ostream &out, const PageBucketExtended<TValue> &pb);       	// "seqan-1.3.1/seqan/file/file_page.h"(181)
template <typename TValue, typename TFile, typename TSpec > ::std::ostream& operator<<(::std::ostream &out, const PageFrame<TValue, TFile, TSpec > &pf);       	// "seqan-1.3.1/seqan/file/file_page.h"(358)

//____________________________________________________________________________
// operator<=

template <typename TContainer> inline bool operator<= (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(850)

//____________________________________________________________________________
// operator==

template <typename TContainer> inline bool operator== (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(802)
template <typename TFileLeft, typename TDataLeft, typename TMetaLeft, typename TFormatLeft, typename TFileRight, typename TDataRight, typename TMetaRight, typename TFormatRight> inline bool operator== (FileFormat<TFileLeft, TDataLeft, TMetaLeft, TFormatLeft> const & left, FileFormat<TFileRight, TDataRight, TMetaRight, TFormatRight> const & right);       	// "seqan-1.3.1/seqan/file/file_format.h"(338)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TFormat2> inline bool operator== (FileFormat<TFile, TData, TMeta, TFormat> const & left, Tag<TFormat2> const);       	// "seqan-1.3.1/seqan/file/file_format.h"(347)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TFormat2> inline bool operator== (Tag<TFormat2> const, FileFormat<TFile, TData, TMeta, TFormat> const & right);       	// "seqan-1.3.1/seqan/file/file_format.h"(356)

//____________________________________________________________________________
// operator>

template <typename TContainer> inline bool operator> (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(837)

//____________________________________________________________________________
// operator>=

template <typename TContainer> inline bool operator>= (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(859)

//____________________________________________________________________________
// pageSize

template <typename TValue > inline typename Size<SimpleBuffer<TValue> >::Type pageSize(SimpleBuffer<TValue> &me);       	// "seqan-1.3.1/seqan/file/file_page.h"(99)
template <typename TValue, typename TFile, unsigned PageSize_ > inline typename Size<PageFrame<TValue, TFile, Fixed<PageSize_> > >::Type pageSize(PageFrame<TValue, TFile, Fixed<PageSize_> > & );       	// "seqan-1.3.1/seqan/file/file_page.h"(345)

//____________________________________________________________________________
// pop_back

template <typename TValue, typename TConfig > inline void pop_back(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1922)

//____________________________________________________________________________
// position

template <typename TContainer> inline typename Position<Iter<TContainer, FileReaderIterator> >::Type position(Iter<TContainer, FileReaderIterator> const & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(611)

//____________________________________________________________________________
// push

template <typename TValue, typename TConfig > inline void push(String<TValue, External<TConfig> > &me, TValue const &Val_);       	// "seqan-1.3.1/seqan/file/string_external.h"(1909)

//____________________________________________________________________________
// push_back

template <typename TValue, typename TConfig > inline void push_back(String<TValue, External<TConfig> > &me, TValue const &Val_);       	// "seqan-1.3.1/seqan/file/string_external.h"(1916)

//____________________________________________________________________________
// read

template <typename TFile, typename TData> inline void read(TFile & file, TData & data, Embl);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(174)
template <typename TFile, typename TData, typename TSize> inline void read(TFile & file, TData & data, TSize limit, Embl);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(192)
template <typename TFile, typename TData, typename TSize> void read(TFile & file, TData & data, TSize limit, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(213)
template <typename TFile, typename TData> void read(TFile & file, TData & data, Fasta tag);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(310)
template <typename TFile, typename TData> void read(TFile & file, TData & data, Raw);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(164)
template <typename TFile, typename TData, typename TSize> void read(TFile & file, TData & data, TSize limit, Raw);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(177)
template <typename TFile, typename TData> void read(TFile & file, TData & data);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(281)
template <typename TFile, typename TData, typename TSize> void read(TFile & file, TData & data, TSize limit);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(290)
template <typename TValue, typename TSize > inline bool read(FILE* me, TValue *memPtr, TSize const count);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(159)
template <typename TSpec, typename TValue, typename TSize > inline bool read(File<TSpec> & me, TValue *memPtr, TSize const count);       	// "seqan-1.3.1/seqan/file/file_base.h"(319)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void read(TFile & file, TData & data, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "seqan-1.3.1/seqan/file/file_format.h"(215)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TSize> inline void read(TFile & file, TData & data, TSize limit, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "seqan-1.3.1/seqan/file/file_format.h"(226)
template <typename TFile, typename TData> inline void read(TFile & file, TData & data, Genbank);       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(192)
template <typename TFile, typename TData, typename TSize> inline void read(TFile & file, TData & data, TSize limit, Genbank);       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(210)

//____________________________________________________________________________
// readAt

template <typename TValue, typename TSize, typename TPos > inline bool readAt(FILE* me, TValue *memPtr, TSize const count, TPos const fileOfs);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(181)
template <typename TFile, typename TValue, typename TSize, typename TPos > inline bool readAt(TFile & me, TValue *memPtr, TSize const count, TPos const fileOfs);       	// "seqan-1.3.1/seqan/file/file_base.h"(359)
template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize, typename TOffset > inline bool readAt(File< Chained<FILE_SIZE, TFile> > &me, TValue *memPtr, TSize count, TOffset offset);       	// "seqan-1.3.1/seqan/file/file_array.h"(376)

//____________________________________________________________________________
// readBucket

template <typename TValue, unsigned FILE_COUNT, typename TFile > inline unsigned readBucket( PageBucket<TValue> &b, int pageNo, unsigned pageSize, unsigned dataSize, File< Striped<FILE_COUNT, TFile> > &file);       	// "seqan-1.3.1/seqan/file/file_page_raid0.h"(146)
template <typename TValue, typename TFile > inline unsigned readBucket(PageBucket<TValue> &b, int pageNo, unsigned pageSize, unsigned dataSize, TFile &file);       	// "seqan-1.3.1/seqan/file/file_page.h"(524)

//____________________________________________________________________________
// readFeature

template <typename TData, typename TKey, typename TString> inline typename Position<TString>::Type readFeature(TString & str, typename Position<TString>::Type start_pos, TData & data, TKey key, Embl);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(395)

//____________________________________________________________________________
// readID

template <typename TFile, typename TString> void readID(TFile & file, TString & id, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(328)
template <typename TFile, typename TString> void readID(TFile & , TString & id, Raw);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(192)

//____________________________________________________________________________
// readLastPage

template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec, typename TSize > inline bool readLastPage( int pageNo, PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, TSpec> &pf, File< Striped<FILE_COUNT, TFile> > &file, TSize size);       	// "seqan-1.3.1/seqan/file/file_page_raid0.h"(96)
template <typename TValue, typename TFile, typename TSpec, typename TSize> inline bool readLastPage(int pageNo, PageFrame<TValue, TFile, TSpec> &pf, TFile &file, TSize size);       	// "seqan-1.3.1/seqan/file/file_page.h"(440)

//____________________________________________________________________________
// readLineType

template <typename TFile, typename TData, typename TKey> inline void readLineType(TFile & file, TData & data, TKey key, Embl);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(270)
template <typename TData, typename TValue, typename TSpec, typename TKey> inline void readLineType(String<TValue,TSpec> & meta, TData & data, TKey key, Embl);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(327)

//____________________________________________________________________________
// readMeta

template <typename TFile, typename TMeta> inline void readMeta(TFile & file, TMeta & meta, Embl);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(215)
template <typename TFile, typename TMeta> void readMeta(TFile & file, TMeta & meta, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(433)
template <typename TFile, typename TMeta> void readMeta(TFile & , TMeta & meta, Raw);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(206)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void readMeta(TFile & file, TMeta & meta, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "seqan-1.3.1/seqan/file/file_format.h"(251)
template <typename TFile, typename TMeta> inline void readMeta(TFile & file, TMeta & meta, Genbank);       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(234)

//____________________________________________________________________________
// readPage

template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec > inline bool readPage( int pageNo, PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, TSpec> &pf, File< Striped<FILE_COUNT, TFile> > &file);       	// "seqan-1.3.1/seqan/file/file_page_raid0.h"(52)
template <typename TValue, typename TFile, typename TSpec > inline bool readPage(int pageNo, PageFrame<TValue, TFile, TSpec> &pf, TFile &file);       	// "seqan-1.3.1/seqan/file/file_page.h"(413)
template <typename TValue, typename TFile, typename TSpec > inline bool readPage(PageFrame<TValue, TFile, Dynamic<TSpec> > &pf, TFile &file);       	// "seqan-1.3.1/seqan/file/file_page.h"(506)

//____________________________________________________________________________
// readShortID

template <typename TFile, typename TString> void readShortID(TFile & file, TString & id, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(375)

//____________________________________________________________________________
// release

template <typename AsyncRequest > inline void release(FILE*, AsyncRequest &);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(233)
template <typename TSpec, typename AsyncRequest > inline void release(File<TSpec> &, AsyncRequest &);       	// "seqan-1.3.1/seqan/file/file_base.h"(717)

//____________________________________________________________________________
// reopen

template <typename File > inline void reopen(File &, int);       	// "seqan-1.3.1/seqan/file/file_base.h"(273)

//____________________________________________________________________________
// replace

template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, ChunkCollector_<TSourceHost> const & source, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(485)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, ChunkCollector_<TSourceHost> const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(497)
template <typename TTargetValue, typename TSourceHost, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, ChunkCollector_<TSourceHost> const & source, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(510)
template <typename TTargetValue, typename TSourceHost, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, ChunkCollector_<TSourceHost> const & source, size_t limit, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/file/chunk_collector.h"(522)

//____________________________________________________________________________
// reserve

template <typename TValue, typename TConfig, typename TSize, typename TExpand > inline typename Size< String<TValue, External<TConfig> > >::Type reserve( String<TValue, External<TConfig> > &me, TSize new_capacity, Tag<TExpand> const expand);       	// "seqan-1.3.1/seqan/file/string_external.h"(1839)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS, typename TExpand > inline void reserve( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> &pageCont, unsigned Count_, Tag<TExpand> const expand);       	// "seqan-1.3.1/seqan/file/file_page.h"(899)

//____________________________________________________________________________
// resize

template <typename TValue, typename TConfig, typename TNewSize, typename TExpand > inline typename Size< String<TValue, External<TConfig> > >::Type resize( String<TValue, External<TConfig> > &me, TNewSize new_length, Tag<TExpand> const expand);       	// "seqan-1.3.1/seqan/file/string_external.h"(1812)
template <typename TSize > inline void resize(FILE* me, TSize new_length);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(218)
template <typename TSpec, typename TSize > inline void resize(File<TSpec> &me, TSize new_length);       	// "seqan-1.3.1/seqan/file/file_base.h"(491)
template <__int64 FILE_SIZE, typename TFile, typename TSize > inline void resize(File< Chained<FILE_SIZE, TFile> > &me, TSize new_length);       	// "seqan-1.3.1/seqan/file/file_array.h"(347)
template <typename TValue, typename TSize > inline void resize(SimpleBuffer<TValue> &me, TSize size);       	// "seqan-1.3.1/seqan/file/file_page.h"(121)
template <typename TValue, typename TFile, typename TSpec, typename TSize > inline void resize(PageFrame<TValue, TFile, Dynamic<TSpec> > &me, TSize size);       	// "seqan-1.3.1/seqan/file/file_page.h"(327)
template <typename TValue, typename TFile, unsigned PageSize_, typename TSize > inline void resize(PageFrame<TValue, TFile, Fixed<PageSize_> > & , TSize );       	// "seqan-1.3.1/seqan/file/file_page.h"(350)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline void resize( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> &pageCont, unsigned Count_);       	// "seqan-1.3.1/seqan/file/file_page.h"(907)

//____________________________________________________________________________
// rewind

template <typename File > inline void rewind(File &me);       	// "seqan-1.3.1/seqan/file/file_base.h"(455)

//____________________________________________________________________________
// save

template <typename TValue, typename TConfig > inline bool save(String<TValue, MMap<TConfig> > const & , const char * , int );       	// "seqan-1.3.1/seqan/file/string_mmap.h"(778)
template <typename TValue, typename TConfig > inline bool save(String<TValue, MMap<TConfig> > const & , const char * );       	// "seqan-1.3.1/seqan/file/string_mmap.h"(786)
template <typename TValue, typename TConfig > inline bool save(String<TValue, MMap<TConfig> > const & , typename TConfig::TFile );       	// "seqan-1.3.1/seqan/file/string_mmap.h"(794)
template <typename TValue, typename TConfig > inline bool save(String<TValue, External<TConfig> > const & , const char * , int );       	// "seqan-1.3.1/seqan/file/string_external.h"(1739)
template <typename TValue, typename TConfig > inline bool save(String<TValue, External<TConfig> > const & , const char * );       	// "seqan-1.3.1/seqan/file/string_external.h"(1747)
template <typename TValue, typename TConfig > inline bool save(String<TValue, External<TConfig> > const & , typename TConfig::TFile );       	// "seqan-1.3.1/seqan/file/string_external.h"(1755)

//____________________________________________________________________________
// sectorSize

inline unsigned sectorSize(FILE* const &);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(132)
template <typename TSpec > inline unsigned sectorSize(File<TSpec> const & );       	// "seqan-1.3.1/seqan/file/file_base.h"(295)

//____________________________________________________________________________
// seek

template <typename TPos > inline Size<FILE*>::Type seek(FILE* me, TPos const fileOfs, int origin);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(139)
template <typename TPos > inline Size<FILE*>::Type seek(FILE* me, TPos const fileOfs);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(146)
template <typename TSpec, typename TPos > inline typename Position< File<TSpec> >::Type seek(File<TSpec> &me, TPos const fileOfs, int origin);       	// "seqan-1.3.1/seqan/file/file_base.h"(409)
template <typename TSpec, typename TPos > inline typename Position< File<TSpec> >::Type seek(File<TSpec> &me, TPos const fileOfs);       	// "seqan-1.3.1/seqan/file/file_base.h"(422)

//____________________________________________________________________________
// setEof

template <typename TSpec > inline bool setEof(File<TSpec> & );       	// "seqan-1.3.1/seqan/file/file_base.h"(510)

//____________________________________________________________________________
// setPageSize

template <typename TValue, typename TSize > inline void setPageSize(SimpleBuffer<TValue> &me, TSize size);       	// "seqan-1.3.1/seqan/file/file_page.h"(104)

//____________________________________________________________________________
// setPosition

template <typename TContainer, typename TPos> inline void setPosition(Iter<TContainer, FileReaderIterator> & it, TPos pos);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(636)

//____________________________________________________________________________
// size

inline Size<FILE*>::Type size(FILE* me);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(206)
template <typename TSpec > inline typename Size<File<TSpec> >::Type size(File<TSpec> &me);       	// "seqan-1.3.1/seqan/file/file_base.h"(472)
template <__int64 FILE_SIZE, typename TFile > __int64 size(File< Chained<FILE_SIZE, TFile> > &me);       	// "seqan-1.3.1/seqan/file/file_array.h"(337)
template <unsigned FileCount_, typename TFile > __int64 size(File< Striped<FileCount_, TFile> > &me);       	// "seqan-1.3.1/seqan/file/file_array.h"(342)
template <typename TValue > inline typename Size<SimpleBuffer<TValue> >::Type size(SimpleBuffer<TValue> const &me);       	// "seqan-1.3.1/seqan/file/file_page.h"(110)
template <typename TValue, typename TFile, unsigned PageSize_ > inline typename Size<PageFrame<TValue, TFile, Fixed<PageSize_> > >::Type size(PageFrame<TValue, TFile, Fixed<PageSize_> > & );       	// "seqan-1.3.1/seqan/file/file_page.h"(333)

//____________________________________________________________________________
// tell

inline Size<FILE*>::Type tell(FILE* me);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(152)
template <typename TSpec > inline typename Position< File<TSpec> >::Type tell(File<TSpec> &me);       	// "seqan-1.3.1/seqan/file/file_base.h"(438)

//____________________________________________________________________________
// value

template <typename TValue, typename TConfig, typename TPos > inline typename Reference<String<TValue, External<TConfig> > >::Type value(String<TValue, External<TConfig> > &me, TPos pos);       	// "seqan-1.3.1/seqan/file/string_external.h"(1881)
template <typename TValue, typename TConfig, typename TPos > inline typename Reference<String<TValue, External<TConfig> > const>::Type value(String<TValue, External<TConfig> > const &me, TPos pos);       	// "seqan-1.3.1/seqan/file/string_external.h"(1888)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPos> inline TValue value(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TPos pos);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(335)
template <typename TContainer> inline typename Reference<Iter<TContainer, FileReaderIterator> >::Type value(Iter<TContainer, FileReaderIterator> & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(581)
template <typename TContainer> inline typename Reference<Iter<TContainer, FileReaderIterator> >::Type value(Iter<TContainer, FileReaderIterator> const & it);       	// "seqan-1.3.1/seqan/file/file_filereader.h"(587)

//____________________________________________________________________________
// waitFor

inline bool waitFor(AsyncDummyRequest &);       	// "seqan-1.3.1/seqan/file/file_base.h"(704)
template <typename TTime > inline bool waitFor(AsyncDummyRequest &, TTime);       	// "seqan-1.3.1/seqan/file/file_base.h"(710)
template <typename TValue, typename TFile, typename TSpec > inline bool waitFor(PageFrame<TValue, TFile, TSpec> &pf);       	// "seqan-1.3.1/seqan/file/file_page.h"(468)
template <typename TValue, typename TFile, typename TSpec, typename TTime > inline bool waitFor(PageFrame<TValue, TFile, TSpec> &pf, TTime timeOut);       	// "seqan-1.3.1/seqan/file/file_page.h"(480)

//____________________________________________________________________________
// waitForAll

template <typename TValue, typename TConfig > inline void waitForAll(String<TValue, MMap<TConfig> > &);       	// "seqan-1.3.1/seqan/file/string_mmap.h"(335)
template <typename TValue, typename TConfig > inline void waitForAll(String<TValue, External<TConfig> > &me);       	// "seqan-1.3.1/seqan/file/string_external.h"(1538)

//____________________________________________________________________________
// write

template <typename TFile, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec>& align, CGViz);       	// "seqan-1.3.1/seqan/file/file_format_cgviz.h"(204)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec> & align, TStringContainer& ids, CGViz);       	// "seqan-1.3.1/seqan/file/file_format_cgviz.h"(212)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec>* align, TStringContainer & ids, CGViz);       	// "seqan-1.3.1/seqan/file/file_format_cgviz.h"(220)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec, typename TMeta> void write(TFile & file, Align<TSource, TSpec> & align, TStringContainer& ids, TMeta &, CGViz);       	// "seqan-1.3.1/seqan/file/file_format_cgviz.h"(228)
template <typename TFile, typename TData> inline void write(TFile & file, TData & data, Embl);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(488)
template <typename TFile, typename TData, typename TMeta> inline void write(TFile & file, TData & data, TMeta & meta, Embl);       	// "seqan-1.3.1/seqan/file/file_format_embl.h"(554)
template <typename TFile, typename TString, typename TData, typename TMeta> void write(TFile & file, TData & data, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(535)
template <typename TFile, typename TString, typename TData> void write(TFile & file, TData & data, TString & id, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(548)
template <typename TFile, typename TString, typename TDataValue> void write(TFile & file, TDataValue * data, TString & id, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(561)
template <typename TFile, typename TString, typename TData, typename TMeta> void write(TFile & file, TData & data, TString & id, TMeta &, Fasta);       	// "seqan-1.3.1/seqan/file/file_format_fasta.h"(576)
template <typename TFile, typename TData> void write(TFile & file, TData const & data, Raw);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(240)
template <typename TFile, typename TData, typename TString> void write(TFile & file, TData const & data, TString const &, Raw);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(253)
template <typename TFile, typename TString, typename TData, typename TMeta> void write(TFile & file, TData const & data, TString const &, TMeta const &, Raw);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(267)
template <typename TFile, typename TData> void write(TFile & file, TData & data);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(301)
template <typename TFile, typename TData> void write(TFile & file, TData const & data);       	// "seqan-1.3.1/seqan/file/file_format_raw.h"(309)
template <typename TValue, typename TSize > inline bool write(FILE* me, TValue const *memPtr, TSize const count);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(170)
template <typename TSpec, typename TValue, typename TSize > inline bool write(File<TSpec> & me, TValue const *memPtr, TSize const count);       	// "seqan-1.3.1/seqan/file/file_base.h"(339)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void write(TFile & file, TData & data, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "seqan-1.3.1/seqan/file/file_format.h"(312)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void write(TFile & file, TData & data, TMeta & meta, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "seqan-1.3.1/seqan/file/file_format.h"(322)
template <typename TFile, typename TData> inline void write(TFile & file, TData & data, Genbank);       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(314)
template <typename TFile, typename TData, typename TMeta> inline void write(TFile & file, TData & data, TMeta & meta, Genbank);       	// "seqan-1.3.1/seqan/file/file_format_genbank.h"(370)

//____________________________________________________________________________
// writeAt

template <typename TValue, typename TSize, typename TPos > inline bool writeAt(FILE* me, TValue const *memPtr, TSize const count, TPos const fileOfs);       	// "seqan-1.3.1/seqan/file/file_cstyle.h"(194)
template <typename TFile, typename TValue, typename TSize, typename TPos > inline bool writeAt(TFile & me, TValue const *memPtr, TSize const count, TPos const fileOfs);       	// "seqan-1.3.1/seqan/file/file_base.h"(381)
template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize, typename TOffset > inline bool writeAt(File< Chained<FILE_SIZE, TFile> > &me, TValue const *memPtr, TSize count, TOffset offset);       	// "seqan-1.3.1/seqan/file/file_array.h"(390)

//____________________________________________________________________________
// writeBucket

template <typename TValue, unsigned FILE_COUNT, typename TFile > inline bool writeBucket( PageBucket<TValue> &b, int pageNo, unsigned pageSize, File< Striped<FILE_COUNT, TFile> > &file);       	// "seqan-1.3.1/seqan/file/file_page_raid0.h"(170)
template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec > inline bool writeBucket( PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, Dynamic<TSpec> > &pf, unsigned &pageOfs, File< Striped<FILE_COUNT, TFile> > &file);       	// "seqan-1.3.1/seqan/file/file_page_raid0.h"(191)
template <typename TValue, typename TFile > inline bool writeBucket(PageBucket<TValue> &b, int pageNo, unsigned pageSize, TFile &file);       	// "seqan-1.3.1/seqan/file/file_page.h"(543)
template <typename TValue, typename TFile, typename TSpec > inline bool writeBucket(PageFrame<TValue, TFile, Dynamic<TSpec> > &pf, unsigned &pageOfs, TFile &file);       	// "seqan-1.3.1/seqan/file/file_page.h"(560)

//____________________________________________________________________________
// writeLastPage

template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec, typename TSize > inline bool writeLastPage( PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, TSpec> &pf, int pageNo, File< Striped<FILE_COUNT, TFile> > &file, TSize size);       	// "seqan-1.3.1/seqan/file/file_page_raid0.h"(118)
template <typename TValue, typename TFile, typename TSpec, typename TSize > inline bool writeLastPage(PageFrame<TValue, TFile, TSpec> &pf, int pageNo, TFile &file, TSize size);       	// "seqan-1.3.1/seqan/file/file_page.h"(454)

//____________________________________________________________________________
// writePage

template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec > inline bool writePage( PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, TSpec> &pf, int pageNo, File< Striped<FILE_COUNT, TFile> > &file);       	// "seqan-1.3.1/seqan/file/file_page_raid0.h"(74)
template <typename TValue, typename TFile, typename TSpec > inline bool writePage(PageFrame<TValue, TFile, TSpec> &pf, int pageNo, TFile &file);       	// "seqan-1.3.1/seqan/file/file_page.h"(427)
template <typename TValue, typename TFile, typename TSpec > inline bool writePage(PageFrame<TValue, TFile, Dynamic<TSpec> > &pf, TFile &file);       	// "seqan-1.3.1/seqan/file/file_page.h"(515)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _fastaAlignScanLine

template <typename TFile, typename TSize> void _fastaAlignScanLine(TFile & file, TSize & count);       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(74)

//____________________________________________________________________________
// _writeImpl

template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void _writeImpl(TFile & file, Align<TSource, TSpec> const & align, TStringContainer const & ids, FastaAlign const &);       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(269)

//____________________________________________________________________________
// goNext

template <typename TFile> void goNext(TFile & file, FastaAlign);       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(255)

//____________________________________________________________________________
// read

template <typename TFile, typename TSource, typename TSpec> void read(TFile & file, Align<TSource, TSpec> & align, FastaAlign const &);       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(94)

//____________________________________________________________________________
// readIDs

template <typename TFile, typename TStringContainer> void readIDs(TFile& file, TStringContainer& ids, FastaAlign);       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(200)

//____________________________________________________________________________
// readMeta

template <typename TFile, typename TMeta> void readMeta(TFile & , TMeta & meta, FastaAlign);       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(245)

//____________________________________________________________________________
// write

template <typename TFile, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec> const & align, FastaAlign const & );       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(307)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec> const & align, TStringContainer const & ids, FastaAlign const & );       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(315)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec> const * align, TStringContainer const & ids, FastaAlign const & );       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(324)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec, typename TMeta> void write(TFile & file, Align<TSource, TSpec> const & align, TStringContainer const & ids, TMeta &, FastaAlign const & );       	// "seqan-1.3.1/seqan/file/file_format_fasta_align.h"(332)

} //namespace seqan

#endif

