// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __util_h__
#define __util_h__

#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <float.h>
#include <math.h>

#include <iostream>
#include <sstream>
#include <iomanip>
using namespace std;

#include "fuzzy.h"
#include "vector.h"

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

#define XImageData(x) x->data

#ifdef _WIN32
#include <xxlib.h>
#include <win32lib.h>
#define XQueryPointer XXQueryPointer
#define XWarpPointer XXWarpPointer
#endif

#ifdef _MACOSX
#undef XImageData
#include <xxlib.h>
#include <macosxlib.h>
#define XGetImage XXGetImage
#define XQueryPointer XXQueryPointer
#define XWarpPointer XXWarpPointer
#endif

#define STRCMP(which,str,cnt) (!strncmp(toConstLower(which), str, cnt) && strlen(which)==cnt)

static const char psFonts[12][32] = {
  {"Helvetica"},
  {"Helvetica-Oblique"},
  {"Helvetica-Bold"},
  {"Helvetica-BoldOblique"},

  {"Times-Roman"},
  {"Times-Italic"},
  {"Times-Bold"},
  {"Times-BoldItalic"},

  {"Courier"},
  {"Courier-Oblique"},
  {"Courier-Bold"},
  {"Courier-BoldOblique"}
};

#ifndef _WIN32
static const double M_TWOPI = 2*M_PI;
#endif
static const double M_THREEPI = 3*M_PI;
static const double M_FOURPI = 4*M_PI;

extern int maperr;

extern int lsb();

extern void swap2(char* src, char* dest);
extern void swap4(char* src, char* dest);
extern void swap8(char* src, char* dest);

// defined in ds9.C
extern void internalError(const char*);

extern char* dupstr(const char*);
extern char* trim(const char*);
extern char* toLower(const char*);
extern char* toUpper(const char*);
extern char* toConstLower(const char*);
extern char* toConstUpper(const char*);

extern double zeroTWOPI(double);
extern double zero360(double);
extern double m180To180(double);
extern double degToRad(double);
extern double radToDeg(double);

extern double dmsToDegree(int, int, int, double);
extern double parseSEXStr(const char*);
extern double parseHMSStr(const char*);
extern double parseDMSStr(const char*);

extern double RGB2Gray(double, double, double);
extern unsigned char RGB2Gray(unsigned char, unsigned char, unsigned char);
extern void RGB2CMYK(unsigned char, unsigned char, unsigned char,
		     unsigned char*, unsigned char*, unsigned char*, 
		     unsigned char*);
extern void RGB2CMYK(unsigned short, unsigned short, unsigned short,
		     unsigned short*, unsigned short*, unsigned short*, 
		     unsigned short*);
extern ostream& psColorGray(XColor*, ostream&);
extern ostream& psColorRGB(XColor*, ostream&);
extern ostream& psColorCMYK(XColor*, ostream&);

extern char* psQuote(const char*);

extern const char* psFontName(const char*);
extern int psFontSize(const char*);
extern const char* psFontName(const char*, const char*, const char*);

extern int fCompare(const void*, const void*);
extern int dCompare(const void*, const void*);

extern Vector mapLen(const Vector& v, const Matrix& mx);

extern "C" {
extern void conputs(FILE *fd, char *format, ...);
}

#endif
