/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Vector;
import org.sablecc.sablecc.IntSet;
import org.sablecc.sablecc.Symbol;

final class SymbolSet
implements Cloneable {
    private final IntSet terminals;
    private final IntSet nonterminals;
    private boolean empty;
    private boolean modified = true;
    private Symbol[] symbols;

    private void computeArray() {
        int n;
        Vector<Symbol> vector = new Vector<Symbol>(0);
        int[] nArray = this.terminals.elements();
        for (n = 0; n < nArray.length; ++n) {
            vector.addElement(Symbol.symbol(nArray[n], true));
        }
        nArray = this.nonterminals.elements();
        for (n = 0; n < nArray.length; ++n) {
            vector.addElement(Symbol.symbol(nArray[n], false));
        }
        this.symbols = new Symbol[vector.size()];
        vector.copyInto(this.symbols);
        this.modified = false;
    }

    SymbolSet() {
        this.terminals = new IntSet();
        this.nonterminals = new IntSet();
    }

    private SymbolSet(SymbolSet symbolSet) {
        this.terminals = (IntSet)symbolSet.terminals.clone();
        this.nonterminals = (IntSet)symbolSet.nonterminals.clone();
        this.empty = symbolSet.empty;
    }

    void setTerminal(int n) {
        this.terminals.set(n);
        this.modified = true;
    }

    void clearTerminal(int n) {
        this.terminals.clear(n);
        this.modified = true;
    }

    boolean getTerminal(int n) {
        return this.terminals.get(n);
    }

    void setNonterminal(int n) {
        this.nonterminals.set(n);
        this.modified = true;
    }

    void clearNonterminal(int n) {
        this.nonterminals.clear(n);
        this.modified = true;
    }

    boolean getNonterminal(int n) {
        return this.nonterminals.get(n);
    }

    void setEmpty() {
        this.empty = true;
        this.modified = true;
    }

    void clearEmpty() {
        this.empty = false;
        this.modified = true;
    }

    boolean getEmpty() {
        return this.empty;
    }

    void and(SymbolSet symbolSet) {
        this.terminals.and(symbolSet.terminals);
        this.nonterminals.and(symbolSet.nonterminals);
        this.empty &= symbolSet.empty;
        this.modified = true;
    }

    void or(SymbolSet symbolSet) {
        this.terminals.or(symbolSet.terminals);
        this.nonterminals.or(symbolSet.nonterminals);
        this.empty |= symbolSet.empty;
        this.modified = true;
    }

    void xor(SymbolSet symbolSet) {
        this.terminals.xor(symbolSet.terminals);
        this.nonterminals.xor(symbolSet.nonterminals);
        this.empty ^= symbolSet.empty;
        this.modified = true;
    }

    public int hashCode() {
        return this.terminals.hashCode() + this.nonterminals.hashCode() + new Boolean(this.empty).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SymbolSet symbolSet = (SymbolSet)object;
        return this.terminals.equals(symbolSet.terminals) && this.nonterminals.equals(symbolSet.nonterminals) && this.empty == symbolSet.empty;
    }

    Symbol[] getSymbols() {
        if (this.modified) {
            this.computeArray();
        }
        return this.symbols;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Symbol[] symbolArray = this.getSymbols();
        boolean bl = false;
        for (int i = 0; i < symbolArray.length; ++i) {
            if (bl) {
                stringBuffer.append(",");
            } else {
                bl = true;
            }
            stringBuffer.append(symbolArray[i]);
        }
        if (this.empty) {
            if (bl) {
                stringBuffer.append(",");
            } else {
                bl = true;
            }
            stringBuffer.append("*empty*");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new SymbolSet(this);
    }
}

