%  file sn/man/dst.Rd  
%  This file is a component of the package 'sn' for R
%  copyright (C) 2002-2013 Adelchi Azzalini
%---------------------
\name{dst}
\alias{dst}
\alias{pst}
\alias{qst}
\alias{rst}

\title{Skew-\eqn{t} Distribution}

\description{Density function, distribution function, quantiles and 
  random number  generation for the skew-\eqn{t} (ST) distribution}

\usage{
dst(x, xi=0, omega=1, alpha=0, nu=Inf, dp=NULL, log=FALSE) 
pst(x, xi=0, omega=1, alpha=0, nu=Inf, dp=NULL, ...)
qst(p, xi=0, omega=1, alpha=0, nu=Inf, tol=1e-08, dp=NULL, ...)
rst(n=1, xi=0, omega=1, alpha=0, nu=Inf, dp=NULL)
}


\arguments{
\item{x}{vector of quantiles. Missing values (\code{NA}s) are allowed.}
\item{p}{vector of probabililities.}
\item{xi}{vector of location parameters.}
\item{omega}{vector of scale parameters; must be positive.}
\item{alpha}{vector of slant parameters. With \code{pst} and \code{qst}, 
it must be of length 1.}
\item{nu}{degrees of freedom (scalar); default is \code{nu=Inf} 
which corresponds to the skew-normal distribution.
}

\item{dp}{a vector of length 4, whose elements represent location, scale
(positive), slant and degrees of freedom, respectively.  If \code{dp} is
specified, the individual parameters cannot be set.  }

\item{n}{sample size}

\item{log}{logical; if TRUE, densities  are given as log-densities}

\item{tol}{
  a scalar value which regulates the accuracy of the result of
  \code{qsn}.
}

\item{...}{additional parameters passed to \code{integrate}}

}

\value{Density (\code{dst}), probability (\code{pst}), quantiles (\code{qst}) 
and random sample (\code{rst}) from the skew-\eqn{t} distribution with given 
\code{xi}, \code{omega}, \code{alpha} and \code{nu} parameters.}

\section{Details}{
Typical usages are
\preformatted{%
dst(x, xi=0, omega=1, alpha=0, nu=Inf, log=FALSE)
dst(x, dp=, log=FALSE)
pst(x, xi=0, omega=1, alpha=0, nu=Inf, ...)
pst(x, dp=, log=FALSE)
qst(p, xi=0, omega=1, alpha=0, nu=Inf, tol=1e-8, ...)
qst(x, dp=, log=FALSE)
rst(n=1, xi=0, omega=1, alpha=0, nu=Inf)
rst(x, dp=, log=FALSE)
}
}
\section{Background}{
The family of skew-t distributions is an extension of the Student's \eqn{t}
family, via the introduction of a \code{alpha} parameter which regulates
skewness; when \code{alpha=0}, the skew-\eqn{t} distribution reduces to the
usual Student's \eqn{t} distribution. When \code{nu=Inf}, it reduces to the 
skew-normal distribution. A multivariate version of the distribution exists.
See Chapter 4 of the reference below for additional information.
}


\references{
% Azzalini, A. and Capitanio, A. (2003).
% Distributions generated by perturbation of symmetry 
% with emphasis on a multivariate skew-\emph{t} distribution.
% \emph{J.Roy. Statist. Soc. B} \bold{65}, 367--389.
%
Azzalini, A. and Capitanio, A. (2014). \emph{The Skew-normal and Related 
Families}. Cambridge University Press, IMS Monographs series.
}
  

\seealso{\code{\link{dmst}}, \code{\link{dsn}}}

\examples{
pdf <- dst(seq(-4,4,by=0.1), alpha=3, nu=5)
rnd <- rst(100, 5, 2, -5, 8)
q <- qst(c(0.25,0.5,0.75), alpha=3, nu=5)
pst(q, alpha=3, nu=5)  # must give back c(0.25,0.5,0.75)

}
\keyword{distribution}

