% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_descent}
\alias{ps_descent}
\title{Query the ancestry of a process}
\usage{
ps_descent(p = ps_handle())
}
\arguments{
\item{p}{Process handle.}
}
\value{
A list of process handles, starting with \code{p}, each one
is the parent process of the previous one.
}
\description{
Query the parent processes recursively, up to the first process.
(On some platforms, like Windows, the process tree is not a tree
and may contain loops, in which case \code{ps_descent()} only goes up
until the first repetition.)
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_descent()
\dontshow{\}) # examplesIf}
}
\seealso{
Other process handle functions: 
\code{\link{ps_children}()},
\code{\link{ps_cmdline}()},
\code{\link{ps_connections}()},
\code{\link{ps_cpu_times}()},
\code{\link{ps_create_time}()},
\code{\link{ps_cwd}()},
\code{\link{ps_environ}()},
\code{\link{ps_exe}()},
\code{\link{ps_handle}()},
\code{\link{ps_interrupt}()},
\code{\link{ps_is_running}()},
\code{\link{ps_kill}()},
\code{\link{ps_memory_info}()},
\code{\link{ps_name}()},
\code{\link{ps_num_fds}()},
\code{\link{ps_num_threads}()},
\code{\link{ps_open_files}()},
\code{\link{ps_pid}()},
\code{\link{ps_ppid}()},
\code{\link{ps_resume}()},
\code{\link{ps_send_signal}()},
\code{\link{ps_shared_libs}()},
\code{\link{ps_status}()},
\code{\link{ps_suspend}()},
\code{\link{ps_terminal}()},
\code{\link{ps_terminate}()},
\code{\link{ps_uids}()},
\code{\link{ps_username}()}
}
\concept{process handle functions}
