% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serializer.R
\name{register_serializer}
\alias{register_serializer}
\alias{registered_serializers}
\title{Register a Serializer}
\usage{
register_serializer(name, serializer, verbose = TRUE)

registered_serializers()
}
\arguments{
\item{name}{The name of the serializer (character string)}

\item{serializer}{The serializer function to be added.
This function should accept arguments that can be supplied when \code{\link[=plumb]{plumb()}}ing a file.
This function should return a function that accepts four arguments: \code{value}, \code{req}, \code{res}, and \code{errorHandler}.
See \code{print(serializer_json)} for an example.}

\item{verbose}{Logical value which determines if a message should be printed when overwriting serializers}
}
\description{
A serializer is responsible for translating a generated R value into output
that a remote user can understand. For instance, the \code{serializer_json}
serializes R objects into JSON before returning them to the user. The list of
available serializers in plumber is global.
}
\details{
There are three main building-block serializers:
\itemize{
\item \code{serializer_headers}: the base building-block serializer that is required to have \code{\link[=as_attachment]{as_attachment()}} work
\item \code{serializer_content_type()}: for setting the content type. (Calls \code{serializer_headers()})
\item \code{serializer_device()}: add endpoint hooks to turn a graphics device on and off in addition to setting the content type. (Uses \code{serializer_content_type()})
}
}
\section{Functions}{
\itemize{
\item \code{register_serializer()}: Register a serializer with a name

\item \code{registered_serializers()}: Return a list of all registered serializers

}}
\examples{
# `serializer_json()` calls `serializer_content_type()` and supplies a serialization function
print(serializer_json)
# serializer_content_type() calls `serializer_headers()` and supplies a serialization function
print(serializer_content_type)
}
