% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_kl.R
\name{r2_kullback}
\alias{r2_kullback}
\title{Kullback-Leibler R2}
\usage{
r2_kullback(model, adjust = TRUE)
}
\arguments{
\item{model}{A generalized linear model.}

\item{adjust}{Logical, if \code{TRUE} (the default), the adjusted R2 value is
returned.}
}
\value{
A named vector with the R2 value.
}
\description{
Calculates the Kullback-Leibler-divergence-based
R2 for generalized linear models.
}
\examples{
model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
r2_kullback(model)
}
\references{
Cameron, A. C. and Windmeijer, A. G. (1997) An R-squared measure of goodness
of fit for some common nonlinear regression models. Journal of Econometrics,
77: 329-342.
}
