% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{vaccinations}
\alias{vaccinations}
\title{Influenza vaccination survey responses}
\format{
A data frame with 117 rows and 5 variables:
\describe{
\item{\code{freq}}{number of respondents represented in each row}
\item{\code{subject}}{identifier linking respondents across surveys}
\item{\code{survey}}{survey designation from the ALP website}
\item{\code{start_date}}{start date of survey}
\item{\code{end_date}}{end date of survey}
\item{\code{response}}{discretized probability of vaccinating for influenza}
}
}
\source{
\url{https://alpdata.rand.org/}
}
\usage{
vaccinations
}
\description{
This data set is aggregated from three RAND American Life Panel (ALP) surveys
that asked respondents their probability of vaccinating for influenza. Their
responses were discretized to "Never" (0\%), "Always" (100\%), or "Sometimes"
(any other value). After merging, missing responses were coded as "Missing"
and respondents were grouped and counted by all three coded responses. The
pre-processed data were kindly contributed by Raffaele Vardavas, and the
complete surveys are freely available at the ALP website.
}
\keyword{datasets}
