% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-htest-tidiers.R
\name{tidy.pairwise.htest}
\alias{tidy.pairwise.htest}
\title{Tidy a(n) pairwise.htest object}
\usage{
\method{tidy}{pairwise.htest}(x, ...)
}
\arguments{
\item{x}{A \code{pairwise.htest} object such as those returned from
\code{\link[stats:pairwise.t.test]{stats::pairwise.t.test()}} or \code{\link[stats:pairwise.wilcox.test]{stats::pairwise.wilcox.test()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
Note that in one-sided tests, the alternative hypothesis of each
test can be stated as "group1 is greater/less than group2".

Note also that the columns of group1 and group2 will always be a factor,
even if the original input is (e.g.) numeric.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

attach(airquality)
Month <- factor(Month, labels = month.abb[5:9])
ptt <- pairwise.t.test(Ozone, Month)
tidy(ptt)

library(modeldata)
data(hpc_data)
attach(hpc_data)
ptt2 <- pairwise.t.test(compounds, class)
tidy(ptt2)

tidy(pairwise.t.test(compounds, class, alternative = "greater"))
tidy(pairwise.t.test(compounds, class, alternative = "less"))

tidy(pairwise.wilcox.test(compounds, class))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[stats:pairwise.t.test]{stats::pairwise.t.test()}}, \code{\link[stats:pairwise.wilcox.test]{stats::pairwise.wilcox.test()}},
\code{\link[=tidy]{tidy()}}

Other htest tidiers: 
\code{\link{augment.htest}()},
\code{\link{tidy.htest}()},
\code{\link{tidy.power.htest}()}
}
\concept{htest tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{group1}{First group being compared.}
  \item{group2}{Second group being compared.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}

}
